/* ARROWS - a game.
 * Author Jeremy Day (nor@noreason.ca)
 * Copyright 1993, 2004 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * This is a simple little game involving arrows.  I find it fun to play.  
 *
 * Ported to gtk/linux on 11 January, 2004.  Most of this code is from the 
 * original arrows.c, written well before I'd learned any decent coding style.
 *
 */

#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include "arrows.h"
#include "xpm.h"

#define XOR_PUT 1

// just a few integers...
int move, amove, levno, dots, ylay, dlay, score, dotx, doty, mod3;
int antix, antiy, d_dotx, d_doty, d_antix, d_antiy, pcol, apcol;
int spin, nj, nnj, shotx, shoty, d_shotx, d_shoty, shot_frame;
int shot=0, ss=0, cal;
int moves[200][3];
int jpoints[JMAX][3];

float DMOD=0;
float DSPEED=0.013;
int DTIME=DT;
int JNUM=JMAX;


// local functions
void init_things(void);
int  load(int levno);
void movedot(void);
void moveanti(void);
void display_field(void);
void moveshot(void);

// the level. pretty simple.
struct st_lstruct {
	int arrows[33][21];
	int s_dotx, s_doty, objx, objy, levdelay;
} initlevel, level;
typedef struct st_lstruct lstruct;

// the set of 4 pixmaps for each type of object.
struct pstruct {
	GdkPixmap *groove[4];
	int size;
	int frame;
	GdkBitmap *mask[4];
} dpict, apict, jpict;

lstruct randomvectors(lstruct);

///////////////////////////////////////////////////////////////////////

inline void msleep(long i)
{
	usleep(i*1000);
}

/*
 * This was the original main().  Now it's called from arrows.c, which 
 * sets up the gtk stuff.
 *
 * The outermost loop is per game; the next is per level; then per "dot"; 
 * then finally comes the main game play loop.
 *
 */
void game_main(void)
{
	int i,j,k,quit=0;
	char c;
	init_things();
	while (!(quit)){
		levno=1;
		spin=0;
		dots=4;
		score=0;

		while (dots){
			if (load(levno)) {  // loads arrows[], dotx, doty, levdelay.
				fprintf(stderr, "ERROR: could not load level %d.\n", levno);
				spin=100;
				break;
			}
			nnj=nj;
			while ( (!(dotx==level.objx && doty==level.objy)) && dots)  {
				spin=10;
				move=0; shot=0;
				amove=0;
				nj=nnj;
				level = initlevel;
				setcolor(0);
				for (i=11; i<409; i++) line(11,i,629,i);
				display_field();
				dlay=level.levdelay/4 - levno*2;
				if (dlay<40) dlay=40;
				ylay=dlay;
				showscore();
				DMOD=DMOD*3;  //slowdown for start
				dotx=level.s_dotx;
				doty=level.s_doty;
				antix=dotx-5;  antiy=doty;   mod3=0;
				d_dotx=1; d_doty=0;
				d_antix=d_dotx;  d_antiy=d_doty;
				newscr();
				setcolor(15);
				if (levno%5) {
					for (i=0; i<nj; i++) {
		 	      	while (level.arrows[j=(rand()%30+2)][k=(rand()%18+2)]!=0);
						level.arrows[j][k]=-32768;
						jpoints[i][0]=j*20; jpoints[i][1]=k*20;
						jpoints[i][2]=1;
						putimage(j*20-5, k*20-5, jpict.groove[0], XOR_PUT);
						if (!level.arrows[j][k]<0) fprintf(stderr, "DUMB!\n");
					}  //put some -1's in.
				} else {
					nj=0;
					for (j=0; j<33; j++) for (k=0; k<21; k++) {
						if (level.arrows[j][k]==-32768) {
							jpoints[nj][0]=j*20; jpoints[nj][1]=k*20;
							jpoints[nj][2]=1;
							nj++;
							putimage(j*20-5, k*20-5, jpict.groove[0], XOR_PUT);
						}
					}
				}
				dpict.frame=0;  apict.frame=0; jpict.frame=0;
				putimage(dotx+PICT_OFF, doty+PICT_OFF, dpict.groove[0], XOR_PUT);
				putimage(antix+PICT_OFF, antiy+PICT_OFF, apict.groove[0], XOR_PUT);
				while ( (!(dotx==antix && doty==antiy)) && (!(dotx==level.objx && doty==level.objy)) )  {
					gtk_main_iteration_do(FALSE);
					g_timer_reset(TTT);
					g_timer_start(TTT);
					cal=-1;
					msleep((int) (5*DMOD));
					if (!dlay){
						moveanti();
						if (!mod3) {
							if (!(dotx==antix && doty==antiy)) moveanti();
							updatescr();
							showscore();
						}
						if ((++mod3)==13) mod3=0;
					} else {
						mod3=(mod3+1)%13;
						if (!mod3) { updatescr();
										 showscore();
										 dlay--;      }
					}
					if (shot) moveshot();
					if (shot) moveshot();
					if (dotx!=antix || doty!=antiy) movedot();
					if (shot) moveshot();
					if (shot) moveshot();
					if (kbhit() && !shot && (dotx%20+doty%20))
						if ((c=getch())==' ') {
							shotx=dotx+d_dotx; shoty=doty+d_doty; d_shotx=d_dotx; d_shoty=d_doty;
							shot=-1; shot_frame=dpict.frame;
							putimage(shotx+PICT_OFF, shoty+PICT_OFF, apict.groove[shot_frame], XOR_PUT);
						} else ungetch(c);
					if (cal) {
						g_timer_stop(TTT);
						if (g_timer_elapsed(TTT, NULL)>DSPEED) DMOD=DMOD*.97;
						if (g_timer_elapsed(TTT, NULL)<DSPEED) DMOD=DMOD*1.03;
					}
				}
				if ( (!(dotx==level.objx && doty==level.objy)) )
					destroy();
			}
			levno++;
			DTIME=(int) (DTIME * 0.8) + 1;
			DSPEED=(DSPEED * 0.93) + .00034;     //.015
		}
		fprintf(stderr, "Your score was %d.\n", score);
		if (spin==100) fprintf(stderr, "ERROR: could not load level %d.\n", levno);
		quit=-1;
	}
	exit(0);
}

/* move the dot; check for arrows; process keys */
void movedot(void)
{
	int i, odx, ody, count, ct, AR, flag=0;
	char c;

	/* First, actually move the dot on the screen */
	putimage(dotx+PICT_OFF,doty+PICT_OFF,dpict.groove[dpict.frame],XOR_PUT);
	if (spin==10 || !(spin=(spin+1)%10)) //note this tricky condition.
		dpict.frame=(dpict.frame+1)%4; 
	putimage((dotx+=d_dotx)+PICT_OFF, (doty+=d_doty)+PICT_OFF, dpict.groove[dpict.frame],XOR_PUT);

	odx=d_dotx;
	ody=d_doty;

	if (dotx==LEFTB || dotx==RIGHTB || doty==UPB || doty==DOWNB){
		antix=dotx;   antiy=doty;
		return;
	}

	/* Check for an arrow off of which to bounce. */
	if ( (d_dotx && dotx % 20 == 10) || (d_doty && doty % 20 == 10) ){
		switch (d_dotx + d_doty*2){
		case -1:
			if (level.arrows[(dotx-10)/20][doty/20] & RIGHT)
				d_dotx *= -1;
			break;
		case 1:
			if (level.arrows[(dotx+10)/20][doty/20] & LEFT)
				d_dotx *= -1;
			break;
		case -2:
			if (level.arrows[dotx/20][(doty-10)/20] & DOWN)
				d_doty *= -1;
			break;
		case 2:
			if (level.arrows[dotx/20][(doty+10)/20] & UP)
				d_doty *= -1;
			break;
		default:
			fprintf(stderr, "SOMETHING IS HORRIBLY WRONG!!>>!>!>!>>!\n");
		}
		//while (kbhit()) c=getch();  //take this time to clear kb buffer.

	/* Now check to see if we're at an arrow */
	} else if ( !((dotx%20)+(doty%20)) && level.arrows[dotx/20][doty/20]>0 ) {
		cal = 0;  //timer off since we stopped
		AR = level.arrows[dotx/20][doty/20];
		count = (AR & UP)/UP + (AR & DOWN)/DOWN + (AR & LEFT)/LEFT + (AR & RIGHT)/RIGHT;
		spin = 0;

		/* If there's only one way to go,... */
		if (count == 1) {
			switch (AR & (UP+DOWN+LEFT+RIGHT)){
			case UP:
				d_dotx=0; d_doty=-1; break;
			case DOWN:
				d_dotx=0; d_doty=1; break;
			case LEFT:
				d_dotx=-1; d_doty=0; break;
			case RIGHT:
				d_dotx=1; d_doty=0; break;
			default:
				fprintf(stderr, "MIGHTY MIGHTY OH!\n");
			}

		/* Otherwise, a choice */
		} else if (count > 1) {
			ct = 0;
			do {
			 if (kbhit()) {
				c=getch();
				switch (c){
				case KEY_UP:
					if (AR & UP) {
						d_dotx=0;
						d_doty=-1;
						flag=-1;
					} break;
				case KEY_DOWN:
					if (AR & DOWN) {
						d_dotx=0;
						d_doty=1;
						flag=-1;
					} break;
				case KEY_LEFT:
					if (AR & LEFT) {
						d_dotx=-1;
						d_doty=0;
						flag=-1;
					} break;
				case KEY_RIGHT:
					if (AR & RIGHT) {
						d_dotx=1;
						d_doty=0;
						flag=-1;
					} break;
				}
			 }
			 if (!(ct=(ct+1)%10)) {
				putimage(dotx+PICT_OFF, doty+PICT_OFF, dpict.groove[dpict.frame], XOR_PUT);
				dpict.frame=(dpict.frame+1)%4;
				putimage(dotx+PICT_OFF, doty+PICT_OFF, dpict.groove[dpict.frame], XOR_PUT);
			 }
			 if (dotx==(antix+d_antix) && doty==(antiy+d_antiy)){flag=-1;mod3=0;}
			 if (!dlay && !flag && (!ct || ct==3 || ct==6))
				 moveanti();
			 else if (!(flag || ct)) {
				 dlay--;
				 showscore();
			 }
			 if (!ct) updatescr();
			 if ((int) (5*DMOD)-levno>20) msleep((int)(5*DMOD) - levno); else msleep(20);
			 gtk_main_iteration_do(FALSE);
			} while (!flag);

		/* The only other possibility, no way to go.  */
		} else {
			// XXX not sure, this might fix the bug.
			;
			//antix=dotx;   //this probably never happens, usually.
			//antiy=doty;
		}

	/* check for -32768, spin and keys */
	} else if (!((dotx%20)+(doty%20))) {
		if (level.arrows[dotx/20][doty/20]==-32768) {
			score+=13; showscore(); nnj--;
			putimage(dotx-5, doty-5, jpict.groove[jpict.frame], XOR_PUT);
			level.arrows[dotx/20][doty/20]=0;
			initlevel.arrows[dotx/20][doty/20]=0;
			for (i=0; i<nj && !(dotx==jpoints[i][0] && doty==jpoints[i][1]); i++);
			if ((dotx==jpoints[i][0] && doty==jpoints[i][1]) && i<nj)
				jpoints[i][2]=0;
		}
		if (kbhit()) {
			c=getch();
			if (strchr(ALT_KEYS, c))
			{
				if (spin<10) {
					switch (d_dotx+d_doty*2){
						case -1: AR=_RIGHT; if (c==ALT_RIGHT) c=0; break;
						case  1: AR=_LEFT; if (c==ALT_LEFT) c=0; break;
						case -2: AR=_DOWN; if (c==ALT_DOWN) c=0; break;
						case  2: AR=_UP; if (c==ALT_UP) c=0; break;
					}
					putimage(dotx+PICT_OFF, doty+PICT_OFF, dpict.groove[dpict.frame], XOR_PUT);
					switch (c) {
					case ALT_UP: draw_arrow(dotx,doty,AR+UP,7);
									 level.arrows[dotx/20][doty/20]=AR+UP;
									 score-=5; spin=10; d_dotx=0; d_doty=-1; showscore(); break;
					case ALT_DOWN: draw_arrow(dotx,doty,AR+DOWN,7);
										level.arrows[dotx/20][doty/20]=AR+DOWN;
										score-=5; spin=10; d_dotx=0; d_doty=1; showscore(); break;
					case ALT_LEFT: draw_arrow(dotx,doty,AR+LEFT,7);
										level.arrows[dotx/20][doty/20]=AR+LEFT;
										score-=5; spin=10; d_dotx=-1; d_doty=0; showscore(); break;
					case ALT_RIGHT:draw_arrow(dotx,doty,AR+RIGHT,7);
										level.arrows[dotx/20][doty/20]=AR+RIGHT;
										score-=5; spin=10; d_dotx=1; d_doty=0; showscore(); break;
					}
					putimage(dotx+PICT_OFF, doty+PICT_OFF, dpict.groove[dpict.frame], XOR_PUT);
				}
			}
			else switch (c) {
			case ' ':   //bang
			  if (!shot){
				shotx=dotx+d_dotx; shoty=doty+d_doty; d_shotx=d_dotx; d_shoty=d_doty;
				shot=-1; shot_frame=dpict.frame;
				putimage(shotx+PICT_OFF, shoty+PICT_OFF, apict.groove[shot_frame], XOR_PUT);
			  }
				break;
			case 'q':
			case 'Q':
				setcolor(15);
				outtextxy(256,415,"You are sure you want to quit? (y/n)");
				if ((c=getch())=='y') {
					exit(0);
				}
				if (c=='|') {     // skip this level
					dotx=level.objx;
					doty=level.objy;
					levno=4-(levno%5)+levno;
				}
				setcolor(0);
				outtextxy(256,415,"You are sure you want to quit? (y/n)");
				break;
			}
		}
	}

	/* If we've changed direction, record it for later */
	if ( !(odx==d_dotx) || !(ody==d_doty)) {
		moves[move][0]=dotx;
		moves[move][1]=doty;
		moves[move][2]=(d_dotx + d_doty * 2);
		move = (move+1)%200;
	}
}

void moveanti(void)
{
	putimage(antix+PICT_OFF,antiy+PICT_OFF,apict.groove[apict.frame],XOR_PUT);
	apict.frame=(apict.frame+1)%4;
	putimage((antix+=d_antix)+PICT_OFF, (antiy+=d_antiy)+PICT_OFF, apict.groove[apict.frame],XOR_PUT);

	if (antix==moves[amove][0] && antiy==moves[amove][1] && move>amove) {
		d_antix=0; d_antiy=0;
		if ( (moves[amove][2]*moves[amove][2]) < 2)
			d_antix=moves[amove][2];
		else
			d_antiy=moves[amove][2]/2;
		amove = (amove + 1) % 200;
	}

}

void moveshot(void)
{
	putimage(shotx+PICT_OFF,shoty+PICT_OFF,apict.groove[shot_frame],XOR_PUT);
	shot_frame=(shot_frame+1)%4;
	putimage((shotx+=d_shotx)+PICT_OFF, (shoty+=d_shoty)+PICT_OFF, apict.groove[shot_frame],XOR_PUT);
	if (!(shotx%20 + shoty%20) && level.arrows[shotx/20][shoty/20]>0) {
		putimage(shotx+PICT_OFF,shoty+PICT_OFF,apict.groove[shot_frame],XOR_PUT);
		shot=0;
		draw_arrow(shotx,shoty,level.arrows[shotx/20][shoty/20],0);
		level.arrows[shotx/20][shoty/20]=0;
	} else if (shotx<5 || shotx>635 || shoty<5 || shoty>395) {
		putimage(shotx+PICT_OFF,shoty+PICT_OFF,apict.groove[shot_frame],XOR_PUT);
		shot=0;
	}
}

/* 
 * My attempt at using transparency doesn't work.  Perhaps it doesn't apply 
 * when you're XORing.  So, I've set the xpm bg's to black instead.
 */
void init_things(void)
{
	//GdkColor *white = &drawing_area->style->white;
	int i, j;
	for (i=0; i<33; i++) for (j=0; j<21; j++) initlevel.arrows[i][j]=0;

	// load graphics
	dpict.size=13*13;
	dpict.frame=0;
	dpict.groove[0]=gdk_pixmap_create_from_xpm_d(pixmap, NULL, NULL, blue1);
	dpict.groove[1]=gdk_pixmap_create_from_xpm_d(pixmap, NULL, NULL, blue2);
	dpict.groove[2]=gdk_pixmap_create_from_xpm_d(pixmap, NULL, NULL, blue3);
	dpict.groove[3]=gdk_pixmap_create_from_xpm_d(pixmap, NULL, NULL, blue4);

	apict.frame=0;
	apict.groove[0]=gdk_pixmap_create_from_xpm_d(pixmap, NULL, NULL, red1);
	apict.groove[1]=gdk_pixmap_create_from_xpm_d(pixmap, NULL, NULL, red2);
	apict.groove[2]=gdk_pixmap_create_from_xpm_d(pixmap, NULL, NULL, red3);
	apict.groove[3]=gdk_pixmap_create_from_xpm_d(pixmap, NULL, NULL, red4);

	jpict.frame=0;
	jpict.groove[0]=gdk_pixmap_create_from_xpm_d(pixmap, NULL, NULL, green1);
	jpict.groove[1]=gdk_pixmap_create_from_xpm_d(pixmap, NULL, NULL, green2);
	jpict.groove[2]=gdk_pixmap_create_from_xpm_d(pixmap, NULL, NULL, green3);
	jpict.groove[3]=gdk_pixmap_create_from_xpm_d(pixmap, NULL, NULL, green4);

	TTT = g_timer_new();
	g_timer_reset(TTT);
	g_timer_start(TTT);

	for (i=0; i<404; i++) { i++; i--;}
	for (i=0; i<100; i++) putimage(100, 100, jpict.groove[i%4], XOR_PUT);

	g_timer_stop(TTT);
	DMOD=((float)       (.04/g_timer_elapsed(TTT, NULL))        );
	DMOD/=1000;
}

/* 
 * Either load from disk, or create a random level.
 */
int load(int levno)
{

	int i,j;
	if (!(levno%5)) {
		FILE *stream;
		char nm[9];
		strcpy(nm, "arrfl.");
		nm[6] = ((char) ((levno/5)+48));
		nm[7] = '\0';
		if ((stream = fopen(nm, "rb")) != NULL) {
			fread(&initlevel, sizeof(initlevel), 1, stream);
			fclose(stream);
			clearviewport();
			level = initlevel;
			display_field();
			dotx=0; doty=0;
			nj=0;
			return(0);
		} else
			return(1);
	} else {
		dotx=0; doty=0; initlevel.s_dotx=20;  initlevel.s_doty=200;
		initlevel.objx=620; initlevel.objy=380;  initlevel.levdelay=0;
		clearviewport();
		//randomize(); xxx
		srandom(time(NULL));
		for (i=0; i<33; i++) for (j=0; j<21; j++) initlevel.arrows[i][j]=0;
		while (initlevel.levdelay<25)
			initlevel=randomvectors(initlevel);
		initlevel.levdelay=100;
		level=initlevel;
		display_field();
		msleep(500);
		nj=JMAX;
		return(0);
	}
}

/*
 * Once the level is loaded, display it.
 */
void display_field()
{
	int i,j;
	int poly[8]={0,461,0,477,400,477,400,461};
	char string[20];

	setcolor(1);
//   for (i=0; i<640; i+=20) line(i,0,i,400);   //these lines
//   for (i=0; i<420; i+=20) line(0,i,640,i);   //draw a grid
	for (i=20; i<640; i+=20) for (j=20; j<420; j+=20) putpixel(i,j,1); 
	for (i=20; i<660; i+=20)
		for (j=0; j<420; j+=20)
			draw_arrow(i, j, level.arrows[i/20][j/20], 7);
	setcolor(7);
	circle(level.objx,level.objy,5);
	line(level.objx,level.objy-4,level.objx,level.objy+4);
	line(level.objx-4,level.objy,level.objx+4,level.objy);
	line(level.objx-4,level.objy-4,level.objx+4,level.objy+4);
	line(level.objx-4,level.objy+4,level.objx+4,level.objy-4);


	setcolor(0);
	fillpoly(4,poly);
	sprintf(string, "Score: %05d", score);
	setcolor(15);
	outtextxy(15,462,string);

		sprintf(string, "Delay:");
		outtextxy(140,462,string);

		setcolor(14);
		poly[0]=200; poly[1]=463; poly[2]=200; poly[3]=468;
		poly[4]=300; poly[5]=468; poly[6]=300; poly[7]=463;
		drawpoly(4,poly);
	if (dlay && ylay) {
		poly[4]=200+(int)((((float)dlay)/((float)ylay))*100.0); poly[6]=poly[4];
		fillpoly(4,poly);
	}



}


/* 
 * You lose.  Should probably make something more visually interesting happen here.
 */
void destroy()
{
	dots--;
	while (kbhit()) (void) getch();
	setcolor(15);
	outtextxy(15,411, "Press any key now..");
	if (getch()==27) dots=0;

	clearviewport();
	display_field();
	updatescr();
}

/*
 * Not sure what this function was originally intended for.
 */
void newscr()
{
	setcolor(8);
	line(10,10,630,10);
	line(10,10,10,410);
	line(10,410,630,410);
	line(630,10,630,410);
}

/*
 * Update the "j points".
 */
void updatescr()
{
	int i,k;

	k=(jpict.frame+1)%4;

	for (i=0; i<nj; i++)
			if (jpoints[i][2]) {
				putimage(jpoints[i][0]-5,jpoints[i][1]-5,jpict.groove[jpict.frame],XOR_PUT);
				putimage(jpoints[i][0]-5,jpoints[i][1]-5,jpict.groove[k],XOR_PUT);
			}
	jpict.frame=k;
}

/*
 * Show the current score, the delay bar, etc.
 */
void showscore()
{
	int poly[8]={70,461,70,477,110,477,110,461};
	char string[20];

	setcolor(0);
	fillpoly(4,poly);
	sprintf(string, "%05d", score);
	setcolor(15);
	outtextxy(72,462,string);

	if (dlay && ylay) {
		setcolor(0);
		poly[0]=200; poly[1]=463; poly[2]=200; poly[3]=468;
		poly[4]=300; poly[5]=468; poly[6]=300; poly[7]=463;
		fillpoly(4,poly);

		setcolor(14);
		poly[4]=200+(int)((((float)dlay)/((float)ylay))*100.0); poly[6]=poly[4];
		fillpoly(4,poly);
	} else if (!dlay && ylay) {
		ylay=0;
		poly[4]=300; poly[6]=300;
		poly[0]=140; poly[2]=140;
		setcolor(0);
		fillpoly(4,poly);
	}
/*
	sprintf(string, "DMOD: %f", DMOD);
	outtextxy(260,462,string);

	sprintf(string, "DSPEED: %f", DSPEED);
	outtextxy(380,462,string);
*/
}


/* 
 * Generate a random level.
 * 
 * This function is original to the 1993 version.  I was quite proud of it at the time.
 * (The original BASIC version didn't have randomly-generated levels.)
 *
 * It's probably not worth trying to understand how this bit works.
 *
 */
lstruct randomvectors(lstruct l)
{
	int p[80][4]; //points[x, {x,y,lifetime,dir}]
	int np, flag;  //activepoints, num arrows.
	int i,j,k,r,s,x, nxp, nyp, cxp, cyp, nokay, count=0;
	int d[9][2];  //dirs
	int ds[4];
	int okay[4], sokay[4];

	ds[0]=UP; ds[1]=LEFT; ds[2]=DOWN; ds[3]=RIGHT;
	d[DOWN][0]=0; d[DOWN][1]=1; d[LEFT][0]=-1; d[LEFT][1]=0;
	d[UP][0]=0; d[UP][1]=-1; d[RIGHT][0]=1; d[RIGHT][1]=0;
	for (i=0; i<33; i++) for (j=0; j<21; j++) l.arrows[i][j]=0;
	for (i=0; i<80; i++) p[i][2]=0;
	np=1;
	p[0][0]=3; p[0][1]=10; p[0][2]=1; p[0][3]=3;
	flag=1;

	while (np>0 && flag){
		flag=0;
		for (i=0; i<np; i++) if (p[i][2]) {
				flag=-11;  s=0;
				nxp=p[i][0]+d[ds[p[i][3]]][0];
				nyp=p[i][1]+d[ds[p[i][3]]][1];
				if (l.arrows[nxp][nyp] || nxp<1 || nyp<1 || nxp>30 || nyp>18 || (!(rand()%3) && p[i][2]>3) ) {
					for (j=0; j<4; j++) {
						okay[j]=1; sokay[j]=0;
						if (j==(p[i][3]+2)%4 || (p[i][0]+d[ds[j]][0]>30 && d[ds[j]][0]) || (p[i][0]+d[ds[j]][0]<2 && d[ds[j]][0]) || (p[i][1]+d[ds[j]][1]>18 && d[ds[j]][1]) || (p[i][1]+d[ds[j]][1]<2 && d[ds[j]][1]))
							okay[j]=0;
						else {
							cxp=p[i][0]+d[ds[j]][0]; cyp=p[i][1]+d[ds[j]][1];
							while (cxp+1>0 && cyp+1>0 && cxp<33 && cyp<21) {
								if (l.arrows[cxp][cyp]) {okay[j]=0; break;}
								cxp+=d[ds[j]][0]; cyp+=d[ds[j]][1];
							}
							if (!okay[j] && (( ((j+2)%4) & l.arrows[cxp][cyp]) || (((j+2)%4)*16) & l.arrows[cxp][cyp] )) {
								if (rand()%25) {
									for (k=0; k<4; k++) okay[k]=0;
									s=6; if (l.arrows[nxp][nyp] || nxp<1 || nyp<1 || nxp>30 || nyp>18) s=5;
									break;
								} else okay[j]=1;
							}
						}
					} //checked all the directions now for branching.
					nokay=0;
					for (j=0; j<4; j++) if (okay[j]) nokay++;
					k=0;
					for (j=0; j<4; j++) {
						if (okay[j]) { sokay[k]=j; k++; }
					} //now nokay=num of okay dirs, stored in sokay[0,1,..,nokay-1]
					for (j=0; j<4; j++) okay[j]=0;
					if (nokay==1 && sokay[0]==p[i][3]){ s=6; nokay=0; }
					if (!nokay) {
					 if (s<6){
						l.arrows[p[i][0]][p[i][1]]=0;
						p[i][2]=0;
						np--;
						setcolor(15);
						circle(p[i][0]*20,p[i][1]*20,6);
					 }
					} else {
						count++;
						l.arrows[p[i][0]][p[i][1]]=ds[(p[i][3]+2)%4]*16; //_DIR=DIR * 16
						do k=rand()%nokay; while (sokay[k]==p[i][3]);
						okay[k]=-1;    //indicates we've picked it already.
						s=k;
						for (x=0; x<nokay-1; x++) if (rand()%(4-x)) {
							while (okay[k]) k=rand()%nokay;
							okay[k]=-1;
							r=0; //next we do a 'newpoint()' put it inline.r=0;
							while (r<80 && p[r][2]) r++;
							if (!p[r][2]) {
								p[r][0]=p[i][0]+d[ds[sokay[k]]][0];
								p[r][1]=p[i][1]+d[ds[sokay[k]]][1];
								p[r][2]=1;
								p[r][3]=sokay[k];
								np++;
							}
							l.arrows[p[i][0]][p[i][1]]+=ds[sokay[k]];
						}
						k=s;
						p[i][3]=sokay[k];   //new dir for this point.
						p[i][2]=1;
						l.arrows[p[i][0]][p[i][1]]+=ds[sokay[k]];
					  // draw_arrow(p[i][0]*20, p[i][1]*20, l.arrows[p[i][0]][p[i][1]], 7);
						p[i][0]=p[i][0]+d[ds[p[i][3]]][0];
						p[i][1]=p[i][1]+d[ds[p[i][3]]][1];
					}
				} else {  //if we decide not to draw an arrow here...
					p[i][2]+=1;
					p[i][0]+=d[ds[p[i][3]]][0];
					p[i][1]+=d[ds[p[i][3]]][1];
					setcolor(i%16);
					circle(p[i][0]*20,p[i][1]*20,3);
					circle(p[i][0]*20,p[i][1]*20,2);
					circle(p[i][0]*20,p[i][1]*20,4);
				}
		if (j==6) i--;     //if we want to keep going and can.
		}
	}
	i=1;
	while (!l.arrows[i][10]) {
		while (!l.arrows[i][10]) i++;
		if (l.arrows[i][10] & LEFT) l.arrows[i][10]=0;
	}  //get rid of arrows that are in the way at start.
	msleep(50);
	l.levdelay=count;
	return(l);
}

/*
 * keyboard handing.
 */
int keypress = 0;
int lastkey = 0;
int kbhit(void)
{
	return keypress;
}

int getch(void)
{
	while (!kbhit())
	{
		gtk_main_iteration_do(FALSE);
		msleep(10);
	}
	int c = tolower(keypress);
	keypress=0;
	// interpret the arrow keys as hjkl.
	if (c==65361) c = KEY_LEFT;
	if (c==65362) c = KEY_UP;
	if (c==65363) c = KEY_RIGHT;
	if (c==65364) c = KEY_DOWN;
	return c;
}

void ungetch(int c)
{
	keypress = c;
}

gboolean key_released( GtkWidget *widget, GdkEventKey *event)
{
	lastkey = 0;
	return TRUE;
}

gboolean key_pressed( GtkWidget *widget, GdkEventKey *event)
{
	if (event->keyval != lastkey)
	{
		keypress = event->keyval;
		lastkey = keypress;
	}
	return TRUE;
}
