/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SingletonAttributeMap;
import net.sf.saxon.om.SmallAttributeMap;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.streams.Predicates;
import net.sf.saxon.s9api.streams.Steps;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.reader.AbstractReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.KeyDef;
import org.dita.dost.util.KeyScope;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;

public final class KeyrefReader
implements AbstractReader {
    private static final List<String> ATTS = List.of("href", "audience", "platform", "product", "otherprops", "rev", "props", "linking", "toc", "print", "search", "format", "scope", "type", "xml:lang", "dir", "translate", "processing-role", "cascade");
    private DITAOTLogger logger;
    private Job job;
    private DocumentBuilder builder;
    private KeyScope rootScope;
    private URI currentFile;
    private XMLUtils xmlUtils;

    @Override
    public void read(File filename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public void setJob(Job job) {
        this.job = job;
    }

    public void setXmlUtils(XMLUtils xmlUtils) {
        this.xmlUtils = xmlUtils;
        this.builder = xmlUtils.getDocumentBuilder();
    }

    public KeyScope getKeyDefinition() {
        return this.rootScope;
    }

    public void read(URI filename, XdmNode doc) {
        this.currentFile = filename;
        this.rootScope = null;
        KeyScope keyScope = this.readScopes(doc);
        KeyScope keyScopeWithChildren = this.cascadeChildKeys(keyScope);
        KeyScope keyScopeWithParents = this.inheritParentKeys(keyScopeWithChildren);
        this.rootScope = this.resolveIntermediate(keyScopeWithParents);
    }

    private KeyScope readScopes(XdmNode doc) {
        assert (doc.getNodeKind() == XdmNodeKind.DOCUMENT);
        XdmNode root = doc.select(XMLUtils.rootElement()).asNode();
        List<KeyScope> scopes = this.readScopesRoot(root);
        if (scopes.size() == 1 && scopes.get(0).name() == null) {
            return scopes.get(0);
        }
        return new KeyScope("#root", null, Collections.emptyMap(), scopes);
    }

    private List<KeyScope> readScopesRoot(XdmNode root) {
        ArrayList<KeyScope> childScopes = new ArrayList<KeyScope>();
        HashMap<String, KeyDef> keyDefs = new HashMap<String, KeyDef>();
        this.readScope(root, keyDefs);
        this.readChildScopes(root, childScopes);
        String keyscope = root.attribute("keyscope");
        if (keyscope == null || keyscope.trim().isEmpty()) {
            return Collections.singletonList(new KeyScope("#root", null, keyDefs, childScopes));
        }
        ArrayList<KeyScope> res = new ArrayList<KeyScope>();
        for (String scope : keyscope.split("\\s+")) {
            res.add(new KeyScope(this.generateId(root, scope), scope, keyDefs, childScopes));
        }
        return res;
    }

    private String generateId(XdmNode root, String scope) {
        StringBuilder res = new StringBuilder();
        XdmNode elem = root;
        while (elem != null) {
            res.append(elem.getNodeName()).append('[');
            int position = 0;
            XdmNode n = elem;
            while (n != null) {
                n = n.select(Steps.precedingSibling().first()).findFirst().orElse(null);
                ++position;
            }
            res.append(Integer.toString(position)).append(']');
            XdmNode p = elem.getParent();
            if (p != null && p.getNodeKind() == XdmNodeKind.ELEMENT) {
                elem = p;
                continue;
            }
            elem = null;
        }
        res.append('.').append(scope);
        return res.toString();
    }

    private void readChildScopes(XdmNode elem, List<KeyScope> childScopes) {
        elem.select(Steps.child((Predicate)Predicates.isElement())).forEach(child -> {
            if (child.attribute("keyscope") != null) {
                List<KeyScope> childScope = this.readScopesRoot((XdmNode)child);
                childScopes.addAll(childScope);
            } else {
                this.readChildScopes((XdmNode)child, childScopes);
            }
        });
    }

    private void readScope(XdmNode scope, Map<String, KeyDef> keyDefs) {
        ArrayList<XdmNode> maps = new ArrayList<XdmNode>();
        maps.add(scope);
        for (XdmNode child : scope.children(Predicates.isElement())) {
            this.collectMaps(child, maps);
        }
        for (XdmNode map : maps) {
            this.readMap(map, keyDefs);
        }
    }

    private void collectMaps(XdmNode elem, List<XdmNode> maps) {
        if (elem.attribute("keyscope") != null) {
            return;
        }
        String classValue = elem.attribute("class");
        if (Constants.MAP_MAP.matches(classValue) || Constants.SUBMAP.matches(classValue)) {
            maps.add(elem);
        }
        for (XdmNode child : elem.children(Predicates.isElement())) {
            this.collectMaps(child, maps);
        }
    }

    private void readMap(XdmNode map, Map<String, KeyDef> keyDefs) {
        this.readKeyDefinition(map, keyDefs);
        for (XdmNode elem : map.children(Predicates.isElement())) {
            if (Constants.SUBMAP.matches(elem) || elem.attribute("keyscope") != null) continue;
            this.readMap(elem, keyDefs);
        }
    }

    private void readKeyDefinition(XdmNode elem, Map<String, KeyDef> keyDefs) {
        String keyName = elem.attribute("keys");
        if (keyName != null) {
            Integer ditaArchVersion = elem.select(Steps.ancestorOrSelf().then(Steps.attribute((String)"http://dita.oasis-open.org/architecture/2005/", (String)"DITAArchVersion"))).findFirst().map(XdmItem::getStringValue).map(v -> (int)Math.floor(Double.parseDouble(v))).orElse(1);
            for (String key : keyName.trim().split("\\s+")) {
                if (keyDefs.containsKey(key)) continue;
                XdmNode copy = elem;
                URI href = URLUtils.toURI(copy.attribute("filter-copy-to") != null ? copy.attribute("filter-copy-to") : (copy.attribute("copy-to") != null ? copy.attribute("copy-to") : copy.attribute("href")));
                String scope = XMLUtils.getCascadeValue(copy, "scope");
                String format = copy.attribute("format");
                KeyDef keyDef = new KeyDef(key, href, scope, format, this.currentFile, copy, ditaArchVersion);
                keyDefs.put(key, keyDef);
            }
        }
    }

    @VisibleForTesting
    KeyScope cascadeChildKeys(KeyScope rootScope) {
        HashMap<String, KeyDef> res = new HashMap<String, KeyDef>(rootScope.keyDefinition());
        this.cascadeChildKeys(rootScope, res, "");
        return new KeyScope(rootScope.id(), rootScope.name(), res, rootScope.childScopes().stream().map(this::cascadeChildKeys).collect(Collectors.toList()));
    }

    private void cascadeChildKeys(KeyScope scope, Map<String, KeyDef> keys, String prefix) {
        for (Map.Entry<String, KeyDef> e : scope.keyDefinition().entrySet()) {
            KeyDef oldKeyDef = e.getValue();
            KeyDef newKeyDef = new KeyDef(prefix + oldKeyDef.keys, oldKeyDef.href, oldKeyDef.scope, oldKeyDef.format, oldKeyDef.source, oldKeyDef.element, oldKeyDef.version);
            if (keys.containsKey(newKeyDef.keys)) continue;
            keys.put(newKeyDef.keys, newKeyDef);
        }
        for (KeyScope child : scope.childScopes()) {
            this.cascadeChildKeys(child, keys, prefix + child.name() + ".");
        }
    }

    private KeyScope inheritParentKeys(KeyScope rootScope) {
        return this.inheritParentKeys(rootScope, Collections.emptyMap());
    }

    private KeyScope inheritParentKeys(KeyScope current, Map<String, KeyDef> parent) {
        if (parent.keySet().isEmpty() && current.childScopes().isEmpty()) {
            return current;
        }
        HashMap<String, KeyDef> resKeys = new HashMap<String, KeyDef>();
        resKeys.putAll(current.keyDefinition());
        resKeys.putAll(parent);
        ArrayList<KeyScope> resChildren = new ArrayList<KeyScope>();
        for (KeyScope child : current.childScopes()) {
            KeyScope resChild = this.inheritParentKeys(child, resKeys);
            resChildren.add(resChild);
        }
        return new KeyScope(current.id(), current.name(), resKeys, resChildren);
    }

    private KeyScope resolveIntermediate(KeyScope scope) {
        HashMap<String, KeyDef> keys = new HashMap<String, KeyDef>(scope.keyDefinition());
        for (Map.Entry<String, KeyDef> e : scope.keyDefinition().entrySet()) {
            KeyDef res = this.resolveIntermediate(scope, e.getValue(), Collections.singletonList(e.getValue()));
            keys.put(e.getKey(), res);
        }
        ArrayList<KeyScope> children = new ArrayList<KeyScope>();
        for (KeyScope child : scope.childScopes()) {
            KeyScope resolvedChild = this.resolveIntermediate(child);
            children.add(resolvedChild);
        }
        return new KeyScope(scope.id(), scope.name(), keys, children);
    }

    private KeyDef resolveIntermediate(KeyScope scope, KeyDef keyDef, List<KeyDef> circularityTracker) {
        XdmNode elem = keyDef.element;
        String keyref = elem.attribute("keyref");
        if (keyref != null && !keyref.trim().isEmpty() && scope.keyDefinition().containsKey(keyref)) {
            KeyDef keyRefDef = scope.keyDefinition().get(keyref);
            if (circularityTracker.contains(keyRefDef)) {
                this.handleCircularDefinitionException(circularityTracker);
                return keyDef;
            }
            XdmNode defElem = keyRefDef.element;
            String defElemKeyref = defElem.attribute("keyref");
            if (defElemKeyref != null && !defElemKeyref.isEmpty()) {
                ArrayList<KeyDef> ct = new ArrayList<KeyDef>(circularityTracker.size() + 1);
                ct.addAll(circularityTracker);
                ct.add(keyRefDef);
                keyRefDef = this.resolveIntermediate(scope, keyRefDef, ct);
            }
            XdmNode res = this.mergeMetadata(keyRefDef.element, elem);
            return new KeyDef(keyDef.keys, keyRefDef.href, keyRefDef.scope, keyRefDef.format, keyRefDef.source, res, keyRefDef.version);
        }
        return keyDef;
    }

    private void handleCircularDefinitionException(List<KeyDef> circularityTracker) {
        StringBuilder sb = new StringBuilder();
        Collections.reverse(circularityTracker);
        for (KeyDef keyDef : circularityTracker) {
            sb.append(keyDef.keys).append(" -> ");
        }
        sb.append(circularityTracker.get((int)0).keys);
        MessageBean ex = MessageUtils.getMessage("DOTJ069E", sb.toString()).setLocation(circularityTracker.get((int)0).element);
        this.logger.error(ex.toString(), ex.toException());
    }

    private XdmNode mergeMetadata(XdmNode defElem, XdmNode refElem) {
        try {
            XdmDestination dst = new XdmDestination();
            dst.setBaseURI(refElem.getBaseURI());
            dst.setDestinationBaseURI(refElem.getBaseURI());
            PipelineConfiguration pipe = refElem.getUnderlyingNode().getConfiguration().makePipelineConfiguration();
            Receiver receiver = dst.getReceiver(pipe, new SerializationProperties());
            receiver.open();
            receiver.startDocument(0);
            NodeInfo rni = refElem.getUnderlyingNode();
            SmallAttributeMap atts = new SmallAttributeMap(defElem.getUnderlyingNode().attributes().asList().stream().filter(attr -> ATTS.contains(attr.getNodeName().getLocalPart())).filter(attr -> refElem.attribute(attr.getNodeName().getLocalPart()) == null).collect(Collectors.toList()));
            receiver.startElement(NameOfNode.makeName((NodeInfo)rni), rni.getSchemaType(), (AttributeMap)atts, rni.getAllNamespaces(), rni.saveLocation(), 0);
            XdmNode defMeta = this.getTopicmeta(defElem);
            if (defMeta != null) {
                XdmNode resMeta = this.getTopicmeta(refElem);
                if (resMeta == null) {
                    SingletonAttributeMap attrs = SingletonAttributeMap.of((AttributeInfo)new AttributeInfo((NodeName)new NoNamespaceName("class"), (SimpleType)BuiltInAtomicType.STRING, Constants.MAP_TOPICMETA.toString(), (Location)Loc.NONE, 0));
                    receiver.startElement((NodeName)new NoNamespaceName(Constants.MAP_TOPICMETA.localName), (SchemaType)Untyped.getInstance(), (AttributeMap)attrs, rni.getAllNamespaces(), (Location)Loc.NONE, 0);
                } else {
                    NodeInfo ni = resMeta.getUnderlyingNode();
                    receiver.startElement(NameOfNode.makeName((NodeInfo)ni), ni.getSchemaType(), resMeta.getUnderlyingNode().attributes().remove((NodeName)new NoNamespaceName("keyref")), resMeta.getUnderlyingNode().getAllNamespaces(), ni.saveLocation(), 0);
                }
                defMeta.select(Steps.child()).forEach(child -> {
                    try {
                        receiver.append((Item)child.getUnderlyingNode());
                    }
                    catch (XPathException e) {
                        throw new UncheckedXPathException(e);
                    }
                });
                receiver.endElement();
            }
            receiver.endElement();
            receiver.endDocument();
            receiver.close();
            return dst.getXdmNode().select(XMLUtils.rootElement()).asNode();
        }
        catch (UncheckedXPathException | XPathException e) {
            this.logger.error("Failed to merge topicmeta: " + e.getMessage(), e);
            return refElem;
        }
    }

    private XdmNode getTopicmeta(XdmNode topicref) {
        return topicref.select(Steps.child(Constants.MAP_TOPICMETA::matches).first()).findAny().orElse(null);
    }
}

