/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SubjectSchemeFilter
extends AbstractXMLFilter {
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private Map<QName, Map<String, String>> defaultValueMap = null;
    private Map<QName, Map<String, Set<String>>> validateMap = null;

    public void setValidateMap(Map<QName, Map<String, Set<String>>> validateMap) {
        this.validateMap = validateMap;
    }

    public void setDefaultValueMap(Map<QName, Map<String, String>> defaultMap) {
        this.defaultValueMap = defaultMap;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Attributes res = this.addDefaultAttributeValues(qName, atts);
        this.validateAttributeValues(qName, res);
        super.startElement(uri, localName, qName, res);
    }

    private Attributes addDefaultAttributeValues(String elemName, Attributes atts) {
        AttributesImpl modified = null;
        for (Map.Entry<QName, Map<String, String>> elementDefaultValues : this.defaultValueMap.entrySet()) {
            String defaultValue;
            QName attrName = elementDefaultValues.getKey();
            if (atts.getValue(attrName.getNamespaceURI(), attrName.getLocalPart()) != null || (defaultValue = elementDefaultValues.getValue().get(elemName)) == null) continue;
            if (modified == null) {
                modified = new AttributesImpl(atts);
            }
            modified.addAttribute(attrName.getNamespaceURI(), attrName.getLocalPart(), null, "CDATA", defaultValue);
        }
        return Objects.requireNonNullElse(modified, atts);
    }

    private void validateAttributeValues(String elemName, Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            String[] tokens;
            QName attrName = new QName(atts.getURI(i), atts.getLocalName(i));
            Map<String, Set<String>> valueMap = this.validateMap.get(attrName);
            if (valueMap == null) continue;
            Set<String> valueSet = valueMap.get(elemName);
            if (valueSet == null) {
                valueSet = valueMap.get("*");
            }
            if (valueSet == null) continue;
            String attrValue = atts.getValue(i);
            for (String token : tokens = WHITESPACE.split(attrValue.trim())) {
                if (valueSet.contains(token)) continue;
                this.logger.warn(MessageUtils.getMessage("DOTJ049W", attrName.toString(), elemName, attrValue, String.join((CharSequence)", ", valueSet)).setLocation(atts).toString());
            }
        }
    }
}

