# Example usage

Built-in help:

```
> framework_tool
Swiss army knife for Framework laptops

Usage: framework_tool [OPTIONS]

Options:
      --flash-gpu-descriptor <fgd> <fgd>

  -v, --verbose...
          Increase logging verbosity
  -q, --quiet...
          Decrease logging verbosity
      --versions
          List current firmware versions
      --version
          Show tool version information (Add -vv for more details)
      --features
          Show features support by the firmware
      --esrt
          Display the UEFI ESRT table
      --device <DEVICE>
          [possible values: bios, ec, pd0, pd1, rtm01, rtm23, ac-left, ac-right]
      --compare-version <COMPARE_VERSION>

      --power
          Show current power status of battery and AC (Add -vv for more details)
      --thermal
          Print thermal information (Temperatures and Fan speed)
      --sensors
          Print sensor information (ALS, G-Sensor)
      --fansetduty [<FANSETDUTY>...]
          Set fan duty cycle (0-100%)
      --fansetrpm [<FANSETRPM>...]
          Set fan RPM (limited by EC fan table max RPM)
      --autofanctrl
          Turn on automatic fan speed control
      --pdports
          Show information about USB-C PD ports
      --info
          Show info from SMBIOS (Only on UEFI)
      --pd-info
          Show details about the PD controllers
      --pd-reset <PD_RESET>
          Reset a specific PD controller (for debugging only)
      --pd-disable <PD_DISABLE>
          Disable all ports on a specific PD controller (for debugging only)
      --pd-enable <PD_ENABLE>
          Enable all ports on a specific PD controller (for debugging only)
      --dp-hdmi-info
          Show details about connected DP or HDMI Expansion Cards
      --dp-hdmi-update <UPDATE_BIN>
          Update the DisplayPort or HDMI Expansion Card
      --audio-card-info
          Show details about connected Audio Expansion Cards (Needs root privileges)
      --privacy
          Show privacy switch statuses (camera and microphone)
      --pd-bin <PD_BIN>
          Parse versions from PD firmware binary file
      --ec-bin <EC_BIN>
          Parse versions from EC firmware binary file
      --capsule <CAPSULE>
          Parse UEFI Capsule information from binary file
      --dump <DUMP>
          Dump extracted UX capsule bitmap image to a file
      --h2o-capsule <H2O_CAPSULE>
          Parse UEFI Capsule information from binary file
      --dump-ec-flash <DUMP_EC_FLASH>
          Dump EC flash contents
      --flash-ec <FLASH_EC>
          Flash EC (RO+RW) with new firmware from file - may render your hardware unbootable!
      --flash-ro-ec <FLASH_RO_EC>
          Flash EC with new RO firmware from file - may render your hardware unbootable!
      --flash-rw-ec <FLASH_RW_EC>
          Flash EC with new RW firmware from file
      --intrusion
          Show status of intrusion switch
      --inputdeck
          Show status of the input modules (Framework 16 only)
      --inputdeck-mode <INPUTDECK_MODE>
          Set input deck power mode [possible values: auto, off, on] (Framework 16 only) [possible values: auto, off, on]
      --expansion-bay
          Show status of the expansion bay (Framework 16 only)
      --charge-limit [<CHARGE_LIMIT>]
          Get or set max charge limit
      --charge-current-limit <CHARGE_CURRENT_LIMIT>...
          Set max charge current limit
      --charge-rate-limit <CHARGE_RATE_LIMIT>...
          Set max charge current limit
      --get-gpio [<GET_GPIO>]
          Get GPIO value by name or all, if no name provided
      --fp-led-level [<FP_LED_LEVEL>]
          Get or set fingerprint LED brightness level [possible values: high, medium, low, ultra-low, auto]
      --fp-brightness [<FP_BRIGHTNESS>]
          Get or set fingerprint LED brightness percentage
      --kblight [<KBLIGHT>]
          Set keyboard backlight percentage or get, if no value provided
      --remap-key <REMAP_KEY> <REMAP_KEY> <REMAP_KEY>
          Remap a key by changing the scancode
      --rgbkbd <RGBKBD> <RGBKBD>...
          Set the color of <key> to <RGB>. Multiple colors for adjacent keys can be set at once. <key> <RGB> [<RGB> ...] Example: 0 0xFF000 0x00FF00 0x0000FF
      --tablet-mode <TABLET_MODE>
          Set tablet mode override [possible values: auto, tablet, laptop]
      --touchscreen-enable <TOUCHSCREEN_ENABLE>
          Enable/disable touchscreen [possible values: true, false]
      --stylus-battery
          Check stylus battery level (USI 2.0 stylus only)
      --console <CONSOLE>
          Get EC console, choose whether recent or to follow the output [possible values: recent, follow]
      --reboot-ec <REBOOT_EC>
          Control EC RO/RW jump [possible values: reboot, jump-ro, jump-rw, cancel-jump, disable-jump]
      --ec-hib-delay [<EC_HIB_DELAY>]
          Get or set EC hibernate delay (S5 to G3)
      --hash <HASH>
          Hash a file of arbitrary data
      --driver <DRIVER>
          Select which driver is used. By default portio is used [possible values: portio, cros-ec, windows]
      --pd-addrs <PD_ADDRS> <PD_ADDRS> <PD_ADDRS>
          Specify I2C addresses of the PD chips (Advanced)
      --pd-ports <PD_PORTS> <PD_PORTS> <PD_PORTS>
          Specify I2C ports of the PD chips (Advanced)
  -t, --test
          Run self-test to check if interaction with EC is possible
  -f, --force
          Force execution of an unsafe command - may render your hardware unbootable!
      --dry-run
          Simulate execution of a command (e.g. --flash-ec)
      --flash-gpu-descriptor-file <FLASH_GPU_DESCRIPTOR_FILE>
          File to write to the gpu EEPROM
      --dump-gpu-descriptor-file <DUMP_GPU_DESCRIPTOR_FILE>
          File to dump the gpu EEPROM to
  -h, --help
          Print help
```

## Check firmware versions

### BIOS (Mainboard, UEFI, EC, PD, Retimer)

Example on Framework 13 AMD Ryzen AI 300 Series:

```
> framework_tool --versions
Mainboard Hardware
  Type:           Laptop 13 (AMD Ryzen AI 300 Series)
  Revision:       MassProduction
UEFI BIOS
  Version:        03.00
  Release Date:   03/10/2025
EC Firmware
  Build version:  lilac-3.0.0-1541dc6 2025-05-05 11:31:24 zoid@localhost
  Current image:  RO
PD Controllers
  Right (01):       0.0.0E (MainFw)
  Left  (23):       0.0.0E (MainFw)
[...]
```

Example on Framework 13 Intel Core Ultra Series 1:

```
> framework_tool --versions
Mainboard Hardware
  Type:           Laptop 13 (AMD Ryzen AI 300 Series)
  Revision:       MassProduction
UEFI BIOS
  Version:        03.03
  Release Date:   10/07/2024
EC Firmware
  Build version:  marigold-3.0.3-278d300 2024-10-04 03:03:58 marigold1@ip-172-26-3-226
  Current image:  RO
PD Controllers
  Right (01):       0.0.08 (MainFw)
  Left  (23):       0.0.08 (MainFw)
[...]
```

### Camera (Framework 12, Framework 13, Framework 16)

Example on Framework 12:

```
> framework_tool --versions
[...]
Framework Laptop 12 Webcam Module
  Firmware Version: 0.1.6
```

Example on Framework 13:

```
> framework_tool --versions
[...]
Laptop Webcam Module (2nd Gen)
  Firmware Version: 1.1.1
```

### Touchscreen (Framework 12)

```
> framework_tool --versions
[...]
Touchscreen
  Firmware Version: v7.0.0.5.0.0.0.0
  Protocols:        USI
```

### Stylus (Framework 12)

```
> sudo framework_tool --versions
[...]
Stylus
  Serial Number:    28C1A00-12E71DAE
  Vendor ID:        32AC (Framework Computer)
  Product ID:       002B (Framework Stylus)
  Firmware Version: FF.FF
[...]
```

### Touchpad (Framework 12, Framework 13, Framework 16)

```
> framework_tool --versions
[...]
Touchpad
  Firmware Version: v0E07
```

### Input modules (Framework 16)

Shows firmware version and location of the modules.

```
> framework_tool --versions
[...]
Laptop 16 Numpad
  Firmware Version: 0.2.9
  Location: [X] [ ] [ ]       [ ] [ ]
Laptop 16 ANSI Keyboard
  Firmware Version: 0.2.9
  Location: [ ] [ ] [X]       [ ] [ ]
[...]
```

```
> framework_tool --versions
[...]
LED Matrix
  Firmware Version: 0.2.0
  Location: [X] [ ] [ ]       [ ] [ ]
Laptop 16 ANSI Keyboard
  Firmware Version: 0.2.9
  Location: [ ] [x] [ ]       [ ] [ ]
LED Matrix
  Firmware Version: 0.2.0
  Location: [ ] [ ] [ ]       [ ] [x]
[...]
```

### DisplayPort or HDMI Expansion Card

```
> framework_tool --dp-hdmi-info
DisplayPort Expansion Card
  Serial Number:        11AD1D0030123F17142C0B00
  Active Firmware:      101 (3.0.11.065)
  Inactive Firmware:    008 (3.0.11.008)
  Operating Mode:       MainFw (#2)

# Or
> framework_tool --versions
[...]
DisplayPort Expansion Card
  Active Firmware:      101 (3.0.11.065)
  Inactive Firmware:    008 (3.0.11.008)
  Operating Mode:       MainFw (#2)
```

### CSME Version (Linux on Intel systems)

```
> framework_tool --versions
[...]
CSME
  Firmware Version: 0:16.1.32.2473
[...]
```

### Firmware Version using ESRT (BIOS, Retimer, CSME)

All systems have at least an entry for BIOS. Intel systems also have CSME and some Retimers.

Example on Framework 13 Intel Core Ultra Series 1:

```
> sudo framework_tool --esrt
ESRT Table
  ResourceCount:        4
  ResourceCountMax:     4
  ResourceVersion:      1
ESRT Entry 0
  GUID:                 BDFFCE36-809C-4FA6-AECC-54536922F0E0
  GUID:                 MtlRetimer23
  Type:                 DeviceFirmware
  Version:              0x270 (624)
  Min FW Version:       0x0 (0)
  Capsule Flags:        0x0
  Last Attempt Version: 0x270 (624)
  Last Attempt Status:  Success
ESRT Entry 1
  GUID:                 32D8D677-EEBC-4947-8F8A-0693A45240E5
  GUID:                 MtlCsme
  Type:                 DeviceFirmware
  Version:              0x85D (2141)
  Min FW Version:       0x3E8 (1000)
  Capsule Flags:        0x0
  Last Attempt Version: 0x0 (0)
  Last Attempt Status:  Success
ESRT Entry 2
  GUID:                 C57FD615-2AC9-4154-BF34-4DC715344408
  GUID:                 MtlRetimer01
  Type:                 DeviceFirmware
  Version:              0x270 (624)
  Min FW Version:       0x0 (0)
  Capsule Flags:        0x0
  Last Attempt Version: 0x270 (624)
  Last Attempt Status:  Success
ESRT Entry 3
  GUID:                 72CECB9B-2B37-5EC2-A9FF-C739AABAADF3
  GUID:                 MtlBios
  Type:                 SystemFirmware
  Version:              0x303 (771)
  Min FW Version:       0x303 (771)
  Capsule Flags:        0x0
  Last Attempt Version: 0x303 (771)
  Last Attempt Status:  Success
```

## Check input deck status

### On Framework 12

```
> framework_tool --inputdeck
Input Deck
  Chassis Closed:      true
  Power Button Board:  Present
  Audio Daughterboard: Present
  Touchpad:            Present
```

### On Framework 13

```
> framework_tool --inputdeck
Input Deck
  Chassis Closed:      true
  Audio Daughterboard: Present
  Touchpad:            Present
```

### On Framework 16

```
> framework_tool --inputdeck
Chassis Closed:   true
Input Deck State: On
Touchpad present: true
SLEEP# GPIO high: true
Positions:
  Pos 0: GenericC
  Pos 1: KeyboardA
  Pos 2: Disconnected
  Pos 3: Disconnected
  Pos 4: GenericC
```

### Checking board ID

Most inputdeck checking is implemented by Board ID. To read those directly for
debugging low level issues, use the `--boardid` command.
This host command was added recently is not available on every system yet.

```
# Example on Framework Laptop 13
# Touchpad Board ID is only present on Laptop 12
# dGPU Board IDs are only present on Laptop 16
> framework_tool --boardid
Board IDs
  Mainboard:    Ok(Some(6))
  PowerButton:  Err(Response(InvalidResponse))
  Touchpad:     Ok(Some(7))
  AudioBoard:   Ok(Some(7))
  dGPU0:        Err(Response(InvalidCommand))
  dGPU1:        Err(Response(InvalidCommand))
```

## Check temperatures and fan speed

```
> sudo framework_tool --thermal
  F75303_Local: 43 C
  F75303_CPU:   44 C
  F75303_DDR:   39 C
  APU:          62 C
  Fan Speed:       0 RPM
```

## Check sensors

### Ambient Light (Framework 13, Framework 16)

```
> sudo framework_tool --sensors
ALS:   76 Lux
```

### Accelerometer (Framework 12)

```
> sudo framework_tool --sensors
Accelerometers:
  Lid Angle:   118 Deg
  Lid Sensor:  X=+0.00G Y=+0.86G, Z=+0.53G
  Base Sensor: X=-0.03G Y=-0.07G, Z=+1.02G
```

## Set custom fan duty/RPM

```
# Set a target fanduty of 100% (all or just fan ID=0)
> sudo framework_tool --fansetduty 100
> sudo framework_tool --fansetduty 0 100
> sudo framework_tool --thermal
  F75303_Local: 40 C
  F75303_CPU:   41 C
  F75303_DDR:   37 C
  APU:          42 C
  Fan Speed:    7281 RPM

# Set a target RPM (all or just fan ID=0)
> sudo framework_tool --fansetrpm 3141
> sudo framework_tool --fansetrpm 0 3141
> sudo framework_tool --thermal
  F75303_Local: 41 C
  F75303_CPU:   42 C
  F75303_DDR:   37 C
  APU:          44 C
  Fan Speed:    3171 RPM

# And back to normal
> sudo framework_tool --autofanctrl
> sudo framework_tool --thermal
  F75303_Local: 40 C
  F75303_CPU:   40 C
  F75303_DDR:   38 C
  APU:          42 C
  Fan Speed:       0 RPM

# Or just for a specific fan (e.g. on Framework Desktop)
> sudo framework_tool --autofanctrl 0
> sudo framework_tool --autofanctrl 1
```

## Check expansion bay (Framework 16)

```
> sudo framework_tool --expansion-bay
Expansion Bay
  Enabled:       true
  No fault:      true
  Door  closed:  true
  Board:         DualInterposer
  Serial Number: FRAXXXXXXXXXXXXXXX
  Config:        Pcie4x2
  Vendor:        SsdHolder
  Expansion Bay EEPROM
    Valid:       true
    HW Version:  8.0
```

Add `-vv` for more verbose details.

## Check charger and battery status (Framework 12/13/16)

```
> sudo framework_tool --power
Charger Status
  AC is:            not connected
  Charger Voltage:  17048mV
  Charger Current:  0mA
  Chg Input Current:384mA
  Battery SoC:      93%
Battery Status
  AC is:            not connected
  Battery is:       connected
  Battery LFCC:     3693 mAh (Last Full Charge Capacity)
  Battery Capacity: 3409 mAh
                    58.96 Wh
  Charge level:     92%
  Battery discharging
```

Get more information

```
> sudo framework_tool --power -vv
Charger Status
  AC is:            not connected
  Charger Voltage:  14824mV
  Charger Current:  0mA
  Chg Input Current:384mA
  Battery SoC:      33%
Battery Status
  AC is:            not connected
  Battery is:       connected
  Battery LFCC:     4021 mAh (Last Full Charge Capacity)
  Battery Capacity: 1300 mAh
                    19.267 Wh
  Charge level:     32%
  Manufacturer:     NVT
  Model Number:     FRANGWA
  Serial Number:    038F
  Battery Type:     LION
  Present Voltage:  14.821 V
  Present Rate:     943 mA
  Design Capacity:  3915 mAh
                    60.604 Wh
  Design Voltage:   15.480 V
  Cycle Count:      64
  Battery discharging
```

### Setting a custom charger current limit

```
# 1C = normal charging rate
# This means charging from 0 to 100% takes 1 hour
# Set charging rate to 0.8C
> sudo framework_tool --charge-rate-limit 0.8

# Limit charge current to the battery to to 2A
# In the output of `framework_tool --power -vv` above you can se "Design Capacity"
# Dividing that by 1h gives you the maximum charging current (1C)
# For example Design Capacity:  3915 mAh => 3915mA
> sudo framework_tool --charge-current-limit 2000

# And then plug in a power adapter
> sudo framework_tool --power
Charger Status
  AC is:            connected
  Charger Voltage:  17800mV
  Charger Current:  2000mA
                    0.51C
  Chg Input Current:3084mA
  Battery SoC:      87%
Battery Status
  AC is:            connected
  Battery is:       connected
  Battery LFCC:     3713 mAh (Last Full Charge Capacity)
  Battery Capacity: 3215 mAh
                    56.953 Wh
  Charge level:     86%
  Battery charging

# Remove limit (set rate to 1C)
> sudo framework_tool --charge-rate-limit 1

# Back to normal
> sudo framework_tool --power
Charger Status
  AC is:            connected
  Charger Voltage:  17800mV
  Charger Current:  2740mA
                    0.70C
  Chg Input Current:3084mA
  Battery SoC:      92%
Battery Status
  AC is:            connected
  Battery is:       connected
  Battery LFCC:     3713 mAh (Last Full Charge Capacity)
  Battery Capacity: 3387 mAh
                    60.146 Wh
  Charge level:     91%
  Battery charging

# Set charge rate/current limit only if battery is >80% charged
> sudo framework_tool --charge-rate-limit 0.8 80
> sudo framework_tool --charge-current-limit 2000 80
```

## EC Console

```
# Get recent EC console logs and watch for more
> framework_tool.exe --console follow
[53694.741000 Battery 62% (Display 61.1 %) / 3h:18 to empty]
[53715.010000 Battery 62% (Display 61.0 %) / 3h:21 to empty]
[53734.281200 Battery 62% (Display 60.9 %) / 3h:18 to empty]
[53738.037200 Battery 61% (Display 60.9 %) / 3h:6 to empty]
[53752.301500 Battery 61% (Display 60.8 %) / 3h:15 to empty]
```

## Keyboard backlight

```
# Check current keyboard backlight brightness
> framework_tool.exe --kblight
Keyboard backlight: 5%

# Set keyboard backlight brightness
# Off
> framework_tool.exe --kblight 0
# 20%
> framework_tool.exe --kblight 20
```

## Fingerprint/Powerbutton brightness

On Framework 13 and Framework 16 the power button has an integrated fingerprint reader, hence the name.
On Framework 12 it does not, but the same command can be used.

```
# Check the current brightness
> framework_tool --fp-brightness
Fingerprint LED Brightness
  Requested:  Auto
  Brightness: 55%

# Set it to a custom perfentage
> framework_tool --fp-brightness 42
Fingerprint LED Brightness
  Requested:  Custom
  Brightness: 42%

# Set to a specific level (like the BIOS setting does)
> framework_tool --fp-led-level high
Fingerprint LED Brightness
  Requested:  High
  Brightness: 55%

# Set it back to auto
> framework_tool --fp-led-level auto
Fingerprint LED Brightness
  Requested:  Auto
  Brightness: 15%
```

## RGB LED (Framework Desktop)

```
# To set three LEDs to red, green, blue
sudo framework_tool --rgbkbd 0 0xFF0000 0x00FF00 0x0000FF

# To clear 8 LEDs
sudo framework_tool --rgbkbd 0 0 0 0 0 0 0 0 0

# Just turn the 3rd LED red
sudo framework_tool --rgbkbd 2 0xFF0000
```

## Stylus (Framework 12)

```
> sudo framework_tool --stylus-battery
Stylus Battery Strength: 77%
```

## Remap keyboard

Note that the keyboard matrix on Framework 12 and Framework 13 are
different.
The scancodes are the same.

- Left-Ctrl 0x0014
- Left-Alt 0x0014
- Tab 0x0058

### Framework 12

```
# Remap capslock key as left-ctrl
> framework_tool --remap-key 6 15 0x0014

# Swap left-ctrl and alt
> framework_tool --remap-key 1 14 0x0011
> framework_tool --remap-key 6 13 0x0014
```

### Framework 13

```
# Remap capslock key as left-ctrl
> framework_tool --remap-key 4 4 0x0014

# Swap left-ctrl and alt
> framework_tool --remap-key 1 12 0x0011
> framework_tool --remap-key 1 3 0x0014
```

### Framework 16

It's not controlled by the EC, use https://keyboard.frame.work.

## Advanced commands

Mostly for debugging firmware.

See [EXAMPLES_ADVANCED.md](EXAMPLES_ADVANCED.md)
