#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1631
#define LARGE_STATE_COUNT 6
#define SYMBOL_COUNT 271
#define ALIAS_COUNT 1
#define TOKEN_COUNT 95
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 32
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 77

enum {
  sym_module_comment = 1,
  sym_statement_comment = 2,
  sym_comment = 3,
  anon_sym_if = 4,
  anon_sym_LBRACE = 5,
  anon_sym_RBRACE = 6,
  anon_sym_erlang = 7,
  anon_sym_javascript = 8,
  anon_sym_AT = 9,
  anon_sym_LPAREN = 10,
  anon_sym_COMMA = 11,
  anon_sym_RPAREN = 12,
  anon_sym_COLON = 13,
  anon_sym_import = 14,
  anon_sym_DOT = 15,
  anon_sym_as = 16,
  anon_sym_SLASH = 17,
  anon_sym_type = 18,
  anon_sym_const = 19,
  anon_sym_EQ = 20,
  anon_sym_POUND = 21,
  anon_sym_LBRACK = 22,
  anon_sym_RBRACK = 23,
  anon_sym_LT_LT = 24,
  anon_sym_GT_GT = 25,
  anon_sym_DASH = 26,
  anon_sym_size = 27,
  anon_sym_fn = 28,
  anon_sym_DASH_GT = 29,
  anon_sym_external = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_AMP_AMP = 32,
  anon_sym_EQ_EQ = 33,
  anon_sym_BANG_EQ = 34,
  anon_sym_LT = 35,
  anon_sym_LT_EQ = 36,
  anon_sym_LT_DOT = 37,
  anon_sym_LT_EQ_DOT = 38,
  anon_sym_GT = 39,
  anon_sym_GT_EQ = 40,
  anon_sym_GT_DOT = 41,
  anon_sym_GT_EQ_DOT = 42,
  anon_sym_PIPE_GT = 43,
  anon_sym_PLUS = 44,
  anon_sym_PLUS_DOT = 45,
  anon_sym_DASH_DOT = 46,
  anon_sym_STAR = 47,
  anon_sym_STAR_DOT = 48,
  anon_sym_SLASH_DOT = 49,
  anon_sym_PERCENT = 50,
  anon_sym_LT_GT = 51,
  anon_sym_todo = 52,
  anon_sym_panic = 53,
  anon_sym_DOT_DOT = 54,
  anon_sym_case = 55,
  anon_sym_PIPE = 56,
  anon_sym_let = 57,
  anon_sym_assert = 58,
  anon_sym_use = 59,
  anon_sym_LT_DASH = 60,
  anon_sym_BANG = 61,
  sym_visibility_modifier = 62,
  sym_opacity_modifier = 63,
  anon_sym_DQUOTE = 64,
  anon_sym_DQUOTE2 = 65,
  aux_sym_escape_sequence_token1 = 66,
  aux_sym_escape_sequence_token2 = 67,
  sym_float = 68,
  sym__hex = 69,
  sym__decimal = 70,
  sym__octal = 71,
  sym__binary = 72,
  anon_sym_binary = 73,
  anon_sym_bytes = 74,
  anon_sym_int = 75,
  anon_sym_float = 76,
  anon_sym_bit_string = 77,
  anon_sym_bits = 78,
  anon_sym_utf8 = 79,
  anon_sym_utf16 = 80,
  anon_sym_utf32 = 81,
  anon_sym_utf8_codepoint = 82,
  anon_sym_utf16_codepoint = 83,
  anon_sym_utf32_codepoint = 84,
  anon_sym_signed = 85,
  anon_sym_unsigned = 86,
  anon_sym_big = 87,
  anon_sym_little = 88,
  anon_sym_native = 89,
  anon_sym_unit = 90,
  sym__discard_name = 91,
  sym__name = 92,
  sym__upname = 93,
  sym_quoted_content = 94,
  sym_source_file = 95,
  sym__module_statement = 96,
  sym_target_group = 97,
  sym_target = 98,
  sym_attribute = 99,
  sym__attribute_arguments = 100,
  sym_attribute_value = 101,
  sym_import = 102,
  sym_module = 103,
  sym_unqualified_imports = 104,
  sym_unqualified_import = 105,
  sym_constant = 106,
  sym__constant_value = 107,
  sym_constant_tuple = 108,
  sym_constant_list = 109,
  sym__constant_bit_string = 110,
  sym_constant_bit_string_segment = 111,
  sym_constant_bit_string_segment_options = 112,
  sym__constant_bit_string_segment_option = 113,
  sym__constant_bit_string_named_segment_option = 114,
  sym__constant_bit_string_segment_option_size = 115,
  sym_constant_record = 116,
  sym_constant_record_arguments = 117,
  sym_constant_record_argument = 118,
  sym_constant_field_access = 119,
  sym__constant_type = 120,
  sym__constant_type_annotation = 121,
  sym_constant_tuple_type = 122,
  sym_constant_function_type = 123,
  sym_constant_function_parameter_types = 124,
  sym_constant_type = 125,
  sym_constant_type_arguments = 126,
  sym_constant_type_argument = 127,
  sym_external_type = 128,
  sym_external_function = 129,
  sym_external_function_parameters = 130,
  sym_external_function_parameter = 131,
  sym_external_function_body = 132,
  sym_function = 133,
  sym_function_parameters = 134,
  sym_function_parameter = 135,
  sym__labeled_discard_param = 136,
  sym__discard_param = 137,
  sym__labeled_name_param = 138,
  sym__name_param = 139,
  aux_sym__statement_seq = 140,
  sym__statement = 141,
  sym__expression = 142,
  sym_binary_expression = 143,
  sym__expression_unit = 144,
  sym_record = 145,
  sym_todo = 146,
  sym_panic = 147,
  sym_tuple = 148,
  sym_list = 149,
  sym__expression_bit_string = 150,
  sym_expression_bit_string_segment = 151,
  sym_expression_bit_string_segment_options = 152,
  sym__expression_bit_string_segment_option = 153,
  sym__expression_bit_string_named_segment_option = 154,
  sym__expression_bit_string_segment_option_size = 155,
  sym_anonymous_function = 156,
  sym_anonymous_function_parameters = 157,
  sym_anonymous_function_parameter = 158,
  sym_block = 159,
  sym_case = 160,
  sym_case_subjects = 161,
  sym_case_clauses = 162,
  sym_case_clause = 163,
  sym_case_clause_patterns = 164,
  sym_case_clause_pattern = 165,
  sym_case_clause_guard = 166,
  sym__case_clause_guard_expression = 167,
  sym__case_clause_guard_binary_expression = 168,
  sym__case_clause_guard_unit = 169,
  sym__case_clause_tuple_access = 170,
  sym_let_assert = 171,
  sym_let = 172,
  sym_use = 173,
  sym_use_assignments = 174,
  sym_use_assignment = 175,
  sym_assert = 176,
  sym_boolean_negation = 177,
  sym_integer_negation = 178,
  sym__assignment = 179,
  sym_record_update = 180,
  sym_record_update_arguments = 181,
  sym_record_update_argument = 182,
  sym__maybe_tuple_expression = 183,
  sym_tuple_access = 184,
  sym__maybe_record_expression = 185,
  sym_field_access = 186,
  sym__maybe_function_expression = 187,
  sym_arguments = 188,
  sym_argument = 189,
  sym_hole = 190,
  sym_function_call = 191,
  sym__pattern_expression = 192,
  sym__pattern_binary_expression = 193,
  sym__pattern = 194,
  sym_record_pattern = 195,
  sym_record_pattern_arguments = 196,
  sym_record_pattern_argument = 197,
  sym_pattern_spread = 198,
  sym_tuple_pattern = 199,
  sym__pattern_bit_string = 200,
  sym_pattern_bit_string_segment = 201,
  sym_pattern_bit_string_segment_options = 202,
  sym__pattern_bit_string_segment_option = 203,
  sym__pattern_bit_string_named_segment_option = 204,
  sym__pattern_bit_string_segment_option_size = 205,
  sym__pattern_bit_string_segment_argument = 206,
  sym_list_pattern = 207,
  sym_list_pattern_tail = 208,
  sym_type_definition = 209,
  sym_data_constructors = 210,
  sym_data_constructor = 211,
  sym_data_constructor_arguments = 212,
  sym_data_constructor_argument = 213,
  sym_type_alias = 214,
  sym_string = 215,
  sym_escape_sequence = 216,
  sym_integer = 217,
  sym__bit_string_segment_option = 218,
  sym__type = 219,
  sym__type_annotation = 220,
  sym_type_hole = 221,
  sym_tuple_type = 222,
  sym_function_type = 223,
  sym_function_parameter_types = 224,
  sym_type = 225,
  sym_type_arguments = 226,
  sym_type_argument = 227,
  sym_type_var = 228,
  sym_type_name = 229,
  sym_type_parameters = 230,
  sym_type_parameter = 231,
  sym_identifier = 232,
  sym_label = 233,
  sym_discard = 234,
  sym_type_identifier = 235,
  sym_remote_type_identifier = 236,
  sym_constructor_name = 237,
  sym_remote_constructor_name = 238,
  aux_sym_source_file_repeat1 = 239,
  aux_sym_target_group_repeat1 = 240,
  aux_sym__attribute_arguments_repeat1 = 241,
  aux_sym_module_repeat1 = 242,
  aux_sym_unqualified_imports_repeat1 = 243,
  aux_sym_constant_tuple_repeat1 = 244,
  aux_sym__constant_bit_string_repeat1 = 245,
  aux_sym_constant_bit_string_segment_options_repeat1 = 246,
  aux_sym_constant_record_arguments_repeat1 = 247,
  aux_sym_constant_tuple_type_repeat1 = 248,
  aux_sym_constant_type_arguments_repeat1 = 249,
  aux_sym_external_function_parameters_repeat1 = 250,
  aux_sym_function_parameters_repeat1 = 251,
  aux_sym_tuple_repeat1 = 252,
  aux_sym__expression_bit_string_repeat1 = 253,
  aux_sym_expression_bit_string_segment_options_repeat1 = 254,
  aux_sym_anonymous_function_parameters_repeat1 = 255,
  aux_sym_case_clauses_repeat1 = 256,
  aux_sym_case_clause_patterns_repeat1 = 257,
  aux_sym_case_clause_pattern_repeat1 = 258,
  aux_sym_use_assignments_repeat1 = 259,
  aux_sym_record_update_arguments_repeat1 = 260,
  aux_sym_arguments_repeat1 = 261,
  aux_sym_record_pattern_arguments_repeat1 = 262,
  aux_sym__pattern_bit_string_repeat1 = 263,
  aux_sym_pattern_bit_string_segment_options_repeat1 = 264,
  aux_sym_data_constructors_repeat1 = 265,
  aux_sym_data_constructor_arguments_repeat1 = 266,
  aux_sym_string_repeat1 = 267,
  aux_sym_tuple_type_repeat1 = 268,
  aux_sym_type_arguments_repeat1 = 269,
  aux_sym_type_parameters_repeat1 = 270,
  alias_sym_function_body = 271,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_module_comment] = "module_comment",
  [sym_statement_comment] = "statement_comment",
  [sym_comment] = "comment",
  [anon_sym_if] = "if",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_erlang] = "erlang",
  [anon_sym_javascript] = "javascript",
  [anon_sym_AT] = "@",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COLON] = ":",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_as] = "as",
  [anon_sym_SLASH] = "/",
  [anon_sym_type] = "type",
  [anon_sym_const] = "const",
  [anon_sym_EQ] = "=",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_DASH] = "-",
  [anon_sym_size] = "size",
  [anon_sym_fn] = "fn",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_external] = "external",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT_DOT] = "<.",
  [anon_sym_LT_EQ_DOT] = "<=.",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT_DOT] = ">.",
  [anon_sym_GT_EQ_DOT] = ">=.",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_PLUS] = "+",
  [anon_sym_PLUS_DOT] = "+.",
  [anon_sym_DASH_DOT] = "-.",
  [anon_sym_STAR] = "*",
  [anon_sym_STAR_DOT] = "*.",
  [anon_sym_SLASH_DOT] = "/.",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_todo] = "todo",
  [anon_sym_panic] = "panic",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_case] = "case",
  [anon_sym_PIPE] = "|",
  [anon_sym_let] = "let",
  [anon_sym_assert] = "assert",
  [anon_sym_use] = "use",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_BANG] = "!",
  [sym_visibility_modifier] = "visibility_modifier",
  [sym_opacity_modifier] = "opacity_modifier",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE2] = "\"",
  [aux_sym_escape_sequence_token1] = "escape_sequence_token1",
  [aux_sym_escape_sequence_token2] = "escape_sequence_token2",
  [sym_float] = "float",
  [sym__hex] = "_hex",
  [sym__decimal] = "_decimal",
  [sym__octal] = "_octal",
  [sym__binary] = "_binary",
  [anon_sym_binary] = "binary",
  [anon_sym_bytes] = "bytes",
  [anon_sym_int] = "int",
  [anon_sym_float] = "float",
  [anon_sym_bit_string] = "bit_string",
  [anon_sym_bits] = "bits",
  [anon_sym_utf8] = "utf8",
  [anon_sym_utf16] = "utf16",
  [anon_sym_utf32] = "utf32",
  [anon_sym_utf8_codepoint] = "utf8_codepoint",
  [anon_sym_utf16_codepoint] = "utf16_codepoint",
  [anon_sym_utf32_codepoint] = "utf32_codepoint",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_big] = "big",
  [anon_sym_little] = "little",
  [anon_sym_native] = "native",
  [anon_sym_unit] = "unit",
  [sym__discard_name] = "_discard_name",
  [sym__name] = "_name",
  [sym__upname] = "_upname",
  [sym_quoted_content] = "quoted_content",
  [sym_source_file] = "source_file",
  [sym__module_statement] = "_module_statement",
  [sym_target_group] = "target_group",
  [sym_target] = "target",
  [sym_attribute] = "attribute",
  [sym__attribute_arguments] = "arguments",
  [sym_attribute_value] = "attribute_value",
  [sym_import] = "import",
  [sym_module] = "module",
  [sym_unqualified_imports] = "unqualified_imports",
  [sym_unqualified_import] = "unqualified_import",
  [sym_constant] = "constant",
  [sym__constant_value] = "_constant_value",
  [sym_constant_tuple] = "tuple",
  [sym_constant_list] = "list",
  [sym__constant_bit_string] = "bit_string",
  [sym_constant_bit_string_segment] = "bit_string_segment",
  [sym_constant_bit_string_segment_options] = "bit_string_segment_options",
  [sym__constant_bit_string_segment_option] = "_constant_bit_string_segment_option",
  [sym__constant_bit_string_named_segment_option] = "_constant_bit_string_named_segment_option",
  [sym__constant_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_constant_record] = "record",
  [sym_constant_record_arguments] = "arguments",
  [sym_constant_record_argument] = "argument",
  [sym_constant_field_access] = "field_access",
  [sym__constant_type] = "_constant_type",
  [sym__constant_type_annotation] = "_constant_type_annotation",
  [sym_constant_tuple_type] = "tuple_type",
  [sym_constant_function_type] = "function_type",
  [sym_constant_function_parameter_types] = "function_parameter_types",
  [sym_constant_type] = "type",
  [sym_constant_type_arguments] = "type_arguments",
  [sym_constant_type_argument] = "type_argument",
  [sym_external_type] = "external_type",
  [sym_external_function] = "external_function",
  [sym_external_function_parameters] = "function_parameters",
  [sym_external_function_parameter] = "function_parameter",
  [sym_external_function_body] = "external_function_body",
  [sym_function] = "function",
  [sym_function_parameters] = "function_parameters",
  [sym_function_parameter] = "function_parameter",
  [sym__labeled_discard_param] = "_labeled_discard_param",
  [sym__discard_param] = "_discard_param",
  [sym__labeled_name_param] = "_labeled_name_param",
  [sym__name_param] = "_name_param",
  [aux_sym__statement_seq] = "_statement_seq",
  [sym__statement] = "_statement",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__expression_unit] = "_expression_unit",
  [sym_record] = "record",
  [sym_todo] = "todo",
  [sym_panic] = "panic",
  [sym_tuple] = "tuple",
  [sym_list] = "list",
  [sym__expression_bit_string] = "bit_string",
  [sym_expression_bit_string_segment] = "bit_string_segment",
  [sym_expression_bit_string_segment_options] = "bit_string_segment_options",
  [sym__expression_bit_string_segment_option] = "_expression_bit_string_segment_option",
  [sym__expression_bit_string_named_segment_option] = "_expression_bit_string_named_segment_option",
  [sym__expression_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_anonymous_function] = "anonymous_function",
  [sym_anonymous_function_parameters] = "function_parameters",
  [sym_anonymous_function_parameter] = "function_parameter",
  [sym_block] = "block",
  [sym_case] = "case",
  [sym_case_subjects] = "case_subjects",
  [sym_case_clauses] = "case_clauses",
  [sym_case_clause] = "case_clause",
  [sym_case_clause_patterns] = "case_clause_patterns",
  [sym_case_clause_pattern] = "case_clause_pattern",
  [sym_case_clause_guard] = "case_clause_guard",
  [sym__case_clause_guard_expression] = "_case_clause_guard_expression",
  [sym__case_clause_guard_binary_expression] = "binary_expression",
  [sym__case_clause_guard_unit] = "_case_clause_guard_unit",
  [sym__case_clause_tuple_access] = "tuple_access",
  [sym_let_assert] = "let_assert",
  [sym_let] = "let",
  [sym_use] = "use",
  [sym_use_assignments] = "use_assignments",
  [sym_use_assignment] = "use_assignment",
  [sym_assert] = "assert",
  [sym_boolean_negation] = "boolean_negation",
  [sym_integer_negation] = "integer_negation",
  [sym__assignment] = "_assignment",
  [sym_record_update] = "record_update",
  [sym_record_update_arguments] = "record_update_arguments",
  [sym_record_update_argument] = "record_update_argument",
  [sym__maybe_tuple_expression] = "_maybe_tuple_expression",
  [sym_tuple_access] = "tuple_access",
  [sym__maybe_record_expression] = "_maybe_record_expression",
  [sym_field_access] = "field_access",
  [sym__maybe_function_expression] = "_maybe_function_expression",
  [sym_arguments] = "arguments",
  [sym_argument] = "argument",
  [sym_hole] = "hole",
  [sym_function_call] = "function_call",
  [sym__pattern_expression] = "_pattern_expression",
  [sym__pattern_binary_expression] = "binary_expression",
  [sym__pattern] = "_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym_record_pattern_arguments] = "record_pattern_arguments",
  [sym_record_pattern_argument] = "record_pattern_argument",
  [sym_pattern_spread] = "pattern_spread",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym__pattern_bit_string] = "bit_string_pattern",
  [sym_pattern_bit_string_segment] = "bit_string_segment",
  [sym_pattern_bit_string_segment_options] = "bit_string_segment_options",
  [sym__pattern_bit_string_segment_option] = "_pattern_bit_string_segment_option",
  [sym__pattern_bit_string_named_segment_option] = "_pattern_bit_string_named_segment_option",
  [sym__pattern_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym__pattern_bit_string_segment_argument] = "_pattern_bit_string_segment_argument",
  [sym_list_pattern] = "list_pattern",
  [sym_list_pattern_tail] = "list_pattern_tail",
  [sym_type_definition] = "type_definition",
  [sym_data_constructors] = "data_constructors",
  [sym_data_constructor] = "data_constructor",
  [sym_data_constructor_arguments] = "data_constructor_arguments",
  [sym_data_constructor_argument] = "data_constructor_argument",
  [sym_type_alias] = "type_alias",
  [sym_string] = "string",
  [sym_escape_sequence] = "escape_sequence",
  [sym_integer] = "integer",
  [sym__bit_string_segment_option] = "bit_string_segment_option",
  [sym__type] = "_type",
  [sym__type_annotation] = "_type_annotation",
  [sym_type_hole] = "type_hole",
  [sym_tuple_type] = "tuple_type",
  [sym_function_type] = "function_type",
  [sym_function_parameter_types] = "function_parameter_types",
  [sym_type] = "type",
  [sym_type_arguments] = "type_arguments",
  [sym_type_argument] = "type_argument",
  [sym_type_var] = "type_var",
  [sym_type_name] = "type_name",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_identifier] = "identifier",
  [sym_label] = "label",
  [sym_discard] = "discard",
  [sym_type_identifier] = "type_identifier",
  [sym_remote_type_identifier] = "remote_type_identifier",
  [sym_constructor_name] = "constructor_name",
  [sym_remote_constructor_name] = "remote_constructor_name",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_target_group_repeat1] = "target_group_repeat1",
  [aux_sym__attribute_arguments_repeat1] = "_attribute_arguments_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_unqualified_imports_repeat1] = "unqualified_imports_repeat1",
  [aux_sym_constant_tuple_repeat1] = "constant_tuple_repeat1",
  [aux_sym__constant_bit_string_repeat1] = "_constant_bit_string_repeat1",
  [aux_sym_constant_bit_string_segment_options_repeat1] = "constant_bit_string_segment_options_repeat1",
  [aux_sym_constant_record_arguments_repeat1] = "constant_record_arguments_repeat1",
  [aux_sym_constant_tuple_type_repeat1] = "constant_tuple_type_repeat1",
  [aux_sym_constant_type_arguments_repeat1] = "constant_type_arguments_repeat1",
  [aux_sym_external_function_parameters_repeat1] = "external_function_parameters_repeat1",
  [aux_sym_function_parameters_repeat1] = "function_parameters_repeat1",
  [aux_sym_tuple_repeat1] = "tuple_repeat1",
  [aux_sym__expression_bit_string_repeat1] = "_expression_bit_string_repeat1",
  [aux_sym_expression_bit_string_segment_options_repeat1] = "expression_bit_string_segment_options_repeat1",
  [aux_sym_anonymous_function_parameters_repeat1] = "anonymous_function_parameters_repeat1",
  [aux_sym_case_clauses_repeat1] = "case_clauses_repeat1",
  [aux_sym_case_clause_patterns_repeat1] = "case_clause_patterns_repeat1",
  [aux_sym_case_clause_pattern_repeat1] = "case_clause_pattern_repeat1",
  [aux_sym_use_assignments_repeat1] = "use_assignments_repeat1",
  [aux_sym_record_update_arguments_repeat1] = "record_update_arguments_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_record_pattern_arguments_repeat1] = "record_pattern_arguments_repeat1",
  [aux_sym__pattern_bit_string_repeat1] = "_pattern_bit_string_repeat1",
  [aux_sym_pattern_bit_string_segment_options_repeat1] = "pattern_bit_string_segment_options_repeat1",
  [aux_sym_data_constructors_repeat1] = "data_constructors_repeat1",
  [aux_sym_data_constructor_arguments_repeat1] = "data_constructor_arguments_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [alias_sym_function_body] = "function_body",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_module_comment] = sym_module_comment,
  [sym_statement_comment] = sym_statement_comment,
  [sym_comment] = sym_comment,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_erlang] = anon_sym_erlang,
  [anon_sym_javascript] = anon_sym_javascript,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_size] = anon_sym_size,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT_DOT] = anon_sym_LT_DOT,
  [anon_sym_LT_EQ_DOT] = anon_sym_LT_EQ_DOT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT_DOT] = anon_sym_GT_DOT,
  [anon_sym_GT_EQ_DOT] = anon_sym_GT_EQ_DOT,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PLUS_DOT] = anon_sym_PLUS_DOT,
  [anon_sym_DASH_DOT] = anon_sym_DASH_DOT,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_STAR_DOT] = anon_sym_STAR_DOT,
  [anon_sym_SLASH_DOT] = anon_sym_SLASH_DOT,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_todo] = anon_sym_todo,
  [anon_sym_panic] = anon_sym_panic,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [sym_visibility_modifier] = sym_visibility_modifier,
  [sym_opacity_modifier] = sym_opacity_modifier,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [aux_sym_escape_sequence_token1] = aux_sym_escape_sequence_token1,
  [aux_sym_escape_sequence_token2] = aux_sym_escape_sequence_token2,
  [sym_float] = sym_float,
  [sym__hex] = sym__hex,
  [sym__decimal] = sym__decimal,
  [sym__octal] = sym__octal,
  [sym__binary] = sym__binary,
  [anon_sym_binary] = anon_sym_binary,
  [anon_sym_bytes] = anon_sym_bytes,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_bit_string] = anon_sym_bit_string,
  [anon_sym_bits] = anon_sym_bits,
  [anon_sym_utf8] = anon_sym_utf8,
  [anon_sym_utf16] = anon_sym_utf16,
  [anon_sym_utf32] = anon_sym_utf32,
  [anon_sym_utf8_codepoint] = anon_sym_utf8_codepoint,
  [anon_sym_utf16_codepoint] = anon_sym_utf16_codepoint,
  [anon_sym_utf32_codepoint] = anon_sym_utf32_codepoint,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_big] = anon_sym_big,
  [anon_sym_little] = anon_sym_little,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_unit] = anon_sym_unit,
  [sym__discard_name] = sym__discard_name,
  [sym__name] = sym__name,
  [sym__upname] = sym__upname,
  [sym_quoted_content] = sym_quoted_content,
  [sym_source_file] = sym_source_file,
  [sym__module_statement] = sym__module_statement,
  [sym_target_group] = sym_target_group,
  [sym_target] = sym_target,
  [sym_attribute] = sym_attribute,
  [sym__attribute_arguments] = sym_arguments,
  [sym_attribute_value] = sym_attribute_value,
  [sym_import] = sym_import,
  [sym_module] = sym_module,
  [sym_unqualified_imports] = sym_unqualified_imports,
  [sym_unqualified_import] = sym_unqualified_import,
  [sym_constant] = sym_constant,
  [sym__constant_value] = sym__constant_value,
  [sym_constant_tuple] = sym_tuple,
  [sym_constant_list] = sym_list,
  [sym__constant_bit_string] = sym__constant_bit_string,
  [sym_constant_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_constant_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__constant_bit_string_segment_option] = sym__constant_bit_string_segment_option,
  [sym__constant_bit_string_named_segment_option] = sym__constant_bit_string_named_segment_option,
  [sym__constant_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_constant_record] = sym_record,
  [sym_constant_record_arguments] = sym_arguments,
  [sym_constant_record_argument] = sym_argument,
  [sym_constant_field_access] = sym_field_access,
  [sym__constant_type] = sym__constant_type,
  [sym__constant_type_annotation] = sym__constant_type_annotation,
  [sym_constant_tuple_type] = sym_tuple_type,
  [sym_constant_function_type] = sym_function_type,
  [sym_constant_function_parameter_types] = sym_function_parameter_types,
  [sym_constant_type] = sym_type,
  [sym_constant_type_arguments] = sym_type_arguments,
  [sym_constant_type_argument] = sym_type_argument,
  [sym_external_type] = sym_external_type,
  [sym_external_function] = sym_external_function,
  [sym_external_function_parameters] = sym_function_parameters,
  [sym_external_function_parameter] = sym_function_parameter,
  [sym_external_function_body] = sym_external_function_body,
  [sym_function] = sym_function,
  [sym_function_parameters] = sym_function_parameters,
  [sym_function_parameter] = sym_function_parameter,
  [sym__labeled_discard_param] = sym__labeled_discard_param,
  [sym__discard_param] = sym__discard_param,
  [sym__labeled_name_param] = sym__labeled_name_param,
  [sym__name_param] = sym__name_param,
  [aux_sym__statement_seq] = aux_sym__statement_seq,
  [sym__statement] = sym__statement,
  [sym__expression] = sym__expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__expression_unit] = sym__expression_unit,
  [sym_record] = sym_record,
  [sym_todo] = sym_todo,
  [sym_panic] = sym_panic,
  [sym_tuple] = sym_tuple,
  [sym_list] = sym_list,
  [sym__expression_bit_string] = sym__constant_bit_string,
  [sym_expression_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_expression_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__expression_bit_string_segment_option] = sym__expression_bit_string_segment_option,
  [sym__expression_bit_string_named_segment_option] = sym__expression_bit_string_named_segment_option,
  [sym__expression_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_anonymous_function] = sym_anonymous_function,
  [sym_anonymous_function_parameters] = sym_function_parameters,
  [sym_anonymous_function_parameter] = sym_function_parameter,
  [sym_block] = sym_block,
  [sym_case] = sym_case,
  [sym_case_subjects] = sym_case_subjects,
  [sym_case_clauses] = sym_case_clauses,
  [sym_case_clause] = sym_case_clause,
  [sym_case_clause_patterns] = sym_case_clause_patterns,
  [sym_case_clause_pattern] = sym_case_clause_pattern,
  [sym_case_clause_guard] = sym_case_clause_guard,
  [sym__case_clause_guard_expression] = sym__case_clause_guard_expression,
  [sym__case_clause_guard_binary_expression] = sym_binary_expression,
  [sym__case_clause_guard_unit] = sym__case_clause_guard_unit,
  [sym__case_clause_tuple_access] = sym_tuple_access,
  [sym_let_assert] = sym_let_assert,
  [sym_let] = sym_let,
  [sym_use] = sym_use,
  [sym_use_assignments] = sym_use_assignments,
  [sym_use_assignment] = sym_use_assignment,
  [sym_assert] = sym_assert,
  [sym_boolean_negation] = sym_boolean_negation,
  [sym_integer_negation] = sym_integer_negation,
  [sym__assignment] = sym__assignment,
  [sym_record_update] = sym_record_update,
  [sym_record_update_arguments] = sym_record_update_arguments,
  [sym_record_update_argument] = sym_record_update_argument,
  [sym__maybe_tuple_expression] = sym__maybe_tuple_expression,
  [sym_tuple_access] = sym_tuple_access,
  [sym__maybe_record_expression] = sym__maybe_record_expression,
  [sym_field_access] = sym_field_access,
  [sym__maybe_function_expression] = sym__maybe_function_expression,
  [sym_arguments] = sym_arguments,
  [sym_argument] = sym_argument,
  [sym_hole] = sym_hole,
  [sym_function_call] = sym_function_call,
  [sym__pattern_expression] = sym__pattern_expression,
  [sym__pattern_binary_expression] = sym_binary_expression,
  [sym__pattern] = sym__pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym_record_pattern_arguments] = sym_record_pattern_arguments,
  [sym_record_pattern_argument] = sym_record_pattern_argument,
  [sym_pattern_spread] = sym_pattern_spread,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym__pattern_bit_string] = sym__pattern_bit_string,
  [sym_pattern_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_pattern_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__pattern_bit_string_segment_option] = sym__pattern_bit_string_segment_option,
  [sym__pattern_bit_string_named_segment_option] = sym__pattern_bit_string_named_segment_option,
  [sym__pattern_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym__pattern_bit_string_segment_argument] = sym__pattern_bit_string_segment_argument,
  [sym_list_pattern] = sym_list_pattern,
  [sym_list_pattern_tail] = sym_list_pattern_tail,
  [sym_type_definition] = sym_type_definition,
  [sym_data_constructors] = sym_data_constructors,
  [sym_data_constructor] = sym_data_constructor,
  [sym_data_constructor_arguments] = sym_data_constructor_arguments,
  [sym_data_constructor_argument] = sym_data_constructor_argument,
  [sym_type_alias] = sym_type_alias,
  [sym_string] = sym_string,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_integer] = sym_integer,
  [sym__bit_string_segment_option] = sym__constant_bit_string_segment_option_size,
  [sym__type] = sym__type,
  [sym__type_annotation] = sym__type_annotation,
  [sym_type_hole] = sym_type_hole,
  [sym_tuple_type] = sym_tuple_type,
  [sym_function_type] = sym_function_type,
  [sym_function_parameter_types] = sym_function_parameter_types,
  [sym_type] = sym_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_type_argument] = sym_type_argument,
  [sym_type_var] = sym_type_var,
  [sym_type_name] = sym_type_name,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_identifier] = sym_identifier,
  [sym_label] = sym_label,
  [sym_discard] = sym_discard,
  [sym_type_identifier] = sym_type_identifier,
  [sym_remote_type_identifier] = sym_remote_type_identifier,
  [sym_constructor_name] = sym_constructor_name,
  [sym_remote_constructor_name] = sym_remote_constructor_name,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_target_group_repeat1] = aux_sym_target_group_repeat1,
  [aux_sym__attribute_arguments_repeat1] = aux_sym__attribute_arguments_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_unqualified_imports_repeat1] = aux_sym_unqualified_imports_repeat1,
  [aux_sym_constant_tuple_repeat1] = aux_sym_constant_tuple_repeat1,
  [aux_sym__constant_bit_string_repeat1] = aux_sym__constant_bit_string_repeat1,
  [aux_sym_constant_bit_string_segment_options_repeat1] = aux_sym_constant_bit_string_segment_options_repeat1,
  [aux_sym_constant_record_arguments_repeat1] = aux_sym_constant_record_arguments_repeat1,
  [aux_sym_constant_tuple_type_repeat1] = aux_sym_constant_tuple_type_repeat1,
  [aux_sym_constant_type_arguments_repeat1] = aux_sym_constant_type_arguments_repeat1,
  [aux_sym_external_function_parameters_repeat1] = aux_sym_external_function_parameters_repeat1,
  [aux_sym_function_parameters_repeat1] = aux_sym_function_parameters_repeat1,
  [aux_sym_tuple_repeat1] = aux_sym_tuple_repeat1,
  [aux_sym__expression_bit_string_repeat1] = aux_sym__expression_bit_string_repeat1,
  [aux_sym_expression_bit_string_segment_options_repeat1] = aux_sym_expression_bit_string_segment_options_repeat1,
  [aux_sym_anonymous_function_parameters_repeat1] = aux_sym_anonymous_function_parameters_repeat1,
  [aux_sym_case_clauses_repeat1] = aux_sym_case_clauses_repeat1,
  [aux_sym_case_clause_patterns_repeat1] = aux_sym_case_clause_patterns_repeat1,
  [aux_sym_case_clause_pattern_repeat1] = aux_sym_case_clause_pattern_repeat1,
  [aux_sym_use_assignments_repeat1] = aux_sym_use_assignments_repeat1,
  [aux_sym_record_update_arguments_repeat1] = aux_sym_record_update_arguments_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_record_pattern_arguments_repeat1] = aux_sym_record_pattern_arguments_repeat1,
  [aux_sym__pattern_bit_string_repeat1] = aux_sym__pattern_bit_string_repeat1,
  [aux_sym_pattern_bit_string_segment_options_repeat1] = aux_sym_pattern_bit_string_segment_options_repeat1,
  [aux_sym_data_constructors_repeat1] = aux_sym_data_constructors_repeat1,
  [aux_sym_data_constructor_arguments_repeat1] = aux_sym_data_constructor_arguments_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [alias_sym_function_body] = alias_sym_function_body,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_module_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_erlang] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_javascript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_size] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_todo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_panic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [sym_visibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_opacity_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_escape_sequence_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym__hex] = {
    .visible = false,
    .named = true,
  },
  [sym__decimal] = {
    .visible = false,
    .named = true,
  },
  [sym__octal] = {
    .visible = false,
    .named = true,
  },
  [sym__binary] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_binary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bit_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_big] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_little] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unit] = {
    .visible = true,
    .named = false,
  },
  [sym__discard_name] = {
    .visible = false,
    .named = true,
  },
  [sym__name] = {
    .visible = false,
    .named = true,
  },
  [sym__upname] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_content] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__module_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_target_group] = {
    .visible = true,
    .named = true,
  },
  [sym_target] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_import] = {
    .visible = true,
    .named = true,
  },
  [sym_constant] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_value] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_list] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_type] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_function_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_external_type] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__labeled_discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__labeled_name_param] = {
    .visible = false,
    .named = true,
  },
  [sym__name_param] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__statement_seq] = {
    .visible = false,
    .named = false,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_unit] = {
    .visible = false,
    .named = true,
  },
  [sym_record] = {
    .visible = true,
    .named = true,
  },
  [sym_todo] = {
    .visible = true,
    .named = true,
  },
  [sym_panic] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_subjects] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clauses] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_patterns] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_guard] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_guard_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_unit] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym_let_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_use] = {
    .visible = true,
    .named = true,
  },
  [sym_use_assignments] = {
    .visible = true,
    .named = true,
  },
  [sym_use_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_negation] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_negation] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_record_update] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_tuple_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_record_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_function_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_spread] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern_tail] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructors] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym__bit_string_segment_option] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_type_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_var] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_discard] = {
    .visible = true,
    .named = true,
  },
  [sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_name] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_constructor_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_target_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unqualified_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__constant_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_record_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_external_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anonymous_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_assignments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_update_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pattern_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructor_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_function_body] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_arguments = 2,
  field_assign = 3,
  field_assignments = 4,
  field_body = 5,
  field_clauses = 6,
  field_constructor = 7,
  field_field = 8,
  field_function = 9,
  field_guard = 10,
  field_imports = 11,
  field_index = 12,
  field_label = 13,
  field_left = 14,
  field_message = 15,
  field_module = 16,
  field_name = 17,
  field_operator = 18,
  field_options = 19,
  field_parameter_types = 20,
  field_parameters = 21,
  field_pattern = 22,
  field_patterns = 23,
  field_record = 24,
  field_return_type = 25,
  field_right = 26,
  field_spread = 27,
  field_subjects = 28,
  field_target = 29,
  field_tuple = 30,
  field_type = 31,
  field_value = 32,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_arguments] = "arguments",
  [field_assign] = "assign",
  [field_assignments] = "assignments",
  [field_body] = "body",
  [field_clauses] = "clauses",
  [field_constructor] = "constructor",
  [field_field] = "field",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_imports] = "imports",
  [field_index] = "index",
  [field_label] = "label",
  [field_left] = "left",
  [field_message] = "message",
  [field_module] = "module",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_options] = "options",
  [field_parameter_types] = "parameter_types",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_patterns] = "patterns",
  [field_record] = "record",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_spread] = "spread",
  [field_subjects] = "subjects",
  [field_target] = "target",
  [field_tuple] = "tuple",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 4},
  [6] = {.index = 8, .length = 3},
  [7] = {.index = 11, .length = 1},
  [8] = {.index = 12, .length = 2},
  [9] = {.index = 14, .length = 2},
  [10] = {.index = 16, .length = 2},
  [11] = {.index = 18, .length = 2},
  [12] = {.index = 20, .length = 1},
  [13] = {.index = 21, .length = 2},
  [14] = {.index = 23, .length = 1},
  [15] = {.index = 24, .length = 2},
  [16] = {.index = 26, .length = 4},
  [17] = {.index = 30, .length = 1},
  [18] = {.index = 31, .length = 2},
  [19] = {.index = 33, .length = 3},
  [20] = {.index = 36, .length = 2},
  [21] = {.index = 38, .length = 2},
  [22] = {.index = 40, .length = 2},
  [23] = {.index = 42, .length = 1},
  [24] = {.index = 43, .length = 2},
  [25] = {.index = 45, .length = 2},
  [26] = {.index = 47, .length = 1},
  [27] = {.index = 48, .length = 2},
  [28] = {.index = 50, .length = 3},
  [29] = {.index = 53, .length = 2},
  [30] = {.index = 55, .length = 2},
  [31] = {.index = 57, .length = 1},
  [32] = {.index = 58, .length = 1},
  [33] = {.index = 59, .length = 2},
  [34] = {.index = 61, .length = 3},
  [35] = {.index = 64, .length = 2},
  [36] = {.index = 66, .length = 2},
  [37] = {.index = 68, .length = 2},
  [38] = {.index = 70, .length = 1},
  [39] = {.index = 71, .length = 3},
  [40] = {.index = 74, .length = 1},
  [41] = {.index = 75, .length = 2},
  [42] = {.index = 77, .length = 3},
  [43] = {.index = 80, .length = 2},
  [44] = {.index = 82, .length = 3},
  [45] = {.index = 85, .length = 1},
  [46] = {.index = 86, .length = 2},
  [47] = {.index = 88, .length = 2},
  [48] = {.index = 90, .length = 1},
  [49] = {.index = 91, .length = 2},
  [50] = {.index = 93, .length = 4},
  [51] = {.index = 97, .length = 4},
  [52] = {.index = 101, .length = 2},
  [53] = {.index = 103, .length = 2},
  [54] = {.index = 105, .length = 3},
  [55] = {.index = 108, .length = 1},
  [56] = {.index = 109, .length = 1},
  [57] = {.index = 110, .length = 3},
  [58] = {.index = 113, .length = 2},
  [59] = {.index = 115, .length = 2},
  [60] = {.index = 117, .length = 2},
  [61] = {.index = 119, .length = 3},
  [62] = {.index = 122, .length = 3},
  [63] = {.index = 125, .length = 3},
  [64] = {.index = 128, .length = 2},
  [65] = {.index = 130, .length = 2},
  [66] = {.index = 132, .length = 1},
  [67] = {.index = 133, .length = 3},
  [68] = {.index = 136, .length = 2},
  [69] = {.index = 138, .length = 3},
  [70] = {.index = 141, .length = 3},
  [71] = {.index = 144, .length = 3},
  [72] = {.index = 147, .length = 2},
  [73] = {.index = 149, .length = 4},
  [74] = {.index = 153, .length = 4},
  [75] = {.index = 153, .length = 4},
  [76] = {.index = 157, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_name, 1},
  [2] =
    {field_module, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_assign, 1, .inherited = true},
    {field_pattern, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [8] =
    {field_left, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
    {field_right, 0, .inherited = true},
  [11] =
    {field_assign, 0, .inherited = true},
  [12] =
    {field_arguments, 1},
    {field_function, 0},
  [14] =
    {field_arguments, 1},
    {field_name, 0},
  [16] =
    {field_arguments, 2},
    {field_name, 1},
  [18] =
    {field_name, 0},
    {field_parameters, 1},
  [20] =
    {field_name, 0, .inherited = true},
  [21] =
    {field_name, 1},
    {field_parameters, 2},
  [23] =
    {field_message, 2},
  [24] =
    {field_assign, 0, .inherited = true},
    {field_value, 0},
  [26] =
    {field_assign, 2, .inherited = true},
    {field_pattern, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [30] =
    {field_value, 2},
  [31] =
    {field_assign, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [33] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [36] =
    {field_index, 2},
    {field_tuple, 0},
  [38] =
    {field_field, 2},
    {field_record, 0},
  [40] =
    {field_module, 0},
    {field_name, 2},
  [42] =
    {field_target, 1},
  [43] =
    {field_imports, 3},
    {field_module, 1},
  [45] =
    {field_alias, 3},
    {field_module, 1},
  [47] =
    {field_type, 1},
  [48] =
    {field_name, 1},
    {field_value, 3},
  [50] =
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [53] =
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [55] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [57] =
    {field_subjects, 1},
  [58] =
    {field_assign, 1, .inherited = true},
  [59] =
    {field_assign, 1},
    {field_assign, 2},
  [61] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_value, 2},
  [64] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
  [66] =
    {field_assignments, 1},
    {field_value, 3},
  [68] =
    {field_name, 2},
    {field_parameters, 3},
  [70] =
    {field_label, 0},
  [71] =
    {field_name, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [74] =
    {field_spread, 3},
  [75] =
    {field_body, 3},
    {field_parameters, 1},
  [77] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [80] =
    {field_label, 0},
    {field_name, 1},
  [82] =
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [85] =
    {field_type, 0},
  [86] =
    {field_clauses, 3},
    {field_subjects, 1},
  [88] =
    {field_assign, 0, .inherited = true},
    {field_assign, 1, .inherited = true},
  [90] =
    {field_assign, 2, .inherited = true},
  [91] =
    {field_assign, 1, .inherited = true},
    {field_assign, 2, .inherited = true},
  [93] =
    {field_assign, 0, .inherited = true},
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [97] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_type, 1, .inherited = true},
    {field_value, 3},
  [101] =
    {field_name, 2},
    {field_value, 4},
  [103] =
    {field_label, 0},
    {field_value, 2},
  [105] =
    {field_alias, 5},
    {field_imports, 3},
    {field_module, 1},
  [108] =
    {field_return_type, 2},
  [109] =
    {field_spread, 4},
  [110] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [113] =
    {field_index, 0, .inherited = true},
    {field_tuple, 0, .inherited = true},
  [115] =
    {field_patterns, 0},
    {field_value, 2},
  [117] =
    {field_assign, 2, .inherited = true},
    {field_assign, 3, .inherited = true},
  [119] =
    {field_assign, 2, .inherited = true},
    {field_label, 0},
    {field_pattern, 2},
  [122] =
    {field_name, 2},
    {field_type, 3, .inherited = true},
    {field_value, 5},
  [125] =
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [128] =
    {field_alias, 2},
    {field_name, 0},
  [130] =
    {field_parameter_types, 1},
    {field_return_type, 3},
  [132] =
    {field_spread, 5},
  [133] =
    {field_body, 5},
    {field_parameters, 1},
    {field_return_type, 3},
  [136] =
    {field_name, 0},
    {field_type, 2},
  [138] =
    {field_guard, 1},
    {field_patterns, 0},
    {field_value, 3},
  [141] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [144] =
    {field_arguments, 5},
    {field_constructor, 0},
    {field_spread, 3},
  [147] =
    {field_alias, 3},
    {field_name, 1},
  [149] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [153] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [157] =
    {field_body, 8},
    {field_name, 3},
    {field_parameters, 4},
    {field_return_type, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [41] = {
    [3] = alias_sym_function_body,
  },
  [57] = {
    [4] = alias_sym_function_body,
  },
  [67] = {
    [5] = alias_sym_function_body,
  },
  [70] = {
    [5] = alias_sym_function_body,
  },
  [73] = {
    [6] = alias_sym_function_body,
  },
  [75] = {
    [7] = alias_sym_function_body,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__statement_seq, 2,
    aux_sym__statement_seq,
    alias_sym_function_body,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(174);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(169)
      if (lookahead == '\r') SKIP(169)
      if (lookahead == '!') ADVANCE(260);
      if (lookahead == '"') ADVANCE(266);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(206);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '@') ADVANCE(188);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == '\\') ADVANCE(127);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == '_') ADVANCE(314);
      if (lookahead == 'a') ADVANCE(424);
      if (lookahead == 'b') ADVANCE(371);
      if (lookahead == 'c') ADVANCE(323);
      if (lookahead == 'e') ADVANCE(417);
      if (lookahead == 'f') ADVANCE(382);
      if (lookahead == 'i') ADVANCE(362);
      if (lookahead == 'j') ADVANCE(321);
      if (lookahead == 'l') ADVANCE(354);
      if (lookahead == 'n') ADVANCE(331);
      if (lookahead == 'o') ADVANCE(410);
      if (lookahead == 'p') ADVANCE(325);
      if (lookahead == 's') ADVANCE(372);
      if (lookahead == 't') ADVANCE(398);
      if (lookahead == 'u') ADVANCE(387);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '|') ADVANCE(254);
      if (lookahead == '}') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('d' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 1:
      if (lookahead == '&') ADVANCE(227);
      END_STATE();
    case 2:
      if (lookahead == '-') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(270);
      END_STATE();
    case 3:
      if (lookahead == '-') ADVANCE(258);
      if (lookahead == '<') ADVANCE(210);
      END_STATE();
    case 4:
      if (lookahead == '-') ADVANCE(258);
      if (lookahead == '>') ADVANCE(248);
      END_STATE();
    case 5:
      if (lookahead == '.') ADVANCE(251);
      END_STATE();
    case 6:
      if (lookahead == '.') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '/') ADVANCE(178);
      END_STATE();
    case 8:
      if (lookahead == '1') ADVANCE(10);
      if (lookahead == '3') ADVANCE(9);
      if (lookahead == '8') ADVANCE(290);
      END_STATE();
    case 9:
      if (lookahead == '2') ADVANCE(294);
      END_STATE();
    case 10:
      if (lookahead == '6') ADVANCE(292);
      END_STATE();
    case 11:
      if (lookahead == '<') ADVANCE(210);
      END_STATE();
    case 12:
      if (lookahead == '=') ADVANCE(229);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(228);
      END_STATE();
    case 14:
      if (lookahead == '>') ADVANCE(223);
      END_STATE();
    case 15:
      if (lookahead == '>') ADVANCE(211);
      END_STATE();
    case 16:
      if (lookahead == '>') ADVANCE(240);
      if (lookahead == '|') ADVANCE(226);
      END_STATE();
    case 17:
      if (lookahead == '_') ADVANCE(111);
      if (lookahead == 's') ADVANCE(288);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(102);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(109);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(124);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 26:
      if (lookahead == 'b') ADVANCE(261);
      END_STATE();
    case 27:
      if (lookahead == 'c') ADVANCE(86);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 29:
      if (lookahead == 'c') ADVANCE(91);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(92);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(302);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(304);
      END_STATE();
    case 33:
      if (lookahead == 'd') ADVANCE(45);
      END_STATE();
    case 34:
      if (lookahead == 'd') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 'd') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(201);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(308);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(310);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(263);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(103);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 48:
      if (lookahead == 'f') ADVANCE(8);
      END_STATE();
    case 49:
      if (lookahead == 'f') ADVANCE(180);
      END_STATE();
    case 50:
      if (lookahead == 'f') ADVANCE(180);
      if (lookahead == 'm') ADVANCE(93);
      END_STATE();
    case 51:
      if (lookahead == 'g') ADVANCE(306);
      if (lookahead == 'n') ADVANCE(20);
      if (lookahead == 't') ADVANCE(17);
      END_STATE();
    case 52:
      if (lookahead == 'g') ADVANCE(184);
      END_STATE();
    case 53:
      if (lookahead == 'g') ADVANCE(286);
      END_STATE();
    case 54:
      if (lookahead == 'g') ADVANCE(78);
      if (lookahead == 'z') ADVANCE(36);
      END_STATE();
    case 55:
      if (lookahead == 'g') ADVANCE(80);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(51);
      if (lookahead == 'y') ADVANCE(112);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(54);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(114);
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 64:
      if (lookahead == 'i') ADVANCE(81);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(82);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(83);
      END_STATE();
    case 67:
      if (lookahead == 'l') ADVANCE(224);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(87);
      if (lookahead == 'n') ADVANCE(221);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(21);
      END_STATE();
    case 70:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 71:
      if (lookahead == 'm') ADVANCE(93);
      END_STATE();
    case 72:
      if (lookahead == 'm') ADVANCE(93);
      if (lookahead == 'n') ADVANCE(113);
      END_STATE();
    case 73:
      if (lookahead == 'n') ADVANCE(221);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(63);
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(110);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(52);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(38);
      END_STATE();
    case 79:
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 80:
      if (lookahead == 'n') ADVANCE(43);
      END_STATE();
    case 81:
      if (lookahead == 'n') ADVANCE(119);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(120);
      END_STATE();
    case 83:
      if (lookahead == 'n') ADVANCE(121);
      END_STATE();
    case 84:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 85:
      if (lookahead == 'o') ADVANCE(106);
      END_STATE();
    case 86:
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 89:
      if (lookahead == 'o') ADVANCE(65);
      END_STATE();
    case 90:
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(34);
      END_STATE();
    case 92:
      if (lookahead == 'o') ADVANCE(35);
      END_STATE();
    case 93:
      if (lookahead == 'p') ADVANCE(85);
      END_STATE();
    case 94:
      if (lookahead == 'p') ADVANCE(19);
      END_STATE();
    case 95:
      if (lookahead == 'p') ADVANCE(37);
      END_STATE();
    case 96:
      if (lookahead == 'p') ADVANCE(88);
      END_STATE();
    case 97:
      if (lookahead == 'p') ADVANCE(118);
      END_STATE();
    case 98:
      if (lookahead == 'p') ADVANCE(89);
      END_STATE();
    case 99:
      if (lookahead == 'p') ADVANCE(90);
      END_STATE();
    case 100:
      if (lookahead == 'q') ADVANCE(129);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(69);
      if (lookahead == 'x') ADVANCE(123);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 103:
      if (lookahead == 'r') ADVANCE(79);
      END_STATE();
    case 104:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 105:
      if (lookahead == 'r') ADVANCE(61);
      END_STATE();
    case 106:
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 107:
      if (lookahead == 's') ADVANCE(197);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(280);
      END_STATE();
    case 109:
      if (lookahead == 's') ADVANCE(28);
      END_STATE();
    case 110:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 111:
      if (lookahead == 's') ADVANCE(125);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(282);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(312);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(203);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(284);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(193);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(186);
      END_STATE();
    case 119:
      if (lookahead == 't') ADVANCE(296);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(298);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 124:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(104);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 127:
      if (lookahead == 'u') ADVANCE(135);
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'e' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(267);
      END_STATE();
    case 128:
      if (lookahead == 'u') ADVANCE(26);
      END_STATE();
    case 129:
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 130:
      if (lookahead == 'v') ADVANCE(23);
      END_STATE();
    case 131:
      if (lookahead == 'v') ADVANCE(40);
      END_STATE();
    case 132:
      if (lookahead == 'x') ADVANCE(123);
      END_STATE();
    case 133:
      if (lookahead == 'y') ADVANCE(278);
      END_STATE();
    case 134:
      if (lookahead == 'y') ADVANCE(95);
      END_STATE();
    case 135:
      if (lookahead == '{') ADVANCE(167);
      END_STATE();
    case 136:
      if (lookahead == '}') ADVANCE(268);
      END_STATE();
    case 137:
      if (lookahead == '}') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(136);
      END_STATE();
    case 138:
      if (lookahead == '}') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      END_STATE();
    case 139:
      if (lookahead == '}') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(138);
      END_STATE();
    case 140:
      if (lookahead == '}') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(139);
      END_STATE();
    case 141:
      if (lookahead == '}') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(140);
      END_STATE();
    case 142:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(142)
      if (lookahead == '\r') SKIP(142)
      if (lookahead == '!') ADVANCE(260);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(206);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(433);
      if (lookahead == 'c') ADVANCE(324);
      if (lookahead == 'f') ADVANCE(386);
      if (lookahead == 'l') ADVANCE(355);
      if (lookahead == 'p') ADVANCE(326);
      if (lookahead == 't') ADVANCE(399);
      if (lookahead == 'u') ADVANCE(425);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 143:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(143)
      if (lookahead == '\r') SKIP(143)
      if (lookahead == '!') ADVANCE(259);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(3);
      if (lookahead == '=') ADVANCE(205);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == '_') ADVANCE(314);
      if (lookahead == 'a') ADVANCE(433);
      if (lookahead == 'c') ADVANCE(324);
      if (lookahead == 'f') ADVANCE(386);
      if (lookahead == 'p') ADVANCE(326);
      if (lookahead == 't') ADVANCE(399);
      if (lookahead == '{') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 144:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(144)
      if (lookahead == '\r') SKIP(144)
      if (lookahead == '!') ADVANCE(259);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(433);
      if (lookahead == 'c') ADVANCE(324);
      if (lookahead == 'f') ADVANCE(386);
      if (lookahead == 'p') ADVANCE(326);
      if (lookahead == 't') ADVANCE(399);
      if (lookahead == '{') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 145:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(145)
      if (lookahead == '\r') SKIP(145)
      if (lookahead == '!') ADVANCE(260);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(424);
      if (lookahead == 'c') ADVANCE(324);
      if (lookahead == 'f') ADVANCE(386);
      if (lookahead == 'l') ADVANCE(355);
      if (lookahead == 'p') ADVANCE(326);
      if (lookahead == 't') ADVANCE(399);
      if (lookahead == 'u') ADVANCE(425);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 146:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(147)
      if (lookahead == '\r') SKIP(147)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(266);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(213);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(206);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '@') ADVANCE(188);
      if (lookahead == '\\') ADVANCE(127);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'b') ADVANCE(56);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(101);
      if (lookahead == 'f') ADVANCE(68);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'j') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(60);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 's') ADVANCE(57);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == 'u') ADVANCE(74);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      END_STATE();
    case 147:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(147)
      if (lookahead == '\r') SKIP(147)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(213);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '0') ADVANCE(274);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(206);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '@') ADVANCE(188);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'b') ADVANCE(56);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(101);
      if (lookahead == 'f') ADVANCE(68);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'j') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(60);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 's') ADVANCE(57);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == 'u') ADVANCE(74);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      END_STATE();
    case 148:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(148)
      if (lookahead == '\r') SKIP(148)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(213);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '@') ADVANCE(188);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(183);
      END_STATE();
    case 149:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(149)
      if (lookahead == '\r') SKIP(149)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == '_') ADVANCE(314);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 150:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(150)
      if (lookahead == '\r') SKIP(150)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == '_') ADVANCE(314);
      if (lookahead == 'a') ADVANCE(427);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 151:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(151)
      if (lookahead == '\r') SKIP(151)
      if (lookahead == '!') ADVANCE(259);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == '{') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 152:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(152)
      if (lookahead == '\r') SKIP(152)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(214);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'i') ADVANCE(49);
      if (lookahead == '|') ADVANCE(254);
      END_STATE();
    case 153:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(153)
      if (lookahead == '\r') SKIP(153)
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == '_') ADVANCE(314);
      if (lookahead == 'i') ADVANCE(364);
      if (lookahead == '|') ADVANCE(253);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 154:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(154)
      if (lookahead == '\r') SKIP(154)
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == '<') ADVANCE(3);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == '_') ADVANCE(314);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 155:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(155)
      if (lookahead == '\r') SKIP(155)
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == '_') ADVANCE(314);
      if (lookahead == 'a') ADVANCE(433);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 156:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(156)
      if (lookahead == '\r') SKIP(156)
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(14);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(4);
      if (lookahead == '=') ADVANCE(205);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '@') ADVANCE(188);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '|') ADVANCE(253);
      if (lookahead == '}') ADVANCE(183);
      END_STATE();
    case 157:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(157)
      if (lookahead == '\r') SKIP(157)
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(212);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(4);
      if (lookahead == '=') ADVANCE(205);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '@') ADVANCE(188);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == '}') ADVANCE(183);
      END_STATE();
    case 158:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(158)
      if (lookahead == '\r') SKIP(158)
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '_') ADVANCE(315);
      if (lookahead == 'f') ADVANCE(386);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 159:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(159)
      if (lookahead == '\r') SKIP(159)
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == '_') ADVANCE(315);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 160:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(160)
      if (lookahead == '\r') SKIP(160)
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == '-') ADVANCE(212);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(274);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(275);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 161:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(161)
      if (lookahead == '\r') SKIP(161)
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == 't') ADVANCE(456);
      if (lookahead == '}') ADVANCE(183);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 162:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(162)
      if (lookahead == '\r') SKIP(162)
      if (lookahead == '!') ADVANCE(260);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(433);
      if (lookahead == 'c') ADVANCE(324);
      if (lookahead == 'f') ADVANCE(386);
      if (lookahead == 'l') ADVANCE(355);
      if (lookahead == 'p') ADVANCE(326);
      if (lookahead == 't') ADVANCE(399);
      if (lookahead == 'u') ADVANCE(425);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 163:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(163)
      if (lookahead == '\r') SKIP(163)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(214);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(231);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '@') ADVANCE(188);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(128);
      if (lookahead == 't') ADVANCE(134);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(183);
      END_STATE();
    case 164:
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(277);
      END_STATE();
    case 165:
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(276);
      END_STATE();
    case 166:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(270);
      END_STATE();
    case 167:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      END_STATE();
    case 168:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(271);
      END_STATE();
    case 169:
      if (eof) ADVANCE(174);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(169)
      if (lookahead == '\r') SKIP(169)
      if (lookahead == '!') ADVANCE(260);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == ')') ADVANCE(191);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == ',') ADVANCE(190);
      if (lookahead == '-') ADVANCE(215);
      if (lookahead == '.') ADVANCE(196);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == ':') ADVANCE(192);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(206);
      if (lookahead == '>') ADVANCE(236);
      if (lookahead == '@') ADVANCE(188);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == ']') ADVANCE(209);
      if (lookahead == '_') ADVANCE(314);
      if (lookahead == 'a') ADVANCE(424);
      if (lookahead == 'b') ADVANCE(371);
      if (lookahead == 'c') ADVANCE(323);
      if (lookahead == 'e') ADVANCE(417);
      if (lookahead == 'f') ADVANCE(382);
      if (lookahead == 'i') ADVANCE(362);
      if (lookahead == 'j') ADVANCE(321);
      if (lookahead == 'l') ADVANCE(354);
      if (lookahead == 'n') ADVANCE(331);
      if (lookahead == 'o') ADVANCE(410);
      if (lookahead == 'p') ADVANCE(325);
      if (lookahead == 's') ADVANCE(372);
      if (lookahead == 't') ADVANCE(398);
      if (lookahead == 'u') ADVANCE(387);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '|') ADVANCE(254);
      if (lookahead == '}') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('d' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 170:
      if (eof) ADVANCE(174);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(170)
      if (lookahead == '\r') SKIP(170)
      if (lookahead == '!') ADVANCE(260);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == '@') ADVANCE(188);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(433);
      if (lookahead == 'c') ADVANCE(323);
      if (lookahead == 'e') ADVANCE(454);
      if (lookahead == 'f') ADVANCE(386);
      if (lookahead == 'i') ADVANCE(363);
      if (lookahead == 'l') ADVANCE(355);
      if (lookahead == 'o') ADVANCE(410);
      if (lookahead == 'p') ADVANCE(325);
      if (lookahead == 't') ADVANCE(398);
      if (lookahead == 'u') ADVANCE(425);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '|') ADVANCE(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 171:
      if (eof) ADVANCE(174);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(171)
      if (lookahead == '\r') SKIP(171)
      if (lookahead == '!') ADVANCE(259);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == '-') ADVANCE(218);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '=') ADVANCE(205);
      if (lookahead == '@') ADVANCE(188);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(433);
      if (lookahead == 'c') ADVANCE(323);
      if (lookahead == 'e') ADVANCE(454);
      if (lookahead == 'f') ADVANCE(386);
      if (lookahead == 'i') ADVANCE(363);
      if (lookahead == 'l') ADVANCE(355);
      if (lookahead == 'o') ADVANCE(410);
      if (lookahead == 'p') ADVANCE(325);
      if (lookahead == 't') ADVANCE(398);
      if (lookahead == 'u') ADVANCE(425);
      if (lookahead == '{') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 172:
      if (eof) ADVANCE(174);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(172)
      if (lookahead == '\r') SKIP(172)
      if (lookahead == '!') ADVANCE(259);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '-') ADVANCE(217);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '@') ADVANCE(188);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(433);
      if (lookahead == 'c') ADVANCE(323);
      if (lookahead == 'e') ADVANCE(454);
      if (lookahead == 'f') ADVANCE(386);
      if (lookahead == 'i') ADVANCE(363);
      if (lookahead == 'l') ADVANCE(355);
      if (lookahead == 'o') ADVANCE(410);
      if (lookahead == 'p') ADVANCE(325);
      if (lookahead == 't') ADVANCE(398);
      if (lookahead == 'u') ADVANCE(425);
      if (lookahead == '{') ADVANCE(182);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 173:
      if (eof) ADVANCE(174);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(173)
      if (lookahead == '\r') SKIP(173)
      if (lookahead == '!') ADVANCE(260);
      if (lookahead == '"') ADVANCE(265);
      if (lookahead == '#') ADVANCE(207);
      if (lookahead == '%') ADVANCE(247);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(189);
      if (lookahead == '*') ADVANCE(244);
      if (lookahead == '+') ADVANCE(241);
      if (lookahead == '-') ADVANCE(216);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '0') ADVANCE(272);
      if (lookahead == '<') ADVANCE(230);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(235);
      if (lookahead == '@') ADVANCE(188);
      if (lookahead == '[') ADVANCE(208);
      if (lookahead == '_') ADVANCE(316);
      if (lookahead == 'a') ADVANCE(424);
      if (lookahead == 'c') ADVANCE(323);
      if (lookahead == 'e') ADVANCE(454);
      if (lookahead == 'f') ADVANCE(386);
      if (lookahead == 'i') ADVANCE(363);
      if (lookahead == 'l') ADVANCE(355);
      if (lookahead == 'o') ADVANCE(410);
      if (lookahead == 'p') ADVANCE(325);
      if (lookahead == 't') ADVANCE(398);
      if (lookahead == 'u') ADVANCE(425);
      if (lookahead == '{') ADVANCE(182);
      if (lookahead == '|') ADVANCE(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(458);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_module_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(175);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead == '/') ADVANCE(175);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(177);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(177);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(176);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(179);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_erlang);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_erlang);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_javascript);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_javascript);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_import);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(251);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(346);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_as);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '.') ADVANCE(246);
      if (lookahead == '/') ADVANCE(178);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_const);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(228);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(243);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(243);
      if (lookahead == '>') ADVANCE(223);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(243);
      if (lookahead == '>') ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_size);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_size);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_fn);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_external);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(233);
      if (lookahead == '<') ADVANCE(210);
      if (lookahead == '=') ADVANCE(232);
      if (lookahead == '>') ADVANCE(248);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(233);
      if (lookahead == '=') ADVANCE(232);
      if (lookahead == '>') ADVANCE(248);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '.') ADVANCE(234);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_LT_DOT);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_LT_EQ_DOT);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(238);
      if (lookahead == '=') ADVANCE(237);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(238);
      if (lookahead == '=') ADVANCE(237);
      if (lookahead == '>') ADVANCE(211);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      if (lookahead == '.') ADVANCE(239);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_GT_DOT);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_GT_EQ_DOT);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(242);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_PLUS_DOT);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_DASH_DOT);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '.') ADVANCE(245);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_STAR_DOT);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_SLASH_DOT);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_todo);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_panic);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_case);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(240);
      if (lookahead == '|') ADVANCE(226);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_assert);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_use);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(229);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_visibility_modifier);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_visibility_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_opacity_modifier);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_opacity_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token1);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token2);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'e') ADVANCE(2);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(269);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(270);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym__hex);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(271);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(269);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(164);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(165);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(273);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(273);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(164);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(165);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(275);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym__decimal);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(275);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym__octal);
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(276);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym__binary);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(277);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_binary);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_binary);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_bytes);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_bytes);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_int);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_bit_string);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_bit_string);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_bits);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_bits);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(27);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(335);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(29);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(30);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(338);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_signed);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_signed);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_unsigned);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_big);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_big);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_little);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_little);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_native);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_unit);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_unit);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym__discard_name);
      if (lookahead == '.') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(314);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(315);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym__discard_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(315);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '.') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(316);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '1') ADVANCE(319);
      if (lookahead == '3') ADVANCE(318);
      if (lookahead == '8') ADVANCE(291);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '2') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '6') ADVANCE(293);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '_') ADVANCE(432);
      if (lookahead == 's') ADVANCE(289);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(452);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(416);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(430);
      if (lookahead == 'o') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(430);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(390);
      if (lookahead == 'u') ADVANCE(333);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(390);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(418);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(383);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(388);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(429);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(438);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'b') ADVANCE(262);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(421);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(408);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(303);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(400);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(360);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(361);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(422);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(311);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(264);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(339);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(435);
      if (lookahead == 'i') ADVANCE(450);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(435);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(340);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(420);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(426);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(411);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(415);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(181);
      if (lookahead == 'm') ADVANCE(409);
      if (lookahead == 'n') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(181);
      if (lookahead == 'm') ADVANCE(409);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(317);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(307);
      if (lookahead == 'n') ADVANCE(327);
      if (lookahead == 't') ADVANCE(320);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(287);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(393);
      if (lookahead == 'z') ADVANCE(348);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(457);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(394);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(366);
      if (lookahead == 'y') ADVANCE(447);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(369);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(334);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(453);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(413);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(391);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(436);
      if (lookahead == 's') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(395);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(396);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(397);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(403);
      if (lookahead == 'n') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(225);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(329);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(378);
      if (lookahead == 's') ADVANCE(345);
      if (lookahead == 't') ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(367);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(431);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(368);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(328);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(353);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(356);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(442);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(443);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(444);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(341);
      if (lookahead == 'y') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(249);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(342);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(423);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(332);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(379);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(380);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(381);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(343);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(344);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(402);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(322);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(404);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(349);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(441);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(406);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'q') ADVANCE(451);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(384);
      if (lookahead == 'x') ADVANCE(449);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(455);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(377);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(392);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(376);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(439);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(440);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(346);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(336);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(347);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(437);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(448);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(428);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(256);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(299);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(375);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(385);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(358);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(419);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(446);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'u') ADVANCE(352);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(351);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'x') ADVANCE(449);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(279);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym__name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(457);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(sym__upname);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(458);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 170},
  [2] = {.lex_state = 170},
  [3] = {.lex_state = 170},
  [4] = {.lex_state = 170},
  [5] = {.lex_state = 170},
  [6] = {.lex_state = 170},
  [7] = {.lex_state = 142},
  [8] = {.lex_state = 142},
  [9] = {.lex_state = 142},
  [10] = {.lex_state = 142},
  [11] = {.lex_state = 142},
  [12] = {.lex_state = 170},
  [13] = {.lex_state = 170},
  [14] = {.lex_state = 142},
  [15] = {.lex_state = 142},
  [16] = {.lex_state = 142},
  [17] = {.lex_state = 173},
  [18] = {.lex_state = 173},
  [19] = {.lex_state = 170},
  [20] = {.lex_state = 142},
  [21] = {.lex_state = 170},
  [22] = {.lex_state = 142},
  [23] = {.lex_state = 170},
  [24] = {.lex_state = 170},
  [25] = {.lex_state = 170},
  [26] = {.lex_state = 142},
  [27] = {.lex_state = 170},
  [28] = {.lex_state = 170},
  [29] = {.lex_state = 170},
  [30] = {.lex_state = 142},
  [31] = {.lex_state = 142},
  [32] = {.lex_state = 142},
  [33] = {.lex_state = 142},
  [34] = {.lex_state = 142},
  [35] = {.lex_state = 142},
  [36] = {.lex_state = 170},
  [37] = {.lex_state = 170},
  [38] = {.lex_state = 142},
  [39] = {.lex_state = 142},
  [40] = {.lex_state = 170},
  [41] = {.lex_state = 142},
  [42] = {.lex_state = 142},
  [43] = {.lex_state = 170},
  [44] = {.lex_state = 142},
  [45] = {.lex_state = 142},
  [46] = {.lex_state = 170},
  [47] = {.lex_state = 142},
  [48] = {.lex_state = 142},
  [49] = {.lex_state = 170},
  [50] = {.lex_state = 142},
  [51] = {.lex_state = 170},
  [52] = {.lex_state = 142},
  [53] = {.lex_state = 142},
  [54] = {.lex_state = 170},
  [55] = {.lex_state = 142},
  [56] = {.lex_state = 142},
  [57] = {.lex_state = 142},
  [58] = {.lex_state = 142},
  [59] = {.lex_state = 170},
  [60] = {.lex_state = 142},
  [61] = {.lex_state = 170},
  [62] = {.lex_state = 142},
  [63] = {.lex_state = 142},
  [64] = {.lex_state = 170},
  [65] = {.lex_state = 142},
  [66] = {.lex_state = 142},
  [67] = {.lex_state = 142},
  [68] = {.lex_state = 142},
  [69] = {.lex_state = 142},
  [70] = {.lex_state = 142},
  [71] = {.lex_state = 170},
  [72] = {.lex_state = 170},
  [73] = {.lex_state = 170},
  [74] = {.lex_state = 142},
  [75] = {.lex_state = 170},
  [76] = {.lex_state = 142},
  [77] = {.lex_state = 170},
  [78] = {.lex_state = 170},
  [79] = {.lex_state = 142},
  [80] = {.lex_state = 170},
  [81] = {.lex_state = 142},
  [82] = {.lex_state = 170},
  [83] = {.lex_state = 142},
  [84] = {.lex_state = 142},
  [85] = {.lex_state = 142},
  [86] = {.lex_state = 143},
  [87] = {.lex_state = 170},
  [88] = {.lex_state = 143},
  [89] = {.lex_state = 170},
  [90] = {.lex_state = 143},
  [91] = {.lex_state = 170},
  [92] = {.lex_state = 170},
  [93] = {.lex_state = 170},
  [94] = {.lex_state = 170},
  [95] = {.lex_state = 170},
  [96] = {.lex_state = 170},
  [97] = {.lex_state = 170},
  [98] = {.lex_state = 170},
  [99] = {.lex_state = 170},
  [100] = {.lex_state = 170},
  [101] = {.lex_state = 170},
  [102] = {.lex_state = 170},
  [103] = {.lex_state = 170},
  [104] = {.lex_state = 170},
  [105] = {.lex_state = 170},
  [106] = {.lex_state = 170},
  [107] = {.lex_state = 170},
  [108] = {.lex_state = 170},
  [109] = {.lex_state = 170},
  [110] = {.lex_state = 170},
  [111] = {.lex_state = 170},
  [112] = {.lex_state = 170},
  [113] = {.lex_state = 170},
  [114] = {.lex_state = 170},
  [115] = {.lex_state = 143},
  [116] = {.lex_state = 170},
  [117] = {.lex_state = 170},
  [118] = {.lex_state = 170},
  [119] = {.lex_state = 170},
  [120] = {.lex_state = 170},
  [121] = {.lex_state = 143},
  [122] = {.lex_state = 170},
  [123] = {.lex_state = 170},
  [124] = {.lex_state = 143},
  [125] = {.lex_state = 143},
  [126] = {.lex_state = 143},
  [127] = {.lex_state = 162},
  [128] = {.lex_state = 162},
  [129] = {.lex_state = 143},
  [130] = {.lex_state = 143},
  [131] = {.lex_state = 143},
  [132] = {.lex_state = 143},
  [133] = {.lex_state = 162},
  [134] = {.lex_state = 143},
  [135] = {.lex_state = 162},
  [136] = {.lex_state = 143},
  [137] = {.lex_state = 143},
  [138] = {.lex_state = 143},
  [139] = {.lex_state = 143},
  [140] = {.lex_state = 143},
  [141] = {.lex_state = 143},
  [142] = {.lex_state = 143},
  [143] = {.lex_state = 162},
  [144] = {.lex_state = 143},
  [145] = {.lex_state = 143},
  [146] = {.lex_state = 162},
  [147] = {.lex_state = 162},
  [148] = {.lex_state = 162},
  [149] = {.lex_state = 162},
  [150] = {.lex_state = 162},
  [151] = {.lex_state = 162},
  [152] = {.lex_state = 162},
  [153] = {.lex_state = 162},
  [154] = {.lex_state = 162},
  [155] = {.lex_state = 162},
  [156] = {.lex_state = 162},
  [157] = {.lex_state = 162},
  [158] = {.lex_state = 162},
  [159] = {.lex_state = 162},
  [160] = {.lex_state = 162},
  [161] = {.lex_state = 162},
  [162] = {.lex_state = 162},
  [163] = {.lex_state = 144},
  [164] = {.lex_state = 162},
  [165] = {.lex_state = 144},
  [166] = {.lex_state = 144},
  [167] = {.lex_state = 162},
  [168] = {.lex_state = 144},
  [169] = {.lex_state = 162},
  [170] = {.lex_state = 162},
  [171] = {.lex_state = 162},
  [172] = {.lex_state = 144},
  [173] = {.lex_state = 144},
  [174] = {.lex_state = 162},
  [175] = {.lex_state = 144},
  [176] = {.lex_state = 162},
  [177] = {.lex_state = 144},
  [178] = {.lex_state = 144},
  [179] = {.lex_state = 144},
  [180] = {.lex_state = 162},
  [181] = {.lex_state = 144},
  [182] = {.lex_state = 144},
  [183] = {.lex_state = 144},
  [184] = {.lex_state = 144},
  [185] = {.lex_state = 144},
  [186] = {.lex_state = 162},
  [187] = {.lex_state = 162},
  [188] = {.lex_state = 162},
  [189] = {.lex_state = 144},
  [190] = {.lex_state = 144},
  [191] = {.lex_state = 144},
  [192] = {.lex_state = 144},
  [193] = {.lex_state = 162},
  [194] = {.lex_state = 144},
  [195] = {.lex_state = 144},
  [196] = {.lex_state = 162},
  [197] = {.lex_state = 162},
  [198] = {.lex_state = 162},
  [199] = {.lex_state = 162},
  [200] = {.lex_state = 144},
  [201] = {.lex_state = 144},
  [202] = {.lex_state = 144},
  [203] = {.lex_state = 162},
  [204] = {.lex_state = 144},
  [205] = {.lex_state = 162},
  [206] = {.lex_state = 162},
  [207] = {.lex_state = 144},
  [208] = {.lex_state = 144},
  [209] = {.lex_state = 162},
  [210] = {.lex_state = 162},
  [211] = {.lex_state = 144},
  [212] = {.lex_state = 144},
  [213] = {.lex_state = 144},
  [214] = {.lex_state = 144},
  [215] = {.lex_state = 144},
  [216] = {.lex_state = 162},
  [217] = {.lex_state = 162},
  [218] = {.lex_state = 144},
  [219] = {.lex_state = 144},
  [220] = {.lex_state = 144},
  [221] = {.lex_state = 144},
  [222] = {.lex_state = 162},
  [223] = {.lex_state = 162},
  [224] = {.lex_state = 144},
  [225] = {.lex_state = 144},
  [226] = {.lex_state = 144},
  [227] = {.lex_state = 144},
  [228] = {.lex_state = 144},
  [229] = {.lex_state = 144},
  [230] = {.lex_state = 144},
  [231] = {.lex_state = 144},
  [232] = {.lex_state = 144},
  [233] = {.lex_state = 144},
  [234] = {.lex_state = 144},
  [235] = {.lex_state = 144},
  [236] = {.lex_state = 144},
  [237] = {.lex_state = 144},
  [238] = {.lex_state = 144},
  [239] = {.lex_state = 144},
  [240] = {.lex_state = 144},
  [241] = {.lex_state = 144},
  [242] = {.lex_state = 144},
  [243] = {.lex_state = 144},
  [244] = {.lex_state = 144},
  [245] = {.lex_state = 145},
  [246] = {.lex_state = 144},
  [247] = {.lex_state = 144},
  [248] = {.lex_state = 144},
  [249] = {.lex_state = 144},
  [250] = {.lex_state = 144},
  [251] = {.lex_state = 144},
  [252] = {.lex_state = 144},
  [253] = {.lex_state = 144},
  [254] = {.lex_state = 144},
  [255] = {.lex_state = 144},
  [256] = {.lex_state = 144},
  [257] = {.lex_state = 144},
  [258] = {.lex_state = 145},
  [259] = {.lex_state = 144},
  [260] = {.lex_state = 144},
  [261] = {.lex_state = 144},
  [262] = {.lex_state = 144},
  [263] = {.lex_state = 144},
  [264] = {.lex_state = 144},
  [265] = {.lex_state = 144},
  [266] = {.lex_state = 144},
  [267] = {.lex_state = 144},
  [268] = {.lex_state = 144},
  [269] = {.lex_state = 144},
  [270] = {.lex_state = 144},
  [271] = {.lex_state = 144},
  [272] = {.lex_state = 144},
  [273] = {.lex_state = 144},
  [274] = {.lex_state = 144},
  [275] = {.lex_state = 144},
  [276] = {.lex_state = 144},
  [277] = {.lex_state = 144},
  [278] = {.lex_state = 144},
  [279] = {.lex_state = 144},
  [280] = {.lex_state = 144},
  [281] = {.lex_state = 144},
  [282] = {.lex_state = 144},
  [283] = {.lex_state = 144},
  [284] = {.lex_state = 144},
  [285] = {.lex_state = 144},
  [286] = {.lex_state = 144},
  [287] = {.lex_state = 144},
  [288] = {.lex_state = 144},
  [289] = {.lex_state = 144},
  [290] = {.lex_state = 144},
  [291] = {.lex_state = 144},
  [292] = {.lex_state = 144},
  [293] = {.lex_state = 144},
  [294] = {.lex_state = 162},
  [295] = {.lex_state = 144},
  [296] = {.lex_state = 144},
  [297] = {.lex_state = 144},
  [298] = {.lex_state = 144},
  [299] = {.lex_state = 144},
  [300] = {.lex_state = 144},
  [301] = {.lex_state = 144},
  [302] = {.lex_state = 144},
  [303] = {.lex_state = 144},
  [304] = {.lex_state = 144},
  [305] = {.lex_state = 144},
  [306] = {.lex_state = 144},
  [307] = {.lex_state = 144},
  [308] = {.lex_state = 144},
  [309] = {.lex_state = 144},
  [310] = {.lex_state = 144},
  [311] = {.lex_state = 144},
  [312] = {.lex_state = 144},
  [313] = {.lex_state = 144},
  [314] = {.lex_state = 144},
  [315] = {.lex_state = 144},
  [316] = {.lex_state = 144},
  [317] = {.lex_state = 144},
  [318] = {.lex_state = 144},
  [319] = {.lex_state = 144},
  [320] = {.lex_state = 144},
  [321] = {.lex_state = 144},
  [322] = {.lex_state = 144},
  [323] = {.lex_state = 144},
  [324] = {.lex_state = 144},
  [325] = {.lex_state = 144},
  [326] = {.lex_state = 144},
  [327] = {.lex_state = 144},
  [328] = {.lex_state = 162},
  [329] = {.lex_state = 144},
  [330] = {.lex_state = 162},
  [331] = {.lex_state = 144},
  [332] = {.lex_state = 162},
  [333] = {.lex_state = 144},
  [334] = {.lex_state = 144},
  [335] = {.lex_state = 144},
  [336] = {.lex_state = 144},
  [337] = {.lex_state = 144},
  [338] = {.lex_state = 144},
  [339] = {.lex_state = 144},
  [340] = {.lex_state = 162},
  [341] = {.lex_state = 144},
  [342] = {.lex_state = 162},
  [343] = {.lex_state = 162},
  [344] = {.lex_state = 162},
  [345] = {.lex_state = 162},
  [346] = {.lex_state = 162},
  [347] = {.lex_state = 144},
  [348] = {.lex_state = 162},
  [349] = {.lex_state = 162},
  [350] = {.lex_state = 162},
  [351] = {.lex_state = 162},
  [352] = {.lex_state = 162},
  [353] = {.lex_state = 144},
  [354] = {.lex_state = 146},
  [355] = {.lex_state = 146},
  [356] = {.lex_state = 146},
  [357] = {.lex_state = 146},
  [358] = {.lex_state = 148},
  [359] = {.lex_state = 146},
  [360] = {.lex_state = 146},
  [361] = {.lex_state = 149},
  [362] = {.lex_state = 149},
  [363] = {.lex_state = 149},
  [364] = {.lex_state = 149},
  [365] = {.lex_state = 149},
  [366] = {.lex_state = 149},
  [367] = {.lex_state = 150},
  [368] = {.lex_state = 149},
  [369] = {.lex_state = 149},
  [370] = {.lex_state = 149},
  [371] = {.lex_state = 149},
  [372] = {.lex_state = 149},
  [373] = {.lex_state = 149},
  [374] = {.lex_state = 149},
  [375] = {.lex_state = 149},
  [376] = {.lex_state = 149},
  [377] = {.lex_state = 150},
  [378] = {.lex_state = 149},
  [379] = {.lex_state = 149},
  [380] = {.lex_state = 149},
  [381] = {.lex_state = 149},
  [382] = {.lex_state = 149},
  [383] = {.lex_state = 149},
  [384] = {.lex_state = 149},
  [385] = {.lex_state = 149},
  [386] = {.lex_state = 149},
  [387] = {.lex_state = 149},
  [388] = {.lex_state = 163},
  [389] = {.lex_state = 149},
  [390] = {.lex_state = 149},
  [391] = {.lex_state = 149},
  [392] = {.lex_state = 149},
  [393] = {.lex_state = 149},
  [394] = {.lex_state = 149},
  [395] = {.lex_state = 149},
  [396] = {.lex_state = 149},
  [397] = {.lex_state = 149},
  [398] = {.lex_state = 149},
  [399] = {.lex_state = 149},
  [400] = {.lex_state = 149},
  [401] = {.lex_state = 149},
  [402] = {.lex_state = 149},
  [403] = {.lex_state = 149},
  [404] = {.lex_state = 149},
  [405] = {.lex_state = 149},
  [406] = {.lex_state = 149},
  [407] = {.lex_state = 149},
  [408] = {.lex_state = 149},
  [409] = {.lex_state = 149},
  [410] = {.lex_state = 149},
  [411] = {.lex_state = 149},
  [412] = {.lex_state = 149},
  [413] = {.lex_state = 149},
  [414] = {.lex_state = 149},
  [415] = {.lex_state = 149},
  [416] = {.lex_state = 149},
  [417] = {.lex_state = 149},
  [418] = {.lex_state = 149},
  [419] = {.lex_state = 149},
  [420] = {.lex_state = 149},
  [421] = {.lex_state = 149},
  [422] = {.lex_state = 149},
  [423] = {.lex_state = 149},
  [424] = {.lex_state = 149},
  [425] = {.lex_state = 149},
  [426] = {.lex_state = 163},
  [427] = {.lex_state = 163},
  [428] = {.lex_state = 163},
  [429] = {.lex_state = 163},
  [430] = {.lex_state = 163},
  [431] = {.lex_state = 163},
  [432] = {.lex_state = 163},
  [433] = {.lex_state = 163},
  [434] = {.lex_state = 163},
  [435] = {.lex_state = 163},
  [436] = {.lex_state = 163},
  [437] = {.lex_state = 163},
  [438] = {.lex_state = 163},
  [439] = {.lex_state = 163},
  [440] = {.lex_state = 163},
  [441] = {.lex_state = 163},
  [442] = {.lex_state = 163},
  [443] = {.lex_state = 163},
  [444] = {.lex_state = 173},
  [445] = {.lex_state = 173},
  [446] = {.lex_state = 173},
  [447] = {.lex_state = 148},
  [448] = {.lex_state = 148},
  [449] = {.lex_state = 148},
  [450] = {.lex_state = 148},
  [451] = {.lex_state = 171},
  [452] = {.lex_state = 148},
  [453] = {.lex_state = 148},
  [454] = {.lex_state = 148},
  [455] = {.lex_state = 148},
  [456] = {.lex_state = 148},
  [457] = {.lex_state = 148},
  [458] = {.lex_state = 173},
  [459] = {.lex_state = 148},
  [460] = {.lex_state = 148},
  [461] = {.lex_state = 148},
  [462] = {.lex_state = 148},
  [463] = {.lex_state = 148},
  [464] = {.lex_state = 148},
  [465] = {.lex_state = 149},
  [466] = {.lex_state = 148},
  [467] = {.lex_state = 148},
  [468] = {.lex_state = 149},
  [469] = {.lex_state = 149},
  [470] = {.lex_state = 148},
  [471] = {.lex_state = 148},
  [472] = {.lex_state = 148},
  [473] = {.lex_state = 148},
  [474] = {.lex_state = 170},
  [475] = {.lex_state = 171},
  [476] = {.lex_state = 148},
  [477] = {.lex_state = 170},
  [478] = {.lex_state = 170},
  [479] = {.lex_state = 148},
  [480] = {.lex_state = 149},
  [481] = {.lex_state = 149},
  [482] = {.lex_state = 148},
  [483] = {.lex_state = 148},
  [484] = {.lex_state = 148},
  [485] = {.lex_state = 171},
  [486] = {.lex_state = 173},
  [487] = {.lex_state = 172},
  [488] = {.lex_state = 148},
  [489] = {.lex_state = 173},
  [490] = {.lex_state = 172},
  [491] = {.lex_state = 148},
  [492] = {.lex_state = 146},
  [493] = {.lex_state = 148},
  [494] = {.lex_state = 148},
  [495] = {.lex_state = 148},
  [496] = {.lex_state = 149},
  [497] = {.lex_state = 171},
  [498] = {.lex_state = 148},
  [499] = {.lex_state = 148},
  [500] = {.lex_state = 172},
  [501] = {.lex_state = 148},
  [502] = {.lex_state = 171},
  [503] = {.lex_state = 149},
  [504] = {.lex_state = 170},
  [505] = {.lex_state = 148},
  [506] = {.lex_state = 171},
  [507] = {.lex_state = 148},
  [508] = {.lex_state = 173},
  [509] = {.lex_state = 148},
  [510] = {.lex_state = 172},
  [511] = {.lex_state = 148},
  [512] = {.lex_state = 148},
  [513] = {.lex_state = 146},
  [514] = {.lex_state = 148},
  [515] = {.lex_state = 171},
  [516] = {.lex_state = 148},
  [517] = {.lex_state = 149},
  [518] = {.lex_state = 146},
  [519] = {.lex_state = 170},
  [520] = {.lex_state = 148},
  [521] = {.lex_state = 148},
  [522] = {.lex_state = 172},
  [523] = {.lex_state = 148},
  [524] = {.lex_state = 148},
  [525] = {.lex_state = 173},
  [526] = {.lex_state = 148},
  [527] = {.lex_state = 171},
  [528] = {.lex_state = 146},
  [529] = {.lex_state = 149},
  [530] = {.lex_state = 148},
  [531] = {.lex_state = 149},
  [532] = {.lex_state = 148},
  [533] = {.lex_state = 148},
  [534] = {.lex_state = 148},
  [535] = {.lex_state = 146},
  [536] = {.lex_state = 173},
  [537] = {.lex_state = 148},
  [538] = {.lex_state = 148},
  [539] = {.lex_state = 172},
  [540] = {.lex_state = 148},
  [541] = {.lex_state = 173},
  [542] = {.lex_state = 171},
  [543] = {.lex_state = 148},
  [544] = {.lex_state = 146},
  [545] = {.lex_state = 171},
  [546] = {.lex_state = 170},
  [547] = {.lex_state = 170},
  [548] = {.lex_state = 170},
  [549] = {.lex_state = 146},
  [550] = {.lex_state = 170},
  [551] = {.lex_state = 151},
  [552] = {.lex_state = 170},
  [553] = {.lex_state = 170},
  [554] = {.lex_state = 170},
  [555] = {.lex_state = 170},
  [556] = {.lex_state = 151},
  [557] = {.lex_state = 170},
  [558] = {.lex_state = 170},
  [559] = {.lex_state = 151},
  [560] = {.lex_state = 151},
  [561] = {.lex_state = 170},
  [562] = {.lex_state = 170},
  [563] = {.lex_state = 170},
  [564] = {.lex_state = 170},
  [565] = {.lex_state = 170},
  [566] = {.lex_state = 170},
  [567] = {.lex_state = 170},
  [568] = {.lex_state = 170},
  [569] = {.lex_state = 151},
  [570] = {.lex_state = 170},
  [571] = {.lex_state = 170},
  [572] = {.lex_state = 170},
  [573] = {.lex_state = 170},
  [574] = {.lex_state = 170},
  [575] = {.lex_state = 170},
  [576] = {.lex_state = 170},
  [577] = {.lex_state = 170},
  [578] = {.lex_state = 170},
  [579] = {.lex_state = 151},
  [580] = {.lex_state = 170},
  [581] = {.lex_state = 170},
  [582] = {.lex_state = 151},
  [583] = {.lex_state = 170},
  [584] = {.lex_state = 170},
  [585] = {.lex_state = 151},
  [586] = {.lex_state = 170},
  [587] = {.lex_state = 151},
  [588] = {.lex_state = 151},
  [589] = {.lex_state = 151},
  [590] = {.lex_state = 151},
  [591] = {.lex_state = 151},
  [592] = {.lex_state = 170},
  [593] = {.lex_state = 170},
  [594] = {.lex_state = 170},
  [595] = {.lex_state = 170},
  [596] = {.lex_state = 152},
  [597] = {.lex_state = 170},
  [598] = {.lex_state = 170},
  [599] = {.lex_state = 151},
  [600] = {.lex_state = 151},
  [601] = {.lex_state = 148},
  [602] = {.lex_state = 170},
  [603] = {.lex_state = 170},
  [604] = {.lex_state = 170},
  [605] = {.lex_state = 146},
  [606] = {.lex_state = 170},
  [607] = {.lex_state = 170},
  [608] = {.lex_state = 170},
  [609] = {.lex_state = 170},
  [610] = {.lex_state = 170},
  [611] = {.lex_state = 170},
  [612] = {.lex_state = 170},
  [613] = {.lex_state = 146},
  [614] = {.lex_state = 170},
  [615] = {.lex_state = 170},
  [616] = {.lex_state = 170},
  [617] = {.lex_state = 170},
  [618] = {.lex_state = 170},
  [619] = {.lex_state = 170},
  [620] = {.lex_state = 170},
  [621] = {.lex_state = 170},
  [622] = {.lex_state = 170},
  [623] = {.lex_state = 170},
  [624] = {.lex_state = 170},
  [625] = {.lex_state = 170},
  [626] = {.lex_state = 170},
  [627] = {.lex_state = 170},
  [628] = {.lex_state = 170},
  [629] = {.lex_state = 170},
  [630] = {.lex_state = 170},
  [631] = {.lex_state = 170},
  [632] = {.lex_state = 170},
  [633] = {.lex_state = 153},
  [634] = {.lex_state = 149},
  [635] = {.lex_state = 154},
  [636] = {.lex_state = 146},
  [637] = {.lex_state = 146},
  [638] = {.lex_state = 153},
  [639] = {.lex_state = 146},
  [640] = {.lex_state = 153},
  [641] = {.lex_state = 149},
  [642] = {.lex_state = 153},
  [643] = {.lex_state = 149},
  [644] = {.lex_state = 149},
  [645] = {.lex_state = 154},
  [646] = {.lex_state = 154},
  [647] = {.lex_state = 149},
  [648] = {.lex_state = 149},
  [649] = {.lex_state = 155},
  [650] = {.lex_state = 149},
  [651] = {.lex_state = 148},
  [652] = {.lex_state = 154},
  [653] = {.lex_state = 149},
  [654] = {.lex_state = 155},
  [655] = {.lex_state = 149},
  [656] = {.lex_state = 149},
  [657] = {.lex_state = 149},
  [658] = {.lex_state = 148},
  [659] = {.lex_state = 149},
  [660] = {.lex_state = 149},
  [661] = {.lex_state = 148},
  [662] = {.lex_state = 149},
  [663] = {.lex_state = 149},
  [664] = {.lex_state = 149},
  [665] = {.lex_state = 149},
  [666] = {.lex_state = 149},
  [667] = {.lex_state = 163},
  [668] = {.lex_state = 149},
  [669] = {.lex_state = 149},
  [670] = {.lex_state = 148},
  [671] = {.lex_state = 149},
  [672] = {.lex_state = 148},
  [673] = {.lex_state = 148},
  [674] = {.lex_state = 149},
  [675] = {.lex_state = 151},
  [676] = {.lex_state = 148},
  [677] = {.lex_state = 148},
  [678] = {.lex_state = 163},
  [679] = {.lex_state = 163},
  [680] = {.lex_state = 151},
  [681] = {.lex_state = 163},
  [682] = {.lex_state = 148},
  [683] = {.lex_state = 151},
  [684] = {.lex_state = 163},
  [685] = {.lex_state = 163},
  [686] = {.lex_state = 163},
  [687] = {.lex_state = 163},
  [688] = {.lex_state = 149},
  [689] = {.lex_state = 151},
  [690] = {.lex_state = 163},
  [691] = {.lex_state = 163},
  [692] = {.lex_state = 163},
  [693] = {.lex_state = 148},
  [694] = {.lex_state = 163},
  [695] = {.lex_state = 163},
  [696] = {.lex_state = 151},
  [697] = {.lex_state = 148},
  [698] = {.lex_state = 151},
  [699] = {.lex_state = 148},
  [700] = {.lex_state = 163},
  [701] = {.lex_state = 163},
  [702] = {.lex_state = 151},
  [703] = {.lex_state = 163},
  [704] = {.lex_state = 163},
  [705] = {.lex_state = 149},
  [706] = {.lex_state = 151},
  [707] = {.lex_state = 151},
  [708] = {.lex_state = 163},
  [709] = {.lex_state = 151},
  [710] = {.lex_state = 151},
  [711] = {.lex_state = 151},
  [712] = {.lex_state = 151},
  [713] = {.lex_state = 163},
  [714] = {.lex_state = 163},
  [715] = {.lex_state = 149},
  [716] = {.lex_state = 151},
  [717] = {.lex_state = 148},
  [718] = {.lex_state = 151},
  [719] = {.lex_state = 151},
  [720] = {.lex_state = 151},
  [721] = {.lex_state = 151},
  [722] = {.lex_state = 163},
  [723] = {.lex_state = 151},
  [724] = {.lex_state = 151},
  [725] = {.lex_state = 151},
  [726] = {.lex_state = 163},
  [727] = {.lex_state = 151},
  [728] = {.lex_state = 163},
  [729] = {.lex_state = 163},
  [730] = {.lex_state = 163},
  [731] = {.lex_state = 151},
  [732] = {.lex_state = 151},
  [733] = {.lex_state = 149},
  [734] = {.lex_state = 163},
  [735] = {.lex_state = 151},
  [736] = {.lex_state = 163},
  [737] = {.lex_state = 148},
  [738] = {.lex_state = 163},
  [739] = {.lex_state = 163},
  [740] = {.lex_state = 148},
  [741] = {.lex_state = 149},
  [742] = {.lex_state = 163},
  [743] = {.lex_state = 163},
  [744] = {.lex_state = 151},
  [745] = {.lex_state = 151},
  [746] = {.lex_state = 151},
  [747] = {.lex_state = 148},
  [748] = {.lex_state = 148},
  [749] = {.lex_state = 163},
  [750] = {.lex_state = 163},
  [751] = {.lex_state = 163},
  [752] = {.lex_state = 163},
  [753] = {.lex_state = 163},
  [754] = {.lex_state = 163},
  [755] = {.lex_state = 163},
  [756] = {.lex_state = 163},
  [757] = {.lex_state = 148},
  [758] = {.lex_state = 163},
  [759] = {.lex_state = 148},
  [760] = {.lex_state = 148},
  [761] = {.lex_state = 163},
  [762] = {.lex_state = 163},
  [763] = {.lex_state = 151},
  [764] = {.lex_state = 163},
  [765] = {.lex_state = 163},
  [766] = {.lex_state = 151},
  [767] = {.lex_state = 148},
  [768] = {.lex_state = 163},
  [769] = {.lex_state = 148},
  [770] = {.lex_state = 163},
  [771] = {.lex_state = 163},
  [772] = {.lex_state = 163},
  [773] = {.lex_state = 151},
  [774] = {.lex_state = 151},
  [775] = {.lex_state = 148},
  [776] = {.lex_state = 148},
  [777] = {.lex_state = 163},
  [778] = {.lex_state = 151},
  [779] = {.lex_state = 163},
  [780] = {.lex_state = 151},
  [781] = {.lex_state = 148},
  [782] = {.lex_state = 151},
  [783] = {.lex_state = 163},
  [784] = {.lex_state = 148},
  [785] = {.lex_state = 148},
  [786] = {.lex_state = 151},
  [787] = {.lex_state = 163},
  [788] = {.lex_state = 148},
  [789] = {.lex_state = 163},
  [790] = {.lex_state = 163},
  [791] = {.lex_state = 148},
  [792] = {.lex_state = 151},
  [793] = {.lex_state = 151},
  [794] = {.lex_state = 163},
  [795] = {.lex_state = 163},
  [796] = {.lex_state = 163},
  [797] = {.lex_state = 148},
  [798] = {.lex_state = 163},
  [799] = {.lex_state = 163},
  [800] = {.lex_state = 148},
  [801] = {.lex_state = 151},
  [802] = {.lex_state = 148},
  [803] = {.lex_state = 148},
  [804] = {.lex_state = 151},
  [805] = {.lex_state = 151},
  [806] = {.lex_state = 148},
  [807] = {.lex_state = 151},
  [808] = {.lex_state = 148},
  [809] = {.lex_state = 163},
  [810] = {.lex_state = 148},
  [811] = {.lex_state = 151},
  [812] = {.lex_state = 151},
  [813] = {.lex_state = 163},
  [814] = {.lex_state = 151},
  [815] = {.lex_state = 151},
  [816] = {.lex_state = 151},
  [817] = {.lex_state = 151},
  [818] = {.lex_state = 151},
  [819] = {.lex_state = 151},
  [820] = {.lex_state = 151},
  [821] = {.lex_state = 151},
  [822] = {.lex_state = 151},
  [823] = {.lex_state = 151},
  [824] = {.lex_state = 148},
  [825] = {.lex_state = 151},
  [826] = {.lex_state = 151},
  [827] = {.lex_state = 148},
  [828] = {.lex_state = 163},
  [829] = {.lex_state = 142},
  [830] = {.lex_state = 142},
  [831] = {.lex_state = 142},
  [832] = {.lex_state = 156},
  [833] = {.lex_state = 157},
  [834] = {.lex_state = 148},
  [835] = {.lex_state = 148},
  [836] = {.lex_state = 148},
  [837] = {.lex_state = 148},
  [838] = {.lex_state = 163},
  [839] = {.lex_state = 163},
  [840] = {.lex_state = 163},
  [841] = {.lex_state = 163},
  [842] = {.lex_state = 163},
  [843] = {.lex_state = 148},
  [844] = {.lex_state = 163},
  [845] = {.lex_state = 163},
  [846] = {.lex_state = 148},
  [847] = {.lex_state = 163},
  [848] = {.lex_state = 163},
  [849] = {.lex_state = 148},
  [850] = {.lex_state = 163},
  [851] = {.lex_state = 148},
  [852] = {.lex_state = 163},
  [853] = {.lex_state = 148},
  [854] = {.lex_state = 148},
  [855] = {.lex_state = 148},
  [856] = {.lex_state = 148},
  [857] = {.lex_state = 148},
  [858] = {.lex_state = 148},
  [859] = {.lex_state = 148},
  [860] = {.lex_state = 148},
  [861] = {.lex_state = 148},
  [862] = {.lex_state = 148},
  [863] = {.lex_state = 148},
  [864] = {.lex_state = 148},
  [865] = {.lex_state = 148},
  [866] = {.lex_state = 148},
  [867] = {.lex_state = 148},
  [868] = {.lex_state = 148},
  [869] = {.lex_state = 148},
  [870] = {.lex_state = 148},
  [871] = {.lex_state = 148},
  [872] = {.lex_state = 148},
  [873] = {.lex_state = 148},
  [874] = {.lex_state = 148},
  [875] = {.lex_state = 146},
  [876] = {.lex_state = 146},
  [877] = {.lex_state = 146},
  [878] = {.lex_state = 158},
  [879] = {.lex_state = 158},
  [880] = {.lex_state = 158},
  [881] = {.lex_state = 158},
  [882] = {.lex_state = 158},
  [883] = {.lex_state = 158},
  [884] = {.lex_state = 156},
  [885] = {.lex_state = 158},
  [886] = {.lex_state = 158},
  [887] = {.lex_state = 156},
  [888] = {.lex_state = 156},
  [889] = {.lex_state = 158},
  [890] = {.lex_state = 158},
  [891] = {.lex_state = 158},
  [892] = {.lex_state = 158},
  [893] = {.lex_state = 158},
  [894] = {.lex_state = 158},
  [895] = {.lex_state = 158},
  [896] = {.lex_state = 158},
  [897] = {.lex_state = 158},
  [898] = {.lex_state = 158},
  [899] = {.lex_state = 156},
  [900] = {.lex_state = 158},
  [901] = {.lex_state = 158},
  [902] = {.lex_state = 158},
  [903] = {.lex_state = 158},
  [904] = {.lex_state = 158},
  [905] = {.lex_state = 158},
  [906] = {.lex_state = 158},
  [907] = {.lex_state = 158},
  [908] = {.lex_state = 156},
  [909] = {.lex_state = 158},
  [910] = {.lex_state = 158},
  [911] = {.lex_state = 158},
  [912] = {.lex_state = 158},
  [913] = {.lex_state = 158},
  [914] = {.lex_state = 156},
  [915] = {.lex_state = 156},
  [916] = {.lex_state = 158},
  [917] = {.lex_state = 156},
  [918] = {.lex_state = 158},
  [919] = {.lex_state = 158},
  [920] = {.lex_state = 158},
  [921] = {.lex_state = 158},
  [922] = {.lex_state = 156},
  [923] = {.lex_state = 158},
  [924] = {.lex_state = 158},
  [925] = {.lex_state = 158},
  [926] = {.lex_state = 158},
  [927] = {.lex_state = 158},
  [928] = {.lex_state = 158},
  [929] = {.lex_state = 158},
  [930] = {.lex_state = 156},
  [931] = {.lex_state = 158},
  [932] = {.lex_state = 156},
  [933] = {.lex_state = 158},
  [934] = {.lex_state = 158},
  [935] = {.lex_state = 156},
  [936] = {.lex_state = 156},
  [937] = {.lex_state = 156},
  [938] = {.lex_state = 158},
  [939] = {.lex_state = 156},
  [940] = {.lex_state = 158},
  [941] = {.lex_state = 158},
  [942] = {.lex_state = 158},
  [943] = {.lex_state = 158},
  [944] = {.lex_state = 158},
  [945] = {.lex_state = 158},
  [946] = {.lex_state = 158},
  [947] = {.lex_state = 158},
  [948] = {.lex_state = 156},
  [949] = {.lex_state = 156},
  [950] = {.lex_state = 158},
  [951] = {.lex_state = 158},
  [952] = {.lex_state = 158},
  [953] = {.lex_state = 158},
  [954] = {.lex_state = 158},
  [955] = {.lex_state = 158},
  [956] = {.lex_state = 156},
  [957] = {.lex_state = 158},
  [958] = {.lex_state = 156},
  [959] = {.lex_state = 156},
  [960] = {.lex_state = 156},
  [961] = {.lex_state = 156},
  [962] = {.lex_state = 156},
  [963] = {.lex_state = 156},
  [964] = {.lex_state = 156},
  [965] = {.lex_state = 156},
  [966] = {.lex_state = 156},
  [967] = {.lex_state = 146},
  [968] = {.lex_state = 146},
  [969] = {.lex_state = 158},
  [970] = {.lex_state = 156},
  [971] = {.lex_state = 156},
  [972] = {.lex_state = 156},
  [973] = {.lex_state = 156},
  [974] = {.lex_state = 158},
  [975] = {.lex_state = 156},
  [976] = {.lex_state = 156},
  [977] = {.lex_state = 156},
  [978] = {.lex_state = 156},
  [979] = {.lex_state = 156},
  [980] = {.lex_state = 158},
  [981] = {.lex_state = 146},
  [982] = {.lex_state = 156},
  [983] = {.lex_state = 156},
  [984] = {.lex_state = 156},
  [985] = {.lex_state = 156},
  [986] = {.lex_state = 156},
  [987] = {.lex_state = 156},
  [988] = {.lex_state = 156},
  [989] = {.lex_state = 156},
  [990] = {.lex_state = 156},
  [991] = {.lex_state = 156},
  [992] = {.lex_state = 146},
  [993] = {.lex_state = 156},
  [994] = {.lex_state = 159},
  [995] = {.lex_state = 163},
  [996] = {.lex_state = 159},
  [997] = {.lex_state = 156},
  [998] = {.lex_state = 146},
  [999] = {.lex_state = 163},
  [1000] = {.lex_state = 163},
  [1001] = {.lex_state = 156},
  [1002] = {.lex_state = 156},
  [1003] = {.lex_state = 159},
  [1004] = {.lex_state = 146},
  [1005] = {.lex_state = 156},
  [1006] = {.lex_state = 163},
  [1007] = {.lex_state = 159},
  [1008] = {.lex_state = 156},
  [1009] = {.lex_state = 163},
  [1010] = {.lex_state = 159},
  [1011] = {.lex_state = 163},
  [1012] = {.lex_state = 156},
  [1013] = {.lex_state = 156},
  [1014] = {.lex_state = 159},
  [1015] = {.lex_state = 146},
  [1016] = {.lex_state = 146},
  [1017] = {.lex_state = 146},
  [1018] = {.lex_state = 146},
  [1019] = {.lex_state = 160},
  [1020] = {.lex_state = 146},
  [1021] = {.lex_state = 159},
  [1022] = {.lex_state = 156},
  [1023] = {.lex_state = 160},
  [1024] = {.lex_state = 146},
  [1025] = {.lex_state = 146},
  [1026] = {.lex_state = 146},
  [1027] = {.lex_state = 146},
  [1028] = {.lex_state = 146},
  [1029] = {.lex_state = 146},
  [1030] = {.lex_state = 146},
  [1031] = {.lex_state = 146},
  [1032] = {.lex_state = 156},
  [1033] = {.lex_state = 146},
  [1034] = {.lex_state = 146},
  [1035] = {.lex_state = 146},
  [1036] = {.lex_state = 146},
  [1037] = {.lex_state = 146},
  [1038] = {.lex_state = 146},
  [1039] = {.lex_state = 146},
  [1040] = {.lex_state = 146},
  [1041] = {.lex_state = 146},
  [1042] = {.lex_state = 156},
  [1043] = {.lex_state = 146},
  [1044] = {.lex_state = 146},
  [1045] = {.lex_state = 146},
  [1046] = {.lex_state = 146},
  [1047] = {.lex_state = 146},
  [1048] = {.lex_state = 146},
  [1049] = {.lex_state = 146},
  [1050] = {.lex_state = 146},
  [1051] = {.lex_state = 146},
  [1052] = {.lex_state = 146},
  [1053] = {.lex_state = 160},
  [1054] = {.lex_state = 156},
  [1055] = {.lex_state = 146},
  [1056] = {.lex_state = 146},
  [1057] = {.lex_state = 146},
  [1058] = {.lex_state = 156},
  [1059] = {.lex_state = 146},
  [1060] = {.lex_state = 156},
  [1061] = {.lex_state = 146},
  [1062] = {.lex_state = 156},
  [1063] = {.lex_state = 159},
  [1064] = {.lex_state = 159},
  [1065] = {.lex_state = 156},
  [1066] = {.lex_state = 156},
  [1067] = {.lex_state = 156},
  [1068] = {.lex_state = 156},
  [1069] = {.lex_state = 159},
  [1070] = {.lex_state = 161},
  [1071] = {.lex_state = 161},
  [1072] = {.lex_state = 161},
  [1073] = {.lex_state = 161},
  [1074] = {.lex_state = 156},
  [1075] = {.lex_state = 161},
  [1076] = {.lex_state = 159},
  [1077] = {.lex_state = 161},
  [1078] = {.lex_state = 146, .external_lex_state = 1},
  [1079] = {.lex_state = 146, .external_lex_state = 1},
  [1080] = {.lex_state = 146, .external_lex_state = 1},
  [1081] = {.lex_state = 160},
  [1082] = {.lex_state = 146},
  [1083] = {.lex_state = 160},
  [1084] = {.lex_state = 160},
  [1085] = {.lex_state = 160},
  [1086] = {.lex_state = 160},
  [1087] = {.lex_state = 146, .external_lex_state = 1},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 146, .external_lex_state = 1},
  [1090] = {.lex_state = 146, .external_lex_state = 1},
  [1091] = {.lex_state = 146, .external_lex_state = 1},
  [1092] = {.lex_state = 146, .external_lex_state = 1},
  [1093] = {.lex_state = 146},
  [1094] = {.lex_state = 161},
  [1095] = {.lex_state = 160},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 160},
  [1098] = {.lex_state = 146, .external_lex_state = 1},
  [1099] = {.lex_state = 160},
  [1100] = {.lex_state = 146},
  [1101] = {.lex_state = 146},
  [1102] = {.lex_state = 160},
  [1103] = {.lex_state = 146, .external_lex_state = 1},
  [1104] = {.lex_state = 146, .external_lex_state = 1},
  [1105] = {.lex_state = 146, .external_lex_state = 1},
  [1106] = {.lex_state = 160},
  [1107] = {.lex_state = 146},
  [1108] = {.lex_state = 146},
  [1109] = {.lex_state = 146},
  [1110] = {.lex_state = 146, .external_lex_state = 1},
  [1111] = {.lex_state = 156},
  [1112] = {.lex_state = 146},
  [1113] = {.lex_state = 160},
  [1114] = {.lex_state = 160},
  [1115] = {.lex_state = 143},
  [1116] = {.lex_state = 146},
  [1117] = {.lex_state = 159},
  [1118] = {.lex_state = 146},
  [1119] = {.lex_state = 159},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 156},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 156},
  [1128] = {.lex_state = 156},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 146},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 146},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 156},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 159},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 146, .external_lex_state = 1},
  [1143] = {.lex_state = 146},
  [1144] = {.lex_state = 156},
  [1145] = {.lex_state = 160},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 160},
  [1150] = {.lex_state = 143},
  [1151] = {.lex_state = 160},
  [1152] = {.lex_state = 146},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 146},
  [1156] = {.lex_state = 146},
  [1157] = {.lex_state = 146},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 146},
  [1160] = {.lex_state = 156},
  [1161] = {.lex_state = 160},
  [1162] = {.lex_state = 160},
  [1163] = {.lex_state = 160},
  [1164] = {.lex_state = 159},
  [1165] = {.lex_state = 146},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 143},
  [1168] = {.lex_state = 159},
  [1169] = {.lex_state = 160},
  [1170] = {.lex_state = 146},
  [1171] = {.lex_state = 146},
  [1172] = {.lex_state = 160},
  [1173] = {.lex_state = 146},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 146},
  [1176] = {.lex_state = 160},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 160},
  [1179] = {.lex_state = 146},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 160},
  [1183] = {.lex_state = 146},
  [1184] = {.lex_state = 159},
  [1185] = {.lex_state = 0},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 159},
  [1188] = {.lex_state = 146},
  [1189] = {.lex_state = 146},
  [1190] = {.lex_state = 156},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 146},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 143},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 160},
  [1200] = {.lex_state = 160},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 143},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 143},
  [1205] = {.lex_state = 0},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 0},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 143},
  [1210] = {.lex_state = 146},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 146},
  [1214] = {.lex_state = 143},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 170},
  [1217] = {.lex_state = 146},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 143},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 0},
  [1224] = {.lex_state = 0},
  [1225] = {.lex_state = 143},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 143},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 0},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 160},
  [1235] = {.lex_state = 146},
  [1236] = {.lex_state = 0},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 0},
  [1243] = {.lex_state = 143},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 146},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 170},
  [1250] = {.lex_state = 0},
  [1251] = {.lex_state = 143},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 0},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 0},
  [1256] = {.lex_state = 143},
  [1257] = {.lex_state = 143},
  [1258] = {.lex_state = 143},
  [1259] = {.lex_state = 0},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 0},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 146},
  [1264] = {.lex_state = 146},
  [1265] = {.lex_state = 160},
  [1266] = {.lex_state = 0},
  [1267] = {.lex_state = 143},
  [1268] = {.lex_state = 0},
  [1269] = {.lex_state = 143},
  [1270] = {.lex_state = 143},
  [1271] = {.lex_state = 0},
  [1272] = {.lex_state = 0},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 0},
  [1275] = {.lex_state = 143},
  [1276] = {.lex_state = 0},
  [1277] = {.lex_state = 0},
  [1278] = {.lex_state = 0},
  [1279] = {.lex_state = 0},
  [1280] = {.lex_state = 143},
  [1281] = {.lex_state = 0},
  [1282] = {.lex_state = 143},
  [1283] = {.lex_state = 0},
  [1284] = {.lex_state = 0},
  [1285] = {.lex_state = 146},
  [1286] = {.lex_state = 0},
  [1287] = {.lex_state = 0},
  [1288] = {.lex_state = 0},
  [1289] = {.lex_state = 0},
  [1290] = {.lex_state = 0},
  [1291] = {.lex_state = 143},
  [1292] = {.lex_state = 0},
  [1293] = {.lex_state = 0},
  [1294] = {.lex_state = 0},
  [1295] = {.lex_state = 160},
  [1296] = {.lex_state = 0},
  [1297] = {.lex_state = 0},
  [1298] = {.lex_state = 0},
  [1299] = {.lex_state = 0},
  [1300] = {.lex_state = 0},
  [1301] = {.lex_state = 0},
  [1302] = {.lex_state = 143},
  [1303] = {.lex_state = 0},
  [1304] = {.lex_state = 0},
  [1305] = {.lex_state = 0},
  [1306] = {.lex_state = 0},
  [1307] = {.lex_state = 146},
  [1308] = {.lex_state = 0},
  [1309] = {.lex_state = 0},
  [1310] = {.lex_state = 146},
  [1311] = {.lex_state = 0},
  [1312] = {.lex_state = 0},
  [1313] = {.lex_state = 0},
  [1314] = {.lex_state = 0},
  [1315] = {.lex_state = 160},
  [1316] = {.lex_state = 0},
  [1317] = {.lex_state = 0},
  [1318] = {.lex_state = 0},
  [1319] = {.lex_state = 156},
  [1320] = {.lex_state = 0},
  [1321] = {.lex_state = 0},
  [1322] = {.lex_state = 146},
  [1323] = {.lex_state = 0},
  [1324] = {.lex_state = 0},
  [1325] = {.lex_state = 0},
  [1326] = {.lex_state = 0},
  [1327] = {.lex_state = 0},
  [1328] = {.lex_state = 0},
  [1329] = {.lex_state = 0},
  [1330] = {.lex_state = 0},
  [1331] = {.lex_state = 0},
  [1332] = {.lex_state = 0},
  [1333] = {.lex_state = 0},
  [1334] = {.lex_state = 0},
  [1335] = {.lex_state = 0},
  [1336] = {.lex_state = 160},
  [1337] = {.lex_state = 0},
  [1338] = {.lex_state = 0},
  [1339] = {.lex_state = 0},
  [1340] = {.lex_state = 143},
  [1341] = {.lex_state = 0},
  [1342] = {.lex_state = 0},
  [1343] = {.lex_state = 0},
  [1344] = {.lex_state = 0},
  [1345] = {.lex_state = 0},
  [1346] = {.lex_state = 0},
  [1347] = {.lex_state = 0},
  [1348] = {.lex_state = 0},
  [1349] = {.lex_state = 143},
  [1350] = {.lex_state = 0},
  [1351] = {.lex_state = 0},
  [1352] = {.lex_state = 0},
  [1353] = {.lex_state = 0},
  [1354] = {.lex_state = 0},
  [1355] = {.lex_state = 0},
  [1356] = {.lex_state = 0},
  [1357] = {.lex_state = 170},
  [1358] = {.lex_state = 0},
  [1359] = {.lex_state = 0},
  [1360] = {.lex_state = 0},
  [1361] = {.lex_state = 0},
  [1362] = {.lex_state = 163},
  [1363] = {.lex_state = 170},
  [1364] = {.lex_state = 0},
  [1365] = {.lex_state = 0},
  [1366] = {.lex_state = 160},
  [1367] = {.lex_state = 160},
  [1368] = {.lex_state = 0},
  [1369] = {.lex_state = 0},
  [1370] = {.lex_state = 0},
  [1371] = {.lex_state = 0},
  [1372] = {.lex_state = 160},
  [1373] = {.lex_state = 160},
  [1374] = {.lex_state = 0},
  [1375] = {.lex_state = 0},
  [1376] = {.lex_state = 0},
  [1377] = {.lex_state = 0},
  [1378] = {.lex_state = 0},
  [1379] = {.lex_state = 0},
  [1380] = {.lex_state = 160},
  [1381] = {.lex_state = 0},
  [1382] = {.lex_state = 0},
  [1383] = {.lex_state = 0},
  [1384] = {.lex_state = 160},
  [1385] = {.lex_state = 0},
  [1386] = {.lex_state = 0},
  [1387] = {.lex_state = 146},
  [1388] = {.lex_state = 0},
  [1389] = {.lex_state = 0},
  [1390] = {.lex_state = 0},
  [1391] = {.lex_state = 0},
  [1392] = {.lex_state = 0},
  [1393] = {.lex_state = 0},
  [1394] = {.lex_state = 0},
  [1395] = {.lex_state = 0},
  [1396] = {.lex_state = 0},
  [1397] = {.lex_state = 143},
  [1398] = {.lex_state = 0},
  [1399] = {.lex_state = 0},
  [1400] = {.lex_state = 0},
  [1401] = {.lex_state = 0},
  [1402] = {.lex_state = 0},
  [1403] = {.lex_state = 0},
  [1404] = {.lex_state = 143},
  [1405] = {.lex_state = 0},
  [1406] = {.lex_state = 0},
  [1407] = {.lex_state = 0},
  [1408] = {.lex_state = 0},
  [1409] = {.lex_state = 0},
  [1410] = {.lex_state = 170},
  [1411] = {.lex_state = 170},
  [1412] = {.lex_state = 160},
  [1413] = {.lex_state = 0},
  [1414] = {.lex_state = 143},
  [1415] = {.lex_state = 0},
  [1416] = {.lex_state = 160},
  [1417] = {.lex_state = 170},
  [1418] = {.lex_state = 0},
  [1419] = {.lex_state = 0},
  [1420] = {.lex_state = 170},
  [1421] = {.lex_state = 170},
  [1422] = {.lex_state = 170},
  [1423] = {.lex_state = 160},
  [1424] = {.lex_state = 0},
  [1425] = {.lex_state = 0},
  [1426] = {.lex_state = 143},
  [1427] = {.lex_state = 0},
  [1428] = {.lex_state = 0},
  [1429] = {.lex_state = 0},
  [1430] = {.lex_state = 160},
  [1431] = {.lex_state = 0},
  [1432] = {.lex_state = 170},
  [1433] = {.lex_state = 160},
  [1434] = {.lex_state = 170},
  [1435] = {.lex_state = 0},
  [1436] = {.lex_state = 160},
  [1437] = {.lex_state = 160},
  [1438] = {.lex_state = 170},
  [1439] = {.lex_state = 0},
  [1440] = {.lex_state = 0},
  [1441] = {.lex_state = 0},
  [1442] = {.lex_state = 0},
  [1443] = {.lex_state = 0},
  [1444] = {.lex_state = 160},
  [1445] = {.lex_state = 0},
  [1446] = {.lex_state = 0},
  [1447] = {.lex_state = 160},
  [1448] = {.lex_state = 0},
  [1449] = {.lex_state = 160},
  [1450] = {.lex_state = 143},
  [1451] = {.lex_state = 0},
  [1452] = {.lex_state = 0},
  [1453] = {.lex_state = 160},
  [1454] = {.lex_state = 146},
  [1455] = {.lex_state = 0},
  [1456] = {.lex_state = 160},
  [1457] = {.lex_state = 160},
  [1458] = {.lex_state = 0},
  [1459] = {.lex_state = 0},
  [1460] = {.lex_state = 0},
  [1461] = {.lex_state = 160},
  [1462] = {.lex_state = 146},
  [1463] = {.lex_state = 143},
  [1464] = {.lex_state = 170},
  [1465] = {.lex_state = 160},
  [1466] = {.lex_state = 170},
  [1467] = {.lex_state = 160},
  [1468] = {.lex_state = 0},
  [1469] = {.lex_state = 160},
  [1470] = {.lex_state = 0},
  [1471] = {.lex_state = 0},
  [1472] = {.lex_state = 0},
  [1473] = {.lex_state = 0},
  [1474] = {.lex_state = 0},
  [1475] = {.lex_state = 0},
  [1476] = {.lex_state = 0},
  [1477] = {.lex_state = 0},
  [1478] = {.lex_state = 0},
  [1479] = {.lex_state = 0},
  [1480] = {.lex_state = 0},
  [1481] = {.lex_state = 0},
  [1482] = {.lex_state = 0},
  [1483] = {.lex_state = 160},
  [1484] = {.lex_state = 0},
  [1485] = {.lex_state = 0},
  [1486] = {.lex_state = 0},
  [1487] = {.lex_state = 0},
  [1488] = {.lex_state = 0},
  [1489] = {.lex_state = 160},
  [1490] = {.lex_state = 146},
  [1491] = {.lex_state = 0},
  [1492] = {.lex_state = 0},
  [1493] = {.lex_state = 0},
  [1494] = {.lex_state = 0},
  [1495] = {.lex_state = 0},
  [1496] = {.lex_state = 0},
  [1497] = {.lex_state = 170},
  [1498] = {.lex_state = 0},
  [1499] = {.lex_state = 160},
  [1500] = {.lex_state = 0},
  [1501] = {.lex_state = 0},
  [1502] = {.lex_state = 143},
  [1503] = {.lex_state = 0},
  [1504] = {.lex_state = 143},
  [1505] = {.lex_state = 0},
  [1506] = {.lex_state = 0},
  [1507] = {.lex_state = 0},
  [1508] = {.lex_state = 0},
  [1509] = {.lex_state = 0},
  [1510] = {.lex_state = 0},
  [1511] = {.lex_state = 143},
  [1512] = {.lex_state = 160},
  [1513] = {.lex_state = 0},
  [1514] = {.lex_state = 0},
  [1515] = {.lex_state = 0},
  [1516] = {.lex_state = 0},
  [1517] = {.lex_state = 0},
  [1518] = {.lex_state = 0},
  [1519] = {.lex_state = 0},
  [1520] = {.lex_state = 0},
  [1521] = {.lex_state = 0},
  [1522] = {.lex_state = 0},
  [1523] = {.lex_state = 0},
  [1524] = {.lex_state = 0},
  [1525] = {.lex_state = 0},
  [1526] = {.lex_state = 143},
  [1527] = {.lex_state = 0},
  [1528] = {.lex_state = 0},
  [1529] = {.lex_state = 143},
  [1530] = {.lex_state = 0},
  [1531] = {.lex_state = 143},
  [1532] = {.lex_state = 0},
  [1533] = {.lex_state = 0},
  [1534] = {.lex_state = 0},
  [1535] = {.lex_state = 0},
  [1536] = {.lex_state = 146},
  [1537] = {.lex_state = 0},
  [1538] = {.lex_state = 160},
  [1539] = {.lex_state = 0},
  [1540] = {.lex_state = 0},
  [1541] = {.lex_state = 0},
  [1542] = {.lex_state = 0},
  [1543] = {.lex_state = 0},
  [1544] = {.lex_state = 143},
  [1545] = {.lex_state = 0},
  [1546] = {.lex_state = 0},
  [1547] = {.lex_state = 0},
  [1548] = {.lex_state = 0},
  [1549] = {.lex_state = 143},
  [1550] = {.lex_state = 0},
  [1551] = {.lex_state = 143},
  [1552] = {.lex_state = 0},
  [1553] = {.lex_state = 143},
  [1554] = {.lex_state = 0},
  [1555] = {.lex_state = 0},
  [1556] = {.lex_state = 0},
  [1557] = {.lex_state = 0},
  [1558] = {.lex_state = 0},
  [1559] = {.lex_state = 143},
  [1560] = {.lex_state = 0},
  [1561] = {.lex_state = 0},
  [1562] = {.lex_state = 0},
  [1563] = {.lex_state = 0},
  [1564] = {.lex_state = 0},
  [1565] = {.lex_state = 0},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 0},
  [1568] = {.lex_state = 0},
  [1569] = {.lex_state = 0},
  [1570] = {.lex_state = 0},
  [1571] = {.lex_state = 0},
  [1572] = {.lex_state = 0},
  [1573] = {.lex_state = 0},
  [1574] = {.lex_state = 0},
  [1575] = {.lex_state = 0},
  [1576] = {.lex_state = 0},
  [1577] = {.lex_state = 143},
  [1578] = {.lex_state = 0},
  [1579] = {.lex_state = 0},
  [1580] = {.lex_state = 0},
  [1581] = {.lex_state = 0},
  [1582] = {.lex_state = 143},
  [1583] = {.lex_state = 0},
  [1584] = {.lex_state = 0},
  [1585] = {.lex_state = 0},
  [1586] = {.lex_state = 143},
  [1587] = {.lex_state = 0},
  [1588] = {.lex_state = 0},
  [1589] = {.lex_state = 0},
  [1590] = {.lex_state = 0},
  [1591] = {.lex_state = 0},
  [1592] = {.lex_state = 146},
  [1593] = {.lex_state = 0},
  [1594] = {.lex_state = 146},
  [1595] = {.lex_state = 0},
  [1596] = {.lex_state = 0},
  [1597] = {.lex_state = 0},
  [1598] = {.lex_state = 0},
  [1599] = {.lex_state = 0},
  [1600] = {.lex_state = 143},
  [1601] = {.lex_state = 0},
  [1602] = {.lex_state = 143},
  [1603] = {.lex_state = 0},
  [1604] = {.lex_state = 0},
  [1605] = {.lex_state = 0},
  [1606] = {.lex_state = 0},
  [1607] = {.lex_state = 0},
  [1608] = {.lex_state = 0},
  [1609] = {.lex_state = 0},
  [1610] = {.lex_state = 0},
  [1611] = {.lex_state = 0},
  [1612] = {.lex_state = 146},
  [1613] = {.lex_state = 0},
  [1614] = {.lex_state = 0},
  [1615] = {.lex_state = 0},
  [1616] = {.lex_state = 0},
  [1617] = {.lex_state = 0},
  [1618] = {.lex_state = 0},
  [1619] = {.lex_state = 0},
  [1620] = {.lex_state = 0},
  [1621] = {.lex_state = 0},
  [1622] = {.lex_state = 0},
  [1623] = {.lex_state = 0},
  [1624] = {.lex_state = 0},
  [1625] = {.lex_state = 0},
  [1626] = {.lex_state = 0},
  [1627] = {.lex_state = 0},
  [1628] = {.lex_state = 0},
  [1629] = {.lex_state = 0},
  [1630] = {.lex_state = 0},
};

enum {
  ts_external_token_quoted_content = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_quoted_content] = sym_quoted_content,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_quoted_content] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_erlang] = ACTIONS(1),
    [anon_sym_javascript] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_size] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT_DOT] = ACTIONS(1),
    [anon_sym_LT_EQ_DOT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_DOT] = ACTIONS(1),
    [anon_sym_GT_EQ_DOT] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PLUS_DOT] = ACTIONS(1),
    [anon_sym_DASH_DOT] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_STAR_DOT] = ACTIONS(1),
    [anon_sym_SLASH_DOT] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_todo] = ACTIONS(1),
    [anon_sym_panic] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [sym_visibility_modifier] = ACTIONS(1),
    [sym_opacity_modifier] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE2] = ACTIONS(1),
    [aux_sym_escape_sequence_token1] = ACTIONS(1),
    [aux_sym_escape_sequence_token2] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym__hex] = ACTIONS(1),
    [sym__decimal] = ACTIONS(1),
    [sym__octal] = ACTIONS(1),
    [sym__binary] = ACTIONS(1),
    [anon_sym_binary] = ACTIONS(1),
    [anon_sym_bytes] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_bit_string] = ACTIONS(1),
    [anon_sym_bits] = ACTIONS(1),
    [anon_sym_utf8] = ACTIONS(1),
    [anon_sym_utf16] = ACTIONS(1),
    [anon_sym_utf32] = ACTIONS(1),
    [anon_sym_utf8_codepoint] = ACTIONS(1),
    [anon_sym_utf16_codepoint] = ACTIONS(1),
    [anon_sym_utf32_codepoint] = ACTIONS(1),
    [anon_sym_signed] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_big] = ACTIONS(1),
    [anon_sym_little] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_unit] = ACTIONS(1),
    [sym__discard_name] = ACTIONS(1),
    [sym__name] = ACTIONS(1),
    [sym__upname] = ACTIONS(1),
    [sym_quoted_content] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(1608),
    [sym__module_statement] = STATE(3),
    [sym_target_group] = STATE(3),
    [sym_attribute] = STATE(3),
    [sym_import] = STATE(3),
    [sym_constant] = STATE(3),
    [sym_external_type] = STATE(3),
    [sym_external_function] = STATE(3),
    [sym_function] = STATE(3),
    [aux_sym__statement_seq] = STATE(4),
    [sym__statement] = STATE(553),
    [sym__expression] = STATE(123),
    [sym_binary_expression] = STATE(123),
    [sym__expression_unit] = STATE(123),
    [sym_record] = STATE(78),
    [sym_todo] = STATE(123),
    [sym_panic] = STATE(123),
    [sym_tuple] = STATE(77),
    [sym_list] = STATE(123),
    [sym__expression_bit_string] = STATE(123),
    [sym_anonymous_function] = STATE(75),
    [sym_block] = STATE(36),
    [sym_case] = STATE(36),
    [sym_let_assert] = STATE(553),
    [sym_let] = STATE(553),
    [sym_use] = STATE(553),
    [sym_assert] = STATE(123),
    [sym_boolean_negation] = STATE(123),
    [sym_integer_negation] = STATE(123),
    [sym_record_update] = STATE(78),
    [sym__maybe_tuple_expression] = STATE(1605),
    [sym_tuple_access] = STATE(36),
    [sym__maybe_record_expression] = STATE(1604),
    [sym_field_access] = STATE(36),
    [sym__maybe_function_expression] = STATE(1396),
    [sym_function_call] = STATE(36),
    [sym_type_definition] = STATE(3),
    [sym_type_alias] = STATE(3),
    [sym_string] = STATE(123),
    [sym_integer] = STATE(123),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(6),
    [sym_remote_constructor_name] = STATE(6),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LT_LT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_todo] = ACTIONS(33),
    [anon_sym_panic] = ACTIONS(35),
    [anon_sym_case] = ACTIONS(37),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_assert] = ACTIONS(41),
    [anon_sym_use] = ACTIONS(43),
    [anon_sym_BANG] = ACTIONS(45),
    [sym_visibility_modifier] = ACTIONS(47),
    [sym_opacity_modifier] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [sym_float] = ACTIONS(53),
    [sym__hex] = ACTIONS(55),
    [sym__decimal] = ACTIONS(57),
    [sym__octal] = ACTIONS(55),
    [sym__binary] = ACTIONS(55),
    [sym__name] = ACTIONS(59),
    [sym__upname] = ACTIONS(61),
  },
  [2] = {
    [sym__module_statement] = STATE(2),
    [sym_target_group] = STATE(2),
    [sym_attribute] = STATE(2),
    [sym_import] = STATE(2),
    [sym_constant] = STATE(2),
    [sym_external_type] = STATE(2),
    [sym_external_function] = STATE(2),
    [sym_function] = STATE(2),
    [aux_sym__statement_seq] = STATE(4),
    [sym__statement] = STATE(553),
    [sym__expression] = STATE(123),
    [sym_binary_expression] = STATE(123),
    [sym__expression_unit] = STATE(123),
    [sym_record] = STATE(78),
    [sym_todo] = STATE(123),
    [sym_panic] = STATE(123),
    [sym_tuple] = STATE(77),
    [sym_list] = STATE(123),
    [sym__expression_bit_string] = STATE(123),
    [sym_anonymous_function] = STATE(75),
    [sym_block] = STATE(36),
    [sym_case] = STATE(36),
    [sym_let_assert] = STATE(553),
    [sym_let] = STATE(553),
    [sym_use] = STATE(553),
    [sym_assert] = STATE(123),
    [sym_boolean_negation] = STATE(123),
    [sym_integer_negation] = STATE(123),
    [sym_record_update] = STATE(78),
    [sym__maybe_tuple_expression] = STATE(1605),
    [sym_tuple_access] = STATE(36),
    [sym__maybe_record_expression] = STATE(1604),
    [sym_field_access] = STATE(36),
    [sym__maybe_function_expression] = STATE(1396),
    [sym_function_call] = STATE(36),
    [sym_type_definition] = STATE(2),
    [sym_type_alias] = STATE(2),
    [sym_string] = STATE(123),
    [sym_integer] = STATE(123),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(6),
    [sym_remote_constructor_name] = STATE(6),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(63),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(68),
    [anon_sym_AT] = ACTIONS(71),
    [anon_sym_import] = ACTIONS(74),
    [anon_sym_type] = ACTIONS(77),
    [anon_sym_const] = ACTIONS(80),
    [anon_sym_POUND] = ACTIONS(83),
    [anon_sym_LBRACK] = ACTIONS(86),
    [anon_sym_LT_LT] = ACTIONS(89),
    [anon_sym_DASH] = ACTIONS(92),
    [anon_sym_fn] = ACTIONS(95),
    [anon_sym_external] = ACTIONS(98),
    [anon_sym_todo] = ACTIONS(101),
    [anon_sym_panic] = ACTIONS(104),
    [anon_sym_case] = ACTIONS(107),
    [anon_sym_let] = ACTIONS(110),
    [anon_sym_assert] = ACTIONS(113),
    [anon_sym_use] = ACTIONS(116),
    [anon_sym_BANG] = ACTIONS(119),
    [sym_visibility_modifier] = ACTIONS(122),
    [sym_opacity_modifier] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(128),
    [sym_float] = ACTIONS(131),
    [sym__hex] = ACTIONS(134),
    [sym__decimal] = ACTIONS(137),
    [sym__octal] = ACTIONS(134),
    [sym__binary] = ACTIONS(134),
    [sym__name] = ACTIONS(140),
    [sym__upname] = ACTIONS(143),
  },
  [3] = {
    [sym__module_statement] = STATE(2),
    [sym_target_group] = STATE(2),
    [sym_attribute] = STATE(2),
    [sym_import] = STATE(2),
    [sym_constant] = STATE(2),
    [sym_external_type] = STATE(2),
    [sym_external_function] = STATE(2),
    [sym_function] = STATE(2),
    [aux_sym__statement_seq] = STATE(4),
    [sym__statement] = STATE(553),
    [sym__expression] = STATE(123),
    [sym_binary_expression] = STATE(123),
    [sym__expression_unit] = STATE(123),
    [sym_record] = STATE(78),
    [sym_todo] = STATE(123),
    [sym_panic] = STATE(123),
    [sym_tuple] = STATE(77),
    [sym_list] = STATE(123),
    [sym__expression_bit_string] = STATE(123),
    [sym_anonymous_function] = STATE(75),
    [sym_block] = STATE(36),
    [sym_case] = STATE(36),
    [sym_let_assert] = STATE(553),
    [sym_let] = STATE(553),
    [sym_use] = STATE(553),
    [sym_assert] = STATE(123),
    [sym_boolean_negation] = STATE(123),
    [sym_integer_negation] = STATE(123),
    [sym_record_update] = STATE(78),
    [sym__maybe_tuple_expression] = STATE(1605),
    [sym_tuple_access] = STATE(36),
    [sym__maybe_record_expression] = STATE(1604),
    [sym_field_access] = STATE(36),
    [sym__maybe_function_expression] = STATE(1396),
    [sym_function_call] = STATE(36),
    [sym_type_definition] = STATE(2),
    [sym_type_alias] = STATE(2),
    [sym_string] = STATE(123),
    [sym_integer] = STATE(123),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(6),
    [sym_remote_constructor_name] = STATE(6),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(146),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_LT_LT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_fn] = ACTIONS(29),
    [anon_sym_external] = ACTIONS(31),
    [anon_sym_todo] = ACTIONS(33),
    [anon_sym_panic] = ACTIONS(35),
    [anon_sym_case] = ACTIONS(37),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_assert] = ACTIONS(41),
    [anon_sym_use] = ACTIONS(43),
    [anon_sym_BANG] = ACTIONS(45),
    [sym_visibility_modifier] = ACTIONS(47),
    [sym_opacity_modifier] = ACTIONS(49),
    [anon_sym_DQUOTE] = ACTIONS(51),
    [sym_float] = ACTIONS(53),
    [sym__hex] = ACTIONS(55),
    [sym__decimal] = ACTIONS(57),
    [sym__octal] = ACTIONS(55),
    [sym__binary] = ACTIONS(55),
    [sym__name] = ACTIONS(59),
    [sym__upname] = ACTIONS(61),
  },
  [4] = {
    [aux_sym__statement_seq] = STATE(5),
    [sym__statement] = STATE(553),
    [sym__expression] = STATE(123),
    [sym_binary_expression] = STATE(123),
    [sym__expression_unit] = STATE(123),
    [sym_record] = STATE(78),
    [sym_todo] = STATE(123),
    [sym_panic] = STATE(123),
    [sym_tuple] = STATE(77),
    [sym_list] = STATE(123),
    [sym__expression_bit_string] = STATE(123),
    [sym_anonymous_function] = STATE(75),
    [sym_block] = STATE(36),
    [sym_case] = STATE(36),
    [sym_let_assert] = STATE(553),
    [sym_let] = STATE(553),
    [sym_use] = STATE(553),
    [sym_assert] = STATE(123),
    [sym_boolean_negation] = STATE(123),
    [sym_integer_negation] = STATE(123),
    [sym_record_update] = STATE(78),
    [sym__maybe_tuple_expression] = STATE(1605),
    [sym_tuple_access] = STATE(36),
    [sym__maybe_record_expression] = STATE(1604),
    [sym_field_access] = STATE(36),
    [sym__maybe_function_expression] = STATE(1396),
    [sym_function_call] = STATE(36),
    [sym_string] = STATE(123),
    [sym_integer] = STATE(123),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(6),
    [sym_remote_constructor_name] = STATE(6),
    [ts_builtin_sym_end] = ACTIONS(148),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(150),
    [anon_sym_LBRACE] = ACTIONS(152),
    [anon_sym_AT] = ACTIONS(148),
    [anon_sym_import] = ACTIONS(150),
    [anon_sym_type] = ACTIONS(150),
    [anon_sym_const] = ACTIONS(150),
    [anon_sym_POUND] = ACTIONS(155),
    [anon_sym_LBRACK] = ACTIONS(158),
    [anon_sym_LT_LT] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(164),
    [anon_sym_fn] = ACTIONS(167),
    [anon_sym_external] = ACTIONS(150),
    [anon_sym_todo] = ACTIONS(170),
    [anon_sym_panic] = ACTIONS(173),
    [anon_sym_case] = ACTIONS(176),
    [anon_sym_let] = ACTIONS(179),
    [anon_sym_assert] = ACTIONS(182),
    [anon_sym_use] = ACTIONS(185),
    [anon_sym_BANG] = ACTIONS(188),
    [sym_visibility_modifier] = ACTIONS(150),
    [sym_opacity_modifier] = ACTIONS(150),
    [anon_sym_DQUOTE] = ACTIONS(191),
    [sym_float] = ACTIONS(194),
    [sym__hex] = ACTIONS(197),
    [sym__decimal] = ACTIONS(200),
    [sym__octal] = ACTIONS(197),
    [sym__binary] = ACTIONS(197),
    [sym__name] = ACTIONS(203),
    [sym__upname] = ACTIONS(206),
  },
  [5] = {
    [aux_sym__statement_seq] = STATE(5),
    [sym__statement] = STATE(553),
    [sym__expression] = STATE(123),
    [sym_binary_expression] = STATE(123),
    [sym__expression_unit] = STATE(123),
    [sym_record] = STATE(78),
    [sym_todo] = STATE(123),
    [sym_panic] = STATE(123),
    [sym_tuple] = STATE(77),
    [sym_list] = STATE(123),
    [sym__expression_bit_string] = STATE(123),
    [sym_anonymous_function] = STATE(75),
    [sym_block] = STATE(36),
    [sym_case] = STATE(36),
    [sym_let_assert] = STATE(553),
    [sym_let] = STATE(553),
    [sym_use] = STATE(553),
    [sym_assert] = STATE(123),
    [sym_boolean_negation] = STATE(123),
    [sym_integer_negation] = STATE(123),
    [sym_record_update] = STATE(78),
    [sym__maybe_tuple_expression] = STATE(1605),
    [sym_tuple_access] = STATE(36),
    [sym__maybe_record_expression] = STATE(1604),
    [sym_field_access] = STATE(36),
    [sym__maybe_function_expression] = STATE(1396),
    [sym_function_call] = STATE(36),
    [sym_string] = STATE(123),
    [sym_integer] = STATE(123),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(6),
    [sym_remote_constructor_name] = STATE(6),
    [ts_builtin_sym_end] = ACTIONS(209),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(211),
    [anon_sym_LBRACE] = ACTIONS(213),
    [anon_sym_AT] = ACTIONS(209),
    [anon_sym_import] = ACTIONS(211),
    [anon_sym_type] = ACTIONS(211),
    [anon_sym_const] = ACTIONS(211),
    [anon_sym_POUND] = ACTIONS(216),
    [anon_sym_LBRACK] = ACTIONS(219),
    [anon_sym_LT_LT] = ACTIONS(222),
    [anon_sym_DASH] = ACTIONS(225),
    [anon_sym_fn] = ACTIONS(228),
    [anon_sym_external] = ACTIONS(211),
    [anon_sym_todo] = ACTIONS(231),
    [anon_sym_panic] = ACTIONS(234),
    [anon_sym_case] = ACTIONS(237),
    [anon_sym_let] = ACTIONS(240),
    [anon_sym_assert] = ACTIONS(243),
    [anon_sym_use] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(249),
    [sym_visibility_modifier] = ACTIONS(211),
    [sym_opacity_modifier] = ACTIONS(211),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_float] = ACTIONS(255),
    [sym__hex] = ACTIONS(258),
    [sym__decimal] = ACTIONS(261),
    [sym__octal] = ACTIONS(258),
    [sym__binary] = ACTIONS(258),
    [sym__name] = ACTIONS(264),
    [sym__upname] = ACTIONS(267),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(274), 1,
      anon_sym_LPAREN,
    STATE(59), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(272), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(270), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [71] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(278), 1,
      anon_sym_RBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [197] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(316), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [323] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(318), 1,
      anon_sym_RBRACE,
    STATE(16), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [449] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(320), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [575] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(322), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [701] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(326), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(324), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [767] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(330), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(328), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [833] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(332), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [959] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(334), 1,
      anon_sym_RBRACE,
    STATE(35), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1085] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(336), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1211] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(342), 1,
      anon_sym_LPAREN,
    ACTIONS(344), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(340), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(338), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1281] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(350), 1,
      anon_sym_LPAREN,
    ACTIONS(352), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(348), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(346), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1351] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(356), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(354), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1417] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(358), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1543] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(362), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(360), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1609] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(364), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1735] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(368), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(366), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1801] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(372), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(370), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1867] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(376), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(374), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1933] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(378), 1,
      anon_sym_RBRACE,
    STATE(50), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2059] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(382), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(380), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2125] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(386), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(384), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2191] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(390), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(388), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [2257] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(392), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2383] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(394), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2509] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(396), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2635] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(398), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2761] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(400), 1,
      anon_sym_RBRACE,
    STATE(57), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2887] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(402), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3013] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(410), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(404), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3083] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(415), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(413), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3149] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(417), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3275] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(419), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3401] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(421), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(404), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3471] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(425), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3597] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(209), 1,
      anon_sym_RBRACE,
    ACTIONS(427), 1,
      anon_sym_LBRACE,
    ACTIONS(430), 1,
      anon_sym_POUND,
    ACTIONS(433), 1,
      anon_sym_LBRACK,
    ACTIONS(436), 1,
      anon_sym_LT_LT,
    ACTIONS(439), 1,
      anon_sym_DASH,
    ACTIONS(442), 1,
      anon_sym_fn,
    ACTIONS(445), 1,
      anon_sym_todo,
    ACTIONS(448), 1,
      anon_sym_panic,
    ACTIONS(451), 1,
      anon_sym_case,
    ACTIONS(454), 1,
      anon_sym_let,
    ACTIONS(457), 1,
      anon_sym_assert,
    ACTIONS(460), 1,
      anon_sym_use,
    ACTIONS(463), 1,
      anon_sym_BANG,
    ACTIONS(466), 1,
      anon_sym_DQUOTE,
    ACTIONS(469), 1,
      sym_float,
    ACTIONS(475), 1,
      sym__decimal,
    ACTIONS(478), 1,
      sym__name,
    ACTIONS(481), 1,
      sym__upname,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(472), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3723] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(486), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(484), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3789] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(488), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3915] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(490), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4041] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(494), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(492), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4107] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(496), 1,
      anon_sym_RBRACE,
    STATE(41), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4233] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(498), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4359] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(502), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(500), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4425] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(504), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4551] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(508), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(506), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4617] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(510), 1,
      anon_sym_RBRACE,
    STATE(20), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4743] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(512), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4869] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(516), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(514), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4935] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(518), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5061] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(520), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5187] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(522), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5313] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(524), 1,
      anon_sym_RBRACE,
    STATE(53), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5439] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(528), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(526), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5504] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(30), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5627] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(530), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5692] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(8), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5815] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(38), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5938] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(536), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(534), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6003] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(33), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6126] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(55), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6249] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(10), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6372] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(14), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6495] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(386), 20,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(384), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6560] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(32), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6683] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(540), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(538), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6748] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(544), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(542), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6813] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(548), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(546), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6878] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(45), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7001] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(404), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7068] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(56), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7191] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(550), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(404), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7258] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(552), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(404), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7325] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(44), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7448] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(556), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(554), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7513] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(48), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7636] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(560), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(558), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7701] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(31), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7824] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(22), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [7947] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(296), 1,
      anon_sym_let,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(300), 1,
      anon_sym_use,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(306), 1,
      sym_float,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    STATE(11), 1,
      aux_sym__statement_seq,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 4,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(332), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [8070] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(564), 1,
      anon_sym_RPAREN,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(580), 1,
      anon_sym_DOT_DOT,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1274), 1,
      sym_argument,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [8196] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(604), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(602), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8260] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(606), 1,
      anon_sym_RPAREN,
    ACTIONS(608), 1,
      anon_sym_DOT_DOT,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1238), 1,
      sym_argument,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [8386] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(612), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(610), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8450] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(614), 1,
      anon_sym_RPAREN,
    ACTIONS(616), 1,
      anon_sym_DOT_DOT,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1283), 1,
      sym_argument,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [8576] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(620), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(618), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8640] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(624), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(622), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8704] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(628), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(626), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8768] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(632), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(630), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8832] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(636), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(634), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8896] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(644), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(646), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(648), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(638), 21,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(640), 21,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8968] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(650), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9032] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(656), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(654), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9096] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(658), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(644), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(646), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(648), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(638), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(640), 21,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9170] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(658), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(644), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(646), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(648), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(660), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(662), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(638), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(640), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9248] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(658), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(644), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(646), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(664), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(648), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(660), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(662), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(638), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(640), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9328] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(658), 1,
      anon_sym_PIPE_GT,
    ACTIONS(666), 1,
      anon_sym_AMP_AMP,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(644), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(646), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(664), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(648), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(660), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(662), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(638), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(640), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9410] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(670), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(668), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9474] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(648), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(638), 23,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(640), 23,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9542] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(640), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(638), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9606] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(658), 1,
      anon_sym_PIPE_GT,
    ACTIONS(666), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(644), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(646), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(664), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(648), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(660), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(662), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(672), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(674), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9690] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(658), 1,
      anon_sym_PIPE_GT,
    ACTIONS(666), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(644), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(646), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(664), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(648), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(660), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(662), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(678), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(680), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9774] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(684), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(682), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9838] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(688), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(686), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9902] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(658), 1,
      anon_sym_PIPE_GT,
    ACTIONS(666), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(644), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(646), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(664), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(648), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(660), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(662), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(690), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(692), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9986] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(696), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(694), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10050] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(700), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(698), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10114] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(704), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(702), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10178] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(709), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(706), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10242] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(712), 1,
      anon_sym_RPAREN,
    ACTIONS(714), 1,
      anon_sym_DOT_DOT,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1260), 1,
      sym_argument,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10368] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(718), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(716), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10432] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(658), 1,
      anon_sym_PIPE_GT,
    ACTIONS(666), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(644), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(646), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(664), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(648), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(660), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(662), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(720), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(722), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10516] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(658), 1,
      anon_sym_PIPE_GT,
    ACTIONS(666), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(644), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(646), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(664), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(648), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(660), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(662), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(724), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(726), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10600] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(730), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(728), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10664] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(658), 1,
      anon_sym_PIPE_GT,
    ACTIONS(666), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(644), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(646), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(664), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(648), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(660), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(662), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(732), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(734), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [10748] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(736), 1,
      anon_sym_RPAREN,
    ACTIONS(738), 1,
      anon_sym_DOT_DOT,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1339), 1,
      sym_argument,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10874] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(742), 25,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(740), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10938] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(658), 1,
      anon_sym_PIPE_GT,
    ACTIONS(666), 1,
      anon_sym_AMP_AMP,
    ACTIONS(676), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(642), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(644), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(646), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(664), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(648), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(660), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(662), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(744), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(746), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [11022] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(564), 1,
      anon_sym_RPAREN,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1274), 1,
      sym_argument,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11145] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(736), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1339), 1,
      sym_argument,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11268] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(748), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1440), 1,
      sym_argument,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11391] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(382), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(380), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11454] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(390), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(388), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11517] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(750), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1440), 1,
      sym_argument,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11640] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(712), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1260), 1,
      sym_argument,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11763] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(752), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1440), 1,
      sym_argument,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11886] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(606), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1238), 1,
      sym_argument,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12009] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(372), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(370), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12072] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(754), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1440), 1,
      sym_argument,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12195] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(326), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(324), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12258] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(756), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1440), 1,
      sym_argument,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12381] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(758), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1440), 1,
      sym_argument,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12504] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(760), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1440), 1,
      sym_argument,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12627] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(762), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1440), 1,
      sym_argument,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12750] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(764), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1440), 1,
      sym_argument,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12873] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(614), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1283), 1,
      sym_argument,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12996] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(766), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1440), 1,
      sym_argument,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13119] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(768), 1,
      anon_sym_LPAREN,
    STATE(180), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(272), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(270), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13185] = 32,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(772), 1,
      sym_float,
    ACTIONS(774), 1,
      sym__name,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1435), 1,
      sym_hole,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(770), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(717), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13303] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(590), 1,
      sym_float,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(596), 1,
      sym__discard_name,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1440), 1,
      sym_argument,
    STATE(1441), 1,
      sym_hole,
    STATE(1550), 1,
      sym_label,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(740), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13423] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(508), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(506), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13484] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(330), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(328), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13545] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(410), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(404), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13610] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(776), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(404), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13675] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(704), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(702), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13736] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(486), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(484), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13797] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(670), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(668), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13858] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(494), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(492), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13919] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(362), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(360), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13980] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(415), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(413), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14041] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(368), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(366), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14102] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(356), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(354), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14163] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(376), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(374), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14224] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(502), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(500), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14285] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(536), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(534), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14345] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(552), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(404), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14407] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(404), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14469] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(780), 1,
      anon_sym_RBRACK,
    ACTIONS(782), 1,
      anon_sym_DOT_DOT,
    ACTIONS(784), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14583] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(550), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(404), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14645] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(786), 1,
      anon_sym_RBRACK,
    ACTIONS(788), 1,
      anon_sym_DOT_DOT,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14759] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(790), 1,
      anon_sym_RBRACK,
    ACTIONS(792), 1,
      anon_sym_DOT_DOT,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14873] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(548), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(546), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14933] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(794), 1,
      anon_sym_RBRACK,
    ACTIONS(796), 1,
      anon_sym_DOT_DOT,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15047] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(540), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(538), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15107] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(556), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(554), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15167] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(530), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15227] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(800), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(798), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(737), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15339] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(802), 1,
      anon_sym_RBRACK,
    ACTIONS(804), 1,
      anon_sym_DOT_DOT,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15453] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(560), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(558), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15513] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(806), 1,
      anon_sym_RBRACK,
    ACTIONS(808), 1,
      anon_sym_DOT_DOT,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15627] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(544), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(542), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15687] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(810), 1,
      anon_sym_RBRACK,
    ACTIONS(812), 1,
      anon_sym_DOT_DOT,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15801] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(814), 1,
      anon_sym_RBRACK,
    ACTIONS(816), 1,
      anon_sym_DOT_DOT,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15915] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(818), 1,
      anon_sym_RBRACK,
    ACTIONS(820), 1,
      anon_sym_DOT_DOT,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16029] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(528), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(526), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16089] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(822), 1,
      anon_sym_RBRACK,
    ACTIONS(824), 1,
      anon_sym_DOT_DOT,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16203] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(826), 1,
      anon_sym_RPAREN,
    ACTIONS(828), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(676), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16314] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(830), 1,
      anon_sym_RPAREN,
    ACTIONS(832), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(693), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16425] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(834), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16536] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(836), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16647] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(604), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(602), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16706] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(612), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(610), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16765] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(688), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(686), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [16824] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(838), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16935] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(840), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17046] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(842), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17157] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(844), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1558), 1,
      sym_case_subjects,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(699), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17268] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(636), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(634), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17327] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(846), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17438] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(848), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17549] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(656), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(654), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17608] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(632), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(630), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17667] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(730), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(728), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17726] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(709), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(706), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17785] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(844), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1572), 1,
      sym_case_subjects,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(699), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17896] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(844), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1584), 1,
      sym_case_subjects,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(699), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18007] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(850), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18118] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(628), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(626), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18177] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(852), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18288] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(650), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18347] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(700), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(698), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18406] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(854), 1,
      anon_sym_RPAREN,
    ACTIONS(856), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(677), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18517] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(844), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1573), 1,
      sym_case_subjects,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(699), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18628] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(742), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(740), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18687] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(696), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(694), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [18746] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(858), 1,
      anon_sym_RBRACK,
    ACTIONS(860), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(661), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18857] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(862), 1,
      anon_sym_RBRACK,
    ACTIONS(864), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(658), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18968] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(844), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1528), 1,
      sym_case_subjects,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(699), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19079] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(866), 1,
      anon_sym_RPAREN,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19190] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(868), 1,
      anon_sym_RPAREN,
    ACTIONS(870), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(697), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19301] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(624), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(622), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19360] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(684), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(682), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19419] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(872), 1,
      anon_sym_RBRACK,
    ACTIONS(874), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(670), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19530] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(876), 1,
      anon_sym_RPAREN,
    ACTIONS(878), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(682), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19641] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(880), 1,
      anon_sym_RBRACK,
    ACTIONS(882), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(672), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19752] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(884), 1,
      anon_sym_RBRACK,
    ACTIONS(886), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(673), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19863] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(718), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(716), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19922] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(620), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(618), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [19981] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(888), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(802), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20089] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(914), 1,
      sym_float,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(409), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20197] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(924), 1,
      sym_float,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(399), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20305] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(926), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(808), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20413] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(928), 1,
      anon_sym_GT_GT,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1399), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20525] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(942), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1399), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20637] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(944), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(803), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20745] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(946), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(791), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20853] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(948), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1254), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20965] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(950), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1273), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21077] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(952), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(760), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21185] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21293] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(954), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(797), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21401] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(956), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(776), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21509] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(958), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(759), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21617] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(960), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(788), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21725] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(962), 1,
      sym_float,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(423), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21833] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(964), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(767), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21941] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(966), 1,
      anon_sym_LBRACE,
    ACTIONS(968), 1,
      anon_sym_POUND,
    ACTIONS(970), 1,
      anon_sym_LBRACK,
    ACTIONS(972), 1,
      anon_sym_LT_LT,
    ACTIONS(974), 1,
      anon_sym_DASH,
    ACTIONS(976), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      anon_sym_todo,
    ACTIONS(980), 1,
      anon_sym_panic,
    ACTIONS(982), 1,
      anon_sym_case,
    ACTIONS(984), 1,
      anon_sym_assert,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(990), 1,
      sym_float,
    ACTIONS(994), 1,
      sym__decimal,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    STATE(679), 1,
      sym_identifier,
    STATE(729), 1,
      sym_tuple,
    STATE(734), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym__maybe_function_expression,
    STATE(1519), 1,
      sym__maybe_tuple_expression,
    STATE(1581), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(667), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(728), 2,
      sym_record,
      sym_record_update,
    ACTIONS(992), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(795), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22049] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(966), 1,
      anon_sym_LBRACE,
    ACTIONS(968), 1,
      anon_sym_POUND,
    ACTIONS(970), 1,
      anon_sym_LBRACK,
    ACTIONS(972), 1,
      anon_sym_LT_LT,
    ACTIONS(974), 1,
      anon_sym_DASH,
    ACTIONS(976), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      anon_sym_todo,
    ACTIONS(980), 1,
      anon_sym_panic,
    ACTIONS(982), 1,
      anon_sym_case,
    ACTIONS(984), 1,
      anon_sym_assert,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(994), 1,
      sym__decimal,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    ACTIONS(1000), 1,
      sym_float,
    STATE(679), 1,
      sym_identifier,
    STATE(729), 1,
      sym_tuple,
    STATE(734), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym__maybe_function_expression,
    STATE(1519), 1,
      sym__maybe_tuple_expression,
    STATE(1581), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(667), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(728), 2,
      sym_record,
      sym_record_update,
    ACTIONS(992), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(754), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22157] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(966), 1,
      anon_sym_LBRACE,
    ACTIONS(968), 1,
      anon_sym_POUND,
    ACTIONS(970), 1,
      anon_sym_LBRACK,
    ACTIONS(972), 1,
      anon_sym_LT_LT,
    ACTIONS(974), 1,
      anon_sym_DASH,
    ACTIONS(976), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      anon_sym_todo,
    ACTIONS(980), 1,
      anon_sym_panic,
    ACTIONS(982), 1,
      anon_sym_case,
    ACTIONS(984), 1,
      anon_sym_assert,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(994), 1,
      sym__decimal,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    ACTIONS(1002), 1,
      sym_float,
    STATE(679), 1,
      sym_identifier,
    STATE(729), 1,
      sym_tuple,
    STATE(734), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym__maybe_function_expression,
    STATE(1519), 1,
      sym__maybe_tuple_expression,
    STATE(1581), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(667), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(728), 2,
      sym_record,
      sym_record_update,
    ACTIONS(992), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(799), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22265] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1004), 1,
      anon_sym_LPAREN,
    ACTIONS(1006), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(340), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(338), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [22327] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1008), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(340), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22435] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1010), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(784), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22543] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(966), 1,
      anon_sym_LBRACE,
    ACTIONS(968), 1,
      anon_sym_POUND,
    ACTIONS(970), 1,
      anon_sym_LBRACK,
    ACTIONS(972), 1,
      anon_sym_LT_LT,
    ACTIONS(974), 1,
      anon_sym_DASH,
    ACTIONS(976), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      anon_sym_todo,
    ACTIONS(980), 1,
      anon_sym_panic,
    ACTIONS(982), 1,
      anon_sym_case,
    ACTIONS(984), 1,
      anon_sym_assert,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(994), 1,
      sym__decimal,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    ACTIONS(1012), 1,
      sym_float,
    STATE(679), 1,
      sym_identifier,
    STATE(729), 1,
      sym_tuple,
    STATE(734), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym__maybe_function_expression,
    STATE(1519), 1,
      sym__maybe_tuple_expression,
    STATE(1581), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(667), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(728), 2,
      sym_record,
      sym_record_update,
    ACTIONS(992), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(790), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22651] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(966), 1,
      anon_sym_LBRACE,
    ACTIONS(968), 1,
      anon_sym_POUND,
    ACTIONS(970), 1,
      anon_sym_LBRACK,
    ACTIONS(972), 1,
      anon_sym_LT_LT,
    ACTIONS(974), 1,
      anon_sym_DASH,
    ACTIONS(976), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      anon_sym_todo,
    ACTIONS(980), 1,
      anon_sym_panic,
    ACTIONS(982), 1,
      anon_sym_case,
    ACTIONS(984), 1,
      anon_sym_assert,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(994), 1,
      sym__decimal,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    ACTIONS(1014), 1,
      sym_float,
    STATE(679), 1,
      sym_identifier,
    STATE(729), 1,
      sym_tuple,
    STATE(734), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym__maybe_function_expression,
    STATE(1519), 1,
      sym__maybe_tuple_expression,
    STATE(1581), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(667), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(728), 2,
      sym_record,
      sym_record_update,
    ACTIONS(992), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(749), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22759] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(1016), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1207), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22871] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1020), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(107), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22979] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(966), 1,
      anon_sym_LBRACE,
    ACTIONS(968), 1,
      anon_sym_POUND,
    ACTIONS(970), 1,
      anon_sym_LBRACK,
    ACTIONS(972), 1,
      anon_sym_LT_LT,
    ACTIONS(974), 1,
      anon_sym_DASH,
    ACTIONS(976), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      anon_sym_todo,
    ACTIONS(980), 1,
      anon_sym_panic,
    ACTIONS(982), 1,
      anon_sym_case,
    ACTIONS(984), 1,
      anon_sym_assert,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(994), 1,
      sym__decimal,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    ACTIONS(1022), 1,
      sym_float,
    STATE(679), 1,
      sym_identifier,
    STATE(729), 1,
      sym_tuple,
    STATE(734), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym__maybe_function_expression,
    STATE(1519), 1,
      sym__maybe_tuple_expression,
    STATE(1581), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(667), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(728), 2,
      sym_record,
      sym_record_update,
    ACTIONS(992), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(751), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23087] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(966), 1,
      anon_sym_LBRACE,
    ACTIONS(968), 1,
      anon_sym_POUND,
    ACTIONS(970), 1,
      anon_sym_LBRACK,
    ACTIONS(972), 1,
      anon_sym_LT_LT,
    ACTIONS(974), 1,
      anon_sym_DASH,
    ACTIONS(976), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      anon_sym_todo,
    ACTIONS(980), 1,
      anon_sym_panic,
    ACTIONS(982), 1,
      anon_sym_case,
    ACTIONS(984), 1,
      anon_sym_assert,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(994), 1,
      sym__decimal,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    ACTIONS(1024), 1,
      sym_float,
    STATE(679), 1,
      sym_identifier,
    STATE(729), 1,
      sym_tuple,
    STATE(734), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym__maybe_function_expression,
    STATE(1519), 1,
      sym__maybe_tuple_expression,
    STATE(1581), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(667), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(728), 2,
      sym_record,
      sym_record_update,
    ACTIONS(992), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(752), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23195] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1026), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(775), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23303] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(966), 1,
      anon_sym_LBRACE,
    ACTIONS(968), 1,
      anon_sym_POUND,
    ACTIONS(970), 1,
      anon_sym_LBRACK,
    ACTIONS(972), 1,
      anon_sym_LT_LT,
    ACTIONS(974), 1,
      anon_sym_DASH,
    ACTIONS(976), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      anon_sym_todo,
    ACTIONS(980), 1,
      anon_sym_panic,
    ACTIONS(982), 1,
      anon_sym_case,
    ACTIONS(984), 1,
      anon_sym_assert,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(994), 1,
      sym__decimal,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    ACTIONS(1028), 1,
      sym_float,
    STATE(679), 1,
      sym_identifier,
    STATE(729), 1,
      sym_tuple,
    STATE(734), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym__maybe_function_expression,
    STATE(1519), 1,
      sym__maybe_tuple_expression,
    STATE(1581), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(667), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(728), 2,
      sym_record,
      sym_record_update,
    ACTIONS(992), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(753), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23411] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1030), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(537), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23519] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(1032), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1399), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23631] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1034), 1,
      anon_sym_LPAREN,
    ACTIONS(1036), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(348), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(346), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [23693] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1038), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(757), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23801] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(966), 1,
      anon_sym_LBRACE,
    ACTIONS(968), 1,
      anon_sym_POUND,
    ACTIONS(970), 1,
      anon_sym_LBRACK,
    ACTIONS(972), 1,
      anon_sym_LT_LT,
    ACTIONS(974), 1,
      anon_sym_DASH,
    ACTIONS(976), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      anon_sym_todo,
    ACTIONS(980), 1,
      anon_sym_panic,
    ACTIONS(982), 1,
      anon_sym_case,
    ACTIONS(984), 1,
      anon_sym_assert,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(994), 1,
      sym__decimal,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    ACTIONS(1040), 1,
      sym_float,
    STATE(679), 1,
      sym_identifier,
    STATE(729), 1,
      sym_tuple,
    STATE(734), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym__maybe_function_expression,
    STATE(1519), 1,
      sym__maybe_tuple_expression,
    STATE(1581), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(667), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(728), 2,
      sym_record,
      sym_record_update,
    ACTIONS(992), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(755), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23909] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1042), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(110), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24017] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1044), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(748), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24125] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(1046), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1399), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24237] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1048), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(117), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24345] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(1050), 1,
      sym_float,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(396), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24453] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(1052), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1399), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24565] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1054), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(526), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24673] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(1056), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1399), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24785] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1058), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(106), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24893] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1060), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(785), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25001] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1062), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(538), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25109] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(966), 1,
      anon_sym_LBRACE,
    ACTIONS(968), 1,
      anon_sym_POUND,
    ACTIONS(970), 1,
      anon_sym_LBRACK,
    ACTIONS(972), 1,
      anon_sym_LT_LT,
    ACTIONS(974), 1,
      anon_sym_DASH,
    ACTIONS(976), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      anon_sym_todo,
    ACTIONS(980), 1,
      anon_sym_panic,
    ACTIONS(982), 1,
      anon_sym_case,
    ACTIONS(984), 1,
      anon_sym_assert,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(994), 1,
      sym__decimal,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    ACTIONS(1064), 1,
      sym_float,
    STATE(679), 1,
      sym_identifier,
    STATE(729), 1,
      sym_tuple,
    STATE(734), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym__maybe_function_expression,
    STATE(1519), 1,
      sym__maybe_tuple_expression,
    STATE(1581), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(667), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(728), 2,
      sym_record,
      sym_record_update,
    ACTIONS(992), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(764), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25217] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(1066), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1399), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25329] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1068), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(493), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25437] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1070), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(747), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25545] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1072), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(494), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25653] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1074), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(806), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25761] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(1076), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1351), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25873] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1078), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(769), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25981] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1080), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(495), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26089] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1082), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(118), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26197] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(1084), 1,
      anon_sym_LBRACE,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26305] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(1087), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1247), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26417] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1089), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(499), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26525] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(784), 1,
      sym_float,
    ACTIONS(1091), 1,
      anon_sym_LBRACE,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26633] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1094), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(512), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26741] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(1096), 1,
      sym_float,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(404), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26849] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1098), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(810), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26957] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1100), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(800), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27065] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1102), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(781), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27173] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1104), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(328), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27281] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1106), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(330), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27389] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1108), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(501), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27497] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(516), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(514), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27555] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1110), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(344), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27663] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(966), 1,
      anon_sym_LBRACE,
    ACTIONS(968), 1,
      anon_sym_POUND,
    ACTIONS(970), 1,
      anon_sym_LBRACK,
    ACTIONS(972), 1,
      anon_sym_LT_LT,
    ACTIONS(974), 1,
      anon_sym_DASH,
    ACTIONS(976), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      anon_sym_todo,
    ACTIONS(980), 1,
      anon_sym_panic,
    ACTIONS(982), 1,
      anon_sym_case,
    ACTIONS(984), 1,
      anon_sym_assert,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(994), 1,
      sym__decimal,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    ACTIONS(1112), 1,
      sym_float,
    STATE(679), 1,
      sym_identifier,
    STATE(729), 1,
      sym_tuple,
    STATE(734), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym__maybe_function_expression,
    STATE(1519), 1,
      sym__maybe_tuple_expression,
    STATE(1581), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(667), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(728), 2,
      sym_record,
      sym_record_update,
    ACTIONS(992), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(794), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27771] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1114), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(105), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27879] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1116), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(104), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27987] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1118), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(348), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28095] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1120), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(102), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28203] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1122), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(350), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28311] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(1124), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1399), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28423] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1126), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(345), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28531] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1128), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(101), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28639] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1130), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(100), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28747] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1132), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(346), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28855] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(1134), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1399), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28967] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1136), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(120), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29075] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1138), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(349), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29183] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1140), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(351), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29291] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1142), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(352), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29399] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(1144), 1,
      sym_float,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(410), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29507] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(1146), 1,
      sym_float,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(411), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29615] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1148), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(99), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29723] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(1150), 1,
      sym_float,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(412), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29831] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(1152), 1,
      sym_float,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(413), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29939] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(1154), 1,
      sym_float,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(414), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30047] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1156), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(96), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30155] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(1158), 1,
      sym_float,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(416), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30263] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    ACTIONS(1160), 1,
      anon_sym_GT_GT,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1399), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30375] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(1162), 1,
      sym_float,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(418), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30483] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(1164), 1,
      sym_float,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(394), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30591] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1166), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(509), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30699] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1168), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(534), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30807] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1170), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(342), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30915] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1172), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(343), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31023] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(940), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1399), 1,
      sym_expression_bit_string_segment,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1206), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31132] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1178), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1180), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1174), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1176), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1182), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(680), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(678), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31208] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(966), 1,
      anon_sym_LBRACE,
    ACTIONS(968), 1,
      anon_sym_POUND,
    ACTIONS(970), 1,
      anon_sym_LBRACK,
    ACTIONS(972), 1,
      anon_sym_LT_LT,
    ACTIONS(974), 1,
      anon_sym_DASH,
    ACTIONS(976), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      anon_sym_todo,
    ACTIONS(980), 1,
      anon_sym_panic,
    ACTIONS(982), 1,
      anon_sym_case,
    ACTIONS(984), 1,
      anon_sym_assert,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    ACTIONS(1194), 1,
      sym_float,
    ACTIONS(1198), 1,
      sym__decimal,
    STATE(679), 1,
      sym_identifier,
    STATE(729), 1,
      sym_tuple,
    STATE(734), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym__maybe_function_expression,
    STATE(1519), 1,
      sym__maybe_tuple_expression,
    STATE(1581), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(667), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(728), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1196), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(777), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31314] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1178), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1180), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1174), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1176), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1182), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(692), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(690), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31390] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1200), 1,
      sym_float,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(488), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31496] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1178), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1180), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1174), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1176), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1182), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(746), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(744), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31572] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(1202), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(196), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31678] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(930), 1,
      anon_sym_DASH,
    ACTIONS(932), 1,
      anon_sym_todo,
    ACTIONS(934), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_assert,
    ACTIONS(938), 1,
      anon_sym_BANG,
    ACTIONS(1204), 1,
      sym_float,
    ACTIONS(1208), 1,
      sym__decimal,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    STATE(1552), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1206), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(198), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31784] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(310), 1,
      sym__decimal,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1202), 1,
      sym_float,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(308), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(196), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31890] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(562), 1,
      anon_sym_LBRACE,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(570), 1,
      anon_sym_LT_LT,
    ACTIONS(572), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_fn,
    ACTIONS(576), 1,
      anon_sym_todo,
    ACTIONS(578), 1,
      anon_sym_panic,
    ACTIONS(582), 1,
      anon_sym_case,
    ACTIONS(584), 1,
      anon_sym_assert,
    ACTIONS(586), 1,
      anon_sym_BANG,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(774), 1,
      sym__name,
    ACTIONS(1210), 1,
      sym_float,
    ACTIONS(1214), 1,
      sym__decimal,
    STATE(462), 1,
      sym_identifier,
    STATE(467), 1,
      sym_anonymous_function,
    STATE(483), 1,
      sym_tuple,
    STATE(1376), 1,
      sym__maybe_function_expression,
    STATE(1555), 1,
      sym__maybe_record_expression,
    STATE(1625), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(447), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(479), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1212), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(460), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(532), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [31996] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      sym__decimal,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1216), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(55), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(98), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32102] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(276), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_POUND,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(284), 1,
      anon_sym_LT_LT,
    ACTIONS(286), 1,
      anon_sym_DASH,
    ACTIONS(288), 1,
      anon_sym_fn,
    ACTIONS(290), 1,
      anon_sym_todo,
    ACTIONS(292), 1,
      anon_sym_panic,
    ACTIONS(294), 1,
      anon_sym_case,
    ACTIONS(298), 1,
      anon_sym_assert,
    ACTIONS(302), 1,
      anon_sym_BANG,
    ACTIONS(304), 1,
      anon_sym_DQUOTE,
    ACTIONS(312), 1,
      sym__name,
    ACTIONS(314), 1,
      sym__upname,
    ACTIONS(1204), 1,
      sym_float,
    ACTIONS(1208), 1,
      sym__decimal,
    STATE(149), 1,
      sym_identifier,
    STATE(162), 1,
      sym_anonymous_function,
    STATE(164), 1,
      sym_tuple,
    STATE(1485), 1,
      sym__maybe_function_expression,
    STATE(1514), 1,
      sym__maybe_tuple_expression,
    STATE(1525), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(143), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(161), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1206), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(148), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(198), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32208] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(1218), 1,
      sym_float,
    ACTIONS(1222), 1,
      sym__decimal,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1220), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(422), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32314] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1178), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1180), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1174), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1176), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1182), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(734), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(732), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32390] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(890), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      anon_sym_POUND,
    ACTIONS(894), 1,
      anon_sym_LBRACK,
    ACTIONS(896), 1,
      anon_sym_LT_LT,
    ACTIONS(898), 1,
      anon_sym_DASH,
    ACTIONS(900), 1,
      anon_sym_fn,
    ACTIONS(902), 1,
      anon_sym_todo,
    ACTIONS(904), 1,
      anon_sym_panic,
    ACTIONS(906), 1,
      anon_sym_case,
    ACTIONS(908), 1,
      anon_sym_assert,
    ACTIONS(910), 1,
      anon_sym_BANG,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    ACTIONS(918), 1,
      sym__decimal,
    ACTIONS(920), 1,
      sym__name,
    ACTIONS(922), 1,
      sym__upname,
    ACTIONS(1224), 1,
      sym_float,
    STATE(379), 1,
      sym_identifier,
    STATE(387), 1,
      sym_tuple,
    STATE(390), 1,
      sym_anonymous_function,
    STATE(1439), 1,
      sym__maybe_function_expression,
    STATE(1517), 1,
      sym__maybe_tuple_expression,
    STATE(1569), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(361), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(393), 2,
      sym_record,
      sym_record_update,
    ACTIONS(916), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(378), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(400), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32496] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1174), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1176), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(640), 14,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(638), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32562] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1174), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1176), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(640), 14,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(638), 20,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32626] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1178), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1180), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1174), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1176), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1182), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(726), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(724), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32702] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(640), 18,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(638), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32758] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1174), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(640), 16,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(638), 22,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32818] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(966), 1,
      anon_sym_LBRACE,
    ACTIONS(968), 1,
      anon_sym_POUND,
    ACTIONS(970), 1,
      anon_sym_LBRACK,
    ACTIONS(972), 1,
      anon_sym_LT_LT,
    ACTIONS(974), 1,
      anon_sym_DASH,
    ACTIONS(976), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      anon_sym_todo,
    ACTIONS(980), 1,
      anon_sym_panic,
    ACTIONS(982), 1,
      anon_sym_case,
    ACTIONS(984), 1,
      anon_sym_assert,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(994), 1,
      sym__decimal,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    ACTIONS(1226), 1,
      sym_float,
    STATE(679), 1,
      sym_identifier,
    STATE(729), 1,
      sym_tuple,
    STATE(734), 1,
      sym_anonymous_function,
    STATE(1481), 1,
      sym__maybe_function_expression,
    STATE(1519), 1,
      sym__maybe_tuple_expression,
    STATE(1581), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(667), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(728), 2,
      sym_record,
      sym_record_update,
    ACTIONS(992), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(692), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(750), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [32924] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1178), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1180), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1174), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1176), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1182), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(722), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(720), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33000] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1180), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1174), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1176), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1182), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(640), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(638), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33074] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1178), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1180), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1174), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1176), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1182), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(674), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(672), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33150] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1174), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1176), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1182), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(640), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(638), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33222] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1188), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1174), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1176), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1190), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1184), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1186), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1192), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(640), 10,
      anon_sym_fn,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(638), 15,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33292] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_POUND,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LT_LT,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(33), 1,
      anon_sym_todo,
    ACTIONS(35), 1,
      anon_sym_panic,
    ACTIONS(37), 1,
      anon_sym_case,
    ACTIONS(41), 1,
      anon_sym_assert,
    ACTIONS(45), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__name,
    ACTIONS(61), 1,
      sym__upname,
    ACTIONS(1018), 1,
      anon_sym_fn,
    ACTIONS(1228), 1,
      sym_float,
    ACTIONS(1232), 1,
      sym__decimal,
    STATE(40), 1,
      sym_identifier,
    STATE(75), 1,
      sym_anonymous_function,
    STATE(77), 1,
      sym_tuple,
    STATE(1396), 1,
      sym__maybe_function_expression,
    STATE(1604), 1,
      sym__maybe_record_expression,
    STATE(1605), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(6), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(78), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1230), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(36), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(119), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [33398] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(382), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(380), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33453] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(386), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(384), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33508] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(326), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(324), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33563] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(390), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(388), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33618] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(372), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(370), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33671] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(670), 9,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(668), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33724] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(704), 9,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(702), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [33777] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1234), 1,
      anon_sym_LPAREN,
    STATE(385), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(272), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(270), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33832] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(508), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(506), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33882] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(494), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(492), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33932] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(356), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(354), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33982] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(326), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(324), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34032] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(368), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(366), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34082] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1236), 1,
      anon_sym_LPAREN,
    ACTIONS(1238), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(348), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(346), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34136] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(486), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(484), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34186] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(330), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(328), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34236] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(415), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(413), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34286] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(362), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(360), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34336] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(382), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(380), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34386] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(502), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(500), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34436] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(376), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(374), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34486] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(372), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(370), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34536] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(516), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(514), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34586] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1240), 1,
      anon_sym_LPAREN,
    ACTIONS(1242), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(340), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(338), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34640] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(410), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(404), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34694] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(1244), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(404), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34748] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(390), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(388), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34798] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(386), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(384), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34848] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(540), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(538), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34897] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(556), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(554), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34946] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(560), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(558), 26,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [34995] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(528), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(526), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35044] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(530), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35093] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(550), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(404), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35144] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1250), 1,
      anon_sym_LPAREN,
    STATE(432), 1,
      sym_constant_record_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1252), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1248), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [35197] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(536), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(534), 26,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35246] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(404), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35297] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(548), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(546), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35346] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(544), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(542), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35395] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(552), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(404), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35446] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1258), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1260), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1268), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1254), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1256), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1262), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1270), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(680), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1264), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1266), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1272), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(678), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35514] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(624), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(622), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35562] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1258), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1260), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1268), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1254), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1256), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1262), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1270), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(734), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1264), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1266), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1272), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(732), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35630] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(620), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(618), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35678] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(628), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(626), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35726] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1258), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1260), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1268), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1254), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1256), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1262), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1270), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1276), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1264), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1266), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1272), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1274), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35794] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(656), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(654), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35842] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(650), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35890] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(700), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(698), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35938] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(742), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(740), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [35986] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1258), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1260), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1268), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1254), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1256), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1262), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1270), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(674), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1264), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1266), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1272), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(672), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36054] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(684), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(682), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36102] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(718), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(716), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36150] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(604), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(602), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36198] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(612), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(610), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36246] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1254), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1256), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1270), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1272), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(640), 7,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(638), 19,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36302] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1268), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1254), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1256), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1270), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1272), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(640), 7,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(638), 18,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36360] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1268), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1254), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1256), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1270), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(640), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1264), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1266), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1272), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(638), 14,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36422] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1268), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1254), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1256), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1262), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1270), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(640), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1264), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1266), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1272), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(638), 12,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36486] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1260), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1268), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1254), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1256), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1262), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1270), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(640), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1264), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1266), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1272), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(638), 11,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36552] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1254), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1272), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(640), 9,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(638), 21,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36604] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(704), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(702), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36652] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(640), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(638), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36700] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(696), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(694), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36748] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1258), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1260), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1268), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1254), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1256), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1262), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1270), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(692), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1264), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1266), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1272), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(690), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36816] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(688), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(686), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36864] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(709), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(706), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36912] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(670), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(668), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [36960] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(730), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(728), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [37008] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1258), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1260), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1268), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1254), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1256), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1262), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1270), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1280), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1264), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1266), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1272), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1278), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [37076] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(636), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(634), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [37124] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(632), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(630), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [37172] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1284), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1282), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37219] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1288), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1286), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37266] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1292), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1290), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37313] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1296), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1294), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37360] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1300), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1298), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37407] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1304), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1302), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37454] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1308), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1306), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37501] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1312), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1310), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37548] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1316), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1314), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37595] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1320), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1318), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37642] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1324), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1322), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37689] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1328), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1326), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37736] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1332), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1330), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37783] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1336), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1334), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37830] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1340), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1338), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37877] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1344), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1342), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37924] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1348), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1346), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [37971] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1352), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(1350), 27,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [38018] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1358), 1,
      anon_sym_SLASH,
    STATE(444), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1354), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1356), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38068] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1365), 1,
      anon_sym_SLASH,
    STATE(446), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1361), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1363), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38118] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1365), 1,
      anon_sym_SLASH,
    STATE(444), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1367), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1369), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38168] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1371), 1,
      anon_sym_LPAREN,
    STATE(472), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(272), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(270), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38218] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(356), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(354), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38263] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(486), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(484), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38308] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(330), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(328), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38353] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1377), 1,
      anon_sym_LPAREN,
    STATE(527), 1,
      sym_type_parameters,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1373), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1375), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38402] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(376), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(374), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38447] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(516), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(514), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38492] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(502), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(500), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38537] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1379), 1,
      anon_sym_LPAREN,
    ACTIONS(1381), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(348), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(346), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38586] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(508), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(506), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38631] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(415), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(413), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38676] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1354), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1356), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38721] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(494), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(492), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38766] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(1383), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(404), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38815] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1386), 1,
      anon_sym_LPAREN,
    ACTIONS(1388), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(340), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(338), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38864] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(1390), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(404), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38913] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(368), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(366), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38958] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(362), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(360), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39003] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1394), 1,
      anon_sym_RBRACE,
    ACTIONS(1396), 1,
      anon_sym_POUND,
    ACTIONS(1398), 1,
      anon_sym_LBRACK,
    ACTIONS(1400), 1,
      anon_sym_LT_LT,
    ACTIONS(1402), 1,
      anon_sym_DASH,
    ACTIONS(1404), 1,
      anon_sym_DQUOTE,
    ACTIONS(1406), 1,
      sym_float,
    ACTIONS(1410), 1,
      sym__decimal,
    ACTIONS(1412), 1,
      sym__discard_name,
    ACTIONS(1414), 1,
      sym__name,
    ACTIONS(1416), 1,
      sym__upname,
    STATE(960), 1,
      sym__pattern_binary_expression,
    STATE(1054), 1,
      sym_identifier,
    STATE(1067), 1,
      sym_string,
    STATE(1125), 1,
      sym__pattern,
    STATE(1144), 1,
      sym_case_clause_pattern,
    STATE(1362), 1,
      sym_case_clause_patterns,
    STATE(1629), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(517), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(899), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1408), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1111), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [39087] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(530), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39131] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(404), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39177] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1396), 1,
      anon_sym_POUND,
    ACTIONS(1398), 1,
      anon_sym_LBRACK,
    ACTIONS(1400), 1,
      anon_sym_LT_LT,
    ACTIONS(1402), 1,
      anon_sym_DASH,
    ACTIONS(1404), 1,
      anon_sym_DQUOTE,
    ACTIONS(1406), 1,
      sym_float,
    ACTIONS(1410), 1,
      sym__decimal,
    ACTIONS(1412), 1,
      sym__discard_name,
    ACTIONS(1414), 1,
      sym__name,
    ACTIONS(1416), 1,
      sym__upname,
    ACTIONS(1418), 1,
      anon_sym_RBRACE,
    STATE(960), 1,
      sym__pattern_binary_expression,
    STATE(1054), 1,
      sym_identifier,
    STATE(1067), 1,
      sym_string,
    STATE(1125), 1,
      sym__pattern,
    STATE(1144), 1,
      sym_case_clause_pattern,
    STATE(1362), 1,
      sym_case_clause_patterns,
    STATE(1527), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(517), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(899), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1408), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1111), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [39261] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1396), 1,
      anon_sym_POUND,
    ACTIONS(1398), 1,
      anon_sym_LBRACK,
    ACTIONS(1400), 1,
      anon_sym_LT_LT,
    ACTIONS(1402), 1,
      anon_sym_DASH,
    ACTIONS(1404), 1,
      anon_sym_DQUOTE,
    ACTIONS(1406), 1,
      sym_float,
    ACTIONS(1410), 1,
      sym__decimal,
    ACTIONS(1412), 1,
      sym__discard_name,
    ACTIONS(1414), 1,
      sym__name,
    ACTIONS(1416), 1,
      sym__upname,
    ACTIONS(1420), 1,
      anon_sym_RBRACE,
    STATE(960), 1,
      sym__pattern_binary_expression,
    STATE(1054), 1,
      sym_identifier,
    STATE(1067), 1,
      sym_string,
    STATE(1125), 1,
      sym__pattern,
    STATE(1144), 1,
      sym_case_clause_pattern,
    STATE(1362), 1,
      sym_case_clause_patterns,
    STATE(1576), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(517), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(899), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1408), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1111), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [39345] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(544), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(542), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39389] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(540), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(538), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39433] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(528), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(526), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39477] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(536), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(534), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39521] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1426), 1,
      anon_sym_LPAREN,
    STATE(564), 1,
      sym_type_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1422), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1424), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39569] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1428), 15,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1430), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39613] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(548), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(546), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39657] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1432), 1,
      anon_sym_LPAREN,
    STATE(629), 1,
      sym_constant_record_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1248), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1252), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39705] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1438), 1,
      anon_sym_LPAREN,
    STATE(606), 1,
      sym__attribute_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1434), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1436), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39753] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1440), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(404), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39799] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1396), 1,
      anon_sym_POUND,
    ACTIONS(1398), 1,
      anon_sym_LBRACK,
    ACTIONS(1400), 1,
      anon_sym_LT_LT,
    ACTIONS(1402), 1,
      anon_sym_DASH,
    ACTIONS(1404), 1,
      anon_sym_DQUOTE,
    ACTIONS(1406), 1,
      sym_float,
    ACTIONS(1410), 1,
      sym__decimal,
    ACTIONS(1412), 1,
      sym__discard_name,
    ACTIONS(1414), 1,
      sym__name,
    ACTIONS(1416), 1,
      sym__upname,
    ACTIONS(1442), 1,
      anon_sym_RBRACE,
    STATE(960), 1,
      sym__pattern_binary_expression,
    STATE(1054), 1,
      sym_identifier,
    STATE(1067), 1,
      sym_string,
    STATE(1125), 1,
      sym__pattern,
    STATE(1144), 1,
      sym_case_clause_pattern,
    STATE(1362), 1,
      sym_case_clause_patterns,
    STATE(1508), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(517), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(899), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1408), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1111), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [39883] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1396), 1,
      anon_sym_POUND,
    ACTIONS(1398), 1,
      anon_sym_LBRACK,
    ACTIONS(1400), 1,
      anon_sym_LT_LT,
    ACTIONS(1402), 1,
      anon_sym_DASH,
    ACTIONS(1404), 1,
      anon_sym_DQUOTE,
    ACTIONS(1406), 1,
      sym_float,
    ACTIONS(1410), 1,
      sym__decimal,
    ACTIONS(1412), 1,
      sym__discard_name,
    ACTIONS(1414), 1,
      sym__name,
    ACTIONS(1416), 1,
      sym__upname,
    ACTIONS(1444), 1,
      anon_sym_RBRACE,
    STATE(960), 1,
      sym__pattern_binary_expression,
    STATE(1054), 1,
      sym_identifier,
    STATE(1067), 1,
      sym_string,
    STATE(1125), 1,
      sym__pattern,
    STATE(1144), 1,
      sym_case_clause_pattern,
    STATE(1362), 1,
      sym_case_clause_patterns,
    STATE(1588), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(517), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(899), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1408), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1111), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [39967] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(556), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(554), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40011] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1446), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(406), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(404), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40057] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(560), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(558), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40101] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1448), 15,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1450), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40145] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1456), 1,
      anon_sym_DOT,
    ACTIONS(1458), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1452), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1454), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40193] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1460), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DASH_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1462), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40236] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(656), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(654), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40279] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1464), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1466), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40322] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1472), 1,
      anon_sym_LBRACE,
    ACTIONS(1474), 1,
      anon_sym_DASH_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1468), 12,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1470), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40369] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(632), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(630), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40412] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(1478), 1,
      anon_sym_DASH,
    ACTIONS(1480), 1,
      anon_sym_size,
    ACTIONS(1486), 1,
      anon_sym_unit,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1476), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1484), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1210), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1482), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [40469] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(640), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(638), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40512] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1488), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1490), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(640), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
    ACTIONS(638), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DOT_DOT,
  [40559] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1494), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1502), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1488), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1492), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1496), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1504), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1490), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1498), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1500), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(638), 9,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_DOT,
  [40618] = 23,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1506), 1,
      anon_sym_RBRACE,
    ACTIONS(1508), 1,
      anon_sym_POUND,
    ACTIONS(1511), 1,
      anon_sym_LBRACK,
    ACTIONS(1514), 1,
      anon_sym_LT_LT,
    ACTIONS(1517), 1,
      anon_sym_DASH,
    ACTIONS(1520), 1,
      anon_sym_DQUOTE,
    ACTIONS(1523), 1,
      sym_float,
    ACTIONS(1529), 1,
      sym__decimal,
    ACTIONS(1532), 1,
      sym__discard_name,
    ACTIONS(1535), 1,
      sym__name,
    ACTIONS(1538), 1,
      sym__upname,
    STATE(960), 1,
      sym__pattern_binary_expression,
    STATE(1054), 1,
      sym_identifier,
    STATE(1067), 1,
      sym_string,
    STATE(1125), 1,
      sym__pattern,
    STATE(1144), 1,
      sym_case_clause_pattern,
    STATE(1362), 1,
      sym_case_clause_patterns,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(496), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(899), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1526), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1111), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [40699] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1541), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1543), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40742] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(628), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(626), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40785] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1502), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1488), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1492), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1496), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1504), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1490), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1498), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1500), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(638), 10,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DOT_DOT,
  [40842] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1545), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DASH_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1547), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40885] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1502), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1488), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1492), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1504), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1490), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1498), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1500), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(638), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DOT_DOT,
  [40940] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1549), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1551), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [40983] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(1396), 1,
      anon_sym_POUND,
    ACTIONS(1398), 1,
      anon_sym_LBRACK,
    ACTIONS(1400), 1,
      anon_sym_LT_LT,
    ACTIONS(1412), 1,
      sym__discard_name,
    ACTIONS(1553), 1,
      anon_sym_RPAREN,
    ACTIONS(1555), 1,
      anon_sym_DASH,
    ACTIONS(1557), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1559), 1,
      sym_float,
    STATE(960), 1,
      sym__pattern_binary_expression,
    STATE(1022), 1,
      sym_identifier,
    STATE(1058), 1,
      sym_string,
    STATE(1131), 1,
      sym_record_pattern_argument,
    STATE(1348), 1,
      sym__pattern,
    STATE(1610), 1,
      sym_label,
    STATE(1621), 1,
      sym_pattern_spread,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(899), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1060), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [41066] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1565), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1561), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1563), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [41111] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(636), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(634), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41154] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1571), 1,
      anon_sym_LBRACE,
    ACTIONS(1573), 1,
      anon_sym_EQ,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1567), 12,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1569), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [41201] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(700), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(698), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41244] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1575), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1577), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [41287] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1502), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1488), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1492), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1504), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(640), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1490), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(638), 16,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DOT_DOT,
  [41340] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1579), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DASH_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1581), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [41383] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(688), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(686), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41426] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1494), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1502), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1488), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1492), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1496), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1504), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1490), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1498), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1500), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(672), 8,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_DOT_DOT,
  [41487] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(1478), 1,
      anon_sym_DASH,
    ACTIONS(1480), 1,
      anon_sym_size,
    ACTIONS(1486), 1,
      anon_sym_unit,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1585), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1484), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1210), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1482), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [41544] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(684), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(682), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41587] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1587), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1589), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [41630] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(624), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(622), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41673] = 23,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1396), 1,
      anon_sym_POUND,
    ACTIONS(1398), 1,
      anon_sym_LBRACK,
    ACTIONS(1400), 1,
      anon_sym_LT_LT,
    ACTIONS(1402), 1,
      anon_sym_DASH,
    ACTIONS(1404), 1,
      anon_sym_DQUOTE,
    ACTIONS(1406), 1,
      sym_float,
    ACTIONS(1410), 1,
      sym__decimal,
    ACTIONS(1412), 1,
      sym__discard_name,
    ACTIONS(1414), 1,
      sym__name,
    ACTIONS(1416), 1,
      sym__upname,
    ACTIONS(1591), 1,
      anon_sym_RBRACE,
    STATE(960), 1,
      sym__pattern_binary_expression,
    STATE(1054), 1,
      sym_identifier,
    STATE(1067), 1,
      sym_string,
    STATE(1125), 1,
      sym__pattern,
    STATE(1144), 1,
      sym_case_clause_pattern,
    STATE(1362), 1,
      sym_case_clause_patterns,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(496), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(899), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1408), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1111), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [41754] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(1478), 1,
      anon_sym_DASH,
    ACTIONS(1486), 1,
      anon_sym_unit,
    ACTIONS(1595), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1593), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1484), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1285), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1482), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [41811] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(384), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1597), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1599), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [41856] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(650), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41899] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(696), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(694), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41942] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1601), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DASH_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1603), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [41985] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(718), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(716), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [42028] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(604), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(602), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [42071] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1609), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1605), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1607), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42116] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1494), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1502), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1488), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1492), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1496), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1504), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1490), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1498), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1500), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(690), 8,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_DOT_DOT,
  [42177] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1611), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1613), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42220] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(1478), 1,
      anon_sym_DASH,
    ACTIONS(1486), 1,
      anon_sym_unit,
    ACTIONS(1617), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1615), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1484), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1245), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1482), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [42277] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(1396), 1,
      anon_sym_POUND,
    ACTIONS(1398), 1,
      anon_sym_LBRACK,
    ACTIONS(1400), 1,
      anon_sym_LT_LT,
    ACTIONS(1412), 1,
      sym__discard_name,
    ACTIONS(1555), 1,
      anon_sym_DASH,
    ACTIONS(1557), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1559), 1,
      sym_float,
    ACTIONS(1619), 1,
      anon_sym_RPAREN,
    STATE(960), 1,
      sym__pattern_binary_expression,
    STATE(1022), 1,
      sym_identifier,
    STATE(1058), 1,
      sym_string,
    STATE(1338), 1,
      sym_record_pattern_argument,
    STATE(1348), 1,
      sym__pattern,
    STATE(1513), 1,
      sym_pattern_spread,
    STATE(1610), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(899), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1060), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [42360] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(709), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(706), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [42403] = 24,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(588), 1,
      anon_sym_DQUOTE,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(598), 1,
      sym__name,
    ACTIONS(600), 1,
      sym__upname,
    ACTIONS(1396), 1,
      anon_sym_POUND,
    ACTIONS(1398), 1,
      anon_sym_LBRACK,
    ACTIONS(1400), 1,
      anon_sym_LT_LT,
    ACTIONS(1412), 1,
      sym__discard_name,
    ACTIONS(1555), 1,
      anon_sym_DASH,
    ACTIONS(1557), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1559), 1,
      sym_float,
    ACTIONS(1621), 1,
      anon_sym_RPAREN,
    STATE(960), 1,
      sym__pattern_binary_expression,
    STATE(1022), 1,
      sym_identifier,
    STATE(1058), 1,
      sym_string,
    STATE(1338), 1,
      sym_record_pattern_argument,
    STATE(1348), 1,
      sym__pattern,
    STATE(1601), 1,
      sym_pattern_spread,
    STATE(1610), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(899), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(1060), 7,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_integer,
      sym_discard,
  [42486] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(730), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(728), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [42529] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(612), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(610), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [42572] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1488), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1492), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1504), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(640), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1490), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(638), 17,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DOT_DOT,
  [42623] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(1478), 1,
      anon_sym_DASH,
    ACTIONS(1486), 1,
      anon_sym_unit,
    ACTIONS(1617), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1623), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1484), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1245), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1482), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [42680] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1625), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1627), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42723] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1494), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1502), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1488), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1492), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1496), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1504), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1490), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1498), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1500), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(732), 8,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_DOT_DOT,
  [42784] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1494), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1502), 1,
      anon_sym_PIPE_GT,
    ACTIONS(1583), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1488), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1492), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1496), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1504), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1490), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1498), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1500), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(678), 8,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_DOT_DOT,
  [42845] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1633), 1,
      anon_sym_LBRACE,
    ACTIONS(1635), 1,
      anon_sym_DASH_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1629), 12,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1631), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42892] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(620), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(618), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [42935] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1637), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1639), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [42978] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1645), 1,
      anon_sym_LBRACE,
    ACTIONS(1647), 1,
      anon_sym_EQ,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1641), 12,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1643), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43025] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(742), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(740), 23,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [43068] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(1478), 1,
      anon_sym_DASH,
    ACTIONS(1486), 1,
      anon_sym_unit,
    ACTIONS(1595), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1649), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1484), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1285), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1482), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [43125] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1651), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1653), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43168] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1655), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1657), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43210] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1659), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1661), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43252] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1663), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1665), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43294] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(594), 1,
      sym__decimal,
    ACTIONS(1478), 1,
      anon_sym_DASH,
    ACTIONS(1480), 1,
      anon_sym_size,
    ACTIONS(1486), 1,
      anon_sym_unit,
    STATE(1446), 1,
      sym_constant_bit_string_segment_options,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(592), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1484), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1143), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1482), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [43350] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1667), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1669), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43392] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(986), 1,
      anon_sym_BANG,
    ACTIONS(988), 1,
      anon_sym_DQUOTE,
    ACTIONS(994), 1,
      sym__decimal,
    ACTIONS(996), 1,
      sym__name,
    ACTIONS(998), 1,
      sym__upname,
    ACTIONS(1402), 1,
      anon_sym_DASH,
    ACTIONS(1671), 1,
      anon_sym_LBRACE,
    ACTIONS(1673), 1,
      anon_sym_POUND,
    ACTIONS(1675), 1,
      anon_sym_LBRACK,
    ACTIONS(1677), 1,
      anon_sym_LT_LT,
    ACTIONS(1679), 1,
      sym_float,
    STATE(828), 1,
      sym_identifier,
    STATE(847), 1,
      sym__case_clause_tuple_access,
    STATE(848), 1,
      sym__case_clause_guard_binary_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(388), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(992), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(845), 11,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_boolean_negation,
      sym_string,
      sym_integer,
  [43464] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1681), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1683), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43506] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1685), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1687), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [43548] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1693), 1,
      anon_sym_LBRACE,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1689), 12,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1691), 17,
      anon_sym_if,
      anon_sym_import,
      anon_sym_type,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      