#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 484
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 145
#define ALIAS_COUNT 2
#define TOKEN_COUNT 83
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 4
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 24

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_alias = 2,
  anon_sym_COLON_EQ = 3,
  anon_sym_export = 4,
  anon_sym_unexport = 5,
  anon_sym_import = 6,
  anon_sym_QMARK = 7,
  anon_sym_mod = 8,
  anon_sym_AT = 9,
  anon_sym_COLON = 10,
  anon_sym_AMP_AMP = 11,
  anon_sym_LBRACK = 12,
  anon_sym_COMMA = 13,
  anon_sym_RBRACK = 14,
  anon_sym_LPAREN = 15,
  anon_sym_RPAREN = 16,
  anon_sym_DOLLAR = 17,
  anon_sym_EQ = 18,
  anon_sym_PLUS = 19,
  anon_sym_STAR = 20,
  aux_sym_shebang_line_token1 = 21,
  anon_sym_AT_DASH = 22,
  anon_sym_DASH_AT = 23,
  anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv = 24,
  aux_sym_shebang_line_token2 = 25,
  sym_shebang_shell = 26,
  anon_sym_DASH = 27,
  anon_sym_LBRACE_LBRACE_LBRACE_LBRACE = 28,
  aux_sym__recipe_line_choice_token1 = 29,
  anon_sym_LBRACE_LBRACE = 30,
  anon_sym_RBRACE_RBRACE = 31,
  anon_sym_set = 32,
  anon_sym_shell = 33,
  anon_sym_true = 34,
  anon_sym_false = 35,
  anon_sym_if = 36,
  anon_sym_LBRACE = 37,
  anon_sym_RBRACE = 38,
  anon_sym_else = 39,
  anon_sym_assert = 40,
  anon_sym_SLASH = 41,
  anon_sym_PIPE_PIPE = 42,
  anon_sym_EQ_EQ = 43,
  anon_sym_BANG_EQ = 44,
  anon_sym_EQ_TILDE = 45,
  anon_sym_BQUOTE = 46,
  aux_sym__backtick_token1 = 47,
  anon_sym_BQUOTE_BQUOTE_BQUOTE = 48,
  aux_sym__indented_backtick_token1 = 49,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 50,
  aux_sym__indented_normal_string_token1 = 51,
  anon_sym_DQUOTE = 52,
  aux_sym__normal_string_token1 = 53,
  anon_sym_SQUOTE_SQUOTE_SQUOTE = 54,
  aux_sym__indented_raw_string_token1 = 55,
  anon_sym_SQUOTE = 56,
  aux_sym__raw_string_token1 = 57,
  anon_sym_BSLASHn = 58,
  anon_sym_BSLASHr = 59,
  anon_sym_BSLASHt = 60,
  anon_sym_BSLASH_DQUOTE = 61,
  anon_sym_BSLASH_BSLASH = 62,
  aux_sym_escape_sequence_token1 = 63,
  anon_sym_x_DQUOTE_DQUOTE_DQUOTE = 64,
  aux_sym__shell_expanded_indented_normal_string_token1 = 65,
  aux_sym__shell_expanded_indented_normal_string_token2 = 66,
  anon_sym_x_DQUOTE = 67,
  aux_sym__shell_expanded_normal_string_token1 = 68,
  aux_sym__shell_expanded_normal_string_token2 = 69,
  anon_sym_x_SQUOTE_SQUOTE_SQUOTE = 70,
  aux_sym__shell_expanded_indented_raw_string_token1 = 71,
  anon_sym_x_SQUOTE = 72,
  aux_sym__shell_expanded_raw_string_token1 = 73,
  aux_sym__shell_expanded_raw_string_token2 = 74,
  sym_shell_variable_name = 75,
  sym_escape_variable_end = 76,
  sym_expansion_long_start = 77,
  sym_expansion_long_middle = 78,
  sym_expansion_long_end = 79,
  aux_sym_comment_token1 = 80,
  sym__eol = 81,
  sym_numeric_error = 82,
  sym_file = 83,
  sym_alias = 84,
  sym_assignment = 85,
  sym_unexport = 86,
  sym_import = 87,
  sym_mod = 88,
  sym_recipe = 89,
  sym_recipe_parameters = 90,
  sym__attribute_list = 91,
  sym_attribute = 92,
  sym_recipe_parameter = 93,
  sym_variadic_parameter = 94,
  sym_recipe_dependency = 95,
  sym__recipe_dependency = 96,
  sym_recipe_body = 97,
  sym_shebang_line = 98,
  sym_recipe_line = 99,
  sym__recipe_line_choice = 100,
  sym_interpolation = 101,
  sym_setting = 102,
  sym__setting_boolean = 103,
  sym__setting_string = 104,
  sym__setting_list = 105,
  sym_boolean = 106,
  sym_expression = 107,
  sym_condition = 108,
  sym_assert_parameters = 109,
  sym_value = 110,
  sym_function_call = 111,
  sym_function_parameters = 112,
  sym_external_command = 113,
  sym__backtick = 114,
  sym__indented_backtick = 115,
  sym_string = 116,
  sym_shell_expanded_string = 117,
  sym_escape_sequence = 118,
  sym_expansion_short_start = 119,
  sym_comment = 120,
  sym__ceol = 121,
  aux_sym_file_repeat1 = 122,
  aux_sym_alias_repeat1 = 123,
  aux_sym_recipe_repeat1 = 124,
  aux_sym_recipe_parameters_repeat1 = 125,
  aux_sym__attribute_list_repeat1 = 126,
  aux_sym_recipe_dependency_repeat1 = 127,
  aux_sym_recipe_body_repeat1 = 128,
  aux_sym_shebang_line_repeat1 = 129,
  aux_sym_shebang_line_repeat2 = 130,
  aux_sym__setting_list_repeat1 = 131,
  aux_sym_function_parameters_repeat1 = 132,
  aux_sym__indented_backtick_repeat1 = 133,
  aux_sym__indented_normal_string_repeat1 = 134,
  aux_sym__normal_string_repeat1 = 135,
  aux_sym__indented_raw_string_repeat1 = 136,
  aux_sym__shell_expanded_indented_normal_string_repeat1 = 137,
  aux_sym__shell_expanded_indented_normal_string_repeat2 = 138,
  aux_sym__shell_expanded_normal_string_repeat1 = 139,
  aux_sym__shell_expanded_normal_string_repeat2 = 140,
  aux_sym__shell_expanded_indented_raw_string_repeat1 = 141,
  aux_sym__shell_expanded_indented_raw_string_repeat2 = 142,
  aux_sym__shell_expanded_raw_string_repeat1 = 143,
  aux_sym__shell_expanded_raw_string_repeat2 = 144,
  alias_sym_path = 145,
  alias_sym_regex = 146,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_alias] = "alias",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_export] = "export",
  [anon_sym_unexport] = "unexport",
  [anon_sym_import] = "import",
  [anon_sym_QMARK] = "\?",
  [anon_sym_mod] = "mod",
  [anon_sym_AT] = "@",
  [anon_sym_COLON] = ":",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [aux_sym_shebang_line_token1] = "shebang_line_token1",
  [anon_sym_AT_DASH] = "@-",
  [anon_sym_DASH_AT] = "-@",
  [anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv] = "#!/usr/bin/env",
  [aux_sym_shebang_line_token2] = "shebang_line_token2",
  [sym_shebang_shell] = "shebang_shell",
  [anon_sym_DASH] = "-",
  [anon_sym_LBRACE_LBRACE_LBRACE_LBRACE] = "{{{{",
  [aux_sym__recipe_line_choice_token1] = "_recipe_line_choice_token1",
  [anon_sym_LBRACE_LBRACE] = "{{",
  [anon_sym_RBRACE_RBRACE] = "}}",
  [anon_sym_set] = "set",
  [anon_sym_shell] = "shell",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_if] = "if",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_else] = "else",
  [anon_sym_assert] = "assert",
  [anon_sym_SLASH] = "/",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_BQUOTE] = "`",
  [aux_sym__backtick_token1] = "content",
  [anon_sym_BQUOTE_BQUOTE_BQUOTE] = "```",
  [aux_sym__indented_backtick_token1] = "_indented_backtick_token1",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [aux_sym__indented_normal_string_token1] = "_indented_normal_string_token1",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__normal_string_token1] = "_normal_string_token1",
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = "'''",
  [aux_sym__indented_raw_string_token1] = "_indented_raw_string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym__raw_string_token1] = "_raw_string_token1",
  [anon_sym_BSLASHn] = "\\n",
  [anon_sym_BSLASHr] = "\\r",
  [anon_sym_BSLASHt] = "\\t",
  [anon_sym_BSLASH_DQUOTE] = "\\\"",
  [anon_sym_BSLASH_BSLASH] = "\\\\",
  [aux_sym_escape_sequence_token1] = "escape_sequence_token1",
  [anon_sym_x_DQUOTE_DQUOTE_DQUOTE] = "x\"\"\"",
  [aux_sym__shell_expanded_indented_normal_string_token1] = "_shell_expanded_indented_normal_string_token1",
  [aux_sym__shell_expanded_indented_normal_string_token2] = "_shell_expanded_indented_normal_string_token2",
  [anon_sym_x_DQUOTE] = "x\"",
  [aux_sym__shell_expanded_normal_string_token1] = "_shell_expanded_normal_string_token1",
  [aux_sym__shell_expanded_normal_string_token2] = "_shell_expanded_normal_string_token2",
  [anon_sym_x_SQUOTE_SQUOTE_SQUOTE] = "x'''",
  [aux_sym__shell_expanded_indented_raw_string_token1] = "_shell_expanded_indented_raw_string_token1",
  [anon_sym_x_SQUOTE] = "x'",
  [aux_sym__shell_expanded_raw_string_token1] = "_shell_expanded_raw_string_token1",
  [aux_sym__shell_expanded_raw_string_token2] = "_shell_expanded_raw_string_token2",
  [sym_shell_variable_name] = "shell_variable_name",
  [sym_escape_variable_end] = "escape_variable_end",
  [sym_expansion_long_start] = "expansion_long_start",
  [sym_expansion_long_middle] = "expansion_long_middle",
  [sym_expansion_long_end] = "expansion_long_end",
  [aux_sym_comment_token1] = "comment_token1",
  [sym__eol] = "_eol",
  [sym_numeric_error] = "numeric_error",
  [sym_file] = "file",
  [sym_alias] = "alias",
  [sym_assignment] = "assignment",
  [sym_unexport] = "unexport",
  [sym_import] = "import",
  [sym_mod] = "mod",
  [sym_recipe] = "recipe",
  [sym_recipe_parameters] = "recipe_parameters",
  [sym__attribute_list] = "_attribute_list",
  [sym_attribute] = "attribute",
  [sym_recipe_parameter] = "recipe_parameter",
  [sym_variadic_parameter] = "variadic_parameter",
  [sym_recipe_dependency] = "recipe_dependency",
  [sym__recipe_dependency] = "_recipe_dependency",
  [sym_recipe_body] = "recipe_body",
  [sym_shebang_line] = "shebang_line",
  [sym_recipe_line] = "recipe_line",
  [sym__recipe_line_choice] = "_recipe_line_choice",
  [sym_interpolation] = "interpolation",
  [sym_setting] = "setting",
  [sym__setting_boolean] = "_setting_boolean",
  [sym__setting_string] = "_setting_string",
  [sym__setting_list] = "_setting_list",
  [sym_boolean] = "boolean",
  [sym_expression] = "expression",
  [sym_condition] = "condition",
  [sym_assert_parameters] = "assert_parameters",
  [sym_value] = "value",
  [sym_function_call] = "function_call",
  [sym_function_parameters] = "function_parameters",
  [sym_external_command] = "external_command",
  [sym__backtick] = "_backtick",
  [sym__indented_backtick] = "_indented_backtick",
  [sym_string] = "string",
  [sym_shell_expanded_string] = "shell_expanded_string",
  [sym_escape_sequence] = "escape_sequence",
  [sym_expansion_short_start] = "expansion_short_start",
  [sym_comment] = "comment",
  [sym__ceol] = "_ceol",
  [aux_sym_file_repeat1] = "file_repeat1",
  [aux_sym_alias_repeat1] = "alias_repeat1",
  [aux_sym_recipe_repeat1] = "recipe_repeat1",
  [aux_sym_recipe_parameters_repeat1] = "recipe_parameters_repeat1",
  [aux_sym__attribute_list_repeat1] = "_attribute_list_repeat1",
  [aux_sym_recipe_dependency_repeat1] = "recipe_dependency_repeat1",
  [aux_sym_recipe_body_repeat1] = "recipe_body_repeat1",
  [aux_sym_shebang_line_repeat1] = "shebang_line_repeat1",
  [aux_sym_shebang_line_repeat2] = "shebang_line_repeat2",
  [aux_sym__setting_list_repeat1] = "_setting_list_repeat1",
  [aux_sym_function_parameters_repeat1] = "function_parameters_repeat1",
  [aux_sym__indented_backtick_repeat1] = "_indented_backtick_repeat1",
  [aux_sym__indented_normal_string_repeat1] = "_indented_normal_string_repeat1",
  [aux_sym__normal_string_repeat1] = "_normal_string_repeat1",
  [aux_sym__indented_raw_string_repeat1] = "_indented_raw_string_repeat1",
  [aux_sym__shell_expanded_indented_normal_string_repeat1] = "_shell_expanded_indented_normal_string_repeat1",
  [aux_sym__shell_expanded_indented_normal_string_repeat2] = "_shell_expanded_indented_normal_string_repeat2",
  [aux_sym__shell_expanded_normal_string_repeat1] = "_shell_expanded_normal_string_repeat1",
  [aux_sym__shell_expanded_normal_string_repeat2] = "_shell_expanded_normal_string_repeat2",
  [aux_sym__shell_expanded_indented_raw_string_repeat1] = "_shell_expanded_indented_raw_string_repeat1",
  [aux_sym__shell_expanded_indented_raw_string_repeat2] = "_shell_expanded_indented_raw_string_repeat2",
  [aux_sym__shell_expanded_raw_string_repeat1] = "_shell_expanded_raw_string_repeat1",
  [aux_sym__shell_expanded_raw_string_repeat2] = "_shell_expanded_raw_string_repeat2",
  [alias_sym_path] = "path",
  [alias_sym_regex] = "regex",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_alias] = anon_sym_alias,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_unexport] = anon_sym_unexport,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_mod] = anon_sym_mod,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [aux_sym_shebang_line_token1] = aux_sym_shebang_line_token1,
  [anon_sym_AT_DASH] = anon_sym_AT_DASH,
  [anon_sym_DASH_AT] = anon_sym_DASH_AT,
  [anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv] = anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv,
  [aux_sym_shebang_line_token2] = aux_sym_shebang_line_token2,
  [sym_shebang_shell] = sym_shebang_shell,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_LBRACE_LBRACE_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
  [aux_sym__recipe_line_choice_token1] = aux_sym__recipe_line_choice_token1,
  [anon_sym_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE,
  [anon_sym_RBRACE_RBRACE] = anon_sym_RBRACE_RBRACE,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_shell] = anon_sym_shell,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_EQ_TILDE] = anon_sym_EQ_TILDE,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym__backtick_token1] = aux_sym__backtick_token1,
  [anon_sym_BQUOTE_BQUOTE_BQUOTE] = anon_sym_BQUOTE_BQUOTE_BQUOTE,
  [aux_sym__indented_backtick_token1] = aux_sym__indented_backtick_token1,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [aux_sym__indented_normal_string_token1] = aux_sym__indented_normal_string_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__normal_string_token1] = aux_sym__normal_string_token1,
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE_SQUOTE,
  [aux_sym__indented_raw_string_token1] = aux_sym__indented_raw_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym__raw_string_token1] = aux_sym__raw_string_token1,
  [anon_sym_BSLASHn] = anon_sym_BSLASHn,
  [anon_sym_BSLASHr] = anon_sym_BSLASHr,
  [anon_sym_BSLASHt] = anon_sym_BSLASHt,
  [anon_sym_BSLASH_DQUOTE] = anon_sym_BSLASH_DQUOTE,
  [anon_sym_BSLASH_BSLASH] = anon_sym_BSLASH_BSLASH,
  [aux_sym_escape_sequence_token1] = aux_sym_escape_sequence_token1,
  [anon_sym_x_DQUOTE_DQUOTE_DQUOTE] = anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
  [aux_sym__shell_expanded_indented_normal_string_token1] = aux_sym__shell_expanded_indented_normal_string_token1,
  [aux_sym__shell_expanded_indented_normal_string_token2] = aux_sym__shell_expanded_indented_normal_string_token2,
  [anon_sym_x_DQUOTE] = anon_sym_x_DQUOTE,
  [aux_sym__shell_expanded_normal_string_token1] = aux_sym__shell_expanded_normal_string_token1,
  [aux_sym__shell_expanded_normal_string_token2] = aux_sym__shell_expanded_normal_string_token2,
  [anon_sym_x_SQUOTE_SQUOTE_SQUOTE] = anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
  [aux_sym__shell_expanded_indented_raw_string_token1] = aux_sym__shell_expanded_indented_raw_string_token1,
  [anon_sym_x_SQUOTE] = anon_sym_x_SQUOTE,
  [aux_sym__shell_expanded_raw_string_token1] = aux_sym__shell_expanded_raw_string_token1,
  [aux_sym__shell_expanded_raw_string_token2] = aux_sym__shell_expanded_raw_string_token2,
  [sym_shell_variable_name] = sym_shell_variable_name,
  [sym_escape_variable_end] = sym_escape_variable_end,
  [sym_expansion_long_start] = sym_expansion_long_start,
  [sym_expansion_long_middle] = sym_expansion_long_middle,
  [sym_expansion_long_end] = sym_expansion_long_end,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [sym__eol] = sym__eol,
  [sym_numeric_error] = sym_numeric_error,
  [sym_file] = sym_file,
  [sym_alias] = sym_alias,
  [sym_assignment] = sym_assignment,
  [sym_unexport] = sym_unexport,
  [sym_import] = sym_import,
  [sym_mod] = sym_mod,
  [sym_recipe] = sym_recipe,
  [sym_recipe_parameters] = sym_recipe_parameters,
  [sym__attribute_list] = sym__attribute_list,
  [sym_attribute] = sym_attribute,
  [sym_recipe_parameter] = sym_recipe_parameter,
  [sym_variadic_parameter] = sym_variadic_parameter,
  [sym_recipe_dependency] = sym_recipe_dependency,
  [sym__recipe_dependency] = sym__recipe_dependency,
  [sym_recipe_body] = sym_recipe_body,
  [sym_shebang_line] = sym_shebang_line,
  [sym_recipe_line] = sym_recipe_line,
  [sym__recipe_line_choice] = sym__recipe_line_choice,
  [sym_interpolation] = sym_interpolation,
  [sym_setting] = sym_setting,
  [sym__setting_boolean] = sym__setting_boolean,
  [sym__setting_string] = sym__setting_string,
  [sym__setting_list] = sym__setting_list,
  [sym_boolean] = sym_boolean,
  [sym_expression] = sym_expression,
  [sym_condition] = sym_condition,
  [sym_assert_parameters] = sym_assert_parameters,
  [sym_value] = sym_value,
  [sym_function_call] = sym_function_call,
  [sym_function_parameters] = sym_function_parameters,
  [sym_external_command] = sym_external_command,
  [sym__backtick] = sym__backtick,
  [sym__indented_backtick] = sym__indented_backtick,
  [sym_string] = sym_string,
  [sym_shell_expanded_string] = sym_shell_expanded_string,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_expansion_short_start] = sym_expansion_short_start,
  [sym_comment] = sym_comment,
  [sym__ceol] = sym__ceol,
  [aux_sym_file_repeat1] = aux_sym_file_repeat1,
  [aux_sym_alias_repeat1] = aux_sym_alias_repeat1,
  [aux_sym_recipe_repeat1] = aux_sym_recipe_repeat1,
  [aux_sym_recipe_parameters_repeat1] = aux_sym_recipe_parameters_repeat1,
  [aux_sym__attribute_list_repeat1] = aux_sym__attribute_list_repeat1,
  [aux_sym_recipe_dependency_repeat1] = aux_sym_recipe_dependency_repeat1,
  [aux_sym_recipe_body_repeat1] = aux_sym_recipe_body_repeat1,
  [aux_sym_shebang_line_repeat1] = aux_sym_shebang_line_repeat1,
  [aux_sym_shebang_line_repeat2] = aux_sym_shebang_line_repeat2,
  [aux_sym__setting_list_repeat1] = aux_sym__setting_list_repeat1,
  [aux_sym_function_parameters_repeat1] = aux_sym_function_parameters_repeat1,
  [aux_sym__indented_backtick_repeat1] = aux_sym__indented_backtick_repeat1,
  [aux_sym__indented_normal_string_repeat1] = aux_sym__indented_normal_string_repeat1,
  [aux_sym__normal_string_repeat1] = aux_sym__normal_string_repeat1,
  [aux_sym__indented_raw_string_repeat1] = aux_sym__indented_raw_string_repeat1,
  [aux_sym__shell_expanded_indented_normal_string_repeat1] = aux_sym__shell_expanded_indented_normal_string_repeat1,
  [aux_sym__shell_expanded_indented_normal_string_repeat2] = aux_sym__shell_expanded_indented_normal_string_repeat2,
  [aux_sym__shell_expanded_normal_string_repeat1] = aux_sym__shell_expanded_normal_string_repeat1,
  [aux_sym__shell_expanded_normal_string_repeat2] = aux_sym__shell_expanded_normal_string_repeat2,
  [aux_sym__shell_expanded_indented_raw_string_repeat1] = aux_sym__shell_expanded_indented_raw_string_repeat1,
  [aux_sym__shell_expanded_indented_raw_string_repeat2] = aux_sym__shell_expanded_indented_raw_string_repeat2,
  [aux_sym__shell_expanded_raw_string_repeat1] = aux_sym__shell_expanded_raw_string_repeat1,
  [aux_sym__shell_expanded_raw_string_repeat2] = aux_sym__shell_expanded_raw_string_repeat2,
  [alias_sym_path] = alias_sym_path,
  [alias_sym_regex] = alias_sym_regex,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_alias] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unexport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_shebang_line_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_AT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_shebang_line_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_shebang_shell] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__recipe_line_choice_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shell] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__backtick_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE_BQUOTE_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__indented_backtick_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__indented_normal_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__normal_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__indented_raw_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__raw_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BSLASHn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_x_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_normal_string_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_normal_string_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_x_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__shell_expanded_normal_string_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_normal_string_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_x_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_raw_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_x_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__shell_expanded_raw_string_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_raw_string_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_shell_variable_name] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_variable_end] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion_long_start] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion_long_middle] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion_long_end] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__eol] = {
    .visible = false,
    .named = true,
  },
  [sym_numeric_error] = {
    .visible = true,
    .named = true,
  },
  [sym_file] = {
    .visible = true,
    .named = true,
  },
  [sym_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_unexport] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_mod] = {
    .visible = true,
    .named = true,
  },
  [sym_recipe] = {
    .visible = true,
    .named = true,
  },
  [sym_recipe_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute_list] = {
    .visible = false,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_recipe_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_recipe_dependency] = {
    .visible = true,
    .named = true,
  },
  [sym__recipe_dependency] = {
    .visible = false,
    .named = true,
  },
  [sym_recipe_body] = {
    .visible = true,
    .named = true,
  },
  [sym_shebang_line] = {
    .visible = true,
    .named = true,
  },
  [sym_recipe_line] = {
    .visible = true,
    .named = true,
  },
  [sym__recipe_line_choice] = {
    .visible = false,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_setting] = {
    .visible = true,
    .named = true,
  },
  [sym__setting_boolean] = {
    .visible = false,
    .named = true,
  },
  [sym__setting_string] = {
    .visible = false,
    .named = true,
  },
  [sym__setting_list] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_external_command] = {
    .visible = true,
    .named = true,
  },
  [sym__backtick] = {
    .visible = false,
    .named = true,
  },
  [sym__indented_backtick] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_shell_expanded_string] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion_short_start] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__ceol] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_alias_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_recipe_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_recipe_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_recipe_dependency_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_recipe_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shebang_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shebang_line_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__setting_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__indented_backtick_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__indented_normal_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__normal_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__indented_raw_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_normal_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_normal_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_normal_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_normal_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_raw_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_raw_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_raw_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_raw_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_path] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_regex] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_interpolation_marker = 1,
  field_name = 2,
  field_recipe_content = 3,
  field_shebang = 4,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_interpolation_marker] = "interpolation_marker",
  [field_name] = "name",
  [field_recipe_content] = "recipe_content",
  [field_shebang] = "shebang",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 1, .length = 1},
  [8] = {.index = 4, .length = 1},
  [9] = {.index = 3, .length = 1},
  [11] = {.index = 5, .length = 1},
  [12] = {.index = 6, .length = 1},
  [13] = {.index = 7, .length = 1},
  [14] = {.index = 8, .length = 1},
  [16] = {.index = 9, .length = 1},
  [17] = {.index = 10, .length = 2},
  [18] = {.index = 8, .length = 1},
  [19] = {.index = 12, .length = 1},
  [20] = {.index = 13, .length = 2},
  [21] = {.index = 15, .length = 1},
  [22] = {.index = 16, .length = 1},
  [23] = {.index = 17, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_name, 1},
  [2] =
    {field_name, 0, .inherited = true},
  [3] =
    {field_name, 2},
  [4] =
    {field_shebang, 0},
  [5] =
    {field_name, 1, .inherited = true},
  [6] =
    {field_recipe_content, 0},
  [7] =
    {field_recipe_content, 0, .inherited = true},
  [8] =
    {field_name, 3},
  [9] =
    {field_recipe_content, 1, .inherited = true},
  [10] =
    {field_recipe_content, 0, .inherited = true},
    {field_recipe_content, 1, .inherited = true},
  [12] =
    {field_recipe_content, 2, .inherited = true},
  [13] =
    {field_interpolation_marker, 0},
    {field_interpolation_marker, 2},
  [15] =
    {field_recipe_content, 3, .inherited = true},
  [16] =
    {field_recipe_content, 4, .inherited = true},
  [17] =
    {field_recipe_content, 5, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [3] = {
    [1] = alias_sym_path,
  },
  [5] = {
    [2] = alias_sym_path,
  },
  [7] = {
    [2] = alias_sym_path,
  },
  [9] = {
    [3] = alias_sym_path,
  },
  [10] = {
    [1] = aux_sym__backtick_token1,
  },
  [15] = {
    [2] = alias_sym_regex,
  },
  [18] = {
    [4] = alias_sym_path,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_expression, 2,
    sym_expression,
    alias_sym_regex,
  sym_string, 2,
    sym_string,
    alias_sym_path,
  aux_sym__indented_backtick_repeat1, 2,
    aux_sym__indented_backtick_repeat1,
    aux_sym__backtick_token1,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 2,
  [7] = 2,
  [8] = 8,
  [9] = 8,
  [10] = 8,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 12,
  [18] = 12,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 21,
  [32] = 32,
  [33] = 21,
  [34] = 32,
  [35] = 21,
  [36] = 32,
  [37] = 32,
  [38] = 28,
  [39] = 27,
  [40] = 30,
  [41] = 28,
  [42] = 27,
  [43] = 30,
  [44] = 25,
  [45] = 25,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 48,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 51,
  [80] = 80,
  [81] = 49,
  [82] = 52,
  [83] = 55,
  [84] = 84,
  [85] = 54,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 60,
  [91] = 59,
  [92] = 61,
  [93] = 58,
  [94] = 56,
  [95] = 57,
  [96] = 53,
  [97] = 50,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 101,
  [103] = 103,
  [104] = 104,
  [105] = 101,
  [106] = 106,
  [107] = 107,
  [108] = 104,
  [109] = 104,
  [110] = 110,
  [111] = 111,
  [112] = 110,
  [113] = 111,
  [114] = 110,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 111,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 122,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 64,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 137,
  [195] = 188,
  [196] = 191,
  [197] = 197,
  [198] = 182,
  [199] = 199,
  [200] = 188,
  [201] = 191,
  [202] = 197,
  [203] = 182,
  [204] = 204,
  [205] = 205,
  [206] = 197,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 67,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 65,
  [222] = 222,
  [223] = 137,
  [224] = 224,
  [225] = 137,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 137,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 137,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 52,
  [254] = 254,
  [255] = 254,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 252,
  [263] = 261,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 254,
  [268] = 256,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 261,
  [276] = 252,
  [277] = 277,
  [278] = 256,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 122,
  [284] = 61,
  [285] = 285,
  [286] = 286,
  [287] = 56,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 53,
  [292] = 292,
  [293] = 64,
  [294] = 50,
  [295] = 57,
  [296] = 58,
  [297] = 59,
  [298] = 60,
  [299] = 299,
  [300] = 64,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 51,
  [306] = 54,
  [307] = 48,
  [308] = 55,
  [309] = 49,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 68,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 15,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 14,
  [346] = 346,
  [347] = 67,
  [348] = 348,
  [349] = 65,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 14,
  [354] = 67,
  [355] = 355,
  [356] = 356,
  [357] = 16,
  [358] = 15,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 336,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 340,
  [371] = 339,
  [372] = 364,
  [373] = 332,
  [374] = 337,
  [375] = 375,
  [376] = 368,
  [377] = 65,
  [378] = 336,
  [379] = 379,
  [380] = 380,
  [381] = 368,
  [382] = 382,
  [383] = 16,
  [384] = 384,
  [385] = 340,
  [386] = 339,
  [387] = 364,
  [388] = 332,
  [389] = 337,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 380,
  [395] = 380,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 398,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 398,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 415,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 431,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 420,
  [448] = 448,
  [449] = 449,
  [450] = 423,
  [451] = 451,
  [452] = 423,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 426,
  [457] = 457,
  [458] = 454,
  [459] = 459,
  [460] = 426,
  [461] = 461,
  [462] = 462,
  [463] = 443,
  [464] = 435,
  [465] = 443,
  [466] = 435,
  [467] = 454,
  [468] = 431,
  [469] = 469,
  [470] = 415,
  [471] = 420,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 417,
  [476] = 417,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 148,
  [482] = 480,
  [483] = 480,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(68);
      ADVANCE_MAP(
        '\n', 207,
        '\r', 1,
        '!', 40,
        '"', 138,
        '#', 29,
        '$', 84,
        '&', 33,
        '\'', 150,
        '(', 81,
        ')', 82,
        '*', 88,
        '+', 87,
        ',', 79,
        '-', 95,
        '/', 113,
        ':', 75,
        '=', 86,
        '?', 70,
        '@', 72,
        '[', 78,
        '\\', 30,
        ']', 80,
        '`', 119,
        'x', 204,
        '{', 111,
        '|', 54,
        '}', 203,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(208);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(207);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '\n', 207,
        '\r', 1,
        '!', 40,
        '"', 138,
        '#', 206,
        '&', 33,
        '\'', 150,
        '(', 81,
        ')', 82,
        ',', 79,
        '/', 113,
        '=', 41,
        '`', 119,
        'x', 204,
        '{', 110,
        '|', 54,
        '}', 112,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(208);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '\n', 207,
        '\r', 1,
        '"', 138,
        '&', 33,
        '\'', 150,
        '(', 81,
        ')', 82,
        '+', 87,
        '/', 113,
        '`', 119,
        'x', 204,
        '|', 54,
        '}', 61,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(208);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '$') ADVANCE(83);
      if (lookahead == '*') ADVANCE(88);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == '=') ADVANCE(85);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(4);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '-') ADVANCE(63);
      if (lookahead == ':') ADVANCE(36);
      if (lookahead == '}') ADVANCE(203);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(6);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '-') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(6);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(7);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(7);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(197);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '\n', 207,
        '\r', 99,
        '#', 104,
        '-', 96,
        '@', 73,
        '{', 106,
        '\t', 100,
        ' ', 100,
      );
      if (lookahead != 0) ADVANCE(107);
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '\r') ADVANCE(99);
      if (lookahead == '#') ADVANCE(104);
      if (lookahead == '{') ADVANCE(106);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(101);
      if (lookahead != 0) ADVANCE(107);
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '\r') ADVANCE(99);
      if (lookahead == '-') ADVANCE(96);
      if (lookahead == '@') ADVANCE(73);
      if (lookahead == '{') ADVANCE(106);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(102);
      if (lookahead != 0) ADVANCE(107);
      END_STATE();
    case 12:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '\r') ADVANCE(99);
      if (lookahead == '{') ADVANCE(106);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(103);
      if (lookahead != 0) ADVANCE(107);
      END_STATE();
    case 13:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '\r') ADVANCE(132);
      if (lookahead == '"') ADVANCE(133);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(131);
      if (lookahead != 0) ADVANCE(136);
      END_STATE();
    case 14:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '\r') ADVANCE(146);
      if (lookahead == '\'') ADVANCE(147);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(145);
      if (lookahead != 0) ADVANCE(148);
      END_STATE();
    case 15:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '\r') ADVANCE(126);
      if (lookahead == '`') ADVANCE(127);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(125);
      if (lookahead != 0) ADVANCE(128);
      END_STATE();
    case 16:
      if (lookahead == '\n') ADVANCE(173);
      if (lookahead == '\r') ADVANCE(169);
      if (lookahead == '"') ADVANCE(170);
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(198);
      if (lookahead != 0) ADVANCE(173);
      END_STATE();
    case 17:
      if (lookahead == '\n') ADVANCE(173);
      if (lookahead == '\r') ADVANCE(169);
      if (lookahead == '"') ADVANCE(170);
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(168);
      if (lookahead != 0) ADVANCE(173);
      END_STATE();
    case 18:
      if (lookahead == '\n') ADVANCE(179);
      if (lookahead == '\r') ADVANCE(180);
      if (lookahead == '"') ADVANCE(137);
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(182);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(197);
      if (lookahead != 0) ADVANCE(179);
      END_STATE();
    case 19:
      if (lookahead == '\n') ADVANCE(179);
      if (lookahead == '\r') ADVANCE(180);
      if (lookahead == '"') ADVANCE(137);
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(182);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(181);
      if (lookahead != 0) ADVANCE(179);
      END_STATE();
    case 20:
      if (lookahead == '\n') ADVANCE(161);
      if (lookahead == '\r') ADVANCE(162);
      if (lookahead == '\\') ADVANCE(165);
      if (lookahead == '}') ADVANCE(203);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(163);
      if (lookahead != 0) ADVANCE(161);
      END_STATE();
    case 21:
      if (lookahead == '\n') ADVANCE(161);
      if (lookahead == '\r') ADVANCE(162);
      if (lookahead == '\\') ADVANCE(166);
      if (lookahead == '}') ADVANCE(203);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(164);
      if (lookahead != 0) ADVANCE(161);
      END_STATE();
    case 22:
      if (lookahead == '\n') ADVANCE(175);
      if (lookahead == '\r') ADVANCE(176);
      if (lookahead == '\\') ADVANCE(178);
      if (lookahead == '}') ADVANCE(203);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(175);
      END_STATE();
    case 23:
      if (lookahead == '\n') ADVANCE(139);
      if (lookahead == '\r') ADVANCE(140);
      if (lookahead == '"') ADVANCE(137);
      if (lookahead == '\\') ADVANCE(142);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(141);
      if (lookahead != 0) ADVANCE(139);
      END_STATE();
    case 24:
      if (lookahead == '\n') ADVANCE(194);
      if (lookahead == '\r') ADVANCE(195);
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '\'') ADVANCE(149);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(197);
      if (lookahead != 0) ADVANCE(194);
      END_STATE();
    case 25:
      if (lookahead == '\n') ADVANCE(194);
      if (lookahead == '\r') ADVANCE(195);
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '\'') ADVANCE(149);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(196);
      if (lookahead != 0) ADVANCE(194);
      END_STATE();
    case 26:
      if (lookahead == '\n') ADVANCE(188);
      if (lookahead == '\r') ADVANCE(186);
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      if (lookahead != 0) ADVANCE(188);
      END_STATE();
    case 27:
      if (lookahead == '\n') ADVANCE(188);
      if (lookahead == '\r') ADVANCE(186);
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(185);
      if (lookahead != 0) ADVANCE(188);
      END_STATE();
    case 28:
      if (lookahead == '\n') ADVANCE(190);
      if (lookahead == '\r') ADVANCE(191);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '}') ADVANCE(203);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(192);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(190);
      END_STATE();
    case 29:
      if (lookahead == '!') ADVANCE(37);
      END_STATE();
    case 30:
      if (lookahead == '"') ADVANCE(157);
      if (lookahead == '\\') ADVANCE(158);
      if (lookahead == 'n') ADVANCE(154);
      if (lookahead == 'r') ADVANCE(155);
      if (lookahead == 't') ADVANCE(156);
      if (lookahead == 'u') ADVANCE(52);
      if (lookahead == '}') ADVANCE(200);
      END_STATE();
    case 31:
      if (lookahead == '"') ADVANCE(129);
      END_STATE();
    case 32:
      if (lookahead == '"') ADVANCE(160);
      END_STATE();
    case 33:
      if (lookahead == '&') ADVANCE(77);
      END_STATE();
    case 34:
      if (lookahead == '\'') ADVANCE(143);
      END_STATE();
    case 35:
      if (lookahead == '\'') ADVANCE(183);
      END_STATE();
    case 36:
      if (lookahead == '-') ADVANCE(202);
      END_STATE();
    case 37:
      if (lookahead == '/') ADVANCE(50);
      END_STATE();
    case 38:
      if (lookahead == '/') ADVANCE(43);
      END_STATE();
    case 39:
      if (lookahead == '/') ADVANCE(44);
      END_STATE();
    case 40:
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 41:
      if (lookahead == '=') ADVANCE(115);
      if (lookahead == '~') ADVANCE(117);
      END_STATE();
    case 42:
      if (lookahead == '`') ADVANCE(123);
      END_STATE();
    case 43:
      if (lookahead == 'b') ADVANCE(45);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(46);
      END_STATE();
    case 45:
      if (lookahead == 'i') ADVANCE(47);
      END_STATE();
    case 46:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 47:
      if (lookahead == 'n') ADVANCE(39);
      END_STATE();
    case 48:
      if (lookahead == 'r') ADVANCE(38);
      END_STATE();
    case 49:
      if (lookahead == 's') ADVANCE(48);
      END_STATE();
    case 50:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 51:
      if (lookahead == 'v') ADVANCE(92);
      END_STATE();
    case 52:
      if (lookahead == '{') ADVANCE(62);
      END_STATE();
    case 53:
      if (lookahead == '{') ADVANCE(97);
      END_STATE();
    case 54:
      if (lookahead == '|') ADVANCE(114);
      END_STATE();
    case 55:
      if (lookahead == '}') ADVANCE(159);
      END_STATE();
    case 56:
      if (lookahead == '}') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 57:
      if (lookahead == '}') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 58:
      if (lookahead == '}') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      END_STATE();
    case 59:
      if (lookahead == '}') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 60:
      if (lookahead == '}') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      END_STATE();
    case 61:
      if (lookahead == '}') ADVANCE(109);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(93);
      END_STATE();
    case 64:
      if (eof) ADVANCE(68);
      ADVANCE_MAP(
        '\n', 207,
        '\r', 1,
        '!', 40,
        '"', 138,
        '#', 29,
        '$', 84,
        '&', 33,
        '\'', 150,
        '(', 81,
        ')', 82,
        '*', 88,
        '+', 87,
        ',', 79,
        '-', 95,
        '/', 113,
        ':', 76,
        '=', 86,
        '@', 72,
        '[', 78,
        '\\', 30,
        ']', 80,
        '`', 119,
        'x', 204,
        '{', 111,
        '|', 54,
        '}', 112,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(208);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 65:
      if (eof) ADVANCE(68);
      ADVANCE_MAP(
        '\n', 207,
        '\r', 1,
        '!', 40,
        '#', 206,
        '$', 83,
        '&', 33,
        '\'', 149,
        '(', 81,
        ')', 82,
        '*', 88,
        '+', 87,
        ',', 79,
        '/', 113,
        ':', 76,
        '=', 41,
        '?', 70,
        '@', 71,
        '[', 78,
        ']', 80,
        '`', 118,
        '{', 110,
        '|', 54,
        '}', 112,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(66);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 66:
      if (eof) ADVANCE(68);
      ADVANCE_MAP(
        '\n', 207,
        '\r', 1,
        '!', 40,
        '#', 206,
        '$', 83,
        '&', 33,
        '\'', 149,
        '(', 81,
        ')', 82,
        '*', 88,
        '+', 87,
        ',', 79,
        '/', 113,
        ':', 76,
        '=', 41,
        '@', 71,
        '[', 78,
        ']', 80,
        '`', 118,
        '{', 110,
        '|', 54,
        '}', 112,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(66);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 67:
      if (eof) ADVANCE(68);
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '#') ADVANCE(206);
      if (lookahead == '@') ADVANCE(71);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(89);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '-') ADVANCE(90);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '{') ADVANCE(98);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '-') ADVANCE(202);
      if (lookahead == '=') ADVANCE(69);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(69);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(201);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(115);
      if (lookahead == '~') ADVANCE(117);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(89);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_AT_DASH);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_DASH_AT);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_shebang_line_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(93);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_shebang_shell);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '@') ADVANCE(91);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '@') ADVANCE(91);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '{') ADVANCE(98);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_LBRACE_LBRACE);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '{') ADVANCE(98);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '\r') ADVANCE(99);
      if (lookahead == '#') ADVANCE(104);
      if (lookahead == '-') ADVANCE(96);
      if (lookahead == '@') ADVANCE(73);
      if (lookahead == '{') ADVANCE(106);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(100);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(107);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '\r') ADVANCE(99);
      if (lookahead == '#') ADVANCE(104);
      if (lookahead == '{') ADVANCE(106);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(101);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(107);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '\r') ADVANCE(99);
      if (lookahead == '-') ADVANCE(96);
      if (lookahead == '@') ADVANCE(73);
      if (lookahead == '{') ADVANCE(106);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(102);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(107);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '\r') ADVANCE(99);
      if (lookahead == '{') ADVANCE(106);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(103);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(107);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '!') ADVANCE(105);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '{') ADVANCE(98);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '/') ADVANCE(50);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(98);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '{') ADVANCE(98);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      if (lookahead == '{') ADVANCE(53);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_RBRACE_RBRACE);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '{') ADVANCE(108);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      if (lookahead == '`') ADVANCE(42);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym__backtick_token1);
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead == '\r') ADVANCE(121);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(120);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(122);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym__backtick_token1);
      if (lookahead == '\n') ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(122);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym__backtick_token1);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(122);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_BQUOTE_BQUOTE_BQUOTE);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym__indented_backtick_token1);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym__indented_backtick_token1);
      if (lookahead == '\n') ADVANCE(124);
      if (lookahead == '\r') ADVANCE(126);
      if (lookahead == '`') ADVANCE(127);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(125);
      if (lookahead != 0) ADVANCE(128);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym__indented_backtick_token1);
      if (lookahead == '\n') ADVANCE(124);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(124);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym__indented_backtick_token1);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead != 0) ADVANCE(124);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym__indented_backtick_token1);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(124);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      if (lookahead == '\n') ADVANCE(130);
      if (lookahead == '\r') ADVANCE(132);
      if (lookahead == '"') ADVANCE(133);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(131);
      if (lookahead != 0) ADVANCE(136);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      if (lookahead == '\n') ADVANCE(130);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(130);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      if (lookahead == '"') ADVANCE(31);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      if (lookahead == '"') ADVANCE(157);
      if (lookahead == '\\') ADVANCE(158);
      if (lookahead == 'n') ADVANCE(154);
      if (lookahead == 'r') ADVANCE(155);
      if (lookahead == 't') ADVANCE(156);
      if (lookahead == 'u') ADVANCE(135);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      if (lookahead == '{') ADVANCE(62);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(130);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(31);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym__normal_string_token1);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym__normal_string_token1);
      if (lookahead == '\n') ADVANCE(207);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym__normal_string_token1);
      if (lookahead == '\n') ADVANCE(139);
      if (lookahead == '\r') ADVANCE(140);
      if (lookahead == '\\') ADVANCE(142);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(141);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(139);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym__normal_string_token1);
      if (lookahead == '"') ADVANCE(157);
      if (lookahead == '\\') ADVANCE(158);
      if (lookahead == 'n') ADVANCE(154);
      if (lookahead == 'r') ADVANCE(155);
      if (lookahead == 't') ADVANCE(156);
      if (lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym__indented_raw_string_token1);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym__indented_raw_string_token1);
      if (lookahead == '\n') ADVANCE(144);
      if (lookahead == '\r') ADVANCE(146);
      if (lookahead == '\'') ADVANCE(147);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(145);
      if (lookahead != 0) ADVANCE(148);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym__indented_raw_string_token1);
      if (lookahead == '\n') ADVANCE(144);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(144);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym__indented_raw_string_token1);
      if (lookahead == '\'') ADVANCE(34);
      if (lookahead != 0) ADVANCE(144);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym__indented_raw_string_token1);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(144);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '\'') ADVANCE(34);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym__raw_string_token1);
      if (lookahead == '\n') ADVANCE(153);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(151);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(153);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym__raw_string_token1);
      if (lookahead == '\n') ADVANCE(153);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(153);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym__raw_string_token1);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(153);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_BSLASHn);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_BSLASHr);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_BSLASHt);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_BSLASH_DQUOTE);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_BSLASH_BSLASH);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token1);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_x_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token1);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token1);
      if (lookahead == '\n') ADVANCE(207);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token1);
      if (lookahead == '\n') ADVANCE(161);
      if (lookahead == '\r') ADVANCE(162);
      if (lookahead == '\\') ADVANCE(165);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(163);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(161);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token1);
      if (lookahead == '\n') ADVANCE(161);
      if (lookahead == '\r') ADVANCE(162);
      if (lookahead == '\\') ADVANCE(166);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(161);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token1);
      if (lookahead == '"') ADVANCE(157);
      if (lookahead == '\\') ADVANCE(158);
      if (lookahead == 'n') ADVANCE(154);
      if (lookahead == 'r') ADVANCE(155);
      if (lookahead == 't') ADVANCE(156);
      if (lookahead == 'u') ADVANCE(52);
      if (lookahead == '}') ADVANCE(200);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token1);
      if (lookahead == '}') ADVANCE(200);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      if (lookahead == '\n') ADVANCE(173);
      if (lookahead == '\r') ADVANCE(169);
      if (lookahead == '"') ADVANCE(170);
      if (lookahead == '\\') ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(168);
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(173);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      if (lookahead == '\n') ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$') ADVANCE(167);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      if (lookahead == '"') ADVANCE(31);
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(167);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      if (lookahead == '"') ADVANCE(157);
      if (lookahead == '\\') ADVANCE(158);
      if (lookahead == 'n') ADVANCE(154);
      if (lookahead == 'r') ADVANCE(155);
      if (lookahead == 't') ADVANCE(156);
      if (lookahead == 'u') ADVANCE(172);
      if (lookahead == '}') ADVANCE(200);
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(167);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      if (lookahead == '{') ADVANCE(62);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$') ADVANCE(167);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_x_DQUOTE);
      if (lookahead == '"') ADVANCE(32);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token1);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token1);
      if (lookahead == '\n') ADVANCE(207);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token1);
      if (lookahead == '\n') ADVANCE(175);
      if (lookahead == '\r') ADVANCE(176);
      if (lookahead == '\\') ADVANCE(178);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '}') ADVANCE(175);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token1);
      if (lookahead == '"') ADVANCE(157);
      if (lookahead == '\\') ADVANCE(158);
      if (lookahead == 'n') ADVANCE(154);
      if (lookahead == 'r') ADVANCE(155);
      if (lookahead == 't') ADVANCE(156);
      if (lookahead == 'u') ADVANCE(52);
      if (lookahead == '}') ADVANCE(200);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token2);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token2);
      if (lookahead == '\n') ADVANCE(207);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token2);
      if (lookahead == '\n') ADVANCE(179);
      if (lookahead == '\r') ADVANCE(180);
      if (lookahead == '\\') ADVANCE(182);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(181);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$') ADVANCE(179);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token2);
      if (lookahead == '"') ADVANCE(157);
      if (lookahead == '\\') ADVANCE(158);
      if (lookahead == 'n') ADVANCE(154);
      if (lookahead == 'r') ADVANCE(155);
      if (lookahead == 't') ADVANCE(156);
      if (lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_x_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_raw_string_token1);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_raw_string_token1);
      if (lookahead == '\n') ADVANCE(188);
      if (lookahead == '\r') ADVANCE(186);
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(188);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_raw_string_token1);
      if (lookahead == '\n') ADVANCE(184);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(184);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_raw_string_token1);
      if (lookahead == '\'') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(184);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_raw_string_token1);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(184);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_x_SQUOTE);
      if (lookahead == '\'') ADVANCE(35);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token1);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token1);
      if (lookahead == '\n') ADVANCE(207);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token1);
      if (lookahead == '\n') ADVANCE(190);
      if (lookahead == '\r') ADVANCE(191);
      if (lookahead == '\\') ADVANCE(193);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(192);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '}') ADVANCE(190);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token1);
      if (lookahead == '}') ADVANCE(200);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token2);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token2);
      if (lookahead == '\n') ADVANCE(207);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token2);
      if (lookahead == '\n') ADVANCE(194);
      if (lookahead == '\r') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(196);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(194);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_shell_variable_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_shell_variable_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(197);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$') ADVANCE(167);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_shell_variable_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(197);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(184);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_escape_variable_end);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_expansion_long_start);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_expansion_long_middle);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_expansion_long_end);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(174);
      if (lookahead == '\'') ADVANCE(189);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(206);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym__eol);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_numeric_error);
      if (lookahead == '.') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(208);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_numeric_error);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'e', 2,
        'f', 3,
        'i', 4,
        'm', 5,
        's', 6,
        't', 7,
        'u', 8,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 's') ADVANCE(10);
      END_STATE();
    case 2:
      if (lookahead == 'l') ADVANCE(11);
      if (lookahead == 'x') ADVANCE(12);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(13);
      END_STATE();
    case 4:
      if (lookahead == 'f') ADVANCE(14);
      if (lookahead == 'm') ADVANCE(15);
      END_STATE();
    case 5:
      if (lookahead == 'o') ADVANCE(16);
      END_STATE();
    case 6:
      if (lookahead == 'e') ADVANCE(17);
      if (lookahead == 'h') ADVANCE(18);
      END_STATE();
    case 7:
      if (lookahead == 'r') ADVANCE(19);
      END_STATE();
    case 8:
      if (lookahead == 'n') ADVANCE(20);
      END_STATE();
    case 9:
      if (lookahead == 'i') ADVANCE(21);
      END_STATE();
    case 10:
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 11:
      if (lookahead == 's') ADVANCE(23);
      END_STATE();
    case 12:
      if (lookahead == 'p') ADVANCE(24);
      END_STATE();
    case 13:
      if (lookahead == 'l') ADVANCE(25);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 15:
      if (lookahead == 'p') ADVANCE(26);
      END_STATE();
    case 16:
      if (lookahead == 'd') ADVANCE(27);
      END_STATE();
    case 17:
      if (lookahead == 't') ADVANCE(28);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(29);
      END_STATE();
    case 19:
      if (lookahead == 'u') ADVANCE(30);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(32);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 24:
      if (lookahead == 'o') ADVANCE(35);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 26:
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_mod);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(38);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 31:
      if (lookahead == 'x') ADVANCE(40);
      END_STATE();
    case 32:
      if (lookahead == 's') ADVANCE(41);
      END_STATE();
    case 33:
      if (lookahead == 'r') ADVANCE(42);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 35:
      if (lookahead == 'r') ADVANCE(43);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 38:
      if (lookahead == 'l') ADVANCE(46);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 40:
      if (lookahead == 'p') ADVANCE(47);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_alias);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(49);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_shell);
      END_STATE();
    case 47:
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 51:
      if (lookahead == 'r') ADVANCE(52);
      END_STATE();
    case 52:
      if (lookahead == 't') ADVANCE(53);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_unexport);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 65},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 2},
  [15] = {.lex_state = 2},
  [16] = {.lex_state = 2},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 65},
  [47] = {.lex_state = 65},
  [48] = {.lex_state = 3},
  [49] = {.lex_state = 3},
  [50] = {.lex_state = 3},
  [51] = {.lex_state = 3},
  [52] = {.lex_state = 3},
  [53] = {.lex_state = 3},
  [54] = {.lex_state = 3},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 3},
  [57] = {.lex_state = 3},
  [58] = {.lex_state = 3},
  [59] = {.lex_state = 3},
  [60] = {.lex_state = 3},
  [61] = {.lex_state = 3},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 0},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 67},
  [70] = {.lex_state = 65},
  [71] = {.lex_state = 67},
  [72] = {.lex_state = 67},
  [73] = {.lex_state = 67},
  [74] = {.lex_state = 67},
  [75] = {.lex_state = 67},
  [76] = {.lex_state = 67},
  [77] = {.lex_state = 67},
  [78] = {.lex_state = 67},
  [79] = {.lex_state = 65},
  [80] = {.lex_state = 67},
  [81] = {.lex_state = 65},
  [82] = {.lex_state = 65},
  [83] = {.lex_state = 65},
  [84] = {.lex_state = 67},
  [85] = {.lex_state = 65},
  [86] = {.lex_state = 67},
  [87] = {.lex_state = 67},
  [88] = {.lex_state = 67},
  [89] = {.lex_state = 67},
  [90] = {.lex_state = 65},
  [91] = {.lex_state = 65},
  [92] = {.lex_state = 65},
  [93] = {.lex_state = 65},
  [94] = {.lex_state = 65},
  [95] = {.lex_state = 65},
  [96] = {.lex_state = 65},
  [97] = {.lex_state = 65},
  [98] = {.lex_state = 0},
  [99] = {.lex_state = 67},
  [100] = {.lex_state = 67},
  [101] = {.lex_state = 17},
  [102] = {.lex_state = 17},
  [103] = {.lex_state = 17},
  [104] = {.lex_state = 17},
  [105] = {.lex_state = 17},
  [106] = {.lex_state = 67},
  [107] = {.lex_state = 67},
  [108] = {.lex_state = 17},
  [109] = {.lex_state = 17},
  [110] = {.lex_state = 19},
  [111] = {.lex_state = 19},
  [112] = {.lex_state = 19},
  [113] = {.lex_state = 19},
  [114] = {.lex_state = 19},
  [115] = {.lex_state = 19},
  [116] = {.lex_state = 2},
  [117] = {.lex_state = 2},
  [118] = {.lex_state = 19},
  [119] = {.lex_state = 2},
  [120] = {.lex_state = 67},
  [121] = {.lex_state = 67},
  [122] = {.lex_state = 67},
  [123] = {.lex_state = 16},
  [124] = {.lex_state = 67},
  [125] = {.lex_state = 67},
  [126] = {.lex_state = 67},
  [127] = {.lex_state = 67},
  [128] = {.lex_state = 67},
  [129] = {.lex_state = 67},
  [130] = {.lex_state = 67},
  [131] = {.lex_state = 0},
  [132] = {.lex_state = 65},
  [133] = {.lex_state = 65},
  [134] = {.lex_state = 20},
  [135] = {.lex_state = 65},
  [136] = {.lex_state = 65},
  [137] = {.lex_state = 17},
  [138] = {.lex_state = 65},
  [139] = {.lex_state = 65},
  [140] = {.lex_state = 20},
  [141] = {.lex_state = 65},
  [142] = {.lex_state = 17},
  [143] = {.lex_state = 20},
  [144] = {.lex_state = 17},
  [145] = {.lex_state = 22},
  [146] = {.lex_state = 65},
  [147] = {.lex_state = 22},
  [148] = {.lex_state = 65},
  [149] = {.lex_state = 65},
  [150] = {.lex_state = 22},
  [151] = {.lex_state = 65},
  [152] = {.lex_state = 65},
  [153] = {.lex_state = 65},
  [154] = {.lex_state = 65},
  [155] = {.lex_state = 17},
  [156] = {.lex_state = 65},
  [157] = {.lex_state = 65},
  [158] = {.lex_state = 65},
  [159] = {.lex_state = 65},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 65},
  [163] = {.lex_state = 65},
  [164] = {.lex_state = 65},
  [165] = {.lex_state = 65},
  [166] = {.lex_state = 65},
  [167] = {.lex_state = 17},
  [168] = {.lex_state = 65},
  [169] = {.lex_state = 65},
  [170] = {.lex_state = 18},
  [171] = {.lex_state = 65},
  [172] = {.lex_state = 65},
  [173] = {.lex_state = 65},
  [174] = {.lex_state = 65},
  [175] = {.lex_state = 65},
  [176] = {.lex_state = 9},
  [177] = {.lex_state = 65},
  [178] = {.lex_state = 65},
  [179] = {.lex_state = 65},
  [180] = {.lex_state = 65},
  [181] = {.lex_state = 19},
  [182] = {.lex_state = 23},
  [183] = {.lex_state = 19},
  [184] = {.lex_state = 11},
  [185] = {.lex_state = 0},
  [186] = {.lex_state = 19},
  [187] = {.lex_state = 0},
  [188] = {.lex_state = 13},
  [189] = {.lex_state = 0},
  [190] = {.lex_state = 0},
  [191] = {.lex_state = 23},
  [192] = {.lex_state = 23},
  [193] = {.lex_state = 13},
  [194] = {.lex_state = 19},
  [195] = {.lex_state = 13},
  [196] = {.lex_state = 23},
  [197] = {.lex_state = 13},
  [198] = {.lex_state = 23},
  [199] = {.lex_state = 65},
  [200] = {.lex_state = 13},
  [201] = {.lex_state = 23},
  [202] = {.lex_state = 13},
  [203] = {.lex_state = 23},
  [204] = {.lex_state = 19},
  [205] = {.lex_state = 0},
  [206] = {.lex_state = 13},
  [207] = {.lex_state = 65},
  [208] = {.lex_state = 65},
  [209] = {.lex_state = 65},
  [210] = {.lex_state = 65},
  [211] = {.lex_state = 65},
  [212] = {.lex_state = 65},
  [213] = {.lex_state = 65},
  [214] = {.lex_state = 65},
  [215] = {.lex_state = 65},
  [216] = {.lex_state = 65},
  [217] = {.lex_state = 65},
  [218] = {.lex_state = 65},
  [219] = {.lex_state = 65},
  [220] = {.lex_state = 65},
  [221] = {.lex_state = 65},
  [222] = {.lex_state = 65},
  [223] = {.lex_state = 20},
  [224] = {.lex_state = 65},
  [225] = {.lex_state = 22},
  [226] = {.lex_state = 65},
  [227] = {.lex_state = 65},
  [228] = {.lex_state = 65},
  [229] = {.lex_state = 65},
  [230] = {.lex_state = 65},
  [231] = {.lex_state = 65},
  [232] = {.lex_state = 65},
  [233] = {.lex_state = 65},
  [234] = {.lex_state = 65},
  [235] = {.lex_state = 65},
  [236] = {.lex_state = 65},
  [237] = {.lex_state = 23},
  [238] = {.lex_state = 65},
  [239] = {.lex_state = 65},
  [240] = {.lex_state = 65},
  [241] = {.lex_state = 65},
  [242] = {.lex_state = 65},
  [243] = {.lex_state = 65},
  [244] = {.lex_state = 13},
  [245] = {.lex_state = 65},
  [246] = {.lex_state = 65},
  [247] = {.lex_state = 65},
  [248] = {.lex_state = 65},
  [249] = {.lex_state = 10},
  [250] = {.lex_state = 65},
  [251] = {.lex_state = 65},
  [252] = {.lex_state = 25},
  [253] = {.lex_state = 65},
  [254] = {.lex_state = 27},
  [255] = {.lex_state = 27},
  [256] = {.lex_state = 25},
  [257] = {.lex_state = 27},
  [258] = {.lex_state = 12},
  [259] = {.lex_state = 4},
  [260] = {.lex_state = 12},
  [261] = {.lex_state = 27},
  [262] = {.lex_state = 25},
  [263] = {.lex_state = 27},
  [264] = {.lex_state = 12},
  [265] = {.lex_state = 65},
  [266] = {.lex_state = 12},
  [267] = {.lex_state = 27},
  [268] = {.lex_state = 25},
  [269] = {.lex_state = 12},
  [270] = {.lex_state = 12},
  [271] = {.lex_state = 65},
  [272] = {.lex_state = 12},
  [273] = {.lex_state = 4},
  [274] = {.lex_state = 12},
  [275] = {.lex_state = 27},
  [276] = {.lex_state = 25},
  [277] = {.lex_state = 25},
  [278] = {.lex_state = 25},
  [279] = {.lex_state = 12},
  [280] = {.lex_state = 65},
  [281] = {.lex_state = 12},
  [282] = {.lex_state = 12},
  [283] = {.lex_state = 65},
  [284] = {.lex_state = 65},
  [285] = {.lex_state = 26},
  [286] = {.lex_state = 65},
  [287] = {.lex_state = 65},
  [288] = {.lex_state = 24},
  [289] = {.lex_state = 65},
  [290] = {.lex_state = 65},
  [291] = {.lex_state = 65},
  [292] = {.lex_state = 65},
  [293] = {.lex_state = 65},
  [294] = {.lex_state = 65},
  [295] = {.lex_state = 65},
  [296] = {.lex_state = 65},
  [297] = {.lex_state = 65},
  [298] = {.lex_state = 65},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 3},
  [301] = {.lex_state = 65},
  [302] = {.lex_state = 65},
  [303] = {.lex_state = 65},
  [304] = {.lex_state = 65},
  [305] = {.lex_state = 65},
  [306] = {.lex_state = 65},
  [307] = {.lex_state = 65},
  [308] = {.lex_state = 65},
  [309] = {.lex_state = 65},
  [310] = {.lex_state = 27},
  [311] = {.lex_state = 25},
  [312] = {.lex_state = 65},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 21},
  [315] = {.lex_state = 25},
  [316] = {.lex_state = 28},
  [317] = {.lex_state = 27},
  [318] = {.lex_state = 65},
  [319] = {.lex_state = 65},
  [320] = {.lex_state = 65},
  [321] = {.lex_state = 21},
  [322] = {.lex_state = 25},
  [323] = {.lex_state = 28},
  [324] = {.lex_state = 21},
  [325] = {.lex_state = 27},
  [326] = {.lex_state = 65},
  [327] = {.lex_state = 65},
  [328] = {.lex_state = 27},
  [329] = {.lex_state = 28},
  [330] = {.lex_state = 65},
  [331] = {.lex_state = 25},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 65},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 65},
  [336] = {.lex_state = 14},
  [337] = {.lex_state = 65},
  [338] = {.lex_state = 65},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 15},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 65},
  [346] = {.lex_state = 15},
  [347] = {.lex_state = 65},
  [348] = {.lex_state = 5},
  [349] = {.lex_state = 65},
  [350] = {.lex_state = 65},
  [351] = {.lex_state = 5},
  [352] = {.lex_state = 12},
  [353] = {.lex_state = 3},
  [354] = {.lex_state = 3},
  [355] = {.lex_state = 12},
  [356] = {.lex_state = 5},
  [357] = {.lex_state = 3},
  [358] = {.lex_state = 3},
  [359] = {.lex_state = 65},
  [360] = {.lex_state = 12},
  [361] = {.lex_state = 65},
  [362] = {.lex_state = 65},
  [363] = {.lex_state = 14},
  [364] = {.lex_state = 15},
  [365] = {.lex_state = 65},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 65},
  [368] = {.lex_state = 14},
  [369] = {.lex_state = 65},
  [370] = {.lex_state = 15},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 15},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 65},
  [375] = {.lex_state = 65},
  [376] = {.lex_state = 14},
  [377] = {.lex_state = 3},
  [378] = {.lex_state = 14},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 65},
  [381] = {.lex_state = 14},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 65},
  [384] = {.lex_state = 65},
  [385] = {.lex_state = 15},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 15},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 65},
  [390] = {.lex_state = 5},
  [391] = {.lex_state = 65},
  [392] = {.lex_state = 5},
  [393] = {.lex_state = 3},
  [394] = {.lex_state = 65},
  [395] = {.lex_state = 65},
  [396] = {.lex_state = 14},
  [397] = {.lex_state = 65},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 15},
  [400] = {.lex_state = 65},
  [401] = {.lex_state = 5},
  [402] = {.lex_state = 5},
  [403] = {.lex_state = 5},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 65},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 65},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 5},
  [410] = {.lex_state = 65},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 65},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 65},
  [416] = {.lex_state = 65},
  [417] = {.lex_state = 65},
  [418] = {.lex_state = 65},
  [419] = {.lex_state = 65},
  [420] = {.lex_state = 65},
  [421] = {.lex_state = 65},
  [422] = {.lex_state = 65},
  [423] = {.lex_state = 0},
  [424] = {.lex_state = 65},
  [425] = {.lex_state = 65},
  [426] = {.lex_state = 120},
  [427] = {.lex_state = 65},
  [428] = {.lex_state = 65},
  [429] = {.lex_state = 0},
  [430] = {.lex_state = 65},
  [431] = {.lex_state = 65},
  [432] = {.lex_state = 65},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 65},
  [435] = {.lex_state = 65},
  [436] = {.lex_state = 0},
  [437] = {.lex_state = 65},
  [438] = {.lex_state = 65},
  [439] = {.lex_state = 65},
  [440] = {.lex_state = 65},
  [441] = {.lex_state = 8},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 65},
  [445] = {.lex_state = 8},
  [446] = {.lex_state = 65},
  [447] = {.lex_state = 65},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 65},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 65},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 65},
  [454] = {.lex_state = 151},
  [455] = {.lex_state = 8},
  [456] = {.lex_state = 120},
  [457] = {.lex_state = 8},
  [458] = {.lex_state = 151},
  [459] = {.lex_state = 65},
  [460] = {.lex_state = 120},
  [461] = {.lex_state = 65},
  [462] = {.lex_state = 8},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 65},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 65},
  [467] = {.lex_state = 151},
  [468] = {.lex_state = 65},
  [469] = {.lex_state = 0},
  [470] = {.lex_state = 65},
  [471] = {.lex_state = 65},
  [472] = {.lex_state = 65},
  [473] = {.lex_state = 8},
  [474] = {.lex_state = 8},
  [475] = {.lex_state = 65},
  [476] = {.lex_state = 65},
  [477] = {.lex_state = 65},
  [478] = {.lex_state = 8},
  [479] = {.lex_state = 65},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_alias] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_unexport] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_mod] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_AT_DASH] = ACTIONS(1),
    [anon_sym_DASH_AT] = ACTIONS(1),
    [anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_shell] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_BSLASHn] = ACTIONS(1),
    [anon_sym_BSLASHr] = ACTIONS(1),
    [anon_sym_BSLASHt] = ACTIONS(1),
    [anon_sym_BSLASH_DQUOTE] = ACTIONS(1),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(1),
    [aux_sym_escape_sequence_token1] = ACTIONS(1),
    [anon_sym_x_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_x_DQUOTE] = ACTIONS(1),
    [anon_sym_x_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_x_SQUOTE] = ACTIONS(1),
    [sym_escape_variable_end] = ACTIONS(1),
    [sym_expansion_long_start] = ACTIONS(1),
    [sym_expansion_long_middle] = ACTIONS(1),
    [sym_expansion_long_end] = ACTIONS(1),
    [sym__eol] = ACTIONS(3),
    [sym_numeric_error] = ACTIONS(1),
  },
  [1] = {
    [sym_file] = STATE(442),
    [sym_alias] = STATE(46),
    [sym_assignment] = STATE(46),
    [sym_unexport] = STATE(46),
    [sym_import] = STATE(46),
    [sym_mod] = STATE(46),
    [sym_recipe] = STATE(46),
    [sym__attribute_list] = STATE(240),
    [sym_setting] = STATE(46),
    [sym_comment] = STATE(46),
    [aux_sym_file_repeat1] = STATE(46),
    [aux_sym_alias_repeat1] = STATE(240),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_alias] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_unexport] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_mod] = ACTIONS(17),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(21),
    [anon_sym_set] = ACTIONS(23),
    [aux_sym_comment_token1] = ACTIONS(25),
    [sym__eol] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 24,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_RPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(299), 1,
      sym_expression,
    STATE(452), 1,
      sym_function_parameters,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [76] = 24,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(4), 1,
      aux_sym_recipe_dependency_repeat1,
    STATE(48), 1,
      sym_shell_expanded_string,
    STATE(64), 1,
      sym_value,
    STATE(66), 1,
      sym_expression,
    STATE(50), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(53), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [152] = 24,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    ACTIONS(91), 1,
      anon_sym_RPAREN,
    STATE(5), 1,
      aux_sym_recipe_dependency_repeat1,
    STATE(48), 1,
      sym_shell_expanded_string,
    STATE(64), 1,
      sym_value,
    STATE(66), 1,
      sym_expression,
    STATE(50), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(53), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [228] = 24,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(96), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_RPAREN,
    ACTIONS(101), 1,
      anon_sym_if,
    ACTIONS(104), 1,
      anon_sym_assert,
    ACTIONS(107), 1,
      anon_sym_SLASH,
    ACTIONS(110), 1,
      anon_sym_BQUOTE,
    ACTIONS(113), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(116), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(119), 1,
      anon_sym_DQUOTE,
    ACTIONS(122), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(125), 1,
      anon_sym_SQUOTE,
    ACTIONS(128), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(131), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(134), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(137), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(140), 1,
      sym_numeric_error,
    STATE(5), 1,
      aux_sym_recipe_dependency_repeat1,
    STATE(48), 1,
      sym_shell_expanded_string,
    STATE(64), 1,
      sym_value,
    STATE(66), 1,
      sym_expression,
    STATE(50), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(53), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [304] = 24,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    ACTIONS(143), 1,
      anon_sym_RPAREN,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(299), 1,
      sym_expression,
    STATE(423), 1,
      sym_function_parameters,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [380] = 24,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    ACTIONS(145), 1,
      anon_sym_RPAREN,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(299), 1,
      sym_expression,
    STATE(450), 1,
      sym_function_parameters,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [456] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(286), 1,
      sym_expression,
    STATE(475), 1,
      sym_condition,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [529] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(286), 1,
      sym_expression,
    STATE(476), 1,
      sym_condition,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [602] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(286), 1,
      sym_expression,
    STATE(417), 1,
      sym_condition,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [675] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    ACTIONS(147), 1,
      anon_sym_RPAREN,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(313), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [748] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(286), 1,
      sym_expression,
    STATE(443), 1,
      sym_condition,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [821] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    ACTIONS(149), 1,
      anon_sym_RPAREN,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(313), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [894] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(151), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(153), 17,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [927] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(155), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(157), 17,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [960] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(159), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(161), 17,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [993] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(286), 1,
      sym_expression,
    STATE(463), 1,
      sym_condition,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1066] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(286), 1,
      sym_expression,
    STATE(465), 1,
      sym_condition,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1139] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(163), 1,
      sym_identifier,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_if,
    ACTIONS(169), 1,
      anon_sym_assert,
    ACTIONS(171), 1,
      anon_sym_SLASH,
    ACTIONS(173), 1,
      anon_sym_BQUOTE,
    ACTIONS(175), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(193), 1,
      sym_numeric_error,
    STATE(293), 1,
      sym_value,
    STATE(304), 1,
      sym_expression,
    STATE(307), 1,
      sym_shell_expanded_string,
    STATE(294), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(291), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1209] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(163), 1,
      sym_identifier,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_if,
    ACTIONS(169), 1,
      anon_sym_assert,
    ACTIONS(171), 1,
      anon_sym_SLASH,
    ACTIONS(173), 1,
      anon_sym_BQUOTE,
    ACTIONS(175), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(193), 1,
      sym_numeric_error,
    STATE(292), 1,
      sym_expression,
    STATE(293), 1,
      sym_value,
    STATE(307), 1,
      sym_shell_expanded_string,
    STATE(294), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(291), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1279] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(163), 1,
      sym_identifier,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_if,
    ACTIONS(169), 1,
      anon_sym_assert,
    ACTIONS(171), 1,
      anon_sym_SLASH,
    ACTIONS(173), 1,
      anon_sym_BQUOTE,
    ACTIONS(175), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(193), 1,
      sym_numeric_error,
    STATE(293), 1,
      sym_value,
    STATE(307), 1,
      sym_shell_expanded_string,
    STATE(349), 1,
      sym_expression,
    STATE(294), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(291), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1349] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(163), 1,
      sym_identifier,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_if,
    ACTIONS(169), 1,
      anon_sym_assert,
    ACTIONS(171), 1,
      anon_sym_SLASH,
    ACTIONS(173), 1,
      anon_sym_BQUOTE,
    ACTIONS(175), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(193), 1,
      sym_numeric_error,
    STATE(293), 1,
      sym_value,
    STATE(303), 1,
      sym_expression,
    STATE(307), 1,
      sym_shell_expanded_string,
    STATE(294), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(291), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1419] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(326), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1489] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(327), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1559] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(380), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1629] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    ACTIONS(195), 1,
      anon_sym_if,
    ACTIONS(197), 1,
      anon_sym_assert,
    ACTIONS(199), 1,
      anon_sym_SLASH,
    STATE(48), 1,
      sym_shell_expanded_string,
    STATE(300), 1,
      sym_value,
    STATE(393), 1,
      sym_expression,
    STATE(50), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(53), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1699] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(332), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1769] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(339), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1839] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(313), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1909] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(337), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1979] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(221), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2049] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(163), 1,
      sym_identifier,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_if,
    ACTIONS(169), 1,
      anon_sym_assert,
    ACTIONS(171), 1,
      anon_sym_SLASH,
    ACTIONS(173), 1,
      anon_sym_BQUOTE,
    ACTIONS(175), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(193), 1,
      sym_numeric_error,
    STATE(293), 1,
      sym_value,
    STATE(307), 1,
      sym_shell_expanded_string,
    STATE(347), 1,
      sym_expression,
    STATE(294), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(291), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2119] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(48), 1,
      sym_shell_expanded_string,
    STATE(64), 1,
      sym_value,
    STATE(65), 1,
      sym_expression,
    STATE(50), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(53), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2189] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(216), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2259] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    ACTIONS(195), 1,
      anon_sym_if,
    ACTIONS(197), 1,
      anon_sym_assert,
    ACTIONS(199), 1,
      anon_sym_SLASH,
    STATE(48), 1,
      sym_shell_expanded_string,
    STATE(300), 1,
      sym_value,
    STATE(377), 1,
      sym_expression,
    STATE(50), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(53), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2329] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(48), 1,
      sym_shell_expanded_string,
    STATE(64), 1,
      sym_value,
    STATE(67), 1,
      sym_expression,
    STATE(50), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(53), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2399] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    ACTIONS(195), 1,
      anon_sym_if,
    ACTIONS(197), 1,
      anon_sym_assert,
    ACTIONS(199), 1,
      anon_sym_SLASH,
    STATE(48), 1,
      sym_shell_expanded_string,
    STATE(300), 1,
      sym_value,
    STATE(354), 1,
      sym_expression,
    STATE(50), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(53), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2469] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(371), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2539] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(373), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2609] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(374), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2679] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(386), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2749] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(388), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2819] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(389), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2889] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(394), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2959] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(178), 1,
      sym_value,
    STATE(395), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [3029] = 14,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_alias,
    ACTIONS(11), 1,
      anon_sym_export,
    ACTIONS(13), 1,
      anon_sym_unexport,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_mod,
    ACTIONS(19), 1,
      anon_sym_AT,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_set,
    ACTIONS(25), 1,
      aux_sym_comment_token1,
    ACTIONS(201), 1,
      ts_builtin_sym_end,
    STATE(240), 2,
      sym__attribute_list,
      aux_sym_alias_repeat1,
    STATE(47), 9,
      sym_alias,
      sym_assignment,
      sym_unexport,
      sym_import,
      sym_mod,
      sym_recipe,
      sym_setting,
      sym_comment,
      aux_sym_file_repeat1,
  [3081] = 14,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(203), 1,
      ts_builtin_sym_end,
    ACTIONS(205), 1,
      sym_identifier,
    ACTIONS(208), 1,
      anon_sym_alias,
    ACTIONS(211), 1,
      anon_sym_export,
    ACTIONS(214), 1,
      anon_sym_unexport,
    ACTIONS(217), 1,
      anon_sym_import,
    ACTIONS(220), 1,
      anon_sym_mod,
    ACTIONS(223), 1,
      anon_sym_AT,
    ACTIONS(226), 1,
      anon_sym_LBRACK,
    ACTIONS(229), 1,
      anon_sym_set,
    ACTIONS(232), 1,
      aux_sym_comment_token1,
    STATE(240), 2,
      sym__attribute_list,
      aux_sym_alias_repeat1,
    STATE(47), 9,
      sym_alias,
      sym_assignment,
      sym_unexport,
      sym_import,
      sym_mod,
      sym_recipe,
      sym_setting,
      sym_comment,
      aux_sym_file_repeat1,
  [3133] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(235), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(237), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3162] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(239), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(241), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3191] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(243), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(245), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3220] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(247), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(249), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3249] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(253), 12,
      anon_sym_AMP_AMP,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3280] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(251), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(253), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3309] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(257), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(259), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3338] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(261), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(263), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3367] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(265), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(267), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3396] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(269), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(271), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3425] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(273), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(275), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3454] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(277), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(279), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3483] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(281), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(283), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3512] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(285), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(287), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3541] = 18,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(302), 1,
      sym_value,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [3599] = 18,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(289), 1,
      sym_value,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [3657] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(293), 2,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(289), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(291), 10,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3687] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(293), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(295), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(297), 9,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3716] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(293), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(299), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(301), 9,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3745] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(293), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(151), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(153), 9,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3774] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(303), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(305), 9,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3799] = 7,
    ACTIONS(307), 1,
      ts_builtin_sym_end,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    STATE(100), 1,
      sym_shebang_line,
    STATE(162), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(309), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [3831] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(237), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [3853] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(315), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(157), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(317), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [3885] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(319), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(169), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(321), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [3917] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(323), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(165), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(325), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [3949] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(327), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(177), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(329), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [3981] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(331), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(180), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(333), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4013] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(335), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(163), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(337), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4045] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(339), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(151), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(341), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4077] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(343), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(172), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(345), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4109] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(249), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [4131] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(347), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(132), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(349), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4163] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(241), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [4185] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(351), 1,
      anon_sym_LPAREN,
    ACTIONS(253), 15,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [4209] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(263), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [4231] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(353), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(166), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(355), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4263] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(259), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [4285] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(357), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(156), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(359), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4317] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(361), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(141), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(363), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4349] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(365), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(146), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(367), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4381] = 7,
    ACTIONS(311), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(369), 1,
      ts_builtin_sym_end,
    STATE(100), 1,
      sym_shebang_line,
    STATE(153), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(371), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4413] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(283), 15,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [4434] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(279), 15,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [4455] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(287), 15,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [4476] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(275), 15,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [4497] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(267), 15,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [4518] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(271), 15,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [4539] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(253), 15,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [4560] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(245), 15,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      sym_identifier,
  [4581] = 14,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(373), 1,
      anon_sym_LBRACK,
    STATE(307), 1,
      sym_shell_expanded_string,
    STATE(440), 1,
      sym_string,
    STATE(446), 1,
      sym_boolean,
    ACTIONS(375), 2,
      anon_sym_true,
      anon_sym_false,
  [4625] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(377), 1,
      ts_builtin_sym_end,
    ACTIONS(381), 1,
      aux_sym_shebang_line_token1,
    STATE(107), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(379), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4651] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(381), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(383), 1,
      ts_builtin_sym_end,
    STATE(106), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(385), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4677] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(387), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(395), 1,
      sym_expansion_long_start,
    STATE(462), 1,
      sym_expansion_short_start,
    ACTIONS(393), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(108), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(391), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4709] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(387), 1,
      anon_sym_DOLLAR,
    ACTIONS(395), 1,
      sym_expansion_long_start,
    ACTIONS(397), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(462), 1,
      sym_expansion_short_start,
    ACTIONS(399), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(104), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(391), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4741] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(401), 1,
      anon_sym_DOLLAR,
    ACTIONS(404), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(412), 1,
      sym_expansion_long_start,
    STATE(462), 1,
      sym_expansion_short_start,
    ACTIONS(409), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(103), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(406), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4773] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(387), 1,
      anon_sym_DOLLAR,
    ACTIONS(395), 1,
      sym_expansion_long_start,
    ACTIONS(415), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(462), 1,
      sym_expansion_short_start,
    ACTIONS(417), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(103), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(391), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4805] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(387), 1,
      anon_sym_DOLLAR,
    ACTIONS(395), 1,
      sym_expansion_long_start,
    ACTIONS(419), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(462), 1,
      sym_expansion_short_start,
    ACTIONS(421), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(109), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(391), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4837] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(381), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(423), 1,
      ts_builtin_sym_end,
    STATE(107), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(425), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4863] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(427), 1,
      ts_builtin_sym_end,
    ACTIONS(431), 1,
      aux_sym_shebang_line_token1,
    STATE(107), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(429), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4889] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(387), 1,
      anon_sym_DOLLAR,
    ACTIONS(395), 1,
      sym_expansion_long_start,
    ACTIONS(434), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(462), 1,
      sym_expansion_short_start,
    ACTIONS(417), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(103), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(391), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4921] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(387), 1,
      anon_sym_DOLLAR,
    ACTIONS(395), 1,
      sym_expansion_long_start,
    ACTIONS(436), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(462), 1,
      sym_expansion_short_start,
    ACTIONS(417), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(103), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(391), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4953] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(415), 1,
      anon_sym_DQUOTE,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__shell_expanded_normal_string_token2,
    ACTIONS(444), 1,
      sym_expansion_long_start,
    STATE(474), 1,
      sym_expansion_short_start,
    STATE(115), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(440), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4984] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(397), 1,
      anon_sym_DQUOTE,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(444), 1,
      sym_expansion_long_start,
    ACTIONS(446), 1,
      aux_sym__shell_expanded_normal_string_token2,
    STATE(474), 1,
      sym_expansion_short_start,
    STATE(110), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(440), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5015] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__shell_expanded_normal_string_token2,
    ACTIONS(444), 1,
      sym_expansion_long_start,
    STATE(474), 1,
      sym_expansion_short_start,
    STATE(115), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(440), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5046] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(419), 1,
      anon_sym_DQUOTE,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(444), 1,
      sym_expansion_long_start,
    ACTIONS(448), 1,
      aux_sym__shell_expanded_normal_string_token2,
    STATE(474), 1,
      sym_expansion_short_start,
    STATE(112), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(440), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5077] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__shell_expanded_normal_string_token2,
    ACTIONS(444), 1,
      sym_expansion_long_start,
    STATE(474), 1,
      sym_expansion_short_start,
    STATE(115), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(440), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5108] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(450), 1,
      anon_sym_DOLLAR,
    ACTIONS(453), 1,
      anon_sym_DQUOTE,
    ACTIONS(458), 1,
      aux_sym__shell_expanded_normal_string_token2,
    ACTIONS(461), 1,
      sym_expansion_long_start,
    STATE(474), 1,
      sym_expansion_short_start,
    STATE(115), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(455), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5139] = 14,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(466), 1,
      sym__eol,
    STATE(179), 1,
      sym__ceol,
    STATE(307), 1,
      sym_shell_expanded_string,
    STATE(361), 1,
      sym_string,
    STATE(483), 1,
      sym_comment,
  [5182] = 14,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(468), 1,
      sym__eol,
    STATE(168), 1,
      sym__ceol,
    STATE(307), 1,
      sym_shell_expanded_string,
    STATE(391), 1,
      sym_string,
    STATE(483), 1,
      sym_comment,
  [5225] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(444), 1,
      sym_expansion_long_start,
    ACTIONS(470), 1,
      aux_sym__shell_expanded_normal_string_token2,
    STATE(474), 1,
      sym_expansion_short_start,
    STATE(114), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(440), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5256] = 14,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      sym__eol,
    STATE(164), 1,
      sym__ceol,
    STATE(307), 1,
      sym_shell_expanded_string,
    STATE(375), 1,
      sym_string,
    STATE(483), 1,
      sym_comment,
  [5299] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(474), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(476), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5319] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(478), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(480), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5339] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(482), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(484), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5359] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(488), 1,
      sym_shell_variable_name,
    ACTIONS(486), 11,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
      sym_expansion_long_start,
  [5379] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(490), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(492), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5399] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(494), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(496), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5419] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(494), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(496), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5439] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(498), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(500), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5459] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(502), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(504), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5479] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(506), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(508), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5499] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(510), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(512), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5519] = 12,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(514), 1,
      anon_sym_RBRACK,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(406), 1,
      sym_string,
  [5556] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(369), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(371), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5575] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(516), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(518), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5594] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(524), 1,
      sym_expansion_long_end,
    ACTIONS(522), 2,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
    STATE(143), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat1,
    ACTIONS(520), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5617] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(526), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(528), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5636] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(530), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(532), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5655] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(534), 11,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
      sym_expansion_long_start,
  [5672] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(536), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(538), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5691] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(540), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(542), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5710] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(546), 1,
      sym_expansion_long_end,
    ACTIONS(544), 2,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
    STATE(134), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat1,
    ACTIONS(520), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5733] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(331), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(333), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5752] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(548), 11,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
      sym_expansion_long_start,
  [5769] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(556), 1,
      sym_expansion_long_end,
    ACTIONS(553), 2,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
    STATE(143), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat1,
    ACTIONS(550), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5792] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(558), 11,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
      sym_expansion_long_start,
  [5809] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(566), 1,
      sym_expansion_long_end,
    ACTIONS(563), 2,
      aux_sym__shell_expanded_normal_string_token1,
      sym_escape_variable_end,
    STATE(145), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat1,
    ACTIONS(560), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5832] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(315), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(317), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5851] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(572), 1,
      sym_expansion_long_end,
    ACTIONS(570), 2,
      aux_sym__shell_expanded_normal_string_token1,
      sym_escape_variable_end,
    STATE(150), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat1,
    ACTIONS(568), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5874] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(574), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(576), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5893] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(578), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(580), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5912] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(584), 1,
      sym_expansion_long_end,
    ACTIONS(582), 2,
      aux_sym__shell_expanded_normal_string_token1,
      sym_escape_variable_end,
    STATE(145), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat1,
    ACTIONS(568), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5935] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(365), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(367), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5954] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(586), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(588), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5973] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(307), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(309), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5992] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(590), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(592), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6011] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(404), 11,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
      sym_expansion_long_start,
  [6028] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(339), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(341), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6047] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(323), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(325), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6066] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(594), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(596), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6085] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(598), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(600), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6104] = 12,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(602), 1,
      anon_sym_QMARK,
    STATE(307), 1,
      sym_shell_expanded_string,
    STATE(367), 1,
      sym_string,
  [6141] = 12,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(604), 1,
      anon_sym_RBRACK,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(406), 1,
      sym_string,
  [6178] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(606), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(608), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6197] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(319), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(321), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6216] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(610), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(612), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6235] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(614), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(616), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6254] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(347), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(349), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6273] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(618), 11,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
      sym_expansion_long_start,
  [6290] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(620), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(622), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6309] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(343), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(345), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6328] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(626), 1,
      sym_shell_variable_name,
    ACTIONS(624), 10,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token2,
      sym_expansion_long_start,
  [6347] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(628), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(630), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6366] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(632), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(634), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6385] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(636), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(638), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6404] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(482), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(484), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6423] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(640), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(642), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6442] = 8,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(648), 1,
      anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv,
    ACTIONS(652), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(258), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(644), 2,
      anon_sym_AT,
      anon_sym_DASH,
    ACTIONS(646), 2,
      anon_sym_AT_DASH,
      anon_sym_DASH_AT,
    ACTIONS(650), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [6471] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(353), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(355), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6490] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(654), 2,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(291), 9,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [6509] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(656), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(658), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6528] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(335), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(337), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6547] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(660), 10,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token2,
      sym_expansion_long_start,
  [6563] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(662), 1,
      anon_sym_DQUOTE,
    ACTIONS(664), 1,
      aux_sym__normal_string_token1,
    STATE(192), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(666), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6585] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(453), 10,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token2,
      sym_expansion_long_start,
  [6601] = 6,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(652), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(258), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(650), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
    ACTIONS(644), 4,
      anon_sym_AT,
      anon_sym_AT_DASH,
      anon_sym_DASH_AT,
      anon_sym_DASH,
  [6625] = 11,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    STATE(307), 1,
      sym_shell_expanded_string,
    STATE(365), 1,
      sym_string,
  [6659] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(668), 10,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token2,
      sym_expansion_long_start,
  [6675] = 11,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(342), 1,
      sym_string,
  [6709] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(670), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(672), 1,
      aux_sym__indented_normal_string_token1,
    STATE(206), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(674), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6731] = 11,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(414), 1,
      sym_string,
  [6765] = 11,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(429), 1,
      sym_string,
  [6799] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(670), 1,
      anon_sym_DQUOTE,
    ACTIONS(676), 1,
      aux_sym__normal_string_token1,
    STATE(182), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(666), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6821] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(678), 1,
      anon_sym_DQUOTE,
    ACTIONS(680), 1,
      aux_sym__normal_string_token1,
    STATE(192), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(683), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6843] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(686), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(688), 1,
      aux_sym__indented_normal_string_token1,
    STATE(193), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(691), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6865] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(534), 10,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token2,
      sym_expansion_long_start,
  [6881] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(694), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(696), 1,
      aux_sym__indented_normal_string_token1,
    STATE(197), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(674), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6903] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(694), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      aux_sym__normal_string_token1,
    STATE(198), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(666), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6925] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(700), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__indented_normal_string_token1,
    STATE(193), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(674), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6947] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(664), 1,
      aux_sym__normal_string_token1,
    ACTIONS(700), 1,
      anon_sym_DQUOTE,
    STATE(192), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(666), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6969] = 10,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(704), 1,
      sym_identifier,
    ACTIONS(706), 1,
      anon_sym_COLON_EQ,
    ACTIONS(708), 1,
      anon_sym_COLON,
    ACTIONS(710), 1,
      anon_sym_DOLLAR,
    STATE(248), 1,
      aux_sym_recipe_parameters_repeat1,
    STATE(290), 1,
      sym_recipe_parameter,
    STATE(428), 1,
      sym_variadic_parameter,
    STATE(477), 1,
      sym_recipe_parameters,
    ACTIONS(712), 2,
      anon_sym_PLUS,
      anon_sym_STAR,
  [7001] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(714), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(716), 1,
      aux_sym__indented_normal_string_token1,
    STATE(202), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(674), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7023] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(714), 1,
      anon_sym_DQUOTE,
    ACTIONS(718), 1,
      aux_sym__normal_string_token1,
    STATE(203), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(666), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7045] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(702), 1,
      aux_sym__indented_normal_string_token1,
    ACTIONS(720), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(193), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(674), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7067] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(664), 1,
      aux_sym__normal_string_token1,
    ACTIONS(720), 1,
      anon_sym_DQUOTE,
    STATE(192), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(666), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7089] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(722), 10,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token2,
      sym_expansion_long_start,
  [7105] = 11,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    STATE(70), 1,
      sym_shell_expanded_string,
    STATE(406), 1,
      sym_string,
  [7139] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(662), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__indented_normal_string_token1,
    STATE(193), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(674), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7161] = 10,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(704), 1,
      sym_identifier,
    ACTIONS(710), 1,
      anon_sym_DOLLAR,
    ACTIONS(724), 1,
      anon_sym_COLON_EQ,
    ACTIONS(726), 1,
      anon_sym_COLON,
    STATE(248), 1,
      aux_sym_recipe_parameters_repeat1,
    STATE(290), 1,
      sym_recipe_parameter,
    STATE(428), 1,
      sym_variadic_parameter,
    STATE(444), 1,
      sym_recipe_parameters,
    ACTIONS(712), 2,
      anon_sym_PLUS,
      anon_sym_STAR,
  [7193] = 9,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(730), 1,
      anon_sym_AMP_AMP,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(734), 1,
      sym__eol,
    STATE(75), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(219), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7222] = 9,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(736), 1,
      anon_sym_AMP_AMP,
    ACTIONS(738), 1,
      sym__eol,
    STATE(74), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(215), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7251] = 9,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(740), 1,
      anon_sym_AMP_AMP,
    ACTIONS(742), 1,
      sym__eol,
    STATE(86), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(211), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7280] = 9,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(744), 1,
      anon_sym_AMP_AMP,
    ACTIONS(746), 1,
      sym__eol,
    STATE(77), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7309] = 9,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(748), 1,
      anon_sym_AMP_AMP,
    ACTIONS(750), 1,
      sym__eol,
    STATE(80), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7338] = 9,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_AMP_AMP,
    ACTIONS(754), 1,
      sym__eol,
    STATE(87), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(218), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7367] = 9,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(704), 1,
      sym_identifier,
    ACTIONS(710), 1,
      anon_sym_DOLLAR,
    ACTIONS(756), 1,
      anon_sym_COLON,
    STATE(248), 1,
      aux_sym_recipe_parameters_repeat1,
    STATE(290), 1,
      sym_recipe_parameter,
    STATE(428), 1,
      sym_variadic_parameter,
    STATE(444), 1,
      sym_recipe_parameters,
    ACTIONS(712), 2,
      anon_sym_PLUS,
      anon_sym_STAR,
  [7396] = 9,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_AMP_AMP,
    ACTIONS(760), 1,
      sym__eol,
    STATE(84), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7425] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(153), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [7442] = 9,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(744), 1,
      anon_sym_AMP_AMP,
    ACTIONS(746), 1,
      sym__eol,
    STATE(77), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(224), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7471] = 9,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(730), 1,
      anon_sym_AMP_AMP,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(734), 1,
      sym__eol,
    STATE(75), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7500] = 9,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(762), 1,
      anon_sym_AMP_AMP,
    ACTIONS(764), 1,
      sym__eol,
    STATE(76), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7529] = 9,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_AMP_AMP,
    ACTIONS(760), 1,
      sym__eol,
    STATE(84), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(212), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7558] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(297), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
  [7575] = 9,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(704), 1,
      sym_identifier,
    ACTIONS(710), 1,
      anon_sym_DOLLAR,
    ACTIONS(766), 1,
      anon_sym_COLON,
    STATE(248), 1,
      aux_sym_recipe_parameters_repeat1,
    STATE(290), 1,
      sym_recipe_parameter,
    STATE(421), 1,
      sym_recipe_parameters,
    STATE(428), 1,
      sym_variadic_parameter,
    ACTIONS(712), 2,
      anon_sym_PLUS,
      anon_sym_STAR,
  [7604] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(768), 1,
      sym_expansion_long_end,
    ACTIONS(534), 8,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
  [7621] = 9,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(770), 1,
      anon_sym_AMP_AMP,
    ACTIONS(772), 1,
      sym__eol,
    STATE(88), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7650] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(768), 1,
      sym_expansion_long_end,
    ACTIONS(534), 8,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token1,
      sym_escape_variable_end,
  [7667] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(750), 1,
      sym__eol,
    STATE(80), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(238), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7693] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(774), 1,
      sym__eol,
    STATE(69), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7719] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(746), 1,
      sym__eol,
    STATE(77), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(241), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7745] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      sym__eol,
    STATE(76), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7771] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(764), 1,
      sym__eol,
    STATE(76), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(242), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7797] = 5,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(778), 1,
      anon_sym_AT,
    ACTIONS(780), 1,
      anon_sym_LBRACK,
    STATE(231), 2,
      sym__attribute_list,
      aux_sym_alias_repeat1,
    ACTIONS(776), 4,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_mod,
      sym_identifier,
  [7817] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(783), 1,
      sym__eol,
    STATE(71), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7843] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(783), 1,
      sym__eol,
    STATE(71), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(235), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7869] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      sym__eol,
    STATE(84), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(246), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7895] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(785), 1,
      sym__eol,
    STATE(73), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7921] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(734), 1,
      sym__eol,
    STATE(75), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(229), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7947] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(534), 8,
      anon_sym_DQUOTE,
      aux_sym__normal_string_token1,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7961] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(787), 1,
      sym__eol,
    STATE(89), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7987] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(787), 1,
      sym__eol,
    STATE(89), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(227), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8013] = 8,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(789), 1,
      sym_identifier,
    ACTIONS(791), 1,
      anon_sym_alias,
    ACTIONS(793), 1,
      anon_sym_export,
    ACTIONS(795), 1,
      anon_sym_mod,
    ACTIONS(797), 1,
      anon_sym_AT,
    STATE(231), 2,
      sym__attribute_list,
      aux_sym_alias_repeat1,
  [8039] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(772), 1,
      sym__eol,
    STATE(88), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8065] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(799), 1,
      sym__eol,
    STATE(72), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8091] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(799), 1,
      sym__eol,
    STATE(72), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(247), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8117] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(534), 8,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym__indented_normal_string_token1,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [8131] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(772), 1,
      sym__eol,
    STATE(88), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(232), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8157] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(750), 1,
      sym__eol,
    STATE(80), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8183] = 8,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(728), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      sym__eol,
    STATE(78), 1,
      sym__ceol,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(482), 1,
      sym_comment,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8209] = 7,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(704), 1,
      sym_identifier,
    ACTIONS(710), 1,
      anon_sym_DOLLAR,
    STATE(271), 1,
      aux_sym_recipe_parameters_repeat1,
    STATE(301), 1,
      sym_recipe_parameter,
    STATE(430), 1,
      sym_variadic_parameter,
    ACTIONS(712), 2,
      anon_sym_PLUS,
      anon_sym_STAR,
  [8232] = 6,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(652), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(803), 1,
      anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv,
    STATE(270), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(650), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8253] = 6,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(805), 1,
      anon_sym_COLON_EQ,
    ACTIONS(807), 1,
      sym__eol,
    STATE(152), 1,
      sym__ceol,
    STATE(483), 1,
      sym_comment,
    STATE(335), 3,
      sym__setting_boolean,
      sym__setting_string,
      sym__setting_list,
  [8274] = 5,
    ACTIONS(809), 1,
      sym_identifier,
    ACTIONS(814), 1,
      anon_sym_LPAREN,
    STATE(319), 1,
      sym__recipe_dependency,
    STATE(251), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
    ACTIONS(812), 3,
      anon_sym_AMP_AMP,
      aux_sym_comment_token1,
      sym__eol,
  [8293] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(389), 1,
      anon_sym_SQUOTE,
    ACTIONS(817), 1,
      anon_sym_DOLLAR,
    ACTIONS(819), 1,
      aux_sym__shell_expanded_raw_string_token2,
    ACTIONS(821), 1,
      sym_expansion_long_start,
    STATE(278), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(478), 1,
      sym_expansion_short_start,
  [8315] = 2,
    ACTIONS(823), 1,
      anon_sym_LPAREN,
    ACTIONS(253), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [8327] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(434), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(825), 1,
      anon_sym_DOLLAR,
    ACTIONS(827), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    ACTIONS(829), 1,
      sym_expansion_long_start,
    STATE(257), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(441), 1,
      sym_expansion_short_start,
  [8349] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(436), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(825), 1,
      anon_sym_DOLLAR,
    ACTIONS(827), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    ACTIONS(829), 1,
      sym_expansion_long_start,
    STATE(257), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(441), 1,
      sym_expansion_short_start,
  [8371] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(436), 1,
      anon_sym_SQUOTE,
    ACTIONS(817), 1,
      anon_sym_DOLLAR,
    ACTIONS(821), 1,
      sym_expansion_long_start,
    ACTIONS(831), 1,
      aux_sym__shell_expanded_raw_string_token2,
    STATE(277), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(478), 1,
      sym_expansion_short_start,
  [8393] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(833), 1,
      anon_sym_DOLLAR,
    ACTIONS(836), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(838), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    ACTIONS(841), 1,
      sym_expansion_long_start,
    STATE(257), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(441), 1,
      sym_expansion_short_start,
  [8415] = 5,
    ACTIONS(652), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(844), 1,
      sym__eol,
    STATE(279), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(650), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8433] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(848), 1,
      anon_sym_EQ,
    ACTIONS(846), 5,
      anon_sym_COLON,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_identifier,
  [8447] = 5,
    ACTIONS(652), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(850), 1,
      sym__eol,
    STATE(281), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(650), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8465] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(397), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(825), 1,
      anon_sym_DOLLAR,
    ACTIONS(829), 1,
      sym_expansion_long_start,
    ACTIONS(852), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    STATE(267), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(441), 1,
      sym_expansion_short_start,
  [8487] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(397), 1,
      anon_sym_SQUOTE,
    ACTIONS(817), 1,
      anon_sym_DOLLAR,
    ACTIONS(821), 1,
      sym_expansion_long_start,
    ACTIONS(854), 1,
      aux_sym__shell_expanded_raw_string_token2,
    STATE(268), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(478), 1,
      sym_expansion_short_start,
  [8509] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(389), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(825), 1,
      anon_sym_DOLLAR,
    ACTIONS(829), 1,
      sym_expansion_long_start,
    ACTIONS(856), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    STATE(254), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(441), 1,
      sym_expansion_short_start,
  [8531] = 5,
    ACTIONS(652), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(858), 1,
      sym__eol,
    STATE(279), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(650), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8549] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(862), 2,
      anon_sym_AT,
      anon_sym_LBRACK,
    ACTIONS(860), 4,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_mod,
      sym_identifier,
  [8563] = 5,
    ACTIONS(652), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(864), 1,
      sym__eol,
    STATE(279), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(650), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8581] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(415), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(825), 1,
      anon_sym_DOLLAR,
    ACTIONS(827), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    ACTIONS(829), 1,
      sym_expansion_long_start,
    STATE(257), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(441), 1,
      sym_expansion_short_start,
  [8603] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(415), 1,
      anon_sym_SQUOTE,
    ACTIONS(817), 1,
      anon_sym_DOLLAR,
    ACTIONS(821), 1,
      sym_expansion_long_start,
    ACTIONS(831), 1,
      aux_sym__shell_expanded_raw_string_token2,
    STATE(277), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(478), 1,
      sym_expansion_short_start,
  [8625] = 5,
    ACTIONS(652), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(866), 1,
      sym__eol,
    STATE(279), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(650), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8643] = 5,
    ACTIONS(652), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(868), 1,
      sym__eol,
    STATE(279), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(650), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8661] = 5,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(873), 1,
      anon_sym_DOLLAR,
    ACTIONS(876), 2,
      anon_sym_PLUS,
      anon_sym_STAR,
    STATE(271), 2,
      sym_recipe_parameter,
      aux_sym_recipe_parameters_repeat1,
  [8679] = 5,
    ACTIONS(652), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(878), 1,
      sym__eol,
    STATE(269), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(650), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8697] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(882), 1,
      anon_sym_EQ,
    ACTIONS(880), 5,
      anon_sym_COLON,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_identifier,
  [8711] = 5,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(652), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(266), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(650), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8729] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(419), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(825), 1,
      anon_sym_DOLLAR,
    ACTIONS(829), 1,
      sym_expansion_long_start,
    ACTIONS(884), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    STATE(255), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(441), 1,
      sym_expansion_short_start,
  [8751] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(419), 1,
      anon_sym_SQUOTE,
    ACTIONS(817), 1,
      anon_sym_DOLLAR,
    ACTIONS(821), 1,
      sym_expansion_long_start,
    ACTIONS(886), 1,
      aux_sym__shell_expanded_raw_string_token2,
    STATE(256), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(478), 1,
      sym_expansion_short_start,
  [8773] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(888), 1,
      anon_sym_DOLLAR,
    ACTIONS(891), 1,
      anon_sym_SQUOTE,
    ACTIONS(893), 1,
      aux_sym__shell_expanded_raw_string_token2,
    ACTIONS(896), 1,
      sym_expansion_long_start,
    STATE(277), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(478), 1,
      sym_expansion_short_start,
  [8795] = 7,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(434), 1,
      anon_sym_SQUOTE,
    ACTIONS(817), 1,
      anon_sym_DOLLAR,
    ACTIONS(821), 1,
      sym_expansion_long_start,
    ACTIONS(831), 1,
      aux_sym__shell_expanded_raw_string_token2,
    STATE(277), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(478), 1,
      sym_expansion_short_start,
  [8817] = 5,
    ACTIONS(902), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(905), 1,
      sym__eol,
    STATE(279), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(899), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8835] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(909), 2,
      anon_sym_AT,
      anon_sym_LBRACK,
    ACTIONS(907), 4,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_mod,
      sym_identifier,
  [8849] = 5,
    ACTIONS(652), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(911), 1,
      sym__eol,
    STATE(279), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(650), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8867] = 5,
    ACTIONS(652), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(913), 1,
      sym__eol,
    STATE(264), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(650), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(355), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8885] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(482), 2,
      anon_sym_AT,
      anon_sym_LBRACK,
    ACTIONS(484), 4,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_mod,
      sym_identifier,
  [8899] = 1,
    ACTIONS(287), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [8908] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(488), 1,
      sym_shell_variable_name,
    ACTIONS(915), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      aux_sym__shell_expanded_indented_raw_string_token1,
      sym_expansion_long_start,
  [8921] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(919), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(917), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [8936] = 1,
    ACTIONS(267), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [8945] = 3,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(626), 1,
      sym_shell_variable_name,
    ACTIONS(921), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__shell_expanded_raw_string_token2,
      sym_expansion_long_start,
  [8958] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(923), 5,
      anon_sym_COLON,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_identifier,
  [8969] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(927), 1,
      anon_sym_COLON,
    ACTIONS(925), 4,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_identifier,
  [8982] = 1,
    ACTIONS(253), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [8991] = 5,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(931), 1,
      sym__eol,
    STATE(173), 1,
      sym__ceol,
    STATE(483), 1,
      sym_comment,
    ACTIONS(929), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9008] = 2,
    ACTIONS(929), 2,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(291), 4,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9019] = 1,
    ACTIONS(245), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9028] = 1,
    ACTIONS(271), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9037] = 1,
    ACTIONS(275), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9046] = 1,
    ACTIONS(279), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9055] = 1,
    ACTIONS(283), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9064] = 5,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(933), 1,
      anon_sym_COMMA,
    ACTIONS(935), 1,
      anon_sym_RPAREN,
    STATE(382), 1,
      aux_sym_function_parameters_repeat1,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9081] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(937), 2,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(291), 3,
      anon_sym_AMP_AMP,
      anon_sym_RBRACE_RBRACE,
      anon_sym_PIPE_PIPE,
  [9094] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(939), 1,
      anon_sym_COLON,
    ACTIONS(925), 4,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_identifier,
  [9107] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(941), 5,
      anon_sym_COLON,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_identifier,
  [9118] = 5,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(943), 1,
      sym__eol,
    STATE(138), 1,
      sym__ceol,
    STATE(483), 1,
      sym_comment,
    ACTIONS(929), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9135] = 5,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(945), 1,
      sym__eol,
    STATE(135), 1,
      sym__ceol,
    STATE(483), 1,
      sym_comment,
    ACTIONS(929), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9152] = 1,
    ACTIONS(249), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9161] = 1,
    ACTIONS(259), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9170] = 1,
    ACTIONS(237), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9179] = 1,
    ACTIONS(263), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9188] = 1,
    ACTIONS(241), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9197] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(947), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      aux_sym__shell_expanded_indented_raw_string_token1,
      sym_expansion_long_start,
  [9207] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(949), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__shell_expanded_raw_string_token2,
      sym_expansion_long_start,
  [9217] = 1,
    ACTIONS(951), 5,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      sym_identifier,
      aux_sym_comment_token1,
      sym__eol,
  [9225] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(953), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [9237] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(958), 1,
      sym_expansion_long_end,
    STATE(314), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat1,
    ACTIONS(955), 2,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
  [9251] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(960), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__shell_expanded_raw_string_token2,
      sym_expansion_long_start,
  [9261] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(965), 1,
      sym_expansion_long_end,
    STATE(316), 1,
      aux_sym__shell_expanded_raw_string_repeat1,
    ACTIONS(962), 2,
      aux_sym__shell_expanded_raw_string_token1,
      sym_escape_variable_end,
  [9275] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(967), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      aux_sym__shell_expanded_indented_raw_string_token1,
      sym_expansion_long_start,
  [9285] = 1,
    ACTIONS(305), 5,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      sym_identifier,
      aux_sym_comment_token1,
      sym__eol,
  [9293] = 1,
    ACTIONS(969), 5,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      sym_identifier,
      aux_sym_comment_token1,
      sym__eol,
  [9301] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(971), 1,
      anon_sym_COLON,
    ACTIONS(975), 1,
      anon_sym_LPAREN,
    ACTIONS(973), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [9315] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(979), 1,
      sym_expansion_long_end,
    STATE(314), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat1,
    ACTIONS(977), 2,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
  [9329] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(981), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__shell_expanded_raw_string_token2,
      sym_expansion_long_start,
  [9339] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(985), 1,
      sym_expansion_long_end,
    STATE(316), 1,
      aux_sym__shell_expanded_raw_string_repeat1,
    ACTIONS(983), 2,
      aux_sym__shell_expanded_raw_string_token1,
      sym_escape_variable_end,
  [9353] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(989), 1,
      sym_expansion_long_end,
    STATE(321), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat1,
    ACTIONS(987), 2,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
  [9367] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(991), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      aux_sym__shell_expanded_indented_raw_string_token1,
      sym_expansion_long_start,
  [9377] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(993), 2,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [9389] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(995), 2,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [9401] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(836), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      aux_sym__shell_expanded_indented_raw_string_token1,
      sym_expansion_long_start,
  [9411] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(999), 1,
      sym_expansion_long_end,
    STATE(323), 1,
      aux_sym__shell_expanded_raw_string_repeat1,
    ACTIONS(997), 2,
      aux_sym__shell_expanded_raw_string_token1,
      sym_escape_variable_end,
  [9425] = 1,
    ACTIONS(1001), 5,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      sym_identifier,
      aux_sym_comment_token1,
      sym__eol,
  [9433] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(891), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__shell_expanded_raw_string_token2,
      sym_expansion_long_start,
  [9443] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1003), 1,
      anon_sym_RPAREN,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9454] = 4,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(1005), 1,
      sym__eol,
    STATE(265), 1,
      sym__ceol,
    STATE(480), 1,
      sym_comment,
  [9467] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1007), 1,
      anon_sym_COMMA,
    ACTIONS(1009), 1,
      anon_sym_RBRACK,
    STATE(366), 1,
      aux_sym__attribute_list_repeat1,
  [9480] = 4,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(1011), 1,
      sym__eol,
    STATE(158), 1,
      sym__ceol,
    STATE(483), 1,
      sym_comment,
  [9493] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(670), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1013), 1,
      aux_sym__indented_raw_string_token1,
    STATE(376), 1,
      aux_sym__indented_raw_string_repeat1,
  [9506] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1015), 1,
      anon_sym_RBRACE,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9517] = 1,
    ACTIONS(157), 4,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9524] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1017), 1,
      anon_sym_RPAREN,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9535] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1019), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(1021), 1,
      aux_sym__indented_backtick_token1,
    STATE(364), 1,
      aux_sym__indented_backtick_repeat1,
  [9548] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1023), 1,
      anon_sym_COMMA,
    ACTIONS(1026), 1,
      anon_sym_RBRACK,
    STATE(341), 1,
      aux_sym__setting_list_repeat1,
  [9561] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1028), 1,
      anon_sym_COMMA,
    ACTIONS(1030), 1,
      anon_sym_RBRACK,
    STATE(379), 1,
      aux_sym__setting_list_repeat1,
  [9574] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1007), 1,
      anon_sym_COMMA,
    ACTIONS(1032), 1,
      anon_sym_RBRACK,
    STATE(334), 1,
      aux_sym__attribute_list_repeat1,
  [9587] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(953), 1,
      anon_sym_RPAREN,
    ACTIONS(1034), 1,
      anon_sym_COMMA,
    STATE(344), 1,
      aux_sym_function_parameters_repeat1,
  [9600] = 1,
    ACTIONS(153), 4,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9607] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1037), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(1039), 1,
      aux_sym__indented_backtick_token1,
    STATE(346), 1,
      aux_sym__indented_backtick_repeat1,
  [9620] = 2,
    ACTIONS(153), 2,
      aux_sym_comment_token1,
      sym__eol,
    ACTIONS(929), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9629] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1042), 1,
      aux_sym_shebang_line_token2,
    ACTIONS(1044), 1,
      sym_shebang_shell,
    STATE(356), 1,
      aux_sym_shebang_line_repeat1,
  [9642] = 2,
    ACTIONS(297), 2,
      aux_sym_comment_token1,
      sym__eol,
    ACTIONS(929), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9651] = 4,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(1046), 1,
      sym__eol,
    STATE(280), 1,
      sym__ceol,
    STATE(480), 1,
      sym_comment,
  [9664] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1048), 1,
      aux_sym_shebang_line_token2,
    ACTIONS(1050), 1,
      sym_shebang_shell,
    STATE(392), 1,
      aux_sym_shebang_line_repeat1,
  [9677] = 1,
    ACTIONS(1052), 4,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
      anon_sym_LBRACE_LBRACE,
      sym__eol,
  [9684] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(153), 3,
      anon_sym_AMP_AMP,
      anon_sym_RBRACE_RBRACE,
      anon_sym_PIPE_PIPE,
  [9693] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(153), 1,
      anon_sym_RBRACE_RBRACE,
    ACTIONS(937), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9704] = 1,
    ACTIONS(1054), 4,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
      anon_sym_LBRACE_LBRACE,
      sym__eol,
  [9711] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1056), 1,
      aux_sym_shebang_line_token2,
    ACTIONS(1059), 1,
      sym_shebang_shell,
    STATE(356), 1,
      aux_sym_shebang_line_repeat1,
  [9724] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(161), 3,
      anon_sym_AMP_AMP,
      anon_sym_RBRACE_RBRACE,
      anon_sym_PIPE_PIPE,
  [9733] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(157), 3,
      anon_sym_AMP_AMP,
      anon_sym_RBRACE_RBRACE,
      anon_sym_PIPE_PIPE,
  [9742] = 4,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(1061), 1,
      sym__eol,
    STATE(136), 1,
      sym__ceol,
    STATE(483), 1,
      sym_comment,
  [9755] = 1,
    ACTIONS(1063), 4,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
      anon_sym_LBRACE_LBRACE,
      sym__eol,
  [9762] = 4,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(1065), 1,
      sym__eol,
    STATE(139), 1,
      sym__ceol,
    STATE(483), 1,
      sym_comment,
  [9775] = 4,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(1067), 1,
      sym__eol,
    STATE(133), 1,
      sym__ceol,
    STATE(483), 1,
      sym_comment,
  [9788] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(694), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1069), 1,
      aux_sym__indented_raw_string_token1,
    STATE(368), 1,
      aux_sym__indented_raw_string_repeat1,
  [9801] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1021), 1,
      aux_sym__indented_backtick_token1,
    ACTIONS(1071), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    STATE(346), 1,
      aux_sym__indented_backtick_repeat1,
  [9814] = 4,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(1073), 1,
      sym__eol,
    STATE(175), 1,
      sym__ceol,
    STATE(483), 1,
      sym_comment,
  [9827] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1075), 1,
      anon_sym_COMMA,
    ACTIONS(1078), 1,
      anon_sym_RBRACK,
    STATE(366), 1,
      aux_sym__attribute_list_repeat1,
  [9840] = 4,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(1080), 1,
      sym__eol,
    STATE(154), 1,
      sym__ceol,
    STATE(483), 1,
      sym_comment,
  [9853] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(700), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1082), 1,
      aux_sym__indented_raw_string_token1,
    STATE(396), 1,
      aux_sym__indented_raw_string_repeat1,
  [9866] = 4,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(1084), 1,
      sym__eol,
    STATE(159), 1,
      sym__ceol,
    STATE(483), 1,
      sym_comment,
  [9879] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1021), 1,
      aux_sym__indented_backtick_token1,
    ACTIONS(1086), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    STATE(372), 1,
      aux_sym__indented_backtick_repeat1,
  [9892] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1088), 1,
      anon_sym_RPAREN,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9903] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1021), 1,
      aux_sym__indented_backtick_token1,
    ACTIONS(1090), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    STATE(346), 1,
      aux_sym__indented_backtick_repeat1,
  [9916] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1092), 1,
      anon_sym_RPAREN,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9927] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1094), 1,
      anon_sym_RBRACE,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9938] = 4,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(1096), 1,
      sym__eol,
    STATE(171), 1,
      sym__ceol,
    STATE(483), 1,
      sym_comment,
  [9951] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(662), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1082), 1,
      aux_sym__indented_raw_string_token1,
    STATE(396), 1,
      aux_sym__indented_raw_string_repeat1,
  [9964] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(297), 1,
      anon_sym_RBRACE_RBRACE,
    ACTIONS(937), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9975] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(714), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1098), 1,
      aux_sym__indented_raw_string_token1,
    STATE(381), 1,
      aux_sym__indented_raw_string_repeat1,
  [9988] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(604), 1,
      anon_sym_RBRACK,
    ACTIONS(1100), 1,
      anon_sym_COMMA,
    STATE(341), 1,
      aux_sym__setting_list_repeat1,
  [10001] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1102), 1,
      anon_sym_RBRACE,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10012] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(720), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1082), 1,
      aux_sym__indented_raw_string_token1,
    STATE(396), 1,
      aux_sym__indented_raw_string_repeat1,
  [10025] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(147), 1,
      anon_sym_RPAREN,
    ACTIONS(1104), 1,
      anon_sym_COMMA,
    STATE(344), 1,
      aux_sym_function_parameters_repeat1,
  [10038] = 1,
    ACTIONS(161), 4,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [10045] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(704), 1,
      sym_identifier,
    ACTIONS(710), 1,
      anon_sym_DOLLAR,
    STATE(416), 1,
      sym_recipe_parameter,
  [10058] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1021), 1,
      aux_sym__indented_backtick_token1,
    ACTIONS(1106), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    STATE(387), 1,
      aux_sym__indented_backtick_repeat1,
  [10071] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1108), 1,
      anon_sym_RPAREN,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10082] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1021), 1,
      aux_sym__indented_backtick_token1,
    ACTIONS(1110), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    STATE(346), 1,
      aux_sym__indented_backtick_repeat1,
  [10095] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1112), 1,
      anon_sym_RPAREN,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10106] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1114), 1,
      anon_sym_RBRACE,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10117] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1116), 1,
      aux_sym_shebang_line_token2,
    ACTIONS(1118), 1,
      sym_shebang_shell,
    STATE(348), 1,
      aux_sym_shebang_line_repeat1,
  [10130] = 4,
    ACTIONS(464), 1,
      aux_sym_comment_token1,
    ACTIONS(1120), 1,
      sym__eol,
    STATE(149), 1,
      sym__ceol,
    STATE(483), 1,
      sym_comment,
  [10143] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1042), 1,
      aux_sym_shebang_line_token2,
    ACTIONS(1118), 1,
      sym_shebang_shell,
    STATE(356), 1,
      aux_sym_shebang_line_repeat1,
  [10156] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1122), 1,
      anon_sym_RBRACE_RBRACE,
    ACTIONS(937), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10167] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1124), 1,
      anon_sym_RBRACE,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10178] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1126), 1,
      anon_sym_RBRACE,
    ACTIONS(654), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10189] = 4,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1128), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1130), 1,
      aux_sym__indented_raw_string_token1,
    STATE(396), 1,
      aux_sym__indented_raw_string_repeat1,
  [10202] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1133), 1,
      sym_identifier,
    STATE(3), 1,
      sym__recipe_dependency,
  [10212] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1135), 1,
      anon_sym_LPAREN,
    STATE(353), 1,
      sym_assert_parameters,
  [10222] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1137), 2,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      aux_sym__indented_backtick_token1,
  [10230] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1139), 1,
      sym_identifier,
    STATE(411), 1,
      sym_attribute,
  [10240] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1141), 1,
      sym_expansion_long_middle,
    ACTIONS(1143), 1,
      sym_expansion_long_end,
  [10250] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1145), 1,
      sym_expansion_long_middle,
    ACTIONS(1147), 1,
      sym_expansion_long_end,
  [10260] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1149), 1,
      sym_expansion_long_middle,
    ACTIONS(1151), 1,
      sym_expansion_long_end,
  [10270] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1153), 1,
      anon_sym_LPAREN,
    STATE(14), 1,
      sym_assert_parameters,
  [10280] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1139), 1,
      sym_identifier,
    STATE(343), 1,
      sym_attribute,
  [10290] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1026), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10298] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1155), 2,
      anon_sym_shell,
      sym_identifier,
  [10306] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1157), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10314] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1159), 1,
      sym_expansion_long_middle,
    ACTIONS(1161), 1,
      sym_expansion_long_end,
  [10324] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1163), 1,
      sym_identifier,
    ACTIONS(1165), 1,
      anon_sym_QMARK,
  [10334] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1078), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10342] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1167), 1,
      sym_identifier,
    ACTIONS(1169), 1,
      anon_sym_QMARK,
  [10352] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    STATE(345), 1,
      sym_assert_parameters,
  [10362] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1173), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10370] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1175), 1,
      anon_sym_else,
  [10377] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1177), 1,
      anon_sym_COLON,
  [10384] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1179), 1,
      anon_sym_LBRACE,
  [10391] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1181), 1,
      sym_identifier,
  [10398] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1183), 1,
      sym_identifier,
  [10405] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1185), 1,
      anon_sym_BQUOTE,
  [10412] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1187), 1,
      anon_sym_COLON,
  [10419] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1189), 1,
      sym_identifier,
  [10426] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1191), 1,
      anon_sym_RPAREN,
  [10433] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1193), 1,
      anon_sym_else,
  [10440] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1195), 1,
      sym_identifier,
  [10447] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1197), 1,
      aux_sym__backtick_token1,
  [10454] = 1,
    ACTIONS(1199), 2,
      aux_sym_comment_token1,
      sym__eol,
  [10459] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(927), 1,
      anon_sym_COLON,
  [10466] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1201), 1,
      anon_sym_RPAREN,
  [10473] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(939), 1,
      anon_sym_COLON,
  [10480] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1203), 1,
      anon_sym_SQUOTE,
  [10487] = 1,
    ACTIONS(1205), 2,
      aux_sym_comment_token1,
      sym__eol,
  [10492] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1207), 1,
      anon_sym_COLON_EQ,
  [10499] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1209), 1,
      sym_identifier,
  [10506] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1211), 1,
      anon_sym_LBRACE,
  [10513] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1213), 1,
      anon_sym_COLON_EQ,
  [10520] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1167), 1,
      sym_identifier,
  [10527] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1215), 1,
      sym_identifier,
  [10534] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1217), 1,
      anon_sym_SQUOTE,
  [10541] = 1,
    ACTIONS(1219), 2,
      aux_sym_comment_token1,
      sym__eol,
  [10546] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1221), 1,
      sym_shell_variable_name,
  [10553] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1223), 1,
      ts_builtin_sym_end,
  [10560] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1225), 1,
      anon_sym_COMMA,
  [10567] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1227), 1,
      anon_sym_COLON,
  [10574] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1229), 1,
      sym_shell_variable_name,
  [10581] = 1,
    ACTIONS(1231), 2,
      aux_sym_comment_token1,
      sym__eol,
  [10586] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1233), 1,
      anon_sym_BQUOTE,
  [10593] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(724), 1,
      anon_sym_COLON_EQ,
  [10600] = 1,
    ACTIONS(1235), 2,
      aux_sym_comment_token1,
      sym__eol,
  [10605] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1237), 1,
      anon_sym_RPAREN,
  [10612] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1239), 1,
      sym_identifier,
  [10619] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1241), 1,
      anon_sym_RPAREN,
  [10626] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1243), 1,
      sym_identifier,
  [10633] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1245), 1,
      aux_sym__raw_string_token1,
  [10640] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1247), 1,
      sym_shell_variable_name,
  [10647] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1249), 1,
      aux_sym__backtick_token1,
  [10654] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1251), 1,
      sym_shell_variable_name,
  [10661] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1253), 1,
      aux_sym__raw_string_token1,
  [10668] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1255), 1,
      sym_identifier,
  [10675] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1257), 1,
      aux_sym__backtick_token1,
  [10682] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1259), 1,
      sym_identifier,
  [10689] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1261), 1,
      sym_shell_variable_name,
  [10696] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1263), 1,
      anon_sym_COMMA,
  [10703] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1265), 1,
      anon_sym_LBRACE,
  [10710] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1267), 1,
      anon_sym_COMMA,
  [10717] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1269), 1,
      anon_sym_LBRACE,
  [10724] = 2,
    ACTIONS(313), 1,
      sym__eol,
    ACTIONS(1271), 1,
      aux_sym__raw_string_token1,
  [10731] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1273), 1,
      anon_sym_SQUOTE,
  [10738] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1275), 1,
      anon_sym_COLON_EQ,
  [10745] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1277), 1,
      anon_sym_else,
  [10752] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1279), 1,
      anon_sym_BQUOTE,
  [10759] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1281), 1,
      sym_identifier,
  [10766] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1283), 1,
      sym_shell_variable_name,
  [10773] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1285), 1,
      sym_shell_variable_name,
  [10780] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1287), 1,
      anon_sym_LBRACE,
  [10787] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1289), 1,
      anon_sym_LBRACE,
  [10794] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1291), 1,
      anon_sym_COLON,
  [10801] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1293), 1,
      sym_shell_variable_name,
  [10808] = 1,
    ACTIONS(1295), 2,
      aux_sym_comment_token1,
      sym__eol,
  [10813] = 1,
    ACTIONS(1297), 1,
      sym__eol,
  [10817] = 1,
    ACTIONS(574), 1,
      sym__eol,
  [10821] = 1,
    ACTIONS(1299), 1,
      sym__eol,
  [10825] = 1,
    ACTIONS(1301), 1,
      sym__eol,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 76,
  [SMALL_STATE(4)] = 152,
  [SMALL_STATE(5)] = 228,
  [SMALL_STATE(6)] = 304,
  [SMALL_STATE(7)] = 380,
  [SMALL_STATE(8)] = 456,
  [SMALL_STATE(9)] = 529,
  [SMALL_STATE(10)] = 602,
  [SMALL_STATE(11)] = 675,
  [SMALL_STATE(12)] = 748,
  [SMALL_STATE(13)] = 821,
  [SMALL_STATE(14)] = 894,
  [SMALL_STATE(15)] = 927,
  [SMALL_STATE(16)] = 960,
  [SMALL_STATE(17)] = 993,
  [SMALL_STATE(18)] = 1066,
  [SMALL_STATE(19)] = 1139,
  [SMALL_STATE(20)] = 1209,
  [SMALL_STATE(21)] = 1279,
  [SMALL_STATE(22)] = 1349,
  [SMALL_STATE(23)] = 1419,
  [SMALL_STATE(24)] = 1489,
  [SMALL_STATE(25)] = 1559,
  [SMALL_STATE(26)] = 1629,
  [SMALL_STATE(27)] = 1699,
  [SMALL_STATE(28)] = 1769,
  [SMALL_STATE(29)] = 1839,
  [SMALL_STATE(30)] = 1909,
  [SMALL_STATE(31)] = 1979,
  [SMALL_STATE(32)] = 2049,
  [SMALL_STATE(33)] = 2119,
  [SMALL_STATE(34)] = 2189,
  [SMALL_STATE(35)] = 2259,
  [SMALL_STATE(36)] = 2329,
  [SMALL_STATE(37)] = 2399,
  [SMALL_STATE(38)] = 2469,
  [SMALL_STATE(39)] = 2539,
  [SMALL_STATE(40)] = 2609,
  [SMALL_STATE(41)] = 2679,
  [SMALL_STATE(42)] = 2749,
  [SMALL_STATE(43)] = 2819,
  [SMALL_STATE(44)] = 2889,
  [SMALL_STATE(45)] = 2959,
  [SMALL_STATE(46)] = 3029,
  [SMALL_STATE(47)] = 3081,
  [SMALL_STATE(48)] = 3133,
  [SMALL_STATE(49)] = 3162,
  [SMALL_STATE(50)] = 3191,
  [SMALL_STATE(51)] = 3220,
  [SMALL_STATE(52)] = 3249,
  [SMALL_STATE(53)] = 3280,
  [SMALL_STATE(54)] = 3309,
  [SMALL_STATE(55)] = 3338,
  [SMALL_STATE(56)] = 3367,
  [SMALL_STATE(57)] = 3396,
  [SMALL_STATE(58)] = 3425,
  [SMALL_STATE(59)] = 3454,
  [SMALL_STATE(60)] = 3483,
  [SMALL_STATE(61)] = 3512,
  [SMALL_STATE(62)] = 3541,
  [SMALL_STATE(63)] = 3599,
  [SMALL_STATE(64)] = 3657,
  [SMALL_STATE(65)] = 3687,
  [SMALL_STATE(66)] = 3716,
  [SMALL_STATE(67)] = 3745,
  [SMALL_STATE(68)] = 3774,
  [SMALL_STATE(69)] = 3799,
  [SMALL_STATE(70)] = 3831,
  [SMALL_STATE(71)] = 3853,
  [SMALL_STATE(72)] = 3885,
  [SMALL_STATE(73)] = 3917,
  [SMALL_STATE(74)] = 3949,
  [SMALL_STATE(75)] = 3981,
  [SMALL_STATE(76)] = 4013,
  [SMALL_STATE(77)] = 4045,
  [SMALL_STATE(78)] = 4077,
  [SMALL_STATE(79)] = 4109,
  [SMALL_STATE(80)] = 4131,
  [SMALL_STATE(81)] = 4163,
  [SMALL_STATE(82)] = 4185,
  [SMALL_STATE(83)] = 4209,
  [SMALL_STATE(84)] = 4231,
  [SMALL_STATE(85)] = 4263,
  [SMALL_STATE(86)] = 4285,
  [SMALL_STATE(87)] = 4317,
  [SMALL_STATE(88)] = 4349,
  [SMALL_STATE(89)] = 4381,
  [SMALL_STATE(90)] = 4413,
  [SMALL_STATE(91)] = 4434,
  [SMALL_STATE(92)] = 4455,
  [SMALL_STATE(93)] = 4476,
  [SMALL_STATE(94)] = 4497,
  [SMALL_STATE(95)] = 4518,
  [SMALL_STATE(96)] = 4539,
  [SMALL_STATE(97)] = 4560,
  [SMALL_STATE(98)] = 4581,
  [SMALL_STATE(99)] = 4625,
  [SMALL_STATE(100)] = 4651,
  [SMALL_STATE(101)] = 4677,
  [SMALL_STATE(102)] = 4709,
  [SMALL_STATE(103)] = 4741,
  [SMALL_STATE(104)] = 4773,
  [SMALL_STATE(105)] = 4805,
  [SMALL_STATE(106)] = 4837,
  [SMALL_STATE(107)] = 4863,
  [SMALL_STATE(108)] = 4889,
  [SMALL_STATE(109)] = 4921,
  [SMALL_STATE(110)] = 4953,
  [SMALL_STATE(111)] = 4984,
  [SMALL_STATE(112)] = 5015,
  [SMALL_STATE(113)] = 5046,
  [SMALL_STATE(114)] = 5077,
  [SMALL_STATE(115)] = 5108,
  [SMALL_STATE(116)] = 5139,
  [SMALL_STATE(117)] = 5182,
  [SMALL_STATE(118)] = 5225,
  [SMALL_STATE(119)] = 5256,
  [SMALL_STATE(120)] = 5299,
  [SMALL_STATE(121)] = 5319,
  [SMALL_STATE(122)] = 5339,
  [SMALL_STATE(123)] = 5359,
  [SMALL_STATE(124)] = 5379,
  [SMALL_STATE(125)] = 5399,
  [SMALL_STATE(126)] = 5419,
  [SMALL_STATE(127)] = 5439,
  [SMALL_STATE(128)] = 5459,
  [SMALL_STATE(129)] = 5479,
  [SMALL_STATE(130)] = 5499,
  [SMALL_STATE(131)] = 5519,
  [SMALL_STATE(132)] = 5556,
  [SMALL_STATE(133)] = 5575,
  [SMALL_STATE(134)] = 5594,
  [SMALL_STATE(135)] = 5617,
  [SMALL_STATE(136)] = 5636,
  [SMALL_STATE(137)] = 5655,
  [SMALL_STATE(138)] = 5672,
  [SMALL_STATE(139)] = 5691,
  [SMALL_STATE(140)] = 5710,
  [SMALL_STATE(141)] = 5733,
  [SMALL_STATE(142)] = 5752,
  [SMALL_STATE(143)] = 5769,
  [SMALL_STATE(144)] = 5792,
  [SMALL_STATE(145)] = 5809,
  [SMALL_STATE(146)] = 5832,
  [SMALL_STATE(147)] = 5851,
  [SMALL_STATE(148)] = 5874,
  [SMALL_STATE(149)] = 5893,
  [SMALL_STATE(150)] = 5912,
  [SMALL_STATE(151)] = 5935,
  [SMALL_STATE(152)] = 5954,
  [SMALL_STATE(153)] = 5973,
  [SMALL_STATE(154)] = 5992,
  [SMALL_STATE(155)] = 6011,
  [SMALL_STATE(156)] = 6028,
  [SMALL_STATE(157)] = 6047,
  [SMALL_STATE(158)] = 6066,
  [SMALL_STATE(159)] = 6085,
  [SMALL_STATE(160)] = 6104,
  [SMALL_STATE(161)] = 6141,
  [SMALL_STATE(162)] = 6178,
  [SMALL_STATE(163)] = 6197,
  [SMALL_STATE(164)] = 6216,
  [SMALL_STATE(165)] = 6235,
  [SMALL_STATE(166)] = 6254,
  [SMALL_STATE(167)] = 6273,
  [SMALL_STATE(168)] = 6290,
  [SMALL_STATE(169)] = 6309,
  [SMALL_STATE(170)] = 6328,
  [SMALL_STATE(171)] = 6347,
  [SMALL_STATE(172)] = 6366,
  [SMALL_STATE(173)] = 6385,
  [SMALL_STATE(174)] = 6404,
  [SMALL_STATE(175)] = 6423,
  [SMALL_STATE(176)] = 6442,
  [SMALL_STATE(177)] = 6471,
  [SMALL_STATE(178)] = 6490,
  [SMALL_STATE(179)] = 6509,
  [SMALL_STATE(180)] = 6528,
  [SMALL_STATE(181)] = 6547,
  [SMALL_STATE(182)] = 6563,
  [SMALL_STATE(183)] = 6585,
  [SMALL_STATE(184)] = 6601,
  [SMALL_STATE(185)] = 6625,
  [SMALL_STATE(186)] = 6659,
  [SMALL_STATE(187)] = 6675,
  [SMALL_STATE(188)] = 6709,
  [SMALL_STATE(189)] = 6731,
  [SMALL_STATE(190)] = 6765,
  [SMALL_STATE(191)] = 6799,
  [SMALL_STATE(192)] = 6821,
  [SMALL_STATE(193)] = 6843,
  [SMALL_STATE(194)] = 6865,
  [SMALL_STATE(195)] = 6881,
  [SMALL_STATE(196)] = 6903,
  [SMALL_STATE(197)] = 6925,
  [SMALL_STATE(198)] = 6947,
  [SMALL_STATE(199)] = 6969,
  [SMALL_STATE(200)] = 7001,
  [SMALL_STATE(201)] = 7023,
  [SMALL_STATE(202)] = 7045,
  [SMALL_STATE(203)] = 7067,
  [SMALL_STATE(204)] = 7089,
  [SMALL_STATE(205)] = 7105,
  [SMALL_STATE(206)] = 7139,
  [SMALL_STATE(207)] = 7161,
  [SMALL_STATE(208)] = 7193,
  [SMALL_STATE(209)] = 7222,
  [SMALL_STATE(210)] = 7251,
  [SMALL_STATE(211)] = 7280,
  [SMALL_STATE(212)] = 7309,
  [SMALL_STATE(213)] = 7338,
  [SMALL_STATE(214)] = 7367,
  [SMALL_STATE(215)] = 7396,
  [SMALL_STATE(216)] = 7425,
  [SMALL_STATE(217)] = 7442,
  [SMALL_STATE(218)] = 7471,
  [SMALL_STATE(219)] = 7500,
  [SMALL_STATE(220)] = 7529,
  [SMALL_STATE(221)] = 7558,
  [SMALL_STATE(222)] = 7575,
  [SMALL_STATE(223)] = 7604,
  [SMALL_STATE(224)] = 7621,
  [SMALL_STATE(225)] = 7650,
  [SMALL_STATE(226)] = 7667,
  [SMALL_STATE(227)] = 7693,
  [SMALL_STATE(228)] = 7719,
  [SMALL_STATE(229)] = 7745,
  [SMALL_STATE(230)] = 7771,
  [SMALL_STATE(231)] = 7797,
  [SMALL_STATE(232)] = 7817,
  [SMALL_STATE(233)] = 7843,
  [SMALL_STATE(234)] = 7869,
  [SMALL_STATE(235)] = 7895,
  [SMALL_STATE(236)] = 7921,
  [SMALL_STATE(237)] = 7947,
  [SMALL_STATE(238)] = 7961,
  [SMALL_STATE(239)] = 7987,
  [SMALL_STATE(240)] = 8013,
  [SMALL_STATE(241)] = 8039,
  [SMALL_STATE(242)] = 8065,
  [SMALL_STATE(243)] = 8091,
  [SMALL_STATE(244)] = 8117,
  [SMALL_STATE(245)] = 8131,
  [SMALL_STATE(246)] = 8157,
  [SMALL_STATE(247)] = 8183,
  [SMALL_STATE(248)] = 8209,
  [SMALL_STATE(249)] = 8232,
  [SMALL_STATE(250)] = 8253,
  [SMALL_STATE(251)] = 8274,
  [SMALL_STATE(252)] = 8293,
  [SMALL_STATE(253)] = 8315,
  [SMALL_STATE(254)] = 8327,
  [SMALL_STATE(255)] = 8349,
  [SMALL_STATE(256)] = 8371,
  [SMALL_STATE(257)] = 8393,
  [SMALL_STATE(258)] = 8415,
  [SMALL_STATE(259)] = 8433,
  [SMALL_STATE(260)] = 8447,
  [SMALL_STATE(261)] = 8465,
  [SMALL_STATE(262)] = 8487,
  [SMALL_STATE(263)] = 8509,
  [SMALL_STATE(264)] = 8531,
  [SMALL_STATE(265)] = 8549,
  [SMALL_STATE(266)] = 8563,
  [SMALL_STATE(267)] = 8581,
  [SMALL_STATE(268)] = 8603,
  [SMALL_STATE(269)] = 8625,
  [SMALL_STATE(270)] = 8643,
  [SMALL_STATE(271)] = 8661,
  [SMALL_STATE(272)] = 8679,
  [SMALL_STATE(273)] = 8697,
  [SMALL_STATE(274)] = 8711,
  [SMALL_STATE(275)] = 8729,
  [SMALL_STATE(276)] = 8751,
  [SMALL_STATE(277)] = 8773,
  [SMALL_STATE(278)] = 8795,
  [SMALL_STATE(279)] = 8817,
  [SMALL_STATE(280)] = 8835,
  [SMALL_STATE(281)] = 8849,
  [SMALL_STATE(282)] = 8867,
  [SMALL_STATE(283)] = 8885,
  [SMALL_STATE(284)] = 8899,
  [SMALL_STATE(285)] = 8908,
  [SMALL_STATE(286)] = 8921,
  [SMALL_STATE(287)] = 8936,
  [SMALL_STATE(288)] = 8945,
  [SMALL_STATE(289)] = 8958,
  [SMALL_STATE(290)] = 8969,
  [SMALL_STATE(291)] = 8982,
  [SMALL_STATE(292)] = 8991,
  [SMALL_STATE(293)] = 9008,
  [SMALL_STATE(294)] = 9019,
  [SMALL_STATE(295)] = 9028,
  [SMALL_STATE(296)] = 9037,
  [SMALL_STATE(297)] = 9046,
  [SMALL_STATE(298)] = 9055,
  [SMALL_STATE(299)] = 9064,
  [SMALL_STATE(300)] = 9081,
  [SMALL_STATE(301)] = 9094,
  [SMALL_STATE(302)] = 9107,
  [SMALL_STATE(303)] = 9118,
  [SMALL_STATE(304)] = 9135,
  [SMALL_STATE(305)] = 9152,
  [SMALL_STATE(306)] = 9161,
  [SMALL_STATE(307)] = 9170,
  [SMALL_STATE(308)] = 9179,
  [SMALL_STATE(309)] = 9188,
  [SMALL_STATE(310)] = 9197,
  [SMALL_STATE(311)] = 9207,
  [SMALL_STATE(312)] = 9217,
  [SMALL_STATE(313)] = 9225,
  [SMALL_STATE(314)] = 9237,
  [SMALL_STATE(315)] = 9251,
  [SMALL_STATE(316)] = 9261,
  [SMALL_STATE(317)] = 9275,
  [SMALL_STATE(318)] = 9285,
  [SMALL_STATE(319)] = 9293,
  [SMALL_STATE(320)] = 9301,
  [SMALL_STATE(321)] = 9315,
  [SMALL_STATE(322)] = 9329,
  [SMALL_STATE(323)] = 9339,
  [SMALL_STATE(324)] = 9353,
  [SMALL_STATE(325)] = 9367,
  [SMALL_STATE(326)] = 9377,
  [SMALL_STATE(327)] = 9389,
  [SMALL_STATE(328)] = 9401,
  [SMALL_STATE(329)] = 9411,
  [SMALL_STATE(330)] = 9425,
  [SMALL_STATE(331)] = 9433,
  [SMALL_STATE(332)] = 9443,
  [SMALL_STATE(333)] = 9454,
  [SMALL_STATE(334)] = 9467,
  [SMALL_STATE(335)] = 9480,
  [SMALL_STATE(336)] = 9493,
  [SMALL_STATE(337)] = 9506,
  [SMALL_STATE(338)] = 9517,
  [SMALL_STATE(339)] = 9524,
  [SMALL_STATE(340)] = 9535,
  [SMALL_STATE(341)] = 9548,
  [SMALL_STATE(342)] = 9561,
  [SMALL_STATE(343)] = 9574,
  [SMALL_STATE(344)] = 9587,
  [SMALL_STATE(345)] = 9600,
  [SMALL_STATE(346)] = 9607,
  [SMALL_STATE(347)] = 9620,
  [SMALL_STATE(348)] = 9629,
  [SMALL_STATE(349)] = 9642,
  [SMALL_STATE(350)] = 9651,
  [SMALL_STATE(351)] = 9664,
  [SMALL_STATE(352)] = 9677,
  [SMALL_STATE(353)] = 9684,
  [SMALL_STATE(354)] = 9693,
  [SMALL_STATE(355)] = 9704,
  [SMALL_STATE(356)] = 9711,
  [SMALL_STATE(357)] = 9724,
  [SMALL_STATE(358)] = 9733,
  [SMALL_STATE(359)] = 9742,
  [SMALL_STATE(360)] = 9755,
  [SMALL_STATE(361)] = 9762,
  [SMALL_STATE(362)] = 9775,
  [SMALL_STATE(363)] = 9788,
  [SMALL_STATE(364)] = 9801,
  [SMALL_STATE(365)] = 9814,
  [SMALL_STATE(366)] = 9827,
  [SMALL_STATE(367)] = 9840,
  [SMALL_STATE(368)] = 9853,
  [SMALL_STATE(369)] = 9866,
  [SMALL_STATE(370)] = 9879,
  [SMALL_STATE(371)] = 9892,
  [SMALL_STATE(372)] = 9903,
  [SMALL_STATE(373)] = 9916,
  [SMALL_STATE(374)] = 9927,
  [SMALL_STATE(375)] = 9938,
  [SMALL_STATE(376)] = 9951,
  [SMALL_STATE(377)] = 9964,
  [SMALL_STATE(378)] = 9975,
  [SMALL_STATE(379)] = 9988,
  [SMALL_STATE(380)] = 10001,
  [SMALL_STATE(381)] = 10012,
  [SMALL_STATE(382)] = 10025,
  [SMALL_STATE(383)] = 10038,
  [SMALL_STATE(384)] = 10045,
  [SMALL_STATE(385)] = 10058,
  [SMALL_STATE(386)] = 10071,
  [SMALL_STATE(387)] = 10082,
  [SMALL_STATE(388)] = 10095,
  [SMALL_STATE(389)] = 10106,
  [SMALL_STATE(390)] = 10117,
  [SMALL_STATE(391)] = 10130,
  [SMALL_STATE(392)] = 10143,
  [SMALL_STATE(393)] = 10156,
  [SMALL_STATE(394)] = 10167,
  [SMALL_STATE(395)] = 10178,
  [SMALL_STATE(396)] = 10189,
  [SMALL_STATE(397)] = 10202,
  [SMALL_STATE(398)] = 10212,
  [SMALL_STATE(399)] = 10222,
  [SMALL_STATE(400)] = 10230,
  [SMALL_STATE(401)] = 10240,
  [SMALL_STATE(402)] = 10250,
  [SMALL_STATE(403)] = 10260,
  [SMALL_STATE(404)] = 10270,
  [SMALL_STATE(405)] = 10280,
  [SMALL_STATE(406)] = 10290,
  [SMALL_STATE(407)] = 10298,
  [SMALL_STATE(408)] = 10306,
  [SMALL_STATE(409)] = 10314,
  [SMALL_STATE(410)] = 10324,
  [SMALL_STATE(411)] = 10334,
  [SMALL_STATE(412)] = 10342,
  [SMALL_STATE(413)] = 10352,
  [SMALL_STATE(414)] = 10362,
  [SMALL_STATE(415)] = 10370,
  [SMALL_STATE(416)] = 10377,
  [SMALL_STATE(417)] = 10384,
  [SMALL_STATE(418)] = 10391,
  [SMALL_STATE(419)] = 10398,
  [SMALL_STATE(420)] = 10405,
  [SMALL_STATE(421)] = 10412,
  [SMALL_STATE(422)] = 10419,
  [SMALL_STATE(423)] = 10426,
  [SMALL_STATE(424)] = 10433,
  [SMALL_STATE(425)] = 10440,
  [SMALL_STATE(426)] = 10447,
  [SMALL_STATE(427)] = 10454,
  [SMALL_STATE(428)] = 10459,
  [SMALL_STATE(429)] = 10466,
  [SMALL_STATE(430)] = 10473,
  [SMALL_STATE(431)] = 10480,
  [SMALL_STATE(432)] = 10487,
  [SMALL_STATE(433)] = 10492,
  [SMALL_STATE(434)] = 10499,
  [SMALL_STATE(435)] = 10506,
  [SMALL_STATE(436)] = 10513,
  [SMALL_STATE(437)] = 10520,
  [SMALL_STATE(438)] = 10527,
  [SMALL_STATE(439)] = 10534,
  [SMALL_STATE(440)] = 10541,
  [SMALL_STATE(441)] = 10546,
  [SMALL_STATE(442)] = 10553,
  [SMALL_STATE(443)] = 10560,
  [SMALL_STATE(444)] = 10567,
  [SMALL_STATE(445)] = 10574,
  [SMALL_STATE(446)] = 10581,
  [SMALL_STATE(447)] = 10586,
  [SMALL_STATE(448)] = 10593,
  [SMALL_STATE(449)] = 10600,
  [SMALL_STATE(450)] = 10605,
  [SMALL_STATE(451)] = 10612,
  [SMALL_STATE(452)] = 10619,
  [SMALL_STATE(453)] = 10626,
  [SMALL_STATE(454)] = 10633,
  [SMALL_STATE(455)] = 10640,
  [SMALL_STATE(456)] = 10647,
  [SMALL_STATE(457)] = 10654,
  [SMALL_STATE(458)] = 10661,
  [SMALL_STATE(459)] = 10668,
  [SMALL_STATE(460)] = 10675,
  [SMALL_STATE(461)] = 10682,
  [SMALL_STATE(462)] = 10689,
  [SMALL_STATE(463)] = 10696,
  [SMALL_STATE(464)] = 10703,
  [SMALL_STATE(465)] = 10710,
  [SMALL_STATE(466)] = 10717,
  [SMALL_STATE(467)] = 10724,
  [SMALL_STATE(468)] = 10731,
  [SMALL_STATE(469)] = 10738,
  [SMALL_STATE(470)] = 10745,
  [SMALL_STATE(471)] = 10752,
  [SMALL_STATE(472)] = 10759,
  [SMALL_STATE(473)] = 10766,
  [SMALL_STATE(474)] = 10773,
  [SMALL_STATE(475)] = 10780,
  [SMALL_STATE(476)] = 10787,
  [SMALL_STATE(477)] = 10794,
  [SMALL_STATE(478)] = 10801,
  [SMALL_STATE(479)] = 10808,
  [SMALL_STATE(480)] = 10813,
  [SMALL_STATE(481)] = 10817,
  [SMALL_STATE(482)] = 10821,
  [SMALL_STATE(483)] = 10825,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(199),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(459),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(472),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(419),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(160),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(410),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(407),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(404),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(456),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(454),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(276),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(460),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(458),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(262),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [93] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(52),
  [96] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(41),
  [99] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(8),
  [104] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(404),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(36),
  [110] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(460),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(385),
  [116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(200),
  [119] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(201),
  [122] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(378),
  [125] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(458),
  [128] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(102),
  [131] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(111),
  [134] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(261),
  [137] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(262),
  [140] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(53),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameters, 2, 0, 0),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameters, 3, 0, 0),
  [151] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 2, 0, 0),
  [153] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 2, 0, 0),
  [155] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 9, 0, 0),
  [157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 9, 0, 0),
  [159] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assert_parameters, 5, 0, 0),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assert_parameters, 5, 0, 0),
  [163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(253),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(413),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(426),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(467),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(398),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 1, 0, 0),
  [203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0),
  [205] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(199),
  [208] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(459),
  [211] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(472),
  [214] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(419),
  [217] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(160),
  [220] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(410),
  [223] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(422),
  [226] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(405),
  [229] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(407),
  [232] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(148),
  [235] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 1, 0, 0),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 1, 0, 0),
  [239] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shell_expanded_string, 2, 0, 0),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shell_expanded_string, 2, 0, 0),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_external_command, 1, 0, 0),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_external_command, 1, 0, 0),
  [247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 0),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 0),
  [251] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 1, 0, 0),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 1, 0, 0),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [257] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 0),
  [259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [261] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shell_expanded_string, 3, 0, 0),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shell_expanded_string, 3, 0, 0),
  [265] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__indented_backtick, 2, 0, 0),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__indented_backtick, 2, 0, 0),
  [269] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 3, 0, 0),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 3, 0, 0),
  [273] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__backtick, 3, 0, 0),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__backtick, 3, 0, 0),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__indented_backtick, 3, 0, 10),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__indented_backtick, 3, 0, 10),
  [281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 3, 0, 1),
  [283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 3, 0, 1),
  [285] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 4, 0, 1),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 4, 0, 1),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 1, 0, 0),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 1, 0, 0),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 3, 0, 0),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 3, 0, 0),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 1, 0, 0),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 1, 0, 0),
  [303] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__recipe_dependency, 1, 0, 1),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__recipe_dependency, 1, 0, 1),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 7, 0, 1),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 7, 0, 1),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [313] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 7, 0, 2),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 7, 0, 2),
  [319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 8, 0, 6),
  [321] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 8, 0, 6),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 8, 0, 2),
  [325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 8, 0, 2),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 3, 0, 1),
  [329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 3, 0, 1),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 6, 0, 6),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 6, 0, 6),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 7, 0, 6),
  [337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 7, 0, 6),
  [339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 5, 0, 2),
  [341] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 5, 0, 2),
  [343] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 9, 0, 6),
  [345] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 9, 0, 6),
  [347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 5, 0, 1),
  [349] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 5, 0, 1),
  [351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [353] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 4, 0, 1),
  [355] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 4, 0, 1),
  [357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 4, 0, 2),
  [359] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 4, 0, 2),
  [361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 5, 0, 6),
  [363] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 5, 0, 6),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 6, 0, 2),
  [367] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 6, 0, 2),
  [369] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 6, 0, 1),
  [371] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 6, 0, 1),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_body, 1, 0, 0),
  [379] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe_body, 1, 0, 0),
  [381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_body, 1, 0, 8),
  [385] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe_body, 1, 0, 8),
  [387] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [389] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [391] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [393] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [395] = {.entry = {.count = 1, .reusable = false}}, SHIFT(457),
  [397] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [399] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [401] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(123),
  [404] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 2, 0, 0),
  [406] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(137),
  [409] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(103),
  [412] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(457),
  [415] = {.entry = {.count = 1, .reusable = false}}, SHIFT(55),
  [417] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [419] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [421] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_body, 2, 0, 8),
  [425] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe_body, 2, 0, 8),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_recipe_body_repeat1, 2, 0, 0),
  [429] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_recipe_body_repeat1, 2, 0, 0),
  [431] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_body_repeat1, 2, 0, 0), SHIFT_REPEAT(184),
  [434] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [436] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [438] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [440] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [442] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [444] = {.entry = {.count = 1, .reusable = false}}, SHIFT(473),
  [446] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [448] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [450] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(170),
  [453] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 2, 0, 0),
  [455] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(194),
  [458] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(115),
  [461] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(473),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [470] = {.entry = {.count = 1, .reusable = false}}, SHIFT(114),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [474] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shebang_line, 5, 0, 0),
  [476] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shebang_line, 5, 0, 0),
  [478] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shebang_line, 7, 0, 23),
  [480] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shebang_line, 7, 0, 23),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__ceol, 2, 0, 0),
  [484] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__ceol, 2, 0, 0),
  [486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 1, 0, 0),
  [488] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expansion_short_start, 1, 0, 0),
  [490] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_line, 3, 0, 16),
  [492] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe_line, 3, 0, 16),
  [494] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_line, 4, 0, 19),
  [496] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe_line, 4, 0, 19),
  [498] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shebang_line, 4, 0, 0),
  [500] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shebang_line, 4, 0, 0),
  [502] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shebang_line, 5, 0, 21),
  [504] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shebang_line, 5, 0, 21),
  [506] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shebang_line, 6, 0, 22),
  [508] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shebang_line, 6, 0, 22),
  [510] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shebang_line, 6, 0, 0),
  [512] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shebang_line, 6, 0, 0),
  [514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_alias, 5, 0, 2),
  [518] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_alias, 5, 0, 2),
  [520] = {.entry = {.count = 1, .reusable = false}}, SHIFT(223),
  [522] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 5, 0, 2),
  [528] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment, 5, 0, 2),
  [530] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_alias, 6, 0, 6),
  [532] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_alias, 6, 0, 6),
  [534] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_escape_sequence, 1, 0, 0),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 6, 0, 6),
  [538] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment, 6, 0, 6),
  [540] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 6, 0, 18),
  [542] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mod, 6, 0, 18),
  [544] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [548] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 5, 0, 0),
  [550] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(223),
  [553] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(143),
  [556] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat1, 2, 0, 0),
  [558] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 3, 0, 0),
  [560] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(225),
  [563] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(145),
  [566] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat1, 2, 0, 0),
  [568] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [570] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [574] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 1, 0, 0),
  [576] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment, 1, 0, 0),
  [578] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 5, 0, 9),
  [580] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mod, 5, 0, 9),
  [582] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [586] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_setting, 3, 0, 2),
  [588] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_setting, 3, 0, 2),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 3, 0, 3),
  [592] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import, 3, 0, 3),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_setting, 4, 0, 2),
  [596] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_setting, 4, 0, 2),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unexport, 3, 0, 2),
  [600] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unexport, 3, 0, 2),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [606] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 8, 0, 1),
  [608] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 8, 0, 1),
  [610] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 3, 0, 2),
  [612] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mod, 3, 0, 2),
  [614] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 9, 0, 2),
  [616] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 9, 0, 2),
  [618] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 4, 0, 0),
  [620] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 4, 0, 6),
  [622] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mod, 4, 0, 6),
  [624] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 1, 0, 0),
  [626] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expansion_short_start, 1, 0, 0),
  [628] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 4, 0, 7),
  [630] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mod, 4, 0, 7),
  [632] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 10, 0, 6),
  [634] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 10, 0, 6),
  [636] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 4, 0, 1),
  [638] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment, 4, 0, 1),
  [640] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 4, 0, 5),
  [642] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import, 4, 0, 5),
  [644] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [646] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [648] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [650] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [652] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [656] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 5, 0, 14),
  [658] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mod, 5, 0, 14),
  [660] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 5, 0, 0),
  [662] = {.entry = {.count = 1, .reusable = false}}, SHIFT(306),
  [664] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [666] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [668] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 4, 0, 0),
  [670] = {.entry = {.count = 1, .reusable = false}}, SHIFT(305),
  [672] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [674] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [676] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [678] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__normal_string_repeat1, 2, 0, 0),
  [680] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(192),
  [683] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(237),
  [686] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__indented_normal_string_repeat1, 2, 0, 0),
  [688] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__indented_normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(193),
  [691] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__indented_normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(244),
  [694] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [696] = {.entry = {.count = 1, .reusable = false}}, SHIFT(197),
  [698] = {.entry = {.count = 1, .reusable = false}}, SHIFT(198),
  [700] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [702] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [708] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [714] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [716] = {.entry = {.count = 1, .reusable = false}}, SHIFT(202),
  [718] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [720] = {.entry = {.count = 1, .reusable = false}}, SHIFT(54),
  [722] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 3, 0, 0),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [726] = {.entry = {.count = 1, .reusable = false}}, SHIFT(210),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_escape_sequence, 1, 0, 0),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [776] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_alias_repeat1, 2, 0, 0),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_alias_repeat1, 2, 0, 0),
  [780] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_alias_repeat1, 2, 0, 0), SHIFT_REPEAT(405),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [789] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [791] = {.entry = {.count = 1, .reusable = false}}, SHIFT(425),
  [793] = {.entry = {.count = 1, .reusable = false}}, SHIFT(451),
  [795] = {.entry = {.count = 1, .reusable = false}}, SHIFT(412),
  [797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [803] = {.entry = {.count = 1, .reusable = false}}, SHIFT(390),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [809] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(318),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0),
  [814] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(397),
  [817] = {.entry = {.count = 1, .reusable = false}}, SHIFT(288),
  [819] = {.entry = {.count = 1, .reusable = false}}, SHIFT(278),
  [821] = {.entry = {.count = 1, .reusable = false}}, SHIFT(455),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [825] = {.entry = {.count = 1, .reusable = false}}, SHIFT(285),
  [827] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [829] = {.entry = {.count = 1, .reusable = false}}, SHIFT(445),
  [831] = {.entry = {.count = 1, .reusable = false}}, SHIFT(277),
  [833] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 2, 0, 0), SHIFT_REPEAT(285),
  [836] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 2, 0, 0),
  [838] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 2, 0, 0), SHIFT_REPEAT(257),
  [841] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 2, 0, 0), SHIFT_REPEAT(445),
  [844] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [846] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_parameter, 2, 0, 2),
  [848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [850] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [852] = {.entry = {.count = 1, .reusable = false}}, SHIFT(267),
  [854] = {.entry = {.count = 1, .reusable = false}}, SHIFT(268),
  [856] = {.entry = {.count = 1, .reusable = false}}, SHIFT(254),
  [858] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [860] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__attribute_list, 4, 0, 0),
  [862] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__attribute_list, 4, 0, 0),
  [864] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [866] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [868] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [870] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(273),
  [873] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(434),
  [876] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_recipe_parameters_repeat1, 2, 0, 0),
  [878] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [880] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_parameter, 1, 0, 1),
  [882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [884] = {.entry = {.count = 1, .reusable = false}}, SHIFT(255),
  [886] = {.entry = {.count = 1, .reusable = false}}, SHIFT(256),
  [888] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 2, 0, 0), SHIFT_REPEAT(288),
  [891] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 2, 0, 0),
  [893] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 2, 0, 0), SHIFT_REPEAT(277),
  [896] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 2, 0, 0), SHIFT_REPEAT(455),
  [899] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_shebang_line_repeat2, 2, 0, 17), SHIFT_REPEAT(352),
  [902] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_shebang_line_repeat2, 2, 0, 17), SHIFT_REPEAT(26),
  [905] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_shebang_line_repeat2, 2, 0, 17),
  [907] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__attribute_list, 5, 0, 0),
  [909] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__attribute_list, 5, 0, 0),
  [911] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [913] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [915] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 1, 0, 0),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [921] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 1, 0, 0),
  [923] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_parameter, 3, 0, 1),
  [925] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_recipe_parameters_repeat1, 1, 0, 0),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_parameters, 1, 0, 0),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [935] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameters, 1, 0, 0),
  [937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [939] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_parameters, 2, 0, 0),
  [941] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_parameter, 4, 0, 2),
  [943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [947] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 4, 0, 0),
  [949] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 3, 0, 0),
  [951] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_dependency, 3, 0, 11),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_parameters_repeat1, 2, 0, 0),
  [955] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat1, 2, 0, 0), SHIFT_REPEAT(314),
  [958] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat1, 2, 0, 0),
  [960] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 5, 0, 0),
  [962] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat1, 2, 0, 0), SHIFT_REPEAT(316),
  [965] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat1, 2, 0, 0),
  [967] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 5, 0, 0),
  [969] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_dependency, 1, 0, 4),
  [971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [973] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1, 0, 1),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [977] = {.entry = {.count = 1, .reusable = false}}, SHIFT(314),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [981] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 4, 0, 0),
  [983] = {.entry = {.count = 1, .reusable = false}}, SHIFT(316),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [987] = {.entry = {.count = 1, .reusable = false}}, SHIFT(321),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [991] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 3, 0, 0),
  [993] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition, 3, 0, 0),
  [995] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition, 3, 0, 15),
  [997] = {.entry = {.count = 1, .reusable = false}}, SHIFT(323),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [1001] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_dependency, 4, 0, 11),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1013] = {.entry = {.count = 1, .reusable = false}}, SHIFT(376),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1019] = {.entry = {.count = 1, .reusable = false}}, SHIFT(287),
  [1021] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [1023] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__setting_list_repeat1, 2, 0, 0), SHIFT_REPEAT(205),
  [1026] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__setting_list_repeat1, 2, 0, 0),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [1034] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(29),
  [1037] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__indented_backtick_repeat1, 2, 0, 0),
  [1039] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__indented_backtick_repeat1, 2, 0, 0), SHIFT_REPEAT(399),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [1052] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__recipe_line_choice, 1, 0, 12),
  [1054] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_shebang_line_repeat2, 1, 0, 13),
  [1056] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shebang_line_repeat1, 2, 0, 0), SHIFT_REPEAT(356),
  [1059] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_shebang_line_repeat1, 2, 0, 0),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [1063] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpolation, 3, 0, 20),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [1069] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [1071] = {.entry = {.count = 1, .reusable = false}}, SHIFT(297),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [1075] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__attribute_list_repeat1, 2, 0, 0), SHIFT_REPEAT(400),
  [1078] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__attribute_list_repeat1, 2, 0, 0),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1082] = {.entry = {.count = 1, .reusable = false}}, SHIFT(396),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1086] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [1088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1090] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1098] = {.entry = {.count = 1, .reusable = false}}, SHIFT(381),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [1102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [1106] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1110] = {.entry = {.count = 1, .reusable = false}}, SHIFT(59),
  [1112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [1120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [1126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [1128] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__indented_raw_string_repeat1, 2, 0, 0),
  [1130] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__indented_raw_string_repeat1, 2, 0, 0), SHIFT_REPEAT(396),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [1137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__indented_backtick_repeat1, 1, 0, 0),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [1157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 4, 0, 1),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 3, 0, 1),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variadic_parameter, 2, 0, 0),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1199] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__setting_list, 6, 0, 0),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [1205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__setting_list, 4, 0, 0),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__setting_string, 2, 0, 0),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [1223] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__setting_boolean, 2, 0, 0),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1, 0, 0),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [1251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [1259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [1273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [1275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [1277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [1285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [1287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__setting_list, 5, 0, 0),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [1299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [1301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_just(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
