#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1282
#define LARGE_STATE_COUNT 354
#define SYMBOL_COUNT 292
#define ALIAS_COUNT 1
#define TOKEN_COUNT 130
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 37
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 238

enum {
  sym_identifier = 1,
  sym_decimal_integer_literal = 2,
  sym_hex_integer_literal = 3,
  sym_octal_integer_literal = 4,
  sym_binary_integer_literal = 5,
  sym_decimal_floating_point_literal = 6,
  sym_hex_floating_point_literal = 7,
  sym_true = 8,
  sym_false = 9,
  sym_character_literal = 10,
  sym_string_literal = 11,
  sym_text_block = 12,
  sym_null_literal = 13,
  anon_sym_LPAREN = 14,
  anon_sym_AMP = 15,
  anon_sym_RPAREN = 16,
  anon_sym_EQ = 17,
  anon_sym_PLUS_EQ = 18,
  anon_sym_DASH_EQ = 19,
  anon_sym_STAR_EQ = 20,
  anon_sym_SLASH_EQ = 21,
  anon_sym_AMP_EQ = 22,
  anon_sym_PIPE_EQ = 23,
  anon_sym_CARET_EQ = 24,
  anon_sym_PERCENT_EQ = 25,
  anon_sym_LT_LT_EQ = 26,
  anon_sym_GT_GT_EQ = 27,
  anon_sym_GT_GT_GT_EQ = 28,
  anon_sym_GT = 29,
  anon_sym_LT = 30,
  anon_sym_GT_EQ = 31,
  anon_sym_LT_EQ = 32,
  anon_sym_EQ_EQ = 33,
  anon_sym_BANG_EQ = 34,
  anon_sym_AMP_AMP = 35,
  anon_sym_PIPE_PIPE = 36,
  anon_sym_PLUS = 37,
  anon_sym_DASH = 38,
  anon_sym_STAR = 39,
  anon_sym_SLASH = 40,
  anon_sym_PIPE = 41,
  anon_sym_CARET = 42,
  anon_sym_PERCENT = 43,
  anon_sym_LT_LT = 44,
  anon_sym_GT_GT = 45,
  anon_sym_GT_GT_GT = 46,
  anon_sym_instanceof = 47,
  anon_sym_final = 48,
  anon_sym_DASH_GT = 49,
  anon_sym_COMMA = 50,
  anon_sym_QMARK = 51,
  anon_sym_COLON = 52,
  anon_sym_BANG = 53,
  anon_sym_TILDE = 54,
  anon_sym_PLUS_PLUS = 55,
  anon_sym_DASH_DASH = 56,
  anon_sym_new = 57,
  anon_sym_LBRACK = 58,
  anon_sym_RBRACK = 59,
  anon_sym_DOT = 60,
  anon_sym_class = 61,
  anon_sym_COLON_COLON = 62,
  anon_sym_extends = 63,
  anon_sym_switch = 64,
  anon_sym_LBRACE = 65,
  anon_sym_RBRACE = 66,
  anon_sym_case = 67,
  anon_sym_default = 68,
  anon_sym_SEMI = 69,
  anon_sym_assert = 70,
  anon_sym_do = 71,
  anon_sym_while = 72,
  anon_sym_break = 73,
  anon_sym_continue = 74,
  anon_sym_return = 75,
  anon_sym_yield = 76,
  anon_sym_synchronized = 77,
  anon_sym_throw = 78,
  anon_sym_try = 79,
  anon_sym_catch = 80,
  anon_sym_finally = 81,
  anon_sym_if = 82,
  anon_sym_else = 83,
  anon_sym_for = 84,
  anon_sym_AT = 85,
  anon_sym_open = 86,
  anon_sym_module = 87,
  anon_sym_requires = 88,
  anon_sym_transitive = 89,
  anon_sym_static = 90,
  anon_sym_exports = 91,
  anon_sym_to = 92,
  anon_sym_opens = 93,
  anon_sym_uses = 94,
  anon_sym_provides = 95,
  anon_sym_with = 96,
  anon_sym_package = 97,
  anon_sym_import = 98,
  anon_sym_enum = 99,
  anon_sym_public = 100,
  anon_sym_protected = 101,
  anon_sym_private = 102,
  anon_sym_abstract = 103,
  anon_sym_strictfp = 104,
  anon_sym_native = 105,
  anon_sym_transient = 106,
  anon_sym_volatile = 107,
  anon_sym_sealed = 108,
  anon_sym_non_DASHsealed = 109,
  anon_sym_implements = 110,
  anon_sym_permits = 111,
  anon_sym_record = 112,
  anon_sym_ATinterface = 113,
  anon_sym_interface = 114,
  anon_sym_byte = 115,
  anon_sym_short = 116,
  anon_sym_int = 117,
  anon_sym_long = 118,
  anon_sym_char = 119,
  anon_sym_float = 120,
  anon_sym_double = 121,
  sym_boolean_type = 122,
  sym_void_type = 123,
  anon_sym_DOT_DOT_DOT = 124,
  anon_sym_throws = 125,
  sym_this = 126,
  sym_super = 127,
  sym_line_comment = 128,
  sym_block_comment = 129,
  sym_program = 130,
  sym__literal = 131,
  sym_expression = 132,
  sym_cast_expression = 133,
  sym_assignment_expression = 134,
  sym_binary_expression = 135,
  sym_instanceof_expression = 136,
  sym_lambda_expression = 137,
  sym_inferred_parameters = 138,
  sym_ternary_expression = 139,
  sym_unary_expression = 140,
  sym_update_expression = 141,
  sym_primary_expression = 142,
  sym_array_creation_expression = 143,
  sym_dimensions_expr = 144,
  sym_parenthesized_expression = 145,
  sym_class_literal = 146,
  sym_object_creation_expression = 147,
  sym__unqualified_object_creation_expression = 148,
  sym_field_access = 149,
  sym_array_access = 150,
  sym_method_invocation = 151,
  sym_argument_list = 152,
  sym_method_reference = 153,
  sym_type_arguments = 154,
  sym_wildcard = 155,
  sym__wildcard_bounds = 156,
  sym_dimensions = 157,
  sym_switch_expression = 158,
  sym_switch_block = 159,
  sym_switch_block_statement_group = 160,
  sym_switch_rule = 161,
  sym_switch_label = 162,
  sym_statement = 163,
  sym_block = 164,
  sym_expression_statement = 165,
  sym_labeled_statement = 166,
  sym_assert_statement = 167,
  sym_do_statement = 168,
  sym_break_statement = 169,
  sym_continue_statement = 170,
  sym_return_statement = 171,
  sym_yield_statement = 172,
  sym_synchronized_statement = 173,
  sym_throw_statement = 174,
  sym_try_statement = 175,
  sym_catch_clause = 176,
  sym_catch_formal_parameter = 177,
  sym_catch_type = 178,
  sym_finally_clause = 179,
  sym_try_with_resources_statement = 180,
  sym_resource_specification = 181,
  sym_resource = 182,
  sym_if_statement = 183,
  sym_while_statement = 184,
  sym_for_statement = 185,
  sym_enhanced_for_statement = 186,
  sym__annotation = 187,
  sym_marker_annotation = 188,
  sym_annotation = 189,
  sym_annotation_argument_list = 190,
  sym_element_value_pair = 191,
  sym__element_value = 192,
  sym_element_value_array_initializer = 193,
  sym_declaration = 194,
  sym_module_declaration = 195,
  sym_module_body = 196,
  sym_module_directive = 197,
  sym_requires_module_directive = 198,
  sym_requires_modifier = 199,
  sym_exports_module_directive = 200,
  sym_opens_module_directive = 201,
  sym_uses_module_directive = 202,
  sym_provides_module_directive = 203,
  sym_package_declaration = 204,
  sym_import_declaration = 205,
  sym_asterisk = 206,
  sym_enum_declaration = 207,
  sym_enum_body = 208,
  sym_enum_body_declarations = 209,
  sym_enum_constant = 210,
  sym_class_declaration = 211,
  sym_modifiers = 212,
  sym_type_parameters = 213,
  sym_type_parameter = 214,
  sym_type_bound = 215,
  sym_superclass = 216,
  sym_super_interfaces = 217,
  sym_type_list = 218,
  sym_permits = 219,
  sym_class_body = 220,
  sym_static_initializer = 221,
  sym_constructor_declaration = 222,
  sym__constructor_declarator = 223,
  sym_constructor_body = 224,
  sym_explicit_constructor_invocation = 225,
  sym_scoped_identifier = 226,
  sym_field_declaration = 227,
  sym_record_declaration = 228,
  sym_annotation_type_declaration = 229,
  sym_annotation_type_body = 230,
  sym_annotation_type_element_declaration = 231,
  sym__default_value = 232,
  sym_interface_declaration = 233,
  sym_extends_interfaces = 234,
  sym_interface_body = 235,
  sym_constant_declaration = 236,
  sym__variable_declarator_list = 237,
  sym_variable_declarator = 238,
  sym__variable_declarator_id = 239,
  sym_array_initializer = 240,
  sym__type = 241,
  sym__unannotated_type = 242,
  sym_annotated_type = 243,
  sym_scoped_type_identifier = 244,
  sym_generic_type = 245,
  sym_array_type = 246,
  sym_integral_type = 247,
  sym_floating_point_type = 248,
  sym__method_header = 249,
  sym__method_declarator = 250,
  sym_formal_parameters = 251,
  sym_formal_parameter = 252,
  sym_receiver_parameter = 253,
  sym_spread_parameter = 254,
  sym_throws = 255,
  sym_local_variable_declaration = 256,
  sym_method_declaration = 257,
  sym_compact_constructor_declaration = 258,
  aux_sym_program_repeat1 = 259,
  aux_sym_cast_expression_repeat1 = 260,
  aux_sym_inferred_parameters_repeat1 = 261,
  aux_sym_array_creation_expression_repeat1 = 262,
  aux_sym_array_creation_expression_repeat2 = 263,
  aux_sym_argument_list_repeat1 = 264,
  aux_sym_type_arguments_repeat1 = 265,
  aux_sym_dimensions_repeat1 = 266,
  aux_sym_switch_block_repeat1 = 267,
  aux_sym_switch_block_repeat2 = 268,
  aux_sym_switch_block_statement_group_repeat1 = 269,
  aux_sym_try_statement_repeat1 = 270,
  aux_sym_catch_type_repeat1 = 271,
  aux_sym_resource_specification_repeat1 = 272,
  aux_sym_for_statement_repeat1 = 273,
  aux_sym_for_statement_repeat2 = 274,
  aux_sym_annotation_argument_list_repeat1 = 275,
  aux_sym_element_value_array_initializer_repeat1 = 276,
  aux_sym_module_body_repeat1 = 277,
  aux_sym_requires_module_directive_repeat1 = 278,
  aux_sym_exports_module_directive_repeat1 = 279,
  aux_sym_provides_module_directive_repeat1 = 280,
  aux_sym_enum_body_repeat1 = 281,
  aux_sym_enum_body_declarations_repeat1 = 282,
  aux_sym_modifiers_repeat1 = 283,
  aux_sym_type_parameters_repeat1 = 284,
  aux_sym_type_bound_repeat1 = 285,
  aux_sym_type_list_repeat1 = 286,
  aux_sym_annotation_type_body_repeat1 = 287,
  aux_sym_interface_body_repeat1 = 288,
  aux_sym__variable_declarator_list_repeat1 = 289,
  aux_sym_array_initializer_repeat1 = 290,
  aux_sym_formal_parameters_repeat1 = 291,
  alias_sym_type_identifier = 292,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_decimal_integer_literal] = "decimal_integer_literal",
  [sym_hex_integer_literal] = "hex_integer_literal",
  [sym_octal_integer_literal] = "octal_integer_literal",
  [sym_binary_integer_literal] = "binary_integer_literal",
  [sym_decimal_floating_point_literal] = "decimal_floating_point_literal",
  [sym_hex_floating_point_literal] = "hex_floating_point_literal",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_character_literal] = "character_literal",
  [sym_string_literal] = "string_literal",
  [sym_text_block] = "text_block",
  [sym_null_literal] = "null_literal",
  [anon_sym_LPAREN] = "(",
  [anon_sym_AMP] = "&",
  [anon_sym_RPAREN] = ")",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_final] = "final",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_COMMA] = ",",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_new] = "new",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_extends] = "extends",
  [anon_sym_switch] = "switch",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_SEMI] = ";",
  [anon_sym_assert] = "assert",
  [anon_sym_do] = "do",
  [anon_sym_while] = "while",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_return] = "return",
  [anon_sym_yield] = "yield",
  [anon_sym_synchronized] = "synchronized",
  [anon_sym_throw] = "throw",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_AT] = "@",
  [anon_sym_open] = "open",
  [anon_sym_module] = "module",
  [anon_sym_requires] = "requires",
  [anon_sym_transitive] = "transitive",
  [anon_sym_static] = "static",
  [anon_sym_exports] = "exports",
  [anon_sym_to] = "to",
  [anon_sym_opens] = "opens",
  [anon_sym_uses] = "uses",
  [anon_sym_provides] = "provides",
  [anon_sym_with] = "with",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_enum] = "enum",
  [anon_sym_public] = "public",
  [anon_sym_protected] = "protected",
  [anon_sym_private] = "private",
  [anon_sym_abstract] = "abstract",
  [anon_sym_strictfp] = "strictfp",
  [anon_sym_native] = "native",
  [anon_sym_transient] = "transient",
  [anon_sym_volatile] = "volatile",
  [anon_sym_sealed] = "sealed",
  [anon_sym_non_DASHsealed] = "non-sealed",
  [anon_sym_implements] = "implements",
  [anon_sym_permits] = "permits",
  [anon_sym_record] = "record",
  [anon_sym_ATinterface] = "@interface",
  [anon_sym_interface] = "interface",
  [anon_sym_byte] = "byte",
  [anon_sym_short] = "short",
  [anon_sym_int] = "int",
  [anon_sym_long] = "long",
  [anon_sym_char] = "char",
  [anon_sym_float] = "float",
  [anon_sym_double] = "double",
  [sym_boolean_type] = "boolean_type",
  [sym_void_type] = "void_type",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_throws] = "throws",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_line_comment] = "line_comment",
  [sym_block_comment] = "block_comment",
  [sym_program] = "program",
  [sym__literal] = "_literal",
  [sym_expression] = "expression",
  [sym_cast_expression] = "cast_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_instanceof_expression] = "instanceof_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_inferred_parameters] = "inferred_parameters",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_primary_expression] = "primary_expression",
  [sym_array_creation_expression] = "array_creation_expression",
  [sym_dimensions_expr] = "dimensions_expr",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_class_literal] = "class_literal",
  [sym_object_creation_expression] = "object_creation_expression",
  [sym__unqualified_object_creation_expression] = "_unqualified_object_creation_expression",
  [sym_field_access] = "field_access",
  [sym_array_access] = "array_access",
  [sym_method_invocation] = "method_invocation",
  [sym_argument_list] = "argument_list",
  [sym_method_reference] = "method_reference",
  [sym_type_arguments] = "type_arguments",
  [sym_wildcard] = "wildcard",
  [sym__wildcard_bounds] = "_wildcard_bounds",
  [sym_dimensions] = "dimensions",
  [sym_switch_expression] = "switch_expression",
  [sym_switch_block] = "switch_block",
  [sym_switch_block_statement_group] = "switch_block_statement_group",
  [sym_switch_rule] = "switch_rule",
  [sym_switch_label] = "switch_label",
  [sym_statement] = "statement",
  [sym_block] = "block",
  [sym_expression_statement] = "expression_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_assert_statement] = "assert_statement",
  [sym_do_statement] = "do_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_return_statement] = "return_statement",
  [sym_yield_statement] = "yield_statement",
  [sym_synchronized_statement] = "synchronized_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_catch_formal_parameter] = "catch_formal_parameter",
  [sym_catch_type] = "catch_type",
  [sym_finally_clause] = "finally_clause",
  [sym_try_with_resources_statement] = "try_with_resources_statement",
  [sym_resource_specification] = "resource_specification",
  [sym_resource] = "resource",
  [sym_if_statement] = "if_statement",
  [sym_while_statement] = "while_statement",
  [sym_for_statement] = "for_statement",
  [sym_enhanced_for_statement] = "enhanced_for_statement",
  [sym__annotation] = "_annotation",
  [sym_marker_annotation] = "marker_annotation",
  [sym_annotation] = "annotation",
  [sym_annotation_argument_list] = "annotation_argument_list",
  [sym_element_value_pair] = "element_value_pair",
  [sym__element_value] = "_element_value",
  [sym_element_value_array_initializer] = "element_value_array_initializer",
  [sym_declaration] = "declaration",
  [sym_module_declaration] = "module_declaration",
  [sym_module_body] = "module_body",
  [sym_module_directive] = "module_directive",
  [sym_requires_module_directive] = "requires_module_directive",
  [sym_requires_modifier] = "requires_modifier",
  [sym_exports_module_directive] = "exports_module_directive",
  [sym_opens_module_directive] = "opens_module_directive",
  [sym_uses_module_directive] = "uses_module_directive",
  [sym_provides_module_directive] = "provides_module_directive",
  [sym_package_declaration] = "package_declaration",
  [sym_import_declaration] = "import_declaration",
  [sym_asterisk] = "asterisk",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_body_declarations] = "enum_body_declarations",
  [sym_enum_constant] = "enum_constant",
  [sym_class_declaration] = "class_declaration",
  [sym_modifiers] = "modifiers",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_bound] = "type_bound",
  [sym_superclass] = "superclass",
  [sym_super_interfaces] = "super_interfaces",
  [sym_type_list] = "type_list",
  [sym_permits] = "permits",
  [sym_class_body] = "class_body",
  [sym_static_initializer] = "static_initializer",
  [sym_constructor_declaration] = "constructor_declaration",
  [sym__constructor_declarator] = "_constructor_declarator",
  [sym_constructor_body] = "constructor_body",
  [sym_explicit_constructor_invocation] = "explicit_constructor_invocation",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_field_declaration] = "field_declaration",
  [sym_record_declaration] = "record_declaration",
  [sym_annotation_type_declaration] = "annotation_type_declaration",
  [sym_annotation_type_body] = "annotation_type_body",
  [sym_annotation_type_element_declaration] = "annotation_type_element_declaration",
  [sym__default_value] = "_default_value",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_interfaces] = "extends_interfaces",
  [sym_interface_body] = "interface_body",
  [sym_constant_declaration] = "constant_declaration",
  [sym__variable_declarator_list] = "_variable_declarator_list",
  [sym_variable_declarator] = "variable_declarator",
  [sym__variable_declarator_id] = "_variable_declarator_id",
  [sym_array_initializer] = "array_initializer",
  [sym__type] = "_type",
  [sym__unannotated_type] = "_unannotated_type",
  [sym_annotated_type] = "annotated_type",
  [sym_scoped_type_identifier] = "scoped_type_identifier",
  [sym_generic_type] = "generic_type",
  [sym_array_type] = "array_type",
  [sym_integral_type] = "integral_type",
  [sym_floating_point_type] = "floating_point_type",
  [sym__method_header] = "_method_header",
  [sym__method_declarator] = "_method_declarator",
  [sym_formal_parameters] = "formal_parameters",
  [sym_formal_parameter] = "formal_parameter",
  [sym_receiver_parameter] = "receiver_parameter",
  [sym_spread_parameter] = "spread_parameter",
  [sym_throws] = "throws",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym_method_declaration] = "method_declaration",
  [sym_compact_constructor_declaration] = "compact_constructor_declaration",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_cast_expression_repeat1] = "cast_expression_repeat1",
  [aux_sym_inferred_parameters_repeat1] = "inferred_parameters_repeat1",
  [aux_sym_array_creation_expression_repeat1] = "array_creation_expression_repeat1",
  [aux_sym_array_creation_expression_repeat2] = "array_creation_expression_repeat2",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_dimensions_repeat1] = "dimensions_repeat1",
  [aux_sym_switch_block_repeat1] = "switch_block_repeat1",
  [aux_sym_switch_block_repeat2] = "switch_block_repeat2",
  [aux_sym_switch_block_statement_group_repeat1] = "switch_block_statement_group_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_catch_type_repeat1] = "catch_type_repeat1",
  [aux_sym_resource_specification_repeat1] = "resource_specification_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_for_statement_repeat2] = "for_statement_repeat2",
  [aux_sym_annotation_argument_list_repeat1] = "annotation_argument_list_repeat1",
  [aux_sym_element_value_array_initializer_repeat1] = "element_value_array_initializer_repeat1",
  [aux_sym_module_body_repeat1] = "module_body_repeat1",
  [aux_sym_requires_module_directive_repeat1] = "requires_module_directive_repeat1",
  [aux_sym_exports_module_directive_repeat1] = "exports_module_directive_repeat1",
  [aux_sym_provides_module_directive_repeat1] = "provides_module_directive_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_enum_body_declarations_repeat1] = "enum_body_declarations_repeat1",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_bound_repeat1] = "type_bound_repeat1",
  [aux_sym_type_list_repeat1] = "type_list_repeat1",
  [aux_sym_annotation_type_body_repeat1] = "annotation_type_body_repeat1",
  [aux_sym_interface_body_repeat1] = "interface_body_repeat1",
  [aux_sym__variable_declarator_list_repeat1] = "_variable_declarator_list_repeat1",
  [aux_sym_array_initializer_repeat1] = "array_initializer_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_decimal_integer_literal] = sym_decimal_integer_literal,
  [sym_hex_integer_literal] = sym_hex_integer_literal,
  [sym_octal_integer_literal] = sym_octal_integer_literal,
  [sym_binary_integer_literal] = sym_binary_integer_literal,
  [sym_decimal_floating_point_literal] = sym_decimal_floating_point_literal,
  [sym_hex_floating_point_literal] = sym_hex_floating_point_literal,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_character_literal] = sym_character_literal,
  [sym_string_literal] = sym_string_literal,
  [sym_text_block] = sym_text_block,
  [sym_null_literal] = sym_null_literal,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_synchronized] = anon_sym_synchronized,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_requires] = anon_sym_requires,
  [anon_sym_transitive] = anon_sym_transitive,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_exports] = anon_sym_exports,
  [anon_sym_to] = anon_sym_to,
  [anon_sym_opens] = anon_sym_opens,
  [anon_sym_uses] = anon_sym_uses,
  [anon_sym_provides] = anon_sym_provides,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_strictfp] = anon_sym_strictfp,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_transient] = anon_sym_transient,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_sealed] = anon_sym_sealed,
  [anon_sym_non_DASHsealed] = anon_sym_non_DASHsealed,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_permits] = anon_sym_permits,
  [anon_sym_record] = anon_sym_record,
  [anon_sym_ATinterface] = anon_sym_ATinterface,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_char] = anon_sym_char,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_double] = anon_sym_double,
  [sym_boolean_type] = sym_boolean_type,
  [sym_void_type] = sym_void_type,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_throws] = anon_sym_throws,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_line_comment] = sym_line_comment,
  [sym_block_comment] = sym_block_comment,
  [sym_program] = sym_program,
  [sym__literal] = sym__literal,
  [sym_expression] = sym_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_instanceof_expression] = sym_instanceof_expression,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_inferred_parameters] = sym_inferred_parameters,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_array_creation_expression] = sym_array_creation_expression,
  [sym_dimensions_expr] = sym_dimensions_expr,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_class_literal] = sym_class_literal,
  [sym_object_creation_expression] = sym_object_creation_expression,
  [sym__unqualified_object_creation_expression] = sym__unqualified_object_creation_expression,
  [sym_field_access] = sym_field_access,
  [sym_array_access] = sym_array_access,
  [sym_method_invocation] = sym_method_invocation,
  [sym_argument_list] = sym_argument_list,
  [sym_method_reference] = sym_method_reference,
  [sym_type_arguments] = sym_type_arguments,
  [sym_wildcard] = sym_wildcard,
  [sym__wildcard_bounds] = sym__wildcard_bounds,
  [sym_dimensions] = sym_dimensions,
  [sym_switch_expression] = sym_switch_expression,
  [sym_switch_block] = sym_switch_block,
  [sym_switch_block_statement_group] = sym_switch_block_statement_group,
  [sym_switch_rule] = sym_switch_rule,
  [sym_switch_label] = sym_switch_label,
  [sym_statement] = sym_statement,
  [sym_block] = sym_block,
  [sym_expression_statement] = sym_expression_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_assert_statement] = sym_assert_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_yield_statement] = sym_yield_statement,
  [sym_synchronized_statement] = sym_synchronized_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_catch_formal_parameter] = sym_catch_formal_parameter,
  [sym_catch_type] = sym_catch_type,
  [sym_finally_clause] = sym_finally_clause,
  [sym_try_with_resources_statement] = sym_try_with_resources_statement,
  [sym_resource_specification] = sym_resource_specification,
  [sym_resource] = sym_resource,
  [sym_if_statement] = sym_if_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_enhanced_for_statement] = sym_enhanced_for_statement,
  [sym__annotation] = sym__annotation,
  [sym_marker_annotation] = sym_marker_annotation,
  [sym_annotation] = sym_annotation,
  [sym_annotation_argument_list] = sym_annotation_argument_list,
  [sym_element_value_pair] = sym_element_value_pair,
  [sym__element_value] = sym__element_value,
  [sym_element_value_array_initializer] = sym_element_value_array_initializer,
  [sym_declaration] = sym_declaration,
  [sym_module_declaration] = sym_module_declaration,
  [sym_module_body] = sym_module_body,
  [sym_module_directive] = sym_module_directive,
  [sym_requires_module_directive] = sym_requires_module_directive,
  [sym_requires_modifier] = sym_requires_modifier,
  [sym_exports_module_directive] = sym_exports_module_directive,
  [sym_opens_module_directive] = sym_opens_module_directive,
  [sym_uses_module_directive] = sym_uses_module_directive,
  [sym_provides_module_directive] = sym_provides_module_directive,
  [sym_package_declaration] = sym_package_declaration,
  [sym_import_declaration] = sym_import_declaration,
  [sym_asterisk] = sym_asterisk,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_body_declarations] = sym_enum_body_declarations,
  [sym_enum_constant] = sym_enum_constant,
  [sym_class_declaration] = sym_class_declaration,
  [sym_modifiers] = sym_modifiers,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_bound] = sym_type_bound,
  [sym_superclass] = sym_superclass,
  [sym_super_interfaces] = sym_super_interfaces,
  [sym_type_list] = sym_type_list,
  [sym_permits] = sym_permits,
  [sym_class_body] = sym_class_body,
  [sym_static_initializer] = sym_static_initializer,
  [sym_constructor_declaration] = sym_constructor_declaration,
  [sym__constructor_declarator] = sym__constructor_declarator,
  [sym_constructor_body] = sym_constructor_body,
  [sym_explicit_constructor_invocation] = sym_explicit_constructor_invocation,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_field_declaration] = sym_field_declaration,
  [sym_record_declaration] = sym_record_declaration,
  [sym_annotation_type_declaration] = sym_annotation_type_declaration,
  [sym_annotation_type_body] = sym_annotation_type_body,
  [sym_annotation_type_element_declaration] = sym_annotation_type_element_declaration,
  [sym__default_value] = sym__default_value,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_interfaces] = sym_extends_interfaces,
  [sym_interface_body] = sym_interface_body,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym__variable_declarator_list] = sym__variable_declarator_list,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym__variable_declarator_id] = sym__variable_declarator_id,
  [sym_array_initializer] = sym_array_initializer,
  [sym__type] = sym__type,
  [sym__unannotated_type] = sym__unannotated_type,
  [sym_annotated_type] = sym_annotated_type,
  [sym_scoped_type_identifier] = sym_scoped_type_identifier,
  [sym_generic_type] = sym_generic_type,
  [sym_array_type] = sym_array_type,
  [sym_integral_type] = sym_integral_type,
  [sym_floating_point_type] = sym_floating_point_type,
  [sym__method_header] = sym__method_header,
  [sym__method_declarator] = sym__method_declarator,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_formal_parameter] = sym_formal_parameter,
  [sym_receiver_parameter] = sym_receiver_parameter,
  [sym_spread_parameter] = sym_spread_parameter,
  [sym_throws] = sym_throws,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [sym_compact_constructor_declaration] = sym_compact_constructor_declaration,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_cast_expression_repeat1] = aux_sym_cast_expression_repeat1,
  [aux_sym_inferred_parameters_repeat1] = aux_sym_inferred_parameters_repeat1,
  [aux_sym_array_creation_expression_repeat1] = aux_sym_array_creation_expression_repeat1,
  [aux_sym_array_creation_expression_repeat2] = aux_sym_array_creation_expression_repeat2,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_dimensions_repeat1] = aux_sym_dimensions_repeat1,
  [aux_sym_switch_block_repeat1] = aux_sym_switch_block_repeat1,
  [aux_sym_switch_block_repeat2] = aux_sym_switch_block_repeat2,
  [aux_sym_switch_block_statement_group_repeat1] = aux_sym_switch_block_statement_group_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_catch_type_repeat1] = aux_sym_catch_type_repeat1,
  [aux_sym_resource_specification_repeat1] = aux_sym_resource_specification_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_for_statement_repeat2] = aux_sym_for_statement_repeat2,
  [aux_sym_annotation_argument_list_repeat1] = aux_sym_annotation_argument_list_repeat1,
  [aux_sym_element_value_array_initializer_repeat1] = aux_sym_element_value_array_initializer_repeat1,
  [aux_sym_module_body_repeat1] = aux_sym_module_body_repeat1,
  [aux_sym_requires_module_directive_repeat1] = aux_sym_requires_module_directive_repeat1,
  [aux_sym_exports_module_directive_repeat1] = aux_sym_exports_module_directive_repeat1,
  [aux_sym_provides_module_directive_repeat1] = aux_sym_provides_module_directive_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_enum_body_declarations_repeat1] = aux_sym_enum_body_declarations_repeat1,
  [aux_sym_modifiers_repeat1] = aux_sym_modifiers_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_bound_repeat1] = aux_sym_type_bound_repeat1,
  [aux_sym_type_list_repeat1] = aux_sym_type_list_repeat1,
  [aux_sym_annotation_type_body_repeat1] = aux_sym_annotation_type_body_repeat1,
  [aux_sym_interface_body_repeat1] = aux_sym_interface_body_repeat1,
  [aux_sym__variable_declarator_list_repeat1] = aux_sym__variable_declarator_list_repeat1,
  [aux_sym_array_initializer_repeat1] = aux_sym_array_initializer_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_character_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_text_block] = {
    .visible = true,
    .named = true,
  },
  [sym_null_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_synchronized] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_requires] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exports] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_opens] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uses] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_provides] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sealed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_non_DASHsealed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_permits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_record] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinterface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_char] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [sym_boolean_type] = {
    .visible = true,
    .named = true,
  },
  [sym_void_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throws] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instanceof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inferred_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dimensions_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_object_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__unqualified_object_creation_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_method_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_method_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym__wildcard_bounds] = {
    .visible = false,
    .named = true,
  },
  [sym_dimensions] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block_statement_group] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yield_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_synchronized_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_type] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_try_with_resources_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_resource_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_resource] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enhanced_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_marker_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_element_value_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__element_value] = {
    .visible = false,
    .named = true,
  },
  [sym_element_value_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module_body] = {
    .visible = true,
    .named = true,
  },
  [sym_module_directive] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_requires_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_requires_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_exports_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_opens_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_uses_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_provides_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_package_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body_declarations] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_superclass] = {
    .visible = true,
    .named = true,
  },
  [sym_super_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_permits] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_static_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_body] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_constructor_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_record_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_body] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_element_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__default_value] = {
    .visible = false,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_list] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_id] = {
    .visible = false,
    .named = true,
  },
  [sym_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__unannotated_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_annotated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_integral_type] = {
    .visible = true,
    .named = true,
  },
  [sym_floating_point_type] = {
    .visible = true,
    .named = true,
  },
  [sym__method_header] = {
    .visible = false,
    .named = true,
  },
  [sym__method_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_receiver_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_throws] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_compact_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cast_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inferred_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_creation_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_creation_expression_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_statement_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_catch_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_resource_specification_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_value_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_requires_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_exports_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_provides_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_bound_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_type_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_declarator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_array = 3,
  field_body = 4,
  field_condition = 5,
  field_consequence = 6,
  field_constructor = 7,
  field_declarator = 8,
  field_dimensions = 9,
  field_element = 10,
  field_field = 11,
  field_index = 12,
  field_init = 13,
  field_interfaces = 14,
  field_key = 15,
  field_left = 16,
  field_modifiers = 17,
  field_module = 18,
  field_modules = 19,
  field_name = 20,
  field_object = 21,
  field_operand = 22,
  field_operator = 23,
  field_package = 24,
  field_parameters = 25,
  field_permits = 26,
  field_provided = 27,
  field_provider = 28,
  field_resources = 29,
  field_right = 30,
  field_scope = 31,
  field_superclass = 32,
  field_type = 33,
  field_type_arguments = 34,
  field_type_parameters = 35,
  field_update = 36,
  field_value = 37,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_array] = "array",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declarator] = "declarator",
  [field_dimensions] = "dimensions",
  [field_element] = "element",
  [field_field] = "field",
  [field_index] = "index",
  [field_init] = "init",
  [field_interfaces] = "interfaces",
  [field_key] = "key",
  [field_left] = "left",
  [field_modifiers] = "modifiers",
  [field_module] = "module",
  [field_modules] = "modules",
  [field_name] = "name",
  [field_object] = "object",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_package] = "package",
  [field_parameters] = "parameters",
  [field_permits] = "permits",
  [field_provided] = "provided",
  [field_provider] = "provider",
  [field_resources] = "resources",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_superclass] = "superclass",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 3},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 8, .length = 1},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 11, .length = 1},
  [13] = {.index = 12, .length = 2},
  [15] = {.index = 14, .length = 3},
  [16] = {.index = 17, .length = 2},
  [17] = {.index = 19, .length = 2},
  [18] = {.index = 17, .length = 2},
  [19] = {.index = 19, .length = 2},
  [20] = {.index = 21, .length = 2},
  [21] = {.index = 23, .length = 2},
  [22] = {.index = 25, .length = 1},
  [23] = {.index = 26, .length = 1},
  [24] = {.index = 27, .length = 2},
  [25] = {.index = 29, .length = 2},
  [26] = {.index = 31, .length = 2},
  [27] = {.index = 31, .length = 2},
  [28] = {.index = 33, .length = 3},
  [29] = {.index = 36, .length = 2},
  [30] = {.index = 21, .length = 2},
  [31] = {.index = 38, .length = 2},
  [32] = {.index = 38, .length = 2},
  [33] = {.index = 33, .length = 3},
  [34] = {.index = 36, .length = 2},
  [36] = {.index = 40, .length = 2},
  [37] = {.index = 42, .length = 3},
  [38] = {.index = 45, .length = 2},
  [39] = {.index = 45, .length = 2},
  [40] = {.index = 47, .length = 2},
  [41] = {.index = 49, .length = 2},
  [43] = {.index = 51, .length = 3},
  [44] = {.index = 54, .length = 1},
  [45] = {.index = 55, .length = 2},
  [46] = {.index = 57, .length = 2},
  [47] = {.index = 59, .length = 3},
  [48] = {.index = 62, .length = 3},
  [49] = {.index = 59, .length = 3},
  [50] = {.index = 62, .length = 3},
  [51] = {.index = 65, .length = 3},
  [52] = {.index = 65, .length = 3},
  [53] = {.index = 68, .length = 2},
  [54] = {.index = 68, .length = 2},
  [55] = {.index = 70, .length = 3},
  [56] = {.index = 73, .length = 3},
  [57] = {.index = 76, .length = 3},
  [58] = {.index = 79, .length = 3},
  [59] = {.index = 82, .length = 2},
  [60] = {.index = 82, .length = 2},
  [61] = {.index = 84, .length = 2},
  [62] = {.index = 84, .length = 2},
  [64] = {.index = 86, .length = 3},
  [65] = {.index = 89, .length = 2},
  [66] = {.index = 91, .length = 3},
  [67] = {.index = 91, .length = 3},
  [69] = {.index = 94, .length = 2},
  [70] = {.index = 96, .length = 3},
  [71] = {.index = 96, .length = 3},
  [72] = {.index = 99, .length = 2},
  [73] = {.index = 101, .length = 2},
  [74] = {.index = 103, .length = 1},
  [75] = {.index = 104, .length = 2},
  [76] = {.index = 106, .length = 3},
  [78] = {.index = 109, .length = 3},
  [79] = {.index = 112, .length = 3},
  [80] = {.index = 115, .length = 3},
  [81] = {.index = 112, .length = 3},
  [82] = {.index = 115, .length = 3},
  [84] = {.index = 118, .length = 2},
  [85] = {.index = 120, .length = 2},
  [86] = {.index = 122, .length = 4},
  [87] = {.index = 126, .length = 4},
  [88] = {.index = 130, .length = 5},
  [89] = {.index = 135, .length = 6},
  [90] = {.index = 141, .length = 4},
  [91] = {.index = 145, .length = 4},
  [92] = {.index = 149, .length = 4},
  [93] = {.index = 153, .length = 4},
  [94] = {.index = 157, .length = 4},
  [95] = {.index = 161, .length = 4},
  [96] = {.index = 165, .length = 2},
  [97] = {.index = 167, .length = 3},
  [98] = {.index = 170, .length = 1},
  [99] = {.index = 171, .length = 2},
  [100] = {.index = 173, .length = 1},
  [101] = {.index = 174, .length = 4},
  [102] = {.index = 178, .length = 4},
  [103] = {.index = 182, .length = 3},
  [104] = {.index = 185, .length = 3},
  [105] = {.index = 188, .length = 2},
  [106] = {.index = 188, .length = 2},
  [107] = {.index = 190, .length = 4},
  [108] = {.index = 190, .length = 4},
  [109] = {.index = 194, .length = 3},
  [110] = {.index = 194, .length = 3},
  [111] = {.index = 197, .length = 3},
  [112] = {.index = 200, .length = 3},
  [113] = {.index = 203, .length = 3},
  [114] = {.index = 206, .length = 3},
  [115] = {.index = 209, .length = 3},
  [116] = {.index = 212, .length = 3},
  [117] = {.index = 215, .length = 2},
  [118] = {.index = 217, .length = 2},
  [119] = {.index = 217, .length = 2},
  [120] = {.index = 219, .length = 4},
  [121] = {.index = 223, .length = 5},
  [122] = {.index = 228, .length = 6},
  [123] = {.index = 234, .length = 3},
  [124] = {.index = 237, .length = 5},
  [125] = {.index = 242, .length = 4},
  [126] = {.index = 120, .length = 2},
  [127] = {.index = 246, .length = 5},
  [128] = {.index = 251, .length = 5},
  [129] = {.index = 256, .length = 5},
  [130] = {.index = 261, .length = 5},
  [131] = {.index = 266, .length = 4},
  [132] = {.index = 270, .length = 2},
  [133] = {.index = 272, .length = 1},
  [134] = {.index = 273, .length = 2},
  [135] = {.index = 275, .length = 2},
  [136] = {.index = 277, .length = 1},
  [137] = {.index = 277, .length = 1},
  [138] = {.index = 278, .length = 2},
  [139] = {.index = 280, .length = 1},
  [140] = {.index = 280, .length = 1},
  [141] = {.index = 54, .length = 1},
  [142] = {.index = 281, .length = 3},
  [143] = {.index = 284, .length = 5},
  [144] = {.index = 289, .length = 4},
  [145] = {.index = 293, .length = 3},
  [146] = {.index = 293, .length = 3},
  [147] = {.index = 296, .length = 4},
  [148] = {.index = 300, .length = 4},
  [149] = {.index = 304, .length = 4},
  [150] = {.index = 308, .length = 4},
  [151] = {.index = 312, .length = 4},
  [152] = {.index = 316, .length = 4},
  [153] = {.index = 320, .length = 4},
  [154] = {.index = 324, .length = 4},
  [155] = {.index = 328, .length = 3},
  [156] = {.index = 331, .length = 3},
  [157] = {.index = 334, .length = 4},
  [158] = {.index = 338, .length = 5},
  [159] = {.index = 343, .length = 3},
  [160] = {.index = 343, .length = 3},
  [161] = {.index = 346, .length = 6},
  [162] = {.index = 352, .length = 4},
  [163] = {.index = 356, .length = 1},
  [164] = {.index = 357, .length = 2},
  [165] = {.index = 359, .length = 2},
  [166] = {.index = 361, .length = 1},
  [167] = {.index = 362, .length = 2},
  [168] = {.index = 364, .length = 2},
  [169] = {.index = 366, .length = 2},
  [170] = {.index = 368, .length = 3},
  [171] = {.index = 371, .length = 3},
  [172] = {.index = 374, .length = 2},
  [173] = {.index = 374, .length = 2},
  [174] = {.index = 376, .length = 3},
  [175] = {.index = 379, .length = 4},
  [176] = {.index = 379, .length = 4},
  [177] = {.index = 383, .length = 5},
  [178] = {.index = 388, .length = 5},
  [179] = {.index = 393, .length = 5},
  [180] = {.index = 398, .length = 5},
  [181] = {.index = 403, .length = 5},
  [182] = {.index = 408, .length = 4},
  [183] = {.index = 412, .length = 2},
  [184] = {.index = 414, .length = 3},
  [185] = {.index = 417, .length = 3},
  [186] = {.index = 420, .length = 3},
  [187] = {.index = 423, .length = 3},
  [188] = {.index = 426, .length = 3},
  [189] = {.index = 429, .length = 5},
  [190] = {.index = 434, .length = 4},
  [191] = {.index = 438, .length = 4},
  [192] = {.index = 442, .length = 2},
  [193] = {.index = 442, .length = 2},
  [194] = {.index = 442, .length = 2},
  [195] = {.index = 442, .length = 2},
  [196] = {.index = 444, .length = 1},
  [197] = {.index = 444, .length = 1},
  [198] = {.index = 444, .length = 1},
  [199] = {.index = 444, .length = 1},
  [200] = {.index = 445, .length = 2},
  [201] = {.index = 447, .length = 6},
  [202] = {.index = 453, .length = 3},
  [203] = {.index = 456, .length = 4},
  [204] = {.index = 460, .length = 4},
  [205] = {.index = 464, .length = 4},
  [206] = {.index = 468, .length = 4},
  [207] = {.index = 472, .length = 4},
  [208] = {.index = 476, .length = 5},
  [209] = {.index = 481, .length = 5},
  [210] = {.index = 486, .length = 1},
  [211] = {.index = 486, .length = 1},
  [212] = {.index = 487, .length = 3},
  [213] = {.index = 490, .length = 2},
  [214] = {.index = 487, .length = 3},
  [215] = {.index = 487, .length = 3},
  [216] = {.index = 487, .length = 3},
  [217] = {.index = 492, .length = 1},
  [218] = {.index = 492, .length = 1},
  [219] = {.index = 493, .length = 2},
  [220] = {.index = 495, .length = 2},
  [221] = {.index = 493, .length = 2},
  [222] = {.index = 493, .length = 2},
  [223] = {.index = 493, .length = 2},
  [224] = {.index = 497, .length = 2},
  [225] = {.index = 499, .length = 1},
  [226] = {.index = 500, .length = 3},
  [227] = {.index = 503, .length = 3},
  [228] = {.index = 506, .length = 3},
  [229] = {.index = 509, .length = 5},
  [230] = {.index = 514, .length = 5},
  [231] = {.index = 519, .length = 5},
  [232] = {.index = 524, .length = 3},
  [233] = {.index = 527, .length = 3},
  [234] = {.index = 530, .length = 4},
  [235] = {.index = 534, .length = 4},
  [236] = {.index = 538, .length = 6},
  [237] = {.index = 544, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_arguments, 0, .inherited = true},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_name, 1},
  [6] =
    {field_arguments, 1},
    {field_name, 0},
  [8] =
    {field_name, 0},
  [9] =
    {field_dimensions, 1},
    {field_element, 0},
  [11] =
    {field_declarator, 0},
  [12] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [14] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
  [17] =
    {field_arguments, 2},
    {field_type, 1},
  [19] =
    {field_dimensions, 2},
    {field_type, 1},
  [21] =
    {field_body, 2},
    {field_name, 1},
  [23] =
    {field_body, 2},
    {field_condition, 1},
  [25] =
    {field_body, 2},
  [26] =
    {field_body, 1},
  [27] =
    {field_body, 2},
    {field_resources, 1},
  [29] =
    {field_condition, 1},
    {field_consequence, 2},
  [31] =
    {field_arguments, 2},
    {field_name, 1},
  [33] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [36] =
    {field_body, 2},
    {field_parameters, 0},
  [38] =
    {field_field, 2},
    {field_object, 0},
  [40] =
    {field_left, 0},
    {field_right, 2},
  [42] =
    {field_arguments, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
  [45] =
    {field_dimensions, 1},
    {field_name, 0},
  [47] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0},
  [49] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [51] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
  [54] =
    {field_type, 1},
  [55] =
    {field_type, 1},
    {field_value, 3},
  [57] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [59] =
    {field_dimensions, 2},
    {field_type, 1},
    {field_value, 3},
  [62] =
    {field_dimensions, 2},
    {field_dimensions, 3},
    {field_type, 1},
  [65] =
    {field_arguments, 3},
    {field_type, 2},
    {field_type_arguments, 1},
  [68] =
    {field_dimensions, 3},
    {field_type, 2},
  [70] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [73] =
    {field_body, 3},
    {field_name, 1},
    {field_superclass, 2},
  [76] =
    {field_body, 3},
    {field_interfaces, 2},
    {field_name, 1},
  [79] =
    {field_body, 3},
    {field_name, 1},
    {field_permits, 2},
  [82] =
    {field_name, 2},
    {field_scope, 0},
  [84] =
    {field_body, 3},
    {field_name, 2},
  [86] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [89] =
    {field_body, 3},
    {field_name, 1},
  [91] =
    {field_arguments, 3},
    {field_name, 2},
    {field_object, 0},
  [94] =
    {field_left, 0},
    {field_right, 3},
  [96] =
    {field_left, 0},
    {field_name, 3},
    {field_right, 2},
  [99] =
    {field_array, 0},
    {field_index, 2},
  [101] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1},
  [103] =
    {field_declarator, 1},
  [104] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [106] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 2},
  [109] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [112] =
    {field_dimensions, 3},
    {field_type, 2},
    {field_value, 4},
  [115] =
    {field_dimensions, 3},
    {field_dimensions, 4},
    {field_type, 2},
  [118] =
    {field_body, 1},
    {field_name, 0},
  [120] =
    {field_name, 0},
    {field_parameters, 1},
  [122] =
    {field_body, 1},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [126] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0},
  [130] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [135] =
    {field_body, 1},
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [141] =
    {field_body, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [145] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [149] =
    {field_body, 4},
    {field_name, 1},
    {field_permits, 3},
    {field_type_parameters, 2},
  [153] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_superclass, 2},
  [157] =
    {field_body, 4},
    {field_name, 1},
    {field_permits, 3},
    {field_superclass, 2},
  [161] =
    {field_body, 4},
    {field_interfaces, 2},
    {field_name, 1},
    {field_permits, 3},
  [165] =
    {field_body, 1},
    {field_condition, 3},
  [167] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [170] =
    {field_init, 1},
  [171] =
    {field_init, 0, .inherited = true},
    {field_init, 1, .inherited = true},
  [173] =
    {field_modifiers, 0},
  [174] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [178] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_parameters, 2},
  [182] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [185] =
    {field_body, 4},
    {field_name, 1},
    {field_permits, 3},
  [188] =
    {field_field, 4},
    {field_object, 0},
  [190] =
    {field_arguments, 4},
    {field_name, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [194] =
    {field_left, 0},
    {field_name, 4},
    {field_right, 3},
  [197] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [200] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [203] =
    {field_body, 4},
    {field_name, 2},
    {field_superclass, 3},
  [206] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 2},
  [209] =
    {field_body, 4},
    {field_name, 2},
    {field_permits, 3},
  [212] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [215] =
    {field_body, 4},
    {field_name, 2},
  [217] =
    {field_body, 4},
    {field_name, 3},
  [219] =
    {field_body, 2},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [223] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [228] =
    {field_body, 2},
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [234] =
    {field_name, 1},
    {field_parameters, 2},
    {field_type_parameters, 0},
  [237] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1},
    {field_type_parameters, 0},
  [242] =
    {field_body, 2},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [246] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [251] =
    {field_body, 5},
    {field_name, 1},
    {field_permits, 4},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [256] =
    {field_body, 5},
    {field_interfaces, 3},
    {field_name, 1},
    {field_permits, 4},
    {field_type_parameters, 2},
  [261] =
    {field_body, 5},
    {field_interfaces, 3},
    {field_name, 1},
    {field_permits, 4},
    {field_superclass, 2},
  [266] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
    {field_value, 3},
  [270] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [272] =
    {field_body, 5},
  [273] =
    {field_body, 5},
    {field_init, 2},
  [275] =
    {field_key, 0},
    {field_value, 2},
  [277] =
    {field_module, 1},
  [278] =
    {field_modifiers, 0, .inherited = true},
    {field_modifiers, 1, .inherited = true},
  [280] =
    {field_package, 1},
  [281] =
    {field_arguments, 1},
    {field_body, 2},
    {field_name, 0},
  [284] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [289] =
    {field_body, 5},
    {field_name, 1},
    {field_permits, 4},
    {field_type_parameters, 2},
  [293] =
    {field_arguments, 5},
    {field_name, 4},
    {field_object, 0},
  [296] =
    {field_body, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [300] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [304] =
    {field_body, 5},
    {field_name, 2},
    {field_permits, 4},
    {field_type_parameters, 3},
  [308] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_superclass, 3},
  [312] =
    {field_body, 5},
    {field_name, 2},
    {field_permits, 4},
    {field_superclass, 3},
  [316] =
    {field_body, 5},
    {field_interfaces, 3},
    {field_name, 2},
    {field_permits, 4},
  [320] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [324] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_parameters, 3},
  [328] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [331] =
    {field_body, 5},
    {field_name, 2},
    {field_permits, 4},
  [334] =
    {field_body, 3},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [338] =
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_parameters, 3, .inherited = true},
    {field_type, 2},
    {field_type_parameters, 0},
  [343] =
    {field_dimensions, 2},
    {field_name, 0},
    {field_parameters, 1},
  [346] =
    {field_body, 6},
    {field_interfaces, 4},
    {field_name, 1},
    {field_permits, 5},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [352] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
    {field_value, 4},
  [356] =
    {field_body, 4},
  [357] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [359] =
    {field_body, 6},
    {field_update, 4},
  [361] =
    {field_update, 1},
  [362] =
    {field_update, 0, .inherited = true},
    {field_update, 1, .inherited = true},
  [364] =
    {field_body, 6},
    {field_condition, 3},
  [366] =
    {field_body, 6},
    {field_init, 2},
  [368] =
    {field_body, 6},
    {field_init, 2},
    {field_update, 4},
  [371] =
    {field_body, 6},
    {field_condition, 3},
    {field_init, 2},
  [374] =
    {field_modifiers, 1, .inherited = true},
    {field_module, 2},
  [376] =
    {field_arguments, 2},
    {field_body, 3},
    {field_name, 1},
  [379] =
    {field_arguments, 6},
    {field_name, 5},
    {field_object, 0},
    {field_type_arguments, 4},
  [383] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [388] =
    {field_body, 6},
    {field_name, 2},
    {field_permits, 5},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [393] =
    {field_body, 6},
    {field_interfaces, 4},
    {field_name, 2},
    {field_permits, 5},
    {field_type_parameters, 3},
  [398] =
    {field_body, 6},
    {field_interfaces, 4},
    {field_name, 2},
    {field_permits, 5},
    {field_superclass, 3},
  [403] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [408] =
    {field_body, 6},
    {field_name, 2},
    {field_permits, 5},
    {field_type_parameters, 3},
  [412] =
    {field_arguments, 1},
    {field_constructor, 0},
  [414] =
    {field_body, 7},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [417] =
    {field_body, 7},
    {field_condition, 3},
    {field_update, 5},
  [420] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 5},
  [423] =
    {field_body, 7},
    {field_condition, 4},
    {field_init, 2},
  [426] =
    {field_body, 7},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [429] =
    {field_body, 7},
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_type, 2},
    {field_value, 5},
  [434] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [438] =
    {field_body, 7},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
  [442] =
    {field_modules, 3},
    {field_package, 1},
  [444] =
    {field_provided, 1},
  [445] =
    {field_name, 1},
    {field_type, 0},
  [447] =
    {field_body, 7},
    {field_interfaces, 5},
    {field_name, 2},
    {field_permits, 6},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [453] =
    {field_arguments, 2},
    {field_constructor, 1},
    {field_type_arguments, 0},
  [456] =
    {field_body, 8},
    {field_condition, 3},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [460] =
    {field_body, 8},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [464] =
    {field_body, 8},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
  [468] =
    {field_body, 8},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
  [472] =
    {field_body, 8},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [476] =
    {field_body, 8},
    {field_dimensions, 4, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_type, 3},
    {field_value, 6},
  [481] =
    {field_body, 8},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [486] =
    {field_modules, 1},
  [487] =
    {field_modules, 3},
    {field_modules, 4, .inherited = true},
    {field_package, 1},
  [490] =
    {field_modules, 0, .inherited = true},
    {field_modules, 1, .inherited = true},
  [492] =
    {field_provider, 1},
  [493] =
    {field_provided, 1},
    {field_provider, 4, .inherited = true},
  [495] =
    {field_provider, 0, .inherited = true},
    {field_provider, 1, .inherited = true},
  [497] =
    {field_name, 2},
    {field_type, 1},
  [499] =
    {field_value, 1},
  [500] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
  [503] =
    {field_name, 1},
    {field_type, 0},
    {field_value, 4, .inherited = true},
  [506] =
    {field_arguments, 3},
    {field_constructor, 2},
    {field_object, 0},
  [509] =
    {field_body, 9},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [514] =
    {field_body, 9},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [519] =
    {field_body, 9},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
  [524] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
  [527] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 5, .inherited = true},
  [530] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
    {field_value, 5, .inherited = true},
  [534] =
    {field_arguments, 4},
    {field_constructor, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [538] =
    {field_body, 10},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
    {field_update, 8, .inherited = true},
  [544] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
    {field_value, 6, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = alias_sym_type_identifier,
  },
  [5] = {
    [1] = sym_identifier,
  },
  [7] = {
    [0] = sym_identifier,
  },
  [9] = {
    [0] = sym_identifier,
  },
  [14] = {
    [1] = sym_identifier,
  },
  [18] = {
    [1] = alias_sym_type_identifier,
  },
  [19] = {
    [1] = alias_sym_type_identifier,
  },
  [26] = {
    [1] = sym_identifier,
  },
  [28] = {
    [0] = sym_identifier,
  },
  [29] = {
    [0] = sym_identifier,
  },
  [30] = {
    [1] = sym_identifier,
  },
  [31] = {
    [2] = sym_identifier,
  },
  [35] = {
    [0] = alias_sym_type_identifier,
    [2] = alias_sym_type_identifier,
  },
  [38] = {
    [0] = sym_identifier,
  },
  [42] = {
    [2] = alias_sym_type_identifier,
  },
  [49] = {
    [1] = alias_sym_type_identifier,
  },
  [50] = {
    [1] = alias_sym_type_identifier,
  },
  [52] = {
    [2] = alias_sym_type_identifier,
  },
  [54] = {
    [2] = alias_sym_type_identifier,
  },
  [59] = {
    [0] = sym_identifier,
  },
  [61] = {
    [2] = sym_identifier,
  },
  [63] = {
    [2] = sym_identifier,
  },
  [66] = {
    [2] = sym_identifier,
  },
  [68] = {
    [0] = alias_sym_type_identifier,
    [3] = alias_sym_type_identifier,
  },
  [70] = {
    [3] = sym_identifier,
  },
  [77] = {
    [3] = alias_sym_type_identifier,
  },
  [81] = {
    [2] = alias_sym_type_identifier,
  },
  [82] = {
    [2] = alias_sym_type_identifier,
  },
  [83] = {
    [1] = alias_sym_type_identifier,
  },
  [105] = {
    [4] = sym_identifier,
  },
  [107] = {
    [3] = sym_identifier,
  },
  [109] = {
    [4] = sym_identifier,
  },
  [118] = {
    [3] = sym_identifier,
  },
  [126] = {
    [0] = sym_identifier,
  },
  [136] = {
    [1] = sym_identifier,
  },
  [139] = {
    [1] = sym_identifier,
  },
  [141] = {
    [1] = sym_identifier,
  },
  [145] = {
    [4] = sym_identifier,
  },
  [159] = {
    [0] = sym_identifier,
  },
  [172] = {
    [2] = sym_identifier,
  },
  [175] = {
    [5] = sym_identifier,
  },
  [192] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [193] = {
    [1] = sym_identifier,
  },
  [194] = {
    [3] = sym_identifier,
  },
  [196] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [197] = {
    [1] = sym_identifier,
  },
  [198] = {
    [3] = sym_identifier,
  },
  [210] = {
    [1] = sym_identifier,
  },
  [212] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [214] = {
    [1] = sym_identifier,
  },
  [215] = {
    [3] = sym_identifier,
  },
  [217] = {
    [1] = sym_identifier,
  },
  [219] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [221] = {
    [1] = sym_identifier,
  },
  [222] = {
    [3] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < '_'
                  ? (c >= '$' && c <= 'Z')
                  : (c <= '_' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1162
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < 'a'
                ? (c < 'A'
                  ? c == '$'
                  : (c <= 'Z' || c == '_'))
                : (c <= 'z' || (c < 181
                  ? c == 170
                  : c <= 181)))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 6400
    ? (c < 2979
      ? (c < 2365
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < '_'
                ? (c < '0'
                  ? c == '$'
                  : (c <= '9' || (c >= 'A' && c <= 'Z')))
                : (c <= '_' || (c < 170
                  ? (c >= 'a' && c <= 'z')
                  : (c <= 170 || c == 181))))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1749
              ? (c < 1632
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1641 || (c < 1649
                  ? (c >= 1646 && c <= 1647)
                  : c <= 1747)))
              : (c <= 1749 || (c < 1808
                ? (c < 1774
                  ? (c >= 1765 && c <= 1766)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1984 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2185
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : (c <= 2154 || (c >= 2160 && c <= 2183)))
                : (c <= 2190 || (c < 2308
                  ? (c >= 2208 && c <= 2249)
                  : c <= 2361)))))))))
        : (c <= 2365 || (c < 2703
          ? (c < 2534
            ? (c < 2474
              ? (c < 2417
                ? (c < 2392
                  ? c == 2384
                  : (c <= 2401 || (c >= 2406 && c <= 2415)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : (c <= 2448 || (c >= 2451 && c <= 2472)))))
              : (c <= 2480 || (c < 2510
                ? (c < 2486
                  ? c == 2482
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2527
                  ? (c >= 2524 && c <= 2525)
                  : c <= 2529)))))
            : (c <= 2545 || (c < 2613
              ? (c < 2579
                ? (c < 2565
                  ? c == 2556
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2610
                  ? (c >= 2602 && c <= 2608)
                  : c <= 2611)))
              : (c <= 2614 || (c < 2662
                ? (c < 2649
                  ? (c >= 2616 && c <= 2617)
                  : (c <= 2652 || c == 2654))
                : (c <= 2671 || (c < 2693
                  ? (c >= 2674 && c <= 2676)
                  : c <= 2701)))))))
          : (c <= 2705 || (c < 2866
            ? (c < 2784
              ? (c < 2741
                ? (c < 2730
                  ? (c >= 2707 && c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2768
                  ? c == 2749
                  : c <= 2768)))
              : (c <= 2785 || (c < 2831
                ? (c < 2809
                  ? (c >= 2790 && c <= 2799)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2947
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2929
                  ? (c >= 2918 && c <= 2927)
                  : c <= 2929)))
              : (c <= 2947 || (c < 2969
                ? (c < 2958
                  ? (c >= 2949 && c <= 2954)
                  : (c <= 2960 || (c >= 2962 && c <= 2965)))
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 3872
        ? (c < 3406
          ? (c < 3205
            ? (c < 3114
              ? (c < 3046
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3055 || (c < 3086
                  ? (c >= 3077 && c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3200
                  ? (c >= 3174 && c <= 3183)
                  : c <= 3200)))))
            : (c <= 3212 || (c < 3296
              ? (c < 3253
                ? (c < 3218
                  ? (c >= 3214 && c <= 3216)
                  : (c <= 3240 || (c >= 3242 && c <= 3251)))
                : (c <= 3257 || (c < 3293
                  ? c == 3261
                  : c <= 3294)))
              : (c <= 3297 || (c < 3342
                ? (c < 3313
                  ? (c >= 3302 && c <= 3311)
                  : (c <= 3314 || (c >= 3332 && c <= 3340)))
                : (c <= 3344 || (c < 3389
                  ? (c >= 3346 && c <= 3386)
                  : c <= 3389)))))))
          : (c <= 3406 || (c < 3664
            ? (c < 3507
              ? (c < 3450
                ? (c < 3423
                  ? (c >= 3412 && c <= 3414)
                  : (c <= 3425 || (c >= 3430 && c <= 3439)))
                : (c <= 3455 || (c < 3482
                  ? (c >= 3461 && c <= 3478)
                  : c <= 3505)))
              : (c <= 3515 || (c < 3585
                ? (c < 3520
                  ? c == 3517
                  : (c <= 3526 || (c >= 3558 && c <= 3567)))
                : (c <= 3632 || (c < 3648
                  ? (c >= 3634 && c <= 3635)
                  : c <= 3654)))))
            : (c <= 3673 || (c < 3762
              ? (c < 3724
                ? (c < 3716
                  ? (c >= 3713 && c <= 3714)
                  : (c <= 3716 || (c >= 3718 && c <= 3722)))
                : (c <= 3747 || (c < 3751
                  ? c == 3749
                  : c <= 3760)))
              : (c <= 3763 || (c < 3792
                ? (c < 3776
                  ? c == 3773
                  : (c <= 3780 || c == 3782))
                : (c <= 3801 || (c < 3840
                  ? (c >= 3804 && c <= 3807)
                  : c <= 3840)))))))))
        : (c <= 3881 || (c < 4802
          ? (c < 4295
            ? (c < 4193
              ? (c < 4096
                ? (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : (c <= 3948 || (c >= 3976 && c <= 3980)))
                : (c <= 4138 || (c < 4176
                  ? (c >= 4159 && c <= 4169)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))
              : (c <= 4193 || (c < 4238
                ? (c < 4206
                  ? (c >= 4197 && c <= 4198)
                  : (c <= 4208 || (c >= 4213 && c <= 4225)))
                : (c <= 4238 || (c < 4256
                  ? (c >= 4240 && c <= 4249)
                  : c <= 4293)))))
            : (c <= 4295 || (c < 4698
              ? (c < 4682
                ? (c < 4304
                  ? c == 4301
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))
                : (c <= 4685 || (c < 4696
                  ? (c >= 4688 && c <= 4694)
                  : c <= 4696)))
              : (c <= 4701 || (c < 4786
                ? (c < 4746
                  ? (c >= 4704 && c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))
                : (c <= 4789 || (c < 4800
                  ? (c >= 4792 && c <= 4798)
                  : c <= 4800)))))))
          : (c <= 4805 || (c < 5919
            ? (c < 5112
              ? (c < 4888
                ? (c < 4824
                  ? (c >= 4808 && c <= 4822)
                  : (c <= 4880 || (c >= 4882 && c <= 4885)))
                : (c <= 4954 || (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : c <= 5109)))
              : (c <= 5117 || (c < 5792
                ? (c < 5743
                  ? (c >= 5121 && c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))
                : (c <= 5866 || (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : c <= 5905)))))
            : (c <= 5937 || (c < 6112
              ? (c < 6016
                ? (c < 5984
                  ? (c >= 5952 && c <= 5969)
                  : (c <= 5996 || (c >= 5998 && c <= 6000)))
                : (c <= 6067 || (c < 6108
                  ? c == 6103
                  : c <= 6108)))
              : (c <= 6121 || (c < 6279
                ? (c < 6176
                  ? (c >= 6160 && c <= 6169)
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))))))))))))
    : (c <= 6430 || (c < 43216
      ? (c < 8490
        ? (c < 7968
          ? (c < 7086
            ? (c < 6784
              ? (c < 6576
                ? (c < 6512
                  ? (c >= 6470 && c <= 6509)
                  : (c <= 6516 || (c >= 6528 && c <= 6571)))
                : (c <= 6601 || (c < 6656
                  ? (c >= 6608 && c <= 6617)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6793 || (c < 6981
                ? (c < 6823
                  ? (c >= 6800 && c <= 6809)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7043
                  ? (c >= 6992 && c <= 7001)
                  : c <= 7072)))))
            : (c <= 7141 || (c < 7401
              ? (c < 7296
                ? (c < 7232
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7241 || (c >= 7245 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))
              : (c <= 7404 || (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))))))
          : (c <= 8005 || (c < 8160
            ? (c < 8064
              ? (c < 8027
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : (c <= 8023 || c == 8025))
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))
              : (c <= 8116 || (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))))
            : (c <= 8172 || (c < 8455
              ? (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))
              : (c <= 8455 || (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))))))))
        : (c <= 8493 || (c < 12449
          ? (c < 11680
            ? (c < 11506
              ? (c < 8526
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : (c <= 8511 || (c >= 8517 && c <= 8521)))
                : (c <= 8526 || (c < 11264
                  ? (c >= 8579 && c <= 8580)
                  : (c <= 11492 || (c >= 11499 && c <= 11502)))))
              : (c <= 11507 || (c < 11568
                ? (c < 11559
                  ? (c >= 11520 && c <= 11557)
                  : (c <= 11559 || c == 11565))
                : (c <= 11623 || (c < 11648
                  ? c == 11631
                  : c <= 11670)))))
            : (c <= 11686 || (c < 11736
              ? (c < 11712
                ? (c < 11696
                  ? (c >= 11688 && c <= 11694)
                  : (c <= 11702 || (c >= 11704 && c <= 11710)))
                : (c <= 11718 || (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : c <= 11734)))
              : (c <= 11742 || (c < 12347
                ? (c < 12293
                  ? c == 11823
                  : (c <= 12294 || (c >= 12337 && c <= 12341)))
                : (c <= 12348 || (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)))))))
          : (c <= 12538 || (c < 42623
            ? (c < 19903
              ? (c < 12704
                ? (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : (c <= 12591 || (c >= 12593 && c <= 12686)))
                : (c <= 12735 || (c < 13312
                  ? (c >= 12784 && c <= 12799)
                  : c <= 13312)))
              : (c <= 19903 || (c < 42240
                ? (c < 40959
                  ? c == 19968
                  : (c <= 42124 || (c >= 42192 && c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c >= 42512 && c <= 42539)
                  : c <= 42606)))))
            : (c <= 42653 || (c < 42965
              ? (c < 42891
                ? (c < 42775
                  ? (c >= 42656 && c <= 42725)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))
                : (c <= 42954 || (c < 42963
                  ? (c >= 42960 && c <= 42961)
                  : c <= 42963)))
              : (c <= 42969 || (c < 43020
                ? (c < 43011
                  ? (c >= 42994 && c <= 43009)
                  : (c <= 43013 || (c >= 43015 && c <= 43018)))
                : (c <= 43042 || (c < 43138
                  ? (c >= 43072 && c <= 43123)
                  : c <= 43187)))))))))))
      : (c <= 43225 || (c < 65296
        ? (c < 43808
          ? (c < 43616
            ? (c < 43471
              ? (c < 43264
                ? (c < 43259
                  ? (c >= 43250 && c <= 43255)
                  : (c <= 43259 || (c >= 43261 && c <= 43262)))
                : (c <= 43301 || (c < 43360
                  ? (c >= 43312 && c <= 43334)
                  : (c <= 43388 || (c >= 43396 && c <= 43442)))))
              : (c <= 43481 || (c < 43584
                ? (c < 43494
                  ? (c >= 43488 && c <= 43492)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43600
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43609)))))
            : (c <= 43638 || (c < 43714
              ? (c < 43701
                ? (c < 43646
                  ? c == 43642
                  : (c <= 43695 || c == 43697))
                : (c <= 43702 || (c < 43712
                  ? (c >= 43705 && c <= 43709)
                  : c <= 43712)))
              : (c <= 43714 || (c < 43777
                ? (c < 43744
                  ? (c >= 43739 && c <= 43741)
                  : (c <= 43754 || (c >= 43762 && c <= 43764)))
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64285
            ? (c < 55203
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 44032
                  ? (c >= 44016 && c <= 44025)
                  : c <= 44032)))
              : (c <= 55203 || (c < 64112
                ? (c < 55243
                  ? (c >= 55216 && c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))
                : (c <= 64217 || (c < 64275
                  ? (c >= 64256 && c <= 64262)
                  : c <= 64279)))))
            : (c <= 64285 || (c < 64326
              ? (c < 64318
                ? (c < 64298
                  ? (c >= 64287 && c <= 64296)
                  : (c <= 64310 || (c >= 64312 && c <= 64316)))
                : (c <= 64318 || (c < 64323
                  ? (c >= 64320 && c <= 64321)
                  : c <= 64324)))
              : (c <= 64433 || (c < 65008
                ? (c < 64848
                  ? (c >= 64467 && c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65305 || (c < 66816
          ? (c < 65664
            ? (c < 65498
              ? (c < 65474
                ? (c < 65345
                  ? (c >= 65313 && c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65470)))
                : (c <= 65479 || (c < 65490
                  ? (c >= 65482 && c <= 65487)
                  : c <= 65495)))
              : (c <= 65500 || (c < 65596
                ? (c < 65549
                  ? (c >= 65536 && c <= 65547)
                  : (c <= 65574 || (c >= 65576 && c <= 65594)))
                : (c <= 65597 || (c < 65616
                  ? (c >= 65599 && c <= 65613)
                  : c <= 65629)))))
            : (c <= 65786 || (c < 66432
              ? (c < 66349
                ? (c < 66208
                  ? (c >= 66176 && c <= 66204)
                  : (c <= 66256 || (c >= 66304 && c <= 66335)))
                : (c <= 66368 || (c < 66384
                  ? (c >= 66370 && c <= 66377)
                  : c <= 66421)))
              : (c <= 66461 || (c < 66720
                ? (c < 66504
                  ? (c >= 66464 && c <= 66499)
                  : (c <= 66511 || (c >= 66560 && c <= 66717)))
                : (c <= 66729 || (c < 66776
                  ? (c >= 66736 && c <= 66771)
                  : c <= 66811)))))))
          : (c <= 66855 || (c < 67463
            ? (c < 66979
              ? (c < 66956
                ? (c < 66928
                  ? (c >= 66864 && c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))
                : (c <= 66962 || (c < 66967
                  ? (c >= 66964 && c <= 66965)
                  : c <= 66977)))
              : (c <= 66993 || (c < 67392
                ? (c < 67003
                  ? (c >= 66995 && c <= 67001)
                  : (c <= 67004 || (c >= 67072 && c <= 67382)))
                : (c <= 67413 || (c < 67456
                  ? (c >= 67424 && c <= 67431)
                  : c <= 67461)))))
            : (c <= 67504 || (c < 67647
              ? (c < 67594
                ? (c < 67584
                  ? (c >= 67506 && c <= 67514)
                  : (c <= 67589 || c == 67592))
                : (c <= 67637 || (c < 67644
                  ? (c >= 67639 && c <= 67640)
                  : c <= 67644)))
              : (c <= 67669 || (c < 67828
                ? (c < 67712
                  ? (c >= 67680 && c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(61);
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '%') ADVANCE(132);
      if (lookahead == '&') ADVANCE(90);
      if (lookahead == '\'') ADVANCE(25);
      if (lookahead == '(') ADVANCE(87);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(118);
      if (lookahead == ',') ADVANCE(140);
      if (lookahead == '-') ADVANCE(120);
      if (lookahead == '.') ADVANCE(153);
      if (lookahead == '/') ADVANCE(125);
      if (lookahead == '0') ADVANCE(63);
      if (lookahead == ':') ADVANCE(143);
      if (lookahead == ';') ADVANCE(158);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(93);
      if (lookahead == '>') ADVANCE(106);
      if (lookahead == '?') ADVANCE(141);
      if (lookahead == '@') ADVANCE(160);
      if (lookahead == '[') ADVANCE(149);
      if (lookahead == ']') ADVANCE(150);
      if (lookahead == '^') ADVANCE(130);
      if (lookahead == 'n') ADVANCE(166);
      if (lookahead == '{') ADVANCE(156);
      if (lookahead == '|') ADVANCE(127);
      if (lookahead == '}') ADVANCE(157);
      if (lookahead == '~') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(167);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(1);
      if (lookahead == '"') ADVANCE(11);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(2);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '%') ADVANCE(131);
      if (lookahead == '&') ADVANCE(89);
      if (lookahead == '\'') ADVANCE(25);
      if (lookahead == '(') ADVANCE(87);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(140);
      if (lookahead == '-') ADVANCE(121);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == '0') ADVANCE(63);
      if (lookahead == ':') ADVANCE(143);
      if (lookahead == ';') ADVANCE(158);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '>') ADVANCE(107);
      if (lookahead == '?') ADVANCE(141);
      if (lookahead == '@') ADVANCE(159);
      if (lookahead == '[') ADVANCE(149);
      if (lookahead == ']') ADVANCE(150);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '{') ADVANCE(156);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(157);
      if (lookahead == '~') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(167);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(144);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '&') ADVANCE(88);
      if (lookahead == '\'') ADVANCE(25);
      if (lookahead == '(') ADVANCE(87);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(140);
      if (lookahead == '-') ADVANCE(119);
      if (lookahead == '.') ADVANCE(51);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '0') ADVANCE(63);
      if (lookahead == ':') ADVANCE(142);
      if (lookahead == ';') ADVANCE(158);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '>') ADVANCE(105);
      if (lookahead == '@') ADVANCE(159);
      if (lookahead == '[') ADVANCE(149);
      if (lookahead == 'n') ADVANCE(166);
      if (lookahead == '}') ADVANCE(157);
      if (lookahead == '~') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(167);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '%') ADVANCE(132);
      if (lookahead == '&') ADVANCE(90);
      if (lookahead == '(') ADVANCE(87);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(118);
      if (lookahead == ',') ADVANCE(140);
      if (lookahead == '-') ADVANCE(120);
      if (lookahead == '.') ADVANCE(152);
      if (lookahead == '/') ADVANCE(125);
      if (lookahead == ':') ADVANCE(143);
      if (lookahead == ';') ADVANCE(158);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(93);
      if (lookahead == '>') ADVANCE(106);
      if (lookahead == '?') ADVANCE(141);
      if (lookahead == '@') ADVANCE(159);
      if (lookahead == '[') ADVANCE(149);
      if (lookahead == ']') ADVANCE(150);
      if (lookahead == '^') ADVANCE(130);
      if (lookahead == '{') ADVANCE(156);
      if (lookahead == '|') ADVANCE(127);
      if (lookahead == '}') ADVANCE(157);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(167);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '%') ADVANCE(131);
      if (lookahead == '&') ADVANCE(89);
      if (lookahead == '(') ADVANCE(87);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(140);
      if (lookahead == '-') ADVANCE(121);
      if (lookahead == '.') ADVANCE(151);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == ':') ADVANCE(143);
      if (lookahead == ';') ADVANCE(158);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '>') ADVANCE(107);
      if (lookahead == '?') ADVANCE(141);
      if (lookahead == '@') ADVANCE(159);
      if (lookahead == '[') ADVANCE(149);
      if (lookahead == ']') ADVANCE(150);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == '{') ADVANCE(156);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(157);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(167);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(85);
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(8);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(8);
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(11);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(86);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(10);
      END_STATE();
    case 12:
      if (lookahead == '&') ADVANCE(88);
      if (lookahead == '(') ADVANCE(87);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == ',') ADVANCE(140);
      if (lookahead == '.') ADVANCE(152);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == ':') ADVANCE(143);
      if (lookahead == ';') ADVANCE(158);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '>') ADVANCE(105);
      if (lookahead == '?') ADVANCE(141);
      if (lookahead == '@') ADVANCE(159);
      if (lookahead == '[') ADVANCE(149);
      if (lookahead == '{') ADVANCE(156);
      if (lookahead == '|') ADVANCE(126);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(167);
      END_STATE();
    case 13:
      if (lookahead == '\'') ADVANCE(83);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(13);
      END_STATE();
    case 14:
      if (lookahead == '(') ADVANCE(87);
      if (lookahead == ',') ADVANCE(140);
      if (lookahead == '.') ADVANCE(151);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == ';') ADVANCE(158);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '@') ADVANCE(160);
      if (lookahead == 'n') ADVANCE(166);
      if (lookahead == '{') ADVANCE(156);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(167);
      END_STATE();
    case 15:
      if (lookahead == '(') ADVANCE(87);
      if (lookahead == '.') ADVANCE(151);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '@') ADVANCE(159);
      if (lookahead == '[') ADVANCE(149);
      if (lookahead == 'n') ADVANCE(166);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(167);
      END_STATE();
    case 16:
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(168);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(17);
      if (lookahead == '/') ADVANCE(169);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(17);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 19:
      if (lookahead == '.') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(163);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 22:
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '@') ADVANCE(41);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(167);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 25:
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(13);
      END_STATE();
    case 26:
      if (lookahead == '_') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 27:
      if (lookahead == '_') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 28:
      if (lookahead == '_') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(75);
      END_STATE();
    case 29:
      if (lookahead == '_') ADVANCE(30);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 30:
      if (lookahead == '_') ADVANCE(30);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 31:
      if (lookahead == '_') ADVANCE(30);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(79);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(78);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(42);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(34);
      END_STATE();
    case 34:
      if (lookahead == 'c') ADVANCE(39);
      END_STATE();
    case 35:
      if (lookahead == 'd') ADVANCE(161);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(35);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 40:
      if (lookahead == 'f') ADVANCE(33);
      END_STATE();
    case 41:
      if (lookahead == 'i') ADVANCE(43);
      END_STATE();
    case 42:
      if (lookahead == 'l') ADVANCE(38);
      END_STATE();
    case 43:
      if (lookahead == 'n') ADVANCE(46);
      END_STATE();
    case 44:
      if (lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(37);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(36);
      END_STATE();
    case 47:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(75);
      END_STATE();
    case 48:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 49:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(72);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(70);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(75);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(78);
      END_STATE();
    case 56:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(9);
      END_STATE();
    case 57:
      if (lookahead != 0) ADVANCE(13);
      END_STATE();
    case 58:
      if (lookahead != 0) ADVANCE(8);
      END_STATE();
    case 59:
      if (eof) ADVANCE(61);
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '%') ADVANCE(131);
      if (lookahead == '&') ADVANCE(89);
      if (lookahead == '\'') ADVANCE(25);
      if (lookahead == '(') ADVANCE(87);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(140);
      if (lookahead == '-') ADVANCE(121);
      if (lookahead == '.') ADVANCE(154);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == '0') ADVANCE(63);
      if (lookahead == ':') ADVANCE(143);
      if (lookahead == ';') ADVANCE(158);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '>') ADVANCE(107);
      if (lookahead == '?') ADVANCE(141);
      if (lookahead == '@') ADVANCE(160);
      if (lookahead == '[') ADVANCE(149);
      if (lookahead == ']') ADVANCE(150);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == 'n') ADVANCE(166);
      if (lookahead == '{') ADVANCE(156);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(157);
      if (lookahead == '~') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(59)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(167);
      END_STATE();
    case 60:
      if (eof) ADVANCE(61);
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '%') ADVANCE(131);
      if (lookahead == '&') ADVANCE(89);
      if (lookahead == '\'') ADVANCE(25);
      if (lookahead == '(') ADVANCE(87);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(122);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == ',') ADVANCE(140);
      if (lookahead == '-') ADVANCE(121);
      if (lookahead == '.') ADVANCE(51);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == '0') ADVANCE(63);
      if (lookahead == ':') ADVANCE(142);
      if (lookahead == ';') ADVANCE(158);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '>') ADVANCE(107);
      if (lookahead == '?') ADVANCE(141);
      if (lookahead == '@') ADVANCE(160);
      if (lookahead == ']') ADVANCE(150);
      if (lookahead == '^') ADVANCE(129);
      if (lookahead == 'n') ADVANCE(166);
      if (lookahead == '{') ADVANCE(156);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(157);
      if (lookahead == '~') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(60)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(64);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(167);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(76);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(49);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(62);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(50);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(21);
      if (lookahead == '_') ADVANCE(26);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(47);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(47);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(76);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(62);
      if (lookahead == '_') ADVANCE(26);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(47);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(47);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(82);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(65);
      if (lookahead == '_') ADVANCE(29);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(68);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(82);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(65);
      if (lookahead == '_') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(68);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(53);
      if (lookahead == '.') ADVANCE(82);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(65);
      if (lookahead == '_') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(68);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(69);
      if (lookahead == '_') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(71);
      if (lookahead == '_') ADVANCE(49);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(72);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(27);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(47);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(28);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(75);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(47);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(81);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(78);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(81);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(78);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(79);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(30);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(53);
      if (lookahead == '_') ADVANCE(55);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(81);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(79);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(81);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(78);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_character_literal);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_string_literal);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_string_literal);
      if (lookahead == '"') ADVANCE(2);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_text_block);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(115);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(135);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(136);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(147);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(147);
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(148);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(148);
      if (lookahead == '=') ADVANCE(95);
      if (lookahead == '>') ADVANCE(139);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(148);
      if (lookahead == '>') ADVANCE(139);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(168);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(168);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '|') ADVANCE(116);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(116);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(100);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(101);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(102);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(103);
      if (lookahead == '>') ADVANCE(138);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(137);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(104);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(155);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(20);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(74);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'i') ADVANCE(43);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_non_DASHsealed);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_ATinterface);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(45);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(167);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(164);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(167);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(165);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(167);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(167);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(168);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_block_comment);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'p') ADVANCE(12);
      if (lookahead == 'r') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      if (lookahead == 't') ADVANCE(15);
      if (lookahead == 'u') ADVANCE(16);
      if (lookahead == 'v') ADVANCE(17);
      if (lookahead == 'w') ADVANCE(18);
      if (lookahead == 'y') ADVANCE(19);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(20);
      if (lookahead == 's') ADVANCE(21);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(22);
      if (lookahead == 'r') ADVANCE(23);
      if (lookahead == 'y') ADVANCE(24);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(25);
      if (lookahead == 'h') ADVANCE(26);
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(32);
      if (lookahead == 'x') ADVANCE(33);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'i') ADVANCE(35);
      if (lookahead == 'l') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(38);
      if (lookahead == 'm') ADVANCE(39);
      if (lookahead == 'n') ADVANCE(40);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(43);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 11:
      if (lookahead == 'p') ADVANCE(46);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      if (lookahead == 'u') ADVANCE(50);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(52);
      if (lookahead == 'h') ADVANCE(53);
      if (lookahead == 't') ADVANCE(54);
      if (lookahead == 'u') ADVANCE(55);
      if (lookahead == 'w') ADVANCE(56);
      if (lookahead == 'y') ADVANCE(57);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(58);
      if (lookahead == 'o') ADVANCE(59);
      if (lookahead == 'r') ADVANCE(60);
      END_STATE();
    case 16:
      if (lookahead == 's') ADVANCE(61);
      END_STATE();
    case 17:
      if (lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(63);
      if (lookahead == 'i') ADVANCE(64);
      END_STATE();
    case 19:
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(66);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 22:
      if (lookahead == 'o') ADVANCE(68);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(69);
      END_STATE();
    case 24:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(71);
      if (lookahead == 't') ADVANCE(72);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(73);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(74);
      END_STATE();
    case 28:
      if (lookahead == 'n') ADVANCE(75);
      END_STATE();
    case 29:
      if (lookahead == 'f') ADVANCE(76);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(77);
      END_STATE();
    case 31:
      if (lookahead == 's') ADVANCE(78);
      END_STATE();
    case 32:
      if (lookahead == 'u') ADVANCE(79);
      END_STATE();
    case 33:
      if (lookahead == 'p') ADVANCE(80);
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 34:
      if (lookahead == 'l') ADVANCE(82);
      END_STATE();
    case 35:
      if (lookahead == 'n') ADVANCE(83);
      END_STATE();
    case 36:
      if (lookahead == 'o') ADVANCE(84);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(85);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 39:
      if (lookahead == 'p') ADVANCE(86);
      END_STATE();
    case 40:
      if (lookahead == 's') ADVANCE(87);
      if (lookahead == 't') ADVANCE(88);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(89);
      END_STATE();
    case 42:
      if (lookahead == 'd') ADVANCE(90);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(91);
      END_STATE();
    case 44:
      if (lookahead == 'w') ADVANCE(92);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 47:
      if (lookahead == 'c') ADVANCE(95);
      END_STATE();
    case 48:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(97);
      if (lookahead == 'o') ADVANCE(98);
      END_STATE();
    case 50:
      if (lookahead == 'b') ADVANCE(99);
      END_STATE();
    case 51:
      if (lookahead == 'c') ADVANCE(100);
      if (lookahead == 'q') ADVANCE(101);
      if (lookahead == 't') ADVANCE(102);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(103);
      END_STATE();
    case 53:
      if (lookahead == 'o') ADVANCE(104);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'r') ADVANCE(106);
      END_STATE();
    case 55:
      if (lookahead == 'p') ADVANCE(107);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(108);
      END_STATE();
    case 57:
      if (lookahead == 'n') ADVANCE(109);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(110);
      if (lookahead == 'r') ADVANCE(111);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_to);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(112);
      if (lookahead == 'u') ADVANCE(113);
      if (lookahead == 'y') ADVANCE(114);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(116);
      if (lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(118);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 66:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(123);
      END_STATE();
    case 69:
      if (lookahead == 'a') ADVANCE(124);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 72:
      if (lookahead == 'c') ADVANCE(127);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 74:
      if (lookahead == 's') ADVANCE(129);
      END_STATE();
    case 75:
      if (lookahead == 't') ADVANCE(130);
      END_STATE();
    case 76:
      if (lookahead == 'a') ADVANCE(131);
      END_STATE();
    case 77:
      if (lookahead == 'b') ADVANCE(132);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(133);
      END_STATE();
    case 79:
      if (lookahead == 'm') ADVANCE(134);
      END_STATE();
    case 80:
      if (lookahead == 'o') ADVANCE(135);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(136);
      END_STATE();
    case 82:
      if (lookahead == 's') ADVANCE(137);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(138);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(139);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 86:
      if (lookahead == 'l') ADVANCE(140);
      if (lookahead == 'o') ADVANCE(141);
      END_STATE();
    case 87:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == 'e') ADVANCE(143);
      END_STATE();
    case 89:
      if (lookahead == 'g') ADVANCE(144);
      END_STATE();
    case 90:
      if (lookahead == 'u') ADVANCE(145);
      END_STATE();
    case 91:
      if (lookahead == 'i') ADVANCE(146);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 93:
      if (lookahead == 'l') ADVANCE(147);
      END_STATE();
    case 94:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 95:
      if (lookahead == 'k') ADVANCE(149);
      END_STATE();
    case 96:
      if (lookahead == 'm') ADVANCE(150);
      END_STATE();
    case 97:
      if (lookahead == 'v') ADVANCE(151);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(152);
      if (lookahead == 'v') ADVANCE(153);
      END_STATE();
    case 99:
      if (lookahead == 'l') ADVANCE(154);
      END_STATE();
    case 100:
      if (lookahead == 'o') ADVANCE(155);
      END_STATE();
    case 101:
      if (lookahead == 'u') ADVANCE(156);
      END_STATE();
    case 102:
      if (lookahead == 'u') ADVANCE(157);
      END_STATE();
    case 103:
      if (lookahead == 'l') ADVANCE(158);
      END_STATE();
    case 104:
      if (lookahead == 'r') ADVANCE(159);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 106:
      if (lookahead == 'i') ADVANCE(161);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(163);
      END_STATE();
    case 109:
      if (lookahead == 'c') ADVANCE(164);
      END_STATE();
    case 110:
      if (lookahead == 's') ADVANCE(165);
      END_STATE();
    case 111:
      if (lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 112:
      if (lookahead == 'n') ADVANCE(167);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(168);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 115:
      if (lookahead == 's') ADVANCE(169);
      END_STATE();
    case 116:
      if (lookahead == 'd') ADVANCE(170);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(171);
      END_STATE();
    case 118:
      if (lookahead == 'l') ADVANCE(172);
      END_STATE();
    case 119:
      if (lookahead == 'h') ADVANCE(173);
      END_STATE();
    case 120:
      if (lookahead == 'l') ADVANCE(174);
      END_STATE();
    case 121:
      if (lookahead == 'r') ADVANCE(175);
      END_STATE();
    case 122:
      if (lookahead == 'r') ADVANCE(176);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 124:
      if (lookahead == 'k') ADVANCE(178);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 127:
      if (lookahead == 'h') ADVANCE(179);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_char);
      END_STATE();
    case 129:
      if (lookahead == 's') ADVANCE(180);
      END_STATE();
    case 130:
      if (lookahead == 'i') ADVANCE(181);
      END_STATE();
    case 131:
      if (lookahead == 'u') ADVANCE(182);
      END_STATE();
    case 132:
      if (lookahead == 'l') ADVANCE(183);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 135:
      if (lookahead == 'r') ADVANCE(184);
      END_STATE();
    case 136:
      if (lookahead == 'n') ADVANCE(185);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 138:
      if (lookahead == 'l') ADVANCE(187);
      END_STATE();
    case 139:
      if (lookahead == 't') ADVANCE(188);
      END_STATE();
    case 140:
      if (lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 141:
      if (lookahead == 'r') ADVANCE(190);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(191);
      END_STATE();
    case 143:
      if (lookahead == 'r') ADVANCE(192);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 145:
      if (lookahead == 'l') ADVANCE(193);
      END_STATE();
    case 146:
      if (lookahead == 'v') ADVANCE(194);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_null_literal);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == 's') ADVANCE(195);
      END_STATE();
    case 149:
      if (lookahead == 'a') ADVANCE(196);
      END_STATE();
    case 150:
      if (lookahead == 'i') ADVANCE(197);
      END_STATE();
    case 151:
      if (lookahead == 'a') ADVANCE(198);
      END_STATE();
    case 152:
      if (lookahead == 'e') ADVANCE(199);
      END_STATE();
    case 153:
      if (lookahead == 'i') ADVANCE(200);
      END_STATE();
    case 154:
      if (lookahead == 'i') ADVANCE(201);
      END_STATE();
    case 155:
      if (lookahead == 'r') ADVANCE(202);
      END_STATE();
    case 156:
      if (lookahead == 'i') ADVANCE(203);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(204);
      END_STATE();
    case 158:
      if (lookahead == 'e') ADVANCE(205);
      END_STATE();
    case 159:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 160:
      if (lookahead == 'i') ADVANCE(207);
      END_STATE();
    case 161:
      if (lookahead == 'c') ADVANCE(208);
      END_STATE();
    case 162:
      if (lookahead == 'r') ADVANCE(209);
      END_STATE();
    case 163:
      if (lookahead == 'c') ADVANCE(210);
      END_STATE();
    case 164:
      if (lookahead == 'h') ADVANCE(211);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 166:
      if (lookahead == 'w') ADVANCE(212);
      END_STATE();
    case 167:
      if (lookahead == 's') ADVANCE(213);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_uses);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_void_type);
      END_STATE();
    case 171:
      if (lookahead == 't') ADVANCE(214);
      END_STATE();
    case 172:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 174:
      if (lookahead == 'd') ADVANCE(216);
      END_STATE();
    case 175:
      if (lookahead == 'a') ADVANCE(217);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(218);
      END_STATE();
    case 177:
      if (lookahead == 'a') ADVANCE(219);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 181:
      if (lookahead == 'n') ADVANCE(220);
      END_STATE();
    case 182:
      if (lookahead == 'l') ADVANCE(221);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(222);
      END_STATE();
    case 184:
      if (lookahead == 't') ADVANCE(223);
      END_STATE();
    case 185:
      if (lookahead == 'd') ADVANCE(224);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == 'l') ADVANCE(225);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 189:
      if (lookahead == 'm') ADVANCE(226);
      END_STATE();
    case 190:
      if (lookahead == 't') ADVANCE(227);
      END_STATE();
    case 191:
      if (lookahead == 'n') ADVANCE(228);
      END_STATE();
    case 192:
      if (lookahead == 'f') ADVANCE(229);
      END_STATE();
    case 193:
      if (lookahead == 'e') ADVANCE(230);
      END_STATE();
    case 194:
      if (lookahead == 'e') ADVANCE(231);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_opens);
      END_STATE();
    case 196:
      if (lookahead == 'g') ADVANCE(232);
      END_STATE();
    case 197:
      if (lookahead == 't') ADVANCE(233);
      END_STATE();
    case 198:
      if (lookahead == 't') ADVANCE(234);
      END_STATE();
    case 199:
      if (lookahead == 'c') ADVANCE(235);
      END_STATE();
    case 200:
      if (lookahead == 'd') ADVANCE(236);
      END_STATE();
    case 201:
      if (lookahead == 'c') ADVANCE(237);
      END_STATE();
    case 202:
      if (lookahead == 'd') ADVANCE(238);
      END_STATE();
    case 203:
      if (lookahead == 'r') ADVANCE(239);
      END_STATE();
    case 204:
      if (lookahead == 'n') ADVANCE(240);
      END_STATE();
    case 205:
      if (lookahead == 'd') ADVANCE(241);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 207:
      if (lookahead == 'c') ADVANCE(242);
      END_STATE();
    case 208:
      if (lookahead == 't') ADVANCE(243);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 210:
      if (lookahead == 'h') ADVANCE(244);
      END_STATE();
    case 211:
      if (lookahead == 'r') ADVANCE(245);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_throw);
      if (lookahead == 's') ADVANCE(246);
      END_STATE();
    case 213:
      if (lookahead == 'i') ADVANCE(247);
      END_STATE();
    case 214:
      if (lookahead == 'i') ADVANCE(248);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 217:
      if (lookahead == 'c') ADVANCE(249);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 219:
      if (lookahead == 'n') ADVANCE(250);
      END_STATE();
    case 220:
      if (lookahead == 'u') ADVANCE(251);
      END_STATE();
    case 221:
      if (lookahead == 't') ADVANCE(252);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 223:
      if (lookahead == 's') ADVANCE(253);
      END_STATE();
    case 224:
      if (lookahead == 's') ADVANCE(254);
      END_STATE();
    case 225:
      if (lookahead == 'y') ADVANCE(255);
      END_STATE();
    case 226:
      if (lookahead == 'e') ADVANCE(256);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 228:
      if (lookahead == 'c') ADVANCE(257);
      END_STATE();
    case 229:
      if (lookahead == 'a') ADVANCE(258);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 232:
      if (lookahead == 'e') ADVANCE(259);
      END_STATE();
    case 233:
      if (lookahead == 's') ADVANCE(260);
      END_STATE();
    case 234:
      if (lookahead == 'e') ADVANCE(261);
      END_STATE();
    case 235:
      if (lookahead == 't') ADVANCE(262);
      END_STATE();
    case 236:
      if (lookahead == 'e') ADVANCE(263);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_record);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(264);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_sealed);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 243:
      if (lookahead == 'f') ADVANCE(265);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 245:
      if (lookahead == 'o') ADVANCE(266);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_throws);
      END_STATE();
    case 247:
      if (lookahead == 'e') ADVANCE(267);
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 248:
      if (lookahead == 'l') ADVANCE(269);
      END_STATE();
    case 249:
      if (lookahead == 't') ADVANCE(270);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_boolean_type);
      END_STATE();
    case 251:
      if (lookahead == 'e') ADVANCE(271);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_exports);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 256:
      if (lookahead == 'n') ADVANCE(272);
      END_STATE();
    case 257:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 258:
      if (lookahead == 'c') ADVANCE(274);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_permits);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 262:
      if (lookahead == 'e') ADVANCE(275);
      END_STATE();
    case 263:
      if (lookahead == 's') ADVANCE(276);
      END_STATE();
    case 264:
      if (lookahead == 's') ADVANCE(277);
      END_STATE();
    case 265:
      if (lookahead == 'p') ADVANCE(278);
      END_STATE();
    case 266:
      if (lookahead == 'n') ADVANCE(279);
      END_STATE();
    case 267:
      if (lookahead == 'n') ADVANCE(280);
      END_STATE();
    case 268:
      if (lookahead == 'i') ADVANCE(281);
      END_STATE();
    case 269:
      if (lookahead == 'e') ADVANCE(282);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 272:
      if (lookahead == 't') ADVANCE(283);
      END_STATE();
    case 273:
      if (lookahead == 'o') ADVANCE(284);
      END_STATE();
    case 274:
      if (lookahead == 'e') ADVANCE(285);
      END_STATE();
    case 275:
      if (lookahead == 'd') ADVANCE(286);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_provides);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_requires);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_strictfp);
      END_STATE();
    case 279:
      if (lookahead == 'i') ADVANCE(287);
      END_STATE();
    case 280:
      if (lookahead == 't') ADVANCE(288);
      END_STATE();
    case 281:
      if (lookahead == 'v') ADVANCE(289);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 283:
      if (lookahead == 's') ADVANCE(290);
      END_STATE();
    case 284:
      if (lookahead == 'f') ADVANCE(291);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 287:
      if (lookahead == 'z') ADVANCE(292);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_transient);
      END_STATE();
    case 289:
      if (lookahead == 'e') ADVANCE(293);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    case 292:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_transitive);
      END_STATE();
    case 294:
      if (lookahead == 'd') ADVANCE(295);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_synchronized);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 60},
  [2] = {.lex_state = 60},
  [3] = {.lex_state = 60},
  [4] = {.lex_state = 60},
  [5] = {.lex_state = 60},
  [6] = {.lex_state = 60},
  [7] = {.lex_state = 60},
  [8] = {.lex_state = 60},
  [9] = {.lex_state = 60},
  [10] = {.lex_state = 60},
  [11] = {.lex_state = 60},
  [12] = {.lex_state = 60},
  [13] = {.lex_state = 60},
  [14] = {.lex_state = 60},
  [15] = {.lex_state = 60},
  [16] = {.lex_state = 60},
  [17] = {.lex_state = 60},
  [18] = {.lex_state = 60},
  [19] = {.lex_state = 60},
  [20] = {.lex_state = 60},
  [21] = {.lex_state = 60},
  [22] = {.lex_state = 60},
  [23] = {.lex_state = 60},
  [24] = {.lex_state = 60},
  [25] = {.lex_state = 60},
  [26] = {.lex_state = 60},
  [27] = {.lex_state = 60},
  [28] = {.lex_state = 60},
  [29] = {.lex_state = 60},
  [30] = {.lex_state = 60},
  [31] = {.lex_state = 60},
  [32] = {.lex_state = 60},
  [33] = {.lex_state = 60},
  [34] = {.lex_state = 60},
  [35] = {.lex_state = 60},
  [36] = {.lex_state = 60},
  [37] = {.lex_state = 60},
  [38] = {.lex_state = 60},
  [39] = {.lex_state = 60},
  [40] = {.lex_state = 60},
  [41] = {.lex_state = 60},
  [42] = {.lex_state = 60},
  [43] = {.lex_state = 60},
  [44] = {.lex_state = 60},
  [45] = {.lex_state = 60},
  [46] = {.lex_state = 60},
  [47] = {.lex_state = 60},
  [48] = {.lex_state = 60},
  [49] = {.lex_state = 60},
  [50] = {.lex_state = 60},
  [51] = {.lex_state = 60},
  [52] = {.lex_state = 60},
  [53] = {.lex_state = 60},
  [54] = {.lex_state = 60},
  [55] = {.lex_state = 60},
  [56] = {.lex_state = 60},
  [57] = {.lex_state = 60},
  [58] = {.lex_state = 60},
  [59] = {.lex_state = 60},
  [60] = {.lex_state = 60},
  [61] = {.lex_state = 60},
  [62] = {.lex_state = 60},
  [63] = {.lex_state = 60},
  [64] = {.lex_state = 60},
  [65] = {.lex_state = 60},
  [66] = {.lex_state = 60},
  [67] = {.lex_state = 60},
  [68] = {.lex_state = 60},
  [69] = {.lex_state = 60},
  [70] = {.lex_state = 60},
  [71] = {.lex_state = 60},
  [72] = {.lex_state = 60},
  [73] = {.lex_state = 60},
  [74] = {.lex_state = 60},
  [75] = {.lex_state = 59},
  [76] = {.lex_state = 59},
  [77] = {.lex_state = 59},
  [78] = {.lex_state = 60},
  [79] = {.lex_state = 60},
  [80] = {.lex_state = 60},
  [81] = {.lex_state = 60},
  [82] = {.lex_state = 60},
  [83] = {.lex_state = 60},
  [84] = {.lex_state = 4},
  [85] = {.lex_state = 4},
  [86] = {.lex_state = 4},
  [87] = {.lex_state = 4},
  [88] = {.lex_state = 60},
  [89] = {.lex_state = 60},
  [90] = {.lex_state = 60},
  [91] = {.lex_state = 60},
  [92] = {.lex_state = 3},
  [93] = {.lex_state = 3},
  [94] = {.lex_state = 3},
  [95] = {.lex_state = 3},
  [96] = {.lex_state = 3},
  [97] = {.lex_state = 3},
  [98] = {.lex_state = 60},
  [99] = {.lex_state = 60},
  [100] = {.lex_state = 60},
  [101] = {.lex_state = 3},
  [102] = {.lex_state = 3},
  [103] = {.lex_state = 60},
  [104] = {.lex_state = 60},
  [105] = {.lex_state = 60},
  [106] = {.lex_state = 60},
  [107] = {.lex_state = 60},
  [108] = {.lex_state = 60},
  [109] = {.lex_state = 60},
  [110] = {.lex_state = 60},
  [111] = {.lex_state = 60},
  [112] = {.lex_state = 60},
  [113] = {.lex_state = 60},
  [114] = {.lex_state = 60},
  [115] = {.lex_state = 60},
  [116] = {.lex_state = 60},
  [117] = {.lex_state = 60},
  [118] = {.lex_state = 60},
  [119] = {.lex_state = 60},
  [120] = {.lex_state = 60},
  [121] = {.lex_state = 60},
  [122] = {.lex_state = 60},
  [123] = {.lex_state = 60},
  [124] = {.lex_state = 60},
  [125] = {.lex_state = 60},
  [126] = {.lex_state = 60},
  [127] = {.lex_state = 3},
  [128] = {.lex_state = 60},
  [129] = {.lex_state = 60},
  [130] = {.lex_state = 60},
  [131] = {.lex_state = 60},
  [132] = {.lex_state = 60},
  [133] = {.lex_state = 60},
  [134] = {.lex_state = 60},
  [135] = {.lex_state = 60},
  [136] = {.lex_state = 60},
  [137] = {.lex_state = 60},
  [138] = {.lex_state = 60},
  [139] = {.lex_state = 60},
  [140] = {.lex_state = 60},
  [141] = {.lex_state = 60},
  [142] = {.lex_state = 60},
  [143] = {.lex_state = 60},
  [144] = {.lex_state = 3},
  [145] = {.lex_state = 60},
  [146] = {.lex_state = 60},
  [147] = {.lex_state = 60},
  [148] = {.lex_state = 60},
  [149] = {.lex_state = 60},
  [150] = {.lex_state = 60},
  [151] = {.lex_state = 60},
  [152] = {.lex_state = 60},
  [153] = {.lex_state = 60},
  [154] = {.lex_state = 60},
  [155] = {.lex_state = 60},
  [156] = {.lex_state = 60},
  [157] = {.lex_state = 60},
  [158] = {.lex_state = 60},
  [159] = {.lex_state = 60},
  [160] = {.lex_state = 60},
  [161] = {.lex_state = 60},
  [162] = {.lex_state = 60},
  [163] = {.lex_state = 60},
  [164] = {.lex_state = 60},
  [165] = {.lex_state = 60},
  [166] = {.lex_state = 3},
  [167] = {.lex_state = 60},
  [168] = {.lex_state = 60},
  [169] = {.lex_state = 60},
  [170] = {.lex_state = 60},
  [171] = {.lex_state = 60},
  [172] = {.lex_state = 3},
  [173] = {.lex_state = 60},
  [174] = {.lex_state = 3},
  [175] = {.lex_state = 60},
  [176] = {.lex_state = 60},
  [177] = {.lex_state = 60},
  [178] = {.lex_state = 3},
  [179] = {.lex_state = 60},
  [180] = {.lex_state = 60},
  [181] = {.lex_state = 60},
  [182] = {.lex_state = 60},
  [183] = {.lex_state = 60},
  [184] = {.lex_state = 60},
  [185] = {.lex_state = 60},
  [186] = {.lex_state = 60},
  [187] = {.lex_state = 60},
  [188] = {.lex_state = 60},
  [189] = {.lex_state = 60},
  [190] = {.lex_state = 60},
  [191] = {.lex_state = 60},
  [192] = {.lex_state = 60},
  [193] = {.lex_state = 60},
  [194] = {.lex_state = 60},
  [195] = {.lex_state = 60},
  [196] = {.lex_state = 60},
  [197] = {.lex_state = 60},
  [198] = {.lex_state = 60},
  [199] = {.lex_state = 60},
  [200] = {.lex_state = 60},
  [201] = {.lex_state = 60},
  [202] = {.lex_state = 3},
  [203] = {.lex_state = 3},
  [204] = {.lex_state = 60},
  [205] = {.lex_state = 60},
  [206] = {.lex_state = 60},
  [207] = {.lex_state = 60},
  [208] = {.lex_state = 60},
  [209] = {.lex_state = 60},
  [210] = {.lex_state = 60},
  [211] = {.lex_state = 60},
  [212] = {.lex_state = 60},
  [213] = {.lex_state = 60},
  [214] = {.lex_state = 60},
  [215] = {.lex_state = 60},
  [216] = {.lex_state = 60},
  [217] = {.lex_state = 60},
  [218] = {.lex_state = 3},
  [219] = {.lex_state = 60},
  [220] = {.lex_state = 60},
  [221] = {.lex_state = 3},
  [222] = {.lex_state = 60},
  [223] = {.lex_state = 60},
  [224] = {.lex_state = 60},
  [225] = {.lex_state = 3},
  [226] = {.lex_state = 60},
  [227] = {.lex_state = 60},
  [228] = {.lex_state = 60},
  [229] = {.lex_state = 60},
  [230] = {.lex_state = 60},
  [231] = {.lex_state = 60},
  [232] = {.lex_state = 60},
  [233] = {.lex_state = 60},
  [234] = {.lex_state = 60},
  [235] = {.lex_state = 60},
  [236] = {.lex_state = 60},
  [237] = {.lex_state = 60},
  [238] = {.lex_state = 60},
  [239] = {.lex_state = 60},
  [240] = {.lex_state = 60},
  [241] = {.lex_state = 60},
  [242] = {.lex_state = 60},
  [243] = {.lex_state = 60},
  [244] = {.lex_state = 60},
  [245] = {.lex_state = 60},
  [246] = {.lex_state = 60},
  [247] = {.lex_state = 60},
  [248] = {.lex_state = 60},
  [249] = {.lex_state = 60},
  [250] = {.lex_state = 60},
  [251] = {.lex_state = 60},
  [252] = {.lex_state = 60},
  [253] = {.lex_state = 60},
  [254] = {.lex_state = 60},
  [255] = {.lex_state = 60},
  [256] = {.lex_state = 60},
  [257] = {.lex_state = 3},
  [258] = {.lex_state = 60},
  [259] = {.lex_state = 3},
  [260] = {.lex_state = 3},
  [261] = {.lex_state = 3},
  [262] = {.lex_state = 3},
  [263] = {.lex_state = 3},
  [264] = {.lex_state = 3},
  [265] = {.lex_state = 3},
  [266] = {.lex_state = 3},
  [267] = {.lex_state = 3},
  [268] = {.lex_state = 3},
  [269] = {.lex_state = 3},
  [270] = {.lex_state = 3},
  [271] = {.lex_state = 3},
  [272] = {.lex_state = 3},
  [273] = {.lex_state = 3},
  [274] = {.lex_state = 3},
  [275] = {.lex_state = 3},
  [276] = {.lex_state = 3},
  [277] = {.lex_state = 3},
  [278] = {.lex_state = 3},
  [279] = {.lex_state = 3},
  [280] = {.lex_state = 3},
  [281] = {.lex_state = 3},
  [282] = {.lex_state = 3},
  [283] = {.lex_state = 3},
  [284] = {.lex_state = 3},
  [285] = {.lex_state = 3},
  [286] = {.lex_state = 3},
  [287] = {.lex_state = 3},
  [288] = {.lex_state = 3},
  [289] = {.lex_state = 3},
  [290] = {.lex_state = 3},
  [291] = {.lex_state = 3},
  [292] = {.lex_state = 3},
  [293] = {.lex_state = 3},
  [294] = {.lex_state = 3},
  [295] = {.lex_state = 3},
  [296] = {.lex_state = 3},
  [297] = {.lex_state = 3},
  [298] = {.lex_state = 3},
  [299] = {.lex_state = 3},
  [300] = {.lex_state = 3},
  [301] = {.lex_state = 3},
  [302] = {.lex_state = 3},
  [303] = {.lex_state = 3},
  [304] = {.lex_state = 3},
  [305] = {.lex_state = 3},
  [306] = {.lex_state = 3},
  [307] = {.lex_state = 3},
  [308] = {.lex_state = 3},
  [309] = {.lex_state = 3},
  [310] = {.lex_state = 3},
  [311] = {.lex_state = 3},
  [312] = {.lex_state = 3},
  [313] = {.lex_state = 3},
  [314] = {.lex_state = 3},
  [315] = {.lex_state = 3},
  [316] = {.lex_state = 3},
  [317] = {.lex_state = 3},
  [318] = {.lex_state = 3},
  [319] = {.lex_state = 3},
  [320] = {.lex_state = 3},
  [321] = {.lex_state = 3},
  [322] = {.lex_state = 60},
  [323] = {.lex_state = 3},
  [324] = {.lex_state = 3},
  [325] = {.lex_state = 3},
  [326] = {.lex_state = 3},
  [327] = {.lex_state = 3},
  [328] = {.lex_state = 3},
  [329] = {.lex_state = 3},
  [330] = {.lex_state = 3},
  [331] = {.lex_state = 3},
  [332] = {.lex_state = 3},
  [333] = {.lex_state = 3},
  [334] = {.lex_state = 3},
  [335] = {.lex_state = 3},
  [336] = {.lex_state = 3},
  [337] = {.lex_state = 3},
  [338] = {.lex_state = 3},
  [339] = {.lex_state = 3},
  [340] = {.lex_state = 3},
  [341] = {.lex_state = 3},
  [342] = {.lex_state = 3},
  [343] = {.lex_state = 3},
  [344] = {.lex_state = 3},
  [345] = {.lex_state = 3},
  [346] = {.lex_state = 4},
  [347] = {.lex_state = 60},
  [348] = {.lex_state = 4},
  [349] = {.lex_state = 60},
  [350] = {.lex_state = 60},
  [351] = {.lex_state = 60},
  [352] = {.lex_state = 4},
  [353] = {.lex_state = 4},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 5},
  [363] = {.lex_state = 5},
  [364] = {.lex_state = 5},
  [365] = {.lex_state = 5},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 5},
  [370] = {.lex_state = 5},
  [371] = {.lex_state = 5},
  [372] = {.lex_state = 5},
  [373] = {.lex_state = 5},
  [374] = {.lex_state = 5},
  [375] = {.lex_state = 5},
  [376] = {.lex_state = 5},
  [377] = {.lex_state = 5},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 5},
  [380] = {.lex_state = 5},
  [381] = {.lex_state = 5},
  [382] = {.lex_state = 6},
  [383] = {.lex_state = 5},
  [384] = {.lex_state = 5},
  [385] = {.lex_state = 5},
  [386] = {.lex_state = 6},
  [387] = {.lex_state = 3},
  [388] = {.lex_state = 3},
  [389] = {.lex_state = 6},
  [390] = {.lex_state = 6},
  [391] = {.lex_state = 6},
  [392] = {.lex_state = 6},
  [393] = {.lex_state = 5},
  [394] = {.lex_state = 4},
  [395] = {.lex_state = 14},
  [396] = {.lex_state = 14},
  [397] = {.lex_state = 6},
  [398] = {.lex_state = 4},
  [399] = {.lex_state = 3},
  [400] = {.lex_state = 6},
  [401] = {.lex_state = 3},
  [402] = {.lex_state = 6},
  [403] = {.lex_state = 6},
  [404] = {.lex_state = 4},
  [405] = {.lex_state = 4},
  [406] = {.lex_state = 6},
  [407] = {.lex_state = 6},
  [408] = {.lex_state = 6},
  [409] = {.lex_state = 6},
  [410] = {.lex_state = 14},
  [411] = {.lex_state = 6},
  [412] = {.lex_state = 6},
  [413] = {.lex_state = 6},
  [414] = {.lex_state = 6},
  [415] = {.lex_state = 6},
  [416] = {.lex_state = 6},
  [417] = {.lex_state = 6},
  [418] = {.lex_state = 14},
  [419] = {.lex_state = 3},
  [420] = {.lex_state = 3},
  [421] = {.lex_state = 3},
  [422] = {.lex_state = 3},
  [423] = {.lex_state = 0},
  [424] = {.lex_state = 6},
  [425] = {.lex_state = 6},
  [426] = {.lex_state = 6},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 6},
  [429] = {.lex_state = 0},
  [430] = {.lex_state = 6},
  [431] = {.lex_state = 0},
  [432] = {.lex_state = 0},
  [433] = {.lex_state = 3},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 0},
  [437] = {.lex_state = 6},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 6},
  [440] = {.lex_state = 3},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 6},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 3},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 0},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 6},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 6},
  [459] = {.lex_state = 6},
  [460] = {.lex_state = 6},
  [461] = {.lex_state = 6},
  [462] = {.lex_state = 6},
  [463] = {.lex_state = 6},
  [464] = {.lex_state = 6},
  [465] = {.lex_state = 6},
  [466] = {.lex_state = 6},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 6},
  [470] = {.lex_state = 6},
  [471] = {.lex_state = 6},
  [472] = {.lex_state = 6},
  [473] = {.lex_state = 6},
  [474] = {.lex_state = 6},
  [475] = {.lex_state = 6},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 6},
  [478] = {.lex_state = 6},
  [479] = {.lex_state = 6},
  [480] = {.lex_state = 6},
  [481] = {.lex_state = 6},
  [482] = {.lex_state = 6},
  [483] = {.lex_state = 6},
  [484] = {.lex_state = 6},
  [485] = {.lex_state = 6},
  [486] = {.lex_state = 6},
  [487] = {.lex_state = 6},
  [488] = {.lex_state = 6},
  [489] = {.lex_state = 6},
  [490] = {.lex_state = 6},
  [491] = {.lex_state = 0},
  [492] = {.lex_state = 6},
  [493] = {.lex_state = 6},
  [494] = {.lex_state = 6},
  [495] = {.lex_state = 6},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 12},
  [498] = {.lex_state = 12},
  [499] = {.lex_state = 12},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 3},
  [502] = {.lex_state = 3},
  [503] = {.lex_state = 3},
  [504] = {.lex_state = 3},
  [505] = {.lex_state = 3},
  [506] = {.lex_state = 3},
  [507] = {.lex_state = 3},
  [508] = {.lex_state = 3},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 3},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 3},
  [516] = {.lex_state = 3},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 3},
  [520] = {.lex_state = 3},
  [521] = {.lex_state = 3},
  [522] = {.lex_state = 15},
  [523] = {.lex_state = 3},
  [524] = {.lex_state = 3},
  [525] = {.lex_state = 3},
  [526] = {.lex_state = 6},
  [527] = {.lex_state = 3},
  [528] = {.lex_state = 4},
  [529] = {.lex_state = 3},
  [530] = {.lex_state = 3},
  [531] = {.lex_state = 3},
  [532] = {.lex_state = 3},
  [533] = {.lex_state = 3},
  [534] = {.lex_state = 3},
  [535] = {.lex_state = 3},
  [536] = {.lex_state = 3},
  [537] = {.lex_state = 3},
  [538] = {.lex_state = 4},
  [539] = {.lex_state = 15},
  [540] = {.lex_state = 12},
  [541] = {.lex_state = 12},
  [542] = {.lex_state = 15},
  [543] = {.lex_state = 15},
  [544] = {.lex_state = 3},
  [545] = {.lex_state = 3},
  [546] = {.lex_state = 6},
  [547] = {.lex_state = 3},
  [548] = {.lex_state = 3},
  [549] = {.lex_state = 4},
  [550] = {.lex_state = 3},
  [551] = {.lex_state = 3},
  [552] = {.lex_state = 3},
  [553] = {.lex_state = 3},
  [554] = {.lex_state = 3},
  [555] = {.lex_state = 3},
  [556] = {.lex_state = 3},
  [557] = {.lex_state = 12},
  [558] = {.lex_state = 4},
  [559] = {.lex_state = 3},
  [560] = {.lex_state = 4},
  [561] = {.lex_state = 3},
  [562] = {.lex_state = 3},
  [563] = {.lex_state = 3},
  [564] = {.lex_state = 3},
  [565] = {.lex_state = 3},
  [566] = {.lex_state = 3},
  [567] = {.lex_state = 3},
  [568] = {.lex_state = 3},
  [569] = {.lex_state = 3},
  [570] = {.lex_state = 3},
  [571] = {.lex_state = 3},
  [572] = {.lex_state = 3},
  [573] = {.lex_state = 3},
  [574] = {.lex_state = 3},
  [575] = {.lex_state = 3},
  [576] = {.lex_state = 3},
  [577] = {.lex_state = 4},
  [578] = {.lex_state = 3},
  [579] = {.lex_state = 4},
  [580] = {.lex_state = 4},
  [581] = {.lex_state = 3},
  [582] = {.lex_state = 3},
  [583] = {.lex_state = 3},
  [584] = {.lex_state = 3},
  [585] = {.lex_state = 3},
  [586] = {.lex_state = 4},
  [587] = {.lex_state = 3},
  [588] = {.lex_state = 4},
  [589] = {.lex_state = 3},
  [590] = {.lex_state = 3},
  [591] = {.lex_state = 4},
  [592] = {.lex_state = 4},
  [593] = {.lex_state = 3},
  [594] = {.lex_state = 3},
  [595] = {.lex_state = 12},
  [596] = {.lex_state = 3},
  [597] = {.lex_state = 3},
  [598] = {.lex_state = 4},
  [599] = {.lex_state = 4},
  [600] = {.lex_state = 3},
  [601] = {.lex_state = 3},
  [602] = {.lex_state = 3},
  [603] = {.lex_state = 3},
  [604] = {.lex_state = 22},
  [605] = {.lex_state = 3},
  [606] = {.lex_state = 4},
  [607] = {.lex_state = 3},
  [608] = {.lex_state = 3},
  [609] = {.lex_state = 3},
  [610] = {.lex_state = 3},
  [611] = {.lex_state = 3},
  [612] = {.lex_state = 3},
  [613] = {.lex_state = 3},
  [614] = {.lex_state = 3},
  [615] = {.lex_state = 3},
  [616] = {.lex_state = 3},
  [617] = {.lex_state = 3},
  [618] = {.lex_state = 3},
  [619] = {.lex_state = 3},
  [620] = {.lex_state = 3},
  [621] = {.lex_state = 3},
  [622] = {.lex_state = 3},
  [623] = {.lex_state = 3},
  [624] = {.lex_state = 3},
  [625] = {.lex_state = 3},
  [626] = {.lex_state = 22},
  [627] = {.lex_state = 3},
  [628] = {.lex_state = 3},
  [629] = {.lex_state = 3},
  [630] = {.lex_state = 3},
  [631] = {.lex_state = 3},
  [632] = {.lex_state = 3},
  [633] = {.lex_state = 3},
  [634] = {.lex_state = 3},
  [635] = {.lex_state = 3},
  [636] = {.lex_state = 3},
  [637] = {.lex_state = 3},
  [638] = {.lex_state = 3},
  [639] = {.lex_state = 3},
  [640] = {.lex_state = 3},
  [641] = {.lex_state = 12},
  [642] = {.lex_state = 3},
  [643] = {.lex_state = 3},
  [644] = {.lex_state = 3},
  [645] = {.lex_state = 3},
  [646] = {.lex_state = 12},
  [647] = {.lex_state = 3},
  [648] = {.lex_state = 3},
  [649] = {.lex_state = 4},
  [650] = {.lex_state = 3},
  [651] = {.lex_state = 5},
  [652] = {.lex_state = 5},
  [653] = {.lex_state = 3},
  [654] = {.lex_state = 12},
  [655] = {.lex_state = 22},
  [656] = {.lex_state = 12},
  [657] = {.lex_state = 12},
  [658] = {.lex_state = 12},
  [659] = {.lex_state = 3},
  [660] = {.lex_state = 12},
  [661] = {.lex_state = 3},
  [662] = {.lex_state = 3},
  [663] = {.lex_state = 3},
  [664] = {.lex_state = 3},
  [665] = {.lex_state = 3},
  [666] = {.lex_state = 12},
  [667] = {.lex_state = 3},
  [668] = {.lex_state = 5},
  [669] = {.lex_state = 5},
  [670] = {.lex_state = 3},
  [671] = {.lex_state = 12},
  [672] = {.lex_state = 12},
  [673] = {.lex_state = 22},
  [674] = {.lex_state = 12},
  [675] = {.lex_state = 12},
  [676] = {.lex_state = 3},
  [677] = {.lex_state = 12},
  [678] = {.lex_state = 3},
  [679] = {.lex_state = 3},
  [680] = {.lex_state = 3},
  [681] = {.lex_state = 3},
  [682] = {.lex_state = 3},
  [683] = {.lex_state = 5},
  [684] = {.lex_state = 12},
  [685] = {.lex_state = 12},
  [686] = {.lex_state = 3},
  [687] = {.lex_state = 3},
  [688] = {.lex_state = 5},
  [689] = {.lex_state = 3},
  [690] = {.lex_state = 5},
  [691] = {.lex_state = 12},
  [692] = {.lex_state = 5},
  [693] = {.lex_state = 12},
  [694] = {.lex_state = 3},
  [695] = {.lex_state = 3},
  [696] = {.lex_state = 3},
  [697] = {.lex_state = 3},
  [698] = {.lex_state = 3},
  [699] = {.lex_state = 3},
  [700] = {.lex_state = 3},
  [701] = {.lex_state = 3},
  [702] = {.lex_state = 3},
  [703] = {.lex_state = 3},
  [704] = {.lex_state = 3},
  [705] = {.lex_state = 3},
  [706] = {.lex_state = 5},
  [707] = {.lex_state = 5},
  [708] = {.lex_state = 5},
  [709] = {.lex_state = 3},
  [710] = {.lex_state = 3},
  [711] = {.lex_state = 3},
  [712] = {.lex_state = 3},
  [713] = {.lex_state = 3},
  [714] = {.lex_state = 5},
  [715] = {.lex_state = 3},
  [716] = {.lex_state = 5},
  [717] = {.lex_state = 3},
  [718] = {.lex_state = 5},
  [719] = {.lex_state = 3},
  [720] = {.lex_state = 3},
  [721] = {.lex_state = 3},
  [722] = {.lex_state = 5},
  [723] = {.lex_state = 3},
  [724] = {.lex_state = 5},
  [725] = {.lex_state = 4},
  [726] = {.lex_state = 5},
  [727] = {.lex_state = 3},
  [728] = {.lex_state = 5},
  [729] = {.lex_state = 3},
  [730] = {.lex_state = 4},
  [731] = {.lex_state = 3},
  [732] = {.lex_state = 5},
  [733] = {.lex_state = 3},
  [734] = {.lex_state = 5},
  [735] = {.lex_state = 5},
  [736] = {.lex_state = 3},
  [737] = {.lex_state = 5},
  [738] = {.lex_state = 3},
  [739] = {.lex_state = 4},
  [740] = {.lex_state = 4},
  [741] = {.lex_state = 3},
  [742] = {.lex_state = 5},
  [743] = {.lex_state = 3},
  [744] = {.lex_state = 5},
  [745] = {.lex_state = 5},
  [746] = {.lex_state = 4},
  [747] = {.lex_state = 5},
  [748] = {.lex_state = 4},
  [749] = {.lex_state = 5},
  [750] = {.lex_state = 4},
  [751] = {.lex_state = 5},
  [752] = {.lex_state = 4},
  [753] = {.lex_state = 5},
  [754] = {.lex_state = 3},
  [755] = {.lex_state = 5},
  [756] = {.lex_state = 5},
  [757] = {.lex_state = 3},
  [758] = {.lex_state = 3},
  [759] = {.lex_state = 3},
  [760] = {.lex_state = 5},
  [761] = {.lex_state = 5},
  [762] = {.lex_state = 4},
  [763] = {.lex_state = 3},
  [764] = {.lex_state = 3},
  [765] = {.lex_state = 4},
  [766] = {.lex_state = 3},
  [767] = {.lex_state = 3},
  [768] = {.lex_state = 3},
  [769] = {.lex_state = 3},
  [770] = {.lex_state = 12},
  [771] = {.lex_state = 3},
  [772] = {.lex_state = 3},
  [773] = {.lex_state = 3},
  [774] = {.lex_state = 3},
  [775] = {.lex_state = 3},
  [776] = {.lex_state = 3},
  [777] = {.lex_state = 3},
  [778] = {.lex_state = 3},
  [779] = {.lex_state = 3},
  [780] = {.lex_state = 3},
  [781] = {.lex_state = 3},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 3},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 3},
  [786] = {.lex_state = 3},
  [787] = {.lex_state = 3},
  [788] = {.lex_state = 3},
  [789] = {.lex_state = 3},
  [790] = {.lex_state = 4},
  [791] = {.lex_state = 4},
  [792] = {.lex_state = 3},
  [793] = {.lex_state = 3},
  [794] = {.lex_state = 3},
  [795] = {.lex_state = 4},
  [796] = {.lex_state = 3},
  [797] = {.lex_state = 3},
  [798] = {.lex_state = 3},
  [799] = {.lex_state = 3},
  [800] = {.lex_state = 3},
  [801] = {.lex_state = 3},
  [802] = {.lex_state = 3},
  [803] = {.lex_state = 3},
  [804] = {.lex_state = 3},
  [805] = {.lex_state = 3},
  [806] = {.lex_state = 3},
  [807] = {.lex_state = 3},
  [808] = {.lex_state = 3},
  [809] = {.lex_state = 3},
  [810] = {.lex_state = 3},
  [811] = {.lex_state = 3},
  [812] = {.lex_state = 3},
  [813] = {.lex_state = 3},
  [814] = {.lex_state = 3},
  [815] = {.lex_state = 3},
  [816] = {.lex_state = 3},
  [817] = {.lex_state = 3},
  [818] = {.lex_state = 4},
  [819] = {.lex_state = 3},
  [820] = {.lex_state = 3},
  [821] = {.lex_state = 3},
  [822] = {.lex_state = 3},
  [823] = {.lex_state = 3},
  [824] = {.lex_state = 4},
  [825] = {.lex_state = 3},
  [826] = {.lex_state = 3},
  [827] = {.lex_state = 3},
  [828] = {.lex_state = 3},
  [829] = {.lex_state = 3},
  [830] = {.lex_state = 3},
  [831] = {.lex_state = 3},
  [832] = {.lex_state = 3},
  [833] = {.lex_state = 3},
  [834] = {.lex_state = 3},
  [835] = {.lex_state = 3},
  [836] = {.lex_state = 3},
  [837] = {.lex_state = 3},
  [838] = {.lex_state = 3},
  [839] = {.lex_state = 3},
  [840] = {.lex_state = 3},
  [841] = {.lex_state = 3},
  [842] = {.lex_state = 3},
  [843] = {.lex_state = 3},
  [844] = {.lex_state = 3},
  [845] = {.lex_state = 3},
  [846] = {.lex_state = 3},
  [847] = {.lex_state = 3},
  [848] = {.lex_state = 3},
  [849] = {.lex_state = 3},
  [850] = {.lex_state = 4},
  [851] = {.lex_state = 3},
  [852] = {.lex_state = 3},
  [853] = {.lex_state = 3},
  [854] = {.lex_state = 3},
  [855] = {.lex_state = 3},
  [856] = {.lex_state = 3},
  [857] = {.lex_state = 3},
  [858] = {.lex_state = 3},
  [859] = {.lex_state = 3},
  [860] = {.lex_state = 12},
  [861] = {.lex_state = 3},
  [862] = {.lex_state = 3},
  [863] = {.lex_state = 3},
  [864] = {.lex_state = 3},
  [865] = {.lex_state = 5},
  [866] = {.lex_state = 3},
  [867] = {.lex_state = 3},
  [868] = {.lex_state = 5},
  [869] = {.lex_state = 3},
  [870] = {.lex_state = 3},
  [871] = {.lex_state = 5},
  [872] = {.lex_state = 5},
  [873] = {.lex_state = 3},
  [874] = {.lex_state = 3},
  [875] = {.lex_state = 5},
  [876] = {.lex_state = 3},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 12},
  [879] = {.lex_state = 3},
  [880] = {.lex_state = 3},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 3},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 3},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 3},
  [888] = {.lex_state = 3},
  [889] = {.lex_state = 3},
  [890] = {.lex_state = 3},
  [891] = {.lex_state = 5},
  [892] = {.lex_state = 3},
  [893] = {.lex_state = 3},
  [894] = {.lex_state = 3},
  [895] = {.lex_state = 3},
  [896] = {.lex_state = 3},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 5},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 4},
  [901] = {.lex_state = 5},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 3},
  [907] = {.lex_state = 3},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 3},
  [911] = {.lex_state = 3},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 12},
  [914] = {.lex_state = 3},
  [915] = {.lex_state = 5},
  [916] = {.lex_state = 5},
  [917] = {.lex_state = 5},
  [918] = {.lex_state = 5},
  [919] = {.lex_state = 5},
  [920] = {.lex_state = 5},
  [921] = {.lex_state = 5},
  [922] = {.lex_state = 5},
  [923] = {.lex_state = 5},
  [924] = {.lex_state = 5},
  [925] = {.lex_state = 5},
  [926] = {.lex_state = 12},
  [927] = {.lex_state = 3},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 3},
  [930] = {.lex_state = 3},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 3},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 3},
  [935] = {.lex_state = 3},
  [936] = {.lex_state = 3},
  [937] = {.lex_state = 3},
  [938] = {.lex_state = 3},
  [939] = {.lex_state = 3},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 3},
  [942] = {.lex_state = 3},
  [943] = {.lex_state = 4},
  [944] = {.lex_state = 3},
  [945] = {.lex_state = 4},
  [946] = {.lex_state = 3},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 3},
  [950] = {.lex_state = 3},
  [951] = {.lex_state = 3},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 3},
  [955] = {.lex_state = 3},
  [956] = {.lex_state = 3},
  [957] = {.lex_state = 3},
  [958] = {.lex_state = 3},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 3},
  [964] = {.lex_state = 3},
  [965] = {.lex_state = 3},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 5},
  [969] = {.lex_state = 4},
  [970] = {.lex_state = 3},
  [971] = {.lex_state = 4},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 3},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 5},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 5},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 3},
  [1002] = {.lex_state = 3},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 5},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 5},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 5},
  [1018] = {.lex_state = 4},
  [1019] = {.lex_state = 5},
  [1020] = {.lex_state = 5},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 3},
  [1024] = {.lex_state = 5},
  [1025] = {.lex_state = 5},
  [1026] = {.lex_state = 5},
  [1027] = {.lex_state = 5},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 3},
  [1030] = {.lex_state = 5},
  [1031] = {.lex_state = 5},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 4},
  [1035] = {.lex_state = 4},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 3},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 5},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 4},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 3},
  [1056] = {.lex_state = 3},
  [1057] = {.lex_state = 3},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 4},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 5},
  [1072] = {.lex_state = 5},
  [1073] = {.lex_state = 4},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 5},
  [1076] = {.lex_state = 4},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 5},
  [1080] = {.lex_state = 4},
  [1081] = {.lex_state = 3},
  [1082] = {.lex_state = 4},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 4},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 3},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 3},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 3},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 3},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 3},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 3},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 4},
  [1118] = {.lex_state = 4},
  [1119] = {.lex_state = 5},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 5},
  [1126] = {.lex_state = 5},
  [1127] = {.lex_state = 5},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 5},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 5},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 3},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 4},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 5},
  [1160] = {.lex_state = 5},
  [1161] = {.lex_state = 5},
  [1162] = {.lex_state = 0},
  [1163] = {.lex_state = 5},
  [1164] = {.lex_state = 5},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 4},
  [1167] = {.lex_state = 5},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 5},
  [1174] = {.lex_state = 5},
  [1175] = {.lex_state = 5},
  [1176] = {.lex_state = 0},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 5},
  [1181] = {.lex_state = 3},
  [1182] = {.lex_state = 5},
  [1183] = {.lex_state = 5},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 3},
  [1186] = {.lex_state = 5},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 0},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 3},
  [1200] = {.lex_state = 0},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 0},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 0},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 0},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 3},
  [1215] = {.lex_state = 3},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 3},
  [1220] = {.lex_state = 3},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 5},
  [1224] = {.lex_state = 3},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 3},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 0},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 5},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 3},
  [1236] = {.lex_state = 3},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 0},
  [1243] = {.lex_state = 3},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 3},
  [1251] = {.lex_state = 3},
  [1252] = {.lex_state = 3},
  [1253] = {.lex_state = 3},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 0},
  [1256] = {.lex_state = 3},
  [1257] = {.lex_state = 0},
  [1258] = {.lex_state = 3},
  [1259] = {.lex_state = 0},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 3},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 3},
  [1264] = {.lex_state = 0},
  [1265] = {.lex_state = 0},
  [1266] = {.lex_state = 0},
  [1267] = {.lex_state = 0},
  [1268] = {.lex_state = 3},
  [1269] = {.lex_state = 0},
  [1270] = {.lex_state = 0},
  [1271] = {.lex_state = 3},
  [1272] = {.lex_state = 3},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 0},
  [1275] = {.lex_state = 3},
  [1276] = {.lex_state = 0},
  [1277] = {.lex_state = 0},
  [1278] = {.lex_state = 0},
  [1279] = {.lex_state = 0},
  [1280] = {.lex_state = 0},
  [1281] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_decimal_integer_literal] = ACTIONS(1),
    [sym_hex_integer_literal] = ACTIONS(1),
    [sym_octal_integer_literal] = ACTIONS(1),
    [sym_binary_integer_literal] = ACTIONS(1),
    [sym_decimal_floating_point_literal] = ACTIONS(1),
    [sym_hex_floating_point_literal] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_character_literal] = ACTIONS(1),
    [sym_string_literal] = ACTIONS(1),
    [sym_text_block] = ACTIONS(1),
    [sym_null_literal] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_synchronized] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_open] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_requires] = ACTIONS(1),
    [anon_sym_transitive] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_exports] = ACTIONS(1),
    [anon_sym_to] = ACTIONS(1),
    [anon_sym_opens] = ACTIONS(1),
    [anon_sym_uses] = ACTIONS(1),
    [anon_sym_provides] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_strictfp] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_transient] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_sealed] = ACTIONS(1),
    [anon_sym_non_DASHsealed] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_permits] = ACTIONS(1),
    [anon_sym_record] = ACTIONS(1),
    [anon_sym_ATinterface] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_char] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [sym_boolean_type] = ACTIONS(1),
    [sym_void_type] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_throws] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(1209),
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(11),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_switch_label] = STATE(1228),
    [sym_statement] = STATE(5),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_program_repeat1] = STATE(5),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_switch_block_statement_group_repeat1] = STATE(235),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(87),
    [anon_sym_case] = ACTIONS(89),
    [anon_sym_default] = ACTIONS(89),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(546),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_type_arguments] = STATE(1098),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_explicit_constructor_invocation] = STATE(13),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_LT] = ACTIONS(91),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(93),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(97),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [ts_builtin_sym_end] = ACTIONS(99),
    [sym_identifier] = ACTIONS(101),
    [sym_decimal_integer_literal] = ACTIONS(104),
    [sym_hex_integer_literal] = ACTIONS(104),
    [sym_octal_integer_literal] = ACTIONS(107),
    [sym_binary_integer_literal] = ACTIONS(107),
    [sym_decimal_floating_point_literal] = ACTIONS(107),
    [sym_hex_floating_point_literal] = ACTIONS(104),
    [sym_true] = ACTIONS(104),
    [sym_false] = ACTIONS(104),
    [sym_character_literal] = ACTIONS(107),
    [sym_string_literal] = ACTIONS(104),
    [sym_text_block] = ACTIONS(107),
    [sym_null_literal] = ACTIONS(104),
    [anon_sym_LPAREN] = ACTIONS(110),
    [anon_sym_PLUS] = ACTIONS(113),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_final] = ACTIONS(116),
    [anon_sym_BANG] = ACTIONS(119),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PLUS_PLUS] = ACTIONS(122),
    [anon_sym_DASH_DASH] = ACTIONS(122),
    [anon_sym_new] = ACTIONS(125),
    [anon_sym_class] = ACTIONS(128),
    [anon_sym_switch] = ACTIONS(131),
    [anon_sym_LBRACE] = ACTIONS(134),
    [anon_sym_RBRACE] = ACTIONS(99),
    [anon_sym_case] = ACTIONS(137),
    [anon_sym_default] = ACTIONS(116),
    [anon_sym_SEMI] = ACTIONS(139),
    [anon_sym_assert] = ACTIONS(142),
    [anon_sym_do] = ACTIONS(145),
    [anon_sym_while] = ACTIONS(148),
    [anon_sym_break] = ACTIONS(151),
    [anon_sym_continue] = ACTIONS(154),
    [anon_sym_return] = ACTIONS(157),
    [anon_sym_yield] = ACTIONS(160),
    [anon_sym_synchronized] = ACTIONS(163),
    [anon_sym_throw] = ACTIONS(166),
    [anon_sym_try] = ACTIONS(169),
    [anon_sym_if] = ACTIONS(172),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_AT] = ACTIONS(178),
    [anon_sym_open] = ACTIONS(181),
    [anon_sym_module] = ACTIONS(184),
    [anon_sym_static] = ACTIONS(116),
    [anon_sym_package] = ACTIONS(187),
    [anon_sym_import] = ACTIONS(190),
    [anon_sym_enum] = ACTIONS(193),
    [anon_sym_public] = ACTIONS(116),
    [anon_sym_protected] = ACTIONS(116),
    [anon_sym_private] = ACTIONS(116),
    [anon_sym_abstract] = ACTIONS(116),
    [anon_sym_strictfp] = ACTIONS(116),
    [anon_sym_native] = ACTIONS(116),
    [anon_sym_transient] = ACTIONS(116),
    [anon_sym_volatile] = ACTIONS(116),
    [anon_sym_sealed] = ACTIONS(116),
    [anon_sym_non_DASHsealed] = ACTIONS(196),
    [anon_sym_record] = ACTIONS(199),
    [anon_sym_ATinterface] = ACTIONS(202),
    [anon_sym_interface] = ACTIONS(205),
    [anon_sym_byte] = ACTIONS(208),
    [anon_sym_short] = ACTIONS(208),
    [anon_sym_int] = ACTIONS(208),
    [anon_sym_long] = ACTIONS(208),
    [anon_sym_char] = ACTIONS(208),
    [anon_sym_float] = ACTIONS(211),
    [anon_sym_double] = ACTIONS(211),
    [sym_boolean_type] = ACTIONS(214),
    [sym_void_type] = ACTIONS(214),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(220),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(223),
    [anon_sym_case] = ACTIONS(225),
    [anon_sym_default] = ACTIONS(225),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(227),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(229),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(9),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(231),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(233),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(7),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(235),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [ts_builtin_sym_end] = ACTIONS(237),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(12),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(227),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(199),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(216),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(182),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(1250),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(240),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(249),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(248),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(247),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(246),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(185),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(209),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(245),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(242),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(236),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(234),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(233),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(183),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(184),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(186),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(189),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(249),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(248),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(247),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(192),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(246),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(183),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(184),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(186),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(189),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(192),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(216),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(226),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [46] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(193),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [47] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(215),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [48] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(194),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [49] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(198),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [50] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(244),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [51] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(200),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [52] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(206),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [53] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(211),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [54] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(193),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(213),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(194),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [57] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(215),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(226),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [59] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(213),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(1152),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [61] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(233),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(234),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [63] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(236),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(242),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(211),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(245),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [67] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(206),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(200),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [69] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(209),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [70] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(185),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [71] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(244),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [72] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(199),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [73] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(594),
    [sym_statement] = STATE(182),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(243),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [74] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(83),
    [sym_statement] = STATE(198),
    [sym_block] = STATE(204),
    [sym_expression_statement] = STATE(204),
    [sym_labeled_statement] = STATE(204),
    [sym_assert_statement] = STATE(204),
    [sym_do_statement] = STATE(204),
    [sym_break_statement] = STATE(204),
    [sym_continue_statement] = STATE(204),
    [sym_return_statement] = STATE(204),
    [sym_yield_statement] = STATE(204),
    [sym_synchronized_statement] = STATE(204),
    [sym_throw_statement] = STATE(204),
    [sym_try_statement] = STATE(204),
    [sym_try_with_resources_statement] = STATE(204),
    [sym_if_statement] = STATE(204),
    [sym_while_statement] = STATE(204),
    [sym_for_statement] = STATE(204),
    [sym_enhanced_for_statement] = STATE(204),
    [sym__annotation] = STATE(491),
    [sym_marker_annotation] = STATE(491),
    [sym_annotation] = STATE(491),
    [sym_declaration] = STATE(204),
    [sym_module_declaration] = STATE(243),
    [sym_package_declaration] = STATE(243),
    [sym_import_declaration] = STATE(243),
    [sym_enum_declaration] = STATE(243),
    [sym_class_declaration] = STATE(243),
    [sym_modifiers] = STATE(655),
    [sym_record_declaration] = STATE(243),
    [sym_annotation_type_declaration] = STATE(243),
    [sym_interface_declaration] = STATE(243),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(688),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(204),
    [aux_sym_array_creation_expression_repeat1] = STATE(629),
    [aux_sym_modifiers_repeat1] = STATE(423),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(17),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_class] = ACTIONS(25),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_default] = ACTIONS(17),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(17),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_abstract] = ACTIONS(17),
    [anon_sym_strictfp] = ACTIONS(17),
    [anon_sym_native] = ACTIONS(17),
    [anon_sym_transient] = ACTIONS(17),
    [anon_sym_volatile] = ACTIONS(17),
    [anon_sym_sealed] = ACTIONS(17),
    [anon_sym_non_DASHsealed] = ACTIONS(69),
    [anon_sym_record] = ACTIONS(71),
    [anon_sym_ATinterface] = ACTIONS(73),
    [anon_sym_interface] = ACTIONS(75),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [75] = {
    [ts_builtin_sym_end] = ACTIONS(249),
    [sym_identifier] = ACTIONS(251),
    [sym_decimal_integer_literal] = ACTIONS(251),
    [sym_hex_integer_literal] = ACTIONS(251),
    [sym_octal_integer_literal] = ACTIONS(249),
    [sym_binary_integer_literal] = ACTIONS(249),
    [sym_decimal_floating_point_literal] = ACTIONS(249),
    [sym_hex_floating_point_literal] = ACTIONS(251),
    [sym_true] = ACTIONS(251),
    [sym_false] = ACTIONS(251),
    [sym_character_literal] = ACTIONS(249),
    [sym_string_literal] = ACTIONS(251),
    [sym_text_block] = ACTIONS(249),
    [sym_null_literal] = ACTIONS(251),
    [anon_sym_LPAREN] = ACTIONS(249),
    [anon_sym_AMP] = ACTIONS(251),
    [anon_sym_RPAREN] = ACTIONS(249),
    [anon_sym_GT] = ACTIONS(251),
    [anon_sym_LT] = ACTIONS(251),
    [anon_sym_GT_EQ] = ACTIONS(249),
    [anon_sym_LT_EQ] = ACTIONS(249),
    [anon_sym_EQ_EQ] = ACTIONS(249),
    [anon_sym_BANG_EQ] = ACTIONS(249),
    [anon_sym_AMP_AMP] = ACTIONS(249),
    [anon_sym_PIPE_PIPE] = ACTIONS(249),
    [anon_sym_PLUS] = ACTIONS(251),
    [anon_sym_DASH] = ACTIONS(251),
    [anon_sym_STAR] = ACTIONS(249),
    [anon_sym_SLASH] = ACTIONS(251),
    [anon_sym_PIPE] = ACTIONS(251),
    [anon_sym_CARET] = ACTIONS(249),
    [anon_sym_PERCENT] = ACTIONS(249),
    [anon_sym_LT_LT] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(251),
    [anon_sym_GT_GT_GT] = ACTIONS(249),
    [anon_sym_instanceof] = ACTIONS(251),
    [anon_sym_final] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(249),
    [anon_sym_COMMA] = ACTIONS(249),
    [anon_sym_QMARK] = ACTIONS(249),
    [anon_sym_COLON] = ACTIONS(251),
    [anon_sym_BANG] = ACTIONS(251),
    [anon_sym_TILDE] = ACTIONS(249),
    [anon_sym_PLUS_PLUS] = ACTIONS(249),
    [anon_sym_DASH_DASH] = ACTIONS(249),
    [anon_sym_new] = ACTIONS(251),
    [anon_sym_LBRACK] = ACTIONS(249),
    [anon_sym_RBRACK] = ACTIONS(249),
    [anon_sym_DOT] = ACTIONS(251),
    [anon_sym_class] = ACTIONS(251),
    [anon_sym_COLON_COLON] = ACTIONS(249),
    [anon_sym_switch] = ACTIONS(251),
    [anon_sym_LBRACE] = ACTIONS(249),
    [anon_sym_RBRACE] = ACTIONS(249),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_default] = ACTIONS(251),
    [anon_sym_SEMI] = ACTIONS(249),
    [anon_sym_assert] = ACTIONS(251),
    [anon_sym_do] = ACTIONS(251),
    [anon_sym_while] = ACTIONS(251),
    [anon_sym_break] = ACTIONS(251),
    [anon_sym_continue] = ACTIONS(251),
    [anon_sym_return] = ACTIONS(251),
    [anon_sym_yield] = ACTIONS(251),
    [anon_sym_synchronized] = ACTIONS(251),
    [anon_sym_throw] = ACTIONS(251),
    [anon_sym_try] = ACTIONS(251),
    [anon_sym_if] = ACTIONS(251),
    [anon_sym_else] = ACTIONS(251),
    [anon_sym_for] = ACTIONS(251),
    [anon_sym_AT] = ACTIONS(251),
    [anon_sym_open] = ACTIONS(251),
    [anon_sym_module] = ACTIONS(251),
    [anon_sym_static] = ACTIONS(251),
    [anon_sym_package] = ACTIONS(251),
    [anon_sym_import] = ACTIONS(251),
    [anon_sym_enum] = ACTIONS(251),
    [anon_sym_public] = ACTIONS(251),
    [anon_sym_protected] = ACTIONS(251),
    [anon_sym_private] = ACTIONS(251),
    [anon_sym_abstract] = ACTIONS(251),
    [anon_sym_strictfp] = ACTIONS(251),
    [anon_sym_native] = ACTIONS(251),
    [anon_sym_transient] = ACTIONS(251),
    [anon_sym_volatile] = ACTIONS(251),
    [anon_sym_sealed] = ACTIONS(251),
    [anon_sym_non_DASHsealed] = ACTIONS(249),
    [anon_sym_record] = ACTIONS(251),
    [anon_sym_ATinterface] = ACTIONS(249),
    [anon_sym_interface] = ACTIONS(251),
    [anon_sym_byte] = ACTIONS(251),
    [anon_sym_short] = ACTIONS(251),
    [anon_sym_int] = ACTIONS(251),
    [anon_sym_long] = ACTIONS(251),
    [anon_sym_char] = ACTIONS(251),
    [anon_sym_float] = ACTIONS(251),
    [anon_sym_double] = ACTIONS(251),
    [sym_boolean_type] = ACTIONS(251),
    [sym_void_type] = ACTIONS(251),
    [sym_this] = ACTIONS(251),
    [sym_super] = ACTIONS(251),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [76] = {
    [ts_builtin_sym_end] = ACTIONS(253),
    [sym_identifier] = ACTIONS(255),
    [sym_decimal_integer_literal] = ACTIONS(255),
    [sym_hex_integer_literal] = ACTIONS(255),
    [sym_octal_integer_literal] = ACTIONS(253),
    [sym_binary_integer_literal] = ACTIONS(253),
    [sym_decimal_floating_point_literal] = ACTIONS(253),
    [sym_hex_floating_point_literal] = ACTIONS(255),
    [sym_true] = ACTIONS(255),
    [sym_false] = ACTIONS(255),
    [sym_character_literal] = ACTIONS(253),
    [sym_string_literal] = ACTIONS(255),
    [sym_text_block] = ACTIONS(253),
    [sym_null_literal] = ACTIONS(255),
    [anon_sym_LPAREN] = ACTIONS(253),
    [anon_sym_AMP] = ACTIONS(255),
    [anon_sym_RPAREN] = ACTIONS(253),
    [anon_sym_GT] = ACTIONS(255),
    [anon_sym_LT] = ACTIONS(255),
    [anon_sym_GT_EQ] = ACTIONS(253),
    [anon_sym_LT_EQ] = ACTIONS(253),
    [anon_sym_EQ_EQ] = ACTIONS(253),
    [anon_sym_BANG_EQ] = ACTIONS(253),
    [anon_sym_AMP_AMP] = ACTIONS(253),
    [anon_sym_PIPE_PIPE] = ACTIONS(253),
    [anon_sym_PLUS] = ACTIONS(255),
    [anon_sym_DASH] = ACTIONS(255),
    [anon_sym_STAR] = ACTIONS(253),
    [anon_sym_SLASH] = ACTIONS(255),
    [anon_sym_PIPE] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(253),
    [anon_sym_PERCENT] = ACTIONS(253),
    [anon_sym_LT_LT] = ACTIONS(253),
    [anon_sym_GT_GT] = ACTIONS(255),
    [anon_sym_GT_GT_GT] = ACTIONS(253),
    [anon_sym_instanceof] = ACTIONS(255),
    [anon_sym_final] = ACTIONS(255),
    [anon_sym_DASH_GT] = ACTIONS(253),
    [anon_sym_COMMA] = ACTIONS(253),
    [anon_sym_QMARK] = ACTIONS(253),
    [anon_sym_COLON] = ACTIONS(255),
    [anon_sym_BANG] = ACTIONS(255),
    [anon_sym_TILDE] = ACTIONS(253),
    [anon_sym_PLUS_PLUS] = ACTIONS(253),
    [anon_sym_DASH_DASH] = ACTIONS(253),
    [anon_sym_new] = ACTIONS(255),
    [anon_sym_LBRACK] = ACTIONS(253),
    [anon_sym_RBRACK] = ACTIONS(253),
    [anon_sym_DOT] = ACTIONS(255),
    [anon_sym_class] = ACTIONS(255),
    [anon_sym_COLON_COLON] = ACTIONS(253),
    [anon_sym_switch] = ACTIONS(255),
    [anon_sym_LBRACE] = ACTIONS(253),
    [anon_sym_RBRACE] = ACTIONS(253),
    [anon_sym_case] = ACTIONS(255),
    [anon_sym_default] = ACTIONS(255),
    [anon_sym_SEMI] = ACTIONS(253),
    [anon_sym_assert] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(255),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_break] = ACTIONS(255),
    [anon_sym_continue] = ACTIONS(255),
    [anon_sym_return] = ACTIONS(255),
    [anon_sym_yield] = ACTIONS(255),
    [anon_sym_synchronized] = ACTIONS(255),
    [anon_sym_throw] = ACTIONS(255),
    [anon_sym_try] = ACTIONS(255),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_else] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(255),
    [anon_sym_AT] = ACTIONS(255),
    [anon_sym_open] = ACTIONS(255),
    [anon_sym_module] = ACTIONS(255),
    [anon_sym_static] = ACTIONS(255),
    [anon_sym_package] = ACTIONS(255),
    [anon_sym_import] = ACTIONS(255),
    [anon_sym_enum] = ACTIONS(255),
    [anon_sym_public] = ACTIONS(255),
    [anon_sym_protected] = ACTIONS(255),
    [anon_sym_private] = ACTIONS(255),
    [anon_sym_abstract] = ACTIONS(255),
    [anon_sym_strictfp] = ACTIONS(255),
    [anon_sym_native] = ACTIONS(255),
    [anon_sym_transient] = ACTIONS(255),
    [anon_sym_volatile] = ACTIONS(255),
    [anon_sym_sealed] = ACTIONS(255),
    [anon_sym_non_DASHsealed] = ACTIONS(253),
    [anon_sym_record] = ACTIONS(255),
    [anon_sym_ATinterface] = ACTIONS(253),
    [anon_sym_interface] = ACTIONS(255),
    [anon_sym_byte] = ACTIONS(255),
    [anon_sym_short] = ACTIONS(255),
    [anon_sym_int] = ACTIONS(255),
    [anon_sym_long] = ACTIONS(255),
    [anon_sym_char] = ACTIONS(255),
    [anon_sym_float] = ACTIONS(255),
    [anon_sym_double] = ACTIONS(255),
    [sym_boolean_type] = ACTIONS(255),
    [sym_void_type] = ACTIONS(255),
    [sym_this] = ACTIONS(255),
    [sym_super] = ACTIONS(255),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [77] = {
    [sym_identifier] = ACTIONS(257),
    [sym_decimal_integer_literal] = ACTIONS(257),
    [sym_hex_integer_literal] = ACTIONS(257),
    [sym_octal_integer_literal] = ACTIONS(259),
    [sym_binary_integer_literal] = ACTIONS(259),
    [sym_decimal_floating_point_literal] = ACTIONS(259),
    [sym_hex_floating_point_literal] = ACTIONS(257),
    [sym_true] = ACTIONS(257),
    [sym_false] = ACTIONS(257),
    [sym_character_literal] = ACTIONS(259),
    [sym_string_literal] = ACTIONS(257),
    [sym_text_block] = ACTIONS(259),
    [sym_null_literal] = ACTIONS(257),
    [anon_sym_LPAREN] = ACTIONS(259),
    [anon_sym_AMP] = ACTIONS(257),
    [anon_sym_RPAREN] = ACTIONS(259),
    [anon_sym_GT] = ACTIONS(257),
    [anon_sym_LT] = ACTIONS(257),
    [anon_sym_GT_EQ] = ACTIONS(259),
    [anon_sym_LT_EQ] = ACTIONS(259),
    [anon_sym_EQ_EQ] = ACTIONS(259),
    [anon_sym_BANG_EQ] = ACTIONS(259),
    [anon_sym_AMP_AMP] = ACTIONS(259),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_PLUS] = ACTIONS(257),
    [anon_sym_DASH] = ACTIONS(257),
    [anon_sym_STAR] = ACTIONS(259),
    [anon_sym_SLASH] = ACTIONS(257),
    [anon_sym_PIPE] = ACTIONS(257),
    [anon_sym_CARET] = ACTIONS(259),
    [anon_sym_PERCENT] = ACTIONS(259),
    [anon_sym_LT_LT] = ACTIONS(259),
    [anon_sym_GT_GT] = ACTIONS(257),
    [anon_sym_GT_GT_GT] = ACTIONS(259),
    [anon_sym_instanceof] = ACTIONS(257),
    [anon_sym_final] = ACTIONS(257),
    [anon_sym_DASH_GT] = ACTIONS(259),
    [anon_sym_COMMA] = ACTIONS(259),
    [anon_sym_QMARK] = ACTIONS(259),
    [anon_sym_COLON] = ACTIONS(257),
    [anon_sym_BANG] = ACTIONS(257),
    [anon_sym_TILDE] = ACTIONS(259),
    [anon_sym_PLUS_PLUS] = ACTIONS(259),
    [anon_sym_DASH_DASH] = ACTIONS(259),
    [anon_sym_new] = ACTIONS(257),
    [anon_sym_LBRACK] = ACTIONS(259),
    [anon_sym_RBRACK] = ACTIONS(259),
    [anon_sym_DOT] = ACTIONS(257),
    [anon_sym_class] = ACTIONS(257),
    [anon_sym_COLON_COLON] = ACTIONS(259),
    [anon_sym_switch] = ACTIONS(257),
    [anon_sym_LBRACE] = ACTIONS(259),
    [anon_sym_RBRACE] = ACTIONS(259),
    [anon_sym_default] = ACTIONS(257),
    [anon_sym_SEMI] = ACTIONS(259),
    [anon_sym_assert] = ACTIONS(257),
    [anon_sym_do] = ACTIONS(257),
    [anon_sym_while] = ACTIONS(257),
    [anon_sym_break] = ACTIONS(257),
    [anon_sym_continue] = ACTIONS(257),
    [anon_sym_return] = ACTIONS(257),
    [anon_sym_yield] = ACTIONS(257),
    [anon_sym_synchronized] = ACTIONS(257),
    [anon_sym_throw] = ACTIONS(257),
    [anon_sym_try] = ACTIONS(257),
    [anon_sym_if] = ACTIONS(257),
    [anon_sym_for] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(257),
    [anon_sym_open] = ACTIONS(257),
    [anon_sym_module] = ACTIONS(257),
    [anon_sym_static] = ACTIONS(257),
    [anon_sym_package] = ACTIONS(257),
    [anon_sym_import] = ACTIONS(257),
    [anon_sym_enum] = ACTIONS(257),
    [anon_sym_public] = ACTIONS(257),
    [anon_sym_protected] = ACTIONS(257),
    [anon_sym_private] = ACTIONS(257),
    [anon_sym_abstract] = ACTIONS(257),
    [anon_sym_strictfp] = ACTIONS(257),
    [anon_sym_native] = ACTIONS(257),
    [anon_sym_transient] = ACTIONS(257),
    [anon_sym_volatile] = ACTIONS(257),
    [anon_sym_sealed] = ACTIONS(257),
    [anon_sym_non_DASHsealed] = ACTIONS(259),
    [anon_sym_record] = ACTIONS(257),
    [anon_sym_ATinterface] = ACTIONS(259),
    [anon_sym_interface] = ACTIONS(257),
    [anon_sym_byte] = ACTIONS(257),
    [anon_sym_short] = ACTIONS(257),
    [anon_sym_int] = ACTIONS(257),
    [anon_sym_long] = ACTIONS(257),
    [anon_sym_char] = ACTIONS(257),
    [anon_sym_float] = ACTIONS(257),
    [anon_sym_double] = ACTIONS(257),
    [sym_boolean_type] = ACTIONS(257),
    [sym_void_type] = ACTIONS(257),
    [sym_this] = ACTIONS(257),
    [sym_super] = ACTIONS(257),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [78] = {
    [ts_builtin_sym_end] = ACTIONS(261),
    [sym_identifier] = ACTIONS(263),
    [sym_decimal_integer_literal] = ACTIONS(263),
    [sym_hex_integer_literal] = ACTIONS(263),
    [sym_octal_integer_literal] = ACTIONS(261),
    [sym_binary_integer_literal] = ACTIONS(261),
    [sym_decimal_floating_point_literal] = ACTIONS(261),
    [sym_hex_floating_point_literal] = ACTIONS(263),
    [sym_true] = ACTIONS(263),
    [sym_false] = ACTIONS(263),
    [sym_character_literal] = ACTIONS(261),
    [sym_string_literal] = ACTIONS(263),
    [sym_text_block] = ACTIONS(261),
    [sym_null_literal] = ACTIONS(263),
    [anon_sym_LPAREN] = ACTIONS(261),
    [anon_sym_AMP] = ACTIONS(263),
    [anon_sym_RPAREN] = ACTIONS(261),
    [anon_sym_GT] = ACTIONS(263),
    [anon_sym_LT] = ACTIONS(263),
    [anon_sym_GT_EQ] = ACTIONS(261),
    [anon_sym_LT_EQ] = ACTIONS(261),
    [anon_sym_EQ_EQ] = ACTIONS(261),
    [anon_sym_BANG_EQ] = ACTIONS(261),
    [anon_sym_AMP_AMP] = ACTIONS(261),
    [anon_sym_PIPE_PIPE] = ACTIONS(261),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_DASH] = ACTIONS(263),
    [anon_sym_STAR] = ACTIONS(261),
    [anon_sym_SLASH] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_CARET] = ACTIONS(261),
    [anon_sym_PERCENT] = ACTIONS(261),
    [anon_sym_LT_LT] = ACTIONS(261),
    [anon_sym_GT_GT] = ACTIONS(263),
    [anon_sym_GT_GT_GT] = ACTIONS(261),
    [anon_sym_instanceof] = ACTIONS(263),
    [anon_sym_final] = ACTIONS(263),
    [anon_sym_DASH_GT] = ACTIONS(261),
    [anon_sym_COMMA] = ACTIONS(261),
    [anon_sym_QMARK] = ACTIONS(261),
    [anon_sym_COLON] = ACTIONS(261),
    [anon_sym_BANG] = ACTIONS(263),
    [anon_sym_TILDE] = ACTIONS(261),
    [anon_sym_PLUS_PLUS] = ACTIONS(261),
    [anon_sym_DASH_DASH] = ACTIONS(261),
    [anon_sym_new] = ACTIONS(263),
    [anon_sym_RBRACK] = ACTIONS(261),
    [anon_sym_class] = ACTIONS(263),
    [anon_sym_switch] = ACTIONS(263),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_RBRACE] = ACTIONS(261),
    [anon_sym_case] = ACTIONS(263),
    [anon_sym_default] = ACTIONS(263),
    [anon_sym_SEMI] = ACTIONS(261),
    [anon_sym_assert] = ACTIONS(263),
    [anon_sym_do] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(263),
    [anon_sym_break] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(263),
    [anon_sym_return] = ACTIONS(263),
    [anon_sym_yield] = ACTIONS(263),
    [anon_sym_synchronized] = ACTIONS(263),
    [anon_sym_throw] = ACTIONS(263),
    [anon_sym_try] = ACTIONS(263),
    [anon_sym_if] = ACTIONS(263),
    [anon_sym_else] = ACTIONS(263),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_open] = ACTIONS(263),
    [anon_sym_module] = ACTIONS(263),
    [anon_sym_static] = ACTIONS(263),
    [anon_sym_package] = ACTIONS(263),
    [anon_sym_import] = ACTIONS(263),
    [anon_sym_enum] = ACTIONS(263),
    [anon_sym_public] = ACTIONS(263),
    [anon_sym_protected] = ACTIONS(263),
    [anon_sym_private] = ACTIONS(263),
    [anon_sym_abstract] = ACTIONS(263),
    [anon_sym_strictfp] = ACTIONS(263),
    [anon_sym_native] = ACTIONS(263),
    [anon_sym_transient] = ACTIONS(263),
    [anon_sym_volatile] = ACTIONS(263),
    [anon_sym_sealed] = ACTIONS(263),
    [anon_sym_non_DASHsealed] = ACTIONS(261),
    [anon_sym_record] = ACTIONS(263),
    [anon_sym_ATinterface] = ACTIONS(261),
    [anon_sym_interface] = ACTIONS(263),
    [anon_sym_byte] = ACTIONS(263),
    [anon_sym_short] = ACTIONS(263),
    [anon_sym_int] = ACTIONS(263),
    [anon_sym_long] = ACTIONS(263),
    [anon_sym_char] = ACTIONS(263),
    [anon_sym_float] = ACTIONS(263),
    [anon_sym_double] = ACTIONS(263),
    [sym_boolean_type] = ACTIONS(263),
    [sym_void_type] = ACTIONS(263),
    [sym_this] = ACTIONS(263),
    [sym_super] = ACTIONS(263),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [79] = {
    [ts_builtin_sym_end] = ACTIONS(265),
    [sym_identifier] = ACTIONS(267),
    [sym_decimal_integer_literal] = ACTIONS(267),
    [sym_hex_integer_literal] = ACTIONS(267),
    [sym_octal_integer_literal] = ACTIONS(265),
    [sym_binary_integer_literal] = ACTIONS(265),
    [sym_decimal_floating_point_literal] = ACTIONS(265),
    [sym_hex_floating_point_literal] = ACTIONS(267),
    [sym_true] = ACTIONS(267),
    [sym_false] = ACTIONS(267),
    [sym_character_literal] = ACTIONS(265),
    [sym_string_literal] = ACTIONS(267),
    [sym_text_block] = ACTIONS(265),
    [sym_null_literal] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(265),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_GT_EQ] = ACTIONS(265),
    [anon_sym_LT_EQ] = ACTIONS(265),
    [anon_sym_EQ_EQ] = ACTIONS(265),
    [anon_sym_BANG_EQ] = ACTIONS(265),
    [anon_sym_AMP_AMP] = ACTIONS(265),
    [anon_sym_PIPE_PIPE] = ACTIONS(265),
    [anon_sym_PLUS] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(265),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(265),
    [anon_sym_PERCENT] = ACTIONS(265),
    [anon_sym_LT_LT] = ACTIONS(265),
    [anon_sym_GT_GT] = ACTIONS(267),
    [anon_sym_GT_GT_GT] = ACTIONS(265),
    [anon_sym_instanceof] = ACTIONS(267),
    [anon_sym_final] = ACTIONS(267),
    [anon_sym_DASH_GT] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(265),
    [anon_sym_QMARK] = ACTIONS(265),
    [anon_sym_COLON] = ACTIONS(265),
    [anon_sym_BANG] = ACTIONS(267),
    [anon_sym_TILDE] = ACTIONS(265),
    [anon_sym_PLUS_PLUS] = ACTIONS(265),
    [anon_sym_DASH_DASH] = ACTIONS(265),
    [anon_sym_new] = ACTIONS(267),
    [anon_sym_RBRACK] = ACTIONS(265),
    [anon_sym_class] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(265),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_case] = ACTIONS(267),
    [anon_sym_default] = ACTIONS(267),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_assert] = ACTIONS(267),
    [anon_sym_do] = ACTIONS(267),
    [anon_sym_while] = ACTIONS(267),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_continue] = ACTIONS(267),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_yield] = ACTIONS(267),
    [anon_sym_synchronized] = ACTIONS(267),
    [anon_sym_throw] = ACTIONS(267),
    [anon_sym_try] = ACTIONS(267),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_else] = ACTIONS(267),
    [anon_sym_for] = ACTIONS(267),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_module] = ACTIONS(267),
    [anon_sym_static] = ACTIONS(267),
    [anon_sym_package] = ACTIONS(267),
    [anon_sym_import] = ACTIONS(267),
    [anon_sym_enum] = ACTIONS(267),
    [anon_sym_public] = ACTIONS(267),
    [anon_sym_protected] = ACTIONS(267),
    [anon_sym_private] = ACTIONS(267),
    [anon_sym_abstract] = ACTIONS(267),
    [anon_sym_strictfp] = ACTIONS(267),
    [anon_sym_native] = ACTIONS(267),
    [anon_sym_transient] = ACTIONS(267),
    [anon_sym_volatile] = ACTIONS(267),
    [anon_sym_sealed] = ACTIONS(267),
    [anon_sym_non_DASHsealed] = ACTIONS(265),
    [anon_sym_record] = ACTIONS(267),
    [anon_sym_ATinterface] = ACTIONS(265),
    [anon_sym_interface] = ACTIONS(267),
    [anon_sym_byte] = ACTIONS(267),
    [anon_sym_short] = ACTIONS(267),
    [anon_sym_int] = ACTIONS(267),
    [anon_sym_long] = ACTIONS(267),
    [anon_sym_char] = ACTIONS(267),
    [anon_sym_float] = ACTIONS(267),
    [anon_sym_double] = ACTIONS(267),
    [sym_boolean_type] = ACTIONS(267),
    [sym_void_type] = ACTIONS(267),
    [sym_this] = ACTIONS(267),
    [sym_super] = ACTIONS(267),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [80] = {
    [ts_builtin_sym_end] = ACTIONS(269),
    [sym_identifier] = ACTIONS(271),
    [sym_decimal_integer_literal] = ACTIONS(271),
    [sym_hex_integer_literal] = ACTIONS(271),
    [sym_octal_integer_literal] = ACTIONS(269),
    [sym_binary_integer_literal] = ACTIONS(269),
    [sym_decimal_floating_point_literal] = ACTIONS(269),
    [sym_hex_floating_point_literal] = ACTIONS(271),
    [sym_true] = ACTIONS(271),
    [sym_false] = ACTIONS(271),
    [sym_character_literal] = ACTIONS(269),
    [sym_string_literal] = ACTIONS(271),
    [sym_text_block] = ACTIONS(269),
    [sym_null_literal] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(269),
    [anon_sym_AMP] = ACTIONS(271),
    [anon_sym_RPAREN] = ACTIONS(269),
    [anon_sym_GT] = ACTIONS(271),
    [anon_sym_LT] = ACTIONS(271),
    [anon_sym_GT_EQ] = ACTIONS(269),
    [anon_sym_LT_EQ] = ACTIONS(269),
    [anon_sym_EQ_EQ] = ACTIONS(269),
    [anon_sym_BANG_EQ] = ACTIONS(269),
    [anon_sym_AMP_AMP] = ACTIONS(269),
    [anon_sym_PIPE_PIPE] = ACTIONS(269),
    [anon_sym_PLUS] = ACTIONS(271),
    [anon_sym_DASH] = ACTIONS(271),
    [anon_sym_STAR] = ACTIONS(269),
    [anon_sym_SLASH] = ACTIONS(271),
    [anon_sym_PIPE] = ACTIONS(271),
    [anon_sym_CARET] = ACTIONS(269),
    [anon_sym_PERCENT] = ACTIONS(269),
    [anon_sym_LT_LT] = ACTIONS(269),
    [anon_sym_GT_GT] = ACTIONS(271),
    [anon_sym_GT_GT_GT] = ACTIONS(269),
    [anon_sym_instanceof] = ACTIONS(271),
    [anon_sym_final] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(269),
    [anon_sym_COMMA] = ACTIONS(269),
    [anon_sym_QMARK] = ACTIONS(269),
    [anon_sym_COLON] = ACTIONS(269),
    [anon_sym_BANG] = ACTIONS(271),
    [anon_sym_TILDE] = ACTIONS(269),
    [anon_sym_PLUS_PLUS] = ACTIONS(269),
    [anon_sym_DASH_DASH] = ACTIONS(269),
    [anon_sym_new] = ACTIONS(271),
    [anon_sym_RBRACK] = ACTIONS(269),
    [anon_sym_class] = ACTIONS(271),
    [anon_sym_switch] = ACTIONS(271),
    [anon_sym_LBRACE] = ACTIONS(269),
    [anon_sym_RBRACE] = ACTIONS(269),
    [anon_sym_case] = ACTIONS(271),
    [anon_sym_default] = ACTIONS(271),
    [anon_sym_SEMI] = ACTIONS(269),
    [anon_sym_assert] = ACTIONS(271),
    [anon_sym_do] = ACTIONS(271),
    [anon_sym_while] = ACTIONS(271),
    [anon_sym_break] = ACTIONS(271),
    [anon_sym_continue] = ACTIONS(271),
    [anon_sym_return] = ACTIONS(271),
    [anon_sym_yield] = ACTIONS(271),
    [anon_sym_synchronized] = ACTIONS(271),
    [anon_sym_throw] = ACTIONS(271),
    [anon_sym_try] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(271),
    [anon_sym_else] = ACTIONS(271),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_AT] = ACTIONS(271),
    [anon_sym_open] = ACTIONS(271),
    [anon_sym_module] = ACTIONS(271),
    [anon_sym_static] = ACTIONS(271),
    [anon_sym_package] = ACTIONS(271),
    [anon_sym_import] = ACTIONS(271),
    [anon_sym_enum] = ACTIONS(271),
    [anon_sym_public] = ACTIONS(271),
    [anon_sym_protected] = ACTIONS(271),
    [anon_sym_private] = ACTIONS(271),
    [anon_sym_abstract] = ACTIONS(271),
    [anon_sym_strictfp] = ACTIONS(271),
    [anon_sym_native] = ACTIONS(271),
    [anon_sym_transient] = ACTIONS(271),
    [anon_sym_volatile] = ACTIONS(271),
    [anon_sym_sealed] = ACTIONS(271),
    [anon_sym_non_DASHsealed] = ACTIONS(269),
    [anon_sym_record] = ACTIONS(271),
    [anon_sym_ATinterface] = ACTIONS(269),
    [anon_sym_interface] = ACTIONS(271),
    [anon_sym_byte] = ACTIONS(271),
    [anon_sym_short] = ACTIONS(271),
    [anon_sym_int] = ACTIONS(271),
    [anon_sym_long] = ACTIONS(271),
    [anon_sym_char] = ACTIONS(271),
    [anon_sym_float] = ACTIONS(271),
    [anon_sym_double] = ACTIONS(271),
    [sym_boolean_type] = ACTIONS(271),
    [sym_void_type] = ACTIONS(271),
    [sym_this] = ACTIONS(271),
    [sym_super] = ACTIONS(271),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [81] = {
    [ts_builtin_sym_end] = ACTIONS(273),
    [sym_identifier] = ACTIONS(275),
    [sym_decimal_integer_literal] = ACTIONS(275),
    [sym_hex_integer_literal] = ACTIONS(275),
    [sym_octal_integer_literal] = ACTIONS(273),
    [sym_binary_integer_literal] = ACTIONS(273),
    [sym_decimal_floating_point_literal] = ACTIONS(273),
    [sym_hex_floating_point_literal] = ACTIONS(275),
    [sym_true] = ACTIONS(275),
    [sym_false] = ACTIONS(275),
    [sym_character_literal] = ACTIONS(273),
    [sym_string_literal] = ACTIONS(275),
    [sym_text_block] = ACTIONS(273),
    [sym_null_literal] = ACTIONS(275),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_AMP] = ACTIONS(275),
    [anon_sym_RPAREN] = ACTIONS(273),
    [anon_sym_GT] = ACTIONS(275),
    [anon_sym_LT] = ACTIONS(275),
    [anon_sym_GT_EQ] = ACTIONS(273),
    [anon_sym_LT_EQ] = ACTIONS(273),
    [anon_sym_EQ_EQ] = ACTIONS(273),
    [anon_sym_BANG_EQ] = ACTIONS(273),
    [anon_sym_AMP_AMP] = ACTIONS(273),
    [anon_sym_PIPE_PIPE] = ACTIONS(273),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(275),
    [anon_sym_STAR] = ACTIONS(273),
    [anon_sym_SLASH] = ACTIONS(275),
    [anon_sym_PIPE] = ACTIONS(275),
    [anon_sym_CARET] = ACTIONS(273),
    [anon_sym_PERCENT] = ACTIONS(273),
    [anon_sym_LT_LT] = ACTIONS(273),
    [anon_sym_GT_GT] = ACTIONS(275),
    [anon_sym_GT_GT_GT] = ACTIONS(273),
    [anon_sym_instanceof] = ACTIONS(275),
    [anon_sym_final] = ACTIONS(275),
    [anon_sym_DASH_GT] = ACTIONS(273),
    [anon_sym_COMMA] = ACTIONS(273),
    [anon_sym_QMARK] = ACTIONS(273),
    [anon_sym_COLON] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_PLUS_PLUS] = ACTIONS(273),
    [anon_sym_DASH_DASH] = ACTIONS(273),
    [anon_sym_new] = ACTIONS(275),
    [anon_sym_RBRACK] = ACTIONS(273),
    [anon_sym_class] = ACTIONS(275),
    [anon_sym_switch] = ACTIONS(275),
    [anon_sym_LBRACE] = ACTIONS(273),
    [anon_sym_RBRACE] = ACTIONS(273),
    [anon_sym_case] = ACTIONS(275),
    [anon_sym_default] = ACTIONS(275),
    [anon_sym_SEMI] = ACTIONS(273),
    [anon_sym_assert] = ACTIONS(275),
    [anon_sym_do] = ACTIONS(275),
    [anon_sym_while] = ACTIONS(275),
    [anon_sym_break] = ACTIONS(275),
    [anon_sym_continue] = ACTIONS(275),
    [anon_sym_return] = ACTIONS(275),
    [anon_sym_yield] = ACTIONS(275),
    [anon_sym_synchronized] = ACTIONS(275),
    [anon_sym_throw] = ACTIONS(275),
    [anon_sym_try] = ACTIONS(275),
    [anon_sym_if] = ACTIONS(275),
    [anon_sym_else] = ACTIONS(275),
    [anon_sym_for] = ACTIONS(275),
    [anon_sym_AT] = ACTIONS(275),
    [anon_sym_open] = ACTIONS(275),
    [anon_sym_module] = ACTIONS(275),
    [anon_sym_static] = ACTIONS(275),
    [anon_sym_package] = ACTIONS(275),
    [anon_sym_import] = ACTIONS(275),
    [anon_sym_enum] = ACTIONS(275),
    [anon_sym_public] = ACTIONS(275),
    [anon_sym_protected] = ACTIONS(275),
    [anon_sym_private] = ACTIONS(275),
    [anon_sym_abstract] = ACTIONS(275),
    [anon_sym_strictfp] = ACTIONS(275),
    [anon_sym_native] = ACTIONS(275),
    [anon_sym_transient] = ACTIONS(275),
    [anon_sym_volatile] = ACTIONS(275),
    [anon_sym_sealed] = ACTIONS(275),
    [anon_sym_non_DASHsealed] = ACTIONS(273),
    [anon_sym_record] = ACTIONS(275),
    [anon_sym_ATinterface] = ACTIONS(273),
    [anon_sym_interface] = ACTIONS(275),
    [anon_sym_byte] = ACTIONS(275),
    [anon_sym_short] = ACTIONS(275),
    [anon_sym_int] = ACTIONS(275),
    [anon_sym_long] = ACTIONS(275),
    [anon_sym_char] = ACTIONS(275),
    [anon_sym_float] = ACTIONS(275),
    [anon_sym_double] = ACTIONS(275),
    [sym_boolean_type] = ACTIONS(275),
    [sym_void_type] = ACTIONS(275),
    [sym_this] = ACTIONS(275),
    [sym_super] = ACTIONS(275),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [82] = {
    [ts_builtin_sym_end] = ACTIONS(277),
    [sym_identifier] = ACTIONS(279),
    [sym_decimal_integer_literal] = ACTIONS(279),
    [sym_hex_integer_literal] = ACTIONS(279),
    [sym_octal_integer_literal] = ACTIONS(277),
    [sym_binary_integer_literal] = ACTIONS(277),
    [sym_decimal_floating_point_literal] = ACTIONS(277),
    [sym_hex_floating_point_literal] = ACTIONS(279),
    [sym_true] = ACTIONS(279),
    [sym_false] = ACTIONS(279),
    [sym_character_literal] = ACTIONS(277),
    [sym_string_literal] = ACTIONS(279),
    [sym_text_block] = ACTIONS(277),
    [sym_null_literal] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_RPAREN] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_AMP_AMP] = ACTIONS(277),
    [anon_sym_PIPE_PIPE] = ACTIONS(277),
    [anon_sym_PLUS] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(277),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_GT_GT_GT] = ACTIONS(277),
    [anon_sym_instanceof] = ACTIONS(279),
    [anon_sym_final] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(277),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_QMARK] = ACTIONS(277),
    [anon_sym_COLON] = ACTIONS(277),
    [anon_sym_BANG] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(277),
    [anon_sym_PLUS_PLUS] = ACTIONS(277),
    [anon_sym_DASH_DASH] = ACTIONS(277),
    [anon_sym_new] = ACTIONS(279),
    [anon_sym_RBRACK] = ACTIONS(277),
    [anon_sym_class] = ACTIONS(279),
    [anon_sym_switch] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(277),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_case] = ACTIONS(279),
    [anon_sym_default] = ACTIONS(279),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_assert] = ACTIONS(279),
    [anon_sym_do] = ACTIONS(279),
    [anon_sym_while] = ACTIONS(279),
    [anon_sym_break] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(279),
    [anon_sym_return] = ACTIONS(279),
    [anon_sym_yield] = ACTIONS(279),
    [anon_sym_synchronized] = ACTIONS(279),
    [anon_sym_throw] = ACTIONS(279),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_else] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(279),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_static] = ACTIONS(279),
    [anon_sym_package] = ACTIONS(279),
    [anon_sym_import] = ACTIONS(279),
    [anon_sym_enum] = ACTIONS(279),
    [anon_sym_public] = ACTIONS(279),
    [anon_sym_protected] = ACTIONS(279),
    [anon_sym_private] = ACTIONS(279),
    [anon_sym_abstract] = ACTIONS(279),
    [anon_sym_strictfp] = ACTIONS(279),
    [anon_sym_native] = ACTIONS(279),
    [anon_sym_transient] = ACTIONS(279),
    [anon_sym_volatile] = ACTIONS(279),
    [anon_sym_sealed] = ACTIONS(279),
    [anon_sym_non_DASHsealed] = ACTIONS(277),
    [anon_sym_record] = ACTIONS(279),
    [anon_sym_ATinterface] = ACTIONS(277),
    [anon_sym_interface] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(279),
    [anon_sym_short] = ACTIONS(279),
    [anon_sym_int] = ACTIONS(279),
    [anon_sym_long] = ACTIONS(279),
    [anon_sym_char] = ACTIONS(279),
    [anon_sym_float] = ACTIONS(279),
    [anon_sym_double] = ACTIONS(279),
    [sym_boolean_type] = ACTIONS(279),
    [sym_void_type] = ACTIONS(279),
    [sym_this] = ACTIONS(279),
    [sym_super] = ACTIONS(279),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [83] = {
    [ts_builtin_sym_end] = ACTIONS(281),
    [sym_identifier] = ACTIONS(283),
    [sym_decimal_integer_literal] = ACTIONS(283),
    [sym_hex_integer_literal] = ACTIONS(283),
    [sym_octal_integer_literal] = ACTIONS(281),
    [sym_binary_integer_literal] = ACTIONS(281),
    [sym_decimal_floating_point_literal] = ACTIONS(281),
    [sym_hex_floating_point_literal] = ACTIONS(283),
    [sym_true] = ACTIONS(283),
    [sym_false] = ACTIONS(283),
    [sym_character_literal] = ACTIONS(281),
    [sym_string_literal] = ACTIONS(283),
    [sym_text_block] = ACTIONS(281),
    [sym_null_literal] = ACTIONS(283),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_AMP] = ACTIONS(285),
    [anon_sym_GT] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(285),
    [anon_sym_GT_EQ] = ACTIONS(287),
    [anon_sym_LT_EQ] = ACTIONS(287),
    [anon_sym_EQ_EQ] = ACTIONS(287),
    [anon_sym_BANG_EQ] = ACTIONS(287),
    [anon_sym_AMP_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(287),
    [anon_sym_PLUS] = ACTIONS(289),
    [anon_sym_DASH] = ACTIONS(289),
    [anon_sym_STAR] = ACTIONS(287),
    [anon_sym_SLASH] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_CARET] = ACTIONS(287),
    [anon_sym_PERCENT] = ACTIONS(287),
    [anon_sym_LT_LT] = ACTIONS(287),
    [anon_sym_GT_GT] = ACTIONS(285),
    [anon_sym_GT_GT_GT] = ACTIONS(287),
    [anon_sym_instanceof] = ACTIONS(285),
    [anon_sym_final] = ACTIONS(283),
    [anon_sym_QMARK] = ACTIONS(287),
    [anon_sym_BANG] = ACTIONS(283),
    [anon_sym_TILDE] = ACTIONS(281),
    [anon_sym_PLUS_PLUS] = ACTIONS(292),
    [anon_sym_DASH_DASH] = ACTIONS(292),
    [anon_sym_new] = ACTIONS(283),
    [anon_sym_class] = ACTIONS(283),
    [anon_sym_switch] = ACTIONS(283),
    [anon_sym_LBRACE] = ACTIONS(281),
    [anon_sym_RBRACE] = ACTIONS(281),
    [anon_sym_case] = ACTIONS(283),
    [anon_sym_default] = ACTIONS(283),
    [anon_sym_SEMI] = ACTIONS(292),
    [anon_sym_assert] = ACTIONS(283),
    [anon_sym_do] = ACTIONS(283),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_break] = ACTIONS(283),
    [anon_sym_continue] = ACTIONS(283),
    [anon_sym_return] = ACTIONS(283),
    [anon_sym_yield] = ACTIONS(283),
    [anon_sym_synchronized] = ACTIONS(283),
    [anon_sym_throw] = ACTIONS(283),
    [anon_sym_try] = ACTIONS(283),
    [anon_sym_if] = ACTIONS(283),
    [anon_sym_else] = ACTIONS(283),
    [anon_sym_for] = ACTIONS(283),
    [anon_sym_AT] = ACTIONS(283),
    [anon_sym_open] = ACTIONS(283),
    [anon_sym_module] = ACTIONS(283),
    [anon_sym_static] = ACTIONS(283),
    [anon_sym_package] = ACTIONS(283),
    [anon_sym_import] = ACTIONS(283),
    [anon_sym_enum] = ACTIONS(283),
    [anon_sym_public] = ACTIONS(283),
    [anon_sym_protected] = ACTIONS(283),
    [anon_sym_private] = ACTIONS(283),
    [anon_sym_abstract] = ACTIONS(283),
    [anon_sym_strictfp] = ACTIONS(283),
    [anon_sym_native] = ACTIONS(283),
    [anon_sym_transient] = ACTIONS(283),
    [anon_sym_volatile] = ACTIONS(283),
    [anon_sym_sealed] = ACTIONS(283),
    [anon_sym_non_DASHsealed] = ACTIONS(281),
    [anon_sym_record] = ACTIONS(283),
    [anon_sym_ATinterface] = ACTIONS(281),
    [anon_sym_interface] = ACTIONS(283),
    [anon_sym_byte] = ACTIONS(283),
    [anon_sym_short] = ACTIONS(283),
    [anon_sym_int] = ACTIONS(283),
    [anon_sym_long] = ACTIONS(283),
    [anon_sym_char] = ACTIONS(283),
    [anon_sym_float] = ACTIONS(283),
    [anon_sym_double] = ACTIONS(283),
    [sym_boolean_type] = ACTIONS(283),
    [sym_void_type] = ACTIONS(283),
    [sym_this] = ACTIONS(283),
    [sym_super] = ACTIONS(283),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [84] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(631),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(606),
    [sym_marker_annotation] = STATE(606),
    [sym_annotation] = STATE(606),
    [sym_modifiers] = STATE(703),
    [sym__type] = STATE(961),
    [sym__unannotated_type] = STATE(683),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_formal_parameter] = STATE(1003),
    [sym_receiver_parameter] = STATE(398),
    [sym_spread_parameter] = STATE(1003),
    [aux_sym_array_creation_expression_repeat1] = STATE(653),
    [aux_sym_modifiers_repeat1] = STATE(538),
    [sym_identifier] = ACTIONS(295),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(297),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(299),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(299),
    [anon_sym_synchronized] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_open] = ACTIONS(303),
    [anon_sym_module] = ACTIONS(303),
    [anon_sym_static] = ACTIONS(299),
    [anon_sym_public] = ACTIONS(299),
    [anon_sym_protected] = ACTIONS(299),
    [anon_sym_private] = ACTIONS(299),
    [anon_sym_abstract] = ACTIONS(299),
    [anon_sym_strictfp] = ACTIONS(299),
    [anon_sym_native] = ACTIONS(299),
    [anon_sym_transient] = ACTIONS(299),
    [anon_sym_volatile] = ACTIONS(299),
    [anon_sym_sealed] = ACTIONS(299),
    [anon_sym_non_DASHsealed] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(303),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [85] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(631),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(606),
    [sym_marker_annotation] = STATE(606),
    [sym_annotation] = STATE(606),
    [sym_modifiers] = STATE(703),
    [sym__type] = STATE(948),
    [sym__unannotated_type] = STATE(683),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_formal_parameter] = STATE(1003),
    [sym_receiver_parameter] = STATE(398),
    [sym_spread_parameter] = STATE(1003),
    [aux_sym_array_creation_expression_repeat1] = STATE(653),
    [aux_sym_modifiers_repeat1] = STATE(538),
    [sym_identifier] = ACTIONS(295),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(297),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(299),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(299),
    [anon_sym_synchronized] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_open] = ACTIONS(303),
    [anon_sym_module] = ACTIONS(303),
    [anon_sym_static] = ACTIONS(299),
    [anon_sym_public] = ACTIONS(299),
    [anon_sym_protected] = ACTIONS(299),
    [anon_sym_private] = ACTIONS(299),
    [anon_sym_abstract] = ACTIONS(299),
    [anon_sym_strictfp] = ACTIONS(299),
    [anon_sym_native] = ACTIONS(299),
    [anon_sym_transient] = ACTIONS(299),
    [anon_sym_volatile] = ACTIONS(299),
    [anon_sym_sealed] = ACTIONS(299),
    [anon_sym_non_DASHsealed] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(303),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [86] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(552),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(606),
    [sym_marker_annotation] = STATE(606),
    [sym_annotation] = STATE(606),
    [sym_modifiers] = STATE(696),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(690),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(277),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [aux_sym_modifiers_repeat1] = STATE(538),
    [sym_identifier] = ACTIONS(307),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(299),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(299),
    [anon_sym_SEMI] = ACTIONS(309),
    [anon_sym_synchronized] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_static] = ACTIONS(299),
    [anon_sym_public] = ACTIONS(299),
    [anon_sym_protected] = ACTIONS(299),
    [anon_sym_private] = ACTIONS(299),
    [anon_sym_abstract] = ACTIONS(299),
    [anon_sym_strictfp] = ACTIONS(299),
    [anon_sym_native] = ACTIONS(299),
    [anon_sym_transient] = ACTIONS(299),
    [anon_sym_volatile] = ACTIONS(299),
    [anon_sym_sealed] = ACTIONS(299),
    [anon_sym_non_DASHsealed] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [87] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(553),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(606),
    [sym_marker_annotation] = STATE(606),
    [sym_annotation] = STATE(606),
    [sym_modifiers] = STATE(697),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(692),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [sym_local_variable_declaration] = STATE(264),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [aux_sym_modifiers_repeat1] = STATE(538),
    [sym_identifier] = ACTIONS(307),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_final] = ACTIONS(299),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(299),
    [anon_sym_SEMI] = ACTIONS(313),
    [anon_sym_synchronized] = ACTIONS(299),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_static] = ACTIONS(299),
    [anon_sym_public] = ACTIONS(299),
    [anon_sym_protected] = ACTIONS(299),
    [anon_sym_private] = ACTIONS(299),
    [anon_sym_abstract] = ACTIONS(299),
    [anon_sym_strictfp] = ACTIONS(299),
    [anon_sym_native] = ACTIONS(299),
    [anon_sym_transient] = ACTIONS(299),
    [anon_sym_volatile] = ACTIONS(299),
    [anon_sym_sealed] = ACTIONS(299),
    [anon_sym_non_DASHsealed] = ACTIONS(305),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [88] = {
    [sym_catch_clause] = STATE(89),
    [sym_finally_clause] = STATE(187),
    [aux_sym_try_statement_repeat1] = STATE(89),
    [ts_builtin_sym_end] = ACTIONS(315),
    [sym_identifier] = ACTIONS(317),
    [sym_decimal_integer_literal] = ACTIONS(317),
    [sym_hex_integer_literal] = ACTIONS(317),
    [sym_octal_integer_literal] = ACTIONS(315),
    [sym_binary_integer_literal] = ACTIONS(315),
    [sym_decimal_floating_point_literal] = ACTIONS(315),
    [sym_hex_floating_point_literal] = ACTIONS(317),
    [sym_true] = ACTIONS(317),
    [sym_false] = ACTIONS(317),
    [sym_character_literal] = ACTIONS(315),
    [sym_string_literal] = ACTIONS(317),
    [sym_text_block] = ACTIONS(315),
    [sym_null_literal] = ACTIONS(317),
    [anon_sym_LPAREN] = ACTIONS(315),
    [anon_sym_PLUS] = ACTIONS(317),
    [anon_sym_DASH] = ACTIONS(317),
    [anon_sym_final] = ACTIONS(317),
    [anon_sym_BANG] = ACTIONS(315),
    [anon_sym_TILDE] = ACTIONS(315),
    [anon_sym_PLUS_PLUS] = ACTIONS(315),
    [anon_sym_DASH_DASH] = ACTIONS(315),
    [anon_sym_new] = ACTIONS(317),
    [anon_sym_class] = ACTIONS(317),
    [anon_sym_switch] = ACTIONS(317),
    [anon_sym_LBRACE] = ACTIONS(315),
    [anon_sym_RBRACE] = ACTIONS(315),
    [anon_sym_case] = ACTIONS(317),
    [anon_sym_default] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(315),
    [anon_sym_assert] = ACTIONS(317),
    [anon_sym_do] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_break] = ACTIONS(317),
    [anon_sym_continue] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_yield] = ACTIONS(317),
    [anon_sym_synchronized] = ACTIONS(317),
    [anon_sym_throw] = ACTIONS(317),
    [anon_sym_try] = ACTIONS(317),
    [anon_sym_catch] = ACTIONS(319),
    [anon_sym_finally] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_else] = ACTIONS(317),
    [anon_sym_for] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_open] = ACTIONS(317),
    [anon_sym_module] = ACTIONS(317),
    [anon_sym_static] = ACTIONS(317),
    [anon_sym_package] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(317),
    [anon_sym_enum] = ACTIONS(317),
    [anon_sym_public] = ACTIONS(317),
    [anon_sym_protected] = ACTIONS(317),
    [anon_sym_private] = ACTIONS(317),
    [anon_sym_abstract] = ACTIONS(317),
    [anon_sym_strictfp] = ACTIONS(317),
    [anon_sym_native] = ACTIONS(317),
    [anon_sym_transient] = ACTIONS(317),
    [anon_sym_volatile] = ACTIONS(317),
    [anon_sym_sealed] = ACTIONS(317),
    [anon_sym_non_DASHsealed] = ACTIONS(315),
    [anon_sym_record] = ACTIONS(317),
    [anon_sym_ATinterface] = ACTIONS(315),
    [anon_sym_interface] = ACTIONS(317),
    [anon_sym_byte] = ACTIONS(317),
    [anon_sym_short] = ACTIONS(317),
    [anon_sym_int] = ACTIONS(317),
    [anon_sym_long] = ACTIONS(317),
    [anon_sym_char] = ACTIONS(317),
    [anon_sym_float] = ACTIONS(317),
    [anon_sym_double] = ACTIONS(317),
    [sym_boolean_type] = ACTIONS(317),
    [sym_void_type] = ACTIONS(317),
    [sym_this] = ACTIONS(317),
    [sym_super] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [89] = {
    [sym_catch_clause] = STATE(91),
    [sym_finally_clause] = STATE(241),
    [aux_sym_try_statement_repeat1] = STATE(91),
    [ts_builtin_sym_end] = ACTIONS(323),
    [sym_identifier] = ACTIONS(325),
    [sym_decimal_integer_literal] = ACTIONS(325),
    [sym_hex_integer_literal] = ACTIONS(325),
    [sym_octal_integer_literal] = ACTIONS(323),
    [sym_binary_integer_literal] = ACTIONS(323),
    [sym_decimal_floating_point_literal] = ACTIONS(323),
    [sym_hex_floating_point_literal] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_character_literal] = ACTIONS(323),
    [sym_string_literal] = ACTIONS(325),
    [sym_text_block] = ACTIONS(323),
    [sym_null_literal] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(323),
    [anon_sym_PLUS] = ACTIONS(325),
    [anon_sym_DASH] = ACTIONS(325),
    [anon_sym_final] = ACTIONS(325),
    [anon_sym_BANG] = ACTIONS(323),
    [anon_sym_TILDE] = ACTIONS(323),
    [anon_sym_PLUS_PLUS] = ACTIONS(323),
    [anon_sym_DASH_DASH] = ACTIONS(323),
    [anon_sym_new] = ACTIONS(325),
    [anon_sym_class] = ACTIONS(325),
    [anon_sym_switch] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(323),
    [anon_sym_RBRACE] = ACTIONS(323),
    [anon_sym_case] = ACTIONS(325),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_SEMI] = ACTIONS(323),
    [anon_sym_assert] = ACTIONS(325),
    [anon_sym_do] = ACTIONS(325),
    [anon_sym_while] = ACTIONS(325),
    [anon_sym_break] = ACTIONS(325),
    [anon_sym_continue] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(325),
    [anon_sym_yield] = ACTIONS(325),
    [anon_sym_synchronized] = ACTIONS(325),
    [anon_sym_throw] = ACTIONS(325),
    [anon_sym_try] = ACTIONS(325),
    [anon_sym_catch] = ACTIONS(319),
    [anon_sym_finally] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(325),
    [anon_sym_else] = ACTIONS(325),
    [anon_sym_for] = ACTIONS(325),
    [anon_sym_AT] = ACTIONS(325),
    [anon_sym_open] = ACTIONS(325),
    [anon_sym_module] = ACTIONS(325),
    [anon_sym_static] = ACTIONS(325),
    [anon_sym_package] = ACTIONS(325),
    [anon_sym_import] = ACTIONS(325),
    [anon_sym_enum] = ACTIONS(325),
    [anon_sym_public] = ACTIONS(325),
    [anon_sym_protected] = ACTIONS(325),
    [anon_sym_private] = ACTIONS(325),
    [anon_sym_abstract] = ACTIONS(325),
    [anon_sym_strictfp] = ACTIONS(325),
    [anon_sym_native] = ACTIONS(325),
    [anon_sym_transient] = ACTIONS(325),
    [anon_sym_volatile] = ACTIONS(325),
    [anon_sym_sealed] = ACTIONS(325),
    [anon_sym_non_DASHsealed] = ACTIONS(323),
    [anon_sym_record] = ACTIONS(325),
    [anon_sym_ATinterface] = ACTIONS(323),
    [anon_sym_interface] = ACTIONS(325),
    [anon_sym_byte] = ACTIONS(325),
    [anon_sym_short] = ACTIONS(325),
    [anon_sym_int] = ACTIONS(325),
    [anon_sym_long] = ACTIONS(325),
    [anon_sym_char] = ACTIONS(325),
    [anon_sym_float] = ACTIONS(325),
    [anon_sym_double] = ACTIONS(325),
    [sym_boolean_type] = ACTIONS(325),
    [sym_void_type] = ACTIONS(325),
    [sym_this] = ACTIONS(325),
    [sym_super] = ACTIONS(325),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [90] = {
    [sym_catch_clause] = STATE(91),
    [sym_finally_clause] = STATE(188),
    [aux_sym_try_statement_repeat1] = STATE(91),
    [ts_builtin_sym_end] = ACTIONS(327),
    [sym_identifier] = ACTIONS(329),
    [sym_decimal_integer_literal] = ACTIONS(329),
    [sym_hex_integer_literal] = ACTIONS(329),
    [sym_octal_integer_literal] = ACTIONS(327),
    [sym_binary_integer_literal] = ACTIONS(327),
    [sym_decimal_floating_point_literal] = ACTIONS(327),
    [sym_hex_floating_point_literal] = ACTIONS(329),
    [sym_true] = ACTIONS(329),
    [sym_false] = ACTIONS(329),
    [sym_character_literal] = ACTIONS(327),
    [sym_string_literal] = ACTIONS(329),
    [sym_text_block] = ACTIONS(327),
    [sym_null_literal] = ACTIONS(329),
    [anon_sym_LPAREN] = ACTIONS(327),
    [anon_sym_PLUS] = ACTIONS(329),
    [anon_sym_DASH] = ACTIONS(329),
    [anon_sym_final] = ACTIONS(329),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_TILDE] = ACTIONS(327),
    [anon_sym_PLUS_PLUS] = ACTIONS(327),
    [anon_sym_DASH_DASH] = ACTIONS(327),
    [anon_sym_new] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(329),
    [anon_sym_switch] = ACTIONS(329),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_RBRACE] = ACTIONS(327),
    [anon_sym_case] = ACTIONS(329),
    [anon_sym_default] = ACTIONS(329),
    [anon_sym_SEMI] = ACTIONS(327),
    [anon_sym_assert] = ACTIONS(329),
    [anon_sym_do] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(329),
    [anon_sym_break] = ACTIONS(329),
    [anon_sym_continue] = ACTIONS(329),
    [anon_sym_return] = ACTIONS(329),
    [anon_sym_yield] = ACTIONS(329),
    [anon_sym_synchronized] = ACTIONS(329),
    [anon_sym_throw] = ACTIONS(329),
    [anon_sym_try] = ACTIONS(329),
    [anon_sym_catch] = ACTIONS(319),
    [anon_sym_finally] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(329),
    [anon_sym_else] = ACTIONS(329),
    [anon_sym_for] = ACTIONS(329),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_open] = ACTIONS(329),
    [anon_sym_module] = ACTIONS(329),
    [anon_sym_static] = ACTIONS(329),
    [anon_sym_package] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(329),
    [anon_sym_enum] = ACTIONS(329),
    [anon_sym_public] = ACTIONS(329),
    [anon_sym_protected] = ACTIONS(329),
    [anon_sym_private] = ACTIONS(329),
    [anon_sym_abstract] = ACTIONS(329),
    [anon_sym_strictfp] = ACTIONS(329),
    [anon_sym_native] = ACTIONS(329),
    [anon_sym_transient] = ACTIONS(329),
    [anon_sym_volatile] = ACTIONS(329),
    [anon_sym_sealed] = ACTIONS(329),
    [anon_sym_non_DASHsealed] = ACTIONS(327),
    [anon_sym_record] = ACTIONS(329),
    [anon_sym_ATinterface] = ACTIONS(327),
    [anon_sym_interface] = ACTIONS(329),
    [anon_sym_byte] = ACTIONS(329),
    [anon_sym_short] = ACTIONS(329),
    [anon_sym_int] = ACTIONS(329),
    [anon_sym_long] = ACTIONS(329),
    [anon_sym_char] = ACTIONS(329),
    [anon_sym_float] = ACTIONS(329),
    [anon_sym_double] = ACTIONS(329),
    [sym_boolean_type] = ACTIONS(329),
    [sym_void_type] = ACTIONS(329),
    [sym_this] = ACTIONS(329),
    [sym_super] = ACTIONS(329),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [91] = {
    [sym_catch_clause] = STATE(91),
    [aux_sym_try_statement_repeat1] = STATE(91),
    [ts_builtin_sym_end] = ACTIONS(331),
    [sym_identifier] = ACTIONS(333),
    [sym_decimal_integer_literal] = ACTIONS(333),
    [sym_hex_integer_literal] = ACTIONS(333),
    [sym_octal_integer_literal] = ACTIONS(331),
    [sym_binary_integer_literal] = ACTIONS(331),
    [sym_decimal_floating_point_literal] = ACTIONS(331),
    [sym_hex_floating_point_literal] = ACTIONS(333),
    [sym_true] = ACTIONS(333),
    [sym_false] = ACTIONS(333),
    [sym_character_literal] = ACTIONS(331),
    [sym_string_literal] = ACTIONS(333),
    [sym_text_block] = ACTIONS(331),
    [sym_null_literal] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_PLUS] = ACTIONS(333),
    [anon_sym_DASH] = ACTIONS(333),
    [anon_sym_final] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_TILDE] = ACTIONS(331),
    [anon_sym_PLUS_PLUS] = ACTIONS(331),
    [anon_sym_DASH_DASH] = ACTIONS(331),
    [anon_sym_new] = ACTIONS(333),
    [anon_sym_class] = ACTIONS(333),
    [anon_sym_switch] = ACTIONS(333),
    [anon_sym_LBRACE] = ACTIONS(331),
    [anon_sym_RBRACE] = ACTIONS(331),
    [anon_sym_case] = ACTIONS(333),
    [anon_sym_default] = ACTIONS(333),
    [anon_sym_SEMI] = ACTIONS(331),
    [anon_sym_assert] = ACTIONS(333),
    [anon_sym_do] = ACTIONS(333),
    [anon_sym_while] = ACTIONS(333),
    [anon_sym_break] = ACTIONS(333),
    [anon_sym_continue] = ACTIONS(333),
    [anon_sym_return] = ACTIONS(333),
    [anon_sym_yield] = ACTIONS(333),
    [anon_sym_synchronized] = ACTIONS(333),
    [anon_sym_throw] = ACTIONS(333),
    [anon_sym_try] = ACTIONS(333),
    [anon_sym_catch] = ACTIONS(335),
    [anon_sym_finally] = ACTIONS(333),
    [anon_sym_if] = ACTIONS(333),
    [anon_sym_else] = ACTIONS(333),
    [anon_sym_for] = ACTIONS(333),
    [anon_sym_AT] = ACTIONS(333),
    [anon_sym_open] = ACTIONS(333),
    [anon_sym_module] = ACTIONS(333),
    [anon_sym_static] = ACTIONS(333),
    [anon_sym_package] = ACTIONS(333),
    [anon_sym_import] = ACTIONS(333),
    [anon_sym_enum] = ACTIONS(333),
    [anon_sym_public] = ACTIONS(333),
    [anon_sym_protected] = ACTIONS(333),
    [anon_sym_private] = ACTIONS(333),
    [anon_sym_abstract] = ACTIONS(333),
    [anon_sym_strictfp] = ACTIONS(333),
    [anon_sym_native] = ACTIONS(333),
    [anon_sym_transient] = ACTIONS(333),
    [anon_sym_volatile] = ACTIONS(333),
    [anon_sym_sealed] = ACTIONS(333),
    [anon_sym_non_DASHsealed] = ACTIONS(331),
    [anon_sym_record] = ACTIONS(333),
    [anon_sym_ATinterface] = ACTIONS(331),
    [anon_sym_interface] = ACTIONS(333),
    [anon_sym_byte] = ACTIONS(333),
    [anon_sym_short] = ACTIONS(333),
    [anon_sym_int] = ACTIONS(333),
    [anon_sym_long] = ACTIONS(333),
    [anon_sym_char] = ACTIONS(333),
    [anon_sym_float] = ACTIONS(333),
    [anon_sym_double] = ACTIONS(333),
    [sym_boolean_type] = ACTIONS(333),
    [sym_void_type] = ACTIONS(333),
    [sym_this] = ACTIONS(333),
    [sym_super] = ACTIONS(333),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [92] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(544),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(710),
    [sym_marker_annotation] = STATE(710),
    [sym_annotation] = STATE(710),
    [sym_element_value_pair] = STATE(973),
    [sym__element_value] = STATE(1247),
    [sym_element_value_array_initializer] = STATE(1247),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(338),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(340),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [93] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(544),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(710),
    [sym_marker_annotation] = STATE(710),
    [sym_annotation] = STATE(710),
    [sym_element_value_pair] = STATE(975),
    [sym__element_value] = STATE(1217),
    [sym_element_value_array_initializer] = STATE(1217),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(338),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(346),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [94] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(544),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(710),
    [sym_marker_annotation] = STATE(710),
    [sym_annotation] = STATE(710),
    [sym__element_value] = STATE(1008),
    [sym_element_value_array_initializer] = STATE(1008),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(307),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(348),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_RBRACE] = ACTIONS(350),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [95] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(544),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(710),
    [sym_marker_annotation] = STATE(710),
    [sym_annotation] = STATE(710),
    [sym_element_value_pair] = STATE(1010),
    [sym__element_value] = STATE(1207),
    [sym_element_value_array_initializer] = STATE(1207),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(338),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(352),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [96] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(616),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym_block] = STATE(1057),
    [sym_expression_statement] = STATE(1057),
    [sym_throw_statement] = STATE(1057),
    [sym__annotation] = STATE(661),
    [sym_marker_annotation] = STATE(661),
    [sym_annotation] = STATE(661),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(307),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [97] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(544),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(710),
    [sym_marker_annotation] = STATE(710),
    [sym_annotation] = STATE(710),
    [sym__element_value] = STATE(1083),
    [sym_element_value_array_initializer] = STATE(1083),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(307),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_RBRACE] = ACTIONS(354),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [98] = {
    [ts_builtin_sym_end] = ACTIONS(265),
    [sym_identifier] = ACTIONS(267),
    [sym_decimal_integer_literal] = ACTIONS(267),
    [sym_hex_integer_literal] = ACTIONS(267),
    [sym_octal_integer_literal] = ACTIONS(265),
    [sym_binary_integer_literal] = ACTIONS(265),
    [sym_decimal_floating_point_literal] = ACTIONS(265),
    [sym_hex_floating_point_literal] = ACTIONS(267),
    [sym_true] = ACTIONS(267),
    [sym_false] = ACTIONS(267),
    [sym_character_literal] = ACTIONS(265),
    [sym_string_literal] = ACTIONS(267),
    [sym_text_block] = ACTIONS(265),
    [sym_null_literal] = ACTIONS(267),
    [anon_sym_LPAREN] = ACTIONS(265),
    [anon_sym_PLUS] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(267),
    [anon_sym_final] = ACTIONS(267),
    [anon_sym_BANG] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(265),
    [anon_sym_PLUS_PLUS] = ACTIONS(265),
    [anon_sym_DASH_DASH] = ACTIONS(265),
    [anon_sym_new] = ACTIONS(267),
    [anon_sym_class] = ACTIONS(267),
    [anon_sym_switch] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(265),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_case] = ACTIONS(267),
    [anon_sym_default] = ACTIONS(267),
    [anon_sym_SEMI] = ACTIONS(265),
    [anon_sym_assert] = ACTIONS(267),
    [anon_sym_do] = ACTIONS(267),
    [anon_sym_while] = ACTIONS(267),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_continue] = ACTIONS(267),
    [anon_sym_return] = ACTIONS(267),
    [anon_sym_yield] = ACTIONS(267),
    [anon_sym_synchronized] = ACTIONS(267),
    [anon_sym_throw] = ACTIONS(267),
    [anon_sym_try] = ACTIONS(267),
    [anon_sym_catch] = ACTIONS(267),
    [anon_sym_finally] = ACTIONS(267),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_else] = ACTIONS(267),
    [anon_sym_for] = ACTIONS(267),
    [anon_sym_AT] = ACTIONS(267),
    [anon_sym_open] = ACTIONS(267),
    [anon_sym_module] = ACTIONS(267),
    [anon_sym_static] = ACTIONS(267),
    [anon_sym_package] = ACTIONS(267),
    [anon_sym_import] = ACTIONS(267),
    [anon_sym_enum] = ACTIONS(267),
    [anon_sym_public] = ACTIONS(267),
    [anon_sym_protected] = ACTIONS(267),
    [anon_sym_private] = ACTIONS(267),
    [anon_sym_abstract] = ACTIONS(267),
    [anon_sym_strictfp] = ACTIONS(267),
    [anon_sym_native] = ACTIONS(267),
    [anon_sym_transient] = ACTIONS(267),
    [anon_sym_volatile] = ACTIONS(267),
    [anon_sym_sealed] = ACTIONS(267),
    [anon_sym_non_DASHsealed] = ACTIONS(265),
    [anon_sym_record] = ACTIONS(267),
    [anon_sym_ATinterface] = ACTIONS(265),
    [anon_sym_interface] = ACTIONS(267),
    [anon_sym_byte] = ACTIONS(267),
    [anon_sym_short] = ACTIONS(267),
    [anon_sym_int] = ACTIONS(267),
    [anon_sym_long] = ACTIONS(267),
    [anon_sym_char] = ACTIONS(267),
    [anon_sym_float] = ACTIONS(267),
    [anon_sym_double] = ACTIONS(267),
    [sym_boolean_type] = ACTIONS(267),
    [sym_void_type] = ACTIONS(267),
    [sym_this] = ACTIONS(267),
    [sym_super] = ACTIONS(267),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [99] = {
    [ts_builtin_sym_end] = ACTIONS(277),
    [sym_identifier] = ACTIONS(279),
    [sym_decimal_integer_literal] = ACTIONS(279),
    [sym_hex_integer_literal] = ACTIONS(279),
    [sym_octal_integer_literal] = ACTIONS(277),
    [sym_binary_integer_literal] = ACTIONS(277),
    [sym_decimal_floating_point_literal] = ACTIONS(277),
    [sym_hex_floating_point_literal] = ACTIONS(279),
    [sym_true] = ACTIONS(279),
    [sym_false] = ACTIONS(279),
    [sym_character_literal] = ACTIONS(277),
    [sym_string_literal] = ACTIONS(279),
    [sym_text_block] = ACTIONS(277),
    [sym_null_literal] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(277),
    [anon_sym_PLUS] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_final] = ACTIONS(279),
    [anon_sym_BANG] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(277),
    [anon_sym_PLUS_PLUS] = ACTIONS(277),
    [anon_sym_DASH_DASH] = ACTIONS(277),
    [anon_sym_new] = ACTIONS(279),
    [anon_sym_class] = ACTIONS(279),
    [anon_sym_switch] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(277),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_case] = ACTIONS(279),
    [anon_sym_default] = ACTIONS(279),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_assert] = ACTIONS(279),
    [anon_sym_do] = ACTIONS(279),
    [anon_sym_while] = ACTIONS(279),
    [anon_sym_break] = ACTIONS(279),
    [anon_sym_continue] = ACTIONS(279),
    [anon_sym_return] = ACTIONS(279),
    [anon_sym_yield] = ACTIONS(279),
    [anon_sym_synchronized] = ACTIONS(279),
    [anon_sym_throw] = ACTIONS(279),
    [anon_sym_try] = ACTIONS(279),
    [anon_sym_catch] = ACTIONS(279),
    [anon_sym_finally] = ACTIONS(279),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_else] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(279),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_static] = ACTIONS(279),
    [anon_sym_package] = ACTIONS(279),
    [anon_sym_import] = ACTIONS(279),
    [anon_sym_enum] = ACTIONS(279),
    [anon_sym_public] = ACTIONS(279),
    [anon_sym_protected] = ACTIONS(279),
    [anon_sym_private] = ACTIONS(279),
    [anon_sym_abstract] = ACTIONS(279),
    [anon_sym_strictfp] = ACTIONS(279),
    [anon_sym_native] = ACTIONS(279),
    [anon_sym_transient] = ACTIONS(279),
    [anon_sym_volatile] = ACTIONS(279),
    [anon_sym_sealed] = ACTIONS(279),
    [anon_sym_non_DASHsealed] = ACTIONS(277),
    [anon_sym_record] = ACTIONS(279),
    [anon_sym_ATinterface] = ACTIONS(277),
    [anon_sym_interface] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(279),
    [anon_sym_short] = ACTIONS(279),
    [anon_sym_int] = ACTIONS(279),
    [anon_sym_long] = ACTIONS(279),
    [anon_sym_char] = ACTIONS(279),
    [anon_sym_float] = ACTIONS(279),
    [anon_sym_double] = ACTIONS(279),
    [sym_boolean_type] = ACTIONS(279),
    [sym_void_type] = ACTIONS(279),
    [sym_this] = ACTIONS(279),
    [sym_super] = ACTIONS(279),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [100] = {
    [ts_builtin_sym_end] = ACTIONS(356),
    [sym_identifier] = ACTIONS(358),
    [sym_decimal_integer_literal] = ACTIONS(358),
    [sym_hex_integer_literal] = ACTIONS(358),
    [sym_octal_integer_literal] = ACTIONS(356),
    [sym_binary_integer_literal] = ACTIONS(356),
    [sym_decimal_floating_point_literal] = ACTIONS(356),
    [sym_hex_floating_point_literal] = ACTIONS(358),
    [sym_true] = ACTIONS(358),
    [sym_false] = ACTIONS(358),
    [sym_character_literal] = ACTIONS(356),
    [sym_string_literal] = ACTIONS(358),
    [sym_text_block] = ACTIONS(356),
    [sym_null_literal] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(356),
    [anon_sym_PLUS] = ACTIONS(358),
    [anon_sym_DASH] = ACTIONS(358),
    [anon_sym_final] = ACTIONS(358),
    [anon_sym_BANG] = ACTIONS(356),
    [anon_sym_TILDE] = ACTIONS(356),
    [anon_sym_PLUS_PLUS] = ACTIONS(356),
    [anon_sym_DASH_DASH] = ACTIONS(356),
    [anon_sym_new] = ACTIONS(358),
    [anon_sym_class] = ACTIONS(358),
    [anon_sym_switch] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(356),
    [anon_sym_RBRACE] = ACTIONS(356),
    [anon_sym_case] = ACTIONS(358),
    [anon_sym_default] = ACTIONS(358),
    [anon_sym_SEMI] = ACTIONS(356),
    [anon_sym_assert] = ACTIONS(358),
    [anon_sym_do] = ACTIONS(358),
    [anon_sym_while] = ACTIONS(358),
    [anon_sym_break] = ACTIONS(358),
    [anon_sym_continue] = ACTIONS(358),
    [anon_sym_return] = ACTIONS(358),
    [anon_sym_yield] = ACTIONS(358),
    [anon_sym_synchronized] = ACTIONS(358),
    [anon_sym_throw] = ACTIONS(358),
    [anon_sym_try] = ACTIONS(358),
    [anon_sym_catch] = ACTIONS(358),
    [anon_sym_finally] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(358),
    [anon_sym_else] = ACTIONS(358),
    [anon_sym_for] = ACTIONS(358),
    [anon_sym_AT] = ACTIONS(358),
    [anon_sym_open] = ACTIONS(358),
    [anon_sym_module] = ACTIONS(358),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_package] = ACTIONS(358),
    [anon_sym_import] = ACTIONS(358),
    [anon_sym_enum] = ACTIONS(358),
    [anon_sym_public] = ACTIONS(358),
    [anon_sym_protected] = ACTIONS(358),
    [anon_sym_private] = ACTIONS(358),
    [anon_sym_abstract] = ACTIONS(358),
    [anon_sym_strictfp] = ACTIONS(358),
    [anon_sym_native] = ACTIONS(358),
    [anon_sym_transient] = ACTIONS(358),
    [anon_sym_volatile] = ACTIONS(358),
    [anon_sym_sealed] = ACTIONS(358),
    [anon_sym_non_DASHsealed] = ACTIONS(356),
    [anon_sym_record] = ACTIONS(358),
    [anon_sym_ATinterface] = ACTIONS(356),
    [anon_sym_interface] = ACTIONS(358),
    [anon_sym_byte] = ACTIONS(358),
    [anon_sym_short] = ACTIONS(358),
    [anon_sym_int] = ACTIONS(358),
    [anon_sym_long] = ACTIONS(358),
    [anon_sym_char] = ACTIONS(358),
    [anon_sym_float] = ACTIONS(358),
    [anon_sym_double] = ACTIONS(358),
    [sym_boolean_type] = ACTIONS(358),
    [sym_void_type] = ACTIONS(358),
    [sym_this] = ACTIONS(358),
    [sym_super] = ACTIONS(358),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [101] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(554),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(661),
    [sym_marker_annotation] = STATE(661),
    [sym_annotation] = STATE(661),
    [sym_array_initializer] = STATE(1063),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(307),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(360),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_RBRACE] = ACTIONS(364),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [102] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(544),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(710),
    [sym_marker_annotation] = STATE(710),
    [sym_annotation] = STATE(710),
    [sym__element_value] = STATE(1083),
    [sym_element_value_array_initializer] = STATE(1083),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(307),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_RBRACE] = ACTIONS(366),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [103] = {
    [ts_builtin_sym_end] = ACTIONS(368),
    [sym_identifier] = ACTIONS(370),
    [sym_decimal_integer_literal] = ACTIONS(370),
    [sym_hex_integer_literal] = ACTIONS(370),
    [sym_octal_integer_literal] = ACTIONS(368),
    [sym_binary_integer_literal] = ACTIONS(368),
    [sym_decimal_floating_point_literal] = ACTIONS(368),
    [sym_hex_floating_point_literal] = ACTIONS(370),
    [sym_true] = ACTIONS(370),
    [sym_false] = ACTIONS(370),
    [sym_character_literal] = ACTIONS(368),
    [sym_string_literal] = ACTIONS(370),
    [sym_text_block] = ACTIONS(368),
    [sym_null_literal] = ACTIONS(370),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_LT] = ACTIONS(368),
    [anon_sym_PLUS] = ACTIONS(370),
    [anon_sym_DASH] = ACTIONS(370),
    [anon_sym_final] = ACTIONS(370),
    [anon_sym_BANG] = ACTIONS(368),
    [anon_sym_TILDE] = ACTIONS(368),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_new] = ACTIONS(370),
    [anon_sym_class] = ACTIONS(370),
    [anon_sym_switch] = ACTIONS(370),
    [anon_sym_LBRACE] = ACTIONS(368),
    [anon_sym_RBRACE] = ACTIONS(368),
    [anon_sym_case] = ACTIONS(370),
    [anon_sym_default] = ACTIONS(370),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym_assert] = ACTIONS(370),
    [anon_sym_do] = ACTIONS(370),
    [anon_sym_while] = ACTIONS(370),
    [anon_sym_break] = ACTIONS(370),
    [anon_sym_continue] = ACTIONS(370),
    [anon_sym_return] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(370),
    [anon_sym_synchronized] = ACTIONS(370),
    [anon_sym_throw] = ACTIONS(370),
    [anon_sym_try] = ACTIONS(370),
    [anon_sym_if] = ACTIONS(370),
    [anon_sym_else] = ACTIONS(370),
    [anon_sym_for] = ACTIONS(370),
    [anon_sym_AT] = ACTIONS(370),
    [anon_sym_open] = ACTIONS(370),
    [anon_sym_module] = ACTIONS(370),
    [anon_sym_static] = ACTIONS(370),
    [anon_sym_package] = ACTIONS(370),
    [anon_sym_import] = ACTIONS(370),
    [anon_sym_enum] = ACTIONS(370),
    [anon_sym_public] = ACTIONS(370),
    [anon_sym_protected] = ACTIONS(370),
    [anon_sym_private] = ACTIONS(370),
    [anon_sym_abstract] = ACTIONS(370),
    [anon_sym_strictfp] = ACTIONS(370),
    [anon_sym_native] = ACTIONS(370),
    [anon_sym_transient] = ACTIONS(370),
    [anon_sym_volatile] = ACTIONS(370),
    [anon_sym_sealed] = ACTIONS(370),
    [anon_sym_non_DASHsealed] = ACTIONS(368),
    [anon_sym_record] = ACTIONS(370),
    [anon_sym_ATinterface] = ACTIONS(368),
    [anon_sym_interface] = ACTIONS(370),
    [anon_sym_byte] = ACTIONS(370),
    [anon_sym_short] = ACTIONS(370),
    [anon_sym_int] = ACTIONS(370),
    [anon_sym_long] = ACTIONS(370),
    [anon_sym_char] = ACTIONS(370),
    [anon_sym_float] = ACTIONS(370),
    [anon_sym_double] = ACTIONS(370),
    [sym_boolean_type] = ACTIONS(370),
    [sym_void_type] = ACTIONS(370),
    [sym_this] = ACTIONS(370),
    [sym_super] = ACTIONS(370),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [104] = {
    [ts_builtin_sym_end] = ACTIONS(372),
    [sym_identifier] = ACTIONS(374),
    [sym_decimal_integer_literal] = ACTIONS(374),
    [sym_hex_integer_literal] = ACTIONS(374),
    [sym_octal_integer_literal] = ACTIONS(372),
    [sym_binary_integer_literal] = ACTIONS(372),
    [sym_decimal_floating_point_literal] = ACTIONS(372),
    [sym_hex_floating_point_literal] = ACTIONS(374),
    [sym_true] = ACTIONS(374),
    [sym_false] = ACTIONS(374),
    [sym_character_literal] = ACTIONS(372),
    [sym_string_literal] = ACTIONS(374),
    [sym_text_block] = ACTIONS(372),
    [sym_null_literal] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(372),
    [anon_sym_LT] = ACTIONS(372),
    [anon_sym_PLUS] = ACTIONS(374),
    [anon_sym_DASH] = ACTIONS(374),
    [anon_sym_final] = ACTIONS(374),
    [anon_sym_BANG] = ACTIONS(372),
    [anon_sym_TILDE] = ACTIONS(372),
    [anon_sym_PLUS_PLUS] = ACTIONS(372),
    [anon_sym_DASH_DASH] = ACTIONS(372),
    [anon_sym_new] = ACTIONS(374),
    [anon_sym_class] = ACTIONS(374),
    [anon_sym_switch] = ACTIONS(374),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_RBRACE] = ACTIONS(372),
    [anon_sym_case] = ACTIONS(374),
    [anon_sym_default] = ACTIONS(374),
    [anon_sym_SEMI] = ACTIONS(372),
    [anon_sym_assert] = ACTIONS(374),
    [anon_sym_do] = ACTIONS(374),
    [anon_sym_while] = ACTIONS(374),
    [anon_sym_break] = ACTIONS(374),
    [anon_sym_continue] = ACTIONS(374),
    [anon_sym_return] = ACTIONS(374),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_synchronized] = ACTIONS(374),
    [anon_sym_throw] = ACTIONS(374),
    [anon_sym_try] = ACTIONS(374),
    [anon_sym_if] = ACTIONS(374),
    [anon_sym_else] = ACTIONS(374),
    [anon_sym_for] = ACTIONS(374),
    [anon_sym_AT] = ACTIONS(374),
    [anon_sym_open] = ACTIONS(374),
    [anon_sym_module] = ACTIONS(374),
    [anon_sym_static] = ACTIONS(374),
    [anon_sym_package] = ACTIONS(374),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_enum] = ACTIONS(374),
    [anon_sym_public] = ACTIONS(374),
    [anon_sym_protected] = ACTIONS(374),
    [anon_sym_private] = ACTIONS(374),
    [anon_sym_abstract] = ACTIONS(374),
    [anon_sym_strictfp] = ACTIONS(374),
    [anon_sym_native] = ACTIONS(374),
    [anon_sym_transient] = ACTIONS(374),
    [anon_sym_volatile] = ACTIONS(374),
    [anon_sym_sealed] = ACTIONS(374),
    [anon_sym_non_DASHsealed] = ACTIONS(372),
    [anon_sym_record] = ACTIONS(374),
    [anon_sym_ATinterface] = ACTIONS(372),
    [anon_sym_interface] = ACTIONS(374),
    [anon_sym_byte] = ACTIONS(374),
    [anon_sym_short] = ACTIONS(374),
    [anon_sym_int] = ACTIONS(374),
    [anon_sym_long] = ACTIONS(374),
    [anon_sym_char] = ACTIONS(374),
    [anon_sym_float] = ACTIONS(374),
    [anon_sym_double] = ACTIONS(374),
    [sym_boolean_type] = ACTIONS(374),
    [sym_void_type] = ACTIONS(374),
    [sym_this] = ACTIONS(374),
    [sym_super] = ACTIONS(374),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [105] = {
    [ts_builtin_sym_end] = ACTIONS(376),
    [sym_identifier] = ACTIONS(378),
    [sym_decimal_integer_literal] = ACTIONS(378),
    [sym_hex_integer_literal] = ACTIONS(378),
    [sym_octal_integer_literal] = ACTIONS(376),
    [sym_binary_integer_literal] = ACTIONS(376),
    [sym_decimal_floating_point_literal] = ACTIONS(376),
    [sym_hex_floating_point_literal] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_character_literal] = ACTIONS(376),
    [sym_string_literal] = ACTIONS(378),
    [sym_text_block] = ACTIONS(376),
    [sym_null_literal] = ACTIONS(378),
    [anon_sym_LPAREN] = ACTIONS(376),
    [anon_sym_LT] = ACTIONS(376),
    [anon_sym_PLUS] = ACTIONS(378),
    [anon_sym_DASH] = ACTIONS(378),
    [anon_sym_final] = ACTIONS(378),
    [anon_sym_BANG] = ACTIONS(376),
    [anon_sym_TILDE] = ACTIONS(376),
    [anon_sym_PLUS_PLUS] = ACTIONS(376),
    [anon_sym_DASH_DASH] = ACTIONS(376),
    [anon_sym_new] = ACTIONS(378),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_switch] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(376),
    [anon_sym_case] = ACTIONS(378),
    [anon_sym_default] = ACTIONS(378),
    [anon_sym_SEMI] = ACTIONS(376),
    [anon_sym_assert] = ACTIONS(378),
    [anon_sym_do] = ACTIONS(378),
    [anon_sym_while] = ACTIONS(378),
    [anon_sym_break] = ACTIONS(378),
    [anon_sym_continue] = ACTIONS(378),
    [anon_sym_return] = ACTIONS(378),
    [anon_sym_yield] = ACTIONS(378),
    [anon_sym_synchronized] = ACTIONS(378),
    [anon_sym_throw] = ACTIONS(378),
    [anon_sym_try] = ACTIONS(378),
    [anon_sym_if] = ACTIONS(378),
    [anon_sym_else] = ACTIONS(378),
    [anon_sym_for] = ACTIONS(378),
    [anon_sym_AT] = ACTIONS(378),
    [anon_sym_open] = ACTIONS(378),
    [anon_sym_module] = ACTIONS(378),
    [anon_sym_static] = ACTIONS(378),
    [anon_sym_package] = ACTIONS(378),
    [anon_sym_import] = ACTIONS(378),
    [anon_sym_enum] = ACTIONS(378),
    [anon_sym_public] = ACTIONS(378),
    [anon_sym_protected] = ACTIONS(378),
    [anon_sym_private] = ACTIONS(378),
    [anon_sym_abstract] = ACTIONS(378),
    [anon_sym_strictfp] = ACTIONS(378),
    [anon_sym_native] = ACTIONS(378),
    [anon_sym_transient] = ACTIONS(378),
    [anon_sym_volatile] = ACTIONS(378),
    [anon_sym_sealed] = ACTIONS(378),
    [anon_sym_non_DASHsealed] = ACTIONS(376),
    [anon_sym_record] = ACTIONS(378),
    [anon_sym_ATinterface] = ACTIONS(376),
    [anon_sym_interface] = ACTIONS(378),
    [anon_sym_byte] = ACTIONS(378),
    [anon_sym_short] = ACTIONS(378),
    [anon_sym_int] = ACTIONS(378),
    [anon_sym_long] = ACTIONS(378),
    [anon_sym_char] = ACTIONS(378),
    [anon_sym_float] = ACTIONS(378),
    [anon_sym_double] = ACTIONS(378),
    [sym_boolean_type] = ACTIONS(378),
    [sym_void_type] = ACTIONS(378),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [106] = {
    [ts_builtin_sym_end] = ACTIONS(380),
    [sym_identifier] = ACTIONS(382),
    [sym_decimal_integer_literal] = ACTIONS(382),
    [sym_hex_integer_literal] = ACTIONS(382),
    [sym_octal_integer_literal] = ACTIONS(380),
    [sym_binary_integer_literal] = ACTIONS(380),
    [sym_decimal_floating_point_literal] = ACTIONS(380),
    [sym_hex_floating_point_literal] = ACTIONS(382),
    [sym_true] = ACTIONS(382),
    [sym_false] = ACTIONS(382),
    [sym_character_literal] = ACTIONS(380),
    [sym_string_literal] = ACTIONS(382),
    [sym_text_block] = ACTIONS(380),
    [sym_null_literal] = ACTIONS(382),
    [anon_sym_LPAREN] = ACTIONS(380),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_PLUS] = ACTIONS(382),
    [anon_sym_DASH] = ACTIONS(382),
    [anon_sym_final] = ACTIONS(382),
    [anon_sym_BANG] = ACTIONS(380),
    [anon_sym_TILDE] = ACTIONS(380),
    [anon_sym_PLUS_PLUS] = ACTIONS(380),
    [anon_sym_DASH_DASH] = ACTIONS(380),
    [anon_sym_new] = ACTIONS(382),
    [anon_sym_class] = ACTIONS(382),
    [anon_sym_switch] = ACTIONS(382),
    [anon_sym_LBRACE] = ACTIONS(380),
    [anon_sym_RBRACE] = ACTIONS(380),
    [anon_sym_case] = ACTIONS(382),
    [anon_sym_default] = ACTIONS(382),
    [anon_sym_SEMI] = ACTIONS(380),
    [anon_sym_assert] = ACTIONS(382),
    [anon_sym_do] = ACTIONS(382),
    [anon_sym_while] = ACTIONS(382),
    [anon_sym_break] = ACTIONS(382),
    [anon_sym_continue] = ACTIONS(382),
    [anon_sym_return] = ACTIONS(382),
    [anon_sym_yield] = ACTIONS(382),
    [anon_sym_synchronized] = ACTIONS(382),
    [anon_sym_throw] = ACTIONS(382),
    [anon_sym_try] = ACTIONS(382),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_else] = ACTIONS(382),
    [anon_sym_for] = ACTIONS(382),
    [anon_sym_AT] = ACTIONS(382),
    [anon_sym_open] = ACTIONS(382),
    [anon_sym_module] = ACTIONS(382),
    [anon_sym_static] = ACTIONS(382),
    [anon_sym_package] = ACTIONS(382),
    [anon_sym_import] = ACTIONS(382),
    [anon_sym_enum] = ACTIONS(382),
    [anon_sym_public] = ACTIONS(382),
    [anon_sym_protected] = ACTIONS(382),
    [anon_sym_private] = ACTIONS(382),
    [anon_sym_abstract] = ACTIONS(382),
    [anon_sym_strictfp] = ACTIONS(382),
    [anon_sym_native] = ACTIONS(382),
    [anon_sym_transient] = ACTIONS(382),
    [anon_sym_volatile] = ACTIONS(382),
    [anon_sym_sealed] = ACTIONS(382),
    [anon_sym_non_DASHsealed] = ACTIONS(380),
    [anon_sym_record] = ACTIONS(382),
    [anon_sym_ATinterface] = ACTIONS(380),
    [anon_sym_interface] = ACTIONS(382),
    [anon_sym_byte] = ACTIONS(382),
    [anon_sym_short] = ACTIONS(382),
    [anon_sym_int] = ACTIONS(382),
    [anon_sym_long] = ACTIONS(382),
    [anon_sym_char] = ACTIONS(382),
    [anon_sym_float] = ACTIONS(382),
    [anon_sym_double] = ACTIONS(382),
    [sym_boolean_type] = ACTIONS(382),
    [sym_void_type] = ACTIONS(382),
    [sym_this] = ACTIONS(382),
    [sym_super] = ACTIONS(382),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [107] = {
    [ts_builtin_sym_end] = ACTIONS(384),
    [sym_identifier] = ACTIONS(386),
    [sym_decimal_integer_literal] = ACTIONS(386),
    [sym_hex_integer_literal] = ACTIONS(386),
    [sym_octal_integer_literal] = ACTIONS(384),
    [sym_binary_integer_literal] = ACTIONS(384),
    [sym_decimal_floating_point_literal] = ACTIONS(384),
    [sym_hex_floating_point_literal] = ACTIONS(386),
    [sym_true] = ACTIONS(386),
    [sym_false] = ACTIONS(386),
    [sym_character_literal] = ACTIONS(384),
    [sym_string_literal] = ACTIONS(386),
    [sym_text_block] = ACTIONS(384),
    [sym_null_literal] = ACTIONS(386),
    [anon_sym_LPAREN] = ACTIONS(384),
    [anon_sym_LT] = ACTIONS(384),
    [anon_sym_PLUS] = ACTIONS(386),
    [anon_sym_DASH] = ACTIONS(386),
    [anon_sym_final] = ACTIONS(386),
    [anon_sym_BANG] = ACTIONS(384),
    [anon_sym_TILDE] = ACTIONS(384),
    [anon_sym_PLUS_PLUS] = ACTIONS(384),
    [anon_sym_DASH_DASH] = ACTIONS(384),
    [anon_sym_new] = ACTIONS(386),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_switch] = ACTIONS(386),
    [anon_sym_LBRACE] = ACTIONS(384),
    [anon_sym_RBRACE] = ACTIONS(384),
    [anon_sym_case] = ACTIONS(386),
    [anon_sym_default] = ACTIONS(386),
    [anon_sym_SEMI] = ACTIONS(384),
    [anon_sym_assert] = ACTIONS(386),
    [anon_sym_do] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(386),
    [anon_sym_break] = ACTIONS(386),
    [anon_sym_continue] = ACTIONS(386),
    [anon_sym_return] = ACTIONS(386),
    [anon_sym_yield] = ACTIONS(386),
    [anon_sym_synchronized] = ACTIONS(386),
    [anon_sym_throw] = ACTIONS(386),
    [anon_sym_try] = ACTIONS(386),
    [anon_sym_if] = ACTIONS(386),
    [anon_sym_else] = ACTIONS(386),
    [anon_sym_for] = ACTIONS(386),
    [anon_sym_AT] = ACTIONS(386),
    [anon_sym_open] = ACTIONS(386),
    [anon_sym_module] = ACTIONS(386),
    [anon_sym_static] = ACTIONS(386),
    [anon_sym_package] = ACTIONS(386),
    [anon_sym_import] = ACTIONS(386),
    [anon_sym_enum] = ACTIONS(386),
    [anon_sym_public] = ACTIONS(386),
    [anon_sym_protected] = ACTIONS(386),
    [anon_sym_private] = ACTIONS(386),
    [anon_sym_abstract] = ACTIONS(386),
    [anon_sym_strictfp] = ACTIONS(386),
    [anon_sym_native] = ACTIONS(386),
    [anon_sym_transient] = ACTIONS(386),
    [anon_sym_volatile] = ACTIONS(386),
    [anon_sym_sealed] = ACTIONS(386),
    [anon_sym_non_DASHsealed] = ACTIONS(384),
    [anon_sym_record] = ACTIONS(386),
    [anon_sym_ATinterface] = ACTIONS(384),
    [anon_sym_interface] = ACTIONS(386),
    [anon_sym_byte] = ACTIONS(386),
    [anon_sym_short] = ACTIONS(386),
    [anon_sym_int] = ACTIONS(386),
    [anon_sym_long] = ACTIONS(386),
    [anon_sym_char] = ACTIONS(386),
    [anon_sym_float] = ACTIONS(386),
    [anon_sym_double] = ACTIONS(386),
    [sym_boolean_type] = ACTIONS(386),
    [sym_void_type] = ACTIONS(386),
    [sym_this] = ACTIONS(386),
    [sym_super] = ACTIONS(386),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [108] = {
    [ts_builtin_sym_end] = ACTIONS(388),
    [sym_identifier] = ACTIONS(390),
    [sym_decimal_integer_literal] = ACTIONS(390),
    [sym_hex_integer_literal] = ACTIONS(390),
    [sym_octal_integer_literal] = ACTIONS(388),
    [sym_binary_integer_literal] = ACTIONS(388),
    [sym_decimal_floating_point_literal] = ACTIONS(388),
    [sym_hex_floating_point_literal] = ACTIONS(390),
    [sym_true] = ACTIONS(390),
    [sym_false] = ACTIONS(390),
    [sym_character_literal] = ACTIONS(388),
    [sym_string_literal] = ACTIONS(390),
    [sym_text_block] = ACTIONS(388),
    [sym_null_literal] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(388),
    [anon_sym_LT] = ACTIONS(388),
    [anon_sym_PLUS] = ACTIONS(390),
    [anon_sym_DASH] = ACTIONS(390),
    [anon_sym_final] = ACTIONS(390),
    [anon_sym_BANG] = ACTIONS(388),
    [anon_sym_TILDE] = ACTIONS(388),
    [anon_sym_PLUS_PLUS] = ACTIONS(388),
    [anon_sym_DASH_DASH] = ACTIONS(388),
    [anon_sym_new] = ACTIONS(390),
    [anon_sym_class] = ACTIONS(390),
    [anon_sym_switch] = ACTIONS(390),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(388),
    [anon_sym_case] = ACTIONS(390),
    [anon_sym_default] = ACTIONS(390),
    [anon_sym_SEMI] = ACTIONS(388),
    [anon_sym_assert] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_break] = ACTIONS(390),
    [anon_sym_continue] = ACTIONS(390),
    [anon_sym_return] = ACTIONS(390),
    [anon_sym_yield] = ACTIONS(390),
    [anon_sym_synchronized] = ACTIONS(390),
    [anon_sym_throw] = ACTIONS(390),
    [anon_sym_try] = ACTIONS(390),
    [anon_sym_if] = ACTIONS(390),
    [anon_sym_else] = ACTIONS(390),
    [anon_sym_for] = ACTIONS(390),
    [anon_sym_AT] = ACTIONS(390),
    [anon_sym_open] = ACTIONS(390),
    [anon_sym_module] = ACTIONS(390),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_package] = ACTIONS(390),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_enum] = ACTIONS(390),
    [anon_sym_public] = ACTIONS(390),
    [anon_sym_protected] = ACTIONS(390),
    [anon_sym_private] = ACTIONS(390),
    [anon_sym_abstract] = ACTIONS(390),
    [anon_sym_strictfp] = ACTIONS(390),
    [anon_sym_native] = ACTIONS(390),
    [anon_sym_transient] = ACTIONS(390),
    [anon_sym_volatile] = ACTIONS(390),
    [anon_sym_sealed] = ACTIONS(390),
    [anon_sym_non_DASHsealed] = ACTIONS(388),
    [anon_sym_record] = ACTIONS(390),
    [anon_sym_ATinterface] = ACTIONS(388),
    [anon_sym_interface] = ACTIONS(390),
    [anon_sym_byte] = ACTIONS(390),
    [anon_sym_short] = ACTIONS(390),
    [anon_sym_int] = ACTIONS(390),
    [anon_sym_long] = ACTIONS(390),
    [anon_sym_char] = ACTIONS(390),
    [anon_sym_float] = ACTIONS(390),
    [anon_sym_double] = ACTIONS(390),
    [sym_boolean_type] = ACTIONS(390),
    [sym_void_type] = ACTIONS(390),
    [sym_this] = ACTIONS(390),
    [sym_super] = ACTIONS(390),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [109] = {
    [ts_builtin_sym_end] = ACTIONS(392),
    [sym_identifier] = ACTIONS(394),
    [sym_decimal_integer_literal] = ACTIONS(394),
    [sym_hex_integer_literal] = ACTIONS(394),
    [sym_octal_integer_literal] = ACTIONS(392),
    [sym_binary_integer_literal] = ACTIONS(392),
    [sym_decimal_floating_point_literal] = ACTIONS(392),
    [sym_hex_floating_point_literal] = ACTIONS(394),
    [sym_true] = ACTIONS(394),
    [sym_false] = ACTIONS(394),
    [sym_character_literal] = ACTIONS(392),
    [sym_string_literal] = ACTIONS(394),
    [sym_text_block] = ACTIONS(392),
    [sym_null_literal] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(392),
    [anon_sym_LT] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_final] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(392),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_PLUS_PLUS] = ACTIONS(392),
    [anon_sym_DASH_DASH] = ACTIONS(392),
    [anon_sym_new] = ACTIONS(394),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_switch] = ACTIONS(394),
    [anon_sym_LBRACE] = ACTIONS(392),
    [anon_sym_RBRACE] = ACTIONS(392),
    [anon_sym_case] = ACTIONS(394),
    [anon_sym_default] = ACTIONS(394),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_assert] = ACTIONS(394),
    [anon_sym_do] = ACTIONS(394),
    [anon_sym_while] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(394),
    [anon_sym_continue] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_yield] = ACTIONS(394),
    [anon_sym_synchronized] = ACTIONS(394),
    [anon_sym_throw] = ACTIONS(394),
    [anon_sym_try] = ACTIONS(394),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_else] = ACTIONS(394),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_AT] = ACTIONS(394),
    [anon_sym_open] = ACTIONS(394),
    [anon_sym_module] = ACTIONS(394),
    [anon_sym_static] = ACTIONS(394),
    [anon_sym_package] = ACTIONS(394),
    [anon_sym_import] = ACTIONS(394),
    [anon_sym_enum] = ACTIONS(394),
    [anon_sym_public] = ACTIONS(394),
    [anon_sym_protected] = ACTIONS(394),
    [anon_sym_private] = ACTIONS(394),
    [anon_sym_abstract] = ACTIONS(394),
    [anon_sym_strictfp] = ACTIONS(394),
    [anon_sym_native] = ACTIONS(394),
    [anon_sym_transient] = ACTIONS(394),
    [anon_sym_volatile] = ACTIONS(394),
    [anon_sym_sealed] = ACTIONS(394),
    [anon_sym_non_DASHsealed] = ACTIONS(392),
    [anon_sym_record] = ACTIONS(394),
    [anon_sym_ATinterface] = ACTIONS(392),
    [anon_sym_interface] = ACTIONS(394),
    [anon_sym_byte] = ACTIONS(394),
    [anon_sym_short] = ACTIONS(394),
    [anon_sym_int] = ACTIONS(394),
    [anon_sym_long] = ACTIONS(394),
    [anon_sym_char] = ACTIONS(394),
    [anon_sym_float] = ACTIONS(394),
    [anon_sym_double] = ACTIONS(394),
    [sym_boolean_type] = ACTIONS(394),
    [sym_void_type] = ACTIONS(394),
    [sym_this] = ACTIONS(394),
    [sym_super] = ACTIONS(394),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [110] = {
    [ts_builtin_sym_end] = ACTIONS(396),
    [sym_identifier] = ACTIONS(398),
    [sym_decimal_integer_literal] = ACTIONS(398),
    [sym_hex_integer_literal] = ACTIONS(398),
    [sym_octal_integer_literal] = ACTIONS(396),
    [sym_binary_integer_literal] = ACTIONS(396),
    [sym_decimal_floating_point_literal] = ACTIONS(396),
    [sym_hex_floating_point_literal] = ACTIONS(398),
    [sym_true] = ACTIONS(398),
    [sym_false] = ACTIONS(398),
    [sym_character_literal] = ACTIONS(396),
    [sym_string_literal] = ACTIONS(398),
    [sym_text_block] = ACTIONS(396),
    [sym_null_literal] = ACTIONS(398),
    [anon_sym_LPAREN] = ACTIONS(396),
    [anon_sym_LT] = ACTIONS(396),
    [anon_sym_PLUS] = ACTIONS(398),
    [anon_sym_DASH] = ACTIONS(398),
    [anon_sym_final] = ACTIONS(398),
    [anon_sym_BANG] = ACTIONS(396),
    [anon_sym_TILDE] = ACTIONS(396),
    [anon_sym_PLUS_PLUS] = ACTIONS(396),
    [anon_sym_DASH_DASH] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(398),
    [anon_sym_class] = ACTIONS(398),
    [anon_sym_switch] = ACTIONS(398),
    [anon_sym_LBRACE] = ACTIONS(396),
    [anon_sym_RBRACE] = ACTIONS(396),
    [anon_sym_case] = ACTIONS(398),
    [anon_sym_default] = ACTIONS(398),
    [anon_sym_SEMI] = ACTIONS(396),
    [anon_sym_assert] = ACTIONS(398),
    [anon_sym_do] = ACTIONS(398),
    [anon_sym_while] = ACTIONS(398),
    [anon_sym_break] = ACTIONS(398),
    [anon_sym_continue] = ACTIONS(398),
    [anon_sym_return] = ACTIONS(398),
    [anon_sym_yield] = ACTIONS(398),
    [anon_sym_synchronized] = ACTIONS(398),
    [anon_sym_throw] = ACTIONS(398),
    [anon_sym_try] = ACTIONS(398),
    [anon_sym_if] = ACTIONS(398),
    [anon_sym_else] = ACTIONS(398),
    [anon_sym_for] = ACTIONS(398),
    [anon_sym_AT] = ACTIONS(398),
    [anon_sym_open] = ACTIONS(398),
    [anon_sym_module] = ACTIONS(398),
    [anon_sym_static] = ACTIONS(398),
    [anon_sym_package] = ACTIONS(398),
    [anon_sym_import] = ACTIONS(398),
    [anon_sym_enum] = ACTIONS(398),
    [anon_sym_public] = ACTIONS(398),
    [anon_sym_protected] = ACTIONS(398),
    [anon_sym_private] = ACTIONS(398),
    [anon_sym_abstract] = ACTIONS(398),
    [anon_sym_strictfp] = ACTIONS(398),
    [anon_sym_native] = ACTIONS(398),
    [anon_sym_transient] = ACTIONS(398),
    [anon_sym_volatile] = ACTIONS(398),
    [anon_sym_sealed] = ACTIONS(398),
    [anon_sym_non_DASHsealed] = ACTIONS(396),
    [anon_sym_record] = ACTIONS(398),
    [anon_sym_ATinterface] = ACTIONS(396),
    [anon_sym_interface] = ACTIONS(398),
    [anon_sym_byte] = ACTIONS(398),
    [anon_sym_short] = ACTIONS(398),
    [anon_sym_int] = ACTIONS(398),
    [anon_sym_long] = ACTIONS(398),
    [anon_sym_char] = ACTIONS(398),
    [anon_sym_float] = ACTIONS(398),
    [anon_sym_double] = ACTIONS(398),
    [sym_boolean_type] = ACTIONS(398),
    [sym_void_type] = ACTIONS(398),
    [sym_this] = ACTIONS(398),
    [sym_super] = ACTIONS(398),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [111] = {
    [ts_builtin_sym_end] = ACTIONS(400),
    [sym_identifier] = ACTIONS(402),
    [sym_decimal_integer_literal] = ACTIONS(402),
    [sym_hex_integer_literal] = ACTIONS(402),
    [sym_octal_integer_literal] = ACTIONS(400),
    [sym_binary_integer_literal] = ACTIONS(400),
    [sym_decimal_floating_point_literal] = ACTIONS(400),
    [sym_hex_floating_point_literal] = ACTIONS(402),
    [sym_true] = ACTIONS(402),
    [sym_false] = ACTIONS(402),
    [sym_character_literal] = ACTIONS(400),
    [sym_string_literal] = ACTIONS(402),
    [sym_text_block] = ACTIONS(400),
    [sym_null_literal] = ACTIONS(402),
    [anon_sym_LPAREN] = ACTIONS(400),
    [anon_sym_LT] = ACTIONS(400),
    [anon_sym_PLUS] = ACTIONS(402),
    [anon_sym_DASH] = ACTIONS(402),
    [anon_sym_final] = ACTIONS(402),
    [anon_sym_BANG] = ACTIONS(400),
    [anon_sym_TILDE] = ACTIONS(400),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [anon_sym_new] = ACTIONS(402),
    [anon_sym_class] = ACTIONS(402),
    [anon_sym_switch] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(400),
    [anon_sym_RBRACE] = ACTIONS(400),
    [anon_sym_case] = ACTIONS(402),
    [anon_sym_default] = ACTIONS(402),
    [anon_sym_SEMI] = ACTIONS(400),
    [anon_sym_assert] = ACTIONS(402),
    [anon_sym_do] = ACTIONS(402),
    [anon_sym_while] = ACTIONS(402),
    [anon_sym_break] = ACTIONS(402),
    [anon_sym_continue] = ACTIONS(402),
    [anon_sym_return] = ACTIONS(402),
    [anon_sym_yield] = ACTIONS(402),
    [anon_sym_synchronized] = ACTIONS(402),
    [anon_sym_throw] = ACTIONS(402),
    [anon_sym_try] = ACTIONS(402),
    [anon_sym_if] = ACTIONS(402),
    [anon_sym_else] = ACTIONS(402),
    [anon_sym_for] = ACTIONS(402),
    [anon_sym_AT] = ACTIONS(402),
    [anon_sym_open] = ACTIONS(402),
    [anon_sym_module] = ACTIONS(402),
    [anon_sym_static] = ACTIONS(402),
    [anon_sym_package] = ACTIONS(402),
    [anon_sym_import] = ACTIONS(402),
    [anon_sym_enum] = ACTIONS(402),
    [anon_sym_public] = ACTIONS(402),
    [anon_sym_protected] = ACTIONS(402),
    [anon_sym_private] = ACTIONS(402),
    [anon_sym_abstract] = ACTIONS(402),
    [anon_sym_strictfp] = ACTIONS(402),
    [anon_sym_native] = ACTIONS(402),
    [anon_sym_transient] = ACTIONS(402),
    [anon_sym_volatile] = ACTIONS(402),
    [anon_sym_sealed] = ACTIONS(402),
    [anon_sym_non_DASHsealed] = ACTIONS(400),
    [anon_sym_record] = ACTIONS(402),
    [anon_sym_ATinterface] = ACTIONS(400),
    [anon_sym_interface] = ACTIONS(402),
    [anon_sym_byte] = ACTIONS(402),
    [anon_sym_short] = ACTIONS(402),
    [anon_sym_int] = ACTIONS(402),
    [anon_sym_long] = ACTIONS(402),
    [anon_sym_char] = ACTIONS(402),
    [anon_sym_float] = ACTIONS(402),
    [anon_sym_double] = ACTIONS(402),
    [sym_boolean_type] = ACTIONS(402),
    [sym_void_type] = ACTIONS(402),
    [sym_this] = ACTIONS(402),
    [sym_super] = ACTIONS(402),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [112] = {
    [ts_builtin_sym_end] = ACTIONS(404),
    [sym_identifier] = ACTIONS(406),
    [sym_decimal_integer_literal] = ACTIONS(406),
    [sym_hex_integer_literal] = ACTIONS(406),
    [sym_octal_integer_literal] = ACTIONS(404),
    [sym_binary_integer_literal] = ACTIONS(404),
    [sym_decimal_floating_point_literal] = ACTIONS(404),
    [sym_hex_floating_point_literal] = ACTIONS(406),
    [sym_true] = ACTIONS(406),
    [sym_false] = ACTIONS(406),
    [sym_character_literal] = ACTIONS(404),
    [sym_string_literal] = ACTIONS(406),
    [sym_text_block] = ACTIONS(404),
    [sym_null_literal] = ACTIONS(406),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_LT] = ACTIONS(404),
    [anon_sym_PLUS] = ACTIONS(406),
    [anon_sym_DASH] = ACTIONS(406),
    [anon_sym_final] = ACTIONS(406),
    [anon_sym_BANG] = ACTIONS(404),
    [anon_sym_TILDE] = ACTIONS(404),
    [anon_sym_PLUS_PLUS] = ACTIONS(404),
    [anon_sym_DASH_DASH] = ACTIONS(404),
    [anon_sym_new] = ACTIONS(406),
    [anon_sym_class] = ACTIONS(406),
    [anon_sym_switch] = ACTIONS(406),
    [anon_sym_LBRACE] = ACTIONS(404),
    [anon_sym_RBRACE] = ACTIONS(404),
    [anon_sym_case] = ACTIONS(406),
    [anon_sym_default] = ACTIONS(406),
    [anon_sym_SEMI] = ACTIONS(404),
    [anon_sym_assert] = ACTIONS(406),
    [anon_sym_do] = ACTIONS(406),
    [anon_sym_while] = ACTIONS(406),
    [anon_sym_break] = ACTIONS(406),
    [anon_sym_continue] = ACTIONS(406),
    [anon_sym_return] = ACTIONS(406),
    [anon_sym_yield] = ACTIONS(406),
    [anon_sym_synchronized] = ACTIONS(406),
    [anon_sym_throw] = ACTIONS(406),
    [anon_sym_try] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(406),
    [anon_sym_else] = ACTIONS(406),
    [anon_sym_for] = ACTIONS(406),
    [anon_sym_AT] = ACTIONS(406),
    [anon_sym_open] = ACTIONS(406),
    [anon_sym_module] = ACTIONS(406),
    [anon_sym_static] = ACTIONS(406),
    [anon_sym_package] = ACTIONS(406),
    [anon_sym_import] = ACTIONS(406),
    [anon_sym_enum] = ACTIONS(406),
    [anon_sym_public] = ACTIONS(406),
    [anon_sym_protected] = ACTIONS(406),
    [anon_sym_private] = ACTIONS(406),
    [anon_sym_abstract] = ACTIONS(406),
    [anon_sym_strictfp] = ACTIONS(406),
    [anon_sym_native] = ACTIONS(406),
    [anon_sym_transient] = ACTIONS(406),
    [anon_sym_volatile] = ACTIONS(406),
    [anon_sym_sealed] = ACTIONS(406),
    [anon_sym_non_DASHsealed] = ACTIONS(404),
    [anon_sym_record] = ACTIONS(406),
    [anon_sym_ATinterface] = ACTIONS(404),
    [anon_sym_interface] = ACTIONS(406),
    [anon_sym_byte] = ACTIONS(406),
    [anon_sym_short] = ACTIONS(406),
    [anon_sym_int] = ACTIONS(406),
    [anon_sym_long] = ACTIONS(406),
    [anon_sym_char] = ACTIONS(406),
    [anon_sym_float] = ACTIONS(406),
    [anon_sym_double] = ACTIONS(406),
    [sym_boolean_type] = ACTIONS(406),
    [sym_void_type] = ACTIONS(406),
    [sym_this] = ACTIONS(406),
    [sym_super] = ACTIONS(406),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [113] = {
    [ts_builtin_sym_end] = ACTIONS(408),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(410),
    [sym_hex_integer_literal] = ACTIONS(410),
    [sym_octal_integer_literal] = ACTIONS(408),
    [sym_binary_integer_literal] = ACTIONS(408),
    [sym_decimal_floating_point_literal] = ACTIONS(408),
    [sym_hex_floating_point_literal] = ACTIONS(410),
    [sym_true] = ACTIONS(410),
    [sym_false] = ACTIONS(410),
    [sym_character_literal] = ACTIONS(408),
    [sym_string_literal] = ACTIONS(410),
    [sym_text_block] = ACTIONS(408),
    [sym_null_literal] = ACTIONS(410),
    [anon_sym_LPAREN] = ACTIONS(408),
    [anon_sym_LT] = ACTIONS(408),
    [anon_sym_PLUS] = ACTIONS(410),
    [anon_sym_DASH] = ACTIONS(410),
    [anon_sym_final] = ACTIONS(410),
    [anon_sym_BANG] = ACTIONS(408),
    [anon_sym_TILDE] = ACTIONS(408),
    [anon_sym_PLUS_PLUS] = ACTIONS(408),
    [anon_sym_DASH_DASH] = ACTIONS(408),
    [anon_sym_new] = ACTIONS(410),
    [anon_sym_class] = ACTIONS(410),
    [anon_sym_switch] = ACTIONS(410),
    [anon_sym_LBRACE] = ACTIONS(408),
    [anon_sym_RBRACE] = ACTIONS(408),
    [anon_sym_case] = ACTIONS(410),
    [anon_sym_default] = ACTIONS(410),
    [anon_sym_SEMI] = ACTIONS(408),
    [anon_sym_assert] = ACTIONS(410),
    [anon_sym_do] = ACTIONS(410),
    [anon_sym_while] = ACTIONS(410),
    [anon_sym_break] = ACTIONS(410),
    [anon_sym_continue] = ACTIONS(410),
    [anon_sym_return] = ACTIONS(410),
    [anon_sym_yield] = ACTIONS(410),
    [anon_sym_synchronized] = ACTIONS(410),
    [anon_sym_throw] = ACTIONS(410),
    [anon_sym_try] = ACTIONS(410),
    [anon_sym_if] = ACTIONS(410),
    [anon_sym_else] = ACTIONS(410),
    [anon_sym_for] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(410),
    [anon_sym_open] = ACTIONS(410),
    [anon_sym_module] = ACTIONS(410),
    [anon_sym_static] = ACTIONS(410),
    [anon_sym_package] = ACTIONS(410),
    [anon_sym_import] = ACTIONS(410),
    [anon_sym_enum] = ACTIONS(410),
    [anon_sym_public] = ACTIONS(410),
    [anon_sym_protected] = ACTIONS(410),
    [anon_sym_private] = ACTIONS(410),
    [anon_sym_abstract] = ACTIONS(410),
    [anon_sym_strictfp] = ACTIONS(410),
    [anon_sym_native] = ACTIONS(410),
    [anon_sym_transient] = ACTIONS(410),
    [anon_sym_volatile] = ACTIONS(410),
    [anon_sym_sealed] = ACTIONS(410),
    [anon_sym_non_DASHsealed] = ACTIONS(408),
    [anon_sym_record] = ACTIONS(410),
    [anon_sym_ATinterface] = ACTIONS(408),
    [anon_sym_interface] = ACTIONS(410),
    [anon_sym_byte] = ACTIONS(410),
    [anon_sym_short] = ACTIONS(410),
    [anon_sym_int] = ACTIONS(410),
    [anon_sym_long] = ACTIONS(410),
    [anon_sym_char] = ACTIONS(410),
    [anon_sym_float] = ACTIONS(410),
    [anon_sym_double] = ACTIONS(410),
    [sym_boolean_type] = ACTIONS(410),
    [sym_void_type] = ACTIONS(410),
    [sym_this] = ACTIONS(410),
    [sym_super] = ACTIONS(410),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [114] = {
    [ts_builtin_sym_end] = ACTIONS(412),
    [sym_identifier] = ACTIONS(414),
    [sym_decimal_integer_literal] = ACTIONS(414),
    [sym_hex_integer_literal] = ACTIONS(414),
    [sym_octal_integer_literal] = ACTIONS(412),
    [sym_binary_integer_literal] = ACTIONS(412),
    [sym_decimal_floating_point_literal] = ACTIONS(412),
    [sym_hex_floating_point_literal] = ACTIONS(414),
    [sym_true] = ACTIONS(414),
    [sym_false] = ACTIONS(414),
    [sym_character_literal] = ACTIONS(412),
    [sym_string_literal] = ACTIONS(414),
    [sym_text_block] = ACTIONS(412),
    [sym_null_literal] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_final] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(412),
    [anon_sym_TILDE] = ACTIONS(412),
    [anon_sym_PLUS_PLUS] = ACTIONS(412),
    [anon_sym_DASH_DASH] = ACTIONS(412),
    [anon_sym_new] = ACTIONS(414),
    [anon_sym_class] = ACTIONS(414),
    [anon_sym_switch] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(412),
    [anon_sym_RBRACE] = ACTIONS(412),
    [anon_sym_case] = ACTIONS(414),
    [anon_sym_default] = ACTIONS(414),
    [anon_sym_SEMI] = ACTIONS(412),
    [anon_sym_assert] = ACTIONS(414),
    [anon_sym_do] = ACTIONS(414),
    [anon_sym_while] = ACTIONS(414),
    [anon_sym_break] = ACTIONS(414),
    [anon_sym_continue] = ACTIONS(414),
    [anon_sym_return] = ACTIONS(414),
    [anon_sym_yield] = ACTIONS(414),
    [anon_sym_synchronized] = ACTIONS(414),
    [anon_sym_throw] = ACTIONS(414),
    [anon_sym_try] = ACTIONS(414),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_else] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(414),
    [anon_sym_AT] = ACTIONS(414),
    [anon_sym_open] = ACTIONS(414),
    [anon_sym_module] = ACTIONS(414),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_package] = ACTIONS(414),
    [anon_sym_import] = ACTIONS(414),
    [anon_sym_enum] = ACTIONS(414),
    [anon_sym_public] = ACTIONS(414),
    [anon_sym_protected] = ACTIONS(414),
    [anon_sym_private] = ACTIONS(414),
    [anon_sym_abstract] = ACTIONS(414),
    [anon_sym_strictfp] = ACTIONS(414),
    [anon_sym_native] = ACTIONS(414),
    [anon_sym_transient] = ACTIONS(414),
    [anon_sym_volatile] = ACTIONS(414),
    [anon_sym_sealed] = ACTIONS(414),
    [anon_sym_non_DASHsealed] = ACTIONS(412),
    [anon_sym_record] = ACTIONS(414),
    [anon_sym_ATinterface] = ACTIONS(412),
    [anon_sym_interface] = ACTIONS(414),
    [anon_sym_byte] = ACTIONS(414),
    [anon_sym_short] = ACTIONS(414),
    [anon_sym_int] = ACTIONS(414),
    [anon_sym_long] = ACTIONS(414),
    [anon_sym_char] = ACTIONS(414),
    [anon_sym_float] = ACTIONS(414),
    [anon_sym_double] = ACTIONS(414),
    [sym_boolean_type] = ACTIONS(414),
    [sym_void_type] = ACTIONS(414),
    [sym_this] = ACTIONS(414),
    [sym_super] = ACTIONS(414),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [115] = {
    [ts_builtin_sym_end] = ACTIONS(416),
    [sym_identifier] = ACTIONS(418),
    [sym_decimal_integer_literal] = ACTIONS(418),
    [sym_hex_integer_literal] = ACTIONS(418),
    [sym_octal_integer_literal] = ACTIONS(416),
    [sym_binary_integer_literal] = ACTIONS(416),
    [sym_decimal_floating_point_literal] = ACTIONS(416),
    [sym_hex_floating_point_literal] = ACTIONS(418),
    [sym_true] = ACTIONS(418),
    [sym_false] = ACTIONS(418),
    [sym_character_literal] = ACTIONS(416),
    [sym_string_literal] = ACTIONS(418),
    [sym_text_block] = ACTIONS(416),
    [sym_null_literal] = ACTIONS(418),
    [anon_sym_LPAREN] = ACTIONS(416),
    [anon_sym_LT] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(418),
    [anon_sym_DASH] = ACTIONS(418),
    [anon_sym_final] = ACTIONS(418),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(416),
    [anon_sym_DASH_DASH] = ACTIONS(416),
    [anon_sym_new] = ACTIONS(418),
    [anon_sym_class] = ACTIONS(418),
    [anon_sym_switch] = ACTIONS(418),
    [anon_sym_LBRACE] = ACTIONS(416),
    [anon_sym_RBRACE] = ACTIONS(416),
    [anon_sym_case] = ACTIONS(418),
    [anon_sym_default] = ACTIONS(418),
    [anon_sym_SEMI] = ACTIONS(416),
    [anon_sym_assert] = ACTIONS(418),
    [anon_sym_do] = ACTIONS(418),
    [anon_sym_while] = ACTIONS(418),
    [anon_sym_break] = ACTIONS(418),
    [anon_sym_continue] = ACTIONS(418),
    [anon_sym_return] = ACTIONS(418),
    [anon_sym_yield] = ACTIONS(418),
    [anon_sym_synchronized] = ACTIONS(418),
    [anon_sym_throw] = ACTIONS(418),
    [anon_sym_try] = ACTIONS(418),
    [anon_sym_if] = ACTIONS(418),
    [anon_sym_else] = ACTIONS(418),
    [anon_sym_for] = ACTIONS(418),
    [anon_sym_AT] = ACTIONS(418),
    [anon_sym_open] = ACTIONS(418),
    [anon_sym_module] = ACTIONS(418),
    [anon_sym_static] = ACTIONS(418),
    [anon_sym_package] = ACTIONS(418),
    [anon_sym_import] = ACTIONS(418),
    [anon_sym_enum] = ACTIONS(418),
    [anon_sym_public] = ACTIONS(418),
    [anon_sym_protected] = ACTIONS(418),
    [anon_sym_private] = ACTIONS(418),
    [anon_sym_abstract] = ACTIONS(418),
    [anon_sym_strictfp] = ACTIONS(418),
    [anon_sym_native] = ACTIONS(418),
    [anon_sym_transient] = ACTIONS(418),
    [anon_sym_volatile] = ACTIONS(418),
    [anon_sym_sealed] = ACTIONS(418),
    [anon_sym_non_DASHsealed] = ACTIONS(416),
    [anon_sym_record] = ACTIONS(418),
    [anon_sym_ATinterface] = ACTIONS(416),
    [anon_sym_interface] = ACTIONS(418),
    [anon_sym_byte] = ACTIONS(418),
    [anon_sym_short] = ACTIONS(418),
    [anon_sym_int] = ACTIONS(418),
    [anon_sym_long] = ACTIONS(418),
    [anon_sym_char] = ACTIONS(418),
    [anon_sym_float] = ACTIONS(418),
    [anon_sym_double] = ACTIONS(418),
    [sym_boolean_type] = ACTIONS(418),
    [sym_void_type] = ACTIONS(418),
    [sym_this] = ACTIONS(418),
    [sym_super] = ACTIONS(418),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [116] = {
    [ts_builtin_sym_end] = ACTIONS(420),
    [sym_identifier] = ACTIONS(422),
    [sym_decimal_integer_literal] = ACTIONS(422),
    [sym_hex_integer_literal] = ACTIONS(422),
    [sym_octal_integer_literal] = ACTIONS(420),
    [sym_binary_integer_literal] = ACTIONS(420),
    [sym_decimal_floating_point_literal] = ACTIONS(420),
    [sym_hex_floating_point_literal] = ACTIONS(422),
    [sym_true] = ACTIONS(422),
    [sym_false] = ACTIONS(422),
    [sym_character_literal] = ACTIONS(420),
    [sym_string_literal] = ACTIONS(422),
    [sym_text_block] = ACTIONS(420),
    [sym_null_literal] = ACTIONS(422),
    [anon_sym_LPAREN] = ACTIONS(420),
    [anon_sym_LT] = ACTIONS(420),
    [anon_sym_PLUS] = ACTIONS(422),
    [anon_sym_DASH] = ACTIONS(422),
    [anon_sym_final] = ACTIONS(422),
    [anon_sym_BANG] = ACTIONS(420),
    [anon_sym_TILDE] = ACTIONS(420),
    [anon_sym_PLUS_PLUS] = ACTIONS(420),
    [anon_sym_DASH_DASH] = ACTIONS(420),
    [anon_sym_new] = ACTIONS(422),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_switch] = ACTIONS(422),
    [anon_sym_LBRACE] = ACTIONS(420),
    [anon_sym_RBRACE] = ACTIONS(420),
    [anon_sym_case] = ACTIONS(422),
    [anon_sym_default] = ACTIONS(422),
    [anon_sym_SEMI] = ACTIONS(420),
    [anon_sym_assert] = ACTIONS(422),
    [anon_sym_do] = ACTIONS(422),
    [anon_sym_while] = ACTIONS(422),
    [anon_sym_break] = ACTIONS(422),
    [anon_sym_continue] = ACTIONS(422),
    [anon_sym_return] = ACTIONS(422),
    [anon_sym_yield] = ACTIONS(422),
    [anon_sym_synchronized] = ACTIONS(422),
    [anon_sym_throw] = ACTIONS(422),
    [anon_sym_try] = ACTIONS(422),
    [anon_sym_if] = ACTIONS(422),
    [anon_sym_else] = ACTIONS(422),
    [anon_sym_for] = ACTIONS(422),
    [anon_sym_AT] = ACTIONS(422),
    [anon_sym_open] = ACTIONS(422),
    [anon_sym_module] = ACTIONS(422),
    [anon_sym_static] = ACTIONS(422),
    [anon_sym_package] = ACTIONS(422),
    [anon_sym_import] = ACTIONS(422),
    [anon_sym_enum] = ACTIONS(422),
    [anon_sym_public] = ACTIONS(422),
    [anon_sym_protected] = ACTIONS(422),
    [anon_sym_private] = ACTIONS(422),
    [anon_sym_abstract] = ACTIONS(422),
    [anon_sym_strictfp] = ACTIONS(422),
    [anon_sym_native] = ACTIONS(422),
    [anon_sym_transient] = ACTIONS(422),
    [anon_sym_volatile] = ACTIONS(422),
    [anon_sym_sealed] = ACTIONS(422),
    [anon_sym_non_DASHsealed] = ACTIONS(420),
    [anon_sym_record] = ACTIONS(422),
    [anon_sym_ATinterface] = ACTIONS(420),
    [anon_sym_interface] = ACTIONS(422),
    [anon_sym_byte] = ACTIONS(422),
    [anon_sym_short] = ACTIONS(422),
    [anon_sym_int] = ACTIONS(422),
    [anon_sym_long] = ACTIONS(422),
    [anon_sym_char] = ACTIONS(422),
    [anon_sym_float] = ACTIONS(422),
    [anon_sym_double] = ACTIONS(422),
    [sym_boolean_type] = ACTIONS(422),
    [sym_void_type] = ACTIONS(422),
    [sym_this] = ACTIONS(422),
    [sym_super] = ACTIONS(422),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [117] = {
    [ts_builtin_sym_end] = ACTIONS(424),
    [sym_identifier] = ACTIONS(426),
    [sym_decimal_integer_literal] = ACTIONS(426),
    [sym_hex_integer_literal] = ACTIONS(426),
    [sym_octal_integer_literal] = ACTIONS(424),
    [sym_binary_integer_literal] = ACTIONS(424),
    [sym_decimal_floating_point_literal] = ACTIONS(424),
    [sym_hex_floating_point_literal] = ACTIONS(426),
    [sym_true] = ACTIONS(426),
    [sym_false] = ACTIONS(426),
    [sym_character_literal] = ACTIONS(424),
    [sym_string_literal] = ACTIONS(426),
    [sym_text_block] = ACTIONS(424),
    [sym_null_literal] = ACTIONS(426),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_LT] = ACTIONS(424),
    [anon_sym_PLUS] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_final] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(424),
    [anon_sym_TILDE] = ACTIONS(424),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_new] = ACTIONS(426),
    [anon_sym_class] = ACTIONS(426),
    [anon_sym_switch] = ACTIONS(426),
    [anon_sym_LBRACE] = ACTIONS(424),
    [anon_sym_RBRACE] = ACTIONS(424),
    [anon_sym_case] = ACTIONS(426),
    [anon_sym_default] = ACTIONS(426),
    [anon_sym_SEMI] = ACTIONS(424),
    [anon_sym_assert] = ACTIONS(426),
    [anon_sym_do] = ACTIONS(426),
    [anon_sym_while] = ACTIONS(426),
    [anon_sym_break] = ACTIONS(426),
    [anon_sym_continue] = ACTIONS(426),
    [anon_sym_return] = ACTIONS(426),
    [anon_sym_yield] = ACTIONS(426),
    [anon_sym_synchronized] = ACTIONS(426),
    [anon_sym_throw] = ACTIONS(426),
    [anon_sym_try] = ACTIONS(426),
    [anon_sym_if] = ACTIONS(426),
    [anon_sym_else] = ACTIONS(426),
    [anon_sym_for] = ACTIONS(426),
    [anon_sym_AT] = ACTIONS(426),
    [anon_sym_open] = ACTIONS(426),
    [anon_sym_module] = ACTIONS(426),
    [anon_sym_static] = ACTIONS(426),
    [anon_sym_package] = ACTIONS(426),
    [anon_sym_import] = ACTIONS(426),
    [anon_sym_enum] = ACTIONS(426),
    [anon_sym_public] = ACTIONS(426),
    [anon_sym_protected] = ACTIONS(426),
    [anon_sym_private] = ACTIONS(426),
    [anon_sym_abstract] = ACTIONS(426),
    [anon_sym_strictfp] = ACTIONS(426),
    [anon_sym_native] = ACTIONS(426),
    [anon_sym_transient] = ACTIONS(426),
    [anon_sym_volatile] = ACTIONS(426),
    [anon_sym_sealed] = ACTIONS(426),
    [anon_sym_non_DASHsealed] = ACTIONS(424),
    [anon_sym_record] = ACTIONS(426),
    [anon_sym_ATinterface] = ACTIONS(424),
    [anon_sym_interface] = ACTIONS(426),
    [anon_sym_byte] = ACTIONS(426),
    [anon_sym_short] = ACTIONS(426),
    [anon_sym_int] = ACTIONS(426),
    [anon_sym_long] = ACTIONS(426),
    [anon_sym_char] = ACTIONS(426),
    [anon_sym_float] = ACTIONS(426),
    [anon_sym_double] = ACTIONS(426),
    [sym_boolean_type] = ACTIONS(426),
    [sym_void_type] = ACTIONS(426),
    [sym_this] = ACTIONS(426),
    [sym_super] = ACTIONS(426),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [118] = {
    [ts_builtin_sym_end] = ACTIONS(428),
    [sym_identifier] = ACTIONS(430),
    [sym_decimal_integer_literal] = ACTIONS(430),
    [sym_hex_integer_literal] = ACTIONS(430),
    [sym_octal_integer_literal] = ACTIONS(428),
    [sym_binary_integer_literal] = ACTIONS(428),
    [sym_decimal_floating_point_literal] = ACTIONS(428),
    [sym_hex_floating_point_literal] = ACTIONS(430),
    [sym_true] = ACTIONS(430),
    [sym_false] = ACTIONS(430),
    [sym_character_literal] = ACTIONS(428),
    [sym_string_literal] = ACTIONS(430),
    [sym_text_block] = ACTIONS(428),
    [sym_null_literal] = ACTIONS(430),
    [anon_sym_LPAREN] = ACTIONS(428),
    [anon_sym_LT] = ACTIONS(428),
    [anon_sym_PLUS] = ACTIONS(430),
    [anon_sym_DASH] = ACTIONS(430),
    [anon_sym_final] = ACTIONS(430),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(428),
    [anon_sym_DASH_DASH] = ACTIONS(428),
    [anon_sym_new] = ACTIONS(430),
    [anon_sym_class] = ACTIONS(430),
    [anon_sym_switch] = ACTIONS(430),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_RBRACE] = ACTIONS(428),
    [anon_sym_case] = ACTIONS(430),
    [anon_sym_default] = ACTIONS(430),
    [anon_sym_SEMI] = ACTIONS(428),
    [anon_sym_assert] = ACTIONS(430),
    [anon_sym_do] = ACTIONS(430),
    [anon_sym_while] = ACTIONS(430),
    [anon_sym_break] = ACTIONS(430),
    [anon_sym_continue] = ACTIONS(430),
    [anon_sym_return] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(430),
    [anon_sym_synchronized] = ACTIONS(430),
    [anon_sym_throw] = ACTIONS(430),
    [anon_sym_try] = ACTIONS(430),
    [anon_sym_if] = ACTIONS(430),
    [anon_sym_else] = ACTIONS(430),
    [anon_sym_for] = ACTIONS(430),
    [anon_sym_AT] = ACTIONS(430),
    [anon_sym_open] = ACTIONS(430),
    [anon_sym_module] = ACTIONS(430),
    [anon_sym_static] = ACTIONS(430),
    [anon_sym_package] = ACTIONS(430),
    [anon_sym_import] = ACTIONS(430),
    [anon_sym_enum] = ACTIONS(430),
    [anon_sym_public] = ACTIONS(430),
    [anon_sym_protected] = ACTIONS(430),
    [anon_sym_private] = ACTIONS(430),
    [anon_sym_abstract] = ACTIONS(430),
    [anon_sym_strictfp] = ACTIONS(430),
    [anon_sym_native] = ACTIONS(430),
    [anon_sym_transient] = ACTIONS(430),
    [anon_sym_volatile] = ACTIONS(430),
    [anon_sym_sealed] = ACTIONS(430),
    [anon_sym_non_DASHsealed] = ACTIONS(428),
    [anon_sym_record] = ACTIONS(430),
    [anon_sym_ATinterface] = ACTIONS(428),
    [anon_sym_interface] = ACTIONS(430),
    [anon_sym_byte] = ACTIONS(430),
    [anon_sym_short] = ACTIONS(430),
    [anon_sym_int] = ACTIONS(430),
    [anon_sym_long] = ACTIONS(430),
    [anon_sym_char] = ACTIONS(430),
    [anon_sym_float] = ACTIONS(430),
    [anon_sym_double] = ACTIONS(430),
    [sym_boolean_type] = ACTIONS(430),
    [sym_void_type] = ACTIONS(430),
    [sym_this] = ACTIONS(430),
    [sym_super] = ACTIONS(430),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [119] = {
    [ts_builtin_sym_end] = ACTIONS(432),
    [sym_identifier] = ACTIONS(434),
    [sym_decimal_integer_literal] = ACTIONS(434),
    [sym_hex_integer_literal] = ACTIONS(434),
    [sym_octal_integer_literal] = ACTIONS(432),
    [sym_binary_integer_literal] = ACTIONS(432),
    [sym_decimal_floating_point_literal] = ACTIONS(432),
    [sym_hex_floating_point_literal] = ACTIONS(434),
    [sym_true] = ACTIONS(434),
    [sym_false] = ACTIONS(434),
    [sym_character_literal] = ACTIONS(432),
    [sym_string_literal] = ACTIONS(434),
    [sym_text_block] = ACTIONS(432),
    [sym_null_literal] = ACTIONS(434),
    [anon_sym_LPAREN] = ACTIONS(432),
    [anon_sym_LT] = ACTIONS(432),
    [anon_sym_PLUS] = ACTIONS(434),
    [anon_sym_DASH] = ACTIONS(434),
    [anon_sym_final] = ACTIONS(434),
    [anon_sym_BANG] = ACTIONS(432),
    [anon_sym_TILDE] = ACTIONS(432),
    [anon_sym_PLUS_PLUS] = ACTIONS(432),
    [anon_sym_DASH_DASH] = ACTIONS(432),
    [anon_sym_new] = ACTIONS(434),
    [anon_sym_class] = ACTIONS(434),
    [anon_sym_switch] = ACTIONS(434),
    [anon_sym_LBRACE] = ACTIONS(432),
    [anon_sym_RBRACE] = ACTIONS(432),
    [anon_sym_case] = ACTIONS(434),
    [anon_sym_default] = ACTIONS(434),
    [anon_sym_SEMI] = ACTIONS(432),
    [anon_sym_assert] = ACTIONS(434),
    [anon_sym_do] = ACTIONS(434),
    [anon_sym_while] = ACTIONS(434),
    [anon_sym_break] = ACTIONS(434),
    [anon_sym_continue] = ACTIONS(434),
    [anon_sym_return] = ACTIONS(434),
    [anon_sym_yield] = ACTIONS(434),
    [anon_sym_synchronized] = ACTIONS(434),
    [anon_sym_throw] = ACTIONS(434),
    [anon_sym_try] = ACTIONS(434),
    [anon_sym_if] = ACTIONS(434),
    [anon_sym_else] = ACTIONS(434),
    [anon_sym_for] = ACTIONS(434),
    [anon_sym_AT] = ACTIONS(434),
    [anon_sym_open] = ACTIONS(434),
    [anon_sym_module] = ACTIONS(434),
    [anon_sym_static] = ACTIONS(434),
    [anon_sym_package] = ACTIONS(434),
    [anon_sym_import] = ACTIONS(434),
    [anon_sym_enum] = ACTIONS(434),
    [anon_sym_public] = ACTIONS(434),
    [anon_sym_protected] = ACTIONS(434),
    [anon_sym_private] = ACTIONS(434),
    [anon_sym_abstract] = ACTIONS(434),
    [anon_sym_strictfp] = ACTIONS(434),
    [anon_sym_native] = ACTIONS(434),
    [anon_sym_transient] = ACTIONS(434),
    [anon_sym_volatile] = ACTIONS(434),
    [anon_sym_sealed] = ACTIONS(434),
    [anon_sym_non_DASHsealed] = ACTIONS(432),
    [anon_sym_record] = ACTIONS(434),
    [anon_sym_ATinterface] = ACTIONS(432),
    [anon_sym_interface] = ACTIONS(434),
    [anon_sym_byte] = ACTIONS(434),
    [anon_sym_short] = ACTIONS(434),
    [anon_sym_int] = ACTIONS(434),
    [anon_sym_long] = ACTIONS(434),
    [anon_sym_char] = ACTIONS(434),
    [anon_sym_float] = ACTIONS(434),
    [anon_sym_double] = ACTIONS(434),
    [sym_boolean_type] = ACTIONS(434),
    [sym_void_type] = ACTIONS(434),
    [sym_this] = ACTIONS(434),
    [sym_super] = ACTIONS(434),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [120] = {
    [ts_builtin_sym_end] = ACTIONS(436),
    [sym_identifier] = ACTIONS(438),
    [sym_decimal_integer_literal] = ACTIONS(438),
    [sym_hex_integer_literal] = ACTIONS(438),
    [sym_octal_integer_literal] = ACTIONS(436),
    [sym_binary_integer_literal] = ACTIONS(436),
    [sym_decimal_floating_point_literal] = ACTIONS(436),
    [sym_hex_floating_point_literal] = ACTIONS(438),
    [sym_true] = ACTIONS(438),
    [sym_false] = ACTIONS(438),
    [sym_character_literal] = ACTIONS(436),
    [sym_string_literal] = ACTIONS(438),
    [sym_text_block] = ACTIONS(436),
    [sym_null_literal] = ACTIONS(438),
    [anon_sym_LPAREN] = ACTIONS(436),
    [anon_sym_LT] = ACTIONS(436),
    [anon_sym_PLUS] = ACTIONS(438),
    [anon_sym_DASH] = ACTIONS(438),
    [anon_sym_final] = ACTIONS(438),
    [anon_sym_BANG] = ACTIONS(436),
    [anon_sym_TILDE] = ACTIONS(436),
    [anon_sym_PLUS_PLUS] = ACTIONS(436),
    [anon_sym_DASH_DASH] = ACTIONS(436),
    [anon_sym_new] = ACTIONS(438),
    [anon_sym_class] = ACTIONS(438),
    [anon_sym_switch] = ACTIONS(438),
    [anon_sym_LBRACE] = ACTIONS(436),
    [anon_sym_RBRACE] = ACTIONS(436),
    [anon_sym_case] = ACTIONS(438),
    [anon_sym_default] = ACTIONS(438),
    [anon_sym_SEMI] = ACTIONS(436),
    [anon_sym_assert] = ACTIONS(438),
    [anon_sym_do] = ACTIONS(438),
    [anon_sym_while] = ACTIONS(438),
    [anon_sym_break] = ACTIONS(438),
    [anon_sym_continue] = ACTIONS(438),
    [anon_sym_return] = ACTIONS(438),
    [anon_sym_yield] = ACTIONS(438),
    [anon_sym_synchronized] = ACTIONS(438),
    [anon_sym_throw] = ACTIONS(438),
    [anon_sym_try] = ACTIONS(438),
    [anon_sym_if] = ACTIONS(438),
    [anon_sym_else] = ACTIONS(438),
    [anon_sym_for] = ACTIONS(438),
    [anon_sym_AT] = ACTIONS(438),
    [anon_sym_open] = ACTIONS(438),
    [anon_sym_module] = ACTIONS(438),
    [anon_sym_static] = ACTIONS(438),
    [anon_sym_package] = ACTIONS(438),
    [anon_sym_import] = ACTIONS(438),
    [anon_sym_enum] = ACTIONS(438),
    [anon_sym_public] = ACTIONS(438),
    [anon_sym_protected] = ACTIONS(438),
    [anon_sym_private] = ACTIONS(438),
    [anon_sym_abstract] = ACTIONS(438),
    [anon_sym_strictfp] = ACTIONS(438),
    [anon_sym_native] = ACTIONS(438),
    [anon_sym_transient] = ACTIONS(438),
    [anon_sym_volatile] = ACTIONS(438),
    [anon_sym_sealed] = ACTIONS(438),
    [anon_sym_non_DASHsealed] = ACTIONS(436),
    [anon_sym_record] = ACTIONS(438),
    [anon_sym_ATinterface] = ACTIONS(436),
    [anon_sym_interface] = ACTIONS(438),
    [anon_sym_byte] = ACTIONS(438),
    [anon_sym_short] = ACTIONS(438),
    [anon_sym_int] = ACTIONS(438),
    [anon_sym_long] = ACTIONS(438),
    [anon_sym_char] = ACTIONS(438),
    [anon_sym_float] = ACTIONS(438),
    [anon_sym_double] = ACTIONS(438),
    [sym_boolean_type] = ACTIONS(438),
    [sym_void_type] = ACTIONS(438),
    [sym_this] = ACTIONS(438),
    [sym_super] = ACTIONS(438),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [121] = {
    [ts_builtin_sym_end] = ACTIONS(440),
    [sym_identifier] = ACTIONS(442),
    [sym_decimal_integer_literal] = ACTIONS(442),
    [sym_hex_integer_literal] = ACTIONS(442),
    [sym_octal_integer_literal] = ACTIONS(440),
    [sym_binary_integer_literal] = ACTIONS(440),
    [sym_decimal_floating_point_literal] = ACTIONS(440),
    [sym_hex_floating_point_literal] = ACTIONS(442),
    [sym_true] = ACTIONS(442),
    [sym_false] = ACTIONS(442),
    [sym_character_literal] = ACTIONS(440),
    [sym_string_literal] = ACTIONS(442),
    [sym_text_block] = ACTIONS(440),
    [sym_null_literal] = ACTIONS(442),
    [anon_sym_LPAREN] = ACTIONS(440),
    [anon_sym_LT] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_final] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(440),
    [anon_sym_TILDE] = ACTIONS(440),
    [anon_sym_PLUS_PLUS] = ACTIONS(440),
    [anon_sym_DASH_DASH] = ACTIONS(440),
    [anon_sym_new] = ACTIONS(442),
    [anon_sym_class] = ACTIONS(442),
    [anon_sym_switch] = ACTIONS(442),
    [anon_sym_LBRACE] = ACTIONS(440),
    [anon_sym_RBRACE] = ACTIONS(440),
    [anon_sym_case] = ACTIONS(442),
    [anon_sym_default] = ACTIONS(442),
    [anon_sym_SEMI] = ACTIONS(440),
    [anon_sym_assert] = ACTIONS(442),
    [anon_sym_do] = ACTIONS(442),
    [anon_sym_while] = ACTIONS(442),
    [anon_sym_break] = ACTIONS(442),
    [anon_sym_continue] = ACTIONS(442),
    [anon_sym_return] = ACTIONS(442),
    [anon_sym_yield] = ACTIONS(442),
    [anon_sym_synchronized] = ACTIONS(442),
    [anon_sym_throw] = ACTIONS(442),
    [anon_sym_try] = ACTIONS(442),
    [anon_sym_if] = ACTIONS(442),
    [anon_sym_else] = ACTIONS(442),
    [anon_sym_for] = ACTIONS(442),
    [anon_sym_AT] = ACTIONS(442),
    [anon_sym_open] = ACTIONS(442),
    [anon_sym_module] = ACTIONS(442),
    [anon_sym_static] = ACTIONS(442),
    [anon_sym_package] = ACTIONS(442),
    [anon_sym_import] = ACTIONS(442),
    [anon_sym_enum] = ACTIONS(442),
    [anon_sym_public] = ACTIONS(442),
    [anon_sym_protected] = ACTIONS(442),
    [anon_sym_private] = ACTIONS(442),
    [anon_sym_abstract] = ACTIONS(442),
    [anon_sym_strictfp] = ACTIONS(442),
    [anon_sym_native] = ACTIONS(442),
    [anon_sym_transient] = ACTIONS(442),
    [anon_sym_volatile] = ACTIONS(442),
    [anon_sym_sealed] = ACTIONS(442),
    [anon_sym_non_DASHsealed] = ACTIONS(440),
    [anon_sym_record] = ACTIONS(442),
    [anon_sym_ATinterface] = ACTIONS(440),
    [anon_sym_interface] = ACTIONS(442),
    [anon_sym_byte] = ACTIONS(442),
    [anon_sym_short] = ACTIONS(442),
    [anon_sym_int] = ACTIONS(442),
    [anon_sym_long] = ACTIONS(442),
    [anon_sym_char] = ACTIONS(442),
    [anon_sym_float] = ACTIONS(442),
    [anon_sym_double] = ACTIONS(442),
    [sym_boolean_type] = ACTIONS(442),
    [sym_void_type] = ACTIONS(442),
    [sym_this] = ACTIONS(442),
    [sym_super] = ACTIONS(442),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [122] = {
    [ts_builtin_sym_end] = ACTIONS(444),
    [sym_identifier] = ACTIONS(446),
    [sym_decimal_integer_literal] = ACTIONS(446),
    [sym_hex_integer_literal] = ACTIONS(446),
    [sym_octal_integer_literal] = ACTIONS(444),
    [sym_binary_integer_literal] = ACTIONS(444),
    [sym_decimal_floating_point_literal] = ACTIONS(444),
    [sym_hex_floating_point_literal] = ACTIONS(446),
    [sym_true] = ACTIONS(446),
    [sym_false] = ACTIONS(446),
    [sym_character_literal] = ACTIONS(444),
    [sym_string_literal] = ACTIONS(446),
    [sym_text_block] = ACTIONS(444),
    [sym_null_literal] = ACTIONS(446),
    [anon_sym_LPAREN] = ACTIONS(444),
    [anon_sym_LT] = ACTIONS(444),
    [anon_sym_PLUS] = ACTIONS(446),
    [anon_sym_DASH] = ACTIONS(446),
    [anon_sym_final] = ACTIONS(446),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_PLUS_PLUS] = ACTIONS(444),
    [anon_sym_DASH_DASH] = ACTIONS(444),
    [anon_sym_new] = ACTIONS(446),
    [anon_sym_class] = ACTIONS(446),
    [anon_sym_switch] = ACTIONS(446),
    [anon_sym_LBRACE] = ACTIONS(444),
    [anon_sym_RBRACE] = ACTIONS(444),
    [anon_sym_case] = ACTIONS(446),
    [anon_sym_default] = ACTIONS(446),
    [anon_sym_SEMI] = ACTIONS(444),
    [anon_sym_assert] = ACTIONS(446),
    [anon_sym_do] = ACTIONS(446),
    [anon_sym_while] = ACTIONS(446),
    [anon_sym_break] = ACTIONS(446),
    [anon_sym_continue] = ACTIONS(446),
    [anon_sym_return] = ACTIONS(446),
    [anon_sym_yield] = ACTIONS(446),
    [anon_sym_synchronized] = ACTIONS(446),
    [anon_sym_throw] = ACTIONS(446),
    [anon_sym_try] = ACTIONS(446),
    [anon_sym_if] = ACTIONS(446),
    [anon_sym_else] = ACTIONS(446),
    [anon_sym_for] = ACTIONS(446),
    [anon_sym_AT] = ACTIONS(446),
    [anon_sym_open] = ACTIONS(446),
    [anon_sym_module] = ACTIONS(446),
    [anon_sym_static] = ACTIONS(446),
    [anon_sym_package] = ACTIONS(446),
    [anon_sym_import] = ACTIONS(446),
    [anon_sym_enum] = ACTIONS(446),
    [anon_sym_public] = ACTIONS(446),
    [anon_sym_protected] = ACTIONS(446),
    [anon_sym_private] = ACTIONS(446),
    [anon_sym_abstract] = ACTIONS(446),
    [anon_sym_strictfp] = ACTIONS(446),
    [anon_sym_native] = ACTIONS(446),
    [anon_sym_transient] = ACTIONS(446),
    [anon_sym_volatile] = ACTIONS(446),
    [anon_sym_sealed] = ACTIONS(446),
    [anon_sym_non_DASHsealed] = ACTIONS(444),
    [anon_sym_record] = ACTIONS(446),
    [anon_sym_ATinterface] = ACTIONS(444),
    [anon_sym_interface] = ACTIONS(446),
    [anon_sym_byte] = ACTIONS(446),
    [anon_sym_short] = ACTIONS(446),
    [anon_sym_int] = ACTIONS(446),
    [anon_sym_long] = ACTIONS(446),
    [anon_sym_char] = ACTIONS(446),
    [anon_sym_float] = ACTIONS(446),
    [anon_sym_double] = ACTIONS(446),
    [sym_boolean_type] = ACTIONS(446),
    [sym_void_type] = ACTIONS(446),
    [sym_this] = ACTIONS(446),
    [sym_super] = ACTIONS(446),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [123] = {
    [ts_builtin_sym_end] = ACTIONS(448),
    [sym_identifier] = ACTIONS(450),
    [sym_decimal_integer_literal] = ACTIONS(450),
    [sym_hex_integer_literal] = ACTIONS(450),
    [sym_octal_integer_literal] = ACTIONS(448),
    [sym_binary_integer_literal] = ACTIONS(448),
    [sym_decimal_floating_point_literal] = ACTIONS(448),
    [sym_hex_floating_point_literal] = ACTIONS(450),
    [sym_true] = ACTIONS(450),
    [sym_false] = ACTIONS(450),
    [sym_character_literal] = ACTIONS(448),
    [sym_string_literal] = ACTIONS(450),
    [sym_text_block] = ACTIONS(448),
    [sym_null_literal] = ACTIONS(450),
    [anon_sym_LPAREN] = ACTIONS(448),
    [anon_sym_LT] = ACTIONS(448),
    [anon_sym_PLUS] = ACTIONS(450),
    [anon_sym_DASH] = ACTIONS(450),
    [anon_sym_final] = ACTIONS(450),
    [anon_sym_BANG] = ACTIONS(448),
    [anon_sym_TILDE] = ACTIONS(448),
    [anon_sym_PLUS_PLUS] = ACTIONS(448),
    [anon_sym_DASH_DASH] = ACTIONS(448),
    [anon_sym_new] = ACTIONS(450),
    [anon_sym_class] = ACTIONS(450),
    [anon_sym_switch] = ACTIONS(450),
    [anon_sym_LBRACE] = ACTIONS(448),
    [anon_sym_RBRACE] = ACTIONS(448),
    [anon_sym_case] = ACTIONS(450),
    [anon_sym_default] = ACTIONS(450),
    [anon_sym_SEMI] = ACTIONS(448),
    [anon_sym_assert] = ACTIONS(450),
    [anon_sym_do] = ACTIONS(450),
    [anon_sym_while] = ACTIONS(450),
    [anon_sym_break] = ACTIONS(450),
    [anon_sym_continue] = ACTIONS(450),
    [anon_sym_return] = ACTIONS(450),
    [anon_sym_yield] = ACTIONS(450),
    [anon_sym_synchronized] = ACTIONS(450),
    [anon_sym_throw] = ACTIONS(450),
    [anon_sym_try] = ACTIONS(450),
    [anon_sym_if] = ACTIONS(450),
    [anon_sym_else] = ACTIONS(450),
    [anon_sym_for] = ACTIONS(450),
    [anon_sym_AT] = ACTIONS(450),
    [anon_sym_open] = ACTIONS(450),
    [anon_sym_module] = ACTIONS(450),
    [anon_sym_static] = ACTIONS(450),
    [anon_sym_package] = ACTIONS(450),
    [anon_sym_import] = ACTIONS(450),
    [anon_sym_enum] = ACTIONS(450),
    [anon_sym_public] = ACTIONS(450),
    [anon_sym_protected] = ACTIONS(450),
    [anon_sym_private] = ACTIONS(450),
    [anon_sym_abstract] = ACTIONS(450),
    [anon_sym_strictfp] = ACTIONS(450),
    [anon_sym_native] = ACTIONS(450),
    [anon_sym_transient] = ACTIONS(450),
    [anon_sym_volatile] = ACTIONS(450),
    [anon_sym_sealed] = ACTIONS(450),
    [anon_sym_non_DASHsealed] = ACTIONS(448),
    [anon_sym_record] = ACTIONS(450),
    [anon_sym_ATinterface] = ACTIONS(448),
    [anon_sym_interface] = ACTIONS(450),
    [anon_sym_byte] = ACTIONS(450),
    [anon_sym_short] = ACTIONS(450),
    [anon_sym_int] = ACTIONS(450),
    [anon_sym_long] = ACTIONS(450),
    [anon_sym_char] = ACTIONS(450),
    [anon_sym_float] = ACTIONS(450),
    [anon_sym_double] = ACTIONS(450),
    [sym_boolean_type] = ACTIONS(450),
    [sym_void_type] = ACTIONS(450),
    [sym_this] = ACTIONS(450),
    [sym_super] = ACTIONS(450),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [124] = {
    [ts_builtin_sym_end] = ACTIONS(452),
    [sym_identifier] = ACTIONS(454),
    [sym_decimal_integer_literal] = ACTIONS(454),
    [sym_hex_integer_literal] = ACTIONS(454),
    [sym_octal_integer_literal] = ACTIONS(452),
    [sym_binary_integer_literal] = ACTIONS(452),
    [sym_decimal_floating_point_literal] = ACTIONS(452),
    [sym_hex_floating_point_literal] = ACTIONS(454),
    [sym_true] = ACTIONS(454),
    [sym_false] = ACTIONS(454),
    [sym_character_literal] = ACTIONS(452),
    [sym_string_literal] = ACTIONS(454),
    [sym_text_block] = ACTIONS(452),
    [sym_null_literal] = ACTIONS(454),
    [anon_sym_LPAREN] = ACTIONS(452),
    [anon_sym_LT] = ACTIONS(452),
    [anon_sym_PLUS] = ACTIONS(454),
    [anon_sym_DASH] = ACTIONS(454),
    [anon_sym_final] = ACTIONS(454),
    [anon_sym_BANG] = ACTIONS(452),
    [anon_sym_TILDE] = ACTIONS(452),
    [anon_sym_PLUS_PLUS] = ACTIONS(452),
    [anon_sym_DASH_DASH] = ACTIONS(452),
    [anon_sym_new] = ACTIONS(454),
    [anon_sym_class] = ACTIONS(454),
    [anon_sym_switch] = ACTIONS(454),
    [anon_sym_LBRACE] = ACTIONS(452),
    [anon_sym_RBRACE] = ACTIONS(452),
    [anon_sym_case] = ACTIONS(454),
    [anon_sym_default] = ACTIONS(454),
    [anon_sym_SEMI] = ACTIONS(452),
    [anon_sym_assert] = ACTIONS(454),
    [anon_sym_do] = ACTIONS(454),
    [anon_sym_while] = ACTIONS(454),
    [anon_sym_break] = ACTIONS(454),
    [anon_sym_continue] = ACTIONS(454),
    [anon_sym_return] = ACTIONS(454),
    [anon_sym_yield] = ACTIONS(454),
    [anon_sym_synchronized] = ACTIONS(454),
    [anon_sym_throw] = ACTIONS(454),
    [anon_sym_try] = ACTIONS(454),
    [anon_sym_if] = ACTIONS(454),
    [anon_sym_else] = ACTIONS(454),
    [anon_sym_for] = ACTIONS(454),
    [anon_sym_AT] = ACTIONS(454),
    [anon_sym_open] = ACTIONS(454),
    [anon_sym_module] = ACTIONS(454),
    [anon_sym_static] = ACTIONS(454),
    [anon_sym_package] = ACTIONS(454),
    [anon_sym_import] = ACTIONS(454),
    [anon_sym_enum] = ACTIONS(454),
    [anon_sym_public] = ACTIONS(454),
    [anon_sym_protected] = ACTIONS(454),
    [anon_sym_private] = ACTIONS(454),
    [anon_sym_abstract] = ACTIONS(454),
    [anon_sym_strictfp] = ACTIONS(454),
    [anon_sym_native] = ACTIONS(454),
    [anon_sym_transient] = ACTIONS(454),
    [anon_sym_volatile] = ACTIONS(454),
    [anon_sym_sealed] = ACTIONS(454),
    [anon_sym_non_DASHsealed] = ACTIONS(452),
    [anon_sym_record] = ACTIONS(454),
    [anon_sym_ATinterface] = ACTIONS(452),
    [anon_sym_interface] = ACTIONS(454),
    [anon_sym_byte] = ACTIONS(454),
    [anon_sym_short] = ACTIONS(454),
    [anon_sym_int] = ACTIONS(454),
    [anon_sym_long] = ACTIONS(454),
    [anon_sym_char] = ACTIONS(454),
    [anon_sym_float] = ACTIONS(454),
    [anon_sym_double] = ACTIONS(454),
    [sym_boolean_type] = ACTIONS(454),
    [sym_void_type] = ACTIONS(454),
    [sym_this] = ACTIONS(454),
    [sym_super] = ACTIONS(454),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [125] = {
    [ts_builtin_sym_end] = ACTIONS(456),
    [sym_identifier] = ACTIONS(458),
    [sym_decimal_integer_literal] = ACTIONS(458),
    [sym_hex_integer_literal] = ACTIONS(458),
    [sym_octal_integer_literal] = ACTIONS(456),
    [sym_binary_integer_literal] = ACTIONS(456),
    [sym_decimal_floating_point_literal] = ACTIONS(456),
    [sym_hex_floating_point_literal] = ACTIONS(458),
    [sym_true] = ACTIONS(458),
    [sym_false] = ACTIONS(458),
    [sym_character_literal] = ACTIONS(456),
    [sym_string_literal] = ACTIONS(458),
    [sym_text_block] = ACTIONS(456),
    [sym_null_literal] = ACTIONS(458),
    [anon_sym_LPAREN] = ACTIONS(456),
    [anon_sym_LT] = ACTIONS(456),
    [anon_sym_PLUS] = ACTIONS(458),
    [anon_sym_DASH] = ACTIONS(458),
    [anon_sym_final] = ACTIONS(458),
    [anon_sym_BANG] = ACTIONS(456),
    [anon_sym_TILDE] = ACTIONS(456),
    [anon_sym_PLUS_PLUS] = ACTIONS(456),
    [anon_sym_DASH_DASH] = ACTIONS(456),
    [anon_sym_new] = ACTIONS(458),
    [anon_sym_class] = ACTIONS(458),
    [anon_sym_switch] = ACTIONS(458),
    [anon_sym_LBRACE] = ACTIONS(456),
    [anon_sym_RBRACE] = ACTIONS(456),
    [anon_sym_case] = ACTIONS(458),
    [anon_sym_default] = ACTIONS(458),
    [anon_sym_SEMI] = ACTIONS(456),
    [anon_sym_assert] = ACTIONS(458),
    [anon_sym_do] = ACTIONS(458),
    [anon_sym_while] = ACTIONS(458),
    [anon_sym_break] = ACTIONS(458),
    [anon_sym_continue] = ACTIONS(458),
    [anon_sym_return] = ACTIONS(458),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_synchronized] = ACTIONS(458),
    [anon_sym_throw] = ACTIONS(458),
    [anon_sym_try] = ACTIONS(458),
    [anon_sym_if] = ACTIONS(458),
    [anon_sym_else] = ACTIONS(458),
    [anon_sym_for] = ACTIONS(458),
    [anon_sym_AT] = ACTIONS(458),
    [anon_sym_open] = ACTIONS(458),
    [anon_sym_module] = ACTIONS(458),
    [anon_sym_static] = ACTIONS(458),
    [anon_sym_package] = ACTIONS(458),
    [anon_sym_import] = ACTIONS(458),
    [anon_sym_enum] = ACTIONS(458),
    [anon_sym_public] = ACTIONS(458),
    [anon_sym_protected] = ACTIONS(458),
    [anon_sym_private] = ACTIONS(458),
    [anon_sym_abstract] = ACTIONS(458),
    [anon_sym_strictfp] = ACTIONS(458),
    [anon_sym_native] = ACTIONS(458),
    [anon_sym_transient] = ACTIONS(458),
    [anon_sym_volatile] = ACTIONS(458),
    [anon_sym_sealed] = ACTIONS(458),
    [anon_sym_non_DASHsealed] = ACTIONS(456),
    [anon_sym_record] = ACTIONS(458),
    [anon_sym_ATinterface] = ACTIONS(456),
    [anon_sym_interface] = ACTIONS(458),
    [anon_sym_byte] = ACTIONS(458),
    [anon_sym_short] = ACTIONS(458),
    [anon_sym_int] = ACTIONS(458),
    [anon_sym_long] = ACTIONS(458),
    [anon_sym_char] = ACTIONS(458),
    [anon_sym_float] = ACTIONS(458),
    [anon_sym_double] = ACTIONS(458),
    [sym_boolean_type] = ACTIONS(458),
    [sym_void_type] = ACTIONS(458),
    [sym_this] = ACTIONS(458),
    [sym_super] = ACTIONS(458),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [126] = {
    [ts_builtin_sym_end] = ACTIONS(460),
    [sym_identifier] = ACTIONS(462),
    [sym_decimal_integer_literal] = ACTIONS(462),
    [sym_hex_integer_literal] = ACTIONS(462),
    [sym_octal_integer_literal] = ACTIONS(460),
    [sym_binary_integer_literal] = ACTIONS(460),
    [sym_decimal_floating_point_literal] = ACTIONS(460),
    [sym_hex_floating_point_literal] = ACTIONS(462),
    [sym_true] = ACTIONS(462),
    [sym_false] = ACTIONS(462),
    [sym_character_literal] = ACTIONS(460),
    [sym_string_literal] = ACTIONS(462),
    [sym_text_block] = ACTIONS(460),
    [sym_null_literal] = ACTIONS(462),
    [anon_sym_LPAREN] = ACTIONS(460),
    [anon_sym_LT] = ACTIONS(460),
    [anon_sym_PLUS] = ACTIONS(462),
    [anon_sym_DASH] = ACTIONS(462),
    [anon_sym_final] = ACTIONS(462),
    [anon_sym_BANG] = ACTIONS(460),
    [anon_sym_TILDE] = ACTIONS(460),
    [anon_sym_PLUS_PLUS] = ACTIONS(460),
    [anon_sym_DASH_DASH] = ACTIONS(460),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_class] = ACTIONS(462),
    [anon_sym_switch] = ACTIONS(462),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_RBRACE] = ACTIONS(460),
    [anon_sym_case] = ACTIONS(462),
    [anon_sym_default] = ACTIONS(462),
    [anon_sym_SEMI] = ACTIONS(460),
    [anon_sym_assert] = ACTIONS(462),
    [anon_sym_do] = ACTIONS(462),
    [anon_sym_while] = ACTIONS(462),
    [anon_sym_break] = ACTIONS(462),
    [anon_sym_continue] = ACTIONS(462),
    [anon_sym_return] = ACTIONS(462),
    [anon_sym_yield] = ACTIONS(462),
    [anon_sym_synchronized] = ACTIONS(462),
    [anon_sym_throw] = ACTIONS(462),
    [anon_sym_try] = ACTIONS(462),
    [anon_sym_if] = ACTIONS(462),
    [anon_sym_else] = ACTIONS(462),
    [anon_sym_for] = ACTIONS(462),
    [anon_sym_AT] = ACTIONS(462),
    [anon_sym_open] = ACTIONS(462),
    [anon_sym_module] = ACTIONS(462),
    [anon_sym_static] = ACTIONS(462),
    [anon_sym_package] = ACTIONS(462),
    [anon_sym_import] = ACTIONS(462),
    [anon_sym_enum] = ACTIONS(462),
    [anon_sym_public] = ACTIONS(462),
    [anon_sym_protected] = ACTIONS(462),
    [anon_sym_private] = ACTIONS(462),
    [anon_sym_abstract] = ACTIONS(462),
    [anon_sym_strictfp] = ACTIONS(462),
    [anon_sym_native] = ACTIONS(462),
    [anon_sym_transient] = ACTIONS(462),
    [anon_sym_volatile] = ACTIONS(462),
    [anon_sym_sealed] = ACTIONS(462),
    [anon_sym_non_DASHsealed] = ACTIONS(460),
    [anon_sym_record] = ACTIONS(462),
    [anon_sym_ATinterface] = ACTIONS(460),
    [anon_sym_interface] = ACTIONS(462),
    [anon_sym_byte] = ACTIONS(462),
    [anon_sym_short] = ACTIONS(462),
    [anon_sym_int] = ACTIONS(462),
    [anon_sym_long] = ACTIONS(462),
    [anon_sym_char] = ACTIONS(462),
    [anon_sym_float] = ACTIONS(462),
    [anon_sym_double] = ACTIONS(462),
    [sym_boolean_type] = ACTIONS(462),
    [sym_void_type] = ACTIONS(462),
    [sym_this] = ACTIONS(462),
    [sym_super] = ACTIONS(462),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [127] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(608),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(710),
    [sym_marker_annotation] = STATE(710),
    [sym_annotation] = STATE(710),
    [sym__element_value] = STATE(1170),
    [sym_element_value_array_initializer] = STATE(1170),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(307),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [128] = {
    [ts_builtin_sym_end] = ACTIONS(464),
    [sym_identifier] = ACTIONS(466),
    [sym_decimal_integer_literal] = ACTIONS(466),
    [sym_hex_integer_literal] = ACTIONS(466),
    [sym_octal_integer_literal] = ACTIONS(464),
    [sym_binary_integer_literal] = ACTIONS(464),
    [sym_decimal_floating_point_literal] = ACTIONS(464),
    [sym_hex_floating_point_literal] = ACTIONS(466),
    [sym_true] = ACTIONS(466),
    [sym_false] = ACTIONS(466),
    [sym_character_literal] = ACTIONS(464),
    [sym_string_literal] = ACTIONS(466),
    [sym_text_block] = ACTIONS(464),
    [sym_null_literal] = ACTIONS(466),
    [anon_sym_LPAREN] = ACTIONS(464),
    [anon_sym_LT] = ACTIONS(464),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_DASH] = ACTIONS(466),
    [anon_sym_final] = ACTIONS(466),
    [anon_sym_BANG] = ACTIONS(464),
    [anon_sym_TILDE] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(464),
    [anon_sym_DASH_DASH] = ACTIONS(464),
    [anon_sym_new] = ACTIONS(466),
    [anon_sym_class] = ACTIONS(466),
    [anon_sym_switch] = ACTIONS(466),
    [anon_sym_LBRACE] = ACTIONS(464),
    [anon_sym_RBRACE] = ACTIONS(464),
    [anon_sym_case] = ACTIONS(466),
    [anon_sym_default] = ACTIONS(466),
    [anon_sym_SEMI] = ACTIONS(464),
    [anon_sym_assert] = ACTIONS(466),
    [anon_sym_do] = ACTIONS(466),
    [anon_sym_while] = ACTIONS(466),
    [anon_sym_break] = ACTIONS(466),
    [anon_sym_continue] = ACTIONS(466),
    [anon_sym_return] = ACTIONS(466),
    [anon_sym_yield] = ACTIONS(466),
    [anon_sym_synchronized] = ACTIONS(466),
    [anon_sym_throw] = ACTIONS(466),
    [anon_sym_try] = ACTIONS(466),
    [anon_sym_if] = ACTIONS(466),
    [anon_sym_else] = ACTIONS(466),
    [anon_sym_for] = ACTIONS(466),
    [anon_sym_AT] = ACTIONS(466),
    [anon_sym_open] = ACTIONS(466),
    [anon_sym_module] = ACTIONS(466),
    [anon_sym_static] = ACTIONS(466),
    [anon_sym_package] = ACTIONS(466),
    [anon_sym_import] = ACTIONS(466),
    [anon_sym_enum] = ACTIONS(466),
    [anon_sym_public] = ACTIONS(466),
    [anon_sym_protected] = ACTIONS(466),
    [anon_sym_private] = ACTIONS(466),
    [anon_sym_abstract] = ACTIONS(466),
    [anon_sym_strictfp] = ACTIONS(466),
    [anon_sym_native] = ACTIONS(466),
    [anon_sym_transient] = ACTIONS(466),
    [anon_sym_volatile] = ACTIONS(466),
    [anon_sym_sealed] = ACTIONS(466),
    [anon_sym_non_DASHsealed] = ACTIONS(464),
    [anon_sym_record] = ACTIONS(466),
    [anon_sym_ATinterface] = ACTIONS(464),
    [anon_sym_interface] = ACTIONS(466),
    [anon_sym_byte] = ACTIONS(466),
    [anon_sym_short] = ACTIONS(466),
    [anon_sym_int] = ACTIONS(466),
    [anon_sym_long] = ACTIONS(466),
    [anon_sym_char] = ACTIONS(466),
    [anon_sym_float] = ACTIONS(466),
    [anon_sym_double] = ACTIONS(466),
    [sym_boolean_type] = ACTIONS(466),
    [sym_void_type] = ACTIONS(466),
    [sym_this] = ACTIONS(466),
    [sym_super] = ACTIONS(466),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [129] = {
    [ts_builtin_sym_end] = ACTIONS(468),
    [sym_identifier] = ACTIONS(470),
    [sym_decimal_integer_literal] = ACTIONS(470),
    [sym_hex_integer_literal] = ACTIONS(470),
    [sym_octal_integer_literal] = ACTIONS(468),
    [sym_binary_integer_literal] = ACTIONS(468),
    [sym_decimal_floating_point_literal] = ACTIONS(468),
    [sym_hex_floating_point_literal] = ACTIONS(470),
    [sym_true] = ACTIONS(470),
    [sym_false] = ACTIONS(470),
    [sym_character_literal] = ACTIONS(468),
    [sym_string_literal] = ACTIONS(470),
    [sym_text_block] = ACTIONS(468),
    [sym_null_literal] = ACTIONS(470),
    [anon_sym_LPAREN] = ACTIONS(468),
    [anon_sym_LT] = ACTIONS(468),
    [anon_sym_PLUS] = ACTIONS(470),
    [anon_sym_DASH] = ACTIONS(470),
    [anon_sym_final] = ACTIONS(470),
    [anon_sym_BANG] = ACTIONS(468),
    [anon_sym_TILDE] = ACTIONS(468),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_new] = ACTIONS(470),
    [anon_sym_class] = ACTIONS(470),
    [anon_sym_switch] = ACTIONS(470),
    [anon_sym_LBRACE] = ACTIONS(468),
    [anon_sym_RBRACE] = ACTIONS(468),
    [anon_sym_case] = ACTIONS(470),
    [anon_sym_default] = ACTIONS(470),
    [anon_sym_SEMI] = ACTIONS(468),
    [anon_sym_assert] = ACTIONS(470),
    [anon_sym_do] = ACTIONS(470),
    [anon_sym_while] = ACTIONS(470),
    [anon_sym_break] = ACTIONS(470),
    [anon_sym_continue] = ACTIONS(470),
    [anon_sym_return] = ACTIONS(470),
    [anon_sym_yield] = ACTIONS(470),
    [anon_sym_synchronized] = ACTIONS(470),
    [anon_sym_throw] = ACTIONS(470),
    [anon_sym_try] = ACTIONS(470),
    [anon_sym_if] = ACTIONS(470),
    [anon_sym_else] = ACTIONS(470),
    [anon_sym_for] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(470),
    [anon_sym_open] = ACTIONS(470),
    [anon_sym_module] = ACTIONS(470),
    [anon_sym_static] = ACTIONS(470),
    [anon_sym_package] = ACTIONS(470),
    [anon_sym_import] = ACTIONS(470),
    [anon_sym_enum] = ACTIONS(470),
    [anon_sym_public] = ACTIONS(470),
    [anon_sym_protected] = ACTIONS(470),
    [anon_sym_private] = ACTIONS(470),
    [anon_sym_abstract] = ACTIONS(470),
    [anon_sym_strictfp] = ACTIONS(470),
    [anon_sym_native] = ACTIONS(470),
    [anon_sym_transient] = ACTIONS(470),
    [anon_sym_volatile] = ACTIONS(470),
    [anon_sym_sealed] = ACTIONS(470),
    [anon_sym_non_DASHsealed] = ACTIONS(468),
    [anon_sym_record] = ACTIONS(470),
    [anon_sym_ATinterface] = ACTIONS(468),
    [anon_sym_interface] = ACTIONS(470),
    [anon_sym_byte] = ACTIONS(470),
    [anon_sym_short] = ACTIONS(470),
    [anon_sym_int] = ACTIONS(470),
    [anon_sym_long] = ACTIONS(470),
    [anon_sym_char] = ACTIONS(470),
    [anon_sym_float] = ACTIONS(470),
    [anon_sym_double] = ACTIONS(470),
    [sym_boolean_type] = ACTIONS(470),
    [sym_void_type] = ACTIONS(470),
    [sym_this] = ACTIONS(470),
    [sym_super] = ACTIONS(470),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [130] = {
    [ts_builtin_sym_end] = ACTIONS(472),
    [sym_identifier] = ACTIONS(474),
    [sym_decimal_integer_literal] = ACTIONS(474),
    [sym_hex_integer_literal] = ACTIONS(474),
    [sym_octal_integer_literal] = ACTIONS(472),
    [sym_binary_integer_literal] = ACTIONS(472),
    [sym_decimal_floating_point_literal] = ACTIONS(472),
    [sym_hex_floating_point_literal] = ACTIONS(474),
    [sym_true] = ACTIONS(474),
    [sym_false] = ACTIONS(474),
    [sym_character_literal] = ACTIONS(472),
    [sym_string_literal] = ACTIONS(474),
    [sym_text_block] = ACTIONS(472),
    [sym_null_literal] = ACTIONS(474),
    [anon_sym_LPAREN] = ACTIONS(472),
    [anon_sym_LT] = ACTIONS(472),
    [anon_sym_PLUS] = ACTIONS(474),
    [anon_sym_DASH] = ACTIONS(474),
    [anon_sym_final] = ACTIONS(474),
    [anon_sym_BANG] = ACTIONS(472),
    [anon_sym_TILDE] = ACTIONS(472),
    [anon_sym_PLUS_PLUS] = ACTIONS(472),
    [anon_sym_DASH_DASH] = ACTIONS(472),
    [anon_sym_new] = ACTIONS(474),
    [anon_sym_class] = ACTIONS(474),
    [anon_sym_switch] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(472),
    [anon_sym_RBRACE] = ACTIONS(472),
    [anon_sym_case] = ACTIONS(474),
    [anon_sym_default] = ACTIONS(474),
    [anon_sym_SEMI] = ACTIONS(472),
    [anon_sym_assert] = ACTIONS(474),
    [anon_sym_do] = ACTIONS(474),
    [anon_sym_while] = ACTIONS(474),
    [anon_sym_break] = ACTIONS(474),
    [anon_sym_continue] = ACTIONS(474),
    [anon_sym_return] = ACTIONS(474),
    [anon_sym_yield] = ACTIONS(474),
    [anon_sym_synchronized] = ACTIONS(474),
    [anon_sym_throw] = ACTIONS(474),
    [anon_sym_try] = ACTIONS(474),
    [anon_sym_if] = ACTIONS(474),
    [anon_sym_else] = ACTIONS(474),
    [anon_sym_for] = ACTIONS(474),
    [anon_sym_AT] = ACTIONS(474),
    [anon_sym_open] = ACTIONS(474),
    [anon_sym_module] = ACTIONS(474),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_package] = ACTIONS(474),
    [anon_sym_import] = ACTIONS(474),
    [anon_sym_enum] = ACTIONS(474),
    [anon_sym_public] = ACTIONS(474),
    [anon_sym_protected] = ACTIONS(474),
    [anon_sym_private] = ACTIONS(474),
    [anon_sym_abstract] = ACTIONS(474),
    [anon_sym_strictfp] = ACTIONS(474),
    [anon_sym_native] = ACTIONS(474),
    [anon_sym_transient] = ACTIONS(474),
    [anon_sym_volatile] = ACTIONS(474),
    [anon_sym_sealed] = ACTIONS(474),
    [anon_sym_non_DASHsealed] = ACTIONS(472),
    [anon_sym_record] = ACTIONS(474),
    [anon_sym_ATinterface] = ACTIONS(472),
    [anon_sym_interface] = ACTIONS(474),
    [anon_sym_byte] = ACTIONS(474),
    [anon_sym_short] = ACTIONS(474),
    [anon_sym_int] = ACTIONS(474),
    [anon_sym_long] = ACTIONS(474),
    [anon_sym_char] = ACTIONS(474),
    [anon_sym_float] = ACTIONS(474),
    [anon_sym_double] = ACTIONS(474),
    [sym_boolean_type] = ACTIONS(474),
    [sym_void_type] = ACTIONS(474),
    [sym_this] = ACTIONS(474),
    [sym_super] = ACTIONS(474),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [131] = {
    [ts_builtin_sym_end] = ACTIONS(476),
    [sym_identifier] = ACTIONS(478),
    [sym_decimal_integer_literal] = ACTIONS(478),
    [sym_hex_integer_literal] = ACTIONS(478),
    [sym_octal_integer_literal] = ACTIONS(476),
    [sym_binary_integer_literal] = ACTIONS(476),
    [sym_decimal_floating_point_literal] = ACTIONS(476),
    [sym_hex_floating_point_literal] = ACTIONS(478),
    [sym_true] = ACTIONS(478),
    [sym_false] = ACTIONS(478),
    [sym_character_literal] = ACTIONS(476),
    [sym_string_literal] = ACTIONS(478),
    [sym_text_block] = ACTIONS(476),
    [sym_null_literal] = ACTIONS(478),
    [anon_sym_LPAREN] = ACTIONS(476),
    [anon_sym_LT] = ACTIONS(476),
    [anon_sym_PLUS] = ACTIONS(478),
    [anon_sym_DASH] = ACTIONS(478),
    [anon_sym_final] = ACTIONS(478),
    [anon_sym_BANG] = ACTIONS(476),
    [anon_sym_TILDE] = ACTIONS(476),
    [anon_sym_PLUS_PLUS] = ACTIONS(476),
    [anon_sym_DASH_DASH] = ACTIONS(476),
    [anon_sym_new] = ACTIONS(478),
    [anon_sym_class] = ACTIONS(478),
    [anon_sym_switch] = ACTIONS(478),
    [anon_sym_LBRACE] = ACTIONS(476),
    [anon_sym_RBRACE] = ACTIONS(476),
    [anon_sym_case] = ACTIONS(478),
    [anon_sym_default] = ACTIONS(478),
    [anon_sym_SEMI] = ACTIONS(476),
    [anon_sym_assert] = ACTIONS(478),
    [anon_sym_do] = ACTIONS(478),
    [anon_sym_while] = ACTIONS(478),
    [anon_sym_break] = ACTIONS(478),
    [anon_sym_continue] = ACTIONS(478),
    [anon_sym_return] = ACTIONS(478),
    [anon_sym_yield] = ACTIONS(478),
    [anon_sym_synchronized] = ACTIONS(478),
    [anon_sym_throw] = ACTIONS(478),
    [anon_sym_try] = ACTIONS(478),
    [anon_sym_if] = ACTIONS(478),
    [anon_sym_else] = ACTIONS(478),
    [anon_sym_for] = ACTIONS(478),
    [anon_sym_AT] = ACTIONS(478),
    [anon_sym_open] = ACTIONS(478),
    [anon_sym_module] = ACTIONS(478),
    [anon_sym_static] = ACTIONS(478),
    [anon_sym_package] = ACTIONS(478),
    [anon_sym_import] = ACTIONS(478),
    [anon_sym_enum] = ACTIONS(478),
    [anon_sym_public] = ACTIONS(478),
    [anon_sym_protected] = ACTIONS(478),
    [anon_sym_private] = ACTIONS(478),
    [anon_sym_abstract] = ACTIONS(478),
    [anon_sym_strictfp] = ACTIONS(478),
    [anon_sym_native] = ACTIONS(478),
    [anon_sym_transient] = ACTIONS(478),
    [anon_sym_volatile] = ACTIONS(478),
    [anon_sym_sealed] = ACTIONS(478),
    [anon_sym_non_DASHsealed] = ACTIONS(476),
    [anon_sym_record] = ACTIONS(478),
    [anon_sym_ATinterface] = ACTIONS(476),
    [anon_sym_interface] = ACTIONS(478),
    [anon_sym_byte] = ACTIONS(478),
    [anon_sym_short] = ACTIONS(478),
    [anon_sym_int] = ACTIONS(478),
    [anon_sym_long] = ACTIONS(478),
    [anon_sym_char] = ACTIONS(478),
    [anon_sym_float] = ACTIONS(478),
    [anon_sym_double] = ACTIONS(478),
    [sym_boolean_type] = ACTIONS(478),
    [sym_void_type] = ACTIONS(478),
    [sym_this] = ACTIONS(478),
    [sym_super] = ACTIONS(478),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [132] = {
    [ts_builtin_sym_end] = ACTIONS(480),
    [sym_identifier] = ACTIONS(482),
    [sym_decimal_integer_literal] = ACTIONS(482),
    [sym_hex_integer_literal] = ACTIONS(482),
    [sym_octal_integer_literal] = ACTIONS(480),
    [sym_binary_integer_literal] = ACTIONS(480),
    [sym_decimal_floating_point_literal] = ACTIONS(480),
    [sym_hex_floating_point_literal] = ACTIONS(482),
    [sym_true] = ACTIONS(482),
    [sym_false] = ACTIONS(482),
    [sym_character_literal] = ACTIONS(480),
    [sym_string_literal] = ACTIONS(482),
    [sym_text_block] = ACTIONS(480),
    [sym_null_literal] = ACTIONS(482),
    [anon_sym_LPAREN] = ACTIONS(480),
    [anon_sym_LT] = ACTIONS(480),
    [anon_sym_PLUS] = ACTIONS(482),
    [anon_sym_DASH] = ACTIONS(482),
    [anon_sym_final] = ACTIONS(482),
    [anon_sym_BANG] = ACTIONS(480),
    [anon_sym_TILDE] = ACTIONS(480),
    [anon_sym_PLUS_PLUS] = ACTIONS(480),
    [anon_sym_DASH_DASH] = ACTIONS(480),
    [anon_sym_new] = ACTIONS(482),
    [anon_sym_class] = ACTIONS(482),
    [anon_sym_switch] = ACTIONS(482),
    [anon_sym_LBRACE] = ACTIONS(480),
    [anon_sym_RBRACE] = ACTIONS(480),
    [anon_sym_case] = ACTIONS(482),
    [anon_sym_default] = ACTIONS(482),
    [anon_sym_SEMI] = ACTIONS(480),
    [anon_sym_assert] = ACTIONS(482),
    [anon_sym_do] = ACTIONS(482),
    [anon_sym_while] = ACTIONS(482),
    [anon_sym_break] = ACTIONS(482),
    [anon_sym_continue] = ACTIONS(482),
    [anon_sym_return] = ACTIONS(482),
    [anon_sym_yield] = ACTIONS(482),
    [anon_sym_synchronized] = ACTIONS(482),
    [anon_sym_throw] = ACTIONS(482),
    [anon_sym_try] = ACTIONS(482),
    [anon_sym_if] = ACTIONS(482),
    [anon_sym_else] = ACTIONS(482),
    [anon_sym_for] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(482),
    [anon_sym_open] = ACTIONS(482),
    [anon_sym_module] = ACTIONS(482),
    [anon_sym_static] = ACTIONS(482),
    [anon_sym_package] = ACTIONS(482),
    [anon_sym_import] = ACTIONS(482),
    [anon_sym_enum] = ACTIONS(482),
    [anon_sym_public] = ACTIONS(482),
    [anon_sym_protected] = ACTIONS(482),
    [anon_sym_private] = ACTIONS(482),
    [anon_sym_abstract] = ACTIONS(482),
    [anon_sym_strictfp] = ACTIONS(482),
    [anon_sym_native] = ACTIONS(482),
    [anon_sym_transient] = ACTIONS(482),
    [anon_sym_volatile] = ACTIONS(482),
    [anon_sym_sealed] = ACTIONS(482),
    [anon_sym_non_DASHsealed] = ACTIONS(480),
    [anon_sym_record] = ACTIONS(482),
    [anon_sym_ATinterface] = ACTIONS(480),
    [anon_sym_interface] = ACTIONS(482),
    [anon_sym_byte] = ACTIONS(482),
    [anon_sym_short] = ACTIONS(482),
    [anon_sym_int] = ACTIONS(482),
    [anon_sym_long] = ACTIONS(482),
    [anon_sym_char] = ACTIONS(482),
    [anon_sym_float] = ACTIONS(482),
    [anon_sym_double] = ACTIONS(482),
    [sym_boolean_type] = ACTIONS(482),
    [sym_void_type] = ACTIONS(482),
    [sym_this] = ACTIONS(482),
    [sym_super] = ACTIONS(482),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [133] = {
    [ts_builtin_sym_end] = ACTIONS(484),
    [sym_identifier] = ACTIONS(486),
    [sym_decimal_integer_literal] = ACTIONS(486),
    [sym_hex_integer_literal] = ACTIONS(486),
    [sym_octal_integer_literal] = ACTIONS(484),
    [sym_binary_integer_literal] = ACTIONS(484),
    [sym_decimal_floating_point_literal] = ACTIONS(484),
    [sym_hex_floating_point_literal] = ACTIONS(486),
    [sym_true] = ACTIONS(486),
    [sym_false] = ACTIONS(486),
    [sym_character_literal] = ACTIONS(484),
    [sym_string_literal] = ACTIONS(486),
    [sym_text_block] = ACTIONS(484),
    [sym_null_literal] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(484),
    [anon_sym_LT] = ACTIONS(484),
    [anon_sym_PLUS] = ACTIONS(486),
    [anon_sym_DASH] = ACTIONS(486),
    [anon_sym_final] = ACTIONS(486),
    [anon_sym_BANG] = ACTIONS(484),
    [anon_sym_TILDE] = ACTIONS(484),
    [anon_sym_PLUS_PLUS] = ACTIONS(484),
    [anon_sym_DASH_DASH] = ACTIONS(484),
    [anon_sym_new] = ACTIONS(486),
    [anon_sym_class] = ACTIONS(486),
    [anon_sym_switch] = ACTIONS(486),
    [anon_sym_LBRACE] = ACTIONS(484),
    [anon_sym_RBRACE] = ACTIONS(484),
    [anon_sym_case] = ACTIONS(486),
    [anon_sym_default] = ACTIONS(486),
    [anon_sym_SEMI] = ACTIONS(484),
    [anon_sym_assert] = ACTIONS(486),
    [anon_sym_do] = ACTIONS(486),
    [anon_sym_while] = ACTIONS(486),
    [anon_sym_break] = ACTIONS(486),
    [anon_sym_continue] = ACTIONS(486),
    [anon_sym_return] = ACTIONS(486),
    [anon_sym_yield] = ACTIONS(486),
    [anon_sym_synchronized] = ACTIONS(486),
    [anon_sym_throw] = ACTIONS(486),
    [anon_sym_try] = ACTIONS(486),
    [anon_sym_if] = ACTIONS(486),
    [anon_sym_else] = ACTIONS(486),
    [anon_sym_for] = ACTIONS(486),
    [anon_sym_AT] = ACTIONS(486),
    [anon_sym_open] = ACTIONS(486),
    [anon_sym_module] = ACTIONS(486),
    [anon_sym_static] = ACTIONS(486),
    [anon_sym_package] = ACTIONS(486),
    [anon_sym_import] = ACTIONS(486),
    [anon_sym_enum] = ACTIONS(486),
    [anon_sym_public] = ACTIONS(486),
    [anon_sym_protected] = ACTIONS(486),
    [anon_sym_private] = ACTIONS(486),
    [anon_sym_abstract] = ACTIONS(486),
    [anon_sym_strictfp] = ACTIONS(486),
    [anon_sym_native] = ACTIONS(486),
    [anon_sym_transient] = ACTIONS(486),
    [anon_sym_volatile] = ACTIONS(486),
    [anon_sym_sealed] = ACTIONS(486),
    [anon_sym_non_DASHsealed] = ACTIONS(484),
    [anon_sym_record] = ACTIONS(486),
    [anon_sym_ATinterface] = ACTIONS(484),
    [anon_sym_interface] = ACTIONS(486),
    [anon_sym_byte] = ACTIONS(486),
    [anon_sym_short] = ACTIONS(486),
    [anon_sym_int] = ACTIONS(486),
    [anon_sym_long] = ACTIONS(486),
    [anon_sym_char] = ACTIONS(486),
    [anon_sym_float] = ACTIONS(486),
    [anon_sym_double] = ACTIONS(486),
    [sym_boolean_type] = ACTIONS(486),
    [sym_void_type] = ACTIONS(486),
    [sym_this] = ACTIONS(486),
    [sym_super] = ACTIONS(486),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [134] = {
    [ts_builtin_sym_end] = ACTIONS(488),
    [sym_identifier] = ACTIONS(490),
    [sym_decimal_integer_literal] = ACTIONS(490),
    [sym_hex_integer_literal] = ACTIONS(490),
    [sym_octal_integer_literal] = ACTIONS(488),
    [sym_binary_integer_literal] = ACTIONS(488),
    [sym_decimal_floating_point_literal] = ACTIONS(488),
    [sym_hex_floating_point_literal] = ACTIONS(490),
    [sym_true] = ACTIONS(490),
    [sym_false] = ACTIONS(490),
    [sym_character_literal] = ACTIONS(488),
    [sym_string_literal] = ACTIONS(490),
    [sym_text_block] = ACTIONS(488),
    [sym_null_literal] = ACTIONS(490),
    [anon_sym_LPAREN] = ACTIONS(488),
    [anon_sym_LT] = ACTIONS(488),
    [anon_sym_PLUS] = ACTIONS(490),
    [anon_sym_DASH] = ACTIONS(490),
    [anon_sym_final] = ACTIONS(490),
    [anon_sym_BANG] = ACTIONS(488),
    [anon_sym_TILDE] = ACTIONS(488),
    [anon_sym_PLUS_PLUS] = ACTIONS(488),
    [anon_sym_DASH_DASH] = ACTIONS(488),
    [anon_sym_new] = ACTIONS(490),
    [anon_sym_class] = ACTIONS(490),
    [anon_sym_switch] = ACTIONS(490),
    [anon_sym_LBRACE] = ACTIONS(488),
    [anon_sym_RBRACE] = ACTIONS(488),
    [anon_sym_case] = ACTIONS(490),
    [anon_sym_default] = ACTIONS(490),
    [anon_sym_SEMI] = ACTIONS(488),
    [anon_sym_assert] = ACTIONS(490),
    [anon_sym_do] = ACTIONS(490),
    [anon_sym_while] = ACTIONS(490),
    [anon_sym_break] = ACTIONS(490),
    [anon_sym_continue] = ACTIONS(490),
    [anon_sym_return] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(490),
    [anon_sym_synchronized] = ACTIONS(490),
    [anon_sym_throw] = ACTIONS(490),
    [anon_sym_try] = ACTIONS(490),
    [anon_sym_if] = ACTIONS(490),
    [anon_sym_else] = ACTIONS(490),
    [anon_sym_for] = ACTIONS(490),
    [anon_sym_AT] = ACTIONS(490),
    [anon_sym_open] = ACTIONS(490),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_static] = ACTIONS(490),
    [anon_sym_package] = ACTIONS(490),
    [anon_sym_import] = ACTIONS(490),
    [anon_sym_enum] = ACTIONS(490),
    [anon_sym_public] = ACTIONS(490),
    [anon_sym_protected] = ACTIONS(490),
    [anon_sym_private] = ACTIONS(490),
    [anon_sym_abstract] = ACTIONS(490),
    [anon_sym_strictfp] = ACTIONS(490),
    [anon_sym_native] = ACTIONS(490),
    [anon_sym_transient] = ACTIONS(490),
    [anon_sym_volatile] = ACTIONS(490),
    [anon_sym_sealed] = ACTIONS(490),
    [anon_sym_non_DASHsealed] = ACTIONS(488),
    [anon_sym_record] = ACTIONS(490),
    [anon_sym_ATinterface] = ACTIONS(488),
    [anon_sym_interface] = ACTIONS(490),
    [anon_sym_byte] = ACTIONS(490),
    [anon_sym_short] = ACTIONS(490),
    [anon_sym_int] = ACTIONS(490),
    [anon_sym_long] = ACTIONS(490),
    [anon_sym_char] = ACTIONS(490),
    [anon_sym_float] = ACTIONS(490),
    [anon_sym_double] = ACTIONS(490),
    [sym_boolean_type] = ACTIONS(490),
    [sym_void_type] = ACTIONS(490),
    [sym_this] = ACTIONS(490),
    [sym_super] = ACTIONS(490),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [135] = {
    [ts_builtin_sym_end] = ACTIONS(492),
    [sym_identifier] = ACTIONS(494),
    [sym_decimal_integer_literal] = ACTIONS(494),
    [sym_hex_integer_literal] = ACTIONS(494),
    [sym_octal_integer_literal] = ACTIONS(492),
    [sym_binary_integer_literal] = ACTIONS(492),
    [sym_decimal_floating_point_literal] = ACTIONS(492),
    [sym_hex_floating_point_literal] = ACTIONS(494),
    [sym_true] = ACTIONS(494),
    [sym_false] = ACTIONS(494),
    [sym_character_literal] = ACTIONS(492),
    [sym_string_literal] = ACTIONS(494),
    [sym_text_block] = ACTIONS(492),
    [sym_null_literal] = ACTIONS(494),
    [anon_sym_LPAREN] = ACTIONS(492),
    [anon_sym_LT] = ACTIONS(492),
    [anon_sym_PLUS] = ACTIONS(494),
    [anon_sym_DASH] = ACTIONS(494),
    [anon_sym_final] = ACTIONS(494),
    [anon_sym_BANG] = ACTIONS(492),
    [anon_sym_TILDE] = ACTIONS(492),
    [anon_sym_PLUS_PLUS] = ACTIONS(492),
    [anon_sym_DASH_DASH] = ACTIONS(492),
    [anon_sym_new] = ACTIONS(494),
    [anon_sym_class] = ACTIONS(494),
    [anon_sym_switch] = ACTIONS(494),
    [anon_sym_LBRACE] = ACTIONS(492),
    [anon_sym_RBRACE] = ACTIONS(492),
    [anon_sym_case] = ACTIONS(494),
    [anon_sym_default] = ACTIONS(494),
    [anon_sym_SEMI] = ACTIONS(492),
    [anon_sym_assert] = ACTIONS(494),
    [anon_sym_do] = ACTIONS(494),
    [anon_sym_while] = ACTIONS(494),
    [anon_sym_break] = ACTIONS(494),
    [anon_sym_continue] = ACTIONS(494),
    [anon_sym_return] = ACTIONS(494),
    [anon_sym_yield] = ACTIONS(494),
    [anon_sym_synchronized] = ACTIONS(494),
    [anon_sym_throw] = ACTIONS(494),
    [anon_sym_try] = ACTIONS(494),
    [anon_sym_if] = ACTIONS(494),
    [anon_sym_else] = ACTIONS(494),
    [anon_sym_for] = ACTIONS(494),
    [anon_sym_AT] = ACTIONS(494),
    [anon_sym_open] = ACTIONS(494),
    [anon_sym_module] = ACTIONS(494),
    [anon_sym_static] = ACTIONS(494),
    [anon_sym_package] = ACTIONS(494),
    [anon_sym_import] = ACTIONS(494),
    [anon_sym_enum] = ACTIONS(494),
    [anon_sym_public] = ACTIONS(494),
    [anon_sym_protected] = ACTIONS(494),
    [anon_sym_private] = ACTIONS(494),
    [anon_sym_abstract] = ACTIONS(494),
    [anon_sym_strictfp] = ACTIONS(494),
    [anon_sym_native] = ACTIONS(494),
    [anon_sym_transient] = ACTIONS(494),
    [anon_sym_volatile] = ACTIONS(494),
    [anon_sym_sealed] = ACTIONS(494),
    [anon_sym_non_DASHsealed] = ACTIONS(492),
    [anon_sym_record] = ACTIONS(494),
    [anon_sym_ATinterface] = ACTIONS(492),
    [anon_sym_interface] = ACTIONS(494),
    [anon_sym_byte] = ACTIONS(494),
    [anon_sym_short] = ACTIONS(494),
    [anon_sym_int] = ACTIONS(494),
    [anon_sym_long] = ACTIONS(494),
    [anon_sym_char] = ACTIONS(494),
    [anon_sym_float] = ACTIONS(494),
    [anon_sym_double] = ACTIONS(494),
    [sym_boolean_type] = ACTIONS(494),
    [sym_void_type] = ACTIONS(494),
    [sym_this] = ACTIONS(494),
    [sym_super] = ACTIONS(494),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [136] = {
    [ts_builtin_sym_end] = ACTIONS(496),
    [sym_identifier] = ACTIONS(498),
    [sym_decimal_integer_literal] = ACTIONS(498),
    [sym_hex_integer_literal] = ACTIONS(498),
    [sym_octal_integer_literal] = ACTIONS(496),
    [sym_binary_integer_literal] = ACTIONS(496),
    [sym_decimal_floating_point_literal] = ACTIONS(496),
    [sym_hex_floating_point_literal] = ACTIONS(498),
    [sym_true] = ACTIONS(498),
    [sym_false] = ACTIONS(498),
    [sym_character_literal] = ACTIONS(496),
    [sym_string_literal] = ACTIONS(498),
    [sym_text_block] = ACTIONS(496),
    [sym_null_literal] = ACTIONS(498),
    [anon_sym_LPAREN] = ACTIONS(496),
    [anon_sym_LT] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_final] = ACTIONS(498),
    [anon_sym_BANG] = ACTIONS(496),
    [anon_sym_TILDE] = ACTIONS(496),
    [anon_sym_PLUS_PLUS] = ACTIONS(496),
    [anon_sym_DASH_DASH] = ACTIONS(496),
    [anon_sym_new] = ACTIONS(498),
    [anon_sym_class] = ACTIONS(498),
    [anon_sym_switch] = ACTIONS(498),
    [anon_sym_LBRACE] = ACTIONS(496),
    [anon_sym_RBRACE] = ACTIONS(496),
    [anon_sym_case] = ACTIONS(498),
    [anon_sym_default] = ACTIONS(498),
    [anon_sym_SEMI] = ACTIONS(496),
    [anon_sym_assert] = ACTIONS(498),
    [anon_sym_do] = ACTIONS(498),
    [anon_sym_while] = ACTIONS(498),
    [anon_sym_break] = ACTIONS(498),
    [anon_sym_continue] = ACTIONS(498),
    [anon_sym_return] = ACTIONS(498),
    [anon_sym_yield] = ACTIONS(498),
    [anon_sym_synchronized] = ACTIONS(498),
    [anon_sym_throw] = ACTIONS(498),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_if] = ACTIONS(498),
    [anon_sym_else] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(498),
    [anon_sym_AT] = ACTIONS(498),
    [anon_sym_open] = ACTIONS(498),
    [anon_sym_module] = ACTIONS(498),
    [anon_sym_static] = ACTIONS(498),
    [anon_sym_package] = ACTIONS(498),
    [anon_sym_import] = ACTIONS(498),
    [anon_sym_enum] = ACTIONS(498),
    [anon_sym_public] = ACTIONS(498),
    [anon_sym_protected] = ACTIONS(498),
    [anon_sym_private] = ACTIONS(498),
    [anon_sym_abstract] = ACTIONS(498),
    [anon_sym_strictfp] = ACTIONS(498),
    [anon_sym_native] = ACTIONS(498),
    [anon_sym_transient] = ACTIONS(498),
    [anon_sym_volatile] = ACTIONS(498),
    [anon_sym_sealed] = ACTIONS(498),
    [anon_sym_non_DASHsealed] = ACTIONS(496),
    [anon_sym_record] = ACTIONS(498),
    [anon_sym_ATinterface] = ACTIONS(496),
    [anon_sym_interface] = ACTIONS(498),
    [anon_sym_byte] = ACTIONS(498),
    [anon_sym_short] = ACTIONS(498),
    [anon_sym_int] = ACTIONS(498),
    [anon_sym_long] = ACTIONS(498),
    [anon_sym_char] = ACTIONS(498),
    [anon_sym_float] = ACTIONS(498),
    [anon_sym_double] = ACTIONS(498),
    [sym_boolean_type] = ACTIONS(498),
    [sym_void_type] = ACTIONS(498),
    [sym_this] = ACTIONS(498),
    [sym_super] = ACTIONS(498),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [137] = {
    [ts_builtin_sym_end] = ACTIONS(500),
    [sym_identifier] = ACTIONS(502),
    [sym_decimal_integer_literal] = ACTIONS(502),
    [sym_hex_integer_literal] = ACTIONS(502),
    [sym_octal_integer_literal] = ACTIONS(500),
    [sym_binary_integer_literal] = ACTIONS(500),
    [sym_decimal_floating_point_literal] = ACTIONS(500),
    [sym_hex_floating_point_literal] = ACTIONS(502),
    [sym_true] = ACTIONS(502),
    [sym_false] = ACTIONS(502),
    [sym_character_literal] = ACTIONS(500),
    [sym_string_literal] = ACTIONS(502),
    [sym_text_block] = ACTIONS(500),
    [sym_null_literal] = ACTIONS(502),
    [anon_sym_LPAREN] = ACTIONS(500),
    [anon_sym_LT] = ACTIONS(500),
    [anon_sym_PLUS] = ACTIONS(502),
    [anon_sym_DASH] = ACTIONS(502),
    [anon_sym_final] = ACTIONS(502),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_PLUS_PLUS] = ACTIONS(500),
    [anon_sym_DASH_DASH] = ACTIONS(500),
    [anon_sym_new] = ACTIONS(502),
    [anon_sym_class] = ACTIONS(502),
    [anon_sym_switch] = ACTIONS(502),
    [anon_sym_LBRACE] = ACTIONS(500),
    [anon_sym_RBRACE] = ACTIONS(500),
    [anon_sym_case] = ACTIONS(502),
    [anon_sym_default] = ACTIONS(502),
    [anon_sym_SEMI] = ACTIONS(500),
    [anon_sym_assert] = ACTIONS(502),
    [anon_sym_do] = ACTIONS(502),
    [anon_sym_while] = ACTIONS(502),
    [anon_sym_break] = ACTIONS(502),
    [anon_sym_continue] = ACTIONS(502),
    [anon_sym_return] = ACTIONS(502),
    [anon_sym_yield] = ACTIONS(502),
    [anon_sym_synchronized] = ACTIONS(502),
    [anon_sym_throw] = ACTIONS(502),
    [anon_sym_try] = ACTIONS(502),
    [anon_sym_if] = ACTIONS(502),
    [anon_sym_else] = ACTIONS(502),
    [anon_sym_for] = ACTIONS(502),
    [anon_sym_AT] = ACTIONS(502),
    [anon_sym_open] = ACTIONS(502),
    [anon_sym_module] = ACTIONS(502),
    [anon_sym_static] = ACTIONS(502),
    [anon_sym_package] = ACTIONS(502),
    [anon_sym_import] = ACTIONS(502),
    [anon_sym_enum] = ACTIONS(502),
    [anon_sym_public] = ACTIONS(502),
    [anon_sym_protected] = ACTIONS(502),
    [anon_sym_private] = ACTIONS(502),
    [anon_sym_abstract] = ACTIONS(502),
    [anon_sym_strictfp] = ACTIONS(502),
    [anon_sym_native] = ACTIONS(502),
    [anon_sym_transient] = ACTIONS(502),
    [anon_sym_volatile] = ACTIONS(502),
    [anon_sym_sealed] = ACTIONS(502),
    [anon_sym_non_DASHsealed] = ACTIONS(500),
    [anon_sym_record] = ACTIONS(502),
    [anon_sym_ATinterface] = ACTIONS(500),
    [anon_sym_interface] = ACTIONS(502),
    [anon_sym_byte] = ACTIONS(502),
    [anon_sym_short] = ACTIONS(502),
    [anon_sym_int] = ACTIONS(502),
    [anon_sym_long] = ACTIONS(502),
    [anon_sym_char] = ACTIONS(502),
    [anon_sym_float] = ACTIONS(502),
    [anon_sym_double] = ACTIONS(502),
    [sym_boolean_type] = ACTIONS(502),
    [sym_void_type] = ACTIONS(502),
    [sym_this] = ACTIONS(502),
    [sym_super] = ACTIONS(502),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [138] = {
    [ts_builtin_sym_end] = ACTIONS(504),
    [sym_identifier] = ACTIONS(506),
    [sym_decimal_integer_literal] = ACTIONS(506),
    [sym_hex_integer_literal] = ACTIONS(506),
    [sym_octal_integer_literal] = ACTIONS(504),
    [sym_binary_integer_literal] = ACTIONS(504),
    [sym_decimal_floating_point_literal] = ACTIONS(504),
    [sym_hex_floating_point_literal] = ACTIONS(506),
    [sym_true] = ACTIONS(506),
    [sym_false] = ACTIONS(506),
    [sym_character_literal] = ACTIONS(504),
    [sym_string_literal] = ACTIONS(506),
    [sym_text_block] = ACTIONS(504),
    [sym_null_literal] = ACTIONS(506),
    [anon_sym_LPAREN] = ACTIONS(504),
    [anon_sym_LT] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_DASH] = ACTIONS(506),
    [anon_sym_final] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(504),
    [anon_sym_TILDE] = ACTIONS(504),
    [anon_sym_PLUS_PLUS] = ACTIONS(504),
    [anon_sym_DASH_DASH] = ACTIONS(504),
    [anon_sym_new] = ACTIONS(506),
    [anon_sym_class] = ACTIONS(506),
    [anon_sym_switch] = ACTIONS(506),
    [anon_sym_LBRACE] = ACTIONS(504),
    [anon_sym_RBRACE] = ACTIONS(504),
    [anon_sym_case] = ACTIONS(506),
    [anon_sym_default] = ACTIONS(506),
    [anon_sym_SEMI] = ACTIONS(504),
    [anon_sym_assert] = ACTIONS(506),
    [anon_sym_do] = ACTIONS(506),
    [anon_sym_while] = ACTIONS(506),
    [anon_sym_break] = ACTIONS(506),
    [anon_sym_continue] = ACTIONS(506),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_yield] = ACTIONS(506),
    [anon_sym_synchronized] = ACTIONS(506),
    [anon_sym_throw] = ACTIONS(506),
    [anon_sym_try] = ACTIONS(506),
    [anon_sym_if] = ACTIONS(506),
    [anon_sym_else] = ACTIONS(506),
    [anon_sym_for] = ACTIONS(506),
    [anon_sym_AT] = ACTIONS(506),
    [anon_sym_open] = ACTIONS(506),
    [anon_sym_module] = ACTIONS(506),
    [anon_sym_static] = ACTIONS(506),
    [anon_sym_package] = ACTIONS(506),
    [anon_sym_import] = ACTIONS(506),
    [anon_sym_enum] = ACTIONS(506),
    [anon_sym_public] = ACTIONS(506),
    [anon_sym_protected] = ACTIONS(506),
    [anon_sym_private] = ACTIONS(506),
    [anon_sym_abstract] = ACTIONS(506),
    [anon_sym_strictfp] = ACTIONS(506),
    [anon_sym_native] = ACTIONS(506),
    [anon_sym_transient] = ACTIONS(506),
    [anon_sym_volatile] = ACTIONS(506),
    [anon_sym_sealed] = ACTIONS(506),
    [anon_sym_non_DASHsealed] = ACTIONS(504),
    [anon_sym_record] = ACTIONS(506),
    [anon_sym_ATinterface] = ACTIONS(504),
    [anon_sym_interface] = ACTIONS(506),
    [anon_sym_byte] = ACTIONS(506),
    [anon_sym_short] = ACTIONS(506),
    [anon_sym_int] = ACTIONS(506),
    [anon_sym_long] = ACTIONS(506),
    [anon_sym_char] = ACTIONS(506),
    [anon_sym_float] = ACTIONS(506),
    [anon_sym_double] = ACTIONS(506),
    [sym_boolean_type] = ACTIONS(506),
    [sym_void_type] = ACTIONS(506),
    [sym_this] = ACTIONS(506),
    [sym_super] = ACTIONS(506),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [139] = {
    [ts_builtin_sym_end] = ACTIONS(508),
    [sym_identifier] = ACTIONS(510),
    [sym_decimal_integer_literal] = ACTIONS(510),
    [sym_hex_integer_literal] = ACTIONS(510),
    [sym_octal_integer_literal] = ACTIONS(508),
    [sym_binary_integer_literal] = ACTIONS(508),
    [sym_decimal_floating_point_literal] = ACTIONS(508),
    [sym_hex_floating_point_literal] = ACTIONS(510),
    [sym_true] = ACTIONS(510),
    [sym_false] = ACTIONS(510),
    [sym_character_literal] = ACTIONS(508),
    [sym_string_literal] = ACTIONS(510),
    [sym_text_block] = ACTIONS(508),
    [sym_null_literal] = ACTIONS(510),
    [anon_sym_LPAREN] = ACTIONS(508),
    [anon_sym_LT] = ACTIONS(508),
    [anon_sym_PLUS] = ACTIONS(510),
    [anon_sym_DASH] = ACTIONS(510),
    [anon_sym_final] = ACTIONS(510),
    [anon_sym_BANG] = ACTIONS(508),
    [anon_sym_TILDE] = ACTIONS(508),
    [anon_sym_PLUS_PLUS] = ACTIONS(508),
    [anon_sym_DASH_DASH] = ACTIONS(508),
    [anon_sym_new] = ACTIONS(510),
    [anon_sym_class] = ACTIONS(510),
    [anon_sym_switch] = ACTIONS(510),
    [anon_sym_LBRACE] = ACTIONS(508),
    [anon_sym_RBRACE] = ACTIONS(508),
    [anon_sym_case] = ACTIONS(510),
    [anon_sym_default] = ACTIONS(510),
    [anon_sym_SEMI] = ACTIONS(508),
    [anon_sym_assert] = ACTIONS(510),
    [anon_sym_do] = ACTIONS(510),
    [anon_sym_while] = ACTIONS(510),
    [anon_sym_break] = ACTIONS(510),
    [anon_sym_continue] = ACTIONS(510),
    [anon_sym_return] = ACTIONS(510),
    [anon_sym_yield] = ACTIONS(510),
    [anon_sym_synchronized] = ACTIONS(510),
    [anon_sym_throw] = ACTIONS(510),
    [anon_sym_try] = ACTIONS(510),
    [anon_sym_if] = ACTIONS(510),
    [anon_sym_else] = ACTIONS(510),
    [anon_sym_for] = ACTIONS(510),
    [anon_sym_AT] = ACTIONS(510),
    [anon_sym_open] = ACTIONS(510),
    [anon_sym_module] = ACTIONS(510),
    [anon_sym_static] = ACTIONS(510),
    [anon_sym_package] = ACTIONS(510),
    [anon_sym_import] = ACTIONS(510),
    [anon_sym_enum] = ACTIONS(510),
    [anon_sym_public] = ACTIONS(510),
    [anon_sym_protected] = ACTIONS(510),
    [anon_sym_private] = ACTIONS(510),
    [anon_sym_abstract] = ACTIONS(510),
    [anon_sym_strictfp] = ACTIONS(510),
    [anon_sym_native] = ACTIONS(510),
    [anon_sym_transient] = ACTIONS(510),
    [anon_sym_volatile] = ACTIONS(510),
    [anon_sym_sealed] = ACTIONS(510),
    [anon_sym_non_DASHsealed] = ACTIONS(508),
    [anon_sym_record] = ACTIONS(510),
    [anon_sym_ATinterface] = ACTIONS(508),
    [anon_sym_interface] = ACTIONS(510),
    [anon_sym_byte] = ACTIONS(510),
    [anon_sym_short] = ACTIONS(510),
    [anon_sym_int] = ACTIONS(510),
    [anon_sym_long] = ACTIONS(510),
    [anon_sym_char] = ACTIONS(510),
    [anon_sym_float] = ACTIONS(510),
    [anon_sym_double] = ACTIONS(510),
    [sym_boolean_type] = ACTIONS(510),
    [sym_void_type] = ACTIONS(510),
    [sym_this] = ACTIONS(510),
    [sym_super] = ACTIONS(510),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [140] = {
    [ts_builtin_sym_end] = ACTIONS(512),
    [sym_identifier] = ACTIONS(514),
    [sym_decimal_integer_literal] = ACTIONS(514),
    [sym_hex_integer_literal] = ACTIONS(514),
    [sym_octal_integer_literal] = ACTIONS(512),
    [sym_binary_integer_literal] = ACTIONS(512),
    [sym_decimal_floating_point_literal] = ACTIONS(512),
    [sym_hex_floating_point_literal] = ACTIONS(514),
    [sym_true] = ACTIONS(514),
    [sym_false] = ACTIONS(514),
    [sym_character_literal] = ACTIONS(512),
    [sym_string_literal] = ACTIONS(514),
    [sym_text_block] = ACTIONS(512),
    [sym_null_literal] = ACTIONS(514),
    [anon_sym_LPAREN] = ACTIONS(512),
    [anon_sym_LT] = ACTIONS(512),
    [anon_sym_PLUS] = ACTIONS(514),
    [anon_sym_DASH] = ACTIONS(514),
    [anon_sym_final] = ACTIONS(514),
    [anon_sym_BANG] = ACTIONS(512),
    [anon_sym_TILDE] = ACTIONS(512),
    [anon_sym_PLUS_PLUS] = ACTIONS(512),
    [anon_sym_DASH_DASH] = ACTIONS(512),
    [anon_sym_new] = ACTIONS(514),
    [anon_sym_class] = ACTIONS(514),
    [anon_sym_switch] = ACTIONS(514),
    [anon_sym_LBRACE] = ACTIONS(512),
    [anon_sym_RBRACE] = ACTIONS(512),
    [anon_sym_case] = ACTIONS(514),
    [anon_sym_default] = ACTIONS(514),
    [anon_sym_SEMI] = ACTIONS(512),
    [anon_sym_assert] = ACTIONS(514),
    [anon_sym_do] = ACTIONS(514),
    [anon_sym_while] = ACTIONS(514),
    [anon_sym_break] = ACTIONS(514),
    [anon_sym_continue] = ACTIONS(514),
    [anon_sym_return] = ACTIONS(514),
    [anon_sym_yield] = ACTIONS(514),
    [anon_sym_synchronized] = ACTIONS(514),
    [anon_sym_throw] = ACTIONS(514),
    [anon_sym_try] = ACTIONS(514),
    [anon_sym_if] = ACTIONS(514),
    [anon_sym_else] = ACTIONS(514),
    [anon_sym_for] = ACTIONS(514),
    [anon_sym_AT] = ACTIONS(514),
    [anon_sym_open] = ACTIONS(514),
    [anon_sym_module] = ACTIONS(514),
    [anon_sym_static] = ACTIONS(514),
    [anon_sym_package] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_enum] = ACTIONS(514),
    [anon_sym_public] = ACTIONS(514),
    [anon_sym_protected] = ACTIONS(514),
    [anon_sym_private] = ACTIONS(514),
    [anon_sym_abstract] = ACTIONS(514),
    [anon_sym_strictfp] = ACTIONS(514),
    [anon_sym_native] = ACTIONS(514),
    [anon_sym_transient] = ACTIONS(514),
    [anon_sym_volatile] = ACTIONS(514),
    [anon_sym_sealed] = ACTIONS(514),
    [anon_sym_non_DASHsealed] = ACTIONS(512),
    [anon_sym_record] = ACTIONS(514),
    [anon_sym_ATinterface] = ACTIONS(512),
    [anon_sym_interface] = ACTIONS(514),
    [anon_sym_byte] = ACTIONS(514),
    [anon_sym_short] = ACTIONS(514),
    [anon_sym_int] = ACTIONS(514),
    [anon_sym_long] = ACTIONS(514),
    [anon_sym_char] = ACTIONS(514),
    [anon_sym_float] = ACTIONS(514),
    [anon_sym_double] = ACTIONS(514),
    [sym_boolean_type] = ACTIONS(514),
    [sym_void_type] = ACTIONS(514),
    [sym_this] = ACTIONS(514),
    [sym_super] = ACTIONS(514),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [141] = {
    [ts_builtin_sym_end] = ACTIONS(516),
    [sym_identifier] = ACTIONS(518),
    [sym_decimal_integer_literal] = ACTIONS(518),
    [sym_hex_integer_literal] = ACTIONS(518),
    [sym_octal_integer_literal] = ACTIONS(516),
    [sym_binary_integer_literal] = ACTIONS(516),
    [sym_decimal_floating_point_literal] = ACTIONS(516),
    [sym_hex_floating_point_literal] = ACTIONS(518),
    [sym_true] = ACTIONS(518),
    [sym_false] = ACTIONS(518),
    [sym_character_literal] = ACTIONS(516),
    [sym_string_literal] = ACTIONS(518),
    [sym_text_block] = ACTIONS(516),
    [sym_null_literal] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(516),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_PLUS] = ACTIONS(518),
    [anon_sym_DASH] = ACTIONS(518),
    [anon_sym_final] = ACTIONS(518),
    [anon_sym_BANG] = ACTIONS(516),
    [anon_sym_TILDE] = ACTIONS(516),
    [anon_sym_PLUS_PLUS] = ACTIONS(516),
    [anon_sym_DASH_DASH] = ACTIONS(516),
    [anon_sym_new] = ACTIONS(518),
    [anon_sym_class] = ACTIONS(518),
    [anon_sym_switch] = ACTIONS(518),
    [anon_sym_LBRACE] = ACTIONS(516),
    [anon_sym_RBRACE] = ACTIONS(516),
    [anon_sym_case] = ACTIONS(518),
    [anon_sym_default] = ACTIONS(518),
    [anon_sym_SEMI] = ACTIONS(516),
    [anon_sym_assert] = ACTIONS(518),
    [anon_sym_do] = ACTIONS(518),
    [anon_sym_while] = ACTIONS(518),
    [anon_sym_break] = ACTIONS(518),
    [anon_sym_continue] = ACTIONS(518),
    [anon_sym_return] = ACTIONS(518),
    [anon_sym_yield] = ACTIONS(518),
    [anon_sym_synchronized] = ACTIONS(518),
    [anon_sym_throw] = ACTIONS(518),
    [anon_sym_try] = ACTIONS(518),
    [anon_sym_if] = ACTIONS(518),
    [anon_sym_else] = ACTIONS(518),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_AT] = ACTIONS(518),
    [anon_sym_open] = ACTIONS(518),
    [anon_sym_module] = ACTIONS(518),
    [anon_sym_static] = ACTIONS(518),
    [anon_sym_package] = ACTIONS(518),
    [anon_sym_import] = ACTIONS(518),
    [anon_sym_enum] = ACTIONS(518),
    [anon_sym_public] = ACTIONS(518),
    [anon_sym_protected] = ACTIONS(518),
    [anon_sym_private] = ACTIONS(518),
    [anon_sym_abstract] = ACTIONS(518),
    [anon_sym_strictfp] = ACTIONS(518),
    [anon_sym_native] = ACTIONS(518),
    [anon_sym_transient] = ACTIONS(518),
    [anon_sym_volatile] = ACTIONS(518),
    [anon_sym_sealed] = ACTIONS(518),
    [anon_sym_non_DASHsealed] = ACTIONS(516),
    [anon_sym_record] = ACTIONS(518),
    [anon_sym_ATinterface] = ACTIONS(516),
    [anon_sym_interface] = ACTIONS(518),
    [anon_sym_byte] = ACTIONS(518),
    [anon_sym_short] = ACTIONS(518),
    [anon_sym_int] = ACTIONS(518),
    [anon_sym_long] = ACTIONS(518),
    [anon_sym_char] = ACTIONS(518),
    [anon_sym_float] = ACTIONS(518),
    [anon_sym_double] = ACTIONS(518),
    [sym_boolean_type] = ACTIONS(518),
    [sym_void_type] = ACTIONS(518),
    [sym_this] = ACTIONS(518),
    [sym_super] = ACTIONS(518),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [142] = {
    [ts_builtin_sym_end] = ACTIONS(520),
    [sym_identifier] = ACTIONS(522),
    [sym_decimal_integer_literal] = ACTIONS(522),
    [sym_hex_integer_literal] = ACTIONS(522),
    [sym_octal_integer_literal] = ACTIONS(520),
    [sym_binary_integer_literal] = ACTIONS(520),
    [sym_decimal_floating_point_literal] = ACTIONS(520),
    [sym_hex_floating_point_literal] = ACTIONS(522),
    [sym_true] = ACTIONS(522),
    [sym_false] = ACTIONS(522),
    [sym_character_literal] = ACTIONS(520),
    [sym_string_literal] = ACTIONS(522),
    [sym_text_block] = ACTIONS(520),
    [sym_null_literal] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(520),
    [anon_sym_LT] = ACTIONS(520),
    [anon_sym_PLUS] = ACTIONS(522),
    [anon_sym_DASH] = ACTIONS(522),
    [anon_sym_final] = ACTIONS(522),
    [anon_sym_BANG] = ACTIONS(520),
    [anon_sym_TILDE] = ACTIONS(520),
    [anon_sym_PLUS_PLUS] = ACTIONS(520),
    [anon_sym_DASH_DASH] = ACTIONS(520),
    [anon_sym_new] = ACTIONS(522),
    [anon_sym_class] = ACTIONS(522),
    [anon_sym_switch] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(520),
    [anon_sym_RBRACE] = ACTIONS(520),
    [anon_sym_case] = ACTIONS(522),
    [anon_sym_default] = ACTIONS(522),
    [anon_sym_SEMI] = ACTIONS(520),
    [anon_sym_assert] = ACTIONS(522),
    [anon_sym_do] = ACTIONS(522),
    [anon_sym_while] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(522),
    [anon_sym_continue] = ACTIONS(522),
    [anon_sym_return] = ACTIONS(522),
    [anon_sym_yield] = ACTIONS(522),
    [anon_sym_synchronized] = ACTIONS(522),
    [anon_sym_throw] = ACTIONS(522),
    [anon_sym_try] = ACTIONS(522),
    [anon_sym_if] = ACTIONS(522),
    [anon_sym_else] = ACTIONS(522),
    [anon_sym_for] = ACTIONS(522),
    [anon_sym_AT] = ACTIONS(522),
    [anon_sym_open] = ACTIONS(522),
    [anon_sym_module] = ACTIONS(522),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_package] = ACTIONS(522),
    [anon_sym_import] = ACTIONS(522),
    [anon_sym_enum] = ACTIONS(522),
    [anon_sym_public] = ACTIONS(522),
    [anon_sym_protected] = ACTIONS(522),
    [anon_sym_private] = ACTIONS(522),
    [anon_sym_abstract] = ACTIONS(522),
    [anon_sym_strictfp] = ACTIONS(522),
    [anon_sym_native] = ACTIONS(522),
    [anon_sym_transient] = ACTIONS(522),
    [anon_sym_volatile] = ACTIONS(522),
    [anon_sym_sealed] = ACTIONS(522),
    [anon_sym_non_DASHsealed] = ACTIONS(520),
    [anon_sym_record] = ACTIONS(522),
    [anon_sym_ATinterface] = ACTIONS(520),
    [anon_sym_interface] = ACTIONS(522),
    [anon_sym_byte] = ACTIONS(522),
    [anon_sym_short] = ACTIONS(522),
    [anon_sym_int] = ACTIONS(522),
    [anon_sym_long] = ACTIONS(522),
    [anon_sym_char] = ACTIONS(522),
    [anon_sym_float] = ACTIONS(522),
    [anon_sym_double] = ACTIONS(522),
    [sym_boolean_type] = ACTIONS(522),
    [sym_void_type] = ACTIONS(522),
    [sym_this] = ACTIONS(522),
    [sym_super] = ACTIONS(522),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [143] = {
    [ts_builtin_sym_end] = ACTIONS(524),
    [sym_identifier] = ACTIONS(526),
    [sym_decimal_integer_literal] = ACTIONS(526),
    [sym_hex_integer_literal] = ACTIONS(526),
    [sym_octal_integer_literal] = ACTIONS(524),
    [sym_binary_integer_literal] = ACTIONS(524),
    [sym_decimal_floating_point_literal] = ACTIONS(524),
    [sym_hex_floating_point_literal] = ACTIONS(526),
    [sym_true] = ACTIONS(526),
    [sym_false] = ACTIONS(526),
    [sym_character_literal] = ACTIONS(524),
    [sym_string_literal] = ACTIONS(526),
    [sym_text_block] = ACTIONS(524),
    [sym_null_literal] = ACTIONS(526),
    [anon_sym_LPAREN] = ACTIONS(524),
    [anon_sym_LT] = ACTIONS(524),
    [anon_sym_PLUS] = ACTIONS(526),
    [anon_sym_DASH] = ACTIONS(526),
    [anon_sym_final] = ACTIONS(526),
    [anon_sym_BANG] = ACTIONS(524),
    [anon_sym_TILDE] = ACTIONS(524),
    [anon_sym_PLUS_PLUS] = ACTIONS(524),
    [anon_sym_DASH_DASH] = ACTIONS(524),
    [anon_sym_new] = ACTIONS(526),
    [anon_sym_class] = ACTIONS(526),
    [anon_sym_switch] = ACTIONS(526),
    [anon_sym_LBRACE] = ACTIONS(524),
    [anon_sym_RBRACE] = ACTIONS(524),
    [anon_sym_case] = ACTIONS(526),
    [anon_sym_default] = ACTIONS(526),
    [anon_sym_SEMI] = ACTIONS(524),
    [anon_sym_assert] = ACTIONS(526),
    [anon_sym_do] = ACTIONS(526),
    [anon_sym_while] = ACTIONS(526),
    [anon_sym_break] = ACTIONS(526),
    [anon_sym_continue] = ACTIONS(526),
    [anon_sym_return] = ACTIONS(526),
    [anon_sym_yield] = ACTIONS(526),
    [anon_sym_synchronized] = ACTIONS(526),
    [anon_sym_throw] = ACTIONS(526),
    [anon_sym_try] = ACTIONS(526),
    [anon_sym_if] = ACTIONS(526),
    [anon_sym_else] = ACTIONS(526),
    [anon_sym_for] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(526),
    [anon_sym_open] = ACTIONS(526),
    [anon_sym_module] = ACTIONS(526),
    [anon_sym_static] = ACTIONS(526),
    [anon_sym_package] = ACTIONS(526),
    [anon_sym_import] = ACTIONS(526),
    [anon_sym_enum] = ACTIONS(526),
    [anon_sym_public] = ACTIONS(526),
    [anon_sym_protected] = ACTIONS(526),
    [anon_sym_private] = ACTIONS(526),
    [anon_sym_abstract] = ACTIONS(526),
    [anon_sym_strictfp] = ACTIONS(526),
    [anon_sym_native] = ACTIONS(526),
    [anon_sym_transient] = ACTIONS(526),
    [anon_sym_volatile] = ACTIONS(526),
    [anon_sym_sealed] = ACTIONS(526),
    [anon_sym_non_DASHsealed] = ACTIONS(524),
    [anon_sym_record] = ACTIONS(526),
    [anon_sym_ATinterface] = ACTIONS(524),
    [anon_sym_interface] = ACTIONS(526),
    [anon_sym_byte] = ACTIONS(526),
    [anon_sym_short] = ACTIONS(526),
    [anon_sym_int] = ACTIONS(526),
    [anon_sym_long] = ACTIONS(526),
    [anon_sym_char] = ACTIONS(526),
    [anon_sym_float] = ACTIONS(526),
    [anon_sym_double] = ACTIONS(526),
    [sym_boolean_type] = ACTIONS(526),
    [sym_void_type] = ACTIONS(526),
    [sym_this] = ACTIONS(526),
    [sym_super] = ACTIONS(526),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [144] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(605),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(661),
    [sym_marker_annotation] = STATE(661),
    [sym_annotation] = STATE(661),
    [sym_array_initializer] = STATE(1110),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(307),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_RBRACE] = ACTIONS(528),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [145] = {
    [ts_builtin_sym_end] = ACTIONS(530),
    [sym_identifier] = ACTIONS(532),
    [sym_decimal_integer_literal] = ACTIONS(532),
    [sym_hex_integer_literal] = ACTIONS(532),
    [sym_octal_integer_literal] = ACTIONS(530),
    [sym_binary_integer_literal] = ACTIONS(530),
    [sym_decimal_floating_point_literal] = ACTIONS(530),
    [sym_hex_floating_point_literal] = ACTIONS(532),
    [sym_true] = ACTIONS(532),
    [sym_false] = ACTIONS(532),
    [sym_character_literal] = ACTIONS(530),
    [sym_string_literal] = ACTIONS(532),
    [sym_text_block] = ACTIONS(530),
    [sym_null_literal] = ACTIONS(532),
    [anon_sym_LPAREN] = ACTIONS(530),
    [anon_sym_LT] = ACTIONS(530),
    [anon_sym_PLUS] = ACTIONS(532),
    [anon_sym_DASH] = ACTIONS(532),
    [anon_sym_final] = ACTIONS(532),
    [anon_sym_BANG] = ACTIONS(530),
    [anon_sym_TILDE] = ACTIONS(530),
    [anon_sym_PLUS_PLUS] = ACTIONS(530),
    [anon_sym_DASH_DASH] = ACTIONS(530),
    [anon_sym_new] = ACTIONS(532),
    [anon_sym_class] = ACTIONS(532),
    [anon_sym_switch] = ACTIONS(532),
    [anon_sym_LBRACE] = ACTIONS(530),
    [anon_sym_RBRACE] = ACTIONS(530),
    [anon_sym_case] = ACTIONS(532),
    [anon_sym_default] = ACTIONS(532),
    [anon_sym_SEMI] = ACTIONS(530),
    [anon_sym_assert] = ACTIONS(532),
    [anon_sym_do] = ACTIONS(532),
    [anon_sym_while] = ACTIONS(532),
    [anon_sym_break] = ACTIONS(532),
    [anon_sym_continue] = ACTIONS(532),
    [anon_sym_return] = ACTIONS(532),
    [anon_sym_yield] = ACTIONS(532),
    [anon_sym_synchronized] = ACTIONS(532),
    [anon_sym_throw] = ACTIONS(532),
    [anon_sym_try] = ACTIONS(532),
    [anon_sym_if] = ACTIONS(532),
    [anon_sym_else] = ACTIONS(532),
    [anon_sym_for] = ACTIONS(532),
    [anon_sym_AT] = ACTIONS(532),
    [anon_sym_open] = ACTIONS(532),
    [anon_sym_module] = ACTIONS(532),
    [anon_sym_static] = ACTIONS(532),
    [anon_sym_package] = ACTIONS(532),
    [anon_sym_import] = ACTIONS(532),
    [anon_sym_enum] = ACTIONS(532),
    [anon_sym_public] = ACTIONS(532),
    [anon_sym_protected] = ACTIONS(532),
    [anon_sym_private] = ACTIONS(532),
    [anon_sym_abstract] = ACTIONS(532),
    [anon_sym_strictfp] = ACTIONS(532),
    [anon_sym_native] = ACTIONS(532),
    [anon_sym_transient] = ACTIONS(532),
    [anon_sym_volatile] = ACTIONS(532),
    [anon_sym_sealed] = ACTIONS(532),
    [anon_sym_non_DASHsealed] = ACTIONS(530),
    [anon_sym_record] = ACTIONS(532),
    [anon_sym_ATinterface] = ACTIONS(530),
    [anon_sym_interface] = ACTIONS(532),
    [anon_sym_byte] = ACTIONS(532),
    [anon_sym_short] = ACTIONS(532),
    [anon_sym_int] = ACTIONS(532),
    [anon_sym_long] = ACTIONS(532),
    [anon_sym_char] = ACTIONS(532),
    [anon_sym_float] = ACTIONS(532),
    [anon_sym_double] = ACTIONS(532),
    [sym_boolean_type] = ACTIONS(532),
    [sym_void_type] = ACTIONS(532),
    [sym_this] = ACTIONS(532),
    [sym_super] = ACTIONS(532),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [146] = {
    [ts_builtin_sym_end] = ACTIONS(534),
    [sym_identifier] = ACTIONS(536),
    [sym_decimal_integer_literal] = ACTIONS(536),
    [sym_hex_integer_literal] = ACTIONS(536),
    [sym_octal_integer_literal] = ACTIONS(534),
    [sym_binary_integer_literal] = ACTIONS(534),
    [sym_decimal_floating_point_literal] = ACTIONS(534),
    [sym_hex_floating_point_literal] = ACTIONS(536),
    [sym_true] = ACTIONS(536),
    [sym_false] = ACTIONS(536),
    [sym_character_literal] = ACTIONS(534),
    [sym_string_literal] = ACTIONS(536),
    [sym_text_block] = ACTIONS(534),
    [sym_null_literal] = ACTIONS(536),
    [anon_sym_LPAREN] = ACTIONS(534),
    [anon_sym_LT] = ACTIONS(534),
    [anon_sym_PLUS] = ACTIONS(536),
    [anon_sym_DASH] = ACTIONS(536),
    [anon_sym_final] = ACTIONS(536),
    [anon_sym_BANG] = ACTIONS(534),
    [anon_sym_TILDE] = ACTIONS(534),
    [anon_sym_PLUS_PLUS] = ACTIONS(534),
    [anon_sym_DASH_DASH] = ACTIONS(534),
    [anon_sym_new] = ACTIONS(536),
    [anon_sym_class] = ACTIONS(536),
    [anon_sym_switch] = ACTIONS(536),
    [anon_sym_LBRACE] = ACTIONS(534),
    [anon_sym_RBRACE] = ACTIONS(534),
    [anon_sym_case] = ACTIONS(536),
    [anon_sym_default] = ACTIONS(536),
    [anon_sym_SEMI] = ACTIONS(534),
    [anon_sym_assert] = ACTIONS(536),
    [anon_sym_do] = ACTIONS(536),
    [anon_sym_while] = ACTIONS(536),
    [anon_sym_break] = ACTIONS(536),
    [anon_sym_continue] = ACTIONS(536),
    [anon_sym_return] = ACTIONS(536),
    [anon_sym_yield] = ACTIONS(536),
    [anon_sym_synchronized] = ACTIONS(536),
    [anon_sym_throw] = ACTIONS(536),
    [anon_sym_try] = ACTIONS(536),
    [anon_sym_if] = ACTIONS(536),
    [anon_sym_else] = ACTIONS(536),
    [anon_sym_for] = ACTIONS(536),
    [anon_sym_AT] = ACTIONS(536),
    [anon_sym_open] = ACTIONS(536),
    [anon_sym_module] = ACTIONS(536),
    [anon_sym_static] = ACTIONS(536),
    [anon_sym_package] = ACTIONS(536),
    [anon_sym_import] = ACTIONS(536),
    [anon_sym_enum] = ACTIONS(536),
    [anon_sym_public] = ACTIONS(536),
    [anon_sym_protected] = ACTIONS(536),
    [anon_sym_private] = ACTIONS(536),
    [anon_sym_abstract] = ACTIONS(536),
    [anon_sym_strictfp] = ACTIONS(536),
    [anon_sym_native] = ACTIONS(536),
    [anon_sym_transient] = ACTIONS(536),
    [anon_sym_volatile] = ACTIONS(536),
    [anon_sym_sealed] = ACTIONS(536),
    [anon_sym_non_DASHsealed] = ACTIONS(534),
    [anon_sym_record] = ACTIONS(536),
    [anon_sym_ATinterface] = ACTIONS(534),
    [anon_sym_interface] = ACTIONS(536),
    [anon_sym_byte] = ACTIONS(536),
    [anon_sym_short] = ACTIONS(536),
    [anon_sym_int] = ACTIONS(536),
    [anon_sym_long] = ACTIONS(536),
    [anon_sym_char] = ACTIONS(536),
    [anon_sym_float] = ACTIONS(536),
    [anon_sym_double] = ACTIONS(536),
    [sym_boolean_type] = ACTIONS(536),
    [sym_void_type] = ACTIONS(536),
    [sym_this] = ACTIONS(536),
    [sym_super] = ACTIONS(536),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [147] = {
    [ts_builtin_sym_end] = ACTIONS(538),
    [sym_identifier] = ACTIONS(540),
    [sym_decimal_integer_literal] = ACTIONS(540),
    [sym_hex_integer_literal] = ACTIONS(540),
    [sym_octal_integer_literal] = ACTIONS(538),
    [sym_binary_integer_literal] = ACTIONS(538),
    [sym_decimal_floating_point_literal] = ACTIONS(538),
    [sym_hex_floating_point_literal] = ACTIONS(540),
    [sym_true] = ACTIONS(540),
    [sym_false] = ACTIONS(540),
    [sym_character_literal] = ACTIONS(538),
    [sym_string_literal] = ACTIONS(540),
    [sym_text_block] = ACTIONS(538),
    [sym_null_literal] = ACTIONS(540),
    [anon_sym_LPAREN] = ACTIONS(538),
    [anon_sym_LT] = ACTIONS(538),
    [anon_sym_PLUS] = ACTIONS(540),
    [anon_sym_DASH] = ACTIONS(540),
    [anon_sym_final] = ACTIONS(540),
    [anon_sym_BANG] = ACTIONS(538),
    [anon_sym_TILDE] = ACTIONS(538),
    [anon_sym_PLUS_PLUS] = ACTIONS(538),
    [anon_sym_DASH_DASH] = ACTIONS(538),
    [anon_sym_new] = ACTIONS(540),
    [anon_sym_class] = ACTIONS(540),
    [anon_sym_switch] = ACTIONS(540),
    [anon_sym_LBRACE] = ACTIONS(538),
    [anon_sym_RBRACE] = ACTIONS(538),
    [anon_sym_case] = ACTIONS(540),
    [anon_sym_default] = ACTIONS(540),
    [anon_sym_SEMI] = ACTIONS(538),
    [anon_sym_assert] = ACTIONS(540),
    [anon_sym_do] = ACTIONS(540),
    [anon_sym_while] = ACTIONS(540),
    [anon_sym_break] = ACTIONS(540),
    [anon_sym_continue] = ACTIONS(540),
    [anon_sym_return] = ACTIONS(540),
    [anon_sym_yield] = ACTIONS(540),
    [anon_sym_synchronized] = ACTIONS(540),
    [anon_sym_throw] = ACTIONS(540),
    [anon_sym_try] = ACTIONS(540),
    [anon_sym_if] = ACTIONS(540),
    [anon_sym_else] = ACTIONS(540),
    [anon_sym_for] = ACTIONS(540),
    [anon_sym_AT] = ACTIONS(540),
    [anon_sym_open] = ACTIONS(540),
    [anon_sym_module] = ACTIONS(540),
    [anon_sym_static] = ACTIONS(540),
    [anon_sym_package] = ACTIONS(540),
    [anon_sym_import] = ACTIONS(540),
    [anon_sym_enum] = ACTIONS(540),
    [anon_sym_public] = ACTIONS(540),
    [anon_sym_protected] = ACTIONS(540),
    [anon_sym_private] = ACTIONS(540),
    [anon_sym_abstract] = ACTIONS(540),
    [anon_sym_strictfp] = ACTIONS(540),
    [anon_sym_native] = ACTIONS(540),
    [anon_sym_transient] = ACTIONS(540),
    [anon_sym_volatile] = ACTIONS(540),
    [anon_sym_sealed] = ACTIONS(540),
    [anon_sym_non_DASHsealed] = ACTIONS(538),
    [anon_sym_record] = ACTIONS(540),
    [anon_sym_ATinterface] = ACTIONS(538),
    [anon_sym_interface] = ACTIONS(540),
    [anon_sym_byte] = ACTIONS(540),
    [anon_sym_short] = ACTIONS(540),
    [anon_sym_int] = ACTIONS(540),
    [anon_sym_long] = ACTIONS(540),
    [anon_sym_char] = ACTIONS(540),
    [anon_sym_float] = ACTIONS(540),
    [anon_sym_double] = ACTIONS(540),
    [sym_boolean_type] = ACTIONS(540),
    [sym_void_type] = ACTIONS(540),
    [sym_this] = ACTIONS(540),
    [sym_super] = ACTIONS(540),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [148] = {
    [ts_builtin_sym_end] = ACTIONS(542),
    [sym_identifier] = ACTIONS(544),
    [sym_decimal_integer_literal] = ACTIONS(544),
    [sym_hex_integer_literal] = ACTIONS(544),
    [sym_octal_integer_literal] = ACTIONS(542),
    [sym_binary_integer_literal] = ACTIONS(542),
    [sym_decimal_floating_point_literal] = ACTIONS(542),
    [sym_hex_floating_point_literal] = ACTIONS(544),
    [sym_true] = ACTIONS(544),
    [sym_false] = ACTIONS(544),
    [sym_character_literal] = ACTIONS(542),
    [sym_string_literal] = ACTIONS(544),
    [sym_text_block] = ACTIONS(542),
    [sym_null_literal] = ACTIONS(544),
    [anon_sym_LPAREN] = ACTIONS(542),
    [anon_sym_LT] = ACTIONS(542),
    [anon_sym_PLUS] = ACTIONS(544),
    [anon_sym_DASH] = ACTIONS(544),
    [anon_sym_final] = ACTIONS(544),
    [anon_sym_BANG] = ACTIONS(542),
    [anon_sym_TILDE] = ACTIONS(542),
    [anon_sym_PLUS_PLUS] = ACTIONS(542),
    [anon_sym_DASH_DASH] = ACTIONS(542),
    [anon_sym_new] = ACTIONS(544),
    [anon_sym_class] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(544),
    [anon_sym_LBRACE] = ACTIONS(542),
    [anon_sym_RBRACE] = ACTIONS(542),
    [anon_sym_case] = ACTIONS(544),
    [anon_sym_default] = ACTIONS(544),
    [anon_sym_SEMI] = ACTIONS(542),
    [anon_sym_assert] = ACTIONS(544),
    [anon_sym_do] = ACTIONS(544),
    [anon_sym_while] = ACTIONS(544),
    [anon_sym_break] = ACTIONS(544),
    [anon_sym_continue] = ACTIONS(544),
    [anon_sym_return] = ACTIONS(544),
    [anon_sym_yield] = ACTIONS(544),
    [anon_sym_synchronized] = ACTIONS(544),
    [anon_sym_throw] = ACTIONS(544),
    [anon_sym_try] = ACTIONS(544),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_else] = ACTIONS(544),
    [anon_sym_for] = ACTIONS(544),
    [anon_sym_AT] = ACTIONS(544),
    [anon_sym_open] = ACTIONS(544),
    [anon_sym_module] = ACTIONS(544),
    [anon_sym_static] = ACTIONS(544),
    [anon_sym_package] = ACTIONS(544),
    [anon_sym_import] = ACTIONS(544),
    [anon_sym_enum] = ACTIONS(544),
    [anon_sym_public] = ACTIONS(544),
    [anon_sym_protected] = ACTIONS(544),
    [anon_sym_private] = ACTIONS(544),
    [anon_sym_abstract] = ACTIONS(544),
    [anon_sym_strictfp] = ACTIONS(544),
    [anon_sym_native] = ACTIONS(544),
    [anon_sym_transient] = ACTIONS(544),
    [anon_sym_volatile] = ACTIONS(544),
    [anon_sym_sealed] = ACTIONS(544),
    [anon_sym_non_DASHsealed] = ACTIONS(542),
    [anon_sym_record] = ACTIONS(544),
    [anon_sym_ATinterface] = ACTIONS(542),
    [anon_sym_interface] = ACTIONS(544),
    [anon_sym_byte] = ACTIONS(544),
    [anon_sym_short] = ACTIONS(544),
    [anon_sym_int] = ACTIONS(544),
    [anon_sym_long] = ACTIONS(544),
    [anon_sym_char] = ACTIONS(544),
    [anon_sym_float] = ACTIONS(544),
    [anon_sym_double] = ACTIONS(544),
    [sym_boolean_type] = ACTIONS(544),
    [sym_void_type] = ACTIONS(544),
    [sym_this] = ACTIONS(544),
    [sym_super] = ACTIONS(544),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [149] = {
    [ts_builtin_sym_end] = ACTIONS(546),
    [sym_identifier] = ACTIONS(548),
    [sym_decimal_integer_literal] = ACTIONS(548),
    [sym_hex_integer_literal] = ACTIONS(548),
    [sym_octal_integer_literal] = ACTIONS(546),
    [sym_binary_integer_literal] = ACTIONS(546),
    [sym_decimal_floating_point_literal] = ACTIONS(546),
    [sym_hex_floating_point_literal] = ACTIONS(548),
    [sym_true] = ACTIONS(548),
    [sym_false] = ACTIONS(548),
    [sym_character_literal] = ACTIONS(546),
    [sym_string_literal] = ACTIONS(548),
    [sym_text_block] = ACTIONS(546),
    [sym_null_literal] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(546),
    [anon_sym_LT] = ACTIONS(546),
    [anon_sym_PLUS] = ACTIONS(548),
    [anon_sym_DASH] = ACTIONS(548),
    [anon_sym_final] = ACTIONS(548),
    [anon_sym_BANG] = ACTIONS(546),
    [anon_sym_TILDE] = ACTIONS(546),
    [anon_sym_PLUS_PLUS] = ACTIONS(546),
    [anon_sym_DASH_DASH] = ACTIONS(546),
    [anon_sym_new] = ACTIONS(548),
    [anon_sym_class] = ACTIONS(548),
    [anon_sym_switch] = ACTIONS(548),
    [anon_sym_LBRACE] = ACTIONS(546),
    [anon_sym_RBRACE] = ACTIONS(546),
    [anon_sym_case] = ACTIONS(548),
    [anon_sym_default] = ACTIONS(548),
    [anon_sym_SEMI] = ACTIONS(546),
    [anon_sym_assert] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(548),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_break] = ACTIONS(548),
    [anon_sym_continue] = ACTIONS(548),
    [anon_sym_return] = ACTIONS(548),
    [anon_sym_yield] = ACTIONS(548),
    [anon_sym_synchronized] = ACTIONS(548),
    [anon_sym_throw] = ACTIONS(548),
    [anon_sym_try] = ACTIONS(548),
    [anon_sym_if] = ACTIONS(548),
    [anon_sym_else] = ACTIONS(548),
    [anon_sym_for] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(548),
    [anon_sym_open] = ACTIONS(548),
    [anon_sym_module] = ACTIONS(548),
    [anon_sym_static] = ACTIONS(548),
    [anon_sym_package] = ACTIONS(548),
    [anon_sym_import] = ACTIONS(548),
    [anon_sym_enum] = ACTIONS(548),
    [anon_sym_public] = ACTIONS(548),
    [anon_sym_protected] = ACTIONS(548),
    [anon_sym_private] = ACTIONS(548),
    [anon_sym_abstract] = ACTIONS(548),
    [anon_sym_strictfp] = ACTIONS(548),
    [anon_sym_native] = ACTIONS(548),
    [anon_sym_transient] = ACTIONS(548),
    [anon_sym_volatile] = ACTIONS(548),
    [anon_sym_sealed] = ACTIONS(548),
    [anon_sym_non_DASHsealed] = ACTIONS(546),
    [anon_sym_record] = ACTIONS(548),
    [anon_sym_ATinterface] = ACTIONS(546),
    [anon_sym_interface] = ACTIONS(548),
    [anon_sym_byte] = ACTIONS(548),
    [anon_sym_short] = ACTIONS(548),
    [anon_sym_int] = ACTIONS(548),
    [anon_sym_long] = ACTIONS(548),
    [anon_sym_char] = ACTIONS(548),
    [anon_sym_float] = ACTIONS(548),
    [anon_sym_double] = ACTIONS(548),
    [sym_boolean_type] = ACTIONS(548),
    [sym_void_type] = ACTIONS(548),
    [sym_this] = ACTIONS(548),
    [sym_super] = ACTIONS(548),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [150] = {
    [ts_builtin_sym_end] = ACTIONS(550),
    [sym_identifier] = ACTIONS(552),
    [sym_decimal_integer_literal] = ACTIONS(552),
    [sym_hex_integer_literal] = ACTIONS(552),
    [sym_octal_integer_literal] = ACTIONS(550),
    [sym_binary_integer_literal] = ACTIONS(550),
    [sym_decimal_floating_point_literal] = ACTIONS(550),
    [sym_hex_floating_point_literal] = ACTIONS(552),
    [sym_true] = ACTIONS(552),
    [sym_false] = ACTIONS(552),
    [sym_character_literal] = ACTIONS(550),
    [sym_string_literal] = ACTIONS(552),
    [sym_text_block] = ACTIONS(550),
    [sym_null_literal] = ACTIONS(552),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_LT] = ACTIONS(550),
    [anon_sym_PLUS] = ACTIONS(552),
    [anon_sym_DASH] = ACTIONS(552),
    [anon_sym_final] = ACTIONS(552),
    [anon_sym_BANG] = ACTIONS(550),
    [anon_sym_TILDE] = ACTIONS(550),
    [anon_sym_PLUS_PLUS] = ACTIONS(550),
    [anon_sym_DASH_DASH] = ACTIONS(550),
    [anon_sym_new] = ACTIONS(552),
    [anon_sym_class] = ACTIONS(552),
    [anon_sym_switch] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(550),
    [anon_sym_RBRACE] = ACTIONS(550),
    [anon_sym_case] = ACTIONS(552),
    [anon_sym_default] = ACTIONS(552),
    [anon_sym_SEMI] = ACTIONS(550),
    [anon_sym_assert] = ACTIONS(552),
    [anon_sym_do] = ACTIONS(552),
    [anon_sym_while] = ACTIONS(552),
    [anon_sym_break] = ACTIONS(552),
    [anon_sym_continue] = ACTIONS(552),
    [anon_sym_return] = ACTIONS(552),
    [anon_sym_yield] = ACTIONS(552),
    [anon_sym_synchronized] = ACTIONS(552),
    [anon_sym_throw] = ACTIONS(552),
    [anon_sym_try] = ACTIONS(552),
    [anon_sym_if] = ACTIONS(552),
    [anon_sym_else] = ACTIONS(552),
    [anon_sym_for] = ACTIONS(552),
    [anon_sym_AT] = ACTIONS(552),
    [anon_sym_open] = ACTIONS(552),
    [anon_sym_module] = ACTIONS(552),
    [anon_sym_static] = ACTIONS(552),
    [anon_sym_package] = ACTIONS(552),
    [anon_sym_import] = ACTIONS(552),
    [anon_sym_enum] = ACTIONS(552),
    [anon_sym_public] = ACTIONS(552),
    [anon_sym_protected] = ACTIONS(552),
    [anon_sym_private] = ACTIONS(552),
    [anon_sym_abstract] = ACTIONS(552),
    [anon_sym_strictfp] = ACTIONS(552),
    [anon_sym_native] = ACTIONS(552),
    [anon_sym_transient] = ACTIONS(552),
    [anon_sym_volatile] = ACTIONS(552),
    [anon_sym_sealed] = ACTIONS(552),
    [anon_sym_non_DASHsealed] = ACTIONS(550),
    [anon_sym_record] = ACTIONS(552),
    [anon_sym_ATinterface] = ACTIONS(550),
    [anon_sym_interface] = ACTIONS(552),
    [anon_sym_byte] = ACTIONS(552),
    [anon_sym_short] = ACTIONS(552),
    [anon_sym_int] = ACTIONS(552),
    [anon_sym_long] = ACTIONS(552),
    [anon_sym_char] = ACTIONS(552),
    [anon_sym_float] = ACTIONS(552),
    [anon_sym_double] = ACTIONS(552),
    [sym_boolean_type] = ACTIONS(552),
    [sym_void_type] = ACTIONS(552),
    [sym_this] = ACTIONS(552),
    [sym_super] = ACTIONS(552),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [151] = {
    [ts_builtin_sym_end] = ACTIONS(554),
    [sym_identifier] = ACTIONS(556),
    [sym_decimal_integer_literal] = ACTIONS(556),
    [sym_hex_integer_literal] = ACTIONS(556),
    [sym_octal_integer_literal] = ACTIONS(554),
    [sym_binary_integer_literal] = ACTIONS(554),
    [sym_decimal_floating_point_literal] = ACTIONS(554),
    [sym_hex_floating_point_literal] = ACTIONS(556),
    [sym_true] = ACTIONS(556),
    [sym_false] = ACTIONS(556),
    [sym_character_literal] = ACTIONS(554),
    [sym_string_literal] = ACTIONS(556),
    [sym_text_block] = ACTIONS(554),
    [sym_null_literal] = ACTIONS(556),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_LT] = ACTIONS(554),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_final] = ACTIONS(556),
    [anon_sym_BANG] = ACTIONS(554),
    [anon_sym_TILDE] = ACTIONS(554),
    [anon_sym_PLUS_PLUS] = ACTIONS(554),
    [anon_sym_DASH_DASH] = ACTIONS(554),
    [anon_sym_new] = ACTIONS(556),
    [anon_sym_class] = ACTIONS(556),
    [anon_sym_switch] = ACTIONS(556),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_RBRACE] = ACTIONS(554),
    [anon_sym_case] = ACTIONS(556),
    [anon_sym_default] = ACTIONS(556),
    [anon_sym_SEMI] = ACTIONS(554),
    [anon_sym_assert] = ACTIONS(556),
    [anon_sym_do] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(556),
    [anon_sym_break] = ACTIONS(556),
    [anon_sym_continue] = ACTIONS(556),
    [anon_sym_return] = ACTIONS(556),
    [anon_sym_yield] = ACTIONS(556),
    [anon_sym_synchronized] = ACTIONS(556),
    [anon_sym_throw] = ACTIONS(556),
    [anon_sym_try] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(556),
    [anon_sym_else] = ACTIONS(556),
    [anon_sym_for] = ACTIONS(556),
    [anon_sym_AT] = ACTIONS(556),
    [anon_sym_open] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(556),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_package] = ACTIONS(556),
    [anon_sym_import] = ACTIONS(556),
    [anon_sym_enum] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(556),
    [anon_sym_strictfp] = ACTIONS(556),
    [anon_sym_native] = ACTIONS(556),
    [anon_sym_transient] = ACTIONS(556),
    [anon_sym_volatile] = ACTIONS(556),
    [anon_sym_sealed] = ACTIONS(556),
    [anon_sym_non_DASHsealed] = ACTIONS(554),
    [anon_sym_record] = ACTIONS(556),
    [anon_sym_ATinterface] = ACTIONS(554),
    [anon_sym_interface] = ACTIONS(556),
    [anon_sym_byte] = ACTIONS(556),
    [anon_sym_short] = ACTIONS(556),
    [anon_sym_int] = ACTIONS(556),
    [anon_sym_long] = ACTIONS(556),
    [anon_sym_char] = ACTIONS(556),
    [anon_sym_float] = ACTIONS(556),
    [anon_sym_double] = ACTIONS(556),
    [sym_boolean_type] = ACTIONS(556),
    [sym_void_type] = ACTIONS(556),
    [sym_this] = ACTIONS(556),
    [sym_super] = ACTIONS(556),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [152] = {
    [ts_builtin_sym_end] = ACTIONS(558),
    [sym_identifier] = ACTIONS(560),
    [sym_decimal_integer_literal] = ACTIONS(560),
    [sym_hex_integer_literal] = ACTIONS(560),
    [sym_octal_integer_literal] = ACTIONS(558),
    [sym_binary_integer_literal] = ACTIONS(558),
    [sym_decimal_floating_point_literal] = ACTIONS(558),
    [sym_hex_floating_point_literal] = ACTIONS(560),
    [sym_true] = ACTIONS(560),
    [sym_false] = ACTIONS(560),
    [sym_character_literal] = ACTIONS(558),
    [sym_string_literal] = ACTIONS(560),
    [sym_text_block] = ACTIONS(558),
    [sym_null_literal] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(558),
    [anon_sym_LT] = ACTIONS(558),
    [anon_sym_PLUS] = ACTIONS(560),
    [anon_sym_DASH] = ACTIONS(560),
    [anon_sym_final] = ACTIONS(560),
    [anon_sym_BANG] = ACTIONS(558),
    [anon_sym_TILDE] = ACTIONS(558),
    [anon_sym_PLUS_PLUS] = ACTIONS(558),
    [anon_sym_DASH_DASH] = ACTIONS(558),
    [anon_sym_new] = ACTIONS(560),
    [anon_sym_class] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(560),
    [anon_sym_LBRACE] = ACTIONS(558),
    [anon_sym_RBRACE] = ACTIONS(558),
    [anon_sym_case] = ACTIONS(560),
    [anon_sym_default] = ACTIONS(560),
    [anon_sym_SEMI] = ACTIONS(558),
    [anon_sym_assert] = ACTIONS(560),
    [anon_sym_do] = ACTIONS(560),
    [anon_sym_while] = ACTIONS(560),
    [anon_sym_break] = ACTIONS(560),
    [anon_sym_continue] = ACTIONS(560),
    [anon_sym_return] = ACTIONS(560),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_synchronized] = ACTIONS(560),
    [anon_sym_throw] = ACTIONS(560),
    [anon_sym_try] = ACTIONS(560),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_else] = ACTIONS(560),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_AT] = ACTIONS(560),
    [anon_sym_open] = ACTIONS(560),
    [anon_sym_module] = ACTIONS(560),
    [anon_sym_static] = ACTIONS(560),
    [anon_sym_package] = ACTIONS(560),
    [anon_sym_import] = ACTIONS(560),
    [anon_sym_enum] = ACTIONS(560),
    [anon_sym_public] = ACTIONS(560),
    [anon_sym_protected] = ACTIONS(560),
    [anon_sym_private] = ACTIONS(560),
    [anon_sym_abstract] = ACTIONS(560),
    [anon_sym_strictfp] = ACTIONS(560),
    [anon_sym_native] = ACTIONS(560),
    [anon_sym_transient] = ACTIONS(560),
    [anon_sym_volatile] = ACTIONS(560),
    [anon_sym_sealed] = ACTIONS(560),
    [anon_sym_non_DASHsealed] = ACTIONS(558),
    [anon_sym_record] = ACTIONS(560),
    [anon_sym_ATinterface] = ACTIONS(558),
    [anon_sym_interface] = ACTIONS(560),
    [anon_sym_byte] = ACTIONS(560),
    [anon_sym_short] = ACTIONS(560),
    [anon_sym_int] = ACTIONS(560),
    [anon_sym_long] = ACTIONS(560),
    [anon_sym_char] = ACTIONS(560),
    [anon_sym_float] = ACTIONS(560),
    [anon_sym_double] = ACTIONS(560),
    [sym_boolean_type] = ACTIONS(560),
    [sym_void_type] = ACTIONS(560),
    [sym_this] = ACTIONS(560),
    [sym_super] = ACTIONS(560),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [153] = {
    [ts_builtin_sym_end] = ACTIONS(562),
    [sym_identifier] = ACTIONS(564),
    [sym_decimal_integer_literal] = ACTIONS(564),
    [sym_hex_integer_literal] = ACTIONS(564),
    [sym_octal_integer_literal] = ACTIONS(562),
    [sym_binary_integer_literal] = ACTIONS(562),
    [sym_decimal_floating_point_literal] = ACTIONS(562),
    [sym_hex_floating_point_literal] = ACTIONS(564),
    [sym_true] = ACTIONS(564),
    [sym_false] = ACTIONS(564),
    [sym_character_literal] = ACTIONS(562),
    [sym_string_literal] = ACTIONS(564),
    [sym_text_block] = ACTIONS(562),
    [sym_null_literal] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(562),
    [anon_sym_PLUS] = ACTIONS(564),
    [anon_sym_DASH] = ACTIONS(564),
    [anon_sym_final] = ACTIONS(564),
    [anon_sym_BANG] = ACTIONS(562),
    [anon_sym_TILDE] = ACTIONS(562),
    [anon_sym_PLUS_PLUS] = ACTIONS(562),
    [anon_sym_DASH_DASH] = ACTIONS(562),
    [anon_sym_new] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_switch] = ACTIONS(564),
    [anon_sym_LBRACE] = ACTIONS(562),
    [anon_sym_RBRACE] = ACTIONS(562),
    [anon_sym_case] = ACTIONS(564),
    [anon_sym_default] = ACTIONS(564),
    [anon_sym_SEMI] = ACTIONS(562),
    [anon_sym_assert] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(564),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_break] = ACTIONS(564),
    [anon_sym_continue] = ACTIONS(564),
    [anon_sym_return] = ACTIONS(564),
    [anon_sym_yield] = ACTIONS(564),
    [anon_sym_synchronized] = ACTIONS(564),
    [anon_sym_throw] = ACTIONS(564),
    [anon_sym_try] = ACTIONS(564),
    [anon_sym_if] = ACTIONS(564),
    [anon_sym_else] = ACTIONS(564),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_AT] = ACTIONS(564),
    [anon_sym_open] = ACTIONS(564),
    [anon_sym_module] = ACTIONS(564),
    [anon_sym_static] = ACTIONS(564),
    [anon_sym_package] = ACTIONS(564),
    [anon_sym_import] = ACTIONS(564),
    [anon_sym_enum] = ACTIONS(564),
    [anon_sym_public] = ACTIONS(564),
    [anon_sym_protected] = ACTIONS(564),
    [anon_sym_private] = ACTIONS(564),
    [anon_sym_abstract] = ACTIONS(564),
    [anon_sym_strictfp] = ACTIONS(564),
    [anon_sym_native] = ACTIONS(564),
    [anon_sym_transient] = ACTIONS(564),
    [anon_sym_volatile] = ACTIONS(564),
    [anon_sym_sealed] = ACTIONS(564),
    [anon_sym_non_DASHsealed] = ACTIONS(562),
    [anon_sym_record] = ACTIONS(564),
    [anon_sym_ATinterface] = ACTIONS(562),
    [anon_sym_interface] = ACTIONS(564),
    [anon_sym_byte] = ACTIONS(564),
    [anon_sym_short] = ACTIONS(564),
    [anon_sym_int] = ACTIONS(564),
    [anon_sym_long] = ACTIONS(564),
    [anon_sym_char] = ACTIONS(564),
    [anon_sym_float] = ACTIONS(564),
    [anon_sym_double] = ACTIONS(564),
    [sym_boolean_type] = ACTIONS(564),
    [sym_void_type] = ACTIONS(564),
    [sym_this] = ACTIONS(564),
    [sym_super] = ACTIONS(564),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [154] = {
    [ts_builtin_sym_end] = ACTIONS(566),
    [sym_identifier] = ACTIONS(568),
    [sym_decimal_integer_literal] = ACTIONS(568),
    [sym_hex_integer_literal] = ACTIONS(568),
    [sym_octal_integer_literal] = ACTIONS(566),
    [sym_binary_integer_literal] = ACTIONS(566),
    [sym_decimal_floating_point_literal] = ACTIONS(566),
    [sym_hex_floating_point_literal] = ACTIONS(568),
    [sym_true] = ACTIONS(568),
    [sym_false] = ACTIONS(568),
    [sym_character_literal] = ACTIONS(566),
    [sym_string_literal] = ACTIONS(568),
    [sym_text_block] = ACTIONS(566),
    [sym_null_literal] = ACTIONS(568),
    [anon_sym_LPAREN] = ACTIONS(566),
    [anon_sym_LT] = ACTIONS(566),
    [anon_sym_PLUS] = ACTIONS(568),
    [anon_sym_DASH] = ACTIONS(568),
    [anon_sym_final] = ACTIONS(568),
    [anon_sym_BANG] = ACTIONS(566),
    [anon_sym_TILDE] = ACTIONS(566),
    [anon_sym_PLUS_PLUS] = ACTIONS(566),
    [anon_sym_DASH_DASH] = ACTIONS(566),
    [anon_sym_new] = ACTIONS(568),
    [anon_sym_class] = ACTIONS(568),
    [anon_sym_switch] = ACTIONS(568),
    [anon_sym_LBRACE] = ACTIONS(566),
    [anon_sym_RBRACE] = ACTIONS(566),
    [anon_sym_case] = ACTIONS(568),
    [anon_sym_default] = ACTIONS(568),
    [anon_sym_SEMI] = ACTIONS(566),
    [anon_sym_assert] = ACTIONS(568),
    [anon_sym_do] = ACTIONS(568),
    [anon_sym_while] = ACTIONS(568),
    [anon_sym_break] = ACTIONS(568),
    [anon_sym_continue] = ACTIONS(568),
    [anon_sym_return] = ACTIONS(568),
    [anon_sym_yield] = ACTIONS(568),
    [anon_sym_synchronized] = ACTIONS(568),
    [anon_sym_throw] = ACTIONS(568),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_if] = ACTIONS(568),
    [anon_sym_else] = ACTIONS(568),
    [anon_sym_for] = ACTIONS(568),
    [anon_sym_AT] = ACTIONS(568),
    [anon_sym_open] = ACTIONS(568),
    [anon_sym_module] = ACTIONS(568),
    [anon_sym_static] = ACTIONS(568),
    [anon_sym_package] = ACTIONS(568),
    [anon_sym_import] = ACTIONS(568),
    [anon_sym_enum] = ACTIONS(568),
    [anon_sym_public] = ACTIONS(568),
    [anon_sym_protected] = ACTIONS(568),
    [anon_sym_private] = ACTIONS(568),
    [anon_sym_abstract] = ACTIONS(568),
    [anon_sym_strictfp] = ACTIONS(568),
    [anon_sym_native] = ACTIONS(568),
    [anon_sym_transient] = ACTIONS(568),
    [anon_sym_volatile] = ACTIONS(568),
    [anon_sym_sealed] = ACTIONS(568),
    [anon_sym_non_DASHsealed] = ACTIONS(566),
    [anon_sym_record] = ACTIONS(568),
    [anon_sym_ATinterface] = ACTIONS(566),
    [anon_sym_interface] = ACTIONS(568),
    [anon_sym_byte] = ACTIONS(568),
    [anon_sym_short] = ACTIONS(568),
    [anon_sym_int] = ACTIONS(568),
    [anon_sym_long] = ACTIONS(568),
    [anon_sym_char] = ACTIONS(568),
    [anon_sym_float] = ACTIONS(568),
    [anon_sym_double] = ACTIONS(568),
    [sym_boolean_type] = ACTIONS(568),
    [sym_void_type] = ACTIONS(568),
    [sym_this] = ACTIONS(568),
    [sym_super] = ACTIONS(568),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [155] = {
    [ts_builtin_sym_end] = ACTIONS(570),
    [sym_identifier] = ACTIONS(572),
    [sym_decimal_integer_literal] = ACTIONS(572),
    [sym_hex_integer_literal] = ACTIONS(572),
    [sym_octal_integer_literal] = ACTIONS(570),
    [sym_binary_integer_literal] = ACTIONS(570),
    [sym_decimal_floating_point_literal] = ACTIONS(570),
    [sym_hex_floating_point_literal] = ACTIONS(572),
    [sym_true] = ACTIONS(572),
    [sym_false] = ACTIONS(572),
    [sym_character_literal] = ACTIONS(570),
    [sym_string_literal] = ACTIONS(572),
    [sym_text_block] = ACTIONS(570),
    [sym_null_literal] = ACTIONS(572),
    [anon_sym_LPAREN] = ACTIONS(570),
    [anon_sym_LT] = ACTIONS(570),
    [anon_sym_PLUS] = ACTIONS(572),
    [anon_sym_DASH] = ACTIONS(572),
    [anon_sym_final] = ACTIONS(572),
    [anon_sym_BANG] = ACTIONS(570),
    [anon_sym_TILDE] = ACTIONS(570),
    [anon_sym_PLUS_PLUS] = ACTIONS(570),
    [anon_sym_DASH_DASH] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_class] = ACTIONS(572),
    [anon_sym_switch] = ACTIONS(572),
    [anon_sym_LBRACE] = ACTIONS(570),
    [anon_sym_RBRACE] = ACTIONS(570),
    [anon_sym_case] = ACTIONS(572),
    [anon_sym_default] = ACTIONS(572),
    [anon_sym_SEMI] = ACTIONS(570),
    [anon_sym_assert] = ACTIONS(572),
    [anon_sym_do] = ACTIONS(572),
    [anon_sym_while] = ACTIONS(572),
    [anon_sym_break] = ACTIONS(572),
    [anon_sym_continue] = ACTIONS(572),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(572),
    [anon_sym_synchronized] = ACTIONS(572),
    [anon_sym_throw] = ACTIONS(572),
    [anon_sym_try] = ACTIONS(572),
    [anon_sym_if] = ACTIONS(572),
    [anon_sym_else] = ACTIONS(572),
    [anon_sym_for] = ACTIONS(572),
    [anon_sym_AT] = ACTIONS(572),
    [anon_sym_open] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(572),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_package] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(572),
    [anon_sym_enum] = ACTIONS(572),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(572),
    [anon_sym_strictfp] = ACTIONS(572),
    [anon_sym_native] = ACTIONS(572),
    [anon_sym_transient] = ACTIONS(572),
    [anon_sym_volatile] = ACTIONS(572),
    [anon_sym_sealed] = ACTIONS(572),
    [anon_sym_non_DASHsealed] = ACTIONS(570),
    [anon_sym_record] = ACTIONS(572),
    [anon_sym_ATinterface] = ACTIONS(570),
    [anon_sym_interface] = ACTIONS(572),
    [anon_sym_byte] = ACTIONS(572),
    [anon_sym_short] = ACTIONS(572),
    [anon_sym_int] = ACTIONS(572),
    [anon_sym_long] = ACTIONS(572),
    [anon_sym_char] = ACTIONS(572),
    [anon_sym_float] = ACTIONS(572),
    [anon_sym_double] = ACTIONS(572),
    [sym_boolean_type] = ACTIONS(572),
    [sym_void_type] = ACTIONS(572),
    [sym_this] = ACTIONS(572),
    [sym_super] = ACTIONS(572),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [156] = {
    [ts_builtin_sym_end] = ACTIONS(574),
    [sym_identifier] = ACTIONS(576),
    [sym_decimal_integer_literal] = ACTIONS(576),
    [sym_hex_integer_literal] = ACTIONS(576),
    [sym_octal_integer_literal] = ACTIONS(574),
    [sym_binary_integer_literal] = ACTIONS(574),
    [sym_decimal_floating_point_literal] = ACTIONS(574),
    [sym_hex_floating_point_literal] = ACTIONS(576),
    [sym_true] = ACTIONS(576),
    [sym_false] = ACTIONS(576),
    [sym_character_literal] = ACTIONS(574),
    [sym_string_literal] = ACTIONS(576),
    [sym_text_block] = ACTIONS(574),
    [sym_null_literal] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(574),
    [anon_sym_LT] = ACTIONS(574),
    [anon_sym_PLUS] = ACTIONS(576),
    [anon_sym_DASH] = ACTIONS(576),
    [anon_sym_final] = ACTIONS(576),
    [anon_sym_BANG] = ACTIONS(574),
    [anon_sym_TILDE] = ACTIONS(574),
    [anon_sym_PLUS_PLUS] = ACTIONS(574),
    [anon_sym_DASH_DASH] = ACTIONS(574),
    [anon_sym_new] = ACTIONS(576),
    [anon_sym_class] = ACTIONS(576),
    [anon_sym_switch] = ACTIONS(576),
    [anon_sym_LBRACE] = ACTIONS(574),
    [anon_sym_RBRACE] = ACTIONS(574),
    [anon_sym_case] = ACTIONS(576),
    [anon_sym_default] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(574),
    [anon_sym_assert] = ACTIONS(576),
    [anon_sym_do] = ACTIONS(576),
    [anon_sym_while] = ACTIONS(576),
    [anon_sym_break] = ACTIONS(576),
    [anon_sym_continue] = ACTIONS(576),
    [anon_sym_return] = ACTIONS(576),
    [anon_sym_yield] = ACTIONS(576),
    [anon_sym_synchronized] = ACTIONS(576),
    [anon_sym_throw] = ACTIONS(576),
    [anon_sym_try] = ACTIONS(576),
    [anon_sym_if] = ACTIONS(576),
    [anon_sym_else] = ACTIONS(576),
    [anon_sym_for] = ACTIONS(576),
    [anon_sym_AT] = ACTIONS(576),
    [anon_sym_open] = ACTIONS(576),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_static] = ACTIONS(576),
    [anon_sym_package] = ACTIONS(576),
    [anon_sym_import] = ACTIONS(576),
    [anon_sym_enum] = ACTIONS(576),
    [anon_sym_public] = ACTIONS(576),
    [anon_sym_protected] = ACTIONS(576),
    [anon_sym_private] = ACTIONS(576),
    [anon_sym_abstract] = ACTIONS(576),
    [anon_sym_strictfp] = ACTIONS(576),
    [anon_sym_native] = ACTIONS(576),
    [anon_sym_transient] = ACTIONS(576),
    [anon_sym_volatile] = ACTIONS(576),
    [anon_sym_sealed] = ACTIONS(576),
    [anon_sym_non_DASHsealed] = ACTIONS(574),
    [anon_sym_record] = ACTIONS(576),
    [anon_sym_ATinterface] = ACTIONS(574),
    [anon_sym_interface] = ACTIONS(576),
    [anon_sym_byte] = ACTIONS(576),
    [anon_sym_short] = ACTIONS(576),
    [anon_sym_int] = ACTIONS(576),
    [anon_sym_long] = ACTIONS(576),
    [anon_sym_char] = ACTIONS(576),
    [anon_sym_float] = ACTIONS(576),
    [anon_sym_double] = ACTIONS(576),
    [sym_boolean_type] = ACTIONS(576),
    [sym_void_type] = ACTIONS(576),
    [sym_this] = ACTIONS(576),
    [sym_super] = ACTIONS(576),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [157] = {
    [ts_builtin_sym_end] = ACTIONS(578),
    [sym_identifier] = ACTIONS(580),
    [sym_decimal_integer_literal] = ACTIONS(580),
    [sym_hex_integer_literal] = ACTIONS(580),
    [sym_octal_integer_literal] = ACTIONS(578),
    [sym_binary_integer_literal] = ACTIONS(578),
    [sym_decimal_floating_point_literal] = ACTIONS(578),
    [sym_hex_floating_point_literal] = ACTIONS(580),
    [sym_true] = ACTIONS(580),
    [sym_false] = ACTIONS(580),
    [sym_character_literal] = ACTIONS(578),
    [sym_string_literal] = ACTIONS(580),
    [sym_text_block] = ACTIONS(578),
    [sym_null_literal] = ACTIONS(580),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_LT] = ACTIONS(578),
    [anon_sym_PLUS] = ACTIONS(580),
    [anon_sym_DASH] = ACTIONS(580),
    [anon_sym_final] = ACTIONS(580),
    [anon_sym_BANG] = ACTIONS(578),
    [anon_sym_TILDE] = ACTIONS(578),
    [anon_sym_PLUS_PLUS] = ACTIONS(578),
    [anon_sym_DASH_DASH] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(580),
    [anon_sym_class] = ACTIONS(580),
    [anon_sym_switch] = ACTIONS(580),
    [anon_sym_LBRACE] = ACTIONS(578),
    [anon_sym_RBRACE] = ACTIONS(578),
    [anon_sym_case] = ACTIONS(580),
    [anon_sym_default] = ACTIONS(580),
    [anon_sym_SEMI] = ACTIONS(578),
    [anon_sym_assert] = ACTIONS(580),
    [anon_sym_do] = ACTIONS(580),
    [anon_sym_while] = ACTIONS(580),
    [anon_sym_break] = ACTIONS(580),
    [anon_sym_continue] = ACTIONS(580),
    [anon_sym_return] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(580),
    [anon_sym_synchronized] = ACTIONS(580),
    [anon_sym_throw] = ACTIONS(580),
    [anon_sym_try] = ACTIONS(580),
    [anon_sym_if] = ACTIONS(580),
    [anon_sym_else] = ACTIONS(580),
    [anon_sym_for] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(580),
    [anon_sym_open] = ACTIONS(580),
    [anon_sym_module] = ACTIONS(580),
    [anon_sym_static] = ACTIONS(580),
    [anon_sym_package] = ACTIONS(580),
    [anon_sym_import] = ACTIONS(580),
    [anon_sym_enum] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(580),
    [anon_sym_protected] = ACTIONS(580),
    [anon_sym_private] = ACTIONS(580),
    [anon_sym_abstract] = ACTIONS(580),
    [anon_sym_strictfp] = ACTIONS(580),
    [anon_sym_native] = ACTIONS(580),
    [anon_sym_transient] = ACTIONS(580),
    [anon_sym_volatile] = ACTIONS(580),
    [anon_sym_sealed] = ACTIONS(580),
    [anon_sym_non_DASHsealed] = ACTIONS(578),
    [anon_sym_record] = ACTIONS(580),
    [anon_sym_ATinterface] = ACTIONS(578),
    [anon_sym_interface] = ACTIONS(580),
    [anon_sym_byte] = ACTIONS(580),
    [anon_sym_short] = ACTIONS(580),
    [anon_sym_int] = ACTIONS(580),
    [anon_sym_long] = ACTIONS(580),
    [anon_sym_char] = ACTIONS(580),
    [anon_sym_float] = ACTIONS(580),
    [anon_sym_double] = ACTIONS(580),
    [sym_boolean_type] = ACTIONS(580),
    [sym_void_type] = ACTIONS(580),
    [sym_this] = ACTIONS(580),
    [sym_super] = ACTIONS(580),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [158] = {
    [ts_builtin_sym_end] = ACTIONS(582),
    [sym_identifier] = ACTIONS(584),
    [sym_decimal_integer_literal] = ACTIONS(584),
    [sym_hex_integer_literal] = ACTIONS(584),
    [sym_octal_integer_literal] = ACTIONS(582),
    [sym_binary_integer_literal] = ACTIONS(582),
    [sym_decimal_floating_point_literal] = ACTIONS(582),
    [sym_hex_floating_point_literal] = ACTIONS(584),
    [sym_true] = ACTIONS(584),
    [sym_false] = ACTIONS(584),
    [sym_character_literal] = ACTIONS(582),
    [sym_string_literal] = ACTIONS(584),
    [sym_text_block] = ACTIONS(582),
    [sym_null_literal] = ACTIONS(584),
    [anon_sym_LPAREN] = ACTIONS(582),
    [anon_sym_LT] = ACTIONS(582),
    [anon_sym_PLUS] = ACTIONS(584),
    [anon_sym_DASH] = ACTIONS(584),
    [anon_sym_final] = ACTIONS(584),
    [anon_sym_BANG] = ACTIONS(582),
    [anon_sym_TILDE] = ACTIONS(582),
    [anon_sym_PLUS_PLUS] = ACTIONS(582),
    [anon_sym_DASH_DASH] = ACTIONS(582),
    [anon_sym_new] = ACTIONS(584),
    [anon_sym_class] = ACTIONS(584),
    [anon_sym_switch] = ACTIONS(584),
    [anon_sym_LBRACE] = ACTIONS(582),
    [anon_sym_RBRACE] = ACTIONS(582),
    [anon_sym_case] = ACTIONS(584),
    [anon_sym_default] = ACTIONS(584),
    [anon_sym_SEMI] = ACTIONS(582),
    [anon_sym_assert] = ACTIONS(584),
    [anon_sym_do] = ACTIONS(584),
    [anon_sym_while] = ACTIONS(584),
    [anon_sym_break] = ACTIONS(584),
    [anon_sym_continue] = ACTIONS(584),
    [anon_sym_return] = ACTIONS(584),
    [anon_sym_yield] = ACTIONS(584),
    [anon_sym_synchronized] = ACTIONS(584),
    [anon_sym_throw] = ACTIONS(584),
    [anon_sym_try] = ACTIONS(584),
    [anon_sym_if] = ACTIONS(584),
    [anon_sym_else] = ACTIONS(584),
    [anon_sym_for] = ACTIONS(584),
    [anon_sym_AT] = ACTIONS(584),
    [anon_sym_open] = ACTIONS(584),
    [anon_sym_module] = ACTIONS(584),
    [anon_sym_static] = ACTIONS(584),
    [anon_sym_package] = ACTIONS(584),
    [anon_sym_import] = ACTIONS(584),
    [anon_sym_enum] = ACTIONS(584),
    [anon_sym_public] = ACTIONS(584),
    [anon_sym_protected] = ACTIONS(584),
    [anon_sym_private] = ACTIONS(584),
    [anon_sym_abstract] = ACTIONS(584),
    [anon_sym_strictfp] = ACTIONS(584),
    [anon_sym_native] = ACTIONS(584),
    [anon_sym_transient] = ACTIONS(584),
    [anon_sym_volatile] = ACTIONS(584),
    [anon_sym_sealed] = ACTIONS(584),
    [anon_sym_non_DASHsealed] = ACTIONS(582),
    [anon_sym_record] = ACTIONS(584),
    [anon_sym_ATinterface] = ACTIONS(582),
    [anon_sym_interface] = ACTIONS(584),
    [anon_sym_byte] = ACTIONS(584),
    [anon_sym_short] = ACTIONS(584),
    [anon_sym_int] = ACTIONS(584),
    [anon_sym_long] = ACTIONS(584),
    [anon_sym_char] = ACTIONS(584),
    [anon_sym_float] = ACTIONS(584),
    [anon_sym_double] = ACTIONS(584),
    [sym_boolean_type] = ACTIONS(584),
    [sym_void_type] = ACTIONS(584),
    [sym_this] = ACTIONS(584),
    [sym_super] = ACTIONS(584),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [159] = {
    [ts_builtin_sym_end] = ACTIONS(586),
    [sym_identifier] = ACTIONS(588),
    [sym_decimal_integer_literal] = ACTIONS(588),
    [sym_hex_integer_literal] = ACTIONS(588),
    [sym_octal_integer_literal] = ACTIONS(586),
    [sym_binary_integer_literal] = ACTIONS(586),
    [sym_decimal_floating_point_literal] = ACTIONS(586),
    [sym_hex_floating_point_literal] = ACTIONS(588),
    [sym_true] = ACTIONS(588),
    [sym_false] = ACTIONS(588),
    [sym_character_literal] = ACTIONS(586),
    [sym_string_literal] = ACTIONS(588),
    [sym_text_block] = ACTIONS(586),
    [sym_null_literal] = ACTIONS(588),
    [anon_sym_LPAREN] = ACTIONS(586),
    [anon_sym_LT] = ACTIONS(586),
    [anon_sym_PLUS] = ACTIONS(588),
    [anon_sym_DASH] = ACTIONS(588),
    [anon_sym_final] = ACTIONS(588),
    [anon_sym_BANG] = ACTIONS(586),
    [anon_sym_TILDE] = ACTIONS(586),
    [anon_sym_PLUS_PLUS] = ACTIONS(586),
    [anon_sym_DASH_DASH] = ACTIONS(586),
    [anon_sym_new] = ACTIONS(588),
    [anon_sym_class] = ACTIONS(588),
    [anon_sym_switch] = ACTIONS(588),
    [anon_sym_LBRACE] = ACTIONS(586),
    [anon_sym_RBRACE] = ACTIONS(586),
    [anon_sym_case] = ACTIONS(588),
    [anon_sym_default] = ACTIONS(588),
    [anon_sym_SEMI] = ACTIONS(586),
    [anon_sym_assert] = ACTIONS(588),
    [anon_sym_do] = ACTIONS(588),
    [anon_sym_while] = ACTIONS(588),
    [anon_sym_break] = ACTIONS(588),
    [anon_sym_continue] = ACTIONS(588),
    [anon_sym_return] = ACTIONS(588),
    [anon_sym_yield] = ACTIONS(588),
    [anon_sym_synchronized] = ACTIONS(588),
    [anon_sym_throw] = ACTIONS(588),
    [anon_sym_try] = ACTIONS(588),
    [anon_sym_if] = ACTIONS(588),
    [anon_sym_else] = ACTIONS(588),
    [anon_sym_for] = ACTIONS(588),
    [anon_sym_AT] = ACTIONS(588),
    [anon_sym_open] = ACTIONS(588),
    [anon_sym_module] = ACTIONS(588),
    [anon_sym_static] = ACTIONS(588),
    [anon_sym_package] = ACTIONS(588),
    [anon_sym_import] = ACTIONS(588),
    [anon_sym_enum] = ACTIONS(588),
    [anon_sym_public] = ACTIONS(588),
    [anon_sym_protected] = ACTIONS(588),
    [anon_sym_private] = ACTIONS(588),
    [anon_sym_abstract] = ACTIONS(588),
    [anon_sym_strictfp] = ACTIONS(588),
    [anon_sym_native] = ACTIONS(588),
    [anon_sym_transient] = ACTIONS(588),
    [anon_sym_volatile] = ACTIONS(588),
    [anon_sym_sealed] = ACTIONS(588),
    [anon_sym_non_DASHsealed] = ACTIONS(586),
    [anon_sym_record] = ACTIONS(588),
    [anon_sym_ATinterface] = ACTIONS(586),
    [anon_sym_interface] = ACTIONS(588),
    [anon_sym_byte] = ACTIONS(588),
    [anon_sym_short] = ACTIONS(588),
    [anon_sym_int] = ACTIONS(588),
    [anon_sym_long] = ACTIONS(588),
    [anon_sym_char] = ACTIONS(588),
    [anon_sym_float] = ACTIONS(588),
    [anon_sym_double] = ACTIONS(588),
    [sym_boolean_type] = ACTIONS(588),
    [sym_void_type] = ACTIONS(588),
    [sym_this] = ACTIONS(588),
    [sym_super] = ACTIONS(588),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [160] = {
    [ts_builtin_sym_end] = ACTIONS(590),
    [sym_identifier] = ACTIONS(592),
    [sym_decimal_integer_literal] = ACTIONS(592),
    [sym_hex_integer_literal] = ACTIONS(592),
    [sym_octal_integer_literal] = ACTIONS(590),
    [sym_binary_integer_literal] = ACTIONS(590),
    [sym_decimal_floating_point_literal] = ACTIONS(590),
    [sym_hex_floating_point_literal] = ACTIONS(592),
    [sym_true] = ACTIONS(592),
    [sym_false] = ACTIONS(592),
    [sym_character_literal] = ACTIONS(590),
    [sym_string_literal] = ACTIONS(592),
    [sym_text_block] = ACTIONS(590),
    [sym_null_literal] = ACTIONS(592),
    [anon_sym_LPAREN] = ACTIONS(590),
    [anon_sym_LT] = ACTIONS(590),
    [anon_sym_PLUS] = ACTIONS(592),
    [anon_sym_DASH] = ACTIONS(592),
    [anon_sym_final] = ACTIONS(592),
    [anon_sym_BANG] = ACTIONS(590),
    [anon_sym_TILDE] = ACTIONS(590),
    [anon_sym_PLUS_PLUS] = ACTIONS(590),
    [anon_sym_DASH_DASH] = ACTIONS(590),
    [anon_sym_new] = ACTIONS(592),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_switch] = ACTIONS(592),
    [anon_sym_LBRACE] = ACTIONS(590),
    [anon_sym_RBRACE] = ACTIONS(590),
    [anon_sym_case] = ACTIONS(592),
    [anon_sym_default] = ACTIONS(592),
    [anon_sym_SEMI] = ACTIONS(590),
    [anon_sym_assert] = ACTIONS(592),
    [anon_sym_do] = ACTIONS(592),
    [anon_sym_while] = ACTIONS(592),
    [anon_sym_break] = ACTIONS(592),
    [anon_sym_continue] = ACTIONS(592),
    [anon_sym_return] = ACTIONS(592),
    [anon_sym_yield] = ACTIONS(592),
    [anon_sym_synchronized] = ACTIONS(592),
    [anon_sym_throw] = ACTIONS(592),
    [anon_sym_try] = ACTIONS(592),
    [anon_sym_if] = ACTIONS(592),
    [anon_sym_else] = ACTIONS(592),
    [anon_sym_for] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(592),
    [anon_sym_open] = ACTIONS(592),
    [anon_sym_module] = ACTIONS(592),
    [anon_sym_static] = ACTIONS(592),
    [anon_sym_package] = ACTIONS(592),
    [anon_sym_import] = ACTIONS(592),
    [anon_sym_enum] = ACTIONS(592),
    [anon_sym_public] = ACTIONS(592),
    [anon_sym_protected] = ACTIONS(592),
    [anon_sym_private] = ACTIONS(592),
    [anon_sym_abstract] = ACTIONS(592),
    [anon_sym_strictfp] = ACTIONS(592),
    [anon_sym_native] = ACTIONS(592),
    [anon_sym_transient] = ACTIONS(592),
    [anon_sym_volatile] = ACTIONS(592),
    [anon_sym_sealed] = ACTIONS(592),
    [anon_sym_non_DASHsealed] = ACTIONS(590),
    [anon_sym_record] = ACTIONS(592),
    [anon_sym_ATinterface] = ACTIONS(590),
    [anon_sym_interface] = ACTIONS(592),
    [anon_sym_byte] = ACTIONS(592),
    [anon_sym_short] = ACTIONS(592),
    [anon_sym_int] = ACTIONS(592),
    [anon_sym_long] = ACTIONS(592),
    [anon_sym_char] = ACTIONS(592),
    [anon_sym_float] = ACTIONS(592),
    [anon_sym_double] = ACTIONS(592),
    [sym_boolean_type] = ACTIONS(592),
    [sym_void_type] = ACTIONS(592),
    [sym_this] = ACTIONS(592),
    [sym_super] = ACTIONS(592),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [161] = {
    [ts_builtin_sym_end] = ACTIONS(594),
    [sym_identifier] = ACTIONS(596),
    [sym_decimal_integer_literal] = ACTIONS(596),
    [sym_hex_integer_literal] = ACTIONS(596),
    [sym_octal_integer_literal] = ACTIONS(594),
    [sym_binary_integer_literal] = ACTIONS(594),
    [sym_decimal_floating_point_literal] = ACTIONS(594),
    [sym_hex_floating_point_literal] = ACTIONS(596),
    [sym_true] = ACTIONS(596),
    [sym_false] = ACTIONS(596),
    [sym_character_literal] = ACTIONS(594),
    [sym_string_literal] = ACTIONS(596),
    [sym_text_block] = ACTIONS(594),
    [sym_null_literal] = ACTIONS(596),
    [anon_sym_LPAREN] = ACTIONS(594),
    [anon_sym_LT] = ACTIONS(594),
    [anon_sym_PLUS] = ACTIONS(596),
    [anon_sym_DASH] = ACTIONS(596),
    [anon_sym_final] = ACTIONS(596),
    [anon_sym_BANG] = ACTIONS(594),
    [anon_sym_TILDE] = ACTIONS(594),
    [anon_sym_PLUS_PLUS] = ACTIONS(594),
    [anon_sym_DASH_DASH] = ACTIONS(594),
    [anon_sym_new] = ACTIONS(596),
    [anon_sym_class] = ACTIONS(596),
    [anon_sym_switch] = ACTIONS(596),
    [anon_sym_LBRACE] = ACTIONS(594),
    [anon_sym_RBRACE] = ACTIONS(594),
    [anon_sym_case] = ACTIONS(596),
    [anon_sym_default] = ACTIONS(596),
    [anon_sym_SEMI] = ACTIONS(594),
    [anon_sym_assert] = ACTIONS(596),
    [anon_sym_do] = ACTIONS(596),
    [anon_sym_while] = ACTIONS(596),
    [anon_sym_break] = ACTIONS(596),
    [anon_sym_continue] = ACTIONS(596),
    [anon_sym_return] = ACTIONS(596),
    [anon_sym_yield] = ACTIONS(596),
    [anon_sym_synchronized] = ACTIONS(596),
    [anon_sym_throw] = ACTIONS(596),
    [anon_sym_try] = ACTIONS(596),
    [anon_sym_if] = ACTIONS(596),
    [anon_sym_else] = ACTIONS(596),
    [anon_sym_for] = ACTIONS(596),
    [anon_sym_AT] = ACTIONS(596),
    [anon_sym_open] = ACTIONS(596),
    [anon_sym_module] = ACTIONS(596),
    [anon_sym_static] = ACTIONS(596),
    [anon_sym_package] = ACTIONS(596),
    [anon_sym_import] = ACTIONS(596),
    [anon_sym_enum] = ACTIONS(596),
    [anon_sym_public] = ACTIONS(596),
    [anon_sym_protected] = ACTIONS(596),
    [anon_sym_private] = ACTIONS(596),
    [anon_sym_abstract] = ACTIONS(596),
    [anon_sym_strictfp] = ACTIONS(596),
    [anon_sym_native] = ACTIONS(596),
    [anon_sym_transient] = ACTIONS(596),
    [anon_sym_volatile] = ACTIONS(596),
    [anon_sym_sealed] = ACTIONS(596),
    [anon_sym_non_DASHsealed] = ACTIONS(594),
    [anon_sym_record] = ACTIONS(596),
    [anon_sym_ATinterface] = ACTIONS(594),
    [anon_sym_interface] = ACTIONS(596),
    [anon_sym_byte] = ACTIONS(596),
    [anon_sym_short] = ACTIONS(596),
    [anon_sym_int] = ACTIONS(596),
    [anon_sym_long] = ACTIONS(596),
    [anon_sym_char] = ACTIONS(596),
    [anon_sym_float] = ACTIONS(596),
    [anon_sym_double] = ACTIONS(596),
    [sym_boolean_type] = ACTIONS(596),
    [sym_void_type] = ACTIONS(596),
    [sym_this] = ACTIONS(596),
    [sym_super] = ACTIONS(596),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [162] = {
    [ts_builtin_sym_end] = ACTIONS(598),
    [sym_identifier] = ACTIONS(600),
    [sym_decimal_integer_literal] = ACTIONS(600),
    [sym_hex_integer_literal] = ACTIONS(600),
    [sym_octal_integer_literal] = ACTIONS(598),
    [sym_binary_integer_literal] = ACTIONS(598),
    [sym_decimal_floating_point_literal] = ACTIONS(598),
    [sym_hex_floating_point_literal] = ACTIONS(600),
    [sym_true] = ACTIONS(600),
    [sym_false] = ACTIONS(600),
    [sym_character_literal] = ACTIONS(598),
    [sym_string_literal] = ACTIONS(600),
    [sym_text_block] = ACTIONS(598),
    [sym_null_literal] = ACTIONS(600),
    [anon_sym_LPAREN] = ACTIONS(598),
    [anon_sym_LT] = ACTIONS(598),
    [anon_sym_PLUS] = ACTIONS(600),
    [anon_sym_DASH] = ACTIONS(600),
    [anon_sym_final] = ACTIONS(600),
    [anon_sym_BANG] = ACTIONS(598),
    [anon_sym_TILDE] = ACTIONS(598),
    [anon_sym_PLUS_PLUS] = ACTIONS(598),
    [anon_sym_DASH_DASH] = ACTIONS(598),
    [anon_sym_new] = ACTIONS(600),
    [anon_sym_class] = ACTIONS(600),
    [anon_sym_switch] = ACTIONS(600),
    [anon_sym_LBRACE] = ACTIONS(598),
    [anon_sym_RBRACE] = ACTIONS(598),
    [anon_sym_case] = ACTIONS(600),
    [anon_sym_default] = ACTIONS(600),
    [anon_sym_SEMI] = ACTIONS(598),
    [anon_sym_assert] = ACTIONS(600),
    [anon_sym_do] = ACTIONS(600),
    [anon_sym_while] = ACTIONS(600),
    [anon_sym_break] = ACTIONS(600),
    [anon_sym_continue] = ACTIONS(600),
    [anon_sym_return] = ACTIONS(600),
    [anon_sym_yield] = ACTIONS(600),
    [anon_sym_synchronized] = ACTIONS(600),
    [anon_sym_throw] = ACTIONS(600),
    [anon_sym_try] = ACTIONS(600),
    [anon_sym_if] = ACTIONS(600),
    [anon_sym_else] = ACTIONS(600),
    [anon_sym_for] = ACTIONS(600),
    [anon_sym_AT] = ACTIONS(600),
    [anon_sym_open] = ACTIONS(600),
    [anon_sym_module] = ACTIONS(600),
    [anon_sym_static] = ACTIONS(600),
    [anon_sym_package] = ACTIONS(600),
    [anon_sym_import] = ACTIONS(600),
    [anon_sym_enum] = ACTIONS(600),
    [anon_sym_public] = ACTIONS(600),
    [anon_sym_protected] = ACTIONS(600),
    [anon_sym_private] = ACTIONS(600),
    [anon_sym_abstract] = ACTIONS(600),
    [anon_sym_strictfp] = ACTIONS(600),
    [anon_sym_native] = ACTIONS(600),
    [anon_sym_transient] = ACTIONS(600),
    [anon_sym_volatile] = ACTIONS(600),
    [anon_sym_sealed] = ACTIONS(600),
    [anon_sym_non_DASHsealed] = ACTIONS(598),
    [anon_sym_record] = ACTIONS(600),
    [anon_sym_ATinterface] = ACTIONS(598),
    [anon_sym_interface] = ACTIONS(600),
    [anon_sym_byte] = ACTIONS(600),
    [anon_sym_short] = ACTIONS(600),
    [anon_sym_int] = ACTIONS(600),
    [anon_sym_long] = ACTIONS(600),
    [anon_sym_char] = ACTIONS(600),
    [anon_sym_float] = ACTIONS(600),
    [anon_sym_double] = ACTIONS(600),
    [sym_boolean_type] = ACTIONS(600),
    [sym_void_type] = ACTIONS(600),
    [sym_this] = ACTIONS(600),
    [sym_super] = ACTIONS(600),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [163] = {
    [ts_builtin_sym_end] = ACTIONS(602),
    [sym_identifier] = ACTIONS(604),
    [sym_decimal_integer_literal] = ACTIONS(604),
    [sym_hex_integer_literal] = ACTIONS(604),
    [sym_octal_integer_literal] = ACTIONS(602),
    [sym_binary_integer_literal] = ACTIONS(602),
    [sym_decimal_floating_point_literal] = ACTIONS(602),
    [sym_hex_floating_point_literal] = ACTIONS(604),
    [sym_true] = ACTIONS(604),
    [sym_false] = ACTIONS(604),
    [sym_character_literal] = ACTIONS(602),
    [sym_string_literal] = ACTIONS(604),
    [sym_text_block] = ACTIONS(602),
    [sym_null_literal] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(602),
    [anon_sym_LT] = ACTIONS(602),
    [anon_sym_PLUS] = ACTIONS(604),
    [anon_sym_DASH] = ACTIONS(604),
    [anon_sym_final] = ACTIONS(604),
    [anon_sym_BANG] = ACTIONS(602),
    [anon_sym_TILDE] = ACTIONS(602),
    [anon_sym_PLUS_PLUS] = ACTIONS(602),
    [anon_sym_DASH_DASH] = ACTIONS(602),
    [anon_sym_new] = ACTIONS(604),
    [anon_sym_class] = ACTIONS(604),
    [anon_sym_switch] = ACTIONS(604),
    [anon_sym_LBRACE] = ACTIONS(602),
    [anon_sym_RBRACE] = ACTIONS(602),
    [anon_sym_case] = ACTIONS(604),
    [anon_sym_default] = ACTIONS(604),
    [anon_sym_SEMI] = ACTIONS(602),
    [anon_sym_assert] = ACTIONS(604),
    [anon_sym_do] = ACTIONS(604),
    [anon_sym_while] = ACTIONS(604),
    [anon_sym_break] = ACTIONS(604),
    [anon_sym_continue] = ACTIONS(604),
    [anon_sym_return] = ACTIONS(604),
    [anon_sym_yield] = ACTIONS(604),
    [anon_sym_synchronized] = ACTIONS(604),
    [anon_sym_throw] = ACTIONS(604),
    [anon_sym_try] = ACTIONS(604),
    [anon_sym_if] = ACTIONS(604),
    [anon_sym_else] = ACTIONS(604),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_AT] = ACTIONS(604),
    [anon_sym_open] = ACTIONS(604),
    [anon_sym_module] = ACTIONS(604),
    [anon_sym_static] = ACTIONS(604),
    [anon_sym_package] = ACTIONS(604),
    [anon_sym_import] = ACTIONS(604),
    [anon_sym_enum] = ACTIONS(604),
    [anon_sym_public] = ACTIONS(604),
    [anon_sym_protected] = ACTIONS(604),
    [anon_sym_private] = ACTIONS(604),
    [anon_sym_abstract] = ACTIONS(604),
    [anon_sym_strictfp] = ACTIONS(604),
    [anon_sym_native] = ACTIONS(604),
    [anon_sym_transient] = ACTIONS(604),
    [anon_sym_volatile] = ACTIONS(604),
    [anon_sym_sealed] = ACTIONS(604),
    [anon_sym_non_DASHsealed] = ACTIONS(602),
    [anon_sym_record] = ACTIONS(604),
    [anon_sym_ATinterface] = ACTIONS(602),
    [anon_sym_interface] = ACTIONS(604),
    [anon_sym_byte] = ACTIONS(604),
    [anon_sym_short] = ACTIONS(604),
    [anon_sym_int] = ACTIONS(604),
    [anon_sym_long] = ACTIONS(604),
    [anon_sym_char] = ACTIONS(604),
    [anon_sym_float] = ACTIONS(604),
    [anon_sym_double] = ACTIONS(604),
    [sym_boolean_type] = ACTIONS(604),
    [sym_void_type] = ACTIONS(604),
    [sym_this] = ACTIONS(604),
    [sym_super] = ACTIONS(604),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [164] = {
    [ts_builtin_sym_end] = ACTIONS(606),
    [sym_identifier] = ACTIONS(608),
    [sym_decimal_integer_literal] = ACTIONS(608),
    [sym_hex_integer_literal] = ACTIONS(608),
    [sym_octal_integer_literal] = ACTIONS(606),
    [sym_binary_integer_literal] = ACTIONS(606),
    [sym_decimal_floating_point_literal] = ACTIONS(606),
    [sym_hex_floating_point_literal] = ACTIONS(608),
    [sym_true] = ACTIONS(608),
    [sym_false] = ACTIONS(608),
    [sym_character_literal] = ACTIONS(606),
    [sym_string_literal] = ACTIONS(608),
    [sym_text_block] = ACTIONS(606),
    [sym_null_literal] = ACTIONS(608),
    [anon_sym_LPAREN] = ACTIONS(606),
    [anon_sym_LT] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_final] = ACTIONS(608),
    [anon_sym_BANG] = ACTIONS(606),
    [anon_sym_TILDE] = ACTIONS(606),
    [anon_sym_PLUS_PLUS] = ACTIONS(606),
    [anon_sym_DASH_DASH] = ACTIONS(606),
    [anon_sym_new] = ACTIONS(608),
    [anon_sym_class] = ACTIONS(608),
    [anon_sym_switch] = ACTIONS(608),
    [anon_sym_LBRACE] = ACTIONS(606),
    [anon_sym_RBRACE] = ACTIONS(606),
    [anon_sym_case] = ACTIONS(608),
    [anon_sym_default] = ACTIONS(608),
    [anon_sym_SEMI] = ACTIONS(606),
    [anon_sym_assert] = ACTIONS(608),
    [anon_sym_do] = ACTIONS(608),
    [anon_sym_while] = ACTIONS(608),
    [anon_sym_break] = ACTIONS(608),
    [anon_sym_continue] = ACTIONS(608),
    [anon_sym_return] = ACTIONS(608),
    [anon_sym_yield] = ACTIONS(608),
    [anon_sym_synchronized] = ACTIONS(608),
    [anon_sym_throw] = ACTIONS(608),
    [anon_sym_try] = ACTIONS(608),
    [anon_sym_if] = ACTIONS(608),
    [anon_sym_else] = ACTIONS(608),
    [anon_sym_for] = ACTIONS(608),
    [anon_sym_AT] = ACTIONS(608),
    [anon_sym_open] = ACTIONS(608),
    [anon_sym_module] = ACTIONS(608),
    [anon_sym_static] = ACTIONS(608),
    [anon_sym_package] = ACTIONS(608),
    [anon_sym_import] = ACTIONS(608),
    [anon_sym_enum] = ACTIONS(608),
    [anon_sym_public] = ACTIONS(608),
    [anon_sym_protected] = ACTIONS(608),
    [anon_sym_private] = ACTIONS(608),
    [anon_sym_abstract] = ACTIONS(608),
    [anon_sym_strictfp] = ACTIONS(608),
    [anon_sym_native] = ACTIONS(608),
    [anon_sym_transient] = ACTIONS(608),
    [anon_sym_volatile] = ACTIONS(608),
    [anon_sym_sealed] = ACTIONS(608),
    [anon_sym_non_DASHsealed] = ACTIONS(606),
    [anon_sym_record] = ACTIONS(608),
    [anon_sym_ATinterface] = ACTIONS(606),
    [anon_sym_interface] = ACTIONS(608),
    [anon_sym_byte] = ACTIONS(608),
    [anon_sym_short] = ACTIONS(608),
    [anon_sym_int] = ACTIONS(608),
    [anon_sym_long] = ACTIONS(608),
    [anon_sym_char] = ACTIONS(608),
    [anon_sym_float] = ACTIONS(608),
    [anon_sym_double] = ACTIONS(608),
    [sym_boolean_type] = ACTIONS(608),
    [sym_void_type] = ACTIONS(608),
    [sym_this] = ACTIONS(608),
    [sym_super] = ACTIONS(608),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [165] = {
    [ts_builtin_sym_end] = ACTIONS(610),
    [sym_identifier] = ACTIONS(612),
    [sym_decimal_integer_literal] = ACTIONS(612),
    [sym_hex_integer_literal] = ACTIONS(612),
    [sym_octal_integer_literal] = ACTIONS(610),
    [sym_binary_integer_literal] = ACTIONS(610),
    [sym_decimal_floating_point_literal] = ACTIONS(610),
    [sym_hex_floating_point_literal] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_character_literal] = ACTIONS(610),
    [sym_string_literal] = ACTIONS(612),
    [sym_text_block] = ACTIONS(610),
    [sym_null_literal] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(610),
    [anon_sym_LT] = ACTIONS(610),
    [anon_sym_PLUS] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_final] = ACTIONS(612),
    [anon_sym_BANG] = ACTIONS(610),
    [anon_sym_TILDE] = ACTIONS(610),
    [anon_sym_PLUS_PLUS] = ACTIONS(610),
    [anon_sym_DASH_DASH] = ACTIONS(610),
    [anon_sym_new] = ACTIONS(612),
    [anon_sym_class] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(610),
    [anon_sym_RBRACE] = ACTIONS(610),
    [anon_sym_case] = ACTIONS(612),
    [anon_sym_default] = ACTIONS(612),
    [anon_sym_SEMI] = ACTIONS(610),
    [anon_sym_assert] = ACTIONS(612),
    [anon_sym_do] = ACTIONS(612),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_break] = ACTIONS(612),
    [anon_sym_continue] = ACTIONS(612),
    [anon_sym_return] = ACTIONS(612),
    [anon_sym_yield] = ACTIONS(612),
    [anon_sym_synchronized] = ACTIONS(612),
    [anon_sym_throw] = ACTIONS(612),
    [anon_sym_try] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_else] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(612),
    [anon_sym_open] = ACTIONS(612),
    [anon_sym_module] = ACTIONS(612),
    [anon_sym_static] = ACTIONS(612),
    [anon_sym_package] = ACTIONS(612),
    [anon_sym_import] = ACTIONS(612),
    [anon_sym_enum] = ACTIONS(612),
    [anon_sym_public] = ACTIONS(612),
    [anon_sym_protected] = ACTIONS(612),
    [anon_sym_private] = ACTIONS(612),
    [anon_sym_abstract] = ACTIONS(612),
    [anon_sym_strictfp] = ACTIONS(612),
    [anon_sym_native] = ACTIONS(612),
    [anon_sym_transient] = ACTIONS(612),
    [anon_sym_volatile] = ACTIONS(612),
    [anon_sym_sealed] = ACTIONS(612),
    [anon_sym_non_DASHsealed] = ACTIONS(610),
    [anon_sym_record] = ACTIONS(612),
    [anon_sym_ATinterface] = ACTIONS(610),
    [anon_sym_interface] = ACTIONS(612),
    [anon_sym_byte] = ACTIONS(612),
    [anon_sym_short] = ACTIONS(612),
    [anon_sym_int] = ACTIONS(612),
    [anon_sym_long] = ACTIONS(612),
    [anon_sym_char] = ACTIONS(612),
    [anon_sym_float] = ACTIONS(612),
    [anon_sym_double] = ACTIONS(612),
    [sym_boolean_type] = ACTIONS(612),
    [sym_void_type] = ACTIONS(612),
    [sym_this] = ACTIONS(612),
    [sym_super] = ACTIONS(612),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [166] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(605),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(661),
    [sym_marker_annotation] = STATE(661),
    [sym_annotation] = STATE(661),
    [sym_array_initializer] = STATE(1110),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(307),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_RBRACE] = ACTIONS(614),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [167] = {
    [ts_builtin_sym_end] = ACTIONS(616),
    [sym_identifier] = ACTIONS(618),
    [sym_decimal_integer_literal] = ACTIONS(618),
    [sym_hex_integer_literal] = ACTIONS(618),
    [sym_octal_integer_literal] = ACTIONS(616),
    [sym_binary_integer_literal] = ACTIONS(616),
    [sym_decimal_floating_point_literal] = ACTIONS(616),
    [sym_hex_floating_point_literal] = ACTIONS(618),
    [sym_true] = ACTIONS(618),
    [sym_false] = ACTIONS(618),
    [sym_character_literal] = ACTIONS(616),
    [sym_string_literal] = ACTIONS(618),
    [sym_text_block] = ACTIONS(616),
    [sym_null_literal] = ACTIONS(618),
    [anon_sym_LPAREN] = ACTIONS(616),
    [anon_sym_LT] = ACTIONS(616),
    [anon_sym_PLUS] = ACTIONS(618),
    [anon_sym_DASH] = ACTIONS(618),
    [anon_sym_final] = ACTIONS(618),
    [anon_sym_BANG] = ACTIONS(616),
    [anon_sym_TILDE] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(616),
    [anon_sym_DASH_DASH] = ACTIONS(616),
    [anon_sym_new] = ACTIONS(618),
    [anon_sym_class] = ACTIONS(618),
    [anon_sym_switch] = ACTIONS(618),
    [anon_sym_LBRACE] = ACTIONS(616),
    [anon_sym_RBRACE] = ACTIONS(616),
    [anon_sym_case] = ACTIONS(618),
    [anon_sym_default] = ACTIONS(618),
    [anon_sym_SEMI] = ACTIONS(616),
    [anon_sym_assert] = ACTIONS(618),
    [anon_sym_do] = ACTIONS(618),
    [anon_sym_while] = ACTIONS(618),
    [anon_sym_break] = ACTIONS(618),
    [anon_sym_continue] = ACTIONS(618),
    [anon_sym_return] = ACTIONS(618),
    [anon_sym_yield] = ACTIONS(618),
    [anon_sym_synchronized] = ACTIONS(618),
    [anon_sym_throw] = ACTIONS(618),
    [anon_sym_try] = ACTIONS(618),
    [anon_sym_if] = ACTIONS(618),
    [anon_sym_else] = ACTIONS(618),
    [anon_sym_for] = ACTIONS(618),
    [anon_sym_AT] = ACTIONS(618),
    [anon_sym_open] = ACTIONS(618),
    [anon_sym_module] = ACTIONS(618),
    [anon_sym_static] = ACTIONS(618),
    [anon_sym_package] = ACTIONS(618),
    [anon_sym_import] = ACTIONS(618),
    [anon_sym_enum] = ACTIONS(618),
    [anon_sym_public] = ACTIONS(618),
    [anon_sym_protected] = ACTIONS(618),
    [anon_sym_private] = ACTIONS(618),
    [anon_sym_abstract] = ACTIONS(618),
    [anon_sym_strictfp] = ACTIONS(618),
    [anon_sym_native] = ACTIONS(618),
    [anon_sym_transient] = ACTIONS(618),
    [anon_sym_volatile] = ACTIONS(618),
    [anon_sym_sealed] = ACTIONS(618),
    [anon_sym_non_DASHsealed] = ACTIONS(616),
    [anon_sym_record] = ACTIONS(618),
    [anon_sym_ATinterface] = ACTIONS(616),
    [anon_sym_interface] = ACTIONS(618),
    [anon_sym_byte] = ACTIONS(618),
    [anon_sym_short] = ACTIONS(618),
    [anon_sym_int] = ACTIONS(618),
    [anon_sym_long] = ACTIONS(618),
    [anon_sym_char] = ACTIONS(618),
    [anon_sym_float] = ACTIONS(618),
    [anon_sym_double] = ACTIONS(618),
    [sym_boolean_type] = ACTIONS(618),
    [sym_void_type] = ACTIONS(618),
    [sym_this] = ACTIONS(618),
    [sym_super] = ACTIONS(618),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [168] = {
    [ts_builtin_sym_end] = ACTIONS(620),
    [sym_identifier] = ACTIONS(622),
    [sym_decimal_integer_literal] = ACTIONS(622),
    [sym_hex_integer_literal] = ACTIONS(622),
    [sym_octal_integer_literal] = ACTIONS(620),
    [sym_binary_integer_literal] = ACTIONS(620),
    [sym_decimal_floating_point_literal] = ACTIONS(620),
    [sym_hex_floating_point_literal] = ACTIONS(622),
    [sym_true] = ACTIONS(622),
    [sym_false] = ACTIONS(622),
    [sym_character_literal] = ACTIONS(620),
    [sym_string_literal] = ACTIONS(622),
    [sym_text_block] = ACTIONS(620),
    [sym_null_literal] = ACTIONS(622),
    [anon_sym_LPAREN] = ACTIONS(620),
    [anon_sym_LT] = ACTIONS(620),
    [anon_sym_PLUS] = ACTIONS(622),
    [anon_sym_DASH] = ACTIONS(622),
    [anon_sym_final] = ACTIONS(622),
    [anon_sym_BANG] = ACTIONS(620),
    [anon_sym_TILDE] = ACTIONS(620),
    [anon_sym_PLUS_PLUS] = ACTIONS(620),
    [anon_sym_DASH_DASH] = ACTIONS(620),
    [anon_sym_new] = ACTIONS(622),
    [anon_sym_class] = ACTIONS(622),
    [anon_sym_switch] = ACTIONS(622),
    [anon_sym_LBRACE] = ACTIONS(620),
    [anon_sym_RBRACE] = ACTIONS(620),
    [anon_sym_case] = ACTIONS(622),
    [anon_sym_default] = ACTIONS(622),
    [anon_sym_SEMI] = ACTIONS(620),
    [anon_sym_assert] = ACTIONS(622),
    [anon_sym_do] = ACTIONS(622),
    [anon_sym_while] = ACTIONS(622),
    [anon_sym_break] = ACTIONS(622),
    [anon_sym_continue] = ACTIONS(622),
    [anon_sym_return] = ACTIONS(622),
    [anon_sym_yield] = ACTIONS(622),
    [anon_sym_synchronized] = ACTIONS(622),
    [anon_sym_throw] = ACTIONS(622),
    [anon_sym_try] = ACTIONS(622),
    [anon_sym_if] = ACTIONS(622),
    [anon_sym_else] = ACTIONS(622),
    [anon_sym_for] = ACTIONS(622),
    [anon_sym_AT] = ACTIONS(622),
    [anon_sym_open] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(622),
    [anon_sym_static] = ACTIONS(622),
    [anon_sym_package] = ACTIONS(622),
    [anon_sym_import] = ACTIONS(622),
    [anon_sym_enum] = ACTIONS(622),
    [anon_sym_public] = ACTIONS(622),
    [anon_sym_protected] = ACTIONS(622),
    [anon_sym_private] = ACTIONS(622),
    [anon_sym_abstract] = ACTIONS(622),
    [anon_sym_strictfp] = ACTIONS(622),
    [anon_sym_native] = ACTIONS(622),
    [anon_sym_transient] = ACTIONS(622),
    [anon_sym_volatile] = ACTIONS(622),
    [anon_sym_sealed] = ACTIONS(622),
    [anon_sym_non_DASHsealed] = ACTIONS(620),
    [anon_sym_record] = ACTIONS(622),
    [anon_sym_ATinterface] = ACTIONS(620),
    [anon_sym_interface] = ACTIONS(622),
    [anon_sym_byte] = ACTIONS(622),
    [anon_sym_short] = ACTIONS(622),
    [anon_sym_int] = ACTIONS(622),
    [anon_sym_long] = ACTIONS(622),
    [anon_sym_char] = ACTIONS(622),
    [anon_sym_float] = ACTIONS(622),
    [anon_sym_double] = ACTIONS(622),
    [sym_boolean_type] = ACTIONS(622),
    [sym_void_type] = ACTIONS(622),
    [sym_this] = ACTIONS(622),
    [sym_super] = ACTIONS(622),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [169] = {
    [ts_builtin_sym_end] = ACTIONS(624),
    [sym_identifier] = ACTIONS(626),
    [sym_decimal_integer_literal] = ACTIONS(626),
    [sym_hex_integer_literal] = ACTIONS(626),
    [sym_octal_integer_literal] = ACTIONS(624),
    [sym_binary_integer_literal] = ACTIONS(624),
    [sym_decimal_floating_point_literal] = ACTIONS(624),
    [sym_hex_floating_point_literal] = ACTIONS(626),
    [sym_true] = ACTIONS(626),
    [sym_false] = ACTIONS(626),
    [sym_character_literal] = ACTIONS(624),
    [sym_string_literal] = ACTIONS(626),
    [sym_text_block] = ACTIONS(624),
    [sym_null_literal] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(624),
    [anon_sym_LT] = ACTIONS(624),
    [anon_sym_PLUS] = ACTIONS(626),
    [anon_sym_DASH] = ACTIONS(626),
    [anon_sym_final] = ACTIONS(626),
    [anon_sym_BANG] = ACTIONS(624),
    [anon_sym_TILDE] = ACTIONS(624),
    [anon_sym_PLUS_PLUS] = ACTIONS(624),
    [anon_sym_DASH_DASH] = ACTIONS(624),
    [anon_sym_new] = ACTIONS(626),
    [anon_sym_class] = ACTIONS(626),
    [anon_sym_switch] = ACTIONS(626),
    [anon_sym_LBRACE] = ACTIONS(624),
    [anon_sym_RBRACE] = ACTIONS(624),
    [anon_sym_case] = ACTIONS(626),
    [anon_sym_default] = ACTIONS(626),
    [anon_sym_SEMI] = ACTIONS(624),
    [anon_sym_assert] = ACTIONS(626),
    [anon_sym_do] = ACTIONS(626),
    [anon_sym_while] = ACTIONS(626),
    [anon_sym_break] = ACTIONS(626),
    [anon_sym_continue] = ACTIONS(626),
    [anon_sym_return] = ACTIONS(626),
    [anon_sym_yield] = ACTIONS(626),
    [anon_sym_synchronized] = ACTIONS(626),
    [anon_sym_throw] = ACTIONS(626),
    [anon_sym_try] = ACTIONS(626),
    [anon_sym_if] = ACTIONS(626),
    [anon_sym_else] = ACTIONS(626),
    [anon_sym_for] = ACTIONS(626),
    [anon_sym_AT] = ACTIONS(626),
    [anon_sym_open] = ACTIONS(626),
    [anon_sym_module] = ACTIONS(626),
    [anon_sym_static] = ACTIONS(626),
    [anon_sym_package] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(626),
    [anon_sym_enum] = ACTIONS(626),
    [anon_sym_public] = ACTIONS(626),
    [anon_sym_protected] = ACTIONS(626),
    [anon_sym_private] = ACTIONS(626),
    [anon_sym_abstract] = ACTIONS(626),
    [anon_sym_strictfp] = ACTIONS(626),
    [anon_sym_native] = ACTIONS(626),
    [anon_sym_transient] = ACTIONS(626),
    [anon_sym_volatile] = ACTIONS(626),
    [anon_sym_sealed] = ACTIONS(626),
    [anon_sym_non_DASHsealed] = ACTIONS(624),
    [anon_sym_record] = ACTIONS(626),
    [anon_sym_ATinterface] = ACTIONS(624),
    [anon_sym_interface] = ACTIONS(626),
    [anon_sym_byte] = ACTIONS(626),
    [anon_sym_short] = ACTIONS(626),
    [anon_sym_int] = ACTIONS(626),
    [anon_sym_long] = ACTIONS(626),
    [anon_sym_char] = ACTIONS(626),
    [anon_sym_float] = ACTIONS(626),
    [anon_sym_double] = ACTIONS(626),
    [sym_boolean_type] = ACTIONS(626),
    [sym_void_type] = ACTIONS(626),
    [sym_this] = ACTIONS(626),
    [sym_super] = ACTIONS(626),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [170] = {
    [ts_builtin_sym_end] = ACTIONS(628),
    [sym_identifier] = ACTIONS(630),
    [sym_decimal_integer_literal] = ACTIONS(630),
    [sym_hex_integer_literal] = ACTIONS(630),
    [sym_octal_integer_literal] = ACTIONS(628),
    [sym_binary_integer_literal] = ACTIONS(628),
    [sym_decimal_floating_point_literal] = ACTIONS(628),
    [sym_hex_floating_point_literal] = ACTIONS(630),
    [sym_true] = ACTIONS(630),
    [sym_false] = ACTIONS(630),
    [sym_character_literal] = ACTIONS(628),
    [sym_string_literal] = ACTIONS(630),
    [sym_text_block] = ACTIONS(628),
    [sym_null_literal] = ACTIONS(630),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_LT] = ACTIONS(628),
    [anon_sym_PLUS] = ACTIONS(630),
    [anon_sym_DASH] = ACTIONS(630),
    [anon_sym_final] = ACTIONS(630),
    [anon_sym_BANG] = ACTIONS(628),
    [anon_sym_TILDE] = ACTIONS(628),
    [anon_sym_PLUS_PLUS] = ACTIONS(628),
    [anon_sym_DASH_DASH] = ACTIONS(628),
    [anon_sym_new] = ACTIONS(630),
    [anon_sym_class] = ACTIONS(630),
    [anon_sym_switch] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_RBRACE] = ACTIONS(628),
    [anon_sym_case] = ACTIONS(630),
    [anon_sym_default] = ACTIONS(630),
    [anon_sym_SEMI] = ACTIONS(628),
    [anon_sym_assert] = ACTIONS(630),
    [anon_sym_do] = ACTIONS(630),
    [anon_sym_while] = ACTIONS(630),
    [anon_sym_break] = ACTIONS(630),
    [anon_sym_continue] = ACTIONS(630),
    [anon_sym_return] = ACTIONS(630),
    [anon_sym_yield] = ACTIONS(630),
    [anon_sym_synchronized] = ACTIONS(630),
    [anon_sym_throw] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(630),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_else] = ACTIONS(630),
    [anon_sym_for] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(630),
    [anon_sym_open] = ACTIONS(630),
    [anon_sym_module] = ACTIONS(630),
    [anon_sym_static] = ACTIONS(630),
    [anon_sym_package] = ACTIONS(630),
    [anon_sym_import] = ACTIONS(630),
    [anon_sym_enum] = ACTIONS(630),
    [anon_sym_public] = ACTIONS(630),
    [anon_sym_protected] = ACTIONS(630),
    [anon_sym_private] = ACTIONS(630),
    [anon_sym_abstract] = ACTIONS(630),
    [anon_sym_strictfp] = ACTIONS(630),
    [anon_sym_native] = ACTIONS(630),
    [anon_sym_transient] = ACTIONS(630),
    [anon_sym_volatile] = ACTIONS(630),
    [anon_sym_sealed] = ACTIONS(630),
    [anon_sym_non_DASHsealed] = ACTIONS(628),
    [anon_sym_record] = ACTIONS(630),
    [anon_sym_ATinterface] = ACTIONS(628),
    [anon_sym_interface] = ACTIONS(630),
    [anon_sym_byte] = ACTIONS(630),
    [anon_sym_short] = ACTIONS(630),
    [anon_sym_int] = ACTIONS(630),
    [anon_sym_long] = ACTIONS(630),
    [anon_sym_char] = ACTIONS(630),
    [anon_sym_float] = ACTIONS(630),
    [anon_sym_double] = ACTIONS(630),
    [sym_boolean_type] = ACTIONS(630),
    [sym_void_type] = ACTIONS(630),
    [sym_this] = ACTIONS(630),
    [sym_super] = ACTIONS(630),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [171] = {
    [ts_builtin_sym_end] = ACTIONS(632),
    [sym_identifier] = ACTIONS(634),
    [sym_decimal_integer_literal] = ACTIONS(634),
    [sym_hex_integer_literal] = ACTIONS(634),
    [sym_octal_integer_literal] = ACTIONS(632),
    [sym_binary_integer_literal] = ACTIONS(632),
    [sym_decimal_floating_point_literal] = ACTIONS(632),
    [sym_hex_floating_point_literal] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_character_literal] = ACTIONS(632),
    [sym_string_literal] = ACTIONS(634),
    [sym_text_block] = ACTIONS(632),
    [sym_null_literal] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(632),
    [anon_sym_LT] = ACTIONS(632),
    [anon_sym_PLUS] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_final] = ACTIONS(634),
    [anon_sym_BANG] = ACTIONS(632),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_PLUS_PLUS] = ACTIONS(632),
    [anon_sym_DASH_DASH] = ACTIONS(632),
    [anon_sym_new] = ACTIONS(634),
    [anon_sym_class] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_RBRACE] = ACTIONS(632),
    [anon_sym_case] = ACTIONS(634),
    [anon_sym_default] = ACTIONS(634),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_assert] = ACTIONS(634),
    [anon_sym_do] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_break] = ACTIONS(634),
    [anon_sym_continue] = ACTIONS(634),
    [anon_sym_return] = ACTIONS(634),
    [anon_sym_yield] = ACTIONS(634),
    [anon_sym_synchronized] = ACTIONS(634),
    [anon_sym_throw] = ACTIONS(634),
    [anon_sym_try] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_AT] = ACTIONS(634),
    [anon_sym_open] = ACTIONS(634),
    [anon_sym_module] = ACTIONS(634),
    [anon_sym_static] = ACTIONS(634),
    [anon_sym_package] = ACTIONS(634),
    [anon_sym_import] = ACTIONS(634),
    [anon_sym_enum] = ACTIONS(634),
    [anon_sym_public] = ACTIONS(634),
    [anon_sym_protected] = ACTIONS(634),
    [anon_sym_private] = ACTIONS(634),
    [anon_sym_abstract] = ACTIONS(634),
    [anon_sym_strictfp] = ACTIONS(634),
    [anon_sym_native] = ACTIONS(634),
    [anon_sym_transient] = ACTIONS(634),
    [anon_sym_volatile] = ACTIONS(634),
    [anon_sym_sealed] = ACTIONS(634),
    [anon_sym_non_DASHsealed] = ACTIONS(632),
    [anon_sym_record] = ACTIONS(634),
    [anon_sym_ATinterface] = ACTIONS(632),
    [anon_sym_interface] = ACTIONS(634),
    [anon_sym_byte] = ACTIONS(634),
    [anon_sym_short] = ACTIONS(634),
    [anon_sym_int] = ACTIONS(634),
    [anon_sym_long] = ACTIONS(634),
    [anon_sym_char] = ACTIONS(634),
    [anon_sym_float] = ACTIONS(634),
    [anon_sym_double] = ACTIONS(634),
    [sym_boolean_type] = ACTIONS(634),
    [sym_void_type] = ACTIONS(634),
    [sym_this] = ACTIONS(634),
    [sym_super] = ACTIONS(634),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [172] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(544),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(710),
    [sym_marker_annotation] = STATE(710),
    [sym_annotation] = STATE(710),
    [sym__element_value] = STATE(1211),
    [sym_element_value_array_initializer] = STATE(1211),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(307),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [173] = {
    [ts_builtin_sym_end] = ACTIONS(636),
    [sym_identifier] = ACTIONS(638),
    [sym_decimal_integer_literal] = ACTIONS(638),
    [sym_hex_integer_literal] = ACTIONS(638),
    [sym_octal_integer_literal] = ACTIONS(636),
    [sym_binary_integer_literal] = ACTIONS(636),
    [sym_decimal_floating_point_literal] = ACTIONS(636),
    [sym_hex_floating_point_literal] = ACTIONS(638),
    [sym_true] = ACTIONS(638),
    [sym_false] = ACTIONS(638),
    [sym_character_literal] = ACTIONS(636),
    [sym_string_literal] = ACTIONS(638),
    [sym_text_block] = ACTIONS(636),
    [sym_null_literal] = ACTIONS(638),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_PLUS] = ACTIONS(638),
    [anon_sym_DASH] = ACTIONS(638),
    [anon_sym_final] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_TILDE] = ACTIONS(636),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_new] = ACTIONS(638),
    [anon_sym_class] = ACTIONS(638),
    [anon_sym_switch] = ACTIONS(638),
    [anon_sym_LBRACE] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(636),
    [anon_sym_case] = ACTIONS(638),
    [anon_sym_default] = ACTIONS(638),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_assert] = ACTIONS(638),
    [anon_sym_do] = ACTIONS(638),
    [anon_sym_while] = ACTIONS(638),
    [anon_sym_break] = ACTIONS(638),
    [anon_sym_continue] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(638),
    [anon_sym_yield] = ACTIONS(638),
    [anon_sym_synchronized] = ACTIONS(638),
    [anon_sym_throw] = ACTIONS(638),
    [anon_sym_try] = ACTIONS(638),
    [anon_sym_if] = ACTIONS(638),
    [anon_sym_else] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(638),
    [anon_sym_AT] = ACTIONS(638),
    [anon_sym_open] = ACTIONS(638),
    [anon_sym_module] = ACTIONS(638),
    [anon_sym_static] = ACTIONS(638),
    [anon_sym_package] = ACTIONS(638),
    [anon_sym_import] = ACTIONS(638),
    [anon_sym_enum] = ACTIONS(638),
    [anon_sym_public] = ACTIONS(638),
    [anon_sym_protected] = ACTIONS(638),
    [anon_sym_private] = ACTIONS(638),
    [anon_sym_abstract] = ACTIONS(638),
    [anon_sym_strictfp] = ACTIONS(638),
    [anon_sym_native] = ACTIONS(638),
    [anon_sym_transient] = ACTIONS(638),
    [anon_sym_volatile] = ACTIONS(638),
    [anon_sym_sealed] = ACTIONS(638),
    [anon_sym_non_DASHsealed] = ACTIONS(636),
    [anon_sym_record] = ACTIONS(638),
    [anon_sym_ATinterface] = ACTIONS(636),
    [anon_sym_interface] = ACTIONS(638),
    [anon_sym_byte] = ACTIONS(638),
    [anon_sym_short] = ACTIONS(638),
    [anon_sym_int] = ACTIONS(638),
    [anon_sym_long] = ACTIONS(638),
    [anon_sym_char] = ACTIONS(638),
    [anon_sym_float] = ACTIONS(638),
    [anon_sym_double] = ACTIONS(638),
    [sym_boolean_type] = ACTIONS(638),
    [sym_void_type] = ACTIONS(638),
    [sym_this] = ACTIONS(638),
    [sym_super] = ACTIONS(638),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [174] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(544),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(710),
    [sym_marker_annotation] = STATE(710),
    [sym_annotation] = STATE(710),
    [sym__element_value] = STATE(1083),
    [sym_element_value_array_initializer] = STATE(1083),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(307),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [175] = {
    [ts_builtin_sym_end] = ACTIONS(640),
    [sym_identifier] = ACTIONS(642),
    [sym_decimal_integer_literal] = ACTIONS(642),
    [sym_hex_integer_literal] = ACTIONS(642),
    [sym_octal_integer_literal] = ACTIONS(640),
    [sym_binary_integer_literal] = ACTIONS(640),
    [sym_decimal_floating_point_literal] = ACTIONS(640),
    [sym_hex_floating_point_literal] = ACTIONS(642),
    [sym_true] = ACTIONS(642),
    [sym_false] = ACTIONS(642),
    [sym_character_literal] = ACTIONS(640),
    [sym_string_literal] = ACTIONS(642),
    [sym_text_block] = ACTIONS(640),
    [sym_null_literal] = ACTIONS(642),
    [anon_sym_LPAREN] = ACTIONS(640),
    [anon_sym_LT] = ACTIONS(640),
    [anon_sym_PLUS] = ACTIONS(642),
    [anon_sym_DASH] = ACTIONS(642),
    [anon_sym_final] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(640),
    [anon_sym_PLUS_PLUS] = ACTIONS(640),
    [anon_sym_DASH_DASH] = ACTIONS(640),
    [anon_sym_new] = ACTIONS(642),
    [anon_sym_class] = ACTIONS(642),
    [anon_sym_switch] = ACTIONS(642),
    [anon_sym_LBRACE] = ACTIONS(640),
    [anon_sym_RBRACE] = ACTIONS(640),
    [anon_sym_case] = ACTIONS(642),
    [anon_sym_default] = ACTIONS(642),
    [anon_sym_SEMI] = ACTIONS(640),
    [anon_sym_assert] = ACTIONS(642),
    [anon_sym_do] = ACTIONS(642),
    [anon_sym_while] = ACTIONS(642),
    [anon_sym_break] = ACTIONS(642),
    [anon_sym_continue] = ACTIONS(642),
    [anon_sym_return] = ACTIONS(642),
    [anon_sym_yield] = ACTIONS(642),
    [anon_sym_synchronized] = ACTIONS(642),
    [anon_sym_throw] = ACTIONS(642),
    [anon_sym_try] = ACTIONS(642),
    [anon_sym_if] = ACTIONS(642),
    [anon_sym_else] = ACTIONS(642),
    [anon_sym_for] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(642),
    [anon_sym_open] = ACTIONS(642),
    [anon_sym_module] = ACTIONS(642),
    [anon_sym_static] = ACTIONS(642),
    [anon_sym_package] = ACTIONS(642),
    [anon_sym_import] = ACTIONS(642),
    [anon_sym_enum] = ACTIONS(642),
    [anon_sym_public] = ACTIONS(642),
    [anon_sym_protected] = ACTIONS(642),
    [anon_sym_private] = ACTIONS(642),
    [anon_sym_abstract] = ACTIONS(642),
    [anon_sym_strictfp] = ACTIONS(642),
    [anon_sym_native] = ACTIONS(642),
    [anon_sym_transient] = ACTIONS(642),
    [anon_sym_volatile] = ACTIONS(642),
    [anon_sym_sealed] = ACTIONS(642),
    [anon_sym_non_DASHsealed] = ACTIONS(640),
    [anon_sym_record] = ACTIONS(642),
    [anon_sym_ATinterface] = ACTIONS(640),
    [anon_sym_interface] = ACTIONS(642),
    [anon_sym_byte] = ACTIONS(642),
    [anon_sym_short] = ACTIONS(642),
    [anon_sym_int] = ACTIONS(642),
    [anon_sym_long] = ACTIONS(642),
    [anon_sym_char] = ACTIONS(642),
    [anon_sym_float] = ACTIONS(642),
    [anon_sym_double] = ACTIONS(642),
    [sym_boolean_type] = ACTIONS(642),
    [sym_void_type] = ACTIONS(642),
    [sym_this] = ACTIONS(642),
    [sym_super] = ACTIONS(642),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [176] = {
    [ts_builtin_sym_end] = ACTIONS(644),
    [sym_identifier] = ACTIONS(646),
    [sym_decimal_integer_literal] = ACTIONS(646),
    [sym_hex_integer_literal] = ACTIONS(646),
    [sym_octal_integer_literal] = ACTIONS(644),
    [sym_binary_integer_literal] = ACTIONS(644),
    [sym_decimal_floating_point_literal] = ACTIONS(644),
    [sym_hex_floating_point_literal] = ACTIONS(646),
    [sym_true] = ACTIONS(646),
    [sym_false] = ACTIONS(646),
    [sym_character_literal] = ACTIONS(644),
    [sym_string_literal] = ACTIONS(646),
    [sym_text_block] = ACTIONS(644),
    [sym_null_literal] = ACTIONS(646),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_LT] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(646),
    [anon_sym_final] = ACTIONS(646),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_TILDE] = ACTIONS(644),
    [anon_sym_PLUS_PLUS] = ACTIONS(644),
    [anon_sym_DASH_DASH] = ACTIONS(644),
    [anon_sym_new] = ACTIONS(646),
    [anon_sym_class] = ACTIONS(646),
    [anon_sym_switch] = ACTIONS(646),
    [anon_sym_LBRACE] = ACTIONS(644),
    [anon_sym_RBRACE] = ACTIONS(644),
    [anon_sym_case] = ACTIONS(646),
    [anon_sym_default] = ACTIONS(646),
    [anon_sym_SEMI] = ACTIONS(644),
    [anon_sym_assert] = ACTIONS(646),
    [anon_sym_do] = ACTIONS(646),
    [anon_sym_while] = ACTIONS(646),
    [anon_sym_break] = ACTIONS(646),
    [anon_sym_continue] = ACTIONS(646),
    [anon_sym_return] = ACTIONS(646),
    [anon_sym_yield] = ACTIONS(646),
    [anon_sym_synchronized] = ACTIONS(646),
    [anon_sym_throw] = ACTIONS(646),
    [anon_sym_try] = ACTIONS(646),
    [anon_sym_if] = ACTIONS(646),
    [anon_sym_else] = ACTIONS(646),
    [anon_sym_for] = ACTIONS(646),
    [anon_sym_AT] = ACTIONS(646),
    [anon_sym_open] = ACTIONS(646),
    [anon_sym_module] = ACTIONS(646),
    [anon_sym_static] = ACTIONS(646),
    [anon_sym_package] = ACTIONS(646),
    [anon_sym_import] = ACTIONS(646),
    [anon_sym_enum] = ACTIONS(646),
    [anon_sym_public] = ACTIONS(646),
    [anon_sym_protected] = ACTIONS(646),
    [anon_sym_private] = ACTIONS(646),
    [anon_sym_abstract] = ACTIONS(646),
    [anon_sym_strictfp] = ACTIONS(646),
    [anon_sym_native] = ACTIONS(646),
    [anon_sym_transient] = ACTIONS(646),
    [anon_sym_volatile] = ACTIONS(646),
    [anon_sym_sealed] = ACTIONS(646),
    [anon_sym_non_DASHsealed] = ACTIONS(644),
    [anon_sym_record] = ACTIONS(646),
    [anon_sym_ATinterface] = ACTIONS(644),
    [anon_sym_interface] = ACTIONS(646),
    [anon_sym_byte] = ACTIONS(646),
    [anon_sym_short] = ACTIONS(646),
    [anon_sym_int] = ACTIONS(646),
    [anon_sym_long] = ACTIONS(646),
    [anon_sym_char] = ACTIONS(646),
    [anon_sym_float] = ACTIONS(646),
    [anon_sym_double] = ACTIONS(646),
    [sym_boolean_type] = ACTIONS(646),
    [sym_void_type] = ACTIONS(646),
    [sym_this] = ACTIONS(646),
    [sym_super] = ACTIONS(646),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [177] = {
    [ts_builtin_sym_end] = ACTIONS(648),
    [sym_identifier] = ACTIONS(650),
    [sym_decimal_integer_literal] = ACTIONS(650),
    [sym_hex_integer_literal] = ACTIONS(650),
    [sym_octal_integer_literal] = ACTIONS(648),
    [sym_binary_integer_literal] = ACTIONS(648),
    [sym_decimal_floating_point_literal] = ACTIONS(648),
    [sym_hex_floating_point_literal] = ACTIONS(650),
    [sym_true] = ACTIONS(650),
    [sym_false] = ACTIONS(650),
    [sym_character_literal] = ACTIONS(648),
    [sym_string_literal] = ACTIONS(650),
    [sym_text_block] = ACTIONS(648),
    [sym_null_literal] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_final] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(648),
    [anon_sym_TILDE] = ACTIONS(648),
    [anon_sym_PLUS_PLUS] = ACTIONS(648),
    [anon_sym_DASH_DASH] = ACTIONS(648),
    [anon_sym_new] = ACTIONS(650),
    [anon_sym_class] = ACTIONS(650),
    [anon_sym_switch] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(648),
    [anon_sym_RBRACE] = ACTIONS(648),
    [anon_sym_case] = ACTIONS(650),
    [anon_sym_default] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(648),
    [anon_sym_assert] = ACTIONS(650),
    [anon_sym_do] = ACTIONS(650),
    [anon_sym_while] = ACTIONS(650),
    [anon_sym_break] = ACTIONS(650),
    [anon_sym_continue] = ACTIONS(650),
    [anon_sym_return] = ACTIONS(650),
    [anon_sym_yield] = ACTIONS(650),
    [anon_sym_synchronized] = ACTIONS(650),
    [anon_sym_throw] = ACTIONS(650),
    [anon_sym_try] = ACTIONS(650),
    [anon_sym_if] = ACTIONS(650),
    [anon_sym_else] = ACTIONS(650),
    [anon_sym_for] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_open] = ACTIONS(650),
    [anon_sym_module] = ACTIONS(650),
    [anon_sym_static] = ACTIONS(650),
    [anon_sym_package] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(650),
    [anon_sym_enum] = ACTIONS(650),
    [anon_sym_public] = ACTIONS(650),
    [anon_sym_protected] = ACTIONS(650),
    [anon_sym_private] = ACTIONS(650),
    [anon_sym_abstract] = ACTIONS(650),
    [anon_sym_strictfp] = ACTIONS(650),
    [anon_sym_native] = ACTIONS(650),
    [anon_sym_transient] = ACTIONS(650),
    [anon_sym_volatile] = ACTIONS(650),
    [anon_sym_sealed] = ACTIONS(650),
    [anon_sym_non_DASHsealed] = ACTIONS(648),
    [anon_sym_record] = ACTIONS(650),
    [anon_sym_ATinterface] = ACTIONS(648),
    [anon_sym_interface] = ACTIONS(650),
    [anon_sym_byte] = ACTIONS(650),
    [anon_sym_short] = ACTIONS(650),
    [anon_sym_int] = ACTIONS(650),
    [anon_sym_long] = ACTIONS(650),
    [anon_sym_char] = ACTIONS(650),
    [anon_sym_float] = ACTIONS(650),
    [anon_sym_double] = ACTIONS(650),
    [sym_boolean_type] = ACTIONS(650),
    [sym_void_type] = ACTIONS(650),
    [sym_this] = ACTIONS(650),
    [sym_super] = ACTIONS(650),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [178] = {
    [sym__literal] = STATE(461),
    [sym_expression] = STATE(544),
    [sym_cast_expression] = STATE(510),
    [sym_assignment_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_instanceof_expression] = STATE(510),
    [sym_lambda_expression] = STATE(510),
    [sym_inferred_parameters] = STATE(1206),
    [sym_ternary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_primary_expression] = STATE(482),
    [sym_array_creation_expression] = STATE(461),
    [sym_parenthesized_expression] = STATE(461),
    [sym_class_literal] = STATE(461),
    [sym_object_creation_expression] = STATE(461),
    [sym__unqualified_object_creation_expression] = STATE(494),
    [sym_field_access] = STATE(381),
    [sym_array_access] = STATE(381),
    [sym_method_invocation] = STATE(461),
    [sym_method_reference] = STATE(461),
    [sym_switch_expression] = STATE(510),
    [sym__annotation] = STATE(710),
    [sym_marker_annotation] = STATE(710),
    [sym_annotation] = STATE(710),
    [sym__element_value] = STATE(1170),
    [sym_element_value_array_initializer] = STATE(1170),
    [sym__type] = STATE(1201),
    [sym__unannotated_type] = STATE(761),
    [sym_annotated_type] = STATE(770),
    [sym_scoped_type_identifier] = STATE(722),
    [sym_generic_type] = STATE(751),
    [sym_array_type] = STATE(685),
    [sym_integral_type] = STATE(685),
    [sym_floating_point_type] = STATE(685),
    [sym_formal_parameters] = STATE(1206),
    [aux_sym_array_creation_expression_repeat1] = STATE(661),
    [sym_identifier] = ACTIONS(307),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(9),
    [sym_text_block] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(21),
    [anon_sym_DASH_DASH] = ACTIONS(21),
    [anon_sym_new] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(27),
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_record] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(77),
    [anon_sym_short] = ACTIONS(77),
    [anon_sym_int] = ACTIONS(77),
    [anon_sym_long] = ACTIONS(77),
    [anon_sym_char] = ACTIONS(77),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_double] = ACTIONS(79),
    [sym_boolean_type] = ACTIONS(81),
    [sym_void_type] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [179] = {
    [ts_builtin_sym_end] = ACTIONS(652),
    [sym_identifier] = ACTIONS(654),
    [sym_decimal_integer_literal] = ACTIONS(654),
    [sym_hex_integer_literal] = ACTIONS(654),
    [sym_octal_integer_literal] = ACTIONS(652),
    [sym_binary_integer_literal] = ACTIONS(652),
    [sym_decimal_floating_point_literal] = ACTIONS(652),
    [sym_hex_floating_point_literal] = ACTIONS(654),
    [sym_true] = ACTIONS(654),
    [sym_false] = ACTIONS(654),
    [sym_character_literal] = ACTIONS(652),
    [sym_string_literal] = ACTIONS(654),
    [sym_text_block] = ACTIONS(652),
    [sym_null_literal] = ACTIONS(654),
    [anon_sym_LPAREN] = ACTIONS(652),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(654),
    [anon_sym_DASH] = ACTIONS(654),
    [anon_sym_final] = ACTIONS(654),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(652),
    [anon_sym_DASH_DASH] = ACTIONS(652),
    [anon_sym_new] = ACTIONS(654),
    [anon_sym_class] = ACTIONS(654),
    [anon_sym_switch] = ACTIONS(654),
    [anon_sym_LBRACE] = ACTIONS(652),
    [anon_sym_RBRACE] = ACTIONS(652),
    [anon_sym_case] = ACTIONS(654),
    [anon_sym_default] = ACTIONS(654),
    [anon_sym_SEMI] = ACTIONS(652),
    [anon_sym_assert] = ACTIONS(654),
    [anon_sym_do] = ACTIONS(654),
    [anon_sym_while] = ACTIONS(654),
    [anon_sym_break] = ACTIONS(654),
    [anon_sym_continue] = ACTIONS(654),
    [anon_sym_return] = ACTIONS(654),
    [anon_sym_yield] = ACTIONS(654),
    [anon_sym_synchronized] = ACTIONS(654),
    [anon_sym_throw] = ACTIONS(654),
    [anon_sym_try] = ACTIONS(654),
    [anon_sym_if] = ACTIONS(654),
    [anon_sym_else] = ACTIONS(654),
    [anon_sym_for] = ACTIONS(654),
    [anon_sym_AT] = ACTIONS(654),
    [anon_sym_open] = ACTIONS(654),
    [anon_sym_module] = ACTIONS(654),
    [anon_sym_static] = ACTIONS(654),
    [anon_sym_package] = ACTIONS(654),
    [anon_sym_import] = ACTIONS(654),
    [anon_sym_enum] = ACTIONS(654),
    [anon_sym_public] = ACTIONS(654),
    [anon_sym_protected] = ACTIONS(654),
    [anon_sym_private] = ACTIONS(654),
    [anon_sym_abstract] = ACTIONS(654),
    [anon_sym_strictfp] = ACTIONS(654),
    [anon_sym_native] = ACTIONS(654),
    [anon_sym_transient] = ACTIONS(654),
    [anon_sym_volatile] = ACTIONS(654),
    [anon_sym_sealed] = ACTIONS(654),
    [anon_sym_non_DASHsealed] = ACTIONS(652),
    [anon_sym_record] = ACTIONS(654),
    [anon_sym_ATinterface] = ACTIONS(652),
    [anon_sym_interface] = ACTIONS(654),
    [anon_sym_byte] = ACTIONS(654),
    [anon_sym_short] = ACTIONS(654),
    [anon_sym_int] = ACTIONS(654),
    [anon_sym_long] = ACTIONS(654),
    [anon_sym_char] = ACTIONS(654),
    [anon_sym_float] = ACTIONS(654),
    [anon_sym_double] = ACTIONS(654),
    [sym_boolean_type] = ACTIONS(654),
    [sym_void_type] = ACTIONS(654),
    [sym_this] = ACTIONS(654),
    [sym_super] = ACTIONS(654),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [180] = {
    [ts_builtin_sym_end] = ACTIONS(656),
    [sym_identifier] = ACTIONS(658),
    [sym_decimal_integer_literal] = ACTIONS(658),
    [sym_hex_integer_literal] = ACTIONS(658),
    [sym_octal_integer_literal] = ACTIONS(656),
    [sym_binary_integer_literal] = ACTIONS(656),
    [sym_decimal_floating_point_literal] = ACTIONS(656),
    [sym_hex_floating_point_literal] = ACTIONS(658),
    [sym_true] = ACTIONS(658),
    [sym_false] = ACTIONS(658),
    [sym_character_literal] = ACTIONS(656),
    [sym_string_literal] = ACTIONS(658),
    [sym_text_block] = ACTIONS(656),
    [sym_null_literal] = ACTIONS(658),
    [anon_sym_LPAREN] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(658),
    [anon_sym_DASH] = ACTIONS(658),
    [anon_sym_final] = ACTIONS(658),
    [anon_sym_BANG] = ACTIONS(656),
    [anon_sym_TILDE] = ACTIONS(656),
    [anon_sym_PLUS_PLUS] = ACTIONS(656),
    [anon_sym_DASH_DASH] = ACTIONS(656),
    [anon_sym_new] = ACTIONS(658),
    [anon_sym_class] = ACTIONS(658),
    [anon_sym_switch] = ACTIONS(658),
    [anon_sym_LBRACE] = ACTIONS(656),
    [anon_sym_RBRACE] = ACTIONS(656),
    [anon_sym_case] = ACTIONS(658),
    [anon_sym_default] = ACTIONS(658),
    [anon_sym_SEMI] = ACTIONS(656),
    [anon_sym_assert] = ACTIONS(658),
    [anon_sym_do] = ACTIONS(658),
    [anon_sym_while] = ACTIONS(658),
    [anon_sym_break] = ACTIONS(658),
    [anon_sym_continue] = ACTIONS(658),
    [anon_sym_return] = ACTIONS(658),
    [anon_sym_yield] = ACTIONS(658),
    [anon_sym_synchronized] = ACTIONS(658),
    [anon_sym_throw] = ACTIONS(658),
    [anon_sym_try] = ACTIONS(658),
    [anon_sym_if] = ACTIONS(658),
    [anon_sym_else] = ACTIONS(658),
    [anon_sym_for] = ACTIONS(658),
    [anon_sym_AT] = ACTIONS(658),
    [anon_sym_open] = ACTIONS(658),
    [anon_sym_module] = ACTIONS(658),
    [anon_sym_static] = ACTIONS(658),
    [anon_sym_package] = ACTIONS(658),
    [anon_sym_import] = ACTIONS(658),
    [anon_sym_enum] = ACTIONS(658),
    [anon_sym_public] = ACTIONS(658),
    [anon_sym_protected] = ACTIONS(658),
    [anon_sym_private] = ACTIONS(658),
    [anon_sym_abstract] = ACTIONS(658),
    [anon_sym_strictfp] = ACTIONS(658),
    [anon_sym_native] = ACTIONS(658),
    [anon_sym_transient] = ACTIONS(658),
    [anon_sym_volatile] = ACTIONS(658),
    [anon_sym_sealed] = ACTIONS(658),
    [anon_sym_non_DASHsealed] = ACTIONS(656),
    [anon_sym_record] = ACTIONS(658),
    [anon_sym_ATinterface] = ACTIONS(656),
    [anon_sym_interface] = ACTIONS(658),
    [anon_sym_byte] = ACTIONS(658),
    [anon_sym_short] = ACTIONS(658),
    [anon_sym_int] = ACTIONS(658),
    [anon_sym_long] = ACTIONS(658),
    [anon_sym_char] = ACTIONS(658),
    [anon_sym_float] = ACTIONS(658),
    [anon_sym_double] = ACTIONS(658),
    [sym_boolean_type] = ACTIONS(658),
    [sym_void_type] = ACTIONS(658),
    [sym_this] = ACTIONS(658),
    [sym_super] = ACTIONS(658),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [181] = {
    [ts_builtin_sym_end] = ACTIONS(660),
    [sym_identifier] = ACTIONS(662),
    [sym_decimal_integer_literal] = ACTIONS(662),
    [sym_hex_integer_literal] = ACTIONS(662),
    [sym_octal_integer_literal] = ACTIONS(660),
    [sym_binary_integer_literal] = ACTIONS(660),
    [sym_decimal_floating_point_literal] = ACTIONS(660),
    [sym_hex_floating_point_literal] = ACTIONS(662),
    [sym_true] = ACTIONS(662),
    [sym_false] = ACTIONS(662),
    [sym_character_literal] = ACTIONS(660),
    [sym_string_literal] = ACTIONS(662),
    [sym_text_block] = ACTIONS(660),
    [sym_null_literal] = ACTIONS(662),
    [anon_sym_LPAREN] = ACTIONS(660),
    [anon_sym_PLUS] = ACTIONS(662),
    [anon_sym_DASH] = ACTIONS(662),
    [anon_sym_final] = ACTIONS(662),
    [anon_sym_BANG] = ACTIONS(660),
    [anon_sym_TILDE] = ACTIONS(660),
    [anon_sym_PLUS_PLUS] = ACTIONS(660),
    [anon_sym_DASH_DASH] = ACTIONS(660),
    [anon_sym_new] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(662),
    [anon_sym_switch] = ACTIONS(662),
    [anon_sym_LBRACE] = ACTIONS(660),
    [anon_sym_RBRACE] = ACTIONS(660),
    [anon_sym_case] = ACTIONS(662),
    [anon_sym_default] = ACTIONS(662),
    [anon_sym_SEMI] = ACTIONS(660),
    [anon_sym_assert] = ACTIONS(662),
    [anon_sym_do] = ACTIONS(662),
    [anon_sym_while] = ACTIONS(662),
    [anon_sym_break] = ACTIONS(662),
    [anon_sym_continue] = ACTIONS(662),
    [anon_sym_return] = ACTIONS(662),
    [anon_sym_yield] = ACTIONS(662),
    [anon_sym_synchronized] = ACTIONS(662),
    [anon_sym_throw] = ACTIONS(662),
    [anon_sym_try] = ACTIONS(662),
    [anon_sym_if] = ACTIONS(662),
    [anon_sym_else] = ACTIONS(662),
    [anon_sym_for] = ACTIONS(662),
    [anon_sym_AT] = ACTIONS(662),
    [anon_sym_open] = ACTIONS(662),
    [anon_sym_module] = ACTIONS(662),
    [anon_sym_static] = ACTIONS(662),
    [anon_sym_package] = ACTIONS(662),
    [anon_sym_import] = ACTIONS(662),
    [anon_sym_enum] = ACTIONS(662),
    [anon_sym_public] = ACTIONS(662),
    [anon_sym_protected] = ACTIONS(662),
    [anon_sym_private] = ACTIONS(662),
    [anon_sym_abstract] = ACTIONS(662),
    [anon_sym_strictfp] = ACTIONS(662),
    [anon_sym_native] = ACTIONS(662),
    [anon_sym_transient] = ACTIONS(662),
    [anon_sym_volatile] = ACTIONS(662),
    [anon_sym_sealed] = ACTIONS(662),
    [anon_sym_non_DASHsealed] = ACTIONS(660),
    [anon_sym_record] = ACTIONS(662),
    [anon_sym_ATinterface] = ACTIONS(660),
    [anon_sym_interface] = ACTIONS(662),
    [anon_sym_byte] = ACTIONS(662),
    [anon_sym_short] = ACTIONS(662),
    [anon_sym_int] = ACTIONS(662),
    [anon_sym_long] = ACTIONS(662),
    [anon_sym_char] = ACTIONS(662),
    [anon_sym_float] = ACTIONS(662),
    [anon_sym_double] = ACTIONS(662),
    [sym_boolean_type] = ACTIONS(662),
    [sym_void_type] = ACTIONS(662),
    [sym_this] = ACTIONS(662),
    [sym_super] = ACTIONS(662),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [182] = {
    [ts_builtin_sym_end] = ACTIONS(664),
    [sym_identifier] = ACTIONS(666),
    [sym_decimal_integer_literal] = ACTIONS(666),
    [sym_hex_integer_literal] = ACTIONS(666),
    [sym_octal_integer_literal] = ACTIONS(664),
    [sym_binary_integer_literal] = ACTIONS(664),
    [sym_decimal_floating_point_literal] = ACTIONS(664),
    [sym_hex_floating_point_literal] = ACTIONS(666),
    [sym_true] = ACTIONS(666),
    [sym_false] = ACTIONS(666),
    [sym_character_literal] = ACTIONS(664),
    [sym_string_literal] = ACTIONS(666),
    [sym_text_block] = ACTIONS(664),
    [sym_null_literal] = ACTIONS(666),
    [anon_sym_LPAREN] = ACTIONS(664),
    [anon_sym_PLUS] = ACTIONS(666),
    [anon_sym_DASH] = ACTIONS(666),
    [anon_sym_final] = ACTIONS(666),
    [anon_sym_BANG] = ACTIONS(664),
    [anon_sym_TILDE] = ACTIONS(664),
    [anon_sym_PLUS_PLUS] = ACTIONS(664),
    [anon_sym_DASH_DASH] = ACTIONS(664),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_class] = ACTIONS(666),
    [anon_sym_switch] = ACTIONS(666),
    [anon_sym_LBRACE] = ACTIONS(664),
    [anon_sym_RBRACE] = ACTIONS(664),
    [anon_sym_case] = ACTIONS(666),
    [anon_sym_default] = ACTIONS(666),
    [anon_sym_SEMI] = ACTIONS(664),
    [anon_sym_assert] = ACTIONS(666),
    [anon_sym_do] = ACTIONS(666),
    [anon_sym_while] = ACTIONS(666),
    [anon_sym_break] = ACTIONS(666),
    [anon_sym_continue] = ACTIONS(666),
    [anon_sym_return] = ACTIONS(666),
    [anon_sym_yield] = ACTIONS(666),
    [anon_sym_synchronized] = ACTIONS(666),
    [anon_sym_throw] = ACTIONS(666),
    [anon_sym_try] = ACTIONS(666),
    [anon_sym_if] = ACTIONS(666),
    [anon_sym_else] = ACTIONS(666),
    [anon_sym_for] = ACTIONS(666),
    [anon_sym_AT] = ACTIONS(666),
    [anon_sym_open] = ACTIONS(666),
    [anon_sym_module] = ACTIONS(666),
    [anon_sym_static] = ACTIONS(666),
    [anon_sym_package] = ACTIONS(666),
    [anon_sym_import] = ACTIONS(666),
    [anon_sym_enum] = ACTIONS(666),
    [anon_sym_public] = ACTIONS(666),
    [anon_sym_protected] = ACTIONS(666),
    [anon_sym_private] = ACTIONS(666),
    [anon_sym_abstract] = ACTIONS(666),
    [anon_sym_strictfp] = ACTIONS(666),
    [anon_sym_native] = ACTIONS(666),
    [anon_sym_transient] = ACTIONS(666),
    [anon_sym_volatile] = ACTIONS(666),
    [anon_sym_sealed] = ACTIONS(666),
    [anon_sym_non_DASHsealed] = ACTIONS(664),
    [anon_sym_record] = ACTIONS(666),
    [anon_sym_ATinterface] = ACTIONS(664),
    [anon_sym_interface] = ACTIONS(666),
    [anon_sym_byte] = ACTIONS(666),
    [anon_sym_short] = ACTIONS(666),
    [anon_sym_int] = ACTIONS(666),
    [anon_sym_long] = ACTIONS(666),
    [anon_sym_char] = ACTIONS(666),
    [anon_sym_float] = ACTIONS(666),
    [anon_sym_double] = ACTIONS(666),
    [sym_boolean_type] = ACTIONS(666),
    [sym_void_type] = ACTIONS(666),
    [sym_this] = ACTIONS(666),
    [sym_super] = ACTIONS(666),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [183] = {
    [ts_builtin_sym_end] = ACTIONS(668),
    [sym_identifier] = ACTIONS(670),
    [sym_decimal_integer_literal] = ACTIONS(670),
    [sym_hex_integer_literal] = ACTIONS(670),
    [sym_octal_integer_literal] = ACTIONS(668),
    [sym_binary_integer_literal] = ACTIONS(668),
    [sym_decimal_floating_point_literal] = ACTIONS(668),
    [sym_hex_floating_point_literal] = ACTIONS(670),
    [sym_true] = ACTIONS(670),
    [sym_false] = ACTIONS(670),
    [sym_character_literal] = ACTIONS(668),
    [sym_string_literal] = ACTIONS(670),
    [sym_text_block] = ACTIONS(668),
    [sym_null_literal] = ACTIONS(670),
    [anon_sym_LPAREN] = ACTIONS(668),
    [anon_sym_PLUS] = ACTIONS(670),
    [anon_sym_DASH] = ACTIONS(670),
    [anon_sym_final] = ACTIONS(670),
    [anon_sym_BANG] = ACTIONS(668),
    [anon_sym_TILDE] = ACTIONS(668),
    [anon_sym_PLUS_PLUS] = ACTIONS(668),
    [anon_sym_DASH_DASH] = ACTIONS(668),
    [anon_sym_new] = ACTIONS(670),
    [anon_sym_class] = ACTIONS(670),
    [anon_sym_switch] = ACTIONS(670),
    [anon_sym_LBRACE] = ACTIONS(668),
    [anon_sym_RBRACE] = ACTIONS(668),
    [anon_sym_case] = ACTIONS(670),
    [anon_sym_default] = ACTIONS(670),
    [anon_sym_SEMI] = ACTIONS(668),
    [anon_sym_assert] = ACTIONS(670),
    [anon_sym_do] = ACTIONS(670),
    [anon_sym_while] = ACTIONS(670),
    [anon_sym_break] = ACTIONS(670),
    [anon_sym_continue] = ACTIONS(670),
    [anon_sym_return] = ACTIONS(670),
    [anon_sym_yield] = ACTIONS(670),
    [anon_sym_synchronized] = ACTIONS(670),
    [anon_sym_throw] = ACTIONS(670),
    [anon_sym_try] = ACTIONS(670),
    [anon_sym_if] = ACTIONS(670),
    [anon_sym_else] = ACTIONS(670),
    [anon_sym_for] = ACTIONS(670),
    [anon_sym_AT] = ACTIONS(670),
    [anon_sym_open] = ACTIONS(670),
    [anon_sym_module] = ACTIONS(670),
    [anon_sym_static] = ACTIONS(670),
    [anon_sym_package] = ACTIONS(670),
    [anon_sym_import] = ACTIONS(670),
    [anon_sym_enum] = ACTIONS(670),
    [anon_sym_public] = ACTIONS(670),
    [anon_sym_protected] = ACTIONS(670),
    [anon_sym_private] = ACTIONS(670),
    [anon_sym_abstract] = ACTIONS(670),
    [anon_sym_strictfp] = ACTIONS(670),
    [anon_sym_native] = ACTIONS(670),
    [anon_sym_transient] = ACTIONS(670),
    [anon_sym_volatile] = ACTIONS(670),
    [anon_sym_sealed] = ACTIONS(670),
    [anon_sym_non_DASHsealed] = ACTIONS(668),
    [anon_sym_record] = ACTIONS(670),
    [anon_sym_ATinterface] = ACTIONS(668),
    [anon_sym_interface] = ACTIONS(670),
    [anon_sym_byte] = ACTIONS(670),
    [anon_sym_short] = ACTIONS(670),
    [anon_sym_int] = ACTIONS(670),
    [anon_sym_long] = ACTIONS(670),
    [anon_sym_char] = ACTIONS(670),
    [anon_sym_float] = ACTIONS(670),
    [anon_sym_double] = ACTIONS(670),
    [sym_boolean_type] = ACTIONS(670),
    [sym_void_type] = ACTIONS(670),
    [sym_this] = ACTIONS(670),
    [sym_super] = ACTIONS(670),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [184] = {
    [ts_builtin_sym_end] = ACTIONS(672),
    [sym_identifier] = ACTIONS(674),
    [sym_decimal_integer_literal] = ACTIONS(674),
    [sym_hex_integer_literal] = ACTIONS(674),
    [sym_octal_integer_literal] = ACTIONS(672),
    [sym_binary_integer_literal] = ACTIONS(672),
    [sym_decimal_floating_point_literal] = ACTIONS(672),
    [sym_hex_floating_point_literal] = ACTIONS(674),
    [sym_true] = ACTIONS(674),
    [sym_false] = ACTIONS(674),
    [sym_character_literal] = ACTIONS(672),
    [sym_string_literal] = ACTIONS(674),
    [sym_text_block] = ACTIONS(672),
    [sym_null_literal] = ACTIONS(674),
    [anon_sym_LPAREN] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_final] = ACTIONS(674),
    [anon_sym_BANG] = ACTIONS(672),
    [anon_sym_TILDE] = ACTIONS(672),
    [anon_sym_PLUS_PLUS] = ACTIONS(672),
    [anon_sym_DASH_DASH] = ACTIONS(672),
    [anon_sym_new] = ACTIONS(674),
    [anon_sym_class] = ACTIONS(674),
    [anon_sym_switch] = ACTIONS(674),
    [anon_sym_LBRACE] = ACTIONS(672),
    [anon_sym_RBRACE] = ACTIONS(672),
    [anon_sym_case] = ACTIONS(674),
    [anon_sym_default] = ACTIONS(674),
    [anon_sym_SEMI] = ACTIONS(672),
    [anon_sym_assert] = ACTIONS(674),
    [anon_sym_do] = ACTIONS(674),
    [anon_sym_while] = ACTIONS(674),
    [anon_sym_break] = ACTIONS(674),
    [anon_sym_continue] = ACTIONS(674),
    [anon_sym_return] = ACTIONS(674),
    [anon_sym_yield] = ACTIONS(674),
    [anon_sym_synchronized] = ACTIONS(674),
    [anon_sym_throw] = ACTIONS(674),
    [anon_sym_try] = ACTIONS(674),
    [anon_sym_if] = ACTIONS(674),
    [anon_sym_else] = ACTIONS(674),
    [anon_sym_for] = ACTIONS(674),
    [anon_sym_AT] = ACTIONS(674),
    [anon_sym_open] = ACTIONS(674),
    [anon_sym_module] = ACTIONS(674),
    [anon_sym_static] = ACTIONS(674),
    [anon_sym_package] = ACTIONS(674),
    [anon_sym_import] = ACTIONS(674),
    [anon_sym_enum] = ACTIONS(674),
    [anon_sym_public] = ACTIONS(674),
    [anon_sym_protected] = ACTIONS(674),
    [anon_sym_private] = ACTIONS(674),
    [anon_sym_abstract] = ACTIONS(674),
    [anon_sym_strictfp] = ACTIONS(674),
    [anon_sym_native] = ACTIONS(674),
    [anon_sym_transient] = ACTIONS(674),
    [anon_sym_volatile] = ACTIONS(674),
    [anon_sym_sealed] = ACTIONS(674),
    [anon_sym_non_DASHsealed] = ACTIONS(672),
    [anon_sym_record] = ACTIONS(674),
    [anon_sym_ATinterface] = ACTIONS(672),
    [anon_sym_interface] = ACTIONS(674),
    [anon_sym_byte] = ACTIONS(674),
    [anon_sym_short] = ACTIONS(674),
    [anon_sym_int] = ACTIONS(674),
    [anon_sym_long] = ACTIONS(674),
    [anon_sym_char] = ACTIONS(674),
    [anon_sym_float] = ACTIONS(674),
    [anon_sym_double] = ACTIONS(674),
    [sym_boolean_type] = ACTIONS(674),
    [sym_void_type] = ACTIONS(674),
    [sym_this] = ACTIONS(674),
    [sym_super] = ACTIONS(674),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [185] = {
    [ts_builtin_sym_end] = ACTIONS(676),
    [sym_identifier] = ACTIONS(678),
    [sym_decimal_integer_literal] = ACTIONS(678),
    [sym_hex_integer_literal] = ACTIONS(678),
    [sym_octal_integer_literal] = ACTIONS(676),
    [sym_binary_integer_literal] = ACTIONS(676),
    [sym_decimal_floating_point_literal] = ACTIONS(676),
    [sym_hex_floating_point_literal] = ACTIONS(678),
    [sym_true] = ACTIONS(678),
    [sym_false] = ACTIONS(678),
    [sym_character_literal] = ACTIONS(676),
    [sym_string_literal] = ACTIONS(678),
    [sym_text_block] = ACTIONS(676),
    [sym_null_literal] = ACTIONS(678),
    [anon_sym_LPAREN] = ACTIONS(676),
    [anon_sym_PLUS] = ACTIONS(678),
    [anon_sym_DASH] = ACTIONS(678),
    [anon_sym_final] = ACTIONS(678),
    [anon_sym_BANG] = ACTIONS(676),
    [anon_sym_TILDE] = ACTIONS(676),
    [anon_sym_PLUS_PLUS] = ACTIONS(676),
    [anon_sym_DASH_DASH] = ACTIONS(676),
    [anon_sym_new] = ACTIONS(678),
    [anon_sym_class] = ACTIONS(678),
    [anon_sym_switch] = ACTIONS(678),
    [anon_sym_LBRACE] = ACTIONS(676),
    [anon_sym_RBRACE] = ACTIONS(676),
    [anon_sym_case] = ACTIONS(678),
    [anon_sym_default] = ACTIONS(678),
    [anon_sym_SEMI] = ACTIONS(676),
    [anon_sym_assert] = ACTIONS(678),
    [anon_sym_do] = ACTIONS(678),
    [anon_sym_while] = ACTIONS(678),
    [anon_sym_break] = ACTIONS(678),
    [anon_sym_continue] = ACTIONS(678),
    [anon_sym_return] = ACTIONS(678),
    [anon_sym_yield] = ACTIONS(678),
    [anon_sym_synchronized] = ACTIONS(678),
    [anon_sym_throw] = ACTIONS(678),
    [anon_sym_try] = ACTIONS(678),
    [anon_sym_if] = ACTIONS(678),
    [anon_sym_else] = ACTIONS(678),
    [anon_sym_for] = ACTIONS(678),
    [anon_sym_AT] = ACTIONS(678),
    [anon_sym_open] = ACTIONS(678),
    [anon_sym_module] = ACTIONS(678),
    [anon_sym_static] = ACTIONS(678),
    [anon_sym_package] = ACTIONS(678),
    [anon_sym_import] = ACTIONS(678),
    [anon_sym_enum] = ACTIONS(678),
    [anon_sym_public] = ACTIONS(678),
    [anon_sym_protected] = ACTIONS(678),
    [anon_sym_private] = ACTIONS(678),
    [anon_sym_abstract] = ACTIONS(678),
    [anon_sym_strictfp] = ACTIONS(678),
    [anon_sym_native] = ACTIONS(678),
    [anon_sym_transient] = ACTIONS(678),
    [anon_sym_volatile] = ACTIONS(678),
    [anon_sym_sealed] = ACTIONS(678),
    [anon_sym_non_DASHsealed] = ACTIONS(676),
    [anon_sym_record] = ACTIONS(678),
    [anon_sym_ATinterface] = ACTIONS(676),
    [anon_sym_interface] = ACTIONS(678),
    [anon_sym_byte] = ACTIONS(678),
    [anon_sym_short] = ACTIONS(678),
    [anon_sym_int] = ACTIONS(678),
    [anon_sym_long] = ACTIONS(678),
    [anon_sym_char] = ACTIONS(678),
    [anon_sym_float] = ACTIONS(678),
    [anon_sym_double] = ACTIONS(678),
    [sym_boolean_type] = ACTIONS(678),
    [sym_void_type] = ACTIONS(678),
    [sym_this] = ACTIONS(678),
    [sym_super] = ACTIONS(678),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [186] = {
    [ts_builtin_sym_end] = ACTIONS(680),
    [sym_identifier] = ACTIONS(682),
    [sym_decimal_integer_literal] = ACTIONS(682),
    [sym_hex_integer_literal] = ACTIONS(682),
    [sym_octal_integer_literal] = ACTIONS(680),
    [sym_binary_integer_literal] = ACTIONS(680),
    [sym_decimal_floating_point_literal] = ACTIONS(680),
    [sym_hex_floating_point_literal] = ACTIONS(682),
    [sym_true] = ACTIONS(682),
    [sym_false] = ACTIONS(682),
    [sym_character_literal] = ACTIONS(680),
    [sym_string_literal] = ACTIONS(682),
    [sym_text_block] = ACTIONS(680),
    [sym_null_literal] = ACTIONS(682),
    [anon_sym_LPAREN] = ACTIONS(680),
    [anon_sym_PLUS] = ACTIONS(682),
    [anon_sym_DASH] = ACTIONS(682),
    [anon_sym_final] = ACTIONS(682),
    [anon_sym_BANG] = ACTIONS(680),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_new] = ACTIONS(682),
    [anon_sym_class] = ACTIONS(682),
    [anon_sym_switch] = ACTIONS(682),
    [anon_sym_LBRACE] = ACTIONS(680),
    [anon_sym_RBRACE] = ACTIONS(680),
    [anon_sym_ca