#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 573
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 101
#define ALIAS_COUNT 0
#define TOKEN_COUNT 63
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 4
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 12

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_unescaped_double_string_fragment = 2,
  sym_escape_sequence = 3,
  anon_sym_DQUOTE = 4,
  sym_comment = 5,
  anon_sym_DASH_GT = 6,
  anon_sym_EQ_GT = 7,
  anon_sym_LBRACK = 8,
  anon_sym_RBRACK = 9,
  anon_sym_LPAREN = 10,
  anon_sym_RPAREN = 11,
  anon_sym_PIPE = 12,
  anon_sym_module = 13,
  anon_sym_LBRACE = 14,
  anon_sym_RBRACE = 15,
  anon_sym_const = 16,
  anon_sym_COLON = 17,
  anon_sym_assume = 18,
  anon_sym_EQ = 19,
  anon_sym_var = 20,
  anon_sym_COMMA = 21,
  anon_sym_pure = 22,
  anon_sym_val = 23,
  anon_sym_def = 24,
  anon_sym_action = 25,
  anon_sym_temporal = 26,
  anon_sym_run = 27,
  anon_sym_SEMI = 28,
  anon_sym_type = 29,
  anon_sym_1to10 = 30,
  anon_sym_Bool = 31,
  anon_sym_Int = 32,
  anon_sym_Nat = 33,
  anon_sym_true = 34,
  anon_sym_false = 35,
  sym_int_literal = 36,
  anon_sym_DASH = 37,
  anon_sym_DOT = 38,
  anon_sym_CARET = 39,
  anon_sym_STAR = 40,
  anon_sym_SLASH = 41,
  anon_sym_PERCENT = 42,
  anon_sym_PLUS = 43,
  anon_sym_LT = 44,
  anon_sym_GT = 45,
  anon_sym_GT_EQ = 46,
  anon_sym_LT_EQ = 47,
  anon_sym_EQ_EQ = 48,
  anon_sym_BANG_EQ = 49,
  anon_sym_SQUOTE_EQ = 50,
  anon_sym_and = 51,
  anon_sym_or = 52,
  anon_sym_iff = 53,
  anon_sym_implies = 54,
  anon_sym_all = 55,
  anon_sym_any = 56,
  anon_sym_if = 57,
  anon_sym_then = 58,
  anon_sym_else = 59,
  anon_sym_nondet = 60,
  anon_sym_LF = 61,
  anon_sym_DOT_DOT_DOT = 62,
  sym_source_file = 63,
  sym_string = 64,
  sym_type = 65,
  sym_function_type = 66,
  sym_operator_type = 67,
  sym_polymorphic_type = 68,
  sym_sum_type = 69,
  sym_module_definition = 70,
  sym_constant_declaration = 71,
  sym_assumption = 72,
  sym_variable_definition = 73,
  sym_typed_argument_list = 74,
  sym_operator_definition = 75,
  sym_type_alias = 76,
  sym_expr = 77,
  sym_well_known_set = 78,
  sym_bool_literal = 79,
  sym_lambda_expr = 80,
  sym_operator_application = 81,
  sym_list_access = 82,
  sym_unary_expr = 83,
  sym_binary_expr = 84,
  sym_braced_and = 85,
  sym_braced_or = 86,
  sym_braced_all = 87,
  sym_braced_any = 88,
  sym_if_else_condition = 89,
  sym_nondet_choice = 90,
  sym_record_literal = 91,
  sym_tuple_literal = 92,
  sym_list_literal = 93,
  aux_sym_source_file_repeat1 = 94,
  aux_sym_string_repeat1 = 95,
  aux_sym_sum_type_repeat1 = 96,
  aux_sym_module_definition_repeat1 = 97,
  aux_sym_typed_argument_list_repeat1 = 98,
  aux_sym_lambda_expr_repeat1 = 99,
  aux_sym_record_literal_repeat1 = 100,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_DQUOTE] = "\"",
  [sym_comment] = "comment",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_PIPE] = "|",
  [anon_sym_module] = "module",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_const] = "const",
  [anon_sym_COLON] = ":",
  [anon_sym_assume] = "assume",
  [anon_sym_EQ] = "=",
  [anon_sym_var] = "var",
  [anon_sym_COMMA] = ",",
  [anon_sym_pure] = "pure",
  [anon_sym_val] = "val",
  [anon_sym_def] = "def",
  [anon_sym_action] = "action",
  [anon_sym_temporal] = "temporal",
  [anon_sym_run] = "run",
  [anon_sym_SEMI] = ";",
  [anon_sym_type] = "type",
  [anon_sym_1to10] = "1 to 10",
  [anon_sym_Bool] = "Bool",
  [anon_sym_Int] = "Int",
  [anon_sym_Nat] = "Nat",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_int_literal] = "int_literal",
  [anon_sym_DASH] = "-",
  [anon_sym_DOT] = ".",
  [anon_sym_CARET] = "^",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PLUS] = "+",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_SQUOTE_EQ] = "' =",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_iff] = "iff",
  [anon_sym_implies] = "implies",
  [anon_sym_all] = "all",
  [anon_sym_any] = "any",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_nondet] = "nondet",
  [anon_sym_LF] = "\n",
  [anon_sym_DOT_DOT_DOT] = "...",
  [sym_source_file] = "source_file",
  [sym_string] = "string",
  [sym_type] = "type",
  [sym_function_type] = "function_type",
  [sym_operator_type] = "operator_type",
  [sym_polymorphic_type] = "polymorphic_type",
  [sym_sum_type] = "sum_type",
  [sym_module_definition] = "module_definition",
  [sym_constant_declaration] = "constant_declaration",
  [sym_assumption] = "assumption",
  [sym_variable_definition] = "variable_definition",
  [sym_typed_argument_list] = "typed_argument_list",
  [sym_operator_definition] = "operator_definition",
  [sym_type_alias] = "type_alias",
  [sym_expr] = "expr",
  [sym_well_known_set] = "well_known_set",
  [sym_bool_literal] = "bool_literal",
  [sym_lambda_expr] = "lambda_expr",
  [sym_operator_application] = "operator_application",
  [sym_list_access] = "list_access",
  [sym_unary_expr] = "unary_expr",
  [sym_binary_expr] = "binary_expr",
  [sym_braced_and] = "braced_and",
  [sym_braced_or] = "braced_or",
  [sym_braced_all] = "braced_all",
  [sym_braced_any] = "braced_any",
  [sym_if_else_condition] = "if_else_condition",
  [sym_nondet_choice] = "nondet_choice",
  [sym_record_literal] = "record_literal",
  [sym_tuple_literal] = "tuple_literal",
  [sym_list_literal] = "list_literal",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_sum_type_repeat1] = "sum_type_repeat1",
  [aux_sym_module_definition_repeat1] = "module_definition_repeat1",
  [aux_sym_typed_argument_list_repeat1] = "typed_argument_list_repeat1",
  [aux_sym_lambda_expr_repeat1] = "lambda_expr_repeat1",
  [aux_sym_record_literal_repeat1] = "record_literal_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_comment] = sym_comment,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_assume] = anon_sym_assume,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_pure] = anon_sym_pure,
  [anon_sym_val] = anon_sym_val,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_action] = anon_sym_action,
  [anon_sym_temporal] = anon_sym_temporal,
  [anon_sym_run] = anon_sym_run,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_1to10] = anon_sym_1to10,
  [anon_sym_Bool] = anon_sym_Bool,
  [anon_sym_Int] = anon_sym_Int,
  [anon_sym_Nat] = anon_sym_Nat,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_int_literal] = sym_int_literal,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_SQUOTE_EQ] = anon_sym_SQUOTE_EQ,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_iff] = anon_sym_iff,
  [anon_sym_implies] = anon_sym_implies,
  [anon_sym_all] = anon_sym_all,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_nondet] = anon_sym_nondet,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [sym_source_file] = sym_source_file,
  [sym_string] = sym_string,
  [sym_type] = sym_type,
  [sym_function_type] = sym_function_type,
  [sym_operator_type] = sym_operator_type,
  [sym_polymorphic_type] = sym_polymorphic_type,
  [sym_sum_type] = sym_sum_type,
  [sym_module_definition] = sym_module_definition,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym_assumption] = sym_assumption,
  [sym_variable_definition] = sym_variable_definition,
  [sym_typed_argument_list] = sym_typed_argument_list,
  [sym_operator_definition] = sym_operator_definition,
  [sym_type_alias] = sym_type_alias,
  [sym_expr] = sym_expr,
  [sym_well_known_set] = sym_well_known_set,
  [sym_bool_literal] = sym_bool_literal,
  [sym_lambda_expr] = sym_lambda_expr,
  [sym_operator_application] = sym_operator_application,
  [sym_list_access] = sym_list_access,
  [sym_unary_expr] = sym_unary_expr,
  [sym_binary_expr] = sym_binary_expr,
  [sym_braced_and] = sym_braced_and,
  [sym_braced_or] = sym_braced_or,
  [sym_braced_all] = sym_braced_all,
  [sym_braced_any] = sym_braced_any,
  [sym_if_else_condition] = sym_if_else_condition,
  [sym_nondet_choice] = sym_nondet_choice,
  [sym_record_literal] = sym_record_literal,
  [sym_tuple_literal] = sym_tuple_literal,
  [sym_list_literal] = sym_list_literal,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_sum_type_repeat1] = aux_sym_sum_type_repeat1,
  [aux_sym_module_definition_repeat1] = aux_sym_module_definition_repeat1,
  [aux_sym_typed_argument_list_repeat1] = aux_sym_typed_argument_list_repeat1,
  [aux_sym_lambda_expr_repeat1] = aux_sym_lambda_expr_repeat1,
  [aux_sym_record_literal_repeat1] = aux_sym_record_literal_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assume] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_val] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_action] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_temporal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_run] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_1to10] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Nat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iff] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_all] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nondet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_type] = {
    .visible = true,
    .named = true,
  },
  [sym_polymorphic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_sum_type] = {
    .visible = true,
    .named = true,
  },
  [sym_module_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_assumption] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_well_known_set] = {
    .visible = true,
    .named = true,
  },
  [sym_bool_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_application] = {
    .visible = true,
    .named = true,
  },
  [sym_list_access] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_and] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_or] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_all] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_any] = {
    .visible = true,
    .named = true,
  },
  [sym_if_else_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_nondet_choice] = {
    .visible = true,
    .named = true,
  },
  [sym_record_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_list_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sum_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_typed_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_lambda_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_arguments = 1,
  field_name = 2,
  field_operator = 3,
  field_rhs = 4,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_arguments] = "arguments",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_rhs] = "rhs",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 2},
  [3] = {.index = 4, .length = 3},
  [4] = {.index = 7, .length = 3},
  [5] = {.index = 10, .length = 3},
  [6] = {.index = 13, .length = 2},
  [7] = {.index = 15, .length = 4},
  [8] = {.index = 19, .length = 2},
  [9] = {.index = 21, .length = 3},
  [10] = {.index = 24, .length = 5},
  [11] = {.index = 29, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
    {field_rhs, 3},
  [2] =
    {field_name, 2},
    {field_rhs, 4},
  [4] =
    {field_arguments, 2},
    {field_name, 1},
    {field_rhs, 4},
  [7] =
    {field_arguments, 1},
    {field_arguments, 2},
    {field_operator, 0},
  [10] =
    {field_arguments, 3},
    {field_name, 2},
    {field_rhs, 5},
  [13] =
    {field_name, 1},
    {field_rhs, 5},
  [15] =
    {field_arguments, 1},
    {field_arguments, 2},
    {field_arguments, 3},
    {field_operator, 0},
  [19] =
    {field_name, 2},
    {field_rhs, 6},
  [21] =
    {field_arguments, 2},
    {field_name, 1},
    {field_rhs, 6},
  [24] =
    {field_arguments, 1},
    {field_arguments, 2},
    {field_arguments, 3},
    {field_arguments, 4},
    {field_operator, 0},
  [29] =
    {field_arguments, 3},
    {field_name, 2},
    {field_rhs, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 2,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 9,
  [20] = 20,
  [21] = 4,
  [22] = 5,
  [23] = 3,
  [24] = 7,
  [25] = 8,
  [26] = 20,
  [27] = 11,
  [28] = 12,
  [29] = 13,
  [30] = 14,
  [31] = 15,
  [32] = 16,
  [33] = 17,
  [34] = 9,
  [35] = 20,
  [36] = 4,
  [37] = 5,
  [38] = 2,
  [39] = 7,
  [40] = 8,
  [41] = 10,
  [42] = 11,
  [43] = 12,
  [44] = 13,
  [45] = 14,
  [46] = 15,
  [47] = 16,
  [48] = 17,
  [49] = 3,
  [50] = 10,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 56,
  [67] = 57,
  [68] = 60,
  [69] = 61,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 51,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 53,
  [86] = 54,
  [87] = 55,
  [88] = 88,
  [89] = 58,
  [90] = 90,
  [91] = 63,
  [92] = 65,
  [93] = 56,
  [94] = 61,
  [95] = 71,
  [96] = 72,
  [97] = 73,
  [98] = 51,
  [99] = 75,
  [100] = 76,
  [101] = 77,
  [102] = 78,
  [103] = 79,
  [104] = 80,
  [105] = 83,
  [106] = 55,
  [107] = 90,
  [108] = 63,
  [109] = 65,
  [110] = 110,
  [111] = 111,
  [112] = 110,
  [113] = 111,
  [114] = 114,
  [115] = 71,
  [116] = 116,
  [117] = 72,
  [118] = 73,
  [119] = 75,
  [120] = 76,
  [121] = 77,
  [122] = 78,
  [123] = 79,
  [124] = 80,
  [125] = 81,
  [126] = 82,
  [127] = 127,
  [128] = 83,
  [129] = 116,
  [130] = 59,
  [131] = 52,
  [132] = 62,
  [133] = 116,
  [134] = 59,
  [135] = 52,
  [136] = 62,
  [137] = 114,
  [138] = 114,
  [139] = 90,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 18,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 84,
  [192] = 70,
  [193] = 88,
  [194] = 148,
  [195] = 161,
  [196] = 162,
  [197] = 158,
  [198] = 198,
  [199] = 199,
  [200] = 165,
  [201] = 166,
  [202] = 167,
  [203] = 149,
  [204] = 146,
  [205] = 170,
  [206] = 171,
  [207] = 168,
  [208] = 172,
  [209] = 173,
  [210] = 174,
  [211] = 150,
  [212] = 175,
  [213] = 213,
  [214] = 214,
  [215] = 177,
  [216] = 178,
  [217] = 151,
  [218] = 159,
  [219] = 190,
  [220] = 180,
  [221] = 160,
  [222] = 179,
  [223] = 145,
  [224] = 224,
  [225] = 182,
  [226] = 183,
  [227] = 147,
  [228] = 140,
  [229] = 184,
  [230] = 152,
  [231] = 153,
  [232] = 154,
  [233] = 233,
  [234] = 234,
  [235] = 186,
  [236] = 236,
  [237] = 185,
  [238] = 142,
  [239] = 144,
  [240] = 187,
  [241] = 155,
  [242] = 188,
  [243] = 189,
  [244] = 163,
  [245] = 164,
  [246] = 176,
  [247] = 141,
  [248] = 156,
  [249] = 143,
  [250] = 157,
  [251] = 181,
  [252] = 252,
  [253] = 233,
  [254] = 199,
  [255] = 214,
  [256] = 224,
  [257] = 213,
  [258] = 236,
  [259] = 198,
  [260] = 234,
  [261] = 252,
  [262] = 262,
  [263] = 262,
  [264] = 264,
  [265] = 18,
  [266] = 262,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 267,
  [272] = 272,
  [273] = 273,
  [274] = 269,
  [275] = 70,
  [276] = 270,
  [277] = 88,
  [278] = 278,
  [279] = 278,
  [280] = 268,
  [281] = 268,
  [282] = 282,
  [283] = 282,
  [284] = 272,
  [285] = 273,
  [286] = 269,
  [287] = 270,
  [288] = 267,
  [289] = 278,
  [290] = 84,
  [291] = 282,
  [292] = 272,
  [293] = 273,
  [294] = 156,
  [295] = 167,
  [296] = 180,
  [297] = 181,
  [298] = 182,
  [299] = 183,
  [300] = 184,
  [301] = 140,
  [302] = 186,
  [303] = 187,
  [304] = 304,
  [305] = 188,
  [306] = 189,
  [307] = 163,
  [308] = 176,
  [309] = 179,
  [310] = 304,
  [311] = 185,
  [312] = 164,
  [313] = 141,
  [314] = 142,
  [315] = 144,
  [316] = 168,
  [317] = 143,
  [318] = 165,
  [319] = 166,
  [320] = 170,
  [321] = 146,
  [322] = 171,
  [323] = 172,
  [324] = 173,
  [325] = 174,
  [326] = 147,
  [327] = 148,
  [328] = 304,
  [329] = 149,
  [330] = 175,
  [331] = 150,
  [332] = 151,
  [333] = 152,
  [334] = 153,
  [335] = 154,
  [336] = 155,
  [337] = 162,
  [338] = 157,
  [339] = 158,
  [340] = 340,
  [341] = 159,
  [342] = 160,
  [343] = 190,
  [344] = 177,
  [345] = 161,
  [346] = 178,
  [347] = 145,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 349,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 356,
  [358] = 354,
  [359] = 351,
  [360] = 356,
  [361] = 361,
  [362] = 354,
  [363] = 363,
  [364] = 351,
  [365] = 349,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 348,
  [375] = 375,
  [376] = 350,
  [377] = 377,
  [378] = 363,
  [379] = 379,
  [380] = 352,
  [381] = 366,
  [382] = 368,
  [383] = 383,
  [384] = 384,
  [385] = 367,
  [386] = 375,
  [387] = 387,
  [388] = 388,
  [389] = 370,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 379,
  [395] = 369,
  [396] = 396,
  [397] = 377,
  [398] = 398,
  [399] = 383,
  [400] = 398,
  [401] = 396,
  [402] = 388,
  [403] = 393,
  [404] = 392,
  [405] = 384,
  [406] = 390,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 410,
  [412] = 412,
  [413] = 413,
  [414] = 412,
  [415] = 409,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 407,
  [421] = 421,
  [422] = 422,
  [423] = 413,
  [424] = 424,
  [425] = 416,
  [426] = 422,
  [427] = 427,
  [428] = 419,
  [429] = 424,
  [430] = 417,
  [431] = 427,
  [432] = 408,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 435,
  [440] = 440,
  [441] = 441,
  [442] = 441,
  [443] = 443,
  [444] = 438,
  [445] = 443,
  [446] = 443,
  [447] = 438,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 449,
  [454] = 454,
  [455] = 450,
  [456] = 456,
  [457] = 456,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 458,
  [462] = 462,
  [463] = 463,
  [464] = 459,
  [465] = 465,
  [466] = 466,
  [467] = 465,
  [468] = 468,
  [469] = 469,
  [470] = 468,
  [471] = 448,
  [472] = 468,
  [473] = 449,
  [474] = 451,
  [475] = 450,
  [476] = 452,
  [477] = 456,
  [478] = 458,
  [479] = 479,
  [480] = 459,
  [481] = 460,
  [482] = 454,
  [483] = 460,
  [484] = 462,
  [485] = 466,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 486,
  [492] = 465,
  [493] = 448,
  [494] = 489,
  [495] = 490,
  [496] = 452,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 497,
  [502] = 500,
  [503] = 503,
  [504] = 498,
  [505] = 505,
  [506] = 505,
  [507] = 507,
  [508] = 505,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 512,
  [518] = 518,
  [519] = 513,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 518,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 521,
  [538] = 538,
  [539] = 521,
  [540] = 528,
  [541] = 525,
  [542] = 526,
  [543] = 527,
  [544] = 528,
  [545] = 533,
  [546] = 546,
  [547] = 533,
  [548] = 525,
  [549] = 527,
  [550] = 523,
  [551] = 529,
  [552] = 531,
  [553] = 522,
  [554] = 546,
  [555] = 555,
  [556] = 556,
  [557] = 530,
  [558] = 558,
  [559] = 532,
  [560] = 558,
  [561] = 530,
  [562] = 558,
  [563] = 536,
  [564] = 564,
  [565] = 565,
  [566] = 536,
  [567] = 526,
  [568] = 520,
  [569] = 555,
  [570] = 535,
  [571] = 535,
  [572] = 565,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(108);
      ADVANCE_MAP(
        '!', 15,
        '"', 144,
        '%', 193,
        '\'', 3,
        '(', 151,
        ')', 152,
        '*', 191,
        '+', 194,
        ',', 163,
        '-', 187,
        '.', 189,
        '/', 192,
        '0', 186,
        '1', 183,
        ':', 158,
        ';', 170,
        '<', 195,
        '=', 160,
        '>', 196,
        'B', 72,
        'I', 62,
        'N', 20,
        '[', 149,
        '\\', 91,
        ']', 150,
        '^', 190,
        'a', 23,
        'c', 68,
        'd', 30,
        'e', 53,
        'f', 22,
        'i', 43,
        'm', 66,
        'n', 69,
        'o', 77,
        'p', 92,
        'r', 94,
        't', 31,
        'v', 19,
        '{', 155,
        '|', 153,
        '}', 156,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(105);
      if (('2' <= lookahead && lookahead <= '9')) ADVANCE(185);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '\n', 218,
        '!', 15,
        '%', 193,
        '\'', 3,
        '(', 151,
        '*', 191,
        '+', 194,
        '-', 187,
        '.', 188,
        '/', 192,
        ';', 170,
        '<', 195,
        '=', 16,
        '>', 196,
        '[', 149,
        '^', 190,
        'a', 65,
        'i', 46,
        'o', 77,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      END_STATE();
    case 2:
      if (lookahead == ' ') ADVANCE(14);
      END_STATE();
    case 3:
      if (lookahead == ' ') ADVANCE(17);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '"', 144,
        '(', 151,
        ')', 152,
        '-', 187,
        '.', 10,
        '/', 7,
        '0', 186,
        '1', 183,
        ':', 158,
        '=', 161,
        'B', 124,
        'I', 121,
        'N', 109,
        '[', 149,
        ']', 150,
        'a', 117,
        'f', 110,
        'i', 116,
        'n', 123,
        'o', 126,
        't', 127,
        '{', 155,
        '}', 156,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('2' <= lookahead && lookahead <= '9')) ADVANCE(185);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(144);
      if (lookahead == '/') ADVANCE(7);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(144);
      if (lookahead == '/') ADVANCE(134);
      if (lookahead == '\\') ADVANCE(91);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(5);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(137);
      if (lookahead != 0) ADVANCE(139);
      END_STATE();
    case 7:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead == '/') ADVANCE(146);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead == '/') ADVANCE(145);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 10:
      if (lookahead == '.') ADVANCE(11);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(219);
      END_STATE();
    case 12:
      if (lookahead == '.') ADVANCE(10);
      if (lookahead == '/') ADVANCE(7);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 13:
      if (lookahead == '0') ADVANCE(172);
      END_STATE();
    case 14:
      if (lookahead == '1') ADVANCE(13);
      END_STATE();
    case 15:
      if (lookahead == '=') ADVANCE(200);
      END_STATE();
    case 16:
      if (lookahead == '=') ADVANCE(199);
      if (lookahead == '>') ADVANCE(148);
      END_STATE();
    case 17:
      if (lookahead == '=') ADVANCE(201);
      END_STATE();
    case 18:
      if (lookahead == '>') ADVANCE(147);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(50);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(86);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(52);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(56);
      END_STATE();
    case 23:
      if (lookahead == 'c') ADVANCE(87);
      if (lookahead == 'l') ADVANCE(49);
      if (lookahead == 'n') ADVANCE(27);
      if (lookahead == 's') ADVANCE(82);
      END_STATE();
    case 24:
      if (lookahead == 'c') ADVANCE(87);
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead == 's') ADVANCE(82);
      END_STATE();
    case 25:
      if (lookahead == 'c') ADVANCE(87);
      if (lookahead == 's') ADVANCE(82);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(202);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(202);
      if (lookahead == 'y') ADVANCE(210);
      END_STATE();
    case 28:
      if (lookahead == 'd') ADVANCE(96);
      END_STATE();
    case 29:
      if (lookahead == 'd') ADVANCE(42);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(57);
      if (lookahead == 'h') ADVANCE(41);
      if (lookahead == 'r') ADVANCE(95);
      if (lookahead == 'y') ADVANCE(76);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(57);
      if (lookahead == 'y') ADVANCE(76);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(179);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 43:
      if (lookahead == 'f') ADVANCE(212);
      if (lookahead == 'm') ADVANCE(74);
      END_STATE();
    case 44:
      if (lookahead == 'f') ADVANCE(166);
      END_STATE();
    case 45:
      if (lookahead == 'f') ADVANCE(206);
      END_STATE();
    case 46:
      if (lookahead == 'f') ADVANCE(45);
      if (lookahead == 'm') ADVANCE(74);
      END_STATE();
    case 47:
      if (lookahead == 'i') ADVANCE(40);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(73);
      END_STATE();
    case 49:
      if (lookahead == 'l') ADVANCE(208);
      END_STATE();
    case 50:
      if (lookahead == 'l') ADVANCE(165);
      if (lookahead == 'r') ADVANCE(162);
      END_STATE();
    case 51:
      if (lookahead == 'l') ADVANCE(173);
      END_STATE();
    case 52:
      if (lookahead == 'l') ADVANCE(168);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(81);
      END_STATE();
    case 54:
      if (lookahead == 'l') ADVANCE(47);
      END_STATE();
    case 55:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 56:
      if (lookahead == 'l') ADVANCE(84);
      END_STATE();
    case 57:
      if (lookahead == 'm') ADVANCE(75);
      END_STATE();
    case 58:
      if (lookahead == 'm') ADVANCE(38);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 60:
      if (lookahead == 'n') ADVANCE(214);
      END_STATE();
    case 61:
      if (lookahead == 'n') ADVANCE(167);
      END_STATE();
    case 62:
      if (lookahead == 'n') ADVANCE(85);
      END_STATE();
    case 63:
      if (lookahead == 'n') ADVANCE(29);
      END_STATE();
    case 64:
      if (lookahead == 'n') ADVANCE(83);
      END_STATE();
    case 65:
      if (lookahead == 'n') ADVANCE(26);
      END_STATE();
    case 66:
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 67:
      if (lookahead == 'o') ADVANCE(2);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 69:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 70:
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 71:
      if (lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 72:
      if (lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 73:
      if (lookahead == 'o') ADVANCE(61);
      END_STATE();
    case 74:
      if (lookahead == 'p') ADVANCE(54);
      END_STATE();
    case 75:
      if (lookahead == 'p') ADVANCE(71);
      END_STATE();
    case 76:
      if (lookahead == 'p') ADVANCE(36);
      END_STATE();
    case 77:
      if (lookahead == 'r') ADVANCE(204);
      END_STATE();
    case 78:
      if (lookahead == 'r') ADVANCE(21);
      END_STATE();
    case 79:
      if (lookahead == 'r') ADVANCE(34);
      END_STATE();
    case 80:
      if (lookahead == 's') ADVANCE(207);
      END_STATE();
    case 81:
      if (lookahead == 's') ADVANCE(33);
      END_STATE();
    case 82:
      if (lookahead == 's') ADVANCE(93);
      END_STATE();
    case 83:
      if (lookahead == 's') ADVANCE(88);
      END_STATE();
    case 84:
      if (lookahead == 's') ADVANCE(37);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(175);
      END_STATE();
    case 86:
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 87:
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(157);
      END_STATE();
    case 89:
      if (lookahead == 't') ADVANCE(216);
      END_STATE();
    case 90:
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 91:
      if (lookahead == 'u') ADVANCE(97);
      if (lookahead == 'x') ADVANCE(104);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(143);
      if (lookahead != 0) ADVANCE(140);
      END_STATE();
    case 92:
      if (lookahead == 'u') ADVANCE(79);
      END_STATE();
    case 93:
      if (lookahead == 'u') ADVANCE(58);
      END_STATE();
    case 94:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 95:
      if (lookahead == 'u') ADVANCE(35);
      END_STATE();
    case 96:
      if (lookahead == 'u') ADVANCE(55);
      END_STATE();
    case 97:
      if (lookahead == '{') ADVANCE(102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(103);
      END_STATE();
    case 98:
      if (lookahead == '}') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(98);
      END_STATE();
    case 99:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(185);
      END_STATE();
    case 100:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(140);
      END_STATE();
    case 101:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(184);
      END_STATE();
    case 102:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(98);
      END_STATE();
    case 103:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(104);
      END_STATE();
    case 104:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(100);
      END_STATE();
    case 105:
      if (eof) ADVANCE(108);
      ADVANCE_MAP(
        '!', 15,
        '"', 144,
        '%', 193,
        '\'', 3,
        '(', 151,
        ')', 152,
        '*', 191,
        '+', 194,
        ',', 163,
        '-', 187,
        '.', 189,
        '/', 192,
        '0', 186,
        '1', 183,
        ':', 158,
        ';', 170,
        '<', 195,
        '=', 160,
        '>', 196,
        'B', 72,
        'I', 62,
        'N', 20,
        '[', 149,
        ']', 150,
        '^', 190,
        'a', 23,
        'c', 68,
        'd', 30,
        'e', 53,
        'f', 22,
        'i', 43,
        'm', 66,
        'n', 69,
        'o', 77,
        'p', 92,
        'r', 94,
        't', 31,
        'v', 19,
        '{', 155,
        '|', 153,
        '}', 156,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(105);
      if (('2' <= lookahead && lookahead <= '9')) ADVANCE(185);
      END_STATE();
    case 106:
      if (eof) ADVANCE(108);
      ADVANCE_MAP(
        '!', 15,
        '"', 144,
        '%', 193,
        '\'', 3,
        '(', 151,
        ')', 152,
        '*', 191,
        '+', 194,
        ',', 163,
        '-', 187,
        '.', 188,
        '/', 192,
        ':', 158,
        ';', 170,
        '<', 195,
        '=', 16,
        '>', 196,
        '[', 149,
        ']', 150,
        '^', 190,
        'a', 24,
        'c', 68,
        'd', 30,
        'e', 53,
        'i', 46,
        'm', 66,
        'o', 77,
        'p', 92,
        'r', 94,
        't', 32,
        'v', 19,
        '}', 156,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(106);
      END_STATE();
    case 107:
      if (eof) ADVANCE(108);
      ADVANCE_MAP(
        '"', 144,
        '(', 151,
        ')', 152,
        ',', 163,
        '-', 18,
        '/', 7,
        '=', 161,
        '[', 149,
        ']', 150,
        'a', 25,
        'c', 68,
        'd', 30,
        'm', 66,
        'p', 92,
        'r', 94,
        't', 32,
        'v', 19,
        '|', 153,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(107);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(203);
      if (lookahead == 'y') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(118);
      if (lookahead == 'n') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(217);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(113);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '/') ADVANCE(138);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(139);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(135);
      if (lookahead == '/') ADVANCE(139);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(136);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(135);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(134);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(137);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(139);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(139);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(138);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(139);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(140);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(140);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(142);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != 0x2028 &&
          lookahead != 0x2029) ADVANCE(146);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_assume);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(199);
      if (lookahead == '>') ADVANCE(148);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(148);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_pure);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_val);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_action);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_temporal);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_run);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_1to10);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_Bool);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_Bool);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_Int);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_Int);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_Nat);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_Nat);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == ' ') ADVANCE(90);
      if (lookahead == '_') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(185);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(185);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(101);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(185);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(147);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(11);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(9);
      if (lookahead == '/') ADVANCE(146);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(198);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(197);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_SQUOTE_EQ);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_and);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_or);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_iff);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_implies);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_all);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_all);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_any);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == 'f') ADVANCE(206);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_nondet);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_nondet);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(133);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(218);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 4},
  [3] = {.lex_state = 4},
  [4] = {.lex_state = 4},
  [5] = {.lex_state = 4},
  [6] = {.lex_state = 4},
  [7] = {.lex_state = 4},
  [8] = {.lex_state = 4},
  [9] = {.lex_state = 4},
  [10] = {.lex_state = 4},
  [11] = {.lex_state = 4},
  [12] = {.lex_state = 4},
  [13] = {.lex_state = 4},
  [14] = {.lex_state = 4},
  [15] = {.lex_state = 4},
  [16] = {.lex_state = 4},
  [17] = {.lex_state = 4},
  [18] = {.lex_state = 106},
  [19] = {.lex_state = 4},
  [20] = {.lex_state = 4},
  [21] = {.lex_state = 4},
  [22] = {.lex_state = 4},
  [23] = {.lex_state = 4},
  [24] = {.lex_state = 4},
  [25] = {.lex_state = 4},
  [26] = {.lex_state = 4},
  [27] = {.lex_state = 4},
  [28] = {.lex_state = 4},
  [29] = {.lex_state = 4},
  [30] = {.lex_state = 4},
  [31] = {.lex_state = 4},
  [32] = {.lex_state = 4},
  [33] = {.lex_state = 4},
  [34] = {.lex_state = 4},
  [35] = {.lex_state = 4},
  [36] = {.lex_state = 4},
  [37] = {.lex_state = 4},
  [38] = {.lex_state = 4},
  [39] = {.lex_state = 4},
  [40] = {.lex_state = 4},
  [41] = {.lex_state = 4},
  [42] = {.lex_state = 4},
  [43] = {.lex_state = 4},
  [44] = {.lex_state = 4},
  [45] = {.lex_state = 4},
  [46] = {.lex_state = 4},
  [47] = {.lex_state = 4},
  [48] = {.lex_state = 4},
  [49] = {.lex_state = 4},
  [50] = {.lex_state = 4},
  [51] = {.lex_state = 4},
  [52] = {.lex_state = 4},
  [53] = {.lex_state = 4},
  [54] = {.lex_state = 4},
  [55] = {.lex_state = 4},
  [56] = {.lex_state = 4},
  [57] = {.lex_state = 4},
  [58] = {.lex_state = 4},
  [59] = {.lex_state = 4},
  [60] = {.lex_state = 4},
  [61] = {.lex_state = 4},
  [62] = {.lex_state = 4},
  [63] = {.lex_state = 4},
  [64] = {.lex_state = 4},
  [65] = {.lex_state = 4},
  [66] = {.lex_state = 4},
  [67] = {.lex_state = 4},
  [68] = {.lex_state = 4},
  [69] = {.lex_state = 4},
  [70] = {.lex_state = 106},
  [71] = {.lex_state = 4},
  [72] = {.lex_state = 4},
  [73] = {.lex_state = 4},
  [74] = {.lex_state = 4},
  [75] = {.lex_state = 4},
  [76] = {.lex_state = 4},
  [77] = {.lex_state = 4},
  [78] = {.lex_state = 4},
  [79] = {.lex_state = 4},
  [80] = {.lex_state = 4},
  [81] = {.lex_state = 4},
  [82] = {.lex_state = 4},
  [83] = {.lex_state = 4},
  [84] = {.lex_state = 106},
  [85] = {.lex_state = 4},
  [86] = {.lex_state = 4},
  [87] = {.lex_state = 4},
  [88] = {.lex_state = 106},
  [89] = {.lex_state = 4},
  [90] = {.lex_state = 4},
  [91] = {.lex_state = 4},
  [92] = {.lex_state = 4},
  [93] = {.lex_state = 4},
  [94] = {.lex_state = 4},
  [95] = {.lex_state = 4},
  [96] = {.lex_state = 4},
  [97] = {.lex_state = 4},
  [98] = {.lex_state = 4},
  [99] = {.lex_state = 4},
  [100] = {.lex_state = 4},
  [101] = {.lex_state = 4},
  [102] = {.lex_state = 4},
  [103] = {.lex_state = 4},
  [104] = {.lex_state = 4},
  [105] = {.lex_state = 4},
  [106] = {.lex_state = 4},
  [107] = {.lex_state = 4},
  [108] = {.lex_state = 4},
  [109] = {.lex_state = 4},
  [110] = {.lex_state = 4},
  [111] = {.lex_state = 4},
  [112] = {.lex_state = 4},
  [113] = {.lex_state = 4},
  [114] = {.lex_state = 4},
  [115] = {.lex_state = 4},
  [116] = {.lex_state = 4},
  [117] = {.lex_state = 4},
  [118] = {.lex_state = 4},
  [119] = {.lex_state = 4},
  [120] = {.lex_state = 4},
  [121] = {.lex_state = 4},
  [122] = {.lex_state = 4},
  [123] = {.lex_state = 4},
  [124] = {.lex_state = 4},
  [125] = {.lex_state = 4},
  [126] = {.lex_state = 4},
  [127] = {.lex_state = 4},
  [128] = {.lex_state = 4},
  [129] = {.lex_state = 4},
  [130] = {.lex_state = 4},
  [131] = {.lex_state = 4},
  [132] = {.lex_state = 4},
  [133] = {.lex_state = 4},
  [134] = {.lex_state = 4},
  [135] = {.lex_state = 4},
  [136] = {.lex_state = 4},
  [137] = {.lex_state = 4},
  [138] = {.lex_state = 4},
  [139] = {.lex_state = 4},
  [140] = {.lex_state = 106},
  [141] = {.lex_state = 106},
  [142] = {.lex_state = 106},
  [143] = {.lex_state = 106},
  [144] = {.lex_state = 106},
  [145] = {.lex_state = 106},
  [146] = {.lex_state = 106},
  [147] = {.lex_state = 106},
  [148] = {.lex_state = 106},
  [149] = {.lex_state = 106},
  [150] = {.lex_state = 106},
  [151] = {.lex_state = 106},
  [152] = {.lex_state = 106},
  [153] = {.lex_state = 106},
  [154] = {.lex_state = 106},
  [155] = {.lex_state = 106},
  [156] = {.lex_state = 106},
  [157] = {.lex_state = 106},
  [158] = {.lex_state = 106},
  [159] = {.lex_state = 106},
  [160] = {.lex_state = 106},
  [161] = {.lex_state = 106},
  [162] = {.lex_state = 106},
  [163] = {.lex_state = 106},
  [164] = {.lex_state = 106},
  [165] = {.lex_state = 106},
  [166] = {.lex_state = 106},
  [167] = {.lex_state = 106},
  [168] = {.lex_state = 106},
  [169] = {.lex_state = 106},
  [170] = {.lex_state = 106},
  [171] = {.lex_state = 106},
  [172] = {.lex_state = 106},
  [173] = {.lex_state = 106},
  [174] = {.lex_state = 106},
  [175] = {.lex_state = 106},
  [176] = {.lex_state = 106},
  [177] = {.lex_state = 106},
  [178] = {.lex_state = 106},
  [179] = {.lex_state = 106},
  [180] = {.lex_state = 106},
  [181] = {.lex_state = 106},
  [182] = {.lex_state = 106},
  [183] = {.lex_state = 106},
  [184] = {.lex_state = 106},
  [185] = {.lex_state = 106},
  [186] = {.lex_state = 106},
  [187] = {.lex_state = 106},
  [188] = {.lex_state = 106},
  [189] = {.lex_state = 106},
  [190] = {.lex_state = 106},
  [191] = {.lex_state = 106},
  [192] = {.lex_state = 106},
  [193] = {.lex_state = 106},
  [194] = {.lex_state = 106},
  [195] = {.lex_state = 106},
  [196] = {.lex_state = 106},
  [197] = {.lex_state = 106},
  [198] = {.lex_state = 106},
  [199] = {.lex_state = 106},
  [200] = {.lex_state = 106},
  [201] = {.lex_state = 106},
  [202] = {.lex_state = 106},
  [203] = {.lex_state = 106},
  [204] = {.lex_state = 106},
  [205] = {.lex_state = 106},
  [206] = {.lex_state = 106},
  [207] = {.lex_state = 106},
  [208] = {.lex_state = 106},
  [209] = {.lex_state = 106},
  [210] = {.lex_state = 106},
  [211] = {.lex_state = 106},
  [212] = {.lex_state = 106},
  [213] = {.lex_state = 106},
  [214] = {.lex_state = 106},
  [215] = {.lex_state = 106},
  [216] = {.lex_state = 106},
  [217] = {.lex_state = 106},
  [218] = {.lex_state = 106},
  [219] = {.lex_state = 106},
  [220] = {.lex_state = 106},
  [221] = {.lex_state = 106},
  [222] = {.lex_state = 106},
  [223] = {.lex_state = 106},
  [224] = {.lex_state = 106},
  [225] = {.lex_state = 106},
  [226] = {.lex_state = 106},
  [227] = {.lex_state = 106},
  [228] = {.lex_state = 106},
  [229] = {.lex_state = 106},
  [230] = {.lex_state = 106},
  [231] = {.lex_state = 106},
  [232] = {.lex_state = 106},
  [233] = {.lex_state = 106},
  [234] = {.lex_state = 106},
  [235] = {.lex_state = 106},
  [236] = {.lex_state = 106},
  [237] = {.lex_state = 106},
  [238] = {.lex_state = 106},
  [239] = {.lex_state = 106},
  [240] = {.lex_state = 106},
  [241] = {.lex_state = 106},
  [242] = {.lex_state = 106},
  [243] = {.lex_state = 106},
  [244] = {.lex_state = 106},
  [245] = {.lex_state = 106},
  [246] = {.lex_state = 106},
  [247] = {.lex_state = 106},
  [248] = {.lex_state = 106},
  [249] = {.lex_state = 106},
  [250] = {.lex_state = 106},
  [251] = {.lex_state = 106},
  [252] = {.lex_state = 106},
  [253] = {.lex_state = 106},
  [254] = {.lex_state = 106},
  [255] = {.lex_state = 106},
  [256] = {.lex_state = 106},
  [257] = {.lex_state = 106},
  [258] = {.lex_state = 106},
  [259] = {.lex_state = 106},
  [260] = {.lex_state = 106},
  [261] = {.lex_state = 106},
  [262] = {.lex_state = 106},
  [263] = {.lex_state = 106},
  [264] = {.lex_state = 106},
  [265] = {.lex_state = 1},
  [266] = {.lex_state = 106},
  [267] = {.lex_state = 106},
  [268] = {.lex_state = 106},
  [269] = {.lex_state = 106},
  [270] = {.lex_state = 106},
  [271] = {.lex_state = 106},
  [272] = {.lex_state = 106},
  [273] = {.lex_state = 106},
  [274] = {.lex_state = 106},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 106},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 106},
  [279] = {.lex_state = 106},
  [280] = {.lex_state = 106},
  [281] = {.lex_state = 106},
  [282] = {.lex_state = 106},
  [283] = {.lex_state = 106},
  [284] = {.lex_state = 106},
  [285] = {.lex_state = 106},
  [286] = {.lex_state = 106},
  [287] = {.lex_state = 106},
  [288] = {.lex_state = 106},
  [289] = {.lex_state = 106},
  [290] = {.lex_state = 1},
  [291] = {.lex_state = 106},
  [292] = {.lex_state = 106},
  [293] = {.lex_state = 106},
  [294] = {.lex_state = 1},
  [295] = {.lex_state = 1},
  [296] = {.lex_state = 1},
  [297] = {.lex_state = 1},
  [298] = {.lex_state = 1},
  [299] = {.lex_state = 1},
  [300] = {.lex_state = 1},
  [301] = {.lex_state = 1},
  [302] = {.lex_state = 1},
  [303] = {.lex_state = 1},
  [304] = {.lex_state = 1},
  [305] = {.lex_state = 1},
  [306] = {.lex_state = 1},
  [307] = {.lex_state = 1},
  [308] = {.lex_state = 1},
  [309] = {.lex_state = 1},
  [310] = {.lex_state = 1},
  [311] = {.lex_state = 1},
  [312] = {.lex_state = 1},
  [313] = {.lex_state = 1},
  [314] = {.lex_state = 1},
  [315] = {.lex_state = 1},
  [316] = {.lex_state = 1},
  [317] = {.lex_state = 1},
  [318] = {.lex_state = 1},
  [319] = {.lex_state = 1},
  [320] = {.lex_state = 1},
  [321] = {.lex_state = 1},
  [322] = {.lex_state = 1},
  [323] = {.lex_state = 1},
  [324] = {.lex_state = 1},
  [325] = {.lex_state = 1},
  [326] = {.lex_state = 1},
  [327] = {.lex_state = 1},
  [328] = {.lex_state = 1},
  [329] = {.lex_state = 1},
  [330] = {.lex_state = 1},
  [331] = {.lex_state = 1},
  [332] = {.lex_state = 1},
  [333] = {.lex_state = 1},
  [334] = {.lex_state = 1},
  [335] = {.lex_state = 1},
  [336] = {.lex_state = 1},
  [337] = {.lex_state = 1},
  [338] = {.lex_state = 1},
  [339] = {.lex_state = 1},
  [340] = {.lex_state = 106},
  [341] = {.lex_state = 1},
  [342] = {.lex_state = 1},
  [343] = {.lex_state = 1},
  [344] = {.lex_state = 1},
  [345] = {.lex_state = 1},
  [346] = {.lex_state = 1},
  [347] = {.lex_state = 1},
  [348] = {.lex_state = 107},
  [349] = {.lex_state = 106},
  [350] = {.lex_state = 107},
  [351] = {.lex_state = 106},
  [352] = {.lex_state = 107},
  [353] = {.lex_state = 106},
  [354] = {.lex_state = 106},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 106},
  [357] = {.lex_state = 106},
  [358] = {.lex_state = 106},
  [359] = {.lex_state = 106},
  [360] = {.lex_state = 106},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 106},
  [363] = {.lex_state = 107},
  [364] = {.lex_state = 106},
  [365] = {.lex_state = 106},
  [366] = {.lex_state = 107},
  [367] = {.lex_state = 107},
  [368] = {.lex_state = 107},
  [369] = {.lex_state = 107},
  [370] = {.lex_state = 107},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 12},
  [408] = {.lex_state = 12},
  [409] = {.lex_state = 12},
  [410] = {.lex_state = 12},
  [411] = {.lex_state = 12},
  [412] = {.lex_state = 12},
  [413] = {.lex_state = 12},
  [414] = {.lex_state = 12},
  [415] = {.lex_state = 12},
  [416] = {.lex_state = 12},
  [417] = {.lex_state = 12},
  [418] = {.lex_state = 12},
  [419] = {.lex_state = 12},
  [420] = {.lex_state = 12},
  [421] = {.lex_state = 12},
  [422] = {.lex_state = 12},
  [423] = {.lex_state = 12},
  [424] = {.lex_state = 12},
  [425] = {.lex_state = 12},
  [426] = {.lex_state = 12},
  [427] = {.lex_state = 12},
  [428] = {.lex_state = 12},
  [429] = {.lex_state = 12},
  [430] = {.lex_state = 12},
  [431] = {.lex_state = 12},
  [432] = {.lex_state = 12},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 4},
  [436] = {.lex_state = 6},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 6},
  [439] = {.lex_state = 4},
  [440] = {.lex_state = 0},
  [441] = {.lex_state = 4},
  [442] = {.lex_state = 4},
  [443] = {.lex_state = 6},
  [444] = {.lex_state = 6},
  [445] = {.lex_state = 6},
  [446] = {.lex_state = 6},
  [447] = {.lex_state = 6},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 4},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 0},
  [454] = {.lex_state = 4},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 0},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 4},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 0},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 0},
  [474] = {.lex_state = 4},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 4},
  [483] = {.lex_state = 0},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 4},
  [486] = {.lex_state = 4},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 4},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 4},
  [499] = {.lex_state = 4},
  [500] = {.lex_state = 4},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 4},
  [503] = {.lex_state = 4},
  [504] = {.lex_state = 4},
  [505] = {.lex_state = 12},
  [506] = {.lex_state = 12},
  [507] = {.lex_state = 4},
  [508] = {.lex_state = 12},
  [509] = {.lex_state = 12},
  [510] = {.lex_state = 4},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 12},
  [515] = {.lex_state = 0},
  [516] = {.lex_state = 12},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 4},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 12},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 4},
  [523] = {.lex_state = 12},
  [524] = {.lex_state = 4},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 12},
  [530] = {.lex_state = 4},
  [531] = {.lex_state = 12},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 12},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 12},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 12},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 12},
  [546] = {.lex_state = 12},
  [547] = {.lex_state = 12},
  [548] = {.lex_state = 0},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 12},
  [551] = {.lex_state = 12},
  [552] = {.lex_state = 12},
  [553] = {.lex_state = 4},
  [554] = {.lex_state = 12},
  [555] = {.lex_state = 12},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 4},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 4},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 12},
  [564] = {.lex_state = 12},
  [565] = {.lex_state = 12},
  [566] = {.lex_state = 12},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 12},
  [569] = {.lex_state = 12},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 12},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_assume] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_pure] = ACTIONS(1),
    [anon_sym_val] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_action] = ACTIONS(1),
    [anon_sym_temporal] = ACTIONS(1),
    [anon_sym_run] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_1to10] = ACTIONS(1),
    [anon_sym_Bool] = ACTIONS(1),
    [anon_sym_Int] = ACTIONS(1),
    [anon_sym_Nat] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_SQUOTE_EQ] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_iff] = ACTIONS(1),
    [anon_sym_implies] = ACTIONS(1),
    [anon_sym_all] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_nondet] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(515),
    [sym_string] = STATE(361),
    [sym_module_definition] = STATE(361),
    [sym_constant_declaration] = STATE(361),
    [sym_assumption] = STATE(361),
    [sym_variable_definition] = STATE(361),
    [sym_operator_definition] = STATE(361),
    [sym_type_alias] = STATE(361),
    [aux_sym_source_file_repeat1] = STATE(361),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_module] = ACTIONS(9),
    [anon_sym_const] = ACTIONS(11),
    [anon_sym_assume] = ACTIONS(13),
    [anon_sym_var] = ACTIONS(15),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_val] = ACTIONS(19),
    [anon_sym_def] = ACTIONS(19),
    [anon_sym_action] = ACTIONS(19),
    [anon_sym_temporal] = ACTIONS(19),
    [anon_sym_run] = ACTIONS(19),
    [anon_sym_type] = ACTIONS(21),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_RBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(293), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [80] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(57), 1,
      sym_identifier,
    ACTIONS(59), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(356), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [160] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(61), 1,
      anon_sym_RPAREN,
    STATE(291), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [240] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(63), 1,
      anon_sym_RBRACE,
    STATE(272), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [320] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(65), 1,
      anon_sym_RBRACE,
    STATE(273), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [400] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(67), 1,
      anon_sym_RBRACE,
    STATE(274), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [480] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(69), 1,
      anon_sym_RBRACE,
    STATE(276), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [560] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(71), 1,
      anon_sym_RBRACK,
    STATE(278), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [640] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(73), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [720] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(75), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [800] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(77), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [880] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(79), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [960] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(81), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [1040] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(83), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [1120] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(85), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [1200] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(87), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [1280] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 1,
      anon_sym_EQ_GT,
    ACTIONS(93), 1,
      anon_sym_LPAREN,
    ACTIONS(95), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(89), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [1330] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(97), 1,
      anon_sym_RBRACK,
    STATE(289), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [1410] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(99), 1,
      anon_sym_RPAREN,
    STATE(268), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [1490] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(101), 1,
      anon_sym_RPAREN,
    STATE(282), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [1570] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(103), 1,
      anon_sym_RBRACE,
    STATE(292), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [1650] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(105), 1,
      sym_identifier,
    ACTIONS(107), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(360), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [1730] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(109), 1,
      anon_sym_RBRACE,
    STATE(269), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [1810] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(111), 1,
      anon_sym_RBRACE,
    STATE(270), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [1890] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(113), 1,
      anon_sym_RPAREN,
    STATE(281), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [1970] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(115), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [2050] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(117), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [2130] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(119), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [2210] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(121), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [2290] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(123), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [2370] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(125), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [2450] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(127), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [2530] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(129), 1,
      anon_sym_RBRACK,
    STATE(279), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [2610] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(131), 1,
      anon_sym_RPAREN,
    STATE(280), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [2690] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
    STATE(283), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [2770] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(135), 1,
      anon_sym_RBRACE,
    STATE(284), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [2850] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(137), 1,
      anon_sym_RBRACE,
    STATE(285), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [2930] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(139), 1,
      anon_sym_RBRACE,
    STATE(286), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [3010] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(141), 1,
      anon_sym_RBRACE,
    STATE(287), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [3090] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(143), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [3170] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(145), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [3250] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(147), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [3330] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(149), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [3410] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(151), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [3490] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(153), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [3570] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(155), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [3650] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(157), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [3730] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(159), 1,
      sym_identifier,
    ACTIONS(161), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(357), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [3810] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    ACTIONS(163), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [3890] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(248), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [3967] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(310), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [4044] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(213), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [4121] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(214), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [4198] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(216), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [4275] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(219), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [4352] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(234), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [4429] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(233), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [4506] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(267), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [4583] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(236), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [4660] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(237), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [4737] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(351), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [4814] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(247), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [4891] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(340), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [4968] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(249), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [5045] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(190), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [5122] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(260), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [5199] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(258), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [5276] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(185), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [5353] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(229), 1,
      anon_sym_EQ_GT,
    ACTIONS(231), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(227), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [5400] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(152), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [5477] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(153), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [5554] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(155), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [5631] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(156), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [5708] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(157), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [5785] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(158), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [5862] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(159), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [5939] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(160), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [6016] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(161), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [6093] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(162), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [6170] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(259), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [6247] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(254), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [6324] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(167), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [6401] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(235), 1,
      anon_sym_EQ_GT,
    ACTIONS(237), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(233), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [6448] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(257), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [6525] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(255), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [6602] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(178), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [6679] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 1,
      anon_sym_EQ_GT,
    ACTIONS(243), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(239), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [6726] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(253), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [6803] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(186), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [6880] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(141), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [6957] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(143), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [7034] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(343), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [7111] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(311), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [7188] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(333), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [7265] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(334), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [7342] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(336), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [7419] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(294), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [7496] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(338), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [7573] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(339), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [7650] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(341), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [7727] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(342), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [7804] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(345), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [7881] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(337), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [7958] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(295), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [8035] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(346), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [8112] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(302), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [8189] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(313), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [8266] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(317), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [8343] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(261), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [8420] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(256), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [8497] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(252), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [8574] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(224), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [8651] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(353), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [8728] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(230), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [8805] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(354), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [8882] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(231), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [8959] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(241), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [9036] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(250), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [9113] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(197), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [9190] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(218), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [9267] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(221), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [9344] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(195), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [9421] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(196), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [9498] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(198), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [9575] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(199), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [9652] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(264), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [9729] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(202), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [9806] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(358), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [9883] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(271), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [9960] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(304), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [10037] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(359), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [10114] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(362), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [10191] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(288), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [10268] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_LBRACE,
    ACTIONS(205), 1,
      anon_sym_1to10,
    ACTIONS(211), 1,
      sym_int_literal,
    ACTIONS(213), 1,
      anon_sym_DASH,
    ACTIONS(215), 1,
      anon_sym_and,
    ACTIONS(217), 1,
      anon_sym_or,
    ACTIONS(219), 1,
      anon_sym_all,
    ACTIONS(221), 1,
      anon_sym_any,
    ACTIONS(223), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_nondet,
    STATE(328), 1,
      sym_expr,
    ACTIONS(209), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(207), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(347), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [10345] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(364), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [10422] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(365), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [10499] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      sym_identifier,
    ACTIONS(25), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_1to10,
    ACTIONS(41), 1,
      sym_int_literal,
    ACTIONS(43), 1,
      anon_sym_DASH,
    ACTIONS(45), 1,
      anon_sym_and,
    ACTIONS(47), 1,
      anon_sym_or,
    ACTIONS(49), 1,
      anon_sym_all,
    ACTIONS(51), 1,
      anon_sym_any,
    ACTIONS(53), 1,
      anon_sym_if,
    ACTIONS(55), 1,
      anon_sym_nondet,
    STATE(349), 1,
      sym_expr,
    ACTIONS(39), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(37), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(145), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [10576] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(165), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_LBRACK,
    ACTIONS(169), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_LBRACE,
    ACTIONS(173), 1,
      anon_sym_1to10,
    ACTIONS(179), 1,
      sym_int_literal,
    ACTIONS(181), 1,
      anon_sym_DASH,
    ACTIONS(183), 1,
      anon_sym_and,
    ACTIONS(185), 1,
      anon_sym_or,
    ACTIONS(187), 1,
      anon_sym_all,
    ACTIONS(189), 1,
      anon_sym_any,
    ACTIONS(191), 1,
      anon_sym_if,
    ACTIONS(193), 1,
      anon_sym_nondet,
    STATE(235), 1,
      sym_expr,
    ACTIONS(177), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(175), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(223), 17,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_nondet_choice,
      sym_record_literal,
      sym_tuple_literal,
      sym_list_literal,
  [10653] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(247), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(245), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [10697] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(253), 16,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_else,
  [10769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(281), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [10813] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 16,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_else,
  [10885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(287), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [10929] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(89), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [10973] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(291), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11017] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(295), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11061] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(301), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(299), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11105] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(303), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11149] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(309), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(307), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11193] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(311), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11237] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 17,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_else,
  [11307] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(317), 3,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(315), 27,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11361] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(317), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(315), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11405] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(317), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(315), 29,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11455] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(317), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(315), 29,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11505] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(317), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(315), 26,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11563] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 22,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11623] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 21,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11685] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 20,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11749] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 19,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11815] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 18,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_implies,
      anon_sym_else,
  [11883] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(321), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(319), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11927] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(325), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(323), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [11971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(329), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(327), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(331), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12059] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(335), 16,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_else,
  [12131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(339), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(337), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12175] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(341), 1,
      anon_sym_EQ_GT,
    ACTIONS(343), 1,
      anon_sym_LPAREN,
    ACTIONS(95), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(89), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [12223] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(347), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(345), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12267] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(351), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(349), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12311] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(355), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(353), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12355] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(359), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(357), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(363), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12443] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(367), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(365), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12487] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(371), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12531] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(373), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12575] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(377), 16,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_else,
  [12647] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(379), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(383), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12735] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(387), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12779] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(391), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12823] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(395), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(399), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [12911] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(403), 16,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_else,
  [12983] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(405), 16,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_else,
  [13055] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(407), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [13099] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(411), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [13143] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(417), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(415), 32,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [13187] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(421), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(419), 30,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [13235] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 1,
      anon_sym_EQ_GT,
    ACTIONS(237), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(233), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [13280] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 1,
      anon_sym_EQ_GT,
    ACTIONS(231), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(227), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [13325] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      anon_sym_EQ_GT,
    ACTIONS(243), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(239), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [13370] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(301), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(299), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [13412] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_iff,
      anon_sym_implies,
  [13476] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_implies,
  [13542] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 20,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [13600] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(459), 1,
      anon_sym_SEMI,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(455), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [13672] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(465), 1,
      anon_sym_SEMI,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(463), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [13744] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(329), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(327), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [13786] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(331), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [13828] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(335), 14,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
  [13898] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(303), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [13940] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(291), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [13982] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(347), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(345), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14024] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(351), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(349), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14066] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(339), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(337), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14108] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(355), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(353), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(359), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(357), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14192] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(363), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(361), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14234] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(309), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(307), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14276] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(367), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(365), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14318] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(469), 1,
      anon_sym_SEMI,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(467), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [14390] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(473), 1,
      anon_sym_SEMI,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(471), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [14462] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(375), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(373), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14504] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(377), 14,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
  [14574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(311), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14616] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 19,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14676] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(421), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(419), 28,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14722] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(383), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14764] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14826] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(379), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(89), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [14910] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(477), 1,
      anon_sym_SEMI,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(475), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [14982] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(391), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15024] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(395), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15066] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(295), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15108] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(247), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(245), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(399), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15192] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(315), 15,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
  [15260] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(317), 3,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(315), 25,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15312] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(317), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(315), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15354] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(481), 1,
      anon_sym_SEMI,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(479), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [15426] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(485), 1,
      anon_sym_SEMI,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(483), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [15498] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(405), 14,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
  [15568] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(489), 1,
      anon_sym_SEMI,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(487), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [15640] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(403), 14,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
  [15710] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(281), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(287), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15794] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(407), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15836] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(317), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(315), 27,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15884] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(411), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15926] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(417), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(415), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15968] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(321), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(319), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [16010] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(325), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(323), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [16052] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(371), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [16094] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(253), 14,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
  [16164] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(317), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(315), 27,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [16212] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(285), 14,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
  [16282] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(317), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(315), 24,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [16338] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(387), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [16380] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LBRACK,
    ACTIONS(431), 1,
      anon_sym_DASH,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(435), 1,
      anon_sym_CARET,
    ACTIONS(439), 1,
      anon_sym_SLASH,
    ACTIONS(441), 1,
      anon_sym_PLUS,
    ACTIONS(447), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(449), 1,
      anon_sym_and,
    ACTIONS(451), 1,
      anon_sym_or,
    ACTIONS(453), 1,
      anon_sym_iff,
    ACTIONS(457), 1,
      anon_sym_DASH_GT,
    ACTIONS(461), 1,
      anon_sym_implies,
    ACTIONS(437), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(443), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(491), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [16449] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(493), 1,
      anon_sym_SEMI,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(479), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [16519] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(495), 1,
      anon_sym_SEMI,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(463), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [16589] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(497), 1,
      anon_sym_SEMI,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(471), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [16659] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(499), 1,
      anon_sym_SEMI,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(475), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [16729] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(501), 1,
      anon_sym_SEMI,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(467), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [16799] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(503), 1,
      anon_sym_SEMI,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(487), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [16869] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(505), 1,
      anon_sym_SEMI,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(455), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [16939] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(507), 1,
      anon_sym_SEMI,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(483), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [17009] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(491), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [17076] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 1,
      anon_sym_EQ_GT,
    ACTIONS(93), 1,
      anon_sym_LPAREN,
    ACTIONS(509), 1,
      anon_sym_COLON,
    ACTIONS(95), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(89), 17,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [17114] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 1,
      anon_sym_EQ_GT,
    ACTIONS(93), 1,
      anon_sym_LPAREN,
    ACTIONS(511), 1,
      anon_sym_COLON,
    ACTIONS(95), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(89), 17,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [17152] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(513), 4,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [17212] = 5,
    ACTIONS(89), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(517), 1,
      anon_sym_EQ_GT,
    ACTIONS(519), 1,
      anon_sym_LPAREN,
    ACTIONS(95), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [17248] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 1,
      anon_sym_EQ_GT,
    ACTIONS(93), 1,
      anon_sym_LPAREN,
    ACTIONS(521), 1,
      anon_sym_COLON,
    ACTIONS(95), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(89), 17,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [17286] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(523), 1,
      anon_sym_RBRACE,
    ACTIONS(525), 1,
      anon_sym_COMMA,
    STATE(483), 1,
      aux_sym_record_literal_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [17349] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(527), 1,
      anon_sym_RPAREN,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    STATE(493), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [17412] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(531), 1,
      anon_sym_RBRACE,
    ACTIONS(533), 1,
      anon_sym_COMMA,
    STATE(458), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [17475] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(535), 1,
      anon_sym_RBRACE,
    ACTIONS(537), 1,
      anon_sym_COMMA,
    STATE(459), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [17538] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(525), 1,
      anon_sym_COMMA,
    ACTIONS(539), 1,
      anon_sym_RBRACE,
    STATE(460), 1,
      aux_sym_record_literal_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [17601] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(541), 1,
      anon_sym_RBRACE,
    ACTIONS(543), 1,
      anon_sym_COMMA,
    STATE(450), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [17664] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(545), 1,
      anon_sym_RBRACE,
    ACTIONS(547), 1,
      anon_sym_COMMA,
    STATE(457), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [17727] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(549), 1,
      anon_sym_RBRACE,
    ACTIONS(551), 1,
      anon_sym_COMMA,
    STATE(461), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [17790] = 4,
    ACTIONS(227), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(553), 1,
      anon_sym_EQ_GT,
    ACTIONS(231), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [17823] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(555), 1,
      anon_sym_RBRACE,
    ACTIONS(557), 1,
      anon_sym_COMMA,
    STATE(464), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [17886] = 4,
    ACTIONS(239), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(559), 1,
      anon_sym_EQ_GT,
    ACTIONS(243), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [17919] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(561), 1,
      anon_sym_RBRACK,
    STATE(465), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [17982] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(563), 1,
      anon_sym_RBRACK,
    STATE(467), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18045] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(565), 1,
      anon_sym_RPAREN,
    STATE(448), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18108] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(567), 1,
      anon_sym_RPAREN,
    STATE(471), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18171] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(569), 1,
      anon_sym_RPAREN,
    STATE(452), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18234] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(571), 1,
      anon_sym_RPAREN,
    STATE(496), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18297] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(573), 1,
      anon_sym_RBRACE,
    ACTIONS(575), 1,
      anon_sym_COMMA,
    STATE(475), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18360] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(577), 1,
      anon_sym_RBRACE,
    ACTIONS(579), 1,
      anon_sym_COMMA,
    STATE(477), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18423] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(581), 1,
      anon_sym_RBRACE,
    ACTIONS(583), 1,
      anon_sym_COMMA,
    STATE(478), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18486] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(585), 1,
      anon_sym_RBRACE,
    ACTIONS(587), 1,
      anon_sym_COMMA,
    STATE(480), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18549] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(525), 1,
      anon_sym_COMMA,
    ACTIONS(589), 1,
      anon_sym_RBRACE,
    STATE(481), 1,
      aux_sym_record_literal_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18612] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(591), 1,
      anon_sym_RBRACK,
    STATE(492), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18675] = 4,
    ACTIONS(233), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(593), 1,
      anon_sym_EQ_GT,
    ACTIONS(237), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [18708] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(595), 1,
      anon_sym_RPAREN,
    STATE(476), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18771] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(597), 1,
      anon_sym_RBRACE,
    ACTIONS(599), 1,
      anon_sym_COMMA,
    STATE(455), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18834] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(601), 1,
      anon_sym_RBRACE,
    ACTIONS(603), 1,
      anon_sym_COMMA,
    STATE(456), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18897] = 6,
    ACTIONS(315), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(317), 18,
      anon_sym_DASH_GT,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [18933] = 15,
    ACTIONS(335), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(611), 1,
      anon_sym_DASH_GT,
    ACTIONS(613), 1,
      anon_sym_SEMI,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(623), 1,
      anon_sym_and,
    ACTIONS(625), 1,
      anon_sym_or,
    ACTIONS(627), 1,
      anon_sym_iff,
    ACTIONS(629), 1,
      anon_sym_implies,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [18987] = 3,
    ACTIONS(383), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(385), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19017] = 3,
    ACTIONS(387), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(389), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19047] = 3,
    ACTIONS(391), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(393), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19077] = 3,
    ACTIONS(395), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(397), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19107] = 3,
    ACTIONS(399), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(401), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19137] = 3,
    ACTIONS(245), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(247), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19167] = 15,
    ACTIONS(405), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(611), 1,
      anon_sym_DASH_GT,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(623), 1,
      anon_sym_and,
    ACTIONS(625), 1,
      anon_sym_or,
    ACTIONS(627), 1,
      anon_sym_iff,
    ACTIONS(629), 1,
      anon_sym_implies,
    ACTIONS(631), 1,
      anon_sym_SEMI,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19221] = 3,
    ACTIONS(407), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(409), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19251] = 15,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(611), 1,
      anon_sym_DASH_GT,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(623), 1,
      anon_sym_and,
    ACTIONS(625), 1,
      anon_sym_or,
    ACTIONS(627), 1,
      anon_sym_iff,
    ACTIONS(629), 1,
      anon_sym_implies,
    ACTIONS(633), 1,
      anon_sym_SEMI,
    ACTIONS(635), 1,
      anon_sym_LF,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19305] = 3,
    ACTIONS(411), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(413), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19335] = 3,
    ACTIONS(415), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(417), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19365] = 3,
    ACTIONS(319), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(321), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19395] = 3,
    ACTIONS(369), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(371), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19425] = 3,
    ACTIONS(379), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(381), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19455] = 15,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(611), 1,
      anon_sym_DASH_GT,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(623), 1,
      anon_sym_and,
    ACTIONS(625), 1,
      anon_sym_or,
    ACTIONS(627), 1,
      anon_sym_iff,
    ACTIONS(629), 1,
      anon_sym_implies,
    ACTIONS(637), 1,
      anon_sym_SEMI,
    ACTIONS(639), 1,
      anon_sym_LF,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19509] = 15,
    ACTIONS(403), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(611), 1,
      anon_sym_DASH_GT,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(623), 1,
      anon_sym_and,
    ACTIONS(625), 1,
      anon_sym_or,
    ACTIONS(627), 1,
      anon_sym_iff,
    ACTIONS(629), 1,
      anon_sym_implies,
    ACTIONS(641), 1,
      anon_sym_SEMI,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19563] = 3,
    ACTIONS(323), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(325), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19593] = 15,
    ACTIONS(253), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(611), 1,
      anon_sym_DASH_GT,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(623), 1,
      anon_sym_and,
    ACTIONS(625), 1,
      anon_sym_or,
    ACTIONS(627), 1,
      anon_sym_iff,
    ACTIONS(629), 1,
      anon_sym_implies,
    ACTIONS(643), 1,
      anon_sym_SEMI,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19647] = 3,
    ACTIONS(281), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(283), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19677] = 3,
    ACTIONS(287), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(289), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19707] = 3,
    ACTIONS(337), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(339), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19737] = 15,
    ACTIONS(285), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(611), 1,
      anon_sym_DASH_GT,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(623), 1,
      anon_sym_and,
    ACTIONS(625), 1,
      anon_sym_or,
    ACTIONS(627), 1,
      anon_sym_iff,
    ACTIONS(629), 1,
      anon_sym_implies,
    ACTIONS(645), 1,
      anon_sym_SEMI,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19791] = 3,
    ACTIONS(327), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(329), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19821] = 3,
    ACTIONS(331), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(333), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19851] = 3,
    ACTIONS(345), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(347), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19881] = 3,
    ACTIONS(291), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(293), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19911] = 3,
    ACTIONS(349), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(351), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19941] = 3,
    ACTIONS(353), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(355), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [19971] = 3,
    ACTIONS(357), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(359), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20001] = 3,
    ACTIONS(361), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(363), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20031] = 3,
    ACTIONS(295), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(297), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20061] = 3,
    ACTIONS(299), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(301), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20091] = 15,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(611), 1,
      anon_sym_DASH_GT,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(623), 1,
      anon_sym_and,
    ACTIONS(625), 1,
      anon_sym_or,
    ACTIONS(627), 1,
      anon_sym_iff,
    ACTIONS(629), 1,
      anon_sym_implies,
    ACTIONS(647), 1,
      anon_sym_SEMI,
    ACTIONS(649), 1,
      anon_sym_LF,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [20145] = 3,
    ACTIONS(303), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(305), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20175] = 3,
    ACTIONS(365), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(367), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20205] = 3,
    ACTIONS(307), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(309), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20235] = 3,
    ACTIONS(311), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(313), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20265] = 14,
    ACTIONS(315), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(623), 1,
      anon_sym_and,
    ACTIONS(625), 1,
      anon_sym_or,
    ACTIONS(627), 1,
      anon_sym_iff,
    ACTIONS(629), 1,
      anon_sym_implies,
    ACTIONS(317), 2,
      anon_sym_DASH_GT,
      anon_sym_SEMI,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [20317] = 7,
    ACTIONS(315), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(317), 15,
      anon_sym_DASH_GT,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20355] = 3,
    ACTIONS(315), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(317), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20385] = 6,
    ACTIONS(315), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(317), 18,
      anon_sym_DASH_GT,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20421] = 13,
    ACTIONS(315), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(623), 1,
      anon_sym_and,
    ACTIONS(625), 1,
      anon_sym_or,
    ACTIONS(627), 1,
      anon_sym_iff,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(317), 3,
      anon_sym_DASH_GT,
      anon_sym_SEMI,
      anon_sym_implies,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [20471] = 8,
    ACTIONS(315), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(317), 13,
      anon_sym_DASH_GT,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20511] = 9,
    ACTIONS(315), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(317), 7,
      anon_sym_DASH_GT,
      anon_sym_SEMI,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20553] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(651), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [20611] = 10,
    ACTIONS(315), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(317), 6,
      anon_sym_DASH_GT,
      anon_sym_SEMI,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [20655] = 11,
    ACTIONS(315), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(623), 1,
      anon_sym_and,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(317), 5,
      anon_sym_DASH_GT,
      anon_sym_SEMI,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [20701] = 5,
    ACTIONS(419), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(421), 19,
      anon_sym_DASH_GT,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20735] = 3,
    ACTIONS(373), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(375), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20765] = 12,
    ACTIONS(315), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(623), 1,
      anon_sym_and,
    ACTIONS(625), 1,
      anon_sym_or,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(317), 4,
      anon_sym_DASH_GT,
      anon_sym_SEMI,
      anon_sym_iff,
      anon_sym_implies,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [20813] = 15,
    ACTIONS(377), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_LBRACK,
    ACTIONS(607), 1,
      anon_sym_DOT,
    ACTIONS(609), 1,
      anon_sym_CARET,
    ACTIONS(611), 1,
      anon_sym_DASH_GT,
    ACTIONS(621), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(623), 1,
      anon_sym_and,
    ACTIONS(625), 1,
      anon_sym_or,
    ACTIONS(627), 1,
      anon_sym_iff,
    ACTIONS(629), 1,
      anon_sym_implies,
    ACTIONS(653), 1,
      anon_sym_SEMI,
    ACTIONS(615), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(617), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(619), 6,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [20867] = 3,
    ACTIONS(89), 1,
      anon_sym_LF,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(95), 21,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_CARET,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [20897] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(657), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym_LPAREN,
    ACTIONS(661), 1,
      anon_sym_EQ,
    ACTIONS(655), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [20930] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(663), 1,
      anon_sym_RPAREN,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [20987] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(667), 1,
      anon_sym_PIPE,
    ACTIONS(670), 1,
      anon_sym_EQ,
    STATE(350), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(665), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [21020] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(672), 1,
      anon_sym_else,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [21077] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 1,
      anon_sym_PIPE,
    ACTIONS(678), 1,
      anon_sym_EQ,
    STATE(363), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(674), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [21110] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(680), 1,
      anon_sym_RPAREN,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [21167] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(682), 1,
      anon_sym_RBRACK,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [21224] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 1,
      ts_builtin_sym_end,
    ACTIONS(686), 1,
      anon_sym_DQUOTE,
    ACTIONS(689), 1,
      anon_sym_module,
    ACTIONS(692), 1,
      anon_sym_const,
    ACTIONS(695), 1,
      anon_sym_assume,
    ACTIONS(698), 1,
      anon_sym_var,
    ACTIONS(701), 1,
      anon_sym_pure,
    ACTIONS(707), 1,
      anon_sym_type,
    ACTIONS(704), 5,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
    STATE(355), 8,
      sym_string,
      sym_module_definition,
      sym_constant_declaration,
      sym_assumption,
      sym_variable_definition,
      sym_operator_definition,
      sym_type_alias,
      aux_sym_source_file_repeat1,
  [21269] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(710), 1,
      anon_sym_RBRACE,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [21326] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(712), 1,
      anon_sym_RBRACE,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [21383] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(714), 1,
      anon_sym_RBRACK,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [21440] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(716), 1,
      anon_sym_else,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [21497] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(718), 1,
      anon_sym_RBRACE,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [21554] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(9), 1,
      anon_sym_module,
    ACTIONS(11), 1,
      anon_sym_const,
    ACTIONS(13), 1,
      anon_sym_assume,
    ACTIONS(15), 1,
      anon_sym_var,
    ACTIONS(17), 1,
      anon_sym_pure,
    ACTIONS(21), 1,
      anon_sym_type,
    ACTIONS(720), 1,
      ts_builtin_sym_end,
    ACTIONS(19), 5,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
    STATE(355), 8,
      sym_string,
      sym_module_definition,
      sym_constant_declaration,
      sym_assumption,
      sym_variable_definition,
      sym_operator_definition,
      sym_type_alias,
      aux_sym_source_file_repeat1,
  [21599] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(722), 1,
      anon_sym_RBRACK,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [21656] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 1,
      anon_sym_PIPE,
    ACTIONS(726), 1,
      anon_sym_EQ,
    STATE(350), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(724), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [21689] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(728), 1,
      anon_sym_else,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [21746] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      anon_sym_DASH_GT,
    ACTIONS(251), 1,
      anon_sym_LBRACK,
    ACTIONS(255), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      anon_sym_DOT,
    ACTIONS(259), 1,
      anon_sym_CARET,
    ACTIONS(263), 1,
      anon_sym_SLASH,
    ACTIONS(265), 1,
      anon_sym_PLUS,
    ACTIONS(271), 1,
      anon_sym_SQUOTE_EQ,
    ACTIONS(273), 1,
      anon_sym_and,
    ACTIONS(275), 1,
      anon_sym_or,
    ACTIONS(277), 1,
      anon_sym_iff,
    ACTIONS(279), 1,
      anon_sym_implies,
    ACTIONS(730), 1,
      anon_sym_RPAREN,
    ACTIONS(261), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(267), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [21803] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 1,
      anon_sym_EQ,
    ACTIONS(732), 19,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_PIPE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [21831] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(740), 1,
      anon_sym_EQ,
    ACTIONS(736), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [21860] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(746), 1,
      anon_sym_EQ,
    ACTIONS(742), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [21891] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      anon_sym_EQ,
    ACTIONS(748), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [21918] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 1,
      anon_sym_EQ,
    ACTIONS(655), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_COMMA,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [21945] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 1,
      anon_sym_RBRACE,
    ACTIONS(754), 1,
      anon_sym_const,
    ACTIONS(756), 1,
      anon_sym_assume,
    ACTIONS(758), 1,
      anon_sym_var,
    ACTIONS(760), 1,
      anon_sym_pure,
    ACTIONS(764), 1,
      anon_sym_type,
    ACTIONS(762), 5,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
    STATE(372), 6,
      sym_constant_declaration,
      sym_assumption,
      sym_variable_definition,
      sym_operator_definition,
      sym_type_alias,
      aux_sym_module_definition_repeat1,
  [21982] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 1,
      anon_sym_const,
    ACTIONS(756), 1,
      anon_sym_assume,
    ACTIONS(758), 1,
      anon_sym_var,
    ACTIONS(760), 1,
      anon_sym_pure,
    ACTIONS(764), 1,
      anon_sym_type,
    ACTIONS(766), 1,
      anon_sym_RBRACE,
    ACTIONS(762), 5,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
    STATE(373), 6,
      sym_constant_declaration,
      sym_assumption,
      sym_variable_definition,
      sym_operator_definition,
      sym_type_alias,
      aux_sym_module_definition_repeat1,
  [22019] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 1,
      anon_sym_RBRACE,
    ACTIONS(770), 1,
      anon_sym_const,
    ACTIONS(773), 1,
      anon_sym_assume,
    ACTIONS(776), 1,
      anon_sym_var,
    ACTIONS(779), 1,
      anon_sym_pure,
    ACTIONS(785), 1,
      anon_sym_type,
    ACTIONS(782), 5,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
    STATE(373), 6,
      sym_constant_declaration,
      sym_assumption,
      sym_variable_definition,
      sym_operator_definition,
      sym_type_alias,
      aux_sym_module_definition_repeat1,
  [22056] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 1,
      anon_sym_LBRACK,
    ACTIONS(790), 1,
      anon_sym_LPAREN,
    ACTIONS(655), 13,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22081] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(792), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22106] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 1,
      anon_sym_PIPE,
    STATE(376), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(665), 13,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22131] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(797), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22156] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 1,
      anon_sym_PIPE,
    STATE(376), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(724), 13,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22181] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(801), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22206] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 1,
      anon_sym_PIPE,
    STATE(378), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(674), 13,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22231] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 14,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22251] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      anon_sym_DASH_GT,
    ACTIONS(805), 1,
      anon_sym_EQ_GT,
    ACTIONS(742), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22274] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22293] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(809), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22312] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      anon_sym_DASH_GT,
    ACTIONS(736), 12,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22333] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      anon_sym_DASH_GT,
    ACTIONS(805), 1,
      anon_sym_EQ_GT,
    ACTIONS(792), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22356] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22375] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(813), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22394] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(655), 13,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22413] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22432] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(817), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22451] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22470] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22489] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      anon_sym_DASH_GT,
    ACTIONS(805), 1,
      anon_sym_EQ_GT,
    ACTIONS(801), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22512] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 13,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22531] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22550] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 1,
      anon_sym_DASH_GT,
    ACTIONS(805), 1,
      anon_sym_EQ_GT,
    ACTIONS(797), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22573] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(825), 13,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22592] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22609] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(825), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22626] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(823), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22643] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(813), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22660] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22677] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22694] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(809), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22711] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 11,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_run,
      anon_sym_type,
  [22728] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(368), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22744] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(367), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22760] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(829), 1,
      sym_identifier,
    STATE(386), 1,
      sym_type,
    STATE(389), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22776] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(829), 1,
      sym_identifier,
    STATE(394), 1,
      sym_type,
    STATE(389), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22792] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(379), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22808] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(829), 1,
      sym_identifier,
    STATE(397), 1,
      sym_type,
    STATE(389), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22824] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(454), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22840] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(377), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22856] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(375), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22872] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(491), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22888] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(484), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22904] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(440), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22920] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(474), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22936] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(829), 1,
      sym_identifier,
    STATE(382), 1,
      sym_type,
    STATE(389), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22952] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(433), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22968] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(494), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [22984] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(482), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [23000] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(485), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [23016] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(486), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [23032] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(489), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [23048] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(490), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [23064] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(451), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [23080] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(466), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [23096] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(462), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [23112] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      sym_identifier,
    STATE(495), 1,
      sym_type,
    STATE(370), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [23128] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(829), 1,
      sym_identifier,
    STATE(385), 1,
      sym_type,
    STATE(389), 4,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_sum_type,
  [23144] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(831), 1,
      anon_sym_RPAREN,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    STATE(469), 1,
      aux_sym_typed_argument_list_repeat1,
  [23163] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(513), 3,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [23178] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 1,
      anon_sym_LPAREN,
    ACTIONS(840), 1,
      anon_sym_COLON,
    ACTIONS(842), 1,
      anon_sym_EQ,
    STATE(504), 1,
      sym_typed_argument_list,
  [23194] = 4,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(847), 1,
      anon_sym_DQUOTE,
    STATE(436), 1,
      aux_sym_string_repeat1,
    ACTIONS(844), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [23208] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(849), 1,
      anon_sym_RPAREN,
    ACTIONS(851), 1,
      anon_sym_COLON,
    STATE(488), 1,
      aux_sym_typed_argument_list_repeat1,
  [23224] = 4,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(855), 1,
      anon_sym_DQUOTE,
    STATE(436), 1,
      aux_sym_string_repeat1,
    ACTIONS(853), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [23238] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 1,
      anon_sym_LPAREN,
    ACTIONS(857), 1,
      anon_sym_COLON,
    ACTIONS(859), 1,
      anon_sym_EQ,
    STATE(498), 1,
      sym_typed_argument_list,
  [23254] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(861), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [23268] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 1,
      anon_sym_LPAREN,
    ACTIONS(863), 1,
      anon_sym_COLON,
    ACTIONS(865), 1,
      anon_sym_EQ,
    STATE(500), 1,
      sym_typed_argument_list,
  [23284] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 1,
      anon_sym_LPAREN,
    ACTIONS(867), 1,
      anon_sym_COLON,
    ACTIONS(869), 1,
      anon_sym_EQ,
    STATE(502), 1,
      sym_typed_argument_list,
  [23300] = 4,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(873), 1,
      anon_sym_DQUOTE,
    STATE(444), 1,
      aux_sym_string_repeat1,
    ACTIONS(871), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [23314] = 4,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_DQUOTE,
    STATE(436), 1,
      aux_sym_string_repeat1,
    ACTIONS(853), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [23328] = 4,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(879), 1,
      anon_sym_DQUOTE,
    STATE(447), 1,
      aux_sym_string_repeat1,
    ACTIONS(877), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [23342] = 4,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(883), 1,
      anon_sym_DQUOTE,
    STATE(438), 1,
      aux_sym_string_repeat1,
    ACTIONS(881), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [23356] = 4,
    ACTIONS(515), 1,
      sym_comment,
    ACTIONS(885), 1,
      anon_sym_DQUOTE,
    STATE(436), 1,
      aux_sym_string_repeat1,
    ACTIONS(853), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [23370] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(887), 1,
      anon_sym_RPAREN,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23383] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 1,
      anon_sym_RBRACE,
    ACTIONS(525), 1,
      anon_sym_COMMA,
    STATE(487), 1,
      aux_sym_record_literal_repeat1,
  [23396] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 1,
      anon_sym_RBRACE,
    ACTIONS(889), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23409] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(891), 1,
      anon_sym_EQ,
  [23422] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(893), 1,
      anon_sym_RPAREN,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23435] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 1,
      anon_sym_COMMA,
    ACTIONS(539), 1,
      anon_sym_RBRACE,
    STATE(487), 1,
      aux_sym_record_literal_repeat1,
  [23448] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(895), 1,
      anon_sym_EQ,
  [23461] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_RBRACE,
    ACTIONS(897), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23474] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(115), 1,
      anon_sym_RBRACE,
    ACTIONS(899), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23487] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      anon_sym_RBRACE,
    ACTIONS(901), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23500] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(117), 1,
      anon_sym_RBRACE,
    ACTIONS(903), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23513] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 1,
      anon_sym_RBRACE,
    ACTIONS(905), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23526] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 1,
      anon_sym_COMMA,
    ACTIONS(907), 1,
      anon_sym_RBRACE,
    STATE(487), 1,
      aux_sym_record_literal_repeat1,
  [23539] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      anon_sym_RBRACE,
    ACTIONS(909), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23552] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(911), 1,
      anon_sym_RPAREN,
  [23565] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      anon_sym_COLON,
    ACTIONS(913), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [23576] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_RBRACE,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23589] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(919), 1,
      anon_sym_RBRACK,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23602] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(921), 1,
      anon_sym_EQ,
  [23615] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(923), 1,
      anon_sym_RBRACK,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23628] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 1,
      anon_sym_COMMA,
    ACTIONS(925), 1,
      anon_sym_RBRACE,
    STATE(473), 1,
      aux_sym_record_literal_repeat1,
  [23641] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(927), 1,
      anon_sym_RPAREN,
    STATE(479), 1,
      aux_sym_typed_argument_list_repeat1,
  [23654] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 1,
      anon_sym_COMMA,
    ACTIONS(929), 1,
      anon_sym_RBRACE,
    STATE(449), 1,
      aux_sym_record_literal_repeat1,
  [23667] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(931), 1,
      anon_sym_RPAREN,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23680] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 1,
      anon_sym_COMMA,
    ACTIONS(933), 1,
      anon_sym_RBRACE,
    STATE(453), 1,
      aux_sym_record_literal_repeat1,
  [23693] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 1,
      anon_sym_COMMA,
    ACTIONS(589), 1,
      anon_sym_RBRACE,
    STATE(487), 1,
      aux_sym_record_literal_repeat1,
  [23706] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(935), 1,
      anon_sym_EQ,
  [23719] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 1,
      anon_sym_RBRACE,
    ACTIONS(937), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23732] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(939), 1,
      anon_sym_RPAREN,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23745] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(145), 1,
      anon_sym_RBRACE,
    ACTIONS(941), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23758] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(147), 1,
      anon_sym_RBRACE,
    ACTIONS(943), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23771] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      anon_sym_RPAREN,
    ACTIONS(945), 1,
      anon_sym_COMMA,
    STATE(479), 1,
      aux_sym_typed_argument_list_repeat1,
  [23784] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(149), 1,
      anon_sym_RBRACE,
    ACTIONS(948), 1,
      anon_sym_COMMA,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23797] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 1,
      anon_sym_COMMA,
    ACTIONS(950), 1,
      anon_sym_RBRACE,
    STATE(487), 1,
      aux_sym_record_literal_repeat1,
  [23810] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(952), 1,
      anon_sym_EQ,
  [23823] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 1,
      anon_sym_COMMA,
    ACTIONS(954), 1,
      anon_sym_RBRACE,
    STATE(487), 1,
      aux_sym_record_literal_repeat1,
  [23836] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(956), 1,
      anon_sym_RPAREN,
  [23849] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(958), 1,
      anon_sym_EQ,
  [23862] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(960), 1,
      anon_sym_EQ,
  [23875] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 1,
      anon_sym_RBRACE,
    ACTIONS(964), 1,
      anon_sym_COMMA,
    STATE(487), 1,
      aux_sym_record_literal_repeat1,
  [23888] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_COMMA,
    ACTIONS(967), 1,
      anon_sym_RPAREN,
    STATE(479), 1,
      aux_sym_typed_argument_list_repeat1,
  [23901] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(969), 1,
      anon_sym_RBRACK,
  [23914] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(971), 1,
      anon_sym_RPAREN,
  [23927] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(973), 1,
      anon_sym_EQ,
  [23940] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(975), 1,
      anon_sym_RBRACK,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23953] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(977), 1,
      anon_sym_RPAREN,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [23966] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(979), 1,
      anon_sym_RBRACK,
  [23979] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_DASH_GT,
    ACTIONS(744), 1,
      anon_sym_EQ_GT,
    ACTIONS(981), 1,
      anon_sym_RPAREN,
  [23992] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(983), 1,
      anon_sym_RPAREN,
    STATE(434), 1,
      aux_sym_lambda_expr_repeat1,
  [24005] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(985), 2,
      anon_sym_val,
      anon_sym_def,
  [24013] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(987), 1,
      anon_sym_COLON,
    ACTIONS(989), 1,
      anon_sym_EQ,
  [24023] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(991), 2,
      anon_sym_COLON,
      anon_sym_EQ,
  [24031] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(993), 1,
      anon_sym_COLON,
    ACTIONS(995), 1,
      anon_sym_EQ,
  [24041] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(997), 2,
      anon_sym_val,
      anon_sym_def,
  [24049] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(999), 1,
      anon_sym_COLON,
    ACTIONS(1001), 1,
      anon_sym_EQ,
  [24059] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 2,
      anon_sym_COLON,
      anon_sym_EQ,
  [24067] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1005), 1,
      anon_sym_COLON,
    ACTIONS(1007), 1,
      anon_sym_EQ,
  [24077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 1,
      sym_identifier,
    STATE(154), 1,
      sym_operator_application,
  [24087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1011), 1,
      sym_identifier,
    STATE(335), 1,
      sym_operator_application,
  [24097] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1013), 2,
      anon_sym_COLON,
      anon_sym_EQ,
  [24105] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1015), 1,
      sym_identifier,
    STATE(232), 1,
      sym_operator_application,
  [24115] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      sym_identifier,
    ACTIONS(1019), 1,
      anon_sym_DOT_DOT_DOT,
  [24125] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1021), 2,
      anon_sym_COLON,
      anon_sym_EQ,
  [24133] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1023), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [24141] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1025), 1,
      anon_sym_COLON,
  [24148] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1027), 1,
      anon_sym_COLON,
  [24155] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1029), 1,
      sym_identifier,
  [24162] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1031), 1,
      ts_builtin_sym_end,
  [24169] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1033), 1,
      sym_identifier,
  [24176] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1035), 1,
      anon_sym_COLON,
  [24183] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1037), 1,
      anon_sym_EQ,
  [24190] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1039), 1,
      anon_sym_COLON,
  [24197] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 1,
      sym_identifier,
  [24204] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      anon_sym_LPAREN,
  [24211] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1043), 1,
      anon_sym_EQ,
  [24218] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1045), 1,
      sym_identifier,
  [24225] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_EQ,
  [24232] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1049), 1,
      anon_sym_LBRACE,
  [24239] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 1,
      anon_sym_LBRACE,
  [24246] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1053), 1,
      anon_sym_LBRACE,
  [24253] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1055), 1,
      anon_sym_LBRACE,
  [24260] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1057), 1,
      sym_identifier,
  [24267] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1059), 1,
      anon_sym_EQ,
  [24274] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1061), 1,
      sym_identifier,
  [24281] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_LPAREN,
  [24288] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1065), 1,
      sym_identifier,
  [24295] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1067), 1,
      anon_sym_COLON,
  [24302] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1069), 1,
      anon_sym_LPAREN,
  [24309] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1071), 1,
      sym_identifier,
  [24316] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(343), 1,
      anon_sym_LPAREN,
  [24323] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1073), 1,
      sym_identifier,
  [24330] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1075), 1,
      anon_sym_LPAREN,
  [24337] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1077), 1,
      anon_sym_LBRACE,
  [24344] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1079), 1,
      anon_sym_LBRACE,
  [24351] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1081), 1,
      anon_sym_LBRACE,
  [24358] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1083), 1,
      anon_sym_LBRACE,
  [24365] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_LBRACE,
  [24372] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1087), 1,
      sym_identifier,
  [24379] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 1,
      sym_identifier,
  [24386] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1091), 1,
      sym_identifier,
  [24393] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      anon_sym_LBRACE,
  [24400] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1095), 1,
      anon_sym_LBRACE,
  [24407] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1097), 1,
      sym_identifier,
  [24414] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1099), 1,
      sym_identifier,
  [24421] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1101), 1,
      sym_identifier,
  [24428] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      anon_sym_EQ,
  [24435] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1105), 1,
      sym_identifier,
  [24442] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1107), 1,
      sym_identifier,
  [24449] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1109), 1,
      anon_sym_LBRACE,
  [24456] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1111), 1,
      anon_sym_EQ,
  [24463] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1113), 1,
      anon_sym_then,
  [24470] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1115), 1,
      anon_sym_LPAREN,
  [24477] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1117), 1,
      anon_sym_then,
  [24484] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1119), 1,
      anon_sym_EQ,
  [24491] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1121), 1,
      anon_sym_then,
  [24498] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1123), 1,
      sym_identifier,
  [24505] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1125), 1,
      sym_identifier,
  [24512] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1127), 1,
      sym_identifier,
  [24519] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1129), 1,
      sym_identifier,
  [24526] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1131), 1,
      anon_sym_LBRACE,
  [24533] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1133), 1,
      sym_identifier,
  [24540] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 1,
      sym_identifier,
  [24547] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1137), 1,
      anon_sym_LPAREN,
  [24554] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1139), 1,
      anon_sym_LPAREN,
  [24561] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1141), 1,
      sym_identifier,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 80,
  [SMALL_STATE(4)] = 160,
  [SMALL_STATE(5)] = 240,
  [SMALL_STATE(6)] = 320,
  [SMALL_STATE(7)] = 400,
  [SMALL_STATE(8)] = 480,
  [SMALL_STATE(9)] = 560,
  [SMALL_STATE(10)] = 640,
  [SMALL_STATE(11)] = 720,
  [SMALL_STATE(12)] = 800,
  [SMALL_STATE(13)] = 880,
  [SMALL_STATE(14)] = 960,
  [SMALL_STATE(15)] = 1040,
  [SMALL_STATE(16)] = 1120,
  [SMALL_STATE(17)] = 1200,
  [SMALL_STATE(18)] = 1280,
  [SMALL_STATE(19)] = 1330,
  [SMALL_STATE(20)] = 1410,
  [SMALL_STATE(21)] = 1490,
  [SMALL_STATE(22)] = 1570,
  [SMALL_STATE(23)] = 1650,
  [SMALL_STATE(24)] = 1730,
  [SMALL_STATE(25)] = 1810,
  [SMALL_STATE(26)] = 1890,
  [SMALL_STATE(27)] = 1970,
  [SMALL_STATE(28)] = 2050,
  [SMALL_STATE(29)] = 2130,
  [SMALL_STATE(30)] = 2210,
  [SMALL_STATE(31)] = 2290,
  [SMALL_STATE(32)] = 2370,
  [SMALL_STATE(33)] = 2450,
  [SMALL_STATE(34)] = 2530,
  [SMALL_STATE(35)] = 2610,
  [SMALL_STATE(36)] = 2690,
  [SMALL_STATE(37)] = 2770,
  [SMALL_STATE(38)] = 2850,
  [SMALL_STATE(39)] = 2930,
  [SMALL_STATE(40)] = 3010,
  [SMALL_STATE(41)] = 3090,
  [SMALL_STATE(42)] = 3170,
  [SMALL_STATE(43)] = 3250,
  [SMALL_STATE(44)] = 3330,
  [SMALL_STATE(45)] = 3410,
  [SMALL_STATE(46)] = 3490,
  [SMALL_STATE(47)] = 3570,
  [SMALL_STATE(48)] = 3650,
  [SMALL_STATE(49)] = 3730,
  [SMALL_STATE(50)] = 3810,
  [SMALL_STATE(51)] = 3890,
  [SMALL_STATE(52)] = 3967,
  [SMALL_STATE(53)] = 4044,
  [SMALL_STATE(54)] = 4121,
  [SMALL_STATE(55)] = 4198,
  [SMALL_STATE(56)] = 4275,
  [SMALL_STATE(57)] = 4352,
  [SMALL_STATE(58)] = 4429,
  [SMALL_STATE(59)] = 4506,
  [SMALL_STATE(60)] = 4583,
  [SMALL_STATE(61)] = 4660,
  [SMALL_STATE(62)] = 4737,
  [SMALL_STATE(63)] = 4814,
  [SMALL_STATE(64)] = 4891,
  [SMALL_STATE(65)] = 4968,
  [SMALL_STATE(66)] = 5045,
  [SMALL_STATE(67)] = 5122,
  [SMALL_STATE(68)] = 5199,
  [SMALL_STATE(69)] = 5276,
  [SMALL_STATE(70)] = 5353,
  [SMALL_STATE(71)] = 5400,
  [SMALL_STATE(72)] = 5477,
  [SMALL_STATE(73)] = 5554,
  [SMALL_STATE(74)] = 5631,
  [SMALL_STATE(75)] = 5708,
  [SMALL_STATE(76)] = 5785,
  [SMALL_STATE(77)] = 5862,
  [SMALL_STATE(78)] = 5939,
  [SMALL_STATE(79)] = 6016,
  [SMALL_STATE(80)] = 6093,
  [SMALL_STATE(81)] = 6170,
  [SMALL_STATE(82)] = 6247,
  [SMALL_STATE(83)] = 6324,
  [SMALL_STATE(84)] = 6401,
  [SMALL_STATE(85)] = 6448,
  [SMALL_STATE(86)] = 6525,
  [SMALL_STATE(87)] = 6602,
  [SMALL_STATE(88)] = 6679,
  [SMALL_STATE(89)] = 6726,
  [SMALL_STATE(90)] = 6803,
  [SMALL_STATE(91)] = 6880,
  [SMALL_STATE(92)] = 6957,
  [SMALL_STATE(93)] = 7034,
  [SMALL_STATE(94)] = 7111,
  [SMALL_STATE(95)] = 7188,
  [SMALL_STATE(96)] = 7265,
  [SMALL_STATE(97)] = 7342,
  [SMALL_STATE(98)] = 7419,
  [SMALL_STATE(99)] = 7496,
  [SMALL_STATE(100)] = 7573,
  [SMALL_STATE(101)] = 7650,
  [SMALL_STATE(102)] = 7727,
  [SMALL_STATE(103)] = 7804,
  [SMALL_STATE(104)] = 7881,
  [SMALL_STATE(105)] = 7958,
  [SMALL_STATE(106)] = 8035,
  [SMALL_STATE(107)] = 8112,
  [SMALL_STATE(108)] = 8189,
  [SMALL_STATE(109)] = 8266,
  [SMALL_STATE(110)] = 8343,
  [SMALL_STATE(111)] = 8420,
  [SMALL_STATE(112)] = 8497,
  [SMALL_STATE(113)] = 8574,
  [SMALL_STATE(114)] = 8651,
  [SMALL_STATE(115)] = 8728,
  [SMALL_STATE(116)] = 8805,
  [SMALL_STATE(117)] = 8882,
  [SMALL_STATE(118)] = 8959,
  [SMALL_STATE(119)] = 9036,
  [SMALL_STATE(120)] = 9113,
  [SMALL_STATE(121)] = 9190,
  [SMALL_STATE(122)] = 9267,
  [SMALL_STATE(123)] = 9344,
  [SMALL_STATE(124)] = 9421,
  [SMALL_STATE(125)] = 9498,
  [SMALL_STATE(126)] = 9575,
  [SMALL_STATE(127)] = 9652,
  [SMALL_STATE(128)] = 9729,
  [SMALL_STATE(129)] = 9806,
  [SMALL_STATE(130)] = 9883,
  [SMALL_STATE(131)] = 9960,
  [SMALL_STATE(132)] = 10037,
  [SMALL_STATE(133)] = 10114,
  [SMALL_STATE(134)] = 10191,
  [SMALL_STATE(135)] = 10268,
  [SMALL_STATE(136)] = 10345,
  [SMALL_STATE(137)] = 10422,
  [SMALL_STATE(138)] = 10499,
  [SMALL_STATE(139)] = 10576,
  [SMALL_STATE(140)] = 10653,
  [SMALL_STATE(141)] = 10697,
  [SMALL_STATE(142)] = 10769,
  [SMALL_STATE(143)] = 10813,
  [SMALL_STATE(144)] = 10885,
  [SMALL_STATE(145)] = 10929,
  [SMALL_STATE(146)] = 10973,
  [SMALL_STATE(147)] = 11017,
  [SMALL_STATE(148)] = 11061,
  [SMALL_STATE(149)] = 11105,
  [SMALL_STATE(150)] = 11149,
  [SMALL_STATE(151)] = 11193,
  [SMALL_STATE(152)] = 11237,
  [SMALL_STATE(153)] = 11307,
  [SMALL_STATE(154)] = 11361,
  [SMALL_STATE(155)] = 11405,
  [SMALL_STATE(156)] = 11455,
  [SMALL_STATE(157)] = 11505,
  [SMALL_STATE(158)] = 11563,
  [SMALL_STATE(159)] = 11623,
  [SMALL_STATE(160)] = 11685,
  [SMALL_STATE(161)] = 11749,
  [SMALL_STATE(162)] = 11815,
  [SMALL_STATE(163)] = 11883,
  [SMALL_STATE(164)] = 11927,
  [SMALL_STATE(165)] = 11971,
  [SMALL_STATE(166)] = 12015,
  [SMALL_STATE(167)] = 12059,
  [SMALL_STATE(168)] = 12131,
  [SMALL_STATE(169)] = 12175,
  [SMALL_STATE(170)] = 12223,
  [SMALL_STATE(171)] = 12267,
  [SMALL_STATE(172)] = 12311,
  [SMALL_STATE(173)] = 12355,
  [SMALL_STATE(174)] = 12399,
  [SMALL_STATE(175)] = 12443,
  [SMALL_STATE(176)] = 12487,
  [SMALL_STATE(177)] = 12531,
  [SMALL_STATE(178)] = 12575,
  [SMALL_STATE(179)] = 12647,
  [SMALL_STATE(180)] = 12691,
  [SMALL_STATE(181)] = 12735,
  [SMALL_STATE(182)] = 12779,
  [SMALL_STATE(183)] = 12823,
  [SMALL_STATE(184)] = 12867,
  [SMALL_STATE(185)] = 12911,
  [SMALL_STATE(186)] = 12983,
  [SMALL_STATE(187)] = 13055,
  [SMALL_STATE(188)] = 13099,
  [SMALL_STATE(189)] = 13143,
  [SMALL_STATE(190)] = 13187,
  [SMALL_STATE(191)] = 13235,
  [SMALL_STATE(192)] = 13280,
  [SMALL_STATE(193)] = 13325,
  [SMALL_STATE(194)] = 13370,
  [SMALL_STATE(195)] = 13412,
  [SMALL_STATE(196)] = 13476,
  [SMALL_STATE(197)] = 13542,
  [SMALL_STATE(198)] = 13600,
  [SMALL_STATE(199)] = 13672,
  [SMALL_STATE(200)] = 13744,
  [SMALL_STATE(201)] = 13786,
  [SMALL_STATE(202)] = 13828,
  [SMALL_STATE(203)] = 13898,
  [SMALL_STATE(204)] = 13940,
  [SMALL_STATE(205)] = 13982,
  [SMALL_STATE(206)] = 14024,
  [SMALL_STATE(207)] = 14066,
  [SMALL_STATE(208)] = 14108,
  [SMALL_STATE(209)] = 14150,
  [SMALL_STATE(210)] = 14192,
  [SMALL_STATE(211)] = 14234,
  [SMALL_STATE(212)] = 14276,
  [SMALL_STATE(213)] = 14318,
  [SMALL_STATE(214)] = 14390,
  [SMALL_STATE(215)] = 14462,
  [SMALL_STATE(216)] = 14504,
  [SMALL_STATE(217)] = 14574,
  [SMALL_STATE(218)] = 14616,
  [SMALL_STATE(219)] = 14676,
  [SMALL_STATE(220)] = 14722,
  [SMALL_STATE(221)] = 14764,
  [SMALL_STATE(222)] = 14826,
  [SMALL_STATE(223)] = 14868,
  [SMALL_STATE(224)] = 14910,
  [SMALL_STATE(225)] = 14982,
  [SMALL_STATE(226)] = 15024,
  [SMALL_STATE(227)] = 15066,
  [SMALL_STATE(228)] = 15108,
  [SMALL_STATE(229)] = 15150,
  [SMALL_STATE(230)] = 15192,
  [SMALL_STATE(231)] = 15260,
  [SMALL_STATE(232)] = 15312,
  [SMALL_STATE(233)] = 15354,
  [SMALL_STATE(234)] = 15426,
  [SMALL_STATE(235)] = 15498,
  [SMALL_STATE(236)] = 15568,
  [SMALL_STATE(237)] = 15640,
  [SMALL_STATE(238)] = 15710,
  [SMALL_STATE(239)] = 15752,
  [SMALL_STATE(240)] = 15794,
  [SMALL_STATE(241)] = 15836,
  [SMALL_STATE(242)] = 15884,
  [SMALL_STATE(243)] = 15926,
  [SMALL_STATE(244)] = 15968,
  [SMALL_STATE(245)] = 16010,
  [SMALL_STATE(246)] = 16052,
  [SMALL_STATE(247)] = 16094,
  [SMALL_STATE(248)] = 16164,
  [SMALL_STATE(249)] = 16212,
  [SMALL_STATE(250)] = 16282,
  [SMALL_STATE(251)] = 16338,
  [SMALL_STATE(252)] = 16380,
  [SMALL_STATE(253)] = 16449,
  [SMALL_STATE(254)] = 16519,
  [SMALL_STATE(255)] = 16589,
  [SMALL_STATE(256)] = 16659,
  [SMALL_STATE(257)] = 16729,
  [SMALL_STATE(258)] = 16799,
  [SMALL_STATE(259)] = 16869,
  [SMALL_STATE(260)] = 16939,
  [SMALL_STATE(261)] = 17009,
  [SMALL_STATE(262)] = 17076,
  [SMALL_STATE(263)] = 17114,
  [SMALL_STATE(264)] = 17152,
  [SMALL_STATE(265)] = 17212,
  [SMALL_STATE(266)] = 17248,
  [SMALL_STATE(267)] = 17286,
  [SMALL_STATE(268)] = 17349,
  [SMALL_STATE(269)] = 17412,
  [SMALL_STATE(270)] = 17475,
  [SMALL_STATE(271)] = 17538,
  [SMALL_STATE(272)] = 17601,
  [SMALL_STATE(273)] = 17664,
  [SMALL_STATE(274)] = 17727,
  [SMALL_STATE(275)] = 17790,
  [SMALL_STATE(276)] = 17823,
  [SMALL_STATE(277)] = 17886,
  [SMALL_STATE(278)] = 17919,
  [SMALL_STATE(279)] = 17982,
  [SMALL_STATE(280)] = 18045,
  [SMALL_STATE(281)] = 18108,
  [SMALL_STATE(282)] = 18171,
  [SMALL_STATE(283)] = 18234,
  [SMALL_STATE(284)] = 18297,
  [SMALL_STATE(285)] = 18360,
  [SMALL_STATE(286)] = 18423,
  [SMALL_STATE(287)] = 18486,
  [SMALL_STATE(288)] = 18549,
  [SMALL_STATE(289)] = 18612,
  [SMALL_STATE(290)] = 18675,
  [SMALL_STATE(291)] = 18708,
  [SMALL_STATE(292)] = 18771,
  [SMALL_STATE(293)] = 18834,
  [SMALL_STATE(294)] = 18897,
  [SMALL_STATE(295)] = 18933,
  [SMALL_STATE(296)] = 18987,
  [SMALL_STATE(297)] = 19017,
  [SMALL_STATE(298)] = 19047,
  [SMALL_STATE(299)] = 19077,
  [SMALL_STATE(300)] = 19107,
  [SMALL_STATE(301)] = 19137,
  [SMALL_STATE(302)] = 19167,
  [SMALL_STATE(303)] = 19221,
  [SMALL_STATE(304)] = 19251,
  [SMALL_STATE(305)] = 19305,
  [SMALL_STATE(306)] = 19335,
  [SMALL_STATE(307)] = 19365,
  [SMALL_STATE(308)] = 19395,
  [SMALL_STATE(309)] = 19425,
  [SMALL_STATE(310)] = 19455,
  [SMALL_STATE(311)] = 19509,
  [SMALL_STATE(312)] = 19563,
  [SMALL_STATE(313)] = 19593,
  [SMALL_STATE(314)] = 19647,
  [SMALL_STATE(315)] = 19677,
  [SMALL_STATE(316)] = 19707,
  [SMALL_STATE(317)] = 19737,
  [SMALL_STATE(318)] = 19791,
  [SMALL_STATE(319)] = 19821,
  [SMALL_STATE(320)] = 19851,
  [SMALL_STATE(321)] = 19881,
  [SMALL_STATE(322)] = 19911,
  [SMALL_STATE(323)] = 19941,
  [SMALL_STATE(324)] = 19971,
  [SMALL_STATE(325)] = 20001,
  [SMALL_STATE(326)] = 20031,
  [SMALL_STATE(327)] = 20061,
  [SMALL_STATE(328)] = 20091,
  [SMALL_STATE(329)] = 20145,
  [SMALL_STATE(330)] = 20175,
  [SMALL_STATE(331)] = 20205,
  [SMALL_STATE(332)] = 20235,
  [SMALL_STATE(333)] = 20265,
  [SMALL_STATE(334)] = 20317,
  [SMALL_STATE(335)] = 20355,
  [SMALL_STATE(336)] = 20385,
  [SMALL_STATE(337)] = 20421,
  [SMALL_STATE(338)] = 20471,
  [SMALL_STATE(339)] = 20511,
  [SMALL_STATE(340)] = 20553,
  [SMALL_STATE(341)] = 20611,
  [SMALL_STATE(342)] = 20655,
  [SMALL_STATE(343)] = 20701,
  [SMALL_STATE(344)] = 20735,
  [SMALL_STATE(345)] = 20765,
  [SMALL_STATE(346)] = 20813,
  [SMALL_STATE(347)] = 20867,
  [SMALL_STATE(348)] = 20897,
  [SMALL_STATE(349)] = 20930,
  [SMALL_STATE(350)] = 20987,
  [SMALL_STATE(351)] = 21020,
  [SMALL_STATE(352)] = 21077,
  [SMALL_STATE(353)] = 21110,
  [SMALL_STATE(354)] = 21167,
  [SMALL_STATE(355)] = 21224,
  [SMALL_STATE(356)] = 21269,
  [SMALL_STATE(357)] = 21326,
  [SMALL_STATE(358)] = 21383,
  [SMALL_STATE(359)] = 21440,
  [SMALL_STATE(360)] = 21497,
  [SMALL_STATE(361)] = 21554,
  [SMALL_STATE(362)] = 21599,
  [SMALL_STATE(363)] = 21656,
  [SMALL_STATE(364)] = 21689,
  [SMALL_STATE(365)] = 21746,
  [SMALL_STATE(366)] = 21803,
  [SMALL_STATE(367)] = 21831,
  [SMALL_STATE(368)] = 21860,
  [SMALL_STATE(369)] = 21891,
  [SMALL_STATE(370)] = 21918,
  [SMALL_STATE(371)] = 21945,
  [SMALL_STATE(372)] = 21982,
  [SMALL_STATE(373)] = 22019,
  [SMALL_STATE(374)] = 22056,
  [SMALL_STATE(375)] = 22081,
  [SMALL_STATE(376)] = 22106,
  [SMALL_STATE(377)] = 22131,
  [SMALL_STATE(378)] = 22156,
  [SMALL_STATE(379)] = 22181,
  [SMALL_STATE(380)] = 22206,
  [SMALL_STATE(381)] = 22231,
  [SMALL_STATE(382)] = 22251,
  [SMALL_STATE(383)] = 22274,
  [SMALL_STATE(384)] = 22293,
  [SMALL_STATE(385)] = 22312,
  [SMALL_STATE(386)] = 22333,
  [SMALL_STATE(387)] = 22356,
  [SMALL_STATE(388)] = 22375,
  [SMALL_STATE(389)] = 22394,
  [SMALL_STATE(390)] = 22413,
  [SMALL_STATE(391)] = 22432,
  [SMALL_STATE(392)] = 22451,
  [SMALL_STATE(393)] = 22470,
  [SMALL_STATE(394)] = 22489,
  [SMALL_STATE(395)] = 22512,
  [SMALL_STATE(396)] = 22531,
  [SMALL_STATE(397)] = 22550,
  [SMALL_STATE(398)] = 22573,
  [SMALL_STATE(399)] = 22592,
  [SMALL_STATE(400)] = 22609,
  [SMALL_STATE(401)] = 22626,
  [SMALL_STATE(402)] = 22643,
  [SMALL_STATE(403)] = 22660,
  [SMALL_STATE(404)] = 22677,
  [SMALL_STATE(405)] = 22694,
  [SMALL_STATE(406)] = 22711,
  [SMALL_STATE(407)] = 22728,
  [SMALL_STATE(408)] = 22744,
  [SMALL_STATE(409)] = 22760,
  [SMALL_STATE(410)] = 22776,
  [SMALL_STATE(411)] = 22792,
  [SMALL_STATE(412)] = 22808,
  [SMALL_STATE(413)] = 22824,
  [SMALL_STATE(414)] = 22840,
  [SMALL_STATE(415)] = 22856,
  [SMALL_STATE(416)] = 22872,
  [SMALL_STATE(417)] = 22888,
  [SMALL_STATE(418)] = 22904,
  [SMALL_STATE(419)] = 22920,
  [SMALL_STATE(420)] = 22936,
  [SMALL_STATE(421)] = 22952,
  [SMALL_STATE(422)] = 22968,
  [SMALL_STATE(423)] = 22984,
  [SMALL_STATE(424)] = 23000,
  [SMALL_STATE(425)] = 23016,
  [SMALL_STATE(426)] = 23032,
  [SMALL_STATE(427)] = 23048,
  [SMALL_STATE(428)] = 23064,
  [SMALL_STATE(429)] = 23080,
  [SMALL_STATE(430)] = 23096,
  [SMALL_STATE(431)] = 23112,
  [SMALL_STATE(432)] = 23128,
  [SMALL_STATE(433)] = 23144,
  [SMALL_STATE(434)] = 23163,
  [SMALL_STATE(435)] = 23178,
  [SMALL_STATE(436)] = 23194,
  [SMALL_STATE(437)] = 23208,
  [SMALL_STATE(438)] = 23224,
  [SMALL_STATE(439)] = 23238,
  [SMALL_STATE(440)] = 23254,
  [SMALL_STATE(441)] = 23268,
  [SMALL_STATE(442)] = 23284,
  [SMALL_STATE(443)] = 23300,
  [SMALL_STATE(444)] = 23314,
  [SMALL_STATE(445)] = 23328,
  [SMALL_STATE(446)] = 23342,
  [SMALL_STATE(447)] = 23356,
  [SMALL_STATE(448)] = 23370,
  [SMALL_STATE(449)] = 23383,
  [SMALL_STATE(450)] = 23396,
  [SMALL_STATE(451)] = 23409,
  [SMALL_STATE(452)] = 23422,
  [SMALL_STATE(453)] = 23435,
  [SMALL_STATE(454)] = 23448,
  [SMALL_STATE(455)] = 23461,
  [SMALL_STATE(456)] = 23474,
  [SMALL_STATE(457)] = 23487,
  [SMALL_STATE(458)] = 23500,
  [SMALL_STATE(459)] = 23513,
  [SMALL_STATE(460)] = 23526,
  [SMALL_STATE(461)] = 23539,
  [SMALL_STATE(462)] = 23552,
  [SMALL_STATE(463)] = 23565,
  [SMALL_STATE(464)] = 23576,
  [SMALL_STATE(465)] = 23589,
  [SMALL_STATE(466)] = 23602,
  [SMALL_STATE(467)] = 23615,
  [SMALL_STATE(468)] = 23628,
  [SMALL_STATE(469)] = 23641,
  [SMALL_STATE(470)] = 23654,
  [SMALL_STATE(471)] = 23667,
  [SMALL_STATE(472)] = 23680,
  [SMALL_STATE(473)] = 23693,
  [SMALL_STATE(474)] = 23706,
  [SMALL_STATE(475)] = 23719,
  [SMALL_STATE(476)] = 23732,
  [SMALL_STATE(477)] = 23745,
  [SMALL_STATE(478)] = 23758,
  [SMALL_STATE(479)] = 23771,
  [SMALL_STATE(480)] = 23784,
  [SMALL_STATE(481)] = 23797,
  [SMALL_STATE(482)] = 23810,
  [SMALL_STATE(483)] = 23823,
  [SMALL_STATE(484)] = 23836,
  [SMALL_STATE(485)] = 23849,
  [SMALL_STATE(486)] = 23862,
  [SMALL_STATE(487)] = 23875,
  [SMALL_STATE(488)] = 23888,
  [SMALL_STATE(489)] = 23901,
  [SMALL_STATE(490)] = 23914,
  [SMALL_STATE(491)] = 23927,
  [SMALL_STATE(492)] = 23940,
  [SMALL_STATE(493)] = 23953,
  [SMALL_STATE(494)] = 23966,
  [SMALL_STATE(495)] = 23979,
  [SMALL_STATE(496)] = 23992,
  [SMALL_STATE(497)] = 24005,
  [SMALL_STATE(498)] = 24013,
  [SMALL_STATE(499)] = 24023,
  [SMALL_STATE(500)] = 24031,
  [SMALL_STATE(501)] = 24041,
  [SMALL_STATE(502)] = 24049,
  [SMALL_STATE(503)] = 24059,
  [SMALL_STATE(504)] = 24067,
  [SMALL_STATE(505)] = 24077,
  [SMALL_STATE(506)] = 24087,
  [SMALL_STATE(507)] = 24097,
  [SMALL_STATE(508)] = 24105,
  [SMALL_STATE(509)] = 24115,
  [SMALL_STATE(510)] = 24125,
  [SMALL_STATE(511)] = 24133,
  [SMALL_STATE(512)] = 24141,
  [SMALL_STATE(513)] = 24148,
  [SMALL_STATE(514)] = 24155,
  [SMALL_STATE(515)] = 24162,
  [SMALL_STATE(516)] = 24169,
  [SMALL_STATE(517)] = 24176,
  [SMALL_STATE(518)] = 24183,
  [SMALL_STATE(519)] = 24190,
  [SMALL_STATE(520)] = 24197,
  [SMALL_STATE(521)] = 24204,
  [SMALL_STATE(522)] = 24211,
  [SMALL_STATE(523)] = 24218,
  [SMALL_STATE(524)] = 24225,
  [SMALL_STATE(525)] = 24232,
  [SMALL_STATE(526)] = 24239,
  [SMALL_STATE(527)] = 24246,
  [SMALL_STATE(528)] = 24253,
  [SMALL_STATE(529)] = 24260,
  [SMALL_STATE(530)] = 24267,
  [SMALL_STATE(531)] = 24274,
  [SMALL_STATE(532)] = 24281,
  [SMALL_STATE(533)] = 24288,
  [SMALL_STATE(534)] = 24295,
  [SMALL_STATE(535)] = 24302,
  [SMALL_STATE(536)] = 24309,
  [SMALL_STATE(537)] = 24316,
  [SMALL_STATE(538)] = 24323,
  [SMALL_STATE(539)] = 24330,
  [SMALL_STATE(540)] = 24337,
  [SMALL_STATE(541)] = 24344,
  [SMALL_STATE(542)] = 24351,
  [SMALL_STATE(543)] = 24358,
  [SMALL_STATE(544)] = 24365,
  [SMALL_STATE(545)] = 24372,
  [SMALL_STATE(546)] = 24379,
  [SMALL_STATE(547)] = 24386,
  [SMALL_STATE(548)] = 24393,
  [SMALL_STATE(549)] = 24400,
  [SMALL_STATE(550)] = 24407,
  [SMALL_STATE(551)] = 24414,
  [SMALL_STATE(552)] = 24421,
  [SMALL_STATE(553)] = 24428,
  [SMALL_STATE(554)] = 24435,
  [SMALL_STATE(555)] = 24442,
  [SMALL_STATE(556)] = 24449,
  [SMALL_STATE(557)] = 24456,
  [SMALL_STATE(558)] = 24463,
  [SMALL_STATE(559)] = 24470,
  [SMALL_STATE(560)] = 24477,
  [SMALL_STATE(561)] = 24484,
  [SMALL_STATE(562)] = 24491,
  [SMALL_STATE(563)] = 24498,
  [SMALL_STATE(564)] = 24505,
  [SMALL_STATE(565)] = 24512,
  [SMALL_STATE(566)] = 24519,
  [SMALL_STATE(567)] = 24526,
  [SMALL_STATE(568)] = 24533,
  [SMALL_STATE(569)] = 24540,
  [SMALL_STATE(570)] = 24547,
  [SMALL_STATE(571)] = 24554,
  [SMALL_STATE(572)] = 24561,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(525),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(526),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(527),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(528),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(570),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(563),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(263),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [89] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 1, 0, 0),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [95] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 1, 0, 0),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(262),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [159] = {.entry = {.count = 1, .reusable = false}}, SHIFT(266),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [165] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [175] = {.entry = {.count = 1, .reusable = false}}, SHIFT(228),
  [177] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(223),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(548),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(567),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(549),
  [189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(540),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(535),
  [193] = {.entry = {.count = 1, .reusable = false}}, SHIFT(536),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [207] = {.entry = {.count = 1, .reusable = false}}, SHIFT(301),
  [209] = {.entry = {.count = 1, .reusable = false}}, SHIFT(316),
  [211] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [215] = {.entry = {.count = 1, .reusable = false}}, SHIFT(541),
  [217] = {.entry = {.count = 1, .reusable = false}}, SHIFT(542),
  [219] = {.entry = {.count = 1, .reusable = false}}, SHIFT(543),
  [221] = {.entry = {.count = 1, .reusable = false}}, SHIFT(544),
  [223] = {.entry = {.count = 1, .reusable = false}}, SHIFT(571),
  [225] = {.entry = {.count = 1, .reusable = false}}, SHIFT(566),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_literal, 2, 0, 0),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [231] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_literal, 2, 0, 0),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_literal, 3, 0, 0),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [237] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_literal, 3, 0, 0),
  [239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_literal, 4, 0, 0),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_literal, 4, 0, 0),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_well_known_set, 1, 0, 0),
  [247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_well_known_set, 1, 0, 0),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nondet_choice, 6, 0, 0),
  [255] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [263] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [267] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_application, 3, 0, 4),
  [283] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_application, 3, 0, 4),
  [285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_else_condition, 8, 0, 0),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_literal, 3, 0, 0),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_literal, 3, 0, 0),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_literal, 2, 0, 0),
  [293] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_literal, 2, 0, 0),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 3, 0, 0),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 3, 0, 0),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_and, 3, 0, 0),
  [301] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_and, 3, 0, 0),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_or, 3, 0, 0),
  [305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_or, 3, 0, 0),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_all, 3, 0, 0),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_all, 3, 0, 0),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_any, 3, 0, 0),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_any, 3, 0, 0),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expr, 3, 0, 0),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expr, 3, 0, 0),
  [319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_all, 6, 0, 0),
  [321] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_all, 6, 0, 0),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_any, 6, 0, 0),
  [325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_any, 6, 0, 0),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_application, 4, 0, 7),
  [329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_application, 4, 0, 7),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_literal, 4, 0, 0),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_literal, 4, 0, 0),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lambda_expr, 4, 0, 0),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bool_literal, 1, 0, 0),
  [339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bool_literal, 1, 0, 0),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_literal, 4, 0, 0),
  [347] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_literal, 4, 0, 0),
  [349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_and, 4, 0, 0),
  [351] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_and, 4, 0, 0),
  [353] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_or, 4, 0, 0),
  [355] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_or, 4, 0, 0),
  [357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_all, 4, 0, 0),
  [359] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_all, 4, 0, 0),
  [361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_any, 4, 0, 0),
  [363] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_any, 4, 0, 0),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_access, 4, 0, 0),
  [367] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_access, 4, 0, 0),
  [369] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 0),
  [371] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 0),
  [373] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_application, 5, 0, 10),
  [375] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_application, 5, 0, 10),
  [377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lambda_expr, 5, 0, 0),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [381] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 0),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_literal, 5, 0, 0),
  [385] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_literal, 5, 0, 0),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_and, 5, 0, 0),
  [389] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_and, 5, 0, 0),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_or, 5, 0, 0),
  [393] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_or, 5, 0, 0),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_all, 5, 0, 0),
  [397] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_all, 5, 0, 0),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_any, 5, 0, 0),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_any, 5, 0, 0),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lambda_expr, 3, 0, 0),
  [405] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lambda_expr, 6, 0, 0),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_literal, 6, 0, 0),
  [409] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_literal, 6, 0, 0),
  [411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_and, 6, 0, 0),
  [413] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_and, 6, 0, 0),
  [415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_or, 6, 0, 0),
  [417] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_or, 6, 0, 0),
  [419] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expr, 2, 0, 0),
  [421] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expr, 2, 0, 0),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [431] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [439] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [455] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 6, 0, 5),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [463] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 6, 0, 6),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [467] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 7, 0, 8),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [471] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 7, 0, 9),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [475] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 4, 0, 1),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [479] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 8, 0, 11),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [483] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 5, 0, 2),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 5, 0, 3),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [491] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assumption, 4, 0, 0),
  [493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [513] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_lambda_expr_repeat1, 2, 0, 0),
  [515] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [517] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [553] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [559] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [593] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [605] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [607] = {.entry = {.count = 1, .reusable = false}}, SHIFT(506),
  [609] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [611] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [613] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lambda_expr, 4, 0, 0),
  [615] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [617] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [619] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [621] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [623] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [625] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [627] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [629] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [631] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lambda_expr, 6, 0, 0),
  [633] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [637] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [641] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lambda_expr, 3, 0, 0),
  [643] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nondet_choice, 6, 0, 0),
  [645] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_else_condition, 8, 0, 0),
  [647] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_literal_repeat1, 4, 0, 0),
  [653] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lambda_expr, 5, 0, 0),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 1, 0, 0),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [661] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type, 1, 0, 0),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [665] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sum_type_repeat1, 2, 0, 0),
  [667] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sum_type_repeat1, 2, 0, 0), SHIFT_REPEAT(572),
  [670] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sum_type_repeat1, 2, 0, 0),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sum_type, 4, 0, 0),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [678] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sum_type, 4, 0, 0),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [684] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0),
  [686] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(443),
  [689] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(564),
  [692] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(523),
  [695] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(529),
  [698] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(531),
  [701] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(501),
  [704] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(546),
  [707] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(569),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [720] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1, 0, 0),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [724] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sum_type, 5, 0, 0),
  [726] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sum_type, 5, 0, 0),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [732] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sum_type_repeat1, 5, 0, 0),
  [734] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sum_type_repeat1, 5, 0, 0),
  [736] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type, 3, 0, 0),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [740] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type, 3, 0, 0),
  [742] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_type, 3, 0, 0),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [746] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_type, 3, 0, 0),
  [748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_polymorphic_type, 4, 0, 0),
  [750] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_polymorphic_type, 4, 0, 0),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0),
  [770] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(550),
  [773] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(551),
  [776] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(552),
  [779] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(497),
  [782] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(554),
  [785] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(555),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [792] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constant_declaration, 4, 0, 0),
  [794] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sum_type_repeat1, 2, 0, 0), SHIFT_REPEAT(565),
  [797] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias, 4, 0, 0),
  [799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [801] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_definition, 4, 0, 0),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [807] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 6, 0, 2),
  [809] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 8, 0, 8),
  [811] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_definition, 4, 0, 0),
  [813] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 6, 0, 3),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 8, 0, 9),
  [817] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_definition, 5, 0, 0),
  [819] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 7, 0, 6),
  [821] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 7, 0, 5),
  [823] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 5, 0, 1),
  [825] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 9, 0, 11),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [835] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_lambda_expr_repeat1, 2, 0, 0), SHIFT_REPEAT(127),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [844] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(436),
  [847] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [855] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [861] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_typed_argument_list_repeat1, 4, 0, 0),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [873] = {.entry = {.count = 1, .reusable = false}}, SHIFT(246),
  [875] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [879] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [883] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [885] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [891] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [895] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [899] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [905] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [913] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_typed_argument_list_repeat1, 2, 0, 0),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [921] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [935] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [945] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_typed_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(514),
  [948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [950] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [952] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [958] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [960] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [962] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_literal_repeat1, 2, 0, 0),
  [964] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_record_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(509),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [973] = {.entry = {.count = 1, .reusable = false}}, SHIFT(54),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [991] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typed_argument_list, 6, 0, 0),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [1001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1003] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typed_argument_list, 3, 0, 0),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [1013] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typed_argument_list, 5, 0, 0),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(534),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [1021] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typed_argument_list, 4, 0, 0),
  [1023] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_literal_repeat1, 3, 0, 0),
  [1025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [1031] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [1035] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [1039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1041] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1047] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [1049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1071] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [1101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [1131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [1137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_Qunit(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
