pub const ext = @import("ext.zig");
const gstwebrtc = @This();

const std = @import("std");
const compat = @import("compat");
const gstsdp = @import("gstsdp1");
const gst = @import("gst1");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
pub const WebRTCDTLSTransport = opaque {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstwebrtc.WebRTCDTLSTransportClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const certificate = struct {
            pub const name = "certificate";

            pub const Type = ?[*:0]u8;
        };

        pub const client = struct {
            pub const name = "client";

            pub const Type = c_int;
        };

        pub const remote_certificate = struct {
            pub const name = "remote-certificate";

            pub const Type = ?[*:0]u8;
        };

        pub const session_id = struct {
            pub const name = "session-id";

            pub const Type = c_uint;
        };

        pub const state = struct {
            pub const name = "state";

            pub const Type = gstwebrtc.WebRTCDTLSTransportState;
        };

        pub const transport = struct {
            pub const name = "transport";

            pub const Type = ?*gstwebrtc.WebRTCICETransport;
        };
    };

    pub const signals = struct {};

    extern fn gst_webrtc_dtls_transport_get_type() usize;
    pub const getGObjectType = gst_webrtc_dtls_transport_get_type;

    extern fn g_object_ref(p_self: *gstwebrtc.WebRTCDTLSTransport) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstwebrtc.WebRTCDTLSTransport) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebRTCDTLSTransport, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCDataChannel = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gstwebrtc.WebRTCDataChannelClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const buffered_amount = struct {
            pub const name = "buffered-amount";

            pub const Type = u64;
        };

        pub const buffered_amount_low_threshold = struct {
            pub const name = "buffered-amount-low-threshold";

            pub const Type = u64;
        };

        pub const id = struct {
            pub const name = "id";

            pub const Type = c_int;
        };

        pub const label = struct {
            pub const name = "label";

            pub const Type = ?[*:0]u8;
        };

        pub const max_packet_lifetime = struct {
            pub const name = "max-packet-lifetime";

            pub const Type = c_int;
        };

        pub const max_retransmits = struct {
            pub const name = "max-retransmits";

            pub const Type = c_int;
        };

        pub const negotiated = struct {
            pub const name = "negotiated";

            pub const Type = c_int;
        };

        pub const ordered = struct {
            pub const name = "ordered";

            pub const Type = c_int;
        };

        pub const priority = struct {
            pub const name = "priority";

            pub const Type = gstwebrtc.WebRTCPriorityType;
        };

        pub const protocol = struct {
            pub const name = "protocol";

            pub const Type = ?[*:0]u8;
        };

        pub const ready_state = struct {
            pub const name = "ready-state";

            pub const Type = gstwebrtc.WebRTCDataChannelState;
        };
    };

    pub const signals = struct {
        /// Close the data channel
        pub const close = struct {
            pub const name = "close";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebRTCDataChannel, p_instance))),
                    gobject.signalLookup("close", WebRTCDataChannel.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        pub const on_buffered_amount_low = struct {
            pub const name = "on-buffered-amount-low";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebRTCDataChannel, p_instance))),
                    gobject.signalLookup("on-buffered-amount-low", WebRTCDataChannel.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        pub const on_close = struct {
            pub const name = "on-close";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebRTCDataChannel, p_instance))),
                    gobject.signalLookup("on-close", WebRTCDataChannel.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        pub const on_error = struct {
            pub const name = "on-error";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_error: *glib.Error, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebRTCDataChannel, p_instance))),
                    gobject.signalLookup("on-error", WebRTCDataChannel.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        pub const on_message_data = struct {
            pub const name = "on-message-data";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_data: ?*glib.Bytes, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebRTCDataChannel, p_instance))),
                    gobject.signalLookup("on-message-data", WebRTCDataChannel.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        pub const on_message_string = struct {
            pub const name = "on-message-string";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_data: ?[*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebRTCDataChannel, p_instance))),
                    gobject.signalLookup("on-message-string", WebRTCDataChannel.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        pub const on_open = struct {
            pub const name = "on-open";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebRTCDataChannel, p_instance))),
                    gobject.signalLookup("on-open", WebRTCDataChannel.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        pub const send_data = struct {
            pub const name = "send-data";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_data: ?*glib.Bytes, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebRTCDataChannel, p_instance))),
                    gobject.signalLookup("send-data", WebRTCDataChannel.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        pub const send_string = struct {
            pub const name = "send-string";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_data: ?[*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebRTCDataChannel, p_instance))),
                    gobject.signalLookup("send-string", WebRTCDataChannel.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Close the `channel`.
    extern fn gst_webrtc_data_channel_close(p_channel: *WebRTCDataChannel) void;
    pub const close = gst_webrtc_data_channel_close;

    /// Send `data` as a data message over `channel`.
    extern fn gst_webrtc_data_channel_send_data(p_channel: *WebRTCDataChannel, p_data: ?*glib.Bytes) void;
    pub const sendData = gst_webrtc_data_channel_send_data;

    /// Send `data` as a data message over `channel`.
    extern fn gst_webrtc_data_channel_send_data_full(p_channel: *WebRTCDataChannel, p_data: ?*glib.Bytes, p_error: ?*?*glib.Error) c_int;
    pub const sendDataFull = gst_webrtc_data_channel_send_data_full;

    /// Send `str` as a string message over `channel`.
    extern fn gst_webrtc_data_channel_send_string(p_channel: *WebRTCDataChannel, p_str: ?[*:0]const u8) void;
    pub const sendString = gst_webrtc_data_channel_send_string;

    /// Send `str` as a string message over `channel`.
    extern fn gst_webrtc_data_channel_send_string_full(p_channel: *WebRTCDataChannel, p_str: ?[*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const sendStringFull = gst_webrtc_data_channel_send_string_full;

    extern fn gst_webrtc_data_channel_get_type() usize;
    pub const getGObjectType = gst_webrtc_data_channel_get_type;

    extern fn g_object_ref(p_self: *gstwebrtc.WebRTCDataChannel) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstwebrtc.WebRTCDataChannel) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebRTCDataChannel, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCICE = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstwebrtc.WebRTCICEClass;
    f_parent: gst.Object,
    f_ice_gathering_state: gstwebrtc.WebRTCICEGatheringState,
    f_ice_connection_state: gstwebrtc.WebRTCICEConnectionState,
    f_min_rtp_port: c_uint,
    f_max_rtp_port: c_uint,
    f__gst_reserved: [4]*anyopaque,

    pub const virtual_methods = struct {
        pub const add_candidate = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream, p_candidate: [*:0]const u8, p_promise: ?*gst.Promise) void {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_add_candidate.?(gobject.ext.as(WebRTCICE, p_ice), p_stream, p_candidate, p_promise);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream, p_candidate: [*:0]const u8, p_promise: ?*gst.Promise) callconv(.C) void) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_add_candidate = @ptrCast(p_implementation);
            }
        };

        pub const add_stream = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_session_id: c_uint) ?*gstwebrtc.WebRTCICEStream {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_add_stream.?(gobject.ext.as(WebRTCICE, p_ice), p_session_id);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_session_id: c_uint) callconv(.C) ?*gstwebrtc.WebRTCICEStream) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_add_stream = @ptrCast(p_implementation);
            }
        };

        pub const add_turn_server = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_uri: [*:0]const u8) c_int {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_add_turn_server.?(gobject.ext.as(WebRTCICE, p_ice), p_uri);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_uri: [*:0]const u8) callconv(.C) c_int) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_add_turn_server = @ptrCast(p_implementation);
            }
        };

        pub const find_transport = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream, p_component: gstwebrtc.WebRTCICEComponent) ?*gstwebrtc.WebRTCICETransport {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_find_transport.?(gobject.ext.as(WebRTCICE, p_ice), p_stream, p_component);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream, p_component: gstwebrtc.WebRTCICEComponent) callconv(.C) ?*gstwebrtc.WebRTCICETransport) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_find_transport = @ptrCast(p_implementation);
            }
        };

        pub const gather_candidates = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream) c_int {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_gather_candidates.?(gobject.ext.as(WebRTCICE, p_ice), p_stream);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream) callconv(.C) c_int) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_gather_candidates = @ptrCast(p_implementation);
            }
        };

        /// Get HTTP Proxy to be used when connecting to TURN server.
        pub const get_http_proxy = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) [*:0]u8 {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_get_http_proxy.?(gobject.ext.as(WebRTCICE, p_ice));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) [*:0]u8) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_get_http_proxy = @ptrCast(p_implementation);
            }
        };

        pub const get_is_controller = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_int {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_get_is_controller.?(gobject.ext.as(WebRTCICE, p_ice));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_int) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_get_is_controller = @ptrCast(p_implementation);
            }
        };

        pub const get_local_candidates = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream) **gstwebrtc.WebRTCICECandidateStats {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_get_local_candidates.?(gobject.ext.as(WebRTCICE, p_ice), p_stream);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream) callconv(.C) **gstwebrtc.WebRTCICECandidateStats) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_get_local_candidates = @ptrCast(p_implementation);
            }
        };

        pub const get_remote_candidates = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream) **gstwebrtc.WebRTCICECandidateStats {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_get_remote_candidates.?(gobject.ext.as(WebRTCICE, p_ice), p_stream);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream) callconv(.C) **gstwebrtc.WebRTCICECandidateStats) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_get_remote_candidates = @ptrCast(p_implementation);
            }
        };

        pub const get_selected_pair = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream, p_local_stats: **gstwebrtc.WebRTCICECandidateStats, p_remote_stats: **gstwebrtc.WebRTCICECandidateStats) c_int {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_get_selected_pair.?(gobject.ext.as(WebRTCICE, p_ice), p_stream, p_local_stats, p_remote_stats);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream, p_local_stats: **gstwebrtc.WebRTCICECandidateStats, p_remote_stats: **gstwebrtc.WebRTCICECandidateStats) callconv(.C) c_int) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_get_selected_pair = @ptrCast(p_implementation);
            }
        };

        pub const get_stun_server = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) ?[*:0]u8 {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_get_stun_server.?(gobject.ext.as(WebRTCICE, p_ice));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) ?[*:0]u8) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_get_stun_server = @ptrCast(p_implementation);
            }
        };

        pub const get_turn_server = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) ?[*:0]u8 {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_get_turn_server.?(gobject.ext.as(WebRTCICE, p_ice));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) ?[*:0]u8) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_get_turn_server = @ptrCast(p_implementation);
            }
        };

        pub const set_force_relay = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_force_relay: c_int) void {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_set_force_relay.?(gobject.ext.as(WebRTCICE, p_ice), p_force_relay);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_force_relay: c_int) callconv(.C) void) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_set_force_relay = @ptrCast(p_implementation);
            }
        };

        /// Set HTTP Proxy to be used when connecting to TURN server.
        pub const set_http_proxy = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_uri: [*:0]const u8) void {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_set_http_proxy.?(gobject.ext.as(WebRTCICE, p_ice), p_uri);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_uri: [*:0]const u8) callconv(.C) void) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_set_http_proxy = @ptrCast(p_implementation);
            }
        };

        pub const set_is_controller = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_controller: c_int) void {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_set_is_controller.?(gobject.ext.as(WebRTCICE, p_ice), p_controller);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_controller: c_int) callconv(.C) void) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_set_is_controller = @ptrCast(p_implementation);
            }
        };

        pub const set_local_credentials = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream, p_ufrag: [*:0]const u8, p_pwd: [*:0]const u8) c_int {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_set_local_credentials.?(gobject.ext.as(WebRTCICE, p_ice), p_stream, p_ufrag, p_pwd);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream, p_ufrag: [*:0]const u8, p_pwd: [*:0]const u8) callconv(.C) c_int) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_set_local_credentials = @ptrCast(p_implementation);
            }
        };

        pub const set_on_ice_candidate = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_func: gstwebrtc.WebRTCICEOnCandidateFunc, p_user_data: ?*anyopaque, p_notify: ?glib.DestroyNotify) void {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_set_on_ice_candidate.?(gobject.ext.as(WebRTCICE, p_ice), p_func, p_user_data, p_notify);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_func: gstwebrtc.WebRTCICEOnCandidateFunc, p_user_data: ?*anyopaque, p_notify: ?glib.DestroyNotify) callconv(.C) void) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_set_on_ice_candidate = @ptrCast(p_implementation);
            }
        };

        pub const set_remote_credentials = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream, p_ufrag: [*:0]const u8, p_pwd: [*:0]const u8) c_int {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_set_remote_credentials.?(gobject.ext.as(WebRTCICE, p_ice), p_stream, p_ufrag, p_pwd);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream, p_ufrag: [*:0]const u8, p_pwd: [*:0]const u8) callconv(.C) c_int) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_set_remote_credentials = @ptrCast(p_implementation);
            }
        };

        pub const set_stun_server = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_uri: ?[*:0]const u8) void {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_set_stun_server.?(gobject.ext.as(WebRTCICE, p_ice), p_uri);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_uri: ?[*:0]const u8) callconv(.C) void) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_set_stun_server = @ptrCast(p_implementation);
            }
        };

        pub const set_tos = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream, p_tos: c_uint) void {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_set_tos.?(gobject.ext.as(WebRTCICE, p_ice), p_stream, p_tos);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_stream: *gstwebrtc.WebRTCICEStream, p_tos: c_uint) callconv(.C) void) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_set_tos = @ptrCast(p_implementation);
            }
        };

        pub const set_turn_server = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_uri: ?[*:0]const u8) void {
                return gobject.ext.as(WebRTCICE.Class, p_class).f_set_turn_server.?(gobject.ext.as(WebRTCICE, p_ice), p_uri);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_uri: ?[*:0]const u8) callconv(.C) void) void {
                gobject.ext.as(WebRTCICE.Class, p_class).f_set_turn_server = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// Maximum port for local rtp port range.
        /// min-rtp-port must be <= max-rtp-port
        pub const max_rtp_port = struct {
            pub const name = "max-rtp-port";

            pub const Type = c_uint;
        };

        /// Minimum port for local rtp port range.
        /// min-rtp-port must be <= max-rtp-port
        pub const min_rtp_port = struct {
            pub const name = "min-rtp-port";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {
        /// Add a local IP address to use for ICE candidate gathering.  If none
        /// are supplied, they will be discovered automatically. Calling this signal
        /// stops automatic ICE gathering.
        pub const add_local_ip_address = struct {
            pub const name = "add-local-ip-address";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_address: [*:0]u8, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebRTCICE, p_instance))),
                    gobject.signalLookup("add-local-ip-address", WebRTCICE.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    extern fn gst_webrtc_ice_add_candidate(p_ice: *WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream, p_candidate: [*:0]const u8, p_promise: ?*gst.Promise) void;
    pub const addCandidate = gst_webrtc_ice_add_candidate;

    extern fn gst_webrtc_ice_add_stream(p_ice: *WebRTCICE, p_session_id: c_uint) ?*gstwebrtc.WebRTCICEStream;
    pub const addStream = gst_webrtc_ice_add_stream;

    extern fn gst_webrtc_ice_add_turn_server(p_ice: *WebRTCICE, p_uri: [*:0]const u8) c_int;
    pub const addTurnServer = gst_webrtc_ice_add_turn_server;

    extern fn gst_webrtc_ice_find_transport(p_ice: *WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream, p_component: gstwebrtc.WebRTCICEComponent) ?*gstwebrtc.WebRTCICETransport;
    pub const findTransport = gst_webrtc_ice_find_transport;

    extern fn gst_webrtc_ice_gather_candidates(p_ice: *WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream) c_int;
    pub const gatherCandidates = gst_webrtc_ice_gather_candidates;

    extern fn gst_webrtc_ice_get_http_proxy(p_ice: *WebRTCICE) [*:0]u8;
    pub const getHttpProxy = gst_webrtc_ice_get_http_proxy;

    extern fn gst_webrtc_ice_get_is_controller(p_ice: *WebRTCICE) c_int;
    pub const getIsController = gst_webrtc_ice_get_is_controller;

    extern fn gst_webrtc_ice_get_local_candidates(p_ice: *WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream) [*]*gstwebrtc.WebRTCICECandidateStats;
    pub const getLocalCandidates = gst_webrtc_ice_get_local_candidates;

    extern fn gst_webrtc_ice_get_remote_candidates(p_ice: *WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream) [*]*gstwebrtc.WebRTCICECandidateStats;
    pub const getRemoteCandidates = gst_webrtc_ice_get_remote_candidates;

    extern fn gst_webrtc_ice_get_selected_pair(p_ice: *WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream, p_local_stats: **gstwebrtc.WebRTCICECandidateStats, p_remote_stats: **gstwebrtc.WebRTCICECandidateStats) c_int;
    pub const getSelectedPair = gst_webrtc_ice_get_selected_pair;

    extern fn gst_webrtc_ice_get_stun_server(p_ice: *WebRTCICE) ?[*:0]u8;
    pub const getStunServer = gst_webrtc_ice_get_stun_server;

    extern fn gst_webrtc_ice_get_turn_server(p_ice: *WebRTCICE) ?[*:0]u8;
    pub const getTurnServer = gst_webrtc_ice_get_turn_server;

    extern fn gst_webrtc_ice_set_force_relay(p_ice: *WebRTCICE, p_force_relay: c_int) void;
    pub const setForceRelay = gst_webrtc_ice_set_force_relay;

    /// Set HTTP Proxy to be used when connecting to TURN server.
    extern fn gst_webrtc_ice_set_http_proxy(p_ice: *WebRTCICE, p_uri: [*:0]const u8) void;
    pub const setHttpProxy = gst_webrtc_ice_set_http_proxy;

    extern fn gst_webrtc_ice_set_is_controller(p_ice: *WebRTCICE, p_controller: c_int) void;
    pub const setIsController = gst_webrtc_ice_set_is_controller;

    extern fn gst_webrtc_ice_set_local_credentials(p_ice: *WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream, p_ufrag: [*:0]const u8, p_pwd: [*:0]const u8) c_int;
    pub const setLocalCredentials = gst_webrtc_ice_set_local_credentials;

    extern fn gst_webrtc_ice_set_on_ice_candidate(p_ice: *WebRTCICE, p_func: gstwebrtc.WebRTCICEOnCandidateFunc, p_user_data: ?*anyopaque, p_notify: ?glib.DestroyNotify) void;
    pub const setOnIceCandidate = gst_webrtc_ice_set_on_ice_candidate;

    extern fn gst_webrtc_ice_set_remote_credentials(p_ice: *WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream, p_ufrag: [*:0]const u8, p_pwd: [*:0]const u8) c_int;
    pub const setRemoteCredentials = gst_webrtc_ice_set_remote_credentials;

    extern fn gst_webrtc_ice_set_stun_server(p_ice: *WebRTCICE, p_uri: ?[*:0]const u8) void;
    pub const setStunServer = gst_webrtc_ice_set_stun_server;

    extern fn gst_webrtc_ice_set_tos(p_ice: *WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream, p_tos: c_uint) void;
    pub const setTos = gst_webrtc_ice_set_tos;

    extern fn gst_webrtc_ice_set_turn_server(p_ice: *WebRTCICE, p_uri: ?[*:0]const u8) void;
    pub const setTurnServer = gst_webrtc_ice_set_turn_server;

    extern fn gst_webrtc_ice_get_type() usize;
    pub const getGObjectType = gst_webrtc_ice_get_type;

    extern fn g_object_ref(p_self: *gstwebrtc.WebRTCICE) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstwebrtc.WebRTCICE) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebRTCICE, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCICEStream = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstwebrtc.WebRTCICEStreamClass;
    f_parent: gst.Object,
    f_stream_id: c_uint,

    pub const virtual_methods = struct {
        pub const find_transport = struct {
            pub fn call(p_class: anytype, p_stream: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_component: gstwebrtc.WebRTCICEComponent) ?*gstwebrtc.WebRTCICETransport {
                return gobject.ext.as(WebRTCICEStream.Class, p_class).f_find_transport.?(gobject.ext.as(WebRTCICEStream, p_stream), p_component);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_stream: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_component: gstwebrtc.WebRTCICEComponent) callconv(.C) ?*gstwebrtc.WebRTCICETransport) void {
                gobject.ext.as(WebRTCICEStream.Class, p_class).f_find_transport = @ptrCast(p_implementation);
            }
        };

        pub const gather_candidates = struct {
            pub fn call(p_class: anytype, p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_int {
                return gobject.ext.as(WebRTCICEStream.Class, p_class).f_gather_candidates.?(gobject.ext.as(WebRTCICEStream, p_ice));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_ice: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_int) void {
                gobject.ext.as(WebRTCICEStream.Class, p_class).f_gather_candidates = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        pub const stream_id = struct {
            pub const name = "stream-id";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {};

    extern fn gst_webrtc_ice_stream_find_transport(p_stream: *WebRTCICEStream, p_component: gstwebrtc.WebRTCICEComponent) ?*gstwebrtc.WebRTCICETransport;
    pub const findTransport = gst_webrtc_ice_stream_find_transport;

    extern fn gst_webrtc_ice_stream_gather_candidates(p_ice: *WebRTCICEStream) c_int;
    pub const gatherCandidates = gst_webrtc_ice_stream_gather_candidates;

    extern fn gst_webrtc_ice_stream_get_type() usize;
    pub const getGObjectType = gst_webrtc_ice_stream_get_type;

    extern fn g_object_ref(p_self: *gstwebrtc.WebRTCICEStream) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstwebrtc.WebRTCICEStream) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebRTCICEStream, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCICETransport = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstwebrtc.WebRTCICETransportClass;
    f_parent: gst.Object,
    f_role: gstwebrtc.WebRTCICERole,
    f_component: gstwebrtc.WebRTCICEComponent,
    f_state: gstwebrtc.WebRTCICEConnectionState,
    f_gathering_state: gstwebrtc.WebRTCICEGatheringState,
    f_src: ?*gst.Element,
    f_sink: ?*gst.Element,
    f__padding: [4]*anyopaque,

    pub const virtual_methods = struct {
        pub const gather_candidates = struct {
            pub fn call(p_class: anytype, p_transport: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_int {
                return gobject.ext.as(WebRTCICETransport.Class, p_class).f_gather_candidates.?(gobject.ext.as(WebRTCICETransport, p_transport));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_transport: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_int) void {
                gobject.ext.as(WebRTCICETransport.Class, p_class).f_gather_candidates = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        pub const component = struct {
            pub const name = "component";

            pub const Type = gstwebrtc.WebRTCICEComponent;
        };

        pub const gathering_state = struct {
            pub const name = "gathering-state";

            pub const Type = gstwebrtc.WebRTCICEGatheringState;
        };

        pub const state = struct {
            pub const name = "state";

            pub const Type = gstwebrtc.WebRTCICEConnectionState;
        };
    };

    pub const signals = struct {
        pub const on_new_candidate = struct {
            pub const name = "on-new-candidate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_object: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebRTCICETransport, p_instance))),
                    gobject.signalLookup("on-new-candidate", WebRTCICETransport.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        pub const on_selected_candidate_pair_change = struct {
            pub const name = "on-selected-candidate-pair-change";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebRTCICETransport, p_instance))),
                    gobject.signalLookup("on-selected-candidate-pair-change", WebRTCICETransport.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    extern fn gst_webrtc_ice_transport_connection_state_change(p_ice: *WebRTCICETransport, p_new_state: gstwebrtc.WebRTCICEConnectionState) void;
    pub const connectionStateChange = gst_webrtc_ice_transport_connection_state_change;

    extern fn gst_webrtc_ice_transport_gathering_state_change(p_ice: *WebRTCICETransport, p_new_state: gstwebrtc.WebRTCICEGatheringState) void;
    pub const gatheringStateChange = gst_webrtc_ice_transport_gathering_state_change;

    extern fn gst_webrtc_ice_transport_new_candidate(p_ice: *WebRTCICETransport, p_stream_id: c_uint, p_component: gstwebrtc.WebRTCICEComponent, p_attr: [*:0]const u8) void;
    pub const newCandidate = gst_webrtc_ice_transport_new_candidate;

    extern fn gst_webrtc_ice_transport_selected_pair_change(p_ice: *WebRTCICETransport) void;
    pub const selectedPairChange = gst_webrtc_ice_transport_selected_pair_change;

    extern fn gst_webrtc_ice_transport_get_type() usize;
    pub const getGObjectType = gst_webrtc_ice_transport_get_type;

    extern fn g_object_ref(p_self: *gstwebrtc.WebRTCICETransport) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstwebrtc.WebRTCICETransport) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebRTCICETransport, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// An object to track the receiving aspect of the stream
///
/// Mostly matches the WebRTC RTCRtpReceiver interface.
pub const WebRTCRTPReceiver = opaque {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstwebrtc.WebRTCRTPReceiverClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The DTLS transport for this receiver
        pub const transport = struct {
            pub const name = "transport";

            pub const Type = ?*gstwebrtc.WebRTCDTLSTransport;
        };
    };

    pub const signals = struct {};

    extern fn gst_webrtc_rtp_receiver_get_type() usize;
    pub const getGObjectType = gst_webrtc_rtp_receiver_get_type;

    extern fn g_object_ref(p_self: *gstwebrtc.WebRTCRTPReceiver) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstwebrtc.WebRTCRTPReceiver) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebRTCRTPReceiver, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// An object to track the sending aspect of the stream
///
/// Mostly matches the WebRTC RTCRtpSender interface.
pub const WebRTCRTPSender = opaque {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstwebrtc.WebRTCRTPSenderClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The priority from which to set the DSCP field on packets
        pub const priority = struct {
            pub const name = "priority";

            pub const Type = gstwebrtc.WebRTCPriorityType;
        };

        /// The DTLS transport for this sender
        pub const transport = struct {
            pub const name = "transport";

            pub const Type = ?*gstwebrtc.WebRTCDTLSTransport;
        };
    };

    pub const signals = struct {};

    /// Sets the content of the IPv4 Type of Service (ToS), also known as DSCP
    /// (Differentiated Services Code Point).
    /// This also sets the Traffic Class field of IPv6.
    extern fn gst_webrtc_rtp_sender_set_priority(p_sender: *WebRTCRTPSender, p_priority: gstwebrtc.WebRTCPriorityType) void;
    pub const setPriority = gst_webrtc_rtp_sender_set_priority;

    extern fn gst_webrtc_rtp_sender_get_type() usize;
    pub const getGObjectType = gst_webrtc_rtp_sender_get_type;

    extern fn g_object_ref(p_self: *gstwebrtc.WebRTCRTPSender) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstwebrtc.WebRTCRTPSender) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebRTCRTPSender, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Mostly matches the WebRTC RTCRtpTransceiver interface.
pub const WebRTCRTPTransceiver = opaque {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstwebrtc.WebRTCRTPTransceiverClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Caps representing the codec preferences.
        pub const codec_preferences = struct {
            pub const name = "codec-preferences";

            pub const Type = ?*gst.Caps;
        };

        /// The transceiver's current directionality, or none if the
        /// transceiver is stopped or has never participated in an exchange
        /// of offers and answers. To change the transceiver's
        /// directionality, set the value of the direction property.
        pub const current_direction = struct {
            pub const name = "current-direction";

            pub const Type = gstwebrtc.WebRTCRTPTransceiverDirection;
        };

        /// Direction of the transceiver.
        pub const direction = struct {
            pub const name = "direction";

            pub const Type = gstwebrtc.WebRTCRTPTransceiverDirection;
        };

        /// The kind of media this transceiver transports
        pub const kind = struct {
            pub const name = "kind";

            pub const Type = gstwebrtc.WebRTCKind;
        };

        /// The media ID of the m-line associated with this transceiver. This
        /// association is established, when possible, whenever either a
        /// local or remote description is applied. This field is null if
        /// neither a local or remote description has been applied, or if its
        /// associated m-line is rejected by either a remote offer or any
        /// answer.
        pub const mid = struct {
            pub const name = "mid";

            pub const Type = ?[*:0]u8;
        };

        pub const mlineindex = struct {
            pub const name = "mlineindex";

            pub const Type = c_uint;
        };

        pub const receiver = struct {
            pub const name = "receiver";

            pub const Type = ?*gstwebrtc.WebRTCRTPReceiver;
        };

        pub const sender = struct {
            pub const name = "sender";

            pub const Type = ?*gstwebrtc.WebRTCRTPSender;
        };
    };

    pub const signals = struct {};

    extern fn gst_webrtc_rtp_transceiver_get_type() usize;
    pub const getGObjectType = gst_webrtc_rtp_transceiver_get_type;

    extern fn g_object_ref(p_self: *gstwebrtc.WebRTCRTPTransceiver) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstwebrtc.WebRTCRTPTransceiver) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebRTCRTPTransceiver, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCSCTPTransport = opaque {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{};
    pub const Class = gstwebrtc.WebRTCSCTPTransportClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const max_channels = struct {
            pub const name = "max-channels";

            pub const Type = c_uint;
        };

        pub const max_message_size = struct {
            pub const name = "max-message-size";

            pub const Type = u64;
        };

        pub const state = struct {
            pub const name = "state";

            pub const Type = gstwebrtc.WebRTCSCTPTransportState;
        };

        pub const transport = struct {
            pub const name = "transport";

            pub const Type = ?*gstwebrtc.WebRTCDTLSTransport;
        };
    };

    pub const signals = struct {};

    extern fn gst_webrtc_sctp_transport_get_type() usize;
    pub const getGObjectType = gst_webrtc_sctp_transport_get_type;

    extern fn g_object_ref(p_self: *gstwebrtc.WebRTCSCTPTransport) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstwebrtc.WebRTCSCTPTransport) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebRTCSCTPTransport, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCDTLSTransportClass = opaque {
    pub const Instance = gstwebrtc.WebRTCDTLSTransport;

    pub fn as(p_instance: *WebRTCDTLSTransportClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCDataChannelClass = opaque {
    pub const Instance = gstwebrtc.WebRTCDataChannel;

    pub fn as(p_instance: *WebRTCDataChannelClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCICECandidateStats = extern struct {
    f_ipaddr: ?[*:0]u8,
    f_port: c_uint,
    f_stream_id: c_uint,
    f_type: ?[*:0]const u8,
    f_proto: ?[*:0]const u8,
    f_relay_proto: ?[*:0]const u8,
    f_prio: c_uint,
    f_url: ?[*:0]u8,
    f__gst_reserved: [20]*anyopaque,

    extern fn gst_webrtc_ice_candidate_stats_copy(p_stats: *WebRTCICECandidateStats) *gstwebrtc.WebRTCICECandidateStats;
    pub const copy = gst_webrtc_ice_candidate_stats_copy;

    /// Helper function to free `gstwebrtc.WebRTCICECandidateStats`
    extern fn gst_webrtc_ice_candidate_stats_free(p_stats: *WebRTCICECandidateStats) void;
    pub const free = gst_webrtc_ice_candidate_stats_free;

    extern fn gst_webrtc_ice_candidate_stats_get_type() usize;
    pub const getGObjectType = gst_webrtc_ice_candidate_stats_get_type;
};

pub const WebRTCICEClass = extern struct {
    pub const Instance = gstwebrtc.WebRTCICE;

    f_parent_class: gst.ObjectClass,
    f_add_stream: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_session_id: c_uint) callconv(.C) ?*gstwebrtc.WebRTCICEStream,
    f_find_transport: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream, p_component: gstwebrtc.WebRTCICEComponent) callconv(.C) ?*gstwebrtc.WebRTCICETransport,
    f_gather_candidates: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream) callconv(.C) c_int,
    f_add_candidate: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream, p_candidate: [*:0]const u8, p_promise: ?*gst.Promise) callconv(.C) void,
    f_set_local_credentials: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream, p_ufrag: [*:0]const u8, p_pwd: [*:0]const u8) callconv(.C) c_int,
    f_set_remote_credentials: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream, p_ufrag: [*:0]const u8, p_pwd: [*:0]const u8) callconv(.C) c_int,
    f_add_turn_server: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_uri: [*:0]const u8) callconv(.C) c_int,
    f_set_is_controller: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_controller: c_int) callconv(.C) void,
    f_get_is_controller: ?*const fn (p_ice: *gstwebrtc.WebRTCICE) callconv(.C) c_int,
    f_set_force_relay: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_force_relay: c_int) callconv(.C) void,
    f_set_stun_server: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_uri: ?[*:0]const u8) callconv(.C) void,
    f_get_stun_server: ?*const fn (p_ice: *gstwebrtc.WebRTCICE) callconv(.C) ?[*:0]u8,
    f_set_turn_server: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_uri: ?[*:0]const u8) callconv(.C) void,
    f_get_turn_server: ?*const fn (p_ice: *gstwebrtc.WebRTCICE) callconv(.C) ?[*:0]u8,
    f_set_http_proxy: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_uri: [*:0]const u8) callconv(.C) void,
    f_get_http_proxy: ?*const fn (p_ice: *gstwebrtc.WebRTCICE) callconv(.C) [*:0]u8,
    f_set_tos: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream, p_tos: c_uint) callconv(.C) void,
    f_set_on_ice_candidate: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_func: gstwebrtc.WebRTCICEOnCandidateFunc, p_user_data: ?*anyopaque, p_notify: ?glib.DestroyNotify) callconv(.C) void,
    f_get_local_candidates: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream) callconv(.C) **gstwebrtc.WebRTCICECandidateStats,
    f_get_remote_candidates: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream) callconv(.C) **gstwebrtc.WebRTCICECandidateStats,
    f_get_selected_pair: ?*const fn (p_ice: *gstwebrtc.WebRTCICE, p_stream: *gstwebrtc.WebRTCICEStream, p_local_stats: **gstwebrtc.WebRTCICECandidateStats, p_remote_stats: **gstwebrtc.WebRTCICECandidateStats) callconv(.C) c_int,
    f__gst_reserved: [4]*anyopaque,

    pub fn as(p_instance: *WebRTCICEClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCICEStreamClass = extern struct {
    pub const Instance = gstwebrtc.WebRTCICEStream;

    f_parent_class: gst.ObjectClass,
    f_find_transport: ?*const fn (p_stream: *gstwebrtc.WebRTCICEStream, p_component: gstwebrtc.WebRTCICEComponent) callconv(.C) ?*gstwebrtc.WebRTCICETransport,
    f_gather_candidates: ?*const fn (p_ice: *gstwebrtc.WebRTCICEStream) callconv(.C) c_int,

    pub fn as(p_instance: *WebRTCICEStreamClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCICETransportClass = extern struct {
    pub const Instance = gstwebrtc.WebRTCICETransport;

    f_parent_class: gst.ObjectClass,
    f_gather_candidates: ?*const fn (p_transport: *gstwebrtc.WebRTCICETransport) callconv(.C) c_int,
    f__padding: [4]*anyopaque,

    pub fn as(p_instance: *WebRTCICETransportClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCRTPReceiverClass = opaque {
    pub const Instance = gstwebrtc.WebRTCRTPReceiver;

    pub fn as(p_instance: *WebRTCRTPReceiverClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCRTPSenderClass = opaque {
    pub const Instance = gstwebrtc.WebRTCRTPSender;

    pub fn as(p_instance: *WebRTCRTPSenderClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCRTPTransceiverClass = opaque {
    pub const Instance = gstwebrtc.WebRTCRTPTransceiver;

    pub fn as(p_instance: *WebRTCRTPTransceiverClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebRTCSCTPTransportClass = opaque {
    pub const Instance = gstwebrtc.WebRTCSCTPTransport;

    pub fn as(p_instance: *WebRTCSCTPTransportClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// See <https://www.w3.org/TR/webrtc/`rtcsessiondescription`-class>
pub const WebRTCSessionDescription = extern struct {
    /// the `gstwebrtc.WebRTCSDPType` of the description
    f_type: gstwebrtc.WebRTCSDPType,
    /// the `gstsdp.SDPMessage` of the description
    f_sdp: ?*gstsdp.SDPMessage,

    extern fn gst_webrtc_session_description_new(p_type: gstwebrtc.WebRTCSDPType, p_sdp: *gstsdp.SDPMessage) *gstwebrtc.WebRTCSessionDescription;
    pub const new = gst_webrtc_session_description_new;

    extern fn gst_webrtc_session_description_copy(p_src: *const WebRTCSessionDescription) *gstwebrtc.WebRTCSessionDescription;
    pub const copy = gst_webrtc_session_description_copy;

    /// Free `desc` and all associated resources
    extern fn gst_webrtc_session_description_free(p_desc: *WebRTCSessionDescription) void;
    pub const free = gst_webrtc_session_description_free;

    extern fn gst_webrtc_session_description_get_type() usize;
    pub const getGObjectType = gst_webrtc_session_description_get_type;
};

/// See https://tools.ietf.org/html/draft-ietf-rtcweb-jsep-24`section`-4.1.1
/// for more information.
pub const WebRTCBundlePolicy = enum(c_int) {
    none = 0,
    balanced = 1,
    max_compat = 2,
    max_bundle = 3,
    _,

    extern fn gst_webrtc_bundle_policy_get_type() usize;
    pub const getGObjectType = gst_webrtc_bundle_policy_get_type;
};

pub const WebRTCDTLSSetup = enum(c_int) {
    none = 0,
    actpass = 1,
    active = 2,
    passive = 3,
    _,

    extern fn gst_webrtc_dtls_setup_get_type() usize;
    pub const getGObjectType = gst_webrtc_dtls_setup_get_type;
};

pub const WebRTCDTLSTransportState = enum(c_int) {
    new = 0,
    closed = 1,
    failed = 2,
    connecting = 3,
    connected = 4,
    _,

    extern fn gst_webrtc_dtls_transport_state_get_type() usize;
    pub const getGObjectType = gst_webrtc_dtls_transport_state_get_type;
};

/// See <http://w3c.github.io/webrtc-pc/`dom`-rtcdatachannelstate>
pub const WebRTCDataChannelState = enum(c_int) {
    connecting = 1,
    open = 2,
    closing = 3,
    closed = 4,
    _,

    extern fn gst_webrtc_data_channel_state_get_type() usize;
    pub const getGObjectType = gst_webrtc_data_channel_state_get_type;
};

/// See <https://www.w3.org/TR/webrtc/`dom`-rtcerrordetailtype> for more information.
pub const WebRTCError = enum(c_int) {
    data_channel_failure = 0,
    dtls_failure = 1,
    fingerprint_failure = 2,
    sctp_failure = 3,
    sdp_syntax_error = 4,
    hardware_encoder_not_available = 5,
    encoder_error = 6,
    invalid_state = 7,
    internal_failure = 8,
    invalid_modification = 9,
    type_error = 10,
    _,

    extern fn gst_webrtc_error_quark() glib.Quark;
    pub const quark = gst_webrtc_error_quark;

    extern fn gst_webrtc_error_get_type() usize;
    pub const getGObjectType = gst_webrtc_error_get_type;
};

pub const WebRTCFECType = enum(c_int) {
    none = 0,
    ulp_red = 1,
    _,

    extern fn gst_webrtc_fec_type_get_type() usize;
    pub const getGObjectType = gst_webrtc_fec_type_get_type;
};

pub const WebRTCICEComponent = enum(c_int) {
    rtp = 0,
    rtcp = 1,
    _,

    extern fn gst_webrtc_ice_component_get_type() usize;
    pub const getGObjectType = gst_webrtc_ice_component_get_type;
};

/// See <http://w3c.github.io/webrtc-pc/`dom`-rtciceconnectionstate>
pub const WebRTCICEConnectionState = enum(c_int) {
    new = 0,
    checking = 1,
    connected = 2,
    completed = 3,
    failed = 4,
    disconnected = 5,
    closed = 6,
    _,

    extern fn gst_webrtc_ice_connection_state_get_type() usize;
    pub const getGObjectType = gst_webrtc_ice_connection_state_get_type;
};

/// See <http://w3c.github.io/webrtc-pc/`dom`-rtcicegatheringstate>
pub const WebRTCICEGatheringState = enum(c_int) {
    new = 0,
    gathering = 1,
    complete = 2,
    _,

    extern fn gst_webrtc_ice_gathering_state_get_type() usize;
    pub const getGObjectType = gst_webrtc_ice_gathering_state_get_type;
};

pub const WebRTCICERole = enum(c_int) {
    controlled = 0,
    controlling = 1,
    _,

    extern fn gst_webrtc_ice_role_get_type() usize;
    pub const getGObjectType = gst_webrtc_ice_role_get_type;
};

/// See https://tools.ietf.org/html/draft-ietf-rtcweb-jsep-24`section`-4.1.1
/// for more information.
pub const WebRTCICETransportPolicy = enum(c_int) {
    all = 0,
    relay = 1,
    _,

    extern fn gst_webrtc_ice_transport_policy_get_type() usize;
    pub const getGObjectType = gst_webrtc_ice_transport_policy_get_type;
};

/// https://w3c.github.io/mediacapture-main/`dom`-mediastreamtrack-kind
pub const WebRTCKind = enum(c_int) {
    unknown = 0,
    audio = 1,
    video = 2,
    _,

    extern fn gst_webrtc_kind_get_type() usize;
    pub const getGObjectType = gst_webrtc_kind_get_type;
};

/// See <http://w3c.github.io/webrtc-pc/`dom`-rtcpeerconnectionstate>
pub const WebRTCPeerConnectionState = enum(c_int) {
    new = 0,
    connecting = 1,
    connected = 2,
    disconnected = 3,
    failed = 4,
    closed = 5,
    _,

    extern fn gst_webrtc_peer_connection_state_get_type() usize;
    pub const getGObjectType = gst_webrtc_peer_connection_state_get_type;
};

/// See <http://w3c.github.io/webrtc-pc/`dom`-rtcprioritytype>
pub const WebRTCPriorityType = enum(c_int) {
    very_low = 1,
    low = 2,
    medium = 3,
    high = 4,
    _,

    extern fn gst_webrtc_priority_type_get_type() usize;
    pub const getGObjectType = gst_webrtc_priority_type_get_type;
};

pub const WebRTCRTPTransceiverDirection = enum(c_int) {
    none = 0,
    inactive = 1,
    sendonly = 2,
    recvonly = 3,
    sendrecv = 4,
    _,

    extern fn gst_webrtc_rtp_transceiver_direction_get_type() usize;
    pub const getGObjectType = gst_webrtc_rtp_transceiver_direction_get_type;
};

/// See <http://w3c.github.io/webrtc-pc/`dom`-rtcsctptransportstate>
pub const WebRTCSCTPTransportState = enum(c_int) {
    new = 0,
    connecting = 1,
    connected = 2,
    closed = 3,
    _,

    extern fn gst_webrtc_sctp_transport_state_get_type() usize;
    pub const getGObjectType = gst_webrtc_sctp_transport_state_get_type;
};

/// See <http://w3c.github.io/webrtc-pc/`rtcsdptype`>
pub const WebRTCSDPType = enum(c_int) {
    offer = 1,
    pranswer = 2,
    answer = 3,
    rollback = 4,
    _,

    extern fn gst_webrtc_sdp_type_to_string(p_type: gstwebrtc.WebRTCSDPType) [*:0]const u8;
    pub const toString = gst_webrtc_sdp_type_to_string;

    extern fn gst_webrtc_sdp_type_get_type() usize;
    pub const getGObjectType = gst_webrtc_sdp_type_get_type;
};

/// See <http://w3c.github.io/webrtc-pc/`dom`-rtcsignalingstate>
pub const WebRTCSignalingState = enum(c_int) {
    stable = 0,
    closed = 1,
    have_local_offer = 2,
    have_remote_offer = 3,
    have_local_pranswer = 4,
    have_remote_pranswer = 5,
    _,

    extern fn gst_webrtc_signaling_state_get_type() usize;
    pub const getGObjectType = gst_webrtc_signaling_state_get_type;
};

/// See <https://w3c.github.io/webrtc-stats/`dom`-rtcstatstype>
pub const WebRTCStatsType = enum(c_int) {
    codec = 1,
    inbound_rtp = 2,
    outbound_rtp = 3,
    remote_inbound_rtp = 4,
    remote_outbound_rtp = 5,
    csrc = 6,
    peer_connection = 7,
    data_channel = 8,
    stream = 9,
    transport = 10,
    candidate_pair = 11,
    local_candidate = 12,
    remote_candidate = 13,
    certificate = 14,
    _,

    extern fn gst_webrtc_stats_type_get_type() usize;
    pub const getGObjectType = gst_webrtc_stats_type_get_type;
};

/// Callback function to be triggered on discovery of a new candidate
pub const WebRTCICEOnCandidateFunc = *const fn (p_ice: *gstwebrtc.WebRTCICE, p_stream_id: c_uint, p_candidate: [*:0]const u8, p_user_data: ?*anyopaque) callconv(.C) void;
