/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.smtp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ProtocolCommandSupport;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.smtp.SMTPCommand;
import org.apache.commons.net.smtp.SMTPConnectionClosedException;

public class SMTP
extends SocketClient {
    public static final int DEFAULT_PORT = 25;
    private static final String __DEFAULT_ENCODING = "ISO-8859-1";
    private StringBuffer __commandBuffer;
    BufferedReader _reader;
    BufferedWriter _writer;
    int _replyCode;
    Vector _replyLines;
    boolean _newReplyString;
    String _replyString;
    protected ProtocolCommandSupport _commandSupport_;

    public SMTP() {
        this.setDefaultPort(25);
        this.__commandBuffer = new StringBuffer();
        this._replyLines = new Vector();
        this._newReplyString = false;
        this._replyString = null;
        this._commandSupport_ = new ProtocolCommandSupport(this);
    }

    private void __getReply() throws IOException {
        this._newReplyString = true;
        this._replyLines.setSize(0);
        String string = this._reader.readLine();
        if (string == null) {
            throw new SMTPConnectionClosedException("Connection closed without indication.");
        }
        int n = string.length();
        if (n < 3) {
            throw new MalformedServerReplyException("Truncated server reply: " + string);
        }
        try {
            String string2 = string.substring(0, 3);
            this._replyCode = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedServerReplyException("Could not parse response code.\nServer Reply: " + string);
        }
        this._replyLines.addElement(string);
        if (n > 3 && string.charAt(3) == '-') {
            do {
                if ((string = this._reader.readLine()) == null) {
                    throw new SMTPConnectionClosedException("Connection closed without indication.");
                }
                this._replyLines.addElement(string);
            } while (string.length() < 4 || string.charAt(3) == '-' || !Character.isDigit(string.charAt(0)));
        }
        if (this._commandSupport_.getListenerCount() > 0) {
            this._commandSupport_.fireReplyReceived(this._replyCode, this.getReplyString());
        }
        if (this._replyCode == 421) {
            throw new SMTPConnectionClosedException("SMTP response 421 received.  Server closed connection.");
        }
    }

    private int __sendCommand(int n, String string, boolean bl) throws IOException {
        return this.__sendCommand(SMTPCommand._commands[n], string, bl);
    }

    private int __sendCommand(String string, String string2, boolean bl) throws IOException {
        this.__commandBuffer.setLength(0);
        this.__commandBuffer.append(string);
        if (string2 != null) {
            if (bl) {
                this.__commandBuffer.append(' ');
            }
            this.__commandBuffer.append(string2);
        }
        this.__commandBuffer.append("\r\n");
        String string3 = this.__commandBuffer.toString();
        this._writer.write(string3);
        this._writer.flush();
        if (this._commandSupport_.getListenerCount() > 0) {
            this._commandSupport_.fireCommandSent(string, string3);
        }
        this.__getReply();
        return this._replyCode;
    }

    protected void _connectAction_() throws IOException {
        super._connectAction_();
        this._reader = new BufferedReader(new InputStreamReader(this._input_, __DEFAULT_ENCODING));
        this._writer = new BufferedWriter(new OutputStreamWriter(this._output_, __DEFAULT_ENCODING));
        this.__getReply();
    }

    public void addProtocolCommandListener(ProtocolCommandListener protocolCommandListener) {
        this._commandSupport_.addProtocolCommandListener(protocolCommandListener);
    }

    public int data() throws IOException {
        return this.sendCommand(3);
    }

    public void disconnect() throws IOException {
        super.disconnect();
        this._reader = null;
        this._writer = null;
        this._replyString = null;
        this._replyLines.setSize(0);
        this._newReplyString = false;
    }

    public int expn(String string) throws IOException {
        return this.sendCommand(9, string);
    }

    public int getReply() throws IOException {
        this.__getReply();
        return this._replyCode;
    }

    public int getReplyCode() {
        return this._replyCode;
    }

    public String getReplyString() {
        if (!this._newReplyString) {
            return this._replyString;
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        Enumeration enumeration = this._replyLines.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append((String)enumeration.nextElement());
            stringBuffer.append("\r\n");
        }
        this._newReplyString = false;
        this._replyString = stringBuffer.toString();
        return this._replyString;
    }

    public String[] getReplyStrings() {
        Object[] objectArray = new String[this._replyLines.size()];
        this._replyLines.copyInto(objectArray);
        return objectArray;
    }

    public int helo(String string) throws IOException {
        return this.sendCommand(0, string);
    }

    public int help() throws IOException {
        return this.sendCommand(10);
    }

    public int help(String string) throws IOException {
        return this.sendCommand(10, string);
    }

    public int mail(String string) throws IOException {
        return this.__sendCommand(1, string, false);
    }

    public int noop() throws IOException {
        return this.sendCommand(11);
    }

    public int quit() throws IOException {
        return this.sendCommand(13);
    }

    public int rcpt(String string) throws IOException {
        return this.__sendCommand(2, string, false);
    }

    public void removeProtocolCommandistener(ProtocolCommandListener protocolCommandListener) {
        this._commandSupport_.removeProtocolCommandListener(protocolCommandListener);
    }

    public int rset() throws IOException {
        return this.sendCommand(7);
    }

    public int saml(String string) throws IOException {
        return this.sendCommand(6, string);
    }

    public int send(String string) throws IOException {
        return this.sendCommand(4, string);
    }

    public int sendCommand(int n) throws IOException {
        return this.sendCommand(n, null);
    }

    public int sendCommand(int n, String string) throws IOException {
        return this.sendCommand(SMTPCommand._commands[n], string);
    }

    public int sendCommand(String string) throws IOException {
        return this.sendCommand(string, null);
    }

    public int sendCommand(String string, String string2) throws IOException {
        return this.__sendCommand(string, string2, true);
    }

    public int soml(String string) throws IOException {
        return this.sendCommand(5, string);
    }

    public int turn() throws IOException {
        return this.sendCommand(12);
    }

    public int vrfy(String string) throws IOException {
        return this.sendCommand(8, string);
    }
}

