/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.h2.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableManager;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.h2.model.H2Constraint;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class H2TableManager
extends GenericTableManager
implements DBEObjectRenamer<GenericTableBase> {
    private static final Class<? extends DBSObject>[] CHILD_TYPES = (Class[])CommonUtils.array((Object[])new Class[]{GenericTableColumn.class, H2Constraint.class, GenericTableForeignKey.class, GenericTableIndex.class});

    @NotNull
    public Class<? extends DBSObject>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public Collection<? extends DBSObject> getChildObjects(DBRProgressMonitor monitor, GenericTableBase object, Class<? extends DBSObject> childType) throws DBException {
        if (childType == H2Constraint.class) {
            return object.getConstraints(monitor);
        }
        return super.getChildObjects(monitor, (DBSObject)object, childType);
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericTableBase object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        GenericTableBase tableBase = (GenericTableBase)command.getObject();
        GenericDataSource dataSource = (GenericDataSource)tableBase.getDataSource();
        GenericStructContainer container = tableBase.getParentObject();
        if (container != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "ALTER TABLE " + DBUtils.getFullyQualifiedName((DBPDataSource)dataSource, (String[])new String[]{container.getName(), command.getOldName()}) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
        }
    }
}

