/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'revert_creds' function
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process calls 'rever_creds', we need to correctly handle this situation
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 10.X.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"

char p_revert_creds_kretprobe_state = 0;

static struct kretprobe p_revert_creds_kretprobe = {
    .kp.symbol_name = "revert_creds",
    .handler = p_revert_creds_ret,
    .entry_handler = p_revert_creds_entry,
    .data_size = sizeof(struct p_revert_creds_data),
};


notrace int p_revert_creds_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

#ifdef P_LKRG_TASK_OFF_DEBUG
   struct p_ed_process *p_tmp;
   unsigned long p_flags;

   if (p_is_ed_task(current)) {
      // Update process
      p_tasks_write_lock(&p_flags);
      if ( (p_tmp = p_find_ed_by_pid(task_pid_nr(current))) != NULL) {
         p_debug_off_flag_override_on(p_tmp, 32, p_regs);
      }
      p_tasks_write_unlock(&p_flags);
   }
#endif
   return 0;
}


notrace int p_revert_creds_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;
   unsigned long p_flags;

   if (p_is_ed_task(current)) {
      // Update process
      p_tasks_write_lock(&p_flags);
      if ( (p_tmp = p_find_ed_by_pid(task_pid_nr(current))) != NULL) {
         p_set_ed_process_override_on(p_tmp);
         p_ed_enforce_pcfi(current, p_tmp, p_regs);
      }
      p_ed_validate_current();
      p_tasks_write_unlock(&p_flags);
   }

   return 0;
}


GENERATE_INSTALL_FUNC(revert_creds)
