// sample action.c file
//
// Ok, you have to modify this file to set up a default handler that will
// be called whenever a host is unreachable.  If you don't care, and just
// want email sent to root, then this setup should be fine.  But, if you
// are feeling super-rad, you can edit this file to do pretty much
// anything you like, such as a popup dialog, instant messaging, paging,
// whatever.  If you have a clever file, I'd love to see it...please email
// me at nik@aboleo.net and send it my way.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "portmon.h"

// default action handler is to just send email to root
int err_action(char *hostname, char *err_msg)
{
 FILE *out_pipe;

 // open up a pipe that we will send the error message to
 // if you are lazy, just change 'root' to whoever you want to get
 // email notification.  Or just see 'man 1 mail'.
 // NOTE: on some systems
 if((out_pipe = popen("mail -s 'portmon update' root", "w")) == NULL) {
  perror("popen");
  exit(1);
 }

 // print out to the pipe.  Note that the 'sendmail' program can do this
 // as well, with many more options than /bin/mail.
 fprintf(out_pipe, "At %s, the host %s reported:\n", get_time(time(NULL)),
         hostname);
 fprintf(out_pipe, "%s\n", err_msg);

 // close the pipe
 if(pclose(out_pipe) == -1) {
  perror("pclose");
  exit(1);
 }
 return (0);
}
