/*
** report.c -- Generate portmon reports
** Copyright (C) 2002 Nik Reiman <nik@aboleo.net>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "config.h"
#include "portmon.h"

#define DEFAULT_OUTPUT "%s Service on %h:%p is %w (%lms)"

int report(int num_hosts, int num_probes, int lag_timeout, char *output_fmt)
{
 int i, j, k, total_milli = 0, num_good_probes = 0, ret = 0, avg_time;
 char out_str[STRLARGE];

 for(i = 0; i < num_hosts; i++) {
  for(j = 0; j < hosts[i].num_ports; j++) {
   num_good_probes = 0;
   avg_time = 0;
   if(hosts[i].ports[j].port == 0) {
    for(k = 0; k < num_probes; k++) {
     if(verbose) {
      printf("Attempting to ping %s -> ", hosts[i].name);
     }
     ret = icmp_ping(hosts[i].ports[j].addr);
     if(ret >= 0) {
      total_milli += ret;
      num_good_probes++;
     }
    }
   }
   else {
    for(k = 0; k < num_probes; k++) {
     if(verbose) {
      printf("Attempting to contact %s:%d -> ", hosts[i].name, hosts[i].ports[j].port);
     }
     ret = tcp_ping(hosts[i].ports[j].addr, hosts[i].ports[j].port);
     if(ret >= 0) {
      total_milli += ret;
      num_good_probes++;
     }
    }
   }

   if(ret < 0) {
    format_output(output_fmt, out_str, hosts[i].name, hosts[i].ports[j].port, avg_time, '!', "down");
    printf("%s\n", out_str);
   }
   else {
    avg_time = total_milli / num_good_probes;
    if(avg_time < lag_timeout) {
     format_output(output_fmt, out_str, hosts[i].name, hosts[i].ports[j].port, avg_time, '-', "normal");
     printf("%s\n", out_str);
    }
    else {
     format_output(output_fmt, out_str, hosts[i].name, hosts[i].ports[j].port, avg_time, '+', "lagged");
     printf("%s\n", out_str);
    }
   }
  }
 }
 return (0);
}

int format_output(char *output_fmt, char *out_str, char *hostname, int port, int lag, char status, char *wd_status) {
 int i, pct_state = 0;
 char active_out_fmt[STRMED];

 if(output_fmt == NULL) {
  strncpy(active_out_fmt, DEFAULT_OUTPUT, STRMED);
 }
 else {
  strncpy(active_out_fmt, output_fmt, STRMED);
 }
 bzero(out_str, STRMED);

 for(i = 0; i < strlen(active_out_fmt); i++) {
  if(active_out_fmt[i] == '%') {
   pct_state = 1;
  }
  else if(pct_state == 1) {
   if(active_out_fmt[i] == '%') {
    strncat(out_str, "%", 1);
   }
   else if(active_out_fmt[i] == 'h') {
    strncat(out_str, hostname, strlen(hostname));
   }
   else if(active_out_fmt[i] == 'p') {
    sprintf(out_str, "%s%d", out_str, port);
   }
   else if(active_out_fmt[i] == 'l') {
    sprintf(out_str, "%s%d", out_str, lag);
   }
   else if(active_out_fmt[i] == 's') {
    sprintf(out_str, "%s%c", out_str, status);
   }
   else if(active_out_fmt[i] == 'w') {
    strncat(out_str, wd_status, strlen(wd_status));
   }
   else { }

   pct_state = 0;
  }
  else if(pct_state == 0) {
   strncat(out_str, active_out_fmt + i, 1);
  }
 }

 return 0;
}
