#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "nomktime.h"
time_t
nomktime(int year, int mon, int day, int hour, int min, int sec)
{
	static time_t ref = 0;
	struct tm zeit;
	static long days_to_month[] = { 0,31,59,90,120,151,181,212,243,273,304,334,365 };
	long days;

	/* Referenz-time_t vom 1.1.1990 berechnen */
	if (!ref)
	{
		zeit.tm_year = 1990 - 1900;
		zeit.tm_mon  = 0;
		zeit.tm_mday = 1;
		zeit.tm_hour = 0;
		zeit.tm_min  = 0;
		zeit.tm_sec  = 0;
		zeit.tm_isdst= 0;
		zeit.tm_yday = 0;
		zeit.tm_wday = 0;
		ref = mktime(&zeit);
	}

	if (year < 1990)
	{
		zeit.tm_year = year - 1900;
		zeit.tm_mon  = mon;
		zeit.tm_mday = day;
		zeit.tm_hour = hour;
		zeit.tm_min  = min;
		zeit.tm_sec  = sec;
		zeit.tm_isdst= 0;
		zeit.tm_yday = 0;
		zeit.tm_wday = 0;
		return mktime(&zeit);
	}

	/* Anzahl Tage ohne Beruecksichtigung der Schaltjahre */
	days = (year - 1990) * 365L + days_to_month[mon] + day -1;
	/* Anzahl Schalttage berechnen, letztes (vor 1990) war 1988 
	 * Berechnung ist gltig bis 2400 - das drfte reichen :-) */
	days += (year - 1988) /4;
	if ((year - 1988) %4 == 0)
	{
		/* wir sind in einem Schaltjahr */
		/* In Januar und Februar um einen Tag nach unten korrigieren */
		if (mon<2) days--;
	}

	return ref + days * 86400L + hour * 3600L + min * 60 + sec;
} /* nomktime */
