#include <stdlib.h>
#include <stdio.h> /* rename */
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <signal.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "dirsysdep.h" /* compat */
#include "str_ulong.h"
#include "uostr.h"
#include "uoio.h"
#include "smtp.h"
#include "smtptools.h"
#include "maildirblast.h"
#include "attribs.h"
#include "filelock.h"
#include "dns.h"
#include "mtalib.h"

#ifndef CAN_LOCK_FILES
error cannot lock files
#endif
static void 
logmsg0(int code,const char *t) 
{ 	union {char *s;const char *cs;} u; uostr_t s;
	u.cs=t; s.data=u.s; s.len=s.size=strlen(t);
	logmsguo(code,&s); }

static int
open_msgfile(const char *fname)
{
	int cfd;
	cfd=open(fname,O_RDWR); /* WR because of lock */
	if (cfd==-1 && errno==ENOENT)
		/* someone else took care of it */
		return -2;
	if (cfd==-1 && errno==EISDIR)
		/* subdirectories are silently unsupported, . and .. don`t care */
		return -2;
	if (cfd==-1) {
		uostr_t logstr;logstr.data=0;
		uostr_xdup_cstrmulti(&logstr,"cannot open ",fname,": ",strerror(errno),NULL);
		logmsguo(SMTP_INFO,&logstr);
		uostr_freedata(&logstr);
		return -1;
	}
	if (-1==fd_write_lock0(cfd)) {
		/* someone else locked it */
		close(cfd);
		return -2;
	}
	return cfd;
}

static int
do_one(const char *host, const char *id, const char *from, const char *to, const char *fname, uostr_t *logstr)
{	
	int status;
	uoio_t rop,wop;
	int fd;
	fd=open(fname,O_RDONLY);
	if (fd==-1) {
		uostr_xadd_cstrmulti(logstr,"cannot open ",fname,": ",strerror(errno),0);
		status=SMTP_DEFER;
		goto cleanup;
	}
	status=smtp_open(id,host,smtpport,greeting,&rop,&wop,logstr);
	if (status!=SMTP_SUCCESS) goto cleanup;
	status=smtp_send(id,host,&rop,&wop,from,to,fd,logstr);
	if (!(status & SMTP_CLOSED)) {
		smtp_close(id,host,&rop,&wop);
	} else {
		status &= ~(SMTP_CLOSED);
	}
  cleanup:
    if (fd!=-1) close(fd);
  	logmsguo(status,logstr);
	return status;
}

static int
bounce(int rfd, const char *fname,const char *from,const char *to,
	const char *id UO_ATTRIB_UNUSED,uostr_t *logstr)
{
	uoio_t i;
	const char *bfrom,*bto;
	int ok=1;
	unsigned long lineno=0;
	mta_ret_t mta_ret;
	mta_t *mta;
	uostr_t tmpfname,panic,str;str.data=panic.data=tmpfname.data=0;


	if (from && *from) {bto=from; bfrom="";}
	else { bto=doublebounceto; bfrom="#@[]";}

	mta_ret=mta_maildir.mta_open(&mta,0,bfrom,bto);
	if (mta_ret!=MTA_SUCCESS) {
		uostr_t s;s.data=0;
		uostr_xdup_cstrmulti(&s,"cannot open file in maildir: ",mta_errtxt,NULL);
		logmsguo(SMTP_DEFER,&s);
		uostr_freedata(&s);
		return -1;
	}

	lseek(rfd,0,SEEK_SET);
	uoio_assign_r(&i,rfd,read,0);
	uostr_xdup_cstrmulti(&str,
		"Return-Path: <",bfrom,">\n"
		"Maildirblast-To: ",bto,"\n" /* can't use delivered-to here */
		"Subject: mail failed\n"
		"From: MAILER-DAEMON\n"
		"To: ",bto,"\n"
		"\n"
		"Hello. This is the maildirblast program on ", greeting, ".\n\n",0);
	if (*bfrom)
		uostr_xadd_cstrmulti(&str,"I tried to deliver your message to the following address.\n  <",
			to,">\n",0);
	else  /* double bounce */
		uostr_xadd_cstrmulti(&str,"I tried to deliver a bounce message to this address:\n  <",
			to,">\n",0);
	uostr_xadd_cstr(&str,"but the delivery failed:\n  ");
	uostr_xadd_uostr(&str,logstr);
	if (*bfrom) uostr_xadd_cstr(&str,"\n\n--- Below this line is a copy of your message:\n\n");
	else        uostr_xadd_cstr(&str,"\n\n--- Below this line is a copy of the original bounce:\n\n");
	mta->mta_write(mta,str.data,str.len);
	uostr_freedata(&str);

	while (1) {
		ssize_t len;
		char *line;
		len=uoio_getdelim_zc(&i,&line,'\n');
		if (len==0) 
			break; /* EOF */
		if (len==-1) {
			/* oh .... */
			uostr_t logstr2;logstr2.data=0;
			uostr_xdup_cstrmulti(&logstr2,"cannot write to XXX: ",strerror(errno),NULL);
			logmsguo(SMTP_DEFER,&logstr2);
			uostr_freedata(&logstr2);
			ok=0;
			break;
		}
		if (max_bounce_lines && lineno++==max_bounce_lines) { /* 0: never */
			const char *btl="\n\n--- bounce too long, shortened\n";
			mta->mta_write(mta,btl,strlen(btl));
			break;
		}
		mta->mta_write(mta,line,len);
	}
	uoio_destroy(&i);
	/* ok, tmp file is written */
	if (MTA_SUCCESS!=mta->mta_close(mta)) {
		uostr_xdup_cstrmulti(&panic,"cannot save ",tmpfname.data,": ",strerror(errno),NULL);
		goto cleanup;
	}
	unlink(fname); /* delete original message */
	alarm(0);
	return 0;
  cleanup:
	logmsguo(SMTP_DEFER,&panic);
	mta->mta_abort(mta);
	uostr_freedata(&tmpfname);
	uostr_freedata(&panic);
	alarm(0);
	return -1;
}

struct mxl {
	dns_t *mxlist;
	int refcount;
};

struct rq_queue {
	char *id;
	char *from;
	char *to;
	char *path;
	char *host;
	struct mxl *mx;
	int done;
	struct rq_queue *next;
};

static struct rq_queue *qanker;

static void
work_queue(void)
{
	struct rq_queue *q,*r;
	/* for get all MX records */
	for (q=qanker;q;q=q->next) {
		for (r=qanker;r;r=r->next) {
			if (0==strcasecmp(q->host,r->host))
				break;
		}
		if (r!=q) /* already resolved this host somewhere else */
			continue;
		q->mx=malloc(sizeof(struct mxl));
		if (!q->mx) { goto oom; }
		q->mx->refcount=1;

		/* need to do DNS-Lookup for MX */
		switch(dns_mx(q->host,&q->mx->mxlist)) {
		case DNS_HARD: break;
		case DNS_SOFT: {
				uostr_t s;s.data=0;
				uostr_xdup_cstr(&s,q->id);
				uostr_xdup_cstr(&s,": soft DNS error");
				logmsguo(SMTP_DEFER,&s);
				uostr_freedata(&s);
				q->done=1; 
				break;
			}
		}
		if (!q->mx->mxlist) {
			q->mx->mxlist=malloc(sizeof(dns_t));
			if (!q->mx->mxlist) { goto oom; }
			memset(q->mx->mxlist,0,sizeof(dns_t));
			q->mx->mxlist->name=strdup(q->host);
			if (!q->mx->mxlist->name) { goto oom; }
			/* now host _has_ a mx list */
		}
		for (r=q->next;r;r=r->next) {
			if (0==strcasecmp(q->host,r->host)) {
				r->mx=q->mx;
				q->mx->refcount++;
			}
		}
	}
	/* got all MX */

	for (q=qanker;q;q=q->next) { /* go through all messages */
		dns_t *mx;
		uoio_t rop,wop;
		int status=SMTP_SUCCESS;
		uostr_t logstr;logstr.data=0;
		if (q->done) continue;
		for (mx=q->mx->mxlist;mx;mx=mx->next) { /* and all MX records */
			status=smtp_open(q->id,mx->name,smtpport,greeting,&rop,&wop,&logstr);
			if (status!=SMTP_SUCCESS) {
				/* note that "SMTP_FATAL" during opening says something about the
				 * host, not the message.
				 */
				status=SMTP_DEFER;
				continue;
			}
			break;
		}
		if (status!=SMTP_SUCCESS) {
			uostr_t s;s.data=0;
			uostr_xdup_cstr(&s,q->id);
			uostr_xdup_cstr(&s,": ");
			uostr_xdup_uostr(&s,&logstr);
			logmsguo(status,&s);
			uostr_freedata(&s);
			/* defer all messages for @host */
			for (r=qanker;r;r=r->next) { /* tries _all_ */
				if (r->done)
					continue;
				if (0!=strcasecmp(r->host,q->host))
					continue;
				r->done=1;
				r->mx->refcount--;
				if (r->mx->refcount==0)
					free(r->mx);
				r->mx=0;
			}
			uostr_freedata(&logstr);
			continue; /* next message */
		}
		/* now that one host is opened go through all undelivered messages
		 * which shall be delivered to the same @host.
		 * Note that we do not try to get "all messages for @hosts who one or
		 * the best MX pointing to our open host". That's not worth the pain.
		 * Note that we are not nice to a machine which has been down for
		 * some days!
		 */
		for (r=qanker;r;r=r->next) { /* tries _all_ */
			int cfd;
			int is_closed=0;
			uostr_t s;s.data=0;
			if (r->done)
				continue;
			if (0!=strcasecmp(r->host,q->host))
				continue;
			cfd=open_msgfile(r->path);
			if (cfd==-1) continue; /* open_msgfile logged */
			if (cfd==-2) {r->done=1; continue;} /* ignored for some reason */
			status=smtp_send(q->id,mx->name,&rop,&wop,r->from,r->to,cfd,&logstr);
			if (status & SMTP_CLOSED) {
				is_closed=1;
				status &= ~(SMTP_CLOSED);
			}
			uostr_xdup_cstr(&s,q->id);
			uostr_xdup_cstr(&s,": ");
			uostr_xdup_uostr(&s,&logstr);
			logmsguo(status,&s);
			uostr_freedata(&s);
			if (status==SMTP_SUCCESS) {
				close(cfd);
				if (-1==unlink(r->path)) {
					uostr_xdup_cstrmulti(&logstr,"cannot unlink ", r->path, ": ",
						strerror(errno),NULL);
					logmsguo(SMTP_DEFER,&logstr);
				}
			} else if (status==SMTP_FATAL) {
				bounce(cfd,r->path,r->from,r->to,r->id,&logstr);
				close(cfd);
			} else close(cfd); /* DEFER */
			r->done=1;
			r->mx->refcount--;
			if (r->mx->refcount==0)
				free(r->mx);
			r->mx=0;
			if (is_closed)
				break;
		} /* one target host */
		uostr_freedata(&logstr);
	} /* outer loop through all messages */
	return;

	oom: logmsg0(SMTP_DEFER,"out of memory"); _exit(1);
}

static int
queue_one (const char *id, const char *from, const char *to, const char *path)
{
	struct rq_queue *n;
	size_t l;
	char *p;
#define D(new,old) do { l=strlen(old)+1;(new)=malloc(l); if (!(new)) goto oom; memcpy((new),(old),l); } while(0)
	n=malloc(sizeof(struct rq_queue));
	if (!n) goto oom;
	memset(n,0,sizeof(*n));
	D(n->id,id);
	D(n->from,from);
	D(n->to,to);
	D(n->path,path);
	p=strchr(to,'@');
	if (!p||!p[1]) D(n->host,"localhost"); 
	else D(n->host,p+1);
#undef D
	n->next=qanker;
	qanker=n;
	return 0;	

  oom:
  	if (n && n->path) free(n->path);
  	if (n && n->from) free(n->from);
  	if (n && n->to) free(n->to);
  	if (n && n->id) free(n->id);
  	if (n && n->host) free(n->host);
	free(n);
    /* could log so much _if_ i could */
  	logmsg0(SMTP_DEFER,"out of memory");
	return -1;
}


static int
onequeuefile(const char *fname)
{
	int cfd;
	int ok=1;
	char *id;
	char *ret_path=NULL;  /* return-path: */
	char *really_to=NULL;
	uoio_t io;
	int retcode=0;
	struct stat st;

	cfd=open(fname,O_RDWR); /* WR because of lock */
	if (cfd==-1 && errno==ENOENT) return 0; /* someone else took care of it */
	if (cfd==-1 && errno==EISDIR) return 0; /* subdirectories are silently unsupported, . and .. don`t care */
	if (cfd==-1) {
		uostr_t logstr;logstr.data=0;
		uostr_xdup_cstrmulti(&logstr,"cannot open ",fname,": ",strerror(errno),NULL);
		logmsguo(SMTP_DEFER,&logstr);
		uostr_freedata(&logstr);
		return -1;
	}
	if (-1==fd_write_lock0(cfd)) {
		/* someone else locked it */
		uostr_t logstr;logstr.data=0;
		close(cfd);
		uostr_xdup_cstrmulti(&logstr,"cannot lock ",fname,": ",strerror(errno),NULL);
		logmsguo(SMTP_INFO,&logstr);
		uostr_freedata(&logstr);
		return 0;
	}

	if (-1==fstat(cfd,&st)) {
		uostr_t logstr;logstr.data=0;
		uostr_xdup_cstrmulti(&logstr,"cannot fstat ",fname,": ",strerror(errno),NULL);
		logmsguo(SMTP_DEFER,&logstr);
		uostr_freedata(&logstr);
		close(cfd);
	}

	id=strrchr(fname,'/')+1;

	/* work on header */
	uoio_assign_r(&io,cfd,read,0);
	while (1) {
		ssize_t len;
		char *line;
		char *p;
		len=uoio_getdelim_zc(&io,&line,'\n');
		if (len==0) break; /* EOF */
		if (len==-1) {
			/* assume we can't write to it, too ... */
			uostr_t logstr;logstr.data=0;
			uostr_xdup_cstrmulti(&logstr,"cannot read ",fname,": ",strerror(errno),NULL);
			logmsguo(SMTP_DEFER,&logstr);
			uostr_freedata(&logstr);
			ok=0;
			break;
		}
		
		if (line[len-1]!='\n') break; /* certainly not a header */
		line[len-1]=0; len--; /* cut of \n */
		if (len==0) break; /* end of header */

		/* name: value separation */
		for(p=line;p-line<len && *p!=':';p++) /* skip to : */;
		if (*p!=':') continue; /* strange */
		*p++=0;
		while (*p==' ' || *p=='\t') p++;

		if (0==strcasecmp(line,"return-path") && !ret_path) {
			size_t l;
			if (*p++!='<'|| !*p) continue; /* strange */
			l=strlen(p);
			ret_path=malloc(l+1);
			if (!ret_path) { logmsg0(SMTP_DEFER,"out of memory"); ok=0; break; }
			memcpy(ret_path,p,l+1);
			p=strchr(ret_path,'>');
			if (p) *p=0;
			continue;
		}
		if (0==strcasecmp(line,"delivered-to") && !really_to) {
			size_t l;
			if (!*p) continue; /* strange */
			l=strlen(p);
			really_to=malloc(l+1);
			if (!really_to) { logmsg0(SMTP_DEFER,"out of memory"); ok=0; break; }
			memcpy(really_to,p,l+1);
			continue;
		}
		if (0==strcasecmp(line,"maildirblast-to") && !really_to) {
			size_t l;
			if (!*p) continue; /* strange */
			l=strlen(p);
			really_to=malloc(l+1);
			if (!really_to) { logmsg0(SMTP_DEFER,"out of memory"); ok=0; break; }
			memcpy(really_to,p,l+1);
			continue;
		}
	}
	uoio_destroy(&io);
	if (!really_to) {
		uostr_t s;s.data=0;
		uostr_xdup_cstrmulti(&s,fname,": no recipient information found",0);
		logmsguo(SMTP_DEFER,&s); 
		ok=0;
		uostr_freedata(&s);
	}

	if (prefix && ok) {
		/* deliver only if recipient starts with a string of "prefix-" */
		size_t l=strlen(prefix);
		if (l>=strlen(really_to))
			ok=0;
		else if (0!=memcmp(really_to,prefix,l) || really_to[l]!='-') 
			ok=0;
		else {
			char *tmp;
			tmp=strdup(really_to+l+1);
			if (!tmp) { logmsg0(SMTP_DEFER,"out of memory"); ok=0; }
			else {
				free(really_to);
				really_to=tmp;
			}
		}
	}

	if (ok) {
		int do_bounce=0;
		int do_remove=0;
		uostr_t logstr;logstr.data=0;
		if (st.st_mtime+14*86400 < time(0)) 
			{ uostr_xdup_cstrmulti(&logstr,"#",id,": ",fname,": too old",NULL); ok=0; }
		if (!ret_path) { uostr_xdup_cstrmulti(&logstr,"#",id,": ",fname,": no from",NULL); ok=0; } 
		if (!really_to) { uostr_xdup_cstrmulti(&logstr,"#",id,": ",fname,": no to",NULL); ok=0; } 
		if (ok) {
			if (relayhost) {
				switch(do_one(relayhost,id,ret_path,really_to,fname,&logstr)) {
				case SMTP_SUCCESS: do_remove=1; break;
				case SMTP_DEFER: break;
				case SMTP_FATAL: do_bounce=1; break;
				}
			} else queue_one(id,ret_path,really_to,fname); /* MX mode */
		} else { logmsguo(SMTP_FATAL,&logstr); do_bounce=1; }
		if (do_bounce) bounce(cfd,fname,ret_path,really_to,id,&logstr);
		if (do_remove) {
			if (-1==unlink(fname)) {
				uostr_xdup_cstrmulti(&logstr,"cannot unlink ", fname, ": ",
					strerror(errno),NULL);
				logmsguo(SMTP_DEFER,&logstr);
			}
		}
		uostr_freedata(&logstr);
	}
	if (ret_path) free(ret_path);
	if (really_to) free(really_to);
	if (cfd!=-1) close(cfd);
	return retcode;

}

void
runqueue(void)
{
	int ec=0;
	DIR *d=NULL;
	int afterslash;
	int lauf;
	uostr_t logstr,dir;dir.data=logstr.data=0;

	/* make sure directories are available */
	d=opendir("tmp");
	if (!d) { uostr_xdup_cstrmulti(&logstr,"cannot opendir tmp: ",strerror(errno),NULL); ec=1; goto cleanup; }
	closedir(d);

	for (lauf=0;lauf<2;lauf++) {
		struct dirent *e;
		if (lauf==0)
			uostr_xdup_cstr(&dir,"new");
		else
			uostr_xdup_cstr(&dir,"cur");
		uostr_x0(&dir);
		d=opendir(dir.data);
		if (!d) {
			uostr_xdup_cstrmulti(&logstr,"cannot opendir ",dir.data,": ",strerror(errno),NULL);
			ec=1;
			if (lauf==0) /* need new directory for bounces! */
				goto cleanup;
			continue;
		}
		uostr_cut(&dir,-1);
		uostr_xadd_char(&dir,'/');
		afterslash=dir.len;
		uostr_x0(&dir);

		while ((errno=0,e=readdir(d))!=NULL) {
			uostr_cut(&dir,afterslash);
			uostr_xadd_cstr(&dir,e->d_name);
			uostr_x0(&dir);
			onequeuefile(dir.data); /* XXX exitcode */
		}
		if (!errno) continue; /* next directory */
		uostr_cut(&dir,afterslash);
		uostr_x0(&dir);
		uostr_xdup_cstrmulti(&logstr,"cannot readdir ",dir.data,": ",strerror(errno),NULL);
		ec=1;
		break;
	}
  cleanup:
  	if (logstr.data)
		logmsguo(SMTP_FATAL,&logstr);
  	if (d)
		closedir(d);
	if (!relayhost)
		work_queue();
	_exit(ec);
}
