#include "config.h"
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <ctype.h>
#include "timselsysdep.h"
#include "uostr.h"
#include "uoio.h"
#include "attribs.h"
#include "uogetopt.h"
#include "smtptools.h"
#include "smtp.h"
#include "str_ulong.h"
#include "str2num.h"
#include "relaydb.h"
#include "qmail_emul.h"
#include "dns.h"
#include "mtalib.h"
#include "nomktime.h"

/* indent makes this worse, it cannot usefully handle the UO_ATTRIB_... stuff */
/* *INDENT-OFF* */

extern void _exit P__((int)) UO_ATTRIB_NORET;

uoio_t *reply_log_chan; /* stays 0 */

/* FD to log into */
int logmsgfd=2;
/* opt */ int allow_stray_lf=0;
/* opt */ unsigned long maxrcpts=10;
/* opt */ unsigned long maxsize=0;
/* opt */ static const char *mygreeting;
/* opt */ static const char *maildir;
/* opt */ static const char *qmail_queue;
/* opt */ static const char *prefix;
/* opt */ static const char *relaydbname;
	/* RBL stuff */
/* opt */ static int rblcheck=0;
/* opt */ static int returntemperrors=0;
/* opt */ static unsigned long rbldelay;
/* opt */ static const char *rbldomain="rbl.maps.vix.com";
/* opt */ static int softdnsretry=0;
/* run */ static const char *rblstr1=0; /* for rbldelay */
/* run */ static char *rblstr2=0; /* for rbldelay */

/* opt */ static int checkenvfrom=0; 
/* run */ static char *myhostname;
/* rem */ static uostr_t sender={0};
/* rem */ static uostr_t helo={0}; /* whatever the sender tells us */
/* rem */ static uostr_t *recipients={0};
/* run */ static unsigned long numrecipients=0;
/* run */ static const char *remhost;
/* run */ static const char *remip;
/* run */ static const char *reminfo;
/* run */ static const char *relayclient;

/* opt */ static unsigned long read_timeout=1200;
/* opt */ static unsigned long write_timeout=1200;
/* opt */ static char *log_spec_str=NULL;
/* opt */ static unsigned long aging=0;

static struct uogetopt myopts[]={
	{'4',"451",   UOGO_FLAG,&returntemperrors,1,
			"Return temporary error codes while despamming.\n"}, /* XXX come up with something better */
	{'a',"allow-stray-lf", UOGO_FLAG,&allow_stray_lf,1, "Allow stray LF to end a line"},
	{'A',"aging", UOGO_ULONG,&aging,1, "Don't allow email to addresses older then DAYS.\n"
			"Mail to addresses containing a YYYYMMDDHHMM will\n"
			"not be delivered if that date is too old.\n","DAYS"},
		   /*12345678901234567890123456789012345678901234567890*/
	{'b',"rbl",   UOGO_FLAG,&rblcheck,1, "Turn on RBL checking.\n"
			"Return a permanent error to RBLd hosts. See -4"},
	{'c',"check-envelope-sender", UOGO_FLAG,&checkenvfrom,1,
			"Check envelope sender host against the DNS.\n"
			"Return a permanent error code, but see -4"},
	{'d',"rbldelay", UOGO_ULONG,&rbldelay,0,
			"die some time after a RBLd host connects\n"
			"Will return error messages before that", "SECONDS"},
	{'D',"rbldomain",UOGO_STRING,&rbldomain,0,
			"Where to look for the information\n"
			"Default: rbl.maps.vix.com","DOMAIN"},
	{'g',"greeting", UOGO_STRING,&mygreeting,0, 
			"Name to use for HELO","MYHOSTNAME"},
	{'l',"log", UOGO_STRING,&log_spec_str,0, 
			"What to log\n"
			"A string of words, separated with commas:\n"
		   /*12345678901234567890123456789012345678901234567890*/
			"HELO, EHLO, MAIL, RCTP, VRFY, EXPN, DATA, RSET,\n"
			"etc. COMMANDS: all commands. UNKNOWN: unknown cmd\n"
			"ERRORS: error replies. REPLIES: all replies\n",0},
    {'m',"max-recipients", UOGO_ULONG,&maxrcpts,0,
			"Maximum number of recipients for a single message\n"
		   /*12345678901234567890123456789012345678901234567890*/
			"0: don't receive messages", "LIMIT"},
    {'M',"maildir", UOGO_STRING,&maildir,0, 
			"Maildir to spool into\n"
			"--qmail-queue overrides --maildir", "MAILDIR"},
    {'P',"prefix", UOGO_STRING,&prefix,0, 
			"Prefix to use in maildir mode\n"
			"Default: usmtpd", "PREFIX"},
    {'q',"qmail-queue", UOGO_STRING,&qmail_queue,0, 
			"Normally /var/qmail/bin/qmail-queue\n"
			"Use $QMAILQUEUE to override, overrides --maildir\n", "PATH"},
	{'r',"relaydb", UOGO_STRING,&relaydbname,1, 
			"Path to relaying control file", "FILE"},
    {'R',"read-timeout", UOGO_ULONG,&read_timeout,0, 
			"Timeout in seconds for reading from remote", "TIMEOUT"},
    {'s',"max-size", UOGO_ULONG,&maxsize,0,
			"Maximum size of messages\noverridden by $DATABYTES", "LIMIT"},
	{'S',"softdnsretry",UOGO_FLAG,&softdnsretry,1,
			"Force the sender to retry on temporary DNS errors.\n" /* XXX come up with somewith better */
			"Used for DNS and envelope sender checking.\n"
			"Default: accept messages during this time"},
		   /*123456789012345678901234567890123456789012345678901234567890*/
    {'W',"write-timeout", UOGO_ULONG,&write_timeout,0, 
			"Timeout in seconds for writing to remote.","TIMEOUT"},
	{0,0}
};
static void *extralogtag=0;

static void exitoom P__((const char *s)) UO_ATTRIB_NORET;
static void remioerrexit P__((const char *s,const char *t)) UO_ATTRIB_NORET;
static void normerrexit P__((const char *,const char *)) UO_ATTRIB_NORET;
static void exitsaying P__((uoio_t *o,const char *code, const char *s))  UO_ATTRIB_NORET;
/* *INDENT-ON* */

static void 
llog1(const char *s) 
{ if(extralogtag) write(logmsgfd,extralogtag,strlen(extralogtag));
	write(logmsgfd,s,strlen(s));write(logmsgfd,"\n",1); }
static void 
llog2(const char *s, const char *t)
{ if(extralogtag) write(logmsgfd,extralogtag,strlen(extralogtag));
		write(logmsgfd,s,strlen(s));write(logmsgfd,t,strlen(t));write(logmsgfd,"\n",1); }
static void 
llog3(const char *s, const char *t, const char *u)
	{ if(extralogtag) write(logmsgfd,extralogtag,strlen(extralogtag));
      write(logmsgfd,s,strlen(s));write(logmsgfd,t,strlen(t));write(logmsgfd,u,strlen(u));write(logmsgfd,"\n",1); }
static void 
exitoom(const char *s)
{ write(1,"421 ",4);write(1,s,strlen(s));write(1," (# 4.3.0)\r\n",12); llog1(s); _exit(1);}

static void 
remioerrexit(const char *s,const char *t) 
	{llog2(s,t);_exit(1);}
static void 
normerr(const char *s,const char *t)
{ 
	write(1,"421 local error",15); write(1,s,strlen(s)); if (t) {write(1,": ",2);write(1,t,strlen(t));} 
	write(1," (#4.3.0)\n",10);
	if (t) llog3(s,": ",t); else llog1(s);
}
static void 
normerrexit(const char *s,const char *t)
{ normerr(s,t);_exit(1);}
static void 
exitsaying(uoio_t *o,const char *code, const char *s)
{ 
	uoio_write_cstrmulti(o,code," ",s,"\r\n",0);
	if (uoio_flush(o)==-1) remioerrexit("write: ", strerror(errno));
	_exit(0);
}
static void 
writerem(uoio_t *o,const char *s)
{
	if (log_spec_str && strstr(log_spec_str,"ERRORS,") && (*s=='5'||*s=='4')) llog1(s);
	else if (log_spec_str && strstr(log_spec_str,"REPLIES,")) llog1(s);
	uoio_write_cstrmulti(o,s,"\r\n",0);
}

static void 
start_logger(void)
{
	int fd[2];
	int pid;
	if (-1==pipe(fd)) normerrexit(": pipe: ",strerror(errno));
	if (-1==(pid=fork())) normerrexit(": fork (logging): ",strerror(errno));
	if (pid==0) {
		int null;
		const char *nargv[5];
		close(fd[1]);
		if (-1==dup2(fd[0],0)) _exit(1);
		if (-1==(null=open("/dev/null",O_RDWR))) _exit(1);
		if (-1==dup2(null,1)) _exit(1);
		if (-1==dup2(null,1)) _exit(1);
		nargv[0]="logger";
		nargv[1]="-i";
		nargv[2]="-t";
		nargv[3]="usmtpd";
		nargv[4]=0;
		execv("/usr/sbin/logger",( char * const*) nargv);
		execv("/sbin/logger",(char *const *)nargv);
		execv("/usr/bin/logger",(char *const *)nargv);
		execv("/bin/logger",(char *const *)nargv);
		execv("/etc/logger",(char *const *)nargv);
		_exit(1);
	}
	close(fd[0]);
	logmsgfd=fd[1];
}

static int
domainindns(const char *dom, const char **err)
{
	dns_t *dns;
	switch(dns_mx(dom,&dns)) {
	case DNS_HARD: break;
	case DNS_SOFT: 
			if (softdnsretry) { 
				*err="451 unresolvable host name, check your DNS (#4.1.8)\r\n"; 
				return 0; }
			return 1; /* assume nice guy */
	default: 
		dns_free_chain(dns); 
		return 1;
	}
	switch(dns_a(dom,&dns)) {
	case DNS_HARD: break;
	case DNS_SOFT: 
			if (softdnsretry) {
				*err="451 unresolvable host name, check your DNS (#4.1.8)\r\n"; 
				return 0; }
			return 1; /* assume nice guy */
	default: 
		dns_free_chain(dns); 
		return 1;
	}
	if (returntemperrors)
		*err="451 unresolvable host name, check your DNS (#4.1.8)\r\n"; 
	else
		*err="551 unresolvable host name, check your DNS (#4.1.8)\r\n"; 
	return 0;
}

static void
do_rbl_check(uoio_t *o)
{
	dns_t *dns;
	const char *p;
	char *q;
	size_t domlen=strlen(rbldomain);
	uostr_t s;
	s.data=0;
	if (!domlen) return;
	uostr_xneedmore(&s,domlen+1+strlen(remip)+1);
	/* 12.34.56.78 -> 78.56.34.12.rbl.maps.vix.com */
	p=remip+strlen(remip)-1;
	q=s.data;
	while (p>remip) {
		const char *r;
		while (p>remip && p[-1]!='.') p--;
		r=p;
		while (*r && *r!='.') *q++=*r++;
		*q++='.';
		if (p!=remip) p--;
	}
	strcpy(q,rbldomain);
	switch(dns_txt(s.data,&dns)) {
	case DNS_HARD: break;
	case DNS_SOFT: 
		if (softdnsretry) exitsaying(o,"451","temporary RBL lookup failure");
		break;
	default:  {
			size_t l=strlen(dns->name);
			rblstr2=malloc(l+1);
			if (!rblstr2) exitoom("out of memory");
			memcpy(rblstr2,dns->name,l+1);
			dns_free_chain(dns);
			if (returntemperrors) rblstr1="451 spam? just say no";
			else rblstr1="553 spam? just say NO";
			if (rbldelay) alarm(rbldelay);
			else exitsaying(o,rblstr1,rblstr2);
		}
	}
	uostr_freedata(&s);
}

static int
is_aged(const char *s)
{
	while (*s) {
		if (*s>='0' && *s<='9')  {
			size_t l;
			l=strspn(s,"0123456789");
			/* allow 19981201.* */
			if (l>=8) { 
				int year,mon,day,hour,min,sec;
				static int thisyear;
				time_t x;
				if (!thisyear) { struct tm *tm;time_t t=time(0); tm=gmtime(&t);thisyear=tm->tm_year+1900; }
				year= (s[0]-'0')*1000;
				year+=(s[1]-'0')*100;
				year+=(s[2]-'0')*10;
				year+=(s[3]-'0');
				if (year<1995 || year >thisyear) return 0;
				mon=  (s[4]-'0')*10;
				mon+= (s[5]-'0');
				mon--;
				day=  (s[6]-'0')*10;
				day+= (s[7]-'0');
				hour=min=sec=0;
				if (l>8) {
					hour= (s[8]-'0')*10;
					hour+=(s[9]-'0');
					min=  (s[10]-'0')*10;
					min+= (s[11]-'0');
					if (l==14) {
						sec=  (s[12]-'0')*10;
						sec+= (s[13]-'0');
					}
				}
				x=nomktime(year,mon,day,hour,min,sec);
				if (x<time(0)-((time_t)aging*86400)) return 1;
				return 0;
			} else s+=l;
		} else s++;
	}
	return 0;
}


static int
is_command(uostr_t *u, const char *s)
{
	char *p=u->data;
	size_t l=u->len;
	while (l) {
		int c1,c2;
		c1=(unsigned char)*p++;
		c2=(unsigned char)*s++;
		if (!c2) { /* place u.data on args ... */
			u->data=--p; u->len=l; while (u->data[0]==' ' || u->data[0]=='\t') {u->data++;u->len--;}
			return 1;
		}
		if (c1>='a' && c1<='z') c1+='A'-'a';
		if (c2>='a' && c2<='z') c2+='A'-'a';
		if (c1!=c2) return 0;
		l--;
	}
	u->data=p;
	u->len=0;
	return 1;
}

static void
mkreceived(uostr_t *rec, const char *proto, const char *sendr, 
	const char *recipient)
{
	struct tm *tm;
	time_t t;
	char timebuf[40];
	size_t l;
	static const char *months[] = { "Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec" };
	/* Received: from ??? ([1.2.3.4]) (HELO other)
	   Received: from other ([1.2.3.4])
	       by me with SMTP for <uwe@ohse.de> 
		   (origin: <who@domain>) ; 3 Jan 1999 12:13:14 +0000
	 */
	time(&t); tm=gmtime(&t);
	/* used to use strftime here, but under SCO 3.2v4.2 this needs
	 * -lintl. This may lead to problems.
	 */
	l=0;
	if (tm->tm_mday<10) timebuf[l++]='0'; l+=str_ulong(timebuf+l,tm->tm_mday); timebuf[l++]=' ';
	memcpy(timebuf+l,months[tm->tm_mon],3); l+=3; timebuf[l++]=' ';
	l+=str_ulong(timebuf+l,tm->tm_year+1900); timebuf[l++]=' ';
	if (tm->tm_hour<10) timebuf[l++]='0'; l+=str_ulong(timebuf+l,tm->tm_hour); timebuf[l++]=':';
	if (tm->tm_min<10) timebuf[l++]='0'; l+=str_ulong(timebuf+l,tm->tm_min); timebuf[l++]=':';
	if (tm->tm_sec<10) timebuf[l++]='0'; l+=str_ulong(timebuf+l,tm->tm_sec); timebuf[l++]=0;

	uostr_xdup_cstrmulti(rec, "Received: from ",remhost," ([",0);
	if (reminfo) uostr_xadd_cstrmulti(rec,reminfo,"@",0);
	uostr_xadd_cstrmulti(rec,remip,"]) ",0);
	if (helo.data && helo.len && (!remhost || 0!=strcasecmp(helo.data,remhost)))
		uostr_xadd_cstrmulti(rec,"(HELO ",helo.data,")",0);
	uostr_xadd_cstrmulti(rec,"\n\t by ",mygreeting," with ",proto," ",
							"for <",recipient, ">\n",
							"\t(origin: <",sendr,">); ",
							timebuf," +0000\n",0);
	uostr_x0(rec);
}

static int 
data(uoio_t *i, uoio_t *o)
{
	mta_t *mta;
	mta_ret_t ret;
	int j;
	const char *name;
	const char *para;
	int trouble=0;
	unsigned long bytes=0;

	uostr_t rec,recs;rec.data=recs.data=0;

	for (j=0;j<(int)numrecipients;j++) { 
		uostr_xadd_cstrmulti(&recs,recipients[j].data,"\n",0);
	}
	uostr_x0(&recs);
	if (qmail_queue) {  name="qq"; para=qmail_queue; }
	else {name="maildir",para=0;}
	ret=mta_get(&mta,name,para,sender.data,recs.data);
	uostr_freedata(&recs);
	if (ret!=MTA_SUCCESS) {
		uostr_t s;s.data=0;
		uostr_xdup_cstrmulti(&s,"queue-open failed: ",mta_errtxt," ",mta_hcmssc,0);
		uostr_x0(&s);
		exitsaying(o,ret==MTA_DEFER ? "421 ": "554 ",s.data);
	}

	mkreceived(&rec,"SMTP",sender.data,numrecipients > 1 ? "multiple recipients" : recipients[0].data);
	trouble=mta->mta_write(mta,rec.data,rec.len-1); /* no \0 */
	uostr_freedata(&rec);

	writerem(o,"354 go on");
	if (-1==uoio_flush(o)) { int e=errno; mta->mta_abort(mta); remioerrexit("remote : ",strerror(e)); }

	while (1) {
		int len;
		char *s;
		len=uoio_getdelim_zc(i,&s,'\n');
		if (len==-1) { int e=errno; mta->mta_abort(mta); remioerrexit("remote : ",strerror(e)); }
		if (len==0) { mta->mta_abort(mta); remioerrexit("remote : ","closed_connection"); }
		len--; /* \n */
		if (s[len-1]!='\r') {
			if (!allow_stray_lf) {
				mta->mta_abort(mta);
				writerem(o,"451 See http://pobox.com/~djb/docs/smtplf.html.");
				if (-1==uoio_flush(o)) { int e=errno; mta->mta_abort(mta); remioerrexit("remote : ",strerror(e)); }
				llog1("remote: sent stray lf"); 
				_exit(1);
			}
		} else len--;
		if (len && *s=='.') {s++; len--; if (!len) break;} /* end of message */
		bytes+=len+1; /* \n */
		if (trouble!=MTA_SUCCESS) continue;
		trouble=mta->mta_write(mta,s,len);
		if (trouble==MTA_SUCCESS) trouble=mta->mta_write(mta,"\n",1);
	} /* read from remote, write to disk */

	if (trouble != MTA_SUCCESS) {
		uostr_t s;s.data=0;
		uostr_xdup_cstrmulti(&s, trouble==MTA_FATAL ? "551 " : "451 ",mta_errtxt," ",mta_hcmssc,0);
		uostr_x0(&s); writerem(o,s.data);uostr_freedata(&s);
		mta->mta_abort(mta);
		if (-1==uoio_flush(o)) remioerrexit("remote : ",strerror(errno));
		return 0;
	}

	if (maxsize && bytes>=maxsize) {
		char num[STR_ULONG];
		uostr_t s;s.data=0;
		uostr_xadd_cstr(&s,"552 sorry, that message size (");
		str_ulong(num,bytes); uostr_xadd_cstr(&s,num);
		uostr_xadd_cstr(&s," bytes) exceeds my maxsize limit (");
		str_ulong(num,maxsize); uostr_xadd_cstr(&s,num);
		uostr_xadd_cstr(&s," bytes) (#5.3.4)");
		uostr_x0(&s);
		writerem(o,s.data);
		llog1(s.data+4);
		uostr_freedata(&s);
		mta->mta_abort(mta);
		if (-1==uoio_flush(o)) {remioerrexit("remote: ",strerror(errno)); }
		return 0;
	}

	trouble=mta->mta_close(mta);
	if (trouble==MTA_SUCCESS) {
		char buf[STR_ULONG];
		uostr_t s;s.data=0;
		uostr_xdup_cstr(&s,"250 Ok ");
		str_ulong(buf,(unsigned long) time(0));
		uostr_xadd_cstr(&s, buf);
		uostr_xadd_cstr(&s," ");
		uostr_xadd_cstr(&s,name);
		uostr_xadd_cstr(&s," ");
		uostr_xadd_cstr(&s,mta_errtxt);
		uostr_x0(&s);
		writerem(o,s.data);
		if (-1==uoio_flush(o))  /* i can't stop the message anymore */
			{ remioerrexit("remote: ",strerror(errno)); }
		uostr_freedata(&s);
		return 0;
	} else {
		uostr_t s;s.data=0;
		uostr_xdup_cstrmulti(&s, trouble==MTA_FATAL ? "551 " : "451 ",mta_errtxt," ",mta_hcmssc,0);
		uostr_x0(&s); writerem(o,s.data);uostr_freedata(&s);
		if (-1==uoio_flush(o)) remioerrexit("remote : ",strerror(errno));
		return 0;
	}
}



/* someone please tell me: why does an email address need quoting? */
static int 
parse_address(const char *ad,uostr_t *res,int allowempty)
{
	int got_less=0;
	int in_quote=0;
	int in_escape=0;
	char *q;
	const char *at=0;
	size_t l=strlen(ad)+1;

	errno=0;
	uostr_xneedmore(res,l);
	q=res->data;
	while (*ad==' '||*ad=='\t') ad++;
	if (*ad=='<') {ad++;got_less++;}
	if (*ad=='@') { /* i don't believe we'll see source routes in 1999! */
		ad++; 
		while (*ad && *ad!=':') ad++;
		if (*ad==':') ad++;
	} 
	if (!*ad) return -1;

	while (*ad) {
		if (in_escape) {*q++=*ad++;continue;}
		if (in_quote) {*q++=*ad; if (*ad++=='\"') in_quote=0;continue;}
		if (*ad=='@' && !at) at=q;
		if (*ad=='>' && got_less) break;
		*q++=*ad;
		if (*ad=='\\') {in_escape=1; ad++; continue;}
		if (*ad=='\"') {in_quote=1; ad++; continue;}
		ad++;
	}
	if (*ad && *ad!='>') return -1;
	res->len=q-res->data+1;
	*q=0; /* that's the +1 in the line above */
	if (got_less && *ad=='>' && allowempty && res->len==1) {*q=0;return 0;}
	if (res->len>=990) return -1;
	/* make sure some assumptions of relaydb work */
	if (!at||!at[1]) return -1; /* read 821: localpart @ domain */
	if (strchr(at+1,' ')) return -1; /* 821 */
	if (strchr(at+1,'@')) return -1; /* 821 */
	return 0;
}



#define WFLUSH(x) do {if (-1==uoio_flush(x)) remioerrexit("remote write: ",strerror(errno));} while(0)
#define LOGC(x) if (log_spec_str) {const char *pp;pp=strstr(log_spec_str,x); \
	if (!pp) pp=strstr(log_spec_str,"COMMANDS,"); \
	if (pp) llog1(s); } 
int 
main(int argc, char **argv)
{
	char buf[128];
	uoio_t i,o;
	int in_MAIL=0;
	char *p;
	uostr_xallocfn=exitoom; /* make uostr.c RFC821 compatible */
#ifdef HAVE_LIBEFENCE
	/* make efence library smtp compatible, throw out copyright info */
	{int fd,fd2;void *waste;
	 if (-1==(fd=open("/dev/null",O_WRONLY))) normerrexit("open(/dev/null)",strerror(errno));
	 if (-1==(fd2=dup(2))) normerrexit("dup(stderr)",strerror(errno));
	 if (-1==(dup2(fd,2))) normerrexit("dup2(/dev/null,stderr)",strerror(errno));
	 waste=malloc(1);
	 if (-1==(dup2(fd2,2))) {logmsgfd=1;normerrexit("dup2(/dev/null,stderr)",strerror(errno));}
	 close(fd); close(fd2);
	}
#endif
	start_logger();
	if (gethostname(buf,sizeof(buf)-1)==-1) { normerrexit("hostname too long",0); } /* think of humans! */ 
	else {
		buf[sizeof(buf)-1]=0;
		myhostname=malloc(strlen(buf)+1);
		if (!myhostname) exitoom("out of memory");
		memcpy(myhostname,buf,strlen(buf)+1);
	}
	mygreeting=myhostname;
	uogetopt("usmtpd",PACKAGE,VERSION,&argc,argv,uogetopt_out,0,myopts,0);
	if (log_spec_str) { size_t l=strlen(log_spec_str); char *t2,*t1=malloc(l+2); if (!t1) exitoom("out of memory");
		t2=t1; while (*log_spec_str) {char cc; cc=*log_spec_str++;*t1++=toupper(cc);}; *t1++=','; *t1=0;
		log_spec_str=t2; } /* now , at the end */
	p=getenv("SMTPGREETING");
	if (p) mygreeting=p;
	
	remhost=getenv("TCPREMOTEHOST");
	remip=getenv("TCPREMOTEIP");
	relayclient=getenv("RELAYCLIENT");
	if (!remip || !remhost) { 
		struct sockaddr_in s_in;
		int l_in=sizeof(s_in);
		if (-1==getpeername(0,(struct sockaddr *)&s_in,&l_in)) { 
			if (errno!=ENOTSOCK) normerrexit("stdin",strerror(errno));
			/* stdin mode */
			if (!remip) remip="127.0.0.1";
			if (!remhost) remhost=myhostname;
			if (!relayclient) relayclient="";
		} else {
			char *v;
			char *t=inet_ntoa(s_in.sin_addr);
			v=malloc(strlen(t)+1);
			if (!v) exitoom("out of memory");
			remip=strcpy(v,t);
			if (!remhost) {
				dns_t *ptr;
				switch(dns_ptr(&s_in.sin_addr,&ptr)) {
				case DNS_SOFT: remhost="soft dns failure"; break;
				case DNS_HARD: remhost="no PTR record"; break;
				default: {
						t=malloc(strlen(ptr->name)+1);
						if (!t) exitoom("out of memory");
						memcpy(t,ptr->name,strlen(ptr->name)+1);
						remhost=t;
						dns_free_chain(ptr);
					}
				}
			}
		}
	}

	reminfo=getenv("TCPREMOTEINFO");
	if ((p=getenv("DATABYTES"))!=0) {
		int x=str2ulong(p,&maxsize,0);
		if (x<0) {maxsize=0; llog2("$DATABYTES unparsable: ",p); }
	}
	if (relaydbname && -1==relaydb_init(relaydbname)) normerrexit(relaydbname,strerror(errno));
	if (maildir && -1==chdir(maildir)) normerrexit(maildir,strerror(errno));
	if (maxrcpts) {
		recipients=malloc(sizeof(uostr_t) *maxrcpts);
		if (!recipients) {exitoom("out of memory");}
		memset(recipients,0,sizeof(uostr_t) *maxrcpts);
	}

	uoio_assign_r(&i,0,read,0);
	i.timeout=read_timeout;
	uoio_assign_w(&o,1,write,0);
	o.timeout=write_timeout;

	if (rblcheck) do_rbl_check(&o);

	uoio_write_cstrmulti(&o,"220 ",mygreeting, " SMTP\r\n",0);

		/* now for one of the most beautiful protocols ... */
	while (1) {
		int len;
		char *s;
		uostr_t u;u.data=0;
		WFLUSH(&o);
		len=uoio_getdelim_zc(&i,&s,'\n');
		if (-1==len) remioerrexit("remote read: ",strerror(errno));
		if (len==0) break; /* eof */
		u.len=--len; /* \n */
		u.data=s;
		if (u.data[u.len-1]=='\r') u.len--;
		u.data[u.len]=0;
		if (len<4) { LOGC("UNKNOWN,"); writerem(&o,"502 not implemented");continue;}
		if (is_command(&u,"QUIT")) { 
			LOGC("QUIT,");
			writerem(&o,"221 pleased to help you");
			uoio_flush(&o); 
			break; }
		if (rblstr1) { uostr_t t;t.data=0; uostr_xadd_cstrmulti(&t,rblstr1,": ",rblstr2,0);
			uostr_x0(&t); writerem(&o,t.data); uostr_freedata(&t); continue;}
		if (is_command(&u,"EHLO")) { uostr_t t;t.data=0; LOGC("EHLO,"); 
			uostr_xdup_cstr(&helo,u.data);uostr_x0(&helo);
			uostr_xadd_cstrmulti(&t,"250 ",mygreeting,0);uostr_x0(&t);
			writerem(&o,t.data); uostr_freedata(&t); continue;}
		if (is_command(&u,"HELO")) { uostr_t t;t.data=0; LOGC("HELO,"); 
			uostr_xdup_cstr(&helo,u.data);uostr_x0(&helo);
			uostr_xadd_cstrmulti(&t,"250 ",mygreeting,0);uostr_x0(&t);
			writerem(&o,t.data); uostr_freedata(&t); continue;}
		if (is_command(&u,"MAIL FROM:")) { 
			const char *err;
			uostr_t res;res.data=0;
			LOGC("MAIL,");
			if (in_MAIL) {writerem(&o,"503 already saw MAIL"); continue; }
			if (-1==parse_address(u.data,&res,1)) 
				{writerem(&o,"553 not an address");uostr_freedata(&res); continue;};
			if (res.len>1 && checkenvfrom && !domainindns(strchr(res.data,'@')+1,&err)) 
				{ writerem(&o,err); uostr_freedata(&res); continue; }
			in_MAIL=1; writerem(&o,"250 ok");
			uostr_xdup_uostr(&sender,&res); uostr_freedata(&res); continue;
		}
		if (is_command(&u,"RCPT TO:")) { 
			uostr_t res;res.data=0;
			LOGC("RCPT,");
			if (!in_MAIL) {writerem(&o,"503 need MAIL FROM"); continue; }
			if (numrecipients == maxrcpts) { writerem(&o,"452 too many recipients"); continue; }
			if (-1==parse_address(u.data,&res,0)) { 
				writerem(&o,"553 not an address");uostr_freedata(&res); continue;};
			if (!relayclient && !relaydb_lookup_host(strchr(res.data,'@')+1)) {
				uostr_t str;str.data=0;
				uostr_xadd_cstrmulti(&str,"553 no way from ",remip," to ",res.data,0);
				uostr_x0(&str);
				writerem(&o,str.data); uostr_freedata(&str); uostr_freedata(&res);continue; }
			if (!relaydb_lookup_address(res.data)) {
				uostr_t str;str.data=0;
				uostr_xadd_cstrmulti(&str,"553 recipient ",res.data, " does not like email",0);
				uostr_x0(&str);
				writerem(&o,str.data); uostr_freedata(&str); uostr_freedata(&res);continue; }
			if (aging && is_aged(res.data)) {
				uostr_t str;str.data=0;
				uostr_xadd_cstrmulti(&str,"553 recipient address ",res.data,"is too old",0);
				uostr_x0(&str);
				writerem(&o,str.data); uostr_freedata(&str); uostr_freedata(&res);continue; }
			if (relayclient && *relayclient) 
				/* done after address check, gone@domain.example is the same for everybody */
				{ res.len--; uostr_xadd_cstr(&res,relayclient);uostr_x0(&res); }
			uostr_xdup_uostr(&recipients[numrecipients++],&res);
			uostr_freedata(&res);
			writerem(&o,"250 ok"); 
			continue;
		}
		if (is_command(&u,"VRFY")) { 
			uostr_t res;res.data=0;
			LOGC("VRFY,");
			if (-1==parse_address(u.data,&res,0)) writerem(&o,"553 certainly not deliverable");
			else writerem(&o,"252 just try it");
			uostr_freedata(&res);
			continue;}
		if (is_command(&u,"HELP")) { 
			LOGC("HELP,"); writerem(&o,"214 http://www.nrw.net/uwe/smtptools.html");continue;}
		if (is_command(&u,"NOOP")) { LOGC("NOOP,"); writerem(&o,"250 pleased to help you");continue;}
		if (is_command(&u,"RSET")) { LOGC("RSET,"); uostr_freedata(&sender); 
				in_MAIL=numrecipients=0;
				writerem(&o,"250 pleased to help you");continue;}
		if (is_command(&u,"DATA")) { 
			LOGC("DATA,");
			if (!numrecipients) { writerem(&o,"503 need RCPT TO"); continue;}
			if (-1==data(&i,&o)) break; 
			numrecipients=in_MAIL=0;
			uostr_freedata(&sender);
			continue; }
		LOGC("UNKNOWN,");
		writerem(&o,"502 not implemented");
	}
	exit(0);
}
