/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2000 - 2004 Hiroyuki Komatsu <komatsu@taiyaki.org>
 *  Copyright (C) 2004 Takuro Ashie <ashie@homa.ne.jp>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA  02111-1307  USA
 *
 *  $Id: uim-tomoe-gtk.c 1549 2007-06-29 01:46:55Z makeinu $
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <uim/uim.h>
#include <uim/uim-helper.h>
#include <tomoe-gtk.h>

/*  for uim */
static void     helper_disconnect_cb    (void);
static gboolean check_helper_connection (void);
static int uim_fd = -1;


static void
char_clicked_cb (TomoeWindow *window, gpointer user_data)
{
    const gchar *ch = tomoe_window_get_selected_char (window);
    GString *tmp = g_string_new ("commit_string\n");
    const char *str;

#if 0
    if (!ch) return;

    str = tomoe_char_get_utf8 (ch);
    if (!str) return;
#endif

    g_string_append (tmp, "charset=UTF-8\n");
    g_string_append (tmp, ch);
    g_string_append (tmp, "\n");

    if (check_helper_connection ())
        uim_helper_send_message (uim_fd, tmp->str);

    g_string_free (tmp, TRUE);
}


/*
 *  for uim
 */
static void
helper_disconnect_cb (void)
{
    uim_fd = -1;
}

static gboolean
check_helper_connection (void)
{
    if (uim_fd < 0)
    {
        uim_fd = uim_helper_init_client_fd (helper_disconnect_cb);
        if (uim_fd < 0)
            return FALSE;
    }

    return TRUE;
}


/*
 *  main
 */
int
main (int argc, char *argv[])
{
    GtkWidget *window;

    bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
    textdomain (GETTEXT_PACKAGE);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");

    gtk_init (&argc, &argv);
    tomoe_gtk_init ();

    /* confirm helper connection */
    check_helper_connection ();

    window = tomoe_window_new ();
    gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
    gtk_widget_show (window);
    g_signal_connect (GTK_OBJECT (window), "destroy",
                      G_CALLBACK (gtk_main_quit), NULL);
    g_signal_connect (G_OBJECT (window), "selected",
                      G_CALLBACK (char_clicked_cb),
                      NULL);

    /* run */
    gtk_main ();

    tomoe_gtk_quit ();

    return 0;
}
