// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: roachpb/errors.proto

package roachpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import bytes "bytes"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// TransactionAbortedReason specifies what caused a TransactionAbortedError.
// The reasons below are not necessarily disjoint - they describe where the
// error was generated, but generally it's possible that a
// TransactionAbortedError would have been generated somewhere else if the
// client would have performed different operations.
type TransactionAbortedReason int32

const (
	// For backwards compatibility.
	ABORT_REASON_UNKNOWN TransactionAbortedReason = 0
	// A BeginTransaction, HeartbeatTxn, or EndTransaction(commit=true) request
	// found an aborted transaction record. Another txn must have written this
	// record - that other txn probably ran into one of our intents and pushed our
	// transaction record successfully. Either a high-priority transaction simply
	// pushed us or we failed to heartbeat for a while and another txn (of any
	// priority) considered us abandoned and pushed us.
	ABORT_REASON_ABORTED_RECORD_FOUND TransactionAbortedReason = 1
	// The request attempting to create a transaction record has a timestamp below
	// the TxnSpanGCThreshold, so there might have been an ABORTED txn record that
	// got GCed (so, we might be in the ABORT_REASON_ABORTED_RECORD_FOUND case and
	// not know).
	// TODO(nvanbenschoten): Remove this error reason in 2.3, at which point no
	// nodes in the cluster will ever return it.
	ABORT_REASON_NEW_TXN_RECORD_TOO_OLD TransactionAbortedReason = 2
	// The client is trying to use a transaction that's already been aborted. The
	// TxnCoordSender detects this. Either the client is misusing a txn, or the
	// TxnCoordSender found out about the transaction being aborted async through
	// the heartbeat loop.
	ABORT_REASON_CLIENT_REJECT TransactionAbortedReason = 3
	// The txn was trying to push another and found out that it itself got aborted
	// somehow while waiting for the push.
	ABORT_REASON_PUSHER_ABORTED TransactionAbortedReason = 4
	// The txn ran into the "abort span" - it was trying to read from a range
	// where it had previously laid down intents that have been cleaned up in the
	// meantime because the transaction was aborted.
	ABORT_REASON_ABORT_SPAN TransactionAbortedReason = 5
	// A request attempting to create a transaction record encountered a write
	// timestamp cache entry for the txn key, and the entry identifies this
	// transaction. This means that the transaction definitely committed or rolled
	// back before. So, this request is either a delayed replay of some sort, or
	// it raced with an async abort and lost. If a client gets this
	// TransactionAbortedError (without it being wrapped in an ambiguous error),
	// it must be the latter case, and the transaction can be retried.
	ABORT_REASON_ALREADY_COMMITTED_OR_ROLLED_BACK_POSSIBLE_REPLAY TransactionAbortedReason = 6
	// Like the above, except the timestamp cache doesn't have a txn id in it.
	// This means that it no longer has good accuracy; likely as a result of a
	// lease transfer. As above, if the error has not been converted by the time
	// it reaches a client, then it's not a replay.
	ABORT_REASON_TIMESTAMP_CACHE_REJECTED_POSSIBLE_REPLAY TransactionAbortedReason = 7
)

var TransactionAbortedReason_name = map[int32]string{
	0: "ABORT_REASON_UNKNOWN",
	1: "ABORT_REASON_ABORTED_RECORD_FOUND",
	2: "ABORT_REASON_NEW_TXN_RECORD_TOO_OLD",
	3: "ABORT_REASON_CLIENT_REJECT",
	4: "ABORT_REASON_PUSHER_ABORTED",
	5: "ABORT_REASON_ABORT_SPAN",
	6: "ABORT_REASON_ALREADY_COMMITTED_OR_ROLLED_BACK_POSSIBLE_REPLAY",
	7: "ABORT_REASON_TIMESTAMP_CACHE_REJECTED_POSSIBLE_REPLAY",
}
var TransactionAbortedReason_value = map[string]int32{
	"ABORT_REASON_UNKNOWN":                                          0,
	"ABORT_REASON_ABORTED_RECORD_FOUND":                             1,
	"ABORT_REASON_NEW_TXN_RECORD_TOO_OLD":                           2,
	"ABORT_REASON_CLIENT_REJECT":                                    3,
	"ABORT_REASON_PUSHER_ABORTED":                                   4,
	"ABORT_REASON_ABORT_SPAN":                                       5,
	"ABORT_REASON_ALREADY_COMMITTED_OR_ROLLED_BACK_POSSIBLE_REPLAY": 6,
	"ABORT_REASON_TIMESTAMP_CACHE_REJECTED_POSSIBLE_REPLAY":         7,
}

func (x TransactionAbortedReason) Enum() *TransactionAbortedReason {
	p := new(TransactionAbortedReason)
	*p = x
	return p
}
func (x TransactionAbortedReason) String() string {
	return proto.EnumName(TransactionAbortedReason_name, int32(x))
}
func (x *TransactionAbortedReason) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TransactionAbortedReason_value, data, "TransactionAbortedReason")
	if err != nil {
		return err
	}
	*x = TransactionAbortedReason(value)
	return nil
}
func (TransactionAbortedReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{0}
}

// TransactionRetryReason specifies what caused a transaction retry.
type TransactionRetryReason int32

const (
	// For backwards compatibility.
	RETRY_REASON_UNKNOWN TransactionRetryReason = 0
	// A concurrent writer finished first, causing restart.
	RETRY_WRITE_TOO_OLD TransactionRetryReason = 1
	// A SERIALIZABLE transaction had its timestamp moved forward.
	RETRY_SERIALIZABLE TransactionRetryReason = 3
	// A possible replay caused by duplicate begin txn or out-of-order
	// txn sequence number.
	// TODO(nvanbenschoten): This is no longer in use. Remove in 2.4.
	RETRY_POSSIBLE_REPLAY TransactionRetryReason = 4
	// An asynchronous write was observed to have failed.
	RETRY_ASYNC_WRITE_FAILURE TransactionRetryReason = 5
	// The transaction exceeded its deadline.
	RETRY_COMMIT_DEADLINE_EXCEEDED TransactionRetryReason = 6
)

var TransactionRetryReason_name = map[int32]string{
	0: "RETRY_REASON_UNKNOWN",
	1: "RETRY_WRITE_TOO_OLD",
	3: "RETRY_SERIALIZABLE",
	4: "RETRY_POSSIBLE_REPLAY",
	5: "RETRY_ASYNC_WRITE_FAILURE",
	6: "RETRY_COMMIT_DEADLINE_EXCEEDED",
}
var TransactionRetryReason_value = map[string]int32{
	"RETRY_REASON_UNKNOWN":           0,
	"RETRY_WRITE_TOO_OLD":            1,
	"RETRY_SERIALIZABLE":             3,
	"RETRY_POSSIBLE_REPLAY":          4,
	"RETRY_ASYNC_WRITE_FAILURE":      5,
	"RETRY_COMMIT_DEADLINE_EXCEEDED": 6,
}

func (x TransactionRetryReason) Enum() *TransactionRetryReason {
	p := new(TransactionRetryReason)
	*p = x
	return p
}
func (x TransactionRetryReason) String() string {
	return proto.EnumName(TransactionRetryReason_name, int32(x))
}
func (x *TransactionRetryReason) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TransactionRetryReason_value, data, "TransactionRetryReason")
	if err != nil {
		return err
	}
	*x = TransactionRetryReason(value)
	return nil
}
func (TransactionRetryReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{1}
}

// TransactionRestart indicates how an error should be handled in a
// transactional context.
type TransactionRestart int32

const (
	// NONE (the default) is used for errors which have no effect on the
	// transaction state. That is, a transactional operation which receives such
	// an error is still PENDING and does not need to restart (at least not as a
	// result of the error). Examples are a CPut whose condition wasn't met, or
	// a spurious RPC error.
	TransactionRestart_NONE TransactionRestart = 0
	// BACKOFF is for errors that can retried by restarting the transaction
	// after an exponential backoff.
	// Note: Deprecated.
	TransactionRestart_BACKOFF TransactionRestart = 1
	// IMMEDIATE is for errors that can be retried by restarting the
	// transaction immediately.
	TransactionRestart_IMMEDIATE TransactionRestart = 2
)

var TransactionRestart_name = map[int32]string{
	0: "NONE",
	1: "BACKOFF",
	2: "IMMEDIATE",
}
var TransactionRestart_value = map[string]int32{
	"NONE":      0,
	"BACKOFF":   1,
	"IMMEDIATE": 2,
}

func (x TransactionRestart) Enum() *TransactionRestart {
	p := new(TransactionRestart)
	*p = x
	return p
}
func (x TransactionRestart) String() string {
	return proto.EnumName(TransactionRestart_name, int32(x))
}
func (x *TransactionRestart) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TransactionRestart_value, data, "TransactionRestart")
	if err != nil {
		return err
	}
	*x = TransactionRestart(value)
	return nil
}
func (TransactionRestart) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{2}
}

// Reason specifies what caused the error.
type TransactionStatusError_Reason int32

const (
	// For backwards compatibility.
	TransactionStatusError_REASON_UNKNOWN TransactionStatusError_Reason = 0
	// The request was sent to a transaction record that does not exist.
	TransactionStatusError_REASON_TXN_NOT_FOUND TransactionStatusError_Reason = 1
	// A committed transaction record was found.
	TransactionStatusError_REASON_TXN_COMMITTED TransactionStatusError_Reason = 2
)

var TransactionStatusError_Reason_name = map[int32]string{
	0: "REASON_UNKNOWN",
	1: "REASON_TXN_NOT_FOUND",
	2: "REASON_TXN_COMMITTED",
}
var TransactionStatusError_Reason_value = map[string]int32{
	"REASON_UNKNOWN":       0,
	"REASON_TXN_NOT_FOUND": 1,
	"REASON_TXN_COMMITTED": 2,
}

func (x TransactionStatusError_Reason) Enum() *TransactionStatusError_Reason {
	p := new(TransactionStatusError_Reason)
	*p = x
	return p
}
func (x TransactionStatusError_Reason) String() string {
	return proto.EnumName(TransactionStatusError_Reason_name, int32(x))
}
func (x *TransactionStatusError_Reason) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TransactionStatusError_Reason_value, data, "TransactionStatusError_Reason")
	if err != nil {
		return err
	}
	*x = TransactionStatusError_Reason(value)
	return nil
}
func (TransactionStatusError_Reason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{9, 0}
}

// Reason specifies what caused the error.
type RangeFeedRetryError_Reason int32

const (
	// The replica was removed from its store.
	RangeFeedRetryError_REASON_REPLICA_REMOVED RangeFeedRetryError_Reason = 0
	// The range was split in two.
	RangeFeedRetryError_REASON_RANGE_SPLIT RangeFeedRetryError_Reason = 1
	// The range was merged into another.
	RangeFeedRetryError_REASON_RANGE_MERGED RangeFeedRetryError_Reason = 2
	// A Raft snapshot applied on the replica.
	RangeFeedRetryError_REASON_RAFT_SNAPSHOT RangeFeedRetryError_Reason = 3
	// A Raft command was missing a logical operation log.
	RangeFeedRetryError_REASON_LOGICAL_OPS_MISSING RangeFeedRetryError_Reason = 4
	// The consumer was processing events too slowly to keep up with live raft
	// events.
	RangeFeedRetryError_REASON_SLOW_CONSUMER RangeFeedRetryError_Reason = 5
)

var RangeFeedRetryError_Reason_name = map[int32]string{
	0: "REASON_REPLICA_REMOVED",
	1: "REASON_RANGE_SPLIT",
	2: "REASON_RANGE_MERGED",
	3: "REASON_RAFT_SNAPSHOT",
	4: "REASON_LOGICAL_OPS_MISSING",
	5: "REASON_SLOW_CONSUMER",
}
var RangeFeedRetryError_Reason_value = map[string]int32{
	"REASON_REPLICA_REMOVED":     0,
	"REASON_RANGE_SPLIT":         1,
	"REASON_RANGE_MERGED":        2,
	"REASON_RAFT_SNAPSHOT":       3,
	"REASON_LOGICAL_OPS_MISSING": 4,
	"REASON_SLOW_CONSUMER":       5,
}

func (x RangeFeedRetryError_Reason) Enum() *RangeFeedRetryError_Reason {
	p := new(RangeFeedRetryError_Reason)
	*p = x
	return p
}
func (x RangeFeedRetryError_Reason) String() string {
	return proto.EnumName(RangeFeedRetryError_Reason_name, int32(x))
}
func (x *RangeFeedRetryError_Reason) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(RangeFeedRetryError_Reason_value, data, "RangeFeedRetryError_Reason")
	if err != nil {
		return err
	}
	*x = RangeFeedRetryError_Reason(value)
	return nil
}
func (RangeFeedRetryError_Reason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{29, 0}
}

// A NotLeaseHolderError indicates that the current range is not the lease
// holder. If the lease holder is known, its Replica is set in the error.
type NotLeaseHolderError struct {
	// The replica the error originated from. Used in the error's string
	// representation.
	Replica ReplicaDescriptor `protobuf:"bytes,1,opt,name=replica" json:"replica"`
	// The lease holder, if known.
	LeaseHolder *ReplicaDescriptor `protobuf:"bytes,2,opt,name=lease_holder,json=leaseHolder" json:"lease_holder,omitempty"`
	// The current lease, if known. This might be nil even when lease_holder is
	// set, as sometimes one can create this error without actually knowing the
	// current lease, but having a guess about who the leader is.
	Lease   *Lease  `protobuf:"bytes,4,opt,name=lease" json:"lease,omitempty"`
	RangeID RangeID `protobuf:"varint,3,opt,name=range_id,json=rangeId,casttype=RangeID" json:"range_id"`
	// If set, the Error() method will return this instead of composing its
	// regular spiel. Useful because we reuse this error when rejecting a command
	// because the lease under which its application was attempted is different
	// than the lease under which it had been proposed.
	CustomMsg            string   `protobuf:"bytes,5,opt,name=custom_msg,json=customMsg" json:"custom_msg"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NotLeaseHolderError) Reset()         { *m = NotLeaseHolderError{} }
func (m *NotLeaseHolderError) String() string { return proto.CompactTextString(m) }
func (*NotLeaseHolderError) ProtoMessage()    {}
func (*NotLeaseHolderError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{0}
}
func (m *NotLeaseHolderError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NotLeaseHolderError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *NotLeaseHolderError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NotLeaseHolderError.Merge(dst, src)
}
func (m *NotLeaseHolderError) XXX_Size() int {
	return m.Size()
}
func (m *NotLeaseHolderError) XXX_DiscardUnknown() {
	xxx_messageInfo_NotLeaseHolderError.DiscardUnknown(m)
}

var xxx_messageInfo_NotLeaseHolderError proto.InternalMessageInfo

// A NodeUnavailableError indicates that the sending gateway can
// not process requests at the time, and that the client should
// retry the request with another peer.
type NodeUnavailableError struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeUnavailableError) Reset()         { *m = NodeUnavailableError{} }
func (m *NodeUnavailableError) String() string { return proto.CompactTextString(m) }
func (*NodeUnavailableError) ProtoMessage()    {}
func (*NodeUnavailableError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{1}
}
func (m *NodeUnavailableError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeUnavailableError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *NodeUnavailableError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeUnavailableError.Merge(dst, src)
}
func (m *NodeUnavailableError) XXX_Size() int {
	return m.Size()
}
func (m *NodeUnavailableError) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeUnavailableError.DiscardUnknown(m)
}

var xxx_messageInfo_NodeUnavailableError proto.InternalMessageInfo

// An UnsupportedRequestError indicates that the recipient node
// does not know how to handle the type of request received.
type UnsupportedRequestError struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UnsupportedRequestError) Reset()         { *m = UnsupportedRequestError{} }
func (m *UnsupportedRequestError) String() string { return proto.CompactTextString(m) }
func (*UnsupportedRequestError) ProtoMessage()    {}
func (*UnsupportedRequestError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{2}
}
func (m *UnsupportedRequestError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UnsupportedRequestError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *UnsupportedRequestError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UnsupportedRequestError.Merge(dst, src)
}
func (m *UnsupportedRequestError) XXX_Size() int {
	return m.Size()
}
func (m *UnsupportedRequestError) XXX_DiscardUnknown() {
	xxx_messageInfo_UnsupportedRequestError.DiscardUnknown(m)
}

var xxx_messageInfo_UnsupportedRequestError proto.InternalMessageInfo

// A RangeNotFoundError indicates that a command was sent to a range
// which is not hosted on this store.
type RangeNotFoundError struct {
	RangeID RangeID `protobuf:"varint,1,opt,name=range_id,json=rangeId,casttype=RangeID" json:"range_id"`
	// store_id is nonzero only if the error originated on a Store.
	StoreID              StoreID  `protobuf:"varint,2,opt,name=store_id,json=storeId,casttype=StoreID" json:"store_id"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RangeNotFoundError) Reset()         { *m = RangeNotFoundError{} }
func (m *RangeNotFoundError) String() string { return proto.CompactTextString(m) }
func (*RangeNotFoundError) ProtoMessage()    {}
func (*RangeNotFoundError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{3}
}
func (m *RangeNotFoundError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeNotFoundError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeNotFoundError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeNotFoundError.Merge(dst, src)
}
func (m *RangeNotFoundError) XXX_Size() int {
	return m.Size()
}
func (m *RangeNotFoundError) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeNotFoundError.DiscardUnknown(m)
}

var xxx_messageInfo_RangeNotFoundError proto.InternalMessageInfo

// A RangeKeyMismatchError indicates that a command was sent to a
// range which did not contain the key(s) specified by the command.
type RangeKeyMismatchError struct {
	RequestStartKey Key `protobuf:"bytes,1,opt,name=request_start_key,json=requestStartKey,casttype=Key" json:"request_start_key,omitempty"`
	RequestEndKey   Key `protobuf:"bytes,2,opt,name=request_end_key,json=requestEndKey,casttype=Key" json:"request_end_key,omitempty"`
	// mismatched_range is the range that the command was incorrectly sent to.
	// It is used to update the sender's range cache without an additional range
	// lookup.
	MismatchedRange *RangeDescriptor `protobuf:"bytes,3,opt,name=mismatched_range,json=mismatchedRange" json:"mismatched_range,omitempty"`
	// suggested_range is a hint to the sender of a command about the range
	// they may be looking for. It is only populated when the recipient has
	// authoritative knowledge of the range requested by the sender.
	SuggestedRange       *RangeDescriptor `protobuf:"bytes,4,opt,name=suggested_range,json=suggestedRange" json:"suggested_range,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *RangeKeyMismatchError) Reset()         { *m = RangeKeyMismatchError{} }
func (m *RangeKeyMismatchError) String() string { return proto.CompactTextString(m) }
func (*RangeKeyMismatchError) ProtoMessage()    {}
func (*RangeKeyMismatchError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{4}
}
func (m *RangeKeyMismatchError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeKeyMismatchError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeKeyMismatchError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeKeyMismatchError.Merge(dst, src)
}
func (m *RangeKeyMismatchError) XXX_Size() int {
	return m.Size()
}
func (m *RangeKeyMismatchError) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeKeyMismatchError.DiscardUnknown(m)
}

var xxx_messageInfo_RangeKeyMismatchError proto.InternalMessageInfo

// A ReadWithinUncertaintyIntervalError indicates that a read at timestamp
// encountered a write within the uncertainty interval of the reader.
// The read should be retried at a higher timestamp; the timestamps contained
// within are purely informational, though typically existing_timestamp is a
// lower bound for a new timestamp at which at least the read producing
// this error would succeed on retry.
type ReadWithinUncertaintyIntervalError struct {
	// This data below is purely informational and used to tailor the
	// error message.
	ReadTimestamp     hlc.Timestamp `protobuf:"bytes,1,opt,name=read_timestamp,json=readTimestamp" json:"read_timestamp"`
	ExistingTimestamp hlc.Timestamp `protobuf:"bytes,2,opt,name=existing_timestamp,json=existingTimestamp" json:"existing_timestamp"`
	// The remaining fields may be missing when running in clusters that have
	// members at below CockroachDB v2.0.
	MaxTimestamp         *hlc.Timestamp      `protobuf:"bytes,3,opt,name=max_timestamp,json=maxTimestamp" json:"max_timestamp,omitempty"`
	ObservedTimestamps   []ObservedTimestamp `protobuf:"bytes,4,rep,name=observed_timestamps,json=observedTimestamps" json:"observed_timestamps"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ReadWithinUncertaintyIntervalError) Reset()         { *m = ReadWithinUncertaintyIntervalError{} }
func (m *ReadWithinUncertaintyIntervalError) String() string { return proto.CompactTextString(m) }
func (*ReadWithinUncertaintyIntervalError) ProtoMessage()    {}
func (*ReadWithinUncertaintyIntervalError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{5}
}
func (m *ReadWithinUncertaintyIntervalError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadWithinUncertaintyIntervalError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ReadWithinUncertaintyIntervalError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadWithinUncertaintyIntervalError.Merge(dst, src)
}
func (m *ReadWithinUncertaintyIntervalError) XXX_Size() int {
	return m.Size()
}
func (m *ReadWithinUncertaintyIntervalError) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadWithinUncertaintyIntervalError.DiscardUnknown(m)
}

var xxx_messageInfo_ReadWithinUncertaintyIntervalError proto.InternalMessageInfo

// A TransactionAbortedError indicates that the client should retry the
// transaction (and use a different txn id, as opposed to
// TransactionRetryError). This most often happens when the transaction was
// aborted by another concurrent transaction. Upon seeing this error, the client
// is supposed to reset its Transaction proto and try the transaction again.
//
// In contrast with other errors, the Transaction that the client gets in the
// pErr carrying this ErrorDetail is not supposed to be used as is by the
// client; the ID should be checked and then attributes like the timestamp
// should be used in creating a new txn.
type TransactionAbortedError struct {
	Reason               TransactionAbortedReason `protobuf:"varint,1,opt,name=reason,enum=cockroach.roachpb.TransactionAbortedReason" json:"reason"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *TransactionAbortedError) Reset()         { *m = TransactionAbortedError{} }
func (m *TransactionAbortedError) String() string { return proto.CompactTextString(m) }
func (*TransactionAbortedError) ProtoMessage()    {}
func (*TransactionAbortedError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{6}
}
func (m *TransactionAbortedError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TransactionAbortedError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TransactionAbortedError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionAbortedError.Merge(dst, src)
}
func (m *TransactionAbortedError) XXX_Size() int {
	return m.Size()
}
func (m *TransactionAbortedError) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionAbortedError.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionAbortedError proto.InternalMessageInfo

// A TransactionPushError indicates that the transaction could not
// continue because it encountered a write intent from another
// transaction which it was unable to push.
type TransactionPushError struct {
	PusheeTxn            Transaction `protobuf:"bytes,1,opt,name=pushee_txn,json=pusheeTxn" json:"pushee_txn"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *TransactionPushError) Reset()         { *m = TransactionPushError{} }
func (m *TransactionPushError) String() string { return proto.CompactTextString(m) }
func (*TransactionPushError) ProtoMessage()    {}
func (*TransactionPushError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{7}
}
func (m *TransactionPushError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TransactionPushError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TransactionPushError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionPushError.Merge(dst, src)
}
func (m *TransactionPushError) XXX_Size() int {
	return m.Size()
}
func (m *TransactionPushError) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionPushError.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionPushError proto.InternalMessageInfo

// A TransactionRetryError indicates that the transaction must be
// retried, usually with an increased transaction timestamp.
type TransactionRetryError struct {
	Reason               TransactionRetryReason `protobuf:"varint,1,opt,name=reason,enum=cockroach.roachpb.TransactionRetryReason" json:"reason"`
	ExtraMsg             string                 `protobuf:"bytes,2,opt,name=extra_msg,json=extraMsg" json:"extra_msg"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *TransactionRetryError) Reset()         { *m = TransactionRetryError{} }
func (m *TransactionRetryError) String() string { return proto.CompactTextString(m) }
func (*TransactionRetryError) ProtoMessage()    {}
func (*TransactionRetryError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{8}
}
func (m *TransactionRetryError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TransactionRetryError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TransactionRetryError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionRetryError.Merge(dst, src)
}
func (m *TransactionRetryError) XXX_Size() int {
	return m.Size()
}
func (m *TransactionRetryError) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionRetryError.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionRetryError proto.InternalMessageInfo

// A TransactionStatusError indicates that the transaction status is
// incompatible with the requested operation. This might mean the
// transaction has already been committed. It might also be the case
// that the request to modify the transaction failed due to a
// regression in transaction epoch or timestamp, both of which may
// only monotonically increase.
type TransactionStatusError struct {
	Msg                  string                        `protobuf:"bytes,1,opt,name=msg" json:"msg"`
	Reason               TransactionStatusError_Reason `protobuf:"varint,2,opt,name=reason,enum=cockroach.roachpb.TransactionStatusError_Reason" json:"reason"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *TransactionStatusError) Reset()         { *m = TransactionStatusError{} }
func (m *TransactionStatusError) String() string { return proto.CompactTextString(m) }
func (*TransactionStatusError) ProtoMessage()    {}
func (*TransactionStatusError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{9}
}
func (m *TransactionStatusError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TransactionStatusError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TransactionStatusError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionStatusError.Merge(dst, src)
}
func (m *TransactionStatusError) XXX_Size() int {
	return m.Size()
}
func (m *TransactionStatusError) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionStatusError.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionStatusError proto.InternalMessageInfo

// A WriteIntentError indicates that one or more write intent
// belonging to another transaction were encountered leading to a
// read/write or write/write conflict. The keys at which the intent
// was encountered are set, as are the txn records for the intents'
// transactions.
type WriteIntentError struct {
	Intents              []Intent `protobuf:"bytes,1,rep,name=intents" json:"intents"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WriteIntentError) Reset()         { *m = WriteIntentError{} }
func (m *WriteIntentError) String() string { return proto.CompactTextString(m) }
func (*WriteIntentError) ProtoMessage()    {}
func (*WriteIntentError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{10}
}
func (m *WriteIntentError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WriteIntentError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *WriteIntentError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteIntentError.Merge(dst, src)
}
func (m *WriteIntentError) XXX_Size() int {
	return m.Size()
}
func (m *WriteIntentError) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteIntentError.DiscardUnknown(m)
}

var xxx_messageInfo_WriteIntentError proto.InternalMessageInfo

// A WriteTooOldError indicates that a write encountered a versioned
// value newer than its timestamp, making it impossible to rewrite
// history. The write is instead done at actual timestamp, which is
// the timestamp of the existing version+1.
type WriteTooOldError struct {
	Timestamp            hlc.Timestamp `protobuf:"bytes,1,opt,name=timestamp" json:"timestamp"`
	ActualTimestamp      hlc.Timestamp `protobuf:"bytes,2,opt,name=actual_timestamp,json=actualTimestamp" json:"actual_timestamp"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *WriteTooOldError) Reset()         { *m = WriteTooOldError{} }
func (m *WriteTooOldError) String() string { return proto.CompactTextString(m) }
func (*WriteTooOldError) ProtoMessage()    {}
func (*WriteTooOldError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{11}
}
func (m *WriteTooOldError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WriteTooOldError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *WriteTooOldError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteTooOldError.Merge(dst, src)
}
func (m *WriteTooOldError) XXX_Size() int {
	return m.Size()
}
func (m *WriteTooOldError) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteTooOldError.DiscardUnknown(m)
}

var xxx_messageInfo_WriteTooOldError proto.InternalMessageInfo

// An OpRequiresTxnError indicates that a command required to be
// carried out in a transactional context but was not.
// For example, a Scan which spans ranges requires a transaction.
// The operation should be retried inside of a transaction.
type OpRequiresTxnError struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OpRequiresTxnError) Reset()         { *m = OpRequiresTxnError{} }
func (m *OpRequiresTxnError) String() string { return proto.CompactTextString(m) }
func (*OpRequiresTxnError) ProtoMessage()    {}
func (*OpRequiresTxnError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{12}
}
func (m *OpRequiresTxnError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OpRequiresTxnError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *OpRequiresTxnError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OpRequiresTxnError.Merge(dst, src)
}
func (m *OpRequiresTxnError) XXX_Size() int {
	return m.Size()
}
func (m *OpRequiresTxnError) XXX_DiscardUnknown() {
	xxx_messageInfo_OpRequiresTxnError.DiscardUnknown(m)
}

var xxx_messageInfo_OpRequiresTxnError proto.InternalMessageInfo

// A ConditionFailedError indicates that the expected value
// of a ConditionalPutRequest was not found, either
// because it was missing or was not equal. The error will
// contain the actual value found.
type ConditionFailedError struct {
	ActualValue          *Value   `protobuf:"bytes,1,opt,name=actual_value,json=actualValue" json:"actual_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConditionFailedError) Reset()         { *m = ConditionFailedError{} }
func (m *ConditionFailedError) String() string { return proto.CompactTextString(m) }
func (*ConditionFailedError) ProtoMessage()    {}
func (*ConditionFailedError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{13}
}
func (m *ConditionFailedError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConditionFailedError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ConditionFailedError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConditionFailedError.Merge(dst, src)
}
func (m *ConditionFailedError) XXX_Size() int {
	return m.Size()
}
func (m *ConditionFailedError) XXX_DiscardUnknown() {
	xxx_messageInfo_ConditionFailedError.DiscardUnknown(m)
}

var xxx_messageInfo_ConditionFailedError proto.InternalMessageInfo

// A LeaseRejectedError indicates that the requested replica could
// not acquire the desired lease because of an existing range lease.
type LeaseRejectedError struct {
	Message              string   `protobuf:"bytes,1,opt,name=message" json:"message"`
	Requested            Lease    `protobuf:"bytes,2,opt,name=requested" json:"requested"`
	Existing             Lease    `protobuf:"bytes,3,opt,name=existing" json:"existing"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LeaseRejectedError) Reset()         { *m = LeaseRejectedError{} }
func (m *LeaseRejectedError) String() string { return proto.CompactTextString(m) }
func (*LeaseRejectedError) ProtoMessage()    {}
func (*LeaseRejectedError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{14}
}
func (m *LeaseRejectedError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LeaseRejectedError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *LeaseRejectedError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LeaseRejectedError.Merge(dst, src)
}
func (m *LeaseRejectedError) XXX_Size() int {
	return m.Size()
}
func (m *LeaseRejectedError) XXX_DiscardUnknown() {
	xxx_messageInfo_LeaseRejectedError.DiscardUnknown(m)
}

var xxx_messageInfo_LeaseRejectedError proto.InternalMessageInfo

// A SendError indicates that a message could not be delivered to
// the desired recipient(s).
type SendError struct {
	Message              string   `protobuf:"bytes,1,opt,name=message" json:"message"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SendError) Reset()         { *m = SendError{} }
func (m *SendError) String() string { return proto.CompactTextString(m) }
func (*SendError) ProtoMessage()    {}
func (*SendError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{15}
}
func (m *SendError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SendError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *SendError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SendError.Merge(dst, src)
}
func (m *SendError) XXX_Size() int {
	return m.Size()
}
func (m *SendError) XXX_DiscardUnknown() {
	xxx_messageInfo_SendError.DiscardUnknown(m)
}

var xxx_messageInfo_SendError proto.InternalMessageInfo

// An AmbiguousResultError indicates that a request may have succeeded or
// failed, but the response was not received and the final result is ambiguous.
type AmbiguousResultError struct {
	Message string `protobuf:"bytes,1,opt,name=message" json:"message"`
	// This can be set to give extra information about which error was converted
	// into an AmbiguousResultError. Useful for tests.
	WrappedErr           *Error   `protobuf:"bytes,2,opt,name=wrapped_err,json=wrappedErr" json:"wrapped_err,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AmbiguousResultError) Reset()         { *m = AmbiguousResultError{} }
func (m *AmbiguousResultError) String() string { return proto.CompactTextString(m) }
func (*AmbiguousResultError) ProtoMessage()    {}
func (*AmbiguousResultError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{16}
}
func (m *AmbiguousResultError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AmbiguousResultError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AmbiguousResultError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AmbiguousResultError.Merge(dst, src)
}
func (m *AmbiguousResultError) XXX_Size() int {
	return m.Size()
}
func (m *AmbiguousResultError) XXX_DiscardUnknown() {
	xxx_messageInfo_AmbiguousResultError.DiscardUnknown(m)
}

var xxx_messageInfo_AmbiguousResultError proto.InternalMessageInfo

// A RaftGroupDeletedError indicates a raft group has been deleted for
// the replica.
type RaftGroupDeletedError struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RaftGroupDeletedError) Reset()         { *m = RaftGroupDeletedError{} }
func (m *RaftGroupDeletedError) String() string { return proto.CompactTextString(m) }
func (*RaftGroupDeletedError) ProtoMessage()    {}
func (*RaftGroupDeletedError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{17}
}
func (m *RaftGroupDeletedError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RaftGroupDeletedError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RaftGroupDeletedError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RaftGroupDeletedError.Merge(dst, src)
}
func (m *RaftGroupDeletedError) XXX_Size() int {
	return m.Size()
}
func (m *RaftGroupDeletedError) XXX_DiscardUnknown() {
	xxx_messageInfo_RaftGroupDeletedError.DiscardUnknown(m)
}

var xxx_messageInfo_RaftGroupDeletedError proto.InternalMessageInfo

// A ReplicaCorruptionError indicates that the replica has experienced
// an error which puts its integrity at risk.
type ReplicaCorruptionError struct {
	ErrorMsg string `protobuf:"bytes,1,opt,name=error_msg,json=errorMsg" json:"error_msg"`
	// processed indicates that the error has been taken into account and
	// necessary steps will be taken. For now, required for testing.
	Processed            bool     `protobuf:"varint,2,opt,name=processed" json:"processed"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReplicaCorruptionError) Reset()         { *m = ReplicaCorruptionError{} }
func (m *ReplicaCorruptionError) String() string { return proto.CompactTextString(m) }
func (*ReplicaCorruptionError) ProtoMessage()    {}
func (*ReplicaCorruptionError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{18}
}
func (m *ReplicaCorruptionError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicaCorruptionError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ReplicaCorruptionError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicaCorruptionError.Merge(dst, src)
}
func (m *ReplicaCorruptionError) XXX_Size() int {
	return m.Size()
}
func (m *ReplicaCorruptionError) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicaCorruptionError.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicaCorruptionError proto.InternalMessageInfo

// ReplicaTooOldError is sent in response to a raft message when the
// recipient of the raft message believes the sender of the raft
// message to have been removed from the raft group
type ReplicaTooOldError struct {
	// replica_id is the ID of the replica that is too old.
	ReplicaID            ReplicaID `protobuf:"varint,1,opt,name=replica_id,json=replicaId,casttype=ReplicaID" json:"replica_id"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ReplicaTooOldError) Reset()         { *m = ReplicaTooOldError{} }
func (m *ReplicaTooOldError) String() string { return proto.CompactTextString(m) }
func (*ReplicaTooOldError) ProtoMessage()    {}
func (*ReplicaTooOldError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{19}
}
func (m *ReplicaTooOldError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicaTooOldError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ReplicaTooOldError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicaTooOldError.Merge(dst, src)
}
func (m *ReplicaTooOldError) XXX_Size() int {
	return m.Size()
}
func (m *ReplicaTooOldError) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicaTooOldError.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicaTooOldError proto.InternalMessageInfo

// A StoreNotFoundError indicates that a command was sent to a store
// which is not hosted on this node.
type StoreNotFoundError struct {
	StoreID              StoreID  `protobuf:"varint,1,opt,name=store_id,json=storeId,casttype=StoreID" json:"store_id"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StoreNotFoundError) Reset()         { *m = StoreNotFoundError{} }
func (m *StoreNotFoundError) String() string { return proto.CompactTextString(m) }
func (*StoreNotFoundError) ProtoMessage()    {}
func (*StoreNotFoundError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{20}
}
func (m *StoreNotFoundError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StoreNotFoundError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *StoreNotFoundError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreNotFoundError.Merge(dst, src)
}
func (m *StoreNotFoundError) XXX_Size() int {
	return m.Size()
}
func (m *StoreNotFoundError) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreNotFoundError.DiscardUnknown(m)
}

var xxx_messageInfo_StoreNotFoundError proto.InternalMessageInfo

// UnhandledRetryableError tells the recipient that a KV request must be
// retried. In case the request was transactional, the whole transaction needs
// to be retried. This is returned generally as a result of a transaction
// conflict.
//
// This error is generated by pErr.GoError() in case of a retryable
// error (other than TransactionRetryWithProtoRefreshError). For transactional
// requests, the TxnCoordSender handles retryable pErrs and transforms
// them into TransactionRetryWithProtoRefreshError. For non-transactional requests,
// this error will be observed by layers above the TxnCoordSender.
type UnhandledRetryableError struct {
	// The underlying storage error that is being marshaled.
	// pErr.TransactionRestart is expected to be set, and the error
	// detail is one of the retryable ones.
	PErr                 Error    `protobuf:"bytes,1,opt,name=pErr" json:"pErr"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UnhandledRetryableError) Reset()         { *m = UnhandledRetryableError{} }
func (m *UnhandledRetryableError) String() string { return proto.CompactTextString(m) }
func (*UnhandledRetryableError) ProtoMessage()    {}
func (*UnhandledRetryableError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{21}
}
func (m *UnhandledRetryableError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UnhandledRetryableError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *UnhandledRetryableError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UnhandledRetryableError.Merge(dst, src)
}
func (m *UnhandledRetryableError) XXX_Size() int {
	return m.Size()
}
func (m *UnhandledRetryableError) XXX_DiscardUnknown() {
	xxx_messageInfo_UnhandledRetryableError.DiscardUnknown(m)
}

var xxx_messageInfo_UnhandledRetryableError proto.InternalMessageInfo

// TransactionRetryWithProtoRefreshError is an error detail representing a retryable error
// that has been "handled" by the TxnCoordSender. This error is produced by the
// TxnCoordSender and is only produced for transactional requests.
//
// It contains the final form of the Transaction proto that should be used on
// next attempts. After being produced by the TxnCoordSender, this error is
// handled first by the client.Txn, which uses the Transaction inside to update
// its state, and then passed along to SQL in a pErr (through the
// client.Sender() interface).
type TransactionRetryWithProtoRefreshError struct {
	// A user-readable message.
	Msg string `protobuf:"bytes,1,opt,name=msg" json:"msg"`
	// The ID of the transaction being restarted. The client is supposed to check
	// this against the ID of its transaction and make sure the retryable error
	// is meant for its level and didn't escape from some inner transaction.
	TxnID github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,2,opt,name=txn_id,json=txnId,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"txn_id"`
	// The Transaction that should be used by next attempts. Depending on the
	// original cause of this method, this can either be the same Transaction as
	// before, but with an incremented epoch and timestamp, or a completely new
	// Transaction.
	Transaction          Transaction `protobuf:"bytes,3,opt,name=transaction" json:"transaction"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *TransactionRetryWithProtoRefreshError) Reset()         { *m = TransactionRetryWithProtoRefreshError{} }
func (m *TransactionRetryWithProtoRefreshError) String() string { return proto.CompactTextString(m) }
func (*TransactionRetryWithProtoRefreshError) ProtoMessage()    {}
func (*TransactionRetryWithProtoRefreshError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{22}
}
func (m *TransactionRetryWithProtoRefreshError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TransactionRetryWithProtoRefreshError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TransactionRetryWithProtoRefreshError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionRetryWithProtoRefreshError.Merge(dst, src)
}
func (m *TransactionRetryWithProtoRefreshError) XXX_Size() int {
	return m.Size()
}
func (m *TransactionRetryWithProtoRefreshError) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionRetryWithProtoRefreshError.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionRetryWithProtoRefreshError proto.InternalMessageInfo

// TxnAlreadyEncounteredErrorError indicates that an operation tried to use a
// transaction that already received an error from a previous request. Once that
// happens, client.Txn rejects future requests.
type TxnAlreadyEncounteredErrorError struct {
	// prev_error is the message from the error that the txn encountered
	// previously.
	PrevError            string   `protobuf:"bytes,1,opt,name=prev_error,json=prevError" json:"prev_error"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TxnAlreadyEncounteredErrorError) Reset()         { *m = TxnAlreadyEncounteredErrorError{} }
func (m *TxnAlreadyEncounteredErrorError) String() string { return proto.CompactTextString(m) }
func (*TxnAlreadyEncounteredErrorError) ProtoMessage()    {}
func (*TxnAlreadyEncounteredErrorError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{23}
}
func (m *TxnAlreadyEncounteredErrorError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TxnAlreadyEncounteredErrorError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TxnAlreadyEncounteredErrorError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TxnAlreadyEncounteredErrorError.Merge(dst, src)
}
func (m *TxnAlreadyEncounteredErrorError) XXX_Size() int {
	return m.Size()
}
func (m *TxnAlreadyEncounteredErrorError) XXX_DiscardUnknown() {
	xxx_messageInfo_TxnAlreadyEncounteredErrorError.DiscardUnknown(m)
}

var xxx_messageInfo_TxnAlreadyEncounteredErrorError proto.InternalMessageInfo

// An IntegerOverflowError indicates that an operation was aborted because
// it would have caused an integeter overflow.
type IntegerOverflowError struct {
	Key                  Key      `protobuf:"bytes,1,opt,name=key,casttype=Key" json:"key,omitempty"`
	CurrentValue         int64    `protobuf:"varint,2,opt,name=current_value,json=currentValue" json:"current_value"`
	IncrementValue       int64    `protobuf:"varint,3,opt,name=increment_value,json=incrementValue" json:"increment_value"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IntegerOverflowError) Reset()         { *m = IntegerOverflowError{} }
func (m *IntegerOverflowError) String() string { return proto.CompactTextString(m) }
func (*IntegerOverflowError) ProtoMessage()    {}
func (*IntegerOverflowError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{24}
}
func (m *IntegerOverflowError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IntegerOverflowError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *IntegerOverflowError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntegerOverflowError.Merge(dst, src)
}
func (m *IntegerOverflowError) XXX_Size() int {
	return m.Size()
}
func (m *IntegerOverflowError) XXX_DiscardUnknown() {
	xxx_messageInfo_IntegerOverflowError.DiscardUnknown(m)
}

var xxx_messageInfo_IntegerOverflowError proto.InternalMessageInfo

// A MixedSuccessError indicates that some portion of the batch
// request may have succeeded, but the batch as a whole failed with
// the wrapped error.
type MixedSuccessError struct {
	Wrapped              *Error   `protobuf:"bytes,1,opt,name=wrapped" json:"wrapped,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MixedSuccessError) Reset()         { *m = MixedSuccessError{} }
func (m *MixedSuccessError) String() string { return proto.CompactTextString(m) }
func (*MixedSuccessError) ProtoMessage()    {}
func (*MixedSuccessError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{25}
}
func (m *MixedSuccessError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MixedSuccessError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MixedSuccessError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MixedSuccessError.Merge(dst, src)
}
func (m *MixedSuccessError) XXX_Size() int {
	return m.Size()
}
func (m *MixedSuccessError) XXX_DiscardUnknown() {
	xxx_messageInfo_MixedSuccessError.DiscardUnknown(m)
}

var xxx_messageInfo_MixedSuccessError proto.InternalMessageInfo

// A BatchTimestampBeforeGCError indicates that a request's timestamp was
// before the GC threshold.
type BatchTimestampBeforeGCError struct {
	Timestamp            hlc.Timestamp `protobuf:"bytes,1,opt,name=Timestamp" json:"Timestamp"`
	Threshold            hlc.Timestamp `protobuf:"bytes,2,opt,name=Threshold" json:"Threshold"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *BatchTimestampBeforeGCError) Reset()         { *m = BatchTimestampBeforeGCError{} }
func (m *BatchTimestampBeforeGCError) String() string { return proto.CompactTextString(m) }
func (*BatchTimestampBeforeGCError) ProtoMessage()    {}
func (*BatchTimestampBeforeGCError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{26}
}
func (m *BatchTimestampBeforeGCError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BatchTimestampBeforeGCError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *BatchTimestampBeforeGCError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchTimestampBeforeGCError.Merge(dst, src)
}
func (m *BatchTimestampBeforeGCError) XXX_Size() int {
	return m.Size()
}
func (m *BatchTimestampBeforeGCError) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchTimestampBeforeGCError.DiscardUnknown(m)
}

var xxx_messageInfo_BatchTimestampBeforeGCError proto.InternalMessageInfo

// An IntentMissingError indicates that a QueryIntent request expected
// an intent to be present at its specified key but the intent was
// not there.
type IntentMissingError struct {
	// The non-matching intent that was found at that key, if any.
	WrongIntent *Intent `protobuf:"bytes,1,opt,name=wrong_intent,json=wrongIntent" json:"wrong_intent,omitempty"`
	// The key where the intent was expected.
	Key                  Key      `protobuf:"bytes,2,opt,name=key,casttype=Key" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IntentMissingError) Reset()         { *m = IntentMissingError{} }
func (m *IntentMissingError) String() string { return proto.CompactTextString(m) }
func (*IntentMissingError) ProtoMessage()    {}
func (*IntentMissingError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{27}
}
func (m *IntentMissingError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IntentMissingError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *IntentMissingError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntentMissingError.Merge(dst, src)
}
func (m *IntentMissingError) XXX_Size() int {
	return m.Size()
}
func (m *IntentMissingError) XXX_DiscardUnknown() {
	xxx_messageInfo_IntentMissingError.DiscardUnknown(m)
}

var xxx_messageInfo_IntentMissingError proto.InternalMessageInfo

// A MergeInProgressError indicates that the request could not be completed
// because the replica is being merged into its left-hand neighbor. The request
// should be resubmitted after the merge completes.
//
// This error is handled by the Store and should not escape to higher levels.
type MergeInProgressError struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MergeInProgressError) Reset()         { *m = MergeInProgressError{} }
func (m *MergeInProgressError) String() string { return proto.CompactTextString(m) }
func (*MergeInProgressError) ProtoMessage()    {}
func (*MergeInProgressError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{28}
}
func (m *MergeInProgressError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MergeInProgressError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MergeInProgressError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeInProgressError.Merge(dst, src)
}
func (m *MergeInProgressError) XXX_Size() int {
	return m.Size()
}
func (m *MergeInProgressError) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeInProgressError.DiscardUnknown(m)
}

var xxx_messageInfo_MergeInProgressError proto.InternalMessageInfo

// A RangeFeedRetryError indicates that a rangefeed was disconnected, often
// because of a range lifecycle event, and can be retried.
type RangeFeedRetryError struct {
	Reason               RangeFeedRetryError_Reason `protobuf:"varint,1,opt,name=reason,enum=cockroach.roachpb.RangeFeedRetryError_Reason" json:"reason"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *RangeFeedRetryError) Reset()         { *m = RangeFeedRetryError{} }
func (m *RangeFeedRetryError) String() string { return proto.CompactTextString(m) }
func (*RangeFeedRetryError) ProtoMessage()    {}
func (*RangeFeedRetryError) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{29}
}
func (m *RangeFeedRetryError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeFeedRetryError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeFeedRetryError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeFeedRetryError.Merge(dst, src)
}
func (m *RangeFeedRetryError) XXX_Size() int {
	return m.Size()
}
func (m *RangeFeedRetryError) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeFeedRetryError.DiscardUnknown(m)
}

var xxx_messageInfo_RangeFeedRetryError proto.InternalMessageInfo

// ErrorDetail is a union type containing all available errors.
type ErrorDetail struct {
	// Types that are valid to be assigned to Value:
	//	*ErrorDetail_NotLeaseHolder
	//	*ErrorDetail_RangeNotFound
	//	*ErrorDetail_RangeKeyMismatch
	//	*ErrorDetail_ReadWithinUncertaintyInterval
	//	*ErrorDetail_TransactionAborted
	//	*ErrorDetail_TransactionPush
	//	*ErrorDetail_TransactionRetry
	//	*ErrorDetail_TransactionStatus
	//	*ErrorDetail_WriteIntent
	//	*ErrorDetail_WriteTooOld
	//	*ErrorDetail_OpRequiresTxn
	//	*ErrorDetail_ConditionFailed
	//	*ErrorDetail_LeaseRejected
	//	*ErrorDetail_NodeUnavailable
	//	*ErrorDetail_Send
	//	*ErrorDetail_RaftGroupDeleted
	//	*ErrorDetail_ReplicaCorruption
	//	*ErrorDetail_ReplicaTooOld
	//	*ErrorDetail_AmbiguousResult
	//	*ErrorDetail_StoreNotFound
	//	*ErrorDetail_TransactionRetryWithProtoRefresh
	//	*ErrorDetail_IntegerOverflow
	//	*ErrorDetail_UnsupportedRequest
	//	*ErrorDetail_MixedSuccess
	//	*ErrorDetail_TimestampBefore
	//	*ErrorDetail_TxnAlreadyEncounteredError
	//	*ErrorDetail_IntentMissing
	//	*ErrorDetail_MergeInProgress
	//	*ErrorDetail_RangefeedRetry
	Value                isErrorDetail_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ErrorDetail) Reset()         { *m = ErrorDetail{} }
func (m *ErrorDetail) String() string { return proto.CompactTextString(m) }
func (*ErrorDetail) ProtoMessage()    {}
func (*ErrorDetail) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{30}
}
func (m *ErrorDetail) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ErrorDetail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ErrorDetail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ErrorDetail.Merge(dst, src)
}
func (m *ErrorDetail) XXX_Size() int {
	return m.Size()
}
func (m *ErrorDetail) XXX_DiscardUnknown() {
	xxx_messageInfo_ErrorDetail.DiscardUnknown(m)
}

var xxx_messageInfo_ErrorDetail proto.InternalMessageInfo

type isErrorDetail_Value interface {
	isErrorDetail_Value()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type ErrorDetail_NotLeaseHolder struct {
	NotLeaseHolder *NotLeaseHolderError `protobuf:"bytes,1,opt,name=not_lease_holder,json=notLeaseHolder,oneof"`
}
type ErrorDetail_RangeNotFound struct {
	RangeNotFound *RangeNotFoundError `protobuf:"bytes,2,opt,name=range_not_found,json=rangeNotFound,oneof"`
}
type ErrorDetail_RangeKeyMismatch struct {
	RangeKeyMismatch *RangeKeyMismatchError `protobuf:"bytes,3,opt,name=range_key_mismatch,json=rangeKeyMismatch,oneof"`
}
type ErrorDetail_ReadWithinUncertaintyInterval struct {
	ReadWithinUncertaintyInterval *ReadWithinUncertaintyIntervalError `protobuf:"bytes,4,opt,name=read_within_uncertainty_interval,json=readWithinUncertaintyInterval,oneof"`
}
type ErrorDetail_TransactionAborted struct {
	TransactionAborted *TransactionAbortedError `protobuf:"bytes,5,opt,name=transaction_aborted,json=transactionAborted,oneof"`
}
type ErrorDetail_TransactionPush struct {
	TransactionPush *TransactionPushError `protobuf:"bytes,6,opt,name=transaction_push,json=transactionPush,oneof"`
}
type ErrorDetail_TransactionRetry struct {
	TransactionRetry *TransactionRetryError `protobuf:"bytes,7,opt,name=transaction_retry,json=transactionRetry,oneof"`
}
type ErrorDetail_TransactionStatus struct {
	TransactionStatus *TransactionStatusError `protobuf:"bytes,8,opt,name=transaction_status,json=transactionStatus,oneof"`
}
type ErrorDetail_WriteIntent struct {
	WriteIntent *WriteIntentError `protobuf:"bytes,9,opt,name=write_intent,json=writeIntent,oneof"`
}
type ErrorDetail_WriteTooOld struct {
	WriteTooOld *WriteTooOldError `protobuf:"bytes,10,opt,name=write_too_old,json=writeTooOld,oneof"`
}
type ErrorDetail_OpRequiresTxn struct {
	OpRequiresTxn *OpRequiresTxnError `protobuf:"bytes,11,opt,name=op_requires_txn,json=opRequiresTxn,oneof"`
}
type ErrorDetail_ConditionFailed struct {
	ConditionFailed *ConditionFailedError `protobuf:"bytes,12,opt,name=condition_failed,json=conditionFailed,oneof"`
}
type ErrorDetail_LeaseRejected struct {
	LeaseRejected *LeaseRejectedError `protobuf:"bytes,13,opt,name=lease_rejected,json=leaseRejected,oneof"`
}
type ErrorDetail_NodeUnavailable struct {
	NodeUnavailable *NodeUnavailableError `protobuf:"bytes,14,opt,name=node_unavailable,json=nodeUnavailable,oneof"`
}
type ErrorDetail_Send struct {
	Send *SendError `protobuf:"bytes,15,opt,name=send,oneof"`
}
type ErrorDetail_RaftGroupDeleted struct {
	RaftGroupDeleted *RaftGroupDeletedError `protobuf:"bytes,16,opt,name=raft_group_deleted,json=raftGroupDeleted,oneof"`
}
type ErrorDetail_ReplicaCorruption struct {
	ReplicaCorruption *ReplicaCorruptionError `protobuf:"bytes,17,opt,name=replica_corruption,json=replicaCorruption,oneof"`
}
type ErrorDetail_ReplicaTooOld struct {
	ReplicaTooOld *ReplicaTooOldError `protobuf:"bytes,18,opt,name=replica_too_old,json=replicaTooOld,oneof"`
}
type ErrorDetail_AmbiguousResult struct {
	AmbiguousResult *AmbiguousResultError `protobuf:"bytes,26,opt,name=ambiguous_result,json=ambiguousResult,oneof"`
}
type ErrorDetail_StoreNotFound struct {
	StoreNotFound *StoreNotFoundError `protobuf:"bytes,27,opt,name=store_not_found,json=storeNotFound,oneof"`
}
type ErrorDetail_TransactionRetryWithProtoRefresh struct {
	TransactionRetryWithProtoRefresh *TransactionRetryWithProtoRefreshError `protobuf:"bytes,28,opt,name=transaction_retry_with_proto_refresh,json=transactionRetryWithProtoRefresh,oneof"`
}
type ErrorDetail_IntegerOverflow struct {
	IntegerOverflow *IntegerOverflowError `protobuf:"bytes,31,opt,name=integer_overflow,json=integerOverflow,oneof"`
}
type ErrorDetail_UnsupportedRequest struct {
	UnsupportedRequest *UnsupportedRequestError `protobuf:"bytes,32,opt,name=unsupported_request,json=unsupportedRequest,oneof"`
}
type ErrorDetail_MixedSuccess struct {
	MixedSuccess *MixedSuccessError `protobuf:"bytes,33,opt,name=mixed_success,json=mixedSuccess,oneof"`
}
type ErrorDetail_TimestampBefore struct {
	TimestampBefore *BatchTimestampBeforeGCError `protobuf:"bytes,34,opt,name=timestamp_before,json=timestampBefore,oneof"`
}
type ErrorDetail_TxnAlreadyEncounteredError struct {
	TxnAlreadyEncounteredError *TxnAlreadyEncounteredErrorError `protobuf:"bytes,35,opt,name=txn_already_encountered_error,json=txnAlreadyEncounteredError,oneof"`
}
type ErrorDetail_IntentMissing struct {
	IntentMissing *IntentMissingError `protobuf:"bytes,36,opt,name=intent_missing,json=intentMissing,oneof"`
}
type ErrorDetail_MergeInProgress struct {
	MergeInProgress *MergeInProgressError `protobuf:"bytes,37,opt,name=merge_in_progress,json=mergeInProgress,oneof"`
}
type ErrorDetail_RangefeedRetry struct {
	RangefeedRetry *RangeFeedRetryError `protobuf:"bytes,38,opt,name=rangefeed_retry,json=rangefeedRetry,oneof"`
}

func (*ErrorDetail_NotLeaseHolder) isErrorDetail_Value()                   {}
func (*ErrorDetail_RangeNotFound) isErrorDetail_Value()                    {}
func (*ErrorDetail_RangeKeyMismatch) isErrorDetail_Value()                 {}
func (*ErrorDetail_ReadWithinUncertaintyInterval) isErrorDetail_Value()    {}
func (*ErrorDetail_TransactionAborted) isErrorDetail_Value()               {}
func (*ErrorDetail_TransactionPush) isErrorDetail_Value()                  {}
func (*ErrorDetail_TransactionRetry) isErrorDetail_Value()                 {}
func (*ErrorDetail_TransactionStatus) isErrorDetail_Value()                {}
func (*ErrorDetail_WriteIntent) isErrorDetail_Value()                      {}
func (*ErrorDetail_WriteTooOld) isErrorDetail_Value()                      {}
func (*ErrorDetail_OpRequiresTxn) isErrorDetail_Value()                    {}
func (*ErrorDetail_ConditionFailed) isErrorDetail_Value()                  {}
func (*ErrorDetail_LeaseRejected) isErrorDetail_Value()                    {}
func (*ErrorDetail_NodeUnavailable) isErrorDetail_Value()                  {}
func (*ErrorDetail_Send) isErrorDetail_Value()                             {}
func (*ErrorDetail_RaftGroupDeleted) isErrorDetail_Value()                 {}
func (*ErrorDetail_ReplicaCorruption) isErrorDetail_Value()                {}
func (*ErrorDetail_ReplicaTooOld) isErrorDetail_Value()                    {}
func (*ErrorDetail_AmbiguousResult) isErrorDetail_Value()                  {}
func (*ErrorDetail_StoreNotFound) isErrorDetail_Value()                    {}
func (*ErrorDetail_TransactionRetryWithProtoRefresh) isErrorDetail_Value() {}
func (*ErrorDetail_IntegerOverflow) isErrorDetail_Value()                  {}
func (*ErrorDetail_UnsupportedRequest) isErrorDetail_Value()               {}
func (*ErrorDetail_MixedSuccess) isErrorDetail_Value()                     {}
func (*ErrorDetail_TimestampBefore) isErrorDetail_Value()                  {}
func (*ErrorDetail_TxnAlreadyEncounteredError) isErrorDetail_Value()       {}
func (*ErrorDetail_IntentMissing) isErrorDetail_Value()                    {}
func (*ErrorDetail_MergeInProgress) isErrorDetail_Value()                  {}
func (*ErrorDetail_RangefeedRetry) isErrorDetail_Value()                   {}

func (m *ErrorDetail) GetValue() isErrorDetail_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ErrorDetail) GetNotLeaseHolder() *NotLeaseHolderError {
	if x, ok := m.GetValue().(*ErrorDetail_NotLeaseHolder); ok {
		return x.NotLeaseHolder
	}
	return nil
}

func (m *ErrorDetail) GetRangeNotFound() *RangeNotFoundError {
	if x, ok := m.GetValue().(*ErrorDetail_RangeNotFound); ok {
		return x.RangeNotFound
	}
	return nil
}

func (m *ErrorDetail) GetRangeKeyMismatch() *RangeKeyMismatchError {
	if x, ok := m.GetValue().(*ErrorDetail_RangeKeyMismatch); ok {
		return x.RangeKeyMismatch
	}
	return nil
}

func (m *ErrorDetail) GetReadWithinUncertaintyInterval() *ReadWithinUncertaintyIntervalError {
	if x, ok := m.GetValue().(*ErrorDetail_ReadWithinUncertaintyInterval); ok {
		return x.ReadWithinUncertaintyInterval
	}
	return nil
}

func (m *ErrorDetail) GetTransactionAborted() *TransactionAbortedError {
	if x, ok := m.GetValue().(*ErrorDetail_TransactionAborted); ok {
		return x.TransactionAborted
	}
	return nil
}

func (m *ErrorDetail) GetTransactionPush() *TransactionPushError {
	if x, ok := m.GetValue().(*ErrorDetail_TransactionPush); ok {
		return x.TransactionPush
	}
	return nil
}

func (m *ErrorDetail) GetTransactionRetry() *TransactionRetryError {
	if x, ok := m.GetValue().(*ErrorDetail_TransactionRetry); ok {
		return x.TransactionRetry
	}
	return nil
}

func (m *ErrorDetail) GetTransactionStatus() *TransactionStatusError {
	if x, ok := m.GetValue().(*ErrorDetail_TransactionStatus); ok {
		return x.TransactionStatus
	}
	return nil
}

func (m *ErrorDetail) GetWriteIntent() *WriteIntentError {
	if x, ok := m.GetValue().(*ErrorDetail_WriteIntent); ok {
		return x.WriteIntent
	}
	return nil
}

func (m *ErrorDetail) GetWriteTooOld() *WriteTooOldError {
	if x, ok := m.GetValue().(*ErrorDetail_WriteTooOld); ok {
		return x.WriteTooOld
	}
	return nil
}

func (m *ErrorDetail) GetOpRequiresTxn() *OpRequiresTxnError {
	if x, ok := m.GetValue().(*ErrorDetail_OpRequiresTxn); ok {
		return x.OpRequiresTxn
	}
	return nil
}

func (m *ErrorDetail) GetConditionFailed() *ConditionFailedError {
	if x, ok := m.GetValue().(*ErrorDetail_ConditionFailed); ok {
		return x.ConditionFailed
	}
	return nil
}

func (m *ErrorDetail) GetLeaseRejected() *LeaseRejectedError {
	if x, ok := m.GetValue().(*ErrorDetail_LeaseRejected); ok {
		return x.LeaseRejected
	}
	return nil
}

func (m *ErrorDetail) GetNodeUnavailable() *NodeUnavailableError {
	if x, ok := m.GetValue().(*ErrorDetail_NodeUnavailable); ok {
		return x.NodeUnavailable
	}
	return nil
}

func (m *ErrorDetail) GetSend() *SendError {
	if x, ok := m.GetValue().(*ErrorDetail_Send); ok {
		return x.Send
	}
	return nil
}

func (m *ErrorDetail) GetRaftGroupDeleted() *RaftGroupDeletedError {
	if x, ok := m.GetValue().(*ErrorDetail_RaftGroupDeleted); ok {
		return x.RaftGroupDeleted
	}
	return nil
}

func (m *ErrorDetail) GetReplicaCorruption() *ReplicaCorruptionError {
	if x, ok := m.GetValue().(*ErrorDetail_ReplicaCorruption); ok {
		return x.ReplicaCorruption
	}
	return nil
}

func (m *ErrorDetail) GetReplicaTooOld() *ReplicaTooOldError {
	if x, ok := m.GetValue().(*ErrorDetail_ReplicaTooOld); ok {
		return x.ReplicaTooOld
	}
	return nil
}

func (m *ErrorDetail) GetAmbiguousResult() *AmbiguousResultError {
	if x, ok := m.GetValue().(*ErrorDetail_AmbiguousResult); ok {
		return x.AmbiguousResult
	}
	return nil
}

func (m *ErrorDetail) GetStoreNotFound() *StoreNotFoundError {
	if x, ok := m.GetValue().(*ErrorDetail_StoreNotFound); ok {
		return x.StoreNotFound
	}
	return nil
}

func (m *ErrorDetail) GetTransactionRetryWithProtoRefresh() *TransactionRetryWithProtoRefreshError {
	if x, ok := m.GetValue().(*ErrorDetail_TransactionRetryWithProtoRefresh); ok {
		return x.TransactionRetryWithProtoRefresh
	}
	return nil
}

func (m *ErrorDetail) GetIntegerOverflow() *IntegerOverflowError {
	if x, ok := m.GetValue().(*ErrorDetail_IntegerOverflow); ok {
		return x.IntegerOverflow
	}
	return nil
}

func (m *ErrorDetail) GetUnsupportedRequest() *UnsupportedRequestError {
	if x, ok := m.GetValue().(*ErrorDetail_UnsupportedRequest); ok {
		return x.UnsupportedRequest
	}
	return nil
}

func (m *ErrorDetail) GetMixedSuccess() *MixedSuccessError {
	if x, ok := m.GetValue().(*ErrorDetail_MixedSuccess); ok {
		return x.MixedSuccess
	}
	return nil
}

func (m *ErrorDetail) GetTimestampBefore() *BatchTimestampBeforeGCError {
	if x, ok := m.GetValue().(*ErrorDetail_TimestampBefore); ok {
		return x.TimestampBefore
	}
	return nil
}

func (m *ErrorDetail) GetTxnAlreadyEncounteredError() *TxnAlreadyEncounteredErrorError {
	if x, ok := m.GetValue().(*ErrorDetail_TxnAlreadyEncounteredError); ok {
		return x.TxnAlreadyEncounteredError
	}
	return nil
}

func (m *ErrorDetail) GetIntentMissing() *IntentMissingError {
	if x, ok := m.GetValue().(*ErrorDetail_IntentMissing); ok {
		return x.IntentMissing
	}
	return nil
}

func (m *ErrorDetail) GetMergeInProgress() *MergeInProgressError {
	if x, ok := m.GetValue().(*ErrorDetail_MergeInProgress); ok {
		return x.MergeInProgress
	}
	return nil
}

func (m *ErrorDetail) GetRangefeedRetry() *RangeFeedRetryError {
	if x, ok := m.GetValue().(*ErrorDetail_RangefeedRetry); ok {
		return x.RangefeedRetry
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ErrorDetail) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ErrorDetail_OneofMarshaler, _ErrorDetail_OneofUnmarshaler, _ErrorDetail_OneofSizer, []interface{}{
		(*ErrorDetail_NotLeaseHolder)(nil),
		(*ErrorDetail_RangeNotFound)(nil),
		(*ErrorDetail_RangeKeyMismatch)(nil),
		(*ErrorDetail_ReadWithinUncertaintyInterval)(nil),
		(*ErrorDetail_TransactionAborted)(nil),
		(*ErrorDetail_TransactionPush)(nil),
		(*ErrorDetail_TransactionRetry)(nil),
		(*ErrorDetail_TransactionStatus)(nil),
		(*ErrorDetail_WriteIntent)(nil),
		(*ErrorDetail_WriteTooOld)(nil),
		(*ErrorDetail_OpRequiresTxn)(nil),
		(*ErrorDetail_ConditionFailed)(nil),
		(*ErrorDetail_LeaseRejected)(nil),
		(*ErrorDetail_NodeUnavailable)(nil),
		(*ErrorDetail_Send)(nil),
		(*ErrorDetail_RaftGroupDeleted)(nil),
		(*ErrorDetail_ReplicaCorruption)(nil),
		(*ErrorDetail_ReplicaTooOld)(nil),
		(*ErrorDetail_AmbiguousResult)(nil),
		(*ErrorDetail_StoreNotFound)(nil),
		(*ErrorDetail_TransactionRetryWithProtoRefresh)(nil),
		(*ErrorDetail_IntegerOverflow)(nil),
		(*ErrorDetail_UnsupportedRequest)(nil),
		(*ErrorDetail_MixedSuccess)(nil),
		(*ErrorDetail_TimestampBefore)(nil),
		(*ErrorDetail_TxnAlreadyEncounteredError)(nil),
		(*ErrorDetail_IntentMissing)(nil),
		(*ErrorDetail_MergeInProgress)(nil),
		(*ErrorDetail_RangefeedRetry)(nil),
	}
}

func _ErrorDetail_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ErrorDetail)
	// value
	switch x := m.Value.(type) {
	case *ErrorDetail_NotLeaseHolder:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NotLeaseHolder); err != nil {
			return err
		}
	case *ErrorDetail_RangeNotFound:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RangeNotFound); err != nil {
			return err
		}
	case *ErrorDetail_RangeKeyMismatch:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RangeKeyMismatch); err != nil {
			return err
		}
	case *ErrorDetail_ReadWithinUncertaintyInterval:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReadWithinUncertaintyInterval); err != nil {
			return err
		}
	case *ErrorDetail_TransactionAborted:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TransactionAborted); err != nil {
			return err
		}
	case *ErrorDetail_TransactionPush:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TransactionPush); err != nil {
			return err
		}
	case *ErrorDetail_TransactionRetry:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TransactionRetry); err != nil {
			return err
		}
	case *ErrorDetail_TransactionStatus:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TransactionStatus); err != nil {
			return err
		}
	case *ErrorDetail_WriteIntent:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WriteIntent); err != nil {
			return err
		}
	case *ErrorDetail_WriteTooOld:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WriteTooOld); err != nil {
			return err
		}
	case *ErrorDetail_OpRequiresTxn:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OpRequiresTxn); err != nil {
			return err
		}
	case *ErrorDetail_ConditionFailed:
		_ = b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ConditionFailed); err != nil {
			return err
		}
	case *ErrorDetail_LeaseRejected:
		_ = b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LeaseRejected); err != nil {
			return err
		}
	case *ErrorDetail_NodeUnavailable:
		_ = b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NodeUnavailable); err != nil {
			return err
		}
	case *ErrorDetail_Send:
		_ = b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Send); err != nil {
			return err
		}
	case *ErrorDetail_RaftGroupDeleted:
		_ = b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RaftGroupDeleted); err != nil {
			return err
		}
	case *ErrorDetail_ReplicaCorruption:
		_ = b.EncodeVarint(17<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReplicaCorruption); err != nil {
			return err
		}
	case *ErrorDetail_ReplicaTooOld:
		_ = b.EncodeVarint(18<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReplicaTooOld); err != nil {
			return err
		}
	case *ErrorDetail_AmbiguousResult:
		_ = b.EncodeVarint(26<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AmbiguousResult); err != nil {
			return err
		}
	case *ErrorDetail_StoreNotFound:
		_ = b.EncodeVarint(27<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StoreNotFound); err != nil {
			return err
		}
	case *ErrorDetail_TransactionRetryWithProtoRefresh:
		_ = b.EncodeVarint(28<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TransactionRetryWithProtoRefresh); err != nil {
			return err
		}
	case *ErrorDetail_IntegerOverflow:
		_ = b.EncodeVarint(31<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.IntegerOverflow); err != nil {
			return err
		}
	case *ErrorDetail_UnsupportedRequest:
		_ = b.EncodeVarint(32<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.UnsupportedRequest); err != nil {
			return err
		}
	case *ErrorDetail_MixedSuccess:
		_ = b.EncodeVarint(33<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MixedSuccess); err != nil {
			return err
		}
	case *ErrorDetail_TimestampBefore:
		_ = b.EncodeVarint(34<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimestampBefore); err != nil {
			return err
		}
	case *ErrorDetail_TxnAlreadyEncounteredError:
		_ = b.EncodeVarint(35<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TxnAlreadyEncounteredError); err != nil {
			return err
		}
	case *ErrorDetail_IntentMissing:
		_ = b.EncodeVarint(36<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.IntentMissing); err != nil {
			return err
		}
	case *ErrorDetail_MergeInProgress:
		_ = b.EncodeVarint(37<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MergeInProgress); err != nil {
			return err
		}
	case *ErrorDetail_RangefeedRetry:
		_ = b.EncodeVarint(38<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RangefeedRetry); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ErrorDetail.Value has unexpected type %T", x)
	}
	return nil
}

func _ErrorDetail_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ErrorDetail)
	switch tag {
	case 1: // value.not_lease_holder
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NotLeaseHolderError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_NotLeaseHolder{msg}
		return true, err
	case 2: // value.range_not_found
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RangeNotFoundError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_RangeNotFound{msg}
		return true, err
	case 3: // value.range_key_mismatch
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RangeKeyMismatchError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_RangeKeyMismatch{msg}
		return true, err
	case 4: // value.read_within_uncertainty_interval
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReadWithinUncertaintyIntervalError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_ReadWithinUncertaintyInterval{msg}
		return true, err
	case 5: // value.transaction_aborted
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransactionAbortedError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_TransactionAborted{msg}
		return true, err
	case 6: // value.transaction_push
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransactionPushError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_TransactionPush{msg}
		return true, err
	case 7: // value.transaction_retry
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransactionRetryError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_TransactionRetry{msg}
		return true, err
	case 8: // value.transaction_status
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransactionStatusError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_TransactionStatus{msg}
		return true, err
	case 9: // value.write_intent
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(WriteIntentError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_WriteIntent{msg}
		return true, err
	case 10: // value.write_too_old
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(WriteTooOldError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_WriteTooOld{msg}
		return true, err
	case 11: // value.op_requires_txn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(OpRequiresTxnError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_OpRequiresTxn{msg}
		return true, err
	case 12: // value.condition_failed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ConditionFailedError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_ConditionFailed{msg}
		return true, err
	case 13: // value.lease_rejected
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(LeaseRejectedError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_LeaseRejected{msg}
		return true, err
	case 14: // value.node_unavailable
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NodeUnavailableError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_NodeUnavailable{msg}
		return true, err
	case 15: // value.send
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SendError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_Send{msg}
		return true, err
	case 16: // value.raft_group_deleted
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RaftGroupDeletedError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_RaftGroupDeleted{msg}
		return true, err
	case 17: // value.replica_corruption
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReplicaCorruptionError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_ReplicaCorruption{msg}
		return true, err
	case 18: // value.replica_too_old
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReplicaTooOldError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_ReplicaTooOld{msg}
		return true, err
	case 26: // value.ambiguous_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AmbiguousResultError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_AmbiguousResult{msg}
		return true, err
	case 27: // value.store_not_found
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StoreNotFoundError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_StoreNotFound{msg}
		return true, err
	case 28: // value.transaction_retry_with_proto_refresh
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransactionRetryWithProtoRefreshError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_TransactionRetryWithProtoRefresh{msg}
		return true, err
	case 31: // value.integer_overflow
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(IntegerOverflowError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_IntegerOverflow{msg}
		return true, err
	case 32: // value.unsupported_request
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UnsupportedRequestError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_UnsupportedRequest{msg}
		return true, err
	case 33: // value.mixed_success
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MixedSuccessError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_MixedSuccess{msg}
		return true, err
	case 34: // value.timestamp_before
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BatchTimestampBeforeGCError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_TimestampBefore{msg}
		return true, err
	case 35: // value.txn_already_encountered_error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TxnAlreadyEncounteredErrorError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_TxnAlreadyEncounteredError{msg}
		return true, err
	case 36: // value.intent_missing
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(IntentMissingError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_IntentMissing{msg}
		return true, err
	case 37: // value.merge_in_progress
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MergeInProgressError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_MergeInProgress{msg}
		return true, err
	case 38: // value.rangefeed_retry
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RangeFeedRetryError)
		err := b.DecodeMessage(msg)
		m.Value = &ErrorDetail_RangefeedRetry{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ErrorDetail_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ErrorDetail)
	// value
	switch x := m.Value.(type) {
	case *ErrorDetail_NotLeaseHolder:
		s := proto.Size(x.NotLeaseHolder)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_RangeNotFound:
		s := proto.Size(x.RangeNotFound)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_RangeKeyMismatch:
		s := proto.Size(x.RangeKeyMismatch)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_ReadWithinUncertaintyInterval:
		s := proto.Size(x.ReadWithinUncertaintyInterval)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_TransactionAborted:
		s := proto.Size(x.TransactionAborted)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_TransactionPush:
		s := proto.Size(x.TransactionPush)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_TransactionRetry:
		s := proto.Size(x.TransactionRetry)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_TransactionStatus:
		s := proto.Size(x.TransactionStatus)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_WriteIntent:
		s := proto.Size(x.WriteIntent)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_WriteTooOld:
		s := proto.Size(x.WriteTooOld)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_OpRequiresTxn:
		s := proto.Size(x.OpRequiresTxn)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_ConditionFailed:
		s := proto.Size(x.ConditionFailed)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_LeaseRejected:
		s := proto.Size(x.LeaseRejected)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_NodeUnavailable:
		s := proto.Size(x.NodeUnavailable)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_Send:
		s := proto.Size(x.Send)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_RaftGroupDeleted:
		s := proto.Size(x.RaftGroupDeleted)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_ReplicaCorruption:
		s := proto.Size(x.ReplicaCorruption)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_ReplicaTooOld:
		s := proto.Size(x.ReplicaTooOld)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_AmbiguousResult:
		s := proto.Size(x.AmbiguousResult)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_StoreNotFound:
		s := proto.Size(x.StoreNotFound)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_TransactionRetryWithProtoRefresh:
		s := proto.Size(x.TransactionRetryWithProtoRefresh)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_IntegerOverflow:
		s := proto.Size(x.IntegerOverflow)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_UnsupportedRequest:
		s := proto.Size(x.UnsupportedRequest)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_MixedSuccess:
		s := proto.Size(x.MixedSuccess)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_TimestampBefore:
		s := proto.Size(x.TimestampBefore)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_TxnAlreadyEncounteredError:
		s := proto.Size(x.TxnAlreadyEncounteredError)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_IntentMissing:
		s := proto.Size(x.IntentMissing)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_MergeInProgress:
		s := proto.Size(x.MergeInProgress)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ErrorDetail_RangefeedRetry:
		s := proto.Size(x.RangefeedRetry)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// ErrPosition describes the position of an error in a Batch. A simple nullable
// primitive field would break compatibility with proto3, where primitive fields
// are no longer allowed to be nullable.
type ErrPosition struct {
	Index                int32    `protobuf:"varint,1,opt,name=index" json:"index"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ErrPosition) Reset()         { *m = ErrPosition{} }
func (m *ErrPosition) String() string { return proto.CompactTextString(m) }
func (*ErrPosition) ProtoMessage()    {}
func (*ErrPosition) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{31}
}
func (m *ErrPosition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ErrPosition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ErrPosition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ErrPosition.Merge(dst, src)
}
func (m *ErrPosition) XXX_Size() int {
	return m.Size()
}
func (m *ErrPosition) XXX_DiscardUnknown() {
	xxx_messageInfo_ErrPosition.DiscardUnknown(m)
}

var xxx_messageInfo_ErrPosition proto.InternalMessageInfo

// Error is a generic representation including a string message
// and information about retryability.
type Error struct {
	// message is a human-readable error message.
	Message string `protobuf:"bytes,1,opt,name=message" json:"message"`
	// If transaction_restart is not ABORT, the error condition may be handled by
	// restarting the transaction.
	TransactionRestart TransactionRestart `protobuf:"varint,3,opt,name=transaction_restart,json=transactionRestart,enum=cockroach.roachpb.TransactionRestart" json:"transaction_restart"`
	// An optional updated transaction. This is to be used by the client in case
	// of retryable errors.
	//
	// Not to be accessed directly - use Error.GetTxn().
	UnexposedTxn *Transaction `protobuf:"bytes,4,opt,name=unexposed_txn,json=unexposedTxn" json:"unexposed_txn,omitempty"`
	// Node at which the error was generated (zero if does not apply).
	OriginNode NodeID `protobuf:"varint,5,opt,name=origin_node,json=originNode,casttype=NodeID" json:"origin_node"`
	// If an ErrorDetail is present, it may contain additional structured data
	// about the error.
	Detail ErrorDetail `protobuf:"bytes,6,opt,name=detail" json:"detail"`
	// The index, if given, contains the index of the request (in the batch)
	// whose execution caused the error.
	Index *ErrPosition `protobuf:"bytes,7,opt,name=index" json:"index,omitempty"`
	// now is the current time at the node sending the response,
	// which can be used by the receiver to update its local HLC.
	Now                  hlc.Timestamp `protobuf:"bytes,8,opt,name=now" json:"now"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Error) Reset()      { *m = Error{} }
func (*Error) ProtoMessage() {}
func (*Error) Descriptor() ([]byte, []int) {
	return fileDescriptor_errors_ee43f5f6d0e525bf, []int{32}
}
func (m *Error) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Error) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *Error) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Error.Merge(dst, src)
}
func (m *Error) XXX_Size() int {
	return m.Size()
}
func (m *Error) XXX_DiscardUnknown() {
	xxx_messageInfo_Error.DiscardUnknown(m)
}

var xxx_messageInfo_Error proto.InternalMessageInfo

func init() {
	proto.RegisterType((*NotLeaseHolderError)(nil), "cockroach.roachpb.NotLeaseHolderError")
	proto.RegisterType((*NodeUnavailableError)(nil), "cockroach.roachpb.NodeUnavailableError")
	proto.RegisterType((*UnsupportedRequestError)(nil), "cockroach.roachpb.UnsupportedRequestError")
	proto.RegisterType((*RangeNotFoundError)(nil), "cockroach.roachpb.RangeNotFoundError")
	proto.RegisterType((*RangeKeyMismatchError)(nil), "cockroach.roachpb.RangeKeyMismatchError")
	proto.RegisterType((*ReadWithinUncertaintyIntervalError)(nil), "cockroach.roachpb.ReadWithinUncertaintyIntervalError")
	proto.RegisterType((*TransactionAbortedError)(nil), "cockroach.roachpb.TransactionAbortedError")
	proto.RegisterType((*TransactionPushError)(nil), "cockroach.roachpb.TransactionPushError")
	proto.RegisterType((*TransactionRetryError)(nil), "cockroach.roachpb.TransactionRetryError")
	proto.RegisterType((*TransactionStatusError)(nil), "cockroach.roachpb.TransactionStatusError")
	proto.RegisterType((*WriteIntentError)(nil), "cockroach.roachpb.WriteIntentError")
	proto.RegisterType((*WriteTooOldError)(nil), "cockroach.roachpb.WriteTooOldError")
	proto.RegisterType((*OpRequiresTxnError)(nil), "cockroach.roachpb.OpRequiresTxnError")
	proto.RegisterType((*ConditionFailedError)(nil), "cockroach.roachpb.ConditionFailedError")
	proto.RegisterType((*LeaseRejectedError)(nil), "cockroach.roachpb.LeaseRejectedError")
	proto.RegisterType((*SendError)(nil), "cockroach.roachpb.SendError")
	proto.RegisterType((*AmbiguousResultError)(nil), "cockroach.roachpb.AmbiguousResultError")
	proto.RegisterType((*RaftGroupDeletedError)(nil), "cockroach.roachpb.RaftGroupDeletedError")
	proto.RegisterType((*ReplicaCorruptionError)(nil), "cockroach.roachpb.ReplicaCorruptionError")
	proto.RegisterType((*ReplicaTooOldError)(nil), "cockroach.roachpb.ReplicaTooOldError")
	proto.RegisterType((*StoreNotFoundError)(nil), "cockroach.roachpb.StoreNotFoundError")
	proto.RegisterType((*UnhandledRetryableError)(nil), "cockroach.roachpb.UnhandledRetryableError")
	proto.RegisterType((*TransactionRetryWithProtoRefreshError)(nil), "cockroach.roachpb.TransactionRetryWithProtoRefreshError")
	proto.RegisterType((*TxnAlreadyEncounteredErrorError)(nil), "cockroach.roachpb.TxnAlreadyEncounteredErrorError")
	proto.RegisterType((*IntegerOverflowError)(nil), "cockroach.roachpb.IntegerOverflowError")
	proto.RegisterType((*MixedSuccessError)(nil), "cockroach.roachpb.MixedSuccessError")
	proto.RegisterType((*BatchTimestampBeforeGCError)(nil), "cockroach.roachpb.BatchTimestampBeforeGCError")
	proto.RegisterType((*IntentMissingError)(nil), "cockroach.roachpb.IntentMissingError")
	proto.RegisterType((*MergeInProgressError)(nil), "cockroach.roachpb.MergeInProgressError")
	proto.RegisterType((*RangeFeedRetryError)(nil), "cockroach.roachpb.RangeFeedRetryError")
	proto.RegisterType((*ErrorDetail)(nil), "cockroach.roachpb.ErrorDetail")
	proto.RegisterType((*ErrPosition)(nil), "cockroach.roachpb.ErrPosition")
	proto.RegisterType((*Error)(nil), "cockroach.roachpb.Error")
	proto.RegisterEnum("cockroach.roachpb.TransactionAbortedReason", TransactionAbortedReason_name, TransactionAbortedReason_value)
	proto.RegisterEnum("cockroach.roachpb.TransactionRetryReason", TransactionRetryReason_name, TransactionRetryReason_value)
	proto.RegisterEnum("cockroach.roachpb.TransactionRestart", TransactionRestart_name, TransactionRestart_value)
	proto.RegisterEnum("cockroach.roachpb.TransactionStatusError_Reason", TransactionStatusError_Reason_name, TransactionStatusError_Reason_value)
	proto.RegisterEnum("cockroach.roachpb.RangeFeedRetryError_Reason", RangeFeedRetryError_Reason_name, RangeFeedRetryError_Reason_value)
}
func (this *NotLeaseHolderError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NotLeaseHolderError)
	if !ok {
		that2, ok := that.(NotLeaseHolderError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Replica.Equal(&that1.Replica) {
		return false
	}
	if !this.LeaseHolder.Equal(that1.LeaseHolder) {
		return false
	}
	if !this.Lease.Equal(that1.Lease) {
		return false
	}
	if this.RangeID != that1.RangeID {
		return false
	}
	if this.CustomMsg != that1.CustomMsg {
		return false
	}
	return true
}
func (this *NodeUnavailableError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NodeUnavailableError)
	if !ok {
		that2, ok := that.(NodeUnavailableError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *UnsupportedRequestError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UnsupportedRequestError)
	if !ok {
		that2, ok := that.(UnsupportedRequestError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *RangeNotFoundError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RangeNotFoundError)
	if !ok {
		that2, ok := that.(RangeNotFoundError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RangeID != that1.RangeID {
		return false
	}
	if this.StoreID != that1.StoreID {
		return false
	}
	return true
}
func (this *RangeKeyMismatchError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RangeKeyMismatchError)
	if !ok {
		that2, ok := that.(RangeKeyMismatchError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.RequestStartKey, that1.RequestStartKey) {
		return false
	}
	if !bytes.Equal(this.RequestEndKey, that1.RequestEndKey) {
		return false
	}
	if !this.MismatchedRange.Equal(that1.MismatchedRange) {
		return false
	}
	if !this.SuggestedRange.Equal(that1.SuggestedRange) {
		return false
	}
	return true
}
func (this *ReadWithinUncertaintyIntervalError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReadWithinUncertaintyIntervalError)
	if !ok {
		that2, ok := that.(ReadWithinUncertaintyIntervalError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ReadTimestamp.Equal(&that1.ReadTimestamp) {
		return false
	}
	if !this.ExistingTimestamp.Equal(&that1.ExistingTimestamp) {
		return false
	}
	if !this.MaxTimestamp.Equal(that1.MaxTimestamp) {
		return false
	}
	if len(this.ObservedTimestamps) != len(that1.ObservedTimestamps) {
		return false
	}
	for i := range this.ObservedTimestamps {
		if !this.ObservedTimestamps[i].Equal(&that1.ObservedTimestamps[i]) {
			return false
		}
	}
	return true
}
func (this *TransactionAbortedError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TransactionAbortedError)
	if !ok {
		that2, ok := that.(TransactionAbortedError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	return true
}
func (this *TransactionPushError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TransactionPushError)
	if !ok {
		that2, ok := that.(TransactionPushError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.PusheeTxn.Equal(&that1.PusheeTxn) {
		return false
	}
	return true
}
func (this *TransactionRetryError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TransactionRetryError)
	if !ok {
		that2, ok := that.(TransactionRetryError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	if this.ExtraMsg != that1.ExtraMsg {
		return false
	}
	return true
}
func (this *TransactionStatusError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TransactionStatusError)
	if !ok {
		that2, ok := that.(TransactionStatusError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Msg != that1.Msg {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	return true
}
func (this *WriteIntentError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WriteIntentError)
	if !ok {
		that2, ok := that.(WriteIntentError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Intents) != len(that1.Intents) {
		return false
	}
	for i := range this.Intents {
		if !this.Intents[i].Equal(&that1.Intents[i]) {
			return false
		}
	}
	return true
}
func (this *WriteTooOldError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WriteTooOldError)
	if !ok {
		that2, ok := that.(WriteTooOldError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	if !this.ActualTimestamp.Equal(&that1.ActualTimestamp) {
		return false
	}
	return true
}
func (this *OpRequiresTxnError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OpRequiresTxnError)
	if !ok {
		that2, ok := that.(OpRequiresTxnError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *ConditionFailedError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConditionFailedError)
	if !ok {
		that2, ok := that.(ConditionFailedError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ActualValue.Equal(that1.ActualValue) {
		return false
	}
	return true
}
func (this *LeaseRejectedError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LeaseRejectedError)
	if !ok {
		that2, ok := that.(LeaseRejectedError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	if !this.Requested.Equal(&that1.Requested) {
		return false
	}
	if !this.Existing.Equal(&that1.Existing) {
		return false
	}
	return true
}
func (this *SendError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SendError)
	if !ok {
		that2, ok := that.(SendError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	return true
}
func (this *AmbiguousResultError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AmbiguousResultError)
	if !ok {
		that2, ok := that.(AmbiguousResultError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	if !this.WrappedErr.Equal(that1.WrappedErr) {
		return false
	}
	return true
}
func (this *RaftGroupDeletedError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RaftGroupDeletedError)
	if !ok {
		that2, ok := that.(RaftGroupDeletedError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *ReplicaCorruptionError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicaCorruptionError)
	if !ok {
		that2, ok := that.(ReplicaCorruptionError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ErrorMsg != that1.ErrorMsg {
		return false
	}
	if this.Processed != that1.Processed {
		return false
	}
	return true
}
func (this *ReplicaTooOldError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicaTooOldError)
	if !ok {
		that2, ok := that.(ReplicaTooOldError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ReplicaID != that1.ReplicaID {
		return false
	}
	return true
}
func (this *StoreNotFoundError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*StoreNotFoundError)
	if !ok {
		that2, ok := that.(StoreNotFoundError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.StoreID != that1.StoreID {
		return false
	}
	return true
}
func (this *TransactionRetryWithProtoRefreshError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TransactionRetryWithProtoRefreshError)
	if !ok {
		that2, ok := that.(TransactionRetryWithProtoRefreshError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Msg != that1.Msg {
		return false
	}
	if !this.TxnID.Equal(that1.TxnID) {
		return false
	}
	if !this.Transaction.Equal(&that1.Transaction) {
		return false
	}
	return true
}
func (this *TxnAlreadyEncounteredErrorError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TxnAlreadyEncounteredErrorError)
	if !ok {
		that2, ok := that.(TxnAlreadyEncounteredErrorError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PrevError != that1.PrevError {
		return false
	}
	return true
}
func (this *IntegerOverflowError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*IntegerOverflowError)
	if !ok {
		that2, ok := that.(IntegerOverflowError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	if this.CurrentValue != that1.CurrentValue {
		return false
	}
	if this.IncrementValue != that1.IncrementValue {
		return false
	}
	return true
}
func (this *MixedSuccessError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MixedSuccessError)
	if !ok {
		that2, ok := that.(MixedSuccessError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Wrapped.Equal(that1.Wrapped) {
		return false
	}
	return true
}
func (this *BatchTimestampBeforeGCError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*BatchTimestampBeforeGCError)
	if !ok {
		that2, ok := that.(BatchTimestampBeforeGCError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	if !this.Threshold.Equal(&that1.Threshold) {
		return false
	}
	return true
}
func (this *IntentMissingError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*IntentMissingError)
	if !ok {
		that2, ok := that.(IntentMissingError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.WrongIntent.Equal(that1.WrongIntent) {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	return true
}
func (this *MergeInProgressError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MergeInProgressError)
	if !ok {
		that2, ok := that.(MergeInProgressError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *RangeFeedRetryError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RangeFeedRetryError)
	if !ok {
		that2, ok := that.(RangeFeedRetryError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Reason != that1.Reason {
		return false
	}
	return true
}
func (this *ErrorDetail) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail)
	if !ok {
		that2, ok := that.(ErrorDetail)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Value == nil {
		if this.Value != nil {
			return false
		}
	} else if this.Value == nil {
		return false
	} else if !this.Value.Equal(that1.Value) {
		return false
	}
	return true
}
func (this *ErrorDetail_NotLeaseHolder) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_NotLeaseHolder)
	if !ok {
		that2, ok := that.(ErrorDetail_NotLeaseHolder)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.NotLeaseHolder.Equal(that1.NotLeaseHolder) {
		return false
	}
	return true
}
func (this *ErrorDetail_RangeNotFound) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_RangeNotFound)
	if !ok {
		that2, ok := that.(ErrorDetail_RangeNotFound)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RangeNotFound.Equal(that1.RangeNotFound) {
		return false
	}
	return true
}
func (this *ErrorDetail_RangeKeyMismatch) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_RangeKeyMismatch)
	if !ok {
		that2, ok := that.(ErrorDetail_RangeKeyMismatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RangeKeyMismatch.Equal(that1.RangeKeyMismatch) {
		return false
	}
	return true
}
func (this *ErrorDetail_ReadWithinUncertaintyInterval) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_ReadWithinUncertaintyInterval)
	if !ok {
		that2, ok := that.(ErrorDetail_ReadWithinUncertaintyInterval)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ReadWithinUncertaintyInterval.Equal(that1.ReadWithinUncertaintyInterval) {
		return false
	}
	return true
}
func (this *ErrorDetail_TransactionAborted) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_TransactionAborted)
	if !ok {
		that2, ok := that.(ErrorDetail_TransactionAborted)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TransactionAborted.Equal(that1.TransactionAborted) {
		return false
	}
	return true
}
func (this *ErrorDetail_TransactionPush) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_TransactionPush)
	if !ok {
		that2, ok := that.(ErrorDetail_TransactionPush)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TransactionPush.Equal(that1.TransactionPush) {
		return false
	}
	return true
}
func (this *ErrorDetail_TransactionRetry) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_TransactionRetry)
	if !ok {
		that2, ok := that.(ErrorDetail_TransactionRetry)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TransactionRetry.Equal(that1.TransactionRetry) {
		return false
	}
	return true
}
func (this *ErrorDetail_TransactionStatus) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_TransactionStatus)
	if !ok {
		that2, ok := that.(ErrorDetail_TransactionStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TransactionStatus.Equal(that1.TransactionStatus) {
		return false
	}
	return true
}
func (this *ErrorDetail_WriteIntent) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_WriteIntent)
	if !ok {
		that2, ok := that.(ErrorDetail_WriteIntent)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.WriteIntent.Equal(that1.WriteIntent) {
		return false
	}
	return true
}
func (this *ErrorDetail_WriteTooOld) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_WriteTooOld)
	if !ok {
		that2, ok := that.(ErrorDetail_WriteTooOld)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.WriteTooOld.Equal(that1.WriteTooOld) {
		return false
	}
	return true
}
func (this *ErrorDetail_OpRequiresTxn) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_OpRequiresTxn)
	if !ok {
		that2, ok := that.(ErrorDetail_OpRequiresTxn)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.OpRequiresTxn.Equal(that1.OpRequiresTxn) {
		return false
	}
	return true
}
func (this *ErrorDetail_ConditionFailed) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_ConditionFailed)
	if !ok {
		that2, ok := that.(ErrorDetail_ConditionFailed)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ConditionFailed.Equal(that1.ConditionFailed) {
		return false
	}
	return true
}
func (this *ErrorDetail_LeaseRejected) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_LeaseRejected)
	if !ok {
		that2, ok := that.(ErrorDetail_LeaseRejected)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LeaseRejected.Equal(that1.LeaseRejected) {
		return false
	}
	return true
}
func (this *ErrorDetail_NodeUnavailable) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_NodeUnavailable)
	if !ok {
		that2, ok := that.(ErrorDetail_NodeUnavailable)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.NodeUnavailable.Equal(that1.NodeUnavailable) {
		return false
	}
	return true
}
func (this *ErrorDetail_Send) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_Send)
	if !ok {
		that2, ok := that.(ErrorDetail_Send)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Send.Equal(that1.Send) {
		return false
	}
	return true
}
func (this *ErrorDetail_RaftGroupDeleted) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_RaftGroupDeleted)
	if !ok {
		that2, ok := that.(ErrorDetail_RaftGroupDeleted)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RaftGroupDeleted.Equal(that1.RaftGroupDeleted) {
		return false
	}
	return true
}
func (this *ErrorDetail_ReplicaCorruption) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_ReplicaCorruption)
	if !ok {
		that2, ok := that.(ErrorDetail_ReplicaCorruption)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ReplicaCorruption.Equal(that1.ReplicaCorruption) {
		return false
	}
	return true
}
func (this *ErrorDetail_ReplicaTooOld) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_ReplicaTooOld)
	if !ok {
		that2, ok := that.(ErrorDetail_ReplicaTooOld)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ReplicaTooOld.Equal(that1.ReplicaTooOld) {
		return false
	}
	return true
}
func (this *ErrorDetail_AmbiguousResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_AmbiguousResult)
	if !ok {
		that2, ok := that.(ErrorDetail_AmbiguousResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.AmbiguousResult.Equal(that1.AmbiguousResult) {
		return false
	}
	return true
}
func (this *ErrorDetail_StoreNotFound) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_StoreNotFound)
	if !ok {
		that2, ok := that.(ErrorDetail_StoreNotFound)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.StoreNotFound.Equal(that1.StoreNotFound) {
		return false
	}
	return true
}
func (this *ErrorDetail_TransactionRetryWithProtoRefresh) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_TransactionRetryWithProtoRefresh)
	if !ok {
		that2, ok := that.(ErrorDetail_TransactionRetryWithProtoRefresh)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TransactionRetryWithProtoRefresh.Equal(that1.TransactionRetryWithProtoRefresh) {
		return false
	}
	return true
}
func (this *ErrorDetail_IntegerOverflow) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_IntegerOverflow)
	if !ok {
		that2, ok := that.(ErrorDetail_IntegerOverflow)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.IntegerOverflow.Equal(that1.IntegerOverflow) {
		return false
	}
	return true
}
func (this *ErrorDetail_UnsupportedRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_UnsupportedRequest)
	if !ok {
		that2, ok := that.(ErrorDetail_UnsupportedRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.UnsupportedRequest.Equal(that1.UnsupportedRequest) {
		return false
	}
	return true
}
func (this *ErrorDetail_MixedSuccess) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_MixedSuccess)
	if !ok {
		that2, ok := that.(ErrorDetail_MixedSuccess)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.MixedSuccess.Equal(that1.MixedSuccess) {
		return false
	}
	return true
}
func (this *ErrorDetail_TimestampBefore) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_TimestampBefore)
	if !ok {
		that2, ok := that.(ErrorDetail_TimestampBefore)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TimestampBefore.Equal(that1.TimestampBefore) {
		return false
	}
	return true
}
func (this *ErrorDetail_TxnAlreadyEncounteredError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_TxnAlreadyEncounteredError)
	if !ok {
		that2, ok := that.(ErrorDetail_TxnAlreadyEncounteredError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TxnAlreadyEncounteredError.Equal(that1.TxnAlreadyEncounteredError) {
		return false
	}
	return true
}
func (this *ErrorDetail_IntentMissing) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_IntentMissing)
	if !ok {
		that2, ok := that.(ErrorDetail_IntentMissing)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.IntentMissing.Equal(that1.IntentMissing) {
		return false
	}
	return true
}
func (this *ErrorDetail_MergeInProgress) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_MergeInProgress)
	if !ok {
		that2, ok := that.(ErrorDetail_MergeInProgress)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.MergeInProgress.Equal(that1.MergeInProgress) {
		return false
	}
	return true
}
func (this *ErrorDetail_RangefeedRetry) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorDetail_RangefeedRetry)
	if !ok {
		that2, ok := that.(ErrorDetail_RangefeedRetry)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RangefeedRetry.Equal(that1.RangefeedRetry) {
		return false
	}
	return true
}
func (this *ErrPosition) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrPosition)
	if !ok {
		that2, ok := that.(ErrPosition)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Index != that1.Index {
		return false
	}
	return true
}
func (this *Error) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Error)
	if !ok {
		that2, ok := that.(Error)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	if this.TransactionRestart != that1.TransactionRestart {
		return false
	}
	if !this.UnexposedTxn.Equal(that1.UnexposedTxn) {
		return false
	}
	if this.OriginNode != that1.OriginNode {
		return false
	}
	if !this.Detail.Equal(&that1.Detail) {
		return false
	}
	if !this.Index.Equal(that1.Index) {
		return false
	}
	if !this.Now.Equal(&that1.Now) {
		return false
	}
	return true
}
func (m *NotLeaseHolderError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NotLeaseHolderError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Replica.Size()))
	n1, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.LeaseHolder != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.LeaseHolder.Size()))
		n2, err := m.LeaseHolder.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	dAtA[i] = 0x18
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.RangeID))
	if m.Lease != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.Lease.Size()))
		n3, err := m.Lease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.CustomMsg)))
	i += copy(dAtA[i:], m.CustomMsg)
	return i, nil
}

func (m *NodeUnavailableError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeUnavailableError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *UnsupportedRequestError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UnsupportedRequestError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *RangeNotFoundError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeNotFoundError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.RangeID))
	dAtA[i] = 0x10
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.StoreID))
	return i, nil
}

func (m *RangeKeyMismatchError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeKeyMismatchError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RequestStartKey != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrors(dAtA, i, uint64(len(m.RequestStartKey)))
		i += copy(dAtA[i:], m.RequestStartKey)
	}
	if m.RequestEndKey != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintErrors(dAtA, i, uint64(len(m.RequestEndKey)))
		i += copy(dAtA[i:], m.RequestEndKey)
	}
	if m.MismatchedRange != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.MismatchedRange.Size()))
		n4, err := m.MismatchedRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.SuggestedRange != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.SuggestedRange.Size()))
		n5, err := m.SuggestedRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *ReadWithinUncertaintyIntervalError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadWithinUncertaintyIntervalError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.ReadTimestamp.Size()))
	n6, err := m.ReadTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	dAtA[i] = 0x12
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.ExistingTimestamp.Size()))
	n7, err := m.ExistingTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	if m.MaxTimestamp != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.MaxTimestamp.Size()))
		n8, err := m.MaxTimestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if len(m.ObservedTimestamps) > 0 {
		for _, msg := range m.ObservedTimestamps {
			dAtA[i] = 0x22
			i++
			i = encodeVarintErrors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *TransactionAbortedError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransactionAbortedError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Reason))
	return i, nil
}

func (m *TransactionPushError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransactionPushError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.PusheeTxn.Size()))
	n9, err := m.PusheeTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	return i, nil
}

func (m *TransactionRetryError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransactionRetryError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Reason))
	dAtA[i] = 0x12
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.ExtraMsg)))
	i += copy(dAtA[i:], m.ExtraMsg)
	return i, nil
}

func (m *TransactionStatusError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransactionStatusError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.Msg)))
	i += copy(dAtA[i:], m.Msg)
	dAtA[i] = 0x10
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Reason))
	return i, nil
}

func (m *WriteIntentError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteIntentError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Intents) > 0 {
		for _, msg := range m.Intents {
			dAtA[i] = 0xa
			i++
			i = encodeVarintErrors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *WriteTooOldError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteTooOldError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Timestamp.Size()))
	n10, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	dAtA[i] = 0x12
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.ActualTimestamp.Size()))
	n11, err := m.ActualTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	return i, nil
}

func (m *OpRequiresTxnError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OpRequiresTxnError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ConditionFailedError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConditionFailedError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ActualValue != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.ActualValue.Size()))
		n12, err := m.ActualValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}

func (m *LeaseRejectedError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LeaseRejectedError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.Message)))
	i += copy(dAtA[i:], m.Message)
	dAtA[i] = 0x12
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Requested.Size()))
	n13, err := m.Requested.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n13
	dAtA[i] = 0x1a
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Existing.Size()))
	n14, err := m.Existing.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n14
	return i, nil
}

func (m *SendError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SendError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.Message)))
	i += copy(dAtA[i:], m.Message)
	return i, nil
}

func (m *AmbiguousResultError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AmbiguousResultError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.Message)))
	i += copy(dAtA[i:], m.Message)
	if m.WrappedErr != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.WrappedErr.Size()))
		n15, err := m.WrappedErr.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}

func (m *RaftGroupDeletedError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftGroupDeletedError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ReplicaCorruptionError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaCorruptionError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.ErrorMsg)))
	i += copy(dAtA[i:], m.ErrorMsg)
	dAtA[i] = 0x10
	i++
	if m.Processed {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *ReplicaTooOldError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaTooOldError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.ReplicaID))
	return i, nil
}

func (m *StoreNotFoundError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreNotFoundError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.StoreID))
	return i, nil
}

func (m *UnhandledRetryableError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UnhandledRetryableError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.PErr.Size()))
	n16, err := m.PErr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n16
	return i, nil
}

func (m *TransactionRetryWithProtoRefreshError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransactionRetryWithProtoRefreshError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.Msg)))
	i += copy(dAtA[i:], m.Msg)
	dAtA[i] = 0x12
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.TxnID.Size()))
	n17, err := m.TxnID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	dAtA[i] = 0x1a
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Transaction.Size()))
	n18, err := m.Transaction.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	return i, nil
}

func (m *TxnAlreadyEncounteredErrorError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxnAlreadyEncounteredErrorError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.PrevError)))
	i += copy(dAtA[i:], m.PrevError)
	return i, nil
}

func (m *IntegerOverflowError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IntegerOverflowError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrors(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x10
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.CurrentValue))
	dAtA[i] = 0x18
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.IncrementValue))
	return i, nil
}

func (m *MixedSuccessError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MixedSuccessError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Wrapped != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.Wrapped.Size()))
		n19, err := m.Wrapped.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	return i, nil
}

func (m *BatchTimestampBeforeGCError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchTimestampBeforeGCError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Timestamp.Size()))
	n20, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	dAtA[i] = 0x12
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Threshold.Size()))
	n21, err := m.Threshold.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n21
	return i, nil
}

func (m *IntentMissingError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IntentMissingError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.WrongIntent != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.WrongIntent.Size()))
		n22, err := m.WrongIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.Key != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintErrors(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	return i, nil
}

func (m *MergeInProgressError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeInProgressError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *RangeFeedRetryError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeFeedRetryError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Reason))
	return i, nil
}

func (m *ErrorDetail) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ErrorDetail) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		nn23, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn23
	}
	return i, nil
}

func (m *ErrorDetail_NotLeaseHolder) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.NotLeaseHolder != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.NotLeaseHolder.Size()))
		n24, err := m.NotLeaseHolder.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	return i, nil
}
func (m *ErrorDetail_RangeNotFound) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RangeNotFound != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.RangeNotFound.Size()))
		n25, err := m.RangeNotFound.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	return i, nil
}
func (m *ErrorDetail_RangeKeyMismatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RangeKeyMismatch != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.RangeKeyMismatch.Size()))
		n26, err := m.RangeKeyMismatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	return i, nil
}
func (m *ErrorDetail_ReadWithinUncertaintyInterval) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ReadWithinUncertaintyInterval != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.ReadWithinUncertaintyInterval.Size()))
		n27, err := m.ReadWithinUncertaintyInterval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	return i, nil
}
func (m *ErrorDetail_TransactionAborted) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TransactionAborted != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.TransactionAborted.Size()))
		n28, err := m.TransactionAborted.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	return i, nil
}
func (m *ErrorDetail_TransactionPush) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TransactionPush != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.TransactionPush.Size()))
		n29, err := m.TransactionPush.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	return i, nil
}
func (m *ErrorDetail_TransactionRetry) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TransactionRetry != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.TransactionRetry.Size()))
		n30, err := m.TransactionRetry.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	return i, nil
}
func (m *ErrorDetail_TransactionStatus) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TransactionStatus != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.TransactionStatus.Size()))
		n31, err := m.TransactionStatus.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	return i, nil
}
func (m *ErrorDetail_WriteIntent) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.WriteIntent != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.WriteIntent.Size()))
		n32, err := m.WriteIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	return i, nil
}
func (m *ErrorDetail_WriteTooOld) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.WriteTooOld != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.WriteTooOld.Size()))
		n33, err := m.WriteTooOld.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	return i, nil
}
func (m *ErrorDetail_OpRequiresTxn) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.OpRequiresTxn != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.OpRequiresTxn.Size()))
		n34, err := m.OpRequiresTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	return i, nil
}
func (m *ErrorDetail_ConditionFailed) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ConditionFailed != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.ConditionFailed.Size()))
		n35, err := m.ConditionFailed.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n35
	}
	return i, nil
}
func (m *ErrorDetail_LeaseRejected) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LeaseRejected != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.LeaseRejected.Size()))
		n36, err := m.LeaseRejected.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n36
	}
	return i, nil
}
func (m *ErrorDetail_NodeUnavailable) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.NodeUnavailable != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.NodeUnavailable.Size()))
		n37, err := m.NodeUnavailable.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n37
	}
	return i, nil
}
func (m *ErrorDetail_Send) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Send != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.Send.Size()))
		n38, err := m.Send.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n38
	}
	return i, nil
}
func (m *ErrorDetail_RaftGroupDeleted) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RaftGroupDeleted != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.RaftGroupDeleted.Size()))
		n39, err := m.RaftGroupDeleted.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	return i, nil
}
func (m *ErrorDetail_ReplicaCorruption) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ReplicaCorruption != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.ReplicaCorruption.Size()))
		n40, err := m.ReplicaCorruption.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n40
	}
	return i, nil
}
func (m *ErrorDetail_ReplicaTooOld) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ReplicaTooOld != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.ReplicaTooOld.Size()))
		n41, err := m.ReplicaTooOld.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n41
	}
	return i, nil
}
func (m *ErrorDetail_AmbiguousResult) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AmbiguousResult != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.AmbiguousResult.Size()))
		n42, err := m.AmbiguousResult.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n42
	}
	return i, nil
}
func (m *ErrorDetail_StoreNotFound) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.StoreNotFound != nil {
		dAtA[i] = 0xda
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.StoreNotFound.Size()))
		n43, err := m.StoreNotFound.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n43
	}
	return i, nil
}
func (m *ErrorDetail_TransactionRetryWithProtoRefresh) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TransactionRetryWithProtoRefresh != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.TransactionRetryWithProtoRefresh.Size()))
		n44, err := m.TransactionRetryWithProtoRefresh.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n44
	}
	return i, nil
}
func (m *ErrorDetail_IntegerOverflow) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.IntegerOverflow != nil {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.IntegerOverflow.Size()))
		n45, err := m.IntegerOverflow.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n45
	}
	return i, nil
}
func (m *ErrorDetail_UnsupportedRequest) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.UnsupportedRequest != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.UnsupportedRequest.Size()))
		n46, err := m.UnsupportedRequest.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n46
	}
	return i, nil
}
func (m *ErrorDetail_MixedSuccess) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.MixedSuccess != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.MixedSuccess.Size()))
		n47, err := m.MixedSuccess.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n47
	}
	return i, nil
}
func (m *ErrorDetail_TimestampBefore) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TimestampBefore != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.TimestampBefore.Size()))
		n48, err := m.TimestampBefore.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n48
	}
	return i, nil
}
func (m *ErrorDetail_TxnAlreadyEncounteredError) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TxnAlreadyEncounteredError != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.TxnAlreadyEncounteredError.Size()))
		n49, err := m.TxnAlreadyEncounteredError.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n49
	}
	return i, nil
}
func (m *ErrorDetail_IntentMissing) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.IntentMissing != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.IntentMissing.Size()))
		n50, err := m.IntentMissing.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n50
	}
	return i, nil
}
func (m *ErrorDetail_MergeInProgress) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.MergeInProgress != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.MergeInProgress.Size()))
		n51, err := m.MergeInProgress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n51
	}
	return i, nil
}
func (m *ErrorDetail_RangefeedRetry) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RangefeedRetry != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.RangefeedRetry.Size()))
		n52, err := m.RangefeedRetry.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n52
	}
	return i, nil
}
func (m *ErrPosition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ErrPosition) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Index))
	return i, nil
}

func (m *Error) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Error) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.Message)))
	i += copy(dAtA[i:], m.Message)
	dAtA[i] = 0x18
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.TransactionRestart))
	if m.UnexposedTxn != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.UnexposedTxn.Size()))
		n53, err := m.UnexposedTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n53
	}
	dAtA[i] = 0x28
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.OriginNode))
	dAtA[i] = 0x32
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Detail.Size()))
	n54, err := m.Detail.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n54
	if m.Index != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.Index.Size()))
		n55, err := m.Index.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n55
	}
	dAtA[i] = 0x42
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Now.Size()))
	n56, err := m.Now.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n56
	return i, nil
}

func encodeVarintErrors(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *NotLeaseHolderError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Replica.Size()
	n += 1 + l + sovErrors(uint64(l))
	if m.LeaseHolder != nil {
		l = m.LeaseHolder.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	n += 1 + sovErrors(uint64(m.RangeID))
	if m.Lease != nil {
		l = m.Lease.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	l = len(m.CustomMsg)
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *NodeUnavailableError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *UnsupportedRequestError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RangeNotFoundError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovErrors(uint64(m.RangeID))
	n += 1 + sovErrors(uint64(m.StoreID))
	return n
}

func (m *RangeKeyMismatchError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestStartKey != nil {
		l = len(m.RequestStartKey)
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.RequestEndKey != nil {
		l = len(m.RequestEndKey)
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.MismatchedRange != nil {
		l = m.MismatchedRange.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.SuggestedRange != nil {
		l = m.SuggestedRange.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}

func (m *ReadWithinUncertaintyIntervalError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ReadTimestamp.Size()
	n += 1 + l + sovErrors(uint64(l))
	l = m.ExistingTimestamp.Size()
	n += 1 + l + sovErrors(uint64(l))
	if m.MaxTimestamp != nil {
		l = m.MaxTimestamp.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if len(m.ObservedTimestamps) > 0 {
		for _, e := range m.ObservedTimestamps {
			l = e.Size()
			n += 1 + l + sovErrors(uint64(l))
		}
	}
	return n
}

func (m *TransactionAbortedError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovErrors(uint64(m.Reason))
	return n
}

func (m *TransactionPushError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.PusheeTxn.Size()
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *TransactionRetryError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovErrors(uint64(m.Reason))
	l = len(m.ExtraMsg)
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *TransactionStatusError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Msg)
	n += 1 + l + sovErrors(uint64(l))
	n += 1 + sovErrors(uint64(m.Reason))
	return n
}

func (m *WriteIntentError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Intents) > 0 {
		for _, e := range m.Intents {
			l = e.Size()
			n += 1 + l + sovErrors(uint64(l))
		}
	}
	return n
}

func (m *WriteTooOldError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Timestamp.Size()
	n += 1 + l + sovErrors(uint64(l))
	l = m.ActualTimestamp.Size()
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *OpRequiresTxnError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ConditionFailedError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ActualValue != nil {
		l = m.ActualValue.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}

func (m *LeaseRejectedError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Message)
	n += 1 + l + sovErrors(uint64(l))
	l = m.Requested.Size()
	n += 1 + l + sovErrors(uint64(l))
	l = m.Existing.Size()
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *SendError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Message)
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *AmbiguousResultError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Message)
	n += 1 + l + sovErrors(uint64(l))
	if m.WrappedErr != nil {
		l = m.WrappedErr.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}

func (m *RaftGroupDeletedError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *ReplicaCorruptionError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ErrorMsg)
	n += 1 + l + sovErrors(uint64(l))
	n += 2
	return n
}

func (m *ReplicaTooOldError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovErrors(uint64(m.ReplicaID))
	return n
}

func (m *StoreNotFoundError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovErrors(uint64(m.StoreID))
	return n
}

func (m *UnhandledRetryableError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.PErr.Size()
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *TransactionRetryWithProtoRefreshError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Msg)
	n += 1 + l + sovErrors(uint64(l))
	l = m.TxnID.Size()
	n += 1 + l + sovErrors(uint64(l))
	l = m.Transaction.Size()
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *TxnAlreadyEncounteredErrorError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PrevError)
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *IntegerOverflowError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Key != nil {
		l = len(m.Key)
		n += 1 + l + sovErrors(uint64(l))
	}
	n += 1 + sovErrors(uint64(m.CurrentValue))
	n += 1 + sovErrors(uint64(m.IncrementValue))
	return n
}

func (m *MixedSuccessError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Wrapped != nil {
		l = m.Wrapped.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}

func (m *BatchTimestampBeforeGCError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Timestamp.Size()
	n += 1 + l + sovErrors(uint64(l))
	l = m.Threshold.Size()
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *IntentMissingError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WrongIntent != nil {
		l = m.WrongIntent.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.Key != nil {
		l = len(m.Key)
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}

func (m *MergeInProgressError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *RangeFeedRetryError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovErrors(uint64(m.Reason))
	return n
}

func (m *ErrorDetail) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *ErrorDetail_NotLeaseHolder) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NotLeaseHolder != nil {
		l = m.NotLeaseHolder.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_RangeNotFound) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RangeNotFound != nil {
		l = m.RangeNotFound.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_RangeKeyMismatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RangeKeyMismatch != nil {
		l = m.RangeKeyMismatch.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_ReadWithinUncertaintyInterval) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReadWithinUncertaintyInterval != nil {
		l = m.ReadWithinUncertaintyInterval.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_TransactionAborted) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TransactionAborted != nil {
		l = m.TransactionAborted.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_TransactionPush) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TransactionPush != nil {
		l = m.TransactionPush.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_TransactionRetry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TransactionRetry != nil {
		l = m.TransactionRetry.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_TransactionStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TransactionStatus != nil {
		l = m.TransactionStatus.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_WriteIntent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WriteIntent != nil {
		l = m.WriteIntent.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_WriteTooOld) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WriteTooOld != nil {
		l = m.WriteTooOld.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_OpRequiresTxn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OpRequiresTxn != nil {
		l = m.OpRequiresTxn.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_ConditionFailed) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConditionFailed != nil {
		l = m.ConditionFailed.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_LeaseRejected) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LeaseRejected != nil {
		l = m.LeaseRejected.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_NodeUnavailable) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NodeUnavailable != nil {
		l = m.NodeUnavailable.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_Send) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Send != nil {
		l = m.Send.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_RaftGroupDeleted) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RaftGroupDeleted != nil {
		l = m.RaftGroupDeleted.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_ReplicaCorruption) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReplicaCorruption != nil {
		l = m.ReplicaCorruption.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_ReplicaTooOld) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReplicaTooOld != nil {
		l = m.ReplicaTooOld.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_AmbiguousResult) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AmbiguousResult != nil {
		l = m.AmbiguousResult.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_StoreNotFound) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StoreNotFound != nil {
		l = m.StoreNotFound.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_TransactionRetryWithProtoRefresh) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TransactionRetryWithProtoRefresh != nil {
		l = m.TransactionRetryWithProtoRefresh.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_IntegerOverflow) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IntegerOverflow != nil {
		l = m.IntegerOverflow.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_UnsupportedRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UnsupportedRequest != nil {
		l = m.UnsupportedRequest.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_MixedSuccess) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MixedSuccess != nil {
		l = m.MixedSuccess.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_TimestampBefore) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TimestampBefore != nil {
		l = m.TimestampBefore.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_TxnAlreadyEncounteredError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TxnAlreadyEncounteredError != nil {
		l = m.TxnAlreadyEncounteredError.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_IntentMissing) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IntentMissing != nil {
		l = m.IntentMissing.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_MergeInProgress) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MergeInProgress != nil {
		l = m.MergeInProgress.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrorDetail_RangefeedRetry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RangefeedRetry != nil {
		l = m.RangefeedRetry.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}
func (m *ErrPosition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovErrors(uint64(m.Index))
	return n
}

func (m *Error) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Message)
	n += 1 + l + sovErrors(uint64(l))
	n += 1 + sovErrors(uint64(m.TransactionRestart))
	if m.UnexposedTxn != nil {
		l = m.UnexposedTxn.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	n += 1 + sovErrors(uint64(m.OriginNode))
	l = m.Detail.Size()
	n += 1 + l + sovErrors(uint64(l))
	if m.Index != nil {
		l = m.Index.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	l = m.Now.Size()
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func sovErrors(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozErrors(x uint64) (n int) {
	return sovErrors(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *NotLeaseHolderError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NotLeaseHolderError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NotLeaseHolderError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseHolder", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LeaseHolder == nil {
				m.LeaseHolder = &ReplicaDescriptor{}
			}
			if err := m.LeaseHolder.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Lease == nil {
				m.Lease = &Lease{}
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomMsg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CustomMsg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeUnavailableError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeUnavailableError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeUnavailableError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UnsupportedRequestError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UnsupportedRequestError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UnsupportedRequestError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeNotFoundError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeNotFoundError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeNotFoundError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeKeyMismatchError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeKeyMismatchError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeKeyMismatchError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestStartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestStartKey = append(m.RequestStartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.RequestStartKey == nil {
				m.RequestStartKey = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestEndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestEndKey = append(m.RequestEndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.RequestEndKey == nil {
				m.RequestEndKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MismatchedRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MismatchedRange == nil {
				m.MismatchedRange = &RangeDescriptor{}
			}
			if err := m.MismatchedRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuggestedRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SuggestedRange == nil {
				m.SuggestedRange = &RangeDescriptor{}
			}
			if err := m.SuggestedRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadWithinUncertaintyIntervalError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadWithinUncertaintyIntervalError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadWithinUncertaintyIntervalError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ReadTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExistingTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ExistingTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxTimestamp == nil {
				m.MaxTimestamp = &hlc.Timestamp{}
			}
			if err := m.MaxTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObservedTimestamps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ObservedTimestamps = append(m.ObservedTimestamps, ObservedTimestamp{})
			if err := m.ObservedTimestamps[len(m.ObservedTimestamps)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransactionAbortedError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransactionAbortedError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransactionAbortedError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			m.Reason = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Reason |= (TransactionAbortedReason(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransactionPushError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransactionPushError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransactionPushError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PusheeTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PusheeTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransactionRetryError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransactionRetryError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransactionRetryError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			m.Reason = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Reason |= (TransactionRetryReason(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtraMsg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExtraMsg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransactionStatusError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransactionStatusError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransactionStatusError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			m.Reason = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Reason |= (TransactionStatusError_Reason(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteIntentError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteIntentError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteIntentError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Intents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Intents = append(m.Intents, Intent{})
			if err := m.Intents[len(m.Intents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteTooOldError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteTooOldError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteTooOldError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActualTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ActualTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OpRequiresTxnError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OpRequiresTxnError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OpRequiresTxnError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConditionFailedError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConditionFailedError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConditionFailedError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActualValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ActualValue == nil {
				m.ActualValue = &Value{}
			}
			if err := m.ActualValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaseRejectedError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaseRejectedError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaseRejectedError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Requested", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Requested.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Existing", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Existing.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SendError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SendError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SendError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AmbiguousResultError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AmbiguousResultError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AmbiguousResultError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WrappedErr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WrappedErr == nil {
				m.WrappedErr = &Error{}
			}
			if err := m.WrappedErr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftGroupDeletedError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftGroupDeletedError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftGroupDeletedError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicaCorruptionError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicaCorruptionError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicaCorruptionError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMsg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMsg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Processed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Processed = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicaTooOldError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicaTooOldError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicaTooOldError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaID", wireType)
			}
			m.ReplicaID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicaID |= (ReplicaID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreNotFoundError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreNotFoundError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreNotFoundError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UnhandledRetryableError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UnhandledRetryableError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UnhandledRetryableError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PErr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PErr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransactionRetryWithProtoRefreshError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransactionRetryWithProtoRefreshError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransactionRetryWithProtoRefreshError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Transaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Transaction.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxnAlreadyEncounteredErrorError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxnAlreadyEncounteredErrorError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxnAlreadyEncounteredErrorError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrevError", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrevError = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IntegerOverflowError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IntegerOverflowError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IntegerOverflowError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentValue", wireType)
			}
			m.CurrentValue = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CurrentValue |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncrementValue", wireType)
			}
			m.IncrementValue = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IncrementValue |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MixedSuccessError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MixedSuccessError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MixedSuccessError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Wrapped", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Wrapped == nil {
				m.Wrapped = &Error{}
			}
			if err := m.Wrapped.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchTimestampBeforeGCError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BatchTimestampBeforeGCError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BatchTimestampBeforeGCError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Threshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Threshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IntentMissingError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IntentMissingError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IntentMissingError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WrongIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WrongIntent == nil {
				m.WrongIntent = &Intent{}
			}
			if err := m.WrongIntent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeInProgressError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeInProgressError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeInProgressError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeFeedRetryError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeFeedRetryError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeFeedRetryError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			m.Reason = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Reason |= (RangeFeedRetryError_Reason(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ErrorDetail) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ErrorDetail: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ErrorDetail: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotLeaseHolder", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NotLeaseHolderError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_NotLeaseHolder{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeNotFound", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RangeNotFoundError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_RangeNotFound{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeKeyMismatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RangeKeyMismatchError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_RangeKeyMismatch{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadWithinUncertaintyInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReadWithinUncertaintyIntervalError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_ReadWithinUncertaintyInterval{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransactionAborted", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TransactionAbortedError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_TransactionAborted{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransactionPush", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TransactionPushError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_TransactionPush{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransactionRetry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TransactionRetryError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_TransactionRetry{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransactionStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TransactionStatusError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_TransactionStatus{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &WriteIntentError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_WriteIntent{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteTooOld", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &WriteTooOldError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_WriteTooOld{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpRequiresTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &OpRequiresTxnError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_OpRequiresTxn{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConditionFailed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ConditionFailedError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_ConditionFailed{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseRejected", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LeaseRejectedError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_LeaseRejected{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeUnavailable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &NodeUnavailableError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_NodeUnavailable{v}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Send", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SendError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_Send{v}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftGroupDeleted", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RaftGroupDeletedError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_RaftGroupDeleted{v}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaCorruption", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReplicaCorruptionError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_ReplicaCorruption{v}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaTooOld", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReplicaTooOldError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_ReplicaTooOld{v}
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AmbiguousResult", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AmbiguousResultError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_AmbiguousResult{v}
			iNdEx = postIndex
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreNotFound", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &StoreNotFoundError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_StoreNotFound{v}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransactionRetryWithProtoRefresh", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TransactionRetryWithProtoRefreshError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_TransactionRetryWithProtoRefresh{v}
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntegerOverflow", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &IntegerOverflowError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_IntegerOverflow{v}
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnsupportedRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &UnsupportedRequestError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_UnsupportedRequest{v}
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MixedSuccess", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MixedSuccessError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_MixedSuccess{v}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimestampBefore", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &BatchTimestampBeforeGCError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_TimestampBefore{v}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnAlreadyEncounteredError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TxnAlreadyEncounteredErrorError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_TxnAlreadyEncounteredError{v}
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentMissing", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &IntentMissingError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_IntentMissing{v}
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeInProgress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MergeInProgressError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_MergeInProgress{v}
			iNdEx = postIndex
		case 38:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangefeedRetry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RangeFeedRetryError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ErrorDetail_RangefeedRetry{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ErrPosition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ErrPosition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ErrPosition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Error) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Error: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Error: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransactionRestart", wireType)
			}
			m.TransactionRestart = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TransactionRestart |= (TransactionRestart(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnexposedTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UnexposedTxn == nil {
				m.UnexposedTxn = &Transaction{}
			}
			if err := m.UnexposedTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginNode", wireType)
			}
			m.OriginNode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OriginNode |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Detail", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Detail.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Index == nil {
				m.Index = &ErrPosition{}
			}
			if err := m.Index.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Now", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Now.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipErrors(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthErrors
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowErrors
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipErrors(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthErrors = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowErrors   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("roachpb/errors.proto", fileDescriptor_errors_ee43f5f6d0e525bf) }

var fileDescriptor_errors_ee43f5f6d0e525bf = []byte{
	// 2864 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x59, 0xcd, 0x6f, 0x1b, 0xc7,
	0x15, 0xe7, 0x52, 0x94, 0x48, 0x3d, 0x7d, 0xad, 0xc7, 0x8a, 0xbc, 0x96, 0x63, 0x4a, 0x96, 0xe3,
	0xc4, 0x71, 0x11, 0xa9, 0x70, 0x6a, 0xb4, 0x71, 0x93, 0x03, 0x3f, 0x56, 0x22, 0x25, 0x7e, 0x28,
	0x4b, 0x2a, 0x8a, 0x93, 0x16, 0x83, 0x15, 0x77, 0x44, 0x6d, 0x4c, 0xee, 0xb2, 0xb3, 0x4b, 0x89,
	0xba, 0xf5, 0x98, 0xf6, 0xd4, 0x02, 0x3d, 0xf4, 0xd6, 0x00, 0x3d, 0x05, 0xbd, 0x16, 0xf9, 0x07,
	0x7a, 0xc9, 0xa5, 0x40, 0x8f, 0x41, 0x0f, 0x46, 0xeb, 0x02, 0x45, 0xd1, 0xfe, 0x07, 0x39, 0x15,
	0xf3, 0xb1, 0xe4, 0xae, 0xb8, 0x94, 0x99, 0x9c, 0xc4, 0x7d, 0x5f, 0xf3, 0xe6, 0xcd, 0x9b, 0xf7,
	0x7e, 0x6f, 0x04, 0xab, 0xd4, 0x35, 0x5b, 0x67, 0xbd, 0x93, 0x1d, 0x42, 0xa9, 0x4b, 0xbd, 0xed,
	0x1e, 0x75, 0x7d, 0x17, 0xdd, 0x68, 0xb9, 0xad, 0xe7, 0x9c, 0xb3, 0x2d, 0xf9, 0xeb, 0x28, 0x10,
	0xb4, 0x4c, 0xdf, 0x14, 0x62, 0xeb, 0x6b, 0x01, 0xad, 0x4b, 0x7c, 0x33, 0x44, 0xbf, 0xef, 0xf9,
	0x2e, 0x35, 0xdb, 0x64, 0x87, 0x38, 0x6d, 0xdb, 0x09, 0xfe, 0x30, 0xb9, 0xf3, 0x56, 0xeb, 0x5d,
	0x29, 0xa4, 0xf5, 0x7d, 0xbb, 0xb3, 0x73, 0xd6, 0x69, 0xed, 0xf8, 0x76, 0x97, 0x78, 0xbe, 0xd9,
	0xed, 0x49, 0xce, 0x6a, 0xdb, 0x6d, 0xbb, 0xfc, 0xe7, 0x0e, 0xfb, 0x25, 0xa8, 0x5b, 0x5f, 0x25,
	0xe1, 0x66, 0xcd, 0xf5, 0x2b, 0xc4, 0xf4, 0x48, 0xc9, 0xed, 0x58, 0x84, 0xea, 0xcc, 0x65, 0x54,
	0x84, 0x34, 0x25, 0xbd, 0x8e, 0xdd, 0x32, 0x35, 0x65, 0x53, 0x79, 0xb8, 0xf0, 0xf8, 0x8d, 0xed,
	0x31, 0xef, 0xb7, 0x0d, 0x21, 0x51, 0x24, 0x5e, 0x8b, 0xda, 0x3d, 0xdf, 0xa5, 0xf9, 0xd4, 0xd7,
	0x2f, 0x36, 0x12, 0x46, 0xa0, 0x8a, 0xf6, 0x60, 0xb1, 0xc3, 0x2c, 0xe3, 0x33, 0x6e, 0x5a, 0x4b,
	0x4e, 0x6f, 0xca, 0x58, 0xe8, 0x8c, 0x7c, 0x42, 0x4f, 0x20, 0x43, 0x4d, 0xa7, 0x4d, 0xb0, 0x6d,
	0x69, 0x33, 0x9b, 0xca, 0xc3, 0x99, 0xfc, 0x3a, 0x5b, 0xe9, 0xe5, 0x8b, 0x8d, 0xb4, 0xc1, 0xe8,
	0xe5, 0xe2, 0xb7, 0xa3, 0x9f, 0x46, 0x9a, 0xcb, 0x96, 0x2d, 0xb4, 0x0d, 0xb3, 0xdc, 0x8a, 0x96,
	0xe2, 0x0b, 0x6b, 0x31, 0x0b, 0xf3, 0x9d, 0x1b, 0x42, 0x0c, 0xdd, 0x07, 0x68, 0xf5, 0x3d, 0xdf,
	0xed, 0xe2, 0xae, 0xd7, 0xd6, 0x66, 0x37, 0x95, 0x87, 0xf3, 0x72, 0x4b, 0xf3, 0x82, 0x5e, 0xf5,
	0xda, 0x4f, 0x53, 0xff, 0xf9, 0x62, 0x43, 0xd9, 0x7a, 0x1d, 0x56, 0x6b, 0xae, 0x45, 0x8e, 0x1c,
	0xf3, 0xdc, 0xb4, 0x3b, 0xe6, 0x49, 0x87, 0xf0, 0xc0, 0x49, 0xee, 0x06, 0xdc, 0x3a, 0x72, 0xbc,
	0x7e, 0xaf, 0xe7, 0x52, 0x9f, 0x58, 0x06, 0xf9, 0x45, 0x9f, 0x78, 0x7e, 0x58, 0xe0, 0x73, 0x05,
	0x10, 0x77, 0xb7, 0xe6, 0xfa, 0xbb, 0x6e, 0xdf, 0xb1, 0x44, 0xd8, 0xc3, 0xfb, 0x54, 0xa6, 0xdf,
	0xe7, 0x13, 0xc8, 0xb0, 0xe4, 0xe0, 0x6a, 0xc9, 0xa8, 0x5a, 0x83, 0xd1, 0x85, 0x9a, 0xfc, 0x69,
	0xa4, 0xb9, 0x6c, 0xd9, 0x92, 0xae, 0xfc, 0x21, 0x09, 0xaf, 0x71, 0x8b, 0x07, 0xe4, 0xb2, 0x6a,
	0x7b, 0x5d, 0xd3, 0x6f, 0x9d, 0x09, 0x6f, 0xde, 0x85, 0x1b, 0x54, 0xb8, 0x8e, 0x3d, 0xdf, 0xa4,
	0x3e, 0x7e, 0x4e, 0x2e, 0xb9, 0x5b, 0x8b, 0xf9, 0xf4, 0xb7, 0x2f, 0x36, 0x66, 0x0e, 0xc8, 0xa5,
	0xb1, 0x22, 0x25, 0x1a, 0x4c, 0xe0, 0x80, 0x5c, 0xa2, 0x1d, 0x08, 0x48, 0x98, 0x38, 0x16, 0x57,
	0x49, 0x46, 0x55, 0x96, 0x24, 0x5f, 0x77, 0x2c, 0xa6, 0x50, 0x05, 0xb5, 0x2b, 0x97, 0x25, 0x16,
	0xe6, 0x5b, 0xe2, 0x67, 0xbc, 0xf0, 0x78, 0x2b, 0x2e, 0x51, 0x18, 0x3f, 0x94, 0x26, 0x2b, 0x23,
	0x5d, 0xce, 0x42, 0x07, 0xb0, 0xe2, 0xf5, 0xdb, 0x6d, 0xe2, 0xf9, 0x43, 0x6b, 0xa9, 0xa9, 0xad,
	0x2d, 0x0f, 0x55, 0x39, 0x47, 0x46, 0xe8, 0x7f, 0x49, 0xd8, 0x32, 0x88, 0x69, 0x1d, 0xdb, 0xfe,
	0x99, 0xed, 0x1c, 0x39, 0x2d, 0x42, 0x7d, 0xd3, 0x76, 0xfc, 0xcb, 0xb2, 0xe3, 0x13, 0x7a, 0x6e,
	0x76, 0x44, 0xb8, 0xf6, 0x61, 0x99, 0x12, 0xd3, 0xc2, 0xc3, 0x9b, 0x27, 0xaf, 0xce, 0xdd, 0xd0,
	0xc2, 0xec, 0x7a, 0x6e, 0x9f, 0x75, 0x5a, 0xdb, 0xcd, 0x40, 0x48, 0x26, 0xd8, 0x12, 0x53, 0x1d,
	0x12, 0x91, 0x01, 0x88, 0x0c, 0x6c, 0xcf, 0xb7, 0x9d, 0x76, 0xc8, 0x5e, 0x72, 0x7a, 0x7b, 0x37,
	0x02, 0xf5, 0x91, 0xcd, 0x3c, 0x2c, 0x75, 0xcd, 0x41, 0xc8, 0xdc, 0xcc, 0x14, 0xe6, 0x8c, 0xc5,
	0xae, 0x39, 0x18, 0xd9, 0xf8, 0x14, 0x6e, 0xba, 0x27, 0x1e, 0xa1, 0xe7, 0x24, 0xb4, 0x4f, 0x4f,
	0x4b, 0x6d, 0xce, 0x4c, 0xb8, 0xd8, 0x75, 0x29, 0x7d, 0xd5, 0x3f, 0xe4, 0x5e, 0x65, 0x78, 0x32,
	0xda, 0x9f, 0xc1, 0xad, 0x26, 0x35, 0x1d, 0xcf, 0x6c, 0xf9, 0xb6, 0xeb, 0xe4, 0x4e, 0xf8, 0x15,
	0x12, 0x11, 0x2e, 0xc3, 0x1c, 0x25, 0xa6, 0xe7, 0x3a, 0x3c, 0xb2, 0xcb, 0x8f, 0x7f, 0x10, 0xb3,
	0xe0, 0xb8, 0xae, 0xc1, 0x55, 0xe4, 0xba, 0xd2, 0x80, 0x5c, 0xcb, 0x84, 0xd5, 0x90, 0xfc, 0x61,
	0xdf, 0x93, 0x99, 0x5f, 0x00, 0xe8, 0xf5, 0xbd, 0x33, 0x42, 0xb0, 0x3f, 0x70, 0xe4, 0x31, 0x66,
	0xaf, 0x5f, 0x2c, 0x28, 0x14, 0x42, 0xaf, 0x39, 0x08, 0x96, 0xf8, 0x95, 0x02, 0xaf, 0x85, 0xc4,
	0x0c, 0xe2, 0xd3, 0x4b, 0xb1, 0xc8, 0xde, 0x95, 0xdd, 0xbc, 0x7d, 0xfd, 0x02, 0x5c, 0x33, 0x6e,
	0x2f, 0xe8, 0x1e, 0xcc, 0x93, 0x81, 0x4f, 0x4d, 0x5e, 0xb5, 0x92, 0xa1, 0xaa, 0x95, 0xe1, 0xe4,
	0x51, 0xd1, 0xfa, 0x46, 0x81, 0xb5, 0x90, 0xc5, 0x86, 0x6f, 0xfa, 0x7d, 0x4f, 0x38, 0xb3, 0x06,
	0x33, 0x4c, 0x5b, 0x09, 0x69, 0x33, 0x02, 0xaa, 0x0d, 0x9d, 0x4c, 0x72, 0x27, 0x7f, 0x78, 0xbd,
	0x93, 0x21, 0x93, 0xdb, 0x71, 0xbe, 0x6e, 0x1d, 0xc2, 0x9c, 0xa0, 0x23, 0x04, 0xcb, 0x86, 0x9e,
	0x6b, 0xd4, 0x6b, 0xf8, 0xa8, 0x76, 0x50, 0xab, 0x1f, 0xd7, 0xd4, 0x04, 0xd2, 0x60, 0x55, 0xd2,
	0x9a, 0x1f, 0xd7, 0x70, 0xad, 0xde, 0xc4, 0xbb, 0xf5, 0xa3, 0x5a, 0x51, 0x55, 0xae, 0x70, 0x0a,
	0xf5, 0x6a, 0xb5, 0xdc, 0x6c, 0xea, 0x45, 0x35, 0x29, 0xb7, 0xf6, 0x0c, 0xd4, 0x63, 0x6a, 0xfb,
	0x84, 0x5d, 0x49, 0x47, 0x94, 0x5a, 0xf4, 0x1e, 0xa4, 0x6d, 0xfe, 0xe9, 0x69, 0x0a, 0x4f, 0xd0,
	0xdb, 0x31, 0xce, 0x0b, 0x85, 0xa0, 0x73, 0x49, 0x79, 0x61, 0x74, 0x3f, 0x95, 0x49, 0xaa, 0x33,
	0x5b, 0x7f, 0x52, 0xa4, 0xed, 0xa6, 0xeb, 0xd6, 0x3b, 0x32, 0x15, 0x73, 0x30, 0xff, 0xbd, 0xee,
	0xf9, 0x48, 0x0b, 0xd5, 0x40, 0x35, 0x5b, 0x7e, 0xdf, 0xec, 0x7c, 0xbf, 0x1b, 0xbe, 0x22, 0x94,
	0x87, 0x64, 0x19, 0x88, 0x75, 0x40, 0xf5, 0x1e, 0xeb, 0x38, 0x36, 0x25, 0x5e, 0x73, 0xe0, 0x84,
	0xbb, 0xce, 0x33, 0x58, 0x2d, 0xb8, 0x8e, 0x65, 0xb3, 0x93, 0xda, 0x35, 0xed, 0x4e, 0x70, 0xaf,
	0x7e, 0x0a, 0x8b, 0xd2, 0x93, 0x73, 0xb3, 0xd3, 0x27, 0x72, 0x3f, 0x71, 0xed, 0xf2, 0x23, 0xc6,
	0x37, 0x16, 0x84, 0x34, 0xff, 0x90, 0xa6, 0xff, 0xac, 0x00, 0x12, 0xbd, 0x94, 0x7c, 0x46, 0x5a,
	0xc3, 0x1b, 0x9b, 0x85, 0x74, 0x97, 0x78, 0x9e, 0xd9, 0x26, 0x91, 0xd4, 0x0a, 0x88, 0xe8, 0x7d,
	0x98, 0x97, 0xdd, 0x80, 0x58, 0x72, 0xf3, 0x13, 0xbb, 0x74, 0x10, 0xc1, 0xa1, 0x02, 0x7a, 0x0a,
	0x99, 0xa0, 0xcc, 0xc9, 0x62, 0xf6, 0x2a, 0xe5, 0xa1, 0xbc, 0x74, 0xfb, 0xc7, 0x30, 0xdf, 0x20,
	0xce, 0x74, 0xce, 0x46, 0x92, 0xe2, 0x02, 0x56, 0x73, 0xdd, 0x13, 0xbb, 0xdd, 0x77, 0xfb, 0x9e,
	0x41, 0xbc, 0x7e, 0xc7, 0x9f, 0x6e, 0xc3, 0xef, 0xc1, 0xc2, 0x05, 0x35, 0x7b, 0x3d, 0x62, 0x61,
	0x42, 0xe9, 0x35, 0x5b, 0xe6, 0xe6, 0x0c, 0x90, 0xc2, 0x3a, 0x0d, 0xce, 0xf0, 0x2e, 0xeb, 0xd6,
	0xa7, 0xfe, 0x1e, 0x75, 0xfb, 0xbd, 0x22, 0xe9, 0x90, 0x20, 0xd4, 0x92, 0x4d, 0x60, 0x4d, 0x62,
	0xa9, 0x82, 0x4b, 0x69, 0xbf, 0xc7, 0x8e, 0x5a, 0x78, 0xc6, 0xaa, 0x04, 0xfb, 0x81, 0xaf, 0xde,
	0xf3, 0x0c, 0x27, 0x57, 0xbd, 0x36, 0xda, 0x82, 0xf9, 0x1e, 0x75, 0x5b, 0xc4, 0xf3, 0xe4, 0x69,
	0x64, 0x86, 0x55, 0x2d, 0x20, 0x0f, 0x33, 0x09, 0xc9, 0x65, 0xc2, 0x97, 0xe2, 0x03, 0x00, 0x09,
	0xfd, 0x02, 0x00, 0x33, 0x9b, 0xcf, 0x4a, 0x24, 0x32, 0x2f, 0xe5, 0x39, 0x16, 0x19, 0x7d, 0xb0,
	0xe3, 0x14, 0x3f, 0x03, 0xd3, 0x1f, 0x02, 0xe2, 0x48, 0x65, 0x0c, 0x19, 0x0d, 0x21, 0x8e, 0xf2,
	0x5d, 0x21, 0x4e, 0x95, 0xc1, 0xb1, 0x33, 0xd3, 0xb1, 0x3a, 0xac, 0x1b, 0xf8, 0xf4, 0x72, 0x88,
	0xd7, 0xd0, 0x63, 0x48, 0xf5, 0x74, 0x4a, 0xaf, 0x49, 0x79, 0x2e, 0x27, 0xe3, 0xc0, 0x65, 0xb7,
	0xfe, 0xab, 0xc0, 0x83, 0xab, 0x85, 0x99, 0x61, 0x83, 0x43, 0x06, 0xa9, 0x0d, 0x72, 0x4a, 0x49,
	0xd0, 0x47, 0x26, 0x55, 0xd5, 0x4f, 0x61, 0xce, 0x1f, 0x38, 0x01, 0x5c, 0x5b, 0xcc, 0x17, 0x19,
	0xeb, 0xef, 0x2f, 0x36, 0xde, 0x6d, 0xdb, 0xfe, 0x59, 0xff, 0x64, 0xbb, 0xe5, 0x76, 0x77, 0x86,
	0x9e, 0x58, 0x27, 0xa3, 0xdf, 0x3b, 0xbd, 0xe7, 0xed, 0x1d, 0x8e, 0xf1, 0xfb, 0x7d, 0xdb, 0xda,
	0x3e, 0x3a, 0x2a, 0x17, 0x5f, 0xbe, 0xd8, 0x98, 0x6d, 0x0e, 0x9c, 0x72, 0xd1, 0x98, 0xf5, 0x07,
	0x4e, 0xd9, 0x42, 0xbb, 0xb0, 0xe0, 0x8f, 0xbc, 0x93, 0x17, 0x63, 0xba, 0xee, 0x15, 0x56, 0x94,
	0xb1, 0xab, 0xc0, 0x46, 0x73, 0xe0, 0xe4, 0x3a, 0x0c, 0x9f, 0x5c, 0xea, 0x4e, 0xcb, 0xed, 0x33,
	0xd0, 0x23, 0x93, 0x4e, 0xec, 0xf2, 0x3e, 0x40, 0x8f, 0x92, 0x73, 0xcc, 0xf3, 0x28, 0xb2, 0xd9,
	0x79, 0x46, 0x0f, 0xa7, 0xe7, 0x6f, 0x15, 0x58, 0x65, 0x15, 0xb7, 0x4d, 0x68, 0xfd, 0x9c, 0xd0,
	0xd3, 0x8e, 0x7b, 0x21, 0x6c, 0xdc, 0x86, 0x99, 0x18, 0x74, 0xc9, 0x68, 0xe8, 0x6d, 0x58, 0x6a,
	0xf5, 0x29, 0x25, 0x8e, 0x2f, 0xcb, 0x93, 0x80, 0xb8, 0x62, 0x85, 0x45, 0xc9, 0xe2, 0xb5, 0x08,
	0xbd, 0x03, 0x2b, 0xb6, 0xd3, 0xa2, 0xa4, 0x3b, 0x12, 0x9e, 0x09, 0x09, 0x2f, 0x0f, 0x99, 0xe1,
	0xd2, 0x55, 0x85, 0x1b, 0x55, 0x7b, 0x40, 0xac, 0x46, 0xbf, 0xc5, 0x72, 0x3c, 0xc8, 0x8b, 0xb4,
	0xbc, 0x7a, 0xaf, 0x4a, 0x0d, 0x23, 0x10, 0x94, 0xe6, 0xbe, 0x54, 0xe0, 0x4e, 0x9e, 0x21, 0xd2,
	0x51, 0xc1, 0x26, 0xa7, 0x2e, 0x25, 0x7b, 0x85, 0x61, 0xe7, 0x68, 0x7e, 0xaf, 0xce, 0x31, 0x42,
	0x61, 0xcc, 0xc4, 0x19, 0xcb, 0x32, 0xb7, 0x63, 0x7d, 0x97, 0x96, 0x31, 0xd2, 0x92, 0xbe, 0x7a,
	0x80, 0x44, 0xff, 0xab, 0xda, 0x9e, 0x67, 0x3b, 0x6d, 0xe1, 0xe1, 0xfb, 0xb0, 0x78, 0x41, 0x5d,
	0xa7, 0x8d, 0x45, 0x37, 0x94, 0x4e, 0x4e, 0x6e, 0x9e, 0xc6, 0x02, 0x17, 0x17, 0x1f, 0xc1, 0x49,
	0x26, 0xc7, 0x4f, 0x72, 0x34, 0x3a, 0x55, 0x09, 0x6d, 0x93, 0xb2, 0x73, 0x48, 0xdd, 0x36, 0x0d,
	0x42, 0x2e, 0xb9, 0xbf, 0x4b, 0xc2, 0x4d, 0x0e, 0xbe, 0x77, 0x89, 0xbc, 0xac, 0xc2, 0xa9, 0x83,
	0x2b, 0x68, 0xe9, 0x9d, 0x49, 0x70, 0x3e, 0xaa, 0x17, 0x8f, 0x42, 0xbe, 0x54, 0x86, 0x30, 0x64,
	0x1d, 0xd6, 0x24, 0xb0, 0x30, 0xf4, 0xc3, 0x4a, 0xb9, 0x90, 0xc3, 0x86, 0x5e, 0xad, 0x7f, 0xa4,
	0x17, 0xd5, 0x04, 0x5a, 0x03, 0x14, 0xf0, 0x72, 0xb5, 0x3d, 0x1d, 0x37, 0x0e, 0x2b, 0xe5, 0xa6,
	0xaa, 0xa0, 0x5b, 0x70, 0x33, 0x42, 0xaf, 0xea, 0xc6, 0x1e, 0xc3, 0x22, 0x21, 0x94, 0x62, 0xe4,
	0x76, 0x9b, 0xb8, 0x51, 0xcb, 0x1d, 0x36, 0x4a, 0xf5, 0xa6, 0x3a, 0x83, 0xb2, 0xb0, 0x2e, 0x39,
	0x95, 0xfa, 0x5e, 0xb9, 0x90, 0xab, 0xe0, 0xfa, 0x61, 0x03, 0x57, 0xcb, 0x8d, 0x46, 0xb9, 0xb6,
	0xa7, 0xa6, 0x42, 0x9a, 0x8d, 0x4a, 0xfd, 0x18, 0x17, 0xea, 0xb5, 0xc6, 0x51, 0x55, 0x37, 0xd4,
	0x59, 0x19, 0x96, 0xbf, 0xac, 0xc2, 0x02, 0xdf, 0x50, 0x91, 0xf8, 0xa6, 0xdd, 0x41, 0x06, 0xa8,
	0x8e, 0xeb, 0xe3, 0xc8, 0x78, 0x2d, 0xce, 0xe9, 0xcd, 0x98, 0xc0, 0xc4, 0x8c, 0xf8, 0xa5, 0x84,
	0xb1, 0xec, 0x44, 0xc8, 0xa8, 0x0e, 0x2b, 0x62, 0xfa, 0x64, 0x96, 0x4f, 0x59, 0xed, 0x95, 0xc9,
	0xf5, 0x60, 0x52, 0xac, 0x23, 0x35, 0xba, 0xc4, 0xa6, 0x98, 0x30, 0x15, 0x7d, 0x0c, 0x48, 0x18,
	0x7c, 0x4e, 0x2e, 0x71, 0x30, 0xa8, 0xc9, 0x82, 0xf4, 0x70, 0x92, 0xcd, 0xab, 0x63, 0x68, 0x29,
	0x61, 0xa8, 0xf4, 0x0a, 0x03, 0xfd, 0x52, 0x81, 0x4d, 0x3e, 0x6c, 0x5d, 0xf0, 0x99, 0x0c, 0xf7,
	0x47, 0x43, 0x19, 0xcf, 0x5a, 0x36, 0x95, 0xc9, 0xb9, 0xef, 0x49, 0xec, 0x73, 0xc3, 0xab, 0xa6,
	0xb9, 0x52, 0xc2, 0xb8, 0x4b, 0xaf, 0x93, 0x42, 0x3f, 0x87, 0x9b, 0xa1, 0x6a, 0x89, 0x4d, 0x31,
	0x6c, 0xf0, 0x57, 0x83, 0x85, 0xc7, 0x8f, 0xa6, 0x9a, 0x4c, 0x82, 0x95, 0x90, 0x3f, 0xc6, 0x42,
	0x4d, 0x50, 0xc3, 0xe6, 0xd9, 0x58, 0xa1, 0xcd, 0x71, 0xdb, 0x6f, 0x5d, 0x6f, 0x7b, 0x38, 0xc5,
	0x94, 0x12, 0xc6, 0x8a, 0x1f, 0xa5, 0xa3, 0x63, 0xb8, 0x11, 0xb6, 0x4a, 0xd9, 0x3d, 0xd1, 0xd2,
	0x13, 0x0f, 0x24, 0x76, 0x70, 0x61, 0x07, 0xe2, 0x5f, 0x61, 0xa0, 0x4f, 0x20, 0xbc, 0x09, 0xec,
	0xf1, 0x39, 0x40, 0xcb, 0x70, 0xcb, 0x6f, 0x4f, 0x3d, 0x33, 0x94, 0x12, 0x46, 0xd8, 0x3f, 0xc1,
	0x41, 0x25, 0x56, 0x8f, 0x6c, 0x9f, 0x04, 0xf5, 0x68, 0x9e, 0x5b, 0xbd, 0x1f, 0x63, 0xf5, 0xea,
	0x08, 0x50, 0x4a, 0xb0, 0xda, 0x34, 0xa4, 0xa1, 0x32, 0x2c, 0x09, 0x4b, 0xbe, 0xeb, 0x62, 0x56,
	0x3c, 0xe1, 0x7a, 0x53, 0x21, 0x70, 0x33, 0x34, 0x25, 0x68, 0xec, 0xb2, 0xb8, 0x3d, 0x4c, 0x25,
	0xd0, 0xe6, 0x73, 0xe2, 0xc2, 0xc4, 0xcb, 0x32, 0x8e, 0xc8, 0xd9, 0x65, 0x71, 0xc3, 0x54, 0x76,
	0xe0, 0xad, 0x00, 0x9c, 0xe3, 0x53, 0x8e, 0xce, 0xb5, 0xc5, 0x89, 0x07, 0x1e, 0x87, 0xe3, 0xd9,
	0x81, 0xb7, 0xa2, 0x74, 0x54, 0x83, 0x65, 0x51, 0x23, 0xa8, 0xc4, 0xe5, 0xda, 0xd2, 0x44, 0x2f,
	0xc7, 0xf1, 0x3b, 0xf3, 0xb2, 0x13, 0xa6, 0x32, 0x2f, 0x1d, 0xd7, 0x22, 0xb8, 0x3f, 0x7a, 0xf8,
	0xd2, 0x96, 0x27, 0x7a, 0x19, 0xf7, 0x44, 0xc6, 0xbc, 0x74, 0xa2, 0x74, 0x86, 0xc2, 0x3c, 0xe2,
	0x58, 0xda, 0x0a, 0xb7, 0xf4, 0x7a, 0x8c, 0xa5, 0x21, 0x4a, 0x2f, 0x25, 0x0c, 0x2e, 0x2b, 0x8a,
	0xcb, 0xa9, 0x8f, 0xdb, 0x0c, 0x09, 0x63, 0x4b, 0x40, 0x61, 0x4d, 0xbd, 0xa6, 0xb8, 0xc4, 0xa0,
	0x66, 0x51, 0x5c, 0xa2, 0x0c, 0x96, 0xcb, 0x01, 0x8c, 0x6d, 0x0d, 0x41, 0xb4, 0x76, 0x63, 0x62,
	0x2e, 0xc7, 0x03, 0x6e, 0x96, 0xcb, 0xf4, 0x2a, 0x87, 0xd7, 0x58, 0x69, 0x3b, 0xc8, 0x41, 0x34,
	0xb9, 0xc6, 0x8e, 0x41, 0x6c, 0x5e, 0x63, 0xc3, 0x54, 0x76, 0x20, 0x66, 0x30, 0x88, 0x60, 0xca,
	0x27, 0x11, 0x6d, 0x7d, 0xe2, 0x81, 0xc4, 0xcd, 0x2c, 0xec, 0x40, 0xcc, 0x28, 0x9d, 0xb9, 0x29,
	0xe0, 0xf6, 0xa8, 0x15, 0xdc, 0x99, 0xe8, 0xe6, 0x38, 0x5c, 0x67, 0x6e, 0x7a, 0x61, 0x2a, 0xfa,
	0xb5, 0x02, 0x6f, 0x8c, 0x55, 0x1e, 0x5e, 0xbd, 0x31, 0x7f, 0x89, 0xc6, 0x54, 0xe0, 0x66, 0xed,
	0x75, 0xbe, 0xcc, 0x4f, 0xa6, 0x28, 0x46, 0xb1, 0x90, 0xbb, 0x94, 0x30, 0x36, 0xfd, 0x57, 0x08,
	0xb2, 0x98, 0xd9, 0x02, 0x84, 0x62, 0x57, 0xa2, 0x50, 0x6d, 0x63, 0x62, 0xcc, 0xe2, 0xf0, 0x2a,
	0x8b, 0x99, 0x1d, 0xa5, 0xb3, 0x86, 0xd0, 0x1f, 0x3d, 0xfa, 0x62, 0x39, 0xa6, 0x6a, 0x9b, 0x13,
	0x1b, 0xc2, 0x84, 0x27, 0x62, 0xd6, 0x10, 0xfa, 0x63, 0x2c, 0x74, 0x00, 0x4b, 0x5d, 0x06, 0x53,
	0xb1, 0x27, 0x70, 0xaa, 0x76, 0x6f, 0xe2, 0x6b, 0xfa, 0x18, 0x9c, 0x2d, 0x25, 0x8c, 0xc5, 0x6e,
	0x88, 0x88, 0x3e, 0x05, 0x75, 0xf8, 0xe8, 0x80, 0x4f, 0x38, 0x3e, 0xd5, 0xb6, 0xb8, 0xbd, 0xed,
	0x18, 0x7b, 0xd7, 0xc0, 0x59, 0xde, 0x64, 0xa2, 0x1c, 0x74, 0x01, 0x77, 0xd9, 0x74, 0x63, 0x8a,
	0x99, 0x01, 0x93, 0xd1, 0xd0, 0x20, 0x47, 0x84, 0xfb, 0x7c, 0xa5, 0xc7, 0x71, 0x67, 0x7c, 0xfd,
	0xa8, 0x51, 0x4a, 0x18, 0xeb, 0xfe, 0x44, 0x11, 0x56, 0xec, 0x44, 0x8b, 0x60, 0x60, 0x83, 0xe1,
	0x59, 0xed, 0x8d, 0x89, 0x49, 0x3b, 0x8e, 0x7b, 0x59, 0xd2, 0xda, 0x61, 0x2a, 0x3a, 0x82, 0x1b,
	0x5d, 0x86, 0x54, 0xb1, 0xed, 0xb0, 0x2c, 0xe5, 0x58, 0x55, 0x7b, 0x30, 0x31, 0x51, 0xe2, 0x50,
	0x2d, 0x8b, 0x4f, 0x37, 0x4a, 0x47, 0x1f, 0x4a, 0x9c, 0x75, 0x4a, 0x78, 0x9a, 0xb0, 0x16, 0xfc,
	0xe6, 0x44, 0xe8, 0x16, 0x83, 0x69, 0x19, 0x74, 0x1b, 0x1a, 0xe0, 0x64, 0x01, 0x12, 0xf3, 0x69,
	0x98, 0xe5, 0x43, 0xcf, 0x7e, 0x2a, 0xb3, 0xa6, 0xde, 0xda, 0x4f, 0x65, 0x6e, 0xab, 0xeb, 0xfb,
	0xa9, 0xcc, 0x5d, 0x35, 0xbb, 0x9f, 0xca, 0x64, 0xd5, 0x8d, 0xad, 0x1d, 0x0e, 0x22, 0x0f, 0x5d,
	0x8f, 0xb7, 0x08, 0xb4, 0x0e, 0xb3, 0xb6, 0x63, 0x91, 0x81, 0x1c, 0xd5, 0x05, 0x46, 0x16, 0x24,
	0x09, 0x3b, 0xbf, 0x9a, 0x81, 0xd9, 0xe9, 0x1e, 0x36, 0x7e, 0x16, 0x85, 0x43, 0x94, 0xf0, 0x7f,
	0x19, 0x70, 0xb0, 0xb7, 0x1c, 0x7b, 0x00, 0x91, 0xeb, 0xcc, 0x85, 0x83, 0xa7, 0x61, 0x7f, 0x8c,
	0x83, 0x0a, 0xb0, 0xd4, 0x77, 0xc8, 0xa0, 0xe7, 0x7a, 0xc4, 0xe2, 0xbd, 0x36, 0x35, 0xcd, 0x54,
	0x6b, 0x2c, 0x0e, 0x95, 0x58, 0x87, 0xdd, 0x81, 0x05, 0x97, 0xda, 0x6d, 0xdb, 0xc1, 0xac, 0xff,
	0x70, 0xa4, 0x36, 0x9b, 0x5f, 0x66, 0x6b, 0x7e, 0xfb, 0x62, 0x63, 0x8e, 0xf5, 0xaa, 0x72, 0xd1,
	0x00, 0x21, 0xc2, 0xbe, 0xd0, 0xfb, 0x30, 0x67, 0x71, 0xb8, 0x2d, 0x91, 0x57, 0x76, 0xd2, 0x0c,
	0x28, 0x40, 0x79, 0x30, 0x64, 0x08, 0x1d, 0xf4, 0xa3, 0x20, 0xba, 0xe9, 0xeb, 0x94, 0x83, 0xc3,
	0x90, 0x71, 0x47, 0x4f, 0x60, 0xc6, 0x71, 0x2f, 0x24, 0x72, 0x9a, 0x6a, 0xaa, 0x63, 0xf2, 0x4f,
	0x33, 0xbf, 0xff, 0x62, 0x23, 0x31, 0x7a, 0x9f, 0x7a, 0xf4, 0xef, 0x24, 0x68, 0x93, 0x9e, 0xc2,
	0xd9, 0xb0, 0x91, 0xcb, 0xd7, 0x8d, 0x26, 0x1e, 0x7b, 0x80, 0x7d, 0x00, 0xf7, 0x22, 0x1c, 0xfe,
	0xa1, 0x17, 0xb1, 0xa1, 0x17, 0xea, 0x46, 0x71, 0xf8, 0x1a, 0xfb, 0x16, 0xdc, 0x8f, 0x88, 0xd5,
	0xf4, 0x63, 0xfe, 0x2e, 0x2b, 0xc5, 0x9a, 0xf5, 0x3a, 0xae, 0x57, 0xd8, 0x40, 0x94, 0x85, 0xf5,
	0x88, 0x60, 0xa1, 0x52, 0xd6, 0x6b, 0xec, 0x6b, 0x5f, 0x2f, 0xb0, 0xb1, 0x68, 0x03, 0xee, 0x44,
	0xf8, 0x87, 0x47, 0x8d, 0x92, 0x6e, 0x04, 0xcb, 0xaa, 0x29, 0x74, 0x07, 0x6e, 0x8d, 0x3b, 0x84,
	0x1b, 0x87, 0xb9, 0x9a, 0x3a, 0x8b, 0x72, 0xf0, 0x41, 0x94, 0x59, 0x31, 0xf4, 0x5c, 0xf1, 0xd9,
	0xe8, 0x79, 0x18, 0xd7, 0x0d, 0x6c, 0xd4, 0x2b, 0x15, 0xbd, 0x88, 0xf3, 0xb9, 0xc2, 0x01, 0x3e,
	0xac, 0x37, 0x1a, 0xe5, 0x7c, 0x45, 0xe7, 0xb3, 0x5e, 0xee, 0x99, 0x3a, 0x87, 0xde, 0x83, 0x27,
	0x11, 0x13, 0xcd, 0x72, 0x55, 0x6f, 0x34, 0x73, 0xd5, 0x43, 0x5c, 0xc8, 0x15, 0x4a, 0xba, 0xf4,
	0x54, 0x2f, 0x8e, 0xa9, 0xa6, 0xd7, 0x53, 0x9f, 0xff, 0x31, 0x9b, 0x78, 0xf4, 0xd7, 0xe8, 0x9b,
	0x7a, 0xe8, 0x95, 0x5e, 0xcc, 0x74, 0x4d, 0xe3, 0xd9, 0x78, 0x98, 0xf9, 0x00, 0xc9, 0x38, 0xc7,
	0x46, 0xb9, 0xa9, 0x0f, 0xe3, 0xa5, 0x88, 0x89, 0x93, 0x31, 0x1a, 0xba, 0x51, 0xce, 0x55, 0xca,
	0x9f, 0xe4, 0xf2, 0x15, 0x5d, 0x9d, 0x41, 0xb7, 0xe1, 0x35, 0x41, 0xbf, 0xea, 0x46, 0x0a, 0xdd,
	0x85, 0xdb, 0x82, 0x95, 0x6b, 0x3c, 0xab, 0x15, 0xa4, 0xc5, 0xdd, 0x5c, 0xb9, 0x72, 0x64, 0xe8,
	0xea, 0x2c, 0xda, 0x82, 0xac, 0x60, 0x8b, 0xa0, 0xe0, 0xa2, 0x9e, 0x2b, 0x56, 0xca, 0x35, 0x1d,
	0xeb, 0x1f, 0x17, 0x74, 0xbd, 0xa8, 0x17, 0xd5, 0x39, 0xb1, 0x93, 0x2d, 0x96, 0x38, 0xc9, 0x47,
	0x4f, 0x01, 0x8d, 0xdf, 0x4c, 0x94, 0x81, 0x54, 0xad, 0x5e, 0xd3, 0xd5, 0x04, 0x5a, 0x80, 0x34,
	0x0b, 0x65, 0x7d, 0x77, 0x57, 0x55, 0xd0, 0x12, 0xcc, 0x97, 0xab, 0x55, 0xbd, 0x58, 0xce, 0x35,
	0x75, 0x35, 0x99, 0xbf, 0xf7, 0xf5, 0x3f, 0xb3, 0x89, 0xaf, 0x5f, 0x66, 0x95, 0xbf, 0xbd, 0xcc,
	0x2a, 0xdf, 0xbc, 0xcc, 0x2a, 0xff, 0x78, 0x99, 0x55, 0x7e, 0xf3, 0xaf, 0x6c, 0xe2, 0x93, 0xb4,
	0xcc, 0xf8, 0xff, 0x07, 0x00, 0x00, 0xff, 0xff, 0x85, 0x13, 0x03, 0xac, 0x1b, 0x1f, 0x00, 0x00,
}
