// Code generated by execgen; DO NOT EDIT.

package exec

import (
	"bytes"

	"github.com/cockroachdb/apd"
	"github.com/cockroachdb/cockroach/pkg/sql/exec/coldata"
	"github.com/cockroachdb/cockroach/pkg/sql/exec/types"
	"github.com/cockroachdb/cockroach/pkg/sql/exec/types/conv"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/sqlbase"
	"github.com/pkg/errors"
)

type selEQBoolBoolConstOp struct {
	input Operator

	colIdx   int
	constArg bool
}

func (p *selEQBoolBoolConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQBoolBoolConstOp) Init() {
	p.input.Init()
}

type selEQBoolBoolOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selEQBoolBoolOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Bool()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Bool()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQBoolBoolOp) Init() {
	p.input.Init()
}

type selNEBoolBoolConstOp struct {
	input Operator

	colIdx   int
	constArg bool
}

func (p *selNEBoolBoolConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEBoolBoolConstOp) Init() {
	p.input.Init()
}

type selNEBoolBoolOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selNEBoolBoolOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Bool()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Bool()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEBoolBoolOp) Init() {
	p.input.Init()
}

type selLTBoolBoolConstOp struct {
	input Operator

	colIdx   int
	constArg bool
}

func (p *selLTBoolBoolConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareBools(coldata[i], p.constArg) < 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareBools(coldata[i], p.constArg) < 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTBoolBoolConstOp) Init() {
	p.input.Init()
}

type selLTBoolBoolOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLTBoolBoolOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Bool()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Bool()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareBools(col1[i], col2[i]) < 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareBools(col1[i], col2[i]) < 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTBoolBoolOp) Init() {
	p.input.Init()
}

type selLEBoolBoolConstOp struct {
	input Operator

	colIdx   int
	constArg bool
}

func (p *selLEBoolBoolConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareBools(coldata[i], p.constArg) <= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareBools(coldata[i], p.constArg) <= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEBoolBoolConstOp) Init() {
	p.input.Init()
}

type selLEBoolBoolOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLEBoolBoolOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Bool()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Bool()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareBools(col1[i], col2[i]) <= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareBools(col1[i], col2[i]) <= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEBoolBoolOp) Init() {
	p.input.Init()
}

type selGTBoolBoolConstOp struct {
	input Operator

	colIdx   int
	constArg bool
}

func (p *selGTBoolBoolConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareBools(coldata[i], p.constArg) > 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareBools(coldata[i], p.constArg) > 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTBoolBoolConstOp) Init() {
	p.input.Init()
}

type selGTBoolBoolOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGTBoolBoolOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Bool()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Bool()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareBools(col1[i], col2[i]) > 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareBools(col1[i], col2[i]) > 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTBoolBoolOp) Init() {
	p.input.Init()
}

type selGEBoolBoolConstOp struct {
	input Operator

	colIdx   int
	constArg bool
}

func (p *selGEBoolBoolConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareBools(coldata[i], p.constArg) >= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareBools(coldata[i], p.constArg) >= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEBoolBoolConstOp) Init() {
	p.input.Init()
}

type selGEBoolBoolOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGEBoolBoolOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Bool()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Bool()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareBools(col1[i], col2[i]) >= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareBools(col1[i], col2[i]) >= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEBoolBoolOp) Init() {
	p.input.Init()
}

type selEQBytesBytesConstOp struct {
	input Operator

	colIdx   int
	constArg []byte
}

func (p *selEQBytesBytesConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = bytes.Equal(coldata[i], p.constArg)
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = bytes.Equal(coldata[i], p.constArg)
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQBytesBytesConstOp) Init() {
	p.input.Init()
}

type selEQBytesBytesOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selEQBytesBytesOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Bytes()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Bytes()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = bytes.Equal(col1[i], col2[i])
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = bytes.Equal(col1[i], col2[i])
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQBytesBytesOp) Init() {
	p.input.Init()
}

type selNEBytesBytesConstOp struct {
	input Operator

	colIdx   int
	constArg []byte
}

func (p *selNEBytesBytesConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = !bytes.Equal(coldata[i], p.constArg)
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = !bytes.Equal(coldata[i], p.constArg)
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEBytesBytesConstOp) Init() {
	p.input.Init()
}

type selNEBytesBytesOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selNEBytesBytesOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Bytes()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Bytes()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = !bytes.Equal(col1[i], col2[i])
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = !bytes.Equal(col1[i], col2[i])
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEBytesBytesOp) Init() {
	p.input.Init()
}

type selLTBytesBytesConstOp struct {
	input Operator

	colIdx   int
	constArg []byte
}

func (p *selLTBytesBytesConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = bytes.Compare(coldata[i], p.constArg) < 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = bytes.Compare(coldata[i], p.constArg) < 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTBytesBytesConstOp) Init() {
	p.input.Init()
}

type selLTBytesBytesOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLTBytesBytesOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Bytes()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Bytes()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = bytes.Compare(col1[i], col2[i]) < 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = bytes.Compare(col1[i], col2[i]) < 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTBytesBytesOp) Init() {
	p.input.Init()
}

type selLEBytesBytesConstOp struct {
	input Operator

	colIdx   int
	constArg []byte
}

func (p *selLEBytesBytesConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = bytes.Compare(coldata[i], p.constArg) <= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = bytes.Compare(coldata[i], p.constArg) <= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEBytesBytesConstOp) Init() {
	p.input.Init()
}

type selLEBytesBytesOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLEBytesBytesOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Bytes()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Bytes()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = bytes.Compare(col1[i], col2[i]) <= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = bytes.Compare(col1[i], col2[i]) <= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEBytesBytesOp) Init() {
	p.input.Init()
}

type selGTBytesBytesConstOp struct {
	input Operator

	colIdx   int
	constArg []byte
}

func (p *selGTBytesBytesConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = bytes.Compare(coldata[i], p.constArg) > 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = bytes.Compare(coldata[i], p.constArg) > 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTBytesBytesConstOp) Init() {
	p.input.Init()
}

type selGTBytesBytesOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGTBytesBytesOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Bytes()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Bytes()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = bytes.Compare(col1[i], col2[i]) > 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = bytes.Compare(col1[i], col2[i]) > 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTBytesBytesOp) Init() {
	p.input.Init()
}

type selGEBytesBytesConstOp struct {
	input Operator

	colIdx   int
	constArg []byte
}

func (p *selGEBytesBytesConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = bytes.Compare(coldata[i], p.constArg) >= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = bytes.Compare(coldata[i], p.constArg) >= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEBytesBytesConstOp) Init() {
	p.input.Init()
}

type selGEBytesBytesOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGEBytesBytesOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Bytes()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Bytes()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = bytes.Compare(col1[i], col2[i]) >= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = bytes.Compare(col1[i], col2[i]) >= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEBytesBytesOp) Init() {
	p.input.Init()
}

type selEQDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal
}

func (p *selEQDecimalDecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareDecimals(&coldata[i], &p.constArg) == 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareDecimals(&coldata[i], &p.constArg) == 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type selEQDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selEQDecimalDecimalOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareDecimals(&col1[i], &col2[i]) == 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareDecimals(&col1[i], &col2[i]) == 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQDecimalDecimalOp) Init() {
	p.input.Init()
}

type selNEDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal
}

func (p *selNEDecimalDecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareDecimals(&coldata[i], &p.constArg) != 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareDecimals(&coldata[i], &p.constArg) != 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type selNEDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selNEDecimalDecimalOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareDecimals(&col1[i], &col2[i]) != 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareDecimals(&col1[i], &col2[i]) != 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEDecimalDecimalOp) Init() {
	p.input.Init()
}

type selLTDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal
}

func (p *selLTDecimalDecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareDecimals(&coldata[i], &p.constArg) < 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareDecimals(&coldata[i], &p.constArg) < 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type selLTDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLTDecimalDecimalOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareDecimals(&col1[i], &col2[i]) < 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareDecimals(&col1[i], &col2[i]) < 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTDecimalDecimalOp) Init() {
	p.input.Init()
}

type selLEDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal
}

func (p *selLEDecimalDecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareDecimals(&coldata[i], &p.constArg) <= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareDecimals(&coldata[i], &p.constArg) <= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type selLEDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLEDecimalDecimalOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareDecimals(&col1[i], &col2[i]) <= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareDecimals(&col1[i], &col2[i]) <= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEDecimalDecimalOp) Init() {
	p.input.Init()
}

type selGTDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal
}

func (p *selGTDecimalDecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareDecimals(&coldata[i], &p.constArg) > 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareDecimals(&coldata[i], &p.constArg) > 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type selGTDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGTDecimalDecimalOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareDecimals(&col1[i], &col2[i]) > 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareDecimals(&col1[i], &col2[i]) > 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTDecimalDecimalOp) Init() {
	p.input.Init()
}

type selGEDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal
}

func (p *selGEDecimalDecimalConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareDecimals(&coldata[i], &p.constArg) >= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareDecimals(&coldata[i], &p.constArg) >= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type selGEDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGEDecimalDecimalOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = tree.CompareDecimals(&col1[i], &col2[i]) >= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = tree.CompareDecimals(&col1[i], &col2[i]) >= 0
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEDecimalDecimalOp) Init() {
	p.input.Init()
}

type selEQInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8
}

func (p *selEQInt8Int8ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQInt8Int8ConstOp) Init() {
	p.input.Init()
}

type selEQInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selEQInt8Int8Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQInt8Int8Op) Init() {
	p.input.Init()
}

type selNEInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8
}

func (p *selNEInt8Int8ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEInt8Int8ConstOp) Init() {
	p.input.Init()
}

type selNEInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selNEInt8Int8Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEInt8Int8Op) Init() {
	p.input.Init()
}

type selLTInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8
}

func (p *selLTInt8Int8ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] < p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] < p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTInt8Int8ConstOp) Init() {
	p.input.Init()
}

type selLTInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLTInt8Int8Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] < col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] < col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTInt8Int8Op) Init() {
	p.input.Init()
}

type selLEInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8
}

func (p *selLEInt8Int8ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] <= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] <= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEInt8Int8ConstOp) Init() {
	p.input.Init()
}

type selLEInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLEInt8Int8Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] <= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] <= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEInt8Int8Op) Init() {
	p.input.Init()
}

type selGTInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8
}

func (p *selGTInt8Int8ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] > p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] > p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTInt8Int8ConstOp) Init() {
	p.input.Init()
}

type selGTInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGTInt8Int8Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] > col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] > col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTInt8Int8Op) Init() {
	p.input.Init()
}

type selGEInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8
}

func (p *selGEInt8Int8ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] >= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] >= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEInt8Int8ConstOp) Init() {
	p.input.Init()
}

type selGEInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGEInt8Int8Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] >= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] >= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEInt8Int8Op) Init() {
	p.input.Init()
}

type selEQInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16
}

func (p *selEQInt16Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQInt16Int16ConstOp) Init() {
	p.input.Init()
}

type selEQInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selEQInt16Int16Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQInt16Int16Op) Init() {
	p.input.Init()
}

type selNEInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16
}

func (p *selNEInt16Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEInt16Int16ConstOp) Init() {
	p.input.Init()
}

type selNEInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selNEInt16Int16Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEInt16Int16Op) Init() {
	p.input.Init()
}

type selLTInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16
}

func (p *selLTInt16Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] < p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] < p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTInt16Int16ConstOp) Init() {
	p.input.Init()
}

type selLTInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLTInt16Int16Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] < col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] < col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTInt16Int16Op) Init() {
	p.input.Init()
}

type selLEInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16
}

func (p *selLEInt16Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] <= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] <= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEInt16Int16ConstOp) Init() {
	p.input.Init()
}

type selLEInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLEInt16Int16Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] <= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] <= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEInt16Int16Op) Init() {
	p.input.Init()
}

type selGTInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16
}

func (p *selGTInt16Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] > p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] > p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTInt16Int16ConstOp) Init() {
	p.input.Init()
}

type selGTInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGTInt16Int16Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] > col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] > col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTInt16Int16Op) Init() {
	p.input.Init()
}

type selGEInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16
}

func (p *selGEInt16Int16ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] >= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] >= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEInt16Int16ConstOp) Init() {
	p.input.Init()
}

type selGEInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGEInt16Int16Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] >= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] >= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEInt16Int16Op) Init() {
	p.input.Init()
}

type selEQInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32
}

func (p *selEQInt32Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQInt32Int32ConstOp) Init() {
	p.input.Init()
}

type selEQInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selEQInt32Int32Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQInt32Int32Op) Init() {
	p.input.Init()
}

type selNEInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32
}

func (p *selNEInt32Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEInt32Int32ConstOp) Init() {
	p.input.Init()
}

type selNEInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selNEInt32Int32Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEInt32Int32Op) Init() {
	p.input.Init()
}

type selLTInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32
}

func (p *selLTInt32Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] < p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] < p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTInt32Int32ConstOp) Init() {
	p.input.Init()
}

type selLTInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLTInt32Int32Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] < col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] < col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTInt32Int32Op) Init() {
	p.input.Init()
}

type selLEInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32
}

func (p *selLEInt32Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] <= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] <= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEInt32Int32ConstOp) Init() {
	p.input.Init()
}

type selLEInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLEInt32Int32Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] <= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] <= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEInt32Int32Op) Init() {
	p.input.Init()
}

type selGTInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32
}

func (p *selGTInt32Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] > p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] > p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTInt32Int32ConstOp) Init() {
	p.input.Init()
}

type selGTInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGTInt32Int32Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] > col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] > col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTInt32Int32Op) Init() {
	p.input.Init()
}

type selGEInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32
}

func (p *selGEInt32Int32ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] >= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] >= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEInt32Int32ConstOp) Init() {
	p.input.Init()
}

type selGEInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGEInt32Int32Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] >= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] >= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEInt32Int32Op) Init() {
	p.input.Init()
}

type selEQInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64
}

func (p *selEQInt64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQInt64Int64ConstOp) Init() {
	p.input.Init()
}

type selEQInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selEQInt64Int64Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQInt64Int64Op) Init() {
	p.input.Init()
}

type selNEInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64
}

func (p *selNEInt64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEInt64Int64ConstOp) Init() {
	p.input.Init()
}

type selNEInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selNEInt64Int64Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEInt64Int64Op) Init() {
	p.input.Init()
}

type selLTInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64
}

func (p *selLTInt64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] < p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] < p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTInt64Int64ConstOp) Init() {
	p.input.Init()
}

type selLTInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLTInt64Int64Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] < col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] < col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTInt64Int64Op) Init() {
	p.input.Init()
}

type selLEInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64
}

func (p *selLEInt64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] <= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] <= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEInt64Int64ConstOp) Init() {
	p.input.Init()
}

type selLEInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLEInt64Int64Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] <= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] <= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEInt64Int64Op) Init() {
	p.input.Init()
}

type selGTInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64
}

func (p *selGTInt64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] > p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] > p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTInt64Int64ConstOp) Init() {
	p.input.Init()
}

type selGTInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGTInt64Int64Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] > col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] > col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTInt64Int64Op) Init() {
	p.input.Init()
}

type selGEInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64
}

func (p *selGEInt64Int64ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] >= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] >= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEInt64Int64ConstOp) Init() {
	p.input.Init()
}

type selGEInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGEInt64Int64Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] >= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] >= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEInt64Int64Op) Init() {
	p.input.Init()
}

type selEQFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32
}

func (p *selEQFloat32Float32ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type selEQFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selEQFloat32Float32Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQFloat32Float32Op) Init() {
	p.input.Init()
}

type selNEFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32
}

func (p *selNEFloat32Float32ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type selNEFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selNEFloat32Float32Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEFloat32Float32Op) Init() {
	p.input.Init()
}

type selLTFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32
}

func (p *selLTFloat32Float32ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] < p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] < p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type selLTFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLTFloat32Float32Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] < col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] < col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTFloat32Float32Op) Init() {
	p.input.Init()
}

type selLEFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32
}

func (p *selLEFloat32Float32ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] <= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] <= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type selLEFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLEFloat32Float32Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] <= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] <= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEFloat32Float32Op) Init() {
	p.input.Init()
}

type selGTFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32
}

func (p *selGTFloat32Float32ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] > p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] > p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type selGTFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGTFloat32Float32Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] > col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] > col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTFloat32Float32Op) Init() {
	p.input.Init()
}

type selGEFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32
}

func (p *selGEFloat32Float32ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] >= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] >= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type selGEFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGEFloat32Float32Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] >= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] >= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEFloat32Float32Op) Init() {
	p.input.Init()
}

type selEQFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64
}

func (p *selEQFloat64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] == p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type selEQFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selEQFloat64Float64Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] == col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selEQFloat64Float64Op) Init() {
	p.input.Init()
}

type selNEFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64
}

func (p *selNEFloat64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] != p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type selNEFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selNEFloat64Float64Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] != col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selNEFloat64Float64Op) Init() {
	p.input.Init()
}

type selLTFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64
}

func (p *selLTFloat64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] < p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] < p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type selLTFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLTFloat64Float64Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] < col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] < col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLTFloat64Float64Op) Init() {
	p.input.Init()
}

type selLEFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64
}

func (p *selLEFloat64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] <= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] <= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type selLEFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selLEFloat64Float64Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] <= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] <= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selLEFloat64Float64Op) Init() {
	p.input.Init()
}

type selGTFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64
}

func (p *selGTFloat64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] > p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] > p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type selGTFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGTFloat64Float64Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] > col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] > col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGTFloat64Float64Op) Init() {
	p.input.Init()
}

type selGEFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64
}

func (p *selGEFloat64Float64ConstOp) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
		var idx uint16
		n := batch.Length()
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = coldata[i] >= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = coldata[i] >= p.constArg
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type selGEFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int
}

func (p *selGEFloat64Float64Op) Next() coldata.Batch {
	for {
		batch := p.input.Next()
		if batch.Length() == 0 {
			return batch
		}

		col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
		col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
		n := batch.Length()

		var idx uint16
		if sel := batch.Selection(); sel != nil {
			sel := sel[:n]
			for _, i := range sel {
				var cmp bool
				cmp = col1[i] >= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		} else {
			batch.SetSelection(true)
			sel := batch.Selection()
			for i := uint16(0); i < n; i++ {
				var cmp bool
				cmp = col1[i] >= col2[i]
				if cmp {
					sel[idx] = i
					idx++
				}
			}
		}
		if idx > 0 {
			batch.SetLength(idx)
			return batch
		}
	}
}

func (p selGEFloat64Float64Op) Init() {
	p.input.Init()
}

// GetSelectionConstOperator returns the appropriate constant selection operator
// for the given column type and comparison.
func GetSelectionConstOperator(
	ct sqlbase.ColumnType,
	cmpOp tree.ComparisonOperator,
	input Operator,
	colIdx int,
	constArg tree.Datum,
) (Operator, error) {
	c, err := conv.GetDatumToPhysicalFn(ct)(constArg)
	if err != nil {
		return nil, err
	}
	switch t := conv.FromColumnType(ct); t {

	case types.Bool:
		switch cmpOp {

		case tree.EQ:
			return &selEQBoolBoolConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(bool),
			}, nil

		case tree.NE:
			return &selNEBoolBoolConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(bool),
			}, nil

		case tree.LT:
			return &selLTBoolBoolConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(bool),
			}, nil

		case tree.LE:
			return &selLEBoolBoolConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(bool),
			}, nil

		case tree.GT:
			return &selGTBoolBoolConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(bool),
			}, nil

		case tree.GE:
			return &selGEBoolBoolConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(bool),
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Bytes:
		switch cmpOp {

		case tree.EQ:
			return &selEQBytesBytesConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.([]byte),
			}, nil

		case tree.NE:
			return &selNEBytesBytesConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.([]byte),
			}, nil

		case tree.LT:
			return &selLTBytesBytesConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.([]byte),
			}, nil

		case tree.LE:
			return &selLEBytesBytesConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.([]byte),
			}, nil

		case tree.GT:
			return &selGTBytesBytesConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.([]byte),
			}, nil

		case tree.GE:
			return &selGEBytesBytesConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.([]byte),
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Decimal:
		switch cmpOp {

		case tree.EQ:
			return &selEQDecimalDecimalConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(apd.Decimal),
			}, nil

		case tree.NE:
			return &selNEDecimalDecimalConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(apd.Decimal),
			}, nil

		case tree.LT:
			return &selLTDecimalDecimalConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(apd.Decimal),
			}, nil

		case tree.LE:
			return &selLEDecimalDecimalConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(apd.Decimal),
			}, nil

		case tree.GT:
			return &selGTDecimalDecimalConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(apd.Decimal),
			}, nil

		case tree.GE:
			return &selGEDecimalDecimalConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(apd.Decimal),
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Int8:
		switch cmpOp {

		case tree.EQ:
			return &selEQInt8Int8ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int8),
			}, nil

		case tree.NE:
			return &selNEInt8Int8ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int8),
			}, nil

		case tree.LT:
			return &selLTInt8Int8ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int8),
			}, nil

		case tree.LE:
			return &selLEInt8Int8ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int8),
			}, nil

		case tree.GT:
			return &selGTInt8Int8ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int8),
			}, nil

		case tree.GE:
			return &selGEInt8Int8ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int8),
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Int16:
		switch cmpOp {

		case tree.EQ:
			return &selEQInt16Int16ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int16),
			}, nil

		case tree.NE:
			return &selNEInt16Int16ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int16),
			}, nil

		case tree.LT:
			return &selLTInt16Int16ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int16),
			}, nil

		case tree.LE:
			return &selLEInt16Int16ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int16),
			}, nil

		case tree.GT:
			return &selGTInt16Int16ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int16),
			}, nil

		case tree.GE:
			return &selGEInt16Int16ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int16),
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Int32:
		switch cmpOp {

		case tree.EQ:
			return &selEQInt32Int32ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int32),
			}, nil

		case tree.NE:
			return &selNEInt32Int32ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int32),
			}, nil

		case tree.LT:
			return &selLTInt32Int32ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int32),
			}, nil

		case tree.LE:
			return &selLEInt32Int32ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int32),
			}, nil

		case tree.GT:
			return &selGTInt32Int32ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int32),
			}, nil

		case tree.GE:
			return &selGEInt32Int32ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int32),
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Int64:
		switch cmpOp {

		case tree.EQ:
			return &selEQInt64Int64ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int64),
			}, nil

		case tree.NE:
			return &selNEInt64Int64ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int64),
			}, nil

		case tree.LT:
			return &selLTInt64Int64ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int64),
			}, nil

		case tree.LE:
			return &selLEInt64Int64ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int64),
			}, nil

		case tree.GT:
			return &selGTInt64Int64ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int64),
			}, nil

		case tree.GE:
			return &selGEInt64Int64ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(int64),
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Float32:
		switch cmpOp {

		case tree.EQ:
			return &selEQFloat32Float32ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(float32),
			}, nil

		case tree.NE:
			return &selNEFloat32Float32ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(float32),
			}, nil

		case tree.LT:
			return &selLTFloat32Float32ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(float32),
			}, nil

		case tree.LE:
			return &selLEFloat32Float32ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(float32),
			}, nil

		case tree.GT:
			return &selGTFloat32Float32ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(float32),
			}, nil

		case tree.GE:
			return &selGEFloat32Float32ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(float32),
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Float64:
		switch cmpOp {

		case tree.EQ:
			return &selEQFloat64Float64ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(float64),
			}, nil

		case tree.NE:
			return &selNEFloat64Float64ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(float64),
			}, nil

		case tree.LT:
			return &selLTFloat64Float64ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(float64),
			}, nil

		case tree.LE:
			return &selLEFloat64Float64ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(float64),
			}, nil

		case tree.GT:
			return &selGTFloat64Float64ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(float64),
			}, nil

		case tree.GE:
			return &selGEFloat64Float64ConstOp{
				input:    input,
				colIdx:   colIdx,
				constArg: c.(float64),
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	default:
		return nil, errors.Errorf("unhandled type: %s", t)
	}
}

// GetSelectionOperator returns the appropriate two column selection operator
// for the given column type and comparison.
func GetSelectionOperator(
	ct sqlbase.ColumnType,
	cmpOp tree.ComparisonOperator,
	input Operator,
	col1Idx int,
	col2Idx int,
) (Operator, error) {
	switch t := conv.FromColumnType(ct); t {

	case types.Bool:
		switch cmpOp {

		case tree.EQ:
			return &selEQBoolBoolOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.NE:
			return &selNEBoolBoolOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LT:
			return &selLTBoolBoolOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LE:
			return &selLEBoolBoolOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GT:
			return &selGTBoolBoolOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GE:
			return &selGEBoolBoolOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Bytes:
		switch cmpOp {

		case tree.EQ:
			return &selEQBytesBytesOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.NE:
			return &selNEBytesBytesOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LT:
			return &selLTBytesBytesOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LE:
			return &selLEBytesBytesOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GT:
			return &selGTBytesBytesOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GE:
			return &selGEBytesBytesOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Decimal:
		switch cmpOp {

		case tree.EQ:
			return &selEQDecimalDecimalOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.NE:
			return &selNEDecimalDecimalOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LT:
			return &selLTDecimalDecimalOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LE:
			return &selLEDecimalDecimalOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GT:
			return &selGTDecimalDecimalOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GE:
			return &selGEDecimalDecimalOp{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Int8:
		switch cmpOp {

		case tree.EQ:
			return &selEQInt8Int8Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.NE:
			return &selNEInt8Int8Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LT:
			return &selLTInt8Int8Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LE:
			return &selLEInt8Int8Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GT:
			return &selGTInt8Int8Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GE:
			return &selGEInt8Int8Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Int16:
		switch cmpOp {

		case tree.EQ:
			return &selEQInt16Int16Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.NE:
			return &selNEInt16Int16Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LT:
			return &selLTInt16Int16Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LE:
			return &selLEInt16Int16Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GT:
			return &selGTInt16Int16Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GE:
			return &selGEInt16Int16Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Int32:
		switch cmpOp {

		case tree.EQ:
			return &selEQInt32Int32Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.NE:
			return &selNEInt32Int32Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LT:
			return &selLTInt32Int32Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LE:
			return &selLEInt32Int32Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GT:
			return &selGTInt32Int32Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GE:
			return &selGEInt32Int32Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Int64:
		switch cmpOp {

		case tree.EQ:
			return &selEQInt64Int64Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.NE:
			return &selNEInt64Int64Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LT:
			return &selLTInt64Int64Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LE:
			return &selLEInt64Int64Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GT:
			return &selGTInt64Int64Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GE:
			return &selGEInt64Int64Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Float32:
		switch cmpOp {

		case tree.EQ:
			return &selEQFloat32Float32Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.NE:
			return &selNEFloat32Float32Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LT:
			return &selLTFloat32Float32Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LE:
			return &selLEFloat32Float32Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GT:
			return &selGTFloat32Float32Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GE:
			return &selGEFloat32Float32Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	case types.Float64:
		switch cmpOp {

		case tree.EQ:
			return &selEQFloat64Float64Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.NE:
			return &selNEFloat64Float64Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LT:
			return &selLTFloat64Float64Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.LE:
			return &selLEFloat64Float64Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GT:
			return &selGTFloat64Float64Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		case tree.GE:
			return &selGEFloat64Float64Op{
				input:   input,
				col1Idx: col1Idx,
				col2Idx: col2Idx,
			}, nil

		default:
			return nil, errors.Errorf("unhandled comparison operator: %s", cmpOp)
		}

	default:
		return nil, errors.Errorf("unhandled type: %s", t)
	}
}
