// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: roachpb/api.proto

package roachpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import enginepb "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"
import tracing "github.com/cockroachdb/cockroach/pkg/util/tracing"

import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import bytes "bytes"

import (
	context "context"
	grpc "google.golang.org/grpc"
)

import encoding_binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// ReadConsistencyType specifies what type of consistency is observed
// during read operations.
type ReadConsistencyType int32

const (
	// CONSISTENT reads are guaranteed to read committed data; the
	// mechanism relies on clocks to determine lease expirations.
	CONSISTENT ReadConsistencyType = 0
	// READ_UNCOMMITTED reads return both committed and uncommitted data.
	// The consistency type is similar to INCONSISTENT in that using it
	// can result in dirty reads. However, like the CONSISTENT type, it
	// requires the replica performing the read to hold a valid read lease,
	// meaning that it can't return arbitrarily stale data.
	READ_UNCOMMITTED ReadConsistencyType = 1
	// INCONSISTENT reads return the latest available, committed values.
	// They are more efficient, but may read stale values as pending
	// intents are ignored.
	INCONSISTENT ReadConsistencyType = 2
)

var ReadConsistencyType_name = map[int32]string{
	0: "CONSISTENT",
	1: "READ_UNCOMMITTED",
	2: "INCONSISTENT",
}
var ReadConsistencyType_value = map[string]int32{
	"CONSISTENT":       0,
	"READ_UNCOMMITTED": 1,
	"INCONSISTENT":     2,
}

func (x ReadConsistencyType) String() string {
	return proto.EnumName(ReadConsistencyType_name, int32(x))
}
func (ReadConsistencyType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{0}
}

// ScanFormat is an enumeration of the available response formats for MVCCScan
// operations.
type ScanFormat int32

const (
	// The standard MVCCScan format: a slice of KeyValue messages.
	KEY_VALUES ScanFormat = 0
	// The batch_response format: a byte slice of alternating keys and values,
	// each prefixed by their length as a varint.
	BATCH_RESPONSE ScanFormat = 1
)

var ScanFormat_name = map[int32]string{
	0: "KEY_VALUES",
	1: "BATCH_RESPONSE",
}
var ScanFormat_value = map[string]int32{
	"KEY_VALUES":     0,
	"BATCH_RESPONSE": 1,
}

func (x ScanFormat) String() string {
	return proto.EnumName(ScanFormat_name, int32(x))
}
func (ScanFormat) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{1}
}

type ChecksumMode int32

const (
	// CHECK_VIA_QUEUE is set for requests made from the consistency queue. In
	// this mode, a full check is carried out, and depending on the result a
	// recursive consistency check is triggered:
	//
	// 1. no inconsistency found: if recomputed stats don't match persisted stats,
	//    trigger a RecomputeStatsRequest.
	// 2. inconsistency found: if a diff is available, print it and trigger fatal
	//    error. If no diff found, trigger recursive check with diff requested
	//    (which then triggers fatal error).
	//
	// TODO(tbg): these semantics are an artifact of how consistency checks were
	// first implemented. The extra behavior here should move to the consistency
	// check queue instead and this option dropped from the enum.
	ChecksumMode_CHECK_VIA_QUEUE ChecksumMode = 0
	// CHECK_FULL recomputes the hash of the replicate data in all replicas and
	// uses this to determine whether there is an inconsistency.
	ChecksumMode_CHECK_FULL ChecksumMode = 1
	// CHECK_STATS only hashes the persisted lease applied state (which notably
	// includes the persisted MVCCStats) only. This catches a large class of
	// replica inconsistencies observed in the wild (where replicas apply a
	// nonidentical log of commands, and as a result almost always have
	// divergent stats), while doing work independent of the size of the data
	// contained in the replicas.
	ChecksumMode_CHECK_STATS ChecksumMode = 2
)

var ChecksumMode_name = map[int32]string{
	0: "CHECK_VIA_QUEUE",
	1: "CHECK_FULL",
	2: "CHECK_STATS",
}
var ChecksumMode_value = map[string]int32{
	"CHECK_VIA_QUEUE": 0,
	"CHECK_FULL":      1,
	"CHECK_STATS":     2,
}

func (x ChecksumMode) String() string {
	return proto.EnumName(ChecksumMode_name, int32(x))
}
func (ChecksumMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{2}
}

// PushTxnType determines what action to take when pushing a transaction.
type PushTxnType int32

const (
	// Push the timestamp forward if possible to accommodate a concurrent reader.
	PUSH_TIMESTAMP PushTxnType = 0
	// Abort the transaction if possible to accommodate a concurrent writer.
	PUSH_ABORT PushTxnType = 1
	// Abort the transaction if it's abandoned, but don't attempt to mutate it
	// otherwise.
	PUSH_TOUCH PushTxnType = 2
)

var PushTxnType_name = map[int32]string{
	0: "PUSH_TIMESTAMP",
	1: "PUSH_ABORT",
	2: "PUSH_TOUCH",
}
var PushTxnType_value = map[string]int32{
	"PUSH_TIMESTAMP": 0,
	"PUSH_ABORT":     1,
	"PUSH_TOUCH":     2,
}

func (x PushTxnType) String() string {
	return proto.EnumName(PushTxnType_name, int32(x))
}
func (PushTxnType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{3}
}

type ExportStorageProvider int32

const (
	ExportStorageProvider_Unknown     ExportStorageProvider = 0
	ExportStorageProvider_LocalFile   ExportStorageProvider = 1
	ExportStorageProvider_Http        ExportStorageProvider = 2
	ExportStorageProvider_S3          ExportStorageProvider = 3
	ExportStorageProvider_GoogleCloud ExportStorageProvider = 4
	ExportStorageProvider_Azure       ExportStorageProvider = 5
	ExportStorageProvider_Workload    ExportStorageProvider = 6
)

var ExportStorageProvider_name = map[int32]string{
	0: "Unknown",
	1: "LocalFile",
	2: "Http",
	3: "S3",
	4: "GoogleCloud",
	5: "Azure",
	6: "Workload",
}
var ExportStorageProvider_value = map[string]int32{
	"Unknown":     0,
	"LocalFile":   1,
	"Http":        2,
	"S3":          3,
	"GoogleCloud": 4,
	"Azure":       5,
	"Workload":    6,
}

func (x ExportStorageProvider) String() string {
	return proto.EnumName(ExportStorageProvider_name, int32(x))
}
func (ExportStorageProvider) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{4}
}

type MVCCFilter int32

const (
	MVCCFilter_Latest MVCCFilter = 0
	MVCCFilter_All    MVCCFilter = 1
)

var MVCCFilter_name = map[int32]string{
	0: "Latest",
	1: "All",
}
var MVCCFilter_value = map[string]int32{
	"Latest": 0,
	"All":    1,
}

func (x MVCCFilter) String() string {
	return proto.EnumName(MVCCFilter_name, int32(x))
}
func (MVCCFilter) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{5}
}

type ResponseHeader_ResumeReason int32

const (
	// Zero value; no resume.
	RESUME_UNKNOWN ResponseHeader_ResumeReason = 0
	// The spanning operation didn't finish because the key limit was
	// exceeded.
	RESUME_KEY_LIMIT ResponseHeader_ResumeReason = 1
	// The spanning operation didn't finish because a range boundary
	// was encountered and the command was configured to stop at range
	// boundaries.
	RESUME_RANGE_BOUNDARY ResponseHeader_ResumeReason = 2
)

var ResponseHeader_ResumeReason_name = map[int32]string{
	0: "RESUME_UNKNOWN",
	1: "RESUME_KEY_LIMIT",
	2: "RESUME_RANGE_BOUNDARY",
}
var ResponseHeader_ResumeReason_value = map[string]int32{
	"RESUME_UNKNOWN":        0,
	"RESUME_KEY_LIMIT":      1,
	"RESUME_RANGE_BOUNDARY": 2,
}

func (x ResponseHeader_ResumeReason) String() string {
	return proto.EnumName(ResponseHeader_ResumeReason_name, int32(x))
}
func (ResponseHeader_ResumeReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{2, 0}
}

type CheckConsistencyResponse_Status int32

const (
	// No inconsistency was detected, but not all replicas returned a checksum.
	CheckConsistencyResponse_RANGE_INDETERMINATE CheckConsistencyResponse_Status = 0
	// A definite inconsistency was detected.
	CheckConsistencyResponse_RANGE_INCONSISTENT CheckConsistencyResponse_Status = 1
	// All replicas of the range agreed on the checksum.
	CheckConsistencyResponse_RANGE_CONSISTENT CheckConsistencyResponse_Status = 2
	// Like RANGE_CONSISTENT, but the recomputed stats disagreed with the
	// persisted stats. The persisted stats indicates estimates, so this is
	// expected.
	CheckConsistencyResponse_RANGE_CONSISTENT_STATS_ESTIMATED CheckConsistencyResponse_Status = 3
	// Like RANGE_CONSISTENT_STATS_ESTIMATED, but the mismatch occurred with
	// persisted stats that claimed to be accurate. This is unexpected and
	// likely indicates a bug in our logic to incrementally update the stats
	// as commands are evaluated and applied.
	CheckConsistencyResponse_RANGE_CONSISTENT_STATS_INCORRECT CheckConsistencyResponse_Status = 4
)

var CheckConsistencyResponse_Status_name = map[int32]string{
	0: "RANGE_INDETERMINATE",
	1: "RANGE_INCONSISTENT",
	2: "RANGE_CONSISTENT",
	3: "RANGE_CONSISTENT_STATS_ESTIMATED",
	4: "RANGE_CONSISTENT_STATS_INCORRECT",
}
var CheckConsistencyResponse_Status_value = map[string]int32{
	"RANGE_INDETERMINATE":              0,
	"RANGE_INCONSISTENT":               1,
	"RANGE_CONSISTENT":                 2,
	"RANGE_CONSISTENT_STATS_ESTIMATED": 3,
	"RANGE_CONSISTENT_STATS_INCORRECT": 4,
}

func (x CheckConsistencyResponse_Status) String() string {
	return proto.EnumName(CheckConsistencyResponse_Status_name, int32(x))
}
func (CheckConsistencyResponse_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{25, 0}
}

type QueryIntentRequest_IfMissingBehavior int32

const (
	// Don't do anything special, just note that the intent was not found in the
	// response.
	QueryIntentRequest_DO_NOTHING QueryIntentRequest_IfMissingBehavior = 0
	// Return an IntentMissingError. Special-cased to return a SERIALIZABLE
	// retry error if a SERIALIZABLE transaction queries its own intent and
	// finds it has been pushed.
	QueryIntentRequest_RETURN_ERROR QueryIntentRequest_IfMissingBehavior = 1
	// Prevent the intent from ever being written in the future. If set as the
	// behavior, a response with found_intent=false implies that an intent will
	// never be writtable at the key at the transaction's timestamp or below.
	//
	// Cannot be used with SNAPSHOT transactions.
	QueryIntentRequest_PREVENT QueryIntentRequest_IfMissingBehavior = 2
)

var QueryIntentRequest_IfMissingBehavior_name = map[int32]string{
	0: "DO_NOTHING",
	1: "RETURN_ERROR",
	2: "PREVENT",
}
var QueryIntentRequest_IfMissingBehavior_value = map[string]int32{
	"DO_NOTHING":   0,
	"RETURN_ERROR": 1,
	"PREVENT":      2,
}

func (x QueryIntentRequest_IfMissingBehavior) String() string {
	return proto.EnumName(QueryIntentRequest_IfMissingBehavior_name, int32(x))
}
func (QueryIntentRequest_IfMissingBehavior) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{50, 0}
}

// RangeInfo describes a range which executed a request. It contains
// the range descriptor and lease information at the time of execution.
type RangeInfo struct {
	Desc                 RangeDescriptor `protobuf:"bytes,1,opt,name=desc,proto3" json:"desc"`
	Lease                Lease           `protobuf:"bytes,2,opt,name=lease,proto3" json:"lease"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *RangeInfo) Reset()         { *m = RangeInfo{} }
func (m *RangeInfo) String() string { return proto.CompactTextString(m) }
func (*RangeInfo) ProtoMessage()    {}
func (*RangeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{0}
}
func (m *RangeInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeInfo.Merge(dst, src)
}
func (m *RangeInfo) XXX_Size() int {
	return m.Size()
}
func (m *RangeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_RangeInfo proto.InternalMessageInfo

// RequestHeader is supplied with every storage node request.
type RequestHeader struct {
	// The key for request. If the request operates on a range, this
	// represents the starting key for the range.
	Key Key `protobuf:"bytes,3,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	// The end key is empty if the request spans only a single key. Otherwise,
	// it must order strictly after Key. In such a case, the header indicates
	// that the operation takes place on the key range from Key to EndKey,
	// including Key and excluding EndKey.
	EndKey Key `protobuf:"bytes,4,opt,name=end_key,json=endKey,proto3,casttype=Key" json:"end_key,omitempty"`
	// A one-indexed transactional sequence number.
	Sequence             int32    `protobuf:"varint,5,opt,name=sequence,proto3" json:"sequence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RequestHeader) Reset()         { *m = RequestHeader{} }
func (m *RequestHeader) String() string { return proto.CompactTextString(m) }
func (*RequestHeader) ProtoMessage()    {}
func (*RequestHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{1}
}
func (m *RequestHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RequestHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestHeader.Merge(dst, src)
}
func (m *RequestHeader) XXX_Size() int {
	return m.Size()
}
func (m *RequestHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestHeader.DiscardUnknown(m)
}

var xxx_messageInfo_RequestHeader proto.InternalMessageInfo

// ResponseHeader is returned with every storage node response.
type ResponseHeader struct {
	// txn is non-nil if the request specified a non-nil transaction.
	// The transaction timestamp and/or priority may have been updated,
	// depending on the outcome of the request.
	Txn *Transaction `protobuf:"bytes,3,opt,name=txn,proto3" json:"txn,omitempty"`
	// The next span to resume from when the response doesn't cover the full span
	// requested. This can happen when a bound on the keys is set through
	// max_span_request_keys in the batch header or when a scan has been stopped
	// before covering the requested data because of scan_options.
	//
	// ResumeSpan is unset when the entire span of keys have been
	// operated on. The span is set to the original span if the request
	// was ignored because max_span_request_keys was hit due to another
	// request in the batch. For a reverse scan the end_key is updated.
	ResumeSpan *Span `protobuf:"bytes,4,opt,name=resume_span,json=resumeSpan,proto3" json:"resume_span,omitempty"`
	// When resume_span is populated, this specifies the reason why the operation
	// wasn't completed and needs to be resumed.
	// This field appeared in v2.0. Responses from storage coming from older
	// servers will not contain it, but the conversion from a BatchResponse to a
	// client.Result always fills it in.
	ResumeReason ResponseHeader_ResumeReason `protobuf:"varint,7,opt,name=resume_reason,json=resumeReason,proto3,enum=cockroach.roachpb.ResponseHeader_ResumeReason" json:"resume_reason,omitempty"`
	// The number of keys operated on.
	NumKeys int64 `protobuf:"varint,5,opt,name=num_keys,json=numKeys,proto3" json:"num_keys,omitempty"`
	// Range or list of ranges used to execute the request. Multiple
	// ranges may be returned for Scan, ReverseScan or DeleteRange.
	RangeInfos           []RangeInfo `protobuf:"bytes,6,rep,name=range_infos,json=rangeInfos,proto3" json:"range_infos"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ResponseHeader) Reset()         { *m = ResponseHeader{} }
func (m *ResponseHeader) String() string { return proto.CompactTextString(m) }
func (*ResponseHeader) ProtoMessage()    {}
func (*ResponseHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{2}
}
func (m *ResponseHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResponseHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ResponseHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponseHeader.Merge(dst, src)
}
func (m *ResponseHeader) XXX_Size() int {
	return m.Size()
}
func (m *ResponseHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponseHeader.DiscardUnknown(m)
}

var xxx_messageInfo_ResponseHeader proto.InternalMessageInfo

// A GetRequest is the argument for the Get() method.
type GetRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRequest) Reset()         { *m = GetRequest{} }
func (m *GetRequest) String() string { return proto.CompactTextString(m) }
func (*GetRequest) ProtoMessage()    {}
func (*GetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{3}
}
func (m *GetRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *GetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRequest.Merge(dst, src)
}
func (m *GetRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRequest proto.InternalMessageInfo

// A GetResponse is the return value from the Get() method.
// If the key doesn't exist, Value will be nil.
type GetResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Value          *Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// The intent seen, if any, when using the READ_UNCOMMITTED consistency level.
	IntentValue          *Value   `protobuf:"bytes,3,opt,name=intent_value,json=intentValue,proto3" json:"intent_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetResponse) Reset()         { *m = GetResponse{} }
func (m *GetResponse) String() string { return proto.CompactTextString(m) }
func (*GetResponse) ProtoMessage()    {}
func (*GetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{4}
}
func (m *GetResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *GetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetResponse.Merge(dst, src)
}
func (m *GetResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetResponse proto.InternalMessageInfo

// A PutRequest is the argument to the Put() method.
type PutRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Value         Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value"`
	// Specify as true to put the value without a corresponding
	// timestamp. This option should be used with care as it precludes
	// the use of this value with transactions.
	Inline bool `protobuf:"varint,3,opt,name=inline,proto3" json:"inline,omitempty"`
	// NOTE: For internal use only! Set to indicate that the put is
	// writing to virgin keyspace and no reads are necessary to
	// rationalize MVCC.
	Blind                bool     `protobuf:"varint,4,opt,name=blind,proto3" json:"blind,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PutRequest) Reset()         { *m = PutRequest{} }
func (m *PutRequest) String() string { return proto.CompactTextString(m) }
func (*PutRequest) ProtoMessage()    {}
func (*PutRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{5}
}
func (m *PutRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PutRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *PutRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PutRequest.Merge(dst, src)
}
func (m *PutRequest) XXX_Size() int {
	return m.Size()
}
func (m *PutRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PutRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PutRequest proto.InternalMessageInfo

// A PutResponse is the return value from the Put() method.
type PutResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PutResponse) Reset()         { *m = PutResponse{} }
func (m *PutResponse) String() string { return proto.CompactTextString(m) }
func (*PutResponse) ProtoMessage()    {}
func (*PutResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{6}
}
func (m *PutResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PutResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *PutResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PutResponse.Merge(dst, src)
}
func (m *PutResponse) XXX_Size() int {
	return m.Size()
}
func (m *PutResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PutResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PutResponse proto.InternalMessageInfo

// A ConditionalPutRequest is the argument to the ConditionalPut() method.
//
// - Returns true and sets value if exp_value equals existing value.
// - If key doesn't exist and exp_value is nil, sets value.
// - If key exists, but value is empty and exp_value is not nil but empty, sets value.
// - Otherwise, returns an error containing the actual value of the key.
type ConditionalPutRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// The value to put.
	Value Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value"`
	// Set exp_value.bytes empty to test for non-existence. Specify as nil
	// to indicate there should be no existing entry. This is different
	// from the expectation that the value exists but is empty.
	ExpValue *Value `protobuf:"bytes,3,opt,name=exp_value,json=expValue,proto3" json:"exp_value,omitempty"`
	// NOTE: For internal use only! Set to indicate that the put is
	// writing to virgin keyspace and no reads are necessary to
	// rationalize MVCC.
	Blind bool `protobuf:"varint,4,opt,name=blind,proto3" json:"blind,omitempty"`
	// Typically if a specific, non-empty expected value is supplied, it *must*
	// exist with that value. Passing this indicates that it is also OK if the key
	// does not exist. This is useful when a given value is expected but it is
	// possible it has not yet been written.
	AllowIfDoesNotExist  bool     `protobuf:"varint,5,opt,name=allow_if_does_not_exist,json=allowIfDoesNotExist,proto3" json:"allow_if_does_not_exist,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConditionalPutRequest) Reset()         { *m = ConditionalPutRequest{} }
func (m *ConditionalPutRequest) String() string { return proto.CompactTextString(m) }
func (*ConditionalPutRequest) ProtoMessage()    {}
func (*ConditionalPutRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{7}
}
func (m *ConditionalPutRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConditionalPutRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ConditionalPutRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConditionalPutRequest.Merge(dst, src)
}
func (m *ConditionalPutRequest) XXX_Size() int {
	return m.Size()
}
func (m *ConditionalPutRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ConditionalPutRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ConditionalPutRequest proto.InternalMessageInfo

// A ConditionalPutResponse is the return value from the
// ConditionalPut() method.
type ConditionalPutResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConditionalPutResponse) Reset()         { *m = ConditionalPutResponse{} }
func (m *ConditionalPutResponse) String() string { return proto.CompactTextString(m) }
func (*ConditionalPutResponse) ProtoMessage()    {}
func (*ConditionalPutResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{8}
}
func (m *ConditionalPutResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConditionalPutResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ConditionalPutResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConditionalPutResponse.Merge(dst, src)
}
func (m *ConditionalPutResponse) XXX_Size() int {
	return m.Size()
}
func (m *ConditionalPutResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ConditionalPutResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ConditionalPutResponse proto.InternalMessageInfo

// An InitPutRequest is the argument to the InitPut() method.
//
// - If key doesn't exist, sets value.
// - If key exists, returns a ConditionFailedError if value != existing value
//   If failOnTombstones is set to true, tombstone values count as mismatched
//   values and will cause a ConditionFailedError.
type InitPutRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Value         Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value"`
	// NOTE: For internal use only! Set to indicate that the put is
	// writing to virgin keyspace and no reads are necessary to
	// rationalize MVCC.
	Blind bool `protobuf:"varint,3,opt,name=blind,proto3" json:"blind,omitempty"`
	// If true, tombstones cause ConditionFailedErrors.
	FailOnTombstones     bool     `protobuf:"varint,4,opt,name=failOnTombstones,proto3" json:"failOnTombstones,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InitPutRequest) Reset()         { *m = InitPutRequest{} }
func (m *InitPutRequest) String() string { return proto.CompactTextString(m) }
func (*InitPutRequest) ProtoMessage()    {}
func (*InitPutRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{9}
}
func (m *InitPutRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InitPutRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *InitPutRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InitPutRequest.Merge(dst, src)
}
func (m *InitPutRequest) XXX_Size() int {
	return m.Size()
}
func (m *InitPutRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InitPutRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InitPutRequest proto.InternalMessageInfo

// A InitPutResponse is the return value from the InitPut() method.
type InitPutResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InitPutResponse) Reset()         { *m = InitPutResponse{} }
func (m *InitPutResponse) String() string { return proto.CompactTextString(m) }
func (*InitPutResponse) ProtoMessage()    {}
func (*InitPutResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{10}
}
func (m *InitPutResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InitPutResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *InitPutResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InitPutResponse.Merge(dst, src)
}
func (m *InitPutResponse) XXX_Size() int {
	return m.Size()
}
func (m *InitPutResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_InitPutResponse.DiscardUnknown(m)
}

var xxx_messageInfo_InitPutResponse proto.InternalMessageInfo

// An IncrementRequest is the argument to the Increment() method. It
// increments the value for key, and returns the new value. If no
// value exists for a key, incrementing by 0 is not a noop, but will
// create a zero value. IncrementRequest cannot be called on a key set
// by Put() or ConditionalPut(). Similarly, Put() and ConditionalPut()
// cannot be invoked on an incremented key.
type IncrementRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Increment            int64    `protobuf:"varint,2,opt,name=increment,proto3" json:"increment,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IncrementRequest) Reset()         { *m = IncrementRequest{} }
func (m *IncrementRequest) String() string { return proto.CompactTextString(m) }
func (*IncrementRequest) ProtoMessage()    {}
func (*IncrementRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{11}
}
func (m *IncrementRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IncrementRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *IncrementRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IncrementRequest.Merge(dst, src)
}
func (m *IncrementRequest) XXX_Size() int {
	return m.Size()
}
func (m *IncrementRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_IncrementRequest.DiscardUnknown(m)
}

var xxx_messageInfo_IncrementRequest proto.InternalMessageInfo

// An IncrementResponse is the return value from the Increment
// method. The new value after increment is specified in NewValue. If
// the value could not be decoded as specified, Error will be set.
type IncrementResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	NewValue             int64    `protobuf:"varint,2,opt,name=new_value,json=newValue,proto3" json:"new_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IncrementResponse) Reset()         { *m = IncrementResponse{} }
func (m *IncrementResponse) String() string { return proto.CompactTextString(m) }
func (*IncrementResponse) ProtoMessage()    {}
func (*IncrementResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{12}
}
func (m *IncrementResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IncrementResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *IncrementResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IncrementResponse.Merge(dst, src)
}
func (m *IncrementResponse) XXX_Size() int {
	return m.Size()
}
func (m *IncrementResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_IncrementResponse.DiscardUnknown(m)
}

var xxx_messageInfo_IncrementResponse proto.InternalMessageInfo

// A DeleteRequest is the argument to the Delete() method.
type DeleteRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteRequest) Reset()         { *m = DeleteRequest{} }
func (m *DeleteRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteRequest) ProtoMessage()    {}
func (*DeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{13}
}
func (m *DeleteRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *DeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRequest.Merge(dst, src)
}
func (m *DeleteRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRequest proto.InternalMessageInfo

// A DeleteResponse is the return value from the Delete() method.
type DeleteResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteResponse) Reset()         { *m = DeleteResponse{} }
func (m *DeleteResponse) String() string { return proto.CompactTextString(m) }
func (*DeleteResponse) ProtoMessage()    {}
func (*DeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{14}
}
func (m *DeleteResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *DeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteResponse.Merge(dst, src)
}
func (m *DeleteResponse) XXX_Size() int {
	return m.Size()
}
func (m *DeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteResponse proto.InternalMessageInfo

// A DeleteRangeRequest is the argument to the DeleteRange() method. It
// specifies the range of keys to delete.
type DeleteRangeRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// return the keys that are deleted in the response.
	ReturnKeys bool `protobuf:"varint,3,opt,name=return_keys,json=returnKeys,proto3" json:"return_keys,omitempty"`
	// delete "inline" keys which are stored without MVCC timestamps. Note that
	// an "inline" DeleteRange will fail if it attempts to delete any keys which
	// contain timestamped (non-inline) values; this option should only be used on
	// keys which are known to store inline values, such as data in cockroach's
	// time series system.
	//
	// Similarly, attempts to delete keys with inline values will fail unless this
	// flag is set to true; the setting must match the data being deleted.
	//
	// Inline values cannot be deleted transactionally; a DeleteRange with
	// "inline" set to true will fail if it is executed within a transaction.
	Inline               bool     `protobuf:"varint,4,opt,name=inline,proto3" json:"inline,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteRangeRequest) Reset()         { *m = DeleteRangeRequest{} }
func (m *DeleteRangeRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteRangeRequest) ProtoMessage()    {}
func (*DeleteRangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{15}
}
func (m *DeleteRangeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteRangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *DeleteRangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRangeRequest.Merge(dst, src)
}
func (m *DeleteRangeRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeleteRangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRangeRequest proto.InternalMessageInfo

// A DeleteRangeResponse is the return value from the DeleteRange()
// method.
type DeleteRangeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// All the deleted keys if return_keys is set.
	Keys                 []Key    `protobuf:"bytes,2,rep,name=keys,proto3,casttype=Key" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteRangeResponse) Reset()         { *m = DeleteRangeResponse{} }
func (m *DeleteRangeResponse) String() string { return proto.CompactTextString(m) }
func (*DeleteRangeResponse) ProtoMessage()    {}
func (*DeleteRangeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{16}
}
func (m *DeleteRangeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteRangeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *DeleteRangeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRangeResponse.Merge(dst, src)
}
func (m *DeleteRangeResponse) XXX_Size() int {
	return m.Size()
}
func (m *DeleteRangeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRangeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRangeResponse proto.InternalMessageInfo

// A ClearRangeRequest is the argument to the ClearRange() method. It
// specifies a range of keys to clear from the underlying engine. Note
// that this differs from the behavior of DeleteRange, which sets
// transactional intents and writes tombstones to the deleted
// keys. ClearRange is used when permanently dropping or truncating
// table data.
//
// ClearRange also updates the GC threshold for the range to the
// timestamp at which this command executes, to prevent reads at
// earlier timestamps from incorrectly returning empty results.
//
// NOTE: it is important that this method only be invoked on a key
// range which is guaranteed to be both inactive and not see future
// writes. Ignoring this warning may result in data loss.
type ClearRangeRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClearRangeRequest) Reset()         { *m = ClearRangeRequest{} }
func (m *ClearRangeRequest) String() string { return proto.CompactTextString(m) }
func (*ClearRangeRequest) ProtoMessage()    {}
func (*ClearRangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{17}
}
func (m *ClearRangeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClearRangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ClearRangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClearRangeRequest.Merge(dst, src)
}
func (m *ClearRangeRequest) XXX_Size() int {
	return m.Size()
}
func (m *ClearRangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ClearRangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ClearRangeRequest proto.InternalMessageInfo

// A ClearRangeResponse is the return value from the ClearRange() method.
type ClearRangeResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClearRangeResponse) Reset()         { *m = ClearRangeResponse{} }
func (m *ClearRangeResponse) String() string { return proto.CompactTextString(m) }
func (*ClearRangeResponse) ProtoMessage()    {}
func (*ClearRangeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{18}
}
func (m *ClearRangeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClearRangeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ClearRangeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClearRangeResponse.Merge(dst, src)
}
func (m *ClearRangeResponse) XXX_Size() int {
	return m.Size()
}
func (m *ClearRangeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ClearRangeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ClearRangeResponse proto.InternalMessageInfo

// ScanOptions is a collection of options for a batch of scans. The options
// apply to all the scans in the batch.
//
// If ScanOptions is present on a batch, the batch can only be made up of scan
// requests (i.e.  {Reverse,}ScanReques), except for
// {Begin,End}TransactionRequest which are still allowed. Moreover, the batch
// cannot mix forward and reverse scans.
//
// TODO(andrei): add option to stop scan(s) when an intent is encountered.
type ScanOptions struct {
	// stop_at_range_boundary, if set, means that the scans will stop at the first
	// range boundary after min_results is specified (if it is
	// specified). If the end of a range stops the scans, the resume_span returned
	// (for all the scans whose spans weren't fully scanned) represents the
	// beginning of the next range (as ranges were at the time of the read).
	//
	// This flag can be combined with header.max_span_request_keys but that means
	// that the desired number of keys may not be scanned.
	//
	// stop_at_range_boundary implies that DistSender will no longer parallelize
	// the execution of requests between ranges; instead, either we're only
	// speaking about scanning one range (if min_results is not set) or
	// it executes the scan serially over different ranges. Note that this is
	// also the case when max_span_request_keys is set (as the scan needs to
	// return results in order), and SQL always sets max_span_request_keys.
	StopAtRangeBoundary bool `protobuf:"varint,1,opt,name=stop_at_range_boundary,json=stopAtRangeBoundary,proto3" json:"stop_at_range_boundary,omitempty"`
	// min_results, if != 0, prevents the stop_at_range_boundary option from
	// terminating the scans before this many keys have been touched. The
	// counting is done across all the scans in the batch.
	//
	// A common value is 1, used if either the client knows that one key will be
	// sufficient for its purposes or if the client wants to skip a prefix of
	// empty ranges and seek to the point where some data is present.
	//
	// This can only be set if stop_at_range_boundary is set. If
	// header.max_span_request_keys is set, min_results needs to be <=
	// header.max_span_request_keys.
	MinResults           int64    `protobuf:"varint,2,opt,name=min_results,json=minResults,proto3" json:"min_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanOptions) Reset()         { *m = ScanOptions{} }
func (m *ScanOptions) String() string { return proto.CompactTextString(m) }
func (*ScanOptions) ProtoMessage()    {}
func (*ScanOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{19}
}
func (m *ScanOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ScanOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanOptions.Merge(dst, src)
}
func (m *ScanOptions) XXX_Size() int {
	return m.Size()
}
func (m *ScanOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanOptions.DiscardUnknown(m)
}

var xxx_messageInfo_ScanOptions proto.InternalMessageInfo

// A ScanRequest is the argument to the Scan() method. It specifies the
// start and end keys for an ascending scan of [start,end) and the maximum
// number of results (unbounded if zero).
type ScanRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// The desired format for the response. If set to BATCH_RESPONSE, the server
	// will set the batch_responses field in the ScanResponse instead of the rows
	// field.
	ScanFormat           ScanFormat `protobuf:"varint,4,opt,name=scan_format,json=scanFormat,proto3,enum=cockroach.roachpb.ScanFormat" json:"scan_format,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ScanRequest) Reset()         { *m = ScanRequest{} }
func (m *ScanRequest) String() string { return proto.CompactTextString(m) }
func (*ScanRequest) ProtoMessage()    {}
func (*ScanRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{20}
}
func (m *ScanRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ScanRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanRequest.Merge(dst, src)
}
func (m *ScanRequest) XXX_Size() int {
	return m.Size()
}
func (m *ScanRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ScanRequest proto.InternalMessageInfo

// A ScanResponse is the return value from the Scan() method.
type ScanResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// Empty if no rows were scanned.
	Rows []KeyValue `protobuf:"bytes,2,rep,name=rows,proto3" json:"rows"`
	// The intent rows seen when performing a scan at the READ_UNCOMMITTED
	// consistency level. These rows do not count against the MaxSpanRequestKeys
	// count.
	IntentRows []KeyValue `protobuf:"bytes,3,rep,name=intent_rows,json=intentRows,proto3" json:"intent_rows"`
	// If set, each item in this repeated bytes field contains part of the results
	// in batch format - the key/value pairs are a buffer of varint-prefixed
	// slices, alternating from key to value. Each entry in this field is
	// complete - there are no key/value pairs that are split across more than one
	// entry. There are num_keys total pairs across all entries, as defined by the
	// ResponseHeader. If set, rows will not be set and vice versa.
	BatchResponses       [][]byte `protobuf:"bytes,4,rep,name=batch_responses,json=batchResponses,proto3" json:"batch_responses,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanResponse) Reset()         { *m = ScanResponse{} }
func (m *ScanResponse) String() string { return proto.CompactTextString(m) }
func (*ScanResponse) ProtoMessage()    {}
func (*ScanResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{21}
}
func (m *ScanResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ScanResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanResponse.Merge(dst, src)
}
func (m *ScanResponse) XXX_Size() int {
	return m.Size()
}
func (m *ScanResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ScanResponse proto.InternalMessageInfo

// A ReverseScanRequest is the argument to the ReverseScan() method. It specifies the
// start and end keys for a descending scan of [start,end) and the maximum
// number of results (unbounded if zero).
type ReverseScanRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// The desired format for the response. If set to BATCH_RESPONSE, the server
	// will set the batch_responses field in the ScanResponse instead of the rows
	// field.
	ScanFormat           ScanFormat `protobuf:"varint,4,opt,name=scan_format,json=scanFormat,proto3,enum=cockroach.roachpb.ScanFormat" json:"scan_format,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ReverseScanRequest) Reset()         { *m = ReverseScanRequest{} }
func (m *ReverseScanRequest) String() string { return proto.CompactTextString(m) }
func (*ReverseScanRequest) ProtoMessage()    {}
func (*ReverseScanRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{22}
}
func (m *ReverseScanRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReverseScanRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ReverseScanRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReverseScanRequest.Merge(dst, src)
}
func (m *ReverseScanRequest) XXX_Size() int {
	return m.Size()
}
func (m *ReverseScanRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReverseScanRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReverseScanRequest proto.InternalMessageInfo

// A ReverseScanResponse is the return value from the ReverseScan() method.
type ReverseScanResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// Empty if no rows were scanned.
	Rows []KeyValue `protobuf:"bytes,2,rep,name=rows,proto3" json:"rows"`
	// The intent rows seen when performing a scan at the READ_UNCOMMITTED
	// consistency level. These rows do not count against the MaxSpanRequestKeys
	// count.
	IntentRows []KeyValue `protobuf:"bytes,3,rep,name=intent_rows,json=intentRows,proto3" json:"intent_rows"`
	// If set, each item in this repeated bytes field contains part of the results
	// in batch format - the key/value pairs are a buffer of varint-prefixed
	// slices, alternating from key to value. Each entry in this field is
	// complete - there are no key/value pairs that are split across more than one
	// entry. There are num_keys total pairs across all entries, as defined by the
	// ResponseHeader. If set, rows will not be set and vice versa.
	BatchResponses       [][]byte `protobuf:"bytes,4,rep,name=batch_responses,json=batchResponses,proto3" json:"batch_responses,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReverseScanResponse) Reset()         { *m = ReverseScanResponse{} }
func (m *ReverseScanResponse) String() string { return proto.CompactTextString(m) }
func (*ReverseScanResponse) ProtoMessage()    {}
func (*ReverseScanResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{23}
}
func (m *ReverseScanResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReverseScanResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ReverseScanResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReverseScanResponse.Merge(dst, src)
}
func (m *ReverseScanResponse) XXX_Size() int {
	return m.Size()
}
func (m *ReverseScanResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReverseScanResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReverseScanResponse proto.InternalMessageInfo

// A CheckConsistencyRequest is the argument to the CheckConsistency() method.
// It specifies the start and end keys for a span of ranges to which a
// consistency check should be applied. A consistency check on a range involves
// running a ComputeChecksum on the range followed by a storage.CollectChecksum.
type CheckConsistencyRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// log a diff of inconsistencies if such inconsistencies are found. This is only
	// valid if mode == FROM_QUEUE
	WithDiff bool         `protobuf:"varint,2,opt,name=with_diff,json=withDiff,proto3" json:"with_diff,omitempty"`
	Mode     ChecksumMode `protobuf:"varint,3,opt,name=mode,proto3,enum=cockroach.roachpb.ChecksumMode" json:"mode,omitempty"`
	// Whether to create a RocksDB checkpoint on each replica at the log position
	// at which the SHA is computed. The checkpoint is essentially a cheap point-
	// in-time backup of the database. It will be put into the engines' auxiliary
	// directory and needs to be removed manually to avoid leaking disk space.
	Checkpoint           bool     `protobuf:"varint,4,opt,name=checkpoint,proto3" json:"checkpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckConsistencyRequest) Reset()         { *m = CheckConsistencyRequest{} }
func (m *CheckConsistencyRequest) String() string { return proto.CompactTextString(m) }
func (*CheckConsistencyRequest) ProtoMessage()    {}
func (*CheckConsistencyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{24}
}
func (m *CheckConsistencyRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckConsistencyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *CheckConsistencyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckConsistencyRequest.Merge(dst, src)
}
func (m *CheckConsistencyRequest) XXX_Size() int {
	return m.Size()
}
func (m *CheckConsistencyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckConsistencyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckConsistencyRequest proto.InternalMessageInfo

// A CheckConsistencyResponse is the return value from the CheckConsistency() method.
// It returns the status the range was found in.
type CheckConsistencyResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// result contains a Result for each Range checked, in no particular order.
	Result               []CheckConsistencyResponse_Result `protobuf:"bytes,2,rep,name=result,proto3" json:"result"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *CheckConsistencyResponse) Reset()         { *m = CheckConsistencyResponse{} }
func (m *CheckConsistencyResponse) String() string { return proto.CompactTextString(m) }
func (*CheckConsistencyResponse) ProtoMessage()    {}
func (*CheckConsistencyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{25}
}
func (m *CheckConsistencyResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckConsistencyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *CheckConsistencyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckConsistencyResponse.Merge(dst, src)
}
func (m *CheckConsistencyResponse) XXX_Size() int {
	return m.Size()
}
func (m *CheckConsistencyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckConsistencyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckConsistencyResponse proto.InternalMessageInfo

type CheckConsistencyResponse_Result struct {
	RangeID RangeID `protobuf:"varint,1,opt,name=range_id,json=rangeId,proto3,casttype=RangeID" json:"range_id,omitempty"`
	// start_key of the range corresponding to range_id (at the time of the
	// check). This is useful to send additional requests to only a subset of
	// ranges contained within a result later, as requests can only be routed by
	// key.
	StartKey []byte                          `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	Status   CheckConsistencyResponse_Status `protobuf:"varint,3,opt,name=status,proto3,enum=cockroach.roachpb.CheckConsistencyResponse_Status" json:"status,omitempty"`
	// detail contains information related to the operation. If no inconsistency
	// is found, it contains informational value such as observed stats. If an
	// inconsistency is found, it contains information about that inconsistency
	// including the involved replica and, if requested, the diff.
	Detail               string   `protobuf:"bytes,4,opt,name=detail,proto3" json:"detail,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckConsistencyResponse_Result) Reset()         { *m = CheckConsistencyResponse_Result{} }
func (m *CheckConsistencyResponse_Result) String() string { return proto.CompactTextString(m) }
func (*CheckConsistencyResponse_Result) ProtoMessage()    {}
func (*CheckConsistencyResponse_Result) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{25, 0}
}
func (m *CheckConsistencyResponse_Result) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckConsistencyResponse_Result) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *CheckConsistencyResponse_Result) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckConsistencyResponse_Result.Merge(dst, src)
}
func (m *CheckConsistencyResponse_Result) XXX_Size() int {
	return m.Size()
}
func (m *CheckConsistencyResponse_Result) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckConsistencyResponse_Result.DiscardUnknown(m)
}

var xxx_messageInfo_CheckConsistencyResponse_Result proto.InternalMessageInfo

// An RecomputeStatsRequest triggers a stats recomputation on the Range addressed by
// the request.
//
// An error will be returned if the start key does not match the start key of the
// target Range.
//
// The stats recomputation touches essentially the whole range, but the command
// avoids having to block other commands by taking care to not interleave
// with splits, and by using the commutativity of stats updates. As a result,
// it is safe to invoke at any time, including repeatedly, though it should be
// used conservatively due to performing a full scan of the Range.
type RecomputeStatsRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// When dry_run is true, the stats delta is computed, but no stats adjustment
	// is performed. This isn't useful outside of testing since RecomputeStats is
	// safe and idempotent.
	DryRun               bool     `protobuf:"varint,2,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RecomputeStatsRequest) Reset()         { *m = RecomputeStatsRequest{} }
func (m *RecomputeStatsRequest) String() string { return proto.CompactTextString(m) }
func (*RecomputeStatsRequest) ProtoMessage()    {}
func (*RecomputeStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{26}
}
func (m *RecomputeStatsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RecomputeStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RecomputeStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecomputeStatsRequest.Merge(dst, src)
}
func (m *RecomputeStatsRequest) XXX_Size() int {
	return m.Size()
}
func (m *RecomputeStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RecomputeStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RecomputeStatsRequest proto.InternalMessageInfo

// An RecomputeStatsResponse is the response to an RecomputeStatsRequest.
type RecomputeStatsResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// added_delta is the adjustment made to the range's stats, i.e. `new_stats = old_stats + added_delta`.
	AddedDelta           enginepb.MVCCStatsDelta `protobuf:"bytes,2,opt,name=added_delta,json=addedDelta,proto3" json:"added_delta"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *RecomputeStatsResponse) Reset()         { *m = RecomputeStatsResponse{} }
func (m *RecomputeStatsResponse) String() string { return proto.CompactTextString(m) }
func (*RecomputeStatsResponse) ProtoMessage()    {}
func (*RecomputeStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{27}
}
func (m *RecomputeStatsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RecomputeStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RecomputeStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecomputeStatsResponse.Merge(dst, src)
}
func (m *RecomputeStatsResponse) XXX_Size() int {
	return m.Size()
}
func (m *RecomputeStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RecomputeStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RecomputeStatsResponse proto.InternalMessageInfo

// A BeginTransactionRequest is the argument to the BeginTransaction() method.
type BeginTransactionRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BeginTransactionRequest) Reset()         { *m = BeginTransactionRequest{} }
func (m *BeginTransactionRequest) String() string { return proto.CompactTextString(m) }
func (*BeginTransactionRequest) ProtoMessage()    {}
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{28}
}
func (m *BeginTransactionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BeginTransactionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *BeginTransactionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginTransactionRequest.Merge(dst, src)
}
func (m *BeginTransactionRequest) XXX_Size() int {
	return m.Size()
}
func (m *BeginTransactionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginTransactionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BeginTransactionRequest proto.InternalMessageInfo

// A BeginTransactionResponse is the return value from the BeginTransaction() method.
type BeginTransactionResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BeginTransactionResponse) Reset()         { *m = BeginTransactionResponse{} }
func (m *BeginTransactionResponse) String() string { return proto.CompactTextString(m) }
func (*BeginTransactionResponse) ProtoMessage()    {}
func (*BeginTransactionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{29}
}
func (m *BeginTransactionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BeginTransactionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *BeginTransactionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginTransactionResponse.Merge(dst, src)
}
func (m *BeginTransactionResponse) XXX_Size() int {
	return m.Size()
}
func (m *BeginTransactionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginTransactionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BeginTransactionResponse proto.InternalMessageInfo

// An EndTransactionRequest is the argument to the EndTransaction() method. It
// specifies whether to commit or roll back an extant transaction.
type EndTransactionRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// False to abort and rollback.
	Commit bool `protobuf:"varint,2,opt,name=commit,proto3" json:"commit,omitempty"`
	// If set, deadline represents the maximum (exclusive) timestamp at which the
	// transaction can commit (i.e. the maximum timestamp for the txn's reads and
	// writes).
	// If EndTransaction(Commit=true) finds that the txn's timestamp has been
	// pushed above this deadline, an error will be returned and the client is
	// supposed to rollback the txn.
	Deadline *hlc.Timestamp `protobuf:"bytes,3,opt,name=deadline,proto3" json:"deadline,omitempty"`
	// commit triggers. Note that commit triggers are for
	// internal use only and will cause an error if requested through the
	// external-facing KV API.
	InternalCommitTrigger *InternalCommitTrigger `protobuf:"bytes,4,opt,name=internal_commit_trigger,json=internalCommitTrigger,proto3" json:"internal_commit_trigger,omitempty"`
	// List of intents written by the transaction. These are spans where
	// write intents have been written which must be resolved on txn
	// completion. Note that these spans may be condensed to cover
	// aggregate spans if the keys written by the transaction exceeded
	// a size threshold.
	IntentSpans []Span `protobuf:"bytes,5,rep,name=intent_spans,json=intentSpans,proto3" json:"intent_spans"`
	// Requires that the transaction completes as a 1 phase commit. This
	// guarantees that all writes are to the same range and that no
	// intents are left in the event of an error.
	Require1PC bool `protobuf:"varint,6,opt,name=require_1pc,json=require1pc,proto3" json:"require_1pc,omitempty"`
	// Set to true if this transaction is serializable isolation but has
	// accummulated no refresh spans. This allows the executing server
	// to retry it locally on the fast path.
	NoRefreshSpans bool `protobuf:"varint,8,opt,name=no_refresh_spans,json=noRefreshSpans,proto3" json:"no_refresh_spans,omitempty"`
	// True to indicate that intent spans should be resolved with
	// poison=true.  This is used when the transaction is being aborted
	// independently of the main thread of client operation, as in the
	// case of an asynchronous abort from the TxnCoordSender on a failed
	// heartbeat.
	Poison               bool     `protobuf:"varint,9,opt,name=poison,proto3" json:"poison,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EndTransactionRequest) Reset()         { *m = EndTransactionRequest{} }
func (m *EndTransactionRequest) String() string { return proto.CompactTextString(m) }
func (*EndTransactionRequest) ProtoMessage()    {}
func (*EndTransactionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{30}
}
func (m *EndTransactionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EndTransactionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *EndTransactionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EndTransactionRequest.Merge(dst, src)
}
func (m *EndTransactionRequest) XXX_Size() int {
	return m.Size()
}
func (m *EndTransactionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EndTransactionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EndTransactionRequest proto.InternalMessageInfo

// An EndTransactionResponse is the return value from the
// EndTransaction() method. The final transaction record is returned
// as part of the response header. In particular, transaction status
// and timestamp will be updated to reflect final committed
// values. Clients may propagate the transaction timestamp as the
// final txn commit timestamp in order to preserve causal ordering
// between subsequent transactions.
type EndTransactionResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// True if the transaction committed on the one phase commit path.
	// This means that all writes which were part of the transaction
	// were written as a single, atomic write batch to just one range.
	OnePhaseCommit       bool     `protobuf:"varint,4,opt,name=one_phase_commit,json=onePhaseCommit,proto3" json:"one_phase_commit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EndTransactionResponse) Reset()         { *m = EndTransactionResponse{} }
func (m *EndTransactionResponse) String() string { return proto.CompactTextString(m) }
func (*EndTransactionResponse) ProtoMessage()    {}
func (*EndTransactionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{31}
}
func (m *EndTransactionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EndTransactionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *EndTransactionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EndTransactionResponse.Merge(dst, src)
}
func (m *EndTransactionResponse) XXX_Size() int {
	return m.Size()
}
func (m *EndTransactionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_EndTransactionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_EndTransactionResponse proto.InternalMessageInfo

// An AdminSplitRequest is the argument to the AdminSplit() method. The
// existing range which contains header.key is split by
// split_key. If split_key is not specified, then this method will
// determine a split key that is roughly halfway through the
// range. The existing range is resized to cover only its start key to
// the split key. The new range created by the split starts at the
// split key and extends to the original range's end key. If split_key
// is known, header.key should also be set to split_key.
//
// New range IDs for each of the split range's replica and a new Raft
// ID are generated by the operation. Split requests are done in the
// context of a distributed transaction which updates range addressing
// records, range metadata and finally, provides a commit trigger to
// update bookkeeping and instantiate the new range on commit.
//
// The new range contains range replicas located on the same stores;
// no range data is moved during this operation. The split can be
// thought of as a mostly logical operation, though some other
// metadata (e.g. abort span and range stats must be copied or
// recomputed).
type AdminSplitRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	SplitKey             Key      `protobuf:"bytes,2,opt,name=split_key,json=splitKey,proto3,casttype=Key" json:"split_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdminSplitRequest) Reset()         { *m = AdminSplitRequest{} }
func (m *AdminSplitRequest) String() string { return proto.CompactTextString(m) }
func (*AdminSplitRequest) ProtoMessage()    {}
func (*AdminSplitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{32}
}
func (m *AdminSplitRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdminSplitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AdminSplitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminSplitRequest.Merge(dst, src)
}
func (m *AdminSplitRequest) XXX_Size() int {
	return m.Size()
}
func (m *AdminSplitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminSplitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AdminSplitRequest proto.InternalMessageInfo

// An AdminSplitResponse is the return value from the AdminSplit()
// method.
type AdminSplitResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdminSplitResponse) Reset()         { *m = AdminSplitResponse{} }
func (m *AdminSplitResponse) String() string { return proto.CompactTextString(m) }
func (*AdminSplitResponse) ProtoMessage()    {}
func (*AdminSplitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{33}
}
func (m *AdminSplitResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdminSplitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AdminSplitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminSplitResponse.Merge(dst, src)
}
func (m *AdminSplitResponse) XXX_Size() int {
	return m.Size()
}
func (m *AdminSplitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminSplitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AdminSplitResponse proto.InternalMessageInfo

// An AdminMergeRequest is the argument to the AdminMerge() method. A
// merge is performed by calling AdminMerge on the left-hand range of
// two consecutive ranges (i.e. the range which contains keys which
// sort first). This range will be the subsuming range and the right
// hand range will be subsumed. After the merge operation, the
// subsumed range will no longer exist and the subsuming range will
// now encompass all keys from its original start key to the end key
// of the subsumed range. If AdminMerge is called on the final range
// in the key space, it is a noop.
type AdminMergeRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdminMergeRequest) Reset()         { *m = AdminMergeRequest{} }
func (m *AdminMergeRequest) String() string { return proto.CompactTextString(m) }
func (*AdminMergeRequest) ProtoMessage()    {}
func (*AdminMergeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{34}
}
func (m *AdminMergeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdminMergeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AdminMergeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminMergeRequest.Merge(dst, src)
}
func (m *AdminMergeRequest) XXX_Size() int {
	return m.Size()
}
func (m *AdminMergeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminMergeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AdminMergeRequest proto.InternalMessageInfo

// An AdminMergeResponse is the return value from the AdminMerge()
// method.
type AdminMergeResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdminMergeResponse) Reset()         { *m = AdminMergeResponse{} }
func (m *AdminMergeResponse) String() string { return proto.CompactTextString(m) }
func (*AdminMergeResponse) ProtoMessage()    {}
func (*AdminMergeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{35}
}
func (m *AdminMergeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdminMergeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AdminMergeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminMergeResponse.Merge(dst, src)
}
func (m *AdminMergeResponse) XXX_Size() int {
	return m.Size()
}
func (m *AdminMergeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminMergeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AdminMergeResponse proto.InternalMessageInfo

// An AdminTransferLeaseRequest is the argument to the AdminTransferLease()
// method. A lease transfer allows an external entity to control the lease
// holder for a range. The target of the lease transfer needs to be a valid
// replica of the range.
type AdminTransferLeaseRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Target               StoreID  `protobuf:"varint,2,opt,name=target,proto3,casttype=StoreID" json:"target,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdminTransferLeaseRequest) Reset()         { *m = AdminTransferLeaseRequest{} }
func (m *AdminTransferLeaseRequest) String() string { return proto.CompactTextString(m) }
func (*AdminTransferLeaseRequest) ProtoMessage()    {}
func (*AdminTransferLeaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{36}
}
func (m *AdminTransferLeaseRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdminTransferLeaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AdminTransferLeaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminTransferLeaseRequest.Merge(dst, src)
}
func (m *AdminTransferLeaseRequest) XXX_Size() int {
	return m.Size()
}
func (m *AdminTransferLeaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminTransferLeaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AdminTransferLeaseRequest proto.InternalMessageInfo

type AdminTransferLeaseResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdminTransferLeaseResponse) Reset()         { *m = AdminTransferLeaseResponse{} }
func (m *AdminTransferLeaseResponse) String() string { return proto.CompactTextString(m) }
func (*AdminTransferLeaseResponse) ProtoMessage()    {}
func (*AdminTransferLeaseResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{37}
}
func (m *AdminTransferLeaseResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdminTransferLeaseResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AdminTransferLeaseResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminTransferLeaseResponse.Merge(dst, src)
}
func (m *AdminTransferLeaseResponse) XXX_Size() int {
	return m.Size()
}
func (m *AdminTransferLeaseResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminTransferLeaseResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AdminTransferLeaseResponse proto.InternalMessageInfo

// An AdminChangeReplicasRequest is the argument to the AdminChangeReplicas()
// method. A change replicas operation allows adding or removing a set of
// replicas for a range.
type AdminChangeReplicasRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	ChangeType    ReplicaChangeType   `protobuf:"varint,2,opt,name=change_type,json=changeType,proto3,enum=cockroach.roachpb.ReplicaChangeType" json:"change_type,omitempty"`
	Targets       []ReplicationTarget `protobuf:"bytes,3,rep,name=targets,proto3" json:"targets"`
	// ExpDesc is the expected current range descriptor to modify. If ExpDesc is
	// not nil and the value of the range descriptor is not identical to ExpDesc
	// for the request will fail.
	//
	// If there is more than one change specified in targets, this expectation
	// will be applied to the first change and subsequent changes will use the
	// resultant descriptor from successfully applying the previous change.
	// If a change with more than one target occurs concurrently with another
	// it is possible that an error will occur after partial application of the
	// change. Changes are applied in the order they appear in the request.
	//
	// This field was added for 19.1 release and must remain optional until 19.2.
	// TODO(ajwerner): Make this non-nullable for 19.2.
	ExpDesc              *RangeDescriptor `protobuf:"bytes,4,opt,name=exp_desc,json=expDesc,proto3" json:"exp_desc,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *AdminChangeReplicasRequest) Reset()         { *m = AdminChangeReplicasRequest{} }
func (m *AdminChangeReplicasRequest) String() string { return proto.CompactTextString(m) }
func (*AdminChangeReplicasRequest) ProtoMessage()    {}
func (*AdminChangeReplicasRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{38}
}
func (m *AdminChangeReplicasRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdminChangeReplicasRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AdminChangeReplicasRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminChangeReplicasRequest.Merge(dst, src)
}
func (m *AdminChangeReplicasRequest) XXX_Size() int {
	return m.Size()
}
func (m *AdminChangeReplicasRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminChangeReplicasRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AdminChangeReplicasRequest proto.InternalMessageInfo

type AdminChangeReplicasResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// Desc is the value of the range descriptor upon success.
	// This field was added for 19.1 release and must remain optional until 19.2.
	// TODO(ajwerner): Make this non-nullable for 19.2.
	Desc                 *RangeDescriptor `protobuf:"bytes,2,opt,name=desc,proto3" json:"desc,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *AdminChangeReplicasResponse) Reset()         { *m = AdminChangeReplicasResponse{} }
func (m *AdminChangeReplicasResponse) String() string { return proto.CompactTextString(m) }
func (*AdminChangeReplicasResponse) ProtoMessage()    {}
func (*AdminChangeReplicasResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{39}
}
func (m *AdminChangeReplicasResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdminChangeReplicasResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AdminChangeReplicasResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminChangeReplicasResponse.Merge(dst, src)
}
func (m *AdminChangeReplicasResponse) XXX_Size() int {
	return m.Size()
}
func (m *AdminChangeReplicasResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminChangeReplicasResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AdminChangeReplicasResponse proto.InternalMessageInfo

// An AdminRelocateRangeRequest is the argument to the AdminRelocateRange()
// method. Relocates the replicas for a range to the specified target stores.
// The first store in the list of targets becomes the new leaseholder.
type AdminRelocateRangeRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Targets              []ReplicationTarget `protobuf:"bytes,2,rep,name=targets,proto3" json:"targets"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *AdminRelocateRangeRequest) Reset()         { *m = AdminRelocateRangeRequest{} }
func (m *AdminRelocateRangeRequest) String() string { return proto.CompactTextString(m) }
func (*AdminRelocateRangeRequest) ProtoMessage()    {}
func (*AdminRelocateRangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{40}
}
func (m *AdminRelocateRangeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdminRelocateRangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AdminRelocateRangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminRelocateRangeRequest.Merge(dst, src)
}
func (m *AdminRelocateRangeRequest) XXX_Size() int {
	return m.Size()
}
func (m *AdminRelocateRangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminRelocateRangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AdminRelocateRangeRequest proto.InternalMessageInfo

type AdminRelocateRangeResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdminRelocateRangeResponse) Reset()         { *m = AdminRelocateRangeResponse{} }
func (m *AdminRelocateRangeResponse) String() string { return proto.CompactTextString(m) }
func (*AdminRelocateRangeResponse) ProtoMessage()    {}
func (*AdminRelocateRangeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{41}
}
func (m *AdminRelocateRangeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdminRelocateRangeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AdminRelocateRangeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminRelocateRangeResponse.Merge(dst, src)
}
func (m *AdminRelocateRangeResponse) XXX_Size() int {
	return m.Size()
}
func (m *AdminRelocateRangeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminRelocateRangeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AdminRelocateRangeResponse proto.InternalMessageInfo

// A HeartbeatTxnRequest is arguments to the HeartbeatTxn()
// method. It's sent by transaction coordinators to let the system
// know that the transaction is still ongoing. Note that this
// heartbeat message is different from the heartbeat message in the
// gossip protocol.
type HeartbeatTxnRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Now                  hlc.Timestamp `protobuf:"bytes,2,opt,name=now,proto3" json:"now"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *HeartbeatTxnRequest) Reset()         { *m = HeartbeatTxnRequest{} }
func (m *HeartbeatTxnRequest) String() string { return proto.CompactTextString(m) }
func (*HeartbeatTxnRequest) ProtoMessage()    {}
func (*HeartbeatTxnRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{42}
}
func (m *HeartbeatTxnRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HeartbeatTxnRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *HeartbeatTxnRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HeartbeatTxnRequest.Merge(dst, src)
}
func (m *HeartbeatTxnRequest) XXX_Size() int {
	return m.Size()
}
func (m *HeartbeatTxnRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HeartbeatTxnRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HeartbeatTxnRequest proto.InternalMessageInfo

// A HeartbeatTxnResponse is the return value from the HeartbeatTxn()
// method. It returns the transaction info in the response header. The
// returned transaction lets the coordinator know the disposition of
// the transaction (i.e. aborted, committed, or pending).
type HeartbeatTxnResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HeartbeatTxnResponse) Reset()         { *m = HeartbeatTxnResponse{} }
func (m *HeartbeatTxnResponse) String() string { return proto.CompactTextString(m) }
func (*HeartbeatTxnResponse) ProtoMessage()    {}
func (*HeartbeatTxnResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{43}
}
func (m *HeartbeatTxnResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HeartbeatTxnResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *HeartbeatTxnResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HeartbeatTxnResponse.Merge(dst, src)
}
func (m *HeartbeatTxnResponse) XXX_Size() int {
	return m.Size()
}
func (m *HeartbeatTxnResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_HeartbeatTxnResponse.DiscardUnknown(m)
}

var xxx_messageInfo_HeartbeatTxnResponse proto.InternalMessageInfo

// A GCRequest is arguments to the GC() method. It's sent by range
// lease holders after scanning range data to find expired MVCC values.
type GCRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Keys          []GCRequest_GCKey `protobuf:"bytes,3,rep,name=keys,proto3" json:"keys"`
	// Threshold is the expiration timestamp.
	Threshold hlc.Timestamp `protobuf:"bytes,4,opt,name=threshold,proto3" json:"threshold"`
	// TxnSpanGCThreshold is the timestamp below which inactive transactions were
	// considered for GC (and thus might have been removed).
	// TODO(nvanbenschoten): Remove this in 2.3, at which point we won't need to
	// update it because no nodes in the cluster will ever consult it.
	TxnSpanGCThreshold   hlc.Timestamp `protobuf:"bytes,5,opt,name=txn_span_gc_threshold,json=txnSpanGcThreshold,proto3" json:"txn_span_gc_threshold"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *GCRequest) Reset()         { *m = GCRequest{} }
func (m *GCRequest) String() string { return proto.CompactTextString(m) }
func (*GCRequest) ProtoMessage()    {}
func (*GCRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{44}
}
func (m *GCRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GCRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *GCRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GCRequest.Merge(dst, src)
}
func (m *GCRequest) XXX_Size() int {
	return m.Size()
}
func (m *GCRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GCRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GCRequest proto.InternalMessageInfo

type GCRequest_GCKey struct {
	Key                  Key           `protobuf:"bytes,1,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	Timestamp            hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *GCRequest_GCKey) Reset()         { *m = GCRequest_GCKey{} }
func (m *GCRequest_GCKey) String() string { return proto.CompactTextString(m) }
func (*GCRequest_GCKey) ProtoMessage()    {}
func (*GCRequest_GCKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{44, 0}
}
func (m *GCRequest_GCKey) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GCRequest_GCKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *GCRequest_GCKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GCRequest_GCKey.Merge(dst, src)
}
func (m *GCRequest_GCKey) XXX_Size() int {
	return m.Size()
}
func (m *GCRequest_GCKey) XXX_DiscardUnknown() {
	xxx_messageInfo_GCRequest_GCKey.DiscardUnknown(m)
}

var xxx_messageInfo_GCRequest_GCKey proto.InternalMessageInfo

// A GCResponse is the return value from the GC() method.
type GCResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GCResponse) Reset()         { *m = GCResponse{} }
func (m *GCResponse) String() string { return proto.CompactTextString(m) }
func (*GCResponse) ProtoMessage()    {}
func (*GCResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{45}
}
func (m *GCResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GCResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *GCResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GCResponse.Merge(dst, src)
}
func (m *GCResponse) XXX_Size() int {
	return m.Size()
}
func (m *GCResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GCResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GCResponse proto.InternalMessageInfo

// A PushTxnRequest is arguments to the PushTxn() method. It's sent by
// readers or writers which have encountered an "intent" laid down by
// another transaction. The goal is to resolve the conflict. Note that
// args.Key should be set to the txn ID of args.PusheeTxn, not
// args.PusherTxn. This RPC is addressed to the range which owns the pushee's
// txn record.
//
// Resolution is trivial if the txn which owns the intent has either
// been committed or aborted already. Otherwise, the existing txn can
// either be aborted (for write/write conflicts), or its commit
// timestamp can be moved forward (for read/write conflicts). The
// course of action is determined by the specified push type, and by
// the owning txn's status and priority.
type PushTxnRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// Transaction which encountered the intent, if applicable. For a
	// non-transactional pusher, pusher_txn will only have the priority set (in
	// particular, ID won't be set). Used to compare priorities and timestamps if
	// priorities are equal.
	PusherTxn Transaction `protobuf:"bytes,2,opt,name=pusher_txn,json=pusherTxn,proto3" json:"pusher_txn"`
	// Transaction to be pushed, as specified at the intent which led to
	// the push transaction request. Note that this may not be the most
	// up-to-date value of the transaction record, but will be set or
	// merged as appropriate.
	PusheeTxn enginepb.TxnMeta `protobuf:"bytes,3,opt,name=pushee_txn,json=pusheeTxn,proto3" json:"pushee_txn"`
	// PushTo is the timestamp which PusheeTxn should be pushed to. During
	// conflict resolution, it should be set just after the timestamp of the
	// conflicting read or write.
	PushTo hlc.Timestamp `protobuf:"bytes,4,opt,name=push_to,json=pushTo,proto3" json:"push_to"`
	// InclusivePushTo is sent by nodes to specify that their PushTo timestamp
	// is the timestamp they want the transaction to be pushed to, instead of
	// the timestamp before the one they want the transaction to be pushed to.
	// It is used to assist that field's migration.
	// TODO(nvanbenschoten): Remove this field in 19.2.
	InclusivePushTo bool `protobuf:"varint,9,opt,name=inclusive_push_to,json=inclusivePushTo,proto3" json:"inclusive_push_to,omitempty"`
	// DeprecatedNow holds the timestamp used to compare the last heartbeat of the
	// pushee against.
	//
	// The field remains for compatibility with 2.1 nodes. Users should set the
	// same value for this field and the batch header timestamp.
	// TODO(nvanbenschoten): Remove this field in 19.2.
	DeprecatedNow hlc.Timestamp `protobuf:"bytes,5,opt,name=deprecated_now,json=deprecatedNow,proto3" json:"deprecated_now"`
	// Readers set this to PUSH_TIMESTAMP to move pushee_txn's provisional
	// commit timestamp forward. Writers set this to PUSH_ABORT to request
	// that pushee_txn be aborted if possible. Inconsistent readers set
	// this to PUSH_TOUCH to determine whether the pushee can be aborted
	// due to inactivity (based on the now field).
	PushType PushTxnType `protobuf:"varint,6,opt,name=push_type,json=pushType,proto3,enum=cockroach.roachpb.PushTxnType" json:"push_type,omitempty"`
	// Forces the push by overriding the normal expiration and priority checks
	// in PushTxn to either abort or push the timestamp.
	Force                bool     `protobuf:"varint,7,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PushTxnRequest) Reset()         { *m = PushTxnRequest{} }
func (m *PushTxnRequest) String() string { return proto.CompactTextString(m) }
func (*PushTxnRequest) ProtoMessage()    {}
func (*PushTxnRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{46}
}
func (m *PushTxnRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PushTxnRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *PushTxnRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushTxnRequest.Merge(dst, src)
}
func (m *PushTxnRequest) XXX_Size() int {
	return m.Size()
}
func (m *PushTxnRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PushTxnRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PushTxnRequest proto.InternalMessageInfo

// A PushTxnResponse is the return value from the PushTxn() method. It
// returns success and the resulting state of PusheeTxn if the
// conflict was resolved in favor of the caller; the caller should
// subsequently invoke ResolveIntent() on the conflicted key. It
// returns an error otherwise.
type PushTxnResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// pushee_txn is non-nil if the transaction was pushed and contains
	// the current value of the transaction.
	// TODO(tschottdorf): Maybe this can be a TxnMeta instead; probably requires
	// factoring out the new Priority.
	PusheeTxn            Transaction `protobuf:"bytes,2,opt,name=pushee_txn,json=pusheeTxn,proto3" json:"pushee_txn"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *PushTxnResponse) Reset()         { *m = PushTxnResponse{} }
func (m *PushTxnResponse) String() string { return proto.CompactTextString(m) }
func (*PushTxnResponse) ProtoMessage()    {}
func (*PushTxnResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{47}
}
func (m *PushTxnResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PushTxnResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *PushTxnResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PushTxnResponse.Merge(dst, src)
}
func (m *PushTxnResponse) XXX_Size() int {
	return m.Size()
}
func (m *PushTxnResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PushTxnResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PushTxnResponse proto.InternalMessageInfo

// A QueryTxnResponse is arguments to the QueryTxn() method. It's sent
// by transactions which are waiting to push another transaction because
// of conflicting write intents to fetch updates to either the pusher's
// or the pushee's transaction records.
type QueryTxnRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// Transaction record to query.
	Txn enginepb.TxnMeta `protobuf:"bytes,2,opt,name=txn,proto3" json:"txn"`
	// If true, the query will not return until there are changes to either the
	// transaction status or priority -OR- to the set of dependent transactions.
	WaitForUpdate bool `protobuf:"varint,3,opt,name=wait_for_update,json=waitForUpdate,proto3" json:"wait_for_update,omitempty"`
	// Set of known dependent transactions.
	KnownWaitingTxns     []github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,4,rep,name=known_waiting_txns,json=knownWaitingTxns,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"known_waiting_txns,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                              `json:"-"`
	XXX_sizecache        int32                                                 `json:"-"`
}

func (m *QueryTxnRequest) Reset()         { *m = QueryTxnRequest{} }
func (m *QueryTxnRequest) String() string { return proto.CompactTextString(m) }
func (*QueryTxnRequest) ProtoMessage()    {}
func (*QueryTxnRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{48}
}
func (m *QueryTxnRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryTxnRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *QueryTxnRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryTxnRequest.Merge(dst, src)
}
func (m *QueryTxnRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryTxnRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryTxnRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryTxnRequest proto.InternalMessageInfo

// A QueryTxnResponse is the return value from the QueryTxn() method.
type QueryTxnResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// Contains the current state of the queried transaction. If the queried
	// transaction record does not exist, this will be empty.
	QueriedTxn Transaction `protobuf:"bytes,2,opt,name=queried_txn,json=queriedTxn,proto3" json:"queried_txn"`
	// Specifies a list of transaction IDs which are waiting on the txn.
	WaitingTxns          []github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,3,rep,name=waiting_txns,json=waitingTxns,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"waiting_txns,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                              `json:"-"`
	XXX_sizecache        int32                                                 `json:"-"`
}

func (m *QueryTxnResponse) Reset()         { *m = QueryTxnResponse{} }
func (m *QueryTxnResponse) String() string { return proto.CompactTextString(m) }
func (*QueryTxnResponse) ProtoMessage()    {}
func (*QueryTxnResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{49}
}
func (m *QueryTxnResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryTxnResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *QueryTxnResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryTxnResponse.Merge(dst, src)
}
func (m *QueryTxnResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryTxnResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryTxnResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryTxnResponse proto.InternalMessageInfo

// A QueryIntentRequest is arguments to the QueryIntent() method. It visits
// the specified key and checks whether an intent is present for the given
// transaction.
type QueryIntentRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// The TxnMeta that the intent is expected to have. Specifically, whether an
	// intent is a match or not is defined as whether an intent exists that could
	// be committed by the provided transaction. If an intent is found at the
	// specified key, the intent is only considered a match if it has the same ID,
	// the same epoch, and a provisional commit timestamp that is equal to or less
	// than that in the provided transaction. For SERIALIZABLE transactions, if
	// the intent's timestamp is greater than that in the provided transaction, it
	// would prevent the transaction from committing and is therefore not a match.
	// However, for SNAPSHOT transactions, if the intent's timestamp is greater
	// than that in the provided transaction, it would not prevent the transaction
	// from committing and therefore is a match.
	//
	// Additionally, the intent is only considered a match if its sequence number
	// is equal to or greater than the expected txn's sequence number. The
	// requests doesn't require an exact sequence number match because the
	// transaction could have performed overlapping writes, in which case only the
	// latest sequence number will remain. We assume that if a transaction has
	// successfully written an intent at a larger sequence number then it must
	// have succeeeded in writing an intent at the smaller sequence number as
	// well.
	Txn enginepb.TxnMeta `protobuf:"bytes,2,opt,name=txn,proto3" json:"txn"`
	// The behavior of the request if the expected intent is found to be not
	// present.
	IfMissing            QueryIntentRequest_IfMissingBehavior `protobuf:"varint,3,opt,name=if_missing,json=ifMissing,proto3,enum=cockroach.roachpb.QueryIntentRequest_IfMissingBehavior" json:"if_missing,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *QueryIntentRequest) Reset()         { *m = QueryIntentRequest{} }
func (m *QueryIntentRequest) String() string { return proto.CompactTextString(m) }
func (*QueryIntentRequest) ProtoMessage()    {}
func (*QueryIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{50}
}
func (m *QueryIntentRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *QueryIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryIntentRequest.Merge(dst, src)
}
func (m *QueryIntentRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryIntentRequest proto.InternalMessageInfo

// A QueryIntentResponse is the return value from the QueryIntent() method.
type QueryIntentResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// Whether an intent matching the expected transaction was found at the key.
	FoundIntent          bool     `protobuf:"varint,2,opt,name=found_intent,json=foundIntent,proto3" json:"found_intent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryIntentResponse) Reset()         { *m = QueryIntentResponse{} }
func (m *QueryIntentResponse) String() string { return proto.CompactTextString(m) }
func (*QueryIntentResponse) ProtoMessage()    {}
func (*QueryIntentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{51}
}
func (m *QueryIntentResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryIntentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *QueryIntentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryIntentResponse.Merge(dst, src)
}
func (m *QueryIntentResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryIntentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryIntentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryIntentResponse proto.InternalMessageInfo

// A ResolveIntentRequest is arguments to the ResolveIntent()
// method. It is sent by transaction coordinators after success
// calling PushTxn to clean up write intents: either to remove, commit
// or move them forward in time.
type ResolveIntentRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// The transaction whose intent is being resolved.
	IntentTxn enginepb.TxnMeta `protobuf:"bytes,2,opt,name=intent_txn,json=intentTxn,proto3" json:"intent_txn"`
	// The status of the transaction.
	Status TransactionStatus `protobuf:"varint,3,opt,name=status,proto3,enum=cockroach.roachpb.TransactionStatus" json:"status,omitempty"`
	// Optionally poison the abort span for the transaction the intent's
	// range.
	Poison               bool     `protobuf:"varint,4,opt,name=poison,proto3" json:"poison,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResolveIntentRequest) Reset()         { *m = ResolveIntentRequest{} }
func (m *ResolveIntentRequest) String() string { return proto.CompactTextString(m) }
func (*ResolveIntentRequest) ProtoMessage()    {}
func (*ResolveIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{52}
}
func (m *ResolveIntentRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResolveIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ResolveIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResolveIntentRequest.Merge(dst, src)
}
func (m *ResolveIntentRequest) XXX_Size() int {
	return m.Size()
}
func (m *ResolveIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResolveIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResolveIntentRequest proto.InternalMessageInfo

// A ResolveIntentResponse is the return value from the
// ResolveIntent() method.
type ResolveIntentResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResolveIntentResponse) Reset()         { *m = ResolveIntentResponse{} }
func (m *ResolveIntentResponse) String() string { return proto.CompactTextString(m) }
func (*ResolveIntentResponse) ProtoMessage()    {}
func (*ResolveIntentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{53}
}
func (m *ResolveIntentResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResolveIntentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ResolveIntentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResolveIntentResponse.Merge(dst, src)
}
func (m *ResolveIntentResponse) XXX_Size() int {
	return m.Size()
}
func (m *ResolveIntentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ResolveIntentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ResolveIntentResponse proto.InternalMessageInfo

// A ResolveIntentRangeRequest is arguments to the ResolveIntentRange() method.
// It is sent by transaction coordinators after success calling PushTxn to
// clean up write intents: either to remove, commit or move them forward in
// time.
type ResolveIntentRangeRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// The transaction whose intents are being resolved.
	IntentTxn enginepb.TxnMeta `protobuf:"bytes,2,opt,name=intent_txn,json=intentTxn,proto3" json:"intent_txn"`
	// The status of the transaction.
	Status TransactionStatus `protobuf:"varint,3,opt,name=status,proto3,enum=cockroach.roachpb.TransactionStatus" json:"status,omitempty"`
	// Optionally poison the abort span for the transaction on all ranges
	// on which the intents reside.
	Poison bool `protobuf:"varint,4,opt,name=poison,proto3" json:"poison,omitempty"`
	// The minimum timestamp for any intents written by this
	// transaction. If present, this value can be used to optimize the
	// iteration over the span to find intents to resolve.
	MinTimestamp         hlc.Timestamp `protobuf:"bytes,5,opt,name=min_timestamp,json=minTimestamp,proto3" json:"min_timestamp"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ResolveIntentRangeRequest) Reset()         { *m = ResolveIntentRangeRequest{} }
func (m *ResolveIntentRangeRequest) String() string { return proto.CompactTextString(m) }
func (*ResolveIntentRangeRequest) ProtoMessage()    {}
func (*ResolveIntentRangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{54}
}
func (m *ResolveIntentRangeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResolveIntentRangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ResolveIntentRangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResolveIntentRangeRequest.Merge(dst, src)
}
func (m *ResolveIntentRangeRequest) XXX_Size() int {
	return m.Size()
}
func (m *ResolveIntentRangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResolveIntentRangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResolveIntentRangeRequest proto.InternalMessageInfo

// A ResolveIntentRangeResponse is the return value from the
// ResolveIntent() method.
type ResolveIntentRangeResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResolveIntentRangeResponse) Reset()         { *m = ResolveIntentRangeResponse{} }
func (m *ResolveIntentRangeResponse) String() string { return proto.CompactTextString(m) }
func (*ResolveIntentRangeResponse) ProtoMessage()    {}
func (*ResolveIntentRangeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{55}
}
func (m *ResolveIntentRangeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResolveIntentRangeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ResolveIntentRangeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResolveIntentRangeResponse.Merge(dst, src)
}
func (m *ResolveIntentRangeResponse) XXX_Size() int {
	return m.Size()
}
func (m *ResolveIntentRangeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ResolveIntentRangeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ResolveIntentRangeResponse proto.InternalMessageInfo

// A MergeRequest contains arguments to the Merge() method. It
// specifies a key and a value which should be merged into the
// existing value at that key.
type MergeRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Value                Value    `protobuf:"bytes,2,opt,name=value,proto3" json:"value"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MergeRequest) Reset()         { *m = MergeRequest{} }
func (m *MergeRequest) String() string { return proto.CompactTextString(m) }
func (*MergeRequest) ProtoMessage()    {}
func (*MergeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{56}
}
func (m *MergeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MergeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MergeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeRequest.Merge(dst, src)
}
func (m *MergeRequest) XXX_Size() int {
	return m.Size()
}
func (m *MergeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MergeRequest proto.InternalMessageInfo

// MergeResponse is the response to a Merge() operation.
type MergeResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MergeResponse) Reset()         { *m = MergeResponse{} }
func (m *MergeResponse) String() string { return proto.CompactTextString(m) }
func (*MergeResponse) ProtoMessage()    {}
func (*MergeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{57}
}
func (m *MergeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MergeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MergeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeResponse.Merge(dst, src)
}
func (m *MergeResponse) XXX_Size() int {
	return m.Size()
}
func (m *MergeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MergeResponse proto.InternalMessageInfo

// TruncateLogRequest is used to remove a prefix of the raft log. While there
// is no requirement for correctness that the raft log truncation be synchronized across
// replicas, it is nice to preserve the property that all replicas of a range are as close
// to identical as possible. The raft leader can also inform decisions about the cutoff point
// with its knowledge of the replicas' acknowledgment status.
type TruncateLogRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// Log entries < this index are to be discarded.
	Index uint64 `protobuf:"varint,2,opt,name=index,proto3" json:"index,omitempty"`
	// RangeID is used to double check that the correct range is being truncated.
	// The header specifies a span, start and end keys, but not the range id
	// itself. The range may have changed from the one specified in the header
	// in the case of a merge.
	RangeID              RangeID  `protobuf:"varint,3,opt,name=range_id,json=rangeId,proto3,casttype=RangeID" json:"range_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TruncateLogRequest) Reset()         { *m = TruncateLogRequest{} }
func (m *TruncateLogRequest) String() string { return proto.CompactTextString(m) }
func (*TruncateLogRequest) ProtoMessage()    {}
func (*TruncateLogRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{58}
}
func (m *TruncateLogRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TruncateLogRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TruncateLogRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TruncateLogRequest.Merge(dst, src)
}
func (m *TruncateLogRequest) XXX_Size() int {
	return m.Size()
}
func (m *TruncateLogRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TruncateLogRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TruncateLogRequest proto.InternalMessageInfo

// TruncateLogResponse is the response to a TruncateLog() operation.
type TruncateLogResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TruncateLogResponse) Reset()         { *m = TruncateLogResponse{} }
func (m *TruncateLogResponse) String() string { return proto.CompactTextString(m) }
func (*TruncateLogResponse) ProtoMessage()    {}
func (*TruncateLogResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{59}
}
func (m *TruncateLogResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TruncateLogResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TruncateLogResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TruncateLogResponse.Merge(dst, src)
}
func (m *TruncateLogResponse) XXX_Size() int {
	return m.Size()
}
func (m *TruncateLogResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TruncateLogResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TruncateLogResponse proto.InternalMessageInfo

// A RequestLeaseRequest is arguments to the RequestLease()
// method. It is sent by the store on behalf of one of its ranges upon receipt
// of a command requiring a lease when none is found.
type RequestLeaseRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Lease         Lease `protobuf:"bytes,2,opt,name=lease,proto3" json:"lease"`
	// The previous lease is specified by the caller to verify
	// it has not changed when executing this command.
	PrevLease Lease `protobuf:"bytes,3,opt,name=prev_lease,json=prevLease,proto3" json:"prev_lease"`
	// The MinLeaseProposedTS of the proposing replica to make sure that leases
	// issued after a node restart receive a new sequence number (instead of
	// counting as a lease extension). See #23204.
	MinProposedTS        *hlc.Timestamp `protobuf:"bytes,4,opt,name=min_proposed_ts,json=minProposedTs,proto3" json:"min_proposed_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RequestLeaseRequest) Reset()         { *m = RequestLeaseRequest{} }
func (m *RequestLeaseRequest) String() string { return proto.CompactTextString(m) }
func (*RequestLeaseRequest) ProtoMessage()    {}
func (*RequestLeaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{60}
}
func (m *RequestLeaseRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestLeaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RequestLeaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestLeaseRequest.Merge(dst, src)
}
func (m *RequestLeaseRequest) XXX_Size() int {
	return m.Size()
}
func (m *RequestLeaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestLeaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RequestLeaseRequest proto.InternalMessageInfo

// A TransferLeaseRequest represents the arguments to the TransferLease()
// method. It is sent by a replica that currently holds the range lease and
// wants to transfer it away.
//
// Like a RequestLeaseRequest, this request has the effect of instituting a new
// lease. The difference is that the new lease is allowed to overlap the
// existing one. It is a separate request because the RequestLeaseRequest is
// special - it's not subject to the same replay protection restrictions as
// other requests, instead being protected from replays by the fact that leases
// are not generally allowed to overlap. The TransferLeaseRequest is not
// special in this respect (for example, the proposer of this command is
// checked to have been holding the lease when the proposal was made).
type TransferLeaseRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Lease         Lease `protobuf:"bytes,2,opt,name=lease,proto3" json:"lease"`
	// The previous lease is specified by the caller to verify
	// it has not changed when executing this command.
	PrevLease            Lease    `protobuf:"bytes,3,opt,name=prev_lease,json=prevLease,proto3" json:"prev_lease"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TransferLeaseRequest) Reset()         { *m = TransferLeaseRequest{} }
func (m *TransferLeaseRequest) String() string { return proto.CompactTextString(m) }
func (*TransferLeaseRequest) ProtoMessage()    {}
func (*TransferLeaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{61}
}
func (m *TransferLeaseRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TransferLeaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TransferLeaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransferLeaseRequest.Merge(dst, src)
}
func (m *TransferLeaseRequest) XXX_Size() int {
	return m.Size()
}
func (m *TransferLeaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TransferLeaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TransferLeaseRequest proto.InternalMessageInfo

// LeaseInfoRequest is the argument to the LeaseInfo() method, for getting
// information about a range's lease.
// It's a point request, so it addresses one single range, and returns the lease
// currently in effect for that range.
type LeaseInfoRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LeaseInfoRequest) Reset()         { *m = LeaseInfoRequest{} }
func (m *LeaseInfoRequest) String() string { return proto.CompactTextString(m) }
func (*LeaseInfoRequest) ProtoMessage()    {}
func (*LeaseInfoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{62}
}
func (m *LeaseInfoRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LeaseInfoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *LeaseInfoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LeaseInfoRequest.Merge(dst, src)
}
func (m *LeaseInfoRequest) XXX_Size() int {
	return m.Size()
}
func (m *LeaseInfoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LeaseInfoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LeaseInfoRequest proto.InternalMessageInfo

// LeaseInfoResponse is the response to a LeaseInfo() operation.
type LeaseInfoResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// The last lease known by the replica serving the request. It can also be the
	// tentative future lease, if a lease transfer is in progress.
	Lease                Lease    `protobuf:"bytes,2,opt,name=lease,proto3" json:"lease"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LeaseInfoResponse) Reset()         { *m = LeaseInfoResponse{} }
func (m *LeaseInfoResponse) String() string { return proto.CompactTextString(m) }
func (*LeaseInfoResponse) ProtoMessage()    {}
func (*LeaseInfoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{63}
}
func (m *LeaseInfoResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LeaseInfoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *LeaseInfoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LeaseInfoResponse.Merge(dst, src)
}
func (m *LeaseInfoResponse) XXX_Size() int {
	return m.Size()
}
func (m *LeaseInfoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LeaseInfoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LeaseInfoResponse proto.InternalMessageInfo

// A RequestLeaseResponse is the response to a RequestLease() or TransferLease()
// operation.
type RequestLeaseResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RequestLeaseResponse) Reset()         { *m = RequestLeaseResponse{} }
func (m *RequestLeaseResponse) String() string { return proto.CompactTextString(m) }
func (*RequestLeaseResponse) ProtoMessage()    {}
func (*RequestLeaseResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{64}
}
func (m *RequestLeaseResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestLeaseResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RequestLeaseResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestLeaseResponse.Merge(dst, src)
}
func (m *RequestLeaseResponse) XXX_Size() int {
	return m.Size()
}
func (m *RequestLeaseResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestLeaseResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RequestLeaseResponse proto.InternalMessageInfo

// A ComputeChecksumRequest is arguments to the ComputeChecksum() method, to
// start computing the checksum for the specified range at the snapshot for this
// request command. A response is returned without the checksum. The computed
// checksum is retrieved via a storage.CollectChecksumRequest.
type ComputeChecksumRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// The version used to pick the checksum method. It allows us to use a
	// consistent checksumming method across replicas.
	Version uint32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	// Compute a checksum along with a snapshot of the entire range, that will be
	// used in logging a diff during checksum verification.
	Snapshot bool `protobuf:"varint,4,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
	// The type of checksum to compute. See ChecksumMode.
	Mode ChecksumMode `protobuf:"varint,5,opt,name=mode,proto3,enum=cockroach.roachpb.ChecksumMode" json:"mode,omitempty"`
	// If set, a checkpoint (i.e. cheap backup) of the engine will be taken. This
	// is expected to be set only if we already know that there is a problem and
	// we want to preserve as much state as possible. The checkpoint will be stored
	// in the engine's auxiliary directory.
	Checkpoint           bool     `protobuf:"varint,6,opt,name=checkpoint,proto3" json:"checkpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ComputeChecksumRequest) Reset()         { *m = ComputeChecksumRequest{} }
func (m *ComputeChecksumRequest) String() string { return proto.CompactTextString(m) }
func (*ComputeChecksumRequest) ProtoMessage()    {}
func (*ComputeChecksumRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{65}
}
func (m *ComputeChecksumRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ComputeChecksumRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ComputeChecksumRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComputeChecksumRequest.Merge(dst, src)
}
func (m *ComputeChecksumRequest) XXX_Size() int {
	return m.Size()
}
func (m *ComputeChecksumRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ComputeChecksumRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ComputeChecksumRequest proto.InternalMessageInfo

// A ComputeChecksumResponse is the response to a ComputeChecksum() operation.
type ComputeChecksumResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// ChecksumID is the unique identifier that can be used to get the computed
	// checksum in a future storage.CollectChecksumRequest.
	ChecksumID           github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,2,opt,name=checksum_id,json=checksumId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"checksum_id"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *ComputeChecksumResponse) Reset()         { *m = ComputeChecksumResponse{} }
func (m *ComputeChecksumResponse) String() string { return proto.CompactTextString(m) }
func (*ComputeChecksumResponse) ProtoMessage()    {}
func (*ComputeChecksumResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{66}
}
func (m *ComputeChecksumResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ComputeChecksumResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ComputeChecksumResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComputeChecksumResponse.Merge(dst, src)
}
func (m *ComputeChecksumResponse) XXX_Size() int {
	return m.Size()
}
func (m *ComputeChecksumResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ComputeChecksumResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ComputeChecksumResponse proto.InternalMessageInfo

type ExportStorage struct {
	Provider             ExportStorageProvider       `protobuf:"varint,1,opt,name=provider,proto3,enum=cockroach.roachpb.ExportStorageProvider" json:"provider,omitempty"`
	LocalFile            ExportStorage_LocalFilePath `protobuf:"bytes,2,opt,name=LocalFile,proto3" json:"LocalFile"`
	HttpPath             ExportStorage_Http          `protobuf:"bytes,3,opt,name=HttpPath,proto3" json:"HttpPath"`
	GoogleCloudConfig    *ExportStorage_GCS          `protobuf:"bytes,4,opt,name=GoogleCloudConfig,proto3" json:"GoogleCloudConfig,omitempty"`
	S3Config             *ExportStorage_S3           `protobuf:"bytes,5,opt,name=S3Config,proto3" json:"S3Config,omitempty"`
	AzureConfig          *ExportStorage_Azure        `protobuf:"bytes,6,opt,name=AzureConfig,proto3" json:"AzureConfig,omitempty"`
	WorkloadConfig       *ExportStorage_Workload     `protobuf:"bytes,7,opt,name=WorkloadConfig,proto3" json:"WorkloadConfig,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *ExportStorage) Reset()         { *m = ExportStorage{} }
func (m *ExportStorage) String() string { return proto.CompactTextString(m) }
func (*ExportStorage) ProtoMessage()    {}
func (*ExportStorage) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{67}
}
func (m *ExportStorage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExportStorage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ExportStorage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportStorage.Merge(dst, src)
}
func (m *ExportStorage) XXX_Size() int {
	return m.Size()
}
func (m *ExportStorage) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportStorage.DiscardUnknown(m)
}

var xxx_messageInfo_ExportStorage proto.InternalMessageInfo

type ExportStorage_LocalFilePath struct {
	Path                 string   `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	NodeID               NodeID   `protobuf:"varint,2,opt,name=node_id,json=nodeId,proto3,casttype=NodeID" json:"node_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportStorage_LocalFilePath) Reset()         { *m = ExportStorage_LocalFilePath{} }
func (m *ExportStorage_LocalFilePath) String() string { return proto.CompactTextString(m) }
func (*ExportStorage_LocalFilePath) ProtoMessage()    {}
func (*ExportStorage_LocalFilePath) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{67, 0}
}
func (m *ExportStorage_LocalFilePath) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExportStorage_LocalFilePath) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ExportStorage_LocalFilePath) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportStorage_LocalFilePath.Merge(dst, src)
}
func (m *ExportStorage_LocalFilePath) XXX_Size() int {
	return m.Size()
}
func (m *ExportStorage_LocalFilePath) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportStorage_LocalFilePath.DiscardUnknown(m)
}

var xxx_messageInfo_ExportStorage_LocalFilePath proto.InternalMessageInfo

type ExportStorage_Http struct {
	BaseUri              string   `protobuf:"bytes,1,opt,name=baseUri,proto3" json:"baseUri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportStorage_Http) Reset()         { *m = ExportStorage_Http{} }
func (m *ExportStorage_Http) String() string { return proto.CompactTextString(m) }
func (*ExportStorage_Http) ProtoMessage()    {}
func (*ExportStorage_Http) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{67, 1}
}
func (m *ExportStorage_Http) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExportStorage_Http) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ExportStorage_Http) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportStorage_Http.Merge(dst, src)
}
func (m *ExportStorage_Http) XXX_Size() int {
	return m.Size()
}
func (m *ExportStorage_Http) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportStorage_Http.DiscardUnknown(m)
}

var xxx_messageInfo_ExportStorage_Http proto.InternalMessageInfo

type ExportStorage_S3 struct {
	Bucket               string   `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	Prefix               string   `protobuf:"bytes,2,opt,name=prefix,proto3" json:"prefix,omitempty"`
	AccessKey            string   `protobuf:"bytes,3,opt,name=access_key,json=accessKey,proto3" json:"access_key,omitempty"`
	Secret               string   `protobuf:"bytes,4,opt,name=secret,proto3" json:"secret,omitempty"`
	TempToken            string   `protobuf:"bytes,5,opt,name=temp_token,json=tempToken,proto3" json:"temp_token,omitempty"`
	Endpoint             string   `protobuf:"bytes,6,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Region               string   `protobuf:"bytes,7,opt,name=region,proto3" json:"region,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportStorage_S3) Reset()         { *m = ExportStorage_S3{} }
func (m *ExportStorage_S3) String() string { return proto.CompactTextString(m) }
func (*ExportStorage_S3) ProtoMessage()    {}
func (*ExportStorage_S3) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{67, 2}
}
func (m *ExportStorage_S3) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExportStorage_S3) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ExportStorage_S3) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportStorage_S3.Merge(dst, src)
}
func (m *ExportStorage_S3) XXX_Size() int {
	return m.Size()
}
func (m *ExportStorage_S3) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportStorage_S3.DiscardUnknown(m)
}

var xxx_messageInfo_ExportStorage_S3 proto.InternalMessageInfo

type ExportStorage_GCS struct {
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	Prefix string `protobuf:"bytes,2,opt,name=prefix,proto3" json:"prefix,omitempty"`
	Auth   string `protobuf:"bytes,3,opt,name=auth,proto3" json:"auth,omitempty"`
	// BillingProject if non-empty, is the Google Cloud project to bill for all storage requests.
	// This is required to be set if using a "requestor pays" bucket.
	BillingProject       string   `protobuf:"bytes,4,opt,name=billing_project,json=billingProject,proto3" json:"billing_project,omitempty"`
	Credentials          string   `protobuf:"bytes,5,opt,name=credentials,proto3" json:"credentials,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportStorage_GCS) Reset()         { *m = ExportStorage_GCS{} }
func (m *ExportStorage_GCS) String() string { return proto.CompactTextString(m) }
func (*ExportStorage_GCS) ProtoMessage()    {}
func (*ExportStorage_GCS) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{67, 3}
}
func (m *ExportStorage_GCS) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExportStorage_GCS) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ExportStorage_GCS) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportStorage_GCS.Merge(dst, src)
}
func (m *ExportStorage_GCS) XXX_Size() int {
	return m.Size()
}
func (m *ExportStorage_GCS) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportStorage_GCS.DiscardUnknown(m)
}

var xxx_messageInfo_ExportStorage_GCS proto.InternalMessageInfo

type ExportStorage_Azure struct {
	Container            string   `protobuf:"bytes,1,opt,name=container,proto3" json:"container,omitempty"`
	Prefix               string   `protobuf:"bytes,2,opt,name=prefix,proto3" json:"prefix,omitempty"`
	AccountName          string   `protobuf:"bytes,3,opt,name=account_name,json=accountName,proto3" json:"account_name,omitempty"`
	AccountKey           string   `protobuf:"bytes,4,opt,name=account_key,json=accountKey,proto3" json:"account_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportStorage_Azure) Reset()         { *m = ExportStorage_Azure{} }
func (m *ExportStorage_Azure) String() string { return proto.CompactTextString(m) }
func (*ExportStorage_Azure) ProtoMessage()    {}
func (*ExportStorage_Azure) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{67, 4}
}
func (m *ExportStorage_Azure) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExportStorage_Azure) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ExportStorage_Azure) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportStorage_Azure.Merge(dst, src)
}
func (m *ExportStorage_Azure) XXX_Size() int {
	return m.Size()
}
func (m *ExportStorage_Azure) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportStorage_Azure.DiscardUnknown(m)
}

var xxx_messageInfo_ExportStorage_Azure proto.InternalMessageInfo

type ExportStorage_Workload struct {
	Generator            string   `protobuf:"bytes,1,opt,name=generator,proto3" json:"generator,omitempty"`
	Version              string   `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Table                string   `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	Flags                []string `protobuf:"bytes,4,rep,name=flags,proto3" json:"flags,omitempty"`
	Format               string   `protobuf:"bytes,5,opt,name=format,proto3" json:"format,omitempty"`
	BatchBegin           int64    `protobuf:"varint,6,opt,name=batch_begin,json=batchBegin,proto3" json:"batch_begin,omitempty"`
	BatchEnd             int64    `protobuf:"varint,7,opt,name=batch_end,json=batchEnd,proto3" json:"batch_end,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportStorage_Workload) Reset()         { *m = ExportStorage_Workload{} }
func (m *ExportStorage_Workload) String() string { return proto.CompactTextString(m) }
func (*ExportStorage_Workload) ProtoMessage()    {}
func (*ExportStorage_Workload) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{67, 5}
}
func (m *ExportStorage_Workload) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExportStorage_Workload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ExportStorage_Workload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportStorage_Workload.Merge(dst, src)
}
func (m *ExportStorage_Workload) XXX_Size() int {
	return m.Size()
}
func (m *ExportStorage_Workload) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportStorage_Workload.DiscardUnknown(m)
}

var xxx_messageInfo_ExportStorage_Workload proto.InternalMessageInfo

// WriteBatchRequest is arguments to the WriteBatch() method, to apply the
// operations encoded in a BatchRepr.
type WriteBatchRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// The span of keys encoded in data, duplicated because the header span can
	// be modified by DistSender and we use this one to fail fast.
	DataSpan Span `protobuf:"bytes,2,opt,name=data_span,json=dataSpan,proto3" json:"data_span"`
	// A BatchRepr, the serialized form of a RocksDB Batch.
	Data                 []byte   `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WriteBatchRequest) Reset()         { *m = WriteBatchRequest{} }
func (m *WriteBatchRequest) String() string { return proto.CompactTextString(m) }
func (*WriteBatchRequest) ProtoMessage()    {}
func (*WriteBatchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{68}
}
func (m *WriteBatchRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WriteBatchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *WriteBatchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteBatchRequest.Merge(dst, src)
}
func (m *WriteBatchRequest) XXX_Size() int {
	return m.Size()
}
func (m *WriteBatchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteBatchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WriteBatchRequest proto.InternalMessageInfo

// WriteBatchResponse is the response to a WriteBatch() operation.
type WriteBatchResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WriteBatchResponse) Reset()         { *m = WriteBatchResponse{} }
func (m *WriteBatchResponse) String() string { return proto.CompactTextString(m) }
func (*WriteBatchResponse) ProtoMessage()    {}
func (*WriteBatchResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{69}
}
func (m *WriteBatchResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WriteBatchResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *WriteBatchResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteBatchResponse.Merge(dst, src)
}
func (m *WriteBatchResponse) XXX_Size() int {
	return m.Size()
}
func (m *WriteBatchResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteBatchResponse.DiscardUnknown(m)
}

var xxx_messageInfo_WriteBatchResponse proto.InternalMessageInfo

// ExportRequest is the argument to the Export() method, to dump a keyrange into
// files under a basepath.
type ExportRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Storage       ExportStorage `protobuf:"bytes,2,opt,name=storage,proto3" json:"storage"`
	StartTime     hlc.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time"`
	MVCCFilter    MVCCFilter    `protobuf:"varint,4,opt,name=mvcc_filter,json=mvccFilter,proto3,enum=cockroach.roachpb.MVCCFilter" json:"mvcc_filter,omitempty"`
	// Return the exported SST data in the response.
	ReturnSST bool `protobuf:"varint,5,opt,name=return_sst,json=returnSst,proto3" json:"return_sst,omitempty"`
	// OmitChecksum, if true, will skip checksumming the sst and leave the
	// `Sha512` field empty in the response. During a rolling upgrade to 2.1, it
	// may still be set if the request is served by an old node, but since the
	// caller has declare they're not going to use it, that's okay.
	OmitChecksum bool `protobuf:"varint,6,opt,name=omit_checksum,json=omitChecksum,proto3" json:"omit_checksum,omitempty"`
	// EnableTimeBoundIteratorOptimization, if true, enables a performance
	// optimization that allows us to entirely skip over sstables in RocksDB that
	// don't have data relevant to the time bounds in this request.
	//
	// This can have a dramatic impact on performance, but we've seen a number of
	// extremely subtle and hard to detect correctness issues with this (see
	// #28358 #34819). As a result, we've decided to skip the optimization
	// everywhere that it isn't absolutely necessary for the feature to work
	// (leaving one place: poller-based changefeeds, which are being phased out
	// anyway). This will both give increased confidence in correctness as well as
	// eliminate any need to investigate time-bound iterators when/if someone hits
	// a correctness bug.
	EnableTimeBoundIteratorOptimization bool     `protobuf:"varint,7,opt,name=enable_time_bound_iterator_optimization,json=enableTimeBoundIteratorOptimization,proto3" json:"enable_time_bound_iterator_optimization,omitempty"`
	XXX_NoUnkeyedLiteral                struct{} `json:"-"`
	XXX_sizecache                       int32    `json:"-"`
}

func (m *ExportRequest) Reset()         { *m = ExportRequest{} }
func (m *ExportRequest) String() string { return proto.CompactTextString(m) }
func (*ExportRequest) ProtoMessage()    {}
func (*ExportRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{70}
}
func (m *ExportRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExportRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ExportRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportRequest.Merge(dst, src)
}
func (m *ExportRequest) XXX_Size() int {
	return m.Size()
}
func (m *ExportRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportRequest proto.InternalMessageInfo

type BulkOpSummary struct {
	DataSize             int64    `protobuf:"varint,1,opt,name=data_size,json=dataSize,proto3" json:"data_size,omitempty"`
	Rows                 int64    `protobuf:"varint,2,opt,name=rows,proto3" json:"rows,omitempty"`
	IndexEntries         int64    `protobuf:"varint,3,opt,name=index_entries,json=indexEntries,proto3" json:"index_entries,omitempty"`
	SystemRecords        int64    `protobuf:"varint,4,opt,name=system_records,json=systemRecords,proto3" json:"system_records,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BulkOpSummary) Reset()         { *m = BulkOpSummary{} }
func (m *BulkOpSummary) String() string { return proto.CompactTextString(m) }
func (*BulkOpSummary) ProtoMessage()    {}
func (*BulkOpSummary) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{71}
}
func (m *BulkOpSummary) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BulkOpSummary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *BulkOpSummary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BulkOpSummary.Merge(dst, src)
}
func (m *BulkOpSummary) XXX_Size() int {
	return m.Size()
}
func (m *BulkOpSummary) XXX_DiscardUnknown() {
	xxx_messageInfo_BulkOpSummary.DiscardUnknown(m)
}

var xxx_messageInfo_BulkOpSummary proto.InternalMessageInfo

// ExportResponse is the response to an Export() operation.
type ExportResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Files                []ExportResponse_File `protobuf:"bytes,2,rep,name=files,proto3" json:"files"`
	StartTime            hlc.Timestamp         `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExportResponse) Reset()         { *m = ExportResponse{} }
func (m *ExportResponse) String() string { return proto.CompactTextString(m) }
func (*ExportResponse) ProtoMessage()    {}
func (*ExportResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{72}
}
func (m *ExportResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExportResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ExportResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportResponse.Merge(dst, src)
}
func (m *ExportResponse) XXX_Size() int {
	return m.Size()
}
func (m *ExportResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExportResponse proto.InternalMessageInfo

// File describes a keyrange that has been dumped to a file at the given
// path.
type ExportResponse_File struct {
	Span                 Span          `protobuf:"bytes,1,opt,name=span,proto3" json:"span"`
	Path                 string        `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	Sha512               []byte        `protobuf:"bytes,5,opt,name=sha512,proto3" json:"sha512,omitempty"`
	Exported             BulkOpSummary `protobuf:"bytes,6,opt,name=exported,proto3" json:"exported"`
	SST                  []byte        `protobuf:"bytes,7,opt,name=sst,proto3" json:"sst,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportResponse_File) Reset()         { *m = ExportResponse_File{} }
func (m *ExportResponse_File) String() string { return proto.CompactTextString(m) }
func (*ExportResponse_File) ProtoMessage()    {}
func (*ExportResponse_File) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{72, 0}
}
func (m *ExportResponse_File) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExportResponse_File) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ExportResponse_File) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportResponse_File.Merge(dst, src)
}
func (m *ExportResponse_File) XXX_Size() int {
	return m.Size()
}
func (m *ExportResponse_File) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportResponse_File.DiscardUnknown(m)
}

var xxx_messageInfo_ExportResponse_File proto.InternalMessageInfo

// ImportRequest is the argument to the Import() method, to bulk load key/value
// entries.
type ImportRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// Files contains an ordered list of files, each containing kv entries to
	// import. Entries in later files with the same key override earlier ones.
	Files []ImportRequest_File `protobuf:"bytes,2,rep,name=files,proto3" json:"files"`
	// DataSpan is the pre-rewrite keyrange of the data in `Files`.
	DataSpan Span `protobuf:"bytes,3,opt,name=data_span,json=dataSpan,proto3" json:"data_span"`
	// EndTime, if not the zero value, will cause only entries before it to be
	// imported.
	EndTime hlc.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time"`
	// Rekeys contains the descriptors for the data being Imported and the
	// previous ID for each (which is the ID used in the source data pointed to by
	// `files`).
	// TODO(dan): This field is a superset of the information represented by
	// `key_rewrites` and will supercede it once rekeying of interleaved tables is
	// fixed.
	Rekeys               []ImportRequest_TableRekey `protobuf:"bytes,5,rep,name=rekeys,proto3" json:"rekeys"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ImportRequest) Reset()         { *m = ImportRequest{} }
func (m *ImportRequest) String() string { return proto.CompactTextString(m) }
func (*ImportRequest) ProtoMessage()    {}
func (*ImportRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{73}
}
func (m *ImportRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImportRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ImportRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportRequest.Merge(dst, src)
}
func (m *ImportRequest) XXX_Size() int {
	return m.Size()
}
func (m *ImportRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportRequest proto.InternalMessageInfo

type ImportRequest_File struct {
	Dir                  ExportStorage `protobuf:"bytes,1,opt,name=dir,proto3" json:"dir"`
	Path                 string        `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	Sha512               []byte        `protobuf:"bytes,4,opt,name=sha512,proto3" json:"sha512,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ImportRequest_File) Reset()         { *m = ImportRequest_File{} }
func (m *ImportRequest_File) String() string { return proto.CompactTextString(m) }
func (*ImportRequest_File) ProtoMessage()    {}
func (*ImportRequest_File) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{73, 0}
}
func (m *ImportRequest_File) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImportRequest_File) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ImportRequest_File) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportRequest_File.Merge(dst, src)
}
func (m *ImportRequest_File) XXX_Size() int {
	return m.Size()
}
func (m *ImportRequest_File) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportRequest_File.DiscardUnknown(m)
}

var xxx_messageInfo_ImportRequest_File proto.InternalMessageInfo

type ImportRequest_TableRekey struct {
	// OldID is the previous ID of `new_desc`.
	OldID uint32 `protobuf:"varint,1,opt,name=old_id,json=oldId,proto3" json:"old_id,omitempty"`
	// NewDesc is an encoded Descriptor message.
	NewDesc              []byte   `protobuf:"bytes,2,opt,name=new_desc,json=newDesc,proto3" json:"new_desc,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportRequest_TableRekey) Reset()         { *m = ImportRequest_TableRekey{} }
func (m *ImportRequest_TableRekey) String() string { return proto.CompactTextString(m) }
func (*ImportRequest_TableRekey) ProtoMessage()    {}
func (*ImportRequest_TableRekey) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{73, 1}
}
func (m *ImportRequest_TableRekey) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImportRequest_TableRekey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ImportRequest_TableRekey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportRequest_TableRekey.Merge(dst, src)
}
func (m *ImportRequest_TableRekey) XXX_Size() int {
	return m.Size()
}
func (m *ImportRequest_TableRekey) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportRequest_TableRekey.DiscardUnknown(m)
}

var xxx_messageInfo_ImportRequest_TableRekey proto.InternalMessageInfo

// ImportResponse is the response to a Import() operation.
type ImportResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Imported             BulkOpSummary `protobuf:"bytes,3,opt,name=imported,proto3" json:"imported"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ImportResponse) Reset()         { *m = ImportResponse{} }
func (m *ImportResponse) String() string { return proto.CompactTextString(m) }
func (*ImportResponse) ProtoMessage()    {}
func (*ImportResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{74}
}
func (m *ImportResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImportResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ImportResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportResponse.Merge(dst, src)
}
func (m *ImportResponse) XXX_Size() int {
	return m.Size()
}
func (m *ImportResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ImportResponse proto.InternalMessageInfo

// AdminScatterRequest is the argument to the AdminScatter() method, which moves
// replicas and leaseholders for a selection of ranges. Scatter is best-effort;
// ranges that cannot be moved will include an error detail in the response and
// won't fail the request.
type AdminScatterRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	RandomizeLeases      bool     `protobuf:"varint,2,opt,name=randomize_leases,json=randomizeLeases,proto3" json:"randomize_leases,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdminScatterRequest) Reset()         { *m = AdminScatterRequest{} }
func (m *AdminScatterRequest) String() string { return proto.CompactTextString(m) }
func (*AdminScatterRequest) ProtoMessage()    {}
func (*AdminScatterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{75}
}
func (m *AdminScatterRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdminScatterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AdminScatterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminScatterRequest.Merge(dst, src)
}
func (m *AdminScatterRequest) XXX_Size() int {
	return m.Size()
}
func (m *AdminScatterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminScatterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AdminScatterRequest proto.InternalMessageInfo

// ScatterResponse is the response to a Scatter() operation.
type AdminScatterResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Ranges               []AdminScatterResponse_Range `protobuf:"bytes,2,rep,name=ranges,proto3" json:"ranges"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *AdminScatterResponse) Reset()         { *m = AdminScatterResponse{} }
func (m *AdminScatterResponse) String() string { return proto.CompactTextString(m) }
func (*AdminScatterResponse) ProtoMessage()    {}
func (*AdminScatterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{76}
}
func (m *AdminScatterResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdminScatterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AdminScatterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminScatterResponse.Merge(dst, src)
}
func (m *AdminScatterResponse) XXX_Size() int {
	return m.Size()
}
func (m *AdminScatterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminScatterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AdminScatterResponse proto.InternalMessageInfo

type AdminScatterResponse_Range struct {
	Span                 Span     `protobuf:"bytes,1,opt,name=span,proto3" json:"span"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdminScatterResponse_Range) Reset()         { *m = AdminScatterResponse_Range{} }
func (m *AdminScatterResponse_Range) String() string { return proto.CompactTextString(m) }
func (*AdminScatterResponse_Range) ProtoMessage()    {}
func (*AdminScatterResponse_Range) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{76, 0}
}
func (m *AdminScatterResponse_Range) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AdminScatterResponse_Range) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AdminScatterResponse_Range) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdminScatterResponse_Range.Merge(dst, src)
}
func (m *AdminScatterResponse_Range) XXX_Size() int {
	return m.Size()
}
func (m *AdminScatterResponse_Range) XXX_DiscardUnknown() {
	xxx_messageInfo_AdminScatterResponse_Range.DiscardUnknown(m)
}

var xxx_messageInfo_AdminScatterResponse_Range proto.InternalMessageInfo

// AddSSTableRequest is arguments to the AddSSTable() method, to link a file
// into the RocksDB log-structured merge-tree.
type AddSSTableRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddSSTableRequest) Reset()         { *m = AddSSTableRequest{} }
func (m *AddSSTableRequest) String() string { return proto.CompactTextString(m) }
func (*AddSSTableRequest) ProtoMessage()    {}
func (*AddSSTableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{77}
}
func (m *AddSSTableRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddSSTableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AddSSTableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddSSTableRequest.Merge(dst, src)
}
func (m *AddSSTableRequest) XXX_Size() int {
	return m.Size()
}
func (m *AddSSTableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddSSTableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddSSTableRequest proto.InternalMessageInfo

// AddSSTableResponse is the response to a AddSSTable() operation.
type AddSSTableResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddSSTableResponse) Reset()         { *m = AddSSTableResponse{} }
func (m *AddSSTableResponse) String() string { return proto.CompactTextString(m) }
func (*AddSSTableResponse) ProtoMessage()    {}
func (*AddSSTableResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{78}
}
func (m *AddSSTableResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddSSTableResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AddSSTableResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddSSTableResponse.Merge(dst, src)
}
func (m *AddSSTableResponse) XXX_Size() int {
	return m.Size()
}
func (m *AddSSTableResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddSSTableResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddSSTableResponse proto.InternalMessageInfo

// RefreshRequest is arguments to the Refresh() method, which verifies
// that no write has occurred since the transaction's orig timestamp
// to the specified key. Either the read or write timestamp cache is
// updated according to the write parameter. A transaction must be
// supplied with this request. If the key has been written more
// recently than the original txn timestamp, an error is returned
// and the timestamp cache is not updated.
type RefreshRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// If set, indicates that the write timestamp cache should be
	// updated. This handles the case of DeleteRange, which must set the
	// write too old flag on transactions which attempt earlier writes.
	Write                bool     `protobuf:"varint,2,opt,name=write,proto3" json:"write,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RefreshRequest) Reset()         { *m = RefreshRequest{} }
func (m *RefreshRequest) String() string { return proto.CompactTextString(m) }
func (*RefreshRequest) ProtoMessage()    {}
func (*RefreshRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{79}
}
func (m *RefreshRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RefreshRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RefreshRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshRequest.Merge(dst, src)
}
func (m *RefreshRequest) XXX_Size() int {
	return m.Size()
}
func (m *RefreshRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshRequest proto.InternalMessageInfo

// RefreshResponse is the response to a Refresh() operation.
type RefreshResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RefreshResponse) Reset()         { *m = RefreshResponse{} }
func (m *RefreshResponse) String() string { return proto.CompactTextString(m) }
func (*RefreshResponse) ProtoMessage()    {}
func (*RefreshResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{80}
}
func (m *RefreshResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RefreshResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RefreshResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshResponse.Merge(dst, src)
}
func (m *RefreshResponse) XXX_Size() int {
	return m.Size()
}
func (m *RefreshResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshResponse proto.InternalMessageInfo

// RefreshRangeRequest is arguments to the RefreshRange() method, which
// is similar to RefreshRequest (see comments above), but operates on
// a key span instead of a single key.
type RefreshRangeRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// If set, indicates that the write timestamp cache should be
	// updated. This handles the case of DeleteRange, which must set the
	// write too old flag on transactions which attempt earlier writes.
	Write                bool     `protobuf:"varint,2,opt,name=write,proto3" json:"write,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RefreshRangeRequest) Reset()         { *m = RefreshRangeRequest{} }
func (m *RefreshRangeRequest) String() string { return proto.CompactTextString(m) }
func (*RefreshRangeRequest) ProtoMessage()    {}
func (*RefreshRangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{81}
}
func (m *RefreshRangeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RefreshRangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RefreshRangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshRangeRequest.Merge(dst, src)
}
func (m *RefreshRangeRequest) XXX_Size() int {
	return m.Size()
}
func (m *RefreshRangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshRangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshRangeRequest proto.InternalMessageInfo

// RefreshRangeResponse is the response to a RefreshRange() operation.
type RefreshRangeResponse struct {
	ResponseHeader       `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RefreshRangeResponse) Reset()         { *m = RefreshRangeResponse{} }
func (m *RefreshRangeResponse) String() string { return proto.CompactTextString(m) }
func (*RefreshRangeResponse) ProtoMessage()    {}
func (*RefreshRangeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{82}
}
func (m *RefreshRangeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RefreshRangeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RefreshRangeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RefreshRangeResponse.Merge(dst, src)
}
func (m *RefreshRangeResponse) XXX_Size() int {
	return m.Size()
}
func (m *RefreshRangeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RefreshRangeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RefreshRangeResponse proto.InternalMessageInfo

// SubsumeRequest is the argument to the Subsume() method, which freezes a range
// for merging with its left-hand neighbor.
//
// Subsume, when called correctly, provides important guarantees that ensure
// there is no moment in time where the ranges involved in the merge could both
// process commands for the same keys. See the comment on Subsume for details.
//
// Subsume may return stale MVCC statistics when used outside of a merge
// transaction. As a rule of thumb, it is incorrect to call Subsume, except from
// its carefully-chosen location within a merge transaction.
type SubsumeRequest struct {
	RequestHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// The range descriptor for the left-hand side of the merge. Used by the
	// right-hand side to sanity-check the validity of the merge.
	LeftRange            RangeDescriptor `protobuf:"bytes,2,opt,name=left_range,json=leftRange,proto3" json:"left_range"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *SubsumeRequest) Reset()         { *m = SubsumeRequest{} }
func (m *SubsumeRequest) String() string { return proto.CompactTextString(m) }
func (*SubsumeRequest) ProtoMessage()    {}
func (*SubsumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{83}
}
func (m *SubsumeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SubsumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *SubsumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubsumeRequest.Merge(dst, src)
}
func (m *SubsumeRequest) XXX_Size() int {
	return m.Size()
}
func (m *SubsumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SubsumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SubsumeRequest proto.InternalMessageInfo

// SubsumeResponse is the response to a SubsumeRequest.
type SubsumeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// MVCCStats are the MVCC statistics for the range.
	MVCCStats enginepb.MVCCStats `protobuf:"bytes,3,opt,name=mvcc_stats,json=mvccStats,proto3" json:"mvcc_stats"`
	// LeaseAppliedIndex is the lease index of the last applied command at the
	// time that the Subsume request executed.
	LeaseAppliedIndex uint64 `protobuf:"varint,4,opt,name=lease_applied_index,json=leaseAppliedIndex,proto3" json:"lease_applied_index,omitempty"`
	// FreezeStart is a timestamp that is guaranteed to be greater than the
	// timestamps at which any requests were serviced by the responding replica
	// before it stopped responding to requests altogether (in anticipation of
	// being subsumed). It is suitable for use as the timestamp cache's low water
	// mark for the keys previously owned by the subsumed range.
	FreezeStart          hlc.Timestamp `protobuf:"bytes,5,opt,name=freeze_start,json=freezeStart,proto3" json:"freeze_start"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *SubsumeResponse) Reset()         { *m = SubsumeResponse{} }
func (m *SubsumeResponse) String() string { return proto.CompactTextString(m) }
func (*SubsumeResponse) ProtoMessage()    {}
func (*SubsumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{84}
}
func (m *SubsumeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SubsumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *SubsumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubsumeResponse.Merge(dst, src)
}
func (m *SubsumeResponse) XXX_Size() int {
	return m.Size()
}
func (m *SubsumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SubsumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SubsumeResponse proto.InternalMessageInfo

// RangeStatsRequest is the argument to the RangeStats() method. It requests the
// MVCC statistics of the receiving range.
type RangeStatsRequest struct {
	RequestHeader        `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RangeStatsRequest) Reset()         { *m = RangeStatsRequest{} }
func (m *RangeStatsRequest) String() string { return proto.CompactTextString(m) }
func (*RangeStatsRequest) ProtoMessage()    {}
func (*RangeStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{85}
}
func (m *RangeStatsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeStatsRequest.Merge(dst, src)
}
func (m *RangeStatsRequest) XXX_Size() int {
	return m.Size()
}
func (m *RangeStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RangeStatsRequest proto.InternalMessageInfo

// RangeStatsResponse is the response to a RangeStatsRequest.
type RangeStatsResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	// MVCCStats are the MVCC statistics for the range that processed the
	// request.
	MVCCStats enginepb.MVCCStats `protobuf:"bytes,2,opt,name=mvcc_stats,json=mvccStats,proto3" json:"mvcc_stats"`
	// QueriesPerSecond is the rate of request/s or QPS for the range.
	QueriesPerSecond     float64  `protobuf:"fixed64,3,opt,name=queries_per_second,json=queriesPerSecond,proto3" json:"queries_per_second,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RangeStatsResponse) Reset()         { *m = RangeStatsResponse{} }
func (m *RangeStatsResponse) String() string { return proto.CompactTextString(m) }
func (*RangeStatsResponse) ProtoMessage()    {}
func (*RangeStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{86}
}
func (m *RangeStatsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeStatsResponse.Merge(dst, src)
}
func (m *RangeStatsResponse) XXX_Size() int {
	return m.Size()
}
func (m *RangeStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RangeStatsResponse proto.InternalMessageInfo

// A RequestUnion contains exactly one of the requests.
// The values added here must match those in ResponseUnion.
//
// Be cautious about deprecating fields as doing so can lead to inconsistencies
// between replicas.
type RequestUnion struct {
	// Types that are valid to be assigned to Value:
	//	*RequestUnion_Get
	//	*RequestUnion_Put
	//	*RequestUnion_ConditionalPut
	//	*RequestUnion_Increment
	//	*RequestUnion_Delete
	//	*RequestUnion_DeleteRange
	//	*RequestUnion_ClearRange
	//	*RequestUnion_Scan
	//	*RequestUnion_BeginTransaction
	//	*RequestUnion_EndTransaction
	//	*RequestUnion_AdminSplit
	//	*RequestUnion_AdminMerge
	//	*RequestUnion_AdminTransferLease
	//	*RequestUnion_AdminChangeReplicas
	//	*RequestUnion_AdminRelocateRange
	//	*RequestUnion_HeartbeatTxn
	//	*RequestUnion_Gc
	//	*RequestUnion_PushTxn
	//	*RequestUnion_ResolveIntent
	//	*RequestUnion_ResolveIntentRange
	//	*RequestUnion_Merge
	//	*RequestUnion_TruncateLog
	//	*RequestUnion_RequestLease
	//	*RequestUnion_ReverseScan
	//	*RequestUnion_ComputeChecksum
	//	*RequestUnion_CheckConsistency
	//	*RequestUnion_InitPut
	//	*RequestUnion_TransferLease
	//	*RequestUnion_LeaseInfo
	//	*RequestUnion_WriteBatch
	//	*RequestUnion_Export
	//	*RequestUnion_Import
	//	*RequestUnion_QueryTxn
	//	*RequestUnion_QueryIntent
	//	*RequestUnion_AdminScatter
	//	*RequestUnion_AddSstable
	//	*RequestUnion_RecomputeStats
	//	*RequestUnion_Refresh
	//	*RequestUnion_RefreshRange
	//	*RequestUnion_Subsume
	//	*RequestUnion_RangeStats
	Value                isRequestUnion_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *RequestUnion) Reset()         { *m = RequestUnion{} }
func (m *RequestUnion) String() string { return proto.CompactTextString(m) }
func (*RequestUnion) ProtoMessage()    {}
func (*RequestUnion) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{87}
}
func (m *RequestUnion) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RequestUnion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RequestUnion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestUnion.Merge(dst, src)
}
func (m *RequestUnion) XXX_Size() int {
	return m.Size()
}
func (m *RequestUnion) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestUnion.DiscardUnknown(m)
}

var xxx_messageInfo_RequestUnion proto.InternalMessageInfo

type isRequestUnion_Value interface {
	isRequestUnion_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type RequestUnion_Get struct {
	Get *GetRequest `protobuf:"bytes,1,opt,name=get,proto3,oneof"`
}
type RequestUnion_Put struct {
	Put *PutRequest `protobuf:"bytes,2,opt,name=put,proto3,oneof"`
}
type RequestUnion_ConditionalPut struct {
	ConditionalPut *ConditionalPutRequest `protobuf:"bytes,3,opt,name=conditional_put,json=conditionalPut,proto3,oneof"`
}
type RequestUnion_Increment struct {
	Increment *IncrementRequest `protobuf:"bytes,4,opt,name=increment,proto3,oneof"`
}
type RequestUnion_Delete struct {
	Delete *DeleteRequest `protobuf:"bytes,5,opt,name=delete,proto3,oneof"`
}
type RequestUnion_DeleteRange struct {
	DeleteRange *DeleteRangeRequest `protobuf:"bytes,6,opt,name=delete_range,json=deleteRange,proto3,oneof"`
}
type RequestUnion_ClearRange struct {
	ClearRange *ClearRangeRequest `protobuf:"bytes,38,opt,name=clear_range,json=clearRange,proto3,oneof"`
}
type RequestUnion_Scan struct {
	Scan *ScanRequest `protobuf:"bytes,7,opt,name=scan,proto3,oneof"`
}
type RequestUnion_BeginTransaction struct {
	BeginTransaction *BeginTransactionRequest `protobuf:"bytes,8,opt,name=begin_transaction,json=beginTransaction,proto3,oneof"`
}
type RequestUnion_EndTransaction struct {
	EndTransaction *EndTransactionRequest `protobuf:"bytes,9,opt,name=end_transaction,json=endTransaction,proto3,oneof"`
}
type RequestUnion_AdminSplit struct {
	AdminSplit *AdminSplitRequest `protobuf:"bytes,10,opt,name=admin_split,json=adminSplit,proto3,oneof"`
}
type RequestUnion_AdminMerge struct {
	AdminMerge *AdminMergeRequest `protobuf:"bytes,11,opt,name=admin_merge,json=adminMerge,proto3,oneof"`
}
type RequestUnion_AdminTransferLease struct {
	AdminTransferLease *AdminTransferLeaseRequest `protobuf:"bytes,29,opt,name=admin_transfer_lease,json=adminTransferLease,proto3,oneof"`
}
type RequestUnion_AdminChangeReplicas struct {
	AdminChangeReplicas *AdminChangeReplicasRequest `protobuf:"bytes,35,opt,name=admin_change_replicas,json=adminChangeReplicas,proto3,oneof"`
}
type RequestUnion_AdminRelocateRange struct {
	AdminRelocateRange *AdminRelocateRangeRequest `protobuf:"bytes,45,opt,name=admin_relocate_range,json=adminRelocateRange,proto3,oneof"`
}
type RequestUnion_HeartbeatTxn struct {
	HeartbeatTxn *HeartbeatTxnRequest `protobuf:"bytes,12,opt,name=heartbeat_txn,json=heartbeatTxn,proto3,oneof"`
}
type RequestUnion_Gc struct {
	Gc *GCRequest `protobuf:"bytes,13,opt,name=gc,proto3,oneof"`
}
type RequestUnion_PushTxn struct {
	PushTxn *PushTxnRequest `protobuf:"bytes,14,opt,name=push_txn,json=pushTxn,proto3,oneof"`
}
type RequestUnion_ResolveIntent struct {
	ResolveIntent *ResolveIntentRequest `protobuf:"bytes,16,opt,name=resolve_intent,json=resolveIntent,proto3,oneof"`
}
type RequestUnion_ResolveIntentRange struct {
	ResolveIntentRange *ResolveIntentRangeRequest `protobuf:"bytes,17,opt,name=resolve_intent_range,json=resolveIntentRange,proto3,oneof"`
}
type RequestUnion_Merge struct {
	Merge *MergeRequest `protobuf:"bytes,18,opt,name=merge,proto3,oneof"`
}
type RequestUnion_TruncateLog struct {
	TruncateLog *TruncateLogRequest `protobuf:"bytes,19,opt,name=truncate_log,json=truncateLog,proto3,oneof"`
}
type RequestUnion_RequestLease struct {
	RequestLease *RequestLeaseRequest `protobuf:"bytes,20,opt,name=request_lease,json=requestLease,proto3,oneof"`
}
type RequestUnion_ReverseScan struct {
	ReverseScan *ReverseScanRequest `protobuf:"bytes,21,opt,name=reverse_scan,json=reverseScan,proto3,oneof"`
}
type RequestUnion_ComputeChecksum struct {
	ComputeChecksum *ComputeChecksumRequest `protobuf:"bytes,22,opt,name=compute_checksum,json=computeChecksum,proto3,oneof"`
}
type RequestUnion_CheckConsistency struct {
	CheckConsistency *CheckConsistencyRequest `protobuf:"bytes,24,opt,name=check_consistency,json=checkConsistency,proto3,oneof"`
}
type RequestUnion_InitPut struct {
	InitPut *InitPutRequest `protobuf:"bytes,26,opt,name=init_put,json=initPut,proto3,oneof"`
}
type RequestUnion_TransferLease struct {
	TransferLease *TransferLeaseRequest `protobuf:"bytes,28,opt,name=transfer_lease,json=transferLease,proto3,oneof"`
}
type RequestUnion_LeaseInfo struct {
	LeaseInfo *LeaseInfoRequest `protobuf:"bytes,30,opt,name=lease_info,json=leaseInfo,proto3,oneof"`
}
type RequestUnion_WriteBatch struct {
	WriteBatch *WriteBatchRequest `protobuf:"bytes,31,opt,name=write_batch,json=writeBatch,proto3,oneof"`
}
type RequestUnion_Export struct {
	Export *ExportRequest `protobuf:"bytes,32,opt,name=export,proto3,oneof"`
}
type RequestUnion_Import struct {
	Import *ImportRequest `protobuf:"bytes,34,opt,name=import,proto3,oneof"`
}
type RequestUnion_QueryTxn struct {
	QueryTxn *QueryTxnRequest `protobuf:"bytes,33,opt,name=query_txn,json=queryTxn,proto3,oneof"`
}
type RequestUnion_QueryIntent struct {
	QueryIntent *QueryIntentRequest `protobuf:"bytes,42,opt,name=query_intent,json=queryIntent,proto3,oneof"`
}
type RequestUnion_AdminScatter struct {
	AdminScatter *AdminScatterRequest `protobuf:"bytes,36,opt,name=admin_scatter,json=adminScatter,proto3,oneof"`
}
type RequestUnion_AddSstable struct {
	AddSstable *AddSSTableRequest `protobuf:"bytes,37,opt,name=add_sstable,json=addSstable,proto3,oneof"`
}
type RequestUnion_RecomputeStats struct {
	RecomputeStats *RecomputeStatsRequest `protobuf:"bytes,39,opt,name=recompute_stats,json=recomputeStats,proto3,oneof"`
}
type RequestUnion_Refresh struct {
	Refresh *RefreshRequest `protobuf:"bytes,40,opt,name=refresh,proto3,oneof"`
}
type RequestUnion_RefreshRange struct {
	RefreshRange *RefreshRangeRequest `protobuf:"bytes,41,opt,name=refresh_range,json=refreshRange,proto3,oneof"`
}
type RequestUnion_Subsume struct {
	Subsume *SubsumeRequest `protobuf:"bytes,43,opt,name=subsume,proto3,oneof"`
}
type RequestUnion_RangeStats struct {
	RangeStats *RangeStatsRequest `protobuf:"bytes,44,opt,name=range_stats,json=rangeStats,proto3,oneof"`
}

func (*RequestUnion_Get) isRequestUnion_Value()                 {}
func (*RequestUnion_Put) isRequestUnion_Value()                 {}
func (*RequestUnion_ConditionalPut) isRequestUnion_Value()      {}
func (*RequestUnion_Increment) isRequestUnion_Value()           {}
func (*RequestUnion_Delete) isRequestUnion_Value()              {}
func (*RequestUnion_DeleteRange) isRequestUnion_Value()         {}
func (*RequestUnion_ClearRange) isRequestUnion_Value()          {}
func (*RequestUnion_Scan) isRequestUnion_Value()                {}
func (*RequestUnion_BeginTransaction) isRequestUnion_Value()    {}
func (*RequestUnion_EndTransaction) isRequestUnion_Value()      {}
func (*RequestUnion_AdminSplit) isRequestUnion_Value()          {}
func (*RequestUnion_AdminMerge) isRequestUnion_Value()          {}
func (*RequestUnion_AdminTransferLease) isRequestUnion_Value()  {}
func (*RequestUnion_AdminChangeReplicas) isRequestUnion_Value() {}
func (*RequestUnion_AdminRelocateRange) isRequestUnion_Value()  {}
func (*RequestUnion_HeartbeatTxn) isRequestUnion_Value()        {}
func (*RequestUnion_Gc) isRequestUnion_Value()                  {}
func (*RequestUnion_PushTxn) isRequestUnion_Value()             {}
func (*RequestUnion_ResolveIntent) isRequestUnion_Value()       {}
func (*RequestUnion_ResolveIntentRange) isRequestUnion_Value()  {}
func (*RequestUnion_Merge) isRequestUnion_Value()               {}
func (*RequestUnion_TruncateLog) isRequestUnion_Value()         {}
func (*RequestUnion_RequestLease) isRequestUnion_Value()        {}
func (*RequestUnion_ReverseScan) isRequestUnion_Value()         {}
func (*RequestUnion_ComputeChecksum) isRequestUnion_Value()     {}
func (*RequestUnion_CheckConsistency) isRequestUnion_Value()    {}
func (*RequestUnion_InitPut) isRequestUnion_Value()             {}
func (*RequestUnion_TransferLease) isRequestUnion_Value()       {}
func (*RequestUnion_LeaseInfo) isRequestUnion_Value()           {}
func (*RequestUnion_WriteBatch) isRequestUnion_Value()          {}
func (*RequestUnion_Export) isRequestUnion_Value()              {}
func (*RequestUnion_Import) isRequestUnion_Value()              {}
func (*RequestUnion_QueryTxn) isRequestUnion_Value()            {}
func (*RequestUnion_QueryIntent) isRequestUnion_Value()         {}
func (*RequestUnion_AdminScatter) isRequestUnion_Value()        {}
func (*RequestUnion_AddSstable) isRequestUnion_Value()          {}
func (*RequestUnion_RecomputeStats) isRequestUnion_Value()      {}
func (*RequestUnion_Refresh) isRequestUnion_Value()             {}
func (*RequestUnion_RefreshRange) isRequestUnion_Value()        {}
func (*RequestUnion_Subsume) isRequestUnion_Value()             {}
func (*RequestUnion_RangeStats) isRequestUnion_Value()          {}

func (m *RequestUnion) GetValue() isRequestUnion_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *RequestUnion) GetGet() *GetRequest {
	if x, ok := m.GetValue().(*RequestUnion_Get); ok {
		return x.Get
	}
	return nil
}

func (m *RequestUnion) GetPut() *PutRequest {
	if x, ok := m.GetValue().(*RequestUnion_Put); ok {
		return x.Put
	}
	return nil
}

func (m *RequestUnion) GetConditionalPut() *ConditionalPutRequest {
	if x, ok := m.GetValue().(*RequestUnion_ConditionalPut); ok {
		return x.ConditionalPut
	}
	return nil
}

func (m *RequestUnion) GetIncrement() *IncrementRequest {
	if x, ok := m.GetValue().(*RequestUnion_Increment); ok {
		return x.Increment
	}
	return nil
}

func (m *RequestUnion) GetDelete() *DeleteRequest {
	if x, ok := m.GetValue().(*RequestUnion_Delete); ok {
		return x.Delete
	}
	return nil
}

func (m *RequestUnion) GetDeleteRange() *DeleteRangeRequest {
	if x, ok := m.GetValue().(*RequestUnion_DeleteRange); ok {
		return x.DeleteRange
	}
	return nil
}

func (m *RequestUnion) GetClearRange() *ClearRangeRequest {
	if x, ok := m.GetValue().(*RequestUnion_ClearRange); ok {
		return x.ClearRange
	}
	return nil
}

func (m *RequestUnion) GetScan() *ScanRequest {
	if x, ok := m.GetValue().(*RequestUnion_Scan); ok {
		return x.Scan
	}
	return nil
}

func (m *RequestUnion) GetBeginTransaction() *BeginTransactionRequest {
	if x, ok := m.GetValue().(*RequestUnion_BeginTransaction); ok {
		return x.BeginTransaction
	}
	return nil
}

func (m *RequestUnion) GetEndTransaction() *EndTransactionRequest {
	if x, ok := m.GetValue().(*RequestUnion_EndTransaction); ok {
		return x.EndTransaction
	}
	return nil
}

func (m *RequestUnion) GetAdminSplit() *AdminSplitRequest {
	if x, ok := m.GetValue().(*RequestUnion_AdminSplit); ok {
		return x.AdminSplit
	}
	return nil
}

func (m *RequestUnion) GetAdminMerge() *AdminMergeRequest {
	if x, ok := m.GetValue().(*RequestUnion_AdminMerge); ok {
		return x.AdminMerge
	}
	return nil
}

func (m *RequestUnion) GetAdminTransferLease() *AdminTransferLeaseRequest {
	if x, ok := m.GetValue().(*RequestUnion_AdminTransferLease); ok {
		return x.AdminTransferLease
	}
	return nil
}

func (m *RequestUnion) GetAdminChangeReplicas() *AdminChangeReplicasRequest {
	if x, ok := m.GetValue().(*RequestUnion_AdminChangeReplicas); ok {
		return x.AdminChangeReplicas
	}
	return nil
}

func (m *RequestUnion) GetAdminRelocateRange() *AdminRelocateRangeRequest {
	if x, ok := m.GetValue().(*RequestUnion_AdminRelocateRange); ok {
		return x.AdminRelocateRange
	}
	return nil
}

func (m *RequestUnion) GetHeartbeatTxn() *HeartbeatTxnRequest {
	if x, ok := m.GetValue().(*RequestUnion_HeartbeatTxn); ok {
		return x.HeartbeatTxn
	}
	return nil
}

func (m *RequestUnion) GetGc() *GCRequest {
	if x, ok := m.GetValue().(*RequestUnion_Gc); ok {
		return x.Gc
	}
	return nil
}

func (m *RequestUnion) GetPushTxn() *PushTxnRequest {
	if x, ok := m.GetValue().(*RequestUnion_PushTxn); ok {
		return x.PushTxn
	}
	return nil
}

func (m *RequestUnion) GetResolveIntent() *ResolveIntentRequest {
	if x, ok := m.GetValue().(*RequestUnion_ResolveIntent); ok {
		return x.ResolveIntent
	}
	return nil
}

func (m *RequestUnion) GetResolveIntentRange() *ResolveIntentRangeRequest {
	if x, ok := m.GetValue().(*RequestUnion_ResolveIntentRange); ok {
		return x.ResolveIntentRange
	}
	return nil
}

func (m *RequestUnion) GetMerge() *MergeRequest {
	if x, ok := m.GetValue().(*RequestUnion_Merge); ok {
		return x.Merge
	}
	return nil
}

func (m *RequestUnion) GetTruncateLog() *TruncateLogRequest {
	if x, ok := m.GetValue().(*RequestUnion_TruncateLog); ok {
		return x.TruncateLog
	}
	return nil
}

func (m *RequestUnion) GetRequestLease() *RequestLeaseRequest {
	if x, ok := m.GetValue().(*RequestUnion_RequestLease); ok {
		return x.RequestLease
	}
	return nil
}

func (m *RequestUnion) GetReverseScan() *ReverseScanRequest {
	if x, ok := m.GetValue().(*RequestUnion_ReverseScan); ok {
		return x.ReverseScan
	}
	return nil
}

func (m *RequestUnion) GetComputeChecksum() *ComputeChecksumRequest {
	if x, ok := m.GetValue().(*RequestUnion_ComputeChecksum); ok {
		return x.ComputeChecksum
	}
	return nil
}

func (m *RequestUnion) GetCheckConsistency() *CheckConsistencyRequest {
	if x, ok := m.GetValue().(*RequestUnion_CheckConsistency); ok {
		return x.CheckConsistency
	}
	return nil
}

func (m *RequestUnion) GetInitPut() *InitPutRequest {
	if x, ok := m.GetValue().(*RequestUnion_InitPut); ok {
		return x.InitPut
	}
	return nil
}

func (m *RequestUnion) GetTransferLease() *TransferLeaseRequest {
	if x, ok := m.GetValue().(*RequestUnion_TransferLease); ok {
		return x.TransferLease
	}
	return nil
}

func (m *RequestUnion) GetLeaseInfo() *LeaseInfoRequest {
	if x, ok := m.GetValue().(*RequestUnion_LeaseInfo); ok {
		return x.LeaseInfo
	}
	return nil
}

func (m *RequestUnion) GetWriteBatch() *WriteBatchRequest {
	if x, ok := m.GetValue().(*RequestUnion_WriteBatch); ok {
		return x.WriteBatch
	}
	return nil
}

func (m *RequestUnion) GetExport() *ExportRequest {
	if x, ok := m.GetValue().(*RequestUnion_Export); ok {
		return x.Export
	}
	return nil
}

func (m *RequestUnion) GetImport() *ImportRequest {
	if x, ok := m.GetValue().(*RequestUnion_Import); ok {
		return x.Import
	}
	return nil
}

func (m *RequestUnion) GetQueryTxn() *QueryTxnRequest {
	if x, ok := m.GetValue().(*RequestUnion_QueryTxn); ok {
		return x.QueryTxn
	}
	return nil
}

func (m *RequestUnion) GetQueryIntent() *QueryIntentRequest {
	if x, ok := m.GetValue().(*RequestUnion_QueryIntent); ok {
		return x.QueryIntent
	}
	return nil
}

func (m *RequestUnion) GetAdminScatter() *AdminScatterRequest {
	if x, ok := m.GetValue().(*RequestUnion_AdminScatter); ok {
		return x.AdminScatter
	}
	return nil
}

func (m *RequestUnion) GetAddSstable() *AddSSTableRequest {
	if x, ok := m.GetValue().(*RequestUnion_AddSstable); ok {
		return x.AddSstable
	}
	return nil
}

func (m *RequestUnion) GetRecomputeStats() *RecomputeStatsRequest {
	if x, ok := m.GetValue().(*RequestUnion_RecomputeStats); ok {
		return x.RecomputeStats
	}
	return nil
}

func (m *RequestUnion) GetRefresh() *RefreshRequest {
	if x, ok := m.GetValue().(*RequestUnion_Refresh); ok {
		return x.Refresh
	}
	return nil
}

func (m *RequestUnion) GetRefreshRange() *RefreshRangeRequest {
	if x, ok := m.GetValue().(*RequestUnion_RefreshRange); ok {
		return x.RefreshRange
	}
	return nil
}

func (m *RequestUnion) GetSubsume() *SubsumeRequest {
	if x, ok := m.GetValue().(*RequestUnion_Subsume); ok {
		return x.Subsume
	}
	return nil
}

func (m *RequestUnion) GetRangeStats() *RangeStatsRequest {
	if x, ok := m.GetValue().(*RequestUnion_RangeStats); ok {
		return x.RangeStats
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RequestUnion) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RequestUnion_OneofMarshaler, _RequestUnion_OneofUnmarshaler, _RequestUnion_OneofSizer, []interface{}{
		(*RequestUnion_Get)(nil),
		(*RequestUnion_Put)(nil),
		(*RequestUnion_ConditionalPut)(nil),
		(*RequestUnion_Increment)(nil),
		(*RequestUnion_Delete)(nil),
		(*RequestUnion_DeleteRange)(nil),
		(*RequestUnion_ClearRange)(nil),
		(*RequestUnion_Scan)(nil),
		(*RequestUnion_BeginTransaction)(nil),
		(*RequestUnion_EndTransaction)(nil),
		(*RequestUnion_AdminSplit)(nil),
		(*RequestUnion_AdminMerge)(nil),
		(*RequestUnion_AdminTransferLease)(nil),
		(*RequestUnion_AdminChangeReplicas)(nil),
		(*RequestUnion_AdminRelocateRange)(nil),
		(*RequestUnion_HeartbeatTxn)(nil),
		(*RequestUnion_Gc)(nil),
		(*RequestUnion_PushTxn)(nil),
		(*RequestUnion_ResolveIntent)(nil),
		(*RequestUnion_ResolveIntentRange)(nil),
		(*RequestUnion_Merge)(nil),
		(*RequestUnion_TruncateLog)(nil),
		(*RequestUnion_RequestLease)(nil),
		(*RequestUnion_ReverseScan)(nil),
		(*RequestUnion_ComputeChecksum)(nil),
		(*RequestUnion_CheckConsistency)(nil),
		(*RequestUnion_InitPut)(nil),
		(*RequestUnion_TransferLease)(nil),
		(*RequestUnion_LeaseInfo)(nil),
		(*RequestUnion_WriteBatch)(nil),
		(*RequestUnion_Export)(nil),
		(*RequestUnion_Import)(nil),
		(*RequestUnion_QueryTxn)(nil),
		(*RequestUnion_QueryIntent)(nil),
		(*RequestUnion_AdminScatter)(nil),
		(*RequestUnion_AddSstable)(nil),
		(*RequestUnion_RecomputeStats)(nil),
		(*RequestUnion_Refresh)(nil),
		(*RequestUnion_RefreshRange)(nil),
		(*RequestUnion_Subsume)(nil),
		(*RequestUnion_RangeStats)(nil),
	}
}

func _RequestUnion_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RequestUnion)
	// value
	switch x := m.Value.(type) {
	case *RequestUnion_Get:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Get); err != nil {
			return err
		}
	case *RequestUnion_Put:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Put); err != nil {
			return err
		}
	case *RequestUnion_ConditionalPut:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ConditionalPut); err != nil {
			return err
		}
	case *RequestUnion_Increment:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Increment); err != nil {
			return err
		}
	case *RequestUnion_Delete:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Delete); err != nil {
			return err
		}
	case *RequestUnion_DeleteRange:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteRange); err != nil {
			return err
		}
	case *RequestUnion_ClearRange:
		_ = b.EncodeVarint(38<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClearRange); err != nil {
			return err
		}
	case *RequestUnion_Scan:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Scan); err != nil {
			return err
		}
	case *RequestUnion_BeginTransaction:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BeginTransaction); err != nil {
			return err
		}
	case *RequestUnion_EndTransaction:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EndTransaction); err != nil {
			return err
		}
	case *RequestUnion_AdminSplit:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminSplit); err != nil {
			return err
		}
	case *RequestUnion_AdminMerge:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminMerge); err != nil {
			return err
		}
	case *RequestUnion_AdminTransferLease:
		_ = b.EncodeVarint(29<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminTransferLease); err != nil {
			return err
		}
	case *RequestUnion_AdminChangeReplicas:
		_ = b.EncodeVarint(35<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminChangeReplicas); err != nil {
			return err
		}
	case *RequestUnion_AdminRelocateRange:
		_ = b.EncodeVarint(45<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminRelocateRange); err != nil {
			return err
		}
	case *RequestUnion_HeartbeatTxn:
		_ = b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HeartbeatTxn); err != nil {
			return err
		}
	case *RequestUnion_Gc:
		_ = b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Gc); err != nil {
			return err
		}
	case *RequestUnion_PushTxn:
		_ = b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PushTxn); err != nil {
			return err
		}
	case *RequestUnion_ResolveIntent:
		_ = b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResolveIntent); err != nil {
			return err
		}
	case *RequestUnion_ResolveIntentRange:
		_ = b.EncodeVarint(17<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResolveIntentRange); err != nil {
			return err
		}
	case *RequestUnion_Merge:
		_ = b.EncodeVarint(18<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Merge); err != nil {
			return err
		}
	case *RequestUnion_TruncateLog:
		_ = b.EncodeVarint(19<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TruncateLog); err != nil {
			return err
		}
	case *RequestUnion_RequestLease:
		_ = b.EncodeVarint(20<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RequestLease); err != nil {
			return err
		}
	case *RequestUnion_ReverseScan:
		_ = b.EncodeVarint(21<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReverseScan); err != nil {
			return err
		}
	case *RequestUnion_ComputeChecksum:
		_ = b.EncodeVarint(22<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ComputeChecksum); err != nil {
			return err
		}
	case *RequestUnion_CheckConsistency:
		_ = b.EncodeVarint(24<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CheckConsistency); err != nil {
			return err
		}
	case *RequestUnion_InitPut:
		_ = b.EncodeVarint(26<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InitPut); err != nil {
			return err
		}
	case *RequestUnion_TransferLease:
		_ = b.EncodeVarint(28<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TransferLease); err != nil {
			return err
		}
	case *RequestUnion_LeaseInfo:
		_ = b.EncodeVarint(30<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LeaseInfo); err != nil {
			return err
		}
	case *RequestUnion_WriteBatch:
		_ = b.EncodeVarint(31<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WriteBatch); err != nil {
			return err
		}
	case *RequestUnion_Export:
		_ = b.EncodeVarint(32<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Export); err != nil {
			return err
		}
	case *RequestUnion_Import:
		_ = b.EncodeVarint(34<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Import); err != nil {
			return err
		}
	case *RequestUnion_QueryTxn:
		_ = b.EncodeVarint(33<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryTxn); err != nil {
			return err
		}
	case *RequestUnion_QueryIntent:
		_ = b.EncodeVarint(42<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryIntent); err != nil {
			return err
		}
	case *RequestUnion_AdminScatter:
		_ = b.EncodeVarint(36<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminScatter); err != nil {
			return err
		}
	case *RequestUnion_AddSstable:
		_ = b.EncodeVarint(37<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AddSstable); err != nil {
			return err
		}
	case *RequestUnion_RecomputeStats:
		_ = b.EncodeVarint(39<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RecomputeStats); err != nil {
			return err
		}
	case *RequestUnion_Refresh:
		_ = b.EncodeVarint(40<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Refresh); err != nil {
			return err
		}
	case *RequestUnion_RefreshRange:
		_ = b.EncodeVarint(41<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RefreshRange); err != nil {
			return err
		}
	case *RequestUnion_Subsume:
		_ = b.EncodeVarint(43<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Subsume); err != nil {
			return err
		}
	case *RequestUnion_RangeStats:
		_ = b.EncodeVarint(44<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RangeStats); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RequestUnion.Value has unexpected type %T", x)
	}
	return nil
}

func _RequestUnion_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RequestUnion)
	switch tag {
	case 1: // value.get
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GetRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Get{msg}
		return true, err
	case 2: // value.put
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PutRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Put{msg}
		return true, err
	case 3: // value.conditional_put
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ConditionalPutRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_ConditionalPut{msg}
		return true, err
	case 4: // value.increment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(IncrementRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Increment{msg}
		return true, err
	case 5: // value.delete
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DeleteRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Delete{msg}
		return true, err
	case 6: // value.delete_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DeleteRangeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_DeleteRange{msg}
		return true, err
	case 38: // value.clear_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClearRangeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_ClearRange{msg}
		return true, err
	case 7: // value.scan
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ScanRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Scan{msg}
		return true, err
	case 8: // value.begin_transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BeginTransactionRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_BeginTransaction{msg}
		return true, err
	case 9: // value.end_transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EndTransactionRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_EndTransaction{msg}
		return true, err
	case 10: // value.admin_split
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminSplitRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AdminSplit{msg}
		return true, err
	case 11: // value.admin_merge
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminMergeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AdminMerge{msg}
		return true, err
	case 29: // value.admin_transfer_lease
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminTransferLeaseRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AdminTransferLease{msg}
		return true, err
	case 35: // value.admin_change_replicas
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminChangeReplicasRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AdminChangeReplicas{msg}
		return true, err
	case 45: // value.admin_relocate_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminRelocateRangeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AdminRelocateRange{msg}
		return true, err
	case 12: // value.heartbeat_txn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HeartbeatTxnRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_HeartbeatTxn{msg}
		return true, err
	case 13: // value.gc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GCRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Gc{msg}
		return true, err
	case 14: // value.push_txn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PushTxnRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_PushTxn{msg}
		return true, err
	case 16: // value.resolve_intent
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ResolveIntentRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_ResolveIntent{msg}
		return true, err
	case 17: // value.resolve_intent_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ResolveIntentRangeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_ResolveIntentRange{msg}
		return true, err
	case 18: // value.merge
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MergeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Merge{msg}
		return true, err
	case 19: // value.truncate_log
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TruncateLogRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_TruncateLog{msg}
		return true, err
	case 20: // value.request_lease
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RequestLeaseRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_RequestLease{msg}
		return true, err
	case 21: // value.reverse_scan
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReverseScanRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_ReverseScan{msg}
		return true, err
	case 22: // value.compute_checksum
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ComputeChecksumRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_ComputeChecksum{msg}
		return true, err
	case 24: // value.check_consistency
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CheckConsistencyRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_CheckConsistency{msg}
		return true, err
	case 26: // value.init_put
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InitPutRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_InitPut{msg}
		return true, err
	case 28: // value.transfer_lease
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransferLeaseRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_TransferLease{msg}
		return true, err
	case 30: // value.lease_info
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(LeaseInfoRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_LeaseInfo{msg}
		return true, err
	case 31: // value.write_batch
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(WriteBatchRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_WriteBatch{msg}
		return true, err
	case 32: // value.export
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ExportRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Export{msg}
		return true, err
	case 34: // value.import
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ImportRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Import{msg}
		return true, err
	case 33: // value.query_txn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryTxnRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_QueryTxn{msg}
		return true, err
	case 42: // value.query_intent
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryIntentRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_QueryIntent{msg}
		return true, err
	case 36: // value.admin_scatter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminScatterRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AdminScatter{msg}
		return true, err
	case 37: // value.add_sstable
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AddSSTableRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_AddSstable{msg}
		return true, err
	case 39: // value.recompute_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RecomputeStatsRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_RecomputeStats{msg}
		return true, err
	case 40: // value.refresh
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RefreshRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Refresh{msg}
		return true, err
	case 41: // value.refresh_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RefreshRangeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_RefreshRange{msg}
		return true, err
	case 43: // value.subsume
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SubsumeRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_Subsume{msg}
		return true, err
	case 44: // value.range_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RangeStatsRequest)
		err := b.DecodeMessage(msg)
		m.Value = &RequestUnion_RangeStats{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RequestUnion_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RequestUnion)
	// value
	switch x := m.Value.(type) {
	case *RequestUnion_Get:
		s := proto.Size(x.Get)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Put:
		s := proto.Size(x.Put)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_ConditionalPut:
		s := proto.Size(x.ConditionalPut)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Increment:
		s := proto.Size(x.Increment)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Delete:
		s := proto.Size(x.Delete)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_DeleteRange:
		s := proto.Size(x.DeleteRange)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_ClearRange:
		s := proto.Size(x.ClearRange)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Scan:
		s := proto.Size(x.Scan)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_BeginTransaction:
		s := proto.Size(x.BeginTransaction)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_EndTransaction:
		s := proto.Size(x.EndTransaction)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AdminSplit:
		s := proto.Size(x.AdminSplit)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AdminMerge:
		s := proto.Size(x.AdminMerge)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AdminTransferLease:
		s := proto.Size(x.AdminTransferLease)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AdminChangeReplicas:
		s := proto.Size(x.AdminChangeReplicas)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AdminRelocateRange:
		s := proto.Size(x.AdminRelocateRange)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_HeartbeatTxn:
		s := proto.Size(x.HeartbeatTxn)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Gc:
		s := proto.Size(x.Gc)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_PushTxn:
		s := proto.Size(x.PushTxn)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_ResolveIntent:
		s := proto.Size(x.ResolveIntent)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_ResolveIntentRange:
		s := proto.Size(x.ResolveIntentRange)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Merge:
		s := proto.Size(x.Merge)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_TruncateLog:
		s := proto.Size(x.TruncateLog)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_RequestLease:
		s := proto.Size(x.RequestLease)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_ReverseScan:
		s := proto.Size(x.ReverseScan)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_ComputeChecksum:
		s := proto.Size(x.ComputeChecksum)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_CheckConsistency:
		s := proto.Size(x.CheckConsistency)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_InitPut:
		s := proto.Size(x.InitPut)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_TransferLease:
		s := proto.Size(x.TransferLease)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_LeaseInfo:
		s := proto.Size(x.LeaseInfo)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_WriteBatch:
		s := proto.Size(x.WriteBatch)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Export:
		s := proto.Size(x.Export)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Import:
		s := proto.Size(x.Import)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_QueryTxn:
		s := proto.Size(x.QueryTxn)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_QueryIntent:
		s := proto.Size(x.QueryIntent)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AdminScatter:
		s := proto.Size(x.AdminScatter)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_AddSstable:
		s := proto.Size(x.AddSstable)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_RecomputeStats:
		s := proto.Size(x.RecomputeStats)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Refresh:
		s := proto.Size(x.Refresh)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_RefreshRange:
		s := proto.Size(x.RefreshRange)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_Subsume:
		s := proto.Size(x.Subsume)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RequestUnion_RangeStats:
		s := proto.Size(x.RangeStats)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A ResponseUnion contains exactly one of the responses.
// The values added here must match those in RequestUnion.
type ResponseUnion struct {
	// Types that are valid to be assigned to Value:
	//	*ResponseUnion_Get
	//	*ResponseUnion_Put
	//	*ResponseUnion_ConditionalPut
	//	*ResponseUnion_Increment
	//	*ResponseUnion_Delete
	//	*ResponseUnion_DeleteRange
	//	*ResponseUnion_ClearRange
	//	*ResponseUnion_Scan
	//	*ResponseUnion_BeginTransaction
	//	*ResponseUnion_EndTransaction
	//	*ResponseUnion_AdminSplit
	//	*ResponseUnion_AdminMerge
	//	*ResponseUnion_AdminTransferLease
	//	*ResponseUnion_AdminChangeReplicas
	//	*ResponseUnion_AdminRelocateRange
	//	*ResponseUnion_HeartbeatTxn
	//	*ResponseUnion_Gc
	//	*ResponseUnion_PushTxn
	//	*ResponseUnion_ResolveIntent
	//	*ResponseUnion_ResolveIntentRange
	//	*ResponseUnion_Merge
	//	*ResponseUnion_TruncateLog
	//	*ResponseUnion_RequestLease
	//	*ResponseUnion_ReverseScan
	//	*ResponseUnion_ComputeChecksum
	//	*ResponseUnion_CheckConsistency
	//	*ResponseUnion_InitPut
	//	*ResponseUnion_LeaseInfo
	//	*ResponseUnion_WriteBatch
	//	*ResponseUnion_Export
	//	*ResponseUnion_Import
	//	*ResponseUnion_QueryTxn
	//	*ResponseUnion_QueryIntent
	//	*ResponseUnion_AdminScatter
	//	*ResponseUnion_AddSstable
	//	*ResponseUnion_RecomputeStats
	//	*ResponseUnion_Refresh
	//	*ResponseUnion_RefreshRange
	//	*ResponseUnion_Subsume
	//	*ResponseUnion_RangeStats
	Value                isResponseUnion_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ResponseUnion) Reset()         { *m = ResponseUnion{} }
func (m *ResponseUnion) String() string { return proto.CompactTextString(m) }
func (*ResponseUnion) ProtoMessage()    {}
func (*ResponseUnion) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{88}
}
func (m *ResponseUnion) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResponseUnion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ResponseUnion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponseUnion.Merge(dst, src)
}
func (m *ResponseUnion) XXX_Size() int {
	return m.Size()
}
func (m *ResponseUnion) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponseUnion.DiscardUnknown(m)
}

var xxx_messageInfo_ResponseUnion proto.InternalMessageInfo

type isResponseUnion_Value interface {
	isResponseUnion_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type ResponseUnion_Get struct {
	Get *GetResponse `protobuf:"bytes,1,opt,name=get,proto3,oneof"`
}
type ResponseUnion_Put struct {
	Put *PutResponse `protobuf:"bytes,2,opt,name=put,proto3,oneof"`
}
type ResponseUnion_ConditionalPut struct {
	ConditionalPut *ConditionalPutResponse `protobuf:"bytes,3,opt,name=conditional_put,json=conditionalPut,proto3,oneof"`
}
type ResponseUnion_Increment struct {
	Increment *IncrementResponse `protobuf:"bytes,4,opt,name=increment,proto3,oneof"`
}
type ResponseUnion_Delete struct {
	Delete *DeleteResponse `protobuf:"bytes,5,opt,name=delete,proto3,oneof"`
}
type ResponseUnion_DeleteRange struct {
	DeleteRange *DeleteRangeResponse `protobuf:"bytes,6,opt,name=delete_range,json=deleteRange,proto3,oneof"`
}
type ResponseUnion_ClearRange struct {
	ClearRange *ClearRangeResponse `protobuf:"bytes,38,opt,name=clear_range,json=clearRange,proto3,oneof"`
}
type ResponseUnion_Scan struct {
	Scan *ScanResponse `protobuf:"bytes,7,opt,name=scan,proto3,oneof"`
}
type ResponseUnion_BeginTransaction struct {
	BeginTransaction *BeginTransactionResponse `protobuf:"bytes,8,opt,name=begin_transaction,json=beginTransaction,proto3,oneof"`
}
type ResponseUnion_EndTransaction struct {
	EndTransaction *EndTransactionResponse `protobuf:"bytes,9,opt,name=end_transaction,json=endTransaction,proto3,oneof"`
}
type ResponseUnion_AdminSplit struct {
	AdminSplit *AdminSplitResponse `protobuf:"bytes,10,opt,name=admin_split,json=adminSplit,proto3,oneof"`
}
type ResponseUnion_AdminMerge struct {
	AdminMerge *AdminMergeResponse `protobuf:"bytes,11,opt,name=admin_merge,json=adminMerge,proto3,oneof"`
}
type ResponseUnion_AdminTransferLease struct {
	AdminTransferLease *AdminTransferLeaseResponse `protobuf:"bytes,29,opt,name=admin_transfer_lease,json=adminTransferLease,proto3,oneof"`
}
type ResponseUnion_AdminChangeReplicas struct {
	AdminChangeReplicas *AdminChangeReplicasResponse `protobuf:"bytes,35,opt,name=admin_change_replicas,json=adminChangeReplicas,proto3,oneof"`
}
type ResponseUnion_AdminRelocateRange struct {
	AdminRelocateRange *AdminRelocateRangeResponse `protobuf:"bytes,45,opt,name=admin_relocate_range,json=adminRelocateRange,proto3,oneof"`
}
type ResponseUnion_HeartbeatTxn struct {
	HeartbeatTxn *HeartbeatTxnResponse `protobuf:"bytes,12,opt,name=heartbeat_txn,json=heartbeatTxn,proto3,oneof"`
}
type ResponseUnion_Gc struct {
	Gc *GCResponse `protobuf:"bytes,13,opt,name=gc,proto3,oneof"`
}
type ResponseUnion_PushTxn struct {
	PushTxn *PushTxnResponse `protobuf:"bytes,14,opt,name=push_txn,json=pushTxn,proto3,oneof"`
}
type ResponseUnion_ResolveIntent struct {
	ResolveIntent *ResolveIntentResponse `protobuf:"bytes,16,opt,name=resolve_intent,json=resolveIntent,proto3,oneof"`
}
type ResponseUnion_ResolveIntentRange struct {
	ResolveIntentRange *ResolveIntentRangeResponse `protobuf:"bytes,17,opt,name=resolve_intent_range,json=resolveIntentRange,proto3,oneof"`
}
type ResponseUnion_Merge struct {
	Merge *MergeResponse `protobuf:"bytes,18,opt,name=merge,proto3,oneof"`
}
type ResponseUnion_TruncateLog struct {
	TruncateLog *TruncateLogResponse `protobuf:"bytes,19,opt,name=truncate_log,json=truncateLog,proto3,oneof"`
}
type ResponseUnion_RequestLease struct {
	RequestLease *RequestLeaseResponse `protobuf:"bytes,20,opt,name=request_lease,json=requestLease,proto3,oneof"`
}
type ResponseUnion_ReverseScan struct {
	ReverseScan *ReverseScanResponse `protobuf:"bytes,21,opt,name=reverse_scan,json=reverseScan,proto3,oneof"`
}
type ResponseUnion_ComputeChecksum struct {
	ComputeChecksum *ComputeChecksumResponse `protobuf:"bytes,22,opt,name=compute_checksum,json=computeChecksum,proto3,oneof"`
}
type ResponseUnion_CheckConsistency struct {
	CheckConsistency *CheckConsistencyResponse `protobuf:"bytes,24,opt,name=check_consistency,json=checkConsistency,proto3,oneof"`
}
type ResponseUnion_InitPut struct {
	InitPut *InitPutResponse `protobuf:"bytes,26,opt,name=init_put,json=initPut,proto3,oneof"`
}
type ResponseUnion_LeaseInfo struct {
	LeaseInfo *LeaseInfoResponse `protobuf:"bytes,30,opt,name=lease_info,json=leaseInfo,proto3,oneof"`
}
type ResponseUnion_WriteBatch struct {
	WriteBatch *WriteBatchResponse `protobuf:"bytes,31,opt,name=write_batch,json=writeBatch,proto3,oneof"`
}
type ResponseUnion_Export struct {
	Export *ExportResponse `protobuf:"bytes,32,opt,name=export,proto3,oneof"`
}
type ResponseUnion_Import struct {
	Import *ImportResponse `protobuf:"bytes,34,opt,name=import,proto3,oneof"`
}
type ResponseUnion_QueryTxn struct {
	QueryTxn *QueryTxnResponse `protobuf:"bytes,33,opt,name=query_txn,json=queryTxn,proto3,oneof"`
}
type ResponseUnion_QueryIntent struct {
	QueryIntent *QueryIntentResponse `protobuf:"bytes,42,opt,name=query_intent,json=queryIntent,proto3,oneof"`
}
type ResponseUnion_AdminScatter struct {
	AdminScatter *AdminScatterResponse `protobuf:"bytes,36,opt,name=admin_scatter,json=adminScatter,proto3,oneof"`
}
type ResponseUnion_AddSstable struct {
	AddSstable *AddSSTableResponse `protobuf:"bytes,37,opt,name=add_sstable,json=addSstable,proto3,oneof"`
}
type ResponseUnion_RecomputeStats struct {
	RecomputeStats *RecomputeStatsResponse `protobuf:"bytes,39,opt,name=recompute_stats,json=recomputeStats,proto3,oneof"`
}
type ResponseUnion_Refresh struct {
	Refresh *RefreshResponse `protobuf:"bytes,40,opt,name=refresh,proto3,oneof"`
}
type ResponseUnion_RefreshRange struct {
	RefreshRange *RefreshRangeResponse `protobuf:"bytes,41,opt,name=refresh_range,json=refreshRange,proto3,oneof"`
}
type ResponseUnion_Subsume struct {
	Subsume *SubsumeResponse `protobuf:"bytes,43,opt,name=subsume,proto3,oneof"`
}
type ResponseUnion_RangeStats struct {
	RangeStats *RangeStatsResponse `protobuf:"bytes,44,opt,name=range_stats,json=rangeStats,proto3,oneof"`
}

func (*ResponseUnion_Get) isResponseUnion_Value()                 {}
func (*ResponseUnion_Put) isResponseUnion_Value()                 {}
func (*ResponseUnion_ConditionalPut) isResponseUnion_Value()      {}
func (*ResponseUnion_Increment) isResponseUnion_Value()           {}
func (*ResponseUnion_Delete) isResponseUnion_Value()              {}
func (*ResponseUnion_DeleteRange) isResponseUnion_Value()         {}
func (*ResponseUnion_ClearRange) isResponseUnion_Value()          {}
func (*ResponseUnion_Scan) isResponseUnion_Value()                {}
func (*ResponseUnion_BeginTransaction) isResponseUnion_Value()    {}
func (*ResponseUnion_EndTransaction) isResponseUnion_Value()      {}
func (*ResponseUnion_AdminSplit) isResponseUnion_Value()          {}
func (*ResponseUnion_AdminMerge) isResponseUnion_Value()          {}
func (*ResponseUnion_AdminTransferLease) isResponseUnion_Value()  {}
func (*ResponseUnion_AdminChangeReplicas) isResponseUnion_Value() {}
func (*ResponseUnion_AdminRelocateRange) isResponseUnion_Value()  {}
func (*ResponseUnion_HeartbeatTxn) isResponseUnion_Value()        {}
func (*ResponseUnion_Gc) isResponseUnion_Value()                  {}
func (*ResponseUnion_PushTxn) isResponseUnion_Value()             {}
func (*ResponseUnion_ResolveIntent) isResponseUnion_Value()       {}
func (*ResponseUnion_ResolveIntentRange) isResponseUnion_Value()  {}
func (*ResponseUnion_Merge) isResponseUnion_Value()               {}
func (*ResponseUnion_TruncateLog) isResponseUnion_Value()         {}
func (*ResponseUnion_RequestLease) isResponseUnion_Value()        {}
func (*ResponseUnion_ReverseScan) isResponseUnion_Value()         {}
func (*ResponseUnion_ComputeChecksum) isResponseUnion_Value()     {}
func (*ResponseUnion_CheckConsistency) isResponseUnion_Value()    {}
func (*ResponseUnion_InitPut) isResponseUnion_Value()             {}
func (*ResponseUnion_LeaseInfo) isResponseUnion_Value()           {}
func (*ResponseUnion_WriteBatch) isResponseUnion_Value()          {}
func (*ResponseUnion_Export) isResponseUnion_Value()              {}
func (*ResponseUnion_Import) isResponseUnion_Value()              {}
func (*ResponseUnion_QueryTxn) isResponseUnion_Value()            {}
func (*ResponseUnion_QueryIntent) isResponseUnion_Value()         {}
func (*ResponseUnion_AdminScatter) isResponseUnion_Value()        {}
func (*ResponseUnion_AddSstable) isResponseUnion_Value()          {}
func (*ResponseUnion_RecomputeStats) isResponseUnion_Value()      {}
func (*ResponseUnion_Refresh) isResponseUnion_Value()             {}
func (*ResponseUnion_RefreshRange) isResponseUnion_Value()        {}
func (*ResponseUnion_Subsume) isResponseUnion_Value()             {}
func (*ResponseUnion_RangeStats) isResponseUnion_Value()          {}

func (m *ResponseUnion) GetValue() isResponseUnion_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ResponseUnion) GetGet() *GetResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Get); ok {
		return x.Get
	}
	return nil
}

func (m *ResponseUnion) GetPut() *PutResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Put); ok {
		return x.Put
	}
	return nil
}

func (m *ResponseUnion) GetConditionalPut() *ConditionalPutResponse {
	if x, ok := m.GetValue().(*ResponseUnion_ConditionalPut); ok {
		return x.ConditionalPut
	}
	return nil
}

func (m *ResponseUnion) GetIncrement() *IncrementResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Increment); ok {
		return x.Increment
	}
	return nil
}

func (m *ResponseUnion) GetDelete() *DeleteResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Delete); ok {
		return x.Delete
	}
	return nil
}

func (m *ResponseUnion) GetDeleteRange() *DeleteRangeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_DeleteRange); ok {
		return x.DeleteRange
	}
	return nil
}

func (m *ResponseUnion) GetClearRange() *ClearRangeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_ClearRange); ok {
		return x.ClearRange
	}
	return nil
}

func (m *ResponseUnion) GetScan() *ScanResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Scan); ok {
		return x.Scan
	}
	return nil
}

func (m *ResponseUnion) GetBeginTransaction() *BeginTransactionResponse {
	if x, ok := m.GetValue().(*ResponseUnion_BeginTransaction); ok {
		return x.BeginTransaction
	}
	return nil
}

func (m *ResponseUnion) GetEndTransaction() *EndTransactionResponse {
	if x, ok := m.GetValue().(*ResponseUnion_EndTransaction); ok {
		return x.EndTransaction
	}
	return nil
}

func (m *ResponseUnion) GetAdminSplit() *AdminSplitResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AdminSplit); ok {
		return x.AdminSplit
	}
	return nil
}

func (m *ResponseUnion) GetAdminMerge() *AdminMergeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AdminMerge); ok {
		return x.AdminMerge
	}
	return nil
}

func (m *ResponseUnion) GetAdminTransferLease() *AdminTransferLeaseResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AdminTransferLease); ok {
		return x.AdminTransferLease
	}
	return nil
}

func (m *ResponseUnion) GetAdminChangeReplicas() *AdminChangeReplicasResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AdminChangeReplicas); ok {
		return x.AdminChangeReplicas
	}
	return nil
}

func (m *ResponseUnion) GetAdminRelocateRange() *AdminRelocateRangeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AdminRelocateRange); ok {
		return x.AdminRelocateRange
	}
	return nil
}

func (m *ResponseUnion) GetHeartbeatTxn() *HeartbeatTxnResponse {
	if x, ok := m.GetValue().(*ResponseUnion_HeartbeatTxn); ok {
		return x.HeartbeatTxn
	}
	return nil
}

func (m *ResponseUnion) GetGc() *GCResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Gc); ok {
		return x.Gc
	}
	return nil
}

func (m *ResponseUnion) GetPushTxn() *PushTxnResponse {
	if x, ok := m.GetValue().(*ResponseUnion_PushTxn); ok {
		return x.PushTxn
	}
	return nil
}

func (m *ResponseUnion) GetResolveIntent() *ResolveIntentResponse {
	if x, ok := m.GetValue().(*ResponseUnion_ResolveIntent); ok {
		return x.ResolveIntent
	}
	return nil
}

func (m *ResponseUnion) GetResolveIntentRange() *ResolveIntentRangeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_ResolveIntentRange); ok {
		return x.ResolveIntentRange
	}
	return nil
}

func (m *ResponseUnion) GetMerge() *MergeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Merge); ok {
		return x.Merge
	}
	return nil
}

func (m *ResponseUnion) GetTruncateLog() *TruncateLogResponse {
	if x, ok := m.GetValue().(*ResponseUnion_TruncateLog); ok {
		return x.TruncateLog
	}
	return nil
}

func (m *ResponseUnion) GetRequestLease() *RequestLeaseResponse {
	if x, ok := m.GetValue().(*ResponseUnion_RequestLease); ok {
		return x.RequestLease
	}
	return nil
}

func (m *ResponseUnion) GetReverseScan() *ReverseScanResponse {
	if x, ok := m.GetValue().(*ResponseUnion_ReverseScan); ok {
		return x.ReverseScan
	}
	return nil
}

func (m *ResponseUnion) GetComputeChecksum() *ComputeChecksumResponse {
	if x, ok := m.GetValue().(*ResponseUnion_ComputeChecksum); ok {
		return x.ComputeChecksum
	}
	return nil
}

func (m *ResponseUnion) GetCheckConsistency() *CheckConsistencyResponse {
	if x, ok := m.GetValue().(*ResponseUnion_CheckConsistency); ok {
		return x.CheckConsistency
	}
	return nil
}

func (m *ResponseUnion) GetInitPut() *InitPutResponse {
	if x, ok := m.GetValue().(*ResponseUnion_InitPut); ok {
		return x.InitPut
	}
	return nil
}

func (m *ResponseUnion) GetLeaseInfo() *LeaseInfoResponse {
	if x, ok := m.GetValue().(*ResponseUnion_LeaseInfo); ok {
		return x.LeaseInfo
	}
	return nil
}

func (m *ResponseUnion) GetWriteBatch() *WriteBatchResponse {
	if x, ok := m.GetValue().(*ResponseUnion_WriteBatch); ok {
		return x.WriteBatch
	}
	return nil
}

func (m *ResponseUnion) GetExport() *ExportResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Export); ok {
		return x.Export
	}
	return nil
}

func (m *ResponseUnion) GetImport() *ImportResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Import); ok {
		return x.Import
	}
	return nil
}

func (m *ResponseUnion) GetQueryTxn() *QueryTxnResponse {
	if x, ok := m.GetValue().(*ResponseUnion_QueryTxn); ok {
		return x.QueryTxn
	}
	return nil
}

func (m *ResponseUnion) GetQueryIntent() *QueryIntentResponse {
	if x, ok := m.GetValue().(*ResponseUnion_QueryIntent); ok {
		return x.QueryIntent
	}
	return nil
}

func (m *ResponseUnion) GetAdminScatter() *AdminScatterResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AdminScatter); ok {
		return x.AdminScatter
	}
	return nil
}

func (m *ResponseUnion) GetAddSstable() *AddSSTableResponse {
	if x, ok := m.GetValue().(*ResponseUnion_AddSstable); ok {
		return x.AddSstable
	}
	return nil
}

func (m *ResponseUnion) GetRecomputeStats() *RecomputeStatsResponse {
	if x, ok := m.GetValue().(*ResponseUnion_RecomputeStats); ok {
		return x.RecomputeStats
	}
	return nil
}

func (m *ResponseUnion) GetRefresh() *RefreshResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Refresh); ok {
		return x.Refresh
	}
	return nil
}

func (m *ResponseUnion) GetRefreshRange() *RefreshRangeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_RefreshRange); ok {
		return x.RefreshRange
	}
	return nil
}

func (m *ResponseUnion) GetSubsume() *SubsumeResponse {
	if x, ok := m.GetValue().(*ResponseUnion_Subsume); ok {
		return x.Subsume
	}
	return nil
}

func (m *ResponseUnion) GetRangeStats() *RangeStatsResponse {
	if x, ok := m.GetValue().(*ResponseUnion_RangeStats); ok {
		return x.RangeStats
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ResponseUnion) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ResponseUnion_OneofMarshaler, _ResponseUnion_OneofUnmarshaler, _ResponseUnion_OneofSizer, []interface{}{
		(*ResponseUnion_Get)(nil),
		(*ResponseUnion_Put)(nil),
		(*ResponseUnion_ConditionalPut)(nil),
		(*ResponseUnion_Increment)(nil),
		(*ResponseUnion_Delete)(nil),
		(*ResponseUnion_DeleteRange)(nil),
		(*ResponseUnion_ClearRange)(nil),
		(*ResponseUnion_Scan)(nil),
		(*ResponseUnion_BeginTransaction)(nil),
		(*ResponseUnion_EndTransaction)(nil),
		(*ResponseUnion_AdminSplit)(nil),
		(*ResponseUnion_AdminMerge)(nil),
		(*ResponseUnion_AdminTransferLease)(nil),
		(*ResponseUnion_AdminChangeReplicas)(nil),
		(*ResponseUnion_AdminRelocateRange)(nil),
		(*ResponseUnion_HeartbeatTxn)(nil),
		(*ResponseUnion_Gc)(nil),
		(*ResponseUnion_PushTxn)(nil),
		(*ResponseUnion_ResolveIntent)(nil),
		(*ResponseUnion_ResolveIntentRange)(nil),
		(*ResponseUnion_Merge)(nil),
		(*ResponseUnion_TruncateLog)(nil),
		(*ResponseUnion_RequestLease)(nil),
		(*ResponseUnion_ReverseScan)(nil),
		(*ResponseUnion_ComputeChecksum)(nil),
		(*ResponseUnion_CheckConsistency)(nil),
		(*ResponseUnion_InitPut)(nil),
		(*ResponseUnion_LeaseInfo)(nil),
		(*ResponseUnion_WriteBatch)(nil),
		(*ResponseUnion_Export)(nil),
		(*ResponseUnion_Import)(nil),
		(*ResponseUnion_QueryTxn)(nil),
		(*ResponseUnion_QueryIntent)(nil),
		(*ResponseUnion_AdminScatter)(nil),
		(*ResponseUnion_AddSstable)(nil),
		(*ResponseUnion_RecomputeStats)(nil),
		(*ResponseUnion_Refresh)(nil),
		(*ResponseUnion_RefreshRange)(nil),
		(*ResponseUnion_Subsume)(nil),
		(*ResponseUnion_RangeStats)(nil),
	}
}

func _ResponseUnion_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ResponseUnion)
	// value
	switch x := m.Value.(type) {
	case *ResponseUnion_Get:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Get); err != nil {
			return err
		}
	case *ResponseUnion_Put:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Put); err != nil {
			return err
		}
	case *ResponseUnion_ConditionalPut:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ConditionalPut); err != nil {
			return err
		}
	case *ResponseUnion_Increment:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Increment); err != nil {
			return err
		}
	case *ResponseUnion_Delete:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Delete); err != nil {
			return err
		}
	case *ResponseUnion_DeleteRange:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteRange); err != nil {
			return err
		}
	case *ResponseUnion_ClearRange:
		_ = b.EncodeVarint(38<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClearRange); err != nil {
			return err
		}
	case *ResponseUnion_Scan:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Scan); err != nil {
			return err
		}
	case *ResponseUnion_BeginTransaction:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BeginTransaction); err != nil {
			return err
		}
	case *ResponseUnion_EndTransaction:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EndTransaction); err != nil {
			return err
		}
	case *ResponseUnion_AdminSplit:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminSplit); err != nil {
			return err
		}
	case *ResponseUnion_AdminMerge:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminMerge); err != nil {
			return err
		}
	case *ResponseUnion_AdminTransferLease:
		_ = b.EncodeVarint(29<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminTransferLease); err != nil {
			return err
		}
	case *ResponseUnion_AdminChangeReplicas:
		_ = b.EncodeVarint(35<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminChangeReplicas); err != nil {
			return err
		}
	case *ResponseUnion_AdminRelocateRange:
		_ = b.EncodeVarint(45<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminRelocateRange); err != nil {
			return err
		}
	case *ResponseUnion_HeartbeatTxn:
		_ = b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HeartbeatTxn); err != nil {
			return err
		}
	case *ResponseUnion_Gc:
		_ = b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Gc); err != nil {
			return err
		}
	case *ResponseUnion_PushTxn:
		_ = b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PushTxn); err != nil {
			return err
		}
	case *ResponseUnion_ResolveIntent:
		_ = b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResolveIntent); err != nil {
			return err
		}
	case *ResponseUnion_ResolveIntentRange:
		_ = b.EncodeVarint(17<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResolveIntentRange); err != nil {
			return err
		}
	case *ResponseUnion_Merge:
		_ = b.EncodeVarint(18<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Merge); err != nil {
			return err
		}
	case *ResponseUnion_TruncateLog:
		_ = b.EncodeVarint(19<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TruncateLog); err != nil {
			return err
		}
	case *ResponseUnion_RequestLease:
		_ = b.EncodeVarint(20<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RequestLease); err != nil {
			return err
		}
	case *ResponseUnion_ReverseScan:
		_ = b.EncodeVarint(21<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReverseScan); err != nil {
			return err
		}
	case *ResponseUnion_ComputeChecksum:
		_ = b.EncodeVarint(22<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ComputeChecksum); err != nil {
			return err
		}
	case *ResponseUnion_CheckConsistency:
		_ = b.EncodeVarint(24<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CheckConsistency); err != nil {
			return err
		}
	case *ResponseUnion_InitPut:
		_ = b.EncodeVarint(26<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InitPut); err != nil {
			return err
		}
	case *ResponseUnion_LeaseInfo:
		_ = b.EncodeVarint(30<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LeaseInfo); err != nil {
			return err
		}
	case *ResponseUnion_WriteBatch:
		_ = b.EncodeVarint(31<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WriteBatch); err != nil {
			return err
		}
	case *ResponseUnion_Export:
		_ = b.EncodeVarint(32<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Export); err != nil {
			return err
		}
	case *ResponseUnion_Import:
		_ = b.EncodeVarint(34<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Import); err != nil {
			return err
		}
	case *ResponseUnion_QueryTxn:
		_ = b.EncodeVarint(33<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryTxn); err != nil {
			return err
		}
	case *ResponseUnion_QueryIntent:
		_ = b.EncodeVarint(42<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryIntent); err != nil {
			return err
		}
	case *ResponseUnion_AdminScatter:
		_ = b.EncodeVarint(36<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdminScatter); err != nil {
			return err
		}
	case *ResponseUnion_AddSstable:
		_ = b.EncodeVarint(37<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AddSstable); err != nil {
			return err
		}
	case *ResponseUnion_RecomputeStats:
		_ = b.EncodeVarint(39<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RecomputeStats); err != nil {
			return err
		}
	case *ResponseUnion_Refresh:
		_ = b.EncodeVarint(40<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Refresh); err != nil {
			return err
		}
	case *ResponseUnion_RefreshRange:
		_ = b.EncodeVarint(41<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RefreshRange); err != nil {
			return err
		}
	case *ResponseUnion_Subsume:
		_ = b.EncodeVarint(43<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Subsume); err != nil {
			return err
		}
	case *ResponseUnion_RangeStats:
		_ = b.EncodeVarint(44<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RangeStats); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ResponseUnion.Value has unexpected type %T", x)
	}
	return nil
}

func _ResponseUnion_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ResponseUnion)
	switch tag {
	case 1: // value.get
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GetResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Get{msg}
		return true, err
	case 2: // value.put
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PutResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Put{msg}
		return true, err
	case 3: // value.conditional_put
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ConditionalPutResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_ConditionalPut{msg}
		return true, err
	case 4: // value.increment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(IncrementResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Increment{msg}
		return true, err
	case 5: // value.delete
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DeleteResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Delete{msg}
		return true, err
	case 6: // value.delete_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DeleteRangeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_DeleteRange{msg}
		return true, err
	case 38: // value.clear_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClearRangeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_ClearRange{msg}
		return true, err
	case 7: // value.scan
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ScanResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Scan{msg}
		return true, err
	case 8: // value.begin_transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BeginTransactionResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_BeginTransaction{msg}
		return true, err
	case 9: // value.end_transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EndTransactionResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_EndTransaction{msg}
		return true, err
	case 10: // value.admin_split
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminSplitResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AdminSplit{msg}
		return true, err
	case 11: // value.admin_merge
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminMergeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AdminMerge{msg}
		return true, err
	case 29: // value.admin_transfer_lease
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminTransferLeaseResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AdminTransferLease{msg}
		return true, err
	case 35: // value.admin_change_replicas
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminChangeReplicasResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AdminChangeReplicas{msg}
		return true, err
	case 45: // value.admin_relocate_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminRelocateRangeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AdminRelocateRange{msg}
		return true, err
	case 12: // value.heartbeat_txn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HeartbeatTxnResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_HeartbeatTxn{msg}
		return true, err
	case 13: // value.gc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GCResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Gc{msg}
		return true, err
	case 14: // value.push_txn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PushTxnResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_PushTxn{msg}
		return true, err
	case 16: // value.resolve_intent
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ResolveIntentResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_ResolveIntent{msg}
		return true, err
	case 17: // value.resolve_intent_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ResolveIntentRangeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_ResolveIntentRange{msg}
		return true, err
	case 18: // value.merge
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MergeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Merge{msg}
		return true, err
	case 19: // value.truncate_log
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TruncateLogResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_TruncateLog{msg}
		return true, err
	case 20: // value.request_lease
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RequestLeaseResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_RequestLease{msg}
		return true, err
	case 21: // value.reverse_scan
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReverseScanResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_ReverseScan{msg}
		return true, err
	case 22: // value.compute_checksum
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ComputeChecksumResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_ComputeChecksum{msg}
		return true, err
	case 24: // value.check_consistency
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CheckConsistencyResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_CheckConsistency{msg}
		return true, err
	case 26: // value.init_put
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InitPutResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_InitPut{msg}
		return true, err
	case 30: // value.lease_info
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(LeaseInfoResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_LeaseInfo{msg}
		return true, err
	case 31: // value.write_batch
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(WriteBatchResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_WriteBatch{msg}
		return true, err
	case 32: // value.export
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ExportResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Export{msg}
		return true, err
	case 34: // value.import
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ImportResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Import{msg}
		return true, err
	case 33: // value.query_txn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryTxnResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_QueryTxn{msg}
		return true, err
	case 42: // value.query_intent
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryIntentResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_QueryIntent{msg}
		return true, err
	case 36: // value.admin_scatter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdminScatterResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AdminScatter{msg}
		return true, err
	case 37: // value.add_sstable
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AddSSTableResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_AddSstable{msg}
		return true, err
	case 39: // value.recompute_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RecomputeStatsResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_RecomputeStats{msg}
		return true, err
	case 40: // value.refresh
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RefreshResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Refresh{msg}
		return true, err
	case 41: // value.refresh_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RefreshRangeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_RefreshRange{msg}
		return true, err
	case 43: // value.subsume
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SubsumeResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_Subsume{msg}
		return true, err
	case 44: // value.range_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RangeStatsResponse)
		err := b.DecodeMessage(msg)
		m.Value = &ResponseUnion_RangeStats{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ResponseUnion_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ResponseUnion)
	// value
	switch x := m.Value.(type) {
	case *ResponseUnion_Get:
		s := proto.Size(x.Get)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Put:
		s := proto.Size(x.Put)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_ConditionalPut:
		s := proto.Size(x.ConditionalPut)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Increment:
		s := proto.Size(x.Increment)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Delete:
		s := proto.Size(x.Delete)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_DeleteRange:
		s := proto.Size(x.DeleteRange)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_ClearRange:
		s := proto.Size(x.ClearRange)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Scan:
		s := proto.Size(x.Scan)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_BeginTransaction:
		s := proto.Size(x.BeginTransaction)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_EndTransaction:
		s := proto.Size(x.EndTransaction)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AdminSplit:
		s := proto.Size(x.AdminSplit)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AdminMerge:
		s := proto.Size(x.AdminMerge)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AdminTransferLease:
		s := proto.Size(x.AdminTransferLease)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AdminChangeReplicas:
		s := proto.Size(x.AdminChangeReplicas)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AdminRelocateRange:
		s := proto.Size(x.AdminRelocateRange)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_HeartbeatTxn:
		s := proto.Size(x.HeartbeatTxn)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Gc:
		s := proto.Size(x.Gc)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_PushTxn:
		s := proto.Size(x.PushTxn)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_ResolveIntent:
		s := proto.Size(x.ResolveIntent)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_ResolveIntentRange:
		s := proto.Size(x.ResolveIntentRange)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Merge:
		s := proto.Size(x.Merge)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_TruncateLog:
		s := proto.Size(x.TruncateLog)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_RequestLease:
		s := proto.Size(x.RequestLease)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_ReverseScan:
		s := proto.Size(x.ReverseScan)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_ComputeChecksum:
		s := proto.Size(x.ComputeChecksum)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_CheckConsistency:
		s := proto.Size(x.CheckConsistency)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_InitPut:
		s := proto.Size(x.InitPut)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_LeaseInfo:
		s := proto.Size(x.LeaseInfo)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_WriteBatch:
		s := proto.Size(x.WriteBatch)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Export:
		s := proto.Size(x.Export)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Import:
		s := proto.Size(x.Import)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_QueryTxn:
		s := proto.Size(x.QueryTxn)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_QueryIntent:
		s := proto.Size(x.QueryIntent)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AdminScatter:
		s := proto.Size(x.AdminScatter)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_AddSstable:
		s := proto.Size(x.AddSstable)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_RecomputeStats:
		s := proto.Size(x.RecomputeStats)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Refresh:
		s := proto.Size(x.Refresh)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_RefreshRange:
		s := proto.Size(x.RefreshRange)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_Subsume:
		s := proto.Size(x.Subsume)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ResponseUnion_RangeStats:
		s := proto.Size(x.RangeStats)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Header is attached to a BatchRequest, encapsulating routing and auxiliary
// information required for executing it.
type Header struct {
	// timestamp specifies time at which read or writes should be
	// performed. If the timestamp is set to zero value, its value
	// is initialized to the wall time of the receiving node.
	Timestamp hlc.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp"`
	// replica specifies the destination of the request.
	Replica ReplicaDescriptor `protobuf:"bytes,2,opt,name=replica,proto3" json:"replica"`
	// range_id specifies the ID of the Raft consensus group which the key
	// range belongs to. This is used by the receiving node to route the
	// request to the correct range.
	RangeID RangeID `protobuf:"varint,3,opt,name=range_id,json=rangeId,proto3,casttype=RangeID" json:"range_id,omitempty"`
	// user_priority allows any command's priority to be biased from the
	// default random priority. It specifies a multiple. If set to 0.5,
	// the chosen priority will be 1/2x as likely to beat any default
	// random priority. If set to 1, a default random priority is
	// chosen. If set to 2, the chosen priority will be 2x as likely to
	// beat any default random priority, and so on. As a special case, 0
	// priority is treated the same as 1. This value is ignored if txn
	// is specified. The min and max user priorities are set via
	// MinUserPriority and MaxUserPriority in data.go.
	UserPriority UserPriority `protobuf:"fixed64,4,opt,name=user_priority,json=userPriority,proto3,casttype=UserPriority" json:"user_priority,omitempty"`
	// txn is set non-nil if a transaction is underway. To start a txn,
	// the first request should set this field to non-nil with name and
	// isolation level set as desired. The response will contain the
	// fully-initialized transaction with txn ID, priority, initial
	// timestamp, and maximum timestamp.
	Txn *Transaction `protobuf:"bytes,5,opt,name=txn,proto3" json:"txn,omitempty"`
	// read_consistency specifies the consistency for read
	// operations. The default is CONSISTENT. This value is ignored for
	// write operations.
	ReadConsistency ReadConsistencyType `protobuf:"varint,6,opt,name=read_consistency,json=readConsistency,proto3,enum=cockroach.roachpb.ReadConsistencyType" json:"read_consistency,omitempty"`
	// If set to a non-zero value, it limits the total number of keys touched
	// by span requests in the batch. Span requests are requests like
	// Scan, ReverseScan, and DelRange. If two requests touch the
	// same key it is double counted.
	//
	// If a batch limit is used with Scan requests, the spans for the requests
	// must be non-overlapping and in increasing order.
	//
	// If a batch limit is used with ReverseScan requests, the spans for the
	// requests must be non-overlapping and in decreasing order.
	MaxSpanRequestKeys int64 `protobuf:"varint,8,opt,name=max_span_request_keys,json=maxSpanRequestKeys,proto3" json:"max_span_request_keys,omitempty"`
	// If set, all of the spans in the batch are distinct. Note that the
	// calculation of distinct spans does not include intents in an
	// EndTransactionRequest. Currently set conservatively: a request
	// might be composed of distinct spans yet have this field set to
	// false.
	DistinctSpans bool `protobuf:"varint,9,opt,name=distinct_spans,json=distinctSpans,proto3" json:"distinct_spans,omitempty"`
	// If set, return_range_info causes RangeInfo details to be returned with
	// each ResponseHeader.
	ReturnRangeInfo bool `protobuf:"varint,10,opt,name=return_range_info,json=returnRangeInfo,proto3" json:"return_range_info,omitempty"`
	// gateway_node_id is the ID of the gateway node where the request originated.
	GatewayNodeID NodeID       `protobuf:"varint,11,opt,name=gateway_node_id,json=gatewayNodeId,proto3,casttype=NodeID" json:"gateway_node_id,omitempty"`
	ScanOptions   *ScanOptions `protobuf:"bytes,12,opt,name=scan_options,json=scanOptions,proto3" json:"scan_options,omitempty"`
	// If set, the request will return to the client before proposing the
	// request into Raft. All consensus processing will be performed
	// asynchronously. Because consensus may fail, this means that the
	// request cannot be expected to succeed. Instead, its success must
	// be verified.
	// TODO(nvanbenschoten): Handling cases where consensus fails would
	// be much more straightforward if all transactional requests were
	// idempotent. We could just re-issue requests. See #26915.
	AsyncConsensus       bool     `protobuf:"varint,13,opt,name=async_consensus,json=asyncConsensus,proto3" json:"async_consensus,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Header) Reset()         { *m = Header{} }
func (m *Header) String() string { return proto.CompactTextString(m) }
func (*Header) ProtoMessage()    {}
func (*Header) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{89}
}
func (m *Header) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Header) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *Header) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Header.Merge(dst, src)
}
func (m *Header) XXX_Size() int {
	return m.Size()
}
func (m *Header) XXX_DiscardUnknown() {
	xxx_messageInfo_Header.DiscardUnknown(m)
}

var xxx_messageInfo_Header proto.InternalMessageInfo

// A BatchRequest contains one or more requests to be executed in
// parallel, or if applicable (based on write-only commands and
// range-locality), as a single update.
type BatchRequest struct {
	Header               `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Requests             []RequestUnion `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *BatchRequest) Reset()      { *m = BatchRequest{} }
func (*BatchRequest) ProtoMessage() {}
func (*BatchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{90}
}
func (m *BatchRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BatchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *BatchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchRequest.Merge(dst, src)
}
func (m *BatchRequest) XXX_Size() int {
	return m.Size()
}
func (m *BatchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchRequest proto.InternalMessageInfo

// A BatchResponse contains one or more responses, one per request
// corresponding to the requests in the matching BatchRequest. The
// error in the response header is set to the first error from the
// slice of responses, if applicable.
type BatchResponse struct {
	BatchResponse_Header `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Responses            []ResponseUnion `protobuf:"bytes,2,rep,name=responses,proto3" json:"responses"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *BatchResponse) Reset()      { *m = BatchResponse{} }
func (*BatchResponse) ProtoMessage() {}
func (*BatchResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{91}
}
func (m *BatchResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BatchResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *BatchResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchResponse.Merge(dst, src)
}
func (m *BatchResponse) XXX_Size() int {
	return m.Size()
}
func (m *BatchResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchResponse proto.InternalMessageInfo

type BatchResponse_Header struct {
	// error communicates a structured error (i.e. one originating from a Node)
	// while the BatchResponse is sent over the network. If the code were
	// written today, the RPC endpoint would return a message containing both a
	// BatchResponse and an Error, and this embedding would go away. However, it
	// returns only a BatchResponse, and so the Error needs to be tucked away
	// somewhere (the structured error cannot be communicated via an RPC-level
	// error).
	//
	// Outside of the RPC boundaries, this field is nil and must neither be
	// checked nor populated (it is reset by the DistSender, which extracts this
	// error and returns it separately). In effect, nearly no usage of
	// BatchResponse needs to care about this field.
	Error *Error `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// timestamp is set only for non-transactional responses and denotes the
	// timestamp at which the batch executed. The timestamp cache is updated
	// at this timestamp.
	Timestamp hlc.Timestamp `protobuf:"bytes,2,opt,name=Timestamp,proto3" json:"Timestamp"`
	// txn is non-nil if the request specified a non-nil
	// transaction. The transaction timestamp and/or priority may have
	// been updated, depending on the outcome of the request.
	Txn *Transaction `protobuf:"bytes,3,opt,name=txn,proto3" json:"txn,omitempty"`
	// now is the highest current time from any node contacted during the request.
	// It can be used by the receiver to update its local HLC.
	Now hlc.Timestamp `protobuf:"bytes,5,opt,name=now,proto3" json:"now"`
	// collected_spans stores trace spans recorded during the execution of this
	// request.
	CollectedSpans       []tracing.RecordedSpan `protobuf:"bytes,6,rep,name=collected_spans,json=collectedSpans,proto3" json:"collected_spans"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *BatchResponse_Header) Reset()         { *m = BatchResponse_Header{} }
func (m *BatchResponse_Header) String() string { return proto.CompactTextString(m) }
func (*BatchResponse_Header) ProtoMessage()    {}
func (*BatchResponse_Header) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{91, 0}
}
func (m *BatchResponse_Header) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BatchResponse_Header) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *BatchResponse_Header) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchResponse_Header.Merge(dst, src)
}
func (m *BatchResponse_Header) XXX_Size() int {
	return m.Size()
}
func (m *BatchResponse_Header) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchResponse_Header.DiscardUnknown(m)
}

var xxx_messageInfo_BatchResponse_Header proto.InternalMessageInfo

// RangeFeedRequest is a request that expresses the intention to establish a
// RangeFeed stream over the provided span, starting at the specified timestamp.
type RangeFeedRequest struct {
	Header               `protobuf:"bytes,1,opt,name=header,proto3,embedded=header" json:"header"`
	Span                 Span     `protobuf:"bytes,2,opt,name=span,proto3" json:"span"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RangeFeedRequest) Reset()         { *m = RangeFeedRequest{} }
func (m *RangeFeedRequest) String() string { return proto.CompactTextString(m) }
func (*RangeFeedRequest) ProtoMessage()    {}
func (*RangeFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{92}
}
func (m *RangeFeedRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeFeedRequest.Merge(dst, src)
}
func (m *RangeFeedRequest) XXX_Size() int {
	return m.Size()
}
func (m *RangeFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RangeFeedRequest proto.InternalMessageInfo

// RangeFeedValue is a variant of RangeFeedEvent that represents an update to
// the specified key with the provided value.
type RangeFeedValue struct {
	Key                  Key      `protobuf:"bytes,1,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	Value                Value    `protobuf:"bytes,2,opt,name=value,proto3" json:"value"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RangeFeedValue) Reset()         { *m = RangeFeedValue{} }
func (m *RangeFeedValue) String() string { return proto.CompactTextString(m) }
func (*RangeFeedValue) ProtoMessage()    {}
func (*RangeFeedValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{93}
}
func (m *RangeFeedValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeFeedValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeFeedValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeFeedValue.Merge(dst, src)
}
func (m *RangeFeedValue) XXX_Size() int {
	return m.Size()
}
func (m *RangeFeedValue) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeFeedValue.DiscardUnknown(m)
}

var xxx_messageInfo_RangeFeedValue proto.InternalMessageInfo

// RangeFeedCheckpoint is a variant of RangeFeedEvent that represents the
// promise that no more RangeFeedValue events with keys in the specified span
// with timestamps less than or equal to the specified resolved timestamp will
// be emitted on the RangeFeed response stream.
type RangeFeedCheckpoint struct {
	Span                 Span          `protobuf:"bytes,1,opt,name=span,proto3" json:"span"`
	ResolvedTS           hlc.Timestamp `protobuf:"bytes,2,opt,name=resolved_ts,json=resolvedTs,proto3" json:"resolved_ts"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *RangeFeedCheckpoint) Reset()         { *m = RangeFeedCheckpoint{} }
func (m *RangeFeedCheckpoint) String() string { return proto.CompactTextString(m) }
func (*RangeFeedCheckpoint) ProtoMessage()    {}
func (*RangeFeedCheckpoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{94}
}
func (m *RangeFeedCheckpoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeFeedCheckpoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeFeedCheckpoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeFeedCheckpoint.Merge(dst, src)
}
func (m *RangeFeedCheckpoint) XXX_Size() int {
	return m.Size()
}
func (m *RangeFeedCheckpoint) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeFeedCheckpoint.DiscardUnknown(m)
}

var xxx_messageInfo_RangeFeedCheckpoint proto.InternalMessageInfo

// RangeFeedError is a variant of RangeFeedEvent that indicates that an error
// occurred during the processing of the RangeFeed. If emitted, a RangeFeedError
// event will always be the final event on a RangeFeed response stream before
// it is torn down.
type RangeFeedError struct {
	Error                Error    `protobuf:"bytes,1,opt,name=error,proto3" json:"error"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RangeFeedError) Reset()         { *m = RangeFeedError{} }
func (m *RangeFeedError) String() string { return proto.CompactTextString(m) }
func (*RangeFeedError) ProtoMessage()    {}
func (*RangeFeedError) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{95}
}
func (m *RangeFeedError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeFeedError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeFeedError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeFeedError.Merge(dst, src)
}
func (m *RangeFeedError) XXX_Size() int {
	return m.Size()
}
func (m *RangeFeedError) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeFeedError.DiscardUnknown(m)
}

var xxx_messageInfo_RangeFeedError proto.InternalMessageInfo

// RangeFeedEvent is a union of all event types that may be returned on a
// RangeFeed response stream.
type RangeFeedEvent struct {
	Val                  *RangeFeedValue      `protobuf:"bytes,1,opt,name=val,proto3" json:"val,omitempty"`
	Checkpoint           *RangeFeedCheckpoint `protobuf:"bytes,2,opt,name=checkpoint,proto3" json:"checkpoint,omitempty"`
	Error                *RangeFeedError      `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *RangeFeedEvent) Reset()         { *m = RangeFeedEvent{} }
func (m *RangeFeedEvent) String() string { return proto.CompactTextString(m) }
func (*RangeFeedEvent) ProtoMessage()    {}
func (*RangeFeedEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_a444025f5929ff5f, []int{96}
}
func (m *RangeFeedEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeFeedEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeFeedEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeFeedEvent.Merge(dst, src)
}
func (m *RangeFeedEvent) XXX_Size() int {
	return m.Size()
}
func (m *RangeFeedEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeFeedEvent.DiscardUnknown(m)
}

var xxx_messageInfo_RangeFeedEvent proto.InternalMessageInfo

func init() {
	proto.RegisterType((*RangeInfo)(nil), "cockroach.roachpb.RangeInfo")
	proto.RegisterType((*RequestHeader)(nil), "cockroach.roachpb.RequestHeader")
	proto.RegisterType((*ResponseHeader)(nil), "cockroach.roachpb.ResponseHeader")
	proto.RegisterType((*GetRequest)(nil), "cockroach.roachpb.GetRequest")
	proto.RegisterType((*GetResponse)(nil), "cockroach.roachpb.GetResponse")
	proto.RegisterType((*PutRequest)(nil), "cockroach.roachpb.PutRequest")
	proto.RegisterType((*PutResponse)(nil), "cockroach.roachpb.PutResponse")
	proto.RegisterType((*ConditionalPutRequest)(nil), "cockroach.roachpb.ConditionalPutRequest")
	proto.RegisterType((*ConditionalPutResponse)(nil), "cockroach.roachpb.ConditionalPutResponse")
	proto.RegisterType((*InitPutRequest)(nil), "cockroach.roachpb.InitPutRequest")
	proto.RegisterType((*InitPutResponse)(nil), "cockroach.roachpb.InitPutResponse")
	proto.RegisterType((*IncrementRequest)(nil), "cockroach.roachpb.IncrementRequest")
	proto.RegisterType((*IncrementResponse)(nil), "cockroach.roachpb.IncrementResponse")
	proto.RegisterType((*DeleteRequest)(nil), "cockroach.roachpb.DeleteRequest")
	proto.RegisterType((*DeleteResponse)(nil), "cockroach.roachpb.DeleteResponse")
	proto.RegisterType((*DeleteRangeRequest)(nil), "cockroach.roachpb.DeleteRangeRequest")
	proto.RegisterType((*DeleteRangeResponse)(nil), "cockroach.roachpb.DeleteRangeResponse")
	proto.RegisterType((*ClearRangeRequest)(nil), "cockroach.roachpb.ClearRangeRequest")
	proto.RegisterType((*ClearRangeResponse)(nil), "cockroach.roachpb.ClearRangeResponse")
	proto.RegisterType((*ScanOptions)(nil), "cockroach.roachpb.ScanOptions")
	proto.RegisterType((*ScanRequest)(nil), "cockroach.roachpb.ScanRequest")
	proto.RegisterType((*ScanResponse)(nil), "cockroach.roachpb.ScanResponse")
	proto.RegisterType((*ReverseScanRequest)(nil), "cockroach.roachpb.ReverseScanRequest")
	proto.RegisterType((*ReverseScanResponse)(nil), "cockroach.roachpb.ReverseScanResponse")
	proto.RegisterType((*CheckConsistencyRequest)(nil), "cockroach.roachpb.CheckConsistencyRequest")
	proto.RegisterType((*CheckConsistencyResponse)(nil), "cockroach.roachpb.CheckConsistencyResponse")
	proto.RegisterType((*CheckConsistencyResponse_Result)(nil), "cockroach.roachpb.CheckConsistencyResponse.Result")
	proto.RegisterType((*RecomputeStatsRequest)(nil), "cockroach.roachpb.RecomputeStatsRequest")
	proto.RegisterType((*RecomputeStatsResponse)(nil), "cockroach.roachpb.RecomputeStatsResponse")
	proto.RegisterType((*BeginTransactionRequest)(nil), "cockroach.roachpb.BeginTransactionRequest")
	proto.RegisterType((*BeginTransactionResponse)(nil), "cockroach.roachpb.BeginTransactionResponse")
	proto.RegisterType((*EndTransactionRequest)(nil), "cockroach.roachpb.EndTransactionRequest")
	proto.RegisterType((*EndTransactionResponse)(nil), "cockroach.roachpb.EndTransactionResponse")
	proto.RegisterType((*AdminSplitRequest)(nil), "cockroach.roachpb.AdminSplitRequest")
	proto.RegisterType((*AdminSplitResponse)(nil), "cockroach.roachpb.AdminSplitResponse")
	proto.RegisterType((*AdminMergeRequest)(nil), "cockroach.roachpb.AdminMergeRequest")
	proto.RegisterType((*AdminMergeResponse)(nil), "cockroach.roachpb.AdminMergeResponse")
	proto.RegisterType((*AdminTransferLeaseRequest)(nil), "cockroach.roachpb.AdminTransferLeaseRequest")
	proto.RegisterType((*AdminTransferLeaseResponse)(nil), "cockroach.roachpb.AdminTransferLeaseResponse")
	proto.RegisterType((*AdminChangeReplicasRequest)(nil), "cockroach.roachpb.AdminChangeReplicasRequest")
	proto.RegisterType((*AdminChangeReplicasResponse)(nil), "cockroach.roachpb.AdminChangeReplicasResponse")
	proto.RegisterType((*AdminRelocateRangeRequest)(nil), "cockroach.roachpb.AdminRelocateRangeRequest")
	proto.RegisterType((*AdminRelocateRangeResponse)(nil), "cockroach.roachpb.AdminRelocateRangeResponse")
	proto.RegisterType((*HeartbeatTxnRequest)(nil), "cockroach.roachpb.HeartbeatTxnRequest")
	proto.RegisterType((*HeartbeatTxnResponse)(nil), "cockroach.roachpb.HeartbeatTxnResponse")
	proto.RegisterType((*GCRequest)(nil), "cockroach.roachpb.GCRequest")
	proto.RegisterType((*GCRequest_GCKey)(nil), "cockroach.roachpb.GCRequest.GCKey")
	proto.RegisterType((*GCResponse)(nil), "cockroach.roachpb.GCResponse")
	proto.RegisterType((*PushTxnRequest)(nil), "cockroach.roachpb.PushTxnRequest")
	proto.RegisterType((*PushTxnResponse)(nil), "cockroach.roachpb.PushTxnResponse")
	proto.RegisterType((*QueryTxnRequest)(nil), "cockroach.roachpb.QueryTxnRequest")
	proto.RegisterType((*QueryTxnResponse)(nil), "cockroach.roachpb.QueryTxnResponse")
	proto.RegisterType((*QueryIntentRequest)(nil), "cockroach.roachpb.QueryIntentRequest")
	proto.RegisterType((*QueryIntentResponse)(nil), "cockroach.roachpb.QueryIntentResponse")
	proto.RegisterType((*ResolveIntentRequest)(nil), "cockroach.roachpb.ResolveIntentRequest")
	proto.RegisterType((*ResolveIntentResponse)(nil), "cockroach.roachpb.ResolveIntentResponse")
	proto.RegisterType((*ResolveIntentRangeRequest)(nil), "cockroach.roachpb.ResolveIntentRangeRequest")
	proto.RegisterType((*ResolveIntentRangeResponse)(nil), "cockroach.roachpb.ResolveIntentRangeResponse")
	proto.RegisterType((*MergeRequest)(nil), "cockroach.roachpb.MergeRequest")
	proto.RegisterType((*MergeResponse)(nil), "cockroach.roachpb.MergeResponse")
	proto.RegisterType((*TruncateLogRequest)(nil), "cockroach.roachpb.TruncateLogRequest")
	proto.RegisterType((*TruncateLogResponse)(nil), "cockroach.roachpb.TruncateLogResponse")
	proto.RegisterType((*RequestLeaseRequest)(nil), "cockroach.roachpb.RequestLeaseRequest")
	proto.RegisterType((*TransferLeaseRequest)(nil), "cockroach.roachpb.TransferLeaseRequest")
	proto.RegisterType((*LeaseInfoRequest)(nil), "cockroach.roachpb.LeaseInfoRequest")
	proto.RegisterType((*LeaseInfoResponse)(nil), "cockroach.roachpb.LeaseInfoResponse")
	proto.RegisterType((*RequestLeaseResponse)(nil), "cockroach.roachpb.RequestLeaseResponse")
	proto.RegisterType((*ComputeChecksumRequest)(nil), "cockroach.roachpb.ComputeChecksumRequest")
	proto.RegisterType((*ComputeChecksumResponse)(nil), "cockroach.roachpb.ComputeChecksumResponse")
	proto.RegisterType((*ExportStorage)(nil), "cockroach.roachpb.ExportStorage")
	proto.RegisterType((*ExportStorage_LocalFilePath)(nil), "cockroach.roachpb.ExportStorage.LocalFilePath")
	proto.RegisterType((*ExportStorage_Http)(nil), "cockroach.roachpb.ExportStorage.Http")
	proto.RegisterType((*ExportStorage_S3)(nil), "cockroach.roachpb.ExportStorage.S3")
	proto.RegisterType((*ExportStorage_GCS)(nil), "cockroach.roachpb.ExportStorage.GCS")
	proto.RegisterType((*ExportStorage_Azure)(nil), "cockroach.roachpb.ExportStorage.Azure")
	proto.RegisterType((*ExportStorage_Workload)(nil), "cockroach.roachpb.ExportStorage.Workload")
	proto.RegisterType((*WriteBatchRequest)(nil), "cockroach.roachpb.WriteBatchRequest")
	proto.RegisterType((*WriteBatchResponse)(nil), "cockroach.roachpb.WriteBatchResponse")
	proto.RegisterType((*ExportRequest)(nil), "cockroach.roachpb.ExportRequest")
	proto.RegisterType((*BulkOpSummary)(nil), "cockroach.roachpb.BulkOpSummary")
	proto.RegisterType((*ExportResponse)(nil), "cockroach.roachpb.ExportResponse")
	proto.RegisterType((*ExportResponse_File)(nil), "cockroach.roachpb.ExportResponse.File")
	proto.RegisterType((*ImportRequest)(nil), "cockroach.roachpb.ImportRequest")
	proto.RegisterType((*ImportRequest_File)(nil), "cockroach.roachpb.ImportRequest.File")
	proto.RegisterType((*ImportRequest_TableRekey)(nil), "cockroach.roachpb.ImportRequest.TableRekey")
	proto.RegisterType((*ImportResponse)(nil), "cockroach.roachpb.ImportResponse")
	proto.RegisterType((*AdminScatterRequest)(nil), "cockroach.roachpb.AdminScatterRequest")
	proto.RegisterType((*AdminScatterResponse)(nil), "cockroach.roachpb.AdminScatterResponse")
	proto.RegisterType((*AdminScatterResponse_Range)(nil), "cockroach.roachpb.AdminScatterResponse.Range")
	proto.RegisterType((*AddSSTableRequest)(nil), "cockroach.roachpb.AddSSTableRequest")
	proto.RegisterType((*AddSSTableResponse)(nil), "cockroach.roachpb.AddSSTableResponse")
	proto.RegisterType((*RefreshRequest)(nil), "cockroach.roachpb.RefreshRequest")
	proto.RegisterType((*RefreshResponse)(nil), "cockroach.roachpb.RefreshResponse")
	proto.RegisterType((*RefreshRangeRequest)(nil), "cockroach.roachpb.RefreshRangeRequest")
	proto.RegisterType((*RefreshRangeResponse)(nil), "cockroach.roachpb.RefreshRangeResponse")
	proto.RegisterType((*SubsumeRequest)(nil), "cockroach.roachpb.SubsumeRequest")
	proto.RegisterType((*SubsumeResponse)(nil), "cockroach.roachpb.SubsumeResponse")
	proto.RegisterType((*RangeStatsRequest)(nil), "cockroach.roachpb.RangeStatsRequest")
	proto.RegisterType((*RangeStatsResponse)(nil), "cockroach.roachpb.RangeStatsResponse")
	proto.RegisterType((*RequestUnion)(nil), "cockroach.roachpb.RequestUnion")
	proto.RegisterType((*ResponseUnion)(nil), "cockroach.roachpb.ResponseUnion")
	proto.RegisterType((*Header)(nil), "cockroach.roachpb.Header")
	proto.RegisterType((*BatchRequest)(nil), "cockroach.roachpb.BatchRequest")
	proto.RegisterType((*BatchResponse)(nil), "cockroach.roachpb.BatchResponse")
	proto.RegisterType((*BatchResponse_Header)(nil), "cockroach.roachpb.BatchResponse.Header")
	proto.RegisterType((*RangeFeedRequest)(nil), "cockroach.roachpb.RangeFeedRequest")
	proto.RegisterType((*RangeFeedValue)(nil), "cockroach.roachpb.RangeFeedValue")
	proto.RegisterType((*RangeFeedCheckpoint)(nil), "cockroach.roachpb.RangeFeedCheckpoint")
	proto.RegisterType((*RangeFeedError)(nil), "cockroach.roachpb.RangeFeedError")
	proto.RegisterType((*RangeFeedEvent)(nil), "cockroach.roachpb.RangeFeedEvent")
	proto.RegisterEnum("cockroach.roachpb.ReadConsistencyType", ReadConsistencyType_name, ReadConsistencyType_value)
	proto.RegisterEnum("cockroach.roachpb.ScanFormat", ScanFormat_name, ScanFormat_value)
	proto.RegisterEnum("cockroach.roachpb.ChecksumMode", ChecksumMode_name, ChecksumMode_value)
	proto.RegisterEnum("cockroach.roachpb.PushTxnType", PushTxnType_name, PushTxnType_value)
	proto.RegisterEnum("cockroach.roachpb.ExportStorageProvider", ExportStorageProvider_name, ExportStorageProvider_value)
	proto.RegisterEnum("cockroach.roachpb.MVCCFilter", MVCCFilter_name, MVCCFilter_value)
	proto.RegisterEnum("cockroach.roachpb.ResponseHeader_ResumeReason", ResponseHeader_ResumeReason_name, ResponseHeader_ResumeReason_value)
	proto.RegisterEnum("cockroach.roachpb.CheckConsistencyResponse_Status", CheckConsistencyResponse_Status_name, CheckConsistencyResponse_Status_value)
	proto.RegisterEnum("cockroach.roachpb.QueryIntentRequest_IfMissingBehavior", QueryIntentRequest_IfMissingBehavior_name, QueryIntentRequest_IfMissingBehavior_value)
}
func (this *RequestHeader) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RequestHeader)
	if !ok {
		that2, ok := that.(RequestHeader)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	if !bytes.Equal(this.EndKey, that1.EndKey) {
		return false
	}
	if this.Sequence != that1.Sequence {
		return false
	}
	return true
}
func (this *GetRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GetRequest)
	if !ok {
		that2, ok := that.(GetRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}
func (this *PutRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PutRequest)
	if !ok {
		that2, ok := that.(PutRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Value.Equal(&that1.Value) {
		return false
	}
	if this.Inline != that1.Inline {
		return false
	}
	if this.Blind != that1.Blind {
		return false
	}
	return true
}
func (this *ConditionalPutRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConditionalPutRequest)
	if !ok {
		that2, ok := that.(ConditionalPutRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Value.Equal(&that1.Value) {
		return false
	}
	if !this.ExpValue.Equal(that1.ExpValue) {
		return false
	}
	if this.Blind != that1.Blind {
		return false
	}
	if this.AllowIfDoesNotExist != that1.AllowIfDoesNotExist {
		return false
	}
	return true
}
func (this *InitPutRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*InitPutRequest)
	if !ok {
		that2, ok := that.(InitPutRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Value.Equal(&that1.Value) {
		return false
	}
	if this.Blind != that1.Blind {
		return false
	}
	if this.FailOnTombstones != that1.FailOnTombstones {
		return false
	}
	return true
}
func (this *IncrementRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*IncrementRequest)
	if !ok {
		that2, ok := that.(IncrementRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Increment != that1.Increment {
		return false
	}
	return true
}
func (this *DeleteRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DeleteRequest)
	if !ok {
		that2, ok := that.(DeleteRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}
func (this *DeleteRangeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DeleteRangeRequest)
	if !ok {
		that2, ok := that.(DeleteRangeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.ReturnKeys != that1.ReturnKeys {
		return false
	}
	if this.Inline != that1.Inline {
		return false
	}
	return true
}
func (this *ClearRangeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ClearRangeRequest)
	if !ok {
		that2, ok := that.(ClearRangeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}
func (this *ScanOptions) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScanOptions)
	if !ok {
		that2, ok := that.(ScanOptions)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.StopAtRangeBoundary != that1.StopAtRangeBoundary {
		return false
	}
	if this.MinResults != that1.MinResults {
		return false
	}
	return true
}
func (this *ScanRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ScanRequest)
	if !ok {
		that2, ok := that.(ScanRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.ScanFormat != that1.ScanFormat {
		return false
	}
	return true
}
func (this *ReverseScanRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReverseScanRequest)
	if !ok {
		that2, ok := that.(ReverseScanRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.ScanFormat != that1.ScanFormat {
		return false
	}
	return true
}
func (this *CheckConsistencyRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CheckConsistencyRequest)
	if !ok {
		that2, ok := that.(CheckConsistencyRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.WithDiff != that1.WithDiff {
		return false
	}
	if this.Mode != that1.Mode {
		return false
	}
	if this.Checkpoint != that1.Checkpoint {
		return false
	}
	return true
}
func (this *RecomputeStatsRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RecomputeStatsRequest)
	if !ok {
		that2, ok := that.(RecomputeStatsRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.DryRun != that1.DryRun {
		return false
	}
	return true
}
func (this *BeginTransactionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*BeginTransactionRequest)
	if !ok {
		that2, ok := that.(BeginTransactionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}
func (this *EndTransactionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*EndTransactionRequest)
	if !ok {
		that2, ok := that.(EndTransactionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Commit != that1.Commit {
		return false
	}
	if !this.Deadline.Equal(that1.Deadline) {
		return false
	}
	if !this.InternalCommitTrigger.Equal(that1.InternalCommitTrigger) {
		return false
	}
	if len(this.IntentSpans) != len(that1.IntentSpans) {
		return false
	}
	for i := range this.IntentSpans {
		if !this.IntentSpans[i].Equal(&that1.IntentSpans[i]) {
			return false
		}
	}
	if this.Require1PC != that1.Require1PC {
		return false
	}
	if this.NoRefreshSpans != that1.NoRefreshSpans {
		return false
	}
	if this.Poison != that1.Poison {
		return false
	}
	return true
}
func (this *AdminSplitRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdminSplitRequest)
	if !ok {
		that2, ok := that.(AdminSplitRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !bytes.Equal(this.SplitKey, that1.SplitKey) {
		return false
	}
	return true
}
func (this *AdminMergeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdminMergeRequest)
	if !ok {
		that2, ok := that.(AdminMergeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}
func (this *AdminTransferLeaseRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdminTransferLeaseRequest)
	if !ok {
		that2, ok := that.(AdminTransferLeaseRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Target != that1.Target {
		return false
	}
	return true
}
func (this *AdminChangeReplicasRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdminChangeReplicasRequest)
	if !ok {
		that2, ok := that.(AdminChangeReplicasRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.ChangeType != that1.ChangeType {
		return false
	}
	if len(this.Targets) != len(that1.Targets) {
		return false
	}
	for i := range this.Targets {
		if !this.Targets[i].Equal(&that1.Targets[i]) {
			return false
		}
	}
	if !this.ExpDesc.Equal(that1.ExpDesc) {
		return false
	}
	return true
}
func (this *AdminRelocateRangeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdminRelocateRangeRequest)
	if !ok {
		that2, ok := that.(AdminRelocateRangeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if len(this.Targets) != len(that1.Targets) {
		return false
	}
	for i := range this.Targets {
		if !this.Targets[i].Equal(&that1.Targets[i]) {
			return false
		}
	}
	return true
}
func (this *HeartbeatTxnRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HeartbeatTxnRequest)
	if !ok {
		that2, ok := that.(HeartbeatTxnRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Now.Equal(&that1.Now) {
		return false
	}
	return true
}
func (this *GCRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GCRequest)
	if !ok {
		that2, ok := that.(GCRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if len(this.Keys) != len(that1.Keys) {
		return false
	}
	for i := range this.Keys {
		if !this.Keys[i].Equal(&that1.Keys[i]) {
			return false
		}
	}
	if !this.Threshold.Equal(&that1.Threshold) {
		return false
	}
	if !this.TxnSpanGCThreshold.Equal(&that1.TxnSpanGCThreshold) {
		return false
	}
	return true
}
func (this *GCRequest_GCKey) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GCRequest_GCKey)
	if !ok {
		that2, ok := that.(GCRequest_GCKey)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	return true
}
func (this *PushTxnRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PushTxnRequest)
	if !ok {
		that2, ok := that.(PushTxnRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.PusherTxn.Equal(&that1.PusherTxn) {
		return false
	}
	if !this.PusheeTxn.Equal(&that1.PusheeTxn) {
		return false
	}
	if !this.PushTo.Equal(&that1.PushTo) {
		return false
	}
	if this.InclusivePushTo != that1.InclusivePushTo {
		return false
	}
	if !this.DeprecatedNow.Equal(&that1.DeprecatedNow) {
		return false
	}
	if this.PushType != that1.PushType {
		return false
	}
	if this.Force != that1.Force {
		return false
	}
	return true
}
func (this *QueryTxnRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryTxnRequest)
	if !ok {
		that2, ok := that.(QueryTxnRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Txn.Equal(&that1.Txn) {
		return false
	}
	if this.WaitForUpdate != that1.WaitForUpdate {
		return false
	}
	if len(this.KnownWaitingTxns) != len(that1.KnownWaitingTxns) {
		return false
	}
	for i := range this.KnownWaitingTxns {
		if !this.KnownWaitingTxns[i].Equal(that1.KnownWaitingTxns[i]) {
			return false
		}
	}
	return true
}
func (this *QueryIntentRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryIntentRequest)
	if !ok {
		that2, ok := that.(QueryIntentRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Txn.Equal(&that1.Txn) {
		return false
	}
	if this.IfMissing != that1.IfMissing {
		return false
	}
	return true
}
func (this *ResolveIntentRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResolveIntentRequest)
	if !ok {
		that2, ok := that.(ResolveIntentRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.IntentTxn.Equal(&that1.IntentTxn) {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.Poison != that1.Poison {
		return false
	}
	return true
}
func (this *ResolveIntentRangeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ResolveIntentRangeRequest)
	if !ok {
		that2, ok := that.(ResolveIntentRangeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.IntentTxn.Equal(&that1.IntentTxn) {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.Poison != that1.Poison {
		return false
	}
	if !this.MinTimestamp.Equal(&that1.MinTimestamp) {
		return false
	}
	return true
}
func (this *MergeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MergeRequest)
	if !ok {
		that2, ok := that.(MergeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Value.Equal(&that1.Value) {
		return false
	}
	return true
}
func (this *TruncateLogRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TruncateLogRequest)
	if !ok {
		that2, ok := that.(TruncateLogRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Index != that1.Index {
		return false
	}
	if this.RangeID != that1.RangeID {
		return false
	}
	return true
}
func (this *RequestLeaseRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RequestLeaseRequest)
	if !ok {
		that2, ok := that.(RequestLeaseRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Lease.Equal(&that1.Lease) {
		return false
	}
	if !this.PrevLease.Equal(&that1.PrevLease) {
		return false
	}
	if !this.MinProposedTS.Equal(that1.MinProposedTS) {
		return false
	}
	return true
}
func (this *TransferLeaseRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TransferLeaseRequest)
	if !ok {
		that2, ok := that.(TransferLeaseRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Lease.Equal(&that1.Lease) {
		return false
	}
	if !this.PrevLease.Equal(&that1.PrevLease) {
		return false
	}
	return true
}
func (this *LeaseInfoRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LeaseInfoRequest)
	if !ok {
		that2, ok := that.(LeaseInfoRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}
func (this *ComputeChecksumRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ComputeChecksumRequest)
	if !ok {
		that2, ok := that.(ComputeChecksumRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.Snapshot != that1.Snapshot {
		return false
	}
	if this.Mode != that1.Mode {
		return false
	}
	if this.Checkpoint != that1.Checkpoint {
		return false
	}
	return true
}
func (this *ExportStorage) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportStorage)
	if !ok {
		that2, ok := that.(ExportStorage)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Provider != that1.Provider {
		return false
	}
	if !this.LocalFile.Equal(&that1.LocalFile) {
		return false
	}
	if !this.HttpPath.Equal(&that1.HttpPath) {
		return false
	}
	if !this.GoogleCloudConfig.Equal(that1.GoogleCloudConfig) {
		return false
	}
	if !this.S3Config.Equal(that1.S3Config) {
		return false
	}
	if !this.AzureConfig.Equal(that1.AzureConfig) {
		return false
	}
	if !this.WorkloadConfig.Equal(that1.WorkloadConfig) {
		return false
	}
	return true
}
func (this *ExportStorage_LocalFilePath) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportStorage_LocalFilePath)
	if !ok {
		that2, ok := that.(ExportStorage_LocalFilePath)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.NodeID != that1.NodeID {
		return false
	}
	return true
}
func (this *ExportStorage_Http) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportStorage_Http)
	if !ok {
		that2, ok := that.(ExportStorage_Http)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.BaseUri != that1.BaseUri {
		return false
	}
	return true
}
func (this *ExportStorage_S3) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportStorage_S3)
	if !ok {
		that2, ok := that.(ExportStorage_S3)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Bucket != that1.Bucket {
		return false
	}
	if this.Prefix != that1.Prefix {
		return false
	}
	if this.AccessKey != that1.AccessKey {
		return false
	}
	if this.Secret != that1.Secret {
		return false
	}
	if this.TempToken != that1.TempToken {
		return false
	}
	if this.Endpoint != that1.Endpoint {
		return false
	}
	if this.Region != that1.Region {
		return false
	}
	return true
}
func (this *ExportStorage_GCS) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportStorage_GCS)
	if !ok {
		that2, ok := that.(ExportStorage_GCS)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Bucket != that1.Bucket {
		return false
	}
	if this.Prefix != that1.Prefix {
		return false
	}
	if this.Auth != that1.Auth {
		return false
	}
	if this.BillingProject != that1.BillingProject {
		return false
	}
	if this.Credentials != that1.Credentials {
		return false
	}
	return true
}
func (this *ExportStorage_Azure) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportStorage_Azure)
	if !ok {
		that2, ok := that.(ExportStorage_Azure)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Container != that1.Container {
		return false
	}
	if this.Prefix != that1.Prefix {
		return false
	}
	if this.AccountName != that1.AccountName {
		return false
	}
	if this.AccountKey != that1.AccountKey {
		return false
	}
	return true
}
func (this *ExportStorage_Workload) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportStorage_Workload)
	if !ok {
		that2, ok := that.(ExportStorage_Workload)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Generator != that1.Generator {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.Table != that1.Table {
		return false
	}
	if len(this.Flags) != len(that1.Flags) {
		return false
	}
	for i := range this.Flags {
		if this.Flags[i] != that1.Flags[i] {
			return false
		}
	}
	if this.Format != that1.Format {
		return false
	}
	if this.BatchBegin != that1.BatchBegin {
		return false
	}
	if this.BatchEnd != that1.BatchEnd {
		return false
	}
	return true
}
func (this *WriteBatchRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*WriteBatchRequest)
	if !ok {
		that2, ok := that.(WriteBatchRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.DataSpan.Equal(&that1.DataSpan) {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *ExportRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ExportRequest)
	if !ok {
		that2, ok := that.(ExportRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.Storage.Equal(&that1.Storage) {
		return false
	}
	if !this.StartTime.Equal(&that1.StartTime) {
		return false
	}
	if this.MVCCFilter != that1.MVCCFilter {
		return false
	}
	if this.ReturnSST != that1.ReturnSST {
		return false
	}
	if this.OmitChecksum != that1.OmitChecksum {
		return false
	}
	if this.EnableTimeBoundIteratorOptimization != that1.EnableTimeBoundIteratorOptimization {
		return false
	}
	return true
}
func (this *ImportRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ImportRequest)
	if !ok {
		that2, ok := that.(ImportRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if len(this.Files) != len(that1.Files) {
		return false
	}
	for i := range this.Files {
		if !this.Files[i].Equal(&that1.Files[i]) {
			return false
		}
	}
	if !this.DataSpan.Equal(&that1.DataSpan) {
		return false
	}
	if !this.EndTime.Equal(&that1.EndTime) {
		return false
	}
	if len(this.Rekeys) != len(that1.Rekeys) {
		return false
	}
	for i := range this.Rekeys {
		if !this.Rekeys[i].Equal(&that1.Rekeys[i]) {
			return false
		}
	}
	return true
}
func (this *ImportRequest_File) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ImportRequest_File)
	if !ok {
		that2, ok := that.(ImportRequest_File)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Dir.Equal(&that1.Dir) {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if !bytes.Equal(this.Sha512, that1.Sha512) {
		return false
	}
	return true
}
func (this *ImportRequest_TableRekey) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ImportRequest_TableRekey)
	if !ok {
		that2, ok := that.(ImportRequest_TableRekey)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.OldID != that1.OldID {
		return false
	}
	if !bytes.Equal(this.NewDesc, that1.NewDesc) {
		return false
	}
	return true
}
func (this *AdminScatterRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AdminScatterRequest)
	if !ok {
		that2, ok := that.(AdminScatterRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.RandomizeLeases != that1.RandomizeLeases {
		return false
	}
	return true
}
func (this *AddSSTableRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AddSSTableRequest)
	if !ok {
		that2, ok := that.(AddSSTableRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *RefreshRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshRequest)
	if !ok {
		that2, ok := that.(RefreshRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Write != that1.Write {
		return false
	}
	return true
}
func (this *RefreshRangeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshRangeRequest)
	if !ok {
		that2, ok := that.(RefreshRangeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if this.Write != that1.Write {
		return false
	}
	return true
}
func (this *SubsumeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SubsumeRequest)
	if !ok {
		that2, ok := that.(SubsumeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	if !this.LeftRange.Equal(&that1.LeftRange) {
		return false
	}
	return true
}
func (this *RangeStatsRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RangeStatsRequest)
	if !ok {
		that2, ok := that.(RangeStatsRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.RequestHeader.Equal(&that1.RequestHeader) {
		return false
	}
	return true
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// InternalClient is the client API for Internal service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type InternalClient interface {
	Batch(ctx context.Context, in *BatchRequest, opts ...grpc.CallOption) (*BatchResponse, error)
	RangeFeed(ctx context.Context, in *RangeFeedRequest, opts ...grpc.CallOption) (Internal_RangeFeedClient, error)
}

type internalClient struct {
	cc *grpc.ClientConn
}

func NewInternalClient(cc *grpc.ClientConn) InternalClient {
	return &internalClient{cc}
}

func (c *internalClient) Batch(ctx context.Context, in *BatchRequest, opts ...grpc.CallOption) (*BatchResponse, error) {
	out := new(BatchResponse)
	err := c.cc.Invoke(ctx, "/cockroach.roachpb.Internal/Batch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalClient) RangeFeed(ctx context.Context, in *RangeFeedRequest, opts ...grpc.CallOption) (Internal_RangeFeedClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Internal_serviceDesc.Streams[0], "/cockroach.roachpb.Internal/RangeFeed", opts...)
	if err != nil {
		return nil, err
	}
	x := &internalRangeFeedClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Internal_RangeFeedClient interface {
	Recv() (*RangeFeedEvent, error)
	grpc.ClientStream
}

type internalRangeFeedClient struct {
	grpc.ClientStream
}

func (x *internalRangeFeedClient) Recv() (*RangeFeedEvent, error) {
	m := new(RangeFeedEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// InternalServer is the server API for Internal service.
type InternalServer interface {
	Batch(context.Context, *BatchRequest) (*BatchResponse, error)
	RangeFeed(*RangeFeedRequest, Internal_RangeFeedServer) error
}

func RegisterInternalServer(s *grpc.Server, srv InternalServer) {
	s.RegisterService(&_Internal_serviceDesc, srv)
}

func _Internal_Batch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalServer).Batch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.roachpb.Internal/Batch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalServer).Batch(ctx, req.(*BatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Internal_RangeFeed_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RangeFeedRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(InternalServer).RangeFeed(m, &internalRangeFeedServer{stream})
}

type Internal_RangeFeedServer interface {
	Send(*RangeFeedEvent) error
	grpc.ServerStream
}

type internalRangeFeedServer struct {
	grpc.ServerStream
}

func (x *internalRangeFeedServer) Send(m *RangeFeedEvent) error {
	return x.ServerStream.SendMsg(m)
}

var _Internal_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.roachpb.Internal",
	HandlerType: (*InternalServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Batch",
			Handler:    _Internal_Batch_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "RangeFeed",
			Handler:       _Internal_RangeFeed_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "roachpb/api.proto",
}

func (m *RangeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Desc.Size()))
	n1, err := m.Desc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Lease.Size()))
	n2, err := m.Lease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	return i, nil
}

func (m *RequestHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if m.Sequence != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Sequence))
	}
	return i, nil
}

func (m *ResponseHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Txn != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
		n3, err := m.Txn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.ResumeSpan != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResumeSpan.Size()))
		n4, err := m.ResumeSpan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.NumKeys != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.NumKeys))
	}
	if len(m.RangeInfos) > 0 {
		for _, msg := range m.RangeInfos {
			dAtA[i] = 0x32
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ResumeReason != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResumeReason))
	}
	return i, nil
}

func (m *GetRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n5, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	return i, nil
}

func (m *GetResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n6, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	if m.Value != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
		n7, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.IntentValue != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.IntentValue.Size()))
		n8, err := m.IntentValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}

func (m *PutRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PutRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n9, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n10, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	if m.Inline {
		dAtA[i] = 0x18
		i++
		if m.Inline {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Blind {
		dAtA[i] = 0x20
		i++
		if m.Blind {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *PutResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PutResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n11, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	return i, nil
}

func (m *ConditionalPutRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConditionalPutRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n12, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n13, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n13
	if m.ExpValue != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ExpValue.Size()))
		n14, err := m.ExpValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.Blind {
		dAtA[i] = 0x20
		i++
		if m.Blind {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.AllowIfDoesNotExist {
		dAtA[i] = 0x28
		i++
		if m.AllowIfDoesNotExist {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *ConditionalPutResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConditionalPutResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n15, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n15
	return i, nil
}

func (m *InitPutRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InitPutRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n16, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n16
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n17, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	if m.Blind {
		dAtA[i] = 0x18
		i++
		if m.Blind {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.FailOnTombstones {
		dAtA[i] = 0x20
		i++
		if m.FailOnTombstones {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *InitPutResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InitPutResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n18, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	return i, nil
}

func (m *IncrementRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IncrementRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n19, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	if m.Increment != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Increment))
	}
	return i, nil
}

func (m *IncrementResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IncrementResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n20, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	if m.NewValue != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.NewValue))
	}
	return i, nil
}

func (m *DeleteRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n21, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n21
	return i, nil
}

func (m *DeleteResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n22, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n22
	return i, nil
}

func (m *DeleteRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n23, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n23
	if m.ReturnKeys {
		dAtA[i] = 0x18
		i++
		if m.ReturnKeys {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Inline {
		dAtA[i] = 0x20
		i++
		if m.Inline {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *DeleteRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n24, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n24
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	return i, nil
}

func (m *ClearRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClearRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n25, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n25
	return i, nil
}

func (m *ClearRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClearRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n26, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n26
	return i, nil
}

func (m *ScanOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.StopAtRangeBoundary {
		dAtA[i] = 0x8
		i++
		if m.StopAtRangeBoundary {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.MinResults != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.MinResults))
	}
	return i, nil
}

func (m *ScanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n27, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n27
	if m.ScanFormat != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ScanFormat))
	}
	return i, nil
}

func (m *ScanResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n28, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n28
	if len(m.Rows) > 0 {
		for _, msg := range m.Rows {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.IntentRows) > 0 {
		for _, msg := range m.IntentRows {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.BatchResponses) > 0 {
		for _, b := range m.BatchResponses {
			dAtA[i] = 0x22
			i++
			i = encodeVarintApi(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	return i, nil
}

func (m *ReverseScanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReverseScanRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n29, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n29
	if m.ScanFormat != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ScanFormat))
	}
	return i, nil
}

func (m *ReverseScanResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReverseScanResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n30, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n30
	if len(m.Rows) > 0 {
		for _, msg := range m.Rows {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.IntentRows) > 0 {
		for _, msg := range m.IntentRows {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.BatchResponses) > 0 {
		for _, b := range m.BatchResponses {
			dAtA[i] = 0x22
			i++
			i = encodeVarintApi(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	return i, nil
}

func (m *CheckConsistencyRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckConsistencyRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n31, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n31
	if m.WithDiff {
		dAtA[i] = 0x10
		i++
		if m.WithDiff {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Mode != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Mode))
	}
	if m.Checkpoint {
		dAtA[i] = 0x20
		i++
		if m.Checkpoint {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *CheckConsistencyResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckConsistencyResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n32, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n32
	if len(m.Result) > 0 {
		for _, msg := range m.Result {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *CheckConsistencyResponse_Result) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckConsistencyResponse_Result) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RangeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeID))
	}
	if len(m.StartKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if m.Status != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Status))
	}
	if len(m.Detail) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Detail)))
		i += copy(dAtA[i:], m.Detail)
	}
	return i, nil
}

func (m *RecomputeStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecomputeStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n33, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n33
	if m.DryRun {
		dAtA[i] = 0x10
		i++
		if m.DryRun {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RecomputeStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecomputeStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n34, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n34
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.AddedDelta.Size()))
	n35, err := m.AddedDelta.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n35
	return i, nil
}

func (m *BeginTransactionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BeginTransactionRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n36, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n36
	return i, nil
}

func (m *BeginTransactionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BeginTransactionResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n37, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n37
	return i, nil
}

func (m *EndTransactionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndTransactionRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n38, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n38
	if m.Commit {
		dAtA[i] = 0x10
		i++
		if m.Commit {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Deadline != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Deadline.Size()))
		n39, err := m.Deadline.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	if m.InternalCommitTrigger != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.InternalCommitTrigger.Size()))
		n40, err := m.InternalCommitTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n40
	}
	if len(m.IntentSpans) > 0 {
		for _, msg := range m.IntentSpans {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Require1PC {
		dAtA[i] = 0x30
		i++
		if m.Require1PC {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.NoRefreshSpans {
		dAtA[i] = 0x40
		i++
		if m.NoRefreshSpans {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Poison {
		dAtA[i] = 0x48
		i++
		if m.Poison {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *EndTransactionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndTransactionResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n41, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n41
	if m.OnePhaseCommit {
		dAtA[i] = 0x20
		i++
		if m.OnePhaseCommit {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *AdminSplitRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminSplitRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n42, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n42
	if len(m.SplitKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.SplitKey)))
		i += copy(dAtA[i:], m.SplitKey)
	}
	return i, nil
}

func (m *AdminSplitResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminSplitResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n43, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n43
	return i, nil
}

func (m *AdminMergeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminMergeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n44, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n44
	return i, nil
}

func (m *AdminMergeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminMergeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n45, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n45
	return i, nil
}

func (m *AdminTransferLeaseRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminTransferLeaseRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n46, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n46
	if m.Target != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Target))
	}
	return i, nil
}

func (m *AdminTransferLeaseResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminTransferLeaseResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n47, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n47
	return i, nil
}

func (m *AdminChangeReplicasRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminChangeReplicasRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n48, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n48
	if m.ChangeType != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ChangeType))
	}
	if len(m.Targets) > 0 {
		for _, msg := range m.Targets {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ExpDesc != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ExpDesc.Size()))
		n49, err := m.ExpDesc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n49
	}
	return i, nil
}

func (m *AdminChangeReplicasResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminChangeReplicasResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n50, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n50
	if m.Desc != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Desc.Size()))
		n51, err := m.Desc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n51
	}
	return i, nil
}

func (m *AdminRelocateRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminRelocateRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n52, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n52
	if len(m.Targets) > 0 {
		for _, msg := range m.Targets {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AdminRelocateRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminRelocateRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n53, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n53
	return i, nil
}

func (m *HeartbeatTxnRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeartbeatTxnRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n54, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n54
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Now.Size()))
	n55, err := m.Now.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n55
	return i, nil
}

func (m *HeartbeatTxnResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeartbeatTxnResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n56, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n56
	return i, nil
}

func (m *GCRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n57, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n57
	if len(m.Keys) > 0 {
		for _, msg := range m.Keys {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Threshold.Size()))
	n58, err := m.Threshold.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n58
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.TxnSpanGCThreshold.Size()))
	n59, err := m.TxnSpanGCThreshold.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n59
	return i, nil
}

func (m *GCRequest_GCKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCRequest_GCKey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Timestamp.Size()))
	n60, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n60
	return i, nil
}

func (m *GCResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n61, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n61
	return i, nil
}

func (m *PushTxnRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushTxnRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n62, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n62
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PusherTxn.Size()))
	n63, err := m.PusherTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n63
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PusheeTxn.Size()))
	n64, err := m.PusheeTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n64
	dAtA[i] = 0x22
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PushTo.Size()))
	n65, err := m.PushTo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n65
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.DeprecatedNow.Size()))
	n66, err := m.DeprecatedNow.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n66
	if m.PushType != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.PushType))
	}
	if m.Force {
		dAtA[i] = 0x38
		i++
		if m.Force {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.InclusivePushTo {
		dAtA[i] = 0x48
		i++
		if m.InclusivePushTo {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *PushTxnResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushTxnResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n67, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n67
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PusheeTxn.Size()))
	n68, err := m.PusheeTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n68
	return i, nil
}

func (m *QueryTxnRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryTxnRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n69, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n69
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
	n70, err := m.Txn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n70
	if m.WaitForUpdate {
		dAtA[i] = 0x18
		i++
		if m.WaitForUpdate {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.KnownWaitingTxns) > 0 {
		for _, msg := range m.KnownWaitingTxns {
			dAtA[i] = 0x22
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *QueryTxnResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryTxnResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n71, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n71
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.QueriedTxn.Size()))
	n72, err := m.QueriedTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n72
	if len(m.WaitingTxns) > 0 {
		for _, msg := range m.WaitingTxns {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *QueryIntentRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryIntentRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n73, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n73
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
	n74, err := m.Txn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n74
	if m.IfMissing != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.IfMissing))
	}
	return i, nil
}

func (m *QueryIntentResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryIntentResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n75, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n75
	if m.FoundIntent {
		dAtA[i] = 0x10
		i++
		if m.FoundIntent {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *ResolveIntentRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveIntentRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n76, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n76
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.IntentTxn.Size()))
	n77, err := m.IntentTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n77
	if m.Status != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Status))
	}
	if m.Poison {
		dAtA[i] = 0x20
		i++
		if m.Poison {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *ResolveIntentResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveIntentResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n78, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n78
	return i, nil
}

func (m *ResolveIntentRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveIntentRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n79, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n79
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.IntentTxn.Size()))
	n80, err := m.IntentTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n80
	if m.Status != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Status))
	}
	if m.Poison {
		dAtA[i] = 0x20
		i++
		if m.Poison {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.MinTimestamp.Size()))
	n81, err := m.MinTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n81
	return i, nil
}

func (m *ResolveIntentRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveIntentRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n82, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n82
	return i, nil
}

func (m *MergeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n83, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n83
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n84, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n84
	return i, nil
}

func (m *MergeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n85, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n85
	return i, nil
}

func (m *TruncateLogRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TruncateLogRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n86, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n86
	if m.Index != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Index))
	}
	if m.RangeID != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeID))
	}
	return i, nil
}

func (m *TruncateLogResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TruncateLogResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n87, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n87
	return i, nil
}

func (m *RequestLeaseRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestLeaseRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n88, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n88
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Lease.Size()))
	n89, err := m.Lease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n89
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PrevLease.Size()))
	n90, err := m.PrevLease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n90
	if m.MinProposedTS != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.MinProposedTS.Size()))
		n91, err := m.MinProposedTS.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n91
	}
	return i, nil
}

func (m *TransferLeaseRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransferLeaseRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n92, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n92
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Lease.Size()))
	n93, err := m.Lease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n93
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PrevLease.Size()))
	n94, err := m.PrevLease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n94
	return i, nil
}

func (m *LeaseInfoRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LeaseInfoRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n95, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n95
	return i, nil
}

func (m *LeaseInfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LeaseInfoResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n96, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n96
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Lease.Size()))
	n97, err := m.Lease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n97
	return i, nil
}

func (m *RequestLeaseResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestLeaseResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n98, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n98
	return i, nil
}

func (m *ComputeChecksumRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComputeChecksumRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n99, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n99
	if m.Version != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Version))
	}
	if m.Snapshot {
		dAtA[i] = 0x20
		i++
		if m.Snapshot {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Mode != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Mode))
	}
	if m.Checkpoint {
		dAtA[i] = 0x30
		i++
		if m.Checkpoint {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *ComputeChecksumResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComputeChecksumResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n100, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n100
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ChecksumID.Size()))
	n101, err := m.ChecksumID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n101
	return i, nil
}

func (m *ExportStorage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Provider != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Provider))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.LocalFile.Size()))
	n102, err := m.LocalFile.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n102
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.HttpPath.Size()))
	n103, err := m.HttpPath.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n103
	if m.GoogleCloudConfig != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.GoogleCloudConfig.Size()))
		n104, err := m.GoogleCloudConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n104
	}
	if m.S3Config != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.S3Config.Size()))
		n105, err := m.S3Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n105
	}
	if m.AzureConfig != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AzureConfig.Size()))
		n106, err := m.AzureConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n106
	}
	if m.WorkloadConfig != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.WorkloadConfig.Size()))
		n107, err := m.WorkloadConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n107
	}
	return i, nil
}

func (m *ExportStorage_LocalFilePath) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_LocalFilePath) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Path) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if m.NodeID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.NodeID))
	}
	return i, nil
}

func (m *ExportStorage_Http) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_Http) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.BaseUri) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.BaseUri)))
		i += copy(dAtA[i:], m.BaseUri)
	}
	return i, nil
}

func (m *ExportStorage_S3) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_S3) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Bucket) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Bucket)))
		i += copy(dAtA[i:], m.Bucket)
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if len(m.AccessKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.AccessKey)))
		i += copy(dAtA[i:], m.AccessKey)
	}
	if len(m.Secret) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Secret)))
		i += copy(dAtA[i:], m.Secret)
	}
	if len(m.TempToken) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.TempToken)))
		i += copy(dAtA[i:], m.TempToken)
	}
	if len(m.Endpoint) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Endpoint)))
		i += copy(dAtA[i:], m.Endpoint)
	}
	if len(m.Region) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Region)))
		i += copy(dAtA[i:], m.Region)
	}
	return i, nil
}

func (m *ExportStorage_GCS) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_GCS) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Bucket) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Bucket)))
		i += copy(dAtA[i:], m.Bucket)
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if len(m.Auth) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Auth)))
		i += copy(dAtA[i:], m.Auth)
	}
	if len(m.BillingProject) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.BillingProject)))
		i += copy(dAtA[i:], m.BillingProject)
	}
	if len(m.Credentials) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Credentials)))
		i += copy(dAtA[i:], m.Credentials)
	}
	return i, nil
}

func (m *ExportStorage_Azure) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_Azure) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Container) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Container)))
		i += copy(dAtA[i:], m.Container)
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if len(m.AccountName) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.AccountName)))
		i += copy(dAtA[i:], m.AccountName)
	}
	if len(m.AccountKey) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.AccountKey)))
		i += copy(dAtA[i:], m.AccountKey)
	}
	return i, nil
}

func (m *ExportStorage_Workload) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_Workload) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Generator) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Generator)))
		i += copy(dAtA[i:], m.Generator)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	if len(m.Table) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Table)))
		i += copy(dAtA[i:], m.Table)
	}
	if len(m.Flags) > 0 {
		for _, s := range m.Flags {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Format) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Format)))
		i += copy(dAtA[i:], m.Format)
	}
	if m.BatchBegin != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.BatchBegin))
	}
	if m.BatchEnd != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.BatchEnd))
	}
	return i, nil
}

func (m *WriteBatchRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteBatchRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n108, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n108
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.DataSpan.Size()))
	n109, err := m.DataSpan.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n109
	if len(m.Data) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *WriteBatchResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteBatchResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n110, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n110
	return i, nil
}

func (m *ExportRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n111, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n111
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Storage.Size()))
	n112, err := m.Storage.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n112
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.StartTime.Size()))
	n113, err := m.StartTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n113
	if m.MVCCFilter != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.MVCCFilter))
	}
	if m.ReturnSST {
		dAtA[i] = 0x28
		i++
		if m.ReturnSST {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.OmitChecksum {
		dAtA[i] = 0x30
		i++
		if m.OmitChecksum {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.EnableTimeBoundIteratorOptimization {
		dAtA[i] = 0x38
		i++
		if m.EnableTimeBoundIteratorOptimization {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *BulkOpSummary) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BulkOpSummary) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.DataSize != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.DataSize))
	}
	if m.Rows != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Rows))
	}
	if m.IndexEntries != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.IndexEntries))
	}
	if m.SystemRecords != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.SystemRecords))
	}
	return i, nil
}

func (m *ExportResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n114, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n114
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.StartTime.Size()))
	n115, err := m.StartTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n115
	return i, nil
}

func (m *ExportResponse_File) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportResponse_File) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n116, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n116
	if len(m.Path) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if len(m.Sha512) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Sha512)))
		i += copy(dAtA[i:], m.Sha512)
	}
	dAtA[i] = 0x32
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Exported.Size()))
	n117, err := m.Exported.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n117
	if len(m.SST) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.SST)))
		i += copy(dAtA[i:], m.SST)
	}
	return i, nil
}

func (m *ImportRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n118, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n118
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.DataSpan.Size()))
	n119, err := m.DataSpan.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n119
	if len(m.Rekeys) > 0 {
		for _, msg := range m.Rekeys {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x32
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.EndTime.Size()))
	n120, err := m.EndTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n120
	return i, nil
}

func (m *ImportRequest_File) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportRequest_File) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Dir.Size()))
	n121, err := m.Dir.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n121
	if len(m.Path) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if len(m.Sha512) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Sha512)))
		i += copy(dAtA[i:], m.Sha512)
	}
	return i, nil
}

func (m *ImportRequest_TableRekey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportRequest_TableRekey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.OldID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.OldID))
	}
	if len(m.NewDesc) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.NewDesc)))
		i += copy(dAtA[i:], m.NewDesc)
	}
	return i, nil
}

func (m *ImportResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n122, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n122
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Imported.Size()))
	n123, err := m.Imported.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n123
	return i, nil
}

func (m *AdminScatterRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminScatterRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n124, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n124
	if m.RandomizeLeases {
		dAtA[i] = 0x10
		i++
		if m.RandomizeLeases {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *AdminScatterResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminScatterResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n125, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n125
	if len(m.Ranges) > 0 {
		for _, msg := range m.Ranges {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AdminScatterResponse_Range) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminScatterResponse_Range) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n126, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n126
	return i, nil
}

func (m *AddSSTableRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSSTableRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n127, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n127
	if len(m.Data) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *AddSSTableResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSSTableResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n128, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n128
	return i, nil
}

func (m *RefreshRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n129, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n129
	if m.Write {
		dAtA[i] = 0x10
		i++
		if m.Write {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RefreshResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n130, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n130
	return i, nil
}

func (m *RefreshRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n131, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n131
	if m.Write {
		dAtA[i] = 0x10
		i++
		if m.Write {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RefreshRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n132, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n132
	return i, nil
}

func (m *SubsumeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubsumeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n133, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n133
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.LeftRange.Size()))
	n134, err := m.LeftRange.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n134
	return i, nil
}

func (m *SubsumeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubsumeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n135, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n135
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.MVCCStats.Size()))
	n136, err := m.MVCCStats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n136
	if m.LeaseAppliedIndex != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.LeaseAppliedIndex))
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.FreezeStart.Size()))
	n137, err := m.FreezeStart.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n137
	return i, nil
}

func (m *RangeStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RequestHeader.Size()))
	n138, err := m.RequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n138
	return i, nil
}

func (m *RangeStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n139, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n139
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.MVCCStats.Size()))
	n140, err := m.MVCCStats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n140
	if m.QueriesPerSecond != 0 {
		dAtA[i] = 0x19
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.QueriesPerSecond))))
		i += 8
	}
	return i, nil
}

func (m *RequestUnion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestUnion) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		nn141, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn141
	}
	return i, nil
}

func (m *RequestUnion_Get) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Get != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Get.Size()))
		n142, err := m.Get.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n142
	}
	return i, nil
}
func (m *RequestUnion_Put) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Put != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Put.Size()))
		n143, err := m.Put.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n143
	}
	return i, nil
}
func (m *RequestUnion_ConditionalPut) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ConditionalPut != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ConditionalPut.Size()))
		n144, err := m.ConditionalPut.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n144
	}
	return i, nil
}
func (m *RequestUnion_Increment) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Increment != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Increment.Size()))
		n145, err := m.Increment.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n145
	}
	return i, nil
}
func (m *RequestUnion_Delete) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Delete != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Delete.Size()))
		n146, err := m.Delete.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n146
	}
	return i, nil
}
func (m *RequestUnion_DeleteRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DeleteRange != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.DeleteRange.Size()))
		n147, err := m.DeleteRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n147
	}
	return i, nil
}
func (m *RequestUnion_Scan) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Scan != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Scan.Size()))
		n148, err := m.Scan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n148
	}
	return i, nil
}
func (m *RequestUnion_BeginTransaction) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.BeginTransaction != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.BeginTransaction.Size()))
		n149, err := m.BeginTransaction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n149
	}
	return i, nil
}
func (m *RequestUnion_EndTransaction) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.EndTransaction != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.EndTransaction.Size()))
		n150, err := m.EndTransaction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n150
	}
	return i, nil
}
func (m *RequestUnion_AdminSplit) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminSplit != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminSplit.Size()))
		n151, err := m.AdminSplit.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n151
	}
	return i, nil
}
func (m *RequestUnion_AdminMerge) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminMerge != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminMerge.Size()))
		n152, err := m.AdminMerge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n152
	}
	return i, nil
}
func (m *RequestUnion_HeartbeatTxn) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HeartbeatTxn != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.HeartbeatTxn.Size()))
		n153, err := m.HeartbeatTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n153
	}
	return i, nil
}
func (m *RequestUnion_Gc) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Gc != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Gc.Size()))
		n154, err := m.Gc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n154
	}
	return i, nil
}
func (m *RequestUnion_PushTxn) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.PushTxn != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.PushTxn.Size()))
		n155, err := m.PushTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n155
	}
	return i, nil
}
func (m *RequestUnion_ResolveIntent) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ResolveIntent != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResolveIntent.Size()))
		n156, err := m.ResolveIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n156
	}
	return i, nil
}
func (m *RequestUnion_ResolveIntentRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ResolveIntentRange != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResolveIntentRange.Size()))
		n157, err := m.ResolveIntentRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n157
	}
	return i, nil
}
func (m *RequestUnion_Merge) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Merge != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Merge.Size()))
		n158, err := m.Merge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n158
	}
	return i, nil
}
func (m *RequestUnion_TruncateLog) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TruncateLog != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.TruncateLog.Size()))
		n159, err := m.TruncateLog.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n159
	}
	return i, nil
}
func (m *RequestUnion_RequestLease) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RequestLease != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RequestLease.Size()))
		n160, err := m.RequestLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n160
	}
	return i, nil
}
func (m *RequestUnion_ReverseScan) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ReverseScan != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ReverseScan.Size()))
		n161, err := m.ReverseScan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n161
	}
	return i, nil
}
func (m *RequestUnion_ComputeChecksum) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ComputeChecksum != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ComputeChecksum.Size()))
		n162, err := m.ComputeChecksum.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n162
	}
	return i, nil
}
func (m *RequestUnion_CheckConsistency) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.CheckConsistency != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.CheckConsistency.Size()))
		n163, err := m.CheckConsistency.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n163
	}
	return i, nil
}
func (m *RequestUnion_InitPut) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.InitPut != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.InitPut.Size()))
		n164, err := m.InitPut.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n164
	}
	return i, nil
}
func (m *RequestUnion_TransferLease) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TransferLease != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.TransferLease.Size()))
		n165, err := m.TransferLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n165
	}
	return i, nil
}
func (m *RequestUnion_AdminTransferLease) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminTransferLease != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminTransferLease.Size()))
		n166, err := m.AdminTransferLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n166
	}
	return i, nil
}
func (m *RequestUnion_LeaseInfo) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LeaseInfo != nil {
		dAtA[i] = 0xf2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.LeaseInfo.Size()))
		n167, err := m.LeaseInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n167
	}
	return i, nil
}
func (m *RequestUnion_WriteBatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.WriteBatch != nil {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.WriteBatch.Size()))
		n168, err := m.WriteBatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n168
	}
	return i, nil
}
func (m *RequestUnion_Export) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Export != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Export.Size()))
		n169, err := m.Export.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n169
	}
	return i, nil
}
func (m *RequestUnion_QueryTxn) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.QueryTxn != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.QueryTxn.Size()))
		n170, err := m.QueryTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n170
	}
	return i, nil
}
func (m *RequestUnion_Import) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Import != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Import.Size()))
		n171, err := m.Import.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n171
	}
	return i, nil
}
func (m *RequestUnion_AdminChangeReplicas) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminChangeReplicas != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminChangeReplicas.Size()))
		n172, err := m.AdminChangeReplicas.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n172
	}
	return i, nil
}
func (m *RequestUnion_AdminScatter) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminScatter != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminScatter.Size()))
		n173, err := m.AdminScatter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n173
	}
	return i, nil
}
func (m *RequestUnion_AddSstable) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AddSstable != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AddSstable.Size()))
		n174, err := m.AddSstable.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n174
	}
	return i, nil
}
func (m *RequestUnion_ClearRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClearRange != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ClearRange.Size()))
		n175, err := m.ClearRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n175
	}
	return i, nil
}
func (m *RequestUnion_RecomputeStats) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RecomputeStats != nil {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RecomputeStats.Size()))
		n176, err := m.RecomputeStats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n176
	}
	return i, nil
}
func (m *RequestUnion_Refresh) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Refresh != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Refresh.Size()))
		n177, err := m.Refresh.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n177
	}
	return i, nil
}
func (m *RequestUnion_RefreshRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RefreshRange != nil {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RefreshRange.Size()))
		n178, err := m.RefreshRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n178
	}
	return i, nil
}
func (m *RequestUnion_QueryIntent) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.QueryIntent != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.QueryIntent.Size()))
		n179, err := m.QueryIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n179
	}
	return i, nil
}
func (m *RequestUnion_Subsume) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Subsume != nil {
		dAtA[i] = 0xda
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Subsume.Size()))
		n180, err := m.Subsume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n180
	}
	return i, nil
}
func (m *RequestUnion_RangeStats) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RangeStats != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeStats.Size()))
		n181, err := m.RangeStats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n181
	}
	return i, nil
}
func (m *RequestUnion_AdminRelocateRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminRelocateRange != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminRelocateRange.Size()))
		n182, err := m.AdminRelocateRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n182
	}
	return i, nil
}
func (m *ResponseUnion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseUnion) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		nn183, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn183
	}
	return i, nil
}

func (m *ResponseUnion_Get) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Get != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Get.Size()))
		n184, err := m.Get.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n184
	}
	return i, nil
}
func (m *ResponseUnion_Put) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Put != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Put.Size()))
		n185, err := m.Put.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n185
	}
	return i, nil
}
func (m *ResponseUnion_ConditionalPut) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ConditionalPut != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ConditionalPut.Size()))
		n186, err := m.ConditionalPut.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n186
	}
	return i, nil
}
func (m *ResponseUnion_Increment) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Increment != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Increment.Size()))
		n187, err := m.Increment.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n187
	}
	return i, nil
}
func (m *ResponseUnion_Delete) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Delete != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Delete.Size()))
		n188, err := m.Delete.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n188
	}
	return i, nil
}
func (m *ResponseUnion_DeleteRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DeleteRange != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.DeleteRange.Size()))
		n189, err := m.DeleteRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n189
	}
	return i, nil
}
func (m *ResponseUnion_Scan) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Scan != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Scan.Size()))
		n190, err := m.Scan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n190
	}
	return i, nil
}
func (m *ResponseUnion_BeginTransaction) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.BeginTransaction != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.BeginTransaction.Size()))
		n191, err := m.BeginTransaction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n191
	}
	return i, nil
}
func (m *ResponseUnion_EndTransaction) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.EndTransaction != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.EndTransaction.Size()))
		n192, err := m.EndTransaction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n192
	}
	return i, nil
}
func (m *ResponseUnion_AdminSplit) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminSplit != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminSplit.Size()))
		n193, err := m.AdminSplit.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n193
	}
	return i, nil
}
func (m *ResponseUnion_AdminMerge) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminMerge != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminMerge.Size()))
		n194, err := m.AdminMerge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n194
	}
	return i, nil
}
func (m *ResponseUnion_HeartbeatTxn) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HeartbeatTxn != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.HeartbeatTxn.Size()))
		n195, err := m.HeartbeatTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n195
	}
	return i, nil
}
func (m *ResponseUnion_Gc) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Gc != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Gc.Size()))
		n196, err := m.Gc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n196
	}
	return i, nil
}
func (m *ResponseUnion_PushTxn) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.PushTxn != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.PushTxn.Size()))
		n197, err := m.PushTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n197
	}
	return i, nil
}
func (m *ResponseUnion_ResolveIntent) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ResolveIntent != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResolveIntent.Size()))
		n198, err := m.ResolveIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n198
	}
	return i, nil
}
func (m *ResponseUnion_ResolveIntentRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ResolveIntentRange != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResolveIntentRange.Size()))
		n199, err := m.ResolveIntentRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n199
	}
	return i, nil
}
func (m *ResponseUnion_Merge) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Merge != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Merge.Size()))
		n200, err := m.Merge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n200
	}
	return i, nil
}
func (m *ResponseUnion_TruncateLog) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TruncateLog != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.TruncateLog.Size()))
		n201, err := m.TruncateLog.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n201
	}
	return i, nil
}
func (m *ResponseUnion_RequestLease) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RequestLease != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RequestLease.Size()))
		n202, err := m.RequestLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n202
	}
	return i, nil
}
func (m *ResponseUnion_ReverseScan) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ReverseScan != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ReverseScan.Size()))
		n203, err := m.ReverseScan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n203
	}
	return i, nil
}
func (m *ResponseUnion_ComputeChecksum) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ComputeChecksum != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ComputeChecksum.Size()))
		n204, err := m.ComputeChecksum.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n204
	}
	return i, nil
}
func (m *ResponseUnion_CheckConsistency) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.CheckConsistency != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.CheckConsistency.Size()))
		n205, err := m.CheckConsistency.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n205
	}
	return i, nil
}
func (m *ResponseUnion_InitPut) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.InitPut != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.InitPut.Size()))
		n206, err := m.InitPut.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n206
	}
	return i, nil
}
func (m *ResponseUnion_AdminTransferLease) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminTransferLease != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminTransferLease.Size()))
		n207, err := m.AdminTransferLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n207
	}
	return i, nil
}
func (m *ResponseUnion_LeaseInfo) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LeaseInfo != nil {
		dAtA[i] = 0xf2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.LeaseInfo.Size()))
		n208, err := m.LeaseInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n208
	}
	return i, nil
}
func (m *ResponseUnion_WriteBatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.WriteBatch != nil {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.WriteBatch.Size()))
		n209, err := m.WriteBatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n209
	}
	return i, nil
}
func (m *ResponseUnion_Export) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Export != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Export.Size()))
		n210, err := m.Export.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n210
	}
	return i, nil
}
func (m *ResponseUnion_QueryTxn) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.QueryTxn != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.QueryTxn.Size()))
		n211, err := m.QueryTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n211
	}
	return i, nil
}
func (m *ResponseUnion_Import) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Import != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Import.Size()))
		n212, err := m.Import.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n212
	}
	return i, nil
}
func (m *ResponseUnion_AdminChangeReplicas) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminChangeReplicas != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminChangeReplicas.Size()))
		n213, err := m.AdminChangeReplicas.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n213
	}
	return i, nil
}
func (m *ResponseUnion_AdminScatter) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminScatter != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminScatter.Size()))
		n214, err := m.AdminScatter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n214
	}
	return i, nil
}
func (m *ResponseUnion_AddSstable) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AddSstable != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AddSstable.Size()))
		n215, err := m.AddSstable.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n215
	}
	return i, nil
}
func (m *ResponseUnion_ClearRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClearRange != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ClearRange.Size()))
		n216, err := m.ClearRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n216
	}
	return i, nil
}
func (m *ResponseUnion_RecomputeStats) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RecomputeStats != nil {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RecomputeStats.Size()))
		n217, err := m.RecomputeStats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n217
	}
	return i, nil
}
func (m *ResponseUnion_Refresh) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Refresh != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Refresh.Size()))
		n218, err := m.Refresh.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n218
	}
	return i, nil
}
func (m *ResponseUnion_RefreshRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RefreshRange != nil {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RefreshRange.Size()))
		n219, err := m.RefreshRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n219
	}
	return i, nil
}
func (m *ResponseUnion_QueryIntent) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.QueryIntent != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.QueryIntent.Size()))
		n220, err := m.QueryIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n220
	}
	return i, nil
}
func (m *ResponseUnion_Subsume) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Subsume != nil {
		dAtA[i] = 0xda
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Subsume.Size()))
		n221, err := m.Subsume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n221
	}
	return i, nil
}
func (m *ResponseUnion_RangeStats) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RangeStats != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeStats.Size()))
		n222, err := m.RangeStats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n222
	}
	return i, nil
}
func (m *ResponseUnion_AdminRelocateRange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AdminRelocateRange != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminRelocateRange.Size()))
		n223, err := m.AdminRelocateRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n223
	}
	return i, nil
}
func (m *Header) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Header) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Timestamp.Size()))
	n224, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n224
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Replica.Size()))
	n225, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n225
	if m.RangeID != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeID))
	}
	if m.UserPriority != 0 {
		dAtA[i] = 0x21
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.UserPriority))))
		i += 8
	}
	if m.Txn != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
		n226, err := m.Txn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n226
	}
	if m.ReadConsistency != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ReadConsistency))
	}
	if m.MaxSpanRequestKeys != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.MaxSpanRequestKeys))
	}
	if m.DistinctSpans {
		dAtA[i] = 0x48
		i++
		if m.DistinctSpans {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ReturnRangeInfo {
		dAtA[i] = 0x50
		i++
		if m.ReturnRangeInfo {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.GatewayNodeID != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.GatewayNodeID))
	}
	if m.ScanOptions != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ScanOptions.Size()))
		n227, err := m.ScanOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n227
	}
	if m.AsyncConsensus {
		dAtA[i] = 0x68
		i++
		if m.AsyncConsensus {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *BatchRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Header.Size()))
	n228, err := m.Header.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n228
	if len(m.Requests) > 0 {
		for _, msg := range m.Requests {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *BatchResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.BatchResponse_Header.Size()))
	n229, err := m.BatchResponse_Header.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n229
	if len(m.Responses) > 0 {
		for _, msg := range m.Responses {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *BatchResponse_Header) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchResponse_Header) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Error != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Error.Size()))
		n230, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n230
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Timestamp.Size()))
	n231, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n231
	if m.Txn != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
		n232, err := m.Txn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n232
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Now.Size()))
	n233, err := m.Now.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n233
	if len(m.CollectedSpans) > 0 {
		for _, msg := range m.CollectedSpans {
			dAtA[i] = 0x32
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RangeFeedRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeFeedRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Header.Size()))
	n234, err := m.Header.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n234
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n235, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n235
	return i, nil
}

func (m *RangeFeedValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeFeedValue) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n236, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n236
	return i, nil
}

func (m *RangeFeedCheckpoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeFeedCheckpoint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n237, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n237
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResolvedTS.Size()))
	n238, err := m.ResolvedTS.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n238
	return i, nil
}

func (m *RangeFeedError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeFeedError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Error.Size()))
	n239, err := m.Error.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n239
	return i, nil
}

func (m *RangeFeedEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeFeedEvent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Val != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Val.Size()))
		n240, err := m.Val.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n240
	}
	if m.Checkpoint != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Checkpoint.Size()))
		n241, err := m.Checkpoint.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n241
	}
	if m.Error != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Error.Size()))
		n242, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n242
	}
	return i, nil
}

func encodeVarintApi(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *RangeInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Desc.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Lease.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RequestHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Sequence != 0 {
		n += 1 + sovApi(uint64(m.Sequence))
	}
	return n
}

func (m *ResponseHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Txn != nil {
		l = m.Txn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ResumeSpan != nil {
		l = m.ResumeSpan.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.NumKeys != 0 {
		n += 1 + sovApi(uint64(m.NumKeys))
	}
	if len(m.RangeInfos) > 0 {
		for _, e := range m.RangeInfos {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.ResumeReason != 0 {
		n += 1 + sovApi(uint64(m.ResumeReason))
	}
	return n
}

func (m *GetRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *GetResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.IntentValue != nil {
		l = m.IntentValue.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *PutRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Inline {
		n += 2
	}
	if m.Blind {
		n += 2
	}
	return n
}

func (m *PutResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ConditionalPutRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.ExpValue != nil {
		l = m.ExpValue.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Blind {
		n += 2
	}
	if m.AllowIfDoesNotExist {
		n += 2
	}
	return n
}

func (m *ConditionalPutResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *InitPutRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Blind {
		n += 2
	}
	if m.FailOnTombstones {
		n += 2
	}
	return n
}

func (m *InitPutResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *IncrementRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Increment != 0 {
		n += 1 + sovApi(uint64(m.Increment))
	}
	return n
}

func (m *IncrementResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.NewValue != 0 {
		n += 1 + sovApi(uint64(m.NewValue))
	}
	return n
}

func (m *DeleteRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *DeleteResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *DeleteRangeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.ReturnKeys {
		n += 2
	}
	if m.Inline {
		n += 2
	}
	return n
}

func (m *DeleteRangeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			l = len(b)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ClearRangeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ClearRangeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ScanOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StopAtRangeBoundary {
		n += 2
	}
	if m.MinResults != 0 {
		n += 1 + sovApi(uint64(m.MinResults))
	}
	return n
}

func (m *ScanRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.ScanFormat != 0 {
		n += 1 + sovApi(uint64(m.ScanFormat))
	}
	return n
}

func (m *ScanResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Rows) > 0 {
		for _, e := range m.Rows {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.IntentRows) > 0 {
		for _, e := range m.IntentRows {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.BatchResponses) > 0 {
		for _, b := range m.BatchResponses {
			l = len(b)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ReverseScanRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.ScanFormat != 0 {
		n += 1 + sovApi(uint64(m.ScanFormat))
	}
	return n
}

func (m *ReverseScanResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Rows) > 0 {
		for _, e := range m.Rows {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.IntentRows) > 0 {
		for _, e := range m.IntentRows {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.BatchResponses) > 0 {
		for _, b := range m.BatchResponses {
			l = len(b)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *CheckConsistencyRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.WithDiff {
		n += 2
	}
	if m.Mode != 0 {
		n += 1 + sovApi(uint64(m.Mode))
	}
	if m.Checkpoint {
		n += 2
	}
	return n
}

func (m *CheckConsistencyResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Result) > 0 {
		for _, e := range m.Result {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *CheckConsistencyResponse_Result) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RangeID != 0 {
		n += 1 + sovApi(uint64(m.RangeID))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovApi(uint64(m.Status))
	}
	l = len(m.Detail)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *RecomputeStatsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.DryRun {
		n += 2
	}
	return n
}

func (m *RecomputeStatsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.AddedDelta.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *BeginTransactionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *BeginTransactionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *EndTransactionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Commit {
		n += 2
	}
	if m.Deadline != nil {
		l = m.Deadline.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.InternalCommitTrigger != nil {
		l = m.InternalCommitTrigger.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.IntentSpans) > 0 {
		for _, e := range m.IntentSpans {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.Require1PC {
		n += 2
	}
	if m.NoRefreshSpans {
		n += 2
	}
	if m.Poison {
		n += 2
	}
	return n
}

func (m *EndTransactionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.OnePhaseCommit {
		n += 2
	}
	return n
}

func (m *AdminSplitRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.SplitKey)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *AdminSplitResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminMergeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminMergeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminTransferLeaseRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Target != 0 {
		n += 1 + sovApi(uint64(m.Target))
	}
	return n
}

func (m *AdminTransferLeaseResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminChangeReplicasRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.ChangeType != 0 {
		n += 1 + sovApi(uint64(m.ChangeType))
	}
	if len(m.Targets) > 0 {
		for _, e := range m.Targets {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.ExpDesc != nil {
		l = m.ExpDesc.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *AdminChangeReplicasResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Desc != nil {
		l = m.Desc.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *AdminRelocateRangeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Targets) > 0 {
		for _, e := range m.Targets {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *AdminRelocateRangeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *HeartbeatTxnRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Now.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *HeartbeatTxnResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *GCRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Keys) > 0 {
		for _, e := range m.Keys {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = m.Threshold.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.TxnSpanGCThreshold.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *GCRequest_GCKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *GCResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *PushTxnRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PusherTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PusheeTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PushTo.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.DeprecatedNow.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.PushType != 0 {
		n += 1 + sovApi(uint64(m.PushType))
	}
	if m.Force {
		n += 2
	}
	if m.InclusivePushTo {
		n += 2
	}
	return n
}

func (m *PushTxnResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PusheeTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *QueryTxnRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Txn.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.WaitForUpdate {
		n += 2
	}
	if len(m.KnownWaitingTxns) > 0 {
		for _, e := range m.KnownWaitingTxns {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *QueryTxnResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.QueriedTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.WaitingTxns) > 0 {
		for _, e := range m.WaitingTxns {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *QueryIntentRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Txn.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.IfMissing != 0 {
		n += 1 + sovApi(uint64(m.IfMissing))
	}
	return n
}

func (m *QueryIntentResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.FoundIntent {
		n += 2
	}
	return n
}

func (m *ResolveIntentRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.IntentTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Status != 0 {
		n += 1 + sovApi(uint64(m.Status))
	}
	if m.Poison {
		n += 2
	}
	return n
}

func (m *ResolveIntentResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ResolveIntentRangeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.IntentTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Status != 0 {
		n += 1 + sovApi(uint64(m.Status))
	}
	if m.Poison {
		n += 2
	}
	l = m.MinTimestamp.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ResolveIntentRangeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *MergeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *MergeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *TruncateLogRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Index != 0 {
		n += 1 + sovApi(uint64(m.Index))
	}
	if m.RangeID != 0 {
		n += 1 + sovApi(uint64(m.RangeID))
	}
	return n
}

func (m *TruncateLogResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RequestLeaseRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Lease.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PrevLease.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.MinProposedTS != nil {
		l = m.MinProposedTS.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *TransferLeaseRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Lease.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PrevLease.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *LeaseInfoRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *LeaseInfoResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Lease.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RequestLeaseResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ComputeChecksumRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Version != 0 {
		n += 1 + sovApi(uint64(m.Version))
	}
	if m.Snapshot {
		n += 2
	}
	if m.Mode != 0 {
		n += 1 + sovApi(uint64(m.Mode))
	}
	if m.Checkpoint {
		n += 2
	}
	return n
}

func (m *ComputeChecksumResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.ChecksumID.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ExportStorage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Provider != 0 {
		n += 1 + sovApi(uint64(m.Provider))
	}
	l = m.LocalFile.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.HttpPath.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.GoogleCloudConfig != nil {
		l = m.GoogleCloudConfig.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.S3Config != nil {
		l = m.S3Config.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.AzureConfig != nil {
		l = m.AzureConfig.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.WorkloadConfig != nil {
		l = m.WorkloadConfig.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ExportStorage_LocalFilePath) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.NodeID != 0 {
		n += 1 + sovApi(uint64(m.NodeID))
	}
	return n
}

func (m *ExportStorage_Http) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.BaseUri)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ExportStorage_S3) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Bucket)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.AccessKey)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Secret)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.TempToken)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ExportStorage_GCS) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Bucket)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Auth)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.BillingProject)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Credentials)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ExportStorage_Azure) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Container)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.AccountName)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.AccountKey)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ExportStorage_Workload) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Generator)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Table)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.Flags) > 0 {
		for _, s := range m.Flags {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = len(m.Format)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.BatchBegin != 0 {
		n += 1 + sovApi(uint64(m.BatchBegin))
	}
	if m.BatchEnd != 0 {
		n += 1 + sovApi(uint64(m.BatchEnd))
	}
	return n
}

func (m *WriteBatchRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.DataSpan.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *WriteBatchResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ExportRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Storage.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.StartTime.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.MVCCFilter != 0 {
		n += 1 + sovApi(uint64(m.MVCCFilter))
	}
	if m.ReturnSST {
		n += 2
	}
	if m.OmitChecksum {
		n += 2
	}
	if m.EnableTimeBoundIteratorOptimization {
		n += 2
	}
	return n
}

func (m *BulkOpSummary) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DataSize != 0 {
		n += 1 + sovApi(uint64(m.DataSize))
	}
	if m.Rows != 0 {
		n += 1 + sovApi(uint64(m.Rows))
	}
	if m.IndexEntries != 0 {
		n += 1 + sovApi(uint64(m.IndexEntries))
	}
	if m.SystemRecords != 0 {
		n += 1 + sovApi(uint64(m.SystemRecords))
	}
	return n
}

func (m *ExportResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = m.StartTime.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ExportResponse_File) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Sha512)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Exported.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.SST)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ImportRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = m.DataSpan.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Rekeys) > 0 {
		for _, e := range m.Rekeys {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = m.EndTime.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ImportRequest_File) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Dir.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = len(m.Sha512)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ImportRequest_TableRekey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OldID != 0 {
		n += 1 + sovApi(uint64(m.OldID))
	}
	l = len(m.NewDesc)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ImportResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Imported.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminScatterRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.RandomizeLeases {
		n += 2
	}
	return n
}

func (m *AdminScatterResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Ranges) > 0 {
		for _, e := range m.Ranges {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *AdminScatterResponse_Range) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AddSSTableRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *AddSSTableResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RefreshRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Write {
		n += 2
	}
	return n
}

func (m *RefreshResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RefreshRangeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Write {
		n += 2
	}
	return n
}

func (m *RefreshRangeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *SubsumeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.LeftRange.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *SubsumeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.MVCCStats.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.LeaseAppliedIndex != 0 {
		n += 1 + sovApi(uint64(m.LeaseAppliedIndex))
	}
	l = m.FreezeStart.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RangeStatsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.RequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RangeStatsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.MVCCStats.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.QueriesPerSecond != 0 {
		n += 9
	}
	return n
}

func (m *RequestUnion) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *RequestUnion_Get) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Get != nil {
		l = m.Get.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Put) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Put != nil {
		l = m.Put.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_ConditionalPut) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConditionalPut != nil {
		l = m.ConditionalPut.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Increment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Increment != nil {
		l = m.Increment.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Delete) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Delete != nil {
		l = m.Delete.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_DeleteRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DeleteRange != nil {
		l = m.DeleteRange.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Scan) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Scan != nil {
		l = m.Scan.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_BeginTransaction) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BeginTransaction != nil {
		l = m.BeginTransaction.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_EndTransaction) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EndTransaction != nil {
		l = m.EndTransaction.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AdminSplit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdminSplit != nil {
		l = m.AdminSplit.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AdminMerge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdminMerge != nil {
		l = m.AdminMerge.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_HeartbeatTxn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HeartbeatTxn != nil {
		l = m.HeartbeatTxn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Gc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Gc != nil {
		l = m.Gc.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_PushTxn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PushTxn != nil {
		l = m.PushTxn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_ResolveIntent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ResolveIntent != nil {
		l = m.ResolveIntent.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_ResolveIntentRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ResolveIntentRange != nil {
		l = m.ResolveIntentRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Merge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Merge != nil {
		l = m.Merge.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_TruncateLog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TruncateLog != nil {
		l = m.TruncateLog.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_RequestLease) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestLease != nil {
		l = m.RequestLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_ReverseScan) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReverseScan != nil {
		l = m.ReverseScan.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_ComputeChecksum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ComputeChecksum != nil {
		l = m.ComputeChecksum.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_CheckConsistency) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CheckConsistency != nil {
		l = m.CheckConsistency.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_InitPut) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.InitPut != nil {
		l = m.InitPut.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_TransferLease) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TransferLease != nil {
		l = m.TransferLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AdminTransferLease) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdminTransferLease != nil {
		l = m.AdminTransferLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_LeaseInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LeaseInfo != nil {
		l = m.LeaseInfo.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_WriteBatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WriteBatch != nil {
		l = m.WriteBatch.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Export) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Export != nil {
		l = m.Export.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_QueryTxn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.QueryTxn != nil {
		l = m.QueryTxn.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Import) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Import != nil {
		l = m.Import.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AdminChangeReplicas) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdminChangeReplicas != nil {
		l = m.AdminChangeReplicas.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AdminScatter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdminScatter != nil {
		l = m.AdminScatter.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AddSstable) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AddSstable != nil {
		l = m.AddSstable.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_ClearRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClearRange != nil {
		l = m.ClearRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_RecomputeStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RecomputeStats != nil {
		l = m.RecomputeStats.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Refresh) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Refresh != nil {
		l = m.Refresh.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_RefreshRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RefreshRange != nil {
		l = m.RefreshRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_QueryIntent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.QueryIntent != nil {
		l = m.QueryIntent.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_Subsume) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Subsume != nil {
		l = m.Subsume.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_RangeStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RangeStats != nil {
		l = m.RangeStats.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *RequestUnion_AdminRelocateRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdminRelocateRange != nil {
		l = m.AdminRelocateRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *ResponseUnion_Get) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Get != nil {
		l = m.Get.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Put) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Put != nil {
		l = m.Put.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_ConditionalPut) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConditionalPut != nil {
		l = m.ConditionalPut.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Increment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Increment != nil {
		l = m.Increment.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Delete) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Delete != nil {
		l = m.Delete.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_DeleteRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DeleteRange != nil {
		l = m.DeleteRange.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Scan) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Scan != nil {
		l = m.Scan.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_BeginTransaction) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BeginTransaction != nil {
		l = m.BeginTransaction.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_EndTransaction) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EndTransaction != nil {
		l = m.EndTransaction.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AdminSplit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdminSplit != nil {
		l = m.AdminSplit.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AdminMerge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdminMerge != nil {
		l = m.AdminMerge.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_HeartbeatTxn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HeartbeatTxn != nil {
		l = m.HeartbeatTxn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Gc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Gc != nil {
		l = m.Gc.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_PushTxn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PushTxn != nil {
		l = m.PushTxn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_ResolveIntent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ResolveIntent != nil {
		l = m.ResolveIntent.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_ResolveIntentRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ResolveIntentRange != nil {
		l = m.ResolveIntentRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Merge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Merge != nil {
		l = m.Merge.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_TruncateLog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TruncateLog != nil {
		l = m.TruncateLog.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_RequestLease) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestLease != nil {
		l = m.RequestLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_ReverseScan) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReverseScan != nil {
		l = m.ReverseScan.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_ComputeChecksum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ComputeChecksum != nil {
		l = m.ComputeChecksum.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_CheckConsistency) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CheckConsistency != nil {
		l = m.CheckConsistency.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_InitPut) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.InitPut != nil {
		l = m.InitPut.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AdminTransferLease) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdminTransferLease != nil {
		l = m.AdminTransferLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_LeaseInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LeaseInfo != nil {
		l = m.LeaseInfo.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_WriteBatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WriteBatch != nil {
		l = m.WriteBatch.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Export) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Export != nil {
		l = m.Export.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_QueryTxn) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.QueryTxn != nil {
		l = m.QueryTxn.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Import) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Import != nil {
		l = m.Import.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AdminChangeReplicas) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdminChangeReplicas != nil {
		l = m.AdminChangeReplicas.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AdminScatter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdminScatter != nil {
		l = m.AdminScatter.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AddSstable) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AddSstable != nil {
		l = m.AddSstable.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_ClearRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClearRange != nil {
		l = m.ClearRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_RecomputeStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RecomputeStats != nil {
		l = m.RecomputeStats.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Refresh) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Refresh != nil {
		l = m.Refresh.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_RefreshRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RefreshRange != nil {
		l = m.RefreshRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_QueryIntent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.QueryIntent != nil {
		l = m.QueryIntent.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_Subsume) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Subsume != nil {
		l = m.Subsume.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_RangeStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RangeStats != nil {
		l = m.RangeStats.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *ResponseUnion_AdminRelocateRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AdminRelocateRange != nil {
		l = m.AdminRelocateRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}
func (m *Header) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Timestamp.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Replica.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.RangeID != 0 {
		n += 1 + sovApi(uint64(m.RangeID))
	}
	if m.UserPriority != 0 {
		n += 9
	}
	if m.Txn != nil {
		l = m.Txn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ReadConsistency != 0 {
		n += 1 + sovApi(uint64(m.ReadConsistency))
	}
	if m.MaxSpanRequestKeys != 0 {
		n += 1 + sovApi(uint64(m.MaxSpanRequestKeys))
	}
	if m.DistinctSpans {
		n += 2
	}
	if m.ReturnRangeInfo {
		n += 2
	}
	if m.GatewayNodeID != 0 {
		n += 1 + sovApi(uint64(m.GatewayNodeID))
	}
	if m.ScanOptions != nil {
		l = m.ScanOptions.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.AsyncConsensus {
		n += 2
	}
	return n
}

func (m *BatchRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Header.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Requests) > 0 {
		for _, e := range m.Requests {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *BatchResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.BatchResponse_Header.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Responses) > 0 {
		for _, e := range m.Responses {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *BatchResponse_Header) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Txn != nil {
		l = m.Txn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Now.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.CollectedSpans) > 0 {
		for _, e := range m.CollectedSpans {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *RangeFeedRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Header.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RangeFeedValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RangeFeedCheckpoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.ResolvedTS.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RangeFeedError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Error.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RangeFeedEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Val != nil {
		l = m.Val.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Checkpoint != nil {
		l = m.Checkpoint.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func sovApi(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozApi(x uint64) (n int) {
	return sovApi(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *RangeFeedEvent) GetValue() interface{} {
	if this.Val != nil {
		return this.Val
	}
	if this.Checkpoint != nil {
		return this.Checkpoint
	}
	if this.Error != nil {
		return this.Error
	}
	return nil
}

func (this *RangeFeedEvent) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *RangeFeedValue:
		this.Val = vt
	case *RangeFeedCheckpoint:
		this.Checkpoint = vt
	case *RangeFeedError:
		this.Error = vt
	default:
		return false
	}
	return true
}
func (m *RangeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Desc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Txn == nil {
				m.Txn = &Transaction{}
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResumeSpan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResumeSpan == nil {
				m.ResumeSpan = &Span{}
			}
			if err := m.ResumeSpan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumKeys", wireType)
			}
			m.NumKeys = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumKeys |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RangeInfos = append(m.RangeInfos, RangeInfo{})
			if err := m.RangeInfos[len(m.RangeInfos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResumeReason", wireType)
			}
			m.ResumeReason = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResumeReason |= (ResponseHeader_ResumeReason(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &Value{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IntentValue == nil {
				m.IntentValue = &Value{}
			}
			if err := m.IntentValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PutRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PutRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PutRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inline", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Inline = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Blind", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Blind = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PutResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PutResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PutResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConditionalPutRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConditionalPutRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConditionalPutRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpValue == nil {
				m.ExpValue = &Value{}
			}
			if err := m.ExpValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Blind", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Blind = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowIfDoesNotExist", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowIfDoesNotExist = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConditionalPutResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConditionalPutResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConditionalPutResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InitPutRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InitPutRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InitPutRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Blind", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Blind = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailOnTombstones", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FailOnTombstones = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InitPutResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InitPutResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InitPutResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IncrementRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IncrementRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IncrementRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Increment", wireType)
			}
			m.Increment = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Increment |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IncrementResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IncrementResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IncrementResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewValue", wireType)
			}
			m.NewValue = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NewValue |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReturnKeys", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReturnKeys = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inline", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Inline = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, make([]byte, postIndex-iNdEx))
			copy(m.Keys[len(m.Keys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClearRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClearRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClearRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClearRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClearRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClearRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StopAtRangeBoundary", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StopAtRangeBoundary = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinResults", wireType)
			}
			m.MinResults = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinResults |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScanFormat", wireType)
			}
			m.ScanFormat = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScanFormat |= (ScanFormat(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rows = append(m.Rows, KeyValue{})
			if err := m.Rows[len(m.Rows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentRows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentRows = append(m.IntentRows, KeyValue{})
			if err := m.IntentRows[len(m.IntentRows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchResponses", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BatchResponses = append(m.BatchResponses, make([]byte, postIndex-iNdEx))
			copy(m.BatchResponses[len(m.BatchResponses)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReverseScanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReverseScanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReverseScanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScanFormat", wireType)
			}
			m.ScanFormat = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScanFormat |= (ScanFormat(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReverseScanResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReverseScanResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReverseScanResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rows = append(m.Rows, KeyValue{})
			if err := m.Rows[len(m.Rows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentRows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentRows = append(m.IntentRows, KeyValue{})
			if err := m.IntentRows[len(m.IntentRows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchResponses", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BatchResponses = append(m.BatchResponses, make([]byte, postIndex-iNdEx))
			copy(m.BatchResponses[len(m.BatchResponses)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckConsistencyRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckConsistencyRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckConsistencyRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WithDiff", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WithDiff = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= (ChecksumMode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checkpoint", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Checkpoint = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckConsistencyResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckConsistencyResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckConsistencyResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = append(m.Result, CheckConsistencyResponse_Result{})
			if err := m.Result[len(m.Result)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckConsistencyResponse_Result) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Result: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Result: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (CheckConsistencyResponse_Status(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Detail", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Detail = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecomputeStatsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecomputeStatsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecomputeStatsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DryRun", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DryRun = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecomputeStatsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecomputeStatsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecomputeStatsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddedDelta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AddedDelta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BeginTransactionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BeginTransactionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BeginTransactionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BeginTransactionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BeginTransactionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BeginTransactionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndTransactionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndTransactionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndTransactionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Commit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Commit = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deadline", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Deadline == nil {
				m.Deadline = &hlc.Timestamp{}
			}
			if err := m.Deadline.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InternalCommitTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InternalCommitTrigger == nil {
				m.InternalCommitTrigger = &InternalCommitTrigger{}
			}
			if err := m.InternalCommitTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentSpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentSpans = append(m.IntentSpans, Span{})
			if err := m.IntentSpans[len(m.IntentSpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Require1PC", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Require1PC = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoRefreshSpans", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoRefreshSpans = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Poison", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Poison = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndTransactionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndTransactionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndTransactionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OnePhaseCommit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.OnePhaseCommit = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminSplitRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminSplitRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminSplitRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SplitKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SplitKey = append(m.SplitKey[:0], dAtA[iNdEx:postIndex]...)
			if m.SplitKey == nil {
				m.SplitKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminSplitResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminSplitResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminSplitResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminMergeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminMergeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminMergeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminMergeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminMergeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminMergeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminTransferLeaseRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminTransferLeaseRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminTransferLeaseRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			m.Target = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Target |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminTransferLeaseResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminTransferLeaseResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminTransferLeaseResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminChangeReplicasRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminChangeReplicasRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminChangeReplicasRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeType", wireType)
			}
			m.ChangeType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ChangeType |= (ReplicaChangeType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Targets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Targets = append(m.Targets, ReplicationTarget{})
			if err := m.Targets[len(m.Targets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpDesc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpDesc == nil {
				m.ExpDesc = &RangeDescriptor{}
			}
			if err := m.ExpDesc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminChangeReplicasResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminChangeReplicasResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminChangeReplicasResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Desc == nil {
				m.Desc = &RangeDescriptor{}
			}
			if err := m.Desc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminRelocateRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminRelocateRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminRelocateRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Targets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Targets = append(m.Targets, ReplicationTarget{})
			if err := m.Targets[len(m.Targets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminRelocateRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminRelocateRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminRelocateRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatTxnRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatTxnRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatTxnRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Now", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Now.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatTxnResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatTxnResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatTxnResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, GCRequest_GCKey{})
			if err := m.Keys[len(m.Keys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Threshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Threshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnSpanGCThreshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnSpanGCThreshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCRequest_GCKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PushTxnRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PushTxnRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PushTxnRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PusherTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PusherTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PusheeTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PusheeTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushTo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PushTo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedNow", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.DeprecatedNow.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushType", wireType)
			}
			m.PushType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PushType |= (PushTxnType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Force", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Force = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InclusivePushTo", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.InclusivePushTo = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PushTxnResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PushTxnResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PushTxnResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PusheeTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PusheeTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryTxnRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryTxnRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryTxnRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WaitForUpdate", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WaitForUpdate = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KnownWaitingTxns", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cockroachdb_cockroach_pkg_util_uuid.UUID
			m.KnownWaitingTxns = append(m.KnownWaitingTxns, v)
			if err := m.KnownWaitingTxns[len(m.KnownWaitingTxns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryTxnResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryTxnResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryTxnResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueriedTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.QueriedTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WaitingTxns", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cockroachdb_cockroach_pkg_util_uuid.UUID
			m.WaitingTxns = append(m.WaitingTxns, v)
			if err := m.WaitingTxns[len(m.WaitingTxns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryIntentRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryIntentRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryIntentRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IfMissing", wireType)
			}
			m.IfMissing = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IfMissing |= (QueryIntentRequest_IfMissingBehavior(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryIntentResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryIntentResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryIntentResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FoundIntent", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FoundIntent = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveIntentRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveIntentRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveIntentRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.IntentTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (TransactionStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Poison", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Poison = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveIntentResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveIntentResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveIntentResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveIntentRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveIntentRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveIntentRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.IntentTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (TransactionStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Poison", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Poison = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MinTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveIntentRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveIntentRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveIntentRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TruncateLogRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TruncateLogRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TruncateLogRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TruncateLogResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TruncateLogResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TruncateLogResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestLeaseRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestLeaseRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestLeaseRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrevLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PrevLease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinProposedTS", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MinProposedTS == nil {
				m.MinProposedTS = &hlc.Timestamp{}
			}
			if err := m.MinProposedTS.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransferLeaseRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransferLeaseRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransferLeaseRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrevLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PrevLease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaseInfoRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaseInfoRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaseInfoRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaseInfoResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaseInfoResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaseInfoResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestLeaseResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestLeaseResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestLeaseResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComputeChecksumRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComputeChecksumRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComputeChecksumRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Snapshot", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Snapshot = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= (ChecksumMode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checkpoint", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Checkpoint = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComputeChecksumResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComputeChecksumResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComputeChecksumResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChecksumID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ChecksumID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExportStorage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExportStorage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Provider", wireType)
			}
			m.Provider = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Provider |= (ExportStorageProvider(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalFile", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LocalFile.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpPath", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.HttpPath.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GoogleCloudConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GoogleCloudConfig == nil {
				m.GoogleCloudConfig = &ExportStorage_GCS{}
			}
			if err := m.GoogleCloudConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field S3Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.S3Config == nil {
				m.S3Config = &ExportStorage_S3{}
			}
			if err := m.S3Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AzureConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AzureConfig == nil {
				m.AzureConfig = &ExportStorage_Azure{}
			}
			if err := m.AzureConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkloadConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkloadConfig == nil {
				m.WorkloadConfig = &ExportStorage_Workload{}
			}
			if err := m.WorkloadConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_LocalFilePath) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalFilePath: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalFilePath: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_Http) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Http: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Http: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseUri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BaseUri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_S3) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: S3: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: S3: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secret = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TempToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TempToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_GCS) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCS: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCS: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Auth", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Auth = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BillingProject", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BillingProject = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Credentials", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Credentials = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_Azure) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Azure: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Azure: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Container = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccountName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccountName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccountKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccountKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_Workload) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Workload: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Workload: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Generator", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Generator = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Table = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Flags = append(m.Flags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Format", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Format = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchBegin", wireType)
			}
			m.BatchBegin = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BatchBegin |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchEnd", wireType)
			}
			m.BatchEnd = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BatchEnd |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteBatchRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteBatchRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteBatchRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataSpan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.DataSpan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteBatchResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteBatchResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteBatchResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExportRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExportRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Storage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Storage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MVCCFilter", wireType)
			}
			m.MVCCFilter = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MVCCFilter |= (MVCCFilter(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReturnSST", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReturnSST = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OmitChecksum", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.OmitChecksum = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableTimeBoundIteratorOptimization", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableTimeBoundIteratorOptimization = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BulkOpSummary) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BulkOpSummary: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BulkOpSummary: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataSize", wireType)
			}
			m.DataSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DataSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rows", wireType)
			}
			m.Rows = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Rows |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexEntries", wireType)
			}
			m.IndexEntries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IndexEntries |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemRecords", wireType)
			}
			m.SystemRecords = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SystemRecords |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExportResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExportResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, ExportResponse_File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportResponse_File) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: File: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: File: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sha512", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sha512 = append(m.Sha512[:0], dAtA[iNdEx:postIndex]...)
			if m.Sha512 == nil {
				m.Sha512 = []byte{}
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exported", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Exported.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SST", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SST = append(m.SST[:0], dAtA[iNdEx:postIndex]...)
			if m.SST == nil {
				m.SST = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImportRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImportRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, ImportRequest_File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataSpan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.DataSpan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rekeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rekeys = append(m.Rekeys, ImportRequest_TableRekey{})
			if err := m.Rekeys[len(m.Rekeys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EndTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportRequest_File) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: File: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: File: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dir", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Dir.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sha512", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sha512 = append(m.Sha512[:0], dAtA[iNdEx:postIndex]...)
			if m.Sha512 == nil {
				m.Sha512 = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportRequest_TableRekey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableRekey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableRekey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OldID", wireType)
			}
			m.OldID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OldID |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewDesc", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NewDesc = append(m.NewDesc[:0], dAtA[iNdEx:postIndex]...)
			if m.NewDesc == nil {
				m.NewDesc = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImportResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImportResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Imported", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Imported.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminScatterRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminScatterRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminScatterRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RandomizeLeases", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RandomizeLeases = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminScatterResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminScatterResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminScatterResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ranges = append(m.Ranges, AdminScatterResponse_Range{})
			if err := m.Ranges[len(m.Ranges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminScatterResponse_Range) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Range: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Range: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSSTableRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSSTableRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSSTableRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSSTableResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSSTableResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSSTableResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Write", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Write = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Write", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Write = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubsumeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubsumeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubsumeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeftRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeftRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubsumeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubsumeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubsumeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MVCCStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MVCCStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseAppliedIndex", wireType)
			}
			m.LeaseAppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeaseAppliedIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FreezeStart", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FreezeStart.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeStatsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeStatsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeStatsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeStatsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeStatsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeStatsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MVCCStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MVCCStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueriesPerSecond", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.QueriesPerSecond = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestUnion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestUnion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestUnion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Get", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GetRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Get{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Put", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &PutRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Put{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConditionalPut", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ConditionalPutRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_ConditionalPut{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Increment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &IncrementRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Increment{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delete", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DeleteRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Delete{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeleteRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DeleteRangeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_DeleteRange{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ScanRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Scan{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BeginTransaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &BeginTransactionRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_BeginTransaction{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTransaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EndTransactionRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_EndTransaction{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminSplit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminSplitRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AdminSplit{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminMerge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminMergeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AdminMerge{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HeartbeatTxnRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_HeartbeatTxn{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GCRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Gc{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &PushTxnRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_PushTxn{v}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolveIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ResolveIntentRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_ResolveIntent{v}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolveIntentRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ResolveIntentRangeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_ResolveIntentRange{v}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Merge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MergeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Merge{v}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TruncateLog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TruncateLogRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_TruncateLog{v}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RequestLeaseRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_RequestLease{v}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReverseScan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReverseScanRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_ReverseScan{v}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComputeChecksum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ComputeChecksumRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_ComputeChecksum{v}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckConsistency", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CheckConsistencyRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_CheckConsistency{v}
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitPut", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &InitPutRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_InitPut{v}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransferLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TransferLeaseRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_TransferLease{v}
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminTransferLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminTransferLeaseRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AdminTransferLease{v}
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LeaseInfoRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_LeaseInfo{v}
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteBatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &WriteBatchRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_WriteBatch{v}
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Export", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ExportRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Export{v}
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryTxnRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_QueryTxn{v}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Import", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ImportRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Import{v}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminChangeReplicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminChangeReplicasRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AdminChangeReplicas{v}
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminScatter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminScatterRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AdminScatter{v}
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddSstable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AddSSTableRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AddSstable{v}
			iNdEx = postIndex
		case 38:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClearRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ClearRangeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_ClearRange{v}
			iNdEx = postIndex
		case 39:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecomputeStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RecomputeStatsRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_RecomputeStats{v}
			iNdEx = postIndex
		case 40:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Refresh", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RefreshRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Refresh{v}
			iNdEx = postIndex
		case 41:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RefreshRangeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_RefreshRange{v}
			iNdEx = postIndex
		case 42:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryIntentRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_QueryIntent{v}
			iNdEx = postIndex
		case 43:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subsume", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SubsumeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_Subsume{v}
			iNdEx = postIndex
		case 44:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RangeStatsRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_RangeStats{v}
			iNdEx = postIndex
		case 45:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminRelocateRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminRelocateRangeRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RequestUnion_AdminRelocateRange{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseUnion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseUnion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseUnion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Get", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GetResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Get{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Put", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &PutResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Put{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConditionalPut", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ConditionalPutResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_ConditionalPut{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Increment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &IncrementResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Increment{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delete", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DeleteResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Delete{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeleteRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DeleteRangeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_DeleteRange{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ScanResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Scan{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BeginTransaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &BeginTransactionResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_BeginTransaction{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTransaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EndTransactionResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_EndTransaction{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminSplit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminSplitResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AdminSplit{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminMerge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminMergeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AdminMerge{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HeartbeatTxnResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_HeartbeatTxn{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GCResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Gc{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &PushTxnResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_PushTxn{v}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolveIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ResolveIntentResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_ResolveIntent{v}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolveIntentRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ResolveIntentRangeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_ResolveIntentRange{v}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Merge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MergeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Merge{v}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TruncateLog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TruncateLogResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_TruncateLog{v}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RequestLeaseResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_RequestLease{v}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReverseScan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReverseScanResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_ReverseScan{v}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComputeChecksum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ComputeChecksumResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_ComputeChecksum{v}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckConsistency", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CheckConsistencyResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_CheckConsistency{v}
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitPut", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &InitPutResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_InitPut{v}
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminTransferLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminTransferLeaseResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AdminTransferLease{v}
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LeaseInfoResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_LeaseInfo{v}
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteBatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &WriteBatchResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_WriteBatch{v}
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Export", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ExportResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Export{v}
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryTxnResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_QueryTxn{v}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Import", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ImportResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Import{v}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminChangeReplicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminChangeReplicasResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AdminChangeReplicas{v}
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminScatter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminScatterResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AdminScatter{v}
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddSstable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AddSSTableResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AddSstable{v}
			iNdEx = postIndex
		case 38:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClearRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ClearRangeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_ClearRange{v}
			iNdEx = postIndex
		case 39:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecomputeStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RecomputeStatsResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_RecomputeStats{v}
			iNdEx = postIndex
		case 40:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Refresh", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RefreshResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Refresh{v}
			iNdEx = postIndex
		case 41:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RefreshRangeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_RefreshRange{v}
			iNdEx = postIndex
		case 42:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryIntentResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_QueryIntent{v}
			iNdEx = postIndex
		case 43:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subsume", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SubsumeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_Subsume{v}
			iNdEx = postIndex
		case 44:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RangeStatsResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_RangeStats{v}
			iNdEx = postIndex
		case 45:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminRelocateRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AdminRelocateRangeResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &ResponseUnion_AdminRelocateRange{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Header) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserPriority", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.UserPriority = UserPriority(math.Float64frombits(v))
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Txn == nil {
				m.Txn = &Transaction{}
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadConsistency", wireType)
			}
			m.ReadConsistency = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadConsistency |= (ReadConsistencyType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxSpanRequestKeys", wireType)
			}
			m.MaxSpanRequestKeys = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxSpanRequestKeys |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DistinctSpans", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DistinctSpans = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReturnRangeInfo", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReturnRangeInfo = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GatewayNodeID", wireType)
			}
			m.GatewayNodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GatewayNodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScanOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScanOptions == nil {
				m.ScanOptions = &ScanOptions{}
			}
			if err := m.ScanOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsyncConsensus", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AsyncConsensus = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BatchRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BatchRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Requests", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Requests = append(m.Requests, RequestUnion{})
			if err := m.Requests[len(m.Requests)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BatchResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BatchResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchResponse_Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.BatchResponse_Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Responses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Responses = append(m.Responses, ResponseUnion{})
			if err := m.Responses[len(m.Responses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchResponse_Header) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Txn == nil {
				m.Txn = &Transaction{}
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Now", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Now.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CollectedSpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CollectedSpans = append(m.CollectedSpans, tracing.RecordedSpan{})
			if err := m.CollectedSpans[len(m.CollectedSpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeFeedRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeFeedRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeFeedRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeFeedValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeFeedValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeFeedValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeFeedCheckpoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeFeedCheckpoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeFeedCheckpoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolvedTS", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResolvedTS.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeFeedError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeFeedError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeFeedError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeFeedEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeFeedEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeFeedEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Val", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Val == nil {
				m.Val = &RangeFeedValue{}
			}
			if err := m.Val.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checkpoint", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Checkpoint == nil {
				m.Checkpoint = &RangeFeedCheckpoint{}
			}
			if err := m.Checkpoint.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &RangeFeedError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipApi(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowApi
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthApi
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowApi
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipApi(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthApi = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowApi   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("roachpb/api.proto", fileDescriptor_api_a444025f5929ff5f) }

var fileDescriptor_api_a444025f5929ff5f = []byte{
	// 6535 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x3d, 0x4b, 0x6c, 0x23, 0xc9,
	0x75, 0x6a, 0x92, 0xa2, 0xc8, 0xc7, 0x8f, 0xa8, 0xd2, 0x7c, 0x38, 0xda, 0xdd, 0x91, 0x86, 0xf3,
	0xdd, 0xd9, 0x5d, 0x8d, 0x67, 0xc6, 0xeb, 0x75, 0x76, 0xed, 0xb5, 0x45, 0x8a, 0x33, 0xe4, 0x68,
	0xf4, 0xd9, 0x22, 0x35, 0xeb, 0x59, 0x67, 0xd3, 0x6e, 0x75, 0x97, 0xa8, 0xf6, 0x90, 0xdd, 0xdc,
	0xee, 0xe6, 0x48, 0x1a, 0x20, 0x08, 0x90, 0x1c, 0x1c, 0x18, 0x86, 0x11, 0x24, 0x41, 0x10, 0x38,
	0x09, 0x62, 0xc0, 0x87, 0x00, 0x09, 0x62, 0xc4, 0x81, 0x81, 0x00, 0x41, 0x12, 0x5f, 0x72, 0x58,
	0x18, 0x39, 0x38, 0x01, 0x1c, 0x18, 0x39, 0x08, 0xc9, 0xe4, 0x60, 0x23, 0x97, 0x1c, 0x72, 0x08,
	0xb0, 0x87, 0x24, 0xa8, 0x4f, 0x7f, 0x48, 0x36, 0x3f, 0x33, 0xee, 0x45, 0x36, 0xc8, 0x49, 0xac,
	0x57, 0xf5, 0x5e, 0x57, 0xd5, 0x7b, 0xf5, 0xea, 0xbd, 0xaa, 0xf7, 0x4a, 0xb0, 0x60, 0x99, 0x8a,
	0x7a, 0xd0, 0xdd, 0xbb, 0xa1, 0x74, 0xf5, 0xd5, 0xae, 0x65, 0x3a, 0x26, 0x5a, 0x50, 0x4d, 0xf5,
	0x11, 0x03, 0xaf, 0x8a, 0xca, 0x25, 0xe4, 0xb6, 0xd2, 0x14, 0x47, 0xe1, 0xcd, 0x96, 0x4e, 0xb9,
	0x30, 0x62, 0x59, 0xa6, 0x65, 0x0b, 0xe8, 0x19, 0x17, 0xda, 0x21, 0x8e, 0x12, 0x68, 0x5d, 0xb2,
	0x1d, 0xd3, 0x52, 0x5a, 0xe4, 0x06, 0x31, 0x5a, 0xba, 0xe1, 0xfe, 0xa1, 0xed, 0x1e, 0xab, 0xaa,
	0x68, 0x73, 0x71, 0x5c, 0x9b, 0xdb, 0xa2, 0x51, 0xb1, 0xe7, 0xe8, 0xed, 0x1b, 0x07, 0x6d, 0xf5,
	0x86, 0xa3, 0x77, 0x88, 0xed, 0x28, 0x9d, 0xae, 0xa8, 0x59, 0x61, 0x35, 0x8e, 0xa5, 0xa8, 0xba,
	0xd1, 0xba, 0x61, 0x11, 0xd5, 0xb4, 0x34, 0xa2, 0xc9, 0x76, 0x57, 0x31, 0xdc, 0x2e, 0xb7, 0xcc,
	0x96, 0xc9, 0x7e, 0xde, 0xa0, 0xbf, 0x38, 0xb4, 0xf4, 0x2b, 0x90, 0xc6, 0x8a, 0xd1, 0x22, 0x75,
	0x63, 0xdf, 0x44, 0x9f, 0x83, 0x84, 0x46, 0x6c, 0xb5, 0x28, 0xad, 0x48, 0xd7, 0x32, 0xb7, 0x4a,
	0xab, 0x43, 0x73, 0xb1, 0xca, 0xda, 0xae, 0x13, 0x5b, 0xb5, 0xf4, 0xae, 0x63, 0x5a, 0xe5, 0xc4,
	0x87, 0x27, 0xcb, 0x33, 0x98, 0x61, 0xa1, 0x4f, 0xc3, 0x6c, 0x9b, 0x28, 0x36, 0x29, 0xc6, 0x18,
	0x7a, 0x31, 0x04, 0xfd, 0x3e, 0xad, 0x17, 0x48, 0xbc, 0x71, 0xe9, 0x09, 0xe4, 0x30, 0xf9, 0xa0,
	0x47, 0x6c, 0xa7, 0x46, 0x14, 0x8d, 0x58, 0xe8, 0x1c, 0xc4, 0x1f, 0x91, 0xe3, 0x62, 0x7c, 0x45,
	0xba, 0x96, 0x2d, 0xcf, 0x7d, 0x74, 0xb2, 0x1c, 0xdf, 0x20, 0xc7, 0x98, 0xc2, 0xd0, 0x0a, 0xcc,
	0x11, 0x43, 0x93, 0x69, 0x75, 0xa2, 0xbf, 0x3a, 0x49, 0x0c, 0x6d, 0x83, 0x1c, 0xa3, 0x25, 0x48,
	0xd9, 0x94, 0x9a, 0xa1, 0x92, 0xe2, 0xec, 0x8a, 0x74, 0x6d, 0x16, 0x7b, 0xe5, 0x37, 0x13, 0x3f,
	0xfb, 0xf6, 0xb2, 0x74, 0x2f, 0x91, 0x92, 0x0a, 0xb1, 0x7b, 0x89, 0x54, 0xac, 0x10, 0x2f, 0x7d,
	0x23, 0x0e, 0x79, 0x4c, 0xec, 0xae, 0x69, 0xd8, 0x44, 0x7c, 0xfd, 0x53, 0x10, 0x77, 0x8e, 0x0c,
	0xf6, 0xf5, 0xcc, 0xad, 0xf3, 0x21, 0x43, 0x68, 0x5a, 0x8a, 0x61, 0x2b, 0xaa, 0xa3, 0x9b, 0x06,
	0xa6, 0x4d, 0xd1, 0x67, 0x21, 0x63, 0x11, 0xbb, 0xd7, 0x21, 0x6c, 0xb2, 0x59, 0xc7, 0x32, 0xb7,
	0xce, 0x86, 0x60, 0x36, 0xba, 0x8a, 0x81, 0x81, 0xb7, 0xa5, 0xbf, 0xd1, 0x39, 0x48, 0x19, 0xbd,
	0x0e, 0x1d, 0x8e, 0xcd, 0x3a, 0x1b, 0xc7, 0x73, 0x46, 0xaf, 0xb3, 0x41, 0x8e, 0x6d, 0x54, 0x81,
	0x8c, 0x45, 0xa7, 0x5a, 0xd6, 0x8d, 0x7d, 0xd3, 0x2e, 0x26, 0x57, 0xe2, 0xd7, 0x32, 0xb7, 0x5e,
	0x1c, 0xc5, 0x10, 0xca, 0x3c, 0x31, 0xab, 0x60, 0xb9, 0x00, 0x1b, 0x35, 0x20, 0x27, 0x7a, 0x66,
	0x11, 0xc5, 0x36, 0x8d, 0xe2, 0xdc, 0x8a, 0x74, 0x2d, 0x7f, 0x6b, 0x35, 0x8c, 0x4c, 0xdf, 0x2c,
	0xd0, 0x62, 0xaf, 0x43, 0x30, 0xc3, 0xc2, 0x59, 0x2b, 0x50, 0x2a, 0x3d, 0x84, 0x6c, 0xb0, 0x16,
	0x21, 0xc8, 0xe3, 0x6a, 0x63, 0x77, 0xb3, 0x2a, 0xef, 0x6e, 0x6d, 0x6c, 0x6d, 0xbf, 0xbb, 0x55,
	0x98, 0x41, 0xa7, 0xa0, 0x20, 0x60, 0x1b, 0xd5, 0x87, 0xf2, 0xfd, 0xfa, 0x66, 0xbd, 0x59, 0x90,
	0xd0, 0x39, 0x38, 0x2d, 0xa0, 0x78, 0x6d, 0xeb, 0x6e, 0x55, 0x2e, 0x6f, 0xef, 0x6e, 0xad, 0xaf,
	0xe1, 0x87, 0x85, 0xd8, 0x52, 0xe2, 0xd7, 0xbf, 0x73, 0x7e, 0xa6, 0xf4, 0x00, 0xe0, 0x2e, 0x71,
	0x84, 0x34, 0xa0, 0x32, 0x24, 0x0f, 0x58, 0x6f, 0x84, 0x38, 0xae, 0x84, 0x76, 0x3b, 0x20, 0x39,
	0xe5, 0x14, 0x9d, 0x81, 0x1f, 0x9d, 0x2c, 0x4b, 0x58, 0x60, 0x72, 0x96, 0x97, 0x7e, 0x20, 0x41,
	0x86, 0x11, 0xe6, 0x63, 0x44, 0x95, 0x01, 0xca, 0x17, 0x26, 0x4e, 0xc8, 0x30, 0x69, 0xb4, 0x0a,
	0xb3, 0x8f, 0x95, 0x76, 0x6f, 0x9c, 0xb4, 0x3f, 0xa0, 0xf5, 0x98, 0x37, 0x43, 0x6f, 0x41, 0x56,
	0x37, 0x1c, 0x62, 0x38, 0x32, 0x47, 0x8b, 0x4f, 0x40, 0xcb, 0xf0, 0xd6, 0xac, 0x50, 0xfa, 0x4b,
	0x09, 0x60, 0xa7, 0x17, 0xe5, 0xd4, 0xd0, 0xd5, 0x3a, 0x55, 0xff, 0xdd, 0xd5, 0xca, 0x47, 0x71,
	0x06, 0x92, 0xba, 0xd1, 0xd6, 0x0d, 0xde, 0xff, 0x14, 0x16, 0x25, 0x74, 0x0a, 0x66, 0xf7, 0xda,
	0xba, 0xa1, 0x31, 0xf1, 0x4f, 0x61, 0x5e, 0x10, 0xd3, 0x8f, 0x21, 0xc3, 0xfa, 0x1e, 0xe1, 0xec,
	0x97, 0xbe, 0x15, 0x83, 0xd3, 0x15, 0xd3, 0xd0, 0x74, 0xba, 0x0e, 0x95, 0xf6, 0x27, 0x62, 0x6e,
	0x5e, 0x87, 0x34, 0x39, 0xea, 0x4e, 0xc9, 0xde, 0x14, 0x39, 0xea, 0xb2, 0x5f, 0xe1, 0x53, 0x87,
	0x3e, 0x0d, 0x67, 0x95, 0x76, 0xdb, 0x3c, 0x94, 0xf5, 0x7d, 0x59, 0x33, 0x89, 0x2d, 0x1b, 0xa6,
	0x23, 0x93, 0x23, 0xdd, 0x76, 0x98, 0xaa, 0x48, 0xe1, 0x45, 0x56, 0x5d, 0xdf, 0x5f, 0x37, 0x89,
	0xbd, 0x65, 0x3a, 0x55, 0x5a, 0x25, 0x26, 0xfc, 0x7d, 0x38, 0x33, 0x38, 0x37, 0x51, 0xce, 0xfd,
	0x3f, 0x48, 0x90, 0xaf, 0x1b, 0xba, 0xf3, 0x89, 0x98, 0x74, 0x6f, 0xf6, 0xe2, 0xc1, 0xd9, 0xbb,
	0x0e, 0x85, 0x7d, 0x45, 0x6f, 0x6f, 0x1b, 0x4d, 0xb3, 0xb3, 0x67, 0x3b, 0xa6, 0x41, 0x6c, 0x31,
	0xbd, 0x43, 0x70, 0x31, 0x67, 0x0f, 0x60, 0xde, 0x1b, 0x53, 0x94, 0x93, 0xf5, 0x04, 0x0a, 0x75,
	0x43, 0xb5, 0x48, 0x87, 0x18, 0x91, 0xce, 0xd6, 0x8b, 0x90, 0xd6, 0x5d, 0xba, 0x6c, 0xc6, 0xe2,
	0xd8, 0x07, 0x88, 0x31, 0xf5, 0x60, 0x21, 0xf0, 0xed, 0x28, 0x95, 0xdf, 0x0b, 0x90, 0x36, 0xc8,
	0xa1, 0xec, 0xf3, 0x2b, 0x8e, 0x53, 0x06, 0x39, 0xe4, 0xca, 0xea, 0x21, 0xe4, 0xd6, 0x49, 0x9b,
	0x38, 0x24, 0x7a, 0x4d, 0xbe, 0x0b, 0x79, 0x97, 0x74, 0x94, 0x4c, 0xfa, 0x03, 0x09, 0x90, 0xa0,
	0x4b, 0x77, 0xcf, 0x28, 0xf9, 0xb4, 0x4c, 0xad, 0x03, 0xa7, 0x67, 0x19, 0x7c, 0x9b, 0xe7, 0x52,
	0x0a, 0x1c, 0xc4, 0x76, 0x7a, 0x5f, 0xa3, 0x26, 0x82, 0x1a, 0xd5, 0xb3, 0x56, 0xa8, 0x9d, 0x72,
	0x08, 0x8b, 0x7d, 0xdd, 0x8b, 0x96, 0x95, 0x09, 0xd6, 0xb3, 0xd8, 0x4a, 0x3c, 0x68, 0x50, 0x31,
	0x60, 0xe9, 0x7d, 0x58, 0xa8, 0xb4, 0x89, 0x62, 0x45, 0x3d, 0x2d, 0x82, 0x9d, 0x0f, 0x01, 0x05,
	0xc9, 0x47, 0xc9, 0x52, 0x1d, 0x32, 0x0d, 0x55, 0x31, 0xb6, 0xbb, 0x54, 0x09, 0xda, 0xe8, 0x36,
	0x9c, 0xb1, 0x1d, 0xb3, 0x2b, 0x2b, 0x8e, 0xcc, 0xed, 0xaa, 0x3d, 0xb3, 0x67, 0x68, 0x8a, 0x75,
	0xcc, 0xbe, 0x91, 0xc2, 0x8b, 0xb4, 0x76, 0xcd, 0x61, 0x1d, 0x29, 0x8b, 0x2a, 0xca, 0xbb, 0x8e,
	0x6e, 0xc8, 0xd4, 0xfc, 0x69, 0x3b, 0xb6, 0x90, 0x73, 0xe8, 0xe8, 0x06, 0xe6, 0x10, 0x31, 0x8a,
	0xef, 0x48, 0xfc, 0x5b, 0x51, 0x8a, 0xcd, 0xdb, 0x90, 0xb1, 0x55, 0xc5, 0x90, 0xf7, 0x4d, 0xab,
	0xa3, 0x38, 0x4c, 0x34, 0xf2, 0xb7, 0x5e, 0x0a, 0x33, 0x2a, 0x55, 0xc5, 0xb8, 0xc3, 0x1a, 0x61,
	0xb0, 0xbd, 0xdf, 0x41, 0xe9, 0xb9, 0x97, 0x48, 0xc5, 0x0b, 0x89, 0xd2, 0x7f, 0x4a, 0x90, 0xe5,
	0xbd, 0x8c, 0x52, 0x7a, 0x5e, 0x87, 0x84, 0x65, 0x1e, 0x72, 0xe9, 0xc9, 0xdc, 0x7a, 0x21, 0x84,
	0xc4, 0x06, 0x39, 0x0e, 0xaa, 0x6d, 0xd6, 0x1c, 0x95, 0x41, 0x98, 0x37, 0x32, 0xc3, 0x8e, 0x4f,
	0x8b, 0x0d, 0x1c, 0x0b, 0x53, 0x1a, 0x57, 0x61, 0x7e, 0x4f, 0x71, 0xd4, 0x03, 0xca, 0x1f, 0xd6,
	0x49, 0xaa, 0xe2, 0xe3, 0xd7, 0xb2, 0x38, 0xcf, 0xc0, 0x6e, 0xd7, 0xed, 0xd2, 0x1f, 0x4b, 0x80,
	0x30, 0x79, 0x4c, 0x2c, 0x9b, 0x7c, 0xf2, 0xd9, 0xf4, 0x5f, 0x12, 0x2c, 0xf6, 0x75, 0xf6, 0xff,
	0x1b, 0xb7, 0x7e, 0x2c, 0xc1, 0xd9, 0xca, 0x01, 0x51, 0x1f, 0x55, 0x4c, 0xc3, 0xd6, 0x6d, 0x87,
	0x18, 0xea, 0x71, 0x94, 0x2c, 0x7b, 0x01, 0xd2, 0x87, 0xba, 0x73, 0x20, 0x6b, 0xfa, 0xfe, 0x3e,
	0x5b, 0xd2, 0x29, 0x9c, 0xa2, 0x80, 0x75, 0x7d, 0x7f, 0x1f, 0xdd, 0x86, 0x44, 0xc7, 0xd4, 0xb8,
	0xf5, 0x96, 0xbf, 0xb5, 0x1c, 0x42, 0x9e, 0x75, 0xcd, 0xee, 0x75, 0x36, 0x4d, 0x8d, 0x60, 0xd6,
	0x18, 0x9d, 0x07, 0x50, 0x29, 0xb4, 0x6b, 0xea, 0x86, 0x23, 0xb4, 0x78, 0x00, 0x22, 0xb4, 0xc4,
	0x37, 0x13, 0x50, 0x1c, 0x1e, 0x57, 0x94, 0xdc, 0xdd, 0x81, 0x24, 0x57, 0x55, 0x82, 0xbf, 0xb7,
	0x46, 0x75, 0x3f, 0xa4, 0x07, 0xab, 0x5c, 0xa5, 0x09, 0xc6, 0x09, 0x3a, 0x4b, 0x7f, 0x25, 0x41,
	0x92, 0x57, 0xa0, 0x9b, 0x90, 0x12, 0x0e, 0xa9, 0xc6, 0xfa, 0x18, 0x2f, 0x9f, 0x79, 0x7a, 0xb2,
	0x3c, 0xc7, 0xdd, 0xcf, 0xf5, 0x8f, 0xfc, 0x9f, 0x78, 0x8e, 0x7b, 0xa0, 0x1a, 0x9d, 0x69, 0xdb,
	0x51, 0x2c, 0x87, 0xf9, 0xeb, 0x74, 0xa6, 0xb3, 0x38, 0xc5, 0x00, 0xd4, 0x51, 0xbf, 0x07, 0x49,
	0xdb, 0x51, 0x9c, 0x9e, 0x2d, 0xe6, 0xfa, 0x99, 0x3a, 0xdb, 0x60, 0x98, 0x58, 0x50, 0xa0, 0x5b,
	0xa8, 0x46, 0x1c, 0x45, 0x6f, 0xb3, 0xc9, 0x4f, 0x63, 0x51, 0x2a, 0xfd, 0x9e, 0x04, 0x49, 0xde,
	0x14, 0x9d, 0x85, 0x45, 0xee, 0x74, 0xd6, 0xb7, 0xd6, 0xab, 0xcd, 0x2a, 0xde, 0xac, 0x6f, 0xad,
	0x35, 0xab, 0x85, 0x19, 0x74, 0x06, 0x90, 0x5b, 0x51, 0xd9, 0xde, 0x6a, 0xd4, 0x1b, 0xcd, 0xea,
	0x16, 0x75, 0x56, 0xa9, 0x0b, 0xcb, 0xe0, 0x01, 0x68, 0x0c, 0x5d, 0x82, 0x95, 0x41, 0xa8, 0xdc,
	0x68, 0xae, 0x35, 0x1b, 0x72, 0xb5, 0xd1, 0xac, 0x6f, 0xae, 0x35, 0xab, 0xeb, 0x85, 0xf8, 0x98,
	0x56, 0xf4, 0x23, 0x18, 0x57, 0x2b, 0xcd, 0x42, 0xa2, 0xf4, 0x04, 0x4e, 0x63, 0xa2, 0x9a, 0x9d,
	0x6e, 0xcf, 0x21, 0xb4, 0x97, 0x76, 0x94, 0x52, 0x7e, 0x16, 0xe6, 0x34, 0xeb, 0x58, 0xb6, 0x7a,
	0x86, 0x90, 0xf1, 0xa4, 0x66, 0x1d, 0xe3, 0x9e, 0x21, 0x84, 0xf1, 0x2f, 0x24, 0x38, 0x33, 0xf8,
	0xf1, 0x28, 0x45, 0xf1, 0x4b, 0x90, 0x51, 0x34, 0x8d, 0x68, 0xb2, 0x46, 0xda, 0x8e, 0x22, 0x2c,
	0xfa, 0x9b, 0x01, 0x4a, 0xe2, 0xb0, 0x6b, 0x95, 0x9f, 0x72, 0xad, 0xba, 0x87, 0x5d, 0xab, 0x9b,
	0x0f, 0x2a, 0x15, 0xd6, 0x9f, 0x75, 0x8a, 0xe8, 0xea, 0x11, 0x46, 0x8b, 0x41, 0x4a, 0x2a, 0x9c,
	0x2d, 0x93, 0x96, 0x6e, 0x04, 0x8f, 0x61, 0x22, 0xb7, 0x4b, 0x64, 0x28, 0x0e, 0x7f, 0x24, 0x4a,
	0xeb, 0xe4, 0xef, 0xe3, 0x70, 0xba, 0x6a, 0x68, 0x1f, 0xcf, 0x20, 0xe8, 0x7a, 0x50, 0xcd, 0x4e,
	0x47, 0x77, 0x5c, 0xde, 0xf3, 0x12, 0xfa, 0x05, 0x48, 0x69, 0x44, 0xd1, 0x3c, 0xf7, 0x3d, 0xd3,
	0xb7, 0x55, 0xf5, 0x1c, 0xbd, 0xbd, 0x7a, 0xd0, 0x56, 0x57, 0x9b, 0xee, 0xd1, 0x22, 0xf6, 0x9a,
	0xa3, 0xaf, 0xc0, 0x59, 0xaa, 0xcc, 0x2d, 0x43, 0x69, 0xcb, 0x9c, 0x9a, 0xec, 0x58, 0x7a, 0xab,
	0x45, 0x2c, 0x71, 0xe0, 0x75, 0x2d, 0xa4, 0x9f, 0x75, 0x81, 0x51, 0x61, 0x08, 0x4d, 0xde, 0x1e,
	0x9f, 0xd6, 0xc3, 0xc0, 0xe8, 0x8b, 0xde, 0xf9, 0x88, 0xdd, 0x55, 0x0c, 0xbb, 0x38, 0xcb, 0x74,
	0xd8, 0xa8, 0x73, 0x34, 0x21, 0x19, 0x62, 0x5f, 0xa2, 0x10, 0x1b, 0xdd, 0xa0, 0xa6, 0xf6, 0x07,
	0x3d, 0xdd, 0x22, 0xf2, 0xcd, 0xae, 0x5a, 0x4c, 0xd2, 0xb1, 0x97, 0xf3, 0x4f, 0x4f, 0x96, 0x01,
	0x73, 0xf0, 0xcd, 0x9d, 0x0a, 0x35, 0xbd, 0xf9, 0xef, 0xae, 0x8a, 0xae, 0x41, 0xc1, 0x30, 0x65,
	0x8b, 0xec, 0x5b, 0xc4, 0x3e, 0x10, 0x9f, 0x4d, 0xb1, 0x19, 0xcb, 0x1b, 0x26, 0xe6, 0x60, 0x4e,
	0xfa, 0x0c, 0x24, 0xbb, 0xa6, 0x6e, 0x9b, 0x46, 0x31, 0xcd, 0x67, 0x94, 0x97, 0xbc, 0xfd, 0x7b,
	0xae, 0x90, 0x2a, 0xfd, 0x96, 0x04, 0x67, 0x06, 0x79, 0x1a, 0xe5, 0x9a, 0xba, 0x06, 0x05, 0xd3,
	0x20, 0x72, 0xf7, 0x40, 0xb1, 0x89, 0xe0, 0x81, 0xd8, 0x6c, 0xf2, 0xa6, 0x41, 0x76, 0x28, 0x98,
	0xcf, 0x68, 0x9f, 0x3d, 0xf1, 0x6b, 0x12, 0x2c, 0xac, 0x69, 0x1d, 0xdd, 0x68, 0x74, 0xdb, 0x7a,
	0xa4, 0x1e, 0xe8, 0x25, 0x48, 0xdb, 0x94, 0xa6, 0xaf, 0xde, 0x7d, 0xef, 0x21, 0xc5, 0x6a, 0x36,
	0xc8, 0xb1, 0x6f, 0xe8, 0x07, 0x3b, 0x11, 0xe5, 0x52, 0x7a, 0x5f, 0x8c, 0x6f, 0x93, 0x58, 0x1f,
	0x93, 0x8b, 0x12, 0x24, 0x1f, 0x65, 0xcf, 0xbf, 0x2e, 0xc1, 0x39, 0x46, 0x9b, 0x89, 0xcc, 0x3e,
	0xb1, 0xd8, 0xe9, 0x78, 0x94, 0x2c, 0xba, 0x08, 0x49, 0x47, 0xb1, 0x5a, 0x84, 0x2b, 0x82, 0xd9,
	0x72, 0x86, 0xee, 0xd3, 0x0d, 0xc7, 0xb4, 0xe8, 0x3e, 0x2d, 0xaa, 0xc4, 0x38, 0x15, 0x58, 0x0a,
	0xeb, 0x4b, 0x94, 0xe3, 0xfd, 0xf3, 0x98, 0xf8, 0x46, 0xe5, 0x80, 0xfb, 0x7b, 0xdd, 0xb6, 0xae,
	0x2a, 0x91, 0x6e, 0x7b, 0x55, 0xc8, 0xa8, 0x8c, 0xb8, 0xec, 0x1c, 0x77, 0xf9, 0xc9, 0x44, 0xfe,
	0xd6, 0xa5, 0x50, 0x42, 0xec, 0xe3, 0xbc, 0x27, 0xcd, 0xe3, 0x2e, 0xa1, 0x16, 0x9b, 0xfb, 0x1b,
	0xad, 0xc3, 0x1c, 0x9f, 0x1c, 0xd7, 0xd8, 0x1d, 0x43, 0x82, 0x2e, 0xf4, 0x26, 0x6b, 0x2c, 0x74,
	0x92, 0x8b, 0x8a, 0x3e, 0x0f, 0x29, 0x72, 0xd4, 0x95, 0xd9, 0x8d, 0x4a, 0x62, 0xda, 0x1b, 0x15,
	0x3c, 0x47, 0x8e, 0xba, 0xb4, 0x28, 0xf8, 0xf2, 0x2d, 0x09, 0x5e, 0x08, 0x9d, 0xb4, 0x28, 0x55,
	0xcb, 0x67, 0xc4, 0xbd, 0x4f, 0x6c, 0xea, 0x5e, 0xb2, 0xf6, 0xa5, 0x3f, 0x71, 0x25, 0x18, 0x93,
	0xb6, 0xa9, 0x2a, 0x1f, 0xc3, 0xf1, 0x49, 0x80, 0x13, 0xb1, 0xe7, 0xe6, 0xc4, 0x80, 0x88, 0x0f,
	0x74, 0x36, 0x4a, 0x11, 0xff, 0x1d, 0x09, 0x16, 0x6b, 0x44, 0xb1, 0x9c, 0x3d, 0xa2, 0x38, 0xcd,
	0xa3, 0x48, 0x77, 0xf5, 0xd7, 0x21, 0x6e, 0x98, 0x87, 0x82, 0x47, 0xe3, 0x37, 0x6e, 0x31, 0x7e,
	0xda, 0x5e, 0x8c, 0xfd, 0xcb, 0x70, 0xaa, 0xbf, 0x5f, 0x51, 0x8e, 0xfa, 0x7b, 0x71, 0x48, 0xdf,
	0xad, 0x44, 0x39, 0xd6, 0xcf, 0x89, 0x43, 0x29, 0xbe, 0xfa, 0xc2, 0x04, 0xd2, 0xfb, 0xde, 0xea,
	0xdd, 0xca, 0x06, 0x39, 0x76, 0xfd, 0x55, 0x8a, 0x85, 0xd6, 0x20, 0xed, 0x1c, 0xd0, 0xcd, 0xdb,
	0x6c, 0x6b, 0x62, 0xe5, 0x4d, 0x35, 0x5f, 0x3e, 0x16, 0x6a, 0xc3, 0x69, 0xe7, 0xc8, 0x60, 0x36,
	0x81, 0xdc, 0x52, 0x65, 0x9f, 0xdc, 0xec, 0x34, 0xe4, 0x96, 0x28, 0xb9, 0xa7, 0x27, 0xcb, 0xa8,
	0x79, 0x64, 0x50, 0x03, 0xe2, 0x6e, 0xa5, 0xe9, 0x12, 0xc0, 0xc8, 0x11, 0x30, 0xd5, 0x83, 0x2d,
	0x3d, 0x82, 0x59, 0x36, 0x0a, 0xf7, 0xee, 0x53, 0x0a, 0xb9, 0xfb, 0xa4, 0x83, 0x72, 0x3f, 0xf0,
	0x2c, 0x42, 0xe0, 0x63, 0x71, 0x51, 0x10, 0x02, 0xf1, 0x0e, 0x00, 0x9d, 0xc2, 0x28, 0xc5, 0xe0,
	0xbf, 0xe3, 0x90, 0xdf, 0xe9, 0xd9, 0x07, 0x11, 0xcb, 0x7d, 0x05, 0xa0, 0xdb, 0xb3, 0x0f, 0x88,
	0x25, 0x3b, 0x47, 0x86, 0x18, 0xf9, 0x84, 0x8b, 0x59, 0x77, 0xe8, 0x1c, 0xaf, 0x79, 0x64, 0xa0,
	0x6d, 0x41, 0x84, 0xc8, 0xfe, 0xed, 0xee, 0xf5, 0x29, 0xfc, 0x91, 0xe6, 0x91, 0xb1, 0x49, 0x3c,
	0x47, 0x84, 0x13, 0x24, 0x94, 0xe0, 0xe7, 0x60, 0x8e, 0x16, 0x64, 0xc7, 0x7c, 0x16, 0x09, 0x4b,
	0x52, 0x9c, 0xa6, 0x89, 0xee, 0x41, 0x5e, 0x23, 0x5d, 0x8b, 0x50, 0x35, 0xa4, 0xc9, 0x74, 0x59,
	0xcf, 0x4e, 0x4f, 0x24, 0xe7, 0xa3, 0x6e, 0x99, 0x87, 0xe8, 0x2d, 0x48, 0xf3, 0x9e, 0xd0, 0x1d,
	0x2f, 0xc9, 0x76, 0xbc, 0xb0, 0xe9, 0x11, 0x9c, 0x61, 0x7b, 0x5d, 0x8a, 0x75, 0x83, 0xee, 0x74,
	0xa7, 0x60, 0x76, 0xdf, 0xb4, 0x54, 0xc2, 0xae, 0x86, 0x53, 0x98, 0x17, 0xd0, 0x75, 0x58, 0xd0,
	0x0d, 0xb5, 0xdd, 0xb3, 0xf5, 0xc7, 0x44, 0x76, 0x87, 0xc9, 0x2d, 0xdf, 0x79, 0xaf, 0x82, 0x11,
	0x34, 0x3d, 0x13, 0x38, 0x55, 0x48, 0x53, 0x87, 0x7b, 0xde, 0x93, 0x80, 0x28, 0x37, 0xa8, 0x4a,
	0x1f, 0xfb, 0x9e, 0x5d, 0x06, 0x28, 0xcb, 0x4a, 0xdf, 0x8d, 0xc1, 0xfc, 0x3b, 0x3d, 0x62, 0x1d,
	0x47, 0x2c, 0xa0, 0x65, 0x1e, 0x32, 0x10, 0x7b, 0x4e, 0xa1, 0x62, 0x41, 0x04, 0x57, 0x60, 0xfe,
	0x50, 0xd1, 0x1d, 0x79, 0xdf, 0xb4, 0xe4, 0x5e, 0x57, 0x53, 0x1c, 0xf7, 0x82, 0x35, 0x47, 0xc1,
	0x77, 0x4c, 0x6b, 0x97, 0x01, 0x11, 0x01, 0xf4, 0xc8, 0x30, 0x0f, 0x0d, 0x99, 0x82, 0x75, 0xa3,
	0x45, 0xe7, 0x43, 0x9c, 0xa4, 0x95, 0xdf, 0xf8, 0xa7, 0x93, 0xe5, 0xdb, 0x2d, 0xdd, 0x39, 0xe8,
	0xed, 0xad, 0xaa, 0x66, 0xe7, 0x86, 0xd7, 0x11, 0x6d, 0xcf, 0xff, 0x7d, 0xa3, 0xfb, 0xa8, 0x75,
	0x83, 0xc5, 0x8a, 0xf4, 0x7a, 0xba, 0xb6, 0xba, 0xbb, 0x5b, 0x5f, 0xc7, 0x05, 0x46, 0xf2, 0x5d,
	0x4e, 0xb1, 0x79, 0x64, 0xb8, 0x1b, 0xe6, 0x47, 0x12, 0x14, 0xfc, 0x09, 0x8b, 0x92, 0x9f, 0x55,
	0xc8, 0x7c, 0xd0, 0x23, 0x96, 0x4e, 0xb4, 0x67, 0x66, 0x28, 0x08, 0x44, 0xba, 0x08, 0xdf, 0x83,
	0x6c, 0xdf, 0x3c, 0xc4, 0x7f, 0xbe, 0x79, 0xc8, 0x1c, 0xfa, 0x53, 0x50, 0xfa, 0x9b, 0x18, 0x20,
	0x36, 0xf8, 0x3a, 0x3f, 0xc4, 0xfc, 0x84, 0x09, 0xcc, 0x03, 0x00, 0x7d, 0x5f, 0xee, 0xe8, 0xb6,
	0xad, 0x1b, 0x2d, 0x71, 0x86, 0xf6, 0x46, 0x48, 0x5f, 0x86, 0x87, 0xb0, 0x5a, 0xdf, 0xdf, 0xe4,
	0x68, 0x65, 0x72, 0xa0, 0x3c, 0xd6, 0x4d, 0x0b, 0xa7, 0x75, 0x17, 0x54, 0x2a, 0xc3, 0xc2, 0x50,
	0x3d, 0xca, 0x03, 0xac, 0x6f, 0xcb, 0x5b, 0xdb, 0xcd, 0x5a, 0x7d, 0xeb, 0x6e, 0x61, 0x06, 0x15,
	0x20, 0x8b, 0xab, 0xcd, 0x5d, 0xbc, 0x25, 0x57, 0x31, 0xde, 0xc6, 0x05, 0x09, 0x65, 0x60, 0x6e,
	0x07, 0x57, 0x1f, 0xb0, 0x53, 0x32, 0x21, 0x3d, 0xbf, 0x0c, 0x8b, 0x7d, 0x1f, 0x8f, 0x52, 0x7e,
	0x2e, 0x40, 0x76, 0xdf, 0xec, 0x19, 0x9a, 0xcc, 0xfd, 0x7f, 0x71, 0xce, 0x91, 0x61, 0x30, 0xfe,
	0xbd, 0xd2, 0xd7, 0x62, 0x70, 0x0a, 0x13, 0xdb, 0x6c, 0x3f, 0x26, 0xd1, 0x73, 0x70, 0x1b, 0xc4,
	0xd9, 0xb6, 0xfc, 0xf3, 0x30, 0x32, 0xcd, 0x69, 0xf0, 0xed, 0xa4, 0xff, 0x38, 0xf4, 0xd2, 0xf8,
	0xb5, 0x30, 0x7c, 0x00, 0x2a, 0x8e, 0x27, 0x12, 0xc3, 0xc7, 0x13, 0xa5, 0x5f, 0x84, 0xd3, 0x03,
	0x13, 0x11, 0xe5, 0xae, 0xff, 0x8f, 0x31, 0x38, 0xd7, 0x4f, 0x3e, 0x6a, 0x1f, 0xe0, 0xff, 0xc6,
	0x64, 0xa3, 0x1a, 0xe4, 0x3a, 0xba, 0x21, 0xfb, 0x46, 0xda, 0x33, 0x6c, 0xe9, 0x59, 0xea, 0x79,
	0xf7, 0xdb, 0x69, 0xd4, 0x5d, 0x09, 0x9b, 0xd7, 0x28, 0x79, 0xf7, 0x4d, 0x09, 0xb2, 0x51, 0x9f,
	0x9b, 0x3c, 0x5f, 0x1c, 0x87, 0x18, 0x73, 0x13, 0x72, 0x1f, 0xc3, 0x41, 0xcb, 0x1f, 0x49, 0x80,
	0x9a, 0x56, 0xcf, 0xa0, 0x26, 0xd3, 0x7d, 0xb3, 0x15, 0xe5, 0x60, 0x4f, 0xc1, 0xac, 0x6e, 0x68,
	0xe4, 0x88, 0x0d, 0x36, 0x81, 0x79, 0xa1, 0xef, 0xb2, 0x24, 0x3e, 0xd5, 0x65, 0x89, 0x18, 0xff,
	0x7b, 0xb0, 0xd8, 0xd7, 0xd1, 0x28, 0x67, 0xe1, 0xbb, 0x31, 0x58, 0x14, 0xc3, 0x89, 0xfc, 0xa0,
	0xe9, 0xb9, 0x42, 0x3f, 0xd1, 0xe7, 0x01, 0xba, 0x16, 0x79, 0x2c, 0x73, 0xd4, 0xf8, 0x54, 0xa8,
	0x69, 0x8a, 0xc1, 0x00, 0xe8, 0x4b, 0x30, 0x4f, 0x17, 0x5c, 0xd7, 0x32, 0xbb, 0xa6, 0x4d, 0x2d,
	0x09, 0x7b, 0x3a, 0x53, 0x7c, 0xe1, 0xe9, 0xc9, 0x72, 0x6e, 0x53, 0x37, 0x76, 0x04, 0x62, 0xb3,
	0x81, 0xe9, 0xca, 0xf5, 0x8a, 0xae, 0xf9, 0xf3, 0x63, 0x09, 0x4e, 0x7d, 0x6c, 0x47, 0x73, 0xff,
	0x1b, 0x33, 0xe6, 0xed, 0x07, 0x05, 0x56, 0xac, 0x1b, 0xfb, 0x66, 0xf4, 0x07, 0xa6, 0xdf, 0x94,
	0x60, 0x21, 0x40, 0x3e, 0xca, 0x5d, 0xff, 0xf9, 0x02, 0x8c, 0xbf, 0x4c, 0xed, 0x80, 0xa0, 0xd8,
	0x47, 0xb9, 0xa8, 0xfe, 0x43, 0x82, 0x33, 0x15, 0x7e, 0x8d, 0xe6, 0xde, 0x0c, 0x47, 0x29, 0x25,
	0x45, 0x98, 0x7b, 0x4c, 0x2c, 0x5b, 0x37, 0xf9, 0xbe, 0x97, 0xc3, 0x6e, 0x91, 0x05, 0x3a, 0x1b,
	0x4a, 0xd7, 0x3e, 0x30, 0xdd, 0x5b, 0x00, 0xaf, 0xec, 0xdd, 0x62, 0xcf, 0x3e, 0xff, 0x2d, 0x76,
	0x32, 0xfc, 0x16, 0x5b, 0x5c, 0x2a, 0xfc, 0x50, 0x82, 0xb3, 0x43, 0xa3, 0x8e, 0x92, 0xd3, 0x5f,
	0x85, 0x8c, 0x2a, 0x08, 0x53, 0x1d, 0xca, 0x6f, 0x17, 0xea, 0xb4, 0xd9, 0x73, 0xda, 0xf6, 0x4f,
	0x4f, 0x96, 0xc1, 0xed, 0x6a, 0x7d, 0x5d, 0x0c, 0x8c, 0xfe, 0xd6, 0x4a, 0x3f, 0x05, 0xc8, 0x55,
	0x8f, 0xba, 0xa6, 0xe5, 0x34, 0xb8, 0x21, 0x81, 0xd6, 0x21, 0xd5, 0xb5, 0xcc, 0xc7, 0xba, 0x3b,
	0x88, 0x7c, 0xe8, 0xed, 0x56, 0x1f, 0xce, 0x8e, 0x68, 0x8f, 0x3d, 0x4c, 0x84, 0x21, 0x7d, 0xdf,
	0x54, 0x95, 0xf6, 0x1d, 0xbd, 0xed, 0x4a, 0xec, 0xea, 0x24, 0x32, 0xab, 0x1e, 0xc6, 0x8e, 0xe2,
	0x1c, 0xb8, 0x0b, 0xd8, 0x03, 0xa2, 0xbb, 0x90, 0xaa, 0x39, 0x4e, 0x97, 0x56, 0x8a, 0xd5, 0x7f,
	0x79, 0x22, 0x49, 0x8a, 0x20, 0x28, 0x79, 0xc8, 0x08, 0xc3, 0xc2, 0x5d, 0xd3, 0x6c, 0xb5, 0x49,
	0xa5, 0x6d, 0xf6, 0xb4, 0x8a, 0x69, 0xec, 0xeb, 0x2d, 0xa1, 0x3d, 0x2f, 0x4d, 0xa4, 0x78, 0xb7,
	0xd2, 0xc0, 0xc3, 0xe8, 0xe8, 0x0b, 0x90, 0x6a, 0xdc, 0x16, 0xa4, 0xb8, 0xed, 0x73, 0x71, 0x22,
	0xa9, 0xc6, 0x6d, 0xec, 0x21, 0xa1, 0x1a, 0x64, 0xd6, 0x9e, 0xf4, 0x2c, 0x22, 0x68, 0x24, 0x19,
	0x8d, 0x2b, 0x13, 0x69, 0x30, 0x1c, 0x1c, 0x44, 0x45, 0xef, 0x40, 0xfe, 0x5d, 0xd3, 0x7a, 0xd4,
	0x36, 0x15, 0x77, 0x6c, 0x73, 0x8c, 0xd8, 0xcb, 0x13, 0x89, 0xb9, 0x68, 0x78, 0x80, 0xc0, 0xd2,
	0x97, 0x20, 0xd7, 0xc7, 0x1c, 0x84, 0x20, 0xd1, 0xa5, 0x7c, 0x90, 0x58, 0xcc, 0x01, 0xfb, 0x8d,
	0x5e, 0x83, 0x39, 0xc3, 0xd4, 0x88, 0x2b, 0xb3, 0xb9, 0xf2, 0xa9, 0xa7, 0x27, 0xcb, 0xc9, 0x2d,
	0x53, 0xe3, 0xdb, 0xbe, 0xf8, 0x85, 0x93, 0xb4, 0x91, 0xbb, 0xe9, 0x2f, 0x5d, 0x81, 0x04, 0xe5,
	0x0b, 0x5d, 0xec, 0x7b, 0x8a, 0x4d, 0x76, 0x2d, 0x5d, 0xd0, 0x74, 0x8b, 0xa2, 0xdd, 0xdf, 0x4a,
	0x10, 0x6b, 0xdc, 0xa6, 0xf6, 0xe7, 0x5e, 0x4f, 0x7d, 0x44, 0x1c, 0xd1, 0x4a, 0x94, 0x98, 0x5d,
	0x6a, 0x91, 0x7d, 0x9d, 0xdb, 0x22, 0x69, 0x2c, 0x4a, 0xe8, 0x25, 0x00, 0x45, 0x55, 0x89, 0x6d,
	0xcb, 0x6e, 0x5a, 0x45, 0x1a, 0xa7, 0x39, 0x64, 0x83, 0x1c, 0x53, 0x34, 0x9b, 0xa8, 0x16, 0x71,
	0xdc, 0xe0, 0x09, 0x5e, 0xa2, 0x68, 0x0e, 0xe9, 0x74, 0x65, 0xc7, 0x7c, 0x44, 0x0c, 0xc6, 0xcf,
	0x34, 0x4e, 0x53, 0x48, 0x93, 0x02, 0xa8, 0xfe, 0x21, 0x86, 0xe6, 0x2b, 0x8b, 0x34, 0xf6, 0xca,
	0x94, 0xa4, 0x45, 0x5a, 0xba, 0x48, 0x38, 0x48, 0x63, 0x51, 0x12, 0xc3, 0xf8, 0x96, 0x04, 0xf1,
	0xbb, 0x95, 0xc6, 0x33, 0x8f, 0x03, 0x41, 0x42, 0xe9, 0x09, 0xb9, 0x4f, 0x63, 0xf6, 0x9b, 0x45,
	0x15, 0xe9, 0xed, 0xb6, 0x6e, 0xb4, 0xa8, 0x19, 0xf0, 0x55, 0xa2, 0xba, 0xa3, 0xc8, 0x0b, 0xf0,
	0x0e, 0x87, 0xa2, 0x15, 0xc8, 0xa8, 0x16, 0xd1, 0x88, 0xe1, 0xe8, 0x4a, 0xdb, 0x16, 0xc3, 0x09,
	0x82, 0x44, 0xe7, 0xbe, 0x26, 0xc1, 0x2c, 0x13, 0x24, 0xf4, 0x22, 0xa4, 0x55, 0xd3, 0x70, 0x14,
	0xdd, 0x10, 0x5a, 0x20, 0x8d, 0x7d, 0xc0, 0xc8, 0x4e, 0x5e, 0x80, 0xac, 0xa2, 0xaa, 0x66, 0xcf,
	0x70, 0x64, 0x43, 0xe9, 0x10, 0xd1, 0xd9, 0x8c, 0x80, 0x6d, 0x29, 0x1d, 0x82, 0x96, 0xc1, 0x2d,
	0x7a, 0x89, 0x2c, 0x69, 0x0c, 0x02, 0xe4, 0x5d, 0x99, 0x2e, 0xfd, 0x50, 0x82, 0x94, 0x2b, 0x82,
	0xb4, 0x33, 0x2d, 0x62, 0x10, 0x4b, 0x71, 0x4c, 0xaf, 0x33, 0x1e, 0x60, 0x70, 0x97, 0x48, 0xfb,
	0xbb, 0xc4, 0x29, 0x98, 0x75, 0x94, 0xbd, 0xb6, 0xdb, 0x0f, 0x5e, 0x60, 0x87, 0x7e, 0x6d, 0xa5,
	0xc5, 0xcf, 0x8d, 0xd2, 0x98, 0x17, 0xe8, 0x90, 0x44, 0x18, 0x1b, 0x9f, 0x1d, 0x51, 0xa2, 0xfd,
	0xe5, 0x91, 0x5b, 0x7b, 0xa4, 0xa5, 0x1b, 0x8c, 0xd9, 0x71, 0x0c, 0x0c, 0xc4, 0x82, 0x24, 0xd0,
	0x0b, 0x90, 0xe6, 0x0d, 0x88, 0xa1, 0x31, 0x8e, 0xc7, 0x71, 0x8a, 0x01, 0xaa, 0x6e, 0x0a, 0x80,
	0x30, 0x0d, 0xfe, 0x54, 0x82, 0x85, 0x77, 0x2d, 0xdd, 0x21, 0x65, 0x1e, 0xf2, 0x15, 0xdd, 0x3e,
	0xf9, 0x26, 0xa4, 0x35, 0xc5, 0x51, 0x78, 0x06, 0x4e, 0x6c, 0x6c, 0x06, 0x8e, 0xab, 0x0a, 0x69,
	0x7b, 0x96, 0x85, 0x83, 0x20, 0x41, 0x7f, 0xf3, 0x84, 0x23, 0xcc, 0x7e, 0xfb, 0x77, 0xbf, 0xc1,
	0xee, 0x46, 0x69, 0x37, 0xfc, 0x24, 0xee, 0x6e, 0x3a, 0x51, 0x4e, 0xc3, 0x17, 0x61, 0x4e, 0x38,
	0xc3, 0x62, 0x12, 0x56, 0x26, 0xe9, 0x3b, 0xf7, 0xa6, 0x4c, 0xa0, 0xa1, 0x32, 0x00, 0x8f, 0xd9,
	0xa2, 0x6e, 0xec, 0x54, 0x41, 0x22, 0xee, 0x26, 0xc5, 0xd0, 0x28, 0x14, 0x6d, 0x41, 0xa6, 0xf3,
	0x58, 0x55, 0xe5, 0x7d, 0xbd, 0xed, 0x88, 0xf8, 0x90, 0xf0, 0xa0, 0xc8, 0xcd, 0x07, 0x95, 0xca,
	0x1d, 0xd6, 0x88, 0x87, 0x69, 0xf8, 0x65, 0x0c, 0x94, 0x02, 0xff, 0x8d, 0x5e, 0x05, 0x11, 0x2f,
	0x2d, 0xdb, 0x6e, 0xf6, 0x43, 0x39, 0xf7, 0xf4, 0x64, 0x39, 0x8d, 0x19, 0xb4, 0xd1, 0x68, 0xe2,
	0x34, 0x6f, 0xd0, 0xb0, 0x1d, 0x74, 0x11, 0x72, 0x66, 0x47, 0x77, 0x64, 0x77, 0x87, 0x17, 0xa6,
	0x4c, 0x96, 0x02, 0x5d, 0x0b, 0x00, 0x35, 0xe1, 0x2a, 0x31, 0xe8, 0x5a, 0x60, 0xe3, 0xe4, 0xc1,
	0xc0, 0xb2, 0xee, 0xf0, 0xf5, 0x24, 0x9b, 0x5d, 0x47, 0xef, 0xe8, 0x4f, 0xd8, 0x85, 0xa2, 0x38,
	0x18, 0xbf, 0xc8, 0x9b, 0xd3, 0xf1, 0xb1, 0xf0, 0xe0, 0xba, 0x68, 0xbb, 0x1d, 0x68, 0x2a, 0xa4,
	0xe6, 0x1b, 0x12, 0xe4, 0xca, 0xbd, 0xf6, 0xa3, 0xed, 0x6e, 0xa3, 0xd7, 0xe9, 0x28, 0xd6, 0x31,
	0x5d, 0x20, 0x5c, 0x3a, 0xf5, 0x27, 0x84, 0x07, 0xcf, 0x09, 0xf1, 0xd3, 0x9f, 0x10, 0x2a, 0x7e,
	0x22, 0x26, 0x93, 0xc2, 0x79, 0xc0, 0xe5, 0x45, 0xc8, 0x31, 0x47, 0x52, 0x26, 0x86, 0x63, 0xe9,
	0x84, 0x9f, 0x53, 0xc4, 0x71, 0x96, 0x01, 0xab, 0x1c, 0x86, 0x2e, 0x43, 0xde, 0x3e, 0xb6, 0x1d,
	0xd2, 0x91, 0x79, 0xb6, 0x1f, 0xf7, 0x7e, 0xe2, 0x38, 0xc7, 0xa1, 0x98, 0x03, 0x4b, 0x7f, 0x16,
	0x87, 0xbc, 0x2b, 0x69, 0x51, 0x9a, 0x68, 0x65, 0x98, 0xdd, 0xd7, 0xdb, 0xc4, 0xbd, 0x97, 0x1d,
	0xbd, 0x4d, 0x7b, 0x51, 0x7b, 0x74, 0xe7, 0x74, 0x4d, 0x73, 0x86, 0x1a, 0x85, 0xb4, 0x2d, 0xfd,
	0x48, 0x82, 0x04, 0xb3, 0x8d, 0x6e, 0x42, 0x82, 0x2d, 0x7f, 0x69, 0x9a, 0xe5, 0xcf, 0x9a, 0x7a,
	0x5b, 0x78, 0x2c, 0xb0, 0x85, 0xd3, 0xfd, 0xf0, 0x40, 0x79, 0xfd, 0xe6, 0x2d, 0x26, 0x69, 0x59,
	0x2c, 0x4a, 0xa8, 0xcc, 0x6e, 0xf3, 0x4d, 0xcb, 0x21, 0x9a, 0xb0, 0x4c, 0xc2, 0x16, 0x57, 0x1f,
	0xe3, 0x5d, 0x55, 0xe3, 0xe2, 0xa1, 0x73, 0x10, 0xa7, 0x22, 0x3c, 0xc7, 0xaf, 0xf7, 0x9e, 0x9e,
	0x2c, 0xc7, 0xa9, 0xf0, 0x52, 0x18, 0x37, 0xac, 0xef, 0x25, 0x52, 0x89, 0xc2, 0x6c, 0xe9, 0xfb,
	0x09, 0xc8, 0xd5, 0x3b, 0x51, 0x2b, 0x87, 0xb5, 0x7e, 0x86, 0x85, 0x19, 0x8e, 0x7d, 0x1f, 0x0d,
	0xe1, 0x57, 0x9f, 0x9a, 0x8d, 0x3f, 0x9b, 0x9a, 0xad, 0x53, 0xa3, 0x40, 0xa4, 0x3a, 0xd2, 0xef,
	0xbf, 0x32, 0xf1, 0xfb, 0x4d, 0xba, 0xe2, 0x30, 0xc5, 0xf1, 0xc3, 0x52, 0xd9, 0xfd, 0xee, 0xdb,
	0xcc, 0xf6, 0xe0, 0x42, 0x93, 0x9c, 0x5e, 0x68, 0xe6, 0x88, 0xa1, 0x31, 0x91, 0x39, 0x12, 0x12,
	0xf3, 0x59, 0x88, 0x6b, 0xfa, 0xb8, 0x29, 0x0d, 0x53, 0x95, 0x14, 0x65, 0x82, 0xe0, 0x24, 0x82,
	0x82, 0x13, 0x74, 0x9c, 0x96, 0xb6, 0x01, 0xfc, 0x51, 0xa1, 0x15, 0x48, 0x9a, 0x6d, 0xcd, 0x8d,
	0xa8, 0xcd, 0x95, 0xd3, 0x4f, 0x4f, 0x96, 0x67, 0xb7, 0xdb, 0x5a, 0x7d, 0x1d, 0xcf, 0x9a, 0x6d,
	0xad, 0xae, 0xb1, 0x0c, 0x51, 0x72, 0x28, 0x7b, 0xc1, 0x19, 0x59, 0x3c, 0x67, 0x90, 0x43, 0x3f,
	0x3c, 0xc4, 0x23, 0x4e, 0xc5, 0xe6, 0x0f, 0x25, 0xc8, 0xbb, 0x33, 0x18, 0xed, 0x4a, 0x4f, 0xe9,
	0x1d, 0x21, 0xf9, 0xf1, 0x67, 0x93, 0x7c, 0x17, 0x4f, 0xe4, 0xb1, 0x7c, 0x5d, 0x82, 0x45, 0x1e,
	0x07, 0xa6, 0x2a, 0x0e, 0x55, 0xf3, 0x11, 0x8a, 0xf7, 0xcb, 0x50, 0xb0, 0x14, 0x43, 0x33, 0x3b,
	0xfa, 0x13, 0xc2, 0xcf, 0x47, 0x6c, 0x71, 0x2d, 0x30, 0xef, 0xc1, 0xd9, 0x01, 0x80, 0x7b, 0xbc,
	0xf3, 0x6f, 0x12, 0x9c, 0xea, 0xef, 0x4c, 0x94, 0x93, 0xb6, 0x01, 0x49, 0x76, 0xb4, 0xe7, 0x2e,
	0xb7, 0xd7, 0x42, 0x88, 0x84, 0x7d, 0x9d, 0x47, 0xda, 0x78, 0x02, 0xcf, 0x48, 0x2c, 0x7d, 0x11,
	0x66, 0x19, 0xf8, 0x39, 0x74, 0x9c, 0x98, 0xf9, 0x0f, 0x60, 0x61, 0x4d, 0xd3, 0x1a, 0x0d, 0x21,
	0x7d, 0xd1, 0x4d, 0xbb, 0x6b, 0x3d, 0xc5, 0xc2, 0xac, 0xa7, 0xe0, 0x27, 0xa3, 0xb4, 0x9e, 0xba,
	0x90, 0x17, 0xe1, 0x99, 0x11, 0x9f, 0xe5, 0x1e, 0x52, 0x73, 0x4f, 0x88, 0x0d, 0x2f, 0xf8, 0xe9,
	0x81, 0xde, 0x17, 0xa3, 0x1c, 0x49, 0x0f, 0x16, 0x5d, 0xba, 0x51, 0x5f, 0x9b, 0x8c, 0x1b, 0x0e,
	0x3b, 0x13, 0x0b, 0x7e, 0x36, 0xca, 0x31, 0x7d, 0x47, 0x82, 0x7c, 0xa3, 0xb7, 0xc7, 0x73, 0xc4,
	0xa3, 0x1b, 0xcf, 0x5d, 0x80, 0x36, 0xd9, 0x17, 0xf9, 0x5b, 0xd3, 0x87, 0xaa, 0xb9, 0x16, 0x03,
	0xc5, 0x65, 0x55, 0x62, 0x0a, 0xbe, 0x1f, 0x83, 0x79, 0xaf, 0x97, 0x51, 0xae, 0xfc, 0x5f, 0x02,
	0x66, 0xbc, 0xca, 0xb6, 0xa3, 0x38, 0xb6, 0x50, 0x98, 0xaf, 0x3e, 0x4b, 0xe8, 0x7b, 0x79, 0x41,
	0x84, 0x0f, 0xa5, 0x3d, 0x10, 0x4e, 0x53, 0x92, 0xec, 0x27, 0x5a, 0x85, 0x45, 0xa6, 0xde, 0x64,
	0xa5, 0xdb, 0x6d, 0xeb, 0x44, 0x93, 0xf9, 0x05, 0x44, 0x82, 0x5d, 0x40, 0x2c, 0xb0, 0xaa, 0x35,
	0x5e, 0x53, 0x67, 0x97, 0x11, 0x77, 0x20, 0xbb, 0x6f, 0x11, 0xf2, 0x84, 0xc8, 0xcc, 0x68, 0x7a,
	0x96, 0x6b, 0xa9, 0x0c, 0x47, 0x6c, 0x50, 0x3c, 0xa1, 0x48, 0xde, 0x87, 0x05, 0x36, 0x8b, 0x51,
	0x67, 0x2c, 0x08, 0xae, 0xfc, 0x54, 0x02, 0x14, 0xa4, 0xff, 0xf1, 0x31, 0x26, 0x16, 0x39, 0x63,
	0x5e, 0x05, 0xc4, 0x63, 0x13, 0x6c, 0xb9, 0x4b, 0x2c, 0xd9, 0x26, 0xaa, 0x29, 0xf2, 0x92, 0x25,
	0x5c, 0x10, 0x35, 0x3b, 0xc4, 0x6a, 0x30, 0x78, 0xe9, 0x37, 0x8b, 0x90, 0x15, 0x73, 0xb2, 0x6b,
	0x50, 0x5f, 0xfd, 0x26, 0xc4, 0x5b, 0xe2, 0x30, 0x24, 0x13, 0xea, 0x2e, 0xf9, 0x6f, 0x23, 0xd4,
	0x66, 0x30, 0x6d, 0x4b, 0x51, 0xba, 0x3d, 0x27, 0x24, 0x1a, 0xcc, 0x0f, 0xfa, 0x09, 0xa2, 0x74,
	0x7b, 0x0e, 0x6a, 0xc0, 0xbc, 0xea, 0xe7, 0x86, 0xcb, 0x14, 0x3d, 0x3e, 0x32, 0x80, 0x3f, 0x34,
	0xc3, 0xbe, 0x36, 0x83, 0xf3, 0x6a, 0x5f, 0x05, 0xaa, 0x04, 0x93, 0x91, 0x13, 0x23, 0x8f, 0xfe,
	0x06, 0x13, 0xa1, 0x6b, 0x33, 0x81, 0x9c, 0x65, 0xf4, 0x26, 0x24, 0x35, 0x96, 0xe4, 0x2a, 0x24,
	0x34, 0x4c, 0x88, 0xfa, 0xf2, 0x8a, 0x6b, 0x33, 0x58, 0x60, 0xa0, 0x7b, 0x90, 0xe5, 0xbf, 0x84,
	0x76, 0x48, 0x8e, 0x3c, 0x1b, 0x1d, 0x4e, 0xf3, 0xad, 0xcd, 0xe0, 0x8c, 0xe6, 0x43, 0xd1, 0xa7,
	0x21, 0x61, 0xab, 0x8a, 0x21, 0x4e, 0x0c, 0xcf, 0x8f, 0x48, 0xe6, 0xf3, 0x91, 0x59, 0x6b, 0xf4,
	0x10, 0x16, 0xd8, 0xf9, 0x88, 0xec, 0xf8, 0x17, 0xc7, 0x2c, 0x99, 0xa0, 0xff, 0xae, 0xda, 0xb3,
	0x96, 0xc2, 0x73, 0x58, 0x6a, 0x33, 0xb8, 0xb0, 0x37, 0x50, 0x45, 0x59, 0xc6, 0xcc, 0xdd, 0x00,
	0xe1, 0xf4, 0x48, 0x96, 0x85, 0x66, 0x95, 0x50, 0x96, 0x91, 0xbe, 0x0a, 0x74, 0x17, 0x32, 0x0a,
	0x35, 0x3f, 0x64, 0x16, 0xa9, 0x5f, 0x84, 0x91, 0x47, 0xbf, 0x43, 0xc9, 0x03, 0x35, 0x96, 0x90,
	0xe3, 0x02, 0x7d, 0x42, 0x1d, 0x62, 0xb5, 0x48, 0x31, 0x33, 0x9e, 0x50, 0xf0, 0xb6, 0xd9, 0x23,
	0xc4, 0x80, 0x68, 0x13, 0x72, 0x07, 0x6e, 0x88, 0x2a, 0xbb, 0xe9, 0xcf, 0x8e, 0x3c, 0xff, 0x0d,
	0x09, 0xb1, 0xad, 0xcd, 0xe0, 0xec, 0x41, 0x00, 0x8c, 0x56, 0x21, 0xd6, 0x52, 0x8b, 0x39, 0x46,
	0xe3, 0xc5, 0x71, 0x01, 0xa4, 0xb5, 0x19, 0x1c, 0x6b, 0xa9, 0xd4, 0xa9, 0xe0, 0x91, 0x6e, 0x47,
	0x46, 0x31, 0x3f, 0x52, 0xc9, 0xf4, 0xc7, 0x37, 0xd6, 0x66, 0x30, 0x8b, 0x02, 0xa4, 0xdf, 0xdb,
	0x81, 0xbc, 0xc5, 0xaf, 0xeb, 0xdd, 0xa0, 0x94, 0x02, 0xa3, 0x72, 0x35, 0x5c, 0x55, 0x0d, 0xc5,
	0xa5, 0xd4, 0x66, 0x70, 0xce, 0x0a, 0xc2, 0xd1, 0x57, 0xe0, 0x54, 0x3f, 0x45, 0x21, 0xdc, 0x0b,
	0x43, 0x9a, 0x2b, 0x9c, 0x6e, 0xbf, 0x8c, 0x23, 0x6b, 0xa8, 0x12, 0xbd, 0x01, 0xb3, 0x9c, 0x6b,
	0x88, 0x91, 0x0c, 0xbb, 0x29, 0x1a, 0x60, 0x18, 0x6f, 0x4f, 0xd7, 0x9b, 0x23, 0xee, 0xa9, 0xe5,
	0xb6, 0xd9, 0x2a, 0x2e, 0x8e, 0x5c, 0x6f, 0xc3, 0xf7, 0xee, 0x74, 0xbd, 0x39, 0x3e, 0x94, 0xf2,
	0xdd, 0xe2, 0x35, 0xe2, 0x5a, 0xf3, 0xd4, 0x48, 0xbe, 0x87, 0x5c, 0x5f, 0x53, 0xbe, 0x5b, 0x01,
	0x30, 0xed, 0x9a, 0xc5, 0xf3, 0x67, 0x65, 0xb6, 0x8c, 0x4f, 0x8f, 0xec, 0xda, 0x70, 0x4e, 0x30,
	0xed, 0x9a, 0xe5, 0x43, 0xd1, 0x03, 0x28, 0x88, 0x1c, 0x39, 0xff, 0x38, 0xe9, 0xcc, 0xc8, 0x8b,
	0x84, 0xf0, 0x7b, 0xc0, 0xda, 0x0c, 0x9e, 0x57, 0xfb, 0x6b, 0xa8, 0xb2, 0x60, 0xf4, 0x64, 0xd5,
	0x4f, 0x6e, 0x2c, 0x16, 0x47, 0x2a, 0x8b, 0x11, 0xe9, 0xb0, 0x54, 0x59, 0xa8, 0x03, 0x55, 0x54,
	0x8c, 0x75, 0x43, 0x77, 0x98, 0x62, 0x5f, 0x1a, 0x29, 0xc6, 0xfd, 0xcf, 0x77, 0x50, 0x31, 0xd6,
	0x39, 0x84, 0x8a, 0xb1, 0x23, 0xee, 0xbc, 0x05, 0x3b, 0x5e, 0x1c, 0x29, 0xc6, 0x61, 0x97, 0xe3,
	0x54, 0x8c, 0x9d, 0x20, 0x9c, 0x8a, 0x31, 0x57, 0x10, 0x03, 0x74, 0x5f, 0x1a, 0x29, 0xc6, 0x23,
	0x93, 0x62, 0xa8, 0x18, 0x2b, 0x43, 0x95, 0x68, 0x9d, 0x5a, 0x86, 0xd4, 0x22, 0xd2, 0x8d, 0x7d,
	0xb3, 0x78, 0x7e, 0xe4, 0xfe, 0x33, 0x78, 0xeb, 0x5d, 0x63, 0x66, 0xa1, 0x80, 0x51, 0x45, 0xc6,
	0x4c, 0x64, 0x99, 0x9d, 0x5d, 0x17, 0x97, 0x47, 0x2a, 0xb2, 0xa1, 0x23, 0x6c, 0xaa, 0xc8, 0x0e,
	0x3d, 0x20, 0xdd, 0xc8, 0xf8, 0x89, 0x4f, 0x71, 0x65, 0xc2, 0xc9, 0x42, 0x60, 0x23, 0xe3, 0x18,
	0x68, 0x0d, 0xd2, 0xd4, 0x52, 0x38, 0x66, 0x6a, 0xe8, 0xc2, 0x48, 0x1b, 0x77, 0x20, 0x8c, 0xb5,
	0x36, 0x83, 0x53, 0x1f, 0x08, 0x10, 0xfd, 0x3c, 0x77, 0xbb, 0x8b, 0xa5, 0x91, 0x9f, 0xef, 0x3b,
	0x68, 0xa1, 0x9f, 0xe7, 0x18, 0x48, 0x85, 0xd3, 0x9c, 0x57, 0x22, 0x8b, 0xc6, 0x12, 0xe9, 0x26,
	0xc5, 0x8b, 0x8c, 0xd4, 0x48, 0x27, 0x36, 0x34, 0xa3, 0xa7, 0x36, 0x83, 0x17, 0x95, 0xe1, 0x5a,
	0xba, 0xe0, 0xc5, 0xd6, 0xc3, 0x5d, 0xdf, 0xe2, 0xa5, 0x91, 0x0b, 0x3e, 0xe4, 0xb0, 0x80, 0x2e,
	0x78, 0x25, 0x00, 0xe6, 0x1b, 0x90, 0x26, 0xdb, 0x36, 0xbf, 0xe9, 0xb8, 0x3c, 0x66, 0x03, 0x1a,
	0x70, 0x80, 0xf9, 0x06, 0xa4, 0x35, 0x38, 0x26, 0x25, 0xa4, 0xb6, 0x89, 0x62, 0x09, 0x35, 0x7b,
	0x65, 0x24, 0xa1, 0xa1, 0x27, 0x31, 0x28, 0x21, 0xd5, 0x03, 0xd2, 0x0d, 0xdb, 0x72, 0x93, 0x6b,
	0x85, 0xb5, 0x79, 0x75, 0xe4, 0x86, 0x1d, 0x9a, 0x03, 0x4c, 0x37, 0x6c, 0xab, 0xaf, 0x02, 0x7d,
	0x1e, 0xe6, 0x44, 0xa6, 0x62, 0xf1, 0xda, 0x18, 0x1b, 0x38, 0xe8, 0x15, 0xd3, 0x75, 0x2d, 0x70,
	0xb8, 0x96, 0xe5, 0x89, 0x8e, 0x7c, 0x78, 0x2f, 0x8f, 0xd1, 0xb2, 0x43, 0x0e, 0x29, 0xd7, 0xb2,
	0x3e, 0x98, 0x6a, 0x59, 0x2e, 0xa7, 0x62, 0xaf, 0xbb, 0x3e, 0x52, 0xcb, 0x0e, 0x07, 0xa0, 0x52,
	0x2d, 0xfb, 0x81, 0x0f, 0xa5, 0x23, 0xb3, 0xb9, 0x23, 0x56, 0x7c, 0x65, 0xe4, 0xc8, 0xfa, 0x1d,
	0x4a, 0x3a, 0x32, 0x81, 0x43, 0xd9, 0xc6, 0x83, 0xad, 0xf8, 0x4c, 0xbf, 0x3a, 0x92, 0x6d, 0x43,
	0x7e, 0x4b, 0xcd, 0x7d, 0x2e, 0x8d, 0xcf, 0xb0, 0xa7, 0xa8, 0x2c, 0x91, 0x20, 0x24, 0x66, 0xea,
	0xb5, 0xf1, 0x8a, 0x2a, 0x2c, 0xf7, 0xc9, 0x53, 0x54, 0x7d, 0x95, 0xe5, 0x39, 0x11, 0x1a, 0x77,
	0x2f, 0x91, 0x9a, 0x2f, 0x14, 0xee, 0x25, 0x52, 0x67, 0x0b, 0xc5, 0x7b, 0x89, 0xd4, 0xb9, 0xc2,
	0xd2, 0xbd, 0x44, 0xea, 0x85, 0xc2, 0x8b, 0xa5, 0x7f, 0x3f, 0x0b, 0x39, 0xd7, 0x8f, 0xe1, 0x5e,
	0xc1, 0xad, 0xa0, 0x57, 0x70, 0x7e, 0x94, 0x57, 0x20, 0x3c, 0x1f, 0xe1, 0x16, 0xdc, 0x0a, 0xba,
	0x05, 0xe7, 0x47, 0xb9, 0x05, 0x3e, 0x0e, 0xf5, 0x0b, 0x9a, 0xa3, 0xfc, 0x82, 0x97, 0xa7, 0xf0,
	0x0b, 0x3c, 0x52, 0x83, 0x8e, 0xc1, 0xfa, 0xb0, 0x63, 0x70, 0x69, 0xbc, 0x63, 0xe0, 0x91, 0x0a,
	0x78, 0x06, 0x6f, 0x0d, 0x78, 0x06, 0x17, 0xc6, 0x78, 0x06, 0x1e, 0xbe, 0xeb, 0x1a, 0x6c, 0x84,
	0xba, 0x06, 0x57, 0x26, 0xb9, 0x06, 0x1e, 0x9d, 0x3e, 0xdf, 0xe0, 0xf5, 0x3e, 0xdf, 0x60, 0x79,
	0xa4, 0x6f, 0xe0, 0x61, 0x73, 0xe7, 0xe0, 0xbd, 0xd1, 0xce, 0xc1, 0x2b, 0x53, 0x39, 0x07, 0x1e,
	0xbd, 0x61, 0xef, 0xa0, 0x39, 0xca, 0x3b, 0x78, 0x79, 0x0a, 0xef, 0xc0, 0x67, 0xdc, 0x80, 0x7b,
	0x50, 0x0b, 0x73, 0x0f, 0x2e, 0x4f, 0x70, 0x0f, 0x3c, 0x6a, 0x41, 0xff, 0xa0, 0x16, 0xe6, 0x1f,
	0x5c, 0x9e, 0xe0, 0x1f, 0x0c, 0x50, 0xe2, 0x0e, 0xc2, 0x56, 0xb8, 0x83, 0x70, 0x75, 0xa2, 0x83,
	0xe0, 0x51, 0xeb, 0xf7, 0x10, 0x6e, 0x04, 0x3c, 0x84, 0x97, 0x46, 0x78, 0x08, 0x1e, 0x2a, 0x75,
	0x11, 0xbe, 0x30, 0xe4, 0x22, 0x94, 0xc6, 0xb9, 0x08, 0x1e, 0xae, 0xe7, 0x23, 0xbc, 0x33, 0xc2,
	0x47, 0xb8, 0x36, 0xd9, 0x47, 0xf0, 0x88, 0x0d, 0x38, 0x09, 0xca, 0x58, 0x27, 0xe1, 0xb5, 0x29,
	0x9d, 0x04, 0x8f, 0x7a, 0x98, 0x97, 0xf0, 0xd9, 0x7e, 0x2f, 0x61, 0x65, 0xb4, 0x97, 0xe0, 0x91,
	0x11, 0x6e, 0xc2, 0x46, 0xa8, 0x9b, 0x70, 0x65, 0x92, 0x9b, 0xe0, 0xaf, 0xbd, 0xa0, 0x9f, 0xb0,
	0x15, 0xee, 0x27, 0x5c, 0x9d, 0xe8, 0x27, 0xf8, 0xec, 0xef, 0x73, 0x14, 0x36, 0x42, 0x1d, 0x85,
	0x2b, 0x93, 0x1c, 0x05, 0xbf, 0x73, 0x41, 0x4f, 0xe1, 0xdd, 0x91, 0x9e, 0xc2, 0xf5, 0x69, 0x3c,
	0x05, 0x8f, 0xe8, 0x90, 0xab, 0xf0, 0xde, 0x68, 0x57, 0xe1, 0x95, 0x67, 0x78, 0x32, 0x25, 0xd4,
	0x57, 0xf8, 0xc2, 0x90, 0xaf, 0x50, 0x1a, 0xe7, 0x2b, 0xf8, 0xf2, 0xec, 0x3a, 0x0b, 0xca, 0x58,
	0xd3, 0xfe, 0xb5, 0x29, 0x4d, 0x7b, 0x5f, 0xf8, 0x42, 0x6c, 0xfb, 0x6a, 0x88, 0x6d, 0x7f, 0x69,
	0xbc, 0x6d, 0xef, 0x6f, 0x21, 0xbe, 0x71, 0x5f, 0x0b, 0x33, 0xee, 0x2f, 0x4f, 0x30, 0xee, 0x7d,
	0x2d, 0x14, 0xb0, 0xee, 0xdf, 0x1a, 0xb0, 0xee, 0x2f, 0x4c, 0xbc, 0xf8, 0x0e, 0x98, 0xf7, 0xe5,
	0x61, 0xf3, 0xfe, 0xe2, 0x58, 0xf3, 0xde, 0xa3, 0xe0, 0xdb, 0xf7, 0x6f, 0x0d, 0xd8, 0xf7, 0x17,
	0xc6, 0xd8, 0xf7, 0x7e, 0x07, 0x84, 0x81, 0xaf, 0x8d, 0x37, 0xf0, 0x57, 0xa7, 0x35, 0xf0, 0x3d,
	0xc2, 0xa1, 0x16, 0xfe, 0x56, 0xb8, 0x85, 0x7f, 0x75, 0xca, 0x3b, 0xb0, 0x21, 0x13, 0xbf, 0x16,
	0x66, 0xe2, 0x5f, 0x9e, 0x60, 0xe2, 0x07, 0xf7, 0x10, 0xcf, 0xc6, 0xaf, 0x85, 0xd9, 0xf8, 0x97,
	0x27, 0xd8, 0xf8, 0x3e, 0xa5, 0x80, 0x91, 0xdf, 0x1c, 0x65, 0xe4, 0xbf, 0x3c, 0x85, 0x91, 0xef,
	0xef, 0xbb, 0x03, 0x56, 0xfe, 0xdb, 0x83, 0x56, 0x7e, 0x69, 0x9c, 0x95, 0xef, 0xaf, 0x48, 0xd7,
	0xcc, 0xdf, 0x0a, 0x37, 0xf3, 0xaf, 0x4e, 0x34, 0xf3, 0x83, 0x4a, 0x32, 0x60, 0xe7, 0x6f, 0x84,
	0xda, 0xf9, 0x57, 0x26, 0xd9, 0xf9, 0xbe, 0x92, 0x0c, 0x1a, 0xfa, 0x6f, 0x0f, 0x1a, 0xfa, 0xa5,
	0x71, 0x86, 0xbe, 0x3f, 0x38, 0xd7, 0xd2, 0xaf, 0x85, 0x59, 0xfa, 0x97, 0x27, 0x58, 0xfa, 0x3e,
	0xf3, 0x02, 0xa6, 0xbe, 0x32, 0xd6, 0xd4, 0x7f, 0x6d, 0x4a, 0x53, 0x7f, 0x40, 0x71, 0x3d, 0x9b,
	0xad, 0x7f, 0x2f, 0x91, 0x7a, 0xb1, 0xf0, 0x52, 0xe9, 0xaf, 0x67, 0x21, 0x59, 0x73, 0x03, 0x34,
	0x02, 0x19, 0xde, 0xd2, 0xf3, 0x64, 0x78, 0xa3, 0x75, 0x2a, 0x3e, 0x6c, 0x11, 0x0a, 0xeb, 0x7f,
	0xcc, 0x73, 0x09, 0x43, 0x57, 0x64, 0x2e, 0xea, 0x73, 0xa4, 0xaf, 0xa0, 0xd7, 0x21, 0xd7, 0xb3,
	0x89, 0x25, 0x77, 0x2d, 0xdd, 0xb4, 0x74, 0x87, 0x87, 0x35, 0x4a, 0xe5, 0xc2, 0x47, 0x27, 0xcb,
	0xd9, 0x5d, 0x9b, 0x58, 0x3b, 0x02, 0x8e, 0xb3, 0xbd, 0x40, 0xc9, 0x7d, 0x6d, 0x7b, 0x76, 0xfa,
	0xd7, 0xb6, 0xdf, 0x81, 0x82, 0x45, 0x14, 0xad, 0x6f, 0x3b, 0xe4, 0x49, 0xcf, 0xe1, 0x3b, 0x37,
	0x8b, 0xdf, 0x75, 0x5b, 0xb2, 0xe4, 0xe7, 0x79, 0xab, 0x1f, 0x88, 0x6e, 0xc2, 0xe9, 0x8e, 0x72,
	0xc4, 0x73, 0xfd, 0x5d, 0x0b, 0x83, 0x05, 0xaa, 0xa4, 0x58, 0x3c, 0x15, 0xea, 0x28, 0x47, 0xec,
	0xe9, 0x6e, 0x5e, 0xc5, 0x1e, 0xed, 0xbc, 0x0c, 0x79, 0x4d, 0xb7, 0x1d, 0xdd, 0x50, 0xdd, 0xe7,
	0x8a, 0x78, 0x76, 0x74, 0xce, 0x85, 0xf2, 0x67, 0x83, 0xae, 0xc3, 0x82, 0x88, 0x5c, 0xf3, 0x1f,
	0xf3, 0x66, 0xb6, 0x74, 0x8a, 0xf6, 0x82, 0x56, 0xf8, 0x6f, 0xaf, 0x57, 0x60, 0xbe, 0xa5, 0x38,
	0xe4, 0x50, 0x39, 0x96, 0xdd, 0x10, 0xe2, 0x0c, 0x7b, 0xb4, 0xe5, 0x85, 0xa7, 0x27, 0xcb, 0xb9,
	0xbb, 0xbc, 0x6a, 0x28, 0x92, 0x38, 0xd7, 0x0a, 0x54, 0x68, 0x68, 0x0d, 0xb2, 0xec, 0x3d, 0x42,
	0x93, 0x3f, 0x7b, 0x29, 0x2c, 0xe4, 0x51, 0x77, 0x18, 0xe2, 0x71, 0x4c, 0xcc, 0xde, 0x30, 0x74,
	0x5f, 0xca, 0xbc, 0x0a, 0xf3, 0x8a, 0x7d, 0x6c, 0xa8, 0x6c, 0x86, 0x89, 0x61, 0xf7, 0x6c, 0x66,
	0x22, 0xa7, 0x70, 0x9e, 0x81, 0x2b, 0x2e, 0x54, 0xbc, 0x7a, 0xf4, 0xdb, 0x12, 0x64, 0xfb, 0xc2,
	0x39, 0xdf, 0x1a, 0xb8, 0xaa, 0x3b, 0x17, 0x6e, 0x9e, 0x8f, 0x8a, 0x51, 0x4a, 0x09, 0x0e, 0xb8,
	0x71, 0x13, 0xcb, 0xa3, 0xcd, 0x3b, 0xe6, 0x20, 0xbb, 0x91, 0x26, 0x2e, 0xda, 0x9b, 0x89, 0xdf,
	0xfd, 0xf6, 0xf2, 0x4c, 0xe9, 0x67, 0x71, 0xc8, 0xf5, 0x87, 0x6d, 0xd6, 0x07, 0xfa, 0x15, 0xa6,
	0x12, 0xfb, 0x30, 0x56, 0xc7, 0x3c, 0x4a, 0x92, 0xf6, 0x5f, 0x31, 0xe4, 0xdd, 0x5c, 0x19, 0x73,
	0x21, 0x19, 0xec, 0xa7, 0x8f, 0xb8, 0xf4, 0x83, 0x98, 0xb7, 0xf2, 0x57, 0x61, 0x96, 0xfd, 0x1f,
	0x01, 0xd1, 0xb5, 0xb0, 0xc4, 0x96, 0x2a, 0xad, 0xc7, 0xbc, 0x19, 0xd5, 0x14, 0xcd, 0xe7, 0x7a,
	0x0b, 0xc2, 0x03, 0x3c, 0xc7, 0x3b, 0xf7, 0xe2, 0xfd, 0x91, 0xd9, 0x67, 0x7b, 0x7f, 0x84, 0x5f,
	0x38, 0xb6, 0xdb, 0x44, 0x75, 0xc4, 0xbf, 0x23, 0x70, 0x5f, 0xb3, 0xbf, 0x34, 0x48, 0x42, 0xfc,
	0xf3, 0x82, 0x55, 0x2c, 0xfe, 0x79, 0x41, 0x20, 0x94, 0x25, 0xef, 0x91, 0x60, 0x0b, 0x8b, 0x07,
	0x3c, 0x09, 0x56, 0xff, 0xaa, 0x04, 0x05, 0xb6, 0x8c, 0xee, 0x10, 0xa2, 0x45, 0x22, 0x85, 0x6e,
	0x94, 0x4d, 0x6c, 0xea, 0x28, 0x9b, 0x92, 0x02, 0x79, 0xaf, 0x0f, 0xfc, 0x59, 0xef, 0x31, 0x4f,
	0x79, 0x3c, 0x57, 0x86, 0x64, 0xe9, 0xf7, 0x25, 0x58, 0xf4, 0xbe, 0x51, 0xf1, 0x12, 0x73, 0x9e,
	0x27, 0xee, 0x11, 0xb3, 0x7f, 0x59, 0x40, 0xfd, 0x3c, 0x96, 0x35, 0x37, 0x95, 0x04, 0x21, 0x71,
	0xf7, 0x0d, 0xc2, 0x7f, 0xd4, 0x9a, 0x0d, 0xf6, 0xcf, 0x0c, 0xf8, 0x6f, 0xbb, 0x74, 0x27, 0x30,
	0x03, 0x4c, 0x58, 0xe9, 0x30, 0xa7, 0x92, 0x6a, 0x77, 0x98, 0xac, 0x71, 0xe9, 0xef, 0xa4, 0x20,
	0xa1, 0xc7, 0xd4, 0x6e, 0xb8, 0x0d, 0xf1, 0xc7, 0x4a, 0x7b, 0xdc, 0xd5, 0x7f, 0xdf, 0xd4, 0x63,
	0xda, 0x1a, 0xdd, 0xe9, 0xcb, 0x67, 0x8a, 0x8d, 0x76, 0xee, 0x86, 0xa7, 0x34, 0x98, 0xf7, 0x84,
	0xde, 0x70, 0x47, 0x11, 0x9f, 0xfc, 0xf9, 0xe0, 0x22, 0x7d, 0x33, 0xf1, 0xe1, 0xb7, 0x97, 0xa5,
	0xeb, 0x0d, 0x58, 0x0c, 0xd9, 0x84, 0x50, 0x1e, 0x20, 0xf0, 0xb0, 0xa4, 0xf8, 0x8f, 0x09, 0x6b,
	0xeb, 0xf2, 0xee, 0x56, 0x65, 0x7b, 0x73, 0xb3, 0xde, 0x6c, 0x56, 0xd7, 0x0b, 0x12, 0x2a, 0x40,
	0xb6, 0xef, 0x59, 0x4a, 0xf1, 0x8f, 0x12, 0xae, 0x7f, 0x06, 0xc0, 0x7f, 0x50, 0x96, 0xd2, 0xda,
	0xa8, 0x3e, 0x94, 0x1f, 0xac, 0xdd, 0xdf, 0xad, 0x36, 0x0a, 0x33, 0x08, 0x41, 0xbe, 0xbc, 0xd6,
	0xac, 0xd4, 0x64, 0x5c, 0x6d, 0xec, 0x6c, 0x6f, 0x35, 0xaa, 0x05, 0x49, 0xe0, 0xad, 0x43, 0x36,
	0x98, 0xf9, 0x85, 0x16, 0x61, 0xbe, 0x52, 0xab, 0x56, 0x36, 0xe4, 0x07, 0xf5, 0x35, 0xf9, 0x9d,
	0xdd, 0xea, 0x6e, 0xb5, 0x30, 0xc3, 0xba, 0xc6, 0x80, 0x77, 0x76, 0xef, 0xdf, 0x2f, 0x48, 0x68,
	0x1e, 0x32, 0xbc, 0xcc, 0x9e, 0xb0, 0x2c, 0xc4, 0xae, 0x6f, 0x42, 0x26, 0xf0, 0x98, 0x08, 0xfd,
	0xdc, 0xce, 0x6e, 0xa3, 0x26, 0x37, 0xeb, 0x9b, 0xd5, 0x46, 0x73, 0x6d, 0x73, 0x87, 0xd3, 0x60,
	0xb0, 0xb5, 0xf2, 0x36, 0x6e, 0x16, 0x24, 0xaf, 0xdc, 0xdc, 0xde, 0xad, 0xd4, 0xbc, 0xff, 0xf7,
	0x90, 0x48, 0xc5, 0x0b, 0xf1, 0xeb, 0x26, 0x9c, 0x0e, 0x4d, 0xa5, 0x42, 0x19, 0x98, 0xdb, 0x35,
	0xd8, 0xd3, 0x14, 0x85, 0x19, 0x94, 0x0b, 0x64, 0x53, 0x15, 0x24, 0x94, 0xe2, 0x39, 0x33, 0x85,
	0x18, 0x4a, 0x42, 0xac, 0x71, 0xbb, 0x10, 0xa7, 0xdd, 0x0c, 0xa4, 0x24, 0x15, 0x12, 0x28, 0x2d,
	0x32, 0x39, 0x0a, 0xb3, 0x28, 0xeb, 0xa7, 0x52, 0x14, 0x92, 0xd7, 0x2f, 0x40, 0x20, 0xd2, 0x1c,
	0x01, 0x24, 0xef, 0x2b, 0x0e, 0xb1, 0x9d, 0xc2, 0x0c, 0x9a, 0x83, 0xf8, 0x5a, 0xbb, 0x5d, 0x90,
	0x6e, 0x7d, 0x4f, 0x82, 0x94, 0xfb, 0x7a, 0x21, 0xba, 0x0f, 0xb3, 0xdc, 0xf5, 0x5b, 0x1e, 0xbd,
	0x65, 0x30, 0xad, 0xb3, 0xb4, 0x32, 0x69, 0x4f, 0x29, 0xcd, 0xa0, 0x77, 0xc5, 0x3f, 0x5c, 0xa1,
	0xf2, 0x82, 0x2e, 0x8e, 0x93, 0x26, 0x97, 0xea, 0x78, 0x91, 0xa3, 0x2b, 0xa4, 0x34, 0xf3, 0x29,
	0xa9, 0x7c, 0xe1, 0xc3, 0x7f, 0x39, 0x3f, 0xf3, 0xe1, 0xd3, 0xf3, 0xd2, 0x8f, 0x9e, 0x9e, 0x97,
	0x7e, 0xf2, 0xf4, 0xbc, 0xf4, 0xcf, 0x4f, 0xcf, 0x4b, 0xbf, 0xf1, 0xaf, 0xe7, 0x67, 0xde, 0x9b,
	0x13, 0x58, 0x7b, 0x49, 0xf6, 0x3f, 0x5f, 0x6e, 0xff, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x35,
	0xa4, 0x19, 0x69, 0xf8, 0x66, 0x00, 0x00,
}
