// Code generated by execgen; DO NOT EDIT.
// Copyright 2018 The Cockroach Authors.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//     http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
// implied. See the License for the specific language governing
// permissions and limitations under the License.

package exec

import (
	"bytes"
	"fmt"
	"reflect"
	"unsafe"

	"github.com/cockroachdb/cockroach/pkg/sql/exec/coldata"
	"github.com/cockroachdb/cockroach/pkg/sql/exec/types"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
)

// rehash takes a element of a key (tuple representing a row of equality
// column values) at a given column and computes a new hash by applying a
// transformation to the existing hash.
func (ht *hashTable) rehash(
	buckets []uint64, keyIdx int, t types.T, col coldata.Vec, nKeys uint64, sel []uint16,
) {
	switch t {
	case types.Bool:
		keys := col.Bool()
		if sel != nil {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[sel[i]]
				p := uintptr(buckets[i])

				x := 0
				if v {
					x = 1
				}
				p = p*31 + uintptr(x)

				buckets[i] = uint64(p)
			}
		} else {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[i]
				p := uintptr(buckets[i])

				x := 0
				if v {
					x = 1
				}
				p = p*31 + uintptr(x)

				buckets[i] = uint64(p)
			}
		}

	case types.Bytes:
		keys := col.Bytes()
		if sel != nil {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[sel[i]]
				p := uintptr(buckets[i])

				sh := (*reflect.SliceHeader)(unsafe.Pointer(&v))
				p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(v)))

				buckets[i] = uint64(p)
			}
		} else {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[i]
				p := uintptr(buckets[i])

				sh := (*reflect.SliceHeader)(unsafe.Pointer(&v))
				p = memhash(unsafe.Pointer(sh.Data), p, uintptr(len(v)))

				buckets[i] = uint64(p)
			}
		}

	case types.Decimal:
		keys := col.Decimal()
		if sel != nil {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[sel[i]]
				p := uintptr(buckets[i])

				d, err := v.Float64()
				if err != nil {
					panic(fmt.Sprintf("%v", err))
				}

				p = f64hash(noescape(unsafe.Pointer(&d)), p)

				buckets[i] = uint64(p)
			}
		} else {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[i]
				p := uintptr(buckets[i])

				d, err := v.Float64()
				if err != nil {
					panic(fmt.Sprintf("%v", err))
				}

				p = f64hash(noescape(unsafe.Pointer(&d)), p)

				buckets[i] = uint64(p)
			}
		}

	case types.Int8:
		keys := col.Int8()
		if sel != nil {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[sel[i]]
				p := uintptr(buckets[i])
				p = memhash8(noescape(unsafe.Pointer(&v)), p)
				buckets[i] = uint64(p)
			}
		} else {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[i]
				p := uintptr(buckets[i])
				p = memhash8(noescape(unsafe.Pointer(&v)), p)
				buckets[i] = uint64(p)
			}
		}

	case types.Int16:
		keys := col.Int16()
		if sel != nil {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[sel[i]]
				p := uintptr(buckets[i])
				p = memhash16(noescape(unsafe.Pointer(&v)), p)
				buckets[i] = uint64(p)
			}
		} else {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[i]
				p := uintptr(buckets[i])
				p = memhash16(noescape(unsafe.Pointer(&v)), p)
				buckets[i] = uint64(p)
			}
		}

	case types.Int32:
		keys := col.Int32()
		if sel != nil {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[sel[i]]
				p := uintptr(buckets[i])
				p = memhash32(noescape(unsafe.Pointer(&v)), p)
				buckets[i] = uint64(p)
			}
		} else {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[i]
				p := uintptr(buckets[i])
				p = memhash32(noescape(unsafe.Pointer(&v)), p)
				buckets[i] = uint64(p)
			}
		}

	case types.Int64:
		keys := col.Int64()
		if sel != nil {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[sel[i]]
				p := uintptr(buckets[i])
				p = memhash64(noescape(unsafe.Pointer(&v)), p)
				buckets[i] = uint64(p)
			}
		} else {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[i]
				p := uintptr(buckets[i])
				p = memhash64(noescape(unsafe.Pointer(&v)), p)
				buckets[i] = uint64(p)
			}
		}

	case types.Float32:
		keys := col.Float32()
		if sel != nil {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[sel[i]]
				p := uintptr(buckets[i])
				p = f32hash(noescape(unsafe.Pointer(&v)), p)
				buckets[i] = uint64(p)
			}
		} else {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[i]
				p := uintptr(buckets[i])
				p = f32hash(noescape(unsafe.Pointer(&v)), p)
				buckets[i] = uint64(p)
			}
		}

	case types.Float64:
		keys := col.Float64()
		if sel != nil {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[sel[i]]
				p := uintptr(buckets[i])
				p = f64hash(noescape(unsafe.Pointer(&v)), p)
				buckets[i] = uint64(p)
			}
		} else {

			for i := uint64(0); i < nKeys; i++ {
				v := keys[i]
				p := uintptr(buckets[i])
				p = f64hash(noescape(unsafe.Pointer(&v)), p)
				buckets[i] = uint64(p)
			}
		}

	default:
		panic(fmt.Sprintf("unhandled type %d", t))
	}
}

// checkCol determines if the current key column in the groupID buckets matches
// the specified equality column key. If there is a match, then the key is added
// to differs. If the bucket has reached the end, the key is rejected. If any
// element in the key is null, then there is no match.
func (prober *hashJoinProber) checkCol(t types.T, keyColIdx int, nToCheck uint16, sel []uint16) {
	switch t {
	case types.Bool:
		buildVec := prober.ht.vals[prober.ht.keyCols[keyColIdx]]
		probeVec := prober.keys[keyColIdx]

		buildKeys := buildVec.Bool()
		probeKeys := probeVec.Bool()

		if sel != nil {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		} else {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		}
	case types.Bytes:
		buildVec := prober.ht.vals[prober.ht.keyCols[keyColIdx]]
		probeVec := prober.keys[keyColIdx]

		buildKeys := buildVec.Bytes()
		probeKeys := probeVec.Bytes()

		if sel != nil {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = !bytes.Equal(buildVal, probeVal)

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = !bytes.Equal(buildVal, probeVal)

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = !bytes.Equal(buildVal, probeVal)

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = !bytes.Equal(buildVal, probeVal)

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		} else {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = !bytes.Equal(buildVal, probeVal)

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = !bytes.Equal(buildVal, probeVal)

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = !bytes.Equal(buildVal, probeVal)

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = !bytes.Equal(buildVal, probeVal)

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		}
	case types.Decimal:
		buildVec := prober.ht.vals[prober.ht.keyCols[keyColIdx]]
		probeVec := prober.keys[keyColIdx]

		buildKeys := buildVec.Decimal()
		probeKeys := probeVec.Decimal()

		if sel != nil {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = tree.CompareDecimals(&buildVal, &probeVal) != 0

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = tree.CompareDecimals(&buildVal, &probeVal) != 0

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = tree.CompareDecimals(&buildVal, &probeVal) != 0

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = tree.CompareDecimals(&buildVal, &probeVal) != 0

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		} else {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = tree.CompareDecimals(&buildVal, &probeVal) != 0

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = tree.CompareDecimals(&buildVal, &probeVal) != 0

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = tree.CompareDecimals(&buildVal, &probeVal) != 0

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = tree.CompareDecimals(&buildVal, &probeVal) != 0

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		}
	case types.Int8:
		buildVec := prober.ht.vals[prober.ht.keyCols[keyColIdx]]
		probeVec := prober.keys[keyColIdx]

		buildKeys := buildVec.Int8()
		probeKeys := probeVec.Int8()

		if sel != nil {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		} else {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		}
	case types.Int16:
		buildVec := prober.ht.vals[prober.ht.keyCols[keyColIdx]]
		probeVec := prober.keys[keyColIdx]

		buildKeys := buildVec.Int16()
		probeKeys := probeVec.Int16()

		if sel != nil {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		} else {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		}
	case types.Int32:
		buildVec := prober.ht.vals[prober.ht.keyCols[keyColIdx]]
		probeVec := prober.keys[keyColIdx]

		buildKeys := buildVec.Int32()
		probeKeys := probeVec.Int32()

		if sel != nil {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		} else {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		}
	case types.Int64:
		buildVec := prober.ht.vals[prober.ht.keyCols[keyColIdx]]
		probeVec := prober.keys[keyColIdx]

		buildKeys := buildVec.Int64()
		probeKeys := probeVec.Int64()

		if sel != nil {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		} else {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		}
	case types.Float32:
		buildVec := prober.ht.vals[prober.ht.keyCols[keyColIdx]]
		probeVec := prober.keys[keyColIdx]

		buildKeys := buildVec.Float32()
		probeKeys := probeVec.Float32()

		if sel != nil {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		} else {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		}
	case types.Float64:
		buildVec := prober.ht.vals[prober.ht.keyCols[keyColIdx]]
		probeVec := prober.keys[keyColIdx]

		buildKeys := buildVec.Float64()
		probeKeys := probeVec.Float64()

		if sel != nil {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(sel[prober.toCheck[i]]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[sel[prober.toCheck[i]]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		} else {

			if probeVec.HasNulls() {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*  */
							if probeVec.NullAt(prober.toCheck[i]) {
								prober.groupID[prober.toCheck[i]] = 0
							} else /*  */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			} else {
				if buildVec.HasNulls() {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							if buildVec.NullAt64(keyID - 1) {
								prober.differs[prober.toCheck[i]] = true
							} else /* */ {

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				} else {

					for i := uint16(0); i < nToCheck; i++ {
						// keyID of 0 is reserved to represent the end of the next chain.

						if keyID := prober.groupID[prober.toCheck[i]]; keyID != 0 {
							// the build table key (calculated using keys[keyID - 1] = key) is
							// compared to the corresponding probe table to determine if a match is
							// found.

							/*   */
							{

								buildVal := buildKeys[keyID-1]
								probeVal := probeKeys[prober.toCheck[i]]
								var unique bool
								unique = buildVal != probeVal

								if unique {
									prober.differs[prober.toCheck[i]] = true
								}
							}
						}
					}
				}
			}
		}
	default:
		panic(fmt.Sprintf("unhandled type %d", t))
	}
}

// collect prepares the buildIdx and probeIdx arrays where the buildIdx and
// probeIdx at each index are joined to make an output row. The total number of
// resulting rows is returned.
func (prober *hashJoinProber) collect(batch coldata.Batch, batchSize uint16, sel []uint16) uint16 {
	nResults := uint16(0)

	if prober.spec.outer {
		if sel != nil {

			for i := uint16(0); i < batchSize; i++ {
				currentID := prober.head[i]

				if currentID == 0 {
					prober.probeRowUnmatched[nResults] = true
				}

				for {
					if nResults >= coldata.BatchSize {
						prober.prevBatch = batch
						return nResults
					}

					prober.buildIdx[nResults] = currentID - 1
					prober.probeIdx[nResults] = sel[i]
					currentID = prober.ht.same[currentID]
					prober.head[i] = currentID
					nResults++

					if currentID == 0 {
						break
					}
				}
			}
		} else {

			for i := uint16(0); i < batchSize; i++ {
				currentID := prober.head[i]

				if currentID == 0 {
					prober.probeRowUnmatched[nResults] = true
				}

				for {
					if nResults >= coldata.BatchSize {
						prober.prevBatch = batch
						return nResults
					}

					prober.buildIdx[nResults] = currentID - 1
					prober.probeIdx[nResults] = i
					currentID = prober.ht.same[currentID]
					prober.head[i] = currentID
					nResults++

					if currentID == 0 {
						break
					}
				}
			}
		}
	} else {
		if sel != nil {

			for i := uint16(0); i < batchSize; i++ {
				currentID := prober.head[i]
				for currentID != 0 {
					if nResults >= coldata.BatchSize {
						prober.prevBatch = batch
						return nResults
					}

					prober.buildIdx[nResults] = currentID - 1
					prober.probeIdx[nResults] = sel[i]
					currentID = prober.ht.same[currentID]
					prober.head[i] = currentID
					nResults++
				}
			}
		} else {

			for i := uint16(0); i < batchSize; i++ {
				currentID := prober.head[i]
				for currentID != 0 {
					if nResults >= coldata.BatchSize {
						prober.prevBatch = batch
						return nResults
					}

					prober.buildIdx[nResults] = currentID - 1
					prober.probeIdx[nResults] = i
					currentID = prober.ht.same[currentID]
					prober.head[i] = currentID
					nResults++
				}
			}
		}
	}

	return nResults
}

// distinctCollect prepares the batch with the joined output columns where the build
// row index for each probe row is given in the groupID slice. This function
// requires assumes a N-1 hash join.
func (prober *hashJoinProber) distinctCollect(
	batch coldata.Batch, batchSize uint16, sel []uint16,
) uint16 {
	nResults := uint16(0)

	if prober.spec.outer {
		nResults = batchSize

		if sel != nil {

			for i := uint16(0); i < batchSize; i++ {
				// Index of keys and outputs in the hash table is calculated as ID - 1.
				prober.buildIdx[i] = prober.groupID[i] - 1
				prober.probeIdx[i] = sel[i]

				prober.probeRowUnmatched[i] = prober.groupID[i] == 0
			}
		} else {

			for i := uint16(0); i < batchSize; i++ {
				// Index of keys and outputs in the hash table is calculated as ID - 1.
				prober.buildIdx[i] = prober.groupID[i] - 1
				prober.probeIdx[i] = i

				prober.probeRowUnmatched[i] = prober.groupID[i] == 0
			}
		}
	} else {
		if sel != nil {

			for i := uint16(0); i < batchSize; i++ {
				if prober.groupID[i] != 0 {
					// Index of keys and outputs in the hash table is calculated as ID - 1.
					prober.buildIdx[nResults] = prober.groupID[i] - 1
					prober.probeIdx[nResults] = sel[i]
					nResults++
				}
			}
		} else {

			for i := uint16(0); i < batchSize; i++ {
				if prober.groupID[i] != 0 {
					// Index of keys and outputs in the hash table is calculated as ID - 1.
					prober.buildIdx[nResults] = prober.groupID[i] - 1
					prober.probeIdx[nResults] = i
					nResults++
				}
			}
		}
	}

	return nResults
}
