// Copyright 2017 The Cockroach Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
// implied. See the License for the specific language governing
// permissions and limitations under the License.

package engine

/* Generated manually via:

find c-deps/rocksdb/{db,env,memtable,table,util} \
	-name '*.cc' \
	-a -not -name '*_tool*' \
	-a -not -name '*_test*' \
	-a -not -name '*_bench*' \
	-a -not -name '*_example*' |
  xargs cat |
  grep -vE '^#' |                              # filter out #pragma, #include, etc
  grep -vF TEST |                              # Remove some RocksDB test macros (called in non-tests)
  grep -Eo '"[^"]+"' |                         # grab all single-line string literals
	grep -Eo '["[:space:]]+[a-zA-Z]+[:.]?' |     # grab the words: "foo bar   baz::lel" matches {foo, bar}
	tr -d '[:blank:]".:' |                       # remove the quotes and any leftover whitespace (but not newlines)
  tr '[:upper:]' '[:lower:]' |
  sort |
  uniq |
  awk '{ print "\"" $1 "\": {},"}'
*/

var rocksDBErrorDict = map[string]struct{}{
	"a":                                  {},
	"able":                               {},
	"aborted":                            {},
	"aborting":                           {},
	"about":                              {},
	"absolute":                           {},
	"access":                             {},
	"accessing":                          {},
	"accumulated":                        {},
	"acquire":                            {},
	"acquiring":                          {},
	"actual":                             {},
	"add":                                {},
	"added":                              {},
	"addedfiles":                         {},
	"addfile":                            {},
	"adding":                             {},
	"adjust":                             {},
	"after":                              {},
	"again":                              {},
	"aggregated":                         {},
	"ahead":                              {},
	"algo":                               {},
	"algorithm":                          {},
	"algorithms":                         {},
	"all":                                {},
	"allocate":                           {},
	"allocatealigned":                    {},
	"allocating":                         {},
	"allow":                              {},
	"allowed":                            {},
	"already":                            {},
	"also":                               {},
	"always":                             {},
	"among":                              {},
	"amp":                                {},
	"an":                                 {},
	"and":                                {},
	"another":                            {},
	"any":                                {},
	"append":                             {},
	"appended":                           {},
	"appending":                          {},
	"applied":                            {},
	"apply":                              {},
	"archive":                            {},
	"archived":                           {},
	"archiving":                          {},
	"are":                                {},
	"arena":                              {},
	"argument":                           {},
	"as":                                 {},
	"ascii":                              {},
	"at":                                 {},
	"attempted":                          {},
	"automatic":                          {},
	"available":                          {},
	"average":                            {},
	"avg":                                {},
	"avgsec":                             {},
	"b":                                  {},
	"back":                               {},
	"background":                         {},
	"bad":                                {},
	"base":                               {},
	"based":                              {},
	"batch":                              {},
	"be":                                 {},
	"because":                            {},
	"been":                               {},
	"before":                             {},
	"being":                              {},
	"between":                            {},
	"beyond":                             {},
	"bigger":                             {},
	"binary":                             {},
	"bits":                               {},
	"blob":                               {},
	"blobindex":                          {},
	"block":                              {},
	"blockbasedtable":                    {},
	"blockbasedtableoptions":             {},
	"blockbasedtablepropertiescollector": {},
	"blocking":                           {},
	"blocks":                             {},
	"bloom":                              {},
	"bloomfilter":                        {},
	"both":                               {},
	"bottommost":                         {},
	"brown":                              {},
	"bucket":                             {},
	"buckets":                            {},
	"buffer":                             {},
	"build":                              {},
	"built":                              {},
	"busy":                               {},
	"but":                                {},
	"by":                                 {},
	"bytes":                              {},
	"bzip":                               {},
	"c":                                  {},
	"cache":                              {},
	"call":                               {},
	"called":                             {},
	"calling":                            {},
	"can":                                {},
	"canceling":                          {},
	"candidate":                          {},
	"cannot":                             {},
	"cf":                                 {},
	"cfstats":                            {},
	"change":                             {},
	"char":                               {},
	"check":                              {},
	"checksum":                           {},
	"chroot":                             {},
	"class":                              {},
	"clean":                              {},
	"close":                              {},
	"closed":                             {},
	"closing":                            {},
	"code":                               {},
	"collector":                          {},
	"collectors":                         {},
	"collisions":                         {},
	"column":                             {},
	"columnfamily":                       {},
	"columnfamilyadd":                    {},
	"columnfamilydrop":                   {},
	"columnfamilyhandle":                 {},
	"commit":                             {},
	"committing":                         {},
	"common":                             {},
	"comp":                               {},
	"compacted":                          {},
	"compactedfiles":                     {},
	"compactfiles":                       {},
	"compacting":                         {},
	"compaction":                         {},
	"compactionjob":                      {},
	"compactions":                        {},
	"comparator":                         {},
	"compatible":                         {},
	"compcount":                          {},
	"compile":                            {},
	"compiled":                           {},
	"complete":                           {},
	"completeparallelmemtablewriter":     {},
	"compressed":                         {},
	"compression":                        {},
	"compsec":                            {},
	"concurrent":                         {},
	"condition":                          {},
	"config":                             {},
	"const":                              {},
	"contain":                            {},
	"containing":                         {},
	"contains":                           {},
	"content":                            {},
	"contents":                           {},
	"continue":                           {},
	"conversion":                         {},
	"converting":                         {},
	"correct":                            {},
	"corrupt":                            {},
	"corrupted":                          {},
	"corruption":                         {},
	"could":                              {},
	"couldn":                             {},
	"count":                              {},
	"counter":                            {},
	"counts":                             {},
	"cpuid":                              {},
	"crc":                                {},
	"create":                             {},
	"created":                            {},
	"createdirifmissing":                 {},
	"creating":                           {},
	"creation":                           {},
	"cross":                              {},
	"cuckoo":                             {},
	"cuckootablereader":                  {},
	"cumulative":                         {},
	"cur":                                {},
	"current":                            {},
	"currently":                          {},
	"custom":                             {},
	"cut":                                {},
	"data":                               {},
	"database":                           {},
	"date":                               {},
	"db":                                 {},
	"dbimpl":                             {},
	"dbiter":                             {},
	"dbname":                             {},
	"dbstats":                            {},
	"deadlock":                           {},
	"debug":                              {},
	"decode":                             {},
	"decompress":                         {},
	"decompressed":                       {},
	"default":                            {},
	"defined":                            {},
	"del":                                {},
	"delete":                             {},
	"deleted":                            {},
	"deletedfiles":                       {},
	"deletefile":                         {},
	"deleterange":                        {},
	"deleting":                           {},
	"deletion":                           {},
	"deletions":                          {},
	"descriptor":                         {},
	"despite":                            {},
	"destination":                        {},
	"details":                            {},
	"detect":                             {},
	"detected":                           {},
	"device":                             {},
	"dictionary":                         {},
	"did":                                {},
	"didn":                               {},
	"different":                          {},
	"dir":                                {},
	"direct":                             {},
	"directio":                           {},
	"directory":                          {},
	"disable":                            {},
	"disabled":                           {},
	"discontinuity":                      {},
	"distribution":                       {},
	"do":                                 {},
	"does":                               {},
	"doesn":                              {},
	"doing":                              {},
	"done":                               {},
	"dont":                               {},
	"drop":                               {},
	"dropped":                            {},
	"dropping":                           {},
	"due":                                {},
	"dump":                               {},
	"dumping":                            {},
	"during":                             {},
	"earliest":                           {},
	"ebx":                                {},
	"edit":                               {},
	"editnumber":                         {},
	"edx":                                {},
	"empty":                              {},
	"enable":                             {},
	"enabled":                            {},
	"encode":                             {},
	"encoding":                           {},
	"encounter":                          {},
	"encountered":                        {},
	"end":                                {},
	"endprepare":                         {},
	"enough":                             {},
	"enterunbatched":                     {},
	"entries":                            {},
	"entry":                              {},
	"eof":                                {},
	"error":                              {},
	"estimate":                           {},
	"estimated":                          {},
	"event":                              {},
	"exceed":                             {},
	"exceeds":                            {},
	"executing":                          {},
	"exist":                              {},
	"existing":                           {},
	"exists":                             {},
	"exitasbatchgroupleader":             {},
	"expanding":                          {},
	"expected":                           {},
	"expired":                            {},
	"external":                           {},
	"externalsstfileingestionjob":        {},
	"extractor":                          {},
	"f":                                  {},
	"factory":                            {},
	"fadvise":                            {},
	"fail":                               {},
	"failed":                             {},
	"fails":                              {},
	"fall":                               {},
	"fallocate":                          {},
	"false":                              {},
	"families":                           {},
	"family":                             {},
	"fast":                               {},
	"fatal":                              {},
	"fcntl":                              {},
	"fdatasync":                          {},
	"feof":                               {},
	"field":                              {},
	"fifo":                               {},
	"file":                               {},
	"fileexists":                         {},
	"filenumber":                         {},
	"filereader":                         {},
	"files":                              {},
	"filesize":                           {},
	"filter":                             {},
	"find":                               {},
	"finish":                             {},
	"first":                              {},
	"fit":                                {},
	"flag":                               {},
	"flush":                              {},
	"flushed":                            {},
	"flushing":                           {},
	"flushmemtabletooutputfile":          {},
	"flushwal":                           {},
	"following":                          {},
	"footer":                             {},
	"fopen":                              {},
	"for":                                {},
	"format":                             {},
	"forwarditerator":                    {},
	"found":                              {},
	"four":                               {},
	"fox":                                {},
	"fragmented":                         {},
	"from":                               {},
	"fs":                                 {},
	"fseek":                              {},
	"fsync":                              {},
	"ftruncate":                          {},
	"ftruncating":                        {},
	"full":                               {},
	"fullfilter":                         {},
	"fully":                              {},
	"functions":                          {},
	"g":                                  {},
	"gap":                                {},
	"gb":                                 {},
	"generated":                          {},
	"get":                                {},
	"getchildren":                        {},
	"getcurrenttime":                     {},
	"gethostname":                        {},
	"getlogfilesize":                     {},
	"git":                                {},
	"given":                              {},
	"global":                             {},
	"good":                               {},
	"got":                                {},
	"greater":                            {},
	"group":                              {},
	"groups":                             {},
	"guaranteed":                         {},
	"h":                                  {},
	"handle":                             {},
	"has":                                {},
	"hash":                               {},
	"hashlinkedlist":                     {},
	"hashlinklistrepfactory":             {},
	"hashskiplistrepfactory":             {},
	"have":                               {},
	"hdfs":                               {},
	"hdfsexists":                         {},
	"hdfslistdirectory":                  {},
	"hdfslogger":                         {},
	"hdfsreadablefile":                   {},
	"hdfswritablefile":                   {},
	"header":                             {},
	"held":                               {},
	"hex":                                {},
	"hfile":                              {},
	"histogram":                          {},
	"hit":                                {},
	"home":                               {},
	"huge":                               {},
	"i":                                  {},
	"id":                                 {},
	"identity":                           {},
	"if":                                 {},
	"ignored":                            {},
	"ignoring":                           {},
	"immutable":                          {},
	"implementation":                     {},
	"implemented":                        {},
	"in":                                 {},
	"include":                            {},
	"incomplete":                         {},
	"inconsistency":                      {},
	"inconsistent":                       {},
	"incorrect":                          {},
	"increasing":                         {},
	"index":                              {},
	"inernal":                            {},
	"infinite":                           {},
	"info":                               {},
	"ingest":                             {},
	"ingested":                           {},
	"initialized":                        {},
	"input":                              {},
	"inputs":                             {},
	"insert":                             {},
	"inserted":                           {},
	"inst":                               {},
	"instead":                            {},
	"int":                                {},
	"interator":                          {},
	"internal":                           {},
	"internalkey":                        {},
	"interval":                           {},
	"into":                               {},
	"invalid":                            {},
	"invalidate":                         {},
	"invoked":                            {},
	"io":                                 {},
	"is":                                 {},
	"issue":                              {},
	"it":                                 {},
	"iter":                               {},
	"iterator":                           {},
	"iterators":                          {},
	"its":                                {},
	"job":                                {},
	"joinbatchgroup":                     {},
	"k":                                  {},
	"kallowoverallocationratio":          {},
	"karenablocksize":                    {},
	"kb":                                 {},
	"kbloomblock":                        {},
	"kcompactionstylelevel":              {},
	"kdeletedkeys":                       {},
	"keep":                               {},
	"kept":                               {},
	"key":                                {},
	"keydrop":                            {},
	"keyin":                              {},
	"keys":                               {},
	"kmaxsequencenumber":                 {},
	"kmergeoperands":                     {},
	"known":                              {},
	"l":                                  {},
	"large":                              {},
	"larger":                             {},
	"largest":                            {},
	"largestikey":                        {},
	"last":                               {},
	"lastseq":                            {},
	"latency":                            {},
	"latest":                             {},
	"ldb":                                {},
	"least":                              {},
	"left":                               {},
	"legacy":                             {},
	"len":                                {},
	"length":                             {},
	"lenth":                              {},
	"level":                              {},
	"leveldb":                            {},
	"leveliterator":                      {},
	"levels":                             {},
	"levelstats":                         {},
	"limit":                              {},
	"link":                               {},
	"linked":                             {},
	"links":                              {},
	"list":                               {},
	"lite":                               {},
	"live":                               {},
	"load":                               {},
	"lock":                               {},
	"log":                                {},
	"logandapply":                        {},
	"logger":                             {},
	"lognumber":                          {},
	"logs":                               {},
	"long":                               {},
	"lost":                               {},
	"lsm":                                {},
	"lx":                                 {},
	"lz":                                 {},
	"m":                                  {},
	"magic":                              {},
	"malformed":                          {},
	"malloc":                             {},
	"managed":                            {},
	"manifest":                           {},
	"manual":                             {},
	"many":                               {},
	"mapped":                             {},
	"mark":                               {},
	"match":                              {},
	"matched":                            {},
	"max":                                {},
	"maxallowedspacereached":             {},
	"maxcolumnfamily":                    {},
	"maximum":                            {},
	"may":                                {},
	"maybe":                              {},
	"mb":                                 {},
	"mem":                                {},
	"memory":                             {},
	"memtable":                           {},
	"memtablelist":                       {},
	"memtables":                          {},
	"merge":                              {},
	"meta":                               {},
	"metadata":                           {},
	"metadb":                             {},
	"metaindex":                          {},
	"mid":                                {},
	"middle":                             {},
	"min":                                {},
	"mismatch":                           {},
	"missing":                            {},
	"mkdir":                              {},
	"mmap":                               {},
	"mmaped":                             {},
	"mmapped":                            {},
	"mock":                               {},
	"mod":                                {},
	"mode":                               {},
	"moderately":                         {},
	"modification":                       {},
	"monotonically":                      {},
	"more":                               {},
	"move":                               {},
	"moved":                              {},
	"movedgb":                            {},
	"moving":                             {},
	"ms":                                 {},
	"msync":                              {},
	"munmap":                             {},
	"must":                               {},
	"mutex":                              {},
	"n":                                  {},
	"name":                               {},
	"names":                              {},
	"nanos":                              {},
	"necessary":                          {},
	"need":                               {},
	"needed":                             {},
	"needs":                              {},
	"negative":                           {},
	"new":                                {},
	"newdirectory":                       {},
	"newer":                              {},
	"newline":                            {},
	"newwritablefile":                    {},
	"next":                               {},
	"nextfilenumber":                     {},
	"no":                                 {},
	"nocache":                            {},
	"non":                                {},
	"not":                                {},
	"notfound":                           {},
	"nothing":                            {},
	"notneeded":                          {},
	"now":                                {},
	"null":                               {},
	"nullptr":                            {},
	"num":                                {},
	"number":                             {},
	"numbers":                            {},
	"numfiles":                           {},
	"object":                             {},
	"of":                                 {},
	"offset":                             {},
	"ok":                                 {},
	"okay":                               {},
	"old":                                {},
	"oldest":                             {},
	"on":                                 {},
	"one":                                {},
	"only":                               {},
	"open":                               {},
	"opencompactionoutputfiles":          {},
	"opendir":                            {},
	"opened":                             {},
	"opening":                            {},
	"operation":                          {},
	"operator":                           {},
	"ops":                                {},
	"opt":                                {},
	"option":                             {},
	"options":                            {},
	"or":                                 {},
	"order":                              {},
	"original":                           {},
	"other":                              {},
	"out":                                {},
	"output":                             {},
	"outside":                            {},
	"overlapping":                        {},
	"p":                                  {},
	"pages":                              {},
	"parallel":                           {},
	"parse":                              {},
	"partial":                            {},
	"partition":                          {},
	"partitionedfilter":                  {},
	"partitions":                         {},
	"path":                               {},
	"paths":                              {},
	"pause":                              {},
	"pending":                            {},
	"per":                                {},
	"percent":                            {},
	"perform":                            {},
	"persist":                            {},
	"persistent":                         {},
	"picking":                            {},
	"pin":                                {},
	"pipelined":                          {},
	"plain":                              {},
	"plaintable":                         {},
	"plaintableindexblock":               {},
	"plaintableoptions":                  {},
	"plaintablereader":                   {},
	"platform":                           {},
	"please":                             {},
	"point":                              {},
	"pointer":                            {},
	"policy":                             {},
	"pos":                                {},
	"possible":                           {},
	"ppc":                                {},
	"pread":                              {},
	"preading":                           {},
	"prefetching":                        {},
	"prefix":                             {},
	"prefixed":                           {},
	"prepared":                           {},
	"prepares":                           {},
	"present":                            {},
	"preserved":                          {},
	"prev":                               {},
	"previous":                           {},
	"prevlognumber":                      {},
	"printing":                           {},
	"progress":                           {},
	"promotel":                           {},
	"prop":                               {},
	"properly":                           {},
	"properties":                         {},
	"property":                           {},
	"provide":                            {},
	"pthread":                            {},
	"purge":                              {},
	"put":                                {},
	"pwrite":                             {},
	"quick":                              {},
	"r":                                  {},
	"random":                             {},
	"randomaccessfilereader":             {},
	"range":                              {},
	"ranges":                             {},
	"rate":                               {},
	"ratio":                              {},
	"raw":                                {},
	"rd":                                 {},
	"reached":                            {},
	"read":                               {},
	"readgb":                             {},
	"reading":                            {},
	"readmbps":                           {},
	"readonly":                           {},
	"reads":                              {},
	"readtier":                           {},
	"real":                               {},
	"really":                             {},
	"recognize":                          {},
	"record":                             {},
	"recorded":                           {},
	"records":                            {},
	"recovered":                          {},
	"recovering":                         {},
	"recovery":                           {},
	"recycle":                            {},
	"reduce":                             {},
	"reduction":                          {},
	"referencing":                        {},
	"refitting":                          {},
	"release":                            {},
	"remove":                             {},
	"rename":                             {},
	"renaming":                           {},
	"renew":                              {},
	"reopen":                             {},
	"reopened":                           {},
	"repair":                             {},
	"repaired":                           {},
	"reported":                           {},
	"requested":                          {},
	"require":                            {},
	"required":                           {},
	"requires":                           {},
	"res":                                {},
	"reseek":                             {},
	"reserving":                          {},
	"resource":                           {},
	"rest":                               {},
	"result":                             {},
	"returned":                           {},
	"reusing":                            {},
	"rmdir":                              {},
	"rn":                                 {},
	"rngb":                               {},
	"rnp":                                {},
	"rocksdb":                            {},
	"rocksdblite":                        {},
	"rollback":                           {},
	"run":                                {},
	"runs":                               {},
	"same":                               {},
	"satisfied":                          {},
	"saved":                              {},
	"scan":                               {},
	"scheduled":                          {},
	"score":                              {},
	"scratch":                            {},
	"search":                             {},
	"sec":                                {},
	"seconds":                            {},
	"seek":                               {},
	"seekable":                           {},
	"seekforprev":                        {},
	"seeking":                            {},
	"seektolast":                         {},
	"selection":                          {},
	"seq":                                {},
	"seqno":                              {},
	"sequence":                           {},
	"sequentially":                       {},
	"set":                                {},
	"setdboptions":                       {},
	"setoptions":                         {},
	"setting":                            {},
	"sha":                                {},
	"short":                              {},
	"shrink":                             {},
	"shutdown":                           {},
	"silently":                           {},
	"since":                              {},
	"size":                               {},
	"sizebytes":                          {},
	"skip":                               {},
	"skipped":                            {},
	"skipping":                           {},
	"slice":                              {},
	"slots":                              {},
	"slowdown":                           {},
	"small":                              {},
	"smallestikey":                       {},
	"snappy":                             {},
	"snapshots":                          {},
	"some":                               {},
	"sorted":                             {},
	"source":                             {},
	"space":                              {},
	"specified":                          {},
	"sse":                                {},
	"sst":                                {},
	"sstable":                            {},
	"sstables":                           {},
	"sstfilemanager":                     {},
	"stale":                              {},
	"stall":                              {},
	"stalling":                           {},
	"stalls":                             {},
	"stamp":                              {},
	"start":                              {},
	"started":                            {},
	"starting":                           {},
	"stat":                               {},
	"statistics":                         {},
	"stats":                              {},
	"status":                             {},
	"stop":                               {},
	"stopping":                           {},
	"store":                              {},
	"style":                              {},
	"styles":                             {},
	"sub":                                {},
	"succeeded":                          {},
	"successfully":                       {},
	"suffix":                             {},
	"sum":                                {},
	"summary":                            {},
	"support":                            {},
	"supported":                          {},
	"sync":                               {},
	"synced":                             {},
	"syncing":                            {},
	"syncs":                              {},
	"syncwal":                            {},
	"table":                              {},
	"tablefactory":                       {},
	"tablepropertiescollector":           {},
	"tag":                                {},
	"tailing":                            {},
	"target":                             {},
	"tb":                                 {},
	"than":                               {},
	"that":                               {},
	"the":                                {},
	"then":                               {},
	"there":                              {},
	"this":                               {},
	"thread":                             {},
	"threads":                            {},
	"time":                               {},
	"timed":                              {},
	"timeout":                            {},
	"tlb":                                {},
	"to":                                 {},
	"tombstone":                          {},
	"tombstones":                         {},
	"too":                                {},
	"top":                                {},
	"total":                              {},
	"trailing":                           {},
	"transaction":                        {},
	"transactiondb":                      {},
	"transactions":                       {},
	"trash":                              {},
	"tried":                              {},
	"trivial":                            {},
	"true":                               {},
	"truncated":                          {},
	"try":                                {},
	"trying":                             {},
	"ttl":                                {},
	"twice":                              {},
	"two":                                {},
	"type":                               {},
	"un":                                 {},
	"unable":                             {},
	"uncommited":                         {},
	"undentified":                        {},
	"underlying":                         {},
	"unexpected":                         {},
	"unidentified":                       {},
	"universal":                          {},
	"unknown":                            {},
	"unless":                             {},
	"unlink":                             {},
	"unlock":                             {},
	"unnable":                            {},
	"unparsable":                         {},
	"unrecognized":                       {},
	"unsupported":                        {},
	"unused":                             {},
	"up":                                 {},
	"updates":                            {},
	"upper":                              {},
	"uptime":                             {},
	"us":                                 {},
	"use":                                {},
	"used":                               {},
	"user":                               {},
	"using":                              {},
	"v":                                  {},
	"valid":                              {},
	"value":                              {},
	"values":                             {},
	"vaue":                               {},
	"vector":                             {},
	"verification":                       {},
	"verify":                             {},
	"version":                            {},
	"versionedit":                        {},
	"very":                               {},
	"via":                                {},
	"vs":                                 {},
	"w":                                  {},
	"waitformemtablewriters":             {},
	"waiting":                            {},
	"wal":                                {},
	"walprocessingoption":                {},
	"wals":                               {},
	"warn":                               {},
	"was":                                {},
	"we":                                 {},
	"when":                               {},
	"which":                              {},
	"while":                              {},
	"who":                                {},
	"whole":                              {},
	"will":                               {},
	"with":                               {},
	"without":                            {},
	"wnew":                               {},
	"wnewgb":                             {},
	"work":                               {},
	"wr":                                 {},
	"writablefile":                       {},
	"writablefilewriter":                 {},
	"write":                              {},
	"writeamp":                           {},
	"writebatch":                         {},
	"writegb":                            {},
	"writembps":                          {},
	"writers":                            {},
	"writes":                             {},
	"writing":                            {},
	"written":                            {},
	"wrong":                              {},
	"x":                                  {},
	"xid":                                {},
	"xpress":                             {},
	"xx":                                 {},
	"xxgb":                               {},
	"xxtb":                               {},
	"yet":                                {},
	"yield":                              {},
	"you":                                {},
	"zero":                               {},
	"zlib":                               {},
	"zstd":                               {},
}
