package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFCTrigger invokes the cdn.ListFCTrigger API synchronously
func (client *Client) ListFCTrigger(request *ListFCTriggerRequest) (response *ListFCTriggerResponse, err error) {
	response = CreateListFCTriggerResponse()
	err = client.DoAction(request, response)
	return
}

// ListFCTriggerWithChan invokes the cdn.ListFCTrigger API asynchronously
func (client *Client) ListFCTriggerWithChan(request *ListFCTriggerRequest) (<-chan *ListFCTriggerResponse, <-chan error) {
	responseChan := make(chan *ListFCTriggerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFCTrigger(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFCTriggerWithCallback invokes the cdn.ListFCTrigger API asynchronously
func (client *Client) ListFCTriggerWithCallback(request *ListFCTriggerRequest, callback func(response *ListFCTriggerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFCTriggerResponse
		var err error
		defer close(result)
		response, err = client.ListFCTrigger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFCTriggerRequest is the request struct for api ListFCTrigger
type ListFCTriggerRequest struct {
	*requests.RpcRequest
	EventMetaVersion string           `position:"Query" name:"EventMetaVersion"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	EventMetaName    string           `position:"Query" name:"EventMetaName"`
}

// ListFCTriggerResponse is the response struct for api ListFCTrigger
type ListFCTriggerResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	FCTriggers []FCTrigger `json:"FCTriggers" xml:"FCTriggers"`
}

// CreateListFCTriggerRequest creates a request to invoke ListFCTrigger API
func CreateListFCTriggerRequest() (request *ListFCTriggerRequest) {
	request = &ListFCTriggerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "ListFCTrigger", "", "")
	request.Method = requests.GET
	return
}

// CreateListFCTriggerResponse creates a response to parse from ListFCTrigger response
func CreateListFCTriggerResponse() (response *ListFCTriggerResponse) {
	response = &ListFCTriggerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
