package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMapRouteDetails invokes the cdrs.ListMapRouteDetails API synchronously
func (client *Client) ListMapRouteDetails(request *ListMapRouteDetailsRequest) (response *ListMapRouteDetailsResponse, err error) {
	response = CreateListMapRouteDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// ListMapRouteDetailsWithChan invokes the cdrs.ListMapRouteDetails API asynchronously
func (client *Client) ListMapRouteDetailsWithChan(request *ListMapRouteDetailsRequest) (<-chan *ListMapRouteDetailsResponse, <-chan error) {
	responseChan := make(chan *ListMapRouteDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMapRouteDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMapRouteDetailsWithCallback invokes the cdrs.ListMapRouteDetails API asynchronously
func (client *Client) ListMapRouteDetailsWithCallback(request *ListMapRouteDetailsRequest, callback func(response *ListMapRouteDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMapRouteDetailsResponse
		var err error
		defer close(result)
		response, err = client.ListMapRouteDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMapRouteDetailsRequest is the request struct for api ListMapRouteDetails
type ListMapRouteDetailsRequest struct {
	*requests.RpcRequest
	RouteList string `position:"Body" name:"RouteList"`
}

// ListMapRouteDetailsResponse is the response struct for api ListMapRouteDetails
type ListMapRouteDetailsResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	PageNumber int64   `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64   `json:"PageSize" xml:"PageSize"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Data       []Datas `json:"Data" xml:"Data"`
}

// CreateListMapRouteDetailsRequest creates a request to invoke ListMapRouteDetails API
func CreateListMapRouteDetailsRequest() (request *ListMapRouteDetailsRequest) {
	request = &ListMapRouteDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListMapRouteDetails", "", "")
	request.Method = requests.POST
	return
}

// CreateListMapRouteDetailsResponse creates a response to parse from ListMapRouteDetails response
func CreateListMapRouteDetailsResponse() (response *ListMapRouteDetailsResponse) {
	response = &ListMapRouteDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
