package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVnStatisticalData invokes the cloudcallcenter.DescribeVnStatisticalData API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnstatisticaldata.html
func (client *Client) DescribeVnStatisticalData(request *DescribeVnStatisticalDataRequest) (response *DescribeVnStatisticalDataResponse, err error) {
	response = CreateDescribeVnStatisticalDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVnStatisticalDataWithChan invokes the cloudcallcenter.DescribeVnStatisticalData API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnstatisticaldata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnStatisticalDataWithChan(request *DescribeVnStatisticalDataRequest) (<-chan *DescribeVnStatisticalDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVnStatisticalDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVnStatisticalData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVnStatisticalDataWithCallback invokes the cloudcallcenter.DescribeVnStatisticalData API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnstatisticaldata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnStatisticalDataWithCallback(request *DescribeVnStatisticalDataRequest, callback func(response *DescribeVnStatisticalDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVnStatisticalDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVnStatisticalData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVnStatisticalDataRequest is the request struct for api DescribeVnStatisticalData
type DescribeVnStatisticalDataRequest struct {
	*requests.RpcRequest
	BeginTimeLeftRange  requests.Integer `position:"Query" name:"BeginTimeLeftRange"`
	TimeUnit            string           `position:"Query" name:"TimeUnit"`
	InstanceId          string           `position:"Query" name:"InstanceId"`
	BeginTimeRightRange requests.Integer `position:"Query" name:"BeginTimeRightRange"`
}

// DescribeVnStatisticalDataResponse is the response struct for api DescribeVnStatisticalData
type DescribeVnStatisticalDataResponse struct {
	*responses.BaseResponse
	RequestId                string                  `json:"RequestId" xml:"RequestId"`
	ResolvedQuestionTotalNum int64                   `json:"ResolvedQuestionTotalNum" xml:"ResolvedQuestionTotalNum"`
	ConversationTotalNum     int64                   `json:"ConversationTotalNum" xml:"ConversationTotalNum"`
	TotalResolutionRate      string                  `json:"TotalResolutionRate" xml:"TotalResolutionRate"`
	TotalValidAnswerRate     string                  `json:"TotalValidAnswerRate" xml:"TotalValidAnswerRate"`
	TotalDialoguePassRate    string                  `json:"TotalDialoguePassRate" xml:"TotalDialoguePassRate"`
	TotalKnowledgeHitRate    string                  `json:"TotalKnowledgeHitRate" xml:"TotalKnowledgeHitRate"`
	StatisticalDataReports   []StatisticalDataReport `json:"StatisticalDataReports" xml:"StatisticalDataReports"`
}

// CreateDescribeVnStatisticalDataRequest creates a request to invoke DescribeVnStatisticalData API
func CreateDescribeVnStatisticalDataRequest() (request *DescribeVnStatisticalDataRequest) {
	request = &DescribeVnStatisticalDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DescribeVnStatisticalData", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeVnStatisticalDataResponse creates a response to parse from DescribeVnStatisticalData response
func CreateDescribeVnStatisticalDataResponse() (response *DescribeVnStatisticalDataResponse) {
	response = &DescribeVnStatisticalDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
