package cloudgameapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryOutAccountBindStatus invokes the cloudgameapi.QueryOutAccountBindStatus API synchronously
func (client *Client) QueryOutAccountBindStatus(request *QueryOutAccountBindStatusRequest) (response *QueryOutAccountBindStatusResponse, err error) {
	response = CreateQueryOutAccountBindStatusResponse()
	err = client.DoAction(request, response)
	return
}

// QueryOutAccountBindStatusWithChan invokes the cloudgameapi.QueryOutAccountBindStatus API asynchronously
func (client *Client) QueryOutAccountBindStatusWithChan(request *QueryOutAccountBindStatusRequest) (<-chan *QueryOutAccountBindStatusResponse, <-chan error) {
	responseChan := make(chan *QueryOutAccountBindStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryOutAccountBindStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryOutAccountBindStatusWithCallback invokes the cloudgameapi.QueryOutAccountBindStatus API asynchronously
func (client *Client) QueryOutAccountBindStatusWithCallback(request *QueryOutAccountBindStatusRequest, callback func(response *QueryOutAccountBindStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryOutAccountBindStatusResponse
		var err error
		defer close(result)
		response, err = client.QueryOutAccountBindStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryOutAccountBindStatusRequest is the request struct for api QueryOutAccountBindStatus
type QueryOutAccountBindStatusRequest struct {
	*requests.RpcRequest
	GameId        string `position:"Query" name:"GameId"`
	AccountDomain string `position:"Query" name:"AccountDomain"`
	AccountId     string `position:"Query" name:"AccountId"`
}

// QueryOutAccountBindStatusResponse is the response struct for api QueryOutAccountBindStatus
type QueryOutAccountBindStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryOutAccountBindStatusRequest creates a request to invoke QueryOutAccountBindStatus API
func CreateQueryOutAccountBindStatusRequest() (request *QueryOutAccountBindStatusRequest) {
	request = &QueryOutAccountBindStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudGameAPI", "2020-07-28", "QueryOutAccountBindStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryOutAccountBindStatusResponse creates a response to parse from QueryOutAccountBindStatus response
func CreateQueryOutAccountBindStatusResponse() (response *QueryOutAccountBindStatusResponse) {
	response = &QueryOutAccountBindStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
