package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OemSitingContrast invokes the cloudwf.OemSitingContrast API synchronously
// api document: https://help.aliyun.com/api/cloudwf/oemsitingcontrast.html
func (client *Client) OemSitingContrast(request *OemSitingContrastRequest) (response *OemSitingContrastResponse, err error) {
	response = CreateOemSitingContrastResponse()
	err = client.DoAction(request, response)
	return
}

// OemSitingContrastWithChan invokes the cloudwf.OemSitingContrast API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemsitingcontrast.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemSitingContrastWithChan(request *OemSitingContrastRequest) (<-chan *OemSitingContrastResponse, <-chan error) {
	responseChan := make(chan *OemSitingContrastResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OemSitingContrast(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OemSitingContrastWithCallback invokes the cloudwf.OemSitingContrast API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemsitingcontrast.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemSitingContrastWithCallback(request *OemSitingContrastRequest, callback func(response *OemSitingContrastResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OemSitingContrastResponse
		var err error
		defer close(result)
		response, err = client.OemSitingContrast(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OemSitingContrastRequest is the request struct for api OemSitingContrast
type OemSitingContrastRequest struct {
	*requests.RpcRequest
	Bid requests.Integer `position:"Query" name:"Bid"`
}

// OemSitingContrastResponse is the response struct for api OemSitingContrast
type OemSitingContrastResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateOemSitingContrastRequest creates a request to invoke OemSitingContrast API
func CreateOemSitingContrastRequest() (request *OemSitingContrastRequest) {
	request = &OemSitingContrastRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "OemSitingContrast", "cloudwf", "openAPI")
	return
}

// CreateOemSitingContrastResponse creates a response to parse from OemSitingContrast response
func CreateOemSitingContrastResponse() (response *OemSitingContrastResponse) {
	response = &OemSitingContrastResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
