package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveProbeDataSubscriber invokes the cloudwf.SaveProbeDataSubscriber API synchronously
// api document: https://help.aliyun.com/api/cloudwf/saveprobedatasubscriber.html
func (client *Client) SaveProbeDataSubscriber(request *SaveProbeDataSubscriberRequest) (response *SaveProbeDataSubscriberResponse, err error) {
	response = CreateSaveProbeDataSubscriberResponse()
	err = client.DoAction(request, response)
	return
}

// SaveProbeDataSubscriberWithChan invokes the cloudwf.SaveProbeDataSubscriber API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveprobedatasubscriber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveProbeDataSubscriberWithChan(request *SaveProbeDataSubscriberRequest) (<-chan *SaveProbeDataSubscriberResponse, <-chan error) {
	responseChan := make(chan *SaveProbeDataSubscriberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveProbeDataSubscriber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveProbeDataSubscriberWithCallback invokes the cloudwf.SaveProbeDataSubscriber API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveprobedatasubscriber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveProbeDataSubscriberWithCallback(request *SaveProbeDataSubscriberRequest, callback func(response *SaveProbeDataSubscriberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveProbeDataSubscriberResponse
		var err error
		defer close(result)
		response, err = client.SaveProbeDataSubscriber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveProbeDataSubscriberRequest is the request struct for api SaveProbeDataSubscriber
type SaveProbeDataSubscriberRequest struct {
	*requests.RpcRequest
	ApiUrl         string           `position:"Query" name:"ApiUrl"`
	ParamGenScript string           `position:"Query" name:"ParamGenScript"`
	Name           string           `position:"Query" name:"Name"`
	HttpMethod     string           `position:"Query" name:"HttpMethod"`
	Description    string           `position:"Query" name:"Description"`
	Id             requests.Integer `position:"Query" name:"Id"`
	Type           requests.Integer `position:"Query" name:"Type"`
	ResourceIds    *[]string        `position:"Query" name:"ResourceIds"  type:"Repeated"`
}

// SaveProbeDataSubscriberResponse is the response struct for api SaveProbeDataSubscriber
type SaveProbeDataSubscriberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateSaveProbeDataSubscriberRequest creates a request to invoke SaveProbeDataSubscriber API
func CreateSaveProbeDataSubscriberRequest() (request *SaveProbeDataSubscriberRequest) {
	request = &SaveProbeDataSubscriberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "SaveProbeDataSubscriber", "cloudwf", "openAPI")
	return
}

// CreateSaveProbeDataSubscriberResponse creates a response to parse from SaveProbeDataSubscriber response
func CreateSaveProbeDataSubscriberResponse() (response *SaveProbeDataSubscriberResponse) {
	response = &SaveProbeDataSubscriberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
