package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteBranch invokes the codeup.DeleteBranch API synchronously
func (client *Client) DeleteBranch(request *DeleteBranchRequest) (response *DeleteBranchResponse, err error) {
	response = CreateDeleteBranchResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteBranchWithChan invokes the codeup.DeleteBranch API asynchronously
func (client *Client) DeleteBranchWithChan(request *DeleteBranchRequest) (<-chan *DeleteBranchResponse, <-chan error) {
	responseChan := make(chan *DeleteBranchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteBranch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteBranchWithCallback invokes the codeup.DeleteBranch API asynchronously
func (client *Client) DeleteBranchWithCallback(request *DeleteBranchRequest, callback func(response *DeleteBranchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteBranchResponse
		var err error
		defer close(result)
		response, err = client.DeleteBranch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteBranchRequest is the request struct for api DeleteBranch
type DeleteBranchRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	SubUserId      string           `position:"Query" name:"SubUserId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
	BranchName     string           `position:"Query" name:"BranchName"`
}

// DeleteBranchResponse is the response struct for api DeleteBranch
type DeleteBranchResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateDeleteBranchRequest creates a request to invoke DeleteBranch API
func CreateDeleteBranchRequest() (request *DeleteBranchRequest) {
	request = &DeleteBranchRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "DeleteBranch", "/api/v3/projects/[ProjectId]/repository/branches/delete", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteBranchResponse creates a response to parse from DeleteBranch response
func CreateDeleteBranchResponse() (response *DeleteBranchResponse) {
	response = &DeleteBranchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
