package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetResourceComplianceByConfigRule invokes the config.GetResourceComplianceByConfigRule API synchronously
func (client *Client) GetResourceComplianceByConfigRule(request *GetResourceComplianceByConfigRuleRequest) (response *GetResourceComplianceByConfigRuleResponse, err error) {
	response = CreateGetResourceComplianceByConfigRuleResponse()
	err = client.DoAction(request, response)
	return
}

// GetResourceComplianceByConfigRuleWithChan invokes the config.GetResourceComplianceByConfigRule API asynchronously
func (client *Client) GetResourceComplianceByConfigRuleWithChan(request *GetResourceComplianceByConfigRuleRequest) (<-chan *GetResourceComplianceByConfigRuleResponse, <-chan error) {
	responseChan := make(chan *GetResourceComplianceByConfigRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetResourceComplianceByConfigRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetResourceComplianceByConfigRuleWithCallback invokes the config.GetResourceComplianceByConfigRule API asynchronously
func (client *Client) GetResourceComplianceByConfigRuleWithCallback(request *GetResourceComplianceByConfigRuleRequest, callback func(response *GetResourceComplianceByConfigRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetResourceComplianceByConfigRuleResponse
		var err error
		defer close(result)
		response, err = client.GetResourceComplianceByConfigRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetResourceComplianceByConfigRuleRequest is the request struct for api GetResourceComplianceByConfigRule
type GetResourceComplianceByConfigRuleRequest struct {
	*requests.RpcRequest
	ConfigRuleId   string `position:"Query" name:"ConfigRuleId"`
	ComplianceType string `position:"Query" name:"ComplianceType"`
}

// GetResourceComplianceByConfigRuleResponse is the response struct for api GetResourceComplianceByConfigRule
type GetResourceComplianceByConfigRuleResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	ComplianceResult ComplianceResult `json:"ComplianceResult" xml:"ComplianceResult"`
}

// CreateGetResourceComplianceByConfigRuleRequest creates a request to invoke GetResourceComplianceByConfigRule API
func CreateGetResourceComplianceByConfigRuleRequest() (request *GetResourceComplianceByConfigRuleRequest) {
	request = &GetResourceComplianceByConfigRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetResourceComplianceByConfigRule", "", "")
	request.Method = requests.GET
	return
}

// CreateGetResourceComplianceByConfigRuleResponse creates a response to parse from GetResourceComplianceByConfigRule response
func CreateGetResourceComplianceByConfigRuleResponse() (response *GetResourceComplianceByConfigRuleResponse) {
	response = &GetResourceComplianceByConfigRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
