package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBatchSlsDispatchStatus invokes the ddoscoo.DescribeBatchSlsDispatchStatus API synchronously
func (client *Client) DescribeBatchSlsDispatchStatus(request *DescribeBatchSlsDispatchStatusRequest) (response *DescribeBatchSlsDispatchStatusResponse, err error) {
	response = CreateDescribeBatchSlsDispatchStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBatchSlsDispatchStatusWithChan invokes the ddoscoo.DescribeBatchSlsDispatchStatus API asynchronously
func (client *Client) DescribeBatchSlsDispatchStatusWithChan(request *DescribeBatchSlsDispatchStatusRequest) (<-chan *DescribeBatchSlsDispatchStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeBatchSlsDispatchStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBatchSlsDispatchStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBatchSlsDispatchStatusWithCallback invokes the ddoscoo.DescribeBatchSlsDispatchStatus API asynchronously
func (client *Client) DescribeBatchSlsDispatchStatusWithCallback(request *DescribeBatchSlsDispatchStatusRequest, callback func(response *DescribeBatchSlsDispatchStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBatchSlsDispatchStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeBatchSlsDispatchStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBatchSlsDispatchStatusRequest is the request struct for api DescribeBatchSlsDispatchStatus
type DescribeBatchSlsDispatchStatusRequest struct {
	*requests.RpcRequest
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageNo          requests.Integer `position:"Query" name:"PageNo"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	Lang            string           `position:"Query" name:"Lang"`
}

// DescribeBatchSlsDispatchStatusResponse is the response struct for api DescribeBatchSlsDispatchStatus
type DescribeBatchSlsDispatchStatusResponse struct {
	*responses.BaseResponse
	RequestId           string            `json:"RequestId" xml:"RequestId"`
	TotalCount          int               `json:"TotalCount" xml:"TotalCount"`
	SlsConfigStatusList []SlsConfigStatus `json:"SlsConfigStatusList" xml:"SlsConfigStatusList"`
}

// CreateDescribeBatchSlsDispatchStatusRequest creates a request to invoke DescribeBatchSlsDispatchStatus API
func CreateDescribeBatchSlsDispatchStatusRequest() (request *DescribeBatchSlsDispatchStatusRequest) {
	request = &DescribeBatchSlsDispatchStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DescribeBatchSlsDispatchStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeBatchSlsDispatchStatusResponse creates a response to parse from DescribeBatchSlsDispatchStatus response
func CreateDescribeBatchSlsDispatchStatusResponse() (response *DescribeBatchSlsDispatchStatusResponse) {
	response = &DescribeBatchSlsDispatchStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
