package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDevopsOrganizationMembers invokes the devops_rdc.DeleteDevopsOrganizationMembers API synchronously
func (client *Client) DeleteDevopsOrganizationMembers(request *DeleteDevopsOrganizationMembersRequest) (response *DeleteDevopsOrganizationMembersResponse, err error) {
	response = CreateDeleteDevopsOrganizationMembersResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDevopsOrganizationMembersWithChan invokes the devops_rdc.DeleteDevopsOrganizationMembers API asynchronously
func (client *Client) DeleteDevopsOrganizationMembersWithChan(request *DeleteDevopsOrganizationMembersRequest) (<-chan *DeleteDevopsOrganizationMembersResponse, <-chan error) {
	responseChan := make(chan *DeleteDevopsOrganizationMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDevopsOrganizationMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDevopsOrganizationMembersWithCallback invokes the devops_rdc.DeleteDevopsOrganizationMembers API asynchronously
func (client *Client) DeleteDevopsOrganizationMembersWithCallback(request *DeleteDevopsOrganizationMembersRequest, callback func(response *DeleteDevopsOrganizationMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDevopsOrganizationMembersResponse
		var err error
		defer close(result)
		response, err = client.DeleteDevopsOrganizationMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDevopsOrganizationMembersRequest is the request struct for api DeleteDevopsOrganizationMembers
type DeleteDevopsOrganizationMembersRequest struct {
	*requests.RpcRequest
	RealPk string `position:"Body" name:"RealPk"`
	UserId string `position:"Body" name:"UserId"`
	OrgId  string `position:"Body" name:"OrgId"`
}

// DeleteDevopsOrganizationMembersResponse is the response struct for api DeleteDevopsOrganizationMembers
type DeleteDevopsOrganizationMembersResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Object       bool   `json:"Object" xml:"Object"`
}

// CreateDeleteDevopsOrganizationMembersRequest creates a request to invoke DeleteDevopsOrganizationMembers API
func CreateDeleteDevopsOrganizationMembersRequest() (request *DeleteDevopsOrganizationMembersRequest) {
	request = &DeleteDevopsOrganizationMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "DeleteDevopsOrganizationMembers", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDevopsOrganizationMembersResponse creates a response to parse from DeleteDevopsOrganizationMembers response
func CreateDeleteDevopsOrganizationMembersResponse() (response *DeleteDevopsOrganizationMembersResponse) {
	response = &DeleteDevopsOrganizationMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
