//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package eci

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportContainerGroupTemplate invokes the eci.ExportContainerGroupTemplate API synchronously
// api document: https://help.aliyun.com/api/eci/exportcontainergrouptemplate.html
func (client *Client) ExportContainerGroupTemplate(request *ExportContainerGroupTemplateRequest) (response *ExportContainerGroupTemplateResponse, err error) {
	response = CreateExportContainerGroupTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// ExportContainerGroupTemplateWithChan invokes the eci.ExportContainerGroupTemplate API asynchronously
// api document: https://help.aliyun.com/api/eci/exportcontainergrouptemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExportContainerGroupTemplateWithChan(request *ExportContainerGroupTemplateRequest) (<-chan *ExportContainerGroupTemplateResponse, <-chan error) {
	responseChan := make(chan *ExportContainerGroupTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportContainerGroupTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportContainerGroupTemplateWithCallback invokes the eci.ExportContainerGroupTemplate API asynchronously
// api document: https://help.aliyun.com/api/eci/exportcontainergrouptemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExportContainerGroupTemplateWithCallback(request *ExportContainerGroupTemplateRequest, callback func(response *ExportContainerGroupTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportContainerGroupTemplateResponse
		var err error
		defer close(result)
		response, err = client.ExportContainerGroupTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportContainerGroupTemplateRequest is the request struct for api ExportContainerGroupTemplate
type ExportContainerGroupTemplateRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RegionId             string           `position:"Query" name:"RegionId"`
	ContainerGroupId     string           `position:"Query" name:"ContainerGroupId"`
	VkClientVersion      string           `position:"Query" name:"VkClientVersion"`
}

// ExportContainerGroupTemplateResponse is the response struct for api ExportContainerGroupTemplate
type ExportContainerGroupTemplateResponse struct {
	*responses.BaseResponse
	RequestId string                                `json:"RequestId" xml:"RequestId"`
	Template  ExportContainerGroupTemplateTemplate0 `json:"Template" xml:"Template"`
}

type ExportContainerGroupTemplateTemplate0 struct {
	RegionId           string                                 `json:"RegionId" xml:"RegionId"`
	ZoneId             string                                 `json:"ZoneId" xml:"ZoneId"`
	SecurityGroupId    string                                 `json:"SecurityGroupId" xml:"SecurityGroupId"`
	VSwitchId          string                                 `json:"VSwitchId" xml:"VSwitchId"`
	ResourceGroupId    string                                 `json:"ResourceGroupId" xml:"ResourceGroupId"`
	EipInstanceId      string                                 `json:"EipInstanceId" xml:"EipInstanceId"`
	ContainerGroupName string                                 `json:"ContainerGroupName" xml:"ContainerGroupName"`
	InstanceType       string                                 `json:"InstanceType" xml:"InstanceType"`
	Tags               []ExportContainerGroupTemplateTag1     `json:"Tags" xml:"Tags"`
	Resources          ExportContainerGroupTemplateResources1 `json:"Resources" xml:"Resources"`
	Spec               ExportContainerGroupTemplateSpec1      `json:"Spec" xml:"Spec"`
}

type ExportContainerGroupTemplateTag1 struct {
	Key   string `json:"Key" xml:"Key"`
	Value string `json:"Value" xml:"Value"`
}

type ExportContainerGroupTemplateResources1 struct {
	Cpu    float32 `json:"Cpu" xml:"Cpu"`
	Memory float32 `json:"Memory" xml:"Memory"`
}

type ExportContainerGroupTemplateSpec1 struct {
	RestartPolicy   string                                       `json:"RestartPolicy" xml:"RestartPolicy"`
	DnsPolicy       string                                       `json:"DnsPolicy" xml:"DnsPolicy"`
	Volumes         []ExportContainerGroupTemplateVolume2        `json:"Volumes" xml:"Volumes"`
	InitContainers  []ExportContainerGroupTemplateInitContainer2 `json:"InitContainers" xml:"InitContainers"`
	Containers      []ExportContainerGroupTemplateContainers2    `json:"Containers" xml:"Containers"`
	DnsConfig       ExportContainerGroupTemplateDnsConfig2       `json:"DnsConfig" xml:"DnsConfig"`
	SecurityContext ExportContainerGroupTemplateSecurityContext2 `json:"SecurityContext" xml:"SecurityContext"`
}

type ExportContainerGroupTemplateVolume2 struct {
	Name       string                                  `json:"Name" xml:"Name"`
	ConfigFile ExportContainerGroupTemplateConfigFile3 `json:"ConfigFile" xml:"ConfigFile"`
	EmptyDir   ExportContainerGroupTemplateEmptyDir3   `json:"EmptyDir" xml:"EmptyDir"`
	Nfs        ExportContainerGroupTemplateNfs3        `json:"Nfs" xml:"Nfs"`
}

type ExportContainerGroupTemplateConfigFile3 struct {
	DefaultMode int                                 `json:"DefaultMode" xml:"DefaultMode"`
	Items       []ExportContainerGroupTemplateItem4 `json:"Items" xml:"Items"`
}

type ExportContainerGroupTemplateItem4 struct {
	Mode    int    `json:"Mode" xml:"Mode"`
	Path    string `json:"Path" xml:"Path"`
	Content string `json:"Content" xml:"Content"`
}

type ExportContainerGroupTemplateEmptyDir3 struct {
	SizeLimit string `json:"SizeLimit" xml:"SizeLimit"`
}

type ExportContainerGroupTemplateNfs3 struct {
	Server   string `json:"Server" xml:"Server"`
	Path     string `json:"Path" xml:"Path"`
	ReadOnly bool   `json:"ReadOnly" xml:"ReadOnly"`
}

type ExportContainerGroupTemplateInitContainer2 struct {
	Name            string                                       `json:"Name" xml:"Name"`
	Image           string                                       `json:"Image" xml:"Image"`
	ImagePullPolicy string                                       `json:"ImagePullPolicy" xml:"ImagePullPolicy"`
	Stdin           bool                                         `json:"Stdin" xml:"Stdin"`
	StdinOnce       bool                                         `json:"StdinOnce" xml:"StdinOnce"`
	Tty             bool                                         `json:"Tty" xml:"Tty"`
	WorkingDir      string                                       `json:"WorkingDir" xml:"WorkingDir"`
	Env             []ExportContainerGroupTemplateEnv3           `json:"Env" xml:"Env"`
	Ports           []ExportContainerGroupTemplatePort3          `json:"Ports" xml:"Ports"`
	VolumeMounts    []ExportContainerGroupTemplateVolumeMount3   `json:"VolumeMounts" xml:"VolumeMounts"`
	Command         []string                                     `json:"Command" xml:"Command"`
	Args            []string                                     `json:"Args" xml:"Args"`
	SecurityContext ExportContainerGroupTemplateSecurityContext3 `json:"SecurityContext" xml:"SecurityContext"`
	Resources       ExportContainerGroupTemplateResources3       `json:"Resources" xml:"Resources"`
}

type ExportContainerGroupTemplateEnv3 struct {
	Name      string                                 `json:"Name" xml:"Name"`
	Value     string                                 `json:"Value" xml:"Value"`
	ValueFrom ExportContainerGroupTemplateValueFrom4 `json:"ValueFrom" xml:"ValueFrom"`
}

type ExportContainerGroupTemplateValueFrom4 struct {
	FieldRef ExportContainerGroupTemplateFieldRef5 `json:"FieldRef" xml:"FieldRef"`
}

type ExportContainerGroupTemplateFieldRef5 struct {
	FieldPath string `json:"FieldPath" xml:"FieldPath"`
}

type ExportContainerGroupTemplatePort3 struct {
	Name          string `json:"Name" xml:"Name"`
	Protocol      string `json:"Protocol" xml:"Protocol"`
	ContainerPort int    `json:"ContainerPort" xml:"ContainerPort"`
}

type ExportContainerGroupTemplateVolumeMount3 struct {
	Name      string `json:"Name" xml:"Name"`
	SubPath   string `json:"SubPath" xml:"SubPath"`
	MountPath string `json:"MountPath" xml:"MountPath"`
	ReadOnly  bool   `json:"ReadOnly" xml:"ReadOnly"`
}

type ExportContainerGroupTemplateSecurityContext3 struct {
	Sysctls []ExportContainerGroupTemplateSysctl4 `json:"Sysctls" xml:"Sysctls"`
}

type ExportContainerGroupTemplateSysctl4 struct {
	Name  string `json:"Name" xml:"Name"`
	Value string `json:"Value" xml:"Value"`
}

type ExportContainerGroupTemplateResources3 struct {
	Cpu    float32 `json:"Cpu" xml:"Cpu"`
	Memory float32 `json:"Memory" xml:"Memory"`
}

type ExportContainerGroupTemplateContainers2 struct {
	Name            string                                       `json:"Name" xml:"Name"`
	Image           string                                       `json:"Image" xml:"Image"`
	ImagePullPolicy string                                       `json:"ImagePullPolicy" xml:"ImagePullPolicy"`
	Stdin           bool                                         `json:"Stdin" xml:"Stdin"`
	StdinOnce       bool                                         `json:"StdinOnce" xml:"StdinOnce"`
	Tty             bool                                         `json:"Tty" xml:"Tty"`
	WorkingDir      string                                       `json:"WorkingDir" xml:"WorkingDir"`
	Env             []ExportContainerGroupTemplateEnv3           `json:"Env" xml:"Env"`
	Ports           []ExportContainerGroupTemplatePort3          `json:"Ports" xml:"Ports"`
	VolumeMounts    []ExportContainerGroupTemplateVolumeMount3   `json:"VolumeMounts" xml:"VolumeMounts"`
	Command         []string                                     `json:"Command" xml:"Command"`
	Args            []string                                     `json:"Args" xml:"Args"`
	SecurityContext ExportContainerGroupTemplateSecurityContext3 `json:"SecurityContext" xml:"SecurityContext"`
	Resources       ExportContainerGroupTemplateResources3       `json:"Resources" xml:"Resources"`
	ReadinessProbe  ExportContainerGroupTemplateReadinessProbe3  `json:"ReadinessProbe" xml:"ReadinessProbe"`
	LivenessProbe   ExportContainerGroupTemplateLivenessProbe3   `json:"LivenessProbe" xml:"LivenessProbe"`
}

type ExportContainerGroupTemplateReadinessProbe3 struct {
	InitialDelaySeconds int                                    `json:"InitialDelaySeconds" xml:"InitialDelaySeconds"`
	PeriodSeconds       int                                    `json:"PeriodSeconds" xml:"PeriodSeconds"`
	SuccessThreshold    int                                    `json:"SuccessThreshold" xml:"SuccessThreshold"`
	FailureThreshold    int                                    `json:"FailureThreshold" xml:"FailureThreshold"`
	TimeoutSeconds      int                                    `json:"TimeoutSeconds" xml:"TimeoutSeconds"`
	Exec                ExportContainerGroupTemplateExec4      `json:"Exec" xml:"Exec"`
	TcpSocket           ExportContainerGroupTemplateTcpSocket4 `json:"TcpSocket" xml:"TcpSocket"`
	HttpGet             ExportContainerGroupTemplateHttpGet4   `json:"HttpGet" xml:"HttpGet"`
}

type ExportContainerGroupTemplateExec4 struct {
	Command []string `json:"Command" xml:"Command"`
}

type ExportContainerGroupTemplateTcpSocket4 struct {
	Port int `json:"Port" xml:"Port"`
}

type ExportContainerGroupTemplateHttpGet4 struct {
	Scheme string `json:"Scheme" xml:"Scheme"`
	Path   string `json:"Path" xml:"Path"`
	Port   int    `json:"Port" xml:"Port"`
}

type ExportContainerGroupTemplateLivenessProbe3 struct {
	InitialDelaySeconds int                                    `json:"InitialDelaySeconds" xml:"InitialDelaySeconds"`
	PeriodSeconds       int                                    `json:"PeriodSeconds" xml:"PeriodSeconds"`
	SuccessThreshold    int                                    `json:"SuccessThreshold" xml:"SuccessThreshold"`
	FailureThreshold    int                                    `json:"FailureThreshold" xml:"FailureThreshold"`
	TimeoutSeconds      int                                    `json:"TimeoutSeconds" xml:"TimeoutSeconds"`
	Exec                ExportContainerGroupTemplateExec4      `json:"Exec" xml:"Exec"`
	TcpSocket           ExportContainerGroupTemplateTcpSocket4 `json:"TcpSocket" xml:"TcpSocket"`
	HttpGet             ExportContainerGroupTemplateHttpGet4   `json:"HttpGet" xml:"HttpGet"`
}

type ExportContainerGroupTemplateDnsConfig2 struct {
	Options     []ExportContainerGroupTemplateOption3 `json:"Options" xml:"Options"`
	NameServers []string                              `json:"NameServers" xml:"NameServers"`
	Searches    []string                              `json:"Searches" xml:"Searches"`
}

type ExportContainerGroupTemplateOption3 struct {
	Name  string `json:"Name" xml:"Name"`
	Value string `json:"Value" xml:"Value"`
}

type ExportContainerGroupTemplateSecurityContext2 struct {
	Sysctls []ExportContainerGroupTemplateSysctl3 `json:"Sysctls" xml:"Sysctls"`
}

type ExportContainerGroupTemplateSysctl3 struct {
	Name  string `json:"Name" xml:"Name"`
	Value string `json:"Value" xml:"Value"`
}

// CreateExportContainerGroupTemplateRequest creates a request to invoke ExportContainerGroupTemplate API
func CreateExportContainerGroupTemplateRequest() (request *ExportContainerGroupTemplateRequest) {
	request = &ExportContainerGroupTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eci", "2018-08-08", "ExportContainerGroupTemplate", "eci", "openAPI")
	return
}

// CreateExportContainerGroupTemplateResponse creates a response to parse from ExportContainerGroupTemplate response
func CreateExportContainerGroupTemplateResponse() (response *ExportContainerGroupTemplateResponse) {
	response = &ExportContainerGroupTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
