package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeReservedResource invokes the ens.DescribeReservedResource API synchronously
func (client *Client) DescribeReservedResource(request *DescribeReservedResourceRequest) (response *DescribeReservedResourceResponse, err error) {
	response = CreateDescribeReservedResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeReservedResourceWithChan invokes the ens.DescribeReservedResource API asynchronously
func (client *Client) DescribeReservedResourceWithChan(request *DescribeReservedResourceRequest) (<-chan *DescribeReservedResourceResponse, <-chan error) {
	responseChan := make(chan *DescribeReservedResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeReservedResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeReservedResourceWithCallback invokes the ens.DescribeReservedResource API asynchronously
func (client *Client) DescribeReservedResourceWithCallback(request *DescribeReservedResourceRequest, callback func(response *DescribeReservedResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeReservedResourceResponse
		var err error
		defer close(result)
		response, err = client.DescribeReservedResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeReservedResourceRequest is the request struct for api DescribeReservedResource
type DescribeReservedResourceRequest struct {
	*requests.RpcRequest
}

// DescribeReservedResourceResponse is the response struct for api DescribeReservedResource
type DescribeReservedResourceResponse struct {
	*responses.BaseResponse
	RequestId        string                                     `json:"RequestId" xml:"RequestId"`
	Code             int                                        `json:"Code" xml:"Code"`
	Images           ImagesInDescribeReservedResource           `json:"Images" xml:"Images"`
	SupportResources SupportResourcesInDescribeReservedResource `json:"SupportResources" xml:"SupportResources"`
}

// CreateDescribeReservedResourceRequest creates a request to invoke DescribeReservedResource API
func CreateDescribeReservedResourceRequest() (request *DescribeReservedResourceRequest) {
	request = &DescribeReservedResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeReservedResource", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeReservedResourceResponse creates a response to parse from DescribeReservedResource response
func CreateDescribeReservedResourceResponse() (response *DescribeReservedResourceResponse) {
	response = &DescribeReservedResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
