package saf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RequestDecision invokes the saf.RequestDecision API synchronously
func (client *Client) RequestDecision(request *RequestDecisionRequest) (response *RequestDecisionResponse, err error) {
	response = CreateRequestDecisionResponse()
	err = client.DoAction(request, response)
	return
}

// RequestDecisionWithChan invokes the saf.RequestDecision API asynchronously
func (client *Client) RequestDecisionWithChan(request *RequestDecisionRequest) (<-chan *RequestDecisionResponse, <-chan error) {
	responseChan := make(chan *RequestDecisionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RequestDecision(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RequestDecisionWithCallback invokes the saf.RequestDecision API asynchronously
func (client *Client) RequestDecisionWithCallback(request *RequestDecisionRequest, callback func(response *RequestDecisionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RequestDecisionResponse
		var err error
		defer close(result)
		response, err = client.RequestDecision(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RequestDecisionRequest is the request struct for api RequestDecision
type RequestDecisionRequest struct {
	*requests.RpcRequest
	ServiceParameters string `position:"Query" name:"ServiceParameters"`
	EventCode         string `position:"Query" name:"EventCode"`
}

// RequestDecisionResponse is the response struct for api RequestDecision
type RequestDecisionResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Code      int64                  `json:"Code" xml:"Code"`
	Message   string                 `json:"Message" xml:"Message"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateRequestDecisionRequest creates a request to invoke RequestDecision API
func CreateRequestDecisionRequest() (request *RequestDecisionRequest) {
	request = &RequestDecisionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("saf", "2019-05-21", "RequestDecision", "", "")
	request.Method = requests.POST
	return
}

// CreateRequestDecisionResponse creates a response to parse from RequestDecision response
func CreateRequestDecisionResponse() (response *RequestDecisionResponse) {
	response = &RequestDecisionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
