package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunDiagnosis invokes the servicemesh.RunDiagnosis API synchronously
func (client *Client) RunDiagnosis(request *RunDiagnosisRequest) (response *RunDiagnosisResponse, err error) {
	response = CreateRunDiagnosisResponse()
	err = client.DoAction(request, response)
	return
}

// RunDiagnosisWithChan invokes the servicemesh.RunDiagnosis API asynchronously
func (client *Client) RunDiagnosisWithChan(request *RunDiagnosisRequest) (<-chan *RunDiagnosisResponse, <-chan error) {
	responseChan := make(chan *RunDiagnosisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunDiagnosis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunDiagnosisWithCallback invokes the servicemesh.RunDiagnosis API asynchronously
func (client *Client) RunDiagnosisWithCallback(request *RunDiagnosisRequest, callback func(response *RunDiagnosisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunDiagnosisResponse
		var err error
		defer close(result)
		response, err = client.RunDiagnosis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunDiagnosisRequest is the request struct for api RunDiagnosis
type RunDiagnosisRequest struct {
	*requests.RpcRequest
	ServiceMeshId string `position:"Body" name:"ServiceMeshId"`
}

// RunDiagnosisResponse is the response struct for api RunDiagnosis
type RunDiagnosisResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateRunDiagnosisRequest creates a request to invoke RunDiagnosis API
func CreateRunDiagnosisRequest() (request *RunDiagnosisRequest) {
	request = &RunDiagnosisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "RunDiagnosis", "servicemesh", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRunDiagnosisResponse creates a response to parse from RunDiagnosis response
func CreateRunDiagnosisResponse() (response *RunDiagnosisResponse) {
	response = &RunDiagnosisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
