package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNatIp invokes the vpc.DeleteNatIp API synchronously
func (client *Client) DeleteNatIp(request *DeleteNatIpRequest) (response *DeleteNatIpResponse, err error) {
	response = CreateDeleteNatIpResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNatIpWithChan invokes the vpc.DeleteNatIp API asynchronously
func (client *Client) DeleteNatIpWithChan(request *DeleteNatIpRequest) (<-chan *DeleteNatIpResponse, <-chan error) {
	responseChan := make(chan *DeleteNatIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNatIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNatIpWithCallback invokes the vpc.DeleteNatIp API asynchronously
func (client *Client) DeleteNatIpWithCallback(request *DeleteNatIpRequest, callback func(response *DeleteNatIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNatIpResponse
		var err error
		defer close(result)
		response, err = client.DeleteNatIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNatIpRequest is the request struct for api DeleteNatIp
type DeleteNatIpRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	NatIpId              string           `position:"Query" name:"NatIpId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteNatIpResponse is the response struct for api DeleteNatIp
type DeleteNatIpResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNatIpRequest creates a request to invoke DeleteNatIp API
func CreateDeleteNatIpRequest() (request *DeleteNatIpRequest) {
	request = &DeleteNatIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteNatIp", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteNatIpResponse creates a response to parse from DeleteNatIp response
func CreateDeleteNatIpResponse() (response *DeleteNatIpResponse) {
	response = &DeleteNatIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
