;;; nerd-icons-data-mdicon.el --- glyphset mdicon -*- lexical-binding: t -*-

;; Copyright (C) 2023 Hongyu Ding <rainstormstudio@yahoo.com>

;; Author: Hongyu Ding <rainstormstudio@yahoo.com>
;; Keywords: lisp

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; mdicon
;; from Nerd Font Version: 3.0.2

;;; Code:

(defvar nerd-icons/mdicon-alist
  '(
    ("nf-md-ab_testing" . "\xf01c9")
    ("nf-md-abacus" . "\xf16e0")
    ("nf-md-abjad_arabic" . "\xf1328")
    ("nf-md-abjad_hebrew" . "\xf1329")
    ("nf-md-abugida_devanagari" . "\xf132a")
    ("nf-md-abugida_thai" . "\xf132b")
    ("nf-md-access_point" . "\xf0003")
    ("nf-md-access_point_check" . "\xf1538")
    ("nf-md-access_point_minus" . "\xf1539")
    ("nf-md-access_point_network" . "\xf0002")
    ("nf-md-access_point_network_off" . "\xf0be1")
    ("nf-md-access_point_off" . "\xf1511")
    ("nf-md-access_point_plus" . "\xf153a")
    ("nf-md-access_point_remove" . "\xf153b")
    ("nf-md-account" . "\xf0004")
    ("nf-md-account_alert" . "\xf0005")
    ("nf-md-account_alert_outline" . "\xf0b50")
    ("nf-md-account_arrow_down" . "\xf1868")
    ("nf-md-account_arrow_down_outline" . "\xf1869")
    ("nf-md-account_arrow_left" . "\xf0b51")
    ("nf-md-account_arrow_left_outline" . "\xf0b52")
    ("nf-md-account_arrow_right" . "\xf0b53")
    ("nf-md-account_arrow_right_outline" . "\xf0b54")
    ("nf-md-account_arrow_up" . "\xf1867")
    ("nf-md-account_arrow_up_outline" . "\xf186a")
    ("nf-md-account_box" . "\xf0006")
    ("nf-md-account_box_multiple" . "\xf0934")
    ("nf-md-account_box_multiple_outline" . "\xf100a")
    ("nf-md-account_box_outline" . "\xf0007")
    ("nf-md-account_cancel" . "\xf12df")
    ("nf-md-account_cancel_outline" . "\xf12e0")
    ("nf-md-account_cash" . "\xf1097")
    ("nf-md-account_cash_outline" . "\xf1098")
    ("nf-md-account_check" . "\xf0008")
    ("nf-md-account_check_outline" . "\xf0be2")
    ("nf-md-account_child" . "\xf0a89")
    ("nf-md-account_child_circle" . "\xf0a8a")
    ("nf-md-account_child_outline" . "\xf10c8")
    ("nf-md-account_circle" . "\xf0009")
    ("nf-md-account_circle_outline" . "\xf0b55")
    ("nf-md-account_clock" . "\xf0b56")
    ("nf-md-account_clock_outline" . "\xf0b57")
    ("nf-md-account_cog" . "\xf1370")
    ("nf-md-account_cog_outline" . "\xf1371")
    ("nf-md-account_convert" . "\xf000a")
    ("nf-md-account_convert_outline" . "\xf1301")
    ("nf-md-account_cowboy_hat" . "\xf0e9b")
    ("nf-md-account_cowboy_hat_outline" . "\xf17f3")
    ("nf-md-account_details" . "\xf0631")
    ("nf-md-account_details_outline" . "\xf1372")
    ("nf-md-account_edit" . "\xf06bc")
    ("nf-md-account_edit_outline" . "\xf0ffb")
    ("nf-md-account_eye" . "\xf0420")
    ("nf-md-account_eye_outline" . "\xf127b")
    ("nf-md-account_filter" . "\xf0936")
    ("nf-md-account_filter_outline" . "\xf0f9d")
    ("nf-md-account_group" . "\xf0849")
    ("nf-md-account_group_outline" . "\xf0b58")
    ("nf-md-account_hard_hat" . "\xf05b5")
    ("nf-md-account_hard_hat_outline" . "\xf1a1f")
    ("nf-md-account_heart" . "\xf0899")
    ("nf-md-account_heart_outline" . "\xf0be3")
    ("nf-md-account_injury" . "\xf1815")
    ("nf-md-account_injury_outline" . "\xf1816")
    ("nf-md-account_key" . "\xf000b")
    ("nf-md-account_key_outline" . "\xf0be4")
    ("nf-md-account_lock" . "\xf115e")
    ("nf-md-account_lock_open" . "\xf1960")
    ("nf-md-account_lock_open_outline" . "\xf1961")
    ("nf-md-account_lock_outline" . "\xf115f")
    ("nf-md-account_minus" . "\xf000d")
    ("nf-md-account_minus_outline" . "\xf0aec")
    ("nf-md-account_multiple" . "\xf000e")
    ("nf-md-account_multiple_check" . "\xf08c5")
    ("nf-md-account_multiple_check_outline" . "\xf11fe")
    ("nf-md-account_multiple_minus" . "\xf05d3")
    ("nf-md-account_multiple_minus_outline" . "\xf0be5")
    ("nf-md-account_multiple_outline" . "\xf000f")
    ("nf-md-account_multiple_plus" . "\xf0010")
    ("nf-md-account_multiple_plus_outline" . "\xf0800")
    ("nf-md-account_multiple_remove" . "\xf120a")
    ("nf-md-account_multiple_remove_outline" . "\xf120b")
    ("nf-md-account_music" . "\xf0803")
    ("nf-md-account_music_outline" . "\xf0ce9")
    ("nf-md-account_network" . "\xf0011")
    ("nf-md-account_network_outline" . "\xf0be6")
    ("nf-md-account_off" . "\xf0012")
    ("nf-md-account_off_outline" . "\xf0be7")
    ("nf-md-account_outline" . "\xf0013")
    ("nf-md-account_plus" . "\xf0014")
    ("nf-md-account_plus_outline" . "\xf0801")
    ("nf-md-account_question" . "\xf0b59")
    ("nf-md-account_question_outline" . "\xf0b5a")
    ("nf-md-account_reactivate" . "\xf152b")
    ("nf-md-account_reactivate_outline" . "\xf152c")
    ("nf-md-account_remove" . "\xf0015")
    ("nf-md-account_remove_outline" . "\xf0aed")
    ("nf-md-account_school" . "\xf1a20")
    ("nf-md-account_school_outline" . "\xf1a21")
    ("nf-md-account_search" . "\xf0016")
    ("nf-md-account_search_outline" . "\xf0935")
    ("nf-md-account_settings" . "\xf0630")
    ("nf-md-account_settings_outline" . "\xf10c9")
    ("nf-md-account_star" . "\xf0017")
    ("nf-md-account_star_outline" . "\xf0be8")
    ("nf-md-account_supervisor" . "\xf0a8b")
    ("nf-md-account_supervisor_circle" . "\xf0a8c")
    ("nf-md-account_supervisor_circle_outline" . "\xf14ec")
    ("nf-md-account_supervisor_outline" . "\xf112d")
    ("nf-md-account_switch" . "\xf0019")
    ("nf-md-account_switch_outline" . "\xf04cb")
    ("nf-md-account_sync" . "\xf191b")
    ("nf-md-account_sync_outline" . "\xf191c")
    ("nf-md-account_tie" . "\xf0ce3")
    ("nf-md-account_tie_hat" . "\xf1898")
    ("nf-md-account_tie_hat_outline" . "\xf1899")
    ("nf-md-account_tie_outline" . "\xf10ca")
    ("nf-md-account_tie_voice" . "\xf1308")
    ("nf-md-account_tie_voice_off" . "\xf130a")
    ("nf-md-account_tie_voice_off_outline" . "\xf130b")
    ("nf-md-account_tie_voice_outline" . "\xf1309")
    ("nf-md-account_tie_woman" . "\xf1a8c")
    ("nf-md-account_voice" . "\xf05cb")
    ("nf-md-account_voice_off" . "\xf0ed4")
    ("nf-md-account_wrench" . "\xf189a")
    ("nf-md-account_wrench_outline" . "\xf189b")
    ("nf-md-adjust" . "\xf001a")
    ("nf-md-advertisements" . "\xf192a")
    ("nf-md-advertisements_off" . "\xf192b")
    ("nf-md-air_conditioner" . "\xf001b")
    ("nf-md-air_filter" . "\xf0d43")
    ("nf-md-air_horn" . "\xf0dac")
    ("nf-md-air_humidifier" . "\xf1099")
    ("nf-md-air_humidifier_off" . "\xf1466")
    ("nf-md-air_purifier" . "\xf0d44")
    ("nf-md-airbag" . "\xf0be9")
    ("nf-md-airballoon" . "\xf001c")
    ("nf-md-airballoon_outline" . "\xf100b")
    ("nf-md-airplane" . "\xf001d")
    ("nf-md-airplane_alert" . "\xf187a")
    ("nf-md-airplane_check" . "\xf187b")
    ("nf-md-airplane_clock" . "\xf187c")
    ("nf-md-airplane_cog" . "\xf187d")
    ("nf-md-airplane_edit" . "\xf187e")
    ("nf-md-airplane_landing" . "\xf05d4")
    ("nf-md-airplane_marker" . "\xf187f")
    ("nf-md-airplane_minus" . "\xf1880")
    ("nf-md-airplane_off" . "\xf001e")
    ("nf-md-airplane_plus" . "\xf1881")
    ("nf-md-airplane_remove" . "\xf1882")
    ("nf-md-airplane_search" . "\xf1883")
    ("nf-md-airplane_settings" . "\xf1884")
    ("nf-md-airplane_takeoff" . "\xf05d5")
    ("nf-md-airport" . "\xf084b")
    ("nf-md-alarm" . "\xf0020")
    ("nf-md-alarm_bell" . "\xf078e")
    ("nf-md-alarm_check" . "\xf0021")
    ("nf-md-alarm_light" . "\xf078f")
    ("nf-md-alarm_light_off" . "\xf171e")
    ("nf-md-alarm_light_off_outline" . "\xf171f")
    ("nf-md-alarm_light_outline" . "\xf0bea")
    ("nf-md-alarm_multiple" . "\xf0022")
    ("nf-md-alarm_note" . "\xf0e71")
    ("nf-md-alarm_note_off" . "\xf0e72")
    ("nf-md-alarm_off" . "\xf0023")
    ("nf-md-alarm_panel" . "\xf15c4")
    ("nf-md-alarm_panel_outline" . "\xf15c5")
    ("nf-md-alarm_plus" . "\xf0024")
    ("nf-md-alarm_snooze" . "\xf068e")
    ("nf-md-album" . "\xf0025")
    ("nf-md-alert" . "\xf0026")
    ("nf-md-alert_box" . "\xf0027")
    ("nf-md-alert_box_outline" . "\xf0ce4")
    ("nf-md-alert_circle" . "\xf0028")
    ("nf-md-alert_circle_check" . "\xf11ed")
    ("nf-md-alert_circle_check_outline" . "\xf11ee")
    ("nf-md-alert_circle_outline" . "\xf05d6")
    ("nf-md-alert_decagram" . "\xf06bd")
    ("nf-md-alert_decagram_outline" . "\xf0ce5")
    ("nf-md-alert_minus" . "\xf14bb")
    ("nf-md-alert_minus_outline" . "\xf14be")
    ("nf-md-alert_octagon" . "\xf0029")
    ("nf-md-alert_octagon_outline" . "\xf0ce6")
    ("nf-md-alert_octagram" . "\xf0767")
    ("nf-md-alert_octagram_outline" . "\xf0ce7")
    ("nf-md-alert_outline" . "\xf002a")
    ("nf-md-alert_plus" . "\xf14ba")
    ("nf-md-alert_plus_outline" . "\xf14bd")
    ("nf-md-alert_remove" . "\xf14bc")
    ("nf-md-alert_remove_outline" . "\xf14bf")
    ("nf-md-alert_rhombus" . "\xf11ce")
    ("nf-md-alert_rhombus_outline" . "\xf11cf")
    ("nf-md-alien" . "\xf089a")
    ("nf-md-alien_outline" . "\xf10cb")
    ("nf-md-align_horizontal_center" . "\xf11c3")
    ("nf-md-align_horizontal_distribute" . "\xf1962")
    ("nf-md-align_horizontal_left" . "\xf11c2")
    ("nf-md-align_horizontal_right" . "\xf11c4")
    ("nf-md-align_vertical_bottom" . "\xf11c5")
    ("nf-md-align_vertical_center" . "\xf11c6")
    ("nf-md-align_vertical_distribute" . "\xf1963")
    ("nf-md-align_vertical_top" . "\xf11c7")
    ("nf-md-all_inclusive" . "\xf06be")
    ("nf-md-all_inclusive_box" . "\xf188d")
    ("nf-md-all_inclusive_box_outline" . "\xf188e")
    ("nf-md-allergy" . "\xf1258")
    ("nf-md-alpha" . "\xf002b")
    ("nf-md-alpha_a" . "\xf0aee")
    ("nf-md-alpha_a_box" . "\xf0b08")
    ("nf-md-alpha_a_box_outline" . "\xf0beb")
    ("nf-md-alpha_a_circle" . "\xf0bec")
    ("nf-md-alpha_a_circle_outline" . "\xf0bed")
    ("nf-md-alpha_b" . "\xf0aef")
    ("nf-md-alpha_b_box" . "\xf0b09")
    ("nf-md-alpha_b_box_outline" . "\xf0bee")
    ("nf-md-alpha_b_circle" . "\xf0bef")
    ("nf-md-alpha_b_circle_outline" . "\xf0bf0")
    ("nf-md-alpha_c" . "\xf0af0")
    ("nf-md-alpha_c_box" . "\xf0b0a")
    ("nf-md-alpha_c_box_outline" . "\xf0bf1")
    ("nf-md-alpha_c_circle" . "\xf0bf2")
    ("nf-md-alpha_c_circle_outline" . "\xf0bf3")
    ("nf-md-alpha_d" . "\xf0af1")
    ("nf-md-alpha_d_box" . "\xf0b0b")
    ("nf-md-alpha_d_box_outline" . "\xf0bf4")
    ("nf-md-alpha_d_circle" . "\xf0bf5")
    ("nf-md-alpha_d_circle_outline" . "\xf0bf6")
    ("nf-md-alpha_e" . "\xf0af2")
    ("nf-md-alpha_e_box" . "\xf0b0c")
    ("nf-md-alpha_e_box_outline" . "\xf0bf7")
    ("nf-md-alpha_e_circle" . "\xf0bf8")
    ("nf-md-alpha_e_circle_outline" . "\xf0bf9")
    ("nf-md-alpha_f" . "\xf0af3")
    ("nf-md-alpha_f_box" . "\xf0b0d")
    ("nf-md-alpha_f_box_outline" . "\xf0bfa")
    ("nf-md-alpha_f_circle" . "\xf0bfb")
    ("nf-md-alpha_f_circle_outline" . "\xf0bfc")
    ("nf-md-alpha_g" . "\xf0af4")
    ("nf-md-alpha_g_box" . "\xf0b0e")
    ("nf-md-alpha_g_box_outline" . "\xf0bfd")
    ("nf-md-alpha_g_circle" . "\xf0bfe")
    ("nf-md-alpha_g_circle_outline" . "\xf0bff")
    ("nf-md-alpha_h" . "\xf0af5")
    ("nf-md-alpha_h_box" . "\xf0b0f")
    ("nf-md-alpha_h_box_outline" . "\xf0c00")
    ("nf-md-alpha_h_circle" . "\xf0c01")
    ("nf-md-alpha_h_circle_outline" . "\xf0c02")
    ("nf-md-alpha_i" . "\xf1088")
    ("nf-md-alpha_i_box" . "\xf0b10")
    ("nf-md-alpha_i_box_outline" . "\xf0c03")
    ("nf-md-alpha_i_circle" . "\xf0c04")
    ("nf-md-alpha_i_circle_outline" . "\xf0c05")
    ("nf-md-alpha_j" . "\xf0af7")
    ("nf-md-alpha_j_box" . "\xf0b11")
    ("nf-md-alpha_j_box_outline" . "\xf0c06")
    ("nf-md-alpha_j_circle" . "\xf0c07")
    ("nf-md-alpha_j_circle_outline" . "\xf0c08")
    ("nf-md-alpha_k" . "\xf0af8")
    ("nf-md-alpha_k_box" . "\xf0b12")
    ("nf-md-alpha_k_box_outline" . "\xf0c09")
    ("nf-md-alpha_k_circle" . "\xf0c0a")
    ("nf-md-alpha_k_circle_outline" . "\xf0c0b")
    ("nf-md-alpha_l" . "\xf13a6")
    ("nf-md-alpha_l_box" . "\xf0b13")
    ("nf-md-alpha_l_box_outline" . "\xf0c0c")
    ("nf-md-alpha_l_circle" . "\xf0c0d")
    ("nf-md-alpha_l_circle_outline" . "\xf0c0e")
    ("nf-md-alpha_m" . "\xf0afa")
    ("nf-md-alpha_m_box" . "\xf0b14")
    ("nf-md-alpha_m_box_outline" . "\xf0c0f")
    ("nf-md-alpha_m_circle" . "\xf0c10")
    ("nf-md-alpha_m_circle_outline" . "\xf0c11")
    ("nf-md-alpha_n" . "\xf0afb")
    ("nf-md-alpha_n_box" . "\xf0b15")
    ("nf-md-alpha_n_box_outline" . "\xf0c12")
    ("nf-md-alpha_n_circle" . "\xf0c13")
    ("nf-md-alpha_n_circle_outline" . "\xf0c14")
    ("nf-md-alpha_o" . "\xf0b39")
    ("nf-md-alpha_o_box" . "\xf0b16")
    ("nf-md-alpha_o_box_outline" . "\xf0c15")
    ("nf-md-alpha_o_circle" . "\xf0c9e")
    ("nf-md-alpha_o_circle_outline" . "\xf0c9f")
    ("nf-md-alpha_p" . "\xf0afd")
    ("nf-md-alpha_p_box" . "\xf0b17")
    ("nf-md-alpha_p_box_outline" . "\xf0c18")
    ("nf-md-alpha_p_circle" . "\xf0c19")
    ("nf-md-alpha_p_circle_outline" . "\xf0c1a")
    ("nf-md-alpha_q" . "\xf0afe")
    ("nf-md-alpha_q_box" . "\xf0b18")
    ("nf-md-alpha_q_box_outline" . "\xf0c1b")
    ("nf-md-alpha_q_circle" . "\xf0c1c")
    ("nf-md-alpha_q_circle_outline" . "\xf0c1d")
    ("nf-md-alpha_r" . "\xf0aff")
    ("nf-md-alpha_r_box" . "\xf0b19")
    ("nf-md-alpha_r_box_outline" . "\xf0c1e")
    ("nf-md-alpha_r_circle" . "\xf0c1f")
    ("nf-md-alpha_r_circle_outline" . "\xf0c20")
    ("nf-md-alpha_s" . "\xf0b00")
    ("nf-md-alpha_s_box" . "\xf0b1a")
    ("nf-md-alpha_s_box_outline" . "\xf0c21")
    ("nf-md-alpha_s_circle" . "\xf0c22")
    ("nf-md-alpha_s_circle_outline" . "\xf0c23")
    ("nf-md-alpha_t" . "\xf0b01")
    ("nf-md-alpha_t_box" . "\xf0b1b")
    ("nf-md-alpha_t_box_outline" . "\xf0c24")
    ("nf-md-alpha_t_circle" . "\xf0c25")
    ("nf-md-alpha_t_circle_outline" . "\xf0c26")
    ("nf-md-alpha_u" . "\xf0b02")
    ("nf-md-alpha_u_box" . "\xf0b1c")
    ("nf-md-alpha_u_box_outline" . "\xf0c27")
    ("nf-md-alpha_u_circle" . "\xf0c28")
    ("nf-md-alpha_u_circle_outline" . "\xf0c29")
    ("nf-md-alpha_v" . "\xf108c")
    ("nf-md-alpha_v_box" . "\xf0b1d")
    ("nf-md-alpha_v_box_outline" . "\xf0c2a")
    ("nf-md-alpha_v_circle" . "\xf0c2b")
    ("nf-md-alpha_v_circle_outline" . "\xf0c2c")
    ("nf-md-alpha_w" . "\xf0b04")
    ("nf-md-alpha_w_box" . "\xf0b1e")
    ("nf-md-alpha_w_box_outline" . "\xf0c2d")
    ("nf-md-alpha_w_circle" . "\xf0c2e")
    ("nf-md-alpha_w_circle_outline" . "\xf0c2f")
    ("nf-md-alpha_x" . "\xf1091")
    ("nf-md-alpha_x_box" . "\xf0b1f")
    ("nf-md-alpha_x_box_outline" . "\xf0c30")
    ("nf-md-alpha_x_circle" . "\xf0c31")
    ("nf-md-alpha_x_circle_outline" . "\xf0c32")
    ("nf-md-alpha_y" . "\xf0b06")
    ("nf-md-alpha_y_box" . "\xf0b20")
    ("nf-md-alpha_y_box_outline" . "\xf0c33")
    ("nf-md-alpha_y_circle" . "\xf0c34")
    ("nf-md-alpha_y_circle_outline" . "\xf0c35")
    ("nf-md-alpha_z" . "\xf0b07")
    ("nf-md-alpha_z_box" . "\xf0b21")
    ("nf-md-alpha_z_box_outline" . "\xf0c36")
    ("nf-md-alpha_z_circle" . "\xf0c37")
    ("nf-md-alpha_z_circle_outline" . "\xf0c38")
    ("nf-md-alphabet_aurebesh" . "\xf132c")
    ("nf-md-alphabet_cyrillic" . "\xf132d")
    ("nf-md-alphabet_greek" . "\xf132e")
    ("nf-md-alphabet_latin" . "\xf132f")
    ("nf-md-alphabet_piqad" . "\xf1330")
    ("nf-md-alphabet_tengwar" . "\xf1337")
    ("nf-md-alphabetical" . "\xf002c")
    ("nf-md-alphabetical_off" . "\xf100c")
    ("nf-md-alphabetical_variant" . "\xf100d")
    ("nf-md-alphabetical_variant_off" . "\xf100e")
    ("nf-md-altimeter" . "\xf05d7")
    ("nf-md-ambulance" . "\xf002f")
    ("nf-md-ammunition" . "\xf0ce8")
    ("nf-md-ampersand" . "\xf0a8d")
    ("nf-md-amplifier" . "\xf0030")
    ("nf-md-amplifier_off" . "\xf11b5")
    ("nf-md-anchor" . "\xf0031")
    ("nf-md-android" . "\xf0032")
    ("nf-md-android_messages" . "\xf0d45")
    ("nf-md-android_studio" . "\xf0034")
    ("nf-md-angle_acute" . "\xf0937")
    ("nf-md-angle_obtuse" . "\xf0938")
    ("nf-md-angle_right" . "\xf0939")
    ("nf-md-angular" . "\xf06b2")
    ("nf-md-angularjs" . "\xf06bf")
    ("nf-md-animation" . "\xf05d8")
    ("nf-md-animation_outline" . "\xf0a8f")
    ("nf-md-animation_play" . "\xf093a")
    ("nf-md-animation_play_outline" . "\xf0a90")
    ("nf-md-ansible" . "\xf109a")
    ("nf-md-antenna" . "\xf1119")
    ("nf-md-anvil" . "\xf089b")
    ("nf-md-apache_kafka" . "\xf100f")
    ("nf-md-api" . "\xf109b")
    ("nf-md-api_off" . "\xf1257")
    ("nf-md-apple" . "\xf0035")
    ("nf-md-apple_finder" . "\xf0036")
    ("nf-md-apple_icloud" . "\xf0038")
    ("nf-md-apple_ios" . "\xf0037")
    ("nf-md-apple_keyboard_caps" . "\xf0632")
    ("nf-md-apple_keyboard_command" . "\xf0633")
    ("nf-md-apple_keyboard_control" . "\xf0634")
    ("nf-md-apple_keyboard_option" . "\xf0635")
    ("nf-md-apple_keyboard_shift" . "\xf0636")
    ("nf-md-apple_safari" . "\xf0039")
    ("nf-md-application" . "\xf08c6")
    ("nf-md-application_array" . "\xf10f5")
    ("nf-md-application_array_outline" . "\xf10f6")
    ("nf-md-application_braces" . "\xf10f7")
    ("nf-md-application_braces_outline" . "\xf10f8")
    ("nf-md-application_brackets" . "\xf0c8b")
    ("nf-md-application_brackets_outline" . "\xf0c8c")
    ("nf-md-application_cog" . "\xf0675")
    ("nf-md-application_cog_outline" . "\xf1577")
    ("nf-md-application_edit" . "\xf00ae")
    ("nf-md-application_edit_outline" . "\xf0619")
    ("nf-md-application_export" . "\xf0dad")
    ("nf-md-application_import" . "\xf0dae")
    ("nf-md-application_outline" . "\xf0614")
    ("nf-md-application_parentheses" . "\xf10f9")
    ("nf-md-application_parentheses_outline" . "\xf10fa")
    ("nf-md-application_settings" . "\xf0b60")
    ("nf-md-application_settings_outline" . "\xf1555")
    ("nf-md-application_variable" . "\xf10fb")
    ("nf-md-application_variable_outline" . "\xf10fc")
    ("nf-md-approximately_equal" . "\xf0f9e")
    ("nf-md-approximately_equal_box" . "\xf0f9f")
    ("nf-md-apps" . "\xf003b")
    ("nf-md-apps_box" . "\xf0d46")
    ("nf-md-arch" . "\xf08c7")
    ("nf-md-archive" . "\xf003c")
    ("nf-md-archive_alert" . "\xf14fd")
    ("nf-md-archive_alert_outline" . "\xf14fe")
    ("nf-md-archive_arrow_down" . "\xf1259")
    ("nf-md-archive_arrow_down_outline" . "\xf125a")
    ("nf-md-archive_arrow_up" . "\xf125b")
    ("nf-md-archive_arrow_up_outline" . "\xf125c")
    ("nf-md-archive_cancel" . "\xf174b")
    ("nf-md-archive_cancel_outline" . "\xf174c")
    ("nf-md-archive_check" . "\xf174d")
    ("nf-md-archive_check_outline" . "\xf174e")
    ("nf-md-archive_clock" . "\xf174f")
    ("nf-md-archive_clock_outline" . "\xf1750")
    ("nf-md-archive_cog" . "\xf1751")
    ("nf-md-archive_cog_outline" . "\xf1752")
    ("nf-md-archive_edit" . "\xf1753")
    ("nf-md-archive_edit_outline" . "\xf1754")
    ("nf-md-archive_eye" . "\xf1755")
    ("nf-md-archive_eye_outline" . "\xf1756")
    ("nf-md-archive_lock" . "\xf1757")
    ("nf-md-archive_lock_open" . "\xf1758")
    ("nf-md-archive_lock_open_outline" . "\xf1759")
    ("nf-md-archive_lock_outline" . "\xf175a")
    ("nf-md-archive_marker" . "\xf175b")
    ("nf-md-archive_marker_outline" . "\xf175c")
    ("nf-md-archive_minus" . "\xf175d")
    ("nf-md-archive_minus_outline" . "\xf175e")
    ("nf-md-archive_music" . "\xf175f")
    ("nf-md-archive_music_outline" . "\xf1760")
    ("nf-md-archive_off" . "\xf1761")
    ("nf-md-archive_off_outline" . "\xf1762")
    ("nf-md-archive_outline" . "\xf120e")
    ("nf-md-archive_plus" . "\xf1763")
    ("nf-md-archive_plus_outline" . "\xf1764")
    ("nf-md-archive_refresh" . "\xf1765")
    ("nf-md-archive_refresh_outline" . "\xf1766")
    ("nf-md-archive_remove" . "\xf1767")
    ("nf-md-archive_remove_outline" . "\xf1768")
    ("nf-md-archive_search" . "\xf1769")
    ("nf-md-archive_search_outline" . "\xf176a")
    ("nf-md-archive_settings" . "\xf176b")
    ("nf-md-archive_settings_outline" . "\xf176c")
    ("nf-md-archive_star" . "\xf176d")
    ("nf-md-archive_star_outline" . "\xf176e")
    ("nf-md-archive_sync" . "\xf176f")
    ("nf-md-archive_sync_outline" . "\xf1770")
    ("nf-md-arm_flex" . "\xf0fd7")
    ("nf-md-arm_flex_outline" . "\xf0fd6")
    ("nf-md-arrange_bring_forward" . "\xf003d")
    ("nf-md-arrange_bring_to_front" . "\xf003e")
    ("nf-md-arrange_send_backward" . "\xf003f")
    ("nf-md-arrange_send_to_back" . "\xf0040")
    ("nf-md-arrow_all" . "\xf0041")
    ("nf-md-arrow_bottom_left" . "\xf0042")
    ("nf-md-arrow_bottom_left_bold_box" . "\xf1964")
    ("nf-md-arrow_bottom_left_bold_box_outline" . "\xf1965")
    ("nf-md-arrow_bottom_left_bold_outline" . "\xf09b7")
    ("nf-md-arrow_bottom_left_thick" . "\xf09b8")
    ("nf-md-arrow_bottom_left_thin" . "\xf19b6")
    ("nf-md-arrow_bottom_left_thin_circle_outline" . "\xf1596")
    ("nf-md-arrow_bottom_right" . "\xf0043")
    ("nf-md-arrow_bottom_right_bold_box" . "\xf1966")
    ("nf-md-arrow_bottom_right_bold_box_outline" . "\xf1967")
    ("nf-md-arrow_bottom_right_bold_outline" . "\xf09b9")
    ("nf-md-arrow_bottom_right_thick" . "\xf09ba")
    ("nf-md-arrow_bottom_right_thin" . "\xf19b7")
    ("nf-md-arrow_bottom_right_thin_circle_outline" . "\xf1595")
    ("nf-md-arrow_collapse" . "\xf0615")
    ("nf-md-arrow_collapse_all" . "\xf0044")
    ("nf-md-arrow_collapse_down" . "\xf0792")
    ("nf-md-arrow_collapse_horizontal" . "\xf084c")
    ("nf-md-arrow_collapse_left" . "\xf0793")
    ("nf-md-arrow_collapse_right" . "\xf0794")
    ("nf-md-arrow_collapse_up" . "\xf0795")
    ("nf-md-arrow_collapse_vertical" . "\xf084d")
    ("nf-md-arrow_decision" . "\xf09bb")
    ("nf-md-arrow_decision_auto" . "\xf09bc")
    ("nf-md-arrow_decision_auto_outline" . "\xf09bd")
    ("nf-md-arrow_decision_outline" . "\xf09be")
    ("nf-md-arrow_down" . "\xf0045")
    ("nf-md-arrow_down_bold" . "\xf072e")
    ("nf-md-arrow_down_bold_box" . "\xf072f")
    ("nf-md-arrow_down_bold_box_outline" . "\xf0730")
    ("nf-md-arrow_down_bold_circle" . "\xf0047")
    ("nf-md-arrow_down_bold_circle_outline" . "\xf0048")
    ("nf-md-arrow_down_bold_hexagon_outline" . "\xf0049")
    ("nf-md-arrow_down_bold_outline" . "\xf09bf")
    ("nf-md-arrow_down_box" . "\xf06c0")
    ("nf-md-arrow_down_circle" . "\xf0cdb")
    ("nf-md-arrow_down_circle_outline" . "\xf0cdc")
    ("nf-md-arrow_down_drop_circle" . "\xf004a")
    ("nf-md-arrow_down_drop_circle_outline" . "\xf004b")
    ("nf-md-arrow_down_left" . "\xf17a1")
    ("nf-md-arrow_down_left_bold" . "\xf17a2")
    ("nf-md-arrow_down_right" . "\xf17a3")
    ("nf-md-arrow_down_right_bold" . "\xf17a4")
    ("nf-md-arrow_down_thick" . "\xf0046")
    ("nf-md-arrow_down_thin" . "\xf19b3")
    ("nf-md-arrow_down_thin_circle_outline" . "\xf1599")
    ("nf-md-arrow_expand" . "\xf0616")
    ("nf-md-arrow_expand_all" . "\xf004c")
    ("nf-md-arrow_expand_down" . "\xf0796")
    ("nf-md-arrow_expand_horizontal" . "\xf084e")
    ("nf-md-arrow_expand_left" . "\xf0797")
    ("nf-md-arrow_expand_right" . "\xf0798")
    ("nf-md-arrow_expand_up" . "\xf0799")
    ("nf-md-arrow_expand_vertical" . "\xf084f")
    ("nf-md-arrow_horizontal_lock" . "\xf115b")
    ("nf-md-arrow_left" . "\xf004d")
    ("nf-md-arrow_left_bold" . "\xf0731")
    ("nf-md-arrow_left_bold_box" . "\xf0732")
    ("nf-md-arrow_left_bold_box_outline" . "\xf0733")
    ("nf-md-arrow_left_bold_circle" . "\xf004f")
    ("nf-md-arrow_left_bold_circle_outline" . "\xf0050")
    ("nf-md-arrow_left_bold_hexagon_outline" . "\xf0051")
    ("nf-md-arrow_left_bold_outline" . "\xf09c0")
    ("nf-md-arrow_left_bottom" . "\xf17a5")
    ("nf-md-arrow_left_bottom_bold" . "\xf17a6")
    ("nf-md-arrow_left_box" . "\xf06c1")
    ("nf-md-arrow_left_circle" . "\xf0cdd")
    ("nf-md-arrow_left_circle_outline" . "\xf0cde")
    ("nf-md-arrow_left_drop_circle" . "\xf0052")
    ("nf-md-arrow_left_drop_circle_outline" . "\xf0053")
    ("nf-md-arrow_left_right" . "\xf0e73")
    ("nf-md-arrow_left_right_bold" . "\xf0e74")
    ("nf-md-arrow_left_right_bold_outline" . "\xf09c1")
    ("nf-md-arrow_left_thick" . "\xf004e")
    ("nf-md-arrow_left_thin" . "\xf19b1")
    ("nf-md-arrow_left_thin_circle_outline" . "\xf159a")
    ("nf-md-arrow_left_top" . "\xf17a7")
    ("nf-md-arrow_left_top_bold" . "\xf17a8")
    ("nf-md-arrow_projectile" . "\xf1840")
    ("nf-md-arrow_projectile_multiple" . "\xf183f")
    ("nf-md-arrow_right" . "\xf0054")
    ("nf-md-arrow_right_bold" . "\xf0734")
    ("nf-md-arrow_right_bold_box" . "\xf0735")
    ("nf-md-arrow_right_bold_box_outline" . "\xf0736")
    ("nf-md-arrow_right_bold_circle" . "\xf0056")
    ("nf-md-arrow_right_bold_circle_outline" . "\xf0057")
    ("nf-md-arrow_right_bold_hexagon_outline" . "\xf0058")
    ("nf-md-arrow_right_bold_outline" . "\xf09c2")
    ("nf-md-arrow_right_bottom" . "\xf17a9")
    ("nf-md-arrow_right_bottom_bold" . "\xf17aa")
    ("nf-md-arrow_right_box" . "\xf06c2")
    ("nf-md-arrow_right_circle" . "\xf0cdf")
    ("nf-md-arrow_right_circle_outline" . "\xf0ce0")
    ("nf-md-arrow_right_drop_circle" . "\xf0059")
    ("nf-md-arrow_right_drop_circle_outline" . "\xf005a")
    ("nf-md-arrow_right_thick" . "\xf0055")
    ("nf-md-arrow_right_thin" . "\xf19b0")
    ("nf-md-arrow_right_thin_circle_outline" . "\xf1598")
    ("nf-md-arrow_right_top" . "\xf17ab")
    ("nf-md-arrow_right_top_bold" . "\xf17ac")
    ("nf-md-arrow_split_horizontal" . "\xf093b")
    ("nf-md-arrow_split_vertical" . "\xf093c")
    ("nf-md-arrow_top_left" . "\xf005b")
    ("nf-md-arrow_top_left_bold_box" . "\xf1968")
    ("nf-md-arrow_top_left_bold_box_outline" . "\xf1969")
    ("nf-md-arrow_top_left_bold_outline" . "\xf09c3")
    ("nf-md-arrow_top_left_bottom_right" . "\xf0e75")
    ("nf-md-arrow_top_left_bottom_right_bold" . "\xf0e76")
    ("nf-md-arrow_top_left_thick" . "\xf09c4")
    ("nf-md-arrow_top_left_thin" . "\xf19b5")
    ("nf-md-arrow_top_left_thin_circle_outline" . "\xf1593")
    ("nf-md-arrow_top_right" . "\xf005c")
    ("nf-md-arrow_top_right_bold_box" . "\xf196a")
    ("nf-md-arrow_top_right_bold_box_outline" . "\xf196b")
    ("nf-md-arrow_top_right_bold_outline" . "\xf09c5")
    ("nf-md-arrow_top_right_bottom_left" . "\xf0e77")
    ("nf-md-arrow_top_right_bottom_left_bold" . "\xf0e78")
    ("nf-md-arrow_top_right_thick" . "\xf09c6")
    ("nf-md-arrow_top_right_thin" . "\xf19b4")
    ("nf-md-arrow_top_right_thin_circle_outline" . "\xf1594")
    ("nf-md-arrow_u_down_left" . "\xf17ad")
    ("nf-md-arrow_u_down_left_bold" . "\xf17ae")
    ("nf-md-arrow_u_down_right" . "\xf17af")
    ("nf-md-arrow_u_down_right_bold" . "\xf17b0")
    ("nf-md-arrow_u_left_bottom" . "\xf17b1")
    ("nf-md-arrow_u_left_bottom_bold" . "\xf17b2")
    ("nf-md-arrow_u_left_top" . "\xf17b3")
    ("nf-md-arrow_u_left_top_bold" . "\xf17b4")
    ("nf-md-arrow_u_right_bottom" . "\xf17b5")
    ("nf-md-arrow_u_right_bottom_bold" . "\xf17b6")
    ("nf-md-arrow_u_right_top" . "\xf17b7")
    ("nf-md-arrow_u_right_top_bold" . "\xf17b8")
    ("nf-md-arrow_u_up_left" . "\xf17b9")
    ("nf-md-arrow_u_up_left_bold" . "\xf17ba")
    ("nf-md-arrow_u_up_right" . "\xf17bb")
    ("nf-md-arrow_u_up_right_bold" . "\xf17bc")
    ("nf-md-arrow_up" . "\xf005d")
    ("nf-md-arrow_up_bold" . "\xf0737")
    ("nf-md-arrow_up_bold_box" . "\xf0738")
    ("nf-md-arrow_up_bold_box_outline" . "\xf0739")
    ("nf-md-arrow_up_bold_circle" . "\xf005f")
    ("nf-md-arrow_up_bold_circle_outline" . "\xf0060")
    ("nf-md-arrow_up_bold_hexagon_outline" . "\xf0061")
    ("nf-md-arrow_up_bold_outline" . "\xf09c7")
    ("nf-md-arrow_up_box" . "\xf06c3")
    ("nf-md-arrow_up_circle" . "\xf0ce1")
    ("nf-md-arrow_up_circle_outline" . "\xf0ce2")
    ("nf-md-arrow_up_down" . "\xf0e79")
    ("nf-md-arrow_up_down_bold" . "\xf0e7a")
    ("nf-md-arrow_up_down_bold_outline" . "\xf09c8")
    ("nf-md-arrow_up_drop_circle" . "\xf0062")
    ("nf-md-arrow_up_drop_circle_outline" . "\xf0063")
    ("nf-md-arrow_up_left" . "\xf17bd")
    ("nf-md-arrow_up_left_bold" . "\xf17be")
    ("nf-md-arrow_up_right" . "\xf17bf")
    ("nf-md-arrow_up_right_bold" . "\xf17c0")
    ("nf-md-arrow_up_thick" . "\xf005e")
    ("nf-md-arrow_up_thin" . "\xf19b2")
    ("nf-md-arrow_up_thin_circle_outline" . "\xf1597")
    ("nf-md-arrow_vertical_lock" . "\xf115c")
    ("nf-md-artstation" . "\xf0b5b")
    ("nf-md-aspect_ratio" . "\xf0a24")
    ("nf-md-assistant" . "\xf0064")
    ("nf-md-asterisk" . "\xf06c4")
    ("nf-md-asterisk_circle_outline" . "\xf1a27")
    ("nf-md-at" . "\xf0065")
    ("nf-md-atlassian" . "\xf0804")
    ("nf-md-atm" . "\xf0d47")
    ("nf-md-atom" . "\xf0768")
    ("nf-md-atom_variant" . "\xf0e7b")
    ("nf-md-attachment" . "\xf0066")
    ("nf-md-attachment_check" . "\xf1ac1")
    ("nf-md-attachment_lock" . "\xf19c4")
    ("nf-md-attachment_minus" . "\xf1ac2")
    ("nf-md-attachment_off" . "\xf1ac3")
    ("nf-md-attachment_plus" . "\xf1ac4")
    ("nf-md-attachment_remove" . "\xf1ac5")
    ("nf-md-audio_input_rca" . "\xf186b")
    ("nf-md-audio_input_stereo_minijack" . "\xf186c")
    ("nf-md-audio_input_xlr" . "\xf186d")
    ("nf-md-audio_video" . "\xf093d")
    ("nf-md-audio_video_off" . "\xf11b6")
    ("nf-md-augmented_reality" . "\xf0850")
    ("nf-md-auto_download" . "\xf137e")
    ("nf-md-auto_fix" . "\xf0068")
    ("nf-md-auto_upload" . "\xf0069")
    ("nf-md-autorenew" . "\xf006a")
    ("nf-md-autorenew_off" . "\xf19e7")
    ("nf-md-av_timer" . "\xf006b")
    ("nf-md-aws" . "\xf0e0f")
    ("nf-md-axe" . "\xf08c8")
    ("nf-md-axe_battle" . "\xf1842")
    ("nf-md-axis" . "\xf0d48")
    ("nf-md-axis_arrow" . "\xf0d49")
    ("nf-md-axis_arrow_info" . "\xf140e")
    ("nf-md-axis_arrow_lock" . "\xf0d4a")
    ("nf-md-axis_lock" . "\xf0d4b")
    ("nf-md-axis_x_arrow" . "\xf0d4c")
    ("nf-md-axis_x_arrow_lock" . "\xf0d4d")
    ("nf-md-axis_x_rotate_clockwise" . "\xf0d4e")
    ("nf-md-axis_x_rotate_counterclockwise" . "\xf0d4f")
    ("nf-md-axis_x_y_arrow_lock" . "\xf0d50")
    ("nf-md-axis_y_arrow" . "\xf0d51")
    ("nf-md-axis_y_arrow_lock" . "\xf0d52")
    ("nf-md-axis_y_rotate_clockwise" . "\xf0d53")
    ("nf-md-axis_y_rotate_counterclockwise" . "\xf0d54")
    ("nf-md-axis_z_arrow" . "\xf0d55")
    ("nf-md-axis_z_arrow_lock" . "\xf0d56")
    ("nf-md-axis_z_rotate_clockwise" . "\xf0d57")
    ("nf-md-axis_z_rotate_counterclockwise" . "\xf0d58")
    ("nf-md-babel" . "\xf0a25")
    ("nf-md-baby" . "\xf006c")
    ("nf-md-baby_bottle" . "\xf0f39")
    ("nf-md-baby_bottle_outline" . "\xf0f3a")
    ("nf-md-baby_buggy" . "\xf13e0")
    ("nf-md-baby_carriage" . "\xf068f")
    ("nf-md-baby_carriage_off" . "\xf0fa0")
    ("nf-md-baby_face" . "\xf0e7c")
    ("nf-md-baby_face_outline" . "\xf0e7d")
    ("nf-md-backburger" . "\xf006d")
    ("nf-md-backspace" . "\xf006e")
    ("nf-md-backspace_outline" . "\xf0b5c")
    ("nf-md-backspace_reverse" . "\xf0e7e")
    ("nf-md-backspace_reverse_outline" . "\xf0e7f")
    ("nf-md-backup_restore" . "\xf006f")
    ("nf-md-bacteria" . "\xf0ed5")
    ("nf-md-bacteria_outline" . "\xf0ed6")
    ("nf-md-badge_account" . "\xf0da7")
    ("nf-md-badge_account_alert" . "\xf0da8")
    ("nf-md-badge_account_alert_outline" . "\xf0da9")
    ("nf-md-badge_account_horizontal" . "\xf0e0d")
    ("nf-md-badge_account_horizontal_outline" . "\xf0e0e")
    ("nf-md-badge_account_outline" . "\xf0daa")
    ("nf-md-badminton" . "\xf0851")
    ("nf-md-bag_carry_on" . "\xf0f3b")
    ("nf-md-bag_carry_on_check" . "\xf0d65")
    ("nf-md-bag_carry_on_off" . "\xf0f3c")
    ("nf-md-bag_checked" . "\xf0f3d")
    ("nf-md-bag_personal" . "\xf0e10")
    ("nf-md-bag_personal_off" . "\xf0e11")
    ("nf-md-bag_personal_off_outline" . "\xf0e12")
    ("nf-md-bag_personal_outline" . "\xf0e13")
    ("nf-md-bag_suitcase" . "\xf158b")
    ("nf-md-bag_suitcase_off" . "\xf158d")
    ("nf-md-bag_suitcase_off_outline" . "\xf158e")
    ("nf-md-bag_suitcase_outline" . "\xf158c")
    ("nf-md-baguette" . "\xf0f3e")
    ("nf-md-balcony" . "\xf1817")
    ("nf-md-balloon" . "\xf0a26")
    ("nf-md-ballot" . "\xf09c9")
    ("nf-md-ballot_outline" . "\xf09ca")
    ("nf-md-ballot_recount" . "\xf0c39")
    ("nf-md-ballot_recount_outline" . "\xf0c3a")
    ("nf-md-bandage" . "\xf0daf")
    ("nf-md-bank" . "\xf0070")
    ("nf-md-bank_check" . "\xf1655")
    ("nf-md-bank_minus" . "\xf0db0")
    ("nf-md-bank_off" . "\xf1656")
    ("nf-md-bank_off_outline" . "\xf1657")
    ("nf-md-bank_outline" . "\xf0e80")
    ("nf-md-bank_plus" . "\xf0db1")
    ("nf-md-bank_remove" . "\xf0db2")
    ("nf-md-bank_transfer" . "\xf0a27")
    ("nf-md-bank_transfer_in" . "\xf0a28")
    ("nf-md-bank_transfer_out" . "\xf0a29")
    ("nf-md-barcode" . "\xf0071")
    ("nf-md-barcode_off" . "\xf1236")
    ("nf-md-barcode_scan" . "\xf0072")
    ("nf-md-barley" . "\xf0073")
    ("nf-md-barley_off" . "\xf0b5d")
    ("nf-md-barn" . "\xf0b5e")
    ("nf-md-barrel" . "\xf0074")
    ("nf-md-barrel_outline" . "\xf1a28")
    ("nf-md-baseball" . "\xf0852")
    ("nf-md-baseball_bat" . "\xf0853")
    ("nf-md-baseball_diamond" . "\xf15ec")
    ("nf-md-baseball_diamond_outline" . "\xf15ed")
    ("nf-md-bash" . "\xf1183")
    ("nf-md-basket" . "\xf0076")
    ("nf-md-basket_check" . "\xf18e5")
    ("nf-md-basket_check_outline" . "\xf18e6")
    ("nf-md-basket_fill" . "\xf0077")
    ("nf-md-basket_minus" . "\xf1523")
    ("nf-md-basket_minus_outline" . "\xf1524")
    ("nf-md-basket_off" . "\xf1525")
    ("nf-md-basket_off_outline" . "\xf1526")
    ("nf-md-basket_outline" . "\xf1181")
    ("nf-md-basket_plus" . "\xf1527")
    ("nf-md-basket_plus_outline" . "\xf1528")
    ("nf-md-basket_remove" . "\xf1529")
    ("nf-md-basket_remove_outline" . "\xf152a")
    ("nf-md-basket_unfill" . "\xf0078")
    ("nf-md-basketball" . "\xf0806")
    ("nf-md-basketball_hoop" . "\xf0c3b")
    ("nf-md-basketball_hoop_outline" . "\xf0c3c")
    ("nf-md-bat" . "\xf0b5f")
    ("nf-md-bathtub" . "\xf1818")
    ("nf-md-bathtub_outline" . "\xf1819")
    ("nf-md-battery" . "\xf0079")
    ("nf-md-battery_10" . "\xf007a")
    ("nf-md-battery_10_bluetooth" . "\xf093e")
    ("nf-md-battery_20" . "\xf007b")
    ("nf-md-battery_20_bluetooth" . "\xf093f")
    ("nf-md-battery_30" . "\xf007c")
    ("nf-md-battery_30_bluetooth" . "\xf0940")
    ("nf-md-battery_40" . "\xf007d")
    ("nf-md-battery_40_bluetooth" . "\xf0941")
    ("nf-md-battery_50" . "\xf007e")
    ("nf-md-battery_50_bluetooth" . "\xf0942")
    ("nf-md-battery_60" . "\xf007f")
    ("nf-md-battery_60_bluetooth" . "\xf0943")
    ("nf-md-battery_70" . "\xf0080")
    ("nf-md-battery_70_bluetooth" . "\xf0944")
    ("nf-md-battery_80" . "\xf0081")
    ("nf-md-battery_80_bluetooth" . "\xf0945")
    ("nf-md-battery_90" . "\xf0082")
    ("nf-md-battery_90_bluetooth" . "\xf0946")
    ("nf-md-battery_alert" . "\xf0083")
    ("nf-md-battery_alert_bluetooth" . "\xf0947")
    ("nf-md-battery_alert_variant" . "\xf10cc")
    ("nf-md-battery_alert_variant_outline" . "\xf10cd")
    ("nf-md-battery_arrow_down" . "\xf17de")
    ("nf-md-battery_arrow_down_outline" . "\xf17df")
    ("nf-md-battery_arrow_up" . "\xf17e0")
    ("nf-md-battery_arrow_up_outline" . "\xf17e1")
    ("nf-md-battery_bluetooth" . "\xf0948")
    ("nf-md-battery_bluetooth_variant" . "\xf0949")
    ("nf-md-battery_charging" . "\xf0084")
    ("nf-md-battery_charging_10" . "\xf089c")
    ("nf-md-battery_charging_100" . "\xf0085")
    ("nf-md-battery_charging_20" . "\xf0086")
    ("nf-md-battery_charging_30" . "\xf0087")
    ("nf-md-battery_charging_40" . "\xf0088")
    ("nf-md-battery_charging_50" . "\xf089d")
    ("nf-md-battery_charging_60" . "\xf0089")
    ("nf-md-battery_charging_70" . "\xf089e")
    ("nf-md-battery_charging_80" . "\xf008a")
    ("nf-md-battery_charging_90" . "\xf008b")
    ("nf-md-battery_charging_high" . "\xf12a6")
    ("nf-md-battery_charging_low" . "\xf12a4")
    ("nf-md-battery_charging_medium" . "\xf12a5")
    ("nf-md-battery_charging_outline" . "\xf089f")
    ("nf-md-battery_charging_wireless" . "\xf0807")
    ("nf-md-battery_charging_wireless_10" . "\xf0808")
    ("nf-md-battery_charging_wireless_20" . "\xf0809")
    ("nf-md-battery_charging_wireless_30" . "\xf080a")
    ("nf-md-battery_charging_wireless_40" . "\xf080b")
    ("nf-md-battery_charging_wireless_50" . "\xf080c")
    ("nf-md-battery_charging_wireless_60" . "\xf080d")
    ("nf-md-battery_charging_wireless_70" . "\xf080e")
    ("nf-md-battery_charging_wireless_80" . "\xf080f")
    ("nf-md-battery_charging_wireless_90" . "\xf0810")
    ("nf-md-battery_charging_wireless_alert" . "\xf0811")
    ("nf-md-battery_charging_wireless_outline" . "\xf0812")
    ("nf-md-battery_check" . "\xf17e2")
    ("nf-md-battery_check_outline" . "\xf17e3")
    ("nf-md-battery_clock" . "\xf19e5")
    ("nf-md-battery_clock_outline" . "\xf19e6")
    ("nf-md-battery_heart" . "\xf120f")
    ("nf-md-battery_heart_outline" . "\xf1210")
    ("nf-md-battery_heart_variant" . "\xf1211")
    ("nf-md-battery_high" . "\xf12a3")
    ("nf-md-battery_lock" . "\xf179c")
    ("nf-md-battery_lock_open" . "\xf179d")
    ("nf-md-battery_low" . "\xf12a1")
    ("nf-md-battery_medium" . "\xf12a2")
    ("nf-md-battery_minus" . "\xf17e4")
    ("nf-md-battery_minus_outline" . "\xf17e5")
    ("nf-md-battery_minus_variant" . "\xf008c")
    ("nf-md-battery_negative" . "\xf008d")
    ("nf-md-battery_off" . "\xf125d")
    ("nf-md-battery_off_outline" . "\xf125e")
    ("nf-md-battery_outline" . "\xf008e")
    ("nf-md-battery_plus" . "\xf17e6")
    ("nf-md-battery_plus_outline" . "\xf17e7")
    ("nf-md-battery_plus_variant" . "\xf008f")
    ("nf-md-battery_positive" . "\xf0090")
    ("nf-md-battery_remove" . "\xf17e8")
    ("nf-md-battery_remove_outline" . "\xf17e9")
    ("nf-md-battery_sync" . "\xf1834")
    ("nf-md-battery_sync_outline" . "\xf1835")
    ("nf-md-battery_unknown" . "\xf0091")
    ("nf-md-battery_unknown_bluetooth" . "\xf094a")
    ("nf-md-beach" . "\xf0092")
    ("nf-md-beaker" . "\xf0cea")
    ("nf-md-beaker_alert" . "\xf1229")
    ("nf-md-beaker_alert_outline" . "\xf122a")
    ("nf-md-beaker_check" . "\xf122b")
    ("nf-md-beaker_check_outline" . "\xf122c")
    ("nf-md-beaker_minus" . "\xf122d")
    ("nf-md-beaker_minus_outline" . "\xf122e")
    ("nf-md-beaker_outline" . "\xf0690")
    ("nf-md-beaker_plus" . "\xf122f")
    ("nf-md-beaker_plus_outline" . "\xf1230")
    ("nf-md-beaker_question" . "\xf1231")
    ("nf-md-beaker_question_outline" . "\xf1232")
    ("nf-md-beaker_remove" . "\xf1233")
    ("nf-md-beaker_remove_outline" . "\xf1234")
    ("nf-md-bed" . "\xf02e3")
    ("nf-md-bed_double" . "\xf0fd4")
    ("nf-md-bed_double_outline" . "\xf0fd3")
    ("nf-md-bed_empty" . "\xf08a0")
    ("nf-md-bed_king" . "\xf0fd2")
    ("nf-md-bed_king_outline" . "\xf0fd1")
    ("nf-md-bed_outline" . "\xf0099")
    ("nf-md-bed_queen" . "\xf0fd0")
    ("nf-md-bed_queen_outline" . "\xf0fdb")
    ("nf-md-bed_single" . "\xf106d")
    ("nf-md-bed_single_outline" . "\xf106e")
    ("nf-md-bee" . "\xf0fa1")
    ("nf-md-bee_flower" . "\xf0fa2")
    ("nf-md-beehive_off_outline" . "\xf13ed")
    ("nf-md-beehive_outline" . "\xf10ce")
    ("nf-md-beekeeper" . "\xf14e2")
    ("nf-md-beer" . "\xf0098")
    ("nf-md-beer_outline" . "\xf130c")
    ("nf-md-bell" . "\xf009a")
    ("nf-md-bell_alert" . "\xf0d59")
    ("nf-md-bell_alert_outline" . "\xf0e81")
    ("nf-md-bell_badge" . "\xf116b")
    ("nf-md-bell_badge_outline" . "\xf0178")
    ("nf-md-bell_cancel" . "\xf13e7")
    ("nf-md-bell_cancel_outline" . "\xf13e8")
    ("nf-md-bell_check" . "\xf11e5")
    ("nf-md-bell_check_outline" . "\xf11e6")
    ("nf-md-bell_circle" . "\xf0d5a")
    ("nf-md-bell_circle_outline" . "\xf0d5b")
    ("nf-md-bell_cog" . "\xf1a29")
    ("nf-md-bell_cog_outline" . "\xf1a2a")
    ("nf-md-bell_minus" . "\xf13e9")
    ("nf-md-bell_minus_outline" . "\xf13ea")
    ("nf-md-bell_off" . "\xf009b")
    ("nf-md-bell_off_outline" . "\xf0a91")
    ("nf-md-bell_outline" . "\xf009c")
    ("nf-md-bell_plus" . "\xf009d")
    ("nf-md-bell_plus_outline" . "\xf0a92")
    ("nf-md-bell_remove" . "\xf13eb")
    ("nf-md-bell_remove_outline" . "\xf13ec")
    ("nf-md-bell_ring" . "\xf009e")
    ("nf-md-bell_ring_outline" . "\xf009f")
    ("nf-md-bell_sleep" . "\xf00a0")
    ("nf-md-bell_sleep_outline" . "\xf0a93")
    ("nf-md-beta" . "\xf00a1")
    ("nf-md-betamax" . "\xf09cb")
    ("nf-md-biathlon" . "\xf0e14")
    ("nf-md-bicycle" . "\xf109c")
    ("nf-md-bicycle_basket" . "\xf1235")
    ("nf-md-bicycle_cargo" . "\xf189c")
    ("nf-md-bicycle_electric" . "\xf15b4")
    ("nf-md-bicycle_penny_farthing" . "\xf15e9")
    ("nf-md-bike" . "\xf00a3")
    ("nf-md-bike_fast" . "\xf111f")
    ("nf-md-billboard" . "\xf1010")
    ("nf-md-billiards" . "\xf0b61")
    ("nf-md-billiards_rack" . "\xf0b62")
    ("nf-md-binoculars" . "\xf00a5")
    ("nf-md-bio" . "\xf00a6")
    ("nf-md-biohazard" . "\xf00a7")
    ("nf-md-bird" . "\xf15c6")
    ("nf-md-bitbucket" . "\xf00a8")
    ("nf-md-bitcoin" . "\xf0813")
    ("nf-md-black_mesa" . "\xf00a9")
    ("nf-md-blender" . "\xf0ceb")
    ("nf-md-blender_outline" . "\xf181a")
    ("nf-md-blender_software" . "\xf00ab")
    ("nf-md-blinds" . "\xf00ac")
    ("nf-md-blinds_horizontal" . "\xf1a2b")
    ("nf-md-blinds_horizontal_closed" . "\xf1a2c")
    ("nf-md-blinds_open" . "\xf1011")
    ("nf-md-blinds_vertical" . "\xf1a2d")
    ("nf-md-blinds_vertical_closed" . "\xf1a2e")
    ("nf-md-block_helper" . "\xf00ad")
    ("nf-md-blood_bag" . "\xf0cec")
    ("nf-md-bluetooth" . "\xf00af")
    ("nf-md-bluetooth_audio" . "\xf00b0")
    ("nf-md-bluetooth_connect" . "\xf00b1")
    ("nf-md-bluetooth_off" . "\xf00b2")
    ("nf-md-bluetooth_settings" . "\xf00b3")
    ("nf-md-bluetooth_transfer" . "\xf00b4")
    ("nf-md-blur" . "\xf00b5")
    ("nf-md-blur_linear" . "\xf00b6")
    ("nf-md-blur_off" . "\xf00b7")
    ("nf-md-blur_radial" . "\xf00b8")
    ("nf-md-bolt" . "\xf0db3")
    ("nf-md-bomb" . "\xf0691")
    ("nf-md-bomb_off" . "\xf06c5")
    ("nf-md-bone" . "\xf00b9")
    ("nf-md-bone_off" . "\xf19e0")
    ("nf-md-book" . "\xf00ba")
    ("nf-md-book_account" . "\xf13ad")
    ("nf-md-book_account_outline" . "\xf13ae")
    ("nf-md-book_alert" . "\xf167c")
    ("nf-md-book_alert_outline" . "\xf167d")
    ("nf-md-book_alphabet" . "\xf061d")
    ("nf-md-book_arrow_down" . "\xf167e")
    ("nf-md-book_arrow_down_outline" . "\xf167f")
    ("nf-md-book_arrow_left" . "\xf1680")
    ("nf-md-book_arrow_left_outline" . "\xf1681")
    ("nf-md-book_arrow_right" . "\xf1682")
    ("nf-md-book_arrow_right_outline" . "\xf1683")
    ("nf-md-book_arrow_up" . "\xf1684")
    ("nf-md-book_arrow_up_outline" . "\xf1685")
    ("nf-md-book_cancel" . "\xf1686")
    ("nf-md-book_cancel_outline" . "\xf1687")
    ("nf-md-book_check" . "\xf14f3")
    ("nf-md-book_check_outline" . "\xf14f4")
    ("nf-md-book_clock" . "\xf1688")
    ("nf-md-book_clock_outline" . "\xf1689")
    ("nf-md-book_cog" . "\xf168a")
    ("nf-md-book_cog_outline" . "\xf168b")
    ("nf-md-book_cross" . "\xf00a2")
    ("nf-md-book_edit" . "\xf168c")
    ("nf-md-book_edit_outline" . "\xf168d")
    ("nf-md-book_education" . "\xf16c9")
    ("nf-md-book_education_outline" . "\xf16ca")
    ("nf-md-book_heart" . "\xf1a1d")
    ("nf-md-book_heart_outline" . "\xf1a1e")
    ("nf-md-book_information_variant" . "\xf106f")
    ("nf-md-book_lock" . "\xf079a")
    ("nf-md-book_lock_open" . "\xf079b")
    ("nf-md-book_lock_open_outline" . "\xf168e")
    ("nf-md-book_lock_outline" . "\xf168f")
    ("nf-md-book_marker" . "\xf1690")
    ("nf-md-book_marker_outline" . "\xf1691")
    ("nf-md-book_minus" . "\xf05d9")
    ("nf-md-book_minus_multiple" . "\xf0a94")
    ("nf-md-book_minus_multiple_outline" . "\xf090b")
    ("nf-md-book_minus_outline" . "\xf1692")
    ("nf-md-book_multiple" . "\xf00bb")
    ("nf-md-book_multiple_outline" . "\xf0436")
    ("nf-md-book_music" . "\xf0067")
    ("nf-md-book_music_outline" . "\xf1693")
    ("nf-md-book_off" . "\xf1694")
    ("nf-md-book_off_outline" . "\xf1695")
    ("nf-md-book_open" . "\xf00bd")
    ("nf-md-book_open_blank_variant" . "\xf00be")
    ("nf-md-book_open_outline" . "\xf0b63")
    ("nf-md-book_open_page_variant" . "\xf05da")
    ("nf-md-book_open_page_variant_outline" . "\xf15d6")
    ("nf-md-book_open_variant" . "\xf14f7")
    ("nf-md-book_outline" . "\xf0b64")
    ("nf-md-book_play" . "\xf0e82")
    ("nf-md-book_play_outline" . "\xf0e83")
    ("nf-md-book_plus" . "\xf05db")
    ("nf-md-book_plus_multiple" . "\xf0a95")
    ("nf-md-book_plus_multiple_outline" . "\xf0ade")
    ("nf-md-book_plus_outline" . "\xf1696")
    ("nf-md-book_refresh" . "\xf1697")
    ("nf-md-book_refresh_outline" . "\xf1698")
    ("nf-md-book_remove" . "\xf0a97")
    ("nf-md-book_remove_multiple" . "\xf0a96")
    ("nf-md-book_remove_multiple_outline" . "\xf04ca")
    ("nf-md-book_remove_outline" . "\xf1699")
    ("nf-md-book_search" . "\xf0e84")
    ("nf-md-book_search_outline" . "\xf0e85")
    ("nf-md-book_settings" . "\xf169a")
    ("nf-md-book_settings_outline" . "\xf169b")
    ("nf-md-book_sync" . "\xf169c")
    ("nf-md-book_sync_outline" . "\xf16c8")
    ("nf-md-book_variant" . "\xf00bf")
    ("nf-md-book_variant_multiple" . "\xf00bc")
    ("nf-md-bookmark" . "\xf00c0")
    ("nf-md-bookmark_box_multiple" . "\xf196c")
    ("nf-md-bookmark_box_multiple_outline" . "\xf196d")
    ("nf-md-bookmark_check" . "\xf00c1")
    ("nf-md-bookmark_check_outline" . "\xf137b")
    ("nf-md-bookmark_minus" . "\xf09cc")
    ("nf-md-bookmark_minus_outline" . "\xf09cd")
    ("nf-md-bookmark_multiple" . "\xf0e15")
    ("nf-md-bookmark_multiple_outline" . "\xf0e16")
    ("nf-md-bookmark_music" . "\xf00c2")
    ("nf-md-bookmark_music_outline" . "\xf1379")
    ("nf-md-bookmark_off" . "\xf09ce")
    ("nf-md-bookmark_off_outline" . "\xf09cf")
    ("nf-md-bookmark_outline" . "\xf00c3")
    ("nf-md-bookmark_plus" . "\xf00c5")
    ("nf-md-bookmark_plus_outline" . "\xf00c4")
    ("nf-md-bookmark_remove" . "\xf00c6")
    ("nf-md-bookmark_remove_outline" . "\xf137a")
    ("nf-md-bookshelf" . "\xf125f")
    ("nf-md-boom_gate" . "\xf0e86")
    ("nf-md-boom_gate_alert" . "\xf0e87")
    ("nf-md-boom_gate_alert_outline" . "\xf0e88")
    ("nf-md-boom_gate_arrow_down" . "\xf0e89")
    ("nf-md-boom_gate_arrow_down_outline" . "\xf0e8a")
    ("nf-md-boom_gate_arrow_up" . "\xf0e8c")
    ("nf-md-boom_gate_arrow_up_outline" . "\xf0e8d")
    ("nf-md-boom_gate_outline" . "\xf0e8b")
    ("nf-md-boom_gate_up" . "\xf17f9")
    ("nf-md-boom_gate_up_outline" . "\xf17fa")
    ("nf-md-boombox" . "\xf05dc")
    ("nf-md-boomerang" . "\xf10cf")
    ("nf-md-bootstrap" . "\xf06c6")
    ("nf-md-border_all" . "\xf00c7")
    ("nf-md-border_all_variant" . "\xf08a1")
    ("nf-md-border_bottom" . "\xf00c8")
    ("nf-md-border_bottom_variant" . "\xf08a2")
    ("nf-md-border_color" . "\xf00c9")
    ("nf-md-border_horizontal" . "\xf00ca")
    ("nf-md-border_inside" . "\xf00cb")
    ("nf-md-border_left" . "\xf00cc")
    ("nf-md-border_left_variant" . "\xf08a3")
    ("nf-md-border_none" . "\xf00cd")
    ("nf-md-border_none_variant" . "\xf08a4")
    ("nf-md-border_outside" . "\xf00ce")
    ("nf-md-border_right" . "\xf00cf")
    ("nf-md-border_right_variant" . "\xf08a5")
    ("nf-md-border_style" . "\xf00d0")
    ("nf-md-border_top" . "\xf00d1")
    ("nf-md-border_top_variant" . "\xf08a6")
    ("nf-md-border_vertical" . "\xf00d2")
    ("nf-md-bottle_soda" . "\xf1070")
    ("nf-md-bottle_soda_classic" . "\xf1071")
    ("nf-md-bottle_soda_classic_outline" . "\xf1363")
    ("nf-md-bottle_soda_outline" . "\xf1072")
    ("nf-md-bottle_tonic" . "\xf112e")
    ("nf-md-bottle_tonic_outline" . "\xf112f")
    ("nf-md-bottle_tonic_plus" . "\xf1130")
    ("nf-md-bottle_tonic_plus_outline" . "\xf1131")
    ("nf-md-bottle_tonic_skull" . "\xf1132")
    ("nf-md-bottle_tonic_skull_outline" . "\xf1133")
    ("nf-md-bottle_wine" . "\xf0854")
    ("nf-md-bottle_wine_outline" . "\xf1310")
    ("nf-md-bow_arrow" . "\xf1841")
    ("nf-md-bow_tie" . "\xf0678")
    ("nf-md-bowl" . "\xf028e")
    ("nf-md-bowl_mix" . "\xf0617")
    ("nf-md-bowl_mix_outline" . "\xf02e4")
    ("nf-md-bowl_outline" . "\xf02a9")
    ("nf-md-bowling" . "\xf00d3")
    ("nf-md-box" . "\xf00d4")
    ("nf-md-box_cutter" . "\xf00d5")
    ("nf-md-box_cutter_off" . "\xf0b4a")
    ("nf-md-box_shadow" . "\xf0637")
    ("nf-md-boxing_glove" . "\xf0b65")
    ("nf-md-braille" . "\xf09d0")
    ("nf-md-brain" . "\xf09d1")
    ("nf-md-bread_slice" . "\xf0cee")
    ("nf-md-bread_slice_outline" . "\xf0cef")
    ("nf-md-bridge" . "\xf0618")
    ("nf-md-briefcase" . "\xf00d6")
    ("nf-md-briefcase_account" . "\xf0cf0")
    ("nf-md-briefcase_account_outline" . "\xf0cf1")
    ("nf-md-briefcase_arrow_left_right" . "\xf1a8d")
    ("nf-md-briefcase_arrow_left_right_outline" . "\xf1a8e")
    ("nf-md-briefcase_arrow_up_down" . "\xf1a8f")
    ("nf-md-briefcase_arrow_up_down_outline" . "\xf1a90")
    ("nf-md-briefcase_check" . "\xf00d7")
    ("nf-md-briefcase_check_outline" . "\xf131e")
    ("nf-md-briefcase_clock" . "\xf10d0")
    ("nf-md-briefcase_clock_outline" . "\xf10d1")
    ("nf-md-briefcase_download" . "\xf00d8")
    ("nf-md-briefcase_download_outline" . "\xf0c3d")
    ("nf-md-briefcase_edit" . "\xf0a98")
    ("nf-md-briefcase_edit_outline" . "\xf0c3e")
    ("nf-md-briefcase_eye" . "\xf17d9")
    ("nf-md-briefcase_eye_outline" . "\xf17da")
    ("nf-md-briefcase_minus" . "\xf0a2a")
    ("nf-md-briefcase_minus_outline" . "\xf0c3f")
    ("nf-md-briefcase_off" . "\xf1658")
    ("nf-md-briefcase_off_outline" . "\xf1659")
    ("nf-md-briefcase_outline" . "\xf0814")
    ("nf-md-briefcase_plus" . "\xf0a2b")
    ("nf-md-briefcase_plus_outline" . "\xf0c40")
    ("nf-md-briefcase_remove" . "\xf0a2c")
    ("nf-md-briefcase_remove_outline" . "\xf0c41")
    ("nf-md-briefcase_search" . "\xf0a2d")
    ("nf-md-briefcase_search_outline" . "\xf0c42")
    ("nf-md-briefcase_upload" . "\xf00d9")
    ("nf-md-briefcase_upload_outline" . "\xf0c43")
    ("nf-md-briefcase_variant" . "\xf1494")
    ("nf-md-briefcase_variant_off" . "\xf165a")
    ("nf-md-briefcase_variant_off_outline" . "\xf165b")
    ("nf-md-briefcase_variant_outline" . "\xf1495")
    ("nf-md-brightness_1" . "\xf00da")
    ("nf-md-brightness_2" . "\xf00db")
    ("nf-md-brightness_3" . "\xf00dc")
    ("nf-md-brightness_4" . "\xf00dd")
    ("nf-md-brightness_5" . "\xf00de")
    ("nf-md-brightness_6" . "\xf00df")
    ("nf-md-brightness_7" . "\xf00e0")
    ("nf-md-brightness_auto" . "\xf00e1")
    ("nf-md-brightness_percent" . "\xf0cf2")
    ("nf-md-broadcast" . "\xf1720")
    ("nf-md-broadcast_off" . "\xf1721")
    ("nf-md-broom" . "\xf00e2")
    ("nf-md-brush" . "\xf00e3")
    ("nf-md-brush_off" . "\xf1771")
    ("nf-md-brush_outline" . "\xf1a0d")
    ("nf-md-brush_variant" . "\xf1813")
    ("nf-md-bucket" . "\xf1415")
    ("nf-md-bucket_outline" . "\xf1416")
    ("nf-md-buffet" . "\xf0578")
    ("nf-md-bug" . "\xf00e4")
    ("nf-md-bug_check" . "\xf0a2e")
    ("nf-md-bug_check_outline" . "\xf0a2f")
    ("nf-md-bug_outline" . "\xf0a30")
    ("nf-md-bugle" . "\xf0db4")
    ("nf-md-bulkhead_light" . "\xf1a2f")
    ("nf-md-bulldozer" . "\xf0b22")
    ("nf-md-bullet" . "\xf0cf3")
    ("nf-md-bulletin_board" . "\xf00e5")
    ("nf-md-bullhorn" . "\xf00e6")
    ("nf-md-bullhorn_outline" . "\xf0b23")
    ("nf-md-bullhorn_variant" . "\xf196e")
    ("nf-md-bullhorn_variant_outline" . "\xf196f")
    ("nf-md-bullseye" . "\xf05dd")
    ("nf-md-bullseye_arrow" . "\xf08c9")
    ("nf-md-bulma" . "\xf12e7")
    ("nf-md-bunk_bed" . "\xf1302")
    ("nf-md-bunk_bed_outline" . "\xf0097")
    ("nf-md-bus" . "\xf00e7")
    ("nf-md-bus_alert" . "\xf0a99")
    ("nf-md-bus_articulated_end" . "\xf079c")
    ("nf-md-bus_articulated_front" . "\xf079d")
    ("nf-md-bus_clock" . "\xf08ca")
    ("nf-md-bus_double_decker" . "\xf079e")
    ("nf-md-bus_electric" . "\xf191d")
    ("nf-md-bus_marker" . "\xf1212")
    ("nf-md-bus_multiple" . "\xf0f3f")
    ("nf-md-bus_school" . "\xf079f")
    ("nf-md-bus_side" . "\xf07a0")
    ("nf-md-bus_stop" . "\xf1012")
    ("nf-md-bus_stop_covered" . "\xf1013")
    ("nf-md-bus_stop_uncovered" . "\xf1014")
    ("nf-md-butterfly" . "\xf1589")
    ("nf-md-butterfly_outline" . "\xf158a")
    ("nf-md-cabin_a_frame" . "\xf188c")
    ("nf-md-cable_data" . "\xf1394")
    ("nf-md-cached" . "\xf00e8")
    ("nf-md-cactus" . "\xf0db5")
    ("nf-md-cake" . "\xf00e9")
    ("nf-md-cake_layered" . "\xf00ea")
    ("nf-md-cake_variant" . "\xf00eb")
    ("nf-md-cake_variant_outline" . "\xf17f0")
    ("nf-md-calculator" . "\xf00ec")
    ("nf-md-calculator_variant" . "\xf0a9a")
    ("nf-md-calculator_variant_outline" . "\xf15a6")
    ("nf-md-calendar" . "\xf00ed")
    ("nf-md-calendar_account" . "\xf0ed7")
    ("nf-md-calendar_account_outline" . "\xf0ed8")
    ("nf-md-calendar_alert" . "\xf0a31")
    ("nf-md-calendar_arrow_left" . "\xf1134")
    ("nf-md-calendar_arrow_right" . "\xf1135")
    ("nf-md-calendar_blank" . "\xf00ee")
    ("nf-md-calendar_blank_multiple" . "\xf1073")
    ("nf-md-calendar_blank_outline" . "\xf0b66")
    ("nf-md-calendar_check" . "\xf00ef")
    ("nf-md-calendar_check_outline" . "\xf0c44")
    ("nf-md-calendar_clock" . "\xf00f0")
    ("nf-md-calendar_clock_outline" . "\xf16e1")
    ("nf-md-calendar_collapse_horizontal" . "\xf189d")
    ("nf-md-calendar_cursor" . "\xf157b")
    ("nf-md-calendar_edit" . "\xf08a7")
    ("nf-md-calendar_end" . "\xf166c")
    ("nf-md-calendar_expand_horizontal" . "\xf189e")
    ("nf-md-calendar_export" . "\xf0b24")
    ("nf-md-calendar_heart" . "\xf09d2")
    ("nf-md-calendar_import" . "\xf0b25")
    ("nf-md-calendar_lock" . "\xf1641")
    ("nf-md-calendar_lock_outline" . "\xf1642")
    ("nf-md-calendar_minus" . "\xf0d5c")
    ("nf-md-calendar_month" . "\xf0e17")
    ("nf-md-calendar_month_outline" . "\xf0e18")
    ("nf-md-calendar_multiple" . "\xf00f1")
    ("nf-md-calendar_multiple_check" . "\xf00f2")
    ("nf-md-calendar_multiselect" . "\xf0a32")
    ("nf-md-calendar_outline" . "\xf0b67")
    ("nf-md-calendar_plus" . "\xf00f3")
    ("nf-md-calendar_question" . "\xf0692")
    ("nf-md-calendar_range" . "\xf0679")
    ("nf-md-calendar_range_outline" . "\xf0b68")
    ("nf-md-calendar_refresh" . "\xf01e1")
    ("nf-md-calendar_refresh_outline" . "\xf0203")
    ("nf-md-calendar_remove" . "\xf00f4")
    ("nf-md-calendar_remove_outline" . "\xf0c45")
    ("nf-md-calendar_search" . "\xf094c")
    ("nf-md-calendar_star" . "\xf09d3")
    ("nf-md-calendar_start" . "\xf166d")
    ("nf-md-calendar_sync" . "\xf0e8e")
    ("nf-md-calendar_sync_outline" . "\xf0e8f")
    ("nf-md-calendar_text" . "\xf00f5")
    ("nf-md-calendar_text_outline" . "\xf0c46")
    ("nf-md-calendar_today" . "\xf00f6")
    ("nf-md-calendar_today_outline" . "\xf1a30")
    ("nf-md-calendar_week" . "\xf0a33")
    ("nf-md-calendar_week_begin" . "\xf0a34")
    ("nf-md-calendar_week_begin_outline" . "\xf1a31")
    ("nf-md-calendar_week_end" . "\xf1a32")
    ("nf-md-calendar_week_end_outline" . "\xf1a33")
    ("nf-md-calendar_week_outline" . "\xf1a34")
    ("nf-md-calendar_weekend" . "\xf0ed9")
    ("nf-md-calendar_weekend_outline" . "\xf0eda")
    ("nf-md-call_made" . "\xf00f7")
    ("nf-md-call_merge" . "\xf00f8")
    ("nf-md-call_missed" . "\xf00f9")
    ("nf-md-call_received" . "\xf00fa")
    ("nf-md-call_split" . "\xf00fb")
    ("nf-md-camcorder" . "\xf00fc")
    ("nf-md-camcorder_off" . "\xf00ff")
    ("nf-md-camera" . "\xf0100")
    ("nf-md-camera_account" . "\xf08cb")
    ("nf-md-camera_burst" . "\xf0693")
    ("nf-md-camera_control" . "\xf0b69")
    ("nf-md-camera_document" . "\xf1871")
    ("nf-md-camera_document_off" . "\xf1872")
    ("nf-md-camera_enhance" . "\xf0101")
    ("nf-md-camera_enhance_outline" . "\xf0b6a")
    ("nf-md-camera_flip" . "\xf15d9")
    ("nf-md-camera_flip_outline" . "\xf15da")
    ("nf-md-camera_front" . "\xf0102")
    ("nf-md-camera_front_variant" . "\xf0103")
    ("nf-md-camera_gopro" . "\xf07a1")
    ("nf-md-camera_image" . "\xf08cc")
    ("nf-md-camera_iris" . "\xf0104")
    ("nf-md-camera_lock" . "\xf1a14")
    ("nf-md-camera_lock_outline" . "\xf1a15")
    ("nf-md-camera_marker" . "\xf19a7")
    ("nf-md-camera_marker_outline" . "\xf19a8")
    ("nf-md-camera_metering_center" . "\xf07a2")
    ("nf-md-camera_metering_matrix" . "\xf07a3")
    ("nf-md-camera_metering_partial" . "\xf07a4")
    ("nf-md-camera_metering_spot" . "\xf07a5")
    ("nf-md-camera_off" . "\xf05df")
    ("nf-md-camera_off_outline" . "\xf19bf")
    ("nf-md-camera_outline" . "\xf0d5d")
    ("nf-md-camera_party_mode" . "\xf0105")
    ("nf-md-camera_plus" . "\xf0edb")
    ("nf-md-camera_plus_outline" . "\xf0edc")
    ("nf-md-camera_rear" . "\xf0106")
    ("nf-md-camera_rear_variant" . "\xf0107")
    ("nf-md-camera_retake" . "\xf0e19")
    ("nf-md-camera_retake_outline" . "\xf0e1a")
    ("nf-md-camera_switch" . "\xf0108")
    ("nf-md-camera_switch_outline" . "\xf084a")
    ("nf-md-camera_timer" . "\xf0109")
    ("nf-md-camera_wireless" . "\xf0db6")
    ("nf-md-camera_wireless_outline" . "\xf0db7")
    ("nf-md-campfire" . "\xf0edd")
    ("nf-md-cancel" . "\xf073a")
    ("nf-md-candelabra" . "\xf17d2")
    ("nf-md-candelabra_fire" . "\xf17d3")
    ("nf-md-candle" . "\xf05e2")
    ("nf-md-candy" . "\xf1970")
    ("nf-md-candy_off" . "\xf1971")
    ("nf-md-candy_off_outline" . "\xf1972")
    ("nf-md-candy_outline" . "\xf1973")
    ("nf-md-candycane" . "\xf010a")
    ("nf-md-cannabis" . "\xf07a6")
    ("nf-md-cannabis_off" . "\xf166e")
    ("nf-md-caps_lock" . "\xf0a9b")
    ("nf-md-car" . "\xf010b")
    ("nf-md-car_2_plus" . "\xf1015")
    ("nf-md-car_3_plus" . "\xf1016")
    ("nf-md-car_arrow_left" . "\xf13b2")
    ("nf-md-car_arrow_right" . "\xf13b3")
    ("nf-md-car_back" . "\xf0e1b")
    ("nf-md-car_battery" . "\xf010c")
    ("nf-md-car_brake_abs" . "\xf0c47")
    ("nf-md-car_brake_alert" . "\xf0c48")
    ("nf-md-car_brake_fluid_level" . "\xf1909")
    ("nf-md-car_brake_hold" . "\xf0d5e")
    ("nf-md-car_brake_low_pressure" . "\xf190a")
    ("nf-md-car_brake_parking" . "\xf0d5f")
    ("nf-md-car_brake_retarder" . "\xf1017")
    ("nf-md-car_brake_temperature" . "\xf190b")
    ("nf-md-car_brake_worn_linings" . "\xf190c")
    ("nf-md-car_child_seat" . "\xf0fa3")
    ("nf-md-car_clock" . "\xf1974")
    ("nf-md-car_clutch" . "\xf1018")
    ("nf-md-car_cog" . "\xf13cc")
    ("nf-md-car_connected" . "\xf010d")
    ("nf-md-car_convertible" . "\xf07a7")
    ("nf-md-car_coolant_level" . "\xf1019")
    ("nf-md-car_cruise_control" . "\xf0d60")
    ("nf-md-car_defrost_front" . "\xf0d61")
    ("nf-md-car_defrost_rear" . "\xf0d62")
    ("nf-md-car_door" . "\xf0b6b")
    ("nf-md-car_door_lock" . "\xf109d")
    ("nf-md-car_electric" . "\xf0b6c")
    ("nf-md-car_electric_outline" . "\xf15b5")
    ("nf-md-car_emergency" . "\xf160f")
    ("nf-md-car_esp" . "\xf0c49")
    ("nf-md-car_estate" . "\xf07a8")
    ("nf-md-car_hatchback" . "\xf07a9")
    ("nf-md-car_info" . "\xf11be")
    ("nf-md-car_key" . "\xf0b6d")
    ("nf-md-car_lifted_pickup" . "\xf152d")
    ("nf-md-car_light_alert" . "\xf190d")
    ("nf-md-car_light_dimmed" . "\xf0c4a")
    ("nf-md-car_light_fog" . "\xf0c4b")
    ("nf-md-car_light_high" . "\xf0c4c")
    ("nf-md-car_limousine" . "\xf08cd")
    ("nf-md-car_multiple" . "\xf0b6e")
    ("nf-md-car_off" . "\xf0e1c")
    ("nf-md-car_outline" . "\xf14ed")
    ("nf-md-car_parking_lights" . "\xf0d63")
    ("nf-md-car_pickup" . "\xf07aa")
    ("nf-md-car_seat" . "\xf0fa4")
    ("nf-md-car_seat_cooler" . "\xf0fa5")
    ("nf-md-car_seat_heater" . "\xf0fa6")
    ("nf-md-car_select" . "\xf1879")
    ("nf-md-car_settings" . "\xf13cd")
    ("nf-md-car_shift_pattern" . "\xf0f40")
    ("nf-md-car_side" . "\xf07ab")
    ("nf-md-car_speed_limiter" . "\xf190e")
    ("nf-md-car_sports" . "\xf07ac")
    ("nf-md-car_tire_alert" . "\xf0c4d")
    ("nf-md-car_traction_control" . "\xf0d64")
    ("nf-md-car_turbocharger" . "\xf101a")
    ("nf-md-car_wash" . "\xf010e")
    ("nf-md-car_windshield" . "\xf101b")
    ("nf-md-car_windshield_outline" . "\xf101c")
    ("nf-md-car_wireless" . "\xf1878")
    ("nf-md-car_wrench" . "\xf1814")
    ("nf-md-carabiner" . "\xf14c0")
    ("nf-md-caravan" . "\xf07ad")
    ("nf-md-card" . "\xf0b6f")
    ("nf-md-card_account_details" . "\xf05d2")
    ("nf-md-card_account_details_outline" . "\xf0dab")
    ("nf-md-card_account_details_star" . "\xf02a3")
    ("nf-md-card_account_details_star_outline" . "\xf06db")
    ("nf-md-card_account_mail" . "\xf018e")
    ("nf-md-card_account_mail_outline" . "\xf0e98")
    ("nf-md-card_account_phone" . "\xf0e99")
    ("nf-md-card_account_phone_outline" . "\xf0e9a")
    ("nf-md-card_bulleted" . "\xf0b70")
    ("nf-md-card_bulleted_off" . "\xf0b71")
    ("nf-md-card_bulleted_off_outline" . "\xf0b72")
    ("nf-md-card_bulleted_outline" . "\xf0b73")
    ("nf-md-card_bulleted_settings" . "\xf0b74")
    ("nf-md-card_bulleted_settings_outline" . "\xf0b75")
    ("nf-md-card_minus" . "\xf1600")
    ("nf-md-card_minus_outline" . "\xf1601")
    ("nf-md-card_multiple" . "\xf17f1")
    ("nf-md-card_multiple_outline" . "\xf17f2")
    ("nf-md-card_off" . "\xf1602")
    ("nf-md-card_off_outline" . "\xf1603")
    ("nf-md-card_outline" . "\xf0b76")
    ("nf-md-card_plus" . "\xf11ff")
    ("nf-md-card_plus_outline" . "\xf1200")
    ("nf-md-card_remove" . "\xf1604")
    ("nf-md-card_remove_outline" . "\xf1605")
    ("nf-md-card_search" . "\xf1074")
    ("nf-md-card_search_outline" . "\xf1075")
    ("nf-md-card_text" . "\xf0b77")
    ("nf-md-card_text_outline" . "\xf0b78")
    ("nf-md-cards" . "\xf0638")
    ("nf-md-cards_club" . "\xf08ce")
    ("nf-md-cards_club_outline" . "\xf189f")
    ("nf-md-cards_diamond" . "\xf08cf")
    ("nf-md-cards_diamond_outline" . "\xf101d")
    ("nf-md-cards_outline" . "\xf0639")
    ("nf-md-cards_playing" . "\xf18a1")
    ("nf-md-cards_playing_club" . "\xf18a2")
    ("nf-md-cards_playing_club_multiple" . "\xf18a3")
    ("nf-md-cards_playing_club_multiple_outline" . "\xf18a4")
    ("nf-md-cards_playing_club_outline" . "\xf18a5")
    ("nf-md-cards_playing_diamond" . "\xf18a6")
    ("nf-md-cards_playing_diamond_multiple" . "\xf18a7")
    ("nf-md-cards_playing_diamond_multiple_outline" . "\xf18a8")
    ("nf-md-cards_playing_diamond_outline" . "\xf18a9")
    ("nf-md-cards_playing_heart" . "\xf18aa")
    ("nf-md-cards_playing_heart_multiple" . "\xf18ab")
    ("nf-md-cards_playing_heart_multiple_outline" . "\xf18ac")
    ("nf-md-cards_playing_heart_outline" . "\xf18ad")
    ("nf-md-cards_playing_outline" . "\xf063a")
    ("nf-md-cards_playing_spade" . "\xf18ae")
    ("nf-md-cards_playing_spade_multiple" . "\xf18af")
    ("nf-md-cards_playing_spade_multiple_outline" . "\xf18b0")
    ("nf-md-cards_playing_spade_outline" . "\xf18b1")
    ("nf-md-cards_spade" . "\xf08d1")
    ("nf-md-cards_spade_outline" . "\xf18b2")
    ("nf-md-cards_variant" . "\xf06c7")
    ("nf-md-carrot" . "\xf010f")
    ("nf-md-cart" . "\xf0110")
    ("nf-md-cart_arrow_down" . "\xf0d66")
    ("nf-md-cart_arrow_right" . "\xf0c4e")
    ("nf-md-cart_arrow_up" . "\xf0d67")
    ("nf-md-cart_check" . "\xf15ea")
    ("nf-md-cart_heart" . "\xf18e0")
    ("nf-md-cart_minus" . "\xf0d68")
    ("nf-md-cart_off" . "\xf066b")
    ("nf-md-cart_outline" . "\xf0111")
    ("nf-md-cart_plus" . "\xf0112")
    ("nf-md-cart_remove" . "\xf0d69")
    ("nf-md-cart_variant" . "\xf15eb")
    ("nf-md-case_sensitive_alt" . "\xf0113")
    ("nf-md-cash" . "\xf0114")
    ("nf-md-cash_100" . "\xf0115")
    ("nf-md-cash_check" . "\xf14ee")
    ("nf-md-cash_clock" . "\xf1a91")
    ("nf-md-cash_fast" . "\xf185c")
    ("nf-md-cash_lock" . "\xf14ea")
    ("nf-md-cash_lock_open" . "\xf14eb")
    ("nf-md-cash_marker" . "\xf0db8")
    ("nf-md-cash_minus" . "\xf1260")
    ("nf-md-cash_multiple" . "\xf0116")
    ("nf-md-cash_plus" . "\xf1261")
    ("nf-md-cash_refund" . "\xf0a9c")
    ("nf-md-cash_register" . "\xf0cf4")
    ("nf-md-cash_remove" . "\xf1262")
    ("nf-md-cash_sync" . "\xf1a92")
    ("nf-md-cassette" . "\xf09d4")
    ("nf-md-cast" . "\xf0118")
    ("nf-md-cast_audio" . "\xf101e")
    ("nf-md-cast_audio_variant" . "\xf1749")
    ("nf-md-cast_connected" . "\xf0119")
    ("nf-md-cast_education" . "\xf0e1d")
    ("nf-md-cast_off" . "\xf078a")
    ("nf-md-cast_variant" . "\xf001f")
    ("nf-md-castle" . "\xf011a")
    ("nf-md-cat" . "\xf011b")
    ("nf-md-cctv" . "\xf07ae")
    ("nf-md-cctv_off" . "\xf185f")
    ("nf-md-ceiling_fan" . "\xf1797")
    ("nf-md-ceiling_fan_light" . "\xf1798")
    ("nf-md-ceiling_light" . "\xf0769")
    ("nf-md-ceiling_light_multiple" . "\xf18dd")
    ("nf-md-ceiling_light_multiple_outline" . "\xf18de")
    ("nf-md-ceiling_light_outline" . "\xf17c7")
    ("nf-md-cellphone" . "\xf011c")
    ("nf-md-cellphone_arrow_down" . "\xf09d5")
    ("nf-md-cellphone_arrow_down_variant" . "\xf19c5")
    ("nf-md-cellphone_basic" . "\xf011e")
    ("nf-md-cellphone_charging" . "\xf1397")
    ("nf-md-cellphone_check" . "\xf17fd")
    ("nf-md-cellphone_cog" . "\xf0951")
    ("nf-md-cellphone_dock" . "\xf011f")
    ("nf-md-cellphone_information" . "\xf0f41")
    ("nf-md-cellphone_key" . "\xf094e")
    ("nf-md-cellphone_link" . "\xf0121")
    ("nf-md-cellphone_link_off" . "\xf0122")
    ("nf-md-cellphone_lock" . "\xf094f")
    ("nf-md-cellphone_marker" . "\xf183a")
    ("nf-md-cellphone_message" . "\xf08d3")
    ("nf-md-cellphone_message_off" . "\xf10d2")
    ("nf-md-cellphone_nfc" . "\xf0e90")
    ("nf-md-cellphone_nfc_off" . "\xf12d8")
    ("nf-md-cellphone_off" . "\xf0950")
    ("nf-md-cellphone_play" . "\xf101f")
    ("nf-md-cellphone_remove" . "\xf094d")
    ("nf-md-cellphone_screenshot" . "\xf0a35")
    ("nf-md-cellphone_settings" . "\xf0123")
    ("nf-md-cellphone_sound" . "\xf0952")
    ("nf-md-cellphone_text" . "\xf08d2")
    ("nf-md-cellphone_wireless" . "\xf0815")
    ("nf-md-centos" . "\xf111a")
    ("nf-md-certificate" . "\xf0124")
    ("nf-md-certificate_outline" . "\xf1188")
    ("nf-md-chair_rolling" . "\xf0f48")
    ("nf-md-chair_school" . "\xf0125")
    ("nf-md-chandelier" . "\xf1793")
    ("nf-md-charity" . "\xf0c4f")
    ("nf-md-chart_arc" . "\xf0126")
    ("nf-md-chart_areaspline" . "\xf0127")
    ("nf-md-chart_areaspline_variant" . "\xf0e91")
    ("nf-md-chart_bar" . "\xf0128")
    ("nf-md-chart_bar_stacked" . "\xf076a")
    ("nf-md-chart_bell_curve" . "\xf0c50")
    ("nf-md-chart_bell_curve_cumulative" . "\xf0fa7")
    ("nf-md-chart_box" . "\xf154d")
    ("nf-md-chart_box_outline" . "\xf154e")
    ("nf-md-chart_box_plus_outline" . "\xf154f")
    ("nf-md-chart_bubble" . "\xf05e3")
    ("nf-md-chart_donut" . "\xf07af")
    ("nf-md-chart_donut_variant" . "\xf07b0")
    ("nf-md-chart_gantt" . "\xf066c")
    ("nf-md-chart_histogram" . "\xf0129")
    ("nf-md-chart_line" . "\xf012a")
    ("nf-md-chart_line_stacked" . "\xf076b")
    ("nf-md-chart_line_variant" . "\xf07b1")
    ("nf-md-chart_multiline" . "\xf08d4")
    ("nf-md-chart_multiple" . "\xf1213")
    ("nf-md-chart_pie" . "\xf012b")
    ("nf-md-chart_ppf" . "\xf1380")
    ("nf-md-chart_sankey" . "\xf11df")
    ("nf-md-chart_sankey_variant" . "\xf11e0")
    ("nf-md-chart_scatter_plot" . "\xf0e92")
    ("nf-md-chart_scatter_plot_hexbin" . "\xf066d")
    ("nf-md-chart_timeline" . "\xf066e")
    ("nf-md-chart_timeline_variant" . "\xf0e93")
    ("nf-md-chart_timeline_variant_shimmer" . "\xf15b6")
    ("nf-md-chart_tree" . "\xf0e94")
    ("nf-md-chart_waterfall" . "\xf1918")
    ("nf-md-chat" . "\xf0b79")
    ("nf-md-chat_alert" . "\xf0b7a")
    ("nf-md-chat_alert_outline" . "\xf12c9")
    ("nf-md-chat_minus" . "\xf1410")
    ("nf-md-chat_minus_outline" . "\xf1413")
    ("nf-md-chat_outline" . "\xf0ede")
    ("nf-md-chat_plus" . "\xf140f")
    ("nf-md-chat_plus_outline" . "\xf1412")
    ("nf-md-chat_processing" . "\xf0b7b")
    ("nf-md-chat_processing_outline" . "\xf12ca")
    ("nf-md-chat_question" . "\xf1738")
    ("nf-md-chat_question_outline" . "\xf1739")
    ("nf-md-chat_remove" . "\xf1411")
    ("nf-md-chat_remove_outline" . "\xf1414")
    ("nf-md-chat_sleep" . "\xf12d1")
    ("nf-md-chat_sleep_outline" . "\xf12d2")
    ("nf-md-check" . "\xf012c")
    ("nf-md-check_all" . "\xf012d")
    ("nf-md-check_bold" . "\xf0e1e")
    ("nf-md-check_circle" . "\xf05e0")
    ("nf-md-check_circle_outline" . "\xf05e1")
    ("nf-md-check_decagram" . "\xf0791")
    ("nf-md-check_decagram_outline" . "\xf1740")
    ("nf-md-check_network" . "\xf0c53")
    ("nf-md-check_network_outline" . "\xf0c54")
    ("nf-md-check_outline" . "\xf0855")
    ("nf-md-check_underline" . "\xf0e1f")
    ("nf-md-check_underline_circle" . "\xf0e20")
    ("nf-md-check_underline_circle_outline" . "\xf0e21")
    ("nf-md-checkbook" . "\xf0a9d")
    ("nf-md-checkbox_blank" . "\xf012e")
    ("nf-md-checkbox_blank_badge" . "\xf1176")
    ("nf-md-checkbox_blank_badge_outline" . "\xf0117")
    ("nf-md-checkbox_blank_circle" . "\xf0765")
    ("nf-md-checkbox_blank_circle_outline" . "\xf0766")
    ("nf-md-checkbox_blank_off" . "\xf12ec")
    ("nf-md-checkbox_blank_off_outline" . "\xf12ed")
    ("nf-md-checkbox_blank_outline" . "\xf0131")
    ("nf-md-checkbox_intermediate" . "\xf0856")
    ("nf-md-checkbox_marked" . "\xf0132")
    ("nf-md-checkbox_marked_circle" . "\xf0133")
    ("nf-md-checkbox_marked_circle_outline" . "\xf0134")
    ("nf-md-checkbox_marked_circle_plus_outline" . "\xf1927")
    ("nf-md-checkbox_marked_outline" . "\xf0135")
    ("nf-md-checkbox_multiple_blank" . "\xf0136")
    ("nf-md-checkbox_multiple_blank_circle" . "\xf063b")
    ("nf-md-checkbox_multiple_blank_circle_outline" . "\xf063c")
    ("nf-md-checkbox_multiple_blank_outline" . "\xf0137")
    ("nf-md-checkbox_multiple_marked" . "\xf0138")
    ("nf-md-checkbox_multiple_marked_circle" . "\xf063d")
    ("nf-md-checkbox_multiple_marked_circle_outline" . "\xf063e")
    ("nf-md-checkbox_multiple_marked_outline" . "\xf0139")
    ("nf-md-checkbox_multiple_outline" . "\xf0c51")
    ("nf-md-checkbox_outline" . "\xf0c52")
    ("nf-md-checkerboard" . "\xf013a")
    ("nf-md-checkerboard_minus" . "\xf1202")
    ("nf-md-checkerboard_plus" . "\xf1201")
    ("nf-md-checkerboard_remove" . "\xf1203")
    ("nf-md-cheese" . "\xf12b9")
    ("nf-md-cheese_off" . "\xf13ee")
    ("nf-md-chef_hat" . "\xf0b7c")
    ("nf-md-chemical_weapon" . "\xf013b")
    ("nf-md-chess_bishop" . "\xf085c")
    ("nf-md-chess_king" . "\xf0857")
    ("nf-md-chess_knight" . "\xf0858")
    ("nf-md-chess_pawn" . "\xf0859")
    ("nf-md-chess_queen" . "\xf085a")
    ("nf-md-chess_rook" . "\xf085b")
    ("nf-md-chevron_double_down" . "\xf013c")
    ("nf-md-chevron_double_left" . "\xf013d")
    ("nf-md-chevron_double_right" . "\xf013e")
    ("nf-md-chevron_double_up" . "\xf013f")
    ("nf-md-chevron_down" . "\xf0140")
    ("nf-md-chevron_down_box" . "\xf09d6")
    ("nf-md-chevron_down_box_outline" . "\xf09d7")
    ("nf-md-chevron_down_circle" . "\xf0b26")
    ("nf-md-chevron_down_circle_outline" . "\xf0b27")
    ("nf-md-chevron_left" . "\xf0141")
    ("nf-md-chevron_left_box" . "\xf09d8")
    ("nf-md-chevron_left_box_outline" . "\xf09d9")
    ("nf-md-chevron_left_circle" . "\xf0b28")
    ("nf-md-chevron_left_circle_outline" . "\xf0b29")
    ("nf-md-chevron_right" . "\xf0142")
    ("nf-md-chevron_right_box" . "\xf09da")
    ("nf-md-chevron_right_box_outline" . "\xf09db")
    ("nf-md-chevron_right_circle" . "\xf0b2a")
    ("nf-md-chevron_right_circle_outline" . "\xf0b2b")
    ("nf-md-chevron_triple_down" . "\xf0db9")
    ("nf-md-chevron_triple_left" . "\xf0dba")
    ("nf-md-chevron_triple_right" . "\xf0dbb")
    ("nf-md-chevron_triple_up" . "\xf0dbc")
    ("nf-md-chevron_up" . "\xf0143")
    ("nf-md-chevron_up_box" . "\xf09dc")
    ("nf-md-chevron_up_box_outline" . "\xf09dd")
    ("nf-md-chevron_up_circle" . "\xf0b2c")
    ("nf-md-chevron_up_circle_outline" . "\xf0b2d")
    ("nf-md-chili_alert" . "\xf17ea")
    ("nf-md-chili_alert_outline" . "\xf17eb")
    ("nf-md-chili_hot" . "\xf07b2")
    ("nf-md-chili_hot_outline" . "\xf17ec")
    ("nf-md-chili_medium" . "\xf07b3")
    ("nf-md-chili_medium_outline" . "\xf17ed")
    ("nf-md-chili_mild" . "\xf07b4")
    ("nf-md-chili_mild_outline" . "\xf17ee")
    ("nf-md-chili_off" . "\xf1467")
    ("nf-md-chili_off_outline" . "\xf17ef")
    ("nf-md-chip" . "\xf061a")
    ("nf-md-church" . "\xf0144")
    ("nf-md-cigar" . "\xf1189")
    ("nf-md-cigar_off" . "\xf141b")
    ("nf-md-circle_box" . "\xf15dc")
    ("nf-md-circle_box_outline" . "\xf15dd")
    ("nf-md-circle_double" . "\xf0e95")
    ("nf-md-circle_edit_outline" . "\xf08d5")
    ("nf-md-circle_expand" . "\xf0e96")
    ("nf-md-circle_half" . "\xf1395")
    ("nf-md-circle_half_full" . "\xf1396")
    ("nf-md-circle_medium" . "\xf09de")
    ("nf-md-circle_multiple" . "\xf0b38")
    ("nf-md-circle_multiple_outline" . "\xf0695")
    ("nf-md-circle_off_outline" . "\xf10d3")
    ("nf-md-circle_opacity" . "\xf1853")
    ("nf-md-circle_slice_1" . "\xf0a9e")
    ("nf-md-circle_slice_2" . "\xf0a9f")
    ("nf-md-circle_slice_3" . "\xf0aa0")
    ("nf-md-circle_slice_4" . "\xf0aa1")
    ("nf-md-circle_slice_5" . "\xf0aa2")
    ("nf-md-circle_slice_6" . "\xf0aa3")
    ("nf-md-circle_slice_7" . "\xf0aa4")
    ("nf-md-circle_slice_8" . "\xf0aa5")
    ("nf-md-circle_small" . "\xf09df")
    ("nf-md-circular_saw" . "\xf0e22")
    ("nf-md-city" . "\xf0146")
    ("nf-md-city_variant" . "\xf0a36")
    ("nf-md-city_variant_outline" . "\xf0a37")
    ("nf-md-clipboard" . "\xf0147")
    ("nf-md-clipboard_account" . "\xf0148")
    ("nf-md-clipboard_account_outline" . "\xf0c55")
    ("nf-md-clipboard_alert" . "\xf0149")
    ("nf-md-clipboard_alert_outline" . "\xf0cf7")
    ("nf-md-clipboard_arrow_down" . "\xf014a")
    ("nf-md-clipboard_arrow_down_outline" . "\xf0c56")
    ("nf-md-clipboard_arrow_left" . "\xf014b")
    ("nf-md-clipboard_arrow_left_outline" . "\xf0cf8")
    ("nf-md-clipboard_arrow_right" . "\xf0cf9")
    ("nf-md-clipboard_arrow_right_outline" . "\xf0cfa")
    ("nf-md-clipboard_arrow_up" . "\xf0c57")
    ("nf-md-clipboard_arrow_up_outline" . "\xf0c58")
    ("nf-md-clipboard_check" . "\xf014e")
    ("nf-md-clipboard_check_multiple" . "\xf1263")
    ("nf-md-clipboard_check_multiple_outline" . "\xf1264")
    ("nf-md-clipboard_check_outline" . "\xf08a8")
    ("nf-md-clipboard_clock" . "\xf16e2")
    ("nf-md-clipboard_clock_outline" . "\xf16e3")
    ("nf-md-clipboard_edit" . "\xf14e5")
    ("nf-md-clipboard_edit_outline" . "\xf14e6")
    ("nf-md-clipboard_file" . "\xf1265")
    ("nf-md-clipboard_file_outline" . "\xf1266")
    ("nf-md-clipboard_flow" . "\xf06c8")
    ("nf-md-clipboard_flow_outline" . "\xf1117")
    ("nf-md-clipboard_list" . "\xf10d4")
    ("nf-md-clipboard_list_outline" . "\xf10d5")
    ("nf-md-clipboard_minus" . "\xf1618")
    ("nf-md-clipboard_minus_outline" . "\xf1619")
    ("nf-md-clipboard_multiple" . "\xf1267")
    ("nf-md-clipboard_multiple_outline" . "\xf1268")
    ("nf-md-clipboard_off" . "\xf161a")
    ("nf-md-clipboard_off_outline" . "\xf161b")
    ("nf-md-clipboard_outline" . "\xf014c")
    ("nf-md-clipboard_play" . "\xf0c59")
    ("nf-md-clipboard_play_multiple" . "\xf1269")
    ("nf-md-clipboard_play_multiple_outline" . "\xf126a")
    ("nf-md-clipboard_play_outline" . "\xf0c5a")
    ("nf-md-clipboard_plus" . "\xf0751")
    ("nf-md-clipboard_plus_outline" . "\xf131f")
    ("nf-md-clipboard_pulse" . "\xf085d")
    ("nf-md-clipboard_pulse_outline" . "\xf085e")
    ("nf-md-clipboard_remove" . "\xf161c")
    ("nf-md-clipboard_remove_outline" . "\xf161d")
    ("nf-md-clipboard_search" . "\xf161e")
    ("nf-md-clipboard_search_outline" . "\xf161f")
    ("nf-md-clipboard_text" . "\xf014d")
    ("nf-md-clipboard_text_clock" . "\xf18f9")
    ("nf-md-clipboard_text_clock_outline" . "\xf18fa")
    ("nf-md-clipboard_text_multiple" . "\xf126b")
    ("nf-md-clipboard_text_multiple_outline" . "\xf126c")
    ("nf-md-clipboard_text_off" . "\xf1620")
    ("nf-md-clipboard_text_off_outline" . "\xf1621")
    ("nf-md-clipboard_text_outline" . "\xf0a38")
    ("nf-md-clipboard_text_play" . "\xf0c5b")
    ("nf-md-clipboard_text_play_outline" . "\xf0c5c")
    ("nf-md-clipboard_text_search" . "\xf1622")
    ("nf-md-clipboard_text_search_outline" . "\xf1623")
    ("nf-md-clippy" . "\xf014f")
    ("nf-md-clock" . "\xf0954")
    ("nf-md-clock_alert" . "\xf0955")
    ("nf-md-clock_alert_outline" . "\xf05ce")
    ("nf-md-clock_check" . "\xf0fa8")
    ("nf-md-clock_check_outline" . "\xf0fa9")
    ("nf-md-clock_digital" . "\xf0e97")
    ("nf-md-clock_edit" . "\xf19ba")
    ("nf-md-clock_edit_outline" . "\xf19bb")
    ("nf-md-clock_end" . "\xf0151")
    ("nf-md-clock_fast" . "\xf0152")
    ("nf-md-clock_in" . "\xf0153")
    ("nf-md-clock_minus" . "\xf1863")
    ("nf-md-clock_minus_outline" . "\xf1864")
    ("nf-md-clock_out" . "\xf0154")
    ("nf-md-clock_outline" . "\xf0150")
    ("nf-md-clock_plus" . "\xf1861")
    ("nf-md-clock_plus_outline" . "\xf1862")
    ("nf-md-clock_remove" . "\xf1865")
    ("nf-md-clock_remove_outline" . "\xf1866")
    ("nf-md-clock_start" . "\xf0155")
    ("nf-md-clock_time_eight" . "\xf1446")
    ("nf-md-clock_time_eight_outline" . "\xf1452")
    ("nf-md-clock_time_eleven" . "\xf1449")
    ("nf-md-clock_time_eleven_outline" . "\xf1455")
    ("nf-md-clock_time_five" . "\xf1443")
    ("nf-md-clock_time_five_outline" . "\xf144f")
    ("nf-md-clock_time_four" . "\xf1442")
    ("nf-md-clock_time_four_outline" . "\xf144e")
    ("nf-md-clock_time_nine" . "\xf1447")
    ("nf-md-clock_time_nine_outline" . "\xf1453")
    ("nf-md-clock_time_one" . "\xf143f")
    ("nf-md-clock_time_one_outline" . "\xf144b")
    ("nf-md-clock_time_seven" . "\xf1445")
    ("nf-md-clock_time_seven_outline" . "\xf1451")
    ("nf-md-clock_time_six" . "\xf1444")
    ("nf-md-clock_time_six_outline" . "\xf1450")
    ("nf-md-clock_time_ten" . "\xf1448")
    ("nf-md-clock_time_ten_outline" . "\xf1454")
    ("nf-md-clock_time_three" . "\xf1441")
    ("nf-md-clock_time_three_outline" . "\xf144d")
    ("nf-md-clock_time_twelve" . "\xf144a")
    ("nf-md-clock_time_twelve_outline" . "\xf1456")
    ("nf-md-clock_time_two" . "\xf1440")
    ("nf-md-clock_time_two_outline" . "\xf144c")
    ("nf-md-close" . "\xf0156")
    ("nf-md-close_box" . "\xf0157")
    ("nf-md-close_box_multiple" . "\xf0c5d")
    ("nf-md-close_box_multiple_outline" . "\xf0c5e")
    ("nf-md-close_box_outline" . "\xf0158")
    ("nf-md-close_circle" . "\xf0159")
    ("nf-md-close_circle_multiple" . "\xf062a")
    ("nf-md-close_circle_multiple_outline" . "\xf0883")
    ("nf-md-close_circle_outline" . "\xf015a")
    ("nf-md-close_network" . "\xf015b")
    ("nf-md-close_network_outline" . "\xf0c5f")
    ("nf-md-close_octagon" . "\xf015c")
    ("nf-md-close_octagon_outline" . "\xf015d")
    ("nf-md-close_outline" . "\xf06c9")
    ("nf-md-close_thick" . "\xf1398")
    ("nf-md-closed_caption" . "\xf015e")
    ("nf-md-closed_caption_outline" . "\xf0dbd")
    ("nf-md-cloud" . "\xf015f")
    ("nf-md-cloud_alert" . "\xf09e0")
    ("nf-md-cloud_braces" . "\xf07b5")
    ("nf-md-cloud_check" . "\xf0160")
    ("nf-md-cloud_check_outline" . "\xf12cc")
    ("nf-md-cloud_circle" . "\xf0161")
    ("nf-md-cloud_download" . "\xf0162")
    ("nf-md-cloud_download_outline" . "\xf0b7d")
    ("nf-md-cloud_lock" . "\xf11f1")
    ("nf-md-cloud_lock_outline" . "\xf11f2")
    ("nf-md-cloud_off_outline" . "\xf0164")
    ("nf-md-cloud_outline" . "\xf0163")
    ("nf-md-cloud_percent" . "\xf1a35")
    ("nf-md-cloud_percent_outline" . "\xf1a36")
    ("nf-md-cloud_print" . "\xf0165")
    ("nf-md-cloud_print_outline" . "\xf0166")
    ("nf-md-cloud_question" . "\xf0a39")
    ("nf-md-cloud_refresh" . "\xf052a")
    ("nf-md-cloud_search" . "\xf0956")
    ("nf-md-cloud_search_outline" . "\xf0957")
    ("nf-md-cloud_sync" . "\xf063f")
    ("nf-md-cloud_sync_outline" . "\xf12d6")
    ("nf-md-cloud_tags" . "\xf07b6")
    ("nf-md-cloud_upload" . "\xf0167")
    ("nf-md-cloud_upload_outline" . "\xf0b7e")
    ("nf-md-clover" . "\xf0816")
    ("nf-md-coach_lamp" . "\xf1020")
    ("nf-md-coach_lamp_variant" . "\xf1a37")
    ("nf-md-coat_rack" . "\xf109e")
    ("nf-md-code_array" . "\xf0168")
    ("nf-md-code_braces" . "\xf0169")
    ("nf-md-code_braces_box" . "\xf10d6")
    ("nf-md-code_brackets" . "\xf016a")
    ("nf-md-code_equal" . "\xf016b")
    ("nf-md-code_greater_than" . "\xf016c")
    ("nf-md-code_greater_than_or_equal" . "\xf016d")
    ("nf-md-code_json" . "\xf0626")
    ("nf-md-code_less_than" . "\xf016e")
    ("nf-md-code_less_than_or_equal" . "\xf016f")
    ("nf-md-code_not_equal" . "\xf0170")
    ("nf-md-code_not_equal_variant" . "\xf0171")
    ("nf-md-code_parentheses" . "\xf0172")
    ("nf-md-code_parentheses_box" . "\xf10d7")
    ("nf-md-code_string" . "\xf0173")
    ("nf-md-code_tags" . "\xf0174")
    ("nf-md-code_tags_check" . "\xf0694")
    ("nf-md-codepen" . "\xf0175")
    ("nf-md-coffee" . "\xf0176")
    ("nf-md-coffee_maker" . "\xf109f")
    ("nf-md-coffee_maker_check" . "\xf1931")
    ("nf-md-coffee_maker_check_outline" . "\xf1932")
    ("nf-md-coffee_maker_outline" . "\xf181b")
    ("nf-md-coffee_off" . "\xf0faa")
    ("nf-md-coffee_off_outline" . "\xf0fab")
    ("nf-md-coffee_outline" . "\xf06ca")
    ("nf-md-coffee_to_go" . "\xf0177")
    ("nf-md-coffee_to_go_outline" . "\xf130e")
    ("nf-md-coffin" . "\xf0b7f")
    ("nf-md-cog" . "\xf0493")
    ("nf-md-cog_box" . "\xf0494")
    ("nf-md-cog_clockwise" . "\xf11dd")
    ("nf-md-cog_counterclockwise" . "\xf11de")
    ("nf-md-cog_off" . "\xf13ce")
    ("nf-md-cog_off_outline" . "\xf13cf")
    ("nf-md-cog_outline" . "\xf08bb")
    ("nf-md-cog_pause" . "\xf1933")
    ("nf-md-cog_pause_outline" . "\xf1934")
    ("nf-md-cog_play" . "\xf1935")
    ("nf-md-cog_play_outline" . "\xf1936")
    ("nf-md-cog_refresh" . "\xf145e")
    ("nf-md-cog_refresh_outline" . "\xf145f")
    ("nf-md-cog_stop" . "\xf1937")
    ("nf-md-cog_stop_outline" . "\xf1938")
    ("nf-md-cog_sync" . "\xf1460")
    ("nf-md-cog_sync_outline" . "\xf1461")
    ("nf-md-cog_transfer" . "\xf105b")
    ("nf-md-cog_transfer_outline" . "\xf105c")
    ("nf-md-cogs" . "\xf08d6")
    ("nf-md-collage" . "\xf0640")
    ("nf-md-collapse_all" . "\xf0aa6")
    ("nf-md-collapse_all_outline" . "\xf0aa7")
    ("nf-md-color_helper" . "\xf0179")
    ("nf-md-comma" . "\xf0e23")
    ("nf-md-comma_box" . "\xf0e2b")
    ("nf-md-comma_box_outline" . "\xf0e24")
    ("nf-md-comma_circle" . "\xf0e25")
    ("nf-md-comma_circle_outline" . "\xf0e26")
    ("nf-md-comment" . "\xf017a")
    ("nf-md-comment_account" . "\xf017b")
    ("nf-md-comment_account_outline" . "\xf017c")
    ("nf-md-comment_alert" . "\xf017d")
    ("nf-md-comment_alert_outline" . "\xf017e")
    ("nf-md-comment_arrow_left" . "\xf09e1")
    ("nf-md-comment_arrow_left_outline" . "\xf09e2")
    ("nf-md-comment_arrow_right" . "\xf09e3")
    ("nf-md-comment_arrow_right_outline" . "\xf09e4")
    ("nf-md-comment_bookmark" . "\xf15ae")
    ("nf-md-comment_bookmark_outline" . "\xf15af")
    ("nf-md-comment_check" . "\xf017f")
    ("nf-md-comment_check_outline" . "\xf0180")
    ("nf-md-comment_edit" . "\xf11bf")
    ("nf-md-comment_edit_outline" . "\xf12c4")
    ("nf-md-comment_eye" . "\xf0a3a")
    ("nf-md-comment_eye_outline" . "\xf0a3b")
    ("nf-md-comment_flash" . "\xf15b0")
    ("nf-md-comment_flash_outline" . "\xf15b1")
    ("nf-md-comment_minus" . "\xf15df")
    ("nf-md-comment_minus_outline" . "\xf15e0")
    ("nf-md-comment_multiple" . "\xf085f")
    ("nf-md-comment_multiple_outline" . "\xf0181")
    ("nf-md-comment_off" . "\xf15e1")
    ("nf-md-comment_off_outline" . "\xf15e2")
    ("nf-md-comment_outline" . "\xf0182")
    ("nf-md-comment_plus" . "\xf09e5")
    ("nf-md-comment_plus_outline" . "\xf0183")
    ("nf-md-comment_processing" . "\xf0184")
    ("nf-md-comment_processing_outline" . "\xf0185")
    ("nf-md-comment_question" . "\xf0817")
    ("nf-md-comment_question_outline" . "\xf0186")
    ("nf-md-comment_quote" . "\xf1021")
    ("nf-md-comment_quote_outline" . "\xf1022")
    ("nf-md-comment_remove" . "\xf05de")
    ("nf-md-comment_remove_outline" . "\xf0187")
    ("nf-md-comment_search" . "\xf0a3c")
    ("nf-md-comment_search_outline" . "\xf0a3d")
    ("nf-md-comment_text" . "\xf0188")
    ("nf-md-comment_text_multiple" . "\xf0860")
    ("nf-md-comment_text_multiple_outline" . "\xf0861")
    ("nf-md-comment_text_outline" . "\xf0189")
    ("nf-md-compare" . "\xf018a")
    ("nf-md-compare_horizontal" . "\xf1492")
    ("nf-md-compare_remove" . "\xf18b3")
    ("nf-md-compare_vertical" . "\xf1493")
    ("nf-md-compass" . "\xf018b")
    ("nf-md-compass_off" . "\xf0b80")
    ("nf-md-compass_off_outline" . "\xf0b81")
    ("nf-md-compass_outline" . "\xf018c")
    ("nf-md-compass_rose" . "\xf1382")
    ("nf-md-compost" . "\xf1a38")
    ("nf-md-cone" . "\xf194c")
    ("nf-md-cone_off" . "\xf194d")
    ("nf-md-connection" . "\xf1616")
    ("nf-md-console" . "\xf018d")
    ("nf-md-console_line" . "\xf07b7")
    ("nf-md-console_network" . "\xf08a9")
    ("nf-md-console_network_outline" . "\xf0c60")
    ("nf-md-consolidate" . "\xf10d8")
    ("nf-md-contactless_payment" . "\xf0d6a")
    ("nf-md-contactless_payment_circle" . "\xf0321")
    ("nf-md-contactless_payment_circle_outline" . "\xf0408")
    ("nf-md-contacts" . "\xf06cb")
    ("nf-md-contacts_outline" . "\xf05b8")
    ("nf-md-contain" . "\xf0a3e")
    ("nf-md-contain_end" . "\xf0a3f")
    ("nf-md-contain_start" . "\xf0a40")
    ("nf-md-content_copy" . "\xf018f")
    ("nf-md-content_cut" . "\xf0190")
    ("nf-md-content_duplicate" . "\xf0191")
    ("nf-md-content_paste" . "\xf0192")
    ("nf-md-content_save" . "\xf0193")
    ("nf-md-content_save_alert" . "\xf0f42")
    ("nf-md-content_save_alert_outline" . "\xf0f43")
    ("nf-md-content_save_all" . "\xf0194")
    ("nf-md-content_save_all_outline" . "\xf0f44")
    ("nf-md-content_save_check" . "\xf18ea")
    ("nf-md-content_save_check_outline" . "\xf18eb")
    ("nf-md-content_save_cog" . "\xf145b")
    ("nf-md-content_save_cog_outline" . "\xf145c")
    ("nf-md-content_save_edit" . "\xf0cfb")
    ("nf-md-content_save_edit_outline" . "\xf0cfc")
    ("nf-md-content_save_move" . "\xf0e27")
    ("nf-md-content_save_move_outline" . "\xf0e28")
    ("nf-md-content_save_off" . "\xf1643")
    ("nf-md-content_save_off_outline" . "\xf1644")
    ("nf-md-content_save_outline" . "\xf0818")
    ("nf-md-content_save_settings" . "\xf061b")
    ("nf-md-content_save_settings_outline" . "\xf0b2e")
    ("nf-md-contrast" . "\xf0195")
    ("nf-md-contrast_box" . "\xf0196")
    ("nf-md-contrast_circle" . "\xf0197")
    ("nf-md-controller_classic" . "\xf0b82")
    ("nf-md-controller_classic_outline" . "\xf0b83")
    ("nf-md-cookie" . "\xf0198")
    ("nf-md-cookie_alert" . "\xf16d0")
    ("nf-md-cookie_alert_outline" . "\xf16d1")
    ("nf-md-cookie_check" . "\xf16d2")
    ("nf-md-cookie_check_outline" . "\xf16d3")
    ("nf-md-cookie_clock" . "\xf16e4")
    ("nf-md-cookie_clock_outline" . "\xf16e5")
    ("nf-md-cookie_cog" . "\xf16d4")
    ("nf-md-cookie_cog_outline" . "\xf16d5")
    ("nf-md-cookie_edit" . "\xf16e6")
    ("nf-md-cookie_edit_outline" . "\xf16e7")
    ("nf-md-cookie_lock" . "\xf16e8")
    ("nf-md-cookie_lock_outline" . "\xf16e9")
    ("nf-md-cookie_minus" . "\xf16da")
    ("nf-md-cookie_minus_outline" . "\xf16db")
    ("nf-md-cookie_off" . "\xf16ea")
    ("nf-md-cookie_off_outline" . "\xf16eb")
    ("nf-md-cookie_outline" . "\xf16de")
    ("nf-md-cookie_plus" . "\xf16d6")
    ("nf-md-cookie_plus_outline" . "\xf16d7")
    ("nf-md-cookie_refresh" . "\xf16ec")
    ("nf-md-cookie_refresh_outline" . "\xf16ed")
    ("nf-md-cookie_remove" . "\xf16d8")
    ("nf-md-cookie_remove_outline" . "\xf16d9")
    ("nf-md-cookie_settings" . "\xf16dc")
    ("nf-md-cookie_settings_outline" . "\xf16dd")
    ("nf-md-coolant_temperature" . "\xf03c8")
    ("nf-md-copyleft" . "\xf1939")
    ("nf-md-copyright" . "\xf05e6")
    ("nf-md-cordova" . "\xf0958")
    ("nf-md-corn" . "\xf07b8")
    ("nf-md-corn_off" . "\xf13ef")
    ("nf-md-cosine_wave" . "\xf1479")
    ("nf-md-counter" . "\xf0199")
    ("nf-md-countertop" . "\xf181c")
    ("nf-md-countertop_outline" . "\xf181d")
    ("nf-md-cow" . "\xf019a")
    ("nf-md-cow_off" . "\xf18fc")
    ("nf-md-cpu_32_bit" . "\xf0edf")
    ("nf-md-cpu_64_bit" . "\xf0ee0")
    ("nf-md-cradle" . "\xf198b")
    ("nf-md-cradle_outline" . "\xf1991")
    ("nf-md-crane" . "\xf0862")
    ("nf-md-creation" . "\xf0674")
    ("nf-md-creative_commons" . "\xf0d6b")
    ("nf-md-credit_card" . "\xf0fef")
    ("nf-md-credit_card_check" . "\xf13d0")
    ("nf-md-credit_card_check_outline" . "\xf13d1")
    ("nf-md-credit_card_chip" . "\xf190f")
    ("nf-md-credit_card_chip_outline" . "\xf1910")
    ("nf-md-credit_card_clock" . "\xf0ee1")
    ("nf-md-credit_card_clock_outline" . "\xf0ee2")
    ("nf-md-credit_card_edit" . "\xf17d7")
    ("nf-md-credit_card_edit_outline" . "\xf17d8")
    ("nf-md-credit_card_fast" . "\xf1911")
    ("nf-md-credit_card_fast_outline" . "\xf1912")
    ("nf-md-credit_card_lock" . "\xf18e7")
    ("nf-md-credit_card_lock_outline" . "\xf18e8")
    ("nf-md-credit_card_marker" . "\xf06a8")
    ("nf-md-credit_card_marker_outline" . "\xf0dbe")
    ("nf-md-credit_card_minus" . "\xf0fac")
    ("nf-md-credit_card_minus_outline" . "\xf0fad")
    ("nf-md-credit_card_multiple" . "\xf0ff0")
    ("nf-md-credit_card_multiple_outline" . "\xf019c")
    ("nf-md-credit_card_off" . "\xf0ff1")
    ("nf-md-credit_card_off_outline" . "\xf05e4")
    ("nf-md-credit_card_outline" . "\xf019b")
    ("nf-md-credit_card_plus" . "\xf0ff2")
    ("nf-md-credit_card_plus_outline" . "\xf0676")
    ("nf-md-credit_card_refresh" . "\xf1645")
    ("nf-md-credit_card_refresh_outline" . "\xf1646")
    ("nf-md-credit_card_refund" . "\xf0ff3")
    ("nf-md-credit_card_refund_outline" . "\xf0aa8")
    ("nf-md-credit_card_remove" . "\xf0fae")
    ("nf-md-credit_card_remove_outline" . "\xf0faf")
    ("nf-md-credit_card_scan" . "\xf0ff4")
    ("nf-md-credit_card_scan_outline" . "\xf019d")
    ("nf-md-credit_card_search" . "\xf1647")
    ("nf-md-credit_card_search_outline" . "\xf1648")
    ("nf-md-credit_card_settings" . "\xf0ff5")
    ("nf-md-credit_card_settings_outline" . "\xf08d7")
    ("nf-md-credit_card_sync" . "\xf1649")
    ("nf-md-credit_card_sync_outline" . "\xf164a")
    ("nf-md-credit_card_wireless" . "\xf0802")
    ("nf-md-credit_card_wireless_off" . "\xf057a")
    ("nf-md-credit_card_wireless_off_outline" . "\xf057b")
    ("nf-md-credit_card_wireless_outline" . "\xf0d6c")
    ("nf-md-cricket" . "\xf0d6d")
    ("nf-md-crop" . "\xf019e")
    ("nf-md-crop_free" . "\xf019f")
    ("nf-md-crop_landscape" . "\xf01a0")
    ("nf-md-crop_portrait" . "\xf01a1")
    ("nf-md-crop_rotate" . "\xf0696")
    ("nf-md-crop_square" . "\xf01a2")
    ("nf-md-cross" . "\xf0953")
    ("nf-md-cross_bolnisi" . "\xf0ced")
    ("nf-md-cross_celtic" . "\xf0cf5")
    ("nf-md-cross_outline" . "\xf0cf6")
    ("nf-md-crosshairs" . "\xf01a3")
    ("nf-md-crosshairs_gps" . "\xf01a4")
    ("nf-md-crosshairs_off" . "\xf0f45")
    ("nf-md-crosshairs_question" . "\xf1136")
    ("nf-md-crowd" . "\xf1975")
    ("nf-md-crown" . "\xf01a5")
    ("nf-md-crown_circle" . "\xf17dc")
    ("nf-md-crown_circle_outline" . "\xf17dd")
    ("nf-md-crown_outline" . "\xf11d0")
    ("nf-md-cryengine" . "\xf0959")
    ("nf-md-crystal_ball" . "\xf0b2f")
    ("nf-md-cube" . "\xf01a6")
    ("nf-md-cube_off" . "\xf141c")
    ("nf-md-cube_off_outline" . "\xf141d")
    ("nf-md-cube_outline" . "\xf01a7")
    ("nf-md-cube_scan" . "\xf0b84")
    ("nf-md-cube_send" . "\xf01a8")
    ("nf-md-cube_unfolded" . "\xf01a9")
    ("nf-md-cup" . "\xf01aa")
    ("nf-md-cup_off" . "\xf05e5")
    ("nf-md-cup_off_outline" . "\xf137d")
    ("nf-md-cup_outline" . "\xf130f")
    ("nf-md-cup_water" . "\xf01ab")
    ("nf-md-cupboard" . "\xf0f46")
    ("nf-md-cupboard_outline" . "\xf0f47")
    ("nf-md-cupcake" . "\xf095a")
    ("nf-md-curling" . "\xf0863")
    ("nf-md-currency_bdt" . "\xf0864")
    ("nf-md-currency_brl" . "\xf0b85")
    ("nf-md-currency_btc" . "\xf01ac")
    ("nf-md-currency_cny" . "\xf07ba")
    ("nf-md-currency_eth" . "\xf07bb")
    ("nf-md-currency_eur" . "\xf01ad")
    ("nf-md-currency_eur_off" . "\xf1315")
    ("nf-md-currency_fra" . "\xf1a39")
    ("nf-md-currency_gbp" . "\xf01ae")
    ("nf-md-currency_ils" . "\xf0c61")
    ("nf-md-currency_inr" . "\xf01af")
    ("nf-md-currency_jpy" . "\xf07bc")
    ("nf-md-currency_krw" . "\xf07bd")
    ("nf-md-currency_kzt" . "\xf0865")
    ("nf-md-currency_mnt" . "\xf1512")
    ("nf-md-currency_ngn" . "\xf01b0")
    ("nf-md-currency_php" . "\xf09e6")
    ("nf-md-currency_rial" . "\xf0e9c")
    ("nf-md-currency_rub" . "\xf01b1")
    ("nf-md-currency_rupee" . "\xf1976")
    ("nf-md-currency_sign" . "\xf07be")
    ("nf-md-currency_try" . "\xf01b2")
    ("nf-md-currency_twd" . "\xf07bf")
    ("nf-md-currency_usd" . "\xf01c1")
    ("nf-md-currency_usd_off" . "\xf067a")
    ("nf-md-current_ac" . "\xf1480")
    ("nf-md-current_dc" . "\xf095c")
    ("nf-md-cursor_default" . "\xf01c0")
    ("nf-md-cursor_default_click" . "\xf0cfd")
    ("nf-md-cursor_default_click_outline" . "\xf0cfe")
    ("nf-md-cursor_default_gesture" . "\xf1127")
    ("nf-md-cursor_default_gesture_outline" . "\xf1128")
    ("nf-md-cursor_default_outline" . "\xf01bf")
    ("nf-md-cursor_move" . "\xf01be")
    ("nf-md-cursor_pointer" . "\xf01bd")
    ("nf-md-cursor_text" . "\xf05e7")
    ("nf-md-curtains" . "\xf1846")
    ("nf-md-curtains_closed" . "\xf1847")
    ("nf-md-cylinder" . "\xf194e")
    ("nf-md-cylinder_off" . "\xf194f")
    ("nf-md-dance_ballroom" . "\xf15fb")
    ("nf-md-dance_pole" . "\xf1578")
    ("nf-md-data_matrix" . "\xf153c")
    ("nf-md-data_matrix_edit" . "\xf153d")
    ("nf-md-data_matrix_minus" . "\xf153e")
    ("nf-md-data_matrix_plus" . "\xf153f")
    ("nf-md-data_matrix_remove" . "\xf1540")
    ("nf-md-data_matrix_scan" . "\xf1541")
    ("nf-md-database" . "\xf01bc")
    ("nf-md-database_alert" . "\xf163a")
    ("nf-md-database_alert_outline" . "\xf1624")
    ("nf-md-database_arrow_down" . "\xf163b")
    ("nf-md-database_arrow_down_outline" . "\xf1625")
    ("nf-md-database_arrow_left" . "\xf163c")
    ("nf-md-database_arrow_left_outline" . "\xf1626")
    ("nf-md-database_arrow_right" . "\xf163d")
    ("nf-md-database_arrow_right_outline" . "\xf1627")
    ("nf-md-database_arrow_up" . "\xf163e")
    ("nf-md-database_arrow_up_outline" . "\xf1628")
    ("nf-md-database_check" . "\xf0aa9")
    ("nf-md-database_check_outline" . "\xf1629")
    ("nf-md-database_clock" . "\xf163f")
    ("nf-md-database_clock_outline" . "\xf162a")
    ("nf-md-database_cog" . "\xf164b")
    ("nf-md-database_cog_outline" . "\xf164c")
    ("nf-md-database_edit" . "\xf0b86")
    ("nf-md-database_edit_outline" . "\xf162b")
    ("nf-md-database_export" . "\xf095e")
    ("nf-md-database_export_outline" . "\xf162c")
    ("nf-md-database_eye" . "\xf191f")
    ("nf-md-database_eye_off" . "\xf1920")
    ("nf-md-database_eye_off_outline" . "\xf1921")
    ("nf-md-database_eye_outline" . "\xf1922")
    ("nf-md-database_import" . "\xf095d")
    ("nf-md-database_import_outline" . "\xf162d")
    ("nf-md-database_lock" . "\xf0aaa")
    ("nf-md-database_lock_outline" . "\xf162e")
    ("nf-md-database_marker" . "\xf12f6")
    ("nf-md-database_marker_outline" . "\xf162f")
    ("nf-md-database_minus" . "\xf01bb")
    ("nf-md-database_minus_outline" . "\xf1630")
    ("nf-md-database_off" . "\xf1640")
    ("nf-md-database_off_outline" . "\xf1631")
    ("nf-md-database_outline" . "\xf1632")
    ("nf-md-database_plus" . "\xf01ba")
    ("nf-md-database_plus_outline" . "\xf1633")
    ("nf-md-database_refresh" . "\xf05c2")
    ("nf-md-database_refresh_outline" . "\xf1634")
    ("nf-md-database_remove" . "\xf0d00")
    ("nf-md-database_remove_outline" . "\xf1635")
    ("nf-md-database_search" . "\xf0866")
    ("nf-md-database_search_outline" . "\xf1636")
    ("nf-md-database_settings" . "\xf0d01")
    ("nf-md-database_settings_outline" . "\xf1637")
    ("nf-md-database_sync" . "\xf0cff")
    ("nf-md-database_sync_outline" . "\xf1638")
    ("nf-md-death_star" . "\xf08d8")
    ("nf-md-death_star_variant" . "\xf08d9")
    ("nf-md-deathly_hallows" . "\xf0b87")
    ("nf-md-debian" . "\xf08da")
    ("nf-md-debug_step_into" . "\xf01b9")
    ("nf-md-debug_step_out" . "\xf01b8")
    ("nf-md-debug_step_over" . "\xf01b7")
    ("nf-md-decagram" . "\xf076c")
    ("nf-md-decagram_outline" . "\xf076d")
    ("nf-md-decimal" . "\xf10a1")
    ("nf-md-decimal_comma" . "\xf10a2")
    ("nf-md-decimal_comma_decrease" . "\xf10a3")
    ("nf-md-decimal_comma_increase" . "\xf10a4")
    ("nf-md-decimal_decrease" . "\xf01b6")
    ("nf-md-decimal_increase" . "\xf01b5")
    ("nf-md-delete" . "\xf01b4")
    ("nf-md-delete_alert" . "\xf10a5")
    ("nf-md-delete_alert_outline" . "\xf10a6")
    ("nf-md-delete_circle" . "\xf0683")
    ("nf-md-delete_circle_outline" . "\xf0b88")
    ("nf-md-delete_clock" . "\xf1556")
    ("nf-md-delete_clock_outline" . "\xf1557")
    ("nf-md-delete_empty" . "\xf06cc")
    ("nf-md-delete_empty_outline" . "\xf0e9d")
    ("nf-md-delete_forever" . "\xf05e8")
    ("nf-md-delete_forever_outline" . "\xf0b89")
    ("nf-md-delete_off" . "\xf10a7")
    ("nf-md-delete_off_outline" . "\xf10a8")
    ("nf-md-delete_outline" . "\xf09e7")
    ("nf-md-delete_restore" . "\xf0819")
    ("nf-md-delete_sweep" . "\xf05e9")
    ("nf-md-delete_sweep_outline" . "\xf0c62")
    ("nf-md-delete_variant" . "\xf01b3")
    ("nf-md-delta" . "\xf01c2")
    ("nf-md-desk" . "\xf1239")
    ("nf-md-desk_lamp" . "\xf095f")
    ("nf-md-deskphone" . "\xf01c3")
    ("nf-md-desktop_classic" . "\xf07c0")
    ("nf-md-desktop_mac" . "\xf01c4")
    ("nf-md-desktop_mac_dashboard" . "\xf09e8")
    ("nf-md-desktop_tower" . "\xf01c5")
    ("nf-md-desktop_tower_monitor" . "\xf0aab")
    ("nf-md-details" . "\xf01c6")
    ("nf-md-dev_to" . "\xf0d6e")
    ("nf-md-developer_board" . "\xf0697")
    ("nf-md-deviantart" . "\xf01c7")
    ("nf-md-devices" . "\xf0fb0")
    ("nf-md-dharmachakra" . "\xf094b")
    ("nf-md-diabetes" . "\xf1126")
    ("nf-md-dialpad" . "\xf061c")
    ("nf-md-diameter" . "\xf0c63")
    ("nf-md-diameter_outline" . "\xf0c64")
    ("nf-md-diameter_variant" . "\xf0c65")
    ("nf-md-diamond" . "\xf0b8a")
    ("nf-md-diamond_outline" . "\xf0b8b")
    ("nf-md-diamond_stone" . "\xf01c8")
    ("nf-md-dice_1" . "\xf01ca")
    ("nf-md-dice_1_outline" . "\xf114a")
    ("nf-md-dice_2" . "\xf01cb")
    ("nf-md-dice_2_outline" . "\xf114b")
    ("nf-md-dice_3" . "\xf01cc")
    ("nf-md-dice_3_outline" . "\xf114c")
    ("nf-md-dice_4" . "\xf01cd")
    ("nf-md-dice_4_outline" . "\xf114d")
    ("nf-md-dice_5" . "\xf01ce")
    ("nf-md-dice_5_outline" . "\xf114e")
    ("nf-md-dice_6" . "\xf01cf")
    ("nf-md-dice_6_outline" . "\xf114f")
    ("nf-md-dice_d10" . "\xf1153")
    ("nf-md-dice_d10_outline" . "\xf076f")
    ("nf-md-dice_d12" . "\xf1154")
    ("nf-md-dice_d12_outline" . "\xf0867")
    ("nf-md-dice_d20" . "\xf1155")
    ("nf-md-dice_d20_outline" . "\xf05ea")
    ("nf-md-dice_d4" . "\xf1150")
    ("nf-md-dice_d4_outline" . "\xf05eb")
    ("nf-md-dice_d6" . "\xf1151")
    ("nf-md-dice_d6_outline" . "\xf05ed")
    ("nf-md-dice_d8" . "\xf1152")
    ("nf-md-dice_d8_outline" . "\xf05ec")
    ("nf-md-dice_multiple" . "\xf076e")
    ("nf-md-dice_multiple_outline" . "\xf1156")
    ("nf-md-digital_ocean" . "\xf1237")
    ("nf-md-dip_switch" . "\xf07c1")
    ("nf-md-directions" . "\xf01d0")
    ("nf-md-directions_fork" . "\xf0641")
    ("nf-md-disc" . "\xf05ee")
    ("nf-md-disc_alert" . "\xf01d1")
    ("nf-md-disc_player" . "\xf0960")
    ("nf-md-discord" . "\xf066f")
    ("nf-md-dishwasher" . "\xf0aac")
    ("nf-md-dishwasher_alert" . "\xf11b8")
    ("nf-md-dishwasher_off" . "\xf11b9")
    ("nf-md-disqus" . "\xf01d2")
    ("nf-md-distribute_horizontal_center" . "\xf11c9")
    ("nf-md-distribute_horizontal_left" . "\xf11c8")
    ("nf-md-distribute_horizontal_right" . "\xf11ca")
    ("nf-md-distribute_vertical_bottom" . "\xf11cb")
    ("nf-md-distribute_vertical_center" . "\xf11cc")
    ("nf-md-distribute_vertical_top" . "\xf11cd")
    ("nf-md-diversify" . "\xf1877")
    ("nf-md-diving" . "\xf1977")
    ("nf-md-diving_flippers" . "\xf0dbf")
    ("nf-md-diving_helmet" . "\xf0dc0")
    ("nf-md-diving_scuba" . "\xf0dc1")
    ("nf-md-diving_scuba_flag" . "\xf0dc2")
    ("nf-md-diving_scuba_tank" . "\xf0dc3")
    ("nf-md-diving_scuba_tank_multiple" . "\xf0dc4")
    ("nf-md-diving_snorkel" . "\xf0dc5")
    ("nf-md-division" . "\xf01d4")
    ("nf-md-division_box" . "\xf01d5")
    ("nf-md-dlna" . "\xf0a41")
    ("nf-md-dna" . "\xf0684")
    ("nf-md-dns" . "\xf01d6")
    ("nf-md-dns_outline" . "\xf0b8c")
    ("nf-md-dock_bottom" . "\xf10a9")
    ("nf-md-dock_left" . "\xf10aa")
    ("nf-md-dock_right" . "\xf10ab")
    ("nf-md-dock_top" . "\xf1513")
    ("nf-md-dock_window" . "\xf10ac")
    ("nf-md-docker" . "\xf0868")
    ("nf-md-doctor" . "\xf0a42")
    ("nf-md-dog" . "\xf0a43")
    ("nf-md-dog_service" . "\xf0aad")
    ("nf-md-dog_side" . "\xf0a44")
    ("nf-md-dog_side_off" . "\xf16ee")
    ("nf-md-dolby" . "\xf06b3")
    ("nf-md-dolly" . "\xf0e9e")
    ("nf-md-dolphin" . "\xf18b4")
    ("nf-md-domain" . "\xf01d7")
    ("nf-md-domain_off" . "\xf0d6f")
    ("nf-md-domain_plus" . "\xf10ad")
    ("nf-md-domain_remove" . "\xf10ae")
    ("nf-md-dome_light" . "\xf141e")
    ("nf-md-domino_mask" . "\xf1023")
    ("nf-md-donkey" . "\xf07c2")
    ("nf-md-door" . "\xf081a")
    ("nf-md-door_closed" . "\xf081b")
    ("nf-md-door_closed_lock" . "\xf10af")
    ("nf-md-door_open" . "\xf081c")
    ("nf-md-door_sliding" . "\xf181e")
    ("nf-md-door_sliding_lock" . "\xf181f")
    ("nf-md-door_sliding_open" . "\xf1820")
    ("nf-md-doorbell" . "\xf12e6")
    ("nf-md-doorbell_video" . "\xf0869")
    ("nf-md-dot_net" . "\xf0aae")
    ("nf-md-dots_circle" . "\xf1978")
    ("nf-md-dots_grid" . "\xf15fc")
    ("nf-md-dots_hexagon" . "\xf15ff")
    ("nf-md-dots_horizontal" . "\xf01d8")
    ("nf-md-dots_horizontal_circle" . "\xf07c3")
    ("nf-md-dots_horizontal_circle_outline" . "\xf0b8d")
    ("nf-md-dots_square" . "\xf15fd")
    ("nf-md-dots_triangle" . "\xf15fe")
    ("nf-md-dots_vertical" . "\xf01d9")
    ("nf-md-dots_vertical_circle" . "\xf07c4")
    ("nf-md-dots_vertical_circle_outline" . "\xf0b8e")
    ("nf-md-download" . "\xf01da")
    ("nf-md-download_box" . "\xf1462")
    ("nf-md-download_box_outline" . "\xf1463")
    ("nf-md-download_circle" . "\xf1464")
    ("nf-md-download_circle_outline" . "\xf1465")
    ("nf-md-download_lock" . "\xf1320")
    ("nf-md-download_lock_outline" . "\xf1321")
    ("nf-md-download_multiple" . "\xf09e9")
    ("nf-md-download_network" . "\xf06f4")
    ("nf-md-download_network_outline" . "\xf0c66")
    ("nf-md-download_off" . "\xf10b0")
    ("nf-md-download_off_outline" . "\xf10b1")
    ("nf-md-download_outline" . "\xf0b8f")
    ("nf-md-drag" . "\xf01db")
    ("nf-md-drag_horizontal" . "\xf01dc")
    ("nf-md-drag_horizontal_variant" . "\xf12f0")
    ("nf-md-drag_variant" . "\xf0b90")
    ("nf-md-drag_vertical" . "\xf01dd")
    ("nf-md-drag_vertical_variant" . "\xf12f1")
    ("nf-md-drama_masks" . "\xf0d02")
    ("nf-md-draw" . "\xf0f49")
    ("nf-md-draw_pen" . "\xf19b9")
    ("nf-md-drawing" . "\xf01de")
    ("nf-md-drawing_box" . "\xf01df")
    ("nf-md-dresser" . "\xf0f4a")
    ("nf-md-dresser_outline" . "\xf0f4b")
    ("nf-md-drone" . "\xf01e2")
    ("nf-md-dropbox" . "\xf01e3")
    ("nf-md-drupal" . "\xf01e4")
    ("nf-md-duck" . "\xf01e5")
    ("nf-md-dumbbell" . "\xf01e6")
    ("nf-md-dump_truck" . "\xf0c67")
    ("nf-md-ear_hearing" . "\xf07c5")
    ("nf-md-ear_hearing_loop" . "\xf1aee")
    ("nf-md-ear_hearing_off" . "\xf0a45")
    ("nf-md-earbuds" . "\xf184f")
    ("nf-md-earbuds_off" . "\xf1850")
    ("nf-md-earbuds_off_outline" . "\xf1851")
    ("nf-md-earbuds_outline" . "\xf1852")
    ("nf-md-earth" . "\xf01e7")
    ("nf-md-earth_arrow_right" . "\xf1311")
    ("nf-md-earth_box" . "\xf06cd")
    ("nf-md-earth_box_minus" . "\xf1407")
    ("nf-md-earth_box_off" . "\xf06ce")
    ("nf-md-earth_box_plus" . "\xf1406")
    ("nf-md-earth_box_remove" . "\xf1408")
    ("nf-md-earth_minus" . "\xf1404")
    ("nf-md-earth_off" . "\xf01e8")
    ("nf-md-earth_plus" . "\xf1403")
    ("nf-md-earth_remove" . "\xf1405")
    ("nf-md-egg" . "\xf0aaf")
    ("nf-md-egg_easter" . "\xf0ab0")
    ("nf-md-egg_fried" . "\xf184a")
    ("nf-md-egg_off" . "\xf13f0")
    ("nf-md-egg_off_outline" . "\xf13f1")
    ("nf-md-egg_outline" . "\xf13f2")
    ("nf-md-eiffel_tower" . "\xf156b")
    ("nf-md-eight_track" . "\xf09ea")
    ("nf-md-eject" . "\xf01ea")
    ("nf-md-eject_outline" . "\xf0b91")
    ("nf-md-electric_switch" . "\xf0e9f")
    ("nf-md-electric_switch_closed" . "\xf10d9")
    ("nf-md-electron_framework" . "\xf1024")
    ("nf-md-elephant" . "\xf07c6")
    ("nf-md-elevation_decline" . "\xf01eb")
    ("nf-md-elevation_rise" . "\xf01ec")
    ("nf-md-elevator" . "\xf01ed")
    ("nf-md-elevator_down" . "\xf12c2")
    ("nf-md-elevator_passenger" . "\xf1381")
    ("nf-md-elevator_passenger_off" . "\xf1979")
    ("nf-md-elevator_passenger_off_outline" . "\xf197a")
    ("nf-md-elevator_passenger_outline" . "\xf197b")
    ("nf-md-elevator_up" . "\xf12c1")
    ("nf-md-ellipse" . "\xf0ea0")
    ("nf-md-ellipse_outline" . "\xf0ea1")
    ("nf-md-email" . "\xf01ee")
    ("nf-md-email_alert" . "\xf06cf")
    ("nf-md-email_alert_outline" . "\xf0d42")
    ("nf-md-email_box" . "\xf0d03")
    ("nf-md-email_check" . "\xf0ab1")
    ("nf-md-email_check_outline" . "\xf0ab2")
    ("nf-md-email_edit" . "\xf0ee3")
    ("nf-md-email_edit_outline" . "\xf0ee4")
    ("nf-md-email_fast" . "\xf186f")
    ("nf-md-email_fast_outline" . "\xf1870")
    ("nf-md-email_lock" . "\xf01f1")
    ("nf-md-email_mark_as_unread" . "\xf0b92")
    ("nf-md-email_minus" . "\xf0ee5")
    ("nf-md-email_minus_outline" . "\xf0ee6")
    ("nf-md-email_multiple" . "\xf0ee7")
    ("nf-md-email_multiple_outline" . "\xf0ee8")
    ("nf-md-email_newsletter" . "\xf0fb1")
    ("nf-md-email_off" . "\xf13e3")
    ("nf-md-email_off_outline" . "\xf13e4")
    ("nf-md-email_open" . "\xf01ef")
    ("nf-md-email_open_multiple" . "\xf0ee9")
    ("nf-md-email_open_multiple_outline" . "\xf0eea")
    ("nf-md-email_open_outline" . "\xf05ef")
    ("nf-md-email_outline" . "\xf01f0")
    ("nf-md-email_plus" . "\xf09eb")
    ("nf-md-email_plus_outline" . "\xf09ec")
    ("nf-md-email_receive" . "\xf10da")
    ("nf-md-email_receive_outline" . "\xf10db")
    ("nf-md-email_remove" . "\xf1661")
    ("nf-md-email_remove_outline" . "\xf1662")
    ("nf-md-email_seal" . "\xf195b")
    ("nf-md-email_seal_outline" . "\xf195c")
    ("nf-md-email_search" . "\xf0961")
    ("nf-md-email_search_outline" . "\xf0962")
    ("nf-md-email_send" . "\xf10dc")
    ("nf-md-email_send_outline" . "\xf10dd")
    ("nf-md-email_sync" . "\xf12c7")
    ("nf-md-email_sync_outline" . "\xf12c8")
    ("nf-md-email_variant" . "\xf05f0")
    ("nf-md-ember" . "\xf0b30")
    ("nf-md-emby" . "\xf06b4")
    ("nf-md-emoticon" . "\xf0c68")
    ("nf-md-emoticon_angry" . "\xf0c69")
    ("nf-md-emoticon_angry_outline" . "\xf0c6a")
    ("nf-md-emoticon_confused" . "\xf10de")
    ("nf-md-emoticon_confused_outline" . "\xf10df")
    ("nf-md-emoticon_cool" . "\xf0c6b")
    ("nf-md-emoticon_cool_outline" . "\xf01f3")
    ("nf-md-emoticon_cry" . "\xf0c6c")
    ("nf-md-emoticon_cry_outline" . "\xf0c6d")
    ("nf-md-emoticon_dead" . "\xf0c6e")
    ("nf-md-emoticon_dead_outline" . "\xf069b")
    ("nf-md-emoticon_devil" . "\xf0c6f")
    ("nf-md-emoticon_devil_outline" . "\xf01f4")
    ("nf-md-emoticon_excited" . "\xf0c70")
    ("nf-md-emoticon_excited_outline" . "\xf069c")
    ("nf-md-emoticon_frown" . "\xf0f4c")
    ("nf-md-emoticon_frown_outline" . "\xf0f4d")
    ("nf-md-emoticon_happy" . "\xf0c71")
    ("nf-md-emoticon_happy_outline" . "\xf01f5")
    ("nf-md-emoticon_kiss" . "\xf0c72")
    ("nf-md-emoticon_kiss_outline" . "\xf0c73")
    ("nf-md-emoticon_lol" . "\xf1214")
    ("nf-md-emoticon_lol_outline" . "\xf1215")
    ("nf-md-emoticon_neutral" . "\xf0c74")
    ("nf-md-emoticon_neutral_outline" . "\xf01f6")
    ("nf-md-emoticon_outline" . "\xf01f2")
    ("nf-md-emoticon_poop" . "\xf01f7")
    ("nf-md-emoticon_poop_outline" . "\xf0c75")
    ("nf-md-emoticon_sad" . "\xf0c76")
    ("nf-md-emoticon_sad_outline" . "\xf01f8")
    ("nf-md-emoticon_sick" . "\xf157c")
    ("nf-md-emoticon_sick_outline" . "\xf157d")
    ("nf-md-emoticon_tongue" . "\xf01f9")
    ("nf-md-emoticon_tongue_outline" . "\xf0c77")
    ("nf-md-emoticon_wink" . "\xf0c78")
    ("nf-md-emoticon_wink_outline" . "\xf0c79")
    ("nf-md-engine" . "\xf01fa")
    ("nf-md-engine_off" . "\xf0a46")
    ("nf-md-engine_off_outline" . "\xf0a47")
    ("nf-md-engine_outline" . "\xf01fb")
    ("nf-md-epsilon" . "\xf10e0")
    ("nf-md-equal" . "\xf01fc")
    ("nf-md-equal_box" . "\xf01fd")
    ("nf-md-equalizer" . "\xf0ea2")
    ("nf-md-equalizer_outline" . "\xf0ea3")
    ("nf-md-eraser" . "\xf01fe")
    ("nf-md-eraser_variant" . "\xf0642")
    ("nf-md-escalator" . "\xf01ff")
    ("nf-md-escalator_box" . "\xf1399")
    ("nf-md-escalator_down" . "\xf12c0")
    ("nf-md-escalator_up" . "\xf12bf")
    ("nf-md-eslint" . "\xf0c7a")
    ("nf-md-et" . "\xf0ab3")
    ("nf-md-ethereum" . "\xf086a")
    ("nf-md-ethernet" . "\xf0200")
    ("nf-md-ethernet_cable" . "\xf0201")
    ("nf-md-ethernet_cable_off" . "\xf0202")
    ("nf-md-ev_plug_ccs1" . "\xf1519")
    ("nf-md-ev_plug_ccs2" . "\xf151a")
    ("nf-md-ev_plug_chademo" . "\xf151b")
    ("nf-md-ev_plug_tesla" . "\xf151c")
    ("nf-md-ev_plug_type1" . "\xf151d")
    ("nf-md-ev_plug_type2" . "\xf151e")
    ("nf-md-ev_station" . "\xf05f1")
    ("nf-md-evernote" . "\xf0204")
    ("nf-md-excavator" . "\xf1025")
    ("nf-md-exclamation" . "\xf0205")
    ("nf-md-exclamation_thick" . "\xf1238")
    ("nf-md-exit_run" . "\xf0a48")
    ("nf-md-exit_to_app" . "\xf05fc")
    ("nf-md-expand_all" . "\xf0ab4")
    ("nf-md-expand_all_outline" . "\xf0ab5")
    ("nf-md-expansion_card" . "\xf08ae")
    ("nf-md-expansion_card_variant" . "\xf0fb2")
    ("nf-md-exponent" . "\xf0963")
    ("nf-md-exponent_box" . "\xf0964")
    ("nf-md-export" . "\xf0207")
    ("nf-md-export_variant" . "\xf0b93")
    ("nf-md-eye" . "\xf0208")
    ("nf-md-eye_arrow_left" . "\xf18fd")
    ("nf-md-eye_arrow_left_outline" . "\xf18fe")
    ("nf-md-eye_arrow_right" . "\xf18ff")
    ("nf-md-eye_arrow_right_outline" . "\xf1900")
    ("nf-md-eye_check" . "\xf0d04")
    ("nf-md-eye_check_outline" . "\xf0d05")
    ("nf-md-eye_circle" . "\xf0b94")
    ("nf-md-eye_circle_outline" . "\xf0b95")
    ("nf-md-eye_minus" . "\xf1026")
    ("nf-md-eye_minus_outline" . "\xf1027")
    ("nf-md-eye_off" . "\xf0209")
    ("nf-md-eye_off_outline" . "\xf06d1")
    ("nf-md-eye_outline" . "\xf06d0")
    ("nf-md-eye_plus" . "\xf086b")
    ("nf-md-eye_plus_outline" . "\xf086c")
    ("nf-md-eye_refresh" . "\xf197c")
    ("nf-md-eye_refresh_outline" . "\xf197d")
    ("nf-md-eye_remove" . "\xf15e3")
    ("nf-md-eye_remove_outline" . "\xf15e4")
    ("nf-md-eye_settings" . "\xf086d")
    ("nf-md-eye_settings_outline" . "\xf086e")
    ("nf-md-eyedropper" . "\xf020a")
    ("nf-md-eyedropper_minus" . "\xf13dd")
    ("nf-md-eyedropper_off" . "\xf13df")
    ("nf-md-eyedropper_plus" . "\xf13dc")
    ("nf-md-eyedropper_remove" . "\xf13de")
    ("nf-md-eyedropper_variant" . "\xf020b")
    ("nf-md-face_agent" . "\xf0d70")
    ("nf-md-face_man" . "\xf0643")
    ("nf-md-face_man_outline" . "\xf0b96")
    ("nf-md-face_man_profile" . "\xf0644")
    ("nf-md-face_man_shimmer" . "\xf15cc")
    ("nf-md-face_man_shimmer_outline" . "\xf15cd")
    ("nf-md-face_mask" . "\xf1586")
    ("nf-md-face_mask_outline" . "\xf1587")
    ("nf-md-face_recognition" . "\xf0c7b")
    ("nf-md-face_woman" . "\xf1077")
    ("nf-md-face_woman_outline" . "\xf1078")
    ("nf-md-face_woman_profile" . "\xf1076")
    ("nf-md-face_woman_shimmer" . "\xf15ce")
    ("nf-md-face_woman_shimmer_outline" . "\xf15cf")
    ("nf-md-facebook" . "\xf020c")
    ("nf-md-facebook_gaming" . "\xf07dd")
    ("nf-md-facebook_messenger" . "\xf020e")
    ("nf-md-facebook_workplace" . "\xf0b31")
    ("nf-md-factory" . "\xf020f")
    ("nf-md-family_tree" . "\xf160e")
    ("nf-md-fan" . "\xf0210")
    ("nf-md-fan_alert" . "\xf146c")
    ("nf-md-fan_auto" . "\xf171d")
    ("nf-md-fan_chevron_down" . "\xf146d")
    ("nf-md-fan_chevron_up" . "\xf146e")
    ("nf-md-fan_clock" . "\xf1a3a")
    ("nf-md-fan_minus" . "\xf1470")
    ("nf-md-fan_off" . "\xf081d")
    ("nf-md-fan_plus" . "\xf146f")
    ("nf-md-fan_remove" . "\xf1471")
    ("nf-md-fan_speed_1" . "\xf1472")
    ("nf-md-fan_speed_2" . "\xf1473")
    ("nf-md-fan_speed_3" . "\xf1474")
    ("nf-md-fast_forward" . "\xf0211")
    ("nf-md-fast_forward_10" . "\xf0d71")
    ("nf-md-fast_forward_15" . "\xf193a")
    ("nf-md-fast_forward_30" . "\xf0d06")
    ("nf-md-fast_forward_5" . "\xf11f8")
    ("nf-md-fast_forward_60" . "\xf160b")
    ("nf-md-fast_forward_outline" . "\xf06d2")
    ("nf-md-fax" . "\xf0212")
    ("nf-md-feather" . "\xf06d3")
    ("nf-md-feature_search" . "\xf0a49")
    ("nf-md-feature_search_outline" . "\xf0a4a")
    ("nf-md-fedora" . "\xf08db")
    ("nf-md-fence" . "\xf179a")
    ("nf-md-fence_electric" . "\xf17f6")
    ("nf-md-fencing" . "\xf14c1")
    ("nf-md-ferris_wheel" . "\xf0ea4")
    ("nf-md-ferry" . "\xf0213")
    ("nf-md-file" . "\xf0214")
    ("nf-md-file_account" . "\xf073b")
    ("nf-md-file_account_outline" . "\xf1028")
    ("nf-md-file_alert" . "\xf0a4b")
    ("nf-md-file_alert_outline" . "\xf0a4c")
    ("nf-md-file_arrow_left_right" . "\xf1a93")
    ("nf-md-file_arrow_left_right_outline" . "\xf1a94")
    ("nf-md-file_arrow_up_down" . "\xf1a95")
    ("nf-md-file_arrow_up_down_outline" . "\xf1a96")
    ("nf-md-file_cabinet" . "\xf0ab6")
    ("nf-md-file_cad" . "\xf0eeb")
    ("nf-md-file_cad_box" . "\xf0eec")
    ("nf-md-file_cancel" . "\xf0dc6")
    ("nf-md-file_cancel_outline" . "\xf0dc7")
    ("nf-md-file_certificate" . "\xf1186")
    ("nf-md-file_certificate_outline" . "\xf1187")
    ("nf-md-file_chart" . "\xf0215")
    ("nf-md-file_chart_check" . "\xf19c6")
    ("nf-md-file_chart_check_outline" . "\xf19c7")
    ("nf-md-file_chart_outline" . "\xf1029")
    ("nf-md-file_check" . "\xf0216")
    ("nf-md-file_check_outline" . "\xf0e29")
    ("nf-md-file_clock" . "\xf12e1")
    ("nf-md-file_clock_outline" . "\xf12e2")
    ("nf-md-file_cloud" . "\xf0217")
    ("nf-md-file_cloud_outline" . "\xf102a")
    ("nf-md-file_code" . "\xf022e")
    ("nf-md-file_code_outline" . "\xf102b")
    ("nf-md-file_cog" . "\xf107b")
    ("nf-md-file_cog_outline" . "\xf107c")
    ("nf-md-file_compare" . "\xf08aa")
    ("nf-md-file_delimited" . "\xf0218")
    ("nf-md-file_delimited_outline" . "\xf0ea5")
    ("nf-md-file_document" . "\xf0219")
    ("nf-md-file_document_alert" . "\xf1a97")
    ("nf-md-file_document_alert_outline" . "\xf1a98")
    ("nf-md-file_document_check" . "\xf1a99")
    ("nf-md-file_document_check_outline" . "\xf1a9a")
    ("nf-md-file_document_edit" . "\xf0dc8")
    ("nf-md-file_document_edit_outline" . "\xf0dc9")
    ("nf-md-file_document_minus" . "\xf1a9b")
    ("nf-md-file_document_minus_outline" . "\xf1a9c")
    ("nf-md-file_document_multiple" . "\xf1517")
    ("nf-md-file_document_multiple_outline" . "\xf1518")
    ("nf-md-file_document_outline" . "\xf09ee")
    ("nf-md-file_document_plus" . "\xf1a9d")
    ("nf-md-file_document_plus_outline" . "\xf1a9e")
    ("nf-md-file_document_remove" . "\xf1a9f")
    ("nf-md-file_document_remove_outline" . "\xf1aa0")
    ("nf-md-file_download" . "\xf0965")
    ("nf-md-file_download_outline" . "\xf0966")
    ("nf-md-file_edit" . "\xf11e7")
    ("nf-md-file_edit_outline" . "\xf11e8")
    ("nf-md-file_excel" . "\xf021b")
    ("nf-md-file_excel_box" . "\xf021c")
    ("nf-md-file_excel_box_outline" . "\xf102c")
    ("nf-md-file_excel_outline" . "\xf102d")
    ("nf-md-file_export" . "\xf021d")
    ("nf-md-file_export_outline" . "\xf102e")
    ("nf-md-file_eye" . "\xf0dca")
    ("nf-md-file_eye_outline" . "\xf0dcb")
    ("nf-md-file_find" . "\xf021e")
    ("nf-md-file_find_outline" . "\xf0b97")
    ("nf-md-file_gif_box" . "\xf0d78")
    ("nf-md-file_hidden" . "\xf0613")
    ("nf-md-file_image" . "\xf021f")
    ("nf-md-file_image_marker" . "\xf1772")
    ("nf-md-file_image_marker_outline" . "\xf1773")
    ("nf-md-file_image_minus" . "\xf193b")
    ("nf-md-file_image_minus_outline" . "\xf193c")
    ("nf-md-file_image_outline" . "\xf0eb0")
    ("nf-md-file_image_plus" . "\xf193d")
    ("nf-md-file_image_plus_outline" . "\xf193e")
    ("nf-md-file_image_remove" . "\xf193f")
    ("nf-md-file_image_remove_outline" . "\xf1940")
    ("nf-md-file_import" . "\xf0220")
    ("nf-md-file_import_outline" . "\xf102f")
    ("nf-md-file_jpg_box" . "\xf0225")
    ("nf-md-file_key" . "\xf1184")
    ("nf-md-file_key_outline" . "\xf1185")
    ("nf-md-file_link" . "\xf1177")
    ("nf-md-file_link_outline" . "\xf1178")
    ("nf-md-file_lock" . "\xf0221")
    ("nf-md-file_lock_open" . "\xf19c8")
    ("nf-md-file_lock_open_outline" . "\xf19c9")
    ("nf-md-file_lock_outline" . "\xf1030")
    ("nf-md-file_marker" . "\xf1774")
    ("nf-md-file_marker_outline" . "\xf1775")
    ("nf-md-file_minus" . "\xf1aa1")
    ("nf-md-file_minus_outline" . "\xf1aa2")
    ("nf-md-file_move" . "\xf0ab9")
    ("nf-md-file_move_outline" . "\xf1031")
    ("nf-md-file_multiple" . "\xf0222")
    ("nf-md-file_multiple_outline" . "\xf1032")
    ("nf-md-file_music" . "\xf0223")
    ("nf-md-file_music_outline" . "\xf0e2a")
    ("nf-md-file_outline" . "\xf0224")
    ("nf-md-file_pdf_box" . "\xf0226")
    ("nf-md-file_percent" . "\xf081e")
    ("nf-md-file_percent_outline" . "\xf1033")
    ("nf-md-file_phone" . "\xf1179")
    ("nf-md-file_phone_outline" . "\xf117a")
    ("nf-md-file_plus" . "\xf0752")
    ("nf-md-file_plus_outline" . "\xf0eed")
    ("nf-md-file_png_box" . "\xf0e2d")
    ("nf-md-file_powerpoint" . "\xf0227")
    ("nf-md-file_powerpoint_box" . "\xf0228")
    ("nf-md-file_powerpoint_box_outline" . "\xf1034")
    ("nf-md-file_powerpoint_outline" . "\xf1035")
    ("nf-md-file_presentation_box" . "\xf0229")
    ("nf-md-file_question" . "\xf086f")
    ("nf-md-file_question_outline" . "\xf1036")
    ("nf-md-file_refresh" . "\xf0918")
    ("nf-md-file_refresh_outline" . "\xf0541")
    ("nf-md-file_remove" . "\xf0b98")
    ("nf-md-file_remove_outline" . "\xf1037")
    ("nf-md-file_replace" . "\xf0b32")
    ("nf-md-file_replace_outline" . "\xf0b33")
    ("nf-md-file_restore" . "\xf0670")
    ("nf-md-file_restore_outline" . "\xf1038")
    ("nf-md-file_rotate_left" . "\xf1a3b")
    ("nf-md-file_rotate_left_outline" . "\xf1a3c")
    ("nf-md-file_rotate_right" . "\xf1a3d")
    ("nf-md-file_rotate_right_outline" . "\xf1a3e")
    ("nf-md-file_search" . "\xf0c7c")
    ("nf-md-file_search_outline" . "\xf0c7d")
    ("nf-md-file_send" . "\xf022a")
    ("nf-md-file_send_outline" . "\xf1039")
    ("nf-md-file_settings" . "\xf1079")
    ("nf-md-file_settings_outline" . "\xf107a")
    ("nf-md-file_sign" . "\xf19c3")
    ("nf-md-file_star" . "\xf103a")
    ("nf-md-file_star_outline" . "\xf103b")
    ("nf-md-file_swap" . "\xf0fb4")
    ("nf-md-file_swap_outline" . "\xf0fb5")
    ("nf-md-file_sync" . "\xf1216")
    ("nf-md-file_sync_outline" . "\xf1217")
    ("nf-md-file_table" . "\xf0c7e")
    ("nf-md-file_table_box" . "\xf10e1")
    ("nf-md-file_table_box_multiple" . "\xf10e2")
    ("nf-md-file_table_box_multiple_outline" . "\xf10e3")
    ("nf-md-file_table_box_outline" . "\xf10e4")
    ("nf-md-file_table_outline" . "\xf0c7f")
    ("nf-md-file_tree" . "\xf0645")
    ("nf-md-file_tree_outline" . "\xf13d2")
    ("nf-md-file_undo" . "\xf08dc")
    ("nf-md-file_undo_outline" . "\xf103c")
    ("nf-md-file_upload" . "\xf0a4d")
    ("nf-md-file_upload_outline" . "\xf0a4e")
    ("nf-md-file_video" . "\xf022b")
    ("nf-md-file_video_outline" . "\xf0e2c")
    ("nf-md-file_word" . "\xf022c")
    ("nf-md-file_word_box" . "\xf022d")
    ("nf-md-file_word_box_outline" . "\xf103d")
    ("nf-md-file_word_outline" . "\xf103e")
    ("nf-md-film" . "\xf022f")
    ("nf-md-filmstrip" . "\xf0230")
    ("nf-md-filmstrip_box" . "\xf0332")
    ("nf-md-filmstrip_box_multiple" . "\xf0d18")
    ("nf-md-filmstrip_off" . "\xf0231")
    ("nf-md-filter" . "\xf0232")
    ("nf-md-filter_check" . "\xf18ec")
    ("nf-md-filter_check_outline" . "\xf18ed")
    ("nf-md-filter_cog" . "\xf1aa3")
    ("nf-md-filter_cog_outline" . "\xf1aa4")
    ("nf-md-filter_menu" . "\xf10e5")
    ("nf-md-filter_menu_outline" . "\xf10e6")
    ("nf-md-filter_minus" . "\xf0eee")
    ("nf-md-filter_minus_outline" . "\xf0eef")
    ("nf-md-filter_multiple" . "\xf1a3f")
    ("nf-md-filter_multiple_outline" . "\xf1a40")
    ("nf-md-filter_off" . "\xf14ef")
    ("nf-md-filter_off_outline" . "\xf14f0")
    ("nf-md-filter_outline" . "\xf0233")
    ("nf-md-filter_plus" . "\xf0ef0")
    ("nf-md-filter_plus_outline" . "\xf0ef1")
    ("nf-md-filter_remove" . "\xf0234")
    ("nf-md-filter_remove_outline" . "\xf0235")
    ("nf-md-filter_settings" . "\xf1aa5")
    ("nf-md-filter_settings_outline" . "\xf1aa6")
    ("nf-md-filter_variant" . "\xf0236")
    ("nf-md-filter_variant_minus" . "\xf1112")
    ("nf-md-filter_variant_plus" . "\xf1113")
    ("nf-md-filter_variant_remove" . "\xf103f")
    ("nf-md-finance" . "\xf081f")
    ("nf-md-find_replace" . "\xf06d4")
    ("nf-md-fingerprint" . "\xf0237")
    ("nf-md-fingerprint_off" . "\xf0eb1")
    ("nf-md-fire" . "\xf0238")
    ("nf-md-fire_alert" . "\xf15d7")
    ("nf-md-fire_circle" . "\xf1807")
    ("nf-md-fire_extinguisher" . "\xf0ef2")
    ("nf-md-fire_hydrant" . "\xf1137")
    ("nf-md-fire_hydrant_alert" . "\xf1138")
    ("nf-md-fire_hydrant_off" . "\xf1139")
    ("nf-md-fire_off" . "\xf1722")
    ("nf-md-fire_truck" . "\xf08ab")
    ("nf-md-firebase" . "\xf0967")
    ("nf-md-firefox" . "\xf0239")
    ("nf-md-fireplace" . "\xf0e2e")
    ("nf-md-fireplace_off" . "\xf0e2f")
    ("nf-md-firewire" . "\xf05be")
    ("nf-md-firework" . "\xf0e30")
    ("nf-md-firework_off" . "\xf1723")
    ("nf-md-fish" . "\xf023a")
    ("nf-md-fish_off" . "\xf13f3")
    ("nf-md-fishbowl" . "\xf0ef3")
    ("nf-md-fishbowl_outline" . "\xf0ef4")
    ("nf-md-fit_to_page" . "\xf0ef5")
    ("nf-md-fit_to_page_outline" . "\xf0ef6")
    ("nf-md-fit_to_screen" . "\xf18f4")
    ("nf-md-fit_to_screen_outline" . "\xf18f5")
    ("nf-md-flag" . "\xf023b")
    ("nf-md-flag_checkered" . "\xf023c")
    ("nf-md-flag_minus" . "\xf0b99")
    ("nf-md-flag_minus_outline" . "\xf10b2")
    ("nf-md-flag_off" . "\xf18ee")
    ("nf-md-flag_off_outline" . "\xf18ef")
    ("nf-md-flag_outline" . "\xf023d")
    ("nf-md-flag_plus" . "\xf0b9a")
    ("nf-md-flag_plus_outline" . "\xf10b3")
    ("nf-md-flag_remove" . "\xf0b9b")
    ("nf-md-flag_remove_outline" . "\xf10b4")
    ("nf-md-flag_triangle" . "\xf023f")
    ("nf-md-flag_variant" . "\xf0240")
    ("nf-md-flag_variant_outline" . "\xf023e")
    ("nf-md-flare" . "\xf0d72")
    ("nf-md-flash" . "\xf0241")
    ("nf-md-flash_alert" . "\xf0ef7")
    ("nf-md-flash_alert_outline" . "\xf0ef8")
    ("nf-md-flash_auto" . "\xf0242")
    ("nf-md-flash_off" . "\xf0243")
    ("nf-md-flash_outline" . "\xf06d5")
    ("nf-md-flash_red_eye" . "\xf067b")
    ("nf-md-flashlight" . "\xf0244")
    ("nf-md-flashlight_off" . "\xf0245")
    ("nf-md-flask" . "\xf0093")
    ("nf-md-flask_empty" . "\xf0094")
    ("nf-md-flask_empty_minus" . "\xf123a")
    ("nf-md-flask_empty_minus_outline" . "\xf123b")
    ("nf-md-flask_empty_off" . "\xf13f4")
    ("nf-md-flask_empty_off_outline" . "\xf13f5")
    ("nf-md-flask_empty_outline" . "\xf0095")
    ("nf-md-flask_empty_plus" . "\xf123c")
    ("nf-md-flask_empty_plus_outline" . "\xf123d")
    ("nf-md-flask_empty_remove" . "\xf123e")
    ("nf-md-flask_empty_remove_outline" . "\xf123f")
    ("nf-md-flask_minus" . "\xf1240")
    ("nf-md-flask_minus_outline" . "\xf1241")
    ("nf-md-flask_off" . "\xf13f6")
    ("nf-md-flask_off_outline" . "\xf13f7")
    ("nf-md-flask_outline" . "\xf0096")
    ("nf-md-flask_plus" . "\xf1242")
    ("nf-md-flask_plus_outline" . "\xf1243")
    ("nf-md-flask_remove" . "\xf1244")
    ("nf-md-flask_remove_outline" . "\xf1245")
    ("nf-md-flask_round_bottom" . "\xf124b")
    ("nf-md-flask_round_bottom_empty" . "\xf124c")
    ("nf-md-flask_round_bottom_empty_outline" . "\xf124d")
    ("nf-md-flask_round_bottom_outline" . "\xf124e")
    ("nf-md-fleur_de_lis" . "\xf1303")
    ("nf-md-flip_horizontal" . "\xf10e7")
    ("nf-md-flip_to_back" . "\xf0247")
    ("nf-md-flip_to_front" . "\xf0248")
    ("nf-md-flip_vertical" . "\xf10e8")
    ("nf-md-floor_lamp" . "\xf08dd")
    ("nf-md-floor_lamp_dual" . "\xf1040")
    ("nf-md-floor_lamp_dual_outline" . "\xf17ce")
    ("nf-md-floor_lamp_outline" . "\xf17c8")
    ("nf-md-floor_lamp_torchiere" . "\xf1747")
    ("nf-md-floor_lamp_torchiere_outline" . "\xf17d6")
    ("nf-md-floor_lamp_torchiere_variant" . "\xf1041")
    ("nf-md-floor_lamp_torchiere_variant_outline" . "\xf17cf")
    ("nf-md-floor_plan" . "\xf0821")
    ("nf-md-floppy" . "\xf0249")
    ("nf-md-floppy_variant" . "\xf09ef")
    ("nf-md-flower" . "\xf024a")
    ("nf-md-flower_outline" . "\xf09f0")
    ("nf-md-flower_pollen" . "\xf1885")
    ("nf-md-flower_pollen_outline" . "\xf1886")
    ("nf-md-flower_poppy" . "\xf0d08")
    ("nf-md-flower_tulip" . "\xf09f1")
    ("nf-md-flower_tulip_outline" . "\xf09f2")
    ("nf-md-focus_auto" . "\xf0f4e")
    ("nf-md-focus_field" . "\xf0f4f")
    ("nf-md-focus_field_horizontal" . "\xf0f50")
    ("nf-md-focus_field_vertical" . "\xf0f51")
    ("nf-md-folder" . "\xf024b")
    ("nf-md-folder_account" . "\xf024c")
    ("nf-md-folder_account_outline" . "\xf0b9c")
    ("nf-md-folder_alert" . "\xf0dcc")
    ("nf-md-folder_alert_outline" . "\xf0dcd")
    ("nf-md-folder_arrow_down" . "\xf19e8")
    ("nf-md-folder_arrow_down_outline" . "\xf19e9")
    ("nf-md-folder_arrow_left" . "\xf19ea")
    ("nf-md-folder_arrow_left_outline" . "\xf19eb")
    ("nf-md-folder_arrow_left_right" . "\xf19ec")
    ("nf-md-folder_arrow_left_right_outline" . "\xf19ed")
    ("nf-md-folder_arrow_right" . "\xf19ee")
    ("nf-md-folder_arrow_right_outline" . "\xf19ef")
    ("nf-md-folder_arrow_up" . "\xf19f0")
    ("nf-md-folder_arrow_up_down" . "\xf19f1")
    ("nf-md-folder_arrow_up_down_outline" . "\xf19f2")
    ("nf-md-folder_arrow_up_outline" . "\xf19f3")
    ("nf-md-folder_cancel" . "\xf19f4")
    ("nf-md-folder_cancel_outline" . "\xf19f5")
    ("nf-md-folder_check" . "\xf197e")
    ("nf-md-folder_check_outline" . "\xf197f")
    ("nf-md-folder_clock" . "\xf0aba")
    ("nf-md-folder_clock_outline" . "\xf0abb")
    ("nf-md-folder_cog" . "\xf107f")
    ("nf-md-folder_cog_outline" . "\xf1080")
    ("nf-md-folder_download" . "\xf024d")
    ("nf-md-folder_download_outline" . "\xf10e9")
    ("nf-md-folder_edit" . "\xf08de")
    ("nf-md-folder_edit_outline" . "\xf0dce")
    ("nf-md-folder_eye" . "\xf178a")
    ("nf-md-folder_eye_outline" . "\xf178b")
    ("nf-md-folder_file" . "\xf19f6")
    ("nf-md-folder_file_outline" . "\xf19f7")
    ("nf-md-folder_google_drive" . "\xf024e")
    ("nf-md-folder_heart" . "\xf10ea")
    ("nf-md-folder_heart_outline" . "\xf10eb")
    ("nf-md-folder_hidden" . "\xf179e")
    ("nf-md-folder_home" . "\xf10b5")
    ("nf-md-folder_home_outline" . "\xf10b6")
    ("nf-md-folder_image" . "\xf024f")
    ("nf-md-folder_information" . "\xf10b7")
    ("nf-md-folder_information_outline" . "\xf10b8")
    ("nf-md-folder_key" . "\xf08ac")
    ("nf-md-folder_key_network" . "\xf08ad")
    ("nf-md-folder_key_network_outline" . "\xf0c80")
    ("nf-md-folder_key_outline" . "\xf10ec")
    ("nf-md-folder_lock" . "\xf0250")
    ("nf-md-folder_lock_open" . "\xf0251")
    ("nf-md-folder_lock_open_outline" . "\xf1aa7")
    ("nf-md-folder_lock_outline" . "\xf1aa8")
    ("nf-md-folder_marker" . "\xf126d")
    ("nf-md-folder_marker_outline" . "\xf126e")
    ("nf-md-folder_move" . "\xf0252")
    ("nf-md-folder_move_outline" . "\xf1246")
    ("nf-md-folder_multiple" . "\xf0253")
    ("nf-md-folder_multiple_image" . "\xf0254")
    ("nf-md-folder_multiple_outline" . "\xf0255")
    ("nf-md-folder_multiple_plus" . "\xf147e")
    ("nf-md-folder_multiple_plus_outline" . "\xf147f")
    ("nf-md-folder_music" . "\xf1359")
    ("nf-md-folder_music_outline" . "\xf135a")
    ("nf-md-folder_network" . "\xf0870")
    ("nf-md-folder_network_outline" . "\xf0c81")
    ("nf-md-folder_off" . "\xf19f8")
    ("nf-md-folder_off_outline" . "\xf19f9")
    ("nf-md-folder_open" . "\xf0770")
    ("nf-md-folder_open_outline" . "\xf0dcf")
    ("nf-md-folder_outline" . "\xf0256")
    ("nf-md-folder_play" . "\xf19fa")
    ("nf-md-folder_play_outline" . "\xf19fb")
    ("nf-md-folder_plus" . "\xf0257")
    ("nf-md-folder_plus_outline" . "\xf0b9d")
    ("nf-md-folder_pound" . "\xf0d09")
    ("nf-md-folder_pound_outline" . "\xf0d0a")
    ("nf-md-folder_question" . "\xf19ca")
    ("nf-md-folder_question_outline" . "\xf19cb")
    ("nf-md-folder_refresh" . "\xf0749")
    ("nf-md-folder_refresh_outline" . "\xf0542")
    ("nf-md-folder_remove" . "\xf0258")
    ("nf-md-folder_remove_outline" . "\xf0b9e")
    ("nf-md-folder_search" . "\xf0968")
    ("nf-md-folder_search_outline" . "\xf0969")
    ("nf-md-folder_settings" . "\xf107d")
    ("nf-md-folder_settings_outline" . "\xf107e")
    ("nf-md-folder_star" . "\xf069d")
    ("nf-md-folder_star_multiple" . "\xf13d3")
    ("nf-md-folder_star_multiple_outline" . "\xf13d4")
    ("nf-md-folder_star_outline" . "\xf0b9f")
    ("nf-md-folder_swap" . "\xf0fb6")
    ("nf-md-folder_swap_outline" . "\xf0fb7")
    ("nf-md-folder_sync" . "\xf0d0b")
    ("nf-md-folder_sync_outline" . "\xf0d0c")
    ("nf-md-folder_table" . "\xf12e3")
    ("nf-md-folder_table_outline" . "\xf12e4")
    ("nf-md-folder_text" . "\xf0c82")
    ("nf-md-folder_text_outline" . "\xf0c83")
    ("nf-md-folder_upload" . "\xf0259")
    ("nf-md-folder_upload_outline" . "\xf10ed")
    ("nf-md-folder_wrench" . "\xf19fc")
    ("nf-md-folder_wrench_outline" . "\xf19fd")
    ("nf-md-folder_zip" . "\xf06eb")
    ("nf-md-folder_zip_outline" . "\xf07b9")
    ("nf-md-font_awesome" . "\xf003a")
    ("nf-md-food" . "\xf025a")
    ("nf-md-food_apple" . "\xf025b")
    ("nf-md-food_apple_outline" . "\xf0c84")
    ("nf-md-food_croissant" . "\xf07c8")
    ("nf-md-food_drumstick" . "\xf141f")
    ("nf-md-food_drumstick_off" . "\xf1468")
    ("nf-md-food_drumstick_off_outline" . "\xf1469")
    ("nf-md-food_drumstick_outline" . "\xf1420")
    ("nf-md-food_fork_drink" . "\xf05f2")
    ("nf-md-food_halal" . "\xf1572")
    ("nf-md-food_hot_dog" . "\xf184b")
    ("nf-md-food_kosher" . "\xf1573")
    ("nf-md-food_off" . "\xf05f3")
    ("nf-md-food_off_outline" . "\xf1915")
    ("nf-md-food_outline" . "\xf1916")
    ("nf-md-food_steak" . "\xf146a")
    ("nf-md-food_steak_off" . "\xf146b")
    ("nf-md-food_takeout_box" . "\xf1836")
    ("nf-md-food_takeout_box_outline" . "\xf1837")
    ("nf-md-food_turkey" . "\xf171c")
    ("nf-md-food_variant" . "\xf025c")
    ("nf-md-food_variant_off" . "\xf13e5")
    ("nf-md-foot_print" . "\xf0f52")
    ("nf-md-football" . "\xf025d")
    ("nf-md-football_australian" . "\xf025e")
    ("nf-md-football_helmet" . "\xf025f")
    ("nf-md-forest" . "\xf1897")
    ("nf-md-forklift" . "\xf07c9")
    ("nf-md-form_dropdown" . "\xf1400")
    ("nf-md-form_select" . "\xf1401")
    ("nf-md-form_textarea" . "\xf1095")
    ("nf-md-form_textbox" . "\xf060e")
    ("nf-md-form_textbox_lock" . "\xf135d")
    ("nf-md-form_textbox_password" . "\xf07f5")
    ("nf-md-format_align_bottom" . "\xf0753")
    ("nf-md-format_align_center" . "\xf0260")
    ("nf-md-format_align_justify" . "\xf0261")
    ("nf-md-format_align_left" . "\xf0262")
    ("nf-md-format_align_middle" . "\xf0754")
    ("nf-md-format_align_right" . "\xf0263")
    ("nf-md-format_align_top" . "\xf0755")
    ("nf-md-format_annotation_minus" . "\xf0abc")
    ("nf-md-format_annotation_plus" . "\xf0646")
    ("nf-md-format_bold" . "\xf0264")
    ("nf-md-format_clear" . "\xf0265")
    ("nf-md-format_color_fill" . "\xf0266")
    ("nf-md-format_color_highlight" . "\xf0e31")
    ("nf-md-format_color_marker_cancel" . "\xf1313")
    ("nf-md-format_color_text" . "\xf069e")
    ("nf-md-format_columns" . "\xf08df")
    ("nf-md-format_float_center" . "\xf0267")
    ("nf-md-format_float_left" . "\xf0268")
    ("nf-md-format_float_none" . "\xf0269")
    ("nf-md-format_float_right" . "\xf026a")
    ("nf-md-format_font" . "\xf06d6")
    ("nf-md-format_font_size_decrease" . "\xf09f3")
    ("nf-md-format_font_size_increase" . "\xf09f4")
    ("nf-md-format_header_1" . "\xf026b")
    ("nf-md-format_header_2" . "\xf026c")
    ("nf-md-format_header_3" . "\xf026d")
    ("nf-md-format_header_4" . "\xf026e")
    ("nf-md-format_header_5" . "\xf026f")
    ("nf-md-format_header_6" . "\xf0270")
    ("nf-md-format_header_decrease" . "\xf0271")
    ("nf-md-format_header_equal" . "\xf0272")
    ("nf-md-format_header_increase" . "\xf0273")
    ("nf-md-format_header_pound" . "\xf0274")
    ("nf-md-format_horizontal_align_center" . "\xf061e")
    ("nf-md-format_horizontal_align_left" . "\xf061f")
    ("nf-md-format_horizontal_align_right" . "\xf0620")
    ("nf-md-format_indent_decrease" . "\xf0275")
    ("nf-md-format_indent_increase" . "\xf0276")
    ("nf-md-format_italic" . "\xf0277")
    ("nf-md-format_letter_case" . "\xf0b34")
    ("nf-md-format_letter_case_lower" . "\xf0b35")
    ("nf-md-format_letter_case_upper" . "\xf0b36")
    ("nf-md-format_letter_ends_with" . "\xf0fb8")
    ("nf-md-format_letter_matches" . "\xf0fb9")
    ("nf-md-format_letter_spacing" . "\xf1956")
    ("nf-md-format_letter_starts_with" . "\xf0fba")
    ("nf-md-format_line_spacing" . "\xf0278")
    ("nf-md-format_line_style" . "\xf05c8")
    ("nf-md-format_line_weight" . "\xf05c9")
    ("nf-md-format_list_bulleted" . "\xf0279")
    ("nf-md-format_list_bulleted_square" . "\xf0dd0")
    ("nf-md-format_list_bulleted_triangle" . "\xf0eb2")
    ("nf-md-format_list_bulleted_type" . "\xf027a")
    ("nf-md-format_list_checkbox" . "\xf096a")
    ("nf-md-format_list_checks" . "\xf0756")
    ("nf-md-format_list_group" . "\xf1860")
    ("nf-md-format_list_numbered" . "\xf027b")
    ("nf-md-format_list_numbered_rtl" . "\xf0d0d")
    ("nf-md-format_list_text" . "\xf126f")
    ("nf-md-format_overline" . "\xf0eb3")
    ("nf-md-format_page_break" . "\xf06d7")
    ("nf-md-format_page_split" . "\xf1917")
    ("nf-md-format_paint" . "\xf027c")
    ("nf-md-format_paragraph" . "\xf027d")
    ("nf-md-format_pilcrow" . "\xf06d8")
    ("nf-md-format_quote_close" . "\xf027e")
    ("nf-md-format_quote_close_outline" . "\xf11a8")
    ("nf-md-format_quote_open" . "\xf0757")
    ("nf-md-format_quote_open_outline" . "\xf11a7")
    ("nf-md-format_rotate_90" . "\xf06aa")
    ("nf-md-format_section" . "\xf069f")
    ("nf-md-format_size" . "\xf027f")
    ("nf-md-format_strikethrough" . "\xf0280")
    ("nf-md-format_strikethrough_variant" . "\xf0281")
    ("nf-md-format_subscript" . "\xf0282")
    ("nf-md-format_superscript" . "\xf0283")
    ("nf-md-format_text" . "\xf0284")
    ("nf-md-format_text_rotation_angle_down" . "\xf0fbb")
    ("nf-md-format_text_rotation_angle_up" . "\xf0fbc")
    ("nf-md-format_text_rotation_down" . "\xf0d73")
    ("nf-md-format_text_rotation_down_vertical" . "\xf0fbd")
    ("nf-md-format_text_rotation_none" . "\xf0d74")
    ("nf-md-format_text_rotation_up" . "\xf0fbe")
    ("nf-md-format_text_rotation_vertical" . "\xf0fbf")
    ("nf-md-format_text_variant" . "\xf0e32")
    ("nf-md-format_text_variant_outline" . "\xf150f")
    ("nf-md-format_text_wrapping_clip" . "\xf0d0e")
    ("nf-md-format_text_wrapping_overflow" . "\xf0d0f")
    ("nf-md-format_text_wrapping_wrap" . "\xf0d10")
    ("nf-md-format_textbox" . "\xf0d11")
    ("nf-md-format_textdirection_l_to_r" . "\xf0285")
    ("nf-md-format_textdirection_r_to_l" . "\xf0286")
    ("nf-md-format_title" . "\xf05f4")
    ("nf-md-format_underline" . "\xf0287")
    ("nf-md-format_underline_wavy" . "\xf18e9")
    ("nf-md-format_vertical_align_bottom" . "\xf0621")
    ("nf-md-format_vertical_align_center" . "\xf0622")
    ("nf-md-format_vertical_align_top" . "\xf0623")
    ("nf-md-format_wrap_inline" . "\xf0288")
    ("nf-md-format_wrap_square" . "\xf0289")
    ("nf-md-format_wrap_tight" . "\xf028a")
    ("nf-md-format_wrap_top_bottom" . "\xf028b")
    ("nf-md-forum" . "\xf028c")
    ("nf-md-forum_minus" . "\xf1aa9")
    ("nf-md-forum_minus_outline" . "\xf1aaa")
    ("nf-md-forum_outline" . "\xf0822")
    ("nf-md-forum_plus" . "\xf1aab")
    ("nf-md-forum_plus_outline" . "\xf1aac")
    ("nf-md-forum_remove" . "\xf1aad")
    ("nf-md-forum_remove_outline" . "\xf1aae")
    ("nf-md-forward" . "\xf028d")
    ("nf-md-forwardburger" . "\xf0d75")
    ("nf-md-fountain" . "\xf096b")
    ("nf-md-fountain_pen" . "\xf0d12")
    ("nf-md-fountain_pen_tip" . "\xf0d13")
    ("nf-md-fraction_one_half" . "\xf1992")
    ("nf-md-freebsd" . "\xf08e0")
    ("nf-md-french_fries" . "\xf1957")
    ("nf-md-frequently_asked_questions" . "\xf0eb4")
    ("nf-md-fridge" . "\xf0290")
    ("nf-md-fridge_alert" . "\xf11b1")
    ("nf-md-fridge_alert_outline" . "\xf11b2")
    ("nf-md-fridge_bottom" . "\xf0292")
    ("nf-md-fridge_industrial" . "\xf15ee")
    ("nf-md-fridge_industrial_alert" . "\xf15ef")
    ("nf-md-fridge_industrial_alert_outline" . "\xf15f0")
    ("nf-md-fridge_industrial_off" . "\xf15f1")
    ("nf-md-fridge_industrial_off_outline" . "\xf15f2")
    ("nf-md-fridge_industrial_outline" . "\xf15f3")
    ("nf-md-fridge_off" . "\xf11af")
    ("nf-md-fridge_off_outline" . "\xf11b0")
    ("nf-md-fridge_outline" . "\xf028f")
    ("nf-md-fridge_top" . "\xf0291")
    ("nf-md-fridge_variant" . "\xf15f4")
    ("nf-md-fridge_variant_alert" . "\xf15f5")
    ("nf-md-fridge_variant_alert_outline" . "\xf15f6")
    ("nf-md-fridge_variant_off" . "\xf15f7")
    ("nf-md-fridge_variant_off_outline" . "\xf15f8")
    ("nf-md-fridge_variant_outline" . "\xf15f9")
    ("nf-md-fruit_cherries" . "\xf1042")
    ("nf-md-fruit_cherries_off" . "\xf13f8")
    ("nf-md-fruit_citrus" . "\xf1043")
    ("nf-md-fruit_citrus_off" . "\xf13f9")
    ("nf-md-fruit_grapes" . "\xf1044")
    ("nf-md-fruit_grapes_outline" . "\xf1045")
    ("nf-md-fruit_pear" . "\xf1a0e")
    ("nf-md-fruit_pineapple" . "\xf1046")
    ("nf-md-fruit_watermelon" . "\xf1047")
    ("nf-md-fuel" . "\xf07ca")
    ("nf-md-fuel_cell" . "\xf18b5")
    ("nf-md-fullscreen" . "\xf0293")
    ("nf-md-fullscreen_exit" . "\xf0294")
    ("nf-md-function" . "\xf0295")
    ("nf-md-function_variant" . "\xf0871")
    ("nf-md-furigana_horizontal" . "\xf1081")
    ("nf-md-furigana_vertical" . "\xf1082")
    ("nf-md-fuse" . "\xf0c85")
    ("nf-md-fuse_alert" . "\xf142d")
    ("nf-md-fuse_blade" . "\xf0c86")
    ("nf-md-fuse_off" . "\xf142c")
    ("nf-md-gamepad" . "\xf0296")
    ("nf-md-gamepad_circle" . "\xf0e33")
    ("nf-md-gamepad_circle_down" . "\xf0e34")
    ("nf-md-gamepad_circle_left" . "\xf0e35")
    ("nf-md-gamepad_circle_outline" . "\xf0e36")
    ("nf-md-gamepad_circle_right" . "\xf0e37")
    ("nf-md-gamepad_circle_up" . "\xf0e38")
    ("nf-md-gamepad_down" . "\xf0e39")
    ("nf-md-gamepad_left" . "\xf0e3a")
    ("nf-md-gamepad_outline" . "\xf1919")
    ("nf-md-gamepad_right" . "\xf0e3b")
    ("nf-md-gamepad_round" . "\xf0e3c")
    ("nf-md-gamepad_round_down" . "\xf0e3d")
    ("nf-md-gamepad_round_left" . "\xf0e3e")
    ("nf-md-gamepad_round_outline" . "\xf0e3f")
    ("nf-md-gamepad_round_right" . "\xf0e40")
    ("nf-md-gamepad_round_up" . "\xf0e41")
    ("nf-md-gamepad_square" . "\xf0eb5")
    ("nf-md-gamepad_square_outline" . "\xf0eb6")
    ("nf-md-gamepad_up" . "\xf0e42")
    ("nf-md-gamepad_variant" . "\xf0297")
    ("nf-md-gamepad_variant_outline" . "\xf0eb7")
    ("nf-md-gamma" . "\xf10ee")
    ("nf-md-gantry_crane" . "\xf0dd1")
    ("nf-md-garage" . "\xf06d9")
    ("nf-md-garage_alert" . "\xf0872")
    ("nf-md-garage_alert_variant" . "\xf12d5")
    ("nf-md-garage_lock" . "\xf17fb")
    ("nf-md-garage_open" . "\xf06da")
    ("nf-md-garage_open_variant" . "\xf12d4")
    ("nf-md-garage_variant" . "\xf12d3")
    ("nf-md-garage_variant_lock" . "\xf17fc")
    ("nf-md-gas_burner" . "\xf1a1b")
    ("nf-md-gas_cylinder" . "\xf0647")
    ("nf-md-gas_station" . "\xf0298")
    ("nf-md-gas_station_off" . "\xf1409")
    ("nf-md-gas_station_off_outline" . "\xf140a")
    ("nf-md-gas_station_outline" . "\xf0eb8")
    ("nf-md-gate" . "\xf0299")
    ("nf-md-gate_alert" . "\xf17f8")
    ("nf-md-gate_and" . "\xf08e1")
    ("nf-md-gate_arrow_left" . "\xf17f7")
    ("nf-md-gate_arrow_right" . "\xf1169")
    ("nf-md-gate_nand" . "\xf08e2")
    ("nf-md-gate_nor" . "\xf08e3")
    ("nf-md-gate_not" . "\xf08e4")
    ("nf-md-gate_open" . "\xf116a")
    ("nf-md-gate_or" . "\xf08e5")
    ("nf-md-gate_xnor" . "\xf08e6")
    ("nf-md-gate_xor" . "\xf08e7")
    ("nf-md-gatsby" . "\xf0e43")
    ("nf-md-gauge" . "\xf029a")
    ("nf-md-gauge_empty" . "\xf0873")
    ("nf-md-gauge_full" . "\xf0874")
    ("nf-md-gauge_low" . "\xf0875")
    ("nf-md-gavel" . "\xf029b")
    ("nf-md-gender_female" . "\xf029c")
    ("nf-md-gender_male" . "\xf029d")
    ("nf-md-gender_male_female" . "\xf029e")
    ("nf-md-gender_male_female_variant" . "\xf113f")
    ("nf-md-gender_non_binary" . "\xf1140")
    ("nf-md-gender_transgender" . "\xf029f")
    ("nf-md-gentoo" . "\xf08e8")
    ("nf-md-gesture" . "\xf07cb")
    ("nf-md-gesture_double_tap" . "\xf073c")
    ("nf-md-gesture_pinch" . "\xf0abd")
    ("nf-md-gesture_spread" . "\xf0abe")
    ("nf-md-gesture_swipe" . "\xf0d76")
    ("nf-md-gesture_swipe_down" . "\xf073d")
    ("nf-md-gesture_swipe_horizontal" . "\xf0abf")
    ("nf-md-gesture_swipe_left" . "\xf073e")
    ("nf-md-gesture_swipe_right" . "\xf073f")
    ("nf-md-gesture_swipe_up" . "\xf0740")
    ("nf-md-gesture_swipe_vertical" . "\xf0ac0")
    ("nf-md-gesture_tap" . "\xf0741")
    ("nf-md-gesture_tap_box" . "\xf12a9")
    ("nf-md-gesture_tap_button" . "\xf12a8")
    ("nf-md-gesture_tap_hold" . "\xf0d77")
    ("nf-md-gesture_two_double_tap" . "\xf0742")
    ("nf-md-gesture_two_tap" . "\xf0743")
    ("nf-md-ghost" . "\xf02a0")
    ("nf-md-ghost_off" . "\xf09f5")
    ("nf-md-ghost_off_outline" . "\xf165c")
    ("nf-md-ghost_outline" . "\xf165d")
    ("nf-md-gift" . "\xf0e44")
    ("nf-md-gift_off" . "\xf16ef")
    ("nf-md-gift_off_outline" . "\xf16f0")
    ("nf-md-gift_open" . "\xf16f1")
    ("nf-md-gift_open_outline" . "\xf16f2")
    ("nf-md-gift_outline" . "\xf02a1")
    ("nf-md-git" . "\xf02a2")
    ("nf-md-github" . "\xf02a4")
    ("nf-md-gitlab" . "\xf0ba0")
    ("nf-md-glass_cocktail" . "\xf0356")
    ("nf-md-glass_cocktail_off" . "\xf15e6")
    ("nf-md-glass_flute" . "\xf02a5")
    ("nf-md-glass_fragile" . "\xf1873")
    ("nf-md-glass_mug" . "\xf02a6")
    ("nf-md-glass_mug_off" . "\xf15e7")
    ("nf-md-glass_mug_variant" . "\xf1116")
    ("nf-md-glass_mug_variant_off" . "\xf15e8")
    ("nf-md-glass_pint_outline" . "\xf130d")
    ("nf-md-glass_stange" . "\xf02a7")
    ("nf-md-glass_tulip" . "\xf02a8")
    ("nf-md-glass_wine" . "\xf0876")
    ("nf-md-glasses" . "\xf02aa")
    ("nf-md-globe_light" . "\xf12d7")
    ("nf-md-globe_model" . "\xf08e9")
    ("nf-md-gmail" . "\xf02ab")
    ("nf-md-gnome" . "\xf02ac")
    ("nf-md-go_kart" . "\xf0d79")
    ("nf-md-go_kart_track" . "\xf0d7a")
    ("nf-md-gog" . "\xf0ba1")
    ("nf-md-gold" . "\xf124f")
    ("nf-md-golf" . "\xf0823")
    ("nf-md-golf_cart" . "\xf11a4")
    ("nf-md-golf_tee" . "\xf1083")
    ("nf-md-gondola" . "\xf0686")
    ("nf-md-goodreads" . "\xf0d7b")
    ("nf-md-google" . "\xf02ad")
    ("nf-md-google_ads" . "\xf0c87")
    ("nf-md-google_analytics" . "\xf07cc")
    ("nf-md-google_assistant" . "\xf07cd")
    ("nf-md-google_cardboard" . "\xf02ae")
    ("nf-md-google_chrome" . "\xf02af")
    ("nf-md-google_circles" . "\xf02b0")
    ("nf-md-google_circles_communities" . "\xf02b1")
    ("nf-md-google_circles_extended" . "\xf02b2")
    ("nf-md-google_circles_group" . "\xf02b3")
    ("nf-md-google_classroom" . "\xf02c0")
    ("nf-md-google_cloud" . "\xf11f6")
    ("nf-md-google_controller" . "\xf02b4")
    ("nf-md-google_controller_off" . "\xf02b5")
    ("nf-md-google_downasaur" . "\xf1362")
    ("nf-md-google_drive" . "\xf02b6")
    ("nf-md-google_earth" . "\xf02b7")
    ("nf-md-google_fit" . "\xf096c")
    ("nf-md-google_glass" . "\xf02b8")
    ("nf-md-google_hangouts" . "\xf02c9")
    ("nf-md-google_home" . "\xf0824")
    ("nf-md-google_keep" . "\xf06dc")
    ("nf-md-google_lens" . "\xf09f6")
    ("nf-md-google_maps" . "\xf05f5")
    ("nf-md-google_my_business" . "\xf1048")
    ("nf-md-google_nearby" . "\xf02b9")
    ("nf-md-google_play" . "\xf02bc")
    ("nf-md-google_plus" . "\xf02bd")
    ("nf-md-google_podcast" . "\xf0eb9")
    ("nf-md-google_spreadsheet" . "\xf09f7")
    ("nf-md-google_street_view" . "\xf0c88")
    ("nf-md-google_translate" . "\xf02bf")
    ("nf-md-gradient_horizontal" . "\xf174a")
    ("nf-md-gradient_vertical" . "\xf06a0")
    ("nf-md-grain" . "\xf0d7c")
    ("nf-md-graph" . "\xf1049")
    ("nf-md-graph_outline" . "\xf104a")
    ("nf-md-graphql" . "\xf0877")
    ("nf-md-grass" . "\xf1510")
    ("nf-md-grave_stone" . "\xf0ba2")
    ("nf-md-grease_pencil" . "\xf0648")
    ("nf-md-greater_than" . "\xf096d")
    ("nf-md-greater_than_or_equal" . "\xf096e")
    ("nf-md-greenhouse" . "\xf002d")
    ("nf-md-grid" . "\xf02c1")
    ("nf-md-grid_large" . "\xf0758")
    ("nf-md-grid_off" . "\xf02c2")
    ("nf-md-grill" . "\xf0e45")
    ("nf-md-grill_outline" . "\xf118a")
    ("nf-md-group" . "\xf02c3")
    ("nf-md-guitar_acoustic" . "\xf0771")
    ("nf-md-guitar_electric" . "\xf02c4")
    ("nf-md-guitar_pick" . "\xf02c5")
    ("nf-md-guitar_pick_outline" . "\xf02c6")
    ("nf-md-guy_fawkes_mask" . "\xf0825")
    ("nf-md-gymnastics" . "\xf1a41")
    ("nf-md-hail" . "\xf0ac1")
    ("nf-md-hair_dryer" . "\xf10ef")
    ("nf-md-hair_dryer_outline" . "\xf10f0")
    ("nf-md-halloween" . "\xf0ba3")
    ("nf-md-hamburger" . "\xf0685")
    ("nf-md-hamburger_check" . "\xf1776")
    ("nf-md-hamburger_minus" . "\xf1777")
    ("nf-md-hamburger_off" . "\xf1778")
    ("nf-md-hamburger_plus" . "\xf1779")
    ("nf-md-hamburger_remove" . "\xf177a")
    ("nf-md-hammer" . "\xf08ea")
    ("nf-md-hammer_screwdriver" . "\xf1322")
    ("nf-md-hammer_sickle" . "\xf1887")
    ("nf-md-hammer_wrench" . "\xf1323")
    ("nf-md-hand_back_left" . "\xf0e46")
    ("nf-md-hand_back_left_off" . "\xf1830")
    ("nf-md-hand_back_left_off_outline" . "\xf1832")
    ("nf-md-hand_back_left_outline" . "\xf182c")
    ("nf-md-hand_back_right" . "\xf0e47")
    ("nf-md-hand_back_right_off" . "\xf1831")
    ("nf-md-hand_back_right_off_outline" . "\xf1833")
    ("nf-md-hand_back_right_outline" . "\xf182d")
    ("nf-md-hand_clap" . "\xf194b")
    ("nf-md-hand_clap_off" . "\xf1a42")
    ("nf-md-hand_coin" . "\xf188f")
    ("nf-md-hand_coin_outline" . "\xf1890")
    ("nf-md-hand_extended" . "\xf18b6")
    ("nf-md-hand_extended_outline" . "\xf18b7")
    ("nf-md-hand_front_left" . "\xf182b")
    ("nf-md-hand_front_left_outline" . "\xf182e")
    ("nf-md-hand_front_right" . "\xf0a4f")
    ("nf-md-hand_front_right_outline" . "\xf182f")
    ("nf-md-hand_heart" . "\xf10f1")
    ("nf-md-hand_heart_outline" . "\xf157e")
    ("nf-md-hand_okay" . "\xf0a50")
    ("nf-md-hand_peace" . "\xf0a51")
    ("nf-md-hand_peace_variant" . "\xf0a52")
    ("nf-md-hand_pointing_down" . "\xf0a53")
    ("nf-md-hand_pointing_left" . "\xf0a54")
    ("nf-md-hand_pointing_right" . "\xf02c7")
    ("nf-md-hand_pointing_up" . "\xf0a55")
    ("nf-md-hand_saw" . "\xf0e48")
    ("nf-md-hand_wash" . "\xf157f")
    ("nf-md-hand_wash_outline" . "\xf1580")
    ("nf-md-hand_water" . "\xf139f")
    ("nf-md-hand_wave" . "\xf1821")
    ("nf-md-hand_wave_outline" . "\xf1822")
    ("nf-md-handball" . "\xf0f53")
    ("nf-md-handcuffs" . "\xf113e")
    ("nf-md-hands_pray" . "\xf0579")
    ("nf-md-handshake" . "\xf1218")
    ("nf-md-handshake_outline" . "\xf15a1")
    ("nf-md-hanger" . "\xf02c8")
    ("nf-md-hard_hat" . "\xf096f")
    ("nf-md-harddisk" . "\xf02ca")
    ("nf-md-harddisk_plus" . "\xf104b")
    ("nf-md-harddisk_remove" . "\xf104c")
    ("nf-md-hat_fedora" . "\xf0ba4")
    ("nf-md-hazard_lights" . "\xf0c89")
    ("nf-md-hdr" . "\xf0d7d")
    ("nf-md-hdr_off" . "\xf0d7e")
    ("nf-md-head" . "\xf135e")
    ("nf-md-head_alert" . "\xf1338")
    ("nf-md-head_alert_outline" . "\xf1339")
    ("nf-md-head_check" . "\xf133a")
    ("nf-md-head_check_outline" . "\xf133b")
    ("nf-md-head_cog" . "\xf133c")
    ("nf-md-head_cog_outline" . "\xf133d")
    ("nf-md-head_dots_horizontal" . "\xf133e")
    ("nf-md-head_dots_horizontal_outline" . "\xf133f")
    ("nf-md-head_flash" . "\xf1340")
    ("nf-md-head_flash_outline" . "\xf1341")
    ("nf-md-head_heart" . "\xf1342")
    ("nf-md-head_heart_outline" . "\xf1343")
    ("nf-md-head_lightbulb" . "\xf1344")
    ("nf-md-head_lightbulb_outline" . "\xf1345")
    ("nf-md-head_minus" . "\xf1346")
    ("nf-md-head_minus_outline" . "\xf1347")
    ("nf-md-head_outline" . "\xf135f")
    ("nf-md-head_plus" . "\xf1348")
    ("nf-md-head_plus_outline" . "\xf1349")
    ("nf-md-head_question" . "\xf134a")
    ("nf-md-head_question_outline" . "\xf134b")
    ("nf-md-head_remove" . "\xf134c")
    ("nf-md-head_remove_outline" . "\xf134d")
    ("nf-md-head_snowflake" . "\xf134e")
    ("nf-md-head_snowflake_outline" . "\xf134f")
    ("nf-md-head_sync" . "\xf1350")
    ("nf-md-head_sync_outline" . "\xf1351")
    ("nf-md-headphones" . "\xf02cb")
    ("nf-md-headphones_bluetooth" . "\xf0970")
    ("nf-md-headphones_box" . "\xf02cc")
    ("nf-md-headphones_off" . "\xf07ce")
    ("nf-md-headphones_settings" . "\xf02cd")
    ("nf-md-headset" . "\xf02ce")
    ("nf-md-headset_dock" . "\xf02cf")
    ("nf-md-headset_off" . "\xf02d0")
    ("nf-md-heart" . "\xf08d0")
    ("nf-md-heart_box" . "\xf02d2")
    ("nf-md-heart_box_outline" . "\xf02d3")
    ("nf-md-heart_broken" . "\xf02d4")
    ("nf-md-heart_broken_outline" . "\xf0d14")
    ("nf-md-heart_circle" . "\xf0971")
    ("nf-md-heart_circle_outline" . "\xf0972")
    ("nf-md-heart_cog" . "\xf1663")
    ("nf-md-heart_cog_outline" . "\xf1664")
    ("nf-md-heart_flash" . "\xf0ef9")
    ("nf-md-heart_half" . "\xf06df")
    ("nf-md-heart_half_full" . "\xf06de")
    ("nf-md-heart_half_outline" . "\xf06e0")
    ("nf-md-heart_minus" . "\xf142f")
    ("nf-md-heart_minus_outline" . "\xf1432")
    ("nf-md-heart_multiple" . "\xf0a56")
    ("nf-md-heart_multiple_outline" . "\xf0a57")
    ("nf-md-heart_off" . "\xf0759")
    ("nf-md-heart_off_outline" . "\xf1434")
    ("nf-md-heart_outline" . "\xf18a0")
    ("nf-md-heart_plus" . "\xf142e")
    ("nf-md-heart_plus_outline" . "\xf1431")
    ("nf-md-heart_pulse" . "\xf05f6")
    ("nf-md-heart_remove" . "\xf1430")
    ("nf-md-heart_remove_outline" . "\xf1433")
    ("nf-md-heart_settings" . "\xf1665")
    ("nf-md-heart_settings_outline" . "\xf1666")
    ("nf-md-heat_pump" . "\xf1a43")
    ("nf-md-heat_pump_outline" . "\xf1a44")
    ("nf-md-heat_wave" . "\xf1a45")
    ("nf-md-heating_coil" . "\xf1aaf")
    ("nf-md-helicopter" . "\xf0ac2")
    ("nf-md-help" . "\xf02d6")
    ("nf-md-help_box" . "\xf078b")
    ("nf-md-help_circle" . "\xf02d7")
    ("nf-md-help_circle_outline" . "\xf0625")
    ("nf-md-help_network" . "\xf06f5")
    ("nf-md-help_network_outline" . "\xf0c8a")
    ("nf-md-help_rhombus" . "\xf0ba5")
    ("nf-md-help_rhombus_outline" . "\xf0ba6")
    ("nf-md-hexadecimal" . "\xf12a7")
    ("nf-md-hexagon" . "\xf02d8")
    ("nf-md-hexagon_multiple" . "\xf06e1")
    ("nf-md-hexagon_multiple_outline" . "\xf10f2")
    ("nf-md-hexagon_outline" . "\xf02d9")
    ("nf-md-hexagon_slice_1" . "\xf0ac3")
    ("nf-md-hexagon_slice_2" . "\xf0ac4")
    ("nf-md-hexagon_slice_3" . "\xf0ac5")
    ("nf-md-hexagon_slice_4" . "\xf0ac6")
    ("nf-md-hexagon_slice_5" . "\xf0ac7")
    ("nf-md-hexagon_slice_6" . "\xf0ac8")
    ("nf-md-hexagram" . "\xf0ac9")
    ("nf-md-hexagram_outline" . "\xf0aca")
    ("nf-md-high_definition" . "\xf07cf")
    ("nf-md-high_definition_box" . "\xf0878")
    ("nf-md-highway" . "\xf05f7")
    ("nf-md-hiking" . "\xf0d7f")
    ("nf-md-history" . "\xf02da")
    ("nf-md-hockey_puck" . "\xf0879")
    ("nf-md-hockey_sticks" . "\xf087a")
    ("nf-md-hololens" . "\xf02db")
    ("nf-md-home" . "\xf02dc")
    ("nf-md-home_account" . "\xf0826")
    ("nf-md-home_alert" . "\xf087b")
    ("nf-md-home_alert_outline" . "\xf15d0")
    ("nf-md-home_analytics" . "\xf0eba")
    ("nf-md-home_assistant" . "\xf07d0")
    ("nf-md-home_automation" . "\xf07d1")
    ("nf-md-home_battery" . "\xf1901")
    ("nf-md-home_battery_outline" . "\xf1902")
    ("nf-md-home_circle" . "\xf07d2")
    ("nf-md-home_circle_outline" . "\xf104d")
    ("nf-md-home_city" . "\xf0d15")
    ("nf-md-home_city_outline" . "\xf0d16")
    ("nf-md-home_clock" . "\xf1a12")
    ("nf-md-home_clock_outline" . "\xf1a13")
    ("nf-md-home_edit" . "\xf1159")
    ("nf-md-home_edit_outline" . "\xf115a")
    ("nf-md-home_export_outline" . "\xf0f9b")
    ("nf-md-home_flood" . "\xf0efa")
    ("nf-md-home_floor_0" . "\xf0dd2")
    ("nf-md-home_floor_1" . "\xf0d80")
    ("nf-md-home_floor_2" . "\xf0d81")
    ("nf-md-home_floor_3" . "\xf0d82")
    ("nf-md-home_floor_a" . "\xf0d83")
    ("nf-md-home_floor_b" . "\xf0d84")
    ("nf-md-home_floor_g" . "\xf0d85")
    ("nf-md-home_floor_l" . "\xf0d86")
    ("nf-md-home_floor_negative_1" . "\xf0dd3")
    ("nf-md-home_group" . "\xf0dd4")
    ("nf-md-home_group_minus" . "\xf19c1")
    ("nf-md-home_group_plus" . "\xf19c0")
    ("nf-md-home_group_remove" . "\xf19c2")
    ("nf-md-home_heart" . "\xf0827")
    ("nf-md-home_import_outline" . "\xf0f9c")
    ("nf-md-home_lightbulb" . "\xf1251")
    ("nf-md-home_lightbulb_outline" . "\xf1252")
    ("nf-md-home_lightning_bolt" . "\xf1903")
    ("nf-md-home_lightning_bolt_outline" . "\xf1904")
    ("nf-md-home_lock" . "\xf08eb")
    ("nf-md-home_lock_open" . "\xf08ec")
    ("nf-md-home_map_marker" . "\xf05f8")
    ("nf-md-home_minus" . "\xf0974")
    ("nf-md-home_minus_outline" . "\xf13d5")
    ("nf-md-home_modern" . "\xf02dd")
    ("nf-md-home_off" . "\xf1a46")
    ("nf-md-home_off_outline" . "\xf1a47")
    ("nf-md-home_outline" . "\xf06a1")
    ("nf-md-home_plus" . "\xf0975")
    ("nf-md-home_plus_outline" . "\xf13d6")
    ("nf-md-home_remove" . "\xf1247")
    ("nf-md-home_remove_outline" . "\xf13d7")
    ("nf-md-home_roof" . "\xf112b")
    ("nf-md-home_search" . "\xf13b0")
    ("nf-md-home_search_outline" . "\xf13b1")
    ("nf-md-home_switch" . "\xf1794")
    ("nf-md-home_switch_outline" . "\xf1795")
    ("nf-md-home_thermometer" . "\xf0f54")
    ("nf-md-home_thermometer_outline" . "\xf0f55")
    ("nf-md-home_variant" . "\xf02de")
    ("nf-md-home_variant_outline" . "\xf0ba7")
    ("nf-md-hook" . "\xf06e2")
    ("nf-md-hook_off" . "\xf06e3")
    ("nf-md-hoop_house" . "\xf0e56")
    ("nf-md-hops" . "\xf02df")
    ("nf-md-horizontal_rotate_clockwise" . "\xf10f3")
    ("nf-md-horizontal_rotate_counterclockwise" . "\xf10f4")
    ("nf-md-horse" . "\xf15bf")
    ("nf-md-horse_human" . "\xf15c0")
    ("nf-md-horse_variant" . "\xf15c1")
    ("nf-md-horse_variant_fast" . "\xf186e")
    ("nf-md-horseshoe" . "\xf0a58")
    ("nf-md-hospital" . "\xf0ff6")
    ("nf-md-hospital_box" . "\xf02e0")
    ("nf-md-hospital_box_outline" . "\xf0ff7")
    ("nf-md-hospital_building" . "\xf02e1")
    ("nf-md-hospital_marker" . "\xf02e2")
    ("nf-md-hot_tub" . "\xf0828")
    ("nf-md-hours_24" . "\xf1478")
    ("nf-md-hubspot" . "\xf0d17")
    ("nf-md-hulu" . "\xf0829")
    ("nf-md-human" . "\xf02e6")
    ("nf-md-human_baby_changing_table" . "\xf138b")
    ("nf-md-human_cane" . "\xf1581")
    ("nf-md-human_capacity_decrease" . "\xf159b")
    ("nf-md-human_capacity_increase" . "\xf159c")
    ("nf-md-human_child" . "\xf02e7")
    ("nf-md-human_dolly" . "\xf1980")
    ("nf-md-human_edit" . "\xf14e8")
    ("nf-md-human_female" . "\xf0649")
    ("nf-md-human_female_boy" . "\xf0a59")
    ("nf-md-human_female_dance" . "\xf15c9")
    ("nf-md-human_female_female" . "\xf0a5a")
    ("nf-md-human_female_girl" . "\xf0a5b")
    ("nf-md-human_greeting" . "\xf17c4")
    ("nf-md-human_greeting_proximity" . "\xf159d")
    ("nf-md-human_greeting_variant" . "\xf064a")
    ("nf-md-human_handsdown" . "\xf064b")
    ("nf-md-human_handsup" . "\xf064c")
    ("nf-md-human_male" . "\xf064d")
    ("nf-md-human_male_board" . "\xf0890")
    ("nf-md-human_male_board_poll" . "\xf0846")
    ("nf-md-human_male_boy" . "\xf0a5c")
    ("nf-md-human_male_child" . "\xf138c")
    ("nf-md-human_male_female" . "\xf02e8")
    ("nf-md-human_male_female_child" . "\xf1823")
    ("nf-md-human_male_girl" . "\xf0a5d")
    ("nf-md-human_male_height" . "\xf0efb")
    ("nf-md-human_male_height_variant" . "\xf0efc")
    ("nf-md-human_male_male" . "\xf0a5e")
    ("nf-md-human_non_binary" . "\xf1848")
    ("nf-md-human_pregnant" . "\xf05cf")
    ("nf-md-human_queue" . "\xf1571")
    ("nf-md-human_scooter" . "\xf11e9")
    ("nf-md-human_wheelchair" . "\xf138d")
    ("nf-md-human_white_cane" . "\xf1981")
    ("nf-md-humble_bundle" . "\xf0744")
    ("nf-md-hvac" . "\xf1352")
    ("nf-md-hvac_off" . "\xf159e")
    ("nf-md-hydraulic_oil_level" . "\xf1324")
    ("nf-md-hydraulic_oil_temperature" . "\xf1325")
    ("nf-md-hydro_power" . "\xf12e5")
    ("nf-md-hydrogen_station" . "\xf1894")
    ("nf-md-ice_cream" . "\xf082a")
    ("nf-md-ice_cream_off" . "\xf0e52")
    ("nf-md-ice_pop" . "\xf0efd")
    ("nf-md-id_card" . "\xf0fc0")
    ("nf-md-identifier" . "\xf0efe")
    ("nf-md-ideogram_cjk" . "\xf1331")
    ("nf-md-ideogram_cjk_variant" . "\xf1332")
    ("nf-md-image" . "\xf02e9")
    ("nf-md-image_album" . "\xf02ea")
    ("nf-md-image_area" . "\xf02eb")
    ("nf-md-image_area_close" . "\xf02ec")
    ("nf-md-image_auto_adjust" . "\xf0fc1")
    ("nf-md-image_broken" . "\xf02ed")
    ("nf-md-image_broken_variant" . "\xf02ee")
    ("nf-md-image_edit" . "\xf11e3")
    ("nf-md-image_edit_outline" . "\xf11e4")
    ("nf-md-image_filter_black_white" . "\xf02f0")
    ("nf-md-image_filter_center_focus" . "\xf02f1")
    ("nf-md-image_filter_center_focus_strong" . "\xf0eff")
    ("nf-md-image_filter_center_focus_strong_outline" . "\xf0f00")
    ("nf-md-image_filter_center_focus_weak" . "\xf02f2")
    ("nf-md-image_filter_drama" . "\xf02f3")
    ("nf-md-image_filter_frames" . "\xf02f4")
    ("nf-md-image_filter_hdr" . "\xf0509")
    ("nf-md-image_filter_none" . "\xf02f6")
    ("nf-md-image_filter_tilt_shift" . "\xf02f7")
    ("nf-md-image_filter_vintage" . "\xf02f8")
    ("nf-md-image_frame" . "\xf0e49")
    ("nf-md-image_lock" . "\xf1ab0")
    ("nf-md-image_lock_outline" . "\xf1ab1")
    ("nf-md-image_marker" . "\xf177b")
    ("nf-md-image_marker_outline" . "\xf177c")
    ("nf-md-image_minus" . "\xf1419")
    ("nf-md-image_move" . "\xf09f8")
    ("nf-md-image_multiple" . "\xf02f9")
    ("nf-md-image_multiple_outline" . "\xf02ef")
    ("nf-md-image_off" . "\xf082b")
    ("nf-md-image_off_outline" . "\xf11d1")
    ("nf-md-image_outline" . "\xf0976")
    ("nf-md-image_plus" . "\xf087c")
    ("nf-md-image_refresh" . "\xf19fe")
    ("nf-md-image_refresh_outline" . "\xf19ff")
    ("nf-md-image_remove" . "\xf1418")
    ("nf-md-image_search" . "\xf0977")
    ("nf-md-image_search_outline" . "\xf0978")
    ("nf-md-image_size_select_actual" . "\xf0c8d")
    ("nf-md-image_size_select_large" . "\xf0c8e")
    ("nf-md-image_size_select_small" . "\xf0c8f")
    ("nf-md-image_sync" . "\xf1a00")
    ("nf-md-image_sync_outline" . "\xf1a01")
    ("nf-md-image_text" . "\xf160d")
    ("nf-md-import" . "\xf02fa")
    ("nf-md-inbox" . "\xf0687")
    ("nf-md-inbox_arrow_down" . "\xf02fb")
    ("nf-md-inbox_arrow_down_outline" . "\xf1270")
    ("nf-md-inbox_arrow_up" . "\xf03d1")
    ("nf-md-inbox_arrow_up_outline" . "\xf1271")
    ("nf-md-inbox_full" . "\xf1272")
    ("nf-md-inbox_full_outline" . "\xf1273")
    ("nf-md-inbox_multiple" . "\xf08b0")
    ("nf-md-inbox_multiple_outline" . "\xf0ba8")
    ("nf-md-inbox_outline" . "\xf1274")
    ("nf-md-inbox_remove" . "\xf159f")
    ("nf-md-inbox_remove_outline" . "\xf15a0")
    ("nf-md-incognito" . "\xf05f9")
    ("nf-md-incognito_circle" . "\xf1421")
    ("nf-md-incognito_circle_off" . "\xf1422")
    ("nf-md-incognito_off" . "\xf0075")
    ("nf-md-induction" . "\xf184c")
    ("nf-md-infinity" . "\xf06e4")
    ("nf-md-information" . "\xf02fc")
    ("nf-md-information_off" . "\xf178c")
    ("nf-md-information_off_outline" . "\xf178d")
    ("nf-md-information_outline" . "\xf02fd")
    ("nf-md-information_variant" . "\xf064e")
    ("nf-md-instagram" . "\xf02fe")
    ("nf-md-instrument_triangle" . "\xf104e")
    ("nf-md-integrated_circuit_chip" . "\xf1913")
    ("nf-md-invert_colors" . "\xf0301")
    ("nf-md-invert_colors_off" . "\xf0e4a")
    ("nf-md-iobroker" . "\xf12e8")
    ("nf-md-ip" . "\xf0a5f")
    ("nf-md-ip_network" . "\xf0a60")
    ("nf-md-ip_network_outline" . "\xf0c90")
    ("nf-md-ip_outline" . "\xf1982")
    ("nf-md-ipod" . "\xf0c91")
    ("nf-md-iron" . "\xf1824")
    ("nf-md-iron_board" . "\xf1838")
    ("nf-md-iron_outline" . "\xf1825")
    ("nf-md-island" . "\xf104f")
    ("nf-md-iv_bag" . "\xf10b9")
    ("nf-md-jabber" . "\xf0dd5")
    ("nf-md-jeepney" . "\xf0302")
    ("nf-md-jellyfish" . "\xf0f01")
    ("nf-md-jellyfish_outline" . "\xf0f02")
    ("nf-md-jira" . "\xf0303")
    ("nf-md-jquery" . "\xf087d")
    ("nf-md-jsfiddle" . "\xf0304")
    ("nf-md-jump_rope" . "\xf12ff")
    ("nf-md-kabaddi" . "\xf0d87")
    ("nf-md-kangaroo" . "\xf1558")
    ("nf-md-karate" . "\xf082c")
    ("nf-md-kayaking" . "\xf08af")
    ("nf-md-keg" . "\xf0305")
    ("nf-md-kettle" . "\xf05fa")
    ("nf-md-kettle_alert" . "\xf1317")
    ("nf-md-kettle_alert_outline" . "\xf1318")
    ("nf-md-kettle_off" . "\xf131b")
    ("nf-md-kettle_off_outline" . "\xf131c")
    ("nf-md-kettle_outline" . "\xf0f56")
    ("nf-md-kettle_pour_over" . "\xf173c")
    ("nf-md-kettle_steam" . "\xf1319")
    ("nf-md-kettle_steam_outline" . "\xf131a")
    ("nf-md-kettlebell" . "\xf1300")
    ("nf-md-key" . "\xf0306")
    ("nf-md-key_alert" . "\xf1983")
    ("nf-md-key_alert_outline" . "\xf1984")
    ("nf-md-key_arrow_right" . "\xf1312")
    ("nf-md-key_chain" . "\xf1574")
    ("nf-md-key_chain_variant" . "\xf1575")
    ("nf-md-key_change" . "\xf0307")
    ("nf-md-key_link" . "\xf119f")
    ("nf-md-key_minus" . "\xf0308")
    ("nf-md-key_outline" . "\xf0dd6")
    ("nf-md-key_plus" . "\xf0309")
    ("nf-md-key_remove" . "\xf030a")
    ("nf-md-key_star" . "\xf119e")
    ("nf-md-key_variant" . "\xf030b")
    ("nf-md-key_wireless" . "\xf0fc2")
    ("nf-md-keyboard" . "\xf030c")
    ("nf-md-keyboard_backspace" . "\xf030d")
    ("nf-md-keyboard_caps" . "\xf030e")
    ("nf-md-keyboard_close" . "\xf030f")
    ("nf-md-keyboard_esc" . "\xf12b7")
    ("nf-md-keyboard_f1" . "\xf12ab")
    ("nf-md-keyboard_f10" . "\xf12b4")
    ("nf-md-keyboard_f11" . "\xf12b5")
    ("nf-md-keyboard_f12" . "\xf12b6")
    ("nf-md-keyboard_f2" . "\xf12ac")
    ("nf-md-keyboard_f3" . "\xf12ad")
    ("nf-md-keyboard_f4" . "\xf12ae")
    ("nf-md-keyboard_f5" . "\xf12af")
    ("nf-md-keyboard_f6" . "\xf12b0")
    ("nf-md-keyboard_f7" . "\xf12b1")
    ("nf-md-keyboard_f8" . "\xf12b2")
    ("nf-md-keyboard_f9" . "\xf12b3")
    ("nf-md-keyboard_off" . "\xf0310")
    ("nf-md-keyboard_off_outline" . "\xf0e4b")
    ("nf-md-keyboard_outline" . "\xf097b")
    ("nf-md-keyboard_return" . "\xf0311")
    ("nf-md-keyboard_settings" . "\xf09f9")
    ("nf-md-keyboard_settings_outline" . "\xf09fa")
    ("nf-md-keyboard_space" . "\xf1050")
    ("nf-md-keyboard_tab" . "\xf0312")
    ("nf-md-keyboard_tab_reverse" . "\xf0325")
    ("nf-md-keyboard_variant" . "\xf0313")
    ("nf-md-khanda" . "\xf10fd")
    ("nf-md-kickstarter" . "\xf0745")
    ("nf-md-kite" . "\xf1985")
    ("nf-md-kite_outline" . "\xf1986")
    ("nf-md-kitesurfing" . "\xf1744")
    ("nf-md-klingon" . "\xf135b")
    ("nf-md-knife" . "\xf09fb")
    ("nf-md-knife_military" . "\xf09fc")
    ("nf-md-koala" . "\xf173f")
    ("nf-md-kodi" . "\xf0314")
    ("nf-md-kubernetes" . "\xf10fe")
    ("nf-md-label" . "\xf0315")
    ("nf-md-label_multiple" . "\xf1375")
    ("nf-md-label_multiple_outline" . "\xf1376")
    ("nf-md-label_off" . "\xf0acb")
    ("nf-md-label_off_outline" . "\xf0acc")
    ("nf-md-label_outline" . "\xf0316")
    ("nf-md-label_percent" . "\xf12ea")
    ("nf-md-label_percent_outline" . "\xf12eb")
    ("nf-md-label_variant" . "\xf0acd")
    ("nf-md-label_variant_outline" . "\xf0ace")
    ("nf-md-ladder" . "\xf15a2")
    ("nf-md-ladybug" . "\xf082d")
    ("nf-md-lambda" . "\xf0627")
    ("nf-md-lamp" . "\xf06b5")
    ("nf-md-lamp_outline" . "\xf17d0")
    ("nf-md-lamps" . "\xf1576")
    ("nf-md-lamps_outline" . "\xf17d1")
    ("nf-md-lan" . "\xf0317")
    ("nf-md-lan_check" . "\xf12aa")
    ("nf-md-lan_connect" . "\xf0318")
    ("nf-md-lan_disconnect" . "\xf0319")
    ("nf-md-lan_pending" . "\xf031a")
    ("nf-md-land_fields" . "\xf1ab2")
    ("nf-md-land_plots" . "\xf1ab3")
    ("nf-md-land_plots_circle" . "\xf1ab4")
    ("nf-md-land_plots_circle_variant" . "\xf1ab5")
    ("nf-md-land_rows_horizontal" . "\xf1ab6")
    ("nf-md-land_rows_vertical" . "\xf1ab7")
    ("nf-md-landslide" . "\xf1a48")
    ("nf-md-landslide_outline" . "\xf1a49")
    ("nf-md-language_c" . "\xf0671")
    ("nf-md-language_cpp" . "\xf0672")
    ("nf-md-language_csharp" . "\xf031b")
    ("nf-md-language_css3" . "\xf031c")
    ("nf-md-language_fortran" . "\xf121a")
    ("nf-md-language_go" . "\xf07d3")
    ("nf-md-language_haskell" . "\xf0c92")
    ("nf-md-language_html5" . "\xf031d")
    ("nf-md-language_java" . "\xf0b37")
    ("nf-md-language_javascript" . "\xf031e")
    ("nf-md-language_kotlin" . "\xf1219")
    ("nf-md-language_lua" . "\xf08b1")
    ("nf-md-language_markdown" . "\xf0354")
    ("nf-md-language_markdown_outline" . "\xf0f5b")
    ("nf-md-language_php" . "\xf031f")
    ("nf-md-language_python" . "\xf0320")
    ("nf-md-language_r" . "\xf07d4")
    ("nf-md-language_ruby" . "\xf0d2d")
    ("nf-md-language_ruby_on_rails" . "\xf0acf")
    ("nf-md-language_rust" . "\xf1617")
    ("nf-md-language_swift" . "\xf06e5")
    ("nf-md-language_typescript" . "\xf06e6")
    ("nf-md-language_xaml" . "\xf0673")
    ("nf-md-laptop" . "\xf0322")
    ("nf-md-laptop_account" . "\xf1a4a")
    ("nf-md-laptop_off" . "\xf06e7")
    ("nf-md-laravel" . "\xf0ad0")
    ("nf-md-laser_pointer" . "\xf1484")
    ("nf-md-lasso" . "\xf0f03")
    ("nf-md-lastpass" . "\xf0446")
    ("nf-md-latitude" . "\xf0f57")
    ("nf-md-launch" . "\xf0327")
    ("nf-md-lava_lamp" . "\xf07d5")
    ("nf-md-layers" . "\xf0328")
    ("nf-md-layers_edit" . "\xf1892")
    ("nf-md-layers_minus" . "\xf0e4c")
    ("nf-md-layers_off" . "\xf0329")
    ("nf-md-layers_off_outline" . "\xf09fd")
    ("nf-md-layers_outline" . "\xf09fe")
    ("nf-md-layers_plus" . "\xf0e4d")
    ("nf-md-layers_remove" . "\xf0e4e")
    ("nf-md-layers_search" . "\xf1206")
    ("nf-md-layers_search_outline" . "\xf1207")
    ("nf-md-layers_triple" . "\xf0f58")
    ("nf-md-layers_triple_outline" . "\xf0f59")
    ("nf-md-lead_pencil" . "\xf064f")
    ("nf-md-leaf" . "\xf032a")
    ("nf-md-leaf_circle" . "\xf1905")
    ("nf-md-leaf_circle_outline" . "\xf1906")
    ("nf-md-leaf_maple" . "\xf0c93")
    ("nf-md-leaf_maple_off" . "\xf12da")
    ("nf-md-leaf_off" . "\xf12d9")
    ("nf-md-leak" . "\xf0dd7")
    ("nf-md-leak_off" . "\xf0dd8")
    ("nf-md-lecturn" . "\xf1af0")
    ("nf-md-led_off" . "\xf032b")
    ("nf-md-led_on" . "\xf032c")
    ("nf-md-led_outline" . "\xf032d")
    ("nf-md-led_strip" . "\xf07d6")
    ("nf-md-led_strip_variant" . "\xf1051")
    ("nf-md-led_strip_variant_off" . "\xf1a4b")
    ("nf-md-led_variant_off" . "\xf032e")
    ("nf-md-led_variant_on" . "\xf032f")
    ("nf-md-led_variant_outline" . "\xf0330")
    ("nf-md-leek" . "\xf117d")
    ("nf-md-less_than" . "\xf097c")
    ("nf-md-less_than_or_equal" . "\xf097d")
    ("nf-md-library" . "\xf0331")
    ("nf-md-library_outline" . "\xf1a22")
    ("nf-md-library_shelves" . "\xf0ba9")
    ("nf-md-license" . "\xf0fc3")
    ("nf-md-lifebuoy" . "\xf087e")
    ("nf-md-light_flood_down" . "\xf1987")
    ("nf-md-light_flood_up" . "\xf1988")
    ("nf-md-light_recessed" . "\xf179b")
    ("nf-md-light_switch" . "\xf097e")
    ("nf-md-light_switch_off" . "\xf1a24")
    ("nf-md-lightbulb" . "\xf0335")
    ("nf-md-lightbulb_alert" . "\xf19e1")
    ("nf-md-lightbulb_alert_outline" . "\xf19e2")
    ("nf-md-lightbulb_auto" . "\xf1800")
    ("nf-md-lightbulb_auto_outline" . "\xf1801")
    ("nf-md-lightbulb_cfl" . "\xf1208")
    ("nf-md-lightbulb_cfl_off" . "\xf1209")
    ("nf-md-lightbulb_cfl_spiral" . "\xf1275")
    ("nf-md-lightbulb_cfl_spiral_off" . "\xf12c3")
    ("nf-md-lightbulb_fluorescent_tube" . "\xf1804")
    ("nf-md-lightbulb_fluorescent_tube_outline" . "\xf1805")
    ("nf-md-lightbulb_group" . "\xf1253")
    ("nf-md-lightbulb_group_off" . "\xf12cd")
    ("nf-md-lightbulb_group_off_outline" . "\xf12ce")
    ("nf-md-lightbulb_group_outline" . "\xf1254")
    ("nf-md-lightbulb_multiple" . "\xf1255")
    ("nf-md-lightbulb_multiple_off" . "\xf12cf")
    ("nf-md-lightbulb_multiple_off_outline" . "\xf12d0")
    ("nf-md-lightbulb_multiple_outline" . "\xf1256")
    ("nf-md-lightbulb_night" . "\xf1a4c")
    ("nf-md-lightbulb_night_outline" . "\xf1a4d")
    ("nf-md-lightbulb_off" . "\xf0e4f")
    ("nf-md-lightbulb_off_outline" . "\xf0e50")
    ("nf-md-lightbulb_on" . "\xf06e8")
    ("nf-md-lightbulb_on_10" . "\xf1a4e")
    ("nf-md-lightbulb_on_20" . "\xf1a4f")
    ("nf-md-lightbulb_on_30" . "\xf1a50")
    ("nf-md-lightbulb_on_40" . "\xf1a51")
    ("nf-md-lightbulb_on_50" . "\xf1a52")
    ("nf-md-lightbulb_on_60" . "\xf1a53")
    ("nf-md-lightbulb_on_70" . "\xf1a54")
    ("nf-md-lightbulb_on_80" . "\xf1a55")
    ("nf-md-lightbulb_on_90" . "\xf1a56")
    ("nf-md-lightbulb_on_outline" . "\xf06e9")
    ("nf-md-lightbulb_outline" . "\xf0336")
    ("nf-md-lightbulb_question" . "\xf19e3")
    ("nf-md-lightbulb_question_outline" . "\xf19e4")
    ("nf-md-lightbulb_spot" . "\xf17f4")
    ("nf-md-lightbulb_spot_off" . "\xf17f5")
    ("nf-md-lightbulb_variant" . "\xf1802")
    ("nf-md-lightbulb_variant_outline" . "\xf1803")
    ("nf-md-lighthouse" . "\xf09ff")
    ("nf-md-lighthouse_on" . "\xf0a00")
    ("nf-md-lightning_bolt" . "\xf140b")
    ("nf-md-lightning_bolt_circle" . "\xf0820")
    ("nf-md-lightning_bolt_outline" . "\xf140c")
    ("nf-md-line_scan" . "\xf0624")
    ("nf-md-lingerie" . "\xf1476")
    ("nf-md-link" . "\xf0337")
    ("nf-md-link_box" . "\xf0d1a")
    ("nf-md-link_box_outline" . "\xf0d1b")
    ("nf-md-link_box_variant" . "\xf0d1c")
    ("nf-md-link_box_variant_outline" . "\xf0d1d")
    ("nf-md-link_lock" . "\xf10ba")
    ("nf-md-link_off" . "\xf0338")
    ("nf-md-link_plus" . "\xf0c94")
    ("nf-md-link_variant" . "\xf0339")
    ("nf-md-link_variant_minus" . "\xf10ff")
    ("nf-md-link_variant_off" . "\xf033a")
    ("nf-md-link_variant_plus" . "\xf1100")
    ("nf-md-link_variant_remove" . "\xf1101")
    ("nf-md-linkedin" . "\xf033b")
    ("nf-md-linux" . "\xf033d")
    ("nf-md-linux_mint" . "\xf08ed")
    ("nf-md-lipstick" . "\xf13b5")
    ("nf-md-liquid_spot" . "\xf1826")
    ("nf-md-liquor" . "\xf191e")
    ("nf-md-list_status" . "\xf15ab")
    ("nf-md-litecoin" . "\xf0a61")
    ("nf-md-loading" . "\xf0772")
    ("nf-md-location_enter" . "\xf0fc4")
    ("nf-md-location_exit" . "\xf0fc5")
    ("nf-md-lock" . "\xf033e")
    ("nf-md-lock_alert" . "\xf08ee")
    ("nf-md-lock_alert_outline" . "\xf15d1")
    ("nf-md-lock_check" . "\xf139a")
    ("nf-md-lock_check_outline" . "\xf16a8")
    ("nf-md-lock_clock" . "\xf097f")
    ("nf-md-lock_minus" . "\xf16a9")
    ("nf-md-lock_minus_outline" . "\xf16aa")
    ("nf-md-lock_off" . "\xf1671")
    ("nf-md-lock_off_outline" . "\xf1672")
    ("nf-md-lock_open" . "\xf033f")
    ("nf-md-lock_open_alert" . "\xf139b")
    ("nf-md-lock_open_alert_outline" . "\xf15d2")
    ("nf-md-lock_open_check" . "\xf139c")
    ("nf-md-lock_open_check_outline" . "\xf16ab")
    ("nf-md-lock_open_minus" . "\xf16ac")
    ("nf-md-lock_open_minus_outline" . "\xf16ad")
    ("nf-md-lock_open_outline" . "\xf0340")
    ("nf-md-lock_open_plus" . "\xf16ae")
    ("nf-md-lock_open_plus_outline" . "\xf16af")
    ("nf-md-lock_open_remove" . "\xf16b0")
    ("nf-md-lock_open_remove_outline" . "\xf16b1")
    ("nf-md-lock_open_variant" . "\xf0fc6")
    ("nf-md-lock_open_variant_outline" . "\xf0fc7")
    ("nf-md-lock_outline" . "\xf0341")
    ("nf-md-lock_pattern" . "\xf06ea")
    ("nf-md-lock_plus" . "\xf05fb")
    ("nf-md-lock_plus_outline" . "\xf16b2")
    ("nf-md-lock_question" . "\xf08ef")
    ("nf-md-lock_remove" . "\xf16b3")
    ("nf-md-lock_remove_outline" . "\xf16b4")
    ("nf-md-lock_reset" . "\xf0773")
    ("nf-md-lock_smart" . "\xf08b2")
    ("nf-md-locker" . "\xf07d7")
    ("nf-md-locker_multiple" . "\xf07d8")
    ("nf-md-login" . "\xf0342")
    ("nf-md-logout" . "\xf0343")
    ("nf-md-logout_variant" . "\xf05fd")
    ("nf-md-longitude" . "\xf0f5a")
    ("nf-md-looks" . "\xf0344")
    ("nf-md-lotion" . "\xf1582")
    ("nf-md-lotion_outline" . "\xf1583")
    ("nf-md-lotion_plus" . "\xf1584")
    ("nf-md-lotion_plus_outline" . "\xf1585")
    ("nf-md-loupe" . "\xf0345")
    ("nf-md-lumx" . "\xf0346")
    ("nf-md-lungs" . "\xf1084")
    ("nf-md-mace" . "\xf1843")
    ("nf-md-magazine_pistol" . "\xf0324")
    ("nf-md-magazine_rifle" . "\xf0323")
    ("nf-md-magic_staff" . "\xf1844")
    ("nf-md-magnet" . "\xf0347")
    ("nf-md-magnet_on" . "\xf0348")
    ("nf-md-magnify" . "\xf0349")
    ("nf-md-magnify_close" . "\xf0980")
    ("nf-md-magnify_expand" . "\xf1874")
    ("nf-md-magnify_minus" . "\xf034a")
    ("nf-md-magnify_minus_cursor" . "\xf0a62")
    ("nf-md-magnify_minus_outline" . "\xf06ec")
    ("nf-md-magnify_plus" . "\xf034b")
    ("nf-md-magnify_plus_cursor" . "\xf0a63")
    ("nf-md-magnify_plus_outline" . "\xf06ed")
    ("nf-md-magnify_remove_cursor" . "\xf120c")
    ("nf-md-magnify_remove_outline" . "\xf120d")
    ("nf-md-magnify_scan" . "\xf1276")
    ("nf-md-mail" . "\xf0ebb")
    ("nf-md-mailbox" . "\xf06ee")
    ("nf-md-mailbox_open" . "\xf0d88")
    ("nf-md-mailbox_open_outline" . "\xf0d89")
    ("nf-md-mailbox_open_up" . "\xf0d8a")
    ("nf-md-mailbox_open_up_outline" . "\xf0d8b")
    ("nf-md-mailbox_outline" . "\xf0d8c")
    ("nf-md-mailbox_up" . "\xf0d8d")
    ("nf-md-mailbox_up_outline" . "\xf0d8e")
    ("nf-md-manjaro" . "\xf160a")
    ("nf-md-map" . "\xf034d")
    ("nf-md-map_check" . "\xf0ebc")
    ("nf-md-map_check_outline" . "\xf0ebd")
    ("nf-md-map_clock" . "\xf0d1e")
    ("nf-md-map_clock_outline" . "\xf0d1f")
    ("nf-md-map_legend" . "\xf0a01")
    ("nf-md-map_marker" . "\xf034e")
    ("nf-md-map_marker_account" . "\xf18e3")
    ("nf-md-map_marker_account_outline" . "\xf18e4")
    ("nf-md-map_marker_alert" . "\xf0f05")
    ("nf-md-map_marker_alert_outline" . "\xf0f06")
    ("nf-md-map_marker_check" . "\xf0c95")
    ("nf-md-map_marker_check_outline" . "\xf12fb")
    ("nf-md-map_marker_circle" . "\xf034f")
    ("nf-md-map_marker_distance" . "\xf08f0")
    ("nf-md-map_marker_down" . "\xf1102")
    ("nf-md-map_marker_left" . "\xf12db")
    ("nf-md-map_marker_left_outline" . "\xf12dd")
    ("nf-md-map_marker_minus" . "\xf0650")
    ("nf-md-map_marker_minus_outline" . "\xf12f9")
    ("nf-md-map_marker_multiple" . "\xf0350")
    ("nf-md-map_marker_multiple_outline" . "\xf1277")
    ("nf-md-map_marker_off" . "\xf0351")
    ("nf-md-map_marker_off_outline" . "\xf12fd")
    ("nf-md-map_marker_outline" . "\xf07d9")
    ("nf-md-map_marker_path" . "\xf0d20")
    ("nf-md-map_marker_plus" . "\xf0651")
    ("nf-md-map_marker_plus_outline" . "\xf12f8")
    ("nf-md-map_marker_question" . "\xf0f07")
    ("nf-md-map_marker_question_outline" . "\xf0f08")
    ("nf-md-map_marker_radius" . "\xf0352")
    ("nf-md-map_marker_radius_outline" . "\xf12fc")
    ("nf-md-map_marker_remove" . "\xf0f09")
    ("nf-md-map_marker_remove_outline" . "\xf12fa")
    ("nf-md-map_marker_remove_variant" . "\xf0f0a")
    ("nf-md-map_marker_right" . "\xf12dc")
    ("nf-md-map_marker_right_outline" . "\xf12de")
    ("nf-md-map_marker_star" . "\xf1608")
    ("nf-md-map_marker_star_outline" . "\xf1609")
    ("nf-md-map_marker_up" . "\xf1103")
    ("nf-md-map_minus" . "\xf0981")
    ("nf-md-map_outline" . "\xf0982")
    ("nf-md-map_plus" . "\xf0983")
    ("nf-md-map_search" . "\xf0984")
    ("nf-md-map_search_outline" . "\xf0985")
    ("nf-md-mapbox" . "\xf0baa")
    ("nf-md-margin" . "\xf0353")
    ("nf-md-marker" . "\xf0652")
    ("nf-md-marker_cancel" . "\xf0dd9")
    ("nf-md-marker_check" . "\xf0355")
    ("nf-md-mastodon" . "\xf0ad1")
    ("nf-md-material_design" . "\xf0986")
    ("nf-md-material_ui" . "\xf0357")
    ("nf-md-math_compass" . "\xf0358")
    ("nf-md-math_cos" . "\xf0c96")
    ("nf-md-math_integral" . "\xf0fc8")
    ("nf-md-math_integral_box" . "\xf0fc9")
    ("nf-md-math_log" . "\xf1085")
    ("nf-md-math_norm" . "\xf0fca")
    ("nf-md-math_norm_box" . "\xf0fcb")
    ("nf-md-math_sin" . "\xf0c97")
    ("nf-md-math_tan" . "\xf0c98")
    ("nf-md-matrix" . "\xf0628")
    ("nf-md-medal" . "\xf0987")
    ("nf-md-medal_outline" . "\xf1326")
    ("nf-md-medical_bag" . "\xf06ef")
    ("nf-md-medical_cotton_swab" . "\xf1ab8")
    ("nf-md-meditation" . "\xf117b")
    ("nf-md-memory" . "\xf035b")
    ("nf-md-menorah" . "\xf17d4")
    ("nf-md-menorah_fire" . "\xf17d5")
    ("nf-md-menu" . "\xf035c")
    ("nf-md-menu_down" . "\xf035d")
    ("nf-md-menu_down_outline" . "\xf06b6")
    ("nf-md-menu_left" . "\xf035e")
    ("nf-md-menu_left_outline" . "\xf0a02")
    ("nf-md-menu_open" . "\xf0bab")
    ("nf-md-menu_right" . "\xf035f")
    ("nf-md-menu_right_outline" . "\xf0a03")
    ("nf-md-menu_swap" . "\xf0a64")
    ("nf-md-menu_swap_outline" . "\xf0a65")
    ("nf-md-menu_up" . "\xf0360")
    ("nf-md-menu_up_outline" . "\xf06b7")
    ("nf-md-merge" . "\xf0f5c")
    ("nf-md-message" . "\xf0361")
    ("nf-md-message_alert" . "\xf0362")
    ("nf-md-message_alert_outline" . "\xf0a04")
    ("nf-md-message_arrow_left" . "\xf12f2")
    ("nf-md-message_arrow_left_outline" . "\xf12f3")
    ("nf-md-message_arrow_right" . "\xf12f4")
    ("nf-md-message_arrow_right_outline" . "\xf12f5")
    ("nf-md-message_badge" . "\xf1941")
    ("nf-md-message_badge_outline" . "\xf1942")
    ("nf-md-message_bookmark" . "\xf15ac")
    ("nf-md-message_bookmark_outline" . "\xf15ad")
    ("nf-md-message_bulleted" . "\xf06a2")
    ("nf-md-message_bulleted_off" . "\xf06a3")
    ("nf-md-message_cog" . "\xf06f1")
    ("nf-md-message_cog_outline" . "\xf1172")
    ("nf-md-message_draw" . "\xf0363")
    ("nf-md-message_fast" . "\xf19cc")
    ("nf-md-message_fast_outline" . "\xf19cd")
    ("nf-md-message_flash" . "\xf15a9")
    ("nf-md-message_flash_outline" . "\xf15aa")
    ("nf-md-message_image" . "\xf0364")
    ("nf-md-message_image_outline" . "\xf116c")
    ("nf-md-message_lock" . "\xf0fcc")
    ("nf-md-message_lock_outline" . "\xf116d")
    ("nf-md-message_minus" . "\xf116e")
    ("nf-md-message_minus_outline" . "\xf116f")
    ("nf-md-message_off" . "\xf164d")
    ("nf-md-message_off_outline" . "\xf164e")
    ("nf-md-message_outline" . "\xf0365")
    ("nf-md-message_plus" . "\xf0653")
    ("nf-md-message_plus_outline" . "\xf10bb")
    ("nf-md-message_processing" . "\xf0366")
    ("nf-md-message_processing_outline" . "\xf1170")
    ("nf-md-message_question" . "\xf173a")
    ("nf-md-message_question_outline" . "\xf173b")
    ("nf-md-message_reply" . "\xf0367")
    ("nf-md-message_reply_outline" . "\xf173d")
    ("nf-md-message_reply_text" . "\xf0368")
    ("nf-md-message_reply_text_outline" . "\xf173e")
    ("nf-md-message_settings" . "\xf06f0")
    ("nf-md-message_settings_outline" . "\xf1171")
    ("nf-md-message_star" . "\xf069a")
    ("nf-md-message_star_outline" . "\xf1250")
    ("nf-md-message_text" . "\xf0369")
    ("nf-md-message_text_clock" . "\xf1173")
    ("nf-md-message_text_clock_outline" . "\xf1174")
    ("nf-md-message_text_fast" . "\xf19ce")
    ("nf-md-message_text_fast_outline" . "\xf19cf")
    ("nf-md-message_text_lock" . "\xf0fcd")
    ("nf-md-message_text_lock_outline" . "\xf1175")
    ("nf-md-message_text_outline" . "\xf036a")
    ("nf-md-message_video" . "\xf036b")
    ("nf-md-meteor" . "\xf0629")
    ("nf-md-meter_electric" . "\xf1a57")
    ("nf-md-meter_electric_outline" . "\xf1a58")
    ("nf-md-meter_gas" . "\xf1a59")
    ("nf-md-meter_gas_outline" . "\xf1a5a")
    ("nf-md-metronome" . "\xf07da")
    ("nf-md-metronome_tick" . "\xf07db")
    ("nf-md-micro_sd" . "\xf07dc")
    ("nf-md-microphone" . "\xf036c")
    ("nf-md-microphone_minus" . "\xf08b3")
    ("nf-md-microphone_off" . "\xf036d")
    ("nf-md-microphone_outline" . "\xf036e")
    ("nf-md-microphone_plus" . "\xf08b4")
    ("nf-md-microphone_question" . "\xf1989")
    ("nf-md-microphone_question_outline" . "\xf198a")
    ("nf-md-microphone_settings" . "\xf036f")
    ("nf-md-microphone_variant" . "\xf0370")
    ("nf-md-microphone_variant_off" . "\xf0371")
    ("nf-md-microscope" . "\xf0654")
    ("nf-md-microsoft" . "\xf0372")
    ("nf-md-microsoft_access" . "\xf138e")
    ("nf-md-microsoft_azure" . "\xf0805")
    ("nf-md-microsoft_azure_devops" . "\xf0fd5")
    ("nf-md-microsoft_bing" . "\xf00a4")
    ("nf-md-microsoft_dynamics_365" . "\xf0988")
    ("nf-md-microsoft_edge" . "\xf01e9")
    ("nf-md-microsoft_excel" . "\xf138f")
    ("nf-md-microsoft_internet_explorer" . "\xf0300")
    ("nf-md-microsoft_office" . "\xf03c6")
    ("nf-md-microsoft_onedrive" . "\xf03ca")
    ("nf-md-microsoft_onenote" . "\xf0747")
    ("nf-md-microsoft_outlook" . "\xf0d22")
    ("nf-md-microsoft_powerpoint" . "\xf1390")
    ("nf-md-microsoft_sharepoint" . "\xf1391")
    ("nf-md-microsoft_teams" . "\xf02bb")
    ("nf-md-microsoft_visual_studio" . "\xf0610")
    ("nf-md-microsoft_visual_studio_code" . "\xf0a1e")
    ("nf-md-microsoft_windows" . "\xf05b3")
    ("nf-md-microsoft_windows_classic" . "\xf0a21")
    ("nf-md-microsoft_word" . "\xf1392")
    ("nf-md-microsoft_xbox" . "\xf05b9")
    ("nf-md-microsoft_xbox_controller" . "\xf05ba")
    ("nf-md-microsoft_xbox_controller_battery_alert" . "\xf074b")
    ("nf-md-microsoft_xbox_controller_battery_charging" . "\xf0a22")
    ("nf-md-microsoft_xbox_controller_battery_empty" . "\xf074c")
    ("nf-md-microsoft_xbox_controller_battery_full" . "\xf074d")
    ("nf-md-microsoft_xbox_controller_battery_low" . "\xf074e")
    ("nf-md-microsoft_xbox_controller_battery_medium" . "\xf074f")
    ("nf-md-microsoft_xbox_controller_battery_unknown" . "\xf0750")
    ("nf-md-microsoft_xbox_controller_menu" . "\xf0e6f")
    ("nf-md-microsoft_xbox_controller_off" . "\xf05bb")
    ("nf-md-microsoft_xbox_controller_view" . "\xf0e70")
    ("nf-md-microwave" . "\xf0c99")
    ("nf-md-microwave_off" . "\xf1423")
    ("nf-md-middleware" . "\xf0f5d")
    ("nf-md-middleware_outline" . "\xf0f5e")
    ("nf-md-midi" . "\xf08f1")
    ("nf-md-midi_port" . "\xf08f2")
    ("nf-md-mine" . "\xf0dda")
    ("nf-md-minecraft" . "\xf0373")
    ("nf-md-mini_sd" . "\xf0a05")
    ("nf-md-minidisc" . "\xf0a06")
    ("nf-md-minus" . "\xf0374")
    ("nf-md-minus_box" . "\xf0375")
    ("nf-md-minus_box_multiple" . "\xf1141")
    ("nf-md-minus_box_multiple_outline" . "\xf1142")
    ("nf-md-minus_box_outline" . "\xf06f2")
    ("nf-md-minus_circle" . "\xf0376")
    ("nf-md-minus_circle_multiple" . "\xf035a")
    ("nf-md-minus_circle_multiple_outline" . "\xf0ad3")
    ("nf-md-minus_circle_off" . "\xf1459")
    ("nf-md-minus_circle_off_outline" . "\xf145a")
    ("nf-md-minus_circle_outline" . "\xf0377")
    ("nf-md-minus_network" . "\xf0378")
    ("nf-md-minus_network_outline" . "\xf0c9a")
    ("nf-md-minus_thick" . "\xf1639")
    ("nf-md-mirror" . "\xf11fd")
    ("nf-md-mirror_rectangle" . "\xf179f")
    ("nf-md-mirror_variant" . "\xf17a0")
    ("nf-md-mixed_martial_arts" . "\xf0d8f")
    ("nf-md-mixed_reality" . "\xf087f")
    ("nf-md-molecule" . "\xf0bac")
    ("nf-md-molecule_co" . "\xf12fe")
    ("nf-md-molecule_co2" . "\xf07e4")
    ("nf-md-monitor" . "\xf0379")
    ("nf-md-monitor_account" . "\xf1a5b")
    ("nf-md-monitor_arrow_down" . "\xf19d0")
    ("nf-md-monitor_arrow_down_variant" . "\xf19d1")
    ("nf-md-monitor_cellphone" . "\xf0989")
    ("nf-md-monitor_cellphone_star" . "\xf098a")
    ("nf-md-monitor_dashboard" . "\xf0a07")
    ("nf-md-monitor_edit" . "\xf12c6")
    ("nf-md-monitor_eye" . "\xf13b4")
    ("nf-md-monitor_lock" . "\xf0ddb")
    ("nf-md-monitor_multiple" . "\xf037a")
    ("nf-md-monitor_off" . "\xf0d90")
    ("nf-md-monitor_screenshot" . "\xf0e51")
    ("nf-md-monitor_share" . "\xf1483")
    ("nf-md-monitor_shimmer" . "\xf1104")
    ("nf-md-monitor_small" . "\xf1876")
    ("nf-md-monitor_speaker" . "\xf0f5f")
    ("nf-md-monitor_speaker_off" . "\xf0f60")
    ("nf-md-monitor_star" . "\xf0ddc")
    ("nf-md-moon_first_quarter" . "\xf0f61")
    ("nf-md-moon_full" . "\xf0f62")
    ("nf-md-moon_last_quarter" . "\xf0f63")
    ("nf-md-moon_new" . "\xf0f64")
    ("nf-md-moon_waning_crescent" . "\xf0f65")
    ("nf-md-moon_waning_gibbous" . "\xf0f66")
    ("nf-md-moon_waxing_crescent" . "\xf0f67")
    ("nf-md-moon_waxing_gibbous" . "\xf0f68")
    ("nf-md-moped" . "\xf1086")
    ("nf-md-moped_electric" . "\xf15b7")
    ("nf-md-moped_electric_outline" . "\xf15b8")
    ("nf-md-moped_outline" . "\xf15b9")
    ("nf-md-more" . "\xf037b")
    ("nf-md-mortar_pestle" . "\xf1748")
    ("nf-md-mortar_pestle_plus" . "\xf03f1")
    ("nf-md-mosque" . "\xf1827")
    ("nf-md-mother_heart" . "\xf1314")
    ("nf-md-mother_nurse" . "\xf0d21")
    ("nf-md-motion" . "\xf15b2")
    ("nf-md-motion_outline" . "\xf15b3")
    ("nf-md-motion_pause" . "\xf1590")
    ("nf-md-motion_pause_outline" . "\xf1592")
    ("nf-md-motion_play" . "\xf158f")
    ("nf-md-motion_play_outline" . "\xf1591")
    ("nf-md-motion_sensor" . "\xf0d91")
    ("nf-md-motion_sensor_off" . "\xf1435")
    ("nf-md-motorbike" . "\xf037c")
    ("nf-md-motorbike_electric" . "\xf15ba")
    ("nf-md-mouse" . "\xf037d")
    ("nf-md-mouse_bluetooth" . "\xf098b")
    ("nf-md-mouse_move_down" . "\xf1550")
    ("nf-md-mouse_move_up" . "\xf1551")
    ("nf-md-mouse_move_vertical" . "\xf1552")
    ("nf-md-mouse_off" . "\xf037e")
    ("nf-md-mouse_variant" . "\xf037f")
    ("nf-md-mouse_variant_off" . "\xf0380")
    ("nf-md-move_resize" . "\xf0655")
    ("nf-md-move_resize_variant" . "\xf0656")
    ("nf-md-movie" . "\xf0381")
    ("nf-md-movie_check" . "\xf16f3")
    ("nf-md-movie_check_outline" . "\xf16f4")
    ("nf-md-movie_cog" . "\xf16f5")
    ("nf-md-movie_cog_outline" . "\xf16f6")
    ("nf-md-movie_edit" . "\xf1122")
    ("nf-md-movie_edit_outline" . "\xf1123")
    ("nf-md-movie_filter" . "\xf1124")
    ("nf-md-movie_filter_outline" . "\xf1125")
    ("nf-md-movie_minus" . "\xf16f7")
    ("nf-md-movie_minus_outline" . "\xf16f8")
    ("nf-md-movie_off" . "\xf16f9")
    ("nf-md-movie_off_outline" . "\xf16fa")
    ("nf-md-movie_open" . "\xf0fce")
    ("nf-md-movie_open_check" . "\xf16fb")
    ("nf-md-movie_open_check_outline" . "\xf16fc")
    ("nf-md-movie_open_cog" . "\xf16fd")
    ("nf-md-movie_open_cog_outline" . "\xf16fe")
    ("nf-md-movie_open_edit" . "\xf16ff")
    ("nf-md-movie_open_edit_outline" . "\xf1700")
    ("nf-md-movie_open_minus" . "\xf1701")
    ("nf-md-movie_open_minus_outline" . "\xf1702")
    ("nf-md-movie_open_off" . "\xf1703")
    ("nf-md-movie_open_off_outline" . "\xf1704")
    ("nf-md-movie_open_outline" . "\xf0fcf")
    ("nf-md-movie_open_play" . "\xf1705")
    ("nf-md-movie_open_play_outline" . "\xf1706")
    ("nf-md-movie_open_plus" . "\xf1707")
    ("nf-md-movie_open_plus_outline" . "\xf1708")
    ("nf-md-movie_open_remove" . "\xf1709")
    ("nf-md-movie_open_remove_outline" . "\xf170a")
    ("nf-md-movie_open_settings" . "\xf170b")
    ("nf-md-movie_open_settings_outline" . "\xf170c")
    ("nf-md-movie_open_star" . "\xf170d")
    ("nf-md-movie_open_star_outline" . "\xf170e")
    ("nf-md-movie_outline" . "\xf0ddd")
    ("nf-md-movie_play" . "\xf170f")
    ("nf-md-movie_play_outline" . "\xf1710")
    ("nf-md-movie_plus" . "\xf1711")
    ("nf-md-movie_plus_outline" . "\xf1712")
    ("nf-md-movie_remove" . "\xf1713")
    ("nf-md-movie_remove_outline" . "\xf1714")
    ("nf-md-movie_roll" . "\xf07de")
    ("nf-md-movie_search" . "\xf11d2")
    ("nf-md-movie_search_outline" . "\xf11d3")
    ("nf-md-movie_settings" . "\xf1715")
    ("nf-md-movie_settings_outline" . "\xf1716")
    ("nf-md-movie_star" . "\xf1717")
    ("nf-md-movie_star_outline" . "\xf1718")
    ("nf-md-mower" . "\xf166f")
    ("nf-md-mower_bag" . "\xf1670")
    ("nf-md-muffin" . "\xf098c")
    ("nf-md-multicast" . "\xf1893")
    ("nf-md-multiplication" . "\xf0382")
    ("nf-md-multiplication_box" . "\xf0383")
    ("nf-md-mushroom" . "\xf07df")
    ("nf-md-mushroom_off" . "\xf13fa")
    ("nf-md-mushroom_off_outline" . "\xf13fb")
    ("nf-md-mushroom_outline" . "\xf07e0")
    ("nf-md-music" . "\xf075a")
    ("nf-md-music_accidental_double_flat" . "\xf0f69")
    ("nf-md-music_accidental_double_sharp" . "\xf0f6a")
    ("nf-md-music_accidental_flat" . "\xf0f6b")
    ("nf-md-music_accidental_natural" . "\xf0f6c")
    ("nf-md-music_accidental_sharp" . "\xf0f6d")
    ("nf-md-music_box" . "\xf0384")
    ("nf-md-music_box_multiple" . "\xf0333")
    ("nf-md-music_box_multiple_outline" . "\xf0f04")
    ("nf-md-music_box_outline" . "\xf0385")
    ("nf-md-music_circle" . "\xf0386")
    ("nf-md-music_circle_outline" . "\xf0ad4")
    ("nf-md-music_clef_alto" . "\xf0f6e")
    ("nf-md-music_clef_bass" . "\xf0f6f")
    ("nf-md-music_clef_treble" . "\xf0f70")
    ("nf-md-music_note" . "\xf0388")
    ("nf-md-music_note_bluetooth" . "\xf05fe")
    ("nf-md-music_note_bluetooth_off" . "\xf05ff")
    ("nf-md-music_note_eighth_dotted" . "\xf0f71")
    ("nf-md-music_note_half" . "\xf0389")
    ("nf-md-music_note_half_dotted" . "\xf0f72")
    ("nf-md-music_note_off" . "\xf038a")
    ("nf-md-music_note_off_outline" . "\xf0f73")
    ("nf-md-music_note_outline" . "\xf0f74")
    ("nf-md-music_note_plus" . "\xf0dde")
    ("nf-md-music_note_quarter" . "\xf038b")
    ("nf-md-music_note_quarter_dotted" . "\xf0f75")
    ("nf-md-music_note_sixteenth" . "\xf038c")
    ("nf-md-music_note_sixteenth_dotted" . "\xf0f76")
    ("nf-md-music_note_whole" . "\xf038d")
    ("nf-md-music_note_whole_dotted" . "\xf0f77")
    ("nf-md-music_off" . "\xf075b")
    ("nf-md-music_rest_eighth" . "\xf0f78")
    ("nf-md-music_rest_half" . "\xf0f79")
    ("nf-md-music_rest_quarter" . "\xf0f7a")
    ("nf-md-music_rest_sixteenth" . "\xf0f7b")
    ("nf-md-music_rest_whole" . "\xf0f7c")
    ("nf-md-mustache" . "\xf15de")
    ("nf-md-nail" . "\xf0ddf")
    ("nf-md-nas" . "\xf08f3")
    ("nf-md-nativescript" . "\xf0880")
    ("nf-md-nature" . "\xf038e")
    ("nf-md-nature_people" . "\xf038f")
    ("nf-md-navigation" . "\xf0390")
    ("nf-md-navigation_outline" . "\xf1607")
    ("nf-md-navigation_variant_outline" . "\xf18f1")
    ("nf-md-near_me" . "\xf18f0")
    ("nf-md-necklace" . "\xf0f0b")
    ("nf-md-needle" . "\xf0391")
    ("nf-md-needle_off" . "\xf19d2")
    ("nf-md-netflix" . "\xf0746")
    ("nf-md-network" . "\xf06f3")
    ("nf-md-network_off" . "\xf0c9b")
    ("nf-md-network_off_outline" . "\xf0c9c")
    ("nf-md-network_outline" . "\xf0c9d")
    ("nf-md-network_pos" . "\xf1acb")
    ("nf-md-network_strength_1" . "\xf08f4")
    ("nf-md-network_strength_1_alert" . "\xf08f5")
    ("nf-md-network_strength_2" . "\xf08f6")
    ("nf-md-network_strength_2_alert" . "\xf08f7")
    ("nf-md-network_strength_3" . "\xf08f8")
    ("nf-md-network_strength_3_alert" . "\xf08f9")
    ("nf-md-network_strength_4" . "\xf08fa")
    ("nf-md-network_strength_4_alert" . "\xf08fb")
    ("nf-md-network_strength_4_cog" . "\xf191a")
    ("nf-md-network_strength_off" . "\xf08fc")
    ("nf-md-network_strength_off_outline" . "\xf08fd")
    ("nf-md-network_strength_outline" . "\xf08fe")
    ("nf-md-new_box" . "\xf0394")
    ("nf-md-newspaper" . "\xf0395")
    ("nf-md-newspaper_check" . "\xf1943")
    ("nf-md-newspaper_minus" . "\xf0f0c")
    ("nf-md-newspaper_plus" . "\xf0f0d")
    ("nf-md-newspaper_remove" . "\xf1944")
    ("nf-md-newspaper_variant" . "\xf1001")
    ("nf-md-newspaper_variant_multiple" . "\xf1002")
    ("nf-md-newspaper_variant_multiple_outline" . "\xf1003")
    ("nf-md-newspaper_variant_outline" . "\xf1004")
    ("nf-md-nfc" . "\xf0396")
    ("nf-md-nfc_search_variant" . "\xf0e53")
    ("nf-md-nfc_tap" . "\xf0397")
    ("nf-md-nfc_variant" . "\xf0398")
    ("nf-md-nfc_variant_off" . "\xf0e54")
    ("nf-md-ninja" . "\xf0774")
    ("nf-md-nintendo_game_boy" . "\xf1393")
    ("nf-md-nintendo_switch" . "\xf07e1")
    ("nf-md-nintendo_wii" . "\xf05ab")
    ("nf-md-nintendo_wiiu" . "\xf072d")
    ("nf-md-nix" . "\xf1105")
    ("nf-md-nodejs" . "\xf0399")
    ("nf-md-noodles" . "\xf117e")
    ("nf-md-not_equal" . "\xf098d")
    ("nf-md-not_equal_variant" . "\xf098e")
    ("nf-md-note" . "\xf039a")
    ("nf-md-note_alert" . "\xf177d")
    ("nf-md-note_alert_outline" . "\xf177e")
    ("nf-md-note_check" . "\xf177f")
    ("nf-md-note_check_outline" . "\xf1780")
    ("nf-md-note_edit" . "\xf1781")
    ("nf-md-note_edit_outline" . "\xf1782")
    ("nf-md-note_minus" . "\xf164f")
    ("nf-md-note_minus_outline" . "\xf1650")
    ("nf-md-note_multiple" . "\xf06b8")
    ("nf-md-note_multiple_outline" . "\xf06b9")
    ("nf-md-note_off" . "\xf1783")
    ("nf-md-note_off_outline" . "\xf1784")
    ("nf-md-note_outline" . "\xf039b")
    ("nf-md-note_plus" . "\xf039c")
    ("nf-md-note_plus_outline" . "\xf039d")
    ("nf-md-note_remove" . "\xf1651")
    ("nf-md-note_remove_outline" . "\xf1652")
    ("nf-md-note_search" . "\xf1653")
    ("nf-md-note_search_outline" . "\xf1654")
    ("nf-md-note_text" . "\xf039e")
    ("nf-md-note_text_outline" . "\xf11d7")
    ("nf-md-notebook" . "\xf082e")
    ("nf-md-notebook_check" . "\xf14f5")
    ("nf-md-notebook_check_outline" . "\xf14f6")
    ("nf-md-notebook_edit" . "\xf14e7")
    ("nf-md-notebook_edit_outline" . "\xf14e9")
    ("nf-md-notebook_heart" . "\xf1a0b")
    ("nf-md-notebook_heart_outline" . "\xf1a0c")
    ("nf-md-notebook_minus" . "\xf1610")
    ("nf-md-notebook_minus_outline" . "\xf1611")
    ("nf-md-notebook_multiple" . "\xf0e55")
    ("nf-md-notebook_outline" . "\xf0ebf")
    ("nf-md-notebook_plus" . "\xf1612")
    ("nf-md-notebook_plus_outline" . "\xf1613")
    ("nf-md-notebook_remove" . "\xf1614")
    ("nf-md-notebook_remove_outline" . "\xf1615")
    ("nf-md-notification_clear_all" . "\xf039f")
    ("nf-md-npm" . "\xf06f7")
    ("nf-md-nuke" . "\xf06a4")
    ("nf-md-null" . "\xf07e2")
    ("nf-md-numeric" . "\xf03a0")
    ("nf-md-numeric_0_box" . "\xf03a1")
    ("nf-md-numeric_0_box_multiple" . "\xf0f0e")
    ("nf-md-numeric_0_box_multiple_outline" . "\xf03a2")
    ("nf-md-numeric_0_box_outline" . "\xf03a3")
    ("nf-md-numeric_1" . "\xf0b3a")
    ("nf-md-numeric_10" . "\xf0fe9")
    ("nf-md-numeric_10_box" . "\xf0f7d")
    ("nf-md-numeric_10_box_multiple" . "\xf0fea")
    ("nf-md-numeric_10_box_multiple_outline" . "\xf0feb")
    ("nf-md-numeric_10_box_outline" . "\xf0f7e")
    ("nf-md-numeric_10_circle" . "\xf0fec")
    ("nf-md-numeric_10_circle_outline" . "\xf0fed")
    ("nf-md-numeric_1_box" . "\xf03a4")
    ("nf-md-numeric_1_box_multiple" . "\xf0f0f")
    ("nf-md-numeric_1_box_multiple_outline" . "\xf03a5")
    ("nf-md-numeric_1_box_outline" . "\xf03a6")
    ("nf-md-numeric_1_circle" . "\xf0ca0")
    ("nf-md-numeric_1_circle_outline" . "\xf0ca1")
    ("nf-md-numeric_2" . "\xf0b3b")
    ("nf-md-numeric_2_box" . "\xf03a7")
    ("nf-md-numeric_2_box_multiple" . "\xf0f10")
    ("nf-md-numeric_2_box_multiple_outline" . "\xf03a8")
    ("nf-md-numeric_2_box_outline" . "\xf03a9")
    ("nf-md-numeric_2_circle" . "\xf0ca2")
    ("nf-md-numeric_2_circle_outline" . "\xf0ca3")
    ("nf-md-numeric_3" . "\xf0b3c")
    ("nf-md-numeric_3_box" . "\xf03aa")
    ("nf-md-numeric_3_box_multiple" . "\xf0f11")
    ("nf-md-numeric_3_box_multiple_outline" . "\xf03ab")
    ("nf-md-numeric_3_box_outline" . "\xf03ac")
    ("nf-md-numeric_3_circle" . "\xf0ca4")
    ("nf-md-numeric_3_circle_outline" . "\xf0ca5")
    ("nf-md-numeric_4" . "\xf0b3d")
    ("nf-md-numeric_4_box" . "\xf03ad")
    ("nf-md-numeric_4_box_multiple" . "\xf0f12")
    ("nf-md-numeric_4_box_multiple_outline" . "\xf03b2")
    ("nf-md-numeric_4_box_outline" . "\xf03ae")
    ("nf-md-numeric_4_circle" . "\xf0ca6")
    ("nf-md-numeric_4_circle_outline" . "\xf0ca7")
    ("nf-md-numeric_5" . "\xf0b3e")
    ("nf-md-numeric_5_box" . "\xf03b1")
    ("nf-md-numeric_5_box_multiple" . "\xf0f13")
    ("nf-md-numeric_5_box_multiple_outline" . "\xf03af")
    ("nf-md-numeric_5_box_outline" . "\xf03b0")
    ("nf-md-numeric_5_circle" . "\xf0ca8")
    ("nf-md-numeric_5_circle_outline" . "\xf0ca9")
    ("nf-md-numeric_6" . "\xf0b3f")
    ("nf-md-numeric_6_box" . "\xf03b3")
    ("nf-md-numeric_6_box_multiple" . "\xf0f14")
    ("nf-md-numeric_6_box_multiple_outline" . "\xf03b4")
    ("nf-md-numeric_6_box_outline" . "\xf03b5")
    ("nf-md-numeric_6_circle" . "\xf0caa")
    ("nf-md-numeric_6_circle_outline" . "\xf0cab")
    ("nf-md-numeric_7" . "\xf0b40")
    ("nf-md-numeric_7_box" . "\xf03b6")
    ("nf-md-numeric_7_box_multiple" . "\xf0f15")
    ("nf-md-numeric_7_box_multiple_outline" . "\xf03b7")
    ("nf-md-numeric_7_box_outline" . "\xf03b8")
    ("nf-md-numeric_7_circle" . "\xf0cac")
    ("nf-md-numeric_7_circle_outline" . "\xf0cad")
    ("nf-md-numeric_8" . "\xf0b41")
    ("nf-md-numeric_8_box" . "\xf03b9")
    ("nf-md-numeric_8_box_multiple" . "\xf0f16")
    ("nf-md-numeric_8_box_multiple_outline" . "\xf03ba")
    ("nf-md-numeric_8_box_outline" . "\xf03bb")
    ("nf-md-numeric_8_circle" . "\xf0cae")
    ("nf-md-numeric_8_circle_outline" . "\xf0caf")
    ("nf-md-numeric_9" . "\xf0b42")
    ("nf-md-numeric_9_box" . "\xf03bc")
    ("nf-md-numeric_9_box_multiple" . "\xf0f17")
    ("nf-md-numeric_9_box_multiple_outline" . "\xf03bd")
    ("nf-md-numeric_9_box_outline" . "\xf03be")
    ("nf-md-numeric_9_circle" . "\xf0cb0")
    ("nf-md-numeric_9_circle_outline" . "\xf0cb1")
    ("nf-md-numeric_9_plus" . "\xf0fee")
    ("nf-md-numeric_9_plus_box" . "\xf03bf")
    ("nf-md-numeric_9_plus_box_multiple" . "\xf0f18")
    ("nf-md-numeric_9_plus_box_multiple_outline" . "\xf03c0")
    ("nf-md-numeric_9_plus_box_outline" . "\xf03c1")
    ("nf-md-numeric_9_plus_circle" . "\xf0cb2")
    ("nf-md-numeric_9_plus_circle_outline" . "\xf0cb3")
    ("nf-md-numeric_negative_1" . "\xf1052")
    ("nf-md-numeric_off" . "\xf19d3")
    ("nf-md-numeric_positive_1" . "\xf15cb")
    ("nf-md-nut" . "\xf06f8")
    ("nf-md-nutrition" . "\xf03c2")
    ("nf-md-nuxt" . "\xf1106")
    ("nf-md-oar" . "\xf067c")
    ("nf-md-ocarina" . "\xf0de0")
    ("nf-md-oci" . "\xf12e9")
    ("nf-md-ocr" . "\xf113a")
    ("nf-md-octagon" . "\xf03c3")
    ("nf-md-octagon_outline" . "\xf03c4")
    ("nf-md-octagram" . "\xf06f9")
    ("nf-md-octagram_outline" . "\xf0775")
    ("nf-md-octahedron" . "\xf1950")
    ("nf-md-octahedron_off" . "\xf1951")
    ("nf-md-odnoklassniki" . "\xf03c5")
    ("nf-md-offer" . "\xf121b")
    ("nf-md-office_building" . "\xf0991")
    ("nf-md-office_building_cog" . "\xf1949")
    ("nf-md-office_building_cog_outline" . "\xf194a")
    ("nf-md-office_building_marker" . "\xf1520")
    ("nf-md-office_building_marker_outline" . "\xf1521")
    ("nf-md-office_building_outline" . "\xf151f")
    ("nf-md-oil" . "\xf03c7")
    ("nf-md-oil_lamp" . "\xf0f19")
    ("nf-md-oil_level" . "\xf1053")
    ("nf-md-oil_temperature" . "\xf0ff8")
    ("nf-md-om" . "\xf0973")
    ("nf-md-omega" . "\xf03c9")
    ("nf-md-one_up" . "\xf0bad")
    ("nf-md-onepassword" . "\xf0881")
    ("nf-md-opacity" . "\xf05cc")
    ("nf-md-open_in_app" . "\xf03cb")
    ("nf-md-open_in_new" . "\xf03cc")
    ("nf-md-open_source_initiative" . "\xf0bae")
    ("nf-md-openid" . "\xf03cd")
    ("nf-md-opera" . "\xf03ce")
    ("nf-md-orbit" . "\xf0018")
    ("nf-md-orbit_variant" . "\xf15db")
    ("nf-md-order_alphabetical_ascending" . "\xf020d")
    ("nf-md-order_alphabetical_descending" . "\xf0d07")
    ("nf-md-order_bool_ascending" . "\xf02be")
    ("nf-md-order_bool_ascending_variant" . "\xf098f")
    ("nf-md-order_bool_descending" . "\xf1384")
    ("nf-md-order_bool_descending_variant" . "\xf0990")
    ("nf-md-order_numeric_ascending" . "\xf0545")
    ("nf-md-order_numeric_descending" . "\xf0546")
    ("nf-md-origin" . "\xf0b43")
    ("nf-md-ornament" . "\xf03cf")
    ("nf-md-ornament_variant" . "\xf03d0")
    ("nf-md-outdoor_lamp" . "\xf1054")
    ("nf-md-overscan" . "\xf1005")
    ("nf-md-owl" . "\xf03d2")
    ("nf-md-pac_man" . "\xf0baf")
    ("nf-md-package" . "\xf03d3")
    ("nf-md-package_down" . "\xf03d4")
    ("nf-md-package_up" . "\xf03d5")
    ("nf-md-package_variant" . "\xf03d6")
    ("nf-md-package_variant_closed" . "\xf03d7")
    ("nf-md-package_variant_closed_minus" . "\xf19d4")
    ("nf-md-package_variant_closed_plus" . "\xf19d5")
    ("nf-md-package_variant_closed_remove" . "\xf19d6")
    ("nf-md-package_variant_minus" . "\xf19d7")
    ("nf-md-package_variant_plus" . "\xf19d8")
    ("nf-md-package_variant_remove" . "\xf19d9")
    ("nf-md-page_first" . "\xf0600")
    ("nf-md-page_last" . "\xf0601")
    ("nf-md-page_layout_body" . "\xf06fa")
    ("nf-md-page_layout_footer" . "\xf06fb")
    ("nf-md-page_layout_header" . "\xf06fc")
    ("nf-md-page_layout_header_footer" . "\xf0f7f")
    ("nf-md-page_layout_sidebar_left" . "\xf06fd")
    ("nf-md-page_layout_sidebar_right" . "\xf06fe")
    ("nf-md-page_next" . "\xf0bb0")
    ("nf-md-page_next_outline" . "\xf0bb1")
    ("nf-md-page_previous" . "\xf0bb2")
    ("nf-md-page_previous_outline" . "\xf0bb3")
    ("nf-md-pail" . "\xf1417")
    ("nf-md-pail_minus" . "\xf1437")
    ("nf-md-pail_minus_outline" . "\xf143c")
    ("nf-md-pail_off" . "\xf1439")
    ("nf-md-pail_off_outline" . "\xf143e")
    ("nf-md-pail_outline" . "\xf143a")
    ("nf-md-pail_plus" . "\xf1436")
    ("nf-md-pail_plus_outline" . "\xf143b")
    ("nf-md-pail_remove" . "\xf1438")
    ("nf-md-pail_remove_outline" . "\xf143d")
    ("nf-md-palette" . "\xf03d8")
    ("nf-md-palette_advanced" . "\xf03d9")
    ("nf-md-palette_outline" . "\xf0e0c")
    ("nf-md-palette_swatch" . "\xf08b5")
    ("nf-md-palette_swatch_outline" . "\xf135c")
    ("nf-md-palette_swatch_variant" . "\xf195a")
    ("nf-md-palm_tree" . "\xf1055")
    ("nf-md-pan" . "\xf0bb4")
    ("nf-md-pan_bottom_left" . "\xf0bb5")
    ("nf-md-pan_bottom_right" . "\xf0bb6")
    ("nf-md-pan_down" . "\xf0bb7")
    ("nf-md-pan_horizontal" . "\xf0bb8")
    ("nf-md-pan_left" . "\xf0bb9")
    ("nf-md-pan_right" . "\xf0bba")
    ("nf-md-pan_top_left" . "\xf0bbb")
    ("nf-md-pan_top_right" . "\xf0bbc")
    ("nf-md-pan_up" . "\xf0bbd")
    ("nf-md-pan_vertical" . "\xf0bbe")
    ("nf-md-panda" . "\xf03da")
    ("nf-md-pandora" . "\xf03db")
    ("nf-md-panorama" . "\xf03dc")
    ("nf-md-panorama_fisheye" . "\xf03dd")
    ("nf-md-panorama_horizontal" . "\xf1928")
    ("nf-md-panorama_horizontal_outline" . "\xf03de")
    ("nf-md-panorama_outline" . "\xf198c")
    ("nf-md-panorama_sphere" . "\xf198d")
    ("nf-md-panorama_sphere_outline" . "\xf198e")
    ("nf-md-panorama_variant" . "\xf198f")
    ("nf-md-panorama_variant_outline" . "\xf1990")
    ("nf-md-panorama_vertical" . "\xf1929")
    ("nf-md-panorama_vertical_outline" . "\xf03df")
    ("nf-md-panorama_wide_angle" . "\xf195f")
    ("nf-md-panorama_wide_angle_outline" . "\xf03e0")
    ("nf-md-paper_cut_vertical" . "\xf03e1")
    ("nf-md-paper_roll" . "\xf1157")
    ("nf-md-paper_roll_outline" . "\xf1158")
    ("nf-md-paperclip" . "\xf03e2")
    ("nf-md-paperclip_check" . "\xf1ac6")
    ("nf-md-paperclip_lock" . "\xf19da")
    ("nf-md-paperclip_minus" . "\xf1ac7")
    ("nf-md-paperclip_off" . "\xf1ac8")
    ("nf-md-paperclip_plus" . "\xf1ac9")
    ("nf-md-paperclip_remove" . "\xf1aca")
    ("nf-md-parachute" . "\xf0cb4")
    ("nf-md-parachute_outline" . "\xf0cb5")
    ("nf-md-paragliding" . "\xf1745")
    ("nf-md-parking" . "\xf03e3")
    ("nf-md-party_popper" . "\xf1056")
    ("nf-md-passport" . "\xf07e3")
    ("nf-md-passport_biometric" . "\xf0de1")
    ("nf-md-pasta" . "\xf1160")
    ("nf-md-patio_heater" . "\xf0f80")
    ("nf-md-patreon" . "\xf0882")
    ("nf-md-pause" . "\xf03e4")
    ("nf-md-pause_circle" . "\xf03e5")
    ("nf-md-pause_circle_outline" . "\xf03e6")
    ("nf-md-pause_octagon" . "\xf03e7")
    ("nf-md-pause_octagon_outline" . "\xf03e8")
    ("nf-md-paw" . "\xf03e9")
    ("nf-md-paw_off" . "\xf0657")
    ("nf-md-paw_off_outline" . "\xf1676")
    ("nf-md-paw_outline" . "\xf1675")
    ("nf-md-peace" . "\xf0884")
    ("nf-md-peanut" . "\xf0ffc")
    ("nf-md-peanut_off" . "\xf0ffd")
    ("nf-md-peanut_off_outline" . "\xf0fff")
    ("nf-md-peanut_outline" . "\xf0ffe")
    ("nf-md-pen" . "\xf03ea")
    ("nf-md-pen_lock" . "\xf0de2")
    ("nf-md-pen_minus" . "\xf0de3")
    ("nf-md-pen_off" . "\xf0de4")
    ("nf-md-pen_plus" . "\xf0de5")
    ("nf-md-pen_remove" . "\xf0de6")
    ("nf-md-pencil" . "\xf03eb")
    ("nf-md-pencil_box" . "\xf03ec")
    ("nf-md-pencil_box_multiple" . "\xf1144")
    ("nf-md-pencil_box_multiple_outline" . "\xf1145")
    ("nf-md-pencil_box_outline" . "\xf03ed")
    ("nf-md-pencil_circle" . "\xf06ff")
    ("nf-md-pencil_circle_outline" . "\xf0776")
    ("nf-md-pencil_lock" . "\xf03ee")
    ("nf-md-pencil_lock_outline" . "\xf0de7")
    ("nf-md-pencil_minus" . "\xf0de8")
    ("nf-md-pencil_minus_outline" . "\xf0de9")
    ("nf-md-pencil_off" . "\xf03ef")
    ("nf-md-pencil_off_outline" . "\xf0dea")
    ("nf-md-pencil_outline" . "\xf0cb6")
    ("nf-md-pencil_plus" . "\xf0deb")
    ("nf-md-pencil_plus_outline" . "\xf0dec")
    ("nf-md-pencil_remove" . "\xf0ded")
    ("nf-md-pencil_remove_outline" . "\xf0dee")
    ("nf-md-pencil_ruler" . "\xf1353")
    ("nf-md-penguin" . "\xf0ec0")
    ("nf-md-pentagon" . "\xf0701")
    ("nf-md-pentagon_outline" . "\xf0700")
    ("nf-md-pentagram" . "\xf1667")
    ("nf-md-percent" . "\xf03f0")
    ("nf-md-percent_box" . "\xf1a02")
    ("nf-md-percent_box_outline" . "\xf1a03")
    ("nf-md-percent_circle" . "\xf1a04")
    ("nf-md-percent_circle_outline" . "\xf1a05")
    ("nf-md-percent_outline" . "\xf1278")
    ("nf-md-periodic_table" . "\xf08b6")
    ("nf-md-perspective_less" . "\xf0d23")
    ("nf-md-perspective_more" . "\xf0d24")
    ("nf-md-ph" . "\xf17c5")
    ("nf-md-phone" . "\xf03f2")
    ("nf-md-phone_alert" . "\xf0f1a")
    ("nf-md-phone_alert_outline" . "\xf118e")
    ("nf-md-phone_bluetooth" . "\xf03f3")
    ("nf-md-phone_bluetooth_outline" . "\xf118f")
    ("nf-md-phone_cancel" . "\xf10bc")
    ("nf-md-phone_cancel_outline" . "\xf1190")
    ("nf-md-phone_check" . "\xf11a9")
    ("nf-md-phone_check_outline" . "\xf11aa")
    ("nf-md-phone_classic" . "\xf0602")
    ("nf-md-phone_classic_off" . "\xf1279")
    ("nf-md-phone_clock" . "\xf19db")
    ("nf-md-phone_dial" . "\xf1559")
    ("nf-md-phone_dial_outline" . "\xf155a")
    ("nf-md-phone_forward" . "\xf03f4")
    ("nf-md-phone_forward_outline" . "\xf1191")
    ("nf-md-phone_hangup" . "\xf03f5")
    ("nf-md-phone_hangup_outline" . "\xf1192")
    ("nf-md-phone_in_talk" . "\xf03f6")
    ("nf-md-phone_in_talk_outline" . "\xf1182")
    ("nf-md-phone_incoming" . "\xf03f7")
    ("nf-md-phone_incoming_outline" . "\xf1193")
    ("nf-md-phone_lock" . "\xf03f8")
    ("nf-md-phone_lock_outline" . "\xf1194")
    ("nf-md-phone_log" . "\xf03f9")
    ("nf-md-phone_log_outline" . "\xf1195")
    ("nf-md-phone_message" . "\xf1196")
    ("nf-md-phone_message_outline" . "\xf1197")
    ("nf-md-phone_minus" . "\xf0658")
    ("nf-md-phone_minus_outline" . "\xf1198")
    ("nf-md-phone_missed" . "\xf03fa")
    ("nf-md-phone_missed_outline" . "\xf11a5")
    ("nf-md-phone_off" . "\xf0def")
    ("nf-md-phone_off_outline" . "\xf11a6")
    ("nf-md-phone_outgoing" . "\xf03fb")
    ("nf-md-phone_outgoing_outline" . "\xf1199")
    ("nf-md-phone_outline" . "\xf0df0")
    ("nf-md-phone_paused" . "\xf03fc")
    ("nf-md-phone_paused_outline" . "\xf119a")
    ("nf-md-phone_plus" . "\xf0659")
    ("nf-md-phone_plus_outline" . "\xf119b")
    ("nf-md-phone_refresh" . "\xf1993")
    ("nf-md-phone_refresh_outline" . "\xf1994")
    ("nf-md-phone_remove" . "\xf152f")
    ("nf-md-phone_remove_outline" . "\xf1530")
    ("nf-md-phone_return" . "\xf082f")
    ("nf-md-phone_return_outline" . "\xf119c")
    ("nf-md-phone_ring" . "\xf11ab")
    ("nf-md-phone_ring_outline" . "\xf11ac")
    ("nf-md-phone_rotate_landscape" . "\xf0885")
    ("nf-md-phone_rotate_portrait" . "\xf0886")
    ("nf-md-phone_settings" . "\xf03fd")
    ("nf-md-phone_settings_outline" . "\xf119d")
    ("nf-md-phone_sync" . "\xf1995")
    ("nf-md-phone_sync_outline" . "\xf1996")
    ("nf-md-phone_voip" . "\xf03fe")
    ("nf-md-pi" . "\xf03ff")
    ("nf-md-pi_box" . "\xf0400")
    ("nf-md-pi_hole" . "\xf0df1")
    ("nf-md-piano" . "\xf067d")
    ("nf-md-piano_off" . "\xf0698")
    ("nf-md-pickaxe" . "\xf08b7")
    ("nf-md-picture_in_picture_bottom_right" . "\xf0e57")
    ("nf-md-picture_in_picture_bottom_right_outline" . "\xf0e58")
    ("nf-md-picture_in_picture_top_right" . "\xf0e59")
    ("nf-md-picture_in_picture_top_right_outline" . "\xf0e5a")
    ("nf-md-pier" . "\xf0887")
    ("nf-md-pier_crane" . "\xf0888")
    ("nf-md-pig" . "\xf0401")
    ("nf-md-pig_variant" . "\xf1006")
    ("nf-md-pig_variant_outline" . "\xf1678")
    ("nf-md-piggy_bank" . "\xf1007")
    ("nf-md-piggy_bank_outline" . "\xf1679")
    ("nf-md-pill" . "\xf0402")
    ("nf-md-pill_off" . "\xf1a5c")
    ("nf-md-pillar" . "\xf0702")
    ("nf-md-pin" . "\xf0403")
    ("nf-md-pin_off" . "\xf0404")
    ("nf-md-pin_off_outline" . "\xf0930")
    ("nf-md-pin_outline" . "\xf0931")
    ("nf-md-pine_tree" . "\xf0405")
    ("nf-md-pine_tree_box" . "\xf0406")
    ("nf-md-pine_tree_fire" . "\xf141a")
    ("nf-md-pinterest" . "\xf0407")
    ("nf-md-pinwheel" . "\xf0ad5")
    ("nf-md-pinwheel_outline" . "\xf0ad6")
    ("nf-md-pipe" . "\xf07e5")
    ("nf-md-pipe_disconnected" . "\xf07e6")
    ("nf-md-pipe_leak" . "\xf0889")
    ("nf-md-pipe_valve" . "\xf184d")
    ("nf-md-pipe_wrench" . "\xf1354")
    ("nf-md-pirate" . "\xf0a08")
    ("nf-md-pistol" . "\xf0703")
    ("nf-md-piston" . "\xf088a")
    ("nf-md-pitchfork" . "\xf1553")
    ("nf-md-pizza" . "\xf0409")
    ("nf-md-play" . "\xf040a")
    ("nf-md-play_box" . "\xf127a")
    ("nf-md-play_box_lock" . "\xf1a16")
    ("nf-md-play_box_lock_open" . "\xf1a17")
    ("nf-md-play_box_lock_open_outline" . "\xf1a18")
    ("nf-md-play_box_lock_outline" . "\xf1a19")
    ("nf-md-play_box_multiple" . "\xf0d19")
    ("nf-md-play_box_multiple_outline" . "\xf13e6")
    ("nf-md-play_box_outline" . "\xf040b")
    ("nf-md-play_circle" . "\xf040c")
    ("nf-md-play_circle_outline" . "\xf040d")
    ("nf-md-play_network" . "\xf088b")
    ("nf-md-play_network_outline" . "\xf0cb7")
    ("nf-md-play_outline" . "\xf0f1b")
    ("nf-md-play_pause" . "\xf040e")
    ("nf-md-play_protected_content" . "\xf040f")
    ("nf-md-play_speed" . "\xf08ff")
    ("nf-md-playlist_check" . "\xf05c7")
    ("nf-md-playlist_edit" . "\xf0900")
    ("nf-md-playlist_minus" . "\xf0410")
    ("nf-md-playlist_music" . "\xf0cb8")
    ("nf-md-playlist_music_outline" . "\xf0cb9")
    ("nf-md-playlist_play" . "\xf0411")
    ("nf-md-playlist_plus" . "\xf0412")
    ("nf-md-playlist_remove" . "\xf0413")
    ("nf-md-playlist_star" . "\xf0df2")
    ("nf-md-plex" . "\xf06ba")
    ("nf-md-pliers" . "\xf19a4")
    ("nf-md-plus" . "\xf0415")
    ("nf-md-plus_box" . "\xf0416")
    ("nf-md-plus_box_multiple" . "\xf0334")
    ("nf-md-plus_box_multiple_outline" . "\xf1143")
    ("nf-md-plus_box_outline" . "\xf0704")
    ("nf-md-plus_circle" . "\xf0417")
    ("nf-md-plus_circle_multiple" . "\xf034c")
    ("nf-md-plus_circle_multiple_outline" . "\xf0418")
    ("nf-md-plus_circle_outline" . "\xf0419")
    ("nf-md-plus_lock" . "\xf1a5d")
    ("nf-md-plus_lock_open" . "\xf1a5e")
    ("nf-md-plus_minus" . "\xf0992")
    ("nf-md-plus_minus_box" . "\xf0993")
    ("nf-md-plus_minus_variant" . "\xf14c9")
    ("nf-md-plus_network" . "\xf041a")
    ("nf-md-plus_network_outline" . "\xf0cba")
    ("nf-md-plus_outline" . "\xf0705")
    ("nf-md-plus_thick" . "\xf11ec")
    ("nf-md-podcast" . "\xf0994")
    ("nf-md-podium" . "\xf0d25")
    ("nf-md-podium_bronze" . "\xf0d26")
    ("nf-md-podium_gold" . "\xf0d27")
    ("nf-md-podium_silver" . "\xf0d28")
    ("nf-md-point_of_sale" . "\xf0d92")
    ("nf-md-pokeball" . "\xf041d")
    ("nf-md-pokemon_go" . "\xf0a09")
    ("nf-md-poker_chip" . "\xf0830")
    ("nf-md-polaroid" . "\xf041e")
    ("nf-md-police_badge" . "\xf1167")
    ("nf-md-police_badge_outline" . "\xf1168")
    ("nf-md-police_station" . "\xf1839")
    ("nf-md-poll" . "\xf041f")
    ("nf-md-polo" . "\xf14c3")
    ("nf-md-polymer" . "\xf0421")
    ("nf-md-pool" . "\xf0606")
    ("nf-md-pool_thermometer" . "\xf1a5f")
    ("nf-md-popcorn" . "\xf0422")
    ("nf-md-post" . "\xf1008")
    ("nf-md-post_lamp" . "\xf1a60")
    ("nf-md-post_outline" . "\xf1009")
    ("nf-md-postage_stamp" . "\xf0cbb")
    ("nf-md-pot" . "\xf02e5")
    ("nf-md-pot_mix" . "\xf065b")
    ("nf-md-pot_mix_outline" . "\xf0677")
    ("nf-md-pot_outline" . "\xf02ff")
    ("nf-md-pot_steam" . "\xf065a")
    ("nf-md-pot_steam_outline" . "\xf0326")
    ("nf-md-pound" . "\xf0423")
    ("nf-md-pound_box" . "\xf0424")
    ("nf-md-pound_box_outline" . "\xf117f")
    ("nf-md-power" . "\xf0425")
    ("nf-md-power_cycle" . "\xf0901")
    ("nf-md-power_off" . "\xf0902")
    ("nf-md-power_on" . "\xf0903")
    ("nf-md-power_plug" . "\xf06a5")
    ("nf-md-power_plug_off" . "\xf06a6")
    ("nf-md-power_plug_off_outline" . "\xf1424")
    ("nf-md-power_plug_outline" . "\xf1425")
    ("nf-md-power_settings" . "\xf0426")
    ("nf-md-power_sleep" . "\xf0904")
    ("nf-md-power_socket" . "\xf0427")
    ("nf-md-power_socket_au" . "\xf0905")
    ("nf-md-power_socket_ch" . "\xf0fb3")
    ("nf-md-power_socket_de" . "\xf1107")
    ("nf-md-power_socket_eu" . "\xf07e7")
    ("nf-md-power_socket_fr" . "\xf1108")
    ("nf-md-power_socket_it" . "\xf14ff")
    ("nf-md-power_socket_jp" . "\xf1109")
    ("nf-md-power_socket_uk" . "\xf07e8")
    ("nf-md-power_socket_us" . "\xf07e9")
    ("nf-md-power_standby" . "\xf0906")
    ("nf-md-powershell" . "\xf0a0a")
    ("nf-md-prescription" . "\xf0706")
    ("nf-md-presentation" . "\xf0428")
    ("nf-md-presentation_play" . "\xf0429")
    ("nf-md-pretzel" . "\xf1562")
    ("nf-md-printer" . "\xf042a")
    ("nf-md-printer_3d" . "\xf042b")
    ("nf-md-printer_3d_nozzle" . "\xf0e5b")
    ("nf-md-printer_3d_nozzle_alert" . "\xf11c0")
    ("nf-md-printer_3d_nozzle_alert_outline" . "\xf11c1")
    ("nf-md-printer_3d_nozzle_heat" . "\xf18b8")
    ("nf-md-printer_3d_nozzle_heat_outline" . "\xf18b9")
    ("nf-md-printer_3d_nozzle_outline" . "\xf0e5c")
    ("nf-md-printer_alert" . "\xf042c")
    ("nf-md-printer_check" . "\xf1146")
    ("nf-md-printer_eye" . "\xf1458")
    ("nf-md-printer_off" . "\xf0e5d")
    ("nf-md-printer_off_outline" . "\xf1785")
    ("nf-md-printer_outline" . "\xf1786")
    ("nf-md-printer_pos" . "\xf1057")
    ("nf-md-printer_search" . "\xf1457")
    ("nf-md-printer_settings" . "\xf0707")
    ("nf-md-printer_wireless" . "\xf0a0b")
    ("nf-md-priority_high" . "\xf0603")
    ("nf-md-priority_low" . "\xf0604")
    ("nf-md-professional_hexagon" . "\xf042d")
    ("nf-md-progress_alert" . "\xf0cbc")
    ("nf-md-progress_check" . "\xf0995")
    ("nf-md-progress_clock" . "\xf0996")
    ("nf-md-progress_close" . "\xf110a")
    ("nf-md-progress_download" . "\xf0997")
    ("nf-md-progress_pencil" . "\xf1787")
    ("nf-md-progress_question" . "\xf1522")
    ("nf-md-progress_star" . "\xf1788")
    ("nf-md-progress_upload" . "\xf0998")
    ("nf-md-progress_wrench" . "\xf0cbd")
    ("nf-md-projector" . "\xf042e")
    ("nf-md-projector_off" . "\xf1a23")
    ("nf-md-projector_screen" . "\xf042f")
    ("nf-md-projector_screen_off" . "\xf180d")
    ("nf-md-projector_screen_off_outline" . "\xf180e")
    ("nf-md-projector_screen_outline" . "\xf1724")
    ("nf-md-projector_screen_variant" . "\xf180f")
    ("nf-md-projector_screen_variant_off" . "\xf1810")
    ("nf-md-projector_screen_variant_off_outline" . "\xf1811")
    ("nf-md-projector_screen_variant_outline" . "\xf1812")
    ("nf-md-propane_tank" . "\xf1357")
    ("nf-md-propane_tank_outline" . "\xf1358")
    ("nf-md-protocol" . "\xf0fd8")
    ("nf-md-publish" . "\xf06a7")
    ("nf-md-publish_off" . "\xf1945")
    ("nf-md-pulse" . "\xf0430")
    ("nf-md-pump" . "\xf1402")
    ("nf-md-pumpkin" . "\xf0bbf")
    ("nf-md-purse" . "\xf0f1c")
    ("nf-md-purse_outline" . "\xf0f1d")
    ("nf-md-puzzle" . "\xf0431")
    ("nf-md-puzzle_check" . "\xf1426")
    ("nf-md-puzzle_check_outline" . "\xf1427")
    ("nf-md-puzzle_edit" . "\xf14d3")
    ("nf-md-puzzle_edit_outline" . "\xf14d9")
    ("nf-md-puzzle_heart" . "\xf14d4")
    ("nf-md-puzzle_heart_outline" . "\xf14da")
    ("nf-md-puzzle_minus" . "\xf14d1")
    ("nf-md-puzzle_minus_outline" . "\xf14d7")
    ("nf-md-puzzle_outline" . "\xf0a66")
    ("nf-md-puzzle_plus" . "\xf14d0")
    ("nf-md-puzzle_plus_outline" . "\xf14d6")
    ("nf-md-puzzle_remove" . "\xf14d2")
    ("nf-md-puzzle_remove_outline" . "\xf14d8")
    ("nf-md-puzzle_star" . "\xf14d5")
    ("nf-md-puzzle_star_outline" . "\xf14db")
    ("nf-md-pyramid" . "\xf1952")
    ("nf-md-pyramid_off" . "\xf1953")
    ("nf-md-qi" . "\xf0999")
    ("nf-md-qqchat" . "\xf0605")
    ("nf-md-qrcode" . "\xf0432")
    ("nf-md-qrcode_edit" . "\xf08b8")
    ("nf-md-qrcode_minus" . "\xf118c")
    ("nf-md-qrcode_plus" . "\xf118b")
    ("nf-md-qrcode_remove" . "\xf118d")
    ("nf-md-qrcode_scan" . "\xf0433")
    ("nf-md-quadcopter" . "\xf0434")
    ("nf-md-quality_high" . "\xf0435")
    ("nf-md-quality_low" . "\xf0a0c")
    ("nf-md-quality_medium" . "\xf0a0d")
    ("nf-md-quora" . "\xf0d29")
    ("nf-md-rabbit" . "\xf0907")
    ("nf-md-rabbit_variant" . "\xf1a61")
    ("nf-md-rabbit_variant_outline" . "\xf1a62")
    ("nf-md-racing_helmet" . "\xf0d93")
    ("nf-md-racquetball" . "\xf0d94")
    ("nf-md-radar" . "\xf0437")
    ("nf-md-radiator" . "\xf0438")
    ("nf-md-radiator_disabled" . "\xf0ad7")
    ("nf-md-radiator_off" . "\xf0ad8")
    ("nf-md-radio" . "\xf0439")
    ("nf-md-radio_am" . "\xf0cbe")
    ("nf-md-radio_fm" . "\xf0cbf")
    ("nf-md-radio_handheld" . "\xf043a")
    ("nf-md-radio_off" . "\xf121c")
    ("nf-md-radio_tower" . "\xf043b")
    ("nf-md-radioactive" . "\xf043c")
    ("nf-md-radioactive_circle" . "\xf185d")
    ("nf-md-radioactive_circle_outline" . "\xf185e")
    ("nf-md-radioactive_off" . "\xf0ec1")
    ("nf-md-radiobox_marked" . "\xf043e")
    ("nf-md-radiology_box" . "\xf14c5")
    ("nf-md-radiology_box_outline" . "\xf14c6")
    ("nf-md-radius" . "\xf0cc0")
    ("nf-md-radius_outline" . "\xf0cc1")
    ("nf-md-railroad_light" . "\xf0f1e")
    ("nf-md-rake" . "\xf1544")
    ("nf-md-raspberry_pi" . "\xf043f")
    ("nf-md-raw" . "\xf1a0f")
    ("nf-md-raw_off" . "\xf1a10")
    ("nf-md-ray_end" . "\xf0440")
    ("nf-md-ray_end_arrow" . "\xf0441")
    ("nf-md-ray_start" . "\xf0442")
    ("nf-md-ray_start_arrow" . "\xf0443")
    ("nf-md-ray_start_end" . "\xf0444")
    ("nf-md-ray_start_vertex_end" . "\xf15d8")
    ("nf-md-ray_vertex" . "\xf0445")
    ("nf-md-razor_double_edge" . "\xf1997")
    ("nf-md-razor_single_edge" . "\xf1998")
    ("nf-md-react" . "\xf0708")
    ("nf-md-read" . "\xf0447")
    ("nf-md-receipt" . "\xf0449")
    ("nf-md-receipt_outline" . "\xf19dc")
    ("nf-md-receipt_text_check" . "\xf1a63")
    ("nf-md-receipt_text_check_outline" . "\xf1a64")
    ("nf-md-receipt_text_minus" . "\xf1a65")
    ("nf-md-receipt_text_minus_outline" . "\xf1a66")
    ("nf-md-receipt_text_plus" . "\xf1a67")
    ("nf-md-receipt_text_plus_outline" . "\xf1a68")
    ("nf-md-receipt_text_remove" . "\xf1a69")
    ("nf-md-receipt_text_remove_outline" . "\xf1a6a")
    ("nf-md-record" . "\xf044a")
    ("nf-md-record_circle" . "\xf0ec2")
    ("nf-md-record_circle_outline" . "\xf0ec3")
    ("nf-md-record_player" . "\xf099a")
    ("nf-md-record_rec" . "\xf044b")
    ("nf-md-rectangle" . "\xf0e5e")
    ("nf-md-rectangle_outline" . "\xf0e5f")
    ("nf-md-recycle" . "\xf044c")
    ("nf-md-recycle_variant" . "\xf139d")
    ("nf-md-reddit" . "\xf044d")
    ("nf-md-redhat" . "\xf111b")
    ("nf-md-redo" . "\xf044e")
    ("nf-md-redo_variant" . "\xf044f")
    ("nf-md-reflect_horizontal" . "\xf0a0e")
    ("nf-md-reflect_vertical" . "\xf0a0f")
    ("nf-md-refresh" . "\xf0450")
    ("nf-md-refresh_auto" . "\xf18f2")
    ("nf-md-refresh_circle" . "\xf1377")
    ("nf-md-regex" . "\xf0451")
    ("nf-md-registered_trademark" . "\xf0a67")
    ("nf-md-reiterate" . "\xf1588")
    ("nf-md-relation_many_to_many" . "\xf1496")
    ("nf-md-relation_many_to_one" . "\xf1497")
    ("nf-md-relation_many_to_one_or_many" . "\xf1498")
    ("nf-md-relation_many_to_only_one" . "\xf1499")
    ("nf-md-relation_many_to_zero_or_many" . "\xf149a")
    ("nf-md-relation_many_to_zero_or_one" . "\xf149b")
    ("nf-md-relation_one_or_many_to_many" . "\xf149c")
    ("nf-md-relation_one_or_many_to_one" . "\xf149d")
    ("nf-md-relation_one_or_many_to_one_or_many" . "\xf149e")
    ("nf-md-relation_one_or_many_to_only_one" . "\xf149f")
    ("nf-md-relation_one_or_many_to_zero_or_many" . "\xf14a0")
    ("nf-md-relation_one_or_many_to_zero_or_one" . "\xf14a1")
    ("nf-md-relation_one_to_many" . "\xf14a2")
    ("nf-md-relation_one_to_one" . "\xf14a3")
    ("nf-md-relation_one_to_one_or_many" . "\xf14a4")
    ("nf-md-relation_one_to_only_one" . "\xf14a5")
    ("nf-md-relation_one_to_zero_or_many" . "\xf14a6")
    ("nf-md-relation_one_to_zero_or_one" . "\xf14a7")
    ("nf-md-relation_only_one_to_many" . "\xf14a8")
    ("nf-md-relation_only_one_to_one" . "\xf14a9")
    ("nf-md-relation_only_one_to_one_or_many" . "\xf14aa")
    ("nf-md-relation_only_one_to_only_one" . "\xf14ab")
    ("nf-md-relation_only_one_to_zero_or_many" . "\xf14ac")
    ("nf-md-relation_only_one_to_zero_or_one" . "\xf14ad")
    ("nf-md-relation_zero_or_many_to_many" . "\xf14ae")
    ("nf-md-relation_zero_or_many_to_one" . "\xf14af")
    ("nf-md-relation_zero_or_many_to_one_or_many" . "\xf14b0")
    ("nf-md-relation_zero_or_many_to_only_one" . "\xf14b1")
    ("nf-md-relation_zero_or_many_to_zero_or_many" . "\xf14b2")
    ("nf-md-relation_zero_or_many_to_zero_or_one" . "\xf14b3")
    ("nf-md-relation_zero_or_one_to_many" . "\xf14b4")
    ("nf-md-relation_zero_or_one_to_one" . "\xf14b5")
    ("nf-md-relation_zero_or_one_to_one_or_many" . "\xf14b6")
    ("nf-md-relation_zero_or_one_to_only_one" . "\xf14b7")
    ("nf-md-relation_zero_or_one_to_zero_or_many" . "\xf14b8")
    ("nf-md-relation_zero_or_one_to_zero_or_one" . "\xf14b9")
    ("nf-md-relative_scale" . "\xf0452")
    ("nf-md-reload" . "\xf0453")
    ("nf-md-reload_alert" . "\xf110b")
    ("nf-md-reminder" . "\xf088c")
    ("nf-md-remote" . "\xf0454")
    ("nf-md-remote_desktop" . "\xf08b9")
    ("nf-md-remote_off" . "\xf0ec4")
    ("nf-md-remote_tv" . "\xf0ec5")
    ("nf-md-remote_tv_off" . "\xf0ec6")
    ("nf-md-rename_box" . "\xf0455")
    ("nf-md-reorder_horizontal" . "\xf0688")
    ("nf-md-reorder_vertical" . "\xf0689")
    ("nf-md-repeat" . "\xf0456")
    ("nf-md-repeat_off" . "\xf0457")
    ("nf-md-repeat_once" . "\xf0458")
    ("nf-md-repeat_variant" . "\xf0547")
    ("nf-md-replay" . "\xf0459")
    ("nf-md-reply" . "\xf045a")
    ("nf-md-reply_all" . "\xf045b")
    ("nf-md-reply_all_outline" . "\xf0f1f")
    ("nf-md-reply_circle" . "\xf11ae")
    ("nf-md-reply_outline" . "\xf0f20")
    ("nf-md-reproduction" . "\xf045c")
    ("nf-md-resistor" . "\xf0b44")
    ("nf-md-resistor_nodes" . "\xf0b45")
    ("nf-md-resize" . "\xf0a68")
    ("nf-md-resize_bottom_right" . "\xf045d")
    ("nf-md-responsive" . "\xf045e")
    ("nf-md-restart" . "\xf0709")
    ("nf-md-restart_alert" . "\xf110c")
    ("nf-md-restart_off" . "\xf0d95")
    ("nf-md-restore" . "\xf099b")
    ("nf-md-restore_alert" . "\xf110d")
    ("nf-md-rewind" . "\xf045f")
    ("nf-md-rewind_10" . "\xf0d2a")
    ("nf-md-rewind_15" . "\xf1946")
    ("nf-md-rewind_30" . "\xf0d96")
    ("nf-md-rewind_5" . "\xf11f9")
    ("nf-md-rewind_60" . "\xf160c")
    ("nf-md-rewind_outline" . "\xf070a")
    ("nf-md-rhombus" . "\xf070b")
    ("nf-md-rhombus_medium" . "\xf0a10")
    ("nf-md-rhombus_medium_outline" . "\xf14dc")
    ("nf-md-rhombus_outline" . "\xf070c")
    ("nf-md-rhombus_split" . "\xf0a11")
    ("nf-md-rhombus_split_outline" . "\xf14dd")
    ("nf-md-ribbon" . "\xf0460")
    ("nf-md-rice" . "\xf07ea")
    ("nf-md-rickshaw" . "\xf15bb")
    ("nf-md-rickshaw_electric" . "\xf15bc")
    ("nf-md-ring" . "\xf07eb")
    ("nf-md-rivet" . "\xf0e60")
    ("nf-md-road" . "\xf0461")
    ("nf-md-road_variant" . "\xf0462")
    ("nf-md-robber" . "\xf1058")
    ("nf-md-robot" . "\xf06a9")
    ("nf-md-robot_angry" . "\xf169d")
    ("nf-md-robot_angry_outline" . "\xf169e")
    ("nf-md-robot_confused" . "\xf169f")
    ("nf-md-robot_confused_outline" . "\xf16a0")
    ("nf-md-robot_dead" . "\xf16a1")
    ("nf-md-robot_dead_outline" . "\xf16a2")
    ("nf-md-robot_excited" . "\xf16a3")
    ("nf-md-robot_excited_outline" . "\xf16a4")
    ("nf-md-robot_happy" . "\xf1719")
    ("nf-md-robot_happy_outline" . "\xf171a")
    ("nf-md-robot_industrial" . "\xf0b46")
    ("nf-md-robot_industrial_outline" . "\xf1a1a")
    ("nf-md-robot_love" . "\xf16a5")
    ("nf-md-robot_love_outline" . "\xf16a6")
    ("nf-md-robot_mower" . "\xf11f7")
    ("nf-md-robot_mower_outline" . "\xf11f3")
    ("nf-md-robot_off" . "\xf16a7")
    ("nf-md-robot_off_outline" . "\xf167b")
    ("nf-md-robot_outline" . "\xf167a")
    ("nf-md-robot_vacuum" . "\xf070d")
    ("nf-md-robot_vacuum_variant" . "\xf0908")
    ("nf-md-rocket" . "\xf0463")
    ("nf-md-rocket_launch" . "\xf14de")
    ("nf-md-rocket_launch_outline" . "\xf14df")
    ("nf-md-rocket_outline" . "\xf13af")
    ("nf-md-rodent" . "\xf1327")
    ("nf-md-roller_shade" . "\xf1a6b")
    ("nf-md-roller_shade_closed" . "\xf1a6c")
    ("nf-md-roller_skate" . "\xf0d2b")
    ("nf-md-roller_skate_off" . "\xf0145")
    ("nf-md-rollerblade" . "\xf0d2c")
    ("nf-md-rollerblade_off" . "\xf002e")
    ("nf-md-rollupjs" . "\xf0bc0")
    ("nf-md-rolodex" . "\xf1ab9")
    ("nf-md-rolodex_outline" . "\xf1aba")
    ("nf-md-roman_numeral_2" . "\xf1089")
    ("nf-md-roman_numeral_3" . "\xf108a")
    ("nf-md-roman_numeral_4" . "\xf108b")
    ("nf-md-roman_numeral_6" . "\xf108d")
    ("nf-md-roman_numeral_7" . "\xf108e")
    ("nf-md-roman_numeral_8" . "\xf108f")
    ("nf-md-roman_numeral_9" . "\xf1090")
    ("nf-md-room_service" . "\xf088d")
    ("nf-md-room_service_outline" . "\xf0d97")
    ("nf-md-rotate_360" . "\xf1999")
    ("nf-md-rotate_3d" . "\xf0ec7")
    ("nf-md-rotate_3d_variant" . "\xf0464")
    ("nf-md-rotate_left" . "\xf0465")
    ("nf-md-rotate_left_variant" . "\xf0466")
    ("nf-md-rotate_orbit" . "\xf0d98")
    ("nf-md-rotate_right" . "\xf0467")
    ("nf-md-rotate_right_variant" . "\xf0468")
    ("nf-md-rounded_corner" . "\xf0607")
    ("nf-md-router" . "\xf11e2")
    ("nf-md-router_network" . "\xf1087")
    ("nf-md-router_wireless" . "\xf0469")
    ("nf-md-router_wireless_off" . "\xf15a3")
    ("nf-md-router_wireless_settings" . "\xf0a69")
    ("nf-md-routes" . "\xf046a")
    ("nf-md-routes_clock" . "\xf1059")
    ("nf-md-rowing" . "\xf0608")
    ("nf-md-rss" . "\xf046b")
    ("nf-md-rss_box" . "\xf046c")
    ("nf-md-rss_off" . "\xf0f21")
    ("nf-md-rug" . "\xf1475")
    ("nf-md-rugby" . "\xf0d99")
    ("nf-md-ruler" . "\xf046d")
    ("nf-md-ruler_square" . "\xf0cc2")
    ("nf-md-ruler_square_compass" . "\xf0ebe")
    ("nf-md-run" . "\xf070e")
    ("nf-md-run_fast" . "\xf046e")
    ("nf-md-rv_truck" . "\xf11d4")
    ("nf-md-sack" . "\xf0d2e")
    ("nf-md-sack_percent" . "\xf0d2f")
    ("nf-md-safe" . "\xf0a6a")
    ("nf-md-safe_square" . "\xf127c")
    ("nf-md-safe_square_outline" . "\xf127d")
    ("nf-md-safety_goggles" . "\xf0d30")
    ("nf-md-sail_boat" . "\xf0ec8")
    ("nf-md-sail_boat_sink" . "\xf1aef")
    ("nf-md-sale" . "\xf046f")
    ("nf-md-sale_outline" . "\xf1a06")
    ("nf-md-salesforce" . "\xf088e")
    ("nf-md-sass" . "\xf07ec")
    ("nf-md-satellite" . "\xf0470")
    ("nf-md-satellite_uplink" . "\xf0909")
    ("nf-md-satellite_variant" . "\xf0471")
    ("nf-md-sausage" . "\xf08ba")
    ("nf-md-sausage_off" . "\xf1789")
    ("nf-md-saw_blade" . "\xf0e61")
    ("nf-md-sawtooth_wave" . "\xf147a")
    ("nf-md-saxophone" . "\xf0609")
    ("nf-md-scale" . "\xf0472")
    ("nf-md-scale_balance" . "\xf05d1")
    ("nf-md-scale_bathroom" . "\xf0473")
    ("nf-md-scale_off" . "\xf105a")
    ("nf-md-scale_unbalanced" . "\xf19b8")
    ("nf-md-scan_helper" . "\xf13d8")
    ("nf-md-scanner" . "\xf06ab")
    ("nf-md-scanner_off" . "\xf090a")
    ("nf-md-scatter_plot" . "\xf0ec9")
    ("nf-md-scatter_plot_outline" . "\xf0eca")
    ("nf-md-scent" . "\xf1958")
    ("nf-md-scent_off" . "\xf1959")
    ("nf-md-school" . "\xf0474")
    ("nf-md-school_outline" . "\xf1180")
    ("nf-md-scissors_cutting" . "\xf0a6b")
    ("nf-md-scooter" . "\xf15bd")
    ("nf-md-scooter_electric" . "\xf15be")
    ("nf-md-scoreboard" . "\xf127e")
    ("nf-md-scoreboard_outline" . "\xf127f")
    ("nf-md-screen_rotation" . "\xf0475")
    ("nf-md-screen_rotation_lock" . "\xf0478")
    ("nf-md-screw_flat_top" . "\xf0df3")
    ("nf-md-screw_lag" . "\xf0df4")
    ("nf-md-screw_machine_flat_top" . "\xf0df5")
    ("nf-md-screw_machine_round_top" . "\xf0df6")
    ("nf-md-screw_round_top" . "\xf0df7")
    ("nf-md-screwdriver" . "\xf0476")
    ("nf-md-script" . "\xf0bc1")
    ("nf-md-script_outline" . "\xf0477")
    ("nf-md-script_text" . "\xf0bc2")
    ("nf-md-script_text_key" . "\xf1725")
    ("nf-md-script_text_key_outline" . "\xf1726")
    ("nf-md-script_text_outline" . "\xf0bc3")
    ("nf-md-script_text_play" . "\xf1727")
    ("nf-md-script_text_play_outline" . "\xf1728")
    ("nf-md-sd" . "\xf0479")
    ("nf-md-seal" . "\xf047a")
    ("nf-md-seal_variant" . "\xf0fd9")
    ("nf-md-search_web" . "\xf070f")
    ("nf-md-seat" . "\xf0cc3")
    ("nf-md-seat_flat" . "\xf047b")
    ("nf-md-seat_flat_angled" . "\xf047c")
    ("nf-md-seat_individual_suite" . "\xf047d")
    ("nf-md-seat_legroom_extra" . "\xf047e")
    ("nf-md-seat_legroom_normal" . "\xf047f")
    ("nf-md-seat_legroom_reduced" . "\xf0480")
    ("nf-md-seat_outline" . "\xf0cc4")
    ("nf-md-seat_passenger" . "\xf1249")
    ("nf-md-seat_recline_extra" . "\xf0481")
    ("nf-md-seat_recline_normal" . "\xf0482")
    ("nf-md-seatbelt" . "\xf0cc5")
    ("nf-md-security" . "\xf0483")
    ("nf-md-security_network" . "\xf0484")
    ("nf-md-seed" . "\xf0e62")
    ("nf-md-seed_off" . "\xf13fd")
    ("nf-md-seed_off_outline" . "\xf13fe")
    ("nf-md-seed_outline" . "\xf0e63")
    ("nf-md-seed_plus" . "\xf1a6d")
    ("nf-md-seed_plus_outline" . "\xf1a6e")
    ("nf-md-seesaw" . "\xf15a4")
    ("nf-md-segment" . "\xf0ecb")
    ("nf-md-select" . "\xf0485")
    ("nf-md-select_all" . "\xf0486")
    ("nf-md-select_color" . "\xf0d31")
    ("nf-md-select_compare" . "\xf0ad9")
    ("nf-md-select_drag" . "\xf0a6c")
    ("nf-md-select_group" . "\xf0f82")
    ("nf-md-select_inverse" . "\xf0487")
    ("nf-md-select_marker" . "\xf1280")
    ("nf-md-select_multiple" . "\xf1281")
    ("nf-md-select_multiple_marker" . "\xf1282")
    ("nf-md-select_off" . "\xf0488")
    ("nf-md-select_place" . "\xf0fda")
    ("nf-md-select_remove" . "\xf17c1")
    ("nf-md-select_search" . "\xf1204")
    ("nf-md-selection" . "\xf0489")
    ("nf-md-selection_drag" . "\xf0a6d")
    ("nf-md-selection_ellipse" . "\xf0d32")
    ("nf-md-selection_ellipse_arrow_inside" . "\xf0f22")
    ("nf-md-selection_ellipse_remove" . "\xf17c2")
    ("nf-md-selection_marker" . "\xf1283")
    ("nf-md-selection_multiple" . "\xf1285")
    ("nf-md-selection_multiple_marker" . "\xf1284")
    ("nf-md-selection_off" . "\xf0777")
    ("nf-md-selection_remove" . "\xf17c3")
    ("nf-md-selection_search" . "\xf1205")
    ("nf-md-semantic_web" . "\xf1316")
    ("nf-md-send" . "\xf048a")
    ("nf-md-send_check" . "\xf1161")
    ("nf-md-send_check_outline" . "\xf1162")
    ("nf-md-send_circle" . "\xf0df8")
    ("nf-md-send_circle_outline" . "\xf0df9")
    ("nf-md-send_clock" . "\xf1163")
    ("nf-md-send_clock_outline" . "\xf1164")
    ("nf-md-send_lock" . "\xf07ed")
    ("nf-md-send_lock_outline" . "\xf1166")
    ("nf-md-send_outline" . "\xf1165")
    ("nf-md-serial_port" . "\xf065c")
    ("nf-md-server" . "\xf048b")
    ("nf-md-server_minus" . "\xf048c")
    ("nf-md-server_network" . "\xf048d")
    ("nf-md-server_network_off" . "\xf048e")
    ("nf-md-server_off" . "\xf048f")
    ("nf-md-server_plus" . "\xf0490")
    ("nf-md-server_remove" . "\xf0491")
    ("nf-md-server_security" . "\xf0492")
    ("nf-md-set_all" . "\xf0778")
    ("nf-md-set_center" . "\xf0779")
    ("nf-md-set_center_right" . "\xf077a")
    ("nf-md-set_left" . "\xf077b")
    ("nf-md-set_left_center" . "\xf077c")
    ("nf-md-set_left_right" . "\xf077d")
    ("nf-md-set_merge" . "\xf14e0")
    ("nf-md-set_none" . "\xf077e")
    ("nf-md-set_right" . "\xf077f")
    ("nf-md-set_split" . "\xf14e1")
    ("nf-md-set_square" . "\xf145d")
    ("nf-md-set_top_box" . "\xf099f")
    ("nf-md-settings_helper" . "\xf0a6e")
    ("nf-md-shaker" . "\xf110e")
    ("nf-md-shaker_outline" . "\xf110f")
    ("nf-md-shape" . "\xf0831")
    ("nf-md-shape_circle_plus" . "\xf065d")
    ("nf-md-shape_outline" . "\xf0832")
    ("nf-md-shape_oval_plus" . "\xf11fa")
    ("nf-md-shape_plus" . "\xf0495")
    ("nf-md-shape_polygon_plus" . "\xf065e")
    ("nf-md-shape_rectangle_plus" . "\xf065f")
    ("nf-md-shape_square_plus" . "\xf0660")
    ("nf-md-shape_square_rounded_plus" . "\xf14fa")
    ("nf-md-share" . "\xf0496")
    ("nf-md-share_all" . "\xf11f4")
    ("nf-md-share_all_outline" . "\xf11f5")
    ("nf-md-share_circle" . "\xf11ad")
    ("nf-md-share_off" . "\xf0f23")
    ("nf-md-share_off_outline" . "\xf0f24")
    ("nf-md-share_outline" . "\xf0932")
    ("nf-md-share_variant" . "\xf0497")
    ("nf-md-share_variant_outline" . "\xf1514")
    ("nf-md-shark" . "\xf18ba")
    ("nf-md-shark_fin" . "\xf1673")
    ("nf-md-shark_fin_outline" . "\xf1674")
    ("nf-md-shark_off" . "\xf18bb")
    ("nf-md-sheep" . "\xf0cc6")
    ("nf-md-shield" . "\xf0498")
    ("nf-md-shield_account" . "\xf088f")
    ("nf-md-shield_account_outline" . "\xf0a12")
    ("nf-md-shield_account_variant" . "\xf15a7")
    ("nf-md-shield_account_variant_outline" . "\xf15a8")
    ("nf-md-shield_airplane" . "\xf06bb")
    ("nf-md-shield_airplane_outline" . "\xf0cc7")
    ("nf-md-shield_alert" . "\xf0ecc")
    ("nf-md-shield_alert_outline" . "\xf0ecd")
    ("nf-md-shield_bug" . "\xf13da")
    ("nf-md-shield_bug_outline" . "\xf13db")
    ("nf-md-shield_car" . "\xf0f83")
    ("nf-md-shield_check" . "\xf0565")
    ("nf-md-shield_check_outline" . "\xf0cc8")
    ("nf-md-shield_cross" . "\xf0cc9")
    ("nf-md-shield_cross_outline" . "\xf0cca")
    ("nf-md-shield_crown" . "\xf18bc")
    ("nf-md-shield_crown_outline" . "\xf18bd")
    ("nf-md-shield_edit" . "\xf11a0")
    ("nf-md-shield_edit_outline" . "\xf11a1")
    ("nf-md-shield_half" . "\xf1360")
    ("nf-md-shield_half_full" . "\xf0780")
    ("nf-md-shield_home" . "\xf068a")
    ("nf-md-shield_home_outline" . "\xf0ccb")
    ("nf-md-shield_key" . "\xf0bc4")
    ("nf-md-shield_key_outline" . "\xf0bc5")
    ("nf-md-shield_link_variant" . "\xf0d33")
    ("nf-md-shield_link_variant_outline" . "\xf0d34")
    ("nf-md-shield_lock" . "\xf099d")
    ("nf-md-shield_lock_open" . "\xf199a")
    ("nf-md-shield_lock_open_outline" . "\xf199b")
    ("nf-md-shield_lock_outline" . "\xf0ccc")
    ("nf-md-shield_moon" . "\xf1828")
    ("nf-md-shield_moon_outline" . "\xf1829")
    ("nf-md-shield_off" . "\xf099e")
    ("nf-md-shield_off_outline" . "\xf099c")
    ("nf-md-shield_outline" . "\xf0499")
    ("nf-md-shield_plus" . "\xf0ada")
    ("nf-md-shield_plus_outline" . "\xf0adb")
    ("nf-md-shield_refresh" . "\xf00aa")
    ("nf-md-shield_refresh_outline" . "\xf01e0")
    ("nf-md-shield_remove" . "\xf0adc")
    ("nf-md-shield_remove_outline" . "\xf0add")
    ("nf-md-shield_search" . "\xf0d9a")
    ("nf-md-shield_star" . "\xf113b")
    ("nf-md-shield_star_outline" . "\xf113c")
    ("nf-md-shield_sun" . "\xf105d")
    ("nf-md-shield_sun_outline" . "\xf105e")
    ("nf-md-shield_sword" . "\xf18be")
    ("nf-md-shield_sword_outline" . "\xf18bf")
    ("nf-md-shield_sync" . "\xf11a2")
    ("nf-md-shield_sync_outline" . "\xf11a3")
    ("nf-md-shimmer" . "\xf1545")
    ("nf-md-ship_wheel" . "\xf0833")
    ("nf-md-shipping_pallet" . "\xf184e")
    ("nf-md-shoe_ballet" . "\xf15ca")
    ("nf-md-shoe_cleat" . "\xf15c7")
    ("nf-md-shoe_formal" . "\xf0b47")
    ("nf-md-shoe_heel" . "\xf0b48")
    ("nf-md-shoe_print" . "\xf0dfa")
    ("nf-md-shoe_sneaker" . "\xf15c8")
    ("nf-md-shopping" . "\xf049a")
    ("nf-md-shopping_music" . "\xf049b")
    ("nf-md-shopping_outline" . "\xf11d5")
    ("nf-md-shopping_search" . "\xf0f84")
    ("nf-md-shopping_search_outline" . "\xf1a6f")
    ("nf-md-shore" . "\xf14f9")
    ("nf-md-shovel" . "\xf0710")
    ("nf-md-shovel_off" . "\xf0711")
    ("nf-md-shower" . "\xf09a0")
    ("nf-md-shower_head" . "\xf09a1")
    ("nf-md-shredder" . "\xf049c")
    ("nf-md-shuffle" . "\xf049d")
    ("nf-md-shuffle_disabled" . "\xf049e")
    ("nf-md-shuffle_variant" . "\xf049f")
    ("nf-md-shuriken" . "\xf137f")
    ("nf-md-sickle" . "\xf18c0")
    ("nf-md-sigma" . "\xf04a0")
    ("nf-md-sigma_lower" . "\xf062b")
    ("nf-md-sign_caution" . "\xf04a1")
    ("nf-md-sign_direction" . "\xf0781")
    ("nf-md-sign_direction_minus" . "\xf1000")
    ("nf-md-sign_direction_plus" . "\xf0fdc")
    ("nf-md-sign_direction_remove" . "\xf0fdd")
    ("nf-md-sign_pole" . "\xf14f8")
    ("nf-md-sign_real_estate" . "\xf1118")
    ("nf-md-sign_text" . "\xf0782")
    ("nf-md-signal" . "\xf04a2")
    ("nf-md-signal_2g" . "\xf0712")
    ("nf-md-signal_3g" . "\xf0713")
    ("nf-md-signal_4g" . "\xf0714")
    ("nf-md-signal_5g" . "\xf0a6f")
    ("nf-md-signal_cellular_1" . "\xf08bc")
    ("nf-md-signal_cellular_2" . "\xf08bd")
    ("nf-md-signal_cellular_3" . "\xf08be")
    ("nf-md-signal_cellular_outline" . "\xf08bf")
    ("nf-md-signal_distance_variant" . "\xf0e64")
    ("nf-md-signal_hspa" . "\xf0715")
    ("nf-md-signal_hspa_plus" . "\xf0716")
    ("nf-md-signal_off" . "\xf0783")
    ("nf-md-signal_variant" . "\xf060a")
    ("nf-md-signature" . "\xf0dfb")
    ("nf-md-signature_freehand" . "\xf0dfc")
    ("nf-md-signature_image" . "\xf0dfd")
    ("nf-md-signature_text" . "\xf0dfe")
    ("nf-md-silo" . "\xf0b49")
    ("nf-md-silverware" . "\xf04a3")
    ("nf-md-silverware_clean" . "\xf0fde")
    ("nf-md-silverware_fork" . "\xf04a4")
    ("nf-md-silverware_fork_knife" . "\xf0a70")
    ("nf-md-silverware_spoon" . "\xf04a5")
    ("nf-md-silverware_variant" . "\xf04a6")
    ("nf-md-sim" . "\xf04a7")
    ("nf-md-sim_alert" . "\xf04a8")
    ("nf-md-sim_alert_outline" . "\xf15d3")
    ("nf-md-sim_off" . "\xf04a9")
    ("nf-md-sim_off_outline" . "\xf15d4")
    ("nf-md-sim_outline" . "\xf15d5")
    ("nf-md-simple_icons" . "\xf131d")
    ("nf-md-sina_weibo" . "\xf0adf")
    ("nf-md-sine_wave" . "\xf095b")
    ("nf-md-sitemap" . "\xf04aa")
    ("nf-md-sitemap_outline" . "\xf199c")
    ("nf-md-size_m" . "\xf13a5")
    ("nf-md-size_s" . "\xf13a4")
    ("nf-md-size_xl" . "\xf13a7")
    ("nf-md-size_xs" . "\xf13a3")
    ("nf-md-size_xxl" . "\xf13a8")
    ("nf-md-size_xxs" . "\xf13a2")
    ("nf-md-size_xxxl" . "\xf13a9")
    ("nf-md-skate" . "\xf0d35")
    ("nf-md-skate_off" . "\xf0699")
    ("nf-md-skateboard" . "\xf14c2")
    ("nf-md-skateboarding" . "\xf0501")
    ("nf-md-skew_less" . "\xf0d36")
    ("nf-md-skew_more" . "\xf0d37")
    ("nf-md-ski" . "\xf1304")
    ("nf-md-ski_cross_country" . "\xf1305")
    ("nf-md-ski_water" . "\xf1306")
    ("nf-md-skip_backward" . "\xf04ab")
    ("nf-md-skip_backward_outline" . "\xf0f25")
    ("nf-md-skip_forward" . "\xf04ac")
    ("nf-md-skip_forward_outline" . "\xf0f26")
    ("nf-md-skip_next" . "\xf04ad")
    ("nf-md-skip_next_circle" . "\xf0661")
    ("nf-md-skip_next_circle_outline" . "\xf0662")
    ("nf-md-skip_next_outline" . "\xf0f27")
    ("nf-md-skip_previous" . "\xf04ae")
    ("nf-md-skip_previous_circle" . "\xf0663")
    ("nf-md-skip_previous_circle_outline" . "\xf0664")
    ("nf-md-skip_previous_outline" . "\xf0f28")
    ("nf-md-skull" . "\xf068c")
    ("nf-md-skull_crossbones" . "\xf0bc6")
    ("nf-md-skull_crossbones_outline" . "\xf0bc7")
    ("nf-md-skull_outline" . "\xf0bc8")
    ("nf-md-skull_scan" . "\xf14c7")
    ("nf-md-skull_scan_outline" . "\xf14c8")
    ("nf-md-skype" . "\xf04af")
    ("nf-md-skype_business" . "\xf04b0")
    ("nf-md-slack" . "\xf04b1")
    ("nf-md-slash_forward" . "\xf0fdf")
    ("nf-md-slash_forward_box" . "\xf0fe0")
    ("nf-md-sledding" . "\xf041b")
    ("nf-md-sleep" . "\xf04b2")
    ("nf-md-sleep_off" . "\xf04b3")
    ("nf-md-slide" . "\xf15a5")
    ("nf-md-slope_downhill" . "\xf0dff")
    ("nf-md-slope_uphill" . "\xf0e00")
    ("nf-md-slot_machine" . "\xf1114")
    ("nf-md-slot_machine_outline" . "\xf1115")
    ("nf-md-smart_card" . "\xf10bd")
    ("nf-md-smart_card_off" . "\xf18f7")
    ("nf-md-smart_card_off_outline" . "\xf18f8")
    ("nf-md-smart_card_outline" . "\xf10be")
    ("nf-md-smart_card_reader" . "\xf10bf")
    ("nf-md-smart_card_reader_outline" . "\xf10c0")
    ("nf-md-smog" . "\xf0a71")
    ("nf-md-smoke" . "\xf1799")
    ("nf-md-smoke_detector" . "\xf0392")
    ("nf-md-smoke_detector_alert" . "\xf192e")
    ("nf-md-smoke_detector_alert_outline" . "\xf192f")
    ("nf-md-smoke_detector_off" . "\xf1809")
    ("nf-md-smoke_detector_off_outline" . "\xf180a")
    ("nf-md-smoke_detector_outline" . "\xf1808")
    ("nf-md-smoke_detector_variant" . "\xf180b")
    ("nf-md-smoke_detector_variant_alert" . "\xf1930")
    ("nf-md-smoke_detector_variant_off" . "\xf180c")
    ("nf-md-smoking" . "\xf04b4")
    ("nf-md-smoking_off" . "\xf04b5")
    ("nf-md-smoking_pipe" . "\xf140d")
    ("nf-md-smoking_pipe_off" . "\xf1428")
    ("nf-md-snail" . "\xf1677")
    ("nf-md-snake" . "\xf150e")
    ("nf-md-snapchat" . "\xf04b6")
    ("nf-md-snowboard" . "\xf1307")
    ("nf-md-snowflake" . "\xf0717")
    ("nf-md-snowflake_alert" . "\xf0f29")
    ("nf-md-snowflake_check" . "\xf1a70")
    ("nf-md-snowflake_melt" . "\xf12cb")
    ("nf-md-snowflake_off" . "\xf14e3")
    ("nf-md-snowflake_thermometer" . "\xf1a71")
    ("nf-md-snowflake_variant" . "\xf0f2a")
    ("nf-md-snowman" . "\xf04b7")
    ("nf-md-snowmobile" . "\xf06dd")
    ("nf-md-snowshoeing" . "\xf1a72")
    ("nf-md-soccer" . "\xf04b8")
    ("nf-md-soccer_field" . "\xf0834")
    ("nf-md-social_distance_2_meters" . "\xf1579")
    ("nf-md-social_distance_6_feet" . "\xf157a")
    ("nf-md-sofa" . "\xf04b9")
    ("nf-md-sofa_outline" . "\xf156d")
    ("nf-md-sofa_single" . "\xf156e")
    ("nf-md-sofa_single_outline" . "\xf156f")
    ("nf-md-solar_panel" . "\xf0d9b")
    ("nf-md-solar_panel_large" . "\xf0d9c")
    ("nf-md-solar_power" . "\xf0a72")
    ("nf-md-solar_power_variant" . "\xf1a73")
    ("nf-md-solar_power_variant_outline" . "\xf1a74")
    ("nf-md-soldering_iron" . "\xf1092")
    ("nf-md-solid" . "\xf068d")
    ("nf-md-sony_playstation" . "\xf0414")
    ("nf-md-sort" . "\xf04ba")
    ("nf-md-sort_alphabetical_ascending" . "\xf05bd")
    ("nf-md-sort_alphabetical_ascending_variant" . "\xf1148")
    ("nf-md-sort_alphabetical_descending" . "\xf05bf")
    ("nf-md-sort_alphabetical_descending_variant" . "\xf1149")
    ("nf-md-sort_alphabetical_variant" . "\xf04bb")
    ("nf-md-sort_ascending" . "\xf04bc")
    ("nf-md-sort_bool_ascending" . "\xf1385")
    ("nf-md-sort_bool_ascending_variant" . "\xf1386")
    ("nf-md-sort_bool_descending" . "\xf1387")
    ("nf-md-sort_bool_descending_variant" . "\xf1388")
    ("nf-md-sort_calendar_ascending" . "\xf1547")
    ("nf-md-sort_calendar_descending" . "\xf1548")
    ("nf-md-sort_clock_ascending" . "\xf1549")
    ("nf-md-sort_clock_ascending_outline" . "\xf154a")
    ("nf-md-sort_clock_descending" . "\xf154b")
    ("nf-md-sort_clock_descending_outline" . "\xf154c")
    ("nf-md-sort_descending" . "\xf04bd")
    ("nf-md-sort_numeric_ascending" . "\xf1389")
    ("nf-md-sort_numeric_ascending_variant" . "\xf090d")
    ("nf-md-sort_numeric_descending" . "\xf138a")
    ("nf-md-sort_numeric_descending_variant" . "\xf0ad2")
    ("nf-md-sort_numeric_variant" . "\xf04be")
    ("nf-md-sort_reverse_variant" . "\xf033c")
    ("nf-md-sort_variant" . "\xf04bf")
    ("nf-md-sort_variant_lock" . "\xf0ccd")
    ("nf-md-sort_variant_lock_open" . "\xf0cce")
    ("nf-md-sort_variant_off" . "\xf1abb")
    ("nf-md-sort_variant_remove" . "\xf1147")
    ("nf-md-soundbar" . "\xf17db")
    ("nf-md-soundcloud" . "\xf04c0")
    ("nf-md-source_branch" . "\xf062c")
    ("nf-md-source_branch_check" . "\xf14cf")
    ("nf-md-source_branch_minus" . "\xf14cb")
    ("nf-md-source_branch_plus" . "\xf14ca")
    ("nf-md-source_branch_refresh" . "\xf14cd")
    ("nf-md-source_branch_remove" . "\xf14cc")
    ("nf-md-source_branch_sync" . "\xf14ce")
    ("nf-md-source_commit" . "\xf0718")
    ("nf-md-source_commit_end" . "\xf0719")
    ("nf-md-source_commit_end_local" . "\xf071a")
    ("nf-md-source_commit_local" . "\xf071b")
    ("nf-md-source_commit_next_local" . "\xf071c")
    ("nf-md-source_commit_start" . "\xf071d")
    ("nf-md-source_commit_start_next_local" . "\xf071e")
    ("nf-md-source_fork" . "\xf04c1")
    ("nf-md-source_merge" . "\xf062d")
    ("nf-md-source_pull" . "\xf04c2")
    ("nf-md-source_repository" . "\xf0ccf")
    ("nf-md-source_repository_multiple" . "\xf0cd0")
    ("nf-md-soy_sauce" . "\xf07ee")
    ("nf-md-soy_sauce_off" . "\xf13fc")
    ("nf-md-spa" . "\xf0cd1")
    ("nf-md-spa_outline" . "\xf0cd2")
    ("nf-md-space_invaders" . "\xf0bc9")
    ("nf-md-space_station" . "\xf1383")
    ("nf-md-spade" . "\xf0e65")
    ("nf-md-speaker" . "\xf04c3")
    ("nf-md-speaker_bluetooth" . "\xf09a2")
    ("nf-md-speaker_multiple" . "\xf0d38")
    ("nf-md-speaker_off" . "\xf04c4")
    ("nf-md-speaker_wireless" . "\xf071f")
    ("nf-md-spear" . "\xf1845")
    ("nf-md-speedometer" . "\xf04c5")
    ("nf-md-speedometer_medium" . "\xf0f85")
    ("nf-md-speedometer_slow" . "\xf0f86")
    ("nf-md-spellcheck" . "\xf04c6")
    ("nf-md-sphere" . "\xf1954")
    ("nf-md-sphere_off" . "\xf1955")
    ("nf-md-spider" . "\xf11ea")
    ("nf-md-spider_thread" . "\xf11eb")
    ("nf-md-spider_web" . "\xf0bca")
    ("nf-md-spirit_level" . "\xf14f1")
    ("nf-md-spoon_sugar" . "\xf1429")
    ("nf-md-spotify" . "\xf04c7")
    ("nf-md-spotlight" . "\xf04c8")
    ("nf-md-spotlight_beam" . "\xf04c9")
    ("nf-md-spray" . "\xf0665")
    ("nf-md-spray_bottle" . "\xf0ae0")
    ("nf-md-sprinkler" . "\xf105f")
    ("nf-md-sprinkler_fire" . "\xf199d")
    ("nf-md-sprinkler_variant" . "\xf1060")
    ("nf-md-sprout" . "\xf0e66")
    ("nf-md-sprout_outline" . "\xf0e67")
    ("nf-md-square" . "\xf0764")
    ("nf-md-square_circle" . "\xf1500")
    ("nf-md-square_edit_outline" . "\xf090c")
    ("nf-md-square_medium" . "\xf0a13")
    ("nf-md-square_medium_outline" . "\xf0a14")
    ("nf-md-square_off" . "\xf12ee")
    ("nf-md-square_off_outline" . "\xf12ef")
    ("nf-md-square_opacity" . "\xf1854")
    ("nf-md-square_outline" . "\xf0763")
    ("nf-md-square_root" . "\xf0784")
    ("nf-md-square_root_box" . "\xf09a3")
    ("nf-md-square_rounded" . "\xf14fb")
    ("nf-md-square_rounded_badge" . "\xf1a07")
    ("nf-md-square_rounded_badge_outline" . "\xf1a08")
    ("nf-md-square_rounded_outline" . "\xf14fc")
    ("nf-md-square_small" . "\xf0a15")
    ("nf-md-square_wave" . "\xf147b")
    ("nf-md-squeegee" . "\xf0ae1")
    ("nf-md-ssh" . "\xf08c0")
    ("nf-md-stack_exchange" . "\xf060b")
    ("nf-md-stack_overflow" . "\xf04cc")
    ("nf-md-stackpath" . "\xf0359")
    ("nf-md-stadium" . "\xf0ff9")
    ("nf-md-stadium_variant" . "\xf0720")
    ("nf-md-stairs" . "\xf04cd")
    ("nf-md-stairs_box" . "\xf139e")
    ("nf-md-stairs_down" . "\xf12be")
    ("nf-md-stairs_up" . "\xf12bd")
    ("nf-md-stamper" . "\xf0d39")
    ("nf-md-standard_definition" . "\xf07ef")
    ("nf-md-star" . "\xf04ce")
    ("nf-md-star_box" . "\xf0a73")
    ("nf-md-star_box_multiple" . "\xf1286")
    ("nf-md-star_box_multiple_outline" . "\xf1287")
    ("nf-md-star_box_outline" . "\xf0a74")
    ("nf-md-star_check" . "\xf1566")
    ("nf-md-star_check_outline" . "\xf156a")
    ("nf-md-star_circle" . "\xf04cf")
    ("nf-md-star_circle_outline" . "\xf09a4")
    ("nf-md-star_cog" . "\xf1668")
    ("nf-md-star_cog_outline" . "\xf1669")
    ("nf-md-star_crescent" . "\xf0979")
    ("nf-md-star_david" . "\xf097a")
    ("nf-md-star_face" . "\xf09a5")
    ("nf-md-star_four_points" . "\xf0ae2")
    ("nf-md-star_four_points_outline" . "\xf0ae3")
    ("nf-md-star_half" . "\xf0246")
    ("nf-md-star_half_full" . "\xf04d0")
    ("nf-md-star_minus" . "\xf1564")
    ("nf-md-star_minus_outline" . "\xf1568")
    ("nf-md-star_off" . "\xf04d1")
    ("nf-md-star_off_outline" . "\xf155b")
    ("nf-md-star_outline" . "\xf04d2")
    ("nf-md-star_plus" . "\xf1563")
    ("nf-md-star_plus_outline" . "\xf1567")
    ("nf-md-star_remove" . "\xf1565")
    ("nf-md-star_remove_outline" . "\xf1569")
    ("nf-md-star_settings" . "\xf166a")
    ("nf-md-star_settings_outline" . "\xf166b")
    ("nf-md-star_shooting" . "\xf1741")
    ("nf-md-star_shooting_outline" . "\xf1742")
    ("nf-md-star_three_points" . "\xf0ae4")
    ("nf-md-star_three_points_outline" . "\xf0ae5")
    ("nf-md-state_machine" . "\xf11ef")
    ("nf-md-steam" . "\xf04d3")
    ("nf-md-steering" . "\xf04d4")
    ("nf-md-steering_off" . "\xf090e")
    ("nf-md-step_backward" . "\xf04d5")
    ("nf-md-step_backward_2" . "\xf04d6")
    ("nf-md-step_forward" . "\xf04d7")
    ("nf-md-step_forward_2" . "\xf04d8")
    ("nf-md-stethoscope" . "\xf04d9")
    ("nf-md-sticker" . "\xf1364")
    ("nf-md-sticker_alert" . "\xf1365")
    ("nf-md-sticker_alert_outline" . "\xf1366")
    ("nf-md-sticker_check" . "\xf1367")
    ("nf-md-sticker_check_outline" . "\xf1368")
    ("nf-md-sticker_circle_outline" . "\xf05d0")
    ("nf-md-sticker_emoji" . "\xf0785")
    ("nf-md-sticker_minus" . "\xf1369")
    ("nf-md-sticker_minus_outline" . "\xf136a")
    ("nf-md-sticker_outline" . "\xf136b")
    ("nf-md-sticker_plus" . "\xf136c")
    ("nf-md-sticker_plus_outline" . "\xf136d")
    ("nf-md-sticker_remove" . "\xf136e")
    ("nf-md-sticker_remove_outline" . "\xf136f")
    ("nf-md-sticker_text" . "\xf178e")
    ("nf-md-sticker_text_outline" . "\xf178f")
    ("nf-md-stocking" . "\xf04da")
    ("nf-md-stomach" . "\xf1093")
    ("nf-md-stool" . "\xf195d")
    ("nf-md-stool_outline" . "\xf195e")
    ("nf-md-stop" . "\xf04db")
    ("nf-md-stop_circle" . "\xf0666")
    ("nf-md-stop_circle_outline" . "\xf0667")
    ("nf-md-storage_tank" . "\xf1a75")
    ("nf-md-storage_tank_outline" . "\xf1a76")
    ("nf-md-store" . "\xf04dc")
    ("nf-md-store_24_hour" . "\xf04dd")
    ("nf-md-store_alert" . "\xf18c1")
    ("nf-md-store_alert_outline" . "\xf18c2")
    ("nf-md-store_check" . "\xf18c3")
    ("nf-md-store_check_outline" . "\xf18c4")
    ("nf-md-store_clock" . "\xf18c5")
    ("nf-md-store_clock_outline" . "\xf18c6")
    ("nf-md-store_cog" . "\xf18c7")
    ("nf-md-store_cog_outline" . "\xf18c8")
    ("nf-md-store_edit" . "\xf18c9")
    ("nf-md-store_edit_outline" . "\xf18ca")
    ("nf-md-store_marker" . "\xf18cb")
    ("nf-md-store_marker_outline" . "\xf18cc")
    ("nf-md-store_minus" . "\xf165e")
    ("nf-md-store_minus_outline" . "\xf18cd")
    ("nf-md-store_off" . "\xf18ce")
    ("nf-md-store_off_outline" . "\xf18cf")
    ("nf-md-store_outline" . "\xf1361")
    ("nf-md-store_plus" . "\xf165f")
    ("nf-md-store_plus_outline" . "\xf18d0")
    ("nf-md-store_remove" . "\xf1660")
    ("nf-md-store_remove_outline" . "\xf18d1")
    ("nf-md-store_search" . "\xf18d2")
    ("nf-md-store_search_outline" . "\xf18d3")
    ("nf-md-store_settings" . "\xf18d4")
    ("nf-md-store_settings_outline" . "\xf18d5")
    ("nf-md-storefront" . "\xf07c7")
    ("nf-md-storefront_outline" . "\xf10c1")
    ("nf-md-stove" . "\xf04de")
    ("nf-md-strategy" . "\xf11d6")
    ("nf-md-stretch_to_page" . "\xf0f2b")
    ("nf-md-stretch_to_page_outline" . "\xf0f2c")
    ("nf-md-string_lights" . "\xf12ba")
    ("nf-md-string_lights_off" . "\xf12bb")
    ("nf-md-subdirectory_arrow_left" . "\xf060c")
    ("nf-md-subdirectory_arrow_right" . "\xf060d")
    ("nf-md-submarine" . "\xf156c")
    ("nf-md-subtitles" . "\xf0a16")
    ("nf-md-subtitles_outline" . "\xf0a17")
    ("nf-md-subway" . "\xf06ac")
    ("nf-md-subway_alert_variant" . "\xf0d9d")
    ("nf-md-subway_variant" . "\xf04df")
    ("nf-md-summit" . "\xf0786")
    ("nf-md-sun_clock" . "\xf1a77")
    ("nf-md-sun_clock_outline" . "\xf1a78")
    ("nf-md-sun_compass" . "\xf19a5")
    ("nf-md-sun_snowflake" . "\xf1796")
    ("nf-md-sun_snowflake_variant" . "\xf1a79")
    ("nf-md-sun_thermometer" . "\xf18d6")
    ("nf-md-sun_thermometer_outline" . "\xf18d7")
    ("nf-md-sun_wireless" . "\xf17fe")
    ("nf-md-sun_wireless_outline" . "\xf17ff")
    ("nf-md-sunglasses" . "\xf04e0")
    ("nf-md-surfing" . "\xf1746")
    ("nf-md-surround_sound" . "\xf05c5")
    ("nf-md-surround_sound_2_0" . "\xf07f0")
    ("nf-md-surround_sound_2_1" . "\xf1729")
    ("nf-md-surround_sound_3_1" . "\xf07f1")
    ("nf-md-surround_sound_5_1" . "\xf07f2")
    ("nf-md-surround_sound_5_1_2" . "\xf172a")
    ("nf-md-surround_sound_7_1" . "\xf07f3")
    ("nf-md-svg" . "\xf0721")
    ("nf-md-swap_horizontal" . "\xf04e1")
    ("nf-md-swap_horizontal_bold" . "\xf0bcd")
    ("nf-md-swap_horizontal_circle" . "\xf0fe1")
    ("nf-md-swap_horizontal_circle_outline" . "\xf0fe2")
    ("nf-md-swap_horizontal_variant" . "\xf08c1")
    ("nf-md-swap_vertical" . "\xf04e2")
    ("nf-md-swap_vertical_bold" . "\xf0bce")
    ("nf-md-swap_vertical_circle" . "\xf0fe3")
    ("nf-md-swap_vertical_circle_outline" . "\xf0fe4")
    ("nf-md-swap_vertical_variant" . "\xf08c2")
    ("nf-md-swim" . "\xf04e3")
    ("nf-md-switch" . "\xf04e4")
    ("nf-md-sword" . "\xf04e5")
    ("nf-md-sword_cross" . "\xf0787")
    ("nf-md-syllabary_hangul" . "\xf1333")
    ("nf-md-syllabary_hiragana" . "\xf1334")
    ("nf-md-syllabary_katakana" . "\xf1335")
    ("nf-md-syllabary_katakana_halfwidth" . "\xf1336")
    ("nf-md-symbol" . "\xf1501")
    ("nf-md-symfony" . "\xf0ae6")
    ("nf-md-sync" . "\xf04e6")
    ("nf-md-sync_alert" . "\xf04e7")
    ("nf-md-sync_circle" . "\xf1378")
    ("nf-md-sync_off" . "\xf04e8")
    ("nf-md-tab" . "\xf04e9")
    ("nf-md-tab_minus" . "\xf0b4b")
    ("nf-md-tab_plus" . "\xf075c")
    ("nf-md-tab_remove" . "\xf0b4c")
    ("nf-md-tab_search" . "\xf199e")
    ("nf-md-tab_unselected" . "\xf04ea")
    ("nf-md-table" . "\xf04eb")
    ("nf-md-table_account" . "\xf13b9")
    ("nf-md-table_alert" . "\xf13ba")
    ("nf-md-table_arrow_down" . "\xf13bb")
    ("nf-md-table_arrow_left" . "\xf13bc")
    ("nf-md-table_arrow_right" . "\xf13bd")
    ("nf-md-table_arrow_up" . "\xf13be")
    ("nf-md-table_border" . "\xf0a18")
    ("nf-md-table_cancel" . "\xf13bf")
    ("nf-md-table_chair" . "\xf1061")
    ("nf-md-table_check" . "\xf13c0")
    ("nf-md-table_clock" . "\xf13c1")
    ("nf-md-table_cog" . "\xf13c2")
    ("nf-md-table_column" . "\xf0835")
    ("nf-md-table_column_plus_after" . "\xf04ec")
    ("nf-md-table_column_plus_before" . "\xf04ed")
    ("nf-md-table_column_remove" . "\xf04ee")
    ("nf-md-table_column_width" . "\xf04ef")
    ("nf-md-table_edit" . "\xf04f0")
    ("nf-md-table_eye" . "\xf1094")
    ("nf-md-table_eye_off" . "\xf13c3")
    ("nf-md-table_furniture" . "\xf05bc")
    ("nf-md-table_headers_eye" . "\xf121d")
    ("nf-md-table_headers_eye_off" . "\xf121e")
    ("nf-md-table_heart" . "\xf13c4")
    ("nf-md-table_key" . "\xf13c5")
    ("nf-md-table_large" . "\xf04f1")
    ("nf-md-table_large_plus" . "\xf0f87")
    ("nf-md-table_large_remove" . "\xf0f88")
    ("nf-md-table_lock" . "\xf13c6")
    ("nf-md-table_merge_cells" . "\xf09a6")
    ("nf-md-table_minus" . "\xf13c7")
    ("nf-md-table_multiple" . "\xf13c8")
    ("nf-md-table_network" . "\xf13c9")
    ("nf-md-table_of_contents" . "\xf0836")
    ("nf-md-table_off" . "\xf13ca")
    ("nf-md-table_picnic" . "\xf1743")
    ("nf-md-table_pivot" . "\xf183c")
    ("nf-md-table_plus" . "\xf0a75")
    ("nf-md-table_refresh" . "\xf13a0")
    ("nf-md-table_remove" . "\xf0a76")
    ("nf-md-table_row" . "\xf0837")
    ("nf-md-table_row_height" . "\xf04f2")
    ("nf-md-table_row_plus_after" . "\xf04f3")
    ("nf-md-table_row_plus_before" . "\xf04f4")
    ("nf-md-table_row_remove" . "\xf04f5")
    ("nf-md-table_search" . "\xf090f")
    ("nf-md-table_settings" . "\xf0838")
    ("nf-md-table_split_cell" . "\xf142a")
    ("nf-md-table_star" . "\xf13cb")
    ("nf-md-table_sync" . "\xf13a1")
    ("nf-md-table_tennis" . "\xf0e68")
    ("nf-md-tablet" . "\xf04f6")
    ("nf-md-tablet_android" . "\xf04f7")
    ("nf-md-tablet_cellphone" . "\xf09a7")
    ("nf-md-tablet_dashboard" . "\xf0ece")
    ("nf-md-taco" . "\xf0762")
    ("nf-md-tag" . "\xf04f9")
    ("nf-md-tag_arrow_down" . "\xf172b")
    ("nf-md-tag_arrow_down_outline" . "\xf172c")
    ("nf-md-tag_arrow_left" . "\xf172d")
    ("nf-md-tag_arrow_left_outline" . "\xf172e")
    ("nf-md-tag_arrow_right" . "\xf172f")
    ("nf-md-tag_arrow_right_outline" . "\xf1730")
    ("nf-md-tag_arrow_up" . "\xf1731")
    ("nf-md-tag_arrow_up_outline" . "\xf1732")
    ("nf-md-tag_check" . "\xf1a7a")
    ("nf-md-tag_check_outline" . "\xf1a7b")
    ("nf-md-tag_faces" . "\xf04fa")
    ("nf-md-tag_heart" . "\xf068b")
    ("nf-md-tag_heart_outline" . "\xf0bcf")
    ("nf-md-tag_minus" . "\xf0910")
    ("nf-md-tag_minus_outline" . "\xf121f")
    ("nf-md-tag_multiple" . "\xf04fb")
    ("nf-md-tag_multiple_outline" . "\xf12f7")
    ("nf-md-tag_off" . "\xf1220")
    ("nf-md-tag_off_outline" . "\xf1221")
    ("nf-md-tag_outline" . "\xf04fc")
    ("nf-md-tag_plus" . "\xf0722")
    ("nf-md-tag_plus_outline" . "\xf1222")
    ("nf-md-tag_remove" . "\xf0723")
    ("nf-md-tag_remove_outline" . "\xf1223")
    ("nf-md-tag_search" . "\xf1907")
    ("nf-md-tag_search_outline" . "\xf1908")
    ("nf-md-tag_text" . "\xf1224")
    ("nf-md-tag_text_outline" . "\xf04fd")
    ("nf-md-tailwind" . "\xf13ff")
    ("nf-md-tally_mark_1" . "\xf1abc")
    ("nf-md-tally_mark_2" . "\xf1abd")
    ("nf-md-tally_mark_3" . "\xf1abe")
    ("nf-md-tally_mark_4" . "\xf1abf")
    ("nf-md-tally_mark_5" . "\xf1ac0")
    ("nf-md-tangram" . "\xf04f8")
    ("nf-md-tank" . "\xf0d3a")
    ("nf-md-tanker_truck" . "\xf0fe5")
    ("nf-md-tape_drive" . "\xf16df")
    ("nf-md-tape_measure" . "\xf0b4d")
    ("nf-md-target" . "\xf04fe")
    ("nf-md-target_account" . "\xf0bd0")
    ("nf-md-target_variant" . "\xf0a77")
    ("nf-md-taxi" . "\xf04ff")
    ("nf-md-tea" . "\xf0d9e")
    ("nf-md-tea_outline" . "\xf0d9f")
    ("nf-md-teamviewer" . "\xf0500")
    ("nf-md-teddy_bear" . "\xf18fb")
    ("nf-md-telescope" . "\xf0b4e")
    ("nf-md-television" . "\xf0502")
    ("nf-md-television_ambient_light" . "\xf1356")
    ("nf-md-television_box" . "\xf0839")
    ("nf-md-television_classic" . "\xf07f4")
    ("nf-md-television_classic_off" . "\xf083a")
    ("nf-md-television_guide" . "\xf0503")
    ("nf-md-television_off" . "\xf083b")
    ("nf-md-television_pause" . "\xf0f89")
    ("nf-md-television_play" . "\xf0ecf")
    ("nf-md-television_shimmer" . "\xf1110")
    ("nf-md-television_stop" . "\xf0f8a")
    ("nf-md-temperature_celsius" . "\xf0504")
    ("nf-md-temperature_fahrenheit" . "\xf0505")
    ("nf-md-temperature_kelvin" . "\xf0506")
    ("nf-md-tennis" . "\xf0da0")
    ("nf-md-tennis_ball" . "\xf0507")
    ("nf-md-tent" . "\xf0508")
    ("nf-md-terraform" . "\xf1062")
    ("nf-md-test_tube" . "\xf0668")
    ("nf-md-test_tube_empty" . "\xf0911")
    ("nf-md-test_tube_off" . "\xf0912")
    ("nf-md-text" . "\xf09a8")
    ("nf-md-text_account" . "\xf1570")
    ("nf-md-text_box" . "\xf021a")
    ("nf-md-text_box_check" . "\xf0ea6")
    ("nf-md-text_box_check_outline" . "\xf0ea7")
    ("nf-md-text_box_edit" . "\xf1a7c")
    ("nf-md-text_box_edit_outline" . "\xf1a7d")
    ("nf-md-text_box_minus" . "\xf0ea8")
    ("nf-md-text_box_minus_outline" . "\xf0ea9")
    ("nf-md-text_box_multiple" . "\xf0ab7")
    ("nf-md-text_box_multiple_outline" . "\xf0ab8")
    ("nf-md-text_box_outline" . "\xf09ed")
    ("nf-md-text_box_plus" . "\xf0eaa")
    ("nf-md-text_box_plus_outline" . "\xf0eab")
    ("nf-md-text_box_remove" . "\xf0eac")
    ("nf-md-text_box_remove_outline" . "\xf0ead")
    ("nf-md-text_box_search" . "\xf0eae")
    ("nf-md-text_box_search_outline" . "\xf0eaf")
    ("nf-md-text_long" . "\xf09aa")
    ("nf-md-text_recognition" . "\xf113d")
    ("nf-md-text_search" . "\xf13b8")
    ("nf-md-text_search_variant" . "\xf1a7e")
    ("nf-md-text_shadow" . "\xf0669")
    ("nf-md-text_short" . "\xf09a9")
    ("nf-md-text_to_speech" . "\xf050a")
    ("nf-md-text_to_speech_off" . "\xf050b")
    ("nf-md-texture" . "\xf050c")
    ("nf-md-texture_box" . "\xf0fe6")
    ("nf-md-theater" . "\xf050d")
    ("nf-md-theme_light_dark" . "\xf050e")
    ("nf-md-thermometer" . "\xf050f")
    ("nf-md-thermometer_alert" . "\xf0e01")
    ("nf-md-thermometer_bluetooth" . "\xf1895")
    ("nf-md-thermometer_check" . "\xf1a7f")
    ("nf-md-thermometer_chevron_down" . "\xf0e02")
    ("nf-md-thermometer_chevron_up" . "\xf0e03")
    ("nf-md-thermometer_high" . "\xf10c2")
    ("nf-md-thermometer_lines" . "\xf0510")
    ("nf-md-thermometer_low" . "\xf10c3")
    ("nf-md-thermometer_minus" . "\xf0e04")
    ("nf-md-thermometer_off" . "\xf1531")
    ("nf-md-thermometer_plus" . "\xf0e05")
    ("nf-md-thermometer_water" . "\xf1a80")
    ("nf-md-thermostat" . "\xf0393")
    ("nf-md-thermostat_box" . "\xf0891")
    ("nf-md-thought_bubble" . "\xf07f6")
    ("nf-md-thought_bubble_outline" . "\xf07f7")
    ("nf-md-thumb_down" . "\xf0511")
    ("nf-md-thumb_down_outline" . "\xf0512")
    ("nf-md-thumb_up" . "\xf0513")
    ("nf-md-thumb_up_outline" . "\xf0514")
    ("nf-md-thumbs_up_down" . "\xf0515")
    ("nf-md-thumbs_up_down_outline" . "\xf1914")
    ("nf-md-ticket" . "\xf0516")
    ("nf-md-ticket_account" . "\xf0517")
    ("nf-md-ticket_confirmation" . "\xf0518")
    ("nf-md-ticket_confirmation_outline" . "\xf13aa")
    ("nf-md-ticket_outline" . "\xf0913")
    ("nf-md-ticket_percent" . "\xf0724")
    ("nf-md-ticket_percent_outline" . "\xf142b")
    ("nf-md-tie" . "\xf0519")
    ("nf-md-tilde" . "\xf0725")
    ("nf-md-tilde_off" . "\xf18f3")
    ("nf-md-timelapse" . "\xf051a")
    ("nf-md-timeline" . "\xf0bd1")
    ("nf-md-timeline_alert" . "\xf0f95")
    ("nf-md-timeline_alert_outline" . "\xf0f98")
    ("nf-md-timeline_check" . "\xf1532")
    ("nf-md-timeline_check_outline" . "\xf1533")
    ("nf-md-timeline_clock" . "\xf11fb")
    ("nf-md-timeline_clock_outline" . "\xf11fc")
    ("nf-md-timeline_help" . "\xf0f99")
    ("nf-md-timeline_help_outline" . "\xf0f9a")
    ("nf-md-timeline_minus" . "\xf1534")
    ("nf-md-timeline_minus_outline" . "\xf1535")
    ("nf-md-timeline_outline" . "\xf0bd2")
    ("nf-md-timeline_plus" . "\xf0f96")
    ("nf-md-timeline_plus_outline" . "\xf0f97")
    ("nf-md-timeline_remove" . "\xf1536")
    ("nf-md-timeline_remove_outline" . "\xf1537")
    ("nf-md-timeline_text" . "\xf0bd3")
    ("nf-md-timeline_text_outline" . "\xf0bd4")
    ("nf-md-timer" . "\xf13ab")
    ("nf-md-timer_10" . "\xf051c")
    ("nf-md-timer_3" . "\xf051d")
    ("nf-md-timer_alert" . "\xf1acc")
    ("nf-md-timer_alert_outline" . "\xf1acd")
    ("nf-md-timer_cancel" . "\xf1ace")
    ("nf-md-timer_cancel_outline" . "\xf1acf")
    ("nf-md-timer_check" . "\xf1ad0")
    ("nf-md-timer_check_outline" . "\xf1ad1")
    ("nf-md-timer_cog" . "\xf1925")
    ("nf-md-timer_cog_outline" . "\xf1926")
    ("nf-md-timer_edit" . "\xf1ad2")
    ("nf-md-timer_edit_outline" . "\xf1ad3")
    ("nf-md-timer_lock" . "\xf1ad4")
    ("nf-md-timer_lock_open" . "\xf1ad5")
    ("nf-md-timer_lock_open_outline" . "\xf1ad6")
    ("nf-md-timer_lock_outline" . "\xf1ad7")
    ("nf-md-timer_marker" . "\xf1ad8")
    ("nf-md-timer_marker_outline" . "\xf1ad9")
    ("nf-md-timer_minus" . "\xf1ada")
    ("nf-md-timer_minus_outline" . "\xf1adb")
    ("nf-md-timer_music" . "\xf1adc")
    ("nf-md-timer_music_outline" . "\xf1add")
    ("nf-md-timer_off" . "\xf13ac")
    ("nf-md-timer_off_outline" . "\xf051e")
    ("nf-md-timer_outline" . "\xf051b")
    ("nf-md-timer_pause" . "\xf1ade")
    ("nf-md-timer_pause_outline" . "\xf1adf")
    ("nf-md-timer_play" . "\xf1ae0")
    ("nf-md-timer_play_outline" . "\xf1ae1")
    ("nf-md-timer_plus" . "\xf1ae2")
    ("nf-md-timer_plus_outline" . "\xf1ae3")
    ("nf-md-timer_refresh" . "\xf1ae4")
    ("nf-md-timer_refresh_outline" . "\xf1ae5")
    ("nf-md-timer_remove" . "\xf1ae6")
    ("nf-md-timer_remove_outline" . "\xf1ae7")
    ("nf-md-timer_sand" . "\xf051f")
    ("nf-md-timer_sand_complete" . "\xf199f")
    ("nf-md-timer_sand_empty" . "\xf06ad")
    ("nf-md-timer_sand_full" . "\xf078c")
    ("nf-md-timer_sand_paused" . "\xf19a0")
    ("nf-md-timer_settings" . "\xf1923")
    ("nf-md-timer_settings_outline" . "\xf1924")
    ("nf-md-timer_star" . "\xf1ae8")
    ("nf-md-timer_star_outline" . "\xf1ae9")
    ("nf-md-timer_stop" . "\xf1aea")
    ("nf-md-timer_stop_outline" . "\xf1aeb")
    ("nf-md-timer_sync" . "\xf1aec")
    ("nf-md-timer_sync_outline" . "\xf1aed")
    ("nf-md-timetable" . "\xf0520")
    ("nf-md-tire" . "\xf1896")
    ("nf-md-toaster" . "\xf1063")
    ("nf-md-toaster_off" . "\xf11b7")
    ("nf-md-toaster_oven" . "\xf0cd3")
    ("nf-md-toggle_switch" . "\xf0521")
    ("nf-md-toggle_switch_off" . "\xf0522")
    ("nf-md-toggle_switch_off_outline" . "\xf0a19")
    ("nf-md-toggle_switch_outline" . "\xf0a1a")
    ("nf-md-toggle_switch_variant" . "\xf1a25")
    ("nf-md-toggle_switch_variant_off" . "\xf1a26")
    ("nf-md-toilet" . "\xf09ab")
    ("nf-md-toolbox" . "\xf09ac")
    ("nf-md-toolbox_outline" . "\xf09ad")
    ("nf-md-tools" . "\xf1064")
    ("nf-md-tooltip" . "\xf0523")
    ("nf-md-tooltip_account" . "\xf000c")
    ("nf-md-tooltip_cellphone" . "\xf183b")
    ("nf-md-tooltip_check" . "\xf155c")
    ("nf-md-tooltip_check_outline" . "\xf155d")
    ("nf-md-tooltip_edit" . "\xf0524")
    ("nf-md-tooltip_edit_outline" . "\xf12c5")
    ("nf-md-tooltip_image" . "\xf0525")
    ("nf-md-tooltip_image_outline" . "\xf0bd5")
    ("nf-md-tooltip_minus" . "\xf155e")
    ("nf-md-tooltip_minus_outline" . "\xf155f")
    ("nf-md-tooltip_outline" . "\xf0526")
    ("nf-md-tooltip_plus" . "\xf0bd6")
    ("nf-md-tooltip_plus_outline" . "\xf0527")
    ("nf-md-tooltip_remove" . "\xf1560")
    ("nf-md-tooltip_remove_outline" . "\xf1561")
    ("nf-md-tooltip_text" . "\xf0528")
    ("nf-md-tooltip_text_outline" . "\xf0bd7")
    ("nf-md-tooth" . "\xf08c3")
    ("nf-md-tooth_outline" . "\xf0529")
    ("nf-md-toothbrush" . "\xf1129")
    ("nf-md-toothbrush_electric" . "\xf112c")
    ("nf-md-toothbrush_paste" . "\xf112a")
    ("nf-md-torch" . "\xf1606")
    ("nf-md-tortoise" . "\xf0d3b")
    ("nf-md-toslink" . "\xf12b8")
    ("nf-md-tournament" . "\xf09ae")
    ("nf-md-tow_truck" . "\xf083c")
    ("nf-md-tower_beach" . "\xf0681")
    ("nf-md-tower_fire" . "\xf0682")
    ("nf-md-town_hall" . "\xf1875")
    ("nf-md-toy_brick" . "\xf1288")
    ("nf-md-toy_brick_marker" . "\xf1289")
    ("nf-md-toy_brick_marker_outline" . "\xf128a")
    ("nf-md-toy_brick_minus" . "\xf128b")
    ("nf-md-toy_brick_minus_outline" . "\xf128c")
    ("nf-md-toy_brick_outline" . "\xf128d")
    ("nf-md-toy_brick_plus" . "\xf128e")
    ("nf-md-toy_brick_plus_outline" . "\xf128f")
    ("nf-md-toy_brick_remove" . "\xf1290")
    ("nf-md-toy_brick_remove_outline" . "\xf1291")
    ("nf-md-toy_brick_search" . "\xf1292")
    ("nf-md-toy_brick_search_outline" . "\xf1293")
    ("nf-md-track_light" . "\xf0914")
    ("nf-md-trackpad" . "\xf07f8")
    ("nf-md-trackpad_lock" . "\xf0933")
    ("nf-md-tractor" . "\xf0892")
    ("nf-md-tractor_variant" . "\xf14c4")
    ("nf-md-trademark" . "\xf0a78")
    ("nf-md-traffic_cone" . "\xf137c")
    ("nf-md-traffic_light" . "\xf052b")
    ("nf-md-traffic_light_outline" . "\xf182a")
    ("nf-md-train" . "\xf052c")
    ("nf-md-train_car" . "\xf0bd8")
    ("nf-md-train_car_passenger" . "\xf1733")
    ("nf-md-train_car_passenger_door" . "\xf1734")
    ("nf-md-train_car_passenger_door_open" . "\xf1735")
    ("nf-md-train_car_passenger_variant" . "\xf1736")
    ("nf-md-train_variant" . "\xf08c4")
    ("nf-md-tram" . "\xf052d")
    ("nf-md-tram_side" . "\xf0fe7")
    ("nf-md-transcribe" . "\xf052e")
    ("nf-md-transcribe_close" . "\xf052f")
    ("nf-md-transfer" . "\xf1065")
    ("nf-md-transfer_down" . "\xf0da1")
    ("nf-md-transfer_left" . "\xf0da2")
    ("nf-md-transfer_right" . "\xf0530")
    ("nf-md-transfer_up" . "\xf0da3")
    ("nf-md-transit_connection" . "\xf0d3c")
    ("nf-md-transit_connection_horizontal" . "\xf1546")
    ("nf-md-transit_connection_variant" . "\xf0d3d")
    ("nf-md-transit_detour" . "\xf0f8b")
    ("nf-md-transit_skip" . "\xf1515")
    ("nf-md-transit_transfer" . "\xf06ae")
    ("nf-md-transition" . "\xf0915")
    ("nf-md-transition_masked" . "\xf0916")
    ("nf-md-translate" . "\xf05ca")
    ("nf-md-translate_off" . "\xf0e06")
    ("nf-md-transmission_tower" . "\xf0d3e")
    ("nf-md-transmission_tower_export" . "\xf192c")
    ("nf-md-transmission_tower_import" . "\xf192d")
    ("nf-md-transmission_tower_off" . "\xf19dd")
    ("nf-md-trash_can" . "\xf0a79")
    ("nf-md-trash_can_outline" . "\xf0a7a")
    ("nf-md-tray" . "\xf1294")
    ("nf-md-tray_alert" . "\xf1295")
    ("nf-md-tray_arrow_down" . "\xf0120")
    ("nf-md-tray_arrow_up" . "\xf011d")
    ("nf-md-tray_full" . "\xf1296")
    ("nf-md-tray_minus" . "\xf1297")
    ("nf-md-tray_plus" . "\xf1298")
    ("nf-md-tray_remove" . "\xf1299")
    ("nf-md-treasure_chest" . "\xf0726")
    ("nf-md-tree" . "\xf0531")
    ("nf-md-tree_outline" . "\xf0e69")
    ("nf-md-trello" . "\xf0532")
    ("nf-md-trending_down" . "\xf0533")
    ("nf-md-trending_neutral" . "\xf0534")
    ("nf-md-trending_up" . "\xf0535")
    ("nf-md-triangle" . "\xf0536")
    ("nf-md-triangle_outline" . "\xf0537")
    ("nf-md-triangle_small_down" . "\xf1a09")
    ("nf-md-triangle_small_up" . "\xf1a0a")
    ("nf-md-triangle_wave" . "\xf147c")
    ("nf-md-triforce" . "\xf0bd9")
    ("nf-md-trophy" . "\xf0538")
    ("nf-md-trophy_award" . "\xf0539")
    ("nf-md-trophy_broken" . "\xf0da4")
    ("nf-md-trophy_outline" . "\xf053a")
    ("nf-md-trophy_variant" . "\xf053b")
    ("nf-md-trophy_variant_outline" . "\xf053c")
    ("nf-md-truck" . "\xf053d")
    ("nf-md-truck_alert" . "\xf19de")
    ("nf-md-truck_alert_outline" . "\xf19df")
    ("nf-md-truck_cargo_container" . "\xf18d8")
    ("nf-md-truck_check" . "\xf0cd4")
    ("nf-md-truck_check_outline" . "\xf129a")
    ("nf-md-truck_delivery" . "\xf053e")
    ("nf-md-truck_delivery_outline" . "\xf129b")
    ("nf-md-truck_fast" . "\xf0788")
    ("nf-md-truck_fast_outline" . "\xf129c")
    ("nf-md-truck_flatbed" . "\xf1891")
    ("nf-md-truck_minus" . "\xf19ae")
    ("nf-md-truck_minus_outline" . "\xf19bd")
    ("nf-md-truck_outline" . "\xf129d")
    ("nf-md-truck_plus" . "\xf19ad")
    ("nf-md-truck_plus_outline" . "\xf19bc")
    ("nf-md-truck_remove" . "\xf19af")
    ("nf-md-truck_remove_outline" . "\xf19be")
    ("nf-md-truck_snowflake" . "\xf19a6")
    ("nf-md-truck_trailer" . "\xf0727")
    ("nf-md-trumpet" . "\xf1096")
    ("nf-md-tshirt_crew" . "\xf0a7b")
    ("nf-md-tshirt_crew_outline" . "\xf053f")
    ("nf-md-tshirt_v" . "\xf0a7c")
    ("nf-md-tshirt_v_outline" . "\xf0540")
    ("nf-md-tsunami" . "\xf1a81")
    ("nf-md-tumble_dryer" . "\xf0917")
    ("nf-md-tumble_dryer_alert" . "\xf11ba")
    ("nf-md-tumble_dryer_off" . "\xf11bb")
    ("nf-md-tune" . "\xf062e")
    ("nf-md-tune_variant" . "\xf1542")
    ("nf-md-tune_vertical" . "\xf066a")
    ("nf-md-tune_vertical_variant" . "\xf1543")
    ("nf-md-tunnel" . "\xf183d")
    ("nf-md-tunnel_outline" . "\xf183e")
    ("nf-md-turbine" . "\xf1a82")
    ("nf-md-turkey" . "\xf171b")
    ("nf-md-turnstile" . "\xf0cd5")
    ("nf-md-turnstile_outline" . "\xf0cd6")
    ("nf-md-turtle" . "\xf0cd7")
    ("nf-md-twitch" . "\xf0543")
    ("nf-md-twitter" . "\xf0544")
    ("nf-md-two_factor_authentication" . "\xf09af")
    ("nf-md-typewriter" . "\xf0f2d")
    ("nf-md-ubisoft" . "\xf0bda")
    ("nf-md-ubuntu" . "\xf0548")
    ("nf-md-ufo" . "\xf10c4")
    ("nf-md-ufo_outline" . "\xf10c5")
    ("nf-md-ultra_high_definition" . "\xf07f9")
    ("nf-md-umbraco" . "\xf0549")
    ("nf-md-umbrella" . "\xf054a")
    ("nf-md-umbrella_beach" . "\xf188a")
    ("nf-md-umbrella_beach_outline" . "\xf188b")
    ("nf-md-umbrella_closed" . "\xf09b0")
    ("nf-md-umbrella_closed_outline" . "\xf13e2")
    ("nf-md-umbrella_closed_variant" . "\xf13e1")
    ("nf-md-umbrella_outline" . "\xf054b")
    ("nf-md-undo" . "\xf054c")
    ("nf-md-undo_variant" . "\xf054d")
    ("nf-md-unfold_less_horizontal" . "\xf054e")
    ("nf-md-unfold_less_vertical" . "\xf0760")
    ("nf-md-unfold_more_horizontal" . "\xf054f")
    ("nf-md-unfold_more_vertical" . "\xf0761")
    ("nf-md-ungroup" . "\xf0550")
    ("nf-md-unicode" . "\xf0ed0")
    ("nf-md-unicorn" . "\xf15c2")
    ("nf-md-unicorn_variant" . "\xf15c3")
    ("nf-md-unicycle" . "\xf15e5")
    ("nf-md-unity" . "\xf06af")
    ("nf-md-unreal" . "\xf09b1")
    ("nf-md-update" . "\xf06b0")
    ("nf-md-upload" . "\xf0552")
    ("nf-md-upload_lock" . "\xf1373")
    ("nf-md-upload_lock_outline" . "\xf1374")
    ("nf-md-upload_multiple" . "\xf083d")
    ("nf-md-upload_network" . "\xf06f6")
    ("nf-md-upload_network_outline" . "\xf0cd8")
    ("nf-md-upload_off" . "\xf10c6")
    ("nf-md-upload_off_outline" . "\xf10c7")
    ("nf-md-upload_outline" . "\xf0e07")
    ("nf-md-usb" . "\xf0553")
    ("nf-md-usb_flash_drive" . "\xf129e")
    ("nf-md-usb_flash_drive_outline" . "\xf129f")
    ("nf-md-usb_port" . "\xf11f0")
    ("nf-md-vacuum" . "\xf19a1")
    ("nf-md-vacuum_outline" . "\xf19a2")
    ("nf-md-valve" . "\xf1066")
    ("nf-md-valve_closed" . "\xf1067")
    ("nf-md-valve_open" . "\xf1068")
    ("nf-md-van_passenger" . "\xf07fa")
    ("nf-md-van_utility" . "\xf07fb")
    ("nf-md-vanish" . "\xf07fc")
    ("nf-md-vanish_quarter" . "\xf1554")
    ("nf-md-vanity_light" . "\xf11e1")
    ("nf-md-variable" . "\xf0ae7")
    ("nf-md-variable_box" . "\xf1111")
    ("nf-md-vector_arrange_above" . "\xf0554")
    ("nf-md-vector_arrange_below" . "\xf0555")
    ("nf-md-vector_bezier" . "\xf0ae8")
    ("nf-md-vector_circle" . "\xf0556")
    ("nf-md-vector_circle_variant" . "\xf0557")
    ("nf-md-vector_combine" . "\xf0558")
    ("nf-md-vector_curve" . "\xf0559")
    ("nf-md-vector_difference" . "\xf055a")
    ("nf-md-vector_difference_ab" . "\xf055b")
    ("nf-md-vector_difference_ba" . "\xf055c")
    ("nf-md-vector_ellipse" . "\xf0893")
    ("nf-md-vector_intersection" . "\xf055d")
    ("nf-md-vector_line" . "\xf055e")
    ("nf-md-vector_link" . "\xf0fe8")
    ("nf-md-vector_point" . "\xf055f")
    ("nf-md-vector_polygon" . "\xf0560")
    ("nf-md-vector_polygon_variant" . "\xf1856")
    ("nf-md-vector_polyline" . "\xf0561")
    ("nf-md-vector_polyline_edit" . "\xf1225")
    ("nf-md-vector_polyline_minus" . "\xf1226")
    ("nf-md-vector_polyline_plus" . "\xf1227")
    ("nf-md-vector_polyline_remove" . "\xf1228")
    ("nf-md-vector_radius" . "\xf074a")
    ("nf-md-vector_rectangle" . "\xf05c6")
    ("nf-md-vector_selection" . "\xf0562")
    ("nf-md-vector_square" . "\xf0001")
    ("nf-md-vector_square_close" . "\xf1857")
    ("nf-md-vector_square_edit" . "\xf18d9")
    ("nf-md-vector_square_minus" . "\xf18da")
    ("nf-md-vector_square_open" . "\xf1858")
    ("nf-md-vector_square_plus" . "\xf18db")
    ("nf-md-vector_square_remove" . "\xf18dc")
    ("nf-md-vector_triangle" . "\xf0563")
    ("nf-md-vector_union" . "\xf0564")
    ("nf-md-vhs" . "\xf0a1b")
    ("nf-md-vibrate" . "\xf0566")
    ("nf-md-vibrate_off" . "\xf0cd9")
    ("nf-md-video" . "\xf0567")
    ("nf-md-video_2d" . "\xf1a1c")
    ("nf-md-video_3d" . "\xf07fd")
    ("nf-md-video_3d_off" . "\xf13d9")
    ("nf-md-video_3d_variant" . "\xf0ed1")
    ("nf-md-video_4k_box" . "\xf083e")
    ("nf-md-video_account" . "\xf0919")
    ("nf-md-video_box" . "\xf00fd")
    ("nf-md-video_box_off" . "\xf00fe")
    ("nf-md-video_check" . "\xf1069")
    ("nf-md-video_check_outline" . "\xf106a")
    ("nf-md-video_high_definition" . "\xf152e")
    ("nf-md-video_image" . "\xf091a")
    ("nf-md-video_input_antenna" . "\xf083f")
    ("nf-md-video_input_component" . "\xf0840")
    ("nf-md-video_input_hdmi" . "\xf0841")
    ("nf-md-video_input_scart" . "\xf0f8c")
    ("nf-md-video_input_svideo" . "\xf0842")
    ("nf-md-video_marker" . "\xf19a9")
    ("nf-md-video_marker_outline" . "\xf19aa")
    ("nf-md-video_minus" . "\xf09b2")
    ("nf-md-video_minus_outline" . "\xf02ba")
    ("nf-md-video_off" . "\xf0568")
    ("nf-md-video_off_outline" . "\xf0bdb")
    ("nf-md-video_outline" . "\xf0bdc")
    ("nf-md-video_plus" . "\xf09b3")
    ("nf-md-video_plus_outline" . "\xf01d3")
    ("nf-md-video_stabilization" . "\xf091b")
    ("nf-md-video_switch" . "\xf0569")
    ("nf-md-video_switch_outline" . "\xf0790")
    ("nf-md-video_vintage" . "\xf0a1c")
    ("nf-md-video_wireless" . "\xf0ed2")
    ("nf-md-video_wireless_outline" . "\xf0ed3")
    ("nf-md-view_agenda" . "\xf056a")
    ("nf-md-view_agenda_outline" . "\xf11d8")
    ("nf-md-view_array" . "\xf056b")
    ("nf-md-view_array_outline" . "\xf1485")
    ("nf-md-view_carousel" . "\xf056c")
    ("nf-md-view_carousel_outline" . "\xf1486")
    ("nf-md-view_column" . "\xf056d")
    ("nf-md-view_column_outline" . "\xf1487")
    ("nf-md-view_comfy" . "\xf0e6a")
    ("nf-md-view_comfy_outline" . "\xf1488")
    ("nf-md-view_compact" . "\xf0e6b")
    ("nf-md-view_compact_outline" . "\xf0e6c")
    ("nf-md-view_dashboard" . "\xf056e")
    ("nf-md-view_dashboard_edit" . "\xf1947")
    ("nf-md-view_dashboard_edit_outline" . "\xf1948")
    ("nf-md-view_dashboard_outline" . "\xf0a1d")
    ("nf-md-view_dashboard_variant" . "\xf0843")
    ("nf-md-view_dashboard_variant_outline" . "\xf1489")
    ("nf-md-view_day" . "\xf056f")
    ("nf-md-view_day_outline" . "\xf148a")
    ("nf-md-view_gallery" . "\xf1888")
    ("nf-md-view_gallery_outline" . "\xf1889")
    ("nf-md-view_grid" . "\xf0570")
    ("nf-md-view_grid_outline" . "\xf11d9")
    ("nf-md-view_grid_plus" . "\xf0f8d")
    ("nf-md-view_grid_plus_outline" . "\xf11da")
    ("nf-md-view_headline" . "\xf0571")
    ("nf-md-view_list" . "\xf0572")
    ("nf-md-view_list_outline" . "\xf148b")
    ("nf-md-view_module" . "\xf0573")
    ("nf-md-view_module_outline" . "\xf148c")
    ("nf-md-view_parallel" . "\xf0728")
    ("nf-md-view_parallel_outline" . "\xf148d")
    ("nf-md-view_quilt" . "\xf0574")
    ("nf-md-view_quilt_outline" . "\xf148e")
    ("nf-md-view_sequential" . "\xf0729")
    ("nf-md-view_sequential_outline" . "\xf148f")
    ("nf-md-view_split_horizontal" . "\xf0bcb")
    ("nf-md-view_split_vertical" . "\xf0bcc")
    ("nf-md-view_stream" . "\xf0575")
    ("nf-md-view_stream_outline" . "\xf1490")
    ("nf-md-view_week" . "\xf0576")
    ("nf-md-view_week_outline" . "\xf1491")
    ("nf-md-vimeo" . "\xf0577")
    ("nf-md-violin" . "\xf060f")
    ("nf-md-virtual_reality" . "\xf0894")
    ("nf-md-virus" . "\xf13b6")
    ("nf-md-virus_off" . "\xf18e1")
    ("nf-md-virus_off_outline" . "\xf18e2")
    ("nf-md-virus_outline" . "\xf13b7")
    ("nf-md-vlc" . "\xf057c")
    ("nf-md-voicemail" . "\xf057d")
    ("nf-md-volcano" . "\xf1a83")
    ("nf-md-volcano_outline" . "\xf1a84")
    ("nf-md-volleyball" . "\xf09b4")
    ("nf-md-volume_high" . "\xf057e")
    ("nf-md-volume_low" . "\xf057f")
    ("nf-md-volume_medium" . "\xf0580")
    ("nf-md-volume_minus" . "\xf075e")
    ("nf-md-volume_mute" . "\xf075f")
    ("nf-md-volume_off" . "\xf0581")
    ("nf-md-volume_plus" . "\xf075d")
    ("nf-md-volume_source" . "\xf1120")
    ("nf-md-volume_variant_off" . "\xf0e08")
    ("nf-md-volume_vibrate" . "\xf1121")
    ("nf-md-vote" . "\xf0a1f")
    ("nf-md-vote_outline" . "\xf0a20")
    ("nf-md-vpn" . "\xf0582")
    ("nf-md-vuejs" . "\xf0844")
    ("nf-md-vuetify" . "\xf0e6d")
    ("nf-md-walk" . "\xf0583")
    ("nf-md-wall" . "\xf07fe")
    ("nf-md-wall_fire" . "\xf1a11")
    ("nf-md-wall_sconce" . "\xf091c")
    ("nf-md-wall_sconce_flat" . "\xf091d")
    ("nf-md-wall_sconce_flat_outline" . "\xf17c9")
    ("nf-md-wall_sconce_flat_variant" . "\xf041c")
    ("nf-md-wall_sconce_flat_variant_outline" . "\xf17ca")
    ("nf-md-wall_sconce_outline" . "\xf17cb")
    ("nf-md-wall_sconce_round" . "\xf0748")
    ("nf-md-wall_sconce_round_outline" . "\xf17cc")
    ("nf-md-wall_sconce_round_variant" . "\xf091e")
    ("nf-md-wall_sconce_round_variant_outline" . "\xf17cd")
    ("nf-md-wallet" . "\xf0584")
    ("nf-md-wallet_giftcard" . "\xf0585")
    ("nf-md-wallet_membership" . "\xf0586")
    ("nf-md-wallet_outline" . "\xf0bdd")
    ("nf-md-wallet_plus" . "\xf0f8e")
    ("nf-md-wallet_plus_outline" . "\xf0f8f")
    ("nf-md-wallet_travel" . "\xf0587")
    ("nf-md-wallpaper" . "\xf0e09")
    ("nf-md-wan" . "\xf0588")
    ("nf-md-wardrobe" . "\xf0f90")
    ("nf-md-wardrobe_outline" . "\xf0f91")
    ("nf-md-warehouse" . "\xf0f81")
    ("nf-md-washing_machine" . "\xf072a")
    ("nf-md-washing_machine_alert" . "\xf11bc")
    ("nf-md-washing_machine_off" . "\xf11bd")
    ("nf-md-watch" . "\xf0589")
    ("nf-md-watch_export" . "\xf058a")
    ("nf-md-watch_export_variant" . "\xf0895")
    ("nf-md-watch_import" . "\xf058b")
    ("nf-md-watch_import_variant" . "\xf0896")
    ("nf-md-watch_variant" . "\xf0897")
    ("nf-md-watch_vibrate" . "\xf06b1")
    ("nf-md-watch_vibrate_off" . "\xf0cda")
    ("nf-md-water" . "\xf058c")
    ("nf-md-water_alert" . "\xf1502")
    ("nf-md-water_alert_outline" . "\xf1503")
    ("nf-md-water_boiler" . "\xf0f92")
    ("nf-md-water_boiler_alert" . "\xf11b3")
    ("nf-md-water_boiler_off" . "\xf11b4")
    ("nf-md-water_check" . "\xf1504")
    ("nf-md-water_check_outline" . "\xf1505")
    ("nf-md-water_circle" . "\xf1806")
    ("nf-md-water_minus" . "\xf1506")
    ("nf-md-water_minus_outline" . "\xf1507")
    ("nf-md-water_off" . "\xf058d")
    ("nf-md-water_off_outline" . "\xf1508")
    ("nf-md-water_opacity" . "\xf1855")
    ("nf-md-water_outline" . "\xf0e0a")
    ("nf-md-water_percent" . "\xf058e")
    ("nf-md-water_percent_alert" . "\xf1509")
    ("nf-md-water_plus" . "\xf150a")
    ("nf-md-water_plus_outline" . "\xf150b")
    ("nf-md-water_polo" . "\xf12a0")
    ("nf-md-water_pump" . "\xf058f")
    ("nf-md-water_pump_off" . "\xf0f93")
    ("nf-md-water_remove" . "\xf150c")
    ("nf-md-water_remove_outline" . "\xf150d")
    ("nf-md-water_sync" . "\xf17c6")
    ("nf-md-water_thermometer" . "\xf1a85")
    ("nf-md-water_thermometer_outline" . "\xf1a86")
    ("nf-md-water_well" . "\xf106b")
    ("nf-md-water_well_outline" . "\xf106c")
    ("nf-md-waterfall" . "\xf1849")
    ("nf-md-watering_can" . "\xf1481")
    ("nf-md-watering_can_outline" . "\xf1482")
    ("nf-md-watermark" . "\xf0612")
    ("nf-md-wave" . "\xf0f2e")
    ("nf-md-waveform" . "\xf147d")
    ("nf-md-waves" . "\xf078d")
    ("nf-md-waves_arrow_left" . "\xf1859")
    ("nf-md-waves_arrow_right" . "\xf185a")
    ("nf-md-waves_arrow_up" . "\xf185b")
    ("nf-md-waze" . "\xf0bde")
    ("nf-md-weather_cloudy" . "\xf0590")
    ("nf-md-weather_cloudy_alert" . "\xf0f2f")
    ("nf-md-weather_cloudy_arrow_right" . "\xf0e6e")
    ("nf-md-weather_cloudy_clock" . "\xf18f6")
    ("nf-md-weather_fog" . "\xf0591")
    ("nf-md-weather_hail" . "\xf0592")
    ("nf-md-weather_hazy" . "\xf0f30")
    ("nf-md-weather_hurricane" . "\xf0898")
    ("nf-md-weather_lightning" . "\xf0593")
    ("nf-md-weather_lightning_rainy" . "\xf067e")
    ("nf-md-weather_night" . "\xf0594")
    ("nf-md-weather_night_partly_cloudy" . "\xf0f31")
    ("nf-md-weather_partly_cloudy" . "\xf0595")
    ("nf-md-weather_partly_lightning" . "\xf0f32")
    ("nf-md-weather_partly_rainy" . "\xf0f33")
    ("nf-md-weather_partly_snowy" . "\xf0f34")
    ("nf-md-weather_partly_snowy_rainy" . "\xf0f35")
    ("nf-md-weather_pouring" . "\xf0596")
    ("nf-md-weather_rainy" . "\xf0597")
    ("nf-md-weather_snowy" . "\xf0598")
    ("nf-md-weather_snowy_heavy" . "\xf0f36")
    ("nf-md-weather_snowy_rainy" . "\xf067f")
    ("nf-md-weather_sunny" . "\xf0599")
    ("nf-md-weather_sunny_alert" . "\xf0f37")
    ("nf-md-weather_sunny_off" . "\xf14e4")
    ("nf-md-weather_sunset" . "\xf059a")
    ("nf-md-weather_sunset_down" . "\xf059b")
    ("nf-md-weather_sunset_up" . "\xf059c")
    ("nf-md-weather_tornado" . "\xf0f38")
    ("nf-md-weather_windy" . "\xf059d")
    ("nf-md-weather_windy_variant" . "\xf059e")
    ("nf-md-web" . "\xf059f")
    ("nf-md-web_box" . "\xf0f94")
    ("nf-md-web_cancel" . "\xf1790")
    ("nf-md-web_check" . "\xf0789")
    ("nf-md-web_clock" . "\xf124a")
    ("nf-md-web_minus" . "\xf10a0")
    ("nf-md-web_off" . "\xf0a8e")
    ("nf-md-web_plus" . "\xf0033")
    ("nf-md-web_refresh" . "\xf1791")
    ("nf-md-web_remove" . "\xf0551")
    ("nf-md-web_sync" . "\xf1792")
    ("nf-md-webcam" . "\xf05a0")
    ("nf-md-webcam_off" . "\xf1737")
    ("nf-md-webhook" . "\xf062f")
    ("nf-md-webpack" . "\xf072b")
    ("nf-md-webrtc" . "\xf1248")
    ("nf-md-wechat" . "\xf0611")
    ("nf-md-weight" . "\xf05a1")
    ("nf-md-weight_gram" . "\xf0d3f")
    ("nf-md-weight_kilogram" . "\xf05a2")
    ("nf-md-weight_lifter" . "\xf115d")
    ("nf-md-weight_pound" . "\xf09b5")
    ("nf-md-whatsapp" . "\xf05a3")
    ("nf-md-wheel_barrow" . "\xf14f2")
    ("nf-md-wheelchair" . "\xf1a87")
    ("nf-md-wheelchair_accessibility" . "\xf05a4")
    ("nf-md-whistle" . "\xf09b6")
    ("nf-md-whistle_outline" . "\xf12bc")
    ("nf-md-white_balance_auto" . "\xf05a5")
    ("nf-md-white_balance_incandescent" . "\xf05a6")
    ("nf-md-white_balance_iridescent" . "\xf05a7")
    ("nf-md-white_balance_sunny" . "\xf05a8")
    ("nf-md-widgets" . "\xf072c")
    ("nf-md-widgets_outline" . "\xf1355")
    ("nf-md-wifi" . "\xf05a9")
    ("nf-md-wifi_alert" . "\xf16b5")
    ("nf-md-wifi_arrow_down" . "\xf16b6")
    ("nf-md-wifi_arrow_left" . "\xf16b7")
    ("nf-md-wifi_arrow_left_right" . "\xf16b8")
    ("nf-md-wifi_arrow_right" . "\xf16b9")
    ("nf-md-wifi_arrow_up" . "\xf16ba")
    ("nf-md-wifi_arrow_up_down" . "\xf16bb")
    ("nf-md-wifi_cancel" . "\xf16bc")
    ("nf-md-wifi_check" . "\xf16bd")
    ("nf-md-wifi_cog" . "\xf16be")
    ("nf-md-wifi_lock" . "\xf16bf")
    ("nf-md-wifi_lock_open" . "\xf16c0")
    ("nf-md-wifi_marker" . "\xf16c1")
    ("nf-md-wifi_minus" . "\xf16c2")
    ("nf-md-wifi_off" . "\xf05aa")
    ("nf-md-wifi_plus" . "\xf16c3")
    ("nf-md-wifi_refresh" . "\xf16c4")
    ("nf-md-wifi_remove" . "\xf16c5")
    ("nf-md-wifi_settings" . "\xf16c6")
    ("nf-md-wifi_star" . "\xf0e0b")
    ("nf-md-wifi_strength_1" . "\xf091f")
    ("nf-md-wifi_strength_1_alert" . "\xf0920")
    ("nf-md-wifi_strength_1_lock" . "\xf0921")
    ("nf-md-wifi_strength_1_lock_open" . "\xf16cb")
    ("nf-md-wifi_strength_2" . "\xf0922")
    ("nf-md-wifi_strength_2_alert" . "\xf0923")
    ("nf-md-wifi_strength_2_lock" . "\xf0924")
    ("nf-md-wifi_strength_2_lock_open" . "\xf16cc")
    ("nf-md-wifi_strength_3" . "\xf0925")
    ("nf-md-wifi_strength_3_alert" . "\xf0926")
    ("nf-md-wifi_strength_3_lock" . "\xf0927")
    ("nf-md-wifi_strength_3_lock_open" . "\xf16cd")
    ("nf-md-wifi_strength_4" . "\xf0928")
    ("nf-md-wifi_strength_4_alert" . "\xf0929")
    ("nf-md-wifi_strength_4_lock" . "\xf092a")
    ("nf-md-wifi_strength_4_lock_open" . "\xf16ce")
    ("nf-md-wifi_strength_alert_outline" . "\xf092b")
    ("nf-md-wifi_strength_lock_open_outline" . "\xf16cf")
    ("nf-md-wifi_strength_lock_outline" . "\xf092c")
    ("nf-md-wifi_strength_off" . "\xf092d")
    ("nf-md-wifi_strength_off_outline" . "\xf092e")
    ("nf-md-wifi_strength_outline" . "\xf092f")
    ("nf-md-wifi_sync" . "\xf16c7")
    ("nf-md-wikipedia" . "\xf05ac")
    ("nf-md-wind_power" . "\xf1a88")
    ("nf-md-wind_power_outline" . "\xf1a89")
    ("nf-md-wind_turbine" . "\xf0da5")
    ("nf-md-wind_turbine_alert" . "\xf19ab")
    ("nf-md-wind_turbine_check" . "\xf19ac")
    ("nf-md-window_close" . "\xf05ad")
    ("nf-md-window_closed" . "\xf05ae")
    ("nf-md-window_closed_variant" . "\xf11db")
    ("nf-md-window_maximize" . "\xf05af")
    ("nf-md-window_minimize" . "\xf05b0")
    ("nf-md-window_open" . "\xf05b1")
    ("nf-md-window_open_variant" . "\xf11dc")
    ("nf-md-window_restore" . "\xf05b2")
    ("nf-md-window_shutter" . "\xf111c")
    ("nf-md-window_shutter_alert" . "\xf111d")
    ("nf-md-window_shutter_cog" . "\xf1a8a")
    ("nf-md-window_shutter_open" . "\xf111e")
    ("nf-md-window_shutter_settings" . "\xf1a8b")
    ("nf-md-windsock" . "\xf15fa")
    ("nf-md-wiper" . "\xf0ae9")
    ("nf-md-wiper_wash" . "\xf0da6")
    ("nf-md-wiper_wash_alert" . "\xf18df")
    ("nf-md-wizard_hat" . "\xf1477")
    ("nf-md-wordpress" . "\xf05b4")
    ("nf-md-wrap" . "\xf05b6")
    ("nf-md-wrap_disabled" . "\xf0bdf")
    ("nf-md-wrench" . "\xf05b7")
    ("nf-md-wrench_clock" . "\xf19a3")
    ("nf-md-wrench_outline" . "\xf0be0")
    ("nf-md-xamarin" . "\xf0845")
    ("nf-md-xml" . "\xf05c0")
    ("nf-md-xmpp" . "\xf07ff")
    ("nf-md-yahoo" . "\xf0b4f")
    ("nf-md-yeast" . "\xf05c1")
    ("nf-md-yin_yang" . "\xf0680")
    ("nf-md-yoga" . "\xf117c")
    ("nf-md-youtube" . "\xf05c3")
    ("nf-md-youtube_gaming" . "\xf0848")
    ("nf-md-youtube_studio" . "\xf0847")
    ("nf-md-youtube_subscription" . "\xf0d40")
    ("nf-md-youtube_tv" . "\xf0448")
    ("nf-md-yurt" . "\xf1516")
    ("nf-md-z_wave" . "\xf0aea")
    ("nf-md-zend" . "\xf0aeb")
    ("nf-md-zigbee" . "\xf0d41")
    ("nf-md-zip_box" . "\xf05c4")
    ("nf-md-zip_box_outline" . "\xf0ffa")
    ("nf-md-zip_disk" . "\xf0a23")
    ("nf-md-zodiac_aquarius" . "\xf0a7d")
    ("nf-md-zodiac_aries" . "\xf0a7e")
    ("nf-md-zodiac_cancer" . "\xf0a7f")
    ("nf-md-zodiac_capricorn" . "\xf0a80")
    ("nf-md-zodiac_gemini" . "\xf0a81")
    ("nf-md-zodiac_leo" . "\xf0a82")
    ("nf-md-zodiac_libra" . "\xf0a83")
    ("nf-md-zodiac_pisces" . "\xf0a84")
    ("nf-md-zodiac_sagittarius" . "\xf0a85")
    ("nf-md-zodiac_scorpio" . "\xf0a86")
    ("nf-md-zodiac_taurus" . "\xf0a87")
    ("nf-md-zodiac_virgo" . "\xf0a88")
    ))

(provide 'nerd-icons-data-mdicon)
;;; nerd-icons-data-mdicon.el ends here