/** VSys:$iflist.cc:0.0.3-024$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: iflist.cc; File version: 0.0.3-024
 */
/*
 * Simple test of iface's retrieval
 * Thanks to unknown authors out of Berkley University for their
 * code of Free BSD ifconfig utility which helps much
 */

#ifdef WIN32
#include <winsock2.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#ifdef __OS_SOLARIS_LIKE
#include <sys/sockio.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include "iflist.h"
#include "thr.h"
#include "config_ndsad.h"
#include "logger.h"
#include <iostream>
#include <vector>
#include <string>
#include <algorithm>

#include "debug.h"
#include "ldefs.h"

std::vector<std::string> processing_devices;

int   if_count = 0; // Count of faces in progress
int   ifi_ios  = 0; // ioctl socket
int   ifl_dump = 0; // ioctl socket

__LOCK_DECL( ifi );
__LOCK_DECL( ifl );
__LOCK_DECL( ios );

__LOCK_DECL( findalldevs );

/*
 * ifl_family :
 *        Find device family for device `dname'.
 *        0 is returned if dname family not supported
 */

inline void ifl_free( if_list * ptr ) {
	if( ifl_pool ) {
		ifl_pool->put( MPH( ptr ) );
	} else
		delete ptr;
}

inline if_list * ifl_malloc() {
	if( ifl_pool ) {
		return ( if_list * ) ifl_pool->get();
	} else
		return new if_list;
}

iff_list * ifl_family( const char *dname ) {
	iff_list *face = faces;
	if (!face) return 0;
	if( !dname ) return 0;
	
#ifdef WIN32
	//if (strstr(dname,"NPF_GenericNdisWanAdapter") != 0) face++;
	return face;
#else
	// Find out dname's family
	while( face->iff_len ){
	 if( strncmp( face->iff_name, dname, face->iff_len )) {
		face++;
	 } else{
		goto END;
	};
	};
//	if( !face->iff_len ) return 0; // No family matches
END:
	return face;
#endif
}

/// New ifi_list. Fill vector with device names
void ifi_list_new(std::vector<std::string>& list){
	pcap_if_t * alldevsp;
	pcap_if_t * alldevsp_orig;
	char errbuf[PCAP_ERRBUF_SIZE];
    __LOCK(findalldevs);
	//DEB(printf( "findalldevs: ifi_list_new" ));
	    
	if(pcap_findalldevs(&alldevsp_orig, errbuf) == 0){
		alldevsp = alldevsp_orig;
		while(alldevsp){
			if(strcmp(alldevsp->name,"any") != 0 ){
        			// std::cout << "TMPNAME:" << alldevsp->name << std::endl;
				// std::string tmpname = alldevsp->name;
				// list.push_back(tmpname);
				list.push_back((std::string)alldevsp->name);
			}
			else
			{
        			// std::cout << "any found ! ignoring!" << std::endl;
			}
			alldevsp = alldevsp->next;
    		}
		pcap_freealldevs(alldevsp_orig);
	}
#ifdef __HAVE_ULOG 
#ifdef __OS_LINUX_LIKE
	list.push_back((std::string)"ulog_iface0");
#endif
#endif

#ifdef __HAVE_BSD_DIVERT
#ifdef __OS_BSD_LIKE
	list.push_back((std::string)"bsd_divert_iface0");
#endif
#endif
	__UNLOCK(findalldevs);
};

/// New ifi_count. Uses pcap_findalldevs
int ifi_count_new(){
	pcap_if_t * alldevsp;
    	char errbuf[PCAP_ERRBUF_SIZE];
    
	int if_count =0;
	if(pcap_findalldevs(&alldevsp, errbuf) == 0){
		while(alldevsp->next){
			if(strcmp(alldevsp->name,"any") != 0 ){
				if_count++;
			}else{
        			// std::cout << "any found ! ignoring!" << std::endl;
			};
        		alldevsp = alldevsp->next;
    		};
	};
	// std::cout << "ifi_count_new. count:" << if_count << std::endl;
	pcap_freealldevs(alldevsp);
	free(alldevsp);
	return if_count;
};

/*
 * ifl_iface :
 *      Makes an attempt to find device node for dname
 *      0 is returned on failure
 */

if_list * ifl_iface( const char * dname ) {
	iff_list *face = ifl_family( dname );
	 if_list *fc;
	if( !face ) return 0;
	if( !face->iff_if  ) return 0; // No devices in the family
	
__LOCK( ifl ); //XXX have to lock here!
	fc = face->iff_if;
	while( fc ) {
		if( strcmp( fc->ifl_name, dname )) {
			fc = fc->ifl_next;
		} else
			break;
	}
__UNLOCK( ifl );

	return fc;
}

/*
 * ifl_remove :
 *        Remove iface with supplied name from list of processed devices
 *        Return values:
 *           0 - Device not found
 *           1 - Device is removed
 *        If worker's pid is not zeroed device is left in the list
 */
int ifl_remove( const char * dname ) {
	iff_list *face = ifl_family( dname );
	 if_list *fc, *ftmp;
	if( !face ) {
		std::cout << "!face" << std::endl;
		return 0;
	};
	/*
	 * Now device family list is implemented as a list.
	 * May it be implemented as an array? If amount of devices
	 * in kernel is limited by a rather small (256 ex) integer
	 * it's better.
	 */	
	// if( !face->iff_if  ) return 0; // No devices in the family
	if( !face->iff_if  ){
		std::cout << "!face->iff_if" << std::endl;
		return 0; // No devices in the family
	};
	
__LOCK( ifl ); //XXX have to lock here!
	fc = 0;
	ftmp = face->iff_if;
	while( ftmp ) {
		// std::cout << "strncmp( ftmp->ifl_name:" << ftmp->ifl_name << " dname:" << dname << " ftmp->ifl_len:" << ftmp->ifl_len << std::endl;
		if( strncmp( ftmp->ifl_name, dname, ftmp->ifl_len )) {
			fc = ftmp;
			ftmp = ftmp->ifl_next;
		} else
			break;
	}
	// std::cout << " ftmp->ifl_pid: "<< ftmp->ifl_pid << std::endl;
	if( !ftmp || ftmp->ifl_pid ) {
		__UNLOCK( ifl );
        	// snprintf( buf, 128, "Halting on %s", ctime( &ts ) );
        	writelog( "!ftmp || ftmp->ifl_pid No device found or worker is alive" );

		// face->iff_if = 0;
		// if_count --;
		return 0; // No device found or worker is alive
	} 
	if( fc ) {
		// Device found and it's not first in the list
		fc->ifl_next = ftmp->ifl_next;
	} else 
		face->iff_if = 0;

	ifl_free( ftmp );
	if_count --;
__UNLOCK( ifl );

	return 1;
}

/*
 * Add device `dname' to proceeded device list.
 * If dname is too long ifl_add fails
 * If no family match occurs ifl_add fails
 * Return values:
 *     0 - ifl_add failed
 *     ptr to added - ifl_add succeeded
 */

if_list * ifl_add( const char * dname ) {
	iff_list *face = ifl_family( dname );
	 if_list *fc;
	u_int8_t len = strlen( dname );
	u_int16_t in = ifi_index( dname );
	if( in == IFI_BAD ) return 0;
	if( !face ) return 0;
	if( len > IFN_SIZE - 1 ) return 0; // Too long to store

	// See comment in ifl_remove
	fc = ifl_malloc();
	if( !fc ) return 0;
	fc->ifl_len = len;
	memcpy( fc->ifl_name, dname, len );
	fc->ifl_name[len] = '\0';
	fc->ifl_ind  = in;
	fc->ifl_ppp_offset = 0;
	fc->ifl_pid  = 0;
	
__LOCK( ifl ); //XXX have to lock here!
	if( !face->iff_nfc ) { 
		char logbuf[512];
		snprintf(logbuf, 512, "Creating NFC for <%s> family. dev <%s>", face->iff_name, dname);
		writelog(logbuf);

		face->iff_nfc = new nfc( face->iff_hash );
		if( !face->iff_nfc ) return 0;

		snprintf(logbuf, 512, "NFC created <0x%x>.", face->iff_nfc);
		writelog(logbuf);
		//FIXME: Have to clean up
	}
	fc->ifl_nfc  = face->iff_nfc;
	fc->ifl_next = face->iff_if;
	face->iff_if = fc;
	if_count ++;
__UNLOCK( ifl );
	DEB(printf( "Device `%s' added in `%s' family\n", 
				fc->ifl_name, face->iff_name));
	
	return fc;
}

/*
 * Updates information in NFC's in families.
 */

void ifl_update() {
	static int cnt = 0;
	int dump = 0;
	iff_list * face = faces;
	time_t ts = time( 0 );
	if( !face ) return;
	if( ifl_dump || cfg.stat && cfg.stat < cnt ) 
		dump = 1;
	while( face->iff_len ) {
		if( face->iff_nfc ) {
			DEB(printf( "Updating nfc for %s family\n", face->iff_name ));
			face->iff_nfc->update( ts, dump, face->iff_name );
		}
		face++;
	}
	if( dump ) {
		if(   nfpool )   nfpool->dump();
		if( ifl_pool ) ifl_pool->dump();
		cnt = 0;
		ifl_dump = 0;
		/// Dump vectors with devices list
		std::vector<std::string>::iterator iter_tmp = processing_devices.begin();
		for(;iter_tmp == processing_devices.end(); iter_tmp++){
			std::cerr << "STAT PROCESSING DEVICES:" << (*iter_tmp) << std::endl;
		};
		std::cerr << "STAT COUNT:" << processing_devices.size() << std::endl;
	}
	cnt++;
}

/*
 * ifl_halt 
 *   halts daemon - it cancels all threads and send all collected data
 */

void ifl_halt() {
	iff_list * face = faces;
	time_t ts = time( 0 );
	char buf[128];
	snprintf( buf, 128, "Halting on %s", ctime( &ts ) );
	writelog( buf );
	writelog( "Killing scaner thread..." );
	__LOCK( ifl );
	pthread_cancel( scaner_pid );
	if( !face ) goto clear;

	while( face->iff_len ) {
		snprintf( buf, 128, "Family `%s':", face->iff_name );
		if( face->iff_if ) writelog( buf );
		if_list * bptr, * tmp = face->iff_if;
		while( tmp ) {
			if( !tmp->ifl_pid ) goto loop;
			snprintf( buf, 128, "Killing `%s' thread...", tmp->ifl_name );
			writelog( buf );
			pthread_cancel( *tmp->ifl_pid );
			delete tmp->ifl_pid;
loop:
			bptr = tmp;
			tmp = tmp->ifl_next; 
			delete bptr;
		}
		if( face->iff_nfc ) {
			DEB(printf( "Updating nfc for %s family\n", face->iff_name ));
			face->iff_nfc->update( ts+60, 1, face->iff_name );
			delete face->iff_nfc;
			face->iff_nfc = 0;
		}
		face++;
	}
	if(   nfpool )   nfpool->dump();
	if( ifl_pool ) ifl_pool->dump();
clear:
	__UNLOCK( ifl );
	// Have I put something here?
}

#ifdef  TRAP_SIGSEGV
/*
 * ifl_panic :
 *    Qietly cleans up threads.
 *    Call to ifl_panic is performed from SIGSEGV trapper.
 *    Memory is still (and also VERY) durty after call returns.
 */

void ifl_panic() {
	iff_list * face = faces;
//	static int locked = 0;
	time_t ts;
//	if( !locked ) __LOCK( ifi );
//	locked = 1;
//	pthread_cancel( scaner_pid );
	if( !faces ) goto clear;

	for( face = faces; face->iff_len; face++ ) {
		for( if_list * tmp = face->iff_if; tmp; tmp = tmp->ifl_next )
			if( tmp->ifl_pid ) pthread_cancel( *tmp->ifl_pid );
	}
	writelog( "IFL_Panic: All threads cancelled..." );
	ts = time( 0 );
#ifdef SIGSEGV_SAVE_STATS
	for( face = faces; face->iff_len; face++ ) {
		if( face->iff_nfc )
			face->iff_nfc->update( ts+60
#ifdef  __DEBUG__
					, 1, face->iff_name
#endif//__DEBUG__
					);
	}
#endif// SIGSEGV_SAVE_STATS
clear:
	writelog( "IFL_Panic: Succeded..." );
//	__UNLOCK( ifl );
}
#endif//TRAP_SIGSEGV

                   /* IFI_ family */
/*
 * __ioctl_lock
 *       Schedule calls to ioctl. Simply locks mutex before and ulocks after
 *       ioctl call.
 */

#ifndef WIN32
inline int __ioctl_lock( int ios, u_int32_t sio, void * argp ) {
__LOCK( ios );
	int iores = ioctl( ios, sio, argp );
__UNLOCK( ios );
	return iores;
}
#endif

/*
 * ifi_ind tries to retrieve ifindex of device `dname'
 * IFI_BAD is returned on error
 *
 * There're two ways to call out ifindex in Free BSD.
 * One is to call for routing system.
 * Other is to retrieve multicast settings of iface.
 * Both are pretty tricky. Multicsting may be not supported.
 *
 * Fri Jan 24 22:32:10 MSK 2003
 *     Attempt of internal index distribution - a set of masks
 *     will be added. Each mask for an iface family - eth, tun, ...
 *     Ex eth10 would have index 10 | ETH_MASK or something like it.
 */
// Linux only!
u_int16_t ifi_index( const char * dname ) {
#if 0
#ifdef __OS_LINUX_LIKE
	ifreq ifr;
	if( !ifi_valid() )
		return IFI_BAD;
	
	strncpy( ifr.ifr_name, dname, IFN_SIZE );
	if( __ioctl_lock( ifi_ios, SIOCGIFINDEX, &ifr ) ) {
#ifdef __DEBUG__
		fprintf( stderr, "%s: ", dname );
		__rep_error( "ifi_index:\n\tioctl:", IFI_BAD );
#else
		return IFI_BAD;
#endif//__DEBUG__
	}

	return ifr.ifr_ifindex;
#endif//__OS_LINUX_LIKE
#endif
//	return if_nametoindex( dname );
	iff_list *face = ifl_family( dname );
	if( !face ) return IFI_BAD;

	u_int16_t subind = (u_int16_t ) atoi( (dname + face->iff_len) );
	return subind | face->iff_mask; 
}

#ifndef WIN32 // no need for ifi_ivp4, ifi_up and ivi_ifvalid on win32

/*
 * ifi_ipv4
 *     Check if `dname' is valid IPv4 device.
 *     If it does, retrieved IP address is returned.
 *     If not 0 is returned
 */

u_int32_t ifi_ipv4( const char * dname ) {
	ifreq ifr;
	u_int32_t addr = IFI_IP_BAD;
	sockaddr_in * sin;
	if( !ifi_valid() )
		return IFI_IP_FATAL;
	
	strncpy( ifr.ifr_name, dname, IFN_SIZE );
	if( __ioctl_lock( ifi_ios, SIOCGIFADDR, &ifr ) ) {
#ifdef __DEBUG__
		fprintf( stderr, "%s: ", dname );
		__rep_error( "ifi_ipv4:\n\tioctl:", IFI_IP_FATAL );
#else
		return IFI_IP_FATAL;
#endif//__DEBUG__
	}
	if( ifr.ifr_addr.sa_family == AF_INET ) {
		sin = (sockaddr_in *) &ifr.ifr_addr;
		addr = *((u_int32_t *)&(sin->sin_addr));
	}

	return addr;
}

/*
 * ifi_up - checks if device with supported name is up
 */
int ifi_up( const char * dname ) {
	ifreq ifr;
	if( !ifi_valid() )
		return 0;
	
	strncpy( ifr.ifr_name, dname, IFN_SIZE );
	if( __ioctl_lock( ifi_ios, SIOCGIFFLAGS, &ifr ) ) {
#ifdef __DEBUG__
		fprintf( stderr, "%s: ", dname );
		__rep_error( "ifi_up:\n\tioctl:", 0 );
#else
		return 0;
#endif//__DEBUG__
	}

	return (ifr.ifr_flags & IFF_UP)?1:0;
}

/*
 * ifi_ifvalid
 *       checks if device is configured.
 *       1 on success
 */

int ifi_ifvalid( const char * dname ) {
	ifreq ifr;
	if( !ifi_valid() )
		return 0;
	
	strncpy( ifr.ifr_name, dname, IFN_SIZE );
	if( __ioctl_lock( ifi_ios, SIOCGIFMTU, &ifr ) ) {
#ifdef __DEBUG__
		fprintf( stderr, "%s: ", dname );
		__rep_error( "ifi_ifvalid:\n\tioctl:", 0 );
#else
		return 0;
#endif//__DEBUG__
	}
	return 1;
}

/*
 * ifi_valid 
 *       checks if ifi_ios is valid file descriptor
 *       If not it tries to recover - open socket
 */
int ifi_valid() {

	if( ifi_ios > 0 ) return 1;

__LOCK( ifi ); //XXX have to lock here!
	ifi_ios = socket (AF_INET, SOCK_DGRAM, 0);
	if( ifi_ios == -1 ) {
		ifi_ios = 0;	   
		__UNLOCK( ifi );	
#ifdef __DEBUG__
		__rep_error( "ifi_valid:\n\tsocket:", 0 );
#else
		return 0;
#endif//__DEBUG__
	}
	__UNLOCK( ifi );	

	return 1;
}

#else


int ifi_ifvalid( const char * dname ) {
	// on win32 we just query winpcap
	// if iface is gone it's not in the lsit
	// no ioctls there !
	
	__LOCK(findalldevs);
	//DEB(printf( "findalldevs: ifi_ifvalid" ));
	
	pcap_if_t * alldevsp;
	pcap_if_t * alldevsp_orig;
	char errbuf[PCAP_ERRBUF_SIZE];
    
	if(pcap_findalldevs(&alldevsp_orig, errbuf) == 0){
		alldevsp = alldevsp_orig;
		while(alldevsp->next) 
		{
			if (strcmp(alldevsp->name,dname) == 0 )
			{
				pcap_freealldevs(alldevsp_orig);
				__UNLOCK(findalldevs);
				return 1;
			}
			alldevsp=alldevsp->next;
		}
	}
	__UNLOCK(findalldevs);
	pcap_freealldevs(alldevsp_orig);
	return 0;	
}
#endif  // WIN32

#if 0 
/*
 * ifi_count returns number of Up devices
 * On error -1 is returned
 */
#ifdef __OS_BSD_LIKE
# include <net/route.h>
# include <sys/sysctl.h>
# include <net/if_dl.h>
#endif

#ifdef  __OS_BSD_LIKE
int ifi_count( void ** user ) {
#else
int ifi_count( void **      ) {
#endif
#ifdef  __OS_BSD_LIKE
	static __LOCK_DECL( ifi_rt );
	static int icnt = 0;
	int ntry = 0;
//	static int mib[6] = { CTL_NET, PF_ROUTE, 0, 0, NET_RT_IFLIST, 0};
	int mib[6];
	u_int32_t needed;
	static char *buf = NULL;
	static u_int32_t buf_size = 0;
	char *next;
	if_name * names;
	struct rt_msghdr *rtm;
	struct if_msghdr *ifm;
	struct sockaddr_dl *dl;
	__LOCK( ifi_rt );

	mib[0] = CTL_NET;
	mib[1] = PF_ROUTE;
	mib[2] = 0;             /* protocol */
	mib[3] = 0;             /* wildcard address family */
	mib[4] = NET_RT_IFLIST;
	mib[5] = 0;             /* no flags */
	if( user ) {
		((if_name *)(*user)) = buf;
		__UNLOCK( ifi_rt );
		DEB(printf("ifi_count: old info returned to caller...\n"));
		return icnt;
	}
	icnt = 0;
	do {
		/*
		 * We'll try to get addresses several times in case that
		 * the number of addresses is unexpectedly increased during
		 * the two sysctl calls.  This should rarely happen, but we'll
		 * try to do our best for applications that assume success of
		 * this library (which should usually be the case).
		 * Portability note: since FreeBSD does not add margin of
		 * memory at the first sysctl, the possibility of failure on
		 * the second sysctl call is a bit higher.
		 */

		if (sysctl(mib, 6, NULL, &needed, NULL, 0) < 0) {
			__UNLOCK( ifi_rt );
			return (-1);
		}
		if( needed > buf_size ) {
			delete buf;
			if ((buf = new char[needed]) == NULL) {
				__UNLOCK( ifi_rt );
				return (-1);
			}
			buf_size = needed;
		}
		if (sysctl(mib, 6, buf, &needed, NULL, 0) < 0) {
			if (++ntry >= 5) {
				__UNLOCK( ifi_rt );
				return (-1);
			}
		} 
	} while (buf == NULL);
	names = (if_name *) buf;

	for (next = buf; next < buf + needed; ) {
		rtm = (struct rt_msghdr *)(void *)next;
		next += rtm->rtm_msglen;
		if (rtm->rtm_version != RTM_VERSION)
			continue;
		if (rtm->rtm_type == RTM_IFINFO ) {
			ifm = ( if_msghdr * ) rtm;
			/*
			 * Skip over unnamed devices.
			 */
			if( !(ifm->ifm_addrs & RTA_IFP ))
				continue;
			dl = (sockaddr_dl *)(ifm+1);
			memset(names[icnt].ifn_name, 0, IFN_SIZE);
			memcpy(names[icnt].ifn_name,dl->sdl_data, dl->sdl_nlen);
//printf("Device: `%s' nlen: %d\nNames[...]: %s\n", dl->sdl_data, dl->sdl_nlen, names[icnt].ifn_name);
			++icnt;
		}
	}
	__UNLOCK( ifi_rt );
	return (icnt);
#else//!__OS_BSD_LIKE

#ifdef WIN32
	return 1;
#else
	ifconf conf;
	if( !ifi_valid() )
		return -1;

//__LOCK( ifi ); //XXX have to lock here!
	conf.ifc_buf = 0;
	conf.ifc_len = 0;

	// Get device count
	if( __ioctl_lock (ifi_ios , SIOCGIFCONF, &conf) < 0) {
//		__UNLOCK( ifi );
#ifdef __DEBUG__
		__rep_error( "ifi_count:\n\tioctl:", -1 );
#else
		return -1;
#endif//__DEBUG__
	}
//__UNLOCK( ifi );

	return (conf.ifc_len/sizeof( struct ifreq ));
#endif//__OS_BSD_LIKE

#endif//WIN32
}

/*
 * ifi_list
 * Returns list of devices currently up
 * if _ls is 0 then no locking will be done
 */

#ifndef WIN32

#ifdef __OS_BSD_LIKE
void * ifi_list( const int     ) {
#else
void * ifi_list( const int _ls ) {
#endif
//ifconf * ifi_list() {
#ifdef __OS_BSD_LIKE
	struct if_name * names;
	ifi_count( (void **) &names );
	return names;
#else
	int ifnum = ifi_count();
	if( ifnum < 0 )
	   return 0;
	static ifconf conf = { 0, { 0 } };
	if( !ifi_valid() )
		return 0;

	if( _ls ) __LOCK( ifi ); //XXX have to lock here!
	if( conf.ifc_len < ifnum * ((int) sizeof( ifreq )) ) {
		delete conf.ifc_buf;
		conf.ifc_len = ifnum * sizeof( ifreq );
		conf.ifc_buf = new char[ conf.ifc_len ];
	}

	DEB(printf("ifi_list: %d devices.\n", ifnum ));
	if( __ioctl_lock (ifi_ios , SIOCGIFCONF, &conf) < 0) {
		if( _ls ) __UNLOCK( ifi );
#ifdef  __DEBUG__
		__rep_error( "ifi_list:\n\tioctl:", 0 );
#else
		return 0;
#endif//__DEBUG__
	}
#ifdef  __DEBUG__
	for( ; ifnum > 0; ifnum-- )
		fprintf( stdout, "> %s\n", conf.ifc_req[ifnum-1].ifr_name );
#endif//__DEBUG__
	if( _ls ) __UNLOCK( ifi );

	return &conf;
#endif//__OS_BSD_LIKE
}

#endif

#endif
/*
 * ifi_update
 *      Method to check if all interfaces are in `faces'
 */

int ifi_update() {
__LOCK( ifi );
	int npf_dialup_found = 0;
	std::vector<std::string>::iterator iter = processing_devices.begin();
	for(;iter != processing_devices.end(); iter++){
		if((*iter).find("NPF_GenericDialupAdapter")){
			npf_dialup_found=1;
		};
	};

	/// Obtain current active devices
	std::vector<std::string> cur_active_list;
	if(npf_dialup_found){
		/// WIN32 mega hack:
		/// We can't call pcap_findalldevs twice if we have NPF_GenericDialupAdapter.
		/// Please contacts us if you have information about this bug (?) - info@netup.ru
		cur_active_list = processing_devices;
	}else{
		ifi_list_new(cur_active_list);
	};

	if (cur_active_list.size() == processing_devices.size()){
		ifl_update();
		__UNLOCK( ifi );
		return 0;
	};

	/// New devices or some devices down
	//
	/// First add new devices
	char buf[128];
	for( iter = cur_active_list.begin(); iter != cur_active_list.end(); iter++ ) {
		std::vector<std::string>::iterator iter_tmp;
		iter_tmp = find(processing_devices.begin(), processing_devices.end(), (*iter));
		if(iter_tmp == processing_devices.end()){
			/// new devices found
			snprintf( buf, 128, "`%s': new device", (*iter).c_str());
			writelog( buf );
			init_worker( (char*)(*iter).c_str() );
			processing_devices.push_back((*iter));
		};
	};

	/// Then remove down ifaces
	std::vector<std::string> need_del;
	for( iter = processing_devices.begin(); iter != processing_devices.end(); iter++ ) {
		std::vector<std::string>::iterator iter_tmp;
		iter_tmp = find(cur_active_list.begin(), cur_active_list.end(), (*iter));
		if(iter_tmp == cur_active_list.end()){
			/// Down iface found. Remove it.
			need_del.push_back((*iter));
		};
	};

	/// Really delete down ifaces
	for( iter = need_del.begin(); iter != need_del.end(); iter++ ) {
        	snprintf( buf, 128, "Trying to delete device %s from list", (*iter).c_str());
        	writelog( buf );
		int res;
		res = ifl_remove((char*)(*iter).c_str());
        	snprintf( buf, 128, "Delete result: %d ", res );
        	writelog( buf );
		std::vector<std::string>::iterator iter_tmp = find(processing_devices.begin(), processing_devices.end(), (*iter));
		if(iter_tmp != processing_devices.end()){
			processing_devices.erase(iter_tmp);
		};
	};

	ifl_update();
	DEB(print_faces());
__UNLOCK( ifi ); 
	return 1;
};

	/* if( !faces ) return 0;
	int count = ifi_count_new();
	DEB(printf( "%d devices found, %d devices are in work\n", count, if_count));
	char buf[128];
	
__LOCK( ifi );
	if( count == if_count ) {
		// IFace count has not changed
		ifl_update();
		__UNLOCK( ifi );
		return 0;
	}
	/// Obtain current active devices
	std::vector<std::string> list;
	ifi_list_new(list);
	std::vector<std::string>::iterator iter;
	std::vector<std::string>::iterator iter_proc;

	/// Some devices down
	if( count < if_count ) {
		/// Found removed devices
		for( iter_proc = processing_devices.begin(); iter_proc != processing_devices.end() ; iter_proc++ ) {
			std::string deleted_name = (*iter_proc);
			std::cout << "Device found in internal list:" << deleted_name << std::endl;
			iter = find(list.begin(),list.end(),deleted_name);
			if(iter == list.end()){
				/// Remove if not found in current active list
				std::cout << "Trying to delete device " << deleted_name << " from list." << std::endl;
				int res;
				res = ifl_remove(deleted_name.c_str());
				std::cout << "Delete result:" << res << std::endl;
				processing_devices.erase(iter_proc);
			};
		};
		// __UNLOCK( ifi );
		// return 1;
	}

	/// Rotate found devices and add if new
	snprintf( buf, 256, "Some new devices found" );
	writelog( buf );
	char * name;
	for( iter = list.begin(); iter != list.end(); iter++ ) {
		name = (char*)(*iter).c_str();
		if( !ifl_iface( name ) ) {
			snprintf( buf, 256, "`%s': new device", name );
			writelog( buf );
			init_worker( name );
			std::string tmp_name = name;
			processing_devices.push_back(tmp_name);
		}
	} 

	ifl_update();
	DEB(print_faces());

__UNLOCK( ifi ); */
