/* sithwm - Minimalist Window Manager for X
 * see README for Copyright, license and other details. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "sithwm.h"
#include <ctype.h>

static int min(int x, int y) {return x<y?x:y;}

#if DEATHSTAR
Application *head_app;
#endif
unsigned int setmodifiers[FUNC_MAX];
int min_size_for_func[FUNC_MAX];

#define NO_PARAMS 2
#define NO_STRINGS 2

struct func {
   unsigned int mask;
   char *strings[NO_STRINGS];
   int params[NO_PARAMS];
};

struct Cmd {
   struct Cmd *links[2];
   KeySym key;
   unsigned int modmask;
   struct func func;
   char flags;
}*action_menu;

static struct Cmd*function_keys;

void func_grab(Window w)
{
   for (struct Cmd* ff = function_keys; ff; ff=ff->links[0]) {
      for (unsigned i=0; i<4 ; i++) {
	 unsigned int mask = ff->modmask|(i&1?LockMask:0)|(i&2?numlockmask:0);
	 unsigned int butt = ff->key-XK_Pointer_Button1 + Button1;
	 if (butt>=Button1&&butt<=(Button1+8)) {
	    XGrabButton(dpy, butt, mask,
			w, False, ButtonPressMask, GrabModeAsync, GrabModeSync, None, None);
	 }
	 KeyCode keycode = XKeysymToKeycode(dpy, ff->key);
	 if (keycode)
	    XGrabKey(dpy, keycode, mask,
		     w, True, GrabModeAsync, GrabModeAsync);
      }
   }
}

const struct masktab funcmasks[] = {
   { "sh", FUNC_SPAWN<<FUNC_SHIFT},
   { "menu", FUNC_MENU<<FUNC_SHIFT},
   { "pan", FUNC_PAN<<FUNC_SHIFT},
   { "next", FUNC_NEXT<<FUNC_SHIFT},
   { "circulate", FUNC_CIRCUL<<FUNC_SHIFT},
   { "hist", (FUNC_HIST<<FUNC_SHIFT)|FMOD_RAISE},
   { "view_hist", (FUNC_VIEW_HIST<<FUNC_SHIFT)|FMOD_RAISE},
   { "kill", FUNC_KILL<<FUNC_SHIFT},
   { "lower", FUNC_LOWER<<FUNC_SHIFT},
   { "enter", XACT_ENTER<<FUNC_SHIFT},
   { "new", XACT_NEW<<FUNC_SHIFT},
   { "deleted", XACT_DELETED<<FUNC_SHIFT},
   { "resize", (FUNC_RESIZE<<FUNC_SHIFT) | FMOD_RAISE},
   { "move", (FUNC_MOVE<<FUNC_SHIFT) | FMOD_RAISE},
   { "drag", FUNC_DRAGRESIZE<<FUNC_SHIFT },
   { "next_screen", FUNC_NEXT_SCREEN<<FUNC_SHIFT },
   { "set_view", FMOD_SET_VIEW},
   { "raise", FMOD_RAISE},
   { "mouse", FMOD_SETMOUSE},
   { "focus", FMOD_FOCUS},
   { "maxim", FMOD_MAXIMISE},
   { "fix", FMOD_FIX},
   { "info", FMOD_INFO},
   { "abs", FMOD_ABS},
   { "view", FMOD_VIEW},
   { "popup", FMOD_POPUP},
   { "local", FMOD_LOCAL},
   { 0, 0}
};

#define FUNC_MASK (-1U<<FUNC_SHIFT)
#ifdef DEBUG
void prt_mask(unsigned int mask, const struct masktab*t) {
   for (const struct masktab*z = t; z->name; z++)
      if ( !((z->mask ^ mask) & FUNC_MASK)) {
	 LOG_DEBUG(z->name);
	 break;
      }
   for (const struct masktab*z = t; z->name; z++)
      if ( (z->mask&FUNC_MASK)==0 && (z->mask & mask))
	 LOG_DEBUG(",%s", z->name);
}
#endif

static struct rowdef {int width;int yoffs;} rowdef_a[20], *current_row_level=rowdef_a;

void perform_func(ScreenInfo*screen, struct Cmd*ff, XEvent*e)
{
   Client *c = head_client;
   struct pos d = {ff->func.params[0],ff->func.params[1]};
   unsigned int func = ff->func.mask >> FUNC_SHIFT;
   static unsigned int locmask;
   locmask = ff->func.mask | setmodifiers[func];
   LOG_DEBUG("F:%p ", c);
   prt_mask(func, funcmasks);
   LOG_DEBUG("\n");
   if (locmask&FMOD_VIEW) {
      // place_client(c);
      d.x *= screen->area.w;
      d.y *= screen->area.h;
   }
   if (func<FUNC_MENU) {
      if (!c) return;
      if (func<FUNC_NEXT && e->xany.window != c->dyn.window)
	 return;
   }

   switch(func) {
   case FUNC_NEXT_SCREEN:
      if (++current_screen>=(screens+num_screens))
         current_screen = screens;
      XWarpPointer(dpy, None, current_screen->root, 0, 0, 0, 0,
		   current_screen->last_pos.x, current_screen->last_pos.y);
      break;
   case FUNC_SPAWN:
      spawn(ff->func.strings[1]);
      break;
#ifndef STORMTROOPER
   case FUNC_MENU:
      if (d.x>=0)
	 current_row_level = rowdef_a + d.x;
      do_menu(screen, e);
      break;
#endif
   case FUNC_PAN: {
      if (locmask&FMOD_ABS) {
	 screen->area.pos = d;
      }
      else {
	 screen->area.pos.x += d.x>>2;
	 screen->area.pos.y += d.y>>2;
      }
      goto clean_hilit;
   }
   case FUNC_NEXT: {
      Client *curr = find_client(screen->hilit);
      Client *foundc = c;
      if (!curr) curr = c;
      local_popup_list = locmask & FMOD_LOCAL;
      for (c = curr ; ; ) {
	 c = c->next;
	 if (!c) c = head_client;
	 if (c == curr) break;
	 if (c->screen == screen &&
	     ( !local_popup_list || intersect(&screen->area, &c->dyn.area)) ) {
            foundc = c;
            if ( !ff->func.params[0] )
               break;
         }
      }
      screen->hilit_funcmask = locmask;
      screen->hilit = foundc->dyn.window;
      goto update_hilit;
   }
   case FUNC_CIRCUL: {
      Client *ic;
      int maxc=d.x-2;
      for (ic = c->next ; ic ; ic = ic->next) {
	 if ( ic->screen == current_screen &&
	      (ic->dyn.area.w+ic->dyn.area.h) > d.y &&
              (ic->dyn.sticky || intersect(&current_screen->area, &ic->dyn.area)) ) {
            c=ic;
            maxc--;
            if (maxc<0)
               break;
         }
      }
   }break;
#ifndef STORMTROOPER
   case FUNC_VIEW_HIST:
      screen->hist_index = (screen->hist_index+VIEW_HISTORY+ff->func.params[0])%VIEW_HISTORY;
      screen->area.pos = screen->hist[screen->hist_index];
      break;
   case FUNC_HIST:
      c->hist_index = (c->hist_index+HISTORY+d.x)%HISTORY;
      if (c->hist[c->hist_index].w>0)
	 c->dyn.area = c->hist[c->hist_index];
      break;
#endif
   case FUNC_KILL: {
      int i, n, found = 0;
      Atom *protocols;

      if (!(locmask&FMOD_ABS) && XGetWMProtocols(dpy, c->dyn.window, &protocols, &n)) {
	 for (i = 0; i < n; i++)
	    if (protocols[i] == xa_wm_delete)
	       found++;
	 XFree(protocols);
      }
      if (found) {
	 XEvent ev;
	 ev.type = ClientMessage;
	 ev.xclient.window = c->dyn.window;
	 ev.xclient.message_type = xa_wm_protos;
	 ev.xclient.format = 32;
	 ev.xclient.data.l[0] = xa_wm_delete;
	 ev.xclient.data.l[1] = CurrentTime;
	 XSendEvent(dpy, c->dyn.window, False, NoEventMask, &ev);
      } else
	 XKillClient(dpy, c->dyn.window);
   } break;
   case FUNC_LOWER:
      XLowerWindow(dpy, c->dyn.window);
      break;
   case FUNC_RESIZE:
      c->dyn.area.w += d.x;
      c->dyn.area.h += d.y;
      break;
   case FUNC_DRAGRESIZE:
      dragsweep.fl = ff->func.params[0];
      if ( XGrabPointer(dpy, e->xbutton.root, False,
                        ButtonReleaseMask|PointerMotionMask,
                        GrabModeAsync, GrabModeAsync,
			None, None, CurrentTime) != GrabSuccess) break;
      dragsweep.c = c;
      dragsweep.pos.x = c->screen->area.pos.x - e->xbutton.x;
      dragsweep.pos.y = c->screen->area.pos.y - e->xbutton.y;
      if (dragsweep.fl) {
	 dragsweep.pos.x += c->dyn.area.w;
	 dragsweep.pos.y += c->dyn.area.h;
      }
      break;
   case FUNC_MOVE:
      if (locmask&FMOD_ABS) {
	 if (locmask&FMOD_VIEW) {
	    c->dyn.area.pos = d;
	    c->last_screen = d;
	 } else {
	    if (d.x<0)
	       d.x += screen->area.w - c->dyn.area.w;
	    c->dyn.area.pos.x = screen->area.pos.x+d.x;
	    if (d.y<0)
	       d.y += screen->area.h - c->dyn.area.h;
	    c->dyn.area.pos.y = screen->area.pos.y+d.y;
	 }
      } else {
	 c->dyn.area.pos.x += d.x;
	 c->dyn.area.pos.y += d.y;
      }break;
   }

   if (screen->infow_func==INFOW_MAP) {
      /* View mode, but illegal key, so then we reset, could also
	 pop down .. */
   clean_hilit:
      screen->hilit = 0;
   update_hilit:
      if (locmask&FMOD_POPUP) {
	 screen->do_infow_func = INFOW_MAP;
      }
      else
	 select_window(screen->hilit, locmask);
      return;
   }

#ifndef STORMTROOPER
   if (locmask & FMOD_INFO) {
      last_current_info = 0;
      opt_qualify_caption |= 2;
      if (c)
	 c->dyn.opts |= FL_NAMED;
   }
#endif

   select_client(c, locmask);
}

void do_func(ScreenInfo *screen, XEvent*e, KeySym key)
{
   struct Cmd* ff;
   unsigned int mask = e->xkey.state & (~(LockMask|numlockmask));

   for (ff= function_keys; ff && (ff->key != key || ff->modmask != mask); ff=ff->links[0])
      ;

   if (ff)
      perform_func(screen, ff,e);
}

unsigned int parse_mask(char *strng, const struct masktab*t) {
   char *tmp;
   unsigned int ret = 0;
   for (;(tmp = strtok(strng, ",+"));)  {
      int found = 0;
      for (const struct masktab*z = t; z->name; z++) {
	 if (!strcmp(z->name, tmp)) {
	    found = 1;
	    ret |= z->mask;

            if (t->mask>=(FUNC_SPAWN<<FUNC_SHIFT) && !strng
                && z->mask>=(FUNC_SPAWN<<FUNC_SHIFT))
               LOG_ERROR("Err, Not a mask:%s %s %p %p\n", tmp, strng, tmp, strng);
	 }
      }
      if (!found) {
	 int iii;
	 if (sscanf(tmp, "%i", &iii) == 1) {
	    ret |= iii;
	 }
	 else
	    LOG_ERROR("Err mask:%s\n", tmp);
      }
      strng=0;
   }
   return ret;
}

struct masktab modifiers[] = {
   { "std", Mod4Mask},
   { "shift", ShiftMask},
   { "control", ControlMask},
   { "alt", Mod1Mask},
   { "mod1", Mod1Mask},
   { "mod2", Mod2Mask},
   { "mod3", Mod3Mask},
   { "mod4", Mod4Mask},
   { "mod5", Mod5Mask},
   { "0", 0},
   { 0, 0}
};

unsigned int parse_modifiers(char *s) {
   return parse_mask(s, modifiers);
}

static void freecmdsub(struct Cmd*t)
{
   free((t)->func.strings[0]);
   if ((t)->func.strings[0] != (t)->func.strings[1])
      free((t)->func.strings[1]);
}

static struct Cmd**recr[20] = {&action_menu};
static struct Cmd***recp = recr;

void parse_rc_line()
{
   struct Cmd*m = (struct Cmd*)calloc(1, sizeof *m);
   int ss=0, pass=0;
   int freem = 1;
   int freestrs = 1;
   struct area a;
   unsigned int mask;
   char*p=global_buffer;
   char ent_type[3] = "\0";
   for (;;) {
      for (;*p && *p<'!';p++)
	 ;
      char ttype = *p;
      if (!ttype)
	 break;
      char *start;
      if (ttype == '"') {
	 p++;
	 start = p;
	 char *ip = p;
	 for (; *p && *p != '"' && *p != '\n' ; ip++,p++) {
	    if (*p == '\\')
	       p++;
	    *ip = *p;
	 }
	 *ip = 0;
      } else {
	 start = p;
	 for (;*p && *p>'!';p++)
	    ;
	 *p=0;
      }
      p++;
      if (!ent_type[0]) {
	 ent_type[0] = start[0];
	 ent_type[1] = start[1];
	 ent_type[2] = start[2];
	 pass = 3;
	 switch (ent_type[0]) {
	 case 'v': case 'x': pass = 2; break;
	 case 'k': pass = 0; break;
	 }
      } else {
	 switch (pass) {
	 case 0:
	    // Got modifier.
	    LOG_DEBUG("key mod:%s\n", start);
	    m->modmask = parse_modifiers(start); break;
	 case 1:
	    m->key = XStringToKeysym(start);
	    if (m->key == 0)
	    {
	       if (start[0]=='P' && start[1]=='o')
		  m->key = start[14]-'1'+XK_Pointer_Button1;
	       else
		  LOG_ERROR("Err key:%s\n", start);
	    }
	    break;
	 case 2:
	    m->func.mask = parse_mask(start,funcmasks); break;
	 default:
	    {
	       if (ttype == '-')
		  ttype = start[1];
	       if (ttype>='0' && ttype<='9') {
		  int pp = pass-3-ss;
		  if (pp<NO_PARAMS)
		     m->func.params[pp] = atoi(start);
	       } else {
		  if (ss < NO_STRINGS && *start)
                     m->func.strings[ss] = strdup(start);
		  if (ss == 0) {
		     mask = XParseGeometry(start, &a.pos.x, &a.pos.y,
					   (unsigned int*)&a.w, (unsigned int*)&a.h);
		  }
		  ss++;
	       }
	    }
	 }
	 pass++;
      }
   }
   switch (ent_type[0]) {
   case 'x': {
      unsigned int func = (m->func.mask >> FUNC_SHIFT)%FUNC_MAX;
      setmodifiers[func] = m->func.mask;
      min_size_for_func[func] = m->func.params[0];
   }break;
   case 'f':
      opt_font = m->func.strings[0];
      freestrs = 0;
      break;
#ifndef STORMTROOPER
   case 'p':
#ifdef DEATHSTAR
      if (ent_type[1] == 't') {
	 opt_popup_timeout(ent_type[2]-'0') = m->func.params[0];
	 break;
      }
#endif
      opt_popup_area = a;
      opt_popup_stack_width = m->func.params[0];
      opt_popup_time_in = m->func.params[1];
      break;
   case 'q':
      opt_qualify_caption = m->func.params[0];
      break;
   case 'l':
      lock_command = m->func.strings[0];
      freestrs = 0;
      break;
#endif
#ifdef DEATHSTAR
   case 'b':
      opt_bw = m->func.params[0];
      break;
   case 'a': {
      Application *njuu = (Application *)calloc(sizeof(Application),1);
      njuu->res_name = m->func.strings[0];
      njuu->res_class = m->func.strings[1];
      njuu->next = head_app;
      head_app = njuu;
      freestrs = 0;
   } break;
   case 'g': {
      if (head_app) {
	 head_app->geometry_mask = mask;
	 head_app->area = a;
      }
   } break;
   case 's':
      if (ent_type[1] == 't') {
	 if (head_app)
	    head_app->sticky = '!';
      }
      else if (ent_type[1] == 'w')
	 opt_snap_to_windows = m->func.params[0];
      else
	 opt_snap = m->func.params[0];
      break;
   case 'n':
      opt_solid_drag = 0;
      break;
#endif
   case 'e':
      if (recp>recr)
	 recp--;
      break;
   case 'c':
      if (ent_type[1] != 'm' && m->func.strings[0]) {
	 unsigned int cc = ent_type[1]-COL_BASE;
	 colnams[cc%COL_NO_OF] = m->func.strings[0];
	 freestrs = 0;
	 break;
      }
   case 'm': if (m->func.strings[0]){
      freem = 0;
      if (*recp)
	 (*recp)[0] = m;
      else
	 (*(recp-1))[1] = m;
      *recp = m->links;      
      if (ent_type[0] == 'm')
	 *(++recp) = 0;
      else
	 m->func.mask = FUNC_SPAWN<<FUNC_SHIFT;
   }break;
   case 'k': {
      struct Cmd*existing;
      for (existing= function_keys;
	   existing && (existing->key != m->key || existing->modmask != m->modmask);
	   existing=existing->links[0])
	 ;
      if (existing) {
	 freecmdsub(existing);
	 existing->func = m->func;
	 free(m);
      } else {
	 if (!m->func.strings[1])
	    m->func.strings[1] = m->func.strings[0];
	 m->links[0] = function_keys;
	 function_keys = m;
      }
      freem = 0;
   }
   default:
      ;
   }
   if (freem) {
      if (freestrs)
	 freecmdsub(m);
      free(m);
   }
}


const char*rcs[]={
#ifndef STORMTROOPER
   "/etc/X11/sithwm/menudefs.hook",
#endif
   CONFDIR "/default.sithwmrc",
   "%s/.sithwmrc",
   0};

void read_rcs(void)
{
   for (const char**rcsp=rcs;*rcsp;rcsp++) {
      snprintf(global_buffer, 110, *rcsp, getenv("HOME"));
      FILE*f = fopen(global_buffer, "r");
      if (f) {
	 for (;fgets(global_buffer, sizeof global_buffer, f);)
	    parse_rc_line();
	 fclose(f);
      }
   }
}

#ifndef STORMTROOPER

static int menu_h, menu_w;
static int x_offs;

void do_menu(ScreenInfo* screen, XEvent*evnt)
{
   int arrow_size;
   KeySym key = 0;
   char akey = 0;
   if (evnt) switch (evnt->type) {
   case KeyPress:
      key = XKeycodeToKeysym(dpy, evnt->xkey.keycode, 0);
      char* sym=XKeysymToString(key);
      if (sym && sym[1] == 0 ) {
         akey = tolower(sym[0]);
         break;
      }

      switch ( key ) {
      case XK_End:case XK_Tab:
         current_row_level = rowdef_a+20;
      case XK_Left:
         if (current_row_level>rowdef_a)
            current_row_level--;
	 break;
      case XK_Home:
	 current_row_level = rowdef_a;
      case XK_Right:
      case XK_Down:
      case XK_Up:
      case XK_Return:
         break;
      default:
         goto pulldown;
      }
   }

   if (screen->infow_func<INFOW_MENU) {
      menu_w = menu_h = 1;
      update_info_window(screen, INFOW_MENU);
      key = akey = 0;
   }
   XMoveResizeWindow(dpy, screen->infow, 1, 1, menu_w, menu_h);
   XMapRaised(dpy, screen->infow);

   arrow_size = (font_height>>1)-3;

   for (int pass= 0;pass<2;pass++) {
      int x=x_offs>>1;
      int newxoffs = 2;
      struct Cmd *cdef;
      struct rowdef*rowdef=rowdef_a;
      for (struct Cmd *column = action_menu;
	   column && rowdef<=(current_row_level+1);
	   column = cdef->links[1], rowdef++ ) {
	 int hilit_offs = 0;
	 int stacker = rowdef->yoffs>>1;
	 struct Cmd *row;
	 struct Cmd *prev = 0;
	 cdef = column;
	 if (pass==0)
	    rowdef->width = 0;
	 for ( row=column; row; prev=row, row=row->links[0], stacker+=font_height){
	    switch(pass){
	    case 0: {
	       int tw;
	       if (row->flags) {
		  cdef = row;
		  if (rowdef == current_row_level) {
		     row->flags = 0;
		     if (akey) {
			cdef = 0;
			key = XK_Return;
			for(struct Cmd *newrow=row;;) {
			   newrow = newrow->links[0];
			   if (!newrow)
			      newrow = column;
			   if (tolower(newrow->func.strings[0][0]) == akey) {
			      if (cdef ) {
				 key = 0;
				 break;
			      }
			      cdef = newrow;
			   }
			   if (newrow == row)
			      break;
			}
			if (!cdef) {
			   cdef = row;
			   key = 0;
			}
		     }
		     switch(key){
		     case XK_Return:
			if (cdef->func.strings[1]) {
			   perform_func(screen, cdef, evnt);
			   cdef->flags = 1;
			   goto pulldown;
			}
		     case XK_Right:
			if (cdef->links[1])
			   current_row_level++;
			break;
		     case XK_Up:
			if (!prev)
			   for (prev=column;prev->links[0];prev=prev->links[0])
			      ;
			cdef=prev;
			break;
		     case XK_Down:
			cdef=row->links[0];
			if (!cdef) cdef = column;
		     }
		     key = 0;
		     akey = 0;
		  }
   	       }
	       tw = XTextWidth(font, row->func.strings[0], strlen(row->func.strings[0]))+1;
	       if (row->links[1])
		  tw += arrow_size+1;
	       if (tw>rowdef->width)
		  rowdef->width = tw;
	    }break;
	    case 1: {
	       if (row->flags) {
		  cdef = row;
		  hilit_offs = stacker;
		  if (rowdef == current_row_level) {
		     XFillRectangle(dpy, screen->infow, screen->gc['g'-COL_BASE],
				    x, stacker, rowdef->width+6, font_height);
		     newxoffs = x;
		  }
		  XDrawRectangle(dpy, screen->infow, screen->gc['i'-COL_BASE],
				 x, stacker, rowdef->width+6, font_height);
	       }
	       XDrawString(dpy, screen->infow, screen->gc['i'-COL_BASE],
			   x+1, stacker + font->max_bounds.ascent,
			   row->func.strings[0], strlen(row->func.strings[0]));
	       if (row->links[1]) {
		  XPoint p[3] = {
		     {min(x+rowdef->width+((row->flags)?0:-arrow_size),menu_w-arrow_size),stacker+3},
		     {arrow_size,arrow_size},{-arrow_size,arrow_size}};
		  XFillPolygon(dpy, screen->infow, screen->gc['i'-COL_BASE], p, 3, Convex, CoordModePrevious);
	       }
	    }
	    }
	 }
	 cdef->flags = 1;
	 if (pass) {
	    int tgt = ((min(stacker+1, screen->area.h>>1)-menu_h)>>1)+1;
	    if (tgt>0) {
	       menu_h += tgt;
	       stacker_offset = 1;
	       rowdef->yoffs = 0;
	    }
	    stacker -= (rowdef->yoffs>>1);
	    hilit_offs -= (rowdef->yoffs>>1);
	    int offs = menu_h-stacker;
	    if (offs<0) {
	       int ih2 = menu_h>>1;
	       if (hilit_offs<ih2)
		  stacker = 1;
	       else if ( (stacker-hilit_offs)<ih2)
		  stacker = offs-2;
	       else
		  stacker = -hilit_offs+ih2;
	    }
	    else
	       stacker = 1;
	    stacker -= rowdef->yoffs>>1;
	    rowdef->yoffs += stacker;
	    if (stacker)
	       stacker_offset = 1;
	 }
	 else
	    XClearArea(dpy, screen->infow, x-1, 0, rowdef->width+8, 1000, False);
	 x += rowdef->width+8;
      }

      if (pass==1) {
	 if ( x>menu_w && menu_w<(screen->area.w>>1)) {
	    menu_w += ((x-menu_w)>>1)+1;
	    stacker_offset = 1;
	 }
	 else if (newxoffs>1){
	    if (x > menu_w) {
	       x_offs -= x-menu_w;
	       stacker_offset = 1;
	    }
	 }
	 else if (newxoffs<1) {
	    x_offs -= newxoffs-1;
	    stacker_offset = 1;
	 }
      }
      else
	 XClearArea(dpy, screen->infow, x-1, 0, 1000, 1000, False);

      if (current_row_level>=rowdef)
	 current_row_level = rowdef-1;
   }

   return;
 pulldown:   
   XUnmapWindow(dpy, screen->infow);
   screen->infow_func = 0;
   return;
}

#endif
