\page ExampleTestEm14 Example TestEm14

  - How to compute cross sections from the direct evaluation of the mean
    free path.
  - How to plot final state of a process.   
  
## GEOMETRY DEFINITION
 
  It is a single box representing a 'semi infinite' homogeneous medium.
  Two parameters define the geometry :
  - the material of the box,
  - the (full) size of the box.
   
  The default geometry (100 m of water) is constructed in 
  DetectorConstruction, but the above parameters can be changed 
  interactively via the commands defined in DetectorMessenger.
   
## PHYSICS LIST
 
  The physics list contains the standard electromagnetic processes.
  In order not to introduce 'artificial' constraints on the step size, the
  multiple scattering is not instanciated, and all processes are
  registered as discrete : there is no continuous energy loss.  
    
## AN EVENT : THE PRIMARY GENERATOR
 
  The primary kinematic consists of a single particle starting at the edge
  of the box. The type of the particle and its energy are set in 
  PrimaryGeneratorAction (1 MeV gamma), and can be changed via the G4 
  build-in commands of G4ParticleGun class (see the macros provided with 
  this example).
   
## PHYSICS
 
  An event is killed at the first interaction of the incident paticle.
  The absorption length, also called mean free path, is computed as 
  the mean value of the track length of the incident particle.
  This is why the medium must be 'infinite' : to be sure that interaction
  occurs at any events.
  
  The result is compared with the 'input' data, i.e. with the cross
  sections stored in the PhysicsTables and used by Geant4.
  
  The energy spectrum and the angular distribution of the scattered
  particle (if any) and of the created secondaries are plotted (see
  SteppingAction).
   
  A set of macros defining various run conditions are provided.
  The processes are actived/inactived in order to survey the processes 
  individually.

## HISTOGRAMS
         
  The test contains 6 built-in 1D histograms, which are managed by the
  HistoManager class and its messenger, HistoMessenger. The histos can be individually 
  activated with the command :
  /analysis/h1/set id nbBins  valMin valMax unit 
  where unit is the desired unit for the histo (MeV or keV, etc..)
  (see the macros xxxx.mac).
 
   - 1 :     "scattered primary particle: energy spectrum"
   - 2 :     "scattered primary particle: costheta distribution"
   - 3 :     "charged secondaries: energy spectrum"
   - 4 :     "charged secondaries: costheta distribution"
   - 5 :     "neutral secondaries: energy spectrum"
   - 6 :     "neutral secondaries: costheta distribution"      
      
   The histograms are managed by the HistoManager class and its messenger, 
   HistoMessenger 
   The histos can be individually activated with the command :
```
/analysis/h1/set id nbBins  valMin valMax unit 
```
   where unit is the desired unit for the histo (MeV or keV, deg or mrad, etc..)
   
   One can control the name of the histograms file with the command:
```
/analysis/setFileName  name  (default testem14)
```
   
   It is possible to choose the format of the histogram file : root (default),
   hdf5, xml, csv, by changing the default file type in HistoManager.cc
       
   It is also possible to print selected histograms on an ascii file:
```
/analysis/h1/setAscii id
```
   All selected histos will be written on a file name.ascii (default testem14) 

## VISUALIZATION
 
   The Visualization Manager is set in the main().
   The initialisation of the drawing is done via the commands
   /vis/... in the macro vis.mac. To get visualisation:
```
> /control/execute vis.mac
```
   
   The detector has a default view which is a longitudinal view of the 
   box.
   
   The tracks are drawn at the end of event, and erased at the end of run.
  
## HOW TO START ?
 
  - Execute TestEm14 in 'batch' mode from macro files :
```
% ./TestEm14   compt.mac
```
    
  - Execute TestEm14 in 'interactive mode' with visualization :
```
% ./TestEm14
Idle> control/execute vis.mac
....
Idle> type your commands
....
Idle> exit
```
  
  Macros provided in this example:
  - anni.mac:      e+ (100 MeV) on Aluminium
  - atomicDeexcitation: gamma (80 keV) on Tellurium 
  - compton.mac:   gamma (300 keV) on Aluminium
  - conv.mac:      gamma (20 MeV) on Lead
  - convtomu.mac:  gamma (100 TeV) on Iron  
  - electron.mac:  e- (100 MeV) on Aluminium
  - gamma.mac:     gamma (100 keV) on Water
  - photoelec.mac: gamma (80 keV) on Gold
  - proton.mac:    proton (100 MeV) on Water  
  