//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-metal")]
#[cfg(not(target_os = "watchos"))]
use objc2_metal::*;

use crate::*;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvmetalbuffercachemaximumbufferagekey?language=objc)
    pub static kCVMetalBufferCacheMaximumBufferAgeKey: &'static CFString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvmetalbuffercache?language=objc)
#[doc(alias = "CVMetalBufferCacheRef")]
#[repr(C)]
pub struct CVMetalBufferCache {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CVMetalBufferCache {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CVMetalBufferCache"> for CVMetalBufferCache {}
);

unsafe impl ConcreteType for CVMetalBufferCache {
    #[doc(alias = "CVMetalBufferCacheGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CVMetalBufferCacheGetTypeID() -> CFTypeID;
        }
        unsafe { CVMetalBufferCacheGetTypeID() }
    }
}

impl CVMetalBufferCache {
    /// Creates a new Buffer Cache.
    ///
    /// Parameter `allocator`: The CFAllocatorRef to use for allocating the cache.  May be NULL.
    ///
    /// Parameter `cacheAttributes`: A CFDictionaryRef containing the attributes of the cache itself. May be NULL.
    ///
    /// Parameter `metalDevice`: The Metal device for which the buffer objects will be created.
    ///
    /// Parameter `cacheOut`: The newly created buffer cache will be placed here
    ///
    /// Returns: Returns kCVReturnSuccess on success
    ///
    /// # Safety
    ///
    /// - `cache_attributes` generics must be of the correct type.
    /// - `cache_out` must be a valid pointer.
    #[doc(alias = "CVMetalBufferCacheCreate")]
    #[cfg(all(feature = "CVReturn", feature = "objc2", feature = "objc2-metal"))]
    #[cfg(not(target_os = "watchos"))]
    #[inline]
    pub unsafe fn create(
        allocator: Option<&CFAllocator>,
        cache_attributes: Option<&CFDictionary>,
        metal_device: &ProtocolObject<dyn MTLDevice>,
        cache_out: NonNull<*mut CVMetalBufferCache>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVMetalBufferCacheCreate(
                allocator: Option<&CFAllocator>,
                cache_attributes: Option<&CFDictionary>,
                metal_device: &ProtocolObject<dyn MTLDevice>,
                cache_out: NonNull<*mut CVMetalBufferCache>,
            ) -> CVReturn;
        }
        unsafe { CVMetalBufferCacheCreate(allocator, cache_attributes, metal_device, cache_out) }
    }

    /// Creates a CVMetalBuffer object from an existing CVImageBuffer
    ///
    /// Parameter `allocator`: The CFAllocatorRef to use for allocating the CVMetalBuffer object. May be NULL.
    ///
    /// Parameter `bufferCache`: The buffer cache object that will manage the buffer.
    ///
    /// Parameter `buffer`: The CVImageBuffer that you want to create a CVMetalBuffer from.
    ///
    /// Parameter `bufferOut`: The newly created buffer object will be placed here.
    ///
    /// Returns: Returns kCVReturnSuccess on success
    ///
    /// Creates or returns a cached CVMetalBuffer object mapped to the CVImageBuffer.
    /// This creates a live binding between the CVImageBuffer and underlying CVMetalBuffer buffer object.
    ///
    /// IMPORTANT NOTE: Clients should retain CVMetalBuffer objects until they are done using the images in them.
    /// Retaining a CVMetalBuffer is your way to indicate that you're still using the image in the buffer, and that it should not be recycled yet.
    ///
    /// # Safety
    ///
    /// `buffer_out` must be a valid pointer.
    #[doc(alias = "CVMetalBufferCacheCreateBufferFromImage")]
    #[cfg(all(
        feature = "CVBuffer",
        feature = "CVImageBuffer",
        feature = "CVMetalBuffer",
        feature = "CVReturn"
    ))]
    #[inline]
    pub unsafe fn create_buffer_from_image(
        allocator: Option<&CFAllocator>,
        buffer_cache: &CVMetalBufferCache,
        image_buffer: &CVImageBuffer,
        buffer_out: NonNull<*mut CVMetalBuffer>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVMetalBufferCacheCreateBufferFromImage(
                allocator: Option<&CFAllocator>,
                buffer_cache: &CVMetalBufferCache,
                image_buffer: &CVImageBuffer,
                buffer_out: NonNull<*mut CVMetalBuffer>,
            ) -> CVReturn;
        }
        unsafe {
            CVMetalBufferCacheCreateBufferFromImage(
                allocator,
                buffer_cache,
                image_buffer,
                buffer_out,
            )
        }
    }

    /// Performs internal housekeeping/recycling operations
    ///
    /// This call must be made periodically to give the buffer cache a chance to do internal housekeeping operations.
    ///
    /// Parameter `bufferCache`: The buffer cache object to flush
    ///
    /// Parameter `options`: Currently unused, set to 0.
    #[doc(alias = "CVMetalBufferCacheFlush")]
    #[cfg(feature = "CVBase")]
    #[inline]
    pub fn flush(&self, options: CVOptionFlags) {
        extern "C-unwind" {
            fn CVMetalBufferCacheFlush(buffer_cache: &CVMetalBufferCache, options: CVOptionFlags);
        }
        unsafe { CVMetalBufferCacheFlush(self, options) }
    }
}

extern "C-unwind" {
    #[cfg(all(feature = "CVReturn", feature = "objc2", feature = "objc2-metal"))]
    #[cfg(not(target_os = "watchos"))]
    #[deprecated = "renamed to `CVMetalBufferCache::create`"]
    pub fn CVMetalBufferCacheCreate(
        allocator: Option<&CFAllocator>,
        cache_attributes: Option<&CFDictionary>,
        metal_device: &ProtocolObject<dyn MTLDevice>,
        cache_out: NonNull<*mut CVMetalBufferCache>,
    ) -> CVReturn;
}

extern "C-unwind" {
    #[cfg(all(
        feature = "CVBuffer",
        feature = "CVImageBuffer",
        feature = "CVMetalBuffer",
        feature = "CVReturn"
    ))]
    #[deprecated = "renamed to `CVMetalBufferCache::create_buffer_from_image`"]
    pub fn CVMetalBufferCacheCreateBufferFromImage(
        allocator: Option<&CFAllocator>,
        buffer_cache: &CVMetalBufferCache,
        image_buffer: &CVImageBuffer,
        buffer_out: NonNull<*mut CVMetalBuffer>,
    ) -> CVReturn;
}

#[cfg(feature = "CVBase")]
#[deprecated = "renamed to `CVMetalBufferCache::flush`"]
#[inline]
pub extern "C-unwind" fn CVMetalBufferCacheFlush(
    buffer_cache: &CVMetalBufferCache,
    options: CVOptionFlags,
) {
    extern "C-unwind" {
        fn CVMetalBufferCacheFlush(buffer_cache: &CVMetalBufferCache, options: CVOptionFlags);
    }
    unsafe { CVMetalBufferCacheFlush(buffer_cache, options) }
}
