/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Pattern;

public abstract class AlignParse
extends BaseParse {
    protected HashMap<String, String> tagmap = new HashMap(35);
    String[] col_names = new String[]{"Query Name", "Flag", "Reference Name", "Position", "Map Quality", "Cigar", "Mate Reference", "Mate Position", "Template Length", "Read Sequence", "Read Quality"};

    public AlignParse(String string) {
        super(string);
        this.initTags();
    }

    @Override
    public abstract void seek(long var1) throws IOException;

    @Override
    public abstract long getNextRecordIndex();

    @Override
    public abstract String[] getNextRecord();

    @Override
    public abstract double getProgress();

    @Override
    public String getToolTip(String string, int n, int n2, String[] stringArray) {
        if (n2 == 1) {
            int n3 = Integer.parseInt(string);
            return this.prettyPrintFlag(n3);
        }
        if (n2 == 5) {
            return this.prettyPrintCigar(string);
        }
        if (n2 == 9 && stringArray.length > 10) {
            String string2 = stringArray[10];
            return this.prettyPrintBaseQual(string, string2);
        }
        if (n2 > 10) {
            return this.prettyPrintTag(string);
        }
        return string;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= this.col_names.length) {
            return "Tag";
        }
        if (n < 0) {
            return "Unknown";
        }
        return this.col_names[n];
    }

    @Override
    public int getNumColumnLabels() {
        if (this.col_names == null) {
            return 0;
        }
        return this.col_names.length;
    }

    protected void initTags() {
        this.tagmap.put("AM", "Smallest template-independent mapping quality of fragments in the rest");
        this.tagmap.put("AS", "Alignment score");
        this.tagmap.put("BQ", "Offset to base alignment quality (BAQ)");
        this.tagmap.put("CC", "Reference name of the next hit");
        this.tagmap.put("CM", "Edit distance between the color sequence and the color reference");
        this.tagmap.put("CP", "Leftmost coordinate of the next hit");
        this.tagmap.put("CQ", "Color read quality");
        this.tagmap.put("CS", "Color read sequence");
        this.tagmap.put("E2", "The 2nd most likely base calls");
        this.tagmap.put("FI", "The index of fragment in the template");
        this.tagmap.put("FS", "Fragment suffix");
        this.tagmap.put("FZ", "Flow signal intensities");
        this.tagmap.put("LB", "Library");
        this.tagmap.put("H0", "Number of perfect hits");
        this.tagmap.put("H1", "Number of 1-difference hits");
        this.tagmap.put("H2", "Number of 2-difference hits");
        this.tagmap.put("HI", "Query hit index");
        this.tagmap.put("IH", "Number of stored alignments in SAM that contains the query in the current record");
        this.tagmap.put("MD", "String for mismatching positions");
        this.tagmap.put("MQ", "Mapping quality of the mate fragment");
        this.tagmap.put("NH", "Number of alignments of query read");
        this.tagmap.put("NM", "Edit distance to the reference");
        this.tagmap.put("OQ", "Original base quality");
        this.tagmap.put("OP", "Original mapping position");
        this.tagmap.put("OC", "Original CIGAR");
        this.tagmap.put("PG", "Program");
        this.tagmap.put("PQ", "Phred likelihood of the template");
        this.tagmap.put("PU", "Platform unit");
        this.tagmap.put("Q2", "Phred quality of the mate fragment");
        this.tagmap.put("R2", "Sequence of the mate fragment in the template");
        this.tagmap.put("RG", "Read group");
        this.tagmap.put("SM", "Template-independent mapping quality");
        this.tagmap.put("TC", "Number of fragments in the template");
        this.tagmap.put("U2", "Phred probility of the 2nd call being wrong conditional on the best being wrong");
        this.tagmap.put("UQ", "Phred likelihood of the fragment");
    }

    protected String prettyPrintFlag(int n) {
        if (n < 0) {
            return "";
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "<html>";
        if (n % 2 != 0) {
            string = string + "Read is paired.<br>";
            bl3 = true;
        }
        if ((n >>= 1) % 2 != 0) {
            string = string + "Read mapped in proper pair.<br>";
        }
        if ((n >>= 1) % 2 != 0) {
            string = string + "Read is unmapped.<br>";
            bl = true;
        }
        if ((n >>= 1) % 2 != 0) {
            string = string + "Mate is unmapped.<br>";
            bl2 = true;
        }
        if ((n >>= 1) % 2 != 0) {
            string = string + "Read is on reverse strand.<br>";
        } else if (!bl) {
            string = string + "Read is on forward strand.<br>";
        }
        if ((n >>= 1) % 2 != 0) {
            string = string + "Mate is on reverse strand.<br>";
        } else if (bl3 && !bl2) {
            string = string + "Mate is on forward strand.<br>";
        }
        if ((n >>= 1) % 2 != 0) {
            string = string + "Read is first in template.<br>";
        }
        if ((n >>= 1) % 2 != 0) {
            string = string + "Read is last in template.<br>";
        }
        if ((n >>= 1) % 2 != 0) {
            string = string + "Read is not primary alignment.<br>";
        }
        if ((n >>= 1) % 2 != 0) {
            string = string + "Read fails platform/vendor quality checks.<br>";
        }
        if ((n >>= 1) % 2 != 0) {
            string = string + "Read is PCR or optical duplicate.<br>";
        }
        string = string + "</html>";
        return string;
    }

    protected String prettyPrintCigar(String string) {
        String string2 = "<html>";
        if (string.equals("*")) {
            string2 = string2 + "No alignment information<br>";
        } else {
            Pattern pattern = Pattern.compile("\\D");
            String[] stringArray = pattern.split(string);
            pattern = Pattern.compile("\\d+");
            String[] stringArray2 = pattern.split(string);
            block11: for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + stringArray[i] + " ";
                switch (stringArray2[i + 1].charAt(0)) {
                    case 'M': 
                    case 'm': {
                        string2 = string2 + "Match/Mismatch<br>";
                        continue block11;
                    }
                    case 'I': 
                    case 'i': {
                        string2 = string2 + "Insertion to reference<br>";
                        continue block11;
                    }
                    case 'D': 
                    case 'd': {
                        string2 = string2 + "Deletion from reference<br>";
                        continue block11;
                    }
                    case 'N': 
                    case 'n': {
                        string2 = string2 + "Skipped region from reference<br>";
                        continue block11;
                    }
                    case 'S': 
                    case 's': {
                        string2 = string2 + "Soft clipping (clipped sequence present)<br>";
                        continue block11;
                    }
                    case 'H': 
                    case 'h': {
                        string2 = string2 + "Hard clipping (clipped sequence removed)<br>";
                        continue block11;
                    }
                    case 'P': 
                    case 'p': {
                        string2 = string2 + "Padding (silent deletion from padded reference)<br>";
                        continue block11;
                    }
                    case '=': {
                        string2 = string2 + "Match<br>";
                        continue block11;
                    }
                    case 'X': 
                    case 'x': {
                        string2 = string2 + "Mismatch<br>";
                        continue block11;
                    }
                    default: {
                        string2 = string2 + stringArray2[i] + "<br>";
                    }
                }
            }
        }
        string2 = string2 + "</html>";
        return string2;
    }

    protected String prettyPrintBaseQual(String string, String string2) {
        if (string.equals("*") || string.length() != string2.length()) {
            return "<html><font size=\"5\">" + string + "</font></html>";
        }
        String string3 = "<html>";
        for (int i = 0; i < string.length(); ++i) {
            string3 = string3 + "<font size=\"5\" color=\"";
            int n = string2.charAt(i) - 33;
            string3 = n < 20 ? string3 + "#E9CFEC" : string3 + "#571B7e";
            string3 = string3 + "\">";
            string3 = string3 + string.charAt(i);
            string3 = string3 + "</font>";
        }
        string3 = string3 + "</html>";
        return string3;
    }

    protected String prettyPrintTag(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length < 3) {
            return string;
        }
        String string2 = "";
        String string3 = null;
        string3 = this.tagmap.get(stringArray[0]);
        if (string3 == null) {
            string3 = stringArray[0];
        }
        return string3 + ": " + stringArray[2];
    }
}

