/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.RandomAccessFile;

public class SAMParse
extends AlignParse {
    private static final int BUFF_SIZE = 131072;
    private static final byte[] buffer = new byte[131072];
    private int buffer_pos = 0;
    private int buffer_size;
    private long file_pos = 0L;
    private RandomAccessFile filein;

    public SAMParse(String string) {
        super(string);
        try {
            this.filein = new RandomAccessFile(string, "r");
            this.parseHeader();
            this.file_pos = this.filein.getFilePointer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void seek(long l) throws IOException {
        this.filein.seek(l);
        this.file_pos = this.filein.getFilePointer();
    }

    @Override
    public long getNextRecordIndex() {
        long l = this.file_pos + (long)this.buffer_pos;
        try {
            while (true) {
                if (this.buffer_size == 0 || this.buffer_pos >= this.buffer_size) {
                    this.file_pos = this.filein.getFilePointer();
                    this.buffer_size = this.filein.read(buffer);
                    this.buffer_pos = 0;
                }
                if (this.buffer_size < 1) {
                    return -1L;
                }
                if (buffer[this.buffer_pos] == 10) {
                    ++this.buffer_pos;
                    return l;
                }
                ++this.buffer_pos;
            }
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public String[] getNextRecord() {
        try {
            String string = this.filein.readLine();
            if (string == null) {
                return null;
            }
            return string.split("\\t");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public double getProgress() {
        try {
            return 1.0 * (double)this.filein.getFilePointer() / (1.0 * (double)this.filein.length());
        }
        catch (IOException iOException) {
            return 1.0;
        }
    }

    private void parseHeader() {
        String string = null;
        this.header = "";
        long l = -1L;
        try {
            String string2;
            l = this.filein.getFilePointer();
            while ((string = this.filein.readLine()) != null && ((string2 = string.substring(0, 3)).equals("@HD") || string2.equals("@SQ") || string2.equals("@RG") || string2.equals("@PG") || string2.equals("@CO"))) {
                this.header = this.header + string;
                this.header = this.header + "\n";
                l = this.filein.getFilePointer();
            }
            if (l >= 0L) {
                this.filein.seek(l);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

