/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.util.EnumSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.OutputColor;
import org.netbeans.api.io.ShowOperation;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IOEvent;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.OutputKind;
import org.netbeans.core.output2.PairMap;
import org.netbeans.spi.io.InputOutputProvider;
import org.netbeans.spi.io.support.Hyperlinks;
import org.netbeans.spi.io.support.OutputColorType;
import org.netbeans.spi.io.support.OutputColors;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.IOColors;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.IOSelect;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public final class NbIOProvider
extends IOProvider
implements InputOutputProvider<InputOutput, OutputWriter, Integer, Integer> {
    private static final WeakHashMap<IOContainer, PairMap> containerPairMaps = new WeakHashMap();
    private static final String STDOUT = NbBundle.getMessage(NbIOProvider.class, (String)"LBL_STDOUT");
    private static final String NAME = "output2";

    public OutputWriter getStdOut() {
        if (Controller.LOG) {
            Controller.log("NbIOProvider.getStdOut");
        }
        NbIO nbIO = (NbIO)this.getIO(STDOUT, false);
        NbWriter nbWriter = nbIO.writer();
        NbIO.post(new IOEvent(nbIO, 0, true));
        if (nbWriter != null && nbWriter.isClosed()) {
            try {
                nbWriter.reset();
                nbWriter = (NbWriter)nbIO.getOut();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                nbIO = (NbIO)this.getIO(STDOUT, true);
                nbWriter = (NbWriter)nbIO.getOut();
            }
        } else {
            nbWriter = (NbWriter)nbIO.getOut();
        }
        return nbWriter;
    }

    public InputOutput getIO(String string, boolean bl) {
        return this.getIO(string, bl, new Action[0], null);
    }

    public InputOutput getIO(String string, Action[] actionArray) {
        return this.getIO(string, true, actionArray, null);
    }

    public InputOutput getIO(String string, Action[] actionArray, IOContainer iOContainer) {
        return this.getIO(string, true, actionArray, iOContainer);
    }

    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputOutput getIO(String string, boolean bl, Action[] actionArray, IOContainer iOContainer) {
        NbIO nbIO;
        PairMap pairMap;
        if (Controller.LOG) {
            Controller.log("GETIO: " + string + " new:" + bl);
        }
        IOContainer iOContainer2 = iOContainer == null ? IOContainer.getDefault() : iOContainer;
        WeakHashMap<IOContainer, PairMap> weakHashMap = containerPairMaps;
        synchronized (weakHashMap) {
            pairMap = containerPairMaps.get(iOContainer2);
            nbIO = pairMap != null ? pairMap.get(string) : null;
        }
        if (nbIO == null || bl) {
            nbIO = new NbIO(string, actionArray, iOContainer2);
            weakHashMap = containerPairMaps;
            synchronized (weakHashMap) {
                pairMap = containerPairMaps.get(iOContainer2);
                if (pairMap == null) {
                    pairMap = new PairMap();
                    containerPairMaps.put(iOContainer2, pairMap);
                }
                pairMap.add(string, nbIO);
            }
            NbIO.post(new IOEvent(nbIO, 0, bl));
        }
        return nbIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dispose(NbIO nbIO) {
        IOContainer iOContainer = nbIO.getIOContainer();
        if (iOContainer == null) {
            iOContainer = IOContainer.getDefault();
        }
        WeakHashMap<IOContainer, PairMap> weakHashMap = containerPairMaps;
        synchronized (weakHashMap) {
            PairMap pairMap = containerPairMaps.get(iOContainer);
            if (pairMap != null) {
                pairMap.remove(nbIO);
                if (pairMap.isEmpty()) {
                    containerPairMaps.remove(iOContainer);
                }
            }
        }
    }

    public String getId() {
        return this.getName();
    }

    public InputOutput getIO(String string, boolean bl, Lookup lookup) {
        Action[] actionArray = (Action[])lookup.lookup(Action[].class);
        IOContainer iOContainer = (IOContainer)lookup.lookup(IOContainer.class);
        return this.getIO(string, bl, actionArray == null ? new Action[]{} : actionArray, iOContainer);
    }

    public Reader getIn(InputOutput inputOutput) {
        return inputOutput.getIn();
    }

    public OutputWriter getOut(InputOutput inputOutput) {
        return inputOutput.getOut();
    }

    public OutputWriter getErr(InputOutput inputOutput) {
        return inputOutput.getErr();
    }

    public void print(InputOutput inputOutput, OutputWriter outputWriter, String string, Hyperlink hyperlink, OutputColor outputColor, boolean bl) {
        boolean bl2;
        Color color = NbIOProvider.outputColorToAwtColor(inputOutput, outputColor);
        OutputListener outputListener = NbIOProvider.hyperlinkToOutputListener(hyperlink);
        boolean bl3 = bl2 = hyperlink != null && Hyperlinks.isImportant((Hyperlink)hyperlink);
        if (inputOutput instanceof NbIO) {
            OutWriter outWriter = ((NbIO)inputOutput).out();
            if (outWriter != null) {
                outWriter.print(string, outputListener, bl2, color, null, OutputKind.OUT, bl);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Lookup getIOLookup(InputOutput inputOutput) {
        if (inputOutput instanceof NbIO) {
            return ((NbIO)inputOutput).getLookup();
        }
        throw new IllegalArgumentException();
    }

    public void resetIO(InputOutput inputOutput) {
        if (inputOutput instanceof NbIO) {
            try {
                inputOutput.getOut().reset();
            }
            catch (IOException iOException) {
                Exceptions.attachSeverity((Throwable)iOException, (Level)Level.WARNING);
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void showIO(InputOutput inputOutput, Set<ShowOperation> set) {
        if (set.contains(ShowOperation.OPEN) && set.contains(ShowOperation.MAKE_VISIBLE) && set.size() == 2) {
            inputOutput.select();
        } else {
            IOSelect.select((InputOutput)inputOutput, this.showOperationsToIoSelect(set));
        }
    }

    public void closeIO(InputOutput inputOutput) {
        inputOutput.closeInputOutput();
    }

    public boolean isIOClosed(InputOutput inputOutput) {
        return inputOutput.isClosed();
    }

    public Integer getCurrentPosition(InputOutput inputOutput, OutputWriter outputWriter) {
        if (inputOutput instanceof NbIO) {
            OutWriter outWriter = ((NbIO)inputOutput).out();
            int n = 0;
            if (outWriter != null) {
                n = outWriter.getLines().getCharCount();
            }
            return n;
        }
        throw new IllegalArgumentException();
    }

    public void scrollTo(InputOutput inputOutput, OutputWriter outputWriter, Integer n) {
        if (inputOutput instanceof NbIO) {
            NbIO.post(new IOEvent((NbIO)inputOutput, 13, n));
        }
    }

    public Integer startFold(InputOutput inputOutput, OutputWriter outputWriter, boolean bl) {
        if (inputOutput instanceof NbIO) {
            return ((NbIO)inputOutput).startFold(bl);
        }
        throw new IllegalArgumentException();
    }

    public void endFold(InputOutput inputOutput, OutputWriter outputWriter, Integer n) {
        if (!(inputOutput instanceof NbIO)) {
            throw new IllegalArgumentException();
        }
        ((NbIO)inputOutput).endFold(n);
    }

    public void setFoldExpanded(InputOutput inputOutput, OutputWriter outputWriter, Integer n, boolean bl) {
        if (inputOutput instanceof NbIO) {
            NbIO nbIO = (NbIO)inputOutput;
            if (bl) {
                nbIO.out().getLines().showFoldAndParentFolds(n);
            } else {
                nbIO.out().getLines().hideFold(n);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String getIODescription(InputOutput inputOutput) {
        if (inputOutput instanceof NbIO) {
            return ((NbIO)inputOutput).getToolTipText();
        }
        throw new IllegalArgumentException();
    }

    public void setIODescription(InputOutput inputOutput, String string) {
        if (!(inputOutput instanceof NbIO)) {
            throw new IllegalArgumentException();
        }
        ((NbIO)inputOutput).setTooltipText(string);
    }

    private Set<IOSelect.AdditionalOperation> showOperationsToIoSelect(Set<ShowOperation> set) {
        EnumSet<IOSelect.AdditionalOperation> enumSet = EnumSet.noneOf(IOSelect.AdditionalOperation.class);
        for (ShowOperation showOperation : set) {
            switch (showOperation) {
                case OPEN: {
                    enumSet.add(IOSelect.AdditionalOperation.OPEN);
                    break;
                }
                case MAKE_VISIBLE: {
                    enumSet.add(IOSelect.AdditionalOperation.REQUEST_VISIBLE);
                    break;
                }
                case ACTIVATE: {
                    enumSet.add(IOSelect.AdditionalOperation.REQUEST_ACTIVE);
                }
            }
        }
        return enumSet;
    }

    private static OutputListener hyperlinkToOutputListener(final Hyperlink hyperlink) {
        if (hyperlink == null) {
            return null;
        }
        return new OutputListener(){

            public void outputLineSelected(OutputEvent outputEvent) {
            }

            public void outputLineAction(OutputEvent outputEvent) {
                Hyperlinks.invoke((Hyperlink)hyperlink);
            }

            public void outputLineCleared(OutputEvent outputEvent) {
            }
        };
    }

    private static Color outputColorToAwtColor(InputOutput inputOutput, OutputColor outputColor) {
        if (outputColor == null) {
            return null;
        }
        OutputColorType outputColorType = OutputColors.getType((OutputColor)outputColor);
        if (outputColorType == OutputColorType.RGB) {
            return new Color(OutputColors.getRGB((OutputColor)outputColor));
        }
        switch (outputColorType) {
            case DEBUG: {
                return IOColors.getColor((InputOutput)inputOutput, (IOColors.OutputType)IOColors.OutputType.LOG_DEBUG);
            }
            case FAILURE: {
                return IOColors.getColor((InputOutput)inputOutput, (IOColors.OutputType)IOColors.OutputType.LOG_FAILURE);
            }
            case WARNING: {
                return IOColors.getColor((InputOutput)inputOutput, (IOColors.OutputType)IOColors.OutputType.LOG_WARNING);
            }
            case SUCCESS: {
                return IOColors.getColor((InputOutput)inputOutput, (IOColors.OutputType)IOColors.OutputType.LOG_SUCCESS);
            }
        }
        return null;
    }
}

