/* Copyright (C) 2009 Trend Micro Inc.
 * All right reserved.
 *
 * This program is a free software; you can redistribute it
 * and/or modify it under the terms of the GNU General Public
 * License (version 2) as published by the FSF - Free Software
 * Foundation
 */

#include "shared.h"
#include "agentd.h"
#include "os_net/os_net.h"
#include "sec.h"

#ifndef WIN32
#include <imsg.h>
#endif

/* Receive a message locally on the agent and forward it to the manager */
void *EventForward(void)
{
    ssize_t recv_b;
    char msg[OS_MAXSTR + 1];

    /* Initialize variables */
    msg[0] = '\0';
    msg[OS_MAXSTR] = '\0';

    while ((recv_b = recv(agt->m_queue, msg, OS_MAXSTR, MSG_DONTWAIT)) > 0) {
        msg[recv_b] = '\0';

        send_msg(0, msg);

        run_notify();
    }

    return (NULL);
}

