#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 79
#define LARGE_STATE_COUNT 10
#define SYMBOL_COUNT 59
#define ALIAS_COUNT 2
#define TOKEN_COUNT 37
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 8

enum ts_symbol_identifiers {
  anon_sym_PIPE = 1,
  sym_any_character = 2,
  anon_sym_CARET = 3,
  sym_end_assertion = 4,
  sym_boundary_assertion = 5,
  sym_non_boundary_assertion = 6,
  anon_sym_LPAREN_QMARK = 7,
  anon_sym_EQ = 8,
  anon_sym_BANG = 9,
  anon_sym_RPAREN = 10,
  anon_sym_LPAREN_QMARK_LT = 11,
  sym_pattern_character = 12,
  anon_sym_LBRACK = 13,
  anon_sym_RBRACK = 14,
  anon_sym_DASH = 15,
  anon_sym_BSLASH_DASH = 16,
  sym_class_character = 17,
  anon_sym_LPAREN = 18,
  anon_sym_GT = 19,
  anon_sym_LPAREN_QMARK_COLON = 20,
  anon_sym_STAR = 21,
  anon_sym_QMARK = 22,
  anon_sym_PLUS = 23,
  anon_sym_LBRACE = 24,
  anon_sym_COMMA = 25,
  anon_sym_RBRACE = 26,
  anon_sym_BSLASHk = 27,
  sym_decimal_escape = 28,
  aux_sym_character_class_escape_token1 = 29,
  aux_sym_character_class_escape_token2 = 30,
  sym_unicode_property = 31,
  sym_control_escape = 32,
  sym_control_letter_escape = 33,
  sym_identity_escape = 34,
  sym_group_name = 35,
  sym_decimal_digits = 36,
  sym_pattern = 37,
  sym_alternation = 38,
  sym_term = 39,
  sym_start_assertion = 40,
  sym_lookaround_assertion = 41,
  sym__lookahead_assertion = 42,
  sym__lookbehind_assertion = 43,
  sym_character_class = 44,
  sym_class_range = 45,
  sym_anonymous_capturing_group = 46,
  sym_named_capturing_group = 47,
  sym_non_capturing_group = 48,
  sym_zero_or_more = 49,
  sym_one_or_more = 50,
  sym_optional = 51,
  sym_count_quantifier = 52,
  sym_backreference_escape = 53,
  sym_character_class_escape = 54,
  sym_unicode_property_value_expression = 55,
  aux_sym_alternation_repeat1 = 56,
  aux_sym_term_repeat1 = 57,
  aux_sym_character_class_repeat1 = 58,
  alias_sym_lazy = 59,
  alias_sym_unicode_property_name = 60,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_PIPE] = "|",
  [sym_any_character] = "any_character",
  [anon_sym_CARET] = "^",
  [sym_end_assertion] = "end_assertion",
  [sym_boundary_assertion] = "boundary_assertion",
  [sym_non_boundary_assertion] = "non_boundary_assertion",
  [anon_sym_LPAREN_QMARK] = "(\?",
  [anon_sym_EQ] = "=",
  [anon_sym_BANG] = "!",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LPAREN_QMARK_LT] = "(\?<",
  [sym_pattern_character] = "pattern_character",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DASH] = "-",
  [anon_sym_BSLASH_DASH] = "identity_escape",
  [sym_class_character] = "class_character",
  [anon_sym_LPAREN] = "(",
  [anon_sym_GT] = ">",
  [anon_sym_LPAREN_QMARK_COLON] = "(\?:",
  [anon_sym_STAR] = "*",
  [anon_sym_QMARK] = "\?",
  [anon_sym_PLUS] = "+",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_BSLASHk] = "\\k",
  [sym_decimal_escape] = "decimal_escape",
  [aux_sym_character_class_escape_token1] = "character_class_escape_token1",
  [aux_sym_character_class_escape_token2] = "character_class_escape_token2",
  [sym_unicode_property] = "unicode_property_value",
  [sym_control_escape] = "control_escape",
  [sym_control_letter_escape] = "control_letter_escape",
  [sym_identity_escape] = "identity_escape",
  [sym_group_name] = "group_name",
  [sym_decimal_digits] = "decimal_digits",
  [sym_pattern] = "pattern",
  [sym_alternation] = "alternation",
  [sym_term] = "term",
  [sym_start_assertion] = "start_assertion",
  [sym_lookaround_assertion] = "lookaround_assertion",
  [sym__lookahead_assertion] = "_lookahead_assertion",
  [sym__lookbehind_assertion] = "_lookbehind_assertion",
  [sym_character_class] = "character_class",
  [sym_class_range] = "class_range",
  [sym_anonymous_capturing_group] = "anonymous_capturing_group",
  [sym_named_capturing_group] = "named_capturing_group",
  [sym_non_capturing_group] = "non_capturing_group",
  [sym_zero_or_more] = "zero_or_more",
  [sym_one_or_more] = "one_or_more",
  [sym_optional] = "optional",
  [sym_count_quantifier] = "count_quantifier",
  [sym_backreference_escape] = "backreference_escape",
  [sym_character_class_escape] = "character_class_escape",
  [sym_unicode_property_value_expression] = "unicode_property_value_expression",
  [aux_sym_alternation_repeat1] = "alternation_repeat1",
  [aux_sym_term_repeat1] = "term_repeat1",
  [aux_sym_character_class_repeat1] = "character_class_repeat1",
  [alias_sym_lazy] = "lazy",
  [alias_sym_unicode_property_name] = "unicode_property_name",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [sym_any_character] = sym_any_character,
  [anon_sym_CARET] = anon_sym_CARET,
  [sym_end_assertion] = sym_end_assertion,
  [sym_boundary_assertion] = sym_boundary_assertion,
  [sym_non_boundary_assertion] = sym_non_boundary_assertion,
  [anon_sym_LPAREN_QMARK] = anon_sym_LPAREN_QMARK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LPAREN_QMARK_LT] = anon_sym_LPAREN_QMARK_LT,
  [sym_pattern_character] = sym_pattern_character,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BSLASH_DASH] = sym_identity_escape,
  [sym_class_character] = sym_class_character,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LPAREN_QMARK_COLON] = anon_sym_LPAREN_QMARK_COLON,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_BSLASHk] = anon_sym_BSLASHk,
  [sym_decimal_escape] = sym_decimal_escape,
  [aux_sym_character_class_escape_token1] = aux_sym_character_class_escape_token1,
  [aux_sym_character_class_escape_token2] = aux_sym_character_class_escape_token2,
  [sym_unicode_property] = sym_unicode_property,
  [sym_control_escape] = sym_control_escape,
  [sym_control_letter_escape] = sym_control_letter_escape,
  [sym_identity_escape] = sym_identity_escape,
  [sym_group_name] = sym_group_name,
  [sym_decimal_digits] = sym_decimal_digits,
  [sym_pattern] = sym_pattern,
  [sym_alternation] = sym_alternation,
  [sym_term] = sym_term,
  [sym_start_assertion] = sym_start_assertion,
  [sym_lookaround_assertion] = sym_lookaround_assertion,
  [sym__lookahead_assertion] = sym__lookahead_assertion,
  [sym__lookbehind_assertion] = sym__lookbehind_assertion,
  [sym_character_class] = sym_character_class,
  [sym_class_range] = sym_class_range,
  [sym_anonymous_capturing_group] = sym_anonymous_capturing_group,
  [sym_named_capturing_group] = sym_named_capturing_group,
  [sym_non_capturing_group] = sym_non_capturing_group,
  [sym_zero_or_more] = sym_zero_or_more,
  [sym_one_or_more] = sym_one_or_more,
  [sym_optional] = sym_optional,
  [sym_count_quantifier] = sym_count_quantifier,
  [sym_backreference_escape] = sym_backreference_escape,
  [sym_character_class_escape] = sym_character_class_escape,
  [sym_unicode_property_value_expression] = sym_unicode_property_value_expression,
  [aux_sym_alternation_repeat1] = aux_sym_alternation_repeat1,
  [aux_sym_term_repeat1] = aux_sym_term_repeat1,
  [aux_sym_character_class_repeat1] = aux_sym_character_class_repeat1,
  [alias_sym_lazy] = alias_sym_lazy,
  [alias_sym_unicode_property_name] = alias_sym_unicode_property_name,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [sym_any_character] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [sym_end_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_boundary_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_non_boundary_assertion] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_QMARK_LT] = {
    .visible = true,
    .named = false,
  },
  [sym_pattern_character] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_DASH] = {
    .visible = true,
    .named = true,
  },
  [sym_class_character] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHk] = {
    .visible = true,
    .named = false,
  },
  [sym_decimal_escape] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_character_class_escape_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_character_class_escape_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_unicode_property] = {
    .visible = true,
    .named = true,
  },
  [sym_control_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_control_letter_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_identity_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_group_name] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_digits] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_alternation] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym_start_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_lookaround_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym__lookahead_assertion] = {
    .visible = false,
    .named = true,
  },
  [sym__lookbehind_assertion] = {
    .visible = false,
    .named = true,
  },
  [sym_character_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_range] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_capturing_group] = {
    .visible = true,
    .named = true,
  },
  [sym_named_capturing_group] = {
    .visible = true,
    .named = true,
  },
  [sym_non_capturing_group] = {
    .visible = true,
    .named = true,
  },
  [sym_zero_or_more] = {
    .visible = true,
    .named = true,
  },
  [sym_one_or_more] = {
    .visible = true,
    .named = true,
  },
  [sym_optional] = {
    .visible = true,
    .named = true,
  },
  [sym_count_quantifier] = {
    .visible = true,
    .named = true,
  },
  [sym_backreference_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_character_class_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_unicode_property_value_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_alternation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_term_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_character_class_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_lazy] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_unicode_property_name] = {
    .visible = true,
    .named = true,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_class_character,
  },
  [2] = {
    [1] = alias_sym_lazy,
  },
  [3] = {
    [0] = sym_class_character,
    [2] = sym_class_character,
  },
  [4] = {
    [2] = sym_class_character,
  },
  [5] = {
    [3] = alias_sym_lazy,
  },
  [6] = {
    [0] = alias_sym_unicode_property_name,
  },
  [7] = {
    [5] = alias_sym_lazy,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 11,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 18,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 59,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 74,
  [77] = 77,
  [78] = 62,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(17);
      if (lookahead == '\n') SKIP(0);
      if (lookahead == '\r') SKIP(12);
      if (lookahead == '!') ADVANCE(26);
      if (lookahead == '$') ADVANCE(21);
      if (lookahead == '(') ADVANCE(37);
      if (lookahead == ')') ADVANCE(27);
      if (lookahead == '*') ADVANCE(40);
      if (lookahead == '+') ADVANCE(42);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(32);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '=') ADVANCE(25);
      if (lookahead == '>') ADVANCE(38);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '[') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(9);
      if (lookahead == ']') ADVANCE(31);
      if (lookahead == '^') ADVANCE(20);
      if (lookahead == '{') ADVANCE(43);
      if (lookahead == '|') ADVANCE(18);
      if (lookahead == '}') ADVANCE(45);
      if (lookahead != 0) ADVANCE(29);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(35);
      if (lookahead == '\r') ADVANCE(34);
      if (lookahead == '-') ADVANCE(32);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(31);
      if (lookahead == '^') ADVANCE(20);
      if (lookahead != 0) ADVANCE(34);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(36);
      if (lookahead == '\r') ADVANCE(34);
      if (lookahead == '-') ADVANCE(32);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(31);
      if (lookahead != 0) ADVANCE(34);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(4);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(4);
      if (lookahead == '\r') SKIP(3);
      if (lookahead == '!') ADVANCE(26);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '=') ADVANCE(25);
      if (lookahead == '>') ADVANCE(38);
      if (lookahead == '}') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(55);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(6);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(6);
      if (lookahead == '\r') SKIP(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(50);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(8);
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(8);
      if (lookahead == '\r') SKIP(7);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(56);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '-', 33,
        'B', 23,
        'b', 22,
        'c', 54,
        'k', 46,
        'P', 49,
        'p', 49,
        '0', 51,
        'f', 51,
        'n', 51,
        'r', 51,
        't', 51,
        'v', 51,
        'D', 48,
        'S', 48,
        'W', 48,
        'd', 48,
        's', 48,
        'w', 48,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(47);
      if (lookahead != 0) ADVANCE(53);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '-', 33,
        'c', 54,
        'P', 49,
        'p', 49,
        'D', 48,
        'S', 48,
        'W', 48,
        'd', 48,
        's', 48,
        'w', 48,
        '0', 51,
        'b', 51,
        'f', 51,
        'n', 51,
        'r', 51,
        't', 51,
        'v', 51,
      );
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != 'k') ADVANCE(53);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        'B', 23,
        'b', 22,
        'c', 54,
        'k', 46,
        'P', 49,
        'p', 49,
        '0', 51,
        'f', 51,
        'n', 51,
        'r', 51,
        't', 51,
        'v', 51,
        'D', 48,
        'S', 48,
        'W', 48,
        'd', 48,
        's', 48,
        'w', 48,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(47);
      if (lookahead != 0) ADVANCE(53);
      END_STATE();
    case 12:
      if (eof) ADVANCE(17);
      if (lookahead == '\n') SKIP(0);
      END_STATE();
    case 13:
      if (eof) ADVANCE(17);
      if (lookahead == '\n') SKIP(14);
      END_STATE();
    case 14:
      if (eof) ADVANCE(17);
      if (lookahead == '\n') SKIP(14);
      if (lookahead == '\r') SKIP(13);
      if (lookahead == '$') ADVANCE(21);
      if (lookahead == '(') ADVANCE(37);
      if (lookahead == ')') ADVANCE(27);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '[') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '^') ADVANCE(20);
      if (lookahead == '|') ADVANCE(18);
      if (lookahead != 0 &&
          (lookahead < '(' || '+' < lookahead) &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(29);
      END_STATE();
    case 15:
      if (eof) ADVANCE(17);
      if (lookahead == '\n') SKIP(16);
      END_STATE();
    case 16:
      if (eof) ADVANCE(17);
      if (lookahead == '\n') SKIP(16);
      if (lookahead == '\r') SKIP(15);
      if (lookahead == '$') ADVANCE(21);
      if (lookahead == '(') ADVANCE(37);
      if (lookahead == ')') ADVANCE(27);
      if (lookahead == '*') ADVANCE(40);
      if (lookahead == '+') ADVANCE(42);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '[') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '^') ADVANCE(20);
      if (lookahead == '{') ADVANCE(43);
      if (lookahead == '|') ADVANCE(18);
      if (lookahead != 0 &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(29);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym_any_character);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym_end_assertion);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym_boundary_assertion);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(sym_non_boundary_assertion);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_LPAREN_QMARK);
      if (lookahead == ':') ADVANCE(39);
      if (lookahead == '<') ADVANCE(28);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_LPAREN_QMARK_LT);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(sym_pattern_character);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_BSLASH_DASH);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(sym_class_character);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_class_character);
      if (lookahead == '\n') ADVANCE(35);
      if (lookahead == '\r') ADVANCE(34);
      if (lookahead == '^') ADVANCE(20);
      if (lookahead != 0 &&
          lookahead != '-' &&
          (lookahead < '\\' || '^' < lookahead)) ADVANCE(34);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym_class_character);
      if (lookahead == '\n') ADVANCE(36);
      if (lookahead == '\r') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '-' &&
          lookahead != '\\' &&
          lookahead != ']') ADVANCE(34);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '?') ADVANCE(24);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_LPAREN_QMARK_COLON);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_BSLASHk);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_decimal_escape);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(aux_sym_character_class_escape_token1);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(aux_sym_character_class_escape_token2);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_unicode_property);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(50);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_control_escape);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_control_letter_escape);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_identity_escape);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_identity_escape);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_group_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_decimal_digits);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(56);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 14},
  [2] = {.lex_state = 14},
  [3] = {.lex_state = 14},
  [4] = {.lex_state = 14},
  [5] = {.lex_state = 14},
  [6] = {.lex_state = 14},
  [7] = {.lex_state = 14},
  [8] = {.lex_state = 14},
  [9] = {.lex_state = 14},
  [10] = {.lex_state = 16},
  [11] = {.lex_state = 16},
  [12] = {.lex_state = 16},
  [13] = {.lex_state = 16},
  [14] = {.lex_state = 16},
  [15] = {.lex_state = 16},
  [16] = {.lex_state = 16},
  [17] = {.lex_state = 16},
  [18] = {.lex_state = 16},
  [19] = {.lex_state = 16},
  [20] = {.lex_state = 16},
  [21] = {.lex_state = 16},
  [22] = {.lex_state = 16},
  [23] = {.lex_state = 16},
  [24] = {.lex_state = 14},
  [25] = {.lex_state = 14},
  [26] = {.lex_state = 14},
  [27] = {.lex_state = 14},
  [28] = {.lex_state = 14},
  [29] = {.lex_state = 14},
  [30] = {.lex_state = 14},
  [31] = {.lex_state = 14},
  [32] = {.lex_state = 14},
  [33] = {.lex_state = 14},
  [34] = {.lex_state = 14},
  [35] = {.lex_state = 1},
  [36] = {.lex_state = 2},
  [37] = {.lex_state = 2},
  [38] = {.lex_state = 2},
  [39] = {.lex_state = 2},
  [40] = {.lex_state = 2},
  [41] = {.lex_state = 2},
  [42] = {.lex_state = 2},
  [43] = {.lex_state = 2},
  [44] = {.lex_state = 2},
  [45] = {.lex_state = 2},
  [46] = {.lex_state = 2},
  [47] = {.lex_state = 2},
  [48] = {.lex_state = 2},
  [49] = {.lex_state = 2},
  [50] = {.lex_state = 0},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 0},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 4},
  [55] = {.lex_state = 0},
  [56] = {.lex_state = 4},
  [57] = {.lex_state = 4},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 6},
  [60] = {.lex_state = 6},
  [61] = {.lex_state = 4},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 4},
  [66] = {.lex_state = 6},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 4},
  [69] = {.lex_state = 0},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 4},
  [72] = {.lex_state = 8},
  [73] = {.lex_state = 4},
  [74] = {.lex_state = 4},
  [75] = {.lex_state = 8},
  [76] = {.lex_state = 4},
  [77] = {.lex_state = 0},
  [78] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [sym_any_character] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [sym_end_assertion] = ACTIONS(1),
    [sym_boundary_assertion] = ACTIONS(1),
    [sym_non_boundary_assertion] = ACTIONS(1),
    [anon_sym_LPAREN_QMARK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LPAREN_QMARK_LT] = ACTIONS(1),
    [sym_pattern_character] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_BSLASH_DASH] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LPAREN_QMARK_COLON] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_BSLASHk] = ACTIONS(1),
    [sym_decimal_escape] = ACTIONS(1),
    [aux_sym_character_class_escape_token1] = ACTIONS(1),
    [aux_sym_character_class_escape_token2] = ACTIONS(1),
    [sym_control_escape] = ACTIONS(1),
    [sym_control_letter_escape] = ACTIONS(1),
    [sym_identity_escape] = ACTIONS(1),
  },
  [1] = {
    [sym_pattern] = STATE(70),
    [sym_alternation] = STATE(58),
    [sym_term] = STATE(53),
    [sym_start_assertion] = STATE(10),
    [sym_lookaround_assertion] = STATE(10),
    [sym__lookahead_assertion] = STATE(16),
    [sym__lookbehind_assertion] = STATE(16),
    [sym_character_class] = STATE(10),
    [sym_anonymous_capturing_group] = STATE(10),
    [sym_named_capturing_group] = STATE(10),
    [sym_non_capturing_group] = STATE(10),
    [sym_backreference_escape] = STATE(10),
    [sym_character_class_escape] = STATE(10),
    [aux_sym_alternation_repeat1] = STATE(52),
    [aux_sym_term_repeat1] = STATE(9),
    [anon_sym_PIPE] = ACTIONS(3),
    [sym_any_character] = ACTIONS(5),
    [anon_sym_CARET] = ACTIONS(7),
    [sym_end_assertion] = ACTIONS(5),
    [sym_boundary_assertion] = ACTIONS(5),
    [sym_non_boundary_assertion] = ACTIONS(5),
    [anon_sym_LPAREN_QMARK] = ACTIONS(9),
    [anon_sym_LPAREN_QMARK_LT] = ACTIONS(11),
    [sym_pattern_character] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_QMARK_COLON] = ACTIONS(17),
    [anon_sym_BSLASHk] = ACTIONS(19),
    [sym_decimal_escape] = ACTIONS(5),
    [aux_sym_character_class_escape_token1] = ACTIONS(21),
    [aux_sym_character_class_escape_token2] = ACTIONS(23),
    [sym_control_escape] = ACTIONS(25),
    [sym_control_letter_escape] = ACTIONS(5),
    [sym_identity_escape] = ACTIONS(25),
  },
  [2] = {
    [sym_pattern] = STATE(77),
    [sym_alternation] = STATE(58),
    [sym_term] = STATE(53),
    [sym_start_assertion] = STATE(10),
    [sym_lookaround_assertion] = STATE(10),
    [sym__lookahead_assertion] = STATE(16),
    [sym__lookbehind_assertion] = STATE(16),
    [sym_character_class] = STATE(10),
    [sym_anonymous_capturing_group] = STATE(10),
    [sym_named_capturing_group] = STATE(10),
    [sym_non_capturing_group] = STATE(10),
    [sym_backreference_escape] = STATE(10),
    [sym_character_class_escape] = STATE(10),
    [aux_sym_alternation_repeat1] = STATE(52),
    [aux_sym_term_repeat1] = STATE(9),
    [anon_sym_PIPE] = ACTIONS(3),
    [sym_any_character] = ACTIONS(5),
    [anon_sym_CARET] = ACTIONS(7),
    [sym_end_assertion] = ACTIONS(5),
    [sym_boundary_assertion] = ACTIONS(5),
    [sym_non_boundary_assertion] = ACTIONS(5),
    [anon_sym_LPAREN_QMARK] = ACTIONS(9),
    [anon_sym_LPAREN_QMARK_LT] = ACTIONS(11),
    [sym_pattern_character] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_QMARK_COLON] = ACTIONS(17),
    [anon_sym_BSLASHk] = ACTIONS(19),
    [sym_decimal_escape] = ACTIONS(5),
    [aux_sym_character_class_escape_token1] = ACTIONS(21),
    [aux_sym_character_class_escape_token2] = ACTIONS(23),
    [sym_control_escape] = ACTIONS(25),
    [sym_control_letter_escape] = ACTIONS(5),
    [sym_identity_escape] = ACTIONS(25),
  },
  [3] = {
    [sym_pattern] = STATE(63),
    [sym_alternation] = STATE(58),
    [sym_term] = STATE(53),
    [sym_start_assertion] = STATE(10),
    [sym_lookaround_assertion] = STATE(10),
    [sym__lookahead_assertion] = STATE(16),
    [sym__lookbehind_assertion] = STATE(16),
    [sym_character_class] = STATE(10),
    [sym_anonymous_capturing_group] = STATE(10),
    [sym_named_capturing_group] = STATE(10),
    [sym_non_capturing_group] = STATE(10),
    [sym_backreference_escape] = STATE(10),
    [sym_character_class_escape] = STATE(10),
    [aux_sym_alternation_repeat1] = STATE(52),
    [aux_sym_term_repeat1] = STATE(9),
    [anon_sym_PIPE] = ACTIONS(3),
    [sym_any_character] = ACTIONS(5),
    [anon_sym_CARET] = ACTIONS(7),
    [sym_end_assertion] = ACTIONS(5),
    [sym_boundary_assertion] = ACTIONS(5),
    [sym_non_boundary_assertion] = ACTIONS(5),
    [anon_sym_LPAREN_QMARK] = ACTIONS(9),
    [anon_sym_LPAREN_QMARK_LT] = ACTIONS(11),
    [sym_pattern_character] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_QMARK_COLON] = ACTIONS(17),
    [anon_sym_BSLASHk] = ACTIONS(19),
    [sym_decimal_escape] = ACTIONS(5),
    [aux_sym_character_class_escape_token1] = ACTIONS(21),
    [aux_sym_character_class_escape_token2] = ACTIONS(23),
    [sym_control_escape] = ACTIONS(25),
    [sym_control_letter_escape] = ACTIONS(5),
    [sym_identity_escape] = ACTIONS(25),
  },
  [4] = {
    [sym_pattern] = STATE(69),
    [sym_alternation] = STATE(58),
    [sym_term] = STATE(53),
    [sym_start_assertion] = STATE(10),
    [sym_lookaround_assertion] = STATE(10),
    [sym__lookahead_assertion] = STATE(16),
    [sym__lookbehind_assertion] = STATE(16),
    [sym_character_class] = STATE(10),
    [sym_anonymous_capturing_group] = STATE(10),
    [sym_named_capturing_group] = STATE(10),
    [sym_non_capturing_group] = STATE(10),
    [sym_backreference_escape] = STATE(10),
    [sym_character_class_escape] = STATE(10),
    [aux_sym_alternation_repeat1] = STATE(52),
    [aux_sym_term_repeat1] = STATE(9),
    [anon_sym_PIPE] = ACTIONS(3),
    [sym_any_character] = ACTIONS(5),
    [anon_sym_CARET] = ACTIONS(7),
    [sym_end_assertion] = ACTIONS(5),
    [sym_boundary_assertion] = ACTIONS(5),
    [sym_non_boundary_assertion] = ACTIONS(5),
    [anon_sym_LPAREN_QMARK] = ACTIONS(9),
    [anon_sym_LPAREN_QMARK_LT] = ACTIONS(11),
    [sym_pattern_character] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_QMARK_COLON] = ACTIONS(17),
    [anon_sym_BSLASHk] = ACTIONS(19),
    [sym_decimal_escape] = ACTIONS(5),
    [aux_sym_character_class_escape_token1] = ACTIONS(21),
    [aux_sym_character_class_escape_token2] = ACTIONS(23),
    [sym_control_escape] = ACTIONS(25),
    [sym_control_letter_escape] = ACTIONS(5),
    [sym_identity_escape] = ACTIONS(25),
  },
  [5] = {
    [sym_pattern] = STATE(67),
    [sym_alternation] = STATE(58),
    [sym_term] = STATE(53),
    [sym_start_assertion] = STATE(10),
    [sym_lookaround_assertion] = STATE(10),
    [sym__lookahead_assertion] = STATE(16),
    [sym__lookbehind_assertion] = STATE(16),
    [sym_character_class] = STATE(10),
    [sym_anonymous_capturing_group] = STATE(10),
    [sym_named_capturing_group] = STATE(10),
    [sym_non_capturing_group] = STATE(10),
    [sym_backreference_escape] = STATE(10),
    [sym_character_class_escape] = STATE(10),
    [aux_sym_alternation_repeat1] = STATE(52),
    [aux_sym_term_repeat1] = STATE(9),
    [anon_sym_PIPE] = ACTIONS(3),
    [sym_any_character] = ACTIONS(5),
    [anon_sym_CARET] = ACTIONS(7),
    [sym_end_assertion] = ACTIONS(5),
    [sym_boundary_assertion] = ACTIONS(5),
    [sym_non_boundary_assertion] = ACTIONS(5),
    [anon_sym_LPAREN_QMARK] = ACTIONS(9),
    [anon_sym_LPAREN_QMARK_LT] = ACTIONS(11),
    [sym_pattern_character] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_QMARK_COLON] = ACTIONS(17),
    [anon_sym_BSLASHk] = ACTIONS(19),
    [sym_decimal_escape] = ACTIONS(5),
    [aux_sym_character_class_escape_token1] = ACTIONS(21),
    [aux_sym_character_class_escape_token2] = ACTIONS(23),
    [sym_control_escape] = ACTIONS(25),
    [sym_control_letter_escape] = ACTIONS(5),
    [sym_identity_escape] = ACTIONS(25),
  },
  [6] = {
    [sym_pattern] = STATE(64),
    [sym_alternation] = STATE(58),
    [sym_term] = STATE(53),
    [sym_start_assertion] = STATE(10),
    [sym_lookaround_assertion] = STATE(10),
    [sym__lookahead_assertion] = STATE(16),
    [sym__lookbehind_assertion] = STATE(16),
    [sym_character_class] = STATE(10),
    [sym_anonymous_capturing_group] = STATE(10),
    [sym_named_capturing_group] = STATE(10),
    [sym_non_capturing_group] = STATE(10),
    [sym_backreference_escape] = STATE(10),
    [sym_character_class_escape] = STATE(10),
    [aux_sym_alternation_repeat1] = STATE(52),
    [aux_sym_term_repeat1] = STATE(9),
    [anon_sym_PIPE] = ACTIONS(3),
    [sym_any_character] = ACTIONS(5),
    [anon_sym_CARET] = ACTIONS(7),
    [sym_end_assertion] = ACTIONS(5),
    [sym_boundary_assertion] = ACTIONS(5),
    [sym_non_boundary_assertion] = ACTIONS(5),
    [anon_sym_LPAREN_QMARK] = ACTIONS(9),
    [anon_sym_LPAREN_QMARK_LT] = ACTIONS(11),
    [sym_pattern_character] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_QMARK_COLON] = ACTIONS(17),
    [anon_sym_BSLASHk] = ACTIONS(19),
    [sym_decimal_escape] = ACTIONS(5),
    [aux_sym_character_class_escape_token1] = ACTIONS(21),
    [aux_sym_character_class_escape_token2] = ACTIONS(23),
    [sym_control_escape] = ACTIONS(25),
    [sym_control_letter_escape] = ACTIONS(5),
    [sym_identity_escape] = ACTIONS(25),
  },
  [7] = {
    [sym_term] = STATE(55),
    [sym_start_assertion] = STATE(10),
    [sym_lookaround_assertion] = STATE(10),
    [sym__lookahead_assertion] = STATE(16),
    [sym__lookbehind_assertion] = STATE(16),
    [sym_character_class] = STATE(10),
    [sym_anonymous_capturing_group] = STATE(10),
    [sym_named_capturing_group] = STATE(10),
    [sym_non_capturing_group] = STATE(10),
    [sym_backreference_escape] = STATE(10),
    [sym_character_class_escape] = STATE(10),
    [aux_sym_term_repeat1] = STATE(9),
    [ts_builtin_sym_end] = ACTIONS(27),
    [anon_sym_PIPE] = ACTIONS(27),
    [sym_any_character] = ACTIONS(5),
    [anon_sym_CARET] = ACTIONS(7),
    [sym_end_assertion] = ACTIONS(5),
    [sym_boundary_assertion] = ACTIONS(5),
    [sym_non_boundary_assertion] = ACTIONS(5),
    [anon_sym_LPAREN_QMARK] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(27),
    [anon_sym_LPAREN_QMARK_LT] = ACTIONS(11),
    [sym_pattern_character] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_QMARK_COLON] = ACTIONS(17),
    [anon_sym_BSLASHk] = ACTIONS(19),
    [sym_decimal_escape] = ACTIONS(5),
    [aux_sym_character_class_escape_token1] = ACTIONS(21),
    [aux_sym_character_class_escape_token2] = ACTIONS(23),
    [sym_control_escape] = ACTIONS(25),
    [sym_control_letter_escape] = ACTIONS(5),
    [sym_identity_escape] = ACTIONS(25),
  },
  [8] = {
    [sym_start_assertion] = STATE(10),
    [sym_lookaround_assertion] = STATE(10),
    [sym__lookahead_assertion] = STATE(16),
    [sym__lookbehind_assertion] = STATE(16),
    [sym_character_class] = STATE(10),
    [sym_anonymous_capturing_group] = STATE(10),
    [sym_named_capturing_group] = STATE(10),
    [sym_non_capturing_group] = STATE(10),
    [sym_backreference_escape] = STATE(10),
    [sym_character_class_escape] = STATE(10),
    [aux_sym_term_repeat1] = STATE(8),
    [ts_builtin_sym_end] = ACTIONS(29),
    [anon_sym_PIPE] = ACTIONS(29),
    [sym_any_character] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(34),
    [sym_end_assertion] = ACTIONS(31),
    [sym_boundary_assertion] = ACTIONS(31),
    [sym_non_boundary_assertion] = ACTIONS(31),
    [anon_sym_LPAREN_QMARK] = ACTIONS(37),
    [anon_sym_RPAREN] = ACTIONS(29),
    [anon_sym_LPAREN_QMARK_LT] = ACTIONS(40),
    [sym_pattern_character] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(43),
    [anon_sym_LPAREN] = ACTIONS(46),
    [anon_sym_LPAREN_QMARK_COLON] = ACTIONS(49),
    [anon_sym_BSLASHk] = ACTIONS(52),
    [sym_decimal_escape] = ACTIONS(31),
    [aux_sym_character_class_escape_token1] = ACTIONS(55),
    [aux_sym_character_class_escape_token2] = ACTIONS(58),
    [sym_control_escape] = ACTIONS(61),
    [sym_control_letter_escape] = ACTIONS(31),
    [sym_identity_escape] = ACTIONS(61),
  },
  [9] = {
    [sym_start_assertion] = STATE(10),
    [sym_lookaround_assertion] = STATE(10),
    [sym__lookahead_assertion] = STATE(16),
    [sym__lookbehind_assertion] = STATE(16),
    [sym_character_class] = STATE(10),
    [sym_anonymous_capturing_group] = STATE(10),
    [sym_named_capturing_group] = STATE(10),
    [sym_non_capturing_group] = STATE(10),
    [sym_backreference_escape] = STATE(10),
    [sym_character_class_escape] = STATE(10),
    [aux_sym_term_repeat1] = STATE(8),
    [ts_builtin_sym_end] = ACTIONS(64),
    [anon_sym_PIPE] = ACTIONS(64),
    [sym_any_character] = ACTIONS(5),
    [anon_sym_CARET] = ACTIONS(7),
    [sym_end_assertion] = ACTIONS(5),
    [sym_boundary_assertion] = ACTIONS(5),
    [sym_non_boundary_assertion] = ACTIONS(5),
    [anon_sym_LPAREN_QMARK] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(64),
    [anon_sym_LPAREN_QMARK_LT] = ACTIONS(11),
    [sym_pattern_character] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_QMARK_COLON] = ACTIONS(17),
    [anon_sym_BSLASHk] = ACTIONS(19),
    [sym_decimal_escape] = ACTIONS(5),
    [aux_sym_character_class_escape_token1] = ACTIONS(21),
    [aux_sym_character_class_escape_token2] = ACTIONS(23),
    [sym_control_escape] = ACTIONS(25),
    [sym_control_letter_escape] = ACTIONS(5),
    [sym_identity_escape] = ACTIONS(25),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 7,
    ACTIONS(70), 1,
      anon_sym_STAR,
    ACTIONS(72), 1,
      anon_sym_QMARK,
    ACTIONS(74), 1,
      anon_sym_PLUS,
    ACTIONS(76), 1,
      anon_sym_LBRACE,
    STATE(31), 4,
      sym_zero_or_more,
      sym_one_or_more,
      sym_optional,
      sym_count_quantifier,
    ACTIONS(68), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(66), 16,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [44] = 2,
    ACTIONS(80), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(78), 20,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_LBRACE,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [74] = 2,
    ACTIONS(84), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(82), 20,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_LBRACE,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [104] = 2,
    ACTIONS(88), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(86), 20,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_LBRACE,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [134] = 2,
    ACTIONS(92), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(90), 20,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_LBRACE,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [164] = 2,
    ACTIONS(96), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(94), 20,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_LBRACE,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [194] = 2,
    ACTIONS(100), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(98), 20,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_LBRACE,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [224] = 2,
    ACTIONS(104), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(102), 20,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_LBRACE,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [254] = 2,
    ACTIONS(108), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(106), 20,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_LBRACE,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [284] = 2,
    ACTIONS(112), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(110), 20,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_LBRACE,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [314] = 2,
    ACTIONS(116), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(114), 20,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_LBRACE,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [344] = 2,
    ACTIONS(120), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(118), 20,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_LBRACE,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [374] = 2,
    ACTIONS(124), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(122), 20,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_LBRACE,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [404] = 2,
    ACTIONS(128), 5,
      anon_sym_LPAREN_QMARK,
      sym_pattern_character,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(126), 20,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_STAR,
      anon_sym_QMARK,
      anon_sym_PLUS,
      anon_sym_LBRACE,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [434] = 3,
    ACTIONS(134), 1,
      anon_sym_QMARK,
    ACTIONS(132), 4,
      anon_sym_LPAREN_QMARK,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(130), 17,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      sym_pattern_character,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [463] = 3,
    ACTIONS(140), 1,
      anon_sym_QMARK,
    ACTIONS(138), 4,
      anon_sym_LPAREN_QMARK,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(136), 17,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      sym_pattern_character,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [492] = 3,
    ACTIONS(146), 1,
      anon_sym_QMARK,
    ACTIONS(144), 4,
      anon_sym_LPAREN_QMARK,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(142), 17,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      sym_pattern_character,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [521] = 3,
    ACTIONS(152), 1,
      anon_sym_QMARK,
    ACTIONS(150), 4,
      anon_sym_LPAREN_QMARK,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(148), 17,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      sym_pattern_character,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [550] = 3,
    ACTIONS(158), 1,
      anon_sym_QMARK,
    ACTIONS(156), 4,
      anon_sym_LPAREN_QMARK,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(154), 17,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      sym_pattern_character,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [579] = 2,
    ACTIONS(162), 4,
      anon_sym_LPAREN_QMARK,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(160), 17,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      sym_pattern_character,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [605] = 2,
    ACTIONS(166), 4,
      anon_sym_LPAREN_QMARK,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(164), 17,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      sym_pattern_character,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [631] = 2,
    ACTIONS(168), 4,
      anon_sym_LPAREN_QMARK,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(29), 17,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      sym_pattern_character,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [657] = 2,
    ACTIONS(172), 4,
      anon_sym_LPAREN_QMARK,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(170), 17,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      sym_pattern_character,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [683] = 2,
    ACTIONS(176), 4,
      anon_sym_LPAREN_QMARK,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(174), 17,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      sym_pattern_character,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [709] = 2,
    ACTIONS(180), 4,
      anon_sym_LPAREN_QMARK,
      anon_sym_LPAREN,
      sym_control_escape,
      sym_identity_escape,
    ACTIONS(178), 17,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      sym_any_character,
      anon_sym_CARET,
      sym_end_assertion,
      sym_boundary_assertion,
      sym_non_boundary_assertion,
      anon_sym_RPAREN,
      anon_sym_LPAREN_QMARK_LT,
      sym_pattern_character,
      anon_sym_LBRACK,
      anon_sym_LPAREN_QMARK_COLON,
      anon_sym_BSLASHk,
      sym_decimal_escape,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_letter_escape,
  [735] = 8,
    ACTIONS(182), 1,
      anon_sym_CARET,
    ACTIONS(184), 1,
      anon_sym_RBRACK,
    ACTIONS(186), 1,
      anon_sym_DASH,
    ACTIONS(190), 1,
      aux_sym_character_class_escape_token1,
    ACTIONS(192), 1,
      aux_sym_character_class_escape_token2,
    STATE(44), 1,
      sym_character_class_escape,
    STATE(37), 2,
      sym_class_range,
      aux_sym_character_class_repeat1,
    ACTIONS(188), 5,
      anon_sym_BSLASH_DASH,
      sym_class_character,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [765] = 8,
    ACTIONS(186), 1,
      anon_sym_DASH,
    ACTIONS(190), 1,
      aux_sym_character_class_escape_token1,
    ACTIONS(192), 1,
      aux_sym_character_class_escape_token2,
    ACTIONS(194), 1,
      anon_sym_RBRACK,
    ACTIONS(196), 1,
      sym_class_character,
    STATE(44), 1,
      sym_character_class_escape,
    STATE(39), 2,
      sym_class_range,
      aux_sym_character_class_repeat1,
    ACTIONS(188), 4,
      anon_sym_BSLASH_DASH,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [794] = 8,
    ACTIONS(186), 1,
      anon_sym_DASH,
    ACTIONS(190), 1,
      aux_sym_character_class_escape_token1,
    ACTIONS(192), 1,
      aux_sym_character_class_escape_token2,
    ACTIONS(194), 1,
      anon_sym_RBRACK,
    ACTIONS(196), 1,
      sym_class_character,
    STATE(44), 1,
      sym_character_class_escape,
    STATE(38), 2,
      sym_class_range,
      aux_sym_character_class_repeat1,
    ACTIONS(188), 4,
      anon_sym_BSLASH_DASH,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [823] = 8,
    ACTIONS(198), 1,
      anon_sym_RBRACK,
    ACTIONS(200), 1,
      anon_sym_DASH,
    ACTIONS(206), 1,
      sym_class_character,
    ACTIONS(209), 1,
      aux_sym_character_class_escape_token1,
    ACTIONS(212), 1,
      aux_sym_character_class_escape_token2,
    STATE(44), 1,
      sym_character_class_escape,
    STATE(38), 2,
      sym_class_range,
      aux_sym_character_class_repeat1,
    ACTIONS(203), 4,
      anon_sym_BSLASH_DASH,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [852] = 8,
    ACTIONS(186), 1,
      anon_sym_DASH,
    ACTIONS(190), 1,
      aux_sym_character_class_escape_token1,
    ACTIONS(192), 1,
      aux_sym_character_class_escape_token2,
    ACTIONS(196), 1,
      sym_class_character,
    ACTIONS(215), 1,
      anon_sym_RBRACK,
    STATE(44), 1,
      sym_character_class_escape,
    STATE(38), 2,
      sym_class_range,
      aux_sym_character_class_repeat1,
    ACTIONS(188), 4,
      anon_sym_BSLASH_DASH,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [881] = 2,
    ACTIONS(219), 1,
      sym_class_character,
    ACTIONS(217), 8,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_BSLASH_DASH,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [895] = 3,
    ACTIONS(223), 1,
      anon_sym_DASH,
    ACTIONS(226), 1,
      sym_class_character,
    ACTIONS(221), 7,
      anon_sym_RBRACK,
      anon_sym_BSLASH_DASH,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [911] = 2,
    ACTIONS(230), 1,
      sym_class_character,
    ACTIONS(228), 8,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_BSLASH_DASH,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [925] = 2,
    ACTIONS(234), 1,
      sym_class_character,
    ACTIONS(232), 8,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_BSLASH_DASH,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [939] = 3,
    ACTIONS(238), 1,
      anon_sym_DASH,
    ACTIONS(241), 1,
      sym_class_character,
    ACTIONS(236), 7,
      anon_sym_RBRACK,
      anon_sym_BSLASH_DASH,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [955] = 2,
    ACTIONS(78), 1,
      sym_class_character,
    ACTIONS(80), 8,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_BSLASH_DASH,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [969] = 2,
    ACTIONS(245), 1,
      sym_class_character,
    ACTIONS(243), 8,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_BSLASH_DASH,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [983] = 6,
    ACTIONS(190), 1,
      aux_sym_character_class_escape_token1,
    ACTIONS(192), 1,
      aux_sym_character_class_escape_token2,
    ACTIONS(247), 1,
      anon_sym_DASH,
    ACTIONS(251), 1,
      sym_class_character,
    STATE(42), 1,
      sym_character_class_escape,
    ACTIONS(249), 4,
      anon_sym_BSLASH_DASH,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [1005] = 6,
    ACTIONS(190), 1,
      aux_sym_character_class_escape_token1,
    ACTIONS(192), 1,
      aux_sym_character_class_escape_token2,
    ACTIONS(253), 1,
      anon_sym_DASH,
    ACTIONS(257), 1,
      sym_class_character,
    STATE(43), 1,
      sym_character_class_escape,
    ACTIONS(255), 4,
      anon_sym_BSLASH_DASH,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [1027] = 2,
    ACTIONS(106), 1,
      sym_class_character,
    ACTIONS(108), 8,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_BSLASH_DASH,
      aux_sym_character_class_escape_token1,
      aux_sym_character_class_escape_token2,
      sym_control_escape,
      sym_control_letter_escape,
      sym_identity_escape,
  [1041] = 3,
    ACTIONS(3), 1,
      anon_sym_PIPE,
    STATE(51), 1,
      aux_sym_alternation_repeat1,
    ACTIONS(259), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
  [1052] = 3,
    ACTIONS(263), 1,
      anon_sym_PIPE,
    STATE(51), 1,
      aux_sym_alternation_repeat1,
    ACTIONS(261), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
  [1063] = 3,
    ACTIONS(3), 1,
      anon_sym_PIPE,
    STATE(51), 1,
      aux_sym_alternation_repeat1,
    ACTIONS(266), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
  [1074] = 3,
    ACTIONS(3), 1,
      anon_sym_PIPE,
    STATE(50), 1,
      aux_sym_alternation_repeat1,
    ACTIONS(268), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
  [1085] = 2,
    ACTIONS(272), 1,
      sym_group_name,
    ACTIONS(270), 2,
      anon_sym_EQ,
      anon_sym_BANG,
  [1093] = 1,
    ACTIONS(261), 3,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_RPAREN,
  [1099] = 2,
    ACTIONS(274), 1,
      anon_sym_EQ,
    ACTIONS(276), 1,
      anon_sym_RBRACE,
  [1106] = 1,
    ACTIONS(278), 2,
      anon_sym_EQ,
      anon_sym_BANG,
  [1111] = 1,
    ACTIONS(268), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
  [1116] = 2,
    ACTIONS(280), 1,
      sym_unicode_property,
    STATE(74), 1,
      sym_unicode_property_value_expression,
  [1123] = 2,
    ACTIONS(280), 1,
      sym_unicode_property,
    STATE(76), 1,
      sym_unicode_property_value_expression,
  [1130] = 2,
    ACTIONS(282), 1,
      anon_sym_COMMA,
    ACTIONS(284), 1,
      anon_sym_RBRACE,
  [1137] = 1,
    ACTIONS(286), 1,
      anon_sym_LBRACE,
  [1141] = 1,
    ACTIONS(288), 1,
      anon_sym_RPAREN,
  [1145] = 1,
    ACTIONS(290), 1,
      anon_sym_RPAREN,
  [1149] = 1,
    ACTIONS(292), 1,
      sym_group_name,
  [1153] = 1,
    ACTIONS(294), 1,
      sym_unicode_property,
  [1157] = 1,
    ACTIONS(296), 1,
      anon_sym_RPAREN,
  [1161] = 1,
    ACTIONS(298), 1,
      anon_sym_RBRACE,
  [1165] = 1,
    ACTIONS(300), 1,
      anon_sym_RPAREN,
  [1169] = 1,
    ACTIONS(302), 1,
      ts_builtin_sym_end,
  [1173] = 1,
    ACTIONS(304), 1,
      anon_sym_RBRACE,
  [1177] = 1,
    ACTIONS(306), 1,
      sym_decimal_digits,
  [1181] = 1,
    ACTIONS(308), 1,
      anon_sym_GT,
  [1185] = 1,
    ACTIONS(310), 1,
      anon_sym_RBRACE,
  [1189] = 1,
    ACTIONS(312), 1,
      sym_decimal_digits,
  [1193] = 1,
    ACTIONS(314), 1,
      anon_sym_RBRACE,
  [1197] = 1,
    ACTIONS(316), 1,
      anon_sym_RPAREN,
  [1201] = 1,
    ACTIONS(318), 1,
      anon_sym_LBRACE,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(10)] = 0,
  [SMALL_STATE(11)] = 44,
  [SMALL_STATE(12)] = 74,
  [SMALL_STATE(13)] = 104,
  [SMALL_STATE(14)] = 134,
  [SMALL_STATE(15)] = 164,
  [SMALL_STATE(16)] = 194,
  [SMALL_STATE(17)] = 224,
  [SMALL_STATE(18)] = 254,
  [SMALL_STATE(19)] = 284,
  [SMALL_STATE(20)] = 314,
  [SMALL_STATE(21)] = 344,
  [SMALL_STATE(22)] = 374,
  [SMALL_STATE(23)] = 404,
  [SMALL_STATE(24)] = 434,
  [SMALL_STATE(25)] = 463,
  [SMALL_STATE(26)] = 492,
  [SMALL_STATE(27)] = 521,
  [SMALL_STATE(28)] = 550,
  [SMALL_STATE(29)] = 579,
  [SMALL_STATE(30)] = 605,
  [SMALL_STATE(31)] = 631,
  [SMALL_STATE(32)] = 657,
  [SMALL_STATE(33)] = 683,
  [SMALL_STATE(34)] = 709,
  [SMALL_STATE(35)] = 735,
  [SMALL_STATE(36)] = 765,
  [SMALL_STATE(37)] = 794,
  [SMALL_STATE(38)] = 823,
  [SMALL_STATE(39)] = 852,
  [SMALL_STATE(40)] = 881,
  [SMALL_STATE(41)] = 895,
  [SMALL_STATE(42)] = 911,
  [SMALL_STATE(43)] = 925,
  [SMALL_STATE(44)] = 939,
  [SMALL_STATE(45)] = 955,
  [SMALL_STATE(46)] = 969,
  [SMALL_STATE(47)] = 983,
  [SMALL_STATE(48)] = 1005,
  [SMALL_STATE(49)] = 1027,
  [SMALL_STATE(50)] = 1041,
  [SMALL_STATE(51)] = 1052,
  [SMALL_STATE(52)] = 1063,
  [SMALL_STATE(53)] = 1074,
  [SMALL_STATE(54)] = 1085,
  [SMALL_STATE(55)] = 1093,
  [SMALL_STATE(56)] = 1099,
  [SMALL_STATE(57)] = 1106,
  [SMALL_STATE(58)] = 1111,
  [SMALL_STATE(59)] = 1116,
  [SMALL_STATE(60)] = 1123,
  [SMALL_STATE(61)] = 1130,
  [SMALL_STATE(62)] = 1137,
  [SMALL_STATE(63)] = 1141,
  [SMALL_STATE(64)] = 1145,
  [SMALL_STATE(65)] = 1149,
  [SMALL_STATE(66)] = 1153,
  [SMALL_STATE(67)] = 1157,
  [SMALL_STATE(68)] = 1161,
  [SMALL_STATE(69)] = 1165,
  [SMALL_STATE(70)] = 1169,
  [SMALL_STATE(71)] = 1173,
  [SMALL_STATE(72)] = 1177,
  [SMALL_STATE(73)] = 1181,
  [SMALL_STATE(74)] = 1185,
  [SMALL_STATE(75)] = 1189,
  [SMALL_STATE(76)] = 1193,
  [SMALL_STATE(77)] = 1197,
  [SMALL_STATE(78)] = 1201,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(57),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [27] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_alternation_repeat1, 1, 0, 0),
  [29] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_term_repeat1, 2, 0, 0),
  [31] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_term_repeat1, 2, 0, 0), SHIFT_REPEAT(10),
  [34] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_term_repeat1, 2, 0, 0), SHIFT_REPEAT(13),
  [37] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_term_repeat1, 2, 0, 0), SHIFT_REPEAT(57),
  [40] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_term_repeat1, 2, 0, 0), SHIFT_REPEAT(54),
  [43] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_term_repeat1, 2, 0, 0), SHIFT_REPEAT(35),
  [46] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_term_repeat1, 2, 0, 0), SHIFT_REPEAT(5),
  [49] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_term_repeat1, 2, 0, 0), SHIFT_REPEAT(6),
  [52] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_term_repeat1, 2, 0, 0), SHIFT_REPEAT(65),
  [55] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_term_repeat1, 2, 0, 0), SHIFT_REPEAT(18),
  [58] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_term_repeat1, 2, 0, 0), SHIFT_REPEAT(62),
  [61] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_term_repeat1, 2, 0, 0), SHIFT_REPEAT(10),
  [64] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 1, 0, 0),
  [66] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_term_repeat1, 1, 0, 0),
  [68] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_term_repeat1, 1, 0, 0),
  [70] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [72] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [74] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [76] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [78] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_character_class_escape, 4, 0, 0),
  [80] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_character_class_escape, 4, 0, 0),
  [82] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__lookahead_assertion, 4, 0, 0),
  [84] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__lookahead_assertion, 4, 0, 0),
  [86] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_start_assertion, 1, 0, 0),
  [88] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_start_assertion, 1, 0, 0),
  [90] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_non_capturing_group, 3, 0, 0),
  [92] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_non_capturing_group, 3, 0, 0),
  [94] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_capturing_group, 3, 0, 0),
  [96] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_capturing_group, 3, 0, 0),
  [98] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lookaround_assertion, 1, 0, 0),
  [100] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lookaround_assertion, 1, 0, 0),
  [102] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_character_class, 3, 0, 0),
  [104] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_character_class, 3, 0, 0),
  [106] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_character_class_escape, 1, 0, 0),
  [108] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_character_class_escape, 1, 0, 0),
  [110] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__lookbehind_assertion, 4, 0, 0),
  [112] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__lookbehind_assertion, 4, 0, 0),
  [114] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_character_class, 4, 0, 0),
  [116] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_character_class, 4, 0, 0),
  [118] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_backreference_escape, 2, 0, 0),
  [120] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_backreference_escape, 2, 0, 0),
  [122] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_capturing_group, 5, 0, 0),
  [124] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_capturing_group, 5, 0, 0),
  [126] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_character_class, 2, 0, 0),
  [128] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_character_class, 2, 0, 0),
  [130] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_count_quantifier, 3, 0, 0),
  [132] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_count_quantifier, 3, 0, 0),
  [134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [136] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_one_or_more, 1, 0, 0),
  [138] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_one_or_more, 1, 0, 0),
  [140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [142] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_count_quantifier, 5, 0, 0),
  [144] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_count_quantifier, 5, 0, 0),
  [146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [148] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optional, 1, 0, 0),
  [150] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_optional, 1, 0, 0),
  [152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [154] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_zero_or_more, 1, 0, 0),
  [156] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_zero_or_more, 1, 0, 0),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_zero_or_more, 2, 0, 2),
  [162] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_zero_or_more, 2, 0, 2),
  [164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_count_quantifier, 6, 0, 7),
  [166] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_count_quantifier, 6, 0, 7),
  [168] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_term_repeat1, 2, 0, 0),
  [170] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_count_quantifier, 4, 0, 5),
  [172] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_count_quantifier, 4, 0, 5),
  [174] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optional, 2, 0, 2),
  [176] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_optional, 2, 0, 2),
  [178] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_one_or_more, 2, 0, 2),
  [180] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_one_or_more, 2, 0, 2),
  [182] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [184] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [186] = {.entry = {.count = 1, .reusable = false}}, SHIFT(41),
  [188] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [190] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [198] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_character_class_repeat1, 2, 0, 0),
  [200] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_character_class_repeat1, 2, 0, 0), SHIFT_REPEAT(41),
  [203] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_character_class_repeat1, 2, 0, 0), SHIFT_REPEAT(44),
  [206] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_character_class_repeat1, 2, 0, 0), SHIFT_REPEAT(44),
  [209] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_character_class_repeat1, 2, 0, 0), SHIFT_REPEAT(49),
  [212] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_character_class_repeat1, 2, 0, 0), SHIFT_REPEAT(78),
  [215] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [217] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_range, 3, 0, 4),
  [219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_range, 3, 0, 4),
  [221] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_character_class_repeat1, 1, 0, 1),
  [223] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_character_class_repeat1, 1, 0, 1), SHIFT(47),
  [226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_character_class_repeat1, 1, 0, 1),
  [228] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_range, 3, 0, 1),
  [230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_range, 3, 0, 1),
  [232] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_range, 3, 0, 0),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_range, 3, 0, 0),
  [236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_character_class_repeat1, 1, 0, 0),
  [238] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_character_class_repeat1, 1, 0, 0), SHIFT(48),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_character_class_repeat1, 1, 0, 0),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_range, 3, 0, 3),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_range, 3, 0, 3),
  [247] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [249] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [253] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [255] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_alternation, 2, 0, 0),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_alternation_repeat1, 2, 0, 0),
  [263] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_alternation_repeat1, 2, 0, 0), SHIFT_REPEAT(7),
  [266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_alternation, 1, 0, 0),
  [268] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern, 1, 0, 0),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unicode_property_value_expression, 1, 0, 0),
  [278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [302] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unicode_property_value_expression, 3, 0, 6),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_regex(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
