//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//

 // G4 Low energy model: n-n or p-p scattering -- Data
 // THIS FILE contains static array initialization
 // F.W. Jones, L.G. Greeniaus, H.P. Wellisch

// FWJ 27-AUG-2010: extended Coulomb-suppressed data to 5 GeV

 // Table of Cumulative nn or pp Scattering Probabilities
 // To be used for generation as a function of std::cos(theta cm)
 // Coulomb effects are SUPPRESSED
 // -- including pp Coulomb-nuclear interference  
 // NOTE: Assumes angle range to be generated is 0-180 degrees  
 //       even for IDENTICAL particles.  This allows tracking of  
 //       well-defined GEANT4 particles and generation of secondary  
 // Range of validity of tables: 10 - 1200 MeV  
 // Results are extracted from RA Arndt's PSA of 1998  
 // CM Angle range: 0.5 - 179.5 degrees in 1 degree steps  

 #include "G4Types.hh"

 // CM momentum (GeV/c)
 const G4float G4AngularDistributionPP::pcm[NENERGY] = {
     0.685E-01f, 0.969E-01f, 0.137f, 0.181f, 0.217f, 0.237f, 0.256f,
     0.291f, 0.321f, 0.349f, 0.363f, 0.375f, 0.400f, 0.444f,
     0.494f, 0.540f, 0.573f, 0.613f, 0.650f, 0.685f, 0.719f, 0.751f,
     0.781f, 0.810f, 0.839f, 0.866f, 0.893f, 0.919f, 0.944f,
     0.969f, 1.016f, 1.061f, 1.104f, 1.146f, 1.186f, 1.263f,
     1.335f, 1.404f, 1.469f, 1.532f
 };
 
 // Lab energy (GeV)
 const G4float G4AngularDistributionPP::elab[NENERGY] = {
     0.100E-01f, 0.200E-01f, 0.400E-01f, 0.700E-01f, 0.100f, 0.120f, 0.140f,
     0.180f, 0.220f, 0.260f, 0.280f, 0.300f, 0.340f, 0.420f,
     0.520f, 0.620f, 0.700f, 0.800f, 0.900f, 1.00f, 1.10f, 1.20f,
     1.30f, 1.40f, 1.50f, 1.60f, 1.70f, 1.80f, 1.90f,
     2.00f, 2.20f, 2.40f, 2.60f, 2.80f, 3.00f, 3.40f,
     3.80f, 4.20f, 4.60f, 5.00f
 };
 
 // Max dSigma/domega-CM (mb/sr)
 const G4float G4AngularDistributionPP::dsigmax[NENERGY] = {
     63.9f, 29.9f, 14.5f, 8.97f, 7.23f, 6.66f, 6.30f,
     5.89f, 5.68f, 5.57f, 5.56f, 5.57f, 5.74f, 6.38f,
     7.66f, 9.65f, 12.4f, 15.6f, 18.0f, 20.1f, 22.0f, 23.8f,
     26.710f, 28.910f, 31.000f, 32.990f, 34.900f, 36.730f, 38.520f,
     40.270f, 43.680f, 46.950f, 50.100f, 53.160f, 55.880f, 58.820f,
     57.420f, 57.820f, 58.590f, 57.800f
 };
 
 // Total cross section
 const G4float G4AngularDistributionPP::sigtot[NENERGY] = {
     396.f, 179.f, 80.7f, 44.5f, 32.8f, 29.0f, 26.9f,
     24.9f, 24.4f, 24.3f, 24.4f, 24.4f, 24.7f, 25.5f,
     26.4f, 26.1f, 25.6f, 25.1f, 24.4f, 23.4f, 22.4f, 21.5f,
     22.765f, 23.275f, 23.744f, 24.188f, 24.620f, 25.058f, 25.509f,
     25.981f, 26.984f, 28.055f, 29.242f, 30.608f, 32.026f, 34.457f,
     34.394f, 33.885f, 34.122f, 33.603f
 };
 
 const G4float G4AngularDistributionPP::sig[NENERGY][NANGLE] = {
     //------------  0.01 GeV
    {0.00008f,  0.00031f,  0.00070f,  0.00124f,  0.00193f,  0.00278f,  0.00378f,
     0.00494f,  0.00624f,  0.00770f,  0.00932f,  0.01108f,  0.01299f,  0.01506f,
     0.01727f,  0.01963f,  0.02214f,  0.02480f,  0.02760f,  0.03055f,  0.03364f,
     0.03687f,  0.04025f,  0.04377f,  0.04743f,  0.05122f,  0.05515f,  0.05922f,
     0.06342f,  0.06776f,  0.07223f,  0.07682f,  0.08155f,  0.08640f,  0.09138f,
     0.09649f,  0.10171f,  0.10706f,  0.11252f,  0.11810f,  0.12380f,  0.12961f,
     0.13553f,  0.14156f,  0.14770f,  0.15395f,  0.16030f,  0.16675f,  0.17330f,
     0.17995f,  0.18670f,  0.19354f,  0.20047f,  0.20749f,  0.21459f,  0.22179f,
     0.22906f,  0.23642f,  0.24385f,  0.25136f,  0.25895f,  0.26660f,  0.27433f,
     0.28212f,  0.28998f,  0.29790f,  0.30587f,  0.31391f,  0.32200f,  0.33015f,
     0.33834f,  0.34658f,  0.35487f,  0.36320f,  0.37157f,  0.37998f,  0.38842f,
     0.39690f,  0.40540f,  0.41394f,  0.42250f,  0.43108f,  0.43968f,  0.44830f,
     0.45694f,  0.46559f,  0.47424f,  0.48291f,  0.49158f,  0.50025f,  0.50892f,
     0.51759f,  0.52626f,  0.53492f,  0.54356f,  0.55220f,  0.56081f,  0.56941f,
     0.57799f,  0.58655f,  0.59508f,  0.60358f,  0.61206f,  0.62050f,  0.62890f,
     0.63726f,  0.64559f,  0.65387f,  0.66211f,  0.67029f,  0.67843f,  0.68652f,
     0.69455f,  0.70252f,  0.71043f,  0.71828f,  0.72607f,  0.73378f,  0.74143f,
     0.74901f,  0.75651f,  0.76394f,  0.77128f,  0.77855f,  0.78574f,  0.79283f,
     0.79985f,  0.80677f,  0.81360f,  0.82033f,  0.82697f,  0.83352f,  0.83996f,
     0.84630f,  0.85254f,  0.85867f,  0.86469f,  0.87060f,  0.87641f,  0.88209f,
     0.88767f,  0.89312f,  0.89846f,  0.90368f,  0.90877f,  0.91374f,  0.91859f,
     0.92331f,  0.92790f,  0.93236f,  0.93669f,  0.94088f,  0.94494f,  0.94887f,
     0.95266f,  0.95631f,  0.95982f,  0.96319f,  0.96642f,  0.96951f,  0.97245f,
     0.97525f,  0.97790f,  0.98040f,  0.98276f,  0.98497f,  0.98703f,  0.98894f,
     0.99070f,  0.99231f,  0.99377f,  0.99507f,  0.99623f,  0.99723f,  0.99807f,
     0.99877f,  0.99931f,  0.99969f,  0.99992f,  1.00000f},
     //---------  0.02 GeV
    {0.00008f,  0.00032f,  0.00072f,  0.00128f,  0.00199f,  0.00287f,  0.00390f,
     0.00509f,  0.00644f,  0.00795f,  0.00961f,  0.01142f,  0.01339f,  0.01552f,
     0.01779f,  0.02022f,  0.02280f,  0.02553f,  0.02840f,  0.03142f,  0.03459f,
     0.03790f,  0.04136f,  0.04495f,  0.04869f,  0.05256f,  0.05658f,  0.06072f,
     0.06500f,  0.06942f,  0.07396f,  0.07863f,  0.08343f,  0.08835f,  0.09340f,
     0.09857f,  0.10386f,  0.10927f,  0.11479f,  0.12042f,  0.12617f,  0.13203f,
     0.13800f,  0.14407f,  0.15025f,  0.15653f,  0.16290f,  0.16938f,  0.17595f,
     0.18262f,  0.18938f,  0.19622f,  0.20316f,  0.21018f,  0.21728f,  0.22447f,
     0.23173f,  0.23907f,  0.24648f,  0.25397f,  0.26152f,  0.26914f,  0.27683f,
     0.28458f,  0.29240f,  0.30027f,  0.30819f,  0.31617f,  0.32420f,  0.33229f,
     0.34041f,  0.34859f,  0.35680f,  0.36506f,  0.37335f,  0.38168f,  0.39004f,
     0.39843f,  0.40685f,  0.41529f,  0.42376f,  0.43225f,  0.44076f,  0.44928f,
     0.45782f,  0.46637f,  0.47493f,  0.48350f,  0.49207f,  0.50064f,  0.50921f,
     0.51778f,  0.52634f,  0.53490f,  0.54344f,  0.55198f,  0.56050f,  0.56900f,
     0.57748f,  0.58594f,  0.59438f,  0.60279f,  0.61117f,  0.61952f,  0.62783f,
     0.63611f,  0.64435f,  0.65256f,  0.66071f,  0.66883f,  0.67689f,  0.68491f,
     0.69287f,  0.70078f,  0.70863f,  0.71642f,  0.72416f,  0.73182f,  0.73943f,
     0.74696f,  0.75443f,  0.76182f,  0.76914f,  0.77638f,  0.78354f,  0.79062f,
     0.79762f,  0.80453f,  0.81136f,  0.81809f,  0.82473f,  0.83128f,  0.83774f,
     0.84410f,  0.85035f,  0.85651f,  0.86256f,  0.86850f,  0.87434f,  0.88006f,
     0.88568f,  0.89118f,  0.89656f,  0.90183f,  0.90698f,  0.91201f,  0.91691f,
     0.92169f,  0.92635f,  0.93087f,  0.93527f,  0.93953f,  0.94366f,  0.94765f,
     0.95151f,  0.95523f,  0.95882f,  0.96226f,  0.96555f,  0.96871f,  0.97172f,
     0.97458f,  0.97730f,  0.97986f,  0.98228f,  0.98455f,  0.98666f,  0.98863f,
     0.99043f,  0.99209f,  0.99359f,  0.99493f,  0.99612f,  0.99714f,  0.99802f,
     0.99873f,  0.99929f,  0.99968f,  0.99992f,  1.00000f},
     //---------  0.04 GeV
    {0.00009f,  0.00034f,  0.00077f,  0.00138f,  0.00215f,  0.00309f,  0.00421f,
     0.00549f,  0.00694f,  0.00855f,  0.01033f,  0.01228f,  0.01438f,  0.01665f,
     0.01908f,  0.02166f,  0.02440f,  0.02729f,  0.03033f,  0.03352f,  0.03686f,
     0.04034f,  0.04397f,  0.04773f,  0.05164f,  0.05568f,  0.05986f,  0.06417f,
     0.06861f,  0.07318f,  0.07787f,  0.08269f,  0.08763f,  0.09269f,  0.09786f,
     0.10316f,  0.10856f,  0.11408f,  0.11970f,  0.12543f,  0.13127f,  0.13720f,
     0.14324f,  0.14938f,  0.15561f,  0.16194f,  0.16836f,  0.17487f,  0.18146f,
     0.18815f,  0.19491f,  0.20176f,  0.20868f,  0.21569f,  0.22277f,  0.22992f,
     0.23714f,  0.24443f,  0.25179f,  0.25921f,  0.26669f,  0.27424f,  0.28184f,
     0.28949f,  0.29721f,  0.30497f,  0.31278f,  0.32064f,  0.32854f,  0.33649f,
     0.34448f,  0.35250f,  0.36057f,  0.36867f,  0.37680f,  0.38496f,  0.39314f,
     0.40136f,  0.40960f,  0.41786f,  0.42614f,  0.43444f,  0.44275f,  0.45108f,
     0.45942f,  0.46777f,  0.47612f,  0.48448f,  0.49285f,  0.50121f,  0.50958f,
     0.51794f,  0.52630f,  0.53465f,  0.54299f,  0.55132f,  0.55963f,  0.56794f,
     0.57622f,  0.58449f,  0.59273f,  0.60095f,  0.60914f,  0.61731f,  0.62545f,
     0.63355f,  0.64163f,  0.64966f,  0.65766f,  0.66562f,  0.67354f,  0.68141f,
     0.68923f,  0.69701f,  0.70474f,  0.71241f,  0.72003f,  0.72760f,  0.73510f,
     0.74255f,  0.74993f,  0.75725f,  0.76450f,  0.77168f,  0.77878f,  0.78582f,
     0.79278f,  0.79966f,  0.80647f,  0.81319f,  0.81983f,  0.82638f,  0.83285f,
     0.83922f,  0.84551f,  0.85170f,  0.85779f,  0.86379f,  0.86969f,  0.87548f,
     0.88117f,  0.88675f,  0.89223f,  0.89759f,  0.90285f,  0.90799f,  0.91301f,
     0.91791f,  0.92269f,  0.92735f,  0.93189f,  0.93629f,  0.94057f,  0.94472f,
     0.94873f,  0.95261f,  0.95635f,  0.95995f,  0.96341f,  0.96672f,  0.96989f,
     0.97291f,  0.97578f,  0.97850f,  0.98106f,  0.98347f,  0.98572f,  0.98781f,
     0.98974f,  0.99151f,  0.99311f,  0.99455f,  0.99582f,  0.99693f,  0.99786f,
     0.99863f,  0.99923f,  0.99966f,  0.99991f,  1.00000f},
     //---------  0.07 GeV
    {0.00010f,  0.00039f,  0.00087f,  0.00154f,  0.00240f,  0.00345f,  0.00469f,
     0.00611f,  0.00771f,  0.00950f,  0.01146f,  0.01359f,  0.01590f,  0.01837f,
     0.02101f,  0.02381f,  0.02677f,  0.02988f,  0.03314f,  0.03656f,  0.04012f,
     0.04382f,  0.04767f,  0.05165f,  0.05577f,  0.06001f,  0.06439f,  0.06889f,
     0.07352f,  0.07827f,  0.08314f,  0.08812f,  0.09322f,  0.09843f,  0.10376f,
     0.10919f,  0.11472f,  0.12036f,  0.12610f,  0.13193f,  0.13787f,  0.14389f,
     0.15001f,  0.15622f,  0.16252f,  0.16890f,  0.17537f,  0.18191f,  0.18854f,
     0.19524f,  0.20202f,  0.20886f,  0.21578f,  0.22277f,  0.22981f,  0.23693f,
     0.24410f,  0.25133f,  0.25862f,  0.26596f,  0.27335f,  0.28079f,  0.28828f,
     0.29582f,  0.30340f,  0.31102f,  0.31868f,  0.32638f,  0.33411f,  0.34187f,
     0.34967f,  0.35750f,  0.36535f,  0.37323f,  0.38114f,  0.38906f,  0.39701f,
     0.40498f,  0.41296f,  0.42096f,  0.42898f,  0.43700f,  0.44504f,  0.45309f,
     0.46114f,  0.46921f,  0.47727f,  0.48534f,  0.49342f,  0.50149f,  0.50956f,
     0.51763f,  0.52569f,  0.53375f,  0.54181f,  0.54985f,  0.55789f,  0.56591f,
     0.57392f,  0.58191f,  0.58989f,  0.59786f,  0.60580f,  0.61372f,  0.62162f,
     0.62950f,  0.63734f,  0.64517f,  0.65296f,  0.66072f,  0.66845f,  0.67614f,
     0.68380f,  0.69142f,  0.69899f,  0.70653f,  0.71402f,  0.72146f,  0.72886f,
     0.73621f,  0.74350f,  0.75074f,  0.75792f,  0.76504f,  0.77210f,  0.77910f,
     0.78603f,  0.79289f,  0.79969f,  0.80641f,  0.81306f,  0.81963f,  0.82612f,
     0.83253f,  0.83886f,  0.84511f,  0.85126f,  0.85733f,  0.86331f,  0.86919f,
     0.87497f,  0.88066f,  0.88625f,  0.89174f,  0.89712f,  0.90239f,  0.90756f,
     0.91261f,  0.91755f,  0.92238f,  0.92708f,  0.93167f,  0.93614f,  0.94047f,
     0.94469f,  0.94877f,  0.95271f,  0.95653f,  0.96020f,  0.96373f,  0.96712f,
     0.97035f,  0.97344f,  0.97638f,  0.97915f,  0.98177f,  0.98422f,  0.98651f,
     0.98863f,  0.99057f,  0.99234f,  0.99394f,  0.99535f,  0.99657f,  0.99762f,
     0.99847f,  0.99914f,  0.99962f,  0.99990f,  1.00000f},
     //---------  0.1 GeV
    {0.00011f,  0.00042f,  0.00095f,  0.00168f,  0.00262f,  0.00377f,  0.00511f,
     0.00665f,  0.00838f,  0.01030f,  0.01240f,  0.01469f,  0.01714f,  0.01977f,
     0.02257f,  0.02552f,  0.02863f,  0.03189f,  0.03531f,  0.03886f,  0.04256f,
     0.04640f,  0.05037f,  0.05447f,  0.05871f,  0.06306f,  0.06754f,  0.07214f,
     0.07686f,  0.08170f,  0.08664f,  0.09170f,  0.09687f,  0.10214f,  0.10752f,
     0.11300f,  0.11858f,  0.12426f,  0.13004f,  0.13591f,  0.14187f,  0.14792f,
     0.15406f,  0.16028f,  0.16659f,  0.17297f,  0.17944f,  0.18598f,  0.19259f,
     0.19928f,  0.20604f,  0.21286f,  0.21974f,  0.22669f,  0.23370f,  0.24077f,
     0.24789f,  0.25506f,  0.26229f,  0.26956f,  0.27688f,  0.28425f,  0.29166f,
     0.29910f,  0.30659f,  0.31411f,  0.32167f,  0.32926f,  0.33688f,  0.34453f,
     0.35221f,  0.35991f,  0.36764f,  0.37539f,  0.38316f,  0.39096f,  0.39877f,
     0.40660f,  0.41444f,  0.42230f,  0.43017f,  0.43805f,  0.44594f,  0.45384f,
     0.46174f,  0.46966f,  0.47757f,  0.48549f,  0.49342f,  0.50134f,  0.50926f,
     0.51718f,  0.52510f,  0.53301f,  0.54091f,  0.54881f,  0.55670f,  0.56458f,
     0.57244f,  0.58030f,  0.58814f,  0.59596f,  0.60377f,  0.61156f,  0.61933f,
     0.62707f,  0.63480f,  0.64250f,  0.65017f,  0.65782f,  0.66544f,  0.67303f,
     0.68058f,  0.68810f,  0.69559f,  0.70304f,  0.71045f,  0.71781f,  0.72514f,
     0.73242f,  0.73965f,  0.74683f,  0.75396f,  0.76103f,  0.76805f,  0.77502f,
     0.78192f,  0.78876f,  0.79553f,  0.80224f,  0.80888f,  0.81544f,  0.82194f,
     0.82835f,  0.83469f,  0.84095f,  0.84712f,  0.85321f,  0.85922f,  0.86513f,
     0.87095f,  0.87668f,  0.88231f,  0.88785f,  0.89329f,  0.89862f,  0.90385f,
     0.90898f,  0.91400f,  0.91890f,  0.92370f,  0.92838f,  0.93294f,  0.93739f,
     0.94171f,  0.94591f,  0.94998f,  0.95392f,  0.95773f,  0.96140f,  0.96493f,
     0.96832f,  0.97156f,  0.97465f,  0.97758f,  0.98036f,  0.98296f,  0.98541f,
     0.98767f,  0.98976f,  0.99167f,  0.99339f,  0.99492f,  0.99626f,  0.99739f,
     0.99833f,  0.99906f,  0.99958f,  0.99990f,  1.00000f},
     //---------  0.12 GeV
    {0.00011f,  0.00044f,  0.00099f,  0.00175f,  0.00272f,  0.00391f,  0.00530f,
     0.00689f,  0.00867f,  0.01065f,  0.01280f,  0.01514f,  0.01765f,  0.02033f,
     0.02318f,  0.02618f,  0.02933f,  0.03263f,  0.03608f,  0.03966f,  0.04339f,
     0.04724f,  0.05123f,  0.05534f,  0.05958f,  0.06394f,  0.06842f,  0.07302f,
     0.07773f,  0.08255f,  0.08748f,  0.09252f,  0.09767f,  0.10292f,  0.10827f,
     0.11372f,  0.11927f,  0.12492f,  0.13066f,  0.13649f,  0.14242f,  0.14843f,
     0.15453f,  0.16071f,  0.16697f,  0.17332f,  0.17974f,  0.18624f,  0.19281f,
     0.19945f,  0.20617f,  0.21295f,  0.21979f,  0.22670f,  0.23367f,  0.24070f,
     0.24778f,  0.25492f,  0.26211f,  0.26935f,  0.27664f,  0.28398f,  0.29136f,
     0.29878f,  0.30624f,  0.31375f,  0.32129f,  0.32886f,  0.33647f,  0.34411f,
     0.35178f,  0.35948f,  0.36720f,  0.37495f,  0.38273f,  0.39052f,  0.39834f,
     0.40618f,  0.41403f,  0.42190f,  0.42978f,  0.43768f,  0.44559f,  0.45351f,
     0.46144f,  0.46937f,  0.47731f,  0.48525f,  0.49320f,  0.50114f,  0.50909f,
     0.51703f,  0.52497f,  0.53291f,  0.54084f,  0.54876f,  0.55667f,  0.56456f,
     0.57245f,  0.58032f,  0.58818f,  0.59602f,  0.60383f,  0.61163f,  0.61941f,
     0.62717f,  0.63490f,  0.64260f,  0.65027f,  0.65792f,  0.66553f,  0.67311f,
     0.68066f,  0.68817f,  0.69564f,  0.70307f,  0.71046f,  0.71781f,  0.72511f,
     0.73237f,  0.73957f,  0.74673f,  0.75383f,  0.76088f,  0.76787f,  0.77480f,
     0.78166f,  0.78847f,  0.79521f,  0.80188f,  0.80848f,  0.81501f,  0.82147f,
     0.82785f,  0.83415f,  0.84038f,  0.84652f,  0.85257f,  0.85854f,  0.86442f,
     0.87022f,  0.87592f,  0.88152f,  0.88703f,  0.89245f,  0.89776f,  0.90297f,
     0.90808f,  0.91309f,  0.91798f,  0.92277f,  0.92745f,  0.93201f,  0.93646f,
     0.94079f,  0.94500f,  0.94908f,  0.95304f,  0.95687f,  0.96057f,  0.96413f,
     0.96756f,  0.97084f,  0.97397f,  0.97695f,  0.97978f,  0.98244f,  0.98494f,
     0.98726f,  0.98941f,  0.99137f,  0.99315f,  0.99473f,  0.99611f,  0.99729f,
     0.99826f,  0.99902f,  0.99956f,  0.99989f,  1.00000f},
     //---------  0.14 GeV
    {0.00011f,  0.00045f,  0.00101f,  0.00178f,  0.00278f,  0.00398f,  0.00540f,
     0.00701f,  0.00882f,  0.01081f,  0.01299f,  0.01534f,  0.01787f,  0.02055f,
     0.02340f,  0.02640f,  0.02954f,  0.03283f,  0.03626f,  0.03983f,  0.04352f,
     0.04735f,  0.05130f,  0.05537f,  0.05957f,  0.06388f,  0.06830f,  0.07284f,
     0.07750f,  0.08226f,  0.08712f,  0.09210f,  0.09718f,  0.10236f,  0.10764f,
     0.11302f,  0.11850f,  0.12407f,  0.12974f,  0.13550f,  0.14135f,  0.14729f,
     0.15331f,  0.15942f,  0.16562f,  0.17190f,  0.17825f,  0.18469f,  0.19120f,
     0.19778f,  0.20444f,  0.21117f,  0.21797f,  0.22483f,  0.23176f,  0.23875f,
     0.24580f,  0.25292f,  0.26008f,  0.26731f,  0.27458f,  0.28191f,  0.28929f,
     0.29672f,  0.30419f,  0.31171f,  0.31927f,  0.32687f,  0.33451f,  0.34218f,
     0.34990f,  0.35764f,  0.36542f,  0.37323f,  0.38107f,  0.38894f,  0.39683f,
     0.40474f,  0.41268f,  0.42064f,  0.42862f,  0.43661f,  0.44462f,  0.45264f,
     0.46067f,  0.46871f,  0.47676f,  0.48481f,  0.49287f,  0.50093f,  0.50899f,
     0.51704f,  0.52510f,  0.53314f,  0.54118f,  0.54920f,  0.55722f,  0.56522f,
     0.57320f,  0.58117f,  0.58912f,  0.59705f,  0.60495f,  0.61283f,  0.62068f,
     0.62850f,  0.63630f,  0.64406f,  0.65179f,  0.65948f,  0.66714f,  0.67476f,
     0.68234f,  0.68988f,  0.69737f,  0.70482f,  0.71222f,  0.71957f,  0.72688f,
     0.73413f,  0.74132f,  0.74846f,  0.75554f,  0.76257f,  0.76953f,  0.77642f,
     0.78326f,  0.79002f,  0.79672f,  0.80334f,  0.80989f,  0.81637f,  0.82277f,
     0.82909f,  0.83534f,  0.84150f,  0.84757f,  0.85357f,  0.85947f,  0.86529f,
     0.87101f,  0.87664f,  0.88218f,  0.88763f,  0.89298f,  0.89822f,  0.90337f,
     0.90842f,  0.91336f,  0.91820f,  0.92293f,  0.92756f,  0.93207f,  0.93647f,
     0.94075f,  0.94492f,  0.94897f,  0.95290f,  0.95670f,  0.96037f,  0.96392f,
     0.96733f,  0.97060f,  0.97373f,  0.97671f,  0.97954f,  0.98222f,  0.98473f,
     0.98707f,  0.98924f,  0.99122f,  0.99302f,  0.99463f,  0.99603f,  0.99723f,
     0.99822f,  0.99900f,  0.99955f,  0.99989f,  1.00000f},
     //---------  0.18 GeV
    {0.00011f,  0.00045f,  0.00101f,  0.00180f,  0.00279f,  0.00400f,  0.00541f,
     0.00701f,  0.00880f,  0.01077f,  0.01291f,  0.01522f,  0.01768f,  0.02030f,
     0.02307f,  0.02597f,  0.02901f,  0.03218f,  0.03549f,  0.03891f,  0.04246f,
     0.04613f,  0.04991f,  0.05381f,  0.05783f,  0.06195f,  0.06619f,  0.07053f,
     0.07498f,  0.07954f,  0.08420f,  0.08897f,  0.09384f,  0.09881f,  0.10388f,
     0.10905f,  0.11432f,  0.11969f,  0.12515f,  0.13071f,  0.13637f,  0.14212f,
     0.14796f,  0.15390f,  0.15993f,  0.16605f,  0.17225f,  0.17855f,  0.18493f,
     0.19140f,  0.19795f,  0.20458f,  0.21129f,  0.21809f,  0.22496f,  0.23191f,
     0.23893f,  0.24602f,  0.25319f,  0.26043f,  0.26773f,  0.27510f,  0.28254f,
     0.29004f,  0.29760f,  0.30522f,  0.31289f,  0.32063f,  0.32841f,  0.33625f,
     0.34414f,  0.35207f,  0.36006f,  0.36808f,  0.37615f,  0.38426f,  0.39240f,
     0.40058f,  0.40880f,  0.41704f,  0.42531f,  0.43360f,  0.44192f,  0.45026f,
     0.45862f,  0.46699f,  0.47537f,  0.48376f,  0.49215f,  0.50055f,  0.50895f,
     0.51734f,  0.52573f,  0.53411f,  0.54248f,  0.55083f,  0.55917f,  0.56748f,
     0.57578f,  0.58404f,  0.59228f,  0.60049f,  0.60867f,  0.61681f,  0.62491f,
     0.63297f,  0.64099f,  0.64896f,  0.65689f,  0.66477f,  0.67260f,  0.68038f,
     0.68810f,  0.69577f,  0.70337f,  0.71092f,  0.71841f,  0.72583f,  0.73319f,
     0.74048f,  0.74770f,  0.75486f,  0.76194f,  0.76894f,  0.77587f,  0.78273f,
     0.78950f,  0.79620f,  0.80281f,  0.80935f,  0.81579f,  0.82216f,  0.82843f,
     0.83462f,  0.84071f,  0.84672f,  0.85264f,  0.85846f,  0.86419f,  0.86982f,
     0.87536f,  0.88081f,  0.88615f,  0.89140f,  0.89655f,  0.90160f,  0.90655f,
     0.91139f,  0.91614f,  0.92078f,  0.92532f,  0.92975f,  0.93407f,  0.93829f,
     0.94239f,  0.94639f,  0.95027f,  0.95404f,  0.95770f,  0.96123f,  0.96464f,
     0.96793f,  0.97109f,  0.97412f,  0.97701f,  0.97976f,  0.98237f,  0.98483f,
     0.98713f,  0.98926f,  0.99123f,  0.99301f,  0.99461f,  0.99601f,  0.99721f,
     0.99821f,  0.99899f,  0.99955f,  0.99989f,  1.00000f},
     //---------  0.22 GeV
    {0.00011f,  0.00045f,  0.00100f,  0.00177f,  0.00274f,  0.00392f,  0.00529f,
     0.00685f,  0.00858f,  0.01049f,  0.01255f,  0.01477f,  0.01714f,  0.01964f,
     0.02229f,  0.02506f,  0.02796f,  0.03099f,  0.03414f,  0.03740f,  0.04078f,
     0.04428f,  0.04789f,  0.05161f,  0.05544f,  0.05938f,  0.06343f,  0.06759f,
     0.07186f,  0.07623f,  0.08071f,  0.08529f,  0.08998f,  0.09477f,  0.09967f,
     0.10467f,  0.10977f,  0.11498f,  0.12029f,  0.12571f,  0.13122f,  0.13684f,
     0.14256f,  0.14839f,  0.15431f,  0.16033f,  0.16645f,  0.17267f,  0.17898f,
     0.18540f,  0.19190f,  0.19850f,  0.20519f,  0.21197f,  0.21884f,  0.22580f,
     0.23284f,  0.23997f,  0.24718f,  0.25447f,  0.26183f,  0.26928f,  0.27680f,
     0.28440f,  0.29206f,  0.29980f,  0.30760f,  0.31547f,  0.32340f,  0.33139f,
     0.33945f,  0.34755f,  0.35572f,  0.36394f,  0.37220f,  0.38052f,  0.38887f,
     0.39728f,  0.40572f,  0.41419f,  0.42270f,  0.43124f,  0.43981f,  0.44840f,
     0.45702f,  0.46565f,  0.47429f,  0.48295f,  0.49161f,  0.50028f,  0.50894f,
     0.51760f,  0.52626f,  0.53490f,  0.54354f,  0.55215f,  0.56074f,  0.56931f,
     0.57785f,  0.58636f,  0.59484f,  0.60328f,  0.61168f,  0.62004f,  0.62835f,
     0.63662f,  0.64483f,  0.65300f,  0.66110f,  0.66916f,  0.67715f,  0.68508f,
     0.69294f,  0.70075f,  0.70848f,  0.71614f,  0.72373f,  0.73125f,  0.73869f,
     0.74606f,  0.75334f,  0.76055f,  0.76767f,  0.77470f,  0.78165f,  0.78852f,
     0.79529f,  0.80197f,  0.80856f,  0.81506f,  0.82146f,  0.82776f,  0.83397f,
     0.84008f,  0.84609f,  0.85200f,  0.85781f,  0.86352f,  0.86913f,  0.87464f,
     0.88004f,  0.88534f,  0.89053f,  0.89562f,  0.90061f,  0.90550f,  0.91028f,
     0.91495f,  0.91952f,  0.92398f,  0.92834f,  0.93259f,  0.93674f,  0.94078f,
     0.94471f,  0.94853f,  0.95224f,  0.95583f,  0.95932f,  0.96269f,  0.96595f,
     0.96909f,  0.97210f,  0.97500f,  0.97776f,  0.98040f,  0.98290f,  0.98526f,
     0.98747f,  0.98953f,  0.99143f,  0.99316f,  0.99472f,  0.99609f,  0.99726f,
     0.99824f,  0.99900f,  0.99956f,  0.99989f,  1.00000f},
     //---------  0.26 GeV
    {0.00011f,  0.00044f,  0.00098f,  0.00173f,  0.00269f,  0.00384f,  0.00518f,
     0.00670f,  0.00838f,  0.01023f,  0.01222f,  0.01436f,  0.01665f,  0.01906f,
     0.02161f,  0.02428f,  0.02707f,  0.02999f,  0.03302f,  0.03617f,  0.03943f,
     0.04281f,  0.04630f,  0.04990f,  0.05361f,  0.05743f,  0.06137f,  0.06541f,
     0.06956f,  0.07382f,  0.07819f,  0.08267f,  0.08726f,  0.09195f,  0.09676f,
     0.10167f,  0.10669f,  0.11182f,  0.11706f,  0.12241f,  0.12787f,  0.13344f,
     0.13911f,  0.14489f,  0.15078f,  0.15678f,  0.16288f,  0.16909f,  0.17540f,
     0.18182f,  0.18834f,  0.19495f,  0.20167f,  0.20849f,  0.21540f,  0.22241f,
     0.22950f,  0.23669f,  0.24397f,  0.25133f,  0.25878f,  0.26631f,  0.27392f,
     0.28160f,  0.28936f,  0.29720f,  0.30510f,  0.31307f,  0.32111f,  0.32921f,
     0.33736f,  0.34558f,  0.35385f,  0.36217f,  0.37054f,  0.37896f,  0.38743f,
     0.39593f,  0.40447f,  0.41305f,  0.42166f,  0.43030f,  0.43897f,  0.44766f,
     0.45636f,  0.46509f,  0.47383f,  0.48258f,  0.49133f,  0.50009f,  0.50885f,
     0.51761f,  0.52636f,  0.53510f,  0.54383f,  0.55254f,  0.56123f,  0.56990f,
     0.57854f,  0.58715f,  0.59573f,  0.60427f,  0.61278f,  0.62125f,  0.62967f,
     0.63804f,  0.64637f,  0.65464f,  0.66286f,  0.67102f,  0.67912f,  0.68716f,
     0.69514f,  0.70304f,  0.71088f,  0.71864f,  0.72633f,  0.73394f,  0.74147f,
     0.74892f,  0.75628f,  0.76356f,  0.77075f,  0.77785f,  0.78485f,  0.79176f,
     0.79858f,  0.80530f,  0.81191f,  0.81843f,  0.82484f,  0.83115f,  0.83736f,
     0.84345f,  0.84945f,  0.85533f,  0.86111f,  0.86678f,  0.87234f,  0.87779f,
     0.88313f,  0.88836f,  0.89349f,  0.89850f,  0.90341f,  0.90821f,  0.91290f,
     0.91748f,  0.92195f,  0.92631f,  0.93056f,  0.93471f,  0.93874f,  0.94267f,
     0.94648f,  0.95019f,  0.95378f,  0.95726f,  0.96063f,  0.96389f,  0.96703f,
     0.97006f,  0.97297f,  0.97576f,  0.97842f,  0.98096f,  0.98338f,  0.98565f,
     0.98779f,  0.98979f,  0.99163f,  0.99331f,  0.99483f,  0.99616f,  0.99731f,
     0.99827f,  0.99902f,  0.99956f,  0.99989f,  1.00000f},
     //---------  0.28 GeV
    {0.00011f,  0.00044f,  0.00098f,  0.00172f,  0.00267f,  0.00382f,  0.00514f,
     0.00664f,  0.00831f,  0.01014f,  0.01211f,  0.01422f,  0.01648f,  0.01886f,
     0.02137f,  0.02401f,  0.02677f,  0.02965f,  0.03265f,  0.03576f,  0.03899f,
     0.04233f,  0.04578f,  0.04935f,  0.05303f,  0.05683f,  0.06073f,  0.06475f,
     0.06888f,  0.07311f,  0.07746f,  0.08192f,  0.08650f,  0.09118f,  0.09597f,
     0.10088f,  0.10589f,  0.11102f,  0.11626f,  0.12161f,  0.12708f,  0.13265f,
     0.13834f,  0.14413f,  0.15004f,  0.15605f,  0.16218f,  0.16841f,  0.17474f,
     0.18119f,  0.18773f,  0.19438f,  0.20113f,  0.20797f,  0.21492f,  0.22195f,
     0.22908f,  0.23630f,  0.24361f,  0.25101f,  0.25848f,  0.26604f,  0.27368f,
     0.28139f,  0.28918f,  0.29704f,  0.30496f,  0.31295f,  0.32101f,  0.32912f,
     0.33730f,  0.34553f,  0.35381f,  0.36214f,  0.37052f,  0.37895f,  0.38741f,
     0.39592f,  0.40446f,  0.41304f,  0.42165f,  0.43029f,  0.43895f,  0.44763f,
     0.45634f,  0.46506f,  0.47379f,  0.48253f,  0.49128f,  0.50003f,  0.50878f,
     0.51753f,  0.52627f,  0.53500f,  0.54373f,  0.55243f,  0.56112f,  0.56978f,
     0.57842f,  0.58703f,  0.59561f,  0.60416f,  0.61267f,  0.62114f,  0.62957f,
     0.63796f,  0.64629f,  0.65458f,  0.66281f,  0.67099f,  0.67911f,  0.68717f,
     0.69516f,  0.70309f,  0.71096f,  0.71875f,  0.72646f,  0.73410f,  0.74166f,
     0.74914f,  0.75654f,  0.76385f,  0.77108f,  0.77821f,  0.78525f,  0.79219f,
     0.79904f,  0.80579f,  0.81243f,  0.81898f,  0.82542f,  0.83176f,  0.83799f,
     0.84411f,  0.85012f,  0.85603f,  0.86182f,  0.86750f,  0.87307f,  0.87853f,
     0.88388f,  0.88912f,  0.89424f,  0.89925f,  0.90415f,  0.90894f,  0.91362f,
     0.91818f,  0.92264f,  0.92698f,  0.93122f,  0.93534f,  0.93935f,  0.94325f,
     0.94704f,  0.95071f,  0.95427f,  0.95773f,  0.96106f,  0.96429f,  0.96739f,
     0.97039f,  0.97326f,  0.97601f,  0.97865f,  0.98116f,  0.98354f,  0.98579f,
     0.98790f,  0.98987f,  0.99170f,  0.99336f,  0.99486f,  0.99619f,  0.99733f,
     0.99828f,  0.99902f,  0.99956f,  0.99989f,  1.00000f},
     //---------  0.30 GeV
    {0.00011f,  0.00044f,  0.00097f,  0.00172f,  0.00267f,  0.00380f,  0.00512f,
     0.00661f,  0.00827f,  0.01008f,  0.01204f,  0.01414f,  0.01637f,  0.01873f,
     0.02122f,  0.02384f,  0.02658f,  0.02944f,  0.03241f,  0.03551f,  0.03872f,
     0.04204f,  0.04548f,  0.04904f,  0.05271f,  0.05650f,  0.06039f,  0.06441f,
     0.06853f,  0.07277f,  0.07712f,  0.08159f,  0.08617f,  0.09086f,  0.09567f,
     0.10059f,  0.10562f,  0.11077f,  0.11604f,  0.12141f,  0.12690f,  0.13251f,
     0.13822f,  0.14405f,  0.14999f,  0.15605f,  0.16221f,  0.16847f,  0.17485f,
     0.18133f,  0.18791f,  0.19460f,  0.20138f,  0.20827f,  0.21525f,  0.22232f,
     0.22948f,  0.23673f,  0.24406f,  0.25148f,  0.25898f,  0.26656f,  0.27422f,
     0.28194f,  0.28974f,  0.29761f,  0.30554f,  0.31353f,  0.32158f,  0.32969f,
     0.33786f,  0.34607f,  0.35434f,  0.36266f,  0.37102f,  0.37942f,  0.38786f,
     0.39634f,  0.40485f,  0.41340f,  0.42197f,  0.43057f,  0.43919f,  0.44784f,
     0.45650f,  0.46518f,  0.47387f,  0.48256f,  0.49127f,  0.49998f,  0.50868f,
     0.51739f,  0.52609f,  0.53478f,  0.54346f,  0.55212f,  0.56077f,  0.56939f,
     0.57800f,  0.58657f,  0.59512f,  0.60364f,  0.61212f,  0.62057f,  0.62897f,
     0.63734f,  0.64566f,  0.65393f,  0.66215f,  0.67032f,  0.67844f,  0.68650f,
     0.69450f,  0.70243f,  0.71030f,  0.71811f,  0.72584f,  0.73350f,  0.74108f,
     0.74858f,  0.75601f,  0.76335f,  0.77060f,  0.77777f,  0.78484f,  0.79182f,
     0.79871f,  0.80550f,  0.81218f,  0.81877f,  0.82525f,  0.83163f,  0.83790f,
     0.84406f,  0.85011f,  0.85605f,  0.86188f,  0.86759f,  0.87320f,  0.87869f,
     0.88406f,  0.88932f,  0.89447f,  0.89950f,  0.90442f,  0.90922f,  0.91391f,
     0.91849f,  0.92295f,  0.92730f,  0.93154f,  0.93566f,  0.93966f,  0.94356f,
     0.94734f,  0.95101f,  0.95456f,  0.95800f,  0.96132f,  0.96452f,  0.96761f,
     0.97059f,  0.97344f,  0.97618f,  0.97879f,  0.98128f,  0.98364f,  0.98587f,
     0.98797f,  0.98993f,  0.99173f,  0.99339f,  0.99488f,  0.99620f,  0.99733f,
     0.99828f,  0.99903f,  0.99957f,  0.99989f,  1.00000f},
     //---------  0.34 GeV
    {0.00011f,  0.00044f,  0.00099f,  0.00175f,  0.00271f,  0.00387f,  0.00520f,
     0.00671f,  0.00838f,  0.01021f,  0.01218f,  0.01429f,  0.01654f,  0.01892f,
     0.02143f,  0.02406f,  0.02682f,  0.02969f,  0.03269f,  0.03581f,  0.03905f,
     0.04241f,  0.04588f,  0.04947f,  0.05318f,  0.05701f,  0.06095f,  0.06501f,
     0.06918f,  0.07347f,  0.07788f,  0.08240f,  0.08704f,  0.09180f,  0.09667f,
     0.10166f,  0.10676f,  0.11198f,  0.11732f,  0.12277f,  0.12833f,  0.13401f,
     0.13980f,  0.14571f,  0.15172f,  0.15785f,  0.16408f,  0.17042f,  0.17687f,
     0.18341f,  0.19006f,  0.19680f,  0.20364f,  0.21057f,  0.21760f,  0.22471f,
     0.23190f,  0.23918f,  0.24653f,  0.25397f,  0.26147f,  0.26905f,  0.27670f,
     0.28441f,  0.29218f,  0.30002f,  0.30791f,  0.31586f,  0.32386f,  0.33191f,
     0.34001f,  0.34815f,  0.35634f,  0.36457f,  0.37284f,  0.38114f,  0.38948f,
     0.39785f,  0.40624f,  0.41467f,  0.42312f,  0.43159f,  0.44009f,  0.44860f,
     0.45713f,  0.46567f,  0.47422f,  0.48277f,  0.49134f,  0.49990f,  0.50847f,
     0.51703f,  0.52559f,  0.53414f,  0.54268f,  0.55121f,  0.55973f,  0.56822f,
     0.57670f,  0.58516f,  0.59359f,  0.60199f,  0.61036f,  0.61871f,  0.62702f,
     0.63529f,  0.64352f,  0.65172f,  0.65987f,  0.66797f,  0.67603f,  0.68404f,
     0.69199f,  0.69989f,  0.70773f,  0.71551f,  0.72323f,  0.73088f,  0.73847f,
     0.74598f,  0.75342f,  0.76078f,  0.76806f,  0.77526f,  0.78238f,  0.78941f,
     0.79634f,  0.80319f,  0.80994f,  0.81659f,  0.82314f,  0.82959f,  0.83593f,
     0.84216f,  0.84829f,  0.85431f,  0.86022f,  0.86601f,  0.87169f,  0.87726f,
     0.88271f,  0.88805f,  0.89327f,  0.89837f,  0.90336f,  0.90823f,  0.91299f,
     0.91763f,  0.92215f,  0.92655f,  0.93084f,  0.93502f,  0.93907f,  0.94301f,
     0.94684f,  0.95054f,  0.95413f,  0.95761f,  0.96096f,  0.96420f,  0.96732f,
     0.97031f,  0.97319f,  0.97595f,  0.97858f,  0.98109f,  0.98346f,  0.98571f,
     0.98782f,  0.98980f,  0.99162f,  0.99329f,  0.99480f,  0.99613f,  0.99729f,
     0.99825f,  0.99901f,  0.99956f,  0.99989f,  1.00000f},
     //---------  0.42 GeV
    {0.00012f,  0.00048f,  0.00107f,  0.00188f,  0.00291f,  0.00414f,  0.00557f,
     0.00717f,  0.00895f,  0.01089f,  0.01299f,  0.01523f,  0.01762f,  0.02014f,
     0.02281f,  0.02561f,  0.02854f,  0.03160f,  0.03479f,  0.03811f,  0.04155f,
     0.04513f,  0.04882f,  0.05264f,  0.05658f,  0.06064f,  0.06482f,  0.06912f,
     0.07355f,  0.07809f,  0.08275f,  0.08752f,  0.09242f,  0.09742f,  0.10255f,
     0.10779f,  0.11315f,  0.11861f,  0.12419f,  0.12988f,  0.13568f,  0.14159f,
     0.14760f,  0.15372f,  0.15994f,  0.16625f,  0.17266f,  0.17917f,  0.18576f,
     0.19244f,  0.19921f,  0.20606f,  0.21298f,  0.21998f,  0.22705f,  0.23419f,
     0.24139f,  0.24865f,  0.25598f,  0.26335f,  0.27078f,  0.27826f,  0.28579f,
     0.29336f,  0.30098f,  0.30863f,  0.31632f,  0.32405f,  0.33181f,  0.33960f,
     0.34742f,  0.35527f,  0.36315f,  0.37106f,  0.37898f,  0.38694f,  0.39491f,
     0.40290f,  0.41091f,  0.41894f,  0.42698f,  0.43504f,  0.44311f,  0.45119f,
     0.45929f,  0.46739f,  0.47549f,  0.48360f,  0.49172f,  0.49984f,  0.50795f,
     0.51607f,  0.52418f,  0.53229f,  0.54039f,  0.54849f,  0.55657f,  0.56465f,
     0.57271f,  0.58076f,  0.58879f,  0.59680f,  0.60480f,  0.61278f,  0.62073f,
     0.62867f,  0.63658f,  0.64446f,  0.65232f,  0.66015f,  0.66795f,  0.67572f,
     0.68345f,  0.69115f,  0.69881f,  0.70643f,  0.71401f,  0.72154f,  0.72903f,
     0.73647f,  0.74385f,  0.75118f,  0.75845f,  0.76566f,  0.77281f,  0.77988f,
     0.78689f,  0.79382f,  0.80067f,  0.80745f,  0.81414f,  0.82074f,  0.82725f,
     0.83367f,  0.83999f,  0.84621f,  0.85233f,  0.85835f,  0.86426f,  0.87006f,
     0.87576f,  0.88134f,  0.88681f,  0.89217f,  0.89742f,  0.90254f,  0.90756f,
     0.91245f,  0.91723f,  0.92189f,  0.92643f,  0.93086f,  0.93516f,  0.93935f,
     0.94341f,  0.94735f,  0.95117f,  0.95486f,  0.95844f,  0.96188f,  0.96520f,
     0.96839f,  0.97146f,  0.97439f,  0.97719f,  0.97985f,  0.98238f,  0.98477f,
     0.98701f,  0.98910f,  0.99104f,  0.99282f,  0.99443f,  0.99585f,  0.99709f,
     0.99812f,  0.99893f,  0.99952f,  0.99988f,  1.00000f},
     //---------  0.52 GeV
    {0.00014f,  0.00055f,  0.00124f,  0.00219f,  0.00338f,  0.00481f,  0.00647f,
     0.00834f,  0.01041f,  0.01267f,  0.01512f,  0.01775f,  0.02055f,  0.02353f,
     0.02666f,  0.02996f,  0.03341f,  0.03701f,  0.04076f,  0.04466f,  0.04870f,
     0.05288f,  0.05719f,  0.06164f,  0.06621f,  0.07092f,  0.07574f,  0.08069f,
     0.08575f,  0.09093f,  0.09622f,  0.10162f,  0.10713f,  0.11275f,  0.11847f,
     0.12429f,  0.13020f,  0.13621f,  0.14231f,  0.14850f,  0.15477f,  0.16112f,
     0.16755f,  0.17406f,  0.18063f,  0.18726f,  0.19396f,  0.20071f,  0.20751f,
     0.21436f,  0.22126f,  0.22819f,  0.23516f,  0.24217f,  0.24920f,  0.25625f,
     0.26333f,  0.27043f,  0.27754f,  0.28467f,  0.29181f,  0.29896f,  0.30611f,
     0.31328f,  0.32044f,  0.32761f,  0.33478f,  0.34196f,  0.34913f,  0.35631f,
     0.36348f,  0.37066f,  0.37784f,  0.38501f,  0.39219f,  0.39936f,  0.40654f,
     0.41371f,  0.42088f,  0.42806f,  0.43523f,  0.44241f,  0.44959f,  0.45676f,
     0.46394f,  0.47112f,  0.47830f,  0.48547f,  0.49265f,  0.49983f,  0.50701f,
     0.51419f,  0.52137f,  0.52855f,  0.53573f,  0.54291f,  0.55009f,  0.55726f,
     0.56444f,  0.57162f,  0.57880f,  0.58598f,  0.59316f,  0.60034f,  0.60752f,
     0.61470f,  0.62188f,  0.62906f,  0.63624f,  0.64342f,  0.65060f,  0.65778f,
     0.66496f,  0.67214f,  0.67932f,  0.68649f,  0.69366f,  0.70083f,  0.70798f,
     0.71513f,  0.72226f,  0.72938f,  0.73649f,  0.74357f,  0.75064f,  0.75768f,
     0.76469f,  0.77166f,  0.77861f,  0.78551f,  0.79237f,  0.79918f,  0.80593f,
     0.81264f,  0.81928f,  0.82585f,  0.83236f,  0.83880f,  0.84515f,  0.85143f,
     0.85763f,  0.86373f,  0.86975f,  0.87567f,  0.88149f,  0.88721f,  0.89283f,
     0.89834f,  0.90375f,  0.90904f,  0.91423f,  0.91929f,  0.92424f,  0.92907f,
     0.93377f,  0.93835f,  0.94279f,  0.94711f,  0.95129f,  0.95533f,  0.95923f,
     0.96298f,  0.96659f,  0.97004f,  0.97333f,  0.97647f,  0.97944f,  0.98224f,
     0.98487f,  0.98732f,  0.98959f,  0.99166f,  0.99353f,  0.99519f,  0.99662f,
     0.99781f,  0.99876f,  0.99945f,  0.99986f,  1.00000f},
     //---------  0.62 GeV
    {0.00018f,  0.00070f,  0.00158f,  0.00278f,  0.00431f,  0.00615f,  0.00828f,
     0.01070f,  0.01339f,  0.01635f,  0.01956f,  0.02301f,  0.02670f,  0.03062f,
     0.03476f,  0.03912f,  0.04368f,  0.04843f,  0.05337f,  0.05850f,  0.06379f,
     0.06925f,  0.07486f,  0.08062f,  0.08653f,  0.09256f,  0.09872f,  0.10500f,
     0.11139f,  0.11789f,  0.12448f,  0.13117f,  0.13795f,  0.14480f,  0.15172f,
     0.15871f,  0.16575f,  0.17285f,  0.17999f,  0.18716f,  0.19437f,  0.20159f,
     0.20883f,  0.21607f,  0.22332f,  0.23055f,  0.23777f,  0.24497f,  0.25214f,
     0.25928f,  0.26638f,  0.27343f,  0.28044f,  0.28739f,  0.29428f,  0.30112f,
     0.30789f,  0.31460f,  0.32125f,  0.32782f,  0.33433f,  0.34077f,  0.34714f,
     0.35344f,  0.35967f,  0.36584f,  0.37195f,  0.37799f,  0.38396f,  0.38988f,
     0.39574f,  0.40155f,  0.40730f,  0.41301f,  0.41866f,  0.42428f,  0.42985f,
     0.43538f,  0.44087f,  0.44634f,  0.45177f,  0.45718f,  0.46256f,  0.46792f,
     0.47327f,  0.47860f,  0.48391f,  0.48922f,  0.49452f,  0.49982f,  0.50512f,
     0.51043f,  0.51574f,  0.52106f,  0.52639f,  0.53173f,  0.53710f,  0.54248f,
     0.54789f,  0.55333f,  0.55880f,  0.56430f,  0.56983f,  0.57541f,  0.58103f,
     0.58669f,  0.59240f,  0.59816f,  0.60397f,  0.60984f,  0.61576f,  0.62174f,
     0.62779f,  0.63390f,  0.64008f,  0.64632f,  0.65263f,  0.65900f,  0.66545f,
     0.67196f,  0.67855f,  0.68520f,  0.69192f,  0.69870f,  0.70554f,  0.71244f,
     0.71940f,  0.72642f,  0.73348f,  0.74059f,  0.74773f,  0.75491f,  0.76211f,
     0.76934f,  0.77658f,  0.78383f,  0.79108f,  0.79833f,  0.80556f,  0.81277f,
     0.81995f,  0.82709f,  0.83419f,  0.84124f,  0.84824f,  0.85517f,  0.86202f,
     0.86880f,  0.87549f,  0.88209f,  0.88859f,  0.89498f,  0.90126f,  0.90743f,
     0.91346f,  0.91937f,  0.92513f,  0.93074f,  0.93620f,  0.94150f,  0.94662f,
     0.95157f,  0.95632f,  0.96088f,  0.96524f,  0.96938f,  0.97330f,  0.97699f,
     0.98044f,  0.98365f,  0.98660f,  0.98930f,  0.99171f,  0.99385f,  0.99569f,
     0.99722f,  0.99842f,  0.99930f,  0.99982f,  1.00000f},
     //---------  0.70 GeV
    {0.00023f,  0.00093f,  0.00207f,  0.00366f,  0.00567f,  0.00810f,  0.01091f,
     0.01410f,  0.01765f,  0.02155f,  0.02578f,  0.03032f,  0.03517f,  0.04031f,
     0.04572f,  0.05139f,  0.05731f,  0.06345f,  0.06981f,  0.07636f,  0.08310f,
     0.09002f,  0.09708f,  0.10429f,  0.11163f,  0.11908f,  0.12665f,  0.13430f,
     0.14203f,  0.14984f,  0.15771f,  0.16562f,  0.17357f,  0.18155f,  0.18955f,
     0.19755f,  0.20555f,  0.21354f,  0.22150f,  0.22942f,  0.23731f,  0.24514f,
     0.25290f,  0.26060f,  0.26822f,  0.27575f,  0.28318f,  0.29052f,  0.29774f,
     0.30486f,  0.31185f,  0.31873f,  0.32548f,  0.33210f,  0.33859f,  0.34496f,
     0.35118f,  0.35728f,  0.36325f,  0.36908f,  0.37479f,  0.38036f,  0.38581f,
     0.39114f,  0.39635f,  0.40145f,  0.40643f,  0.41130f,  0.41606f,  0.42073f,
     0.42529f,  0.42977f,  0.43416f,  0.43846f,  0.44268f,  0.44683f,  0.45091f,
     0.45493f,  0.45888f,  0.46278f,  0.46663f,  0.47043f,  0.47419f,  0.47792f,
     0.48161f,  0.48528f,  0.48893f,  0.49256f,  0.49619f,  0.49981f,  0.50342f,
     0.50705f,  0.51068f,  0.51433f,  0.51800f,  0.52170f,  0.52543f,  0.52919f,
     0.53300f,  0.53685f,  0.54075f,  0.54471f,  0.54872f,  0.55281f,  0.55696f,
     0.56119f,  0.56550f,  0.56989f,  0.57437f,  0.57894f,  0.58361f,  0.58839f,
     0.59326f,  0.59825f,  0.60335f,  0.60856f,  0.61390f,  0.61936f,  0.62494f,
     0.63065f,  0.63650f,  0.64247f,  0.64857f,  0.65481f,  0.66118f,  0.66768f,
     0.67431f,  0.68107f,  0.68795f,  0.69496f,  0.70208f,  0.70931f,  0.71665f,
     0.72410f,  0.73164f,  0.73926f,  0.74696f,  0.75474f,  0.76258f,  0.77047f,
     0.77840f,  0.78637f,  0.79436f,  0.80237f,  0.81037f,  0.81838f,  0.82636f,
     0.83432f,  0.84224f,  0.85011f,  0.85792f,  0.86566f,  0.87332f,  0.88088f,
     0.88834f,  0.89568f,  0.90289f,  0.90996f,  0.91688f,  0.92362f,  0.93018f,
     0.93654f,  0.94268f,  0.94860f,  0.95427f,  0.95968f,  0.96482f,  0.96967f,
     0.97422f,  0.97845f,  0.98235f,  0.98590f,  0.98909f,  0.99190f,  0.99433f,
     0.99634f,  0.99793f,  0.99907f,  0.99977f,  1.00000f},
     //---------  0.80 GeV
    {0.00030f,  0.00119f,  0.00266f,  0.00469f,  0.00727f,  0.01037f,  0.01397f,
     0.01805f,  0.02259f,  0.02756f,  0.03294f,  0.03872f,  0.04486f,  0.05135f,
     0.05816f,  0.06528f,  0.07267f,  0.08031f,  0.08818f,  0.09626f,  0.10452f,
     0.11294f,  0.12151f,  0.13020f,  0.13899f,  0.14786f,  0.15680f,  0.16579f,
     0.17481f,  0.18385f,  0.19288f,  0.20190f,  0.21089f,  0.21984f,  0.22873f,
     0.23755f,  0.24629f,  0.25493f,  0.26346f,  0.27187f,  0.28016f,  0.28830f,
     0.29630f,  0.30414f,  0.31182f,  0.31933f,  0.32666f,  0.33381f,  0.34078f,
     0.34756f,  0.35415f,  0.36055f,  0.36677f,  0.37279f,  0.37863f,  0.38428f,
     0.38974f,  0.39503f,  0.40014f,  0.40507f,  0.40984f,  0.41445f,  0.41890f,
     0.42319f,  0.42734f,  0.43134f,  0.43521f,  0.43895f,  0.44257f,  0.44607f,
     0.44945f,  0.45273f,  0.45590f,  0.45898f,  0.46197f,  0.46487f,  0.46770f,
     0.47045f,  0.47314f,  0.47576f,  0.47833f,  0.48084f,  0.48331f,  0.48574f,
     0.48814f,  0.49051f,  0.49286f,  0.49518f,  0.49750f,  0.49981f,  0.50212f,
     0.50444f,  0.50677f,  0.50912f,  0.51149f,  0.51388f,  0.51632f,  0.51879f,
     0.52130f,  0.52387f,  0.52650f,  0.52918f,  0.53194f,  0.53477f,  0.53767f,
     0.54067f,  0.54375f,  0.54693f,  0.55021f,  0.55359f,  0.55709f,  0.56071f,
     0.56445f,  0.56833f,  0.57234f,  0.57649f,  0.58079f,  0.58524f,  0.58985f,
     0.59463f,  0.59957f,  0.60468f,  0.60997f,  0.61545f,  0.62110f,  0.62694f,
     0.63297f,  0.63919f,  0.64560f,  0.65220f,  0.65899f,  0.66597f,  0.67313f,
     0.68047f,  0.68798f,  0.69567f,  0.70351f,  0.71152f,  0.71967f,  0.72796f,
     0.73638f,  0.74492f,  0.75357f,  0.76231f,  0.77114f,  0.78004f,  0.78899f,
     0.79799f,  0.80702f,  0.81606f,  0.82511f,  0.83413f,  0.84313f,  0.85207f,
     0.86095f,  0.86975f,  0.87844f,  0.88701f,  0.89544f,  0.90371f,  0.91179f,
     0.91966f,  0.92731f,  0.93470f,  0.94182f,  0.94863f,  0.95512f,  0.96127f,
     0.96705f,  0.97243f,  0.97740f,  0.98194f,  0.98602f,  0.98962f,  0.99273f,
     0.99531f,  0.99734f,  0.99881f,  0.99970f,  1.00000f},
     //---------  0.90 GeV
    {0.00035f,  0.00141f,  0.00316f,  0.00557f,  0.00863f,  0.01231f,  0.01657f,
     0.02139f,  0.02674f,  0.03260f,  0.03893f,  0.04570f,  0.05288f,  0.06045f,
     0.06837f,  0.07660f,  0.08513f,  0.09391f,  0.10292f,  0.11212f,  0.12149f,
     0.13100f,  0.14063f,  0.15034f,  0.16012f,  0.16994f,  0.17978f,  0.18962f,
     0.19944f,  0.20922f,  0.21894f,  0.22859f,  0.23814f,  0.24758f,  0.25690f,
     0.26609f,  0.27511f,  0.28398f,  0.29267f,  0.30117f,  0.30947f,  0.31757f,
     0.32546f,  0.33313f,  0.34057f,  0.34779f,  0.35477f,  0.36153f,  0.36806f,
     0.37435f,  0.38042f,  0.38626f,  0.39187f,  0.39727f,  0.40246f,  0.40743f,
     0.41221f,  0.41679f,  0.42118f,  0.42538f,  0.42942f,  0.43328f,  0.43698f,
     0.44053f,  0.44394f,  0.44720f,  0.45033f,  0.45334f,  0.45622f,  0.45900f,
     0.46167f,  0.46424f,  0.46671f,  0.46910f,  0.47141f,  0.47364f,  0.47580f,
     0.47790f,  0.47993f,  0.48191f,  0.48385f,  0.48573f,  0.48758f,  0.48939f,
     0.49118f,  0.49294f,  0.49468f,  0.49640f,  0.49812f,  0.49983f,  0.50154f,
     0.50325f,  0.50498f,  0.50672f,  0.50848f,  0.51026f,  0.51207f,  0.51392f,
     0.51581f,  0.51774f,  0.51972f,  0.52176f,  0.52386f,  0.52602f,  0.52825f,
     0.53056f,  0.53295f,  0.53543f,  0.53800f,  0.54067f,  0.54344f,  0.54633f,
     0.54934f,  0.55247f,  0.55574f,  0.55915f,  0.56270f,  0.56641f,  0.57027f,
     0.57431f,  0.57852f,  0.58291f,  0.58750f,  0.59228f,  0.59726f,  0.60245f,
     0.60785f,  0.61347f,  0.61932f,  0.62539f,  0.63169f,  0.63822f,  0.64498f,
     0.65198f,  0.65920f,  0.66665f,  0.67433f,  0.68222f,  0.69033f,  0.69864f,
     0.70715f,  0.71585f,  0.72472f,  0.73376f,  0.74295f,  0.75227f,  0.76173f,
     0.77129f,  0.78094f,  0.79067f,  0.80046f,  0.81028f,  0.82013f,  0.82998f,
     0.83980f,  0.84959f,  0.85931f,  0.86894f,  0.87846f,  0.88783f,  0.89704f,
     0.90605f,  0.91483f,  0.92336f,  0.93160f,  0.93952f,  0.94709f,  0.95428f,
     0.96106f,  0.96739f,  0.97325f,  0.97860f,  0.98342f,  0.98769f,  0.99137f,
     0.99443f,  0.99684f,  0.99859f,  0.99965f,  1.00000f},
     //---------  1.00 GeV
    {0.00041f,  0.00164f,  0.00366f,  0.00645f,  0.00999f,  0.01423f,  0.01914f,
     0.02469f,  0.03084f,  0.03755f,  0.04478f,  0.05250f,  0.06066f,  0.06923f,
     0.07815f,  0.08741f,  0.09694f,  0.10672f,  0.11670f,  0.12685f,  0.13714f,
     0.14753f,  0.15800f,  0.16850f,  0.17902f,  0.18953f,  0.20000f,  0.21041f,
     0.22075f,  0.23098f,  0.24109f,  0.25107f,  0.26088f,  0.27053f,  0.27999f,
     0.28924f,  0.29829f,  0.30711f,  0.31569f,  0.32403f,  0.33212f,  0.33995f,
     0.34752f,  0.35483f,  0.36187f,  0.36864f,  0.37515f,  0.38140f,  0.38738f,
     0.39312f,  0.39861f,  0.40385f,  0.40886f,  0.41364f,  0.41820f,  0.42256f,
     0.42671f,  0.43066f,  0.43443f,  0.43803f,  0.44146f,  0.44473f,  0.44786f,
     0.45084f,  0.45368f,  0.45640f,  0.45901f,  0.46150f,  0.46389f,  0.46618f,
     0.46838f,  0.47050f,  0.47253f,  0.47450f,  0.47639f,  0.47823f,  0.48000f,
     0.48172f,  0.48340f,  0.48503f,  0.48662f,  0.48818f,  0.48970f,  0.49120f,
     0.49267f,  0.49413f,  0.49557f,  0.49700f,  0.49842f,  0.49984f,  0.50125f,
     0.50267f,  0.50410f,  0.50554f,  0.50700f,  0.50847f,  0.50997f,  0.51150f,
     0.51305f,  0.51464f,  0.51627f,  0.51795f,  0.51967f,  0.52145f,  0.52328f,
     0.52518f,  0.52714f,  0.52918f,  0.53129f,  0.53350f,  0.53579f,  0.53818f,
     0.54067f,  0.54328f,  0.54600f,  0.54885f,  0.55183f,  0.55495f,  0.55823f,
     0.56166f,  0.56526f,  0.56904f,  0.57300f,  0.57715f,  0.58151f,  0.58607f,
     0.59086f,  0.59587f,  0.60112f,  0.60661f,  0.61235f,  0.61835f,  0.62460f,
     0.63112f,  0.63790f,  0.64494f,  0.65226f,  0.65983f,  0.66767f,  0.67577f,
     0.68412f,  0.69271f,  0.70153f,  0.71059f,  0.71985f,  0.72932f,  0.73897f,
     0.74880f,  0.75878f,  0.76890f,  0.77914f,  0.78948f,  0.79990f,  0.81038f,
     0.82089f,  0.83142f,  0.84193f,  0.85240f,  0.86280f,  0.87309f,  0.88325f,
     0.89324f,  0.90302f,  0.91256f,  0.92181f,  0.93075f,  0.93931f,  0.94748f,
     0.95520f,  0.96244f,  0.96915f,  0.97530f,  0.98085f,  0.98576f,  0.99001f,
     0.99355f,  0.99634f,  0.99836f,  0.99959f,  1.00000f},
     //---------  1.10 GeV
    {0.00047f,  0.00187f,  0.00418f,  0.00737f,  0.01140f,  0.01623f,  0.02181f,
     0.02811f,  0.03507f,  0.04265f,  0.05079f,  0.05946f,  0.06859f,  0.07814f,
     0.08806f,  0.09829f,  0.10878f,  0.11950f,  0.13038f,  0.14140f,  0.15250f,
     0.16366f,  0.17483f,  0.18598f,  0.19709f,  0.20813f,  0.21906f,  0.22987f,
     0.24053f,  0.25103f,  0.26134f,  0.27145f,  0.28134f,  0.29100f,  0.30041f,
     0.30956f,  0.31844f,  0.32704f,  0.33536f,  0.34339f,  0.35112f,  0.35856f,
     0.36569f,  0.37253f,  0.37908f,  0.38533f,  0.39130f,  0.39699f,  0.40241f,
     0.40756f,  0.41246f,  0.41712f,  0.42154f,  0.42574f,  0.42972f,  0.43351f,
     0.43710f,  0.44050f,  0.44374f,  0.44682f,  0.44974f,  0.45253f,  0.45518f,
     0.45770f,  0.46011f,  0.46241f,  0.46461f,  0.46672f,  0.46874f,  0.47068f,
     0.47254f,  0.47434f,  0.47607f,  0.47774f,  0.47936f,  0.48093f,  0.48246f,
     0.48395f,  0.48540f,  0.48681f,  0.48820f,  0.48956f,  0.49089f,  0.49221f,
     0.49351f,  0.49479f,  0.49606f,  0.49733f,  0.49859f,  0.49984f,  0.50110f,
     0.50236f,  0.50362f,  0.50490f,  0.50618f,  0.50748f,  0.50879f,  0.51013f,
     0.51149f,  0.51288f,  0.51429f,  0.51574f,  0.51722f,  0.51875f,  0.52032f,
     0.52194f,  0.52362f,  0.52535f,  0.52714f,  0.52901f,  0.53095f,  0.53297f,
     0.53507f,  0.53728f,  0.53958f,  0.54199f,  0.54452f,  0.54717f,  0.54995f,
     0.55288f,  0.55596f,  0.55920f,  0.56261f,  0.56620f,  0.56999f,  0.57397f,
     0.57818f,  0.58260f,  0.58726f,  0.59217f,  0.59733f,  0.60275f,  0.60845f,
     0.61442f,  0.62068f,  0.62723f,  0.63408f,  0.64123f,  0.64867f,  0.65641f,
     0.66444f,  0.67277f,  0.68138f,  0.69027f,  0.69943f,  0.70884f,  0.71851f,
     0.72841f,  0.73852f,  0.74884f,  0.75935f,  0.77002f,  0.78083f,  0.79178f,
     0.80282f,  0.81393f,  0.82509f,  0.83627f,  0.84743f,  0.85854f,  0.86956f,
     0.88046f,  0.89117f,  0.90167f,  0.91191f,  0.92183f,  0.93138f,  0.94052f,
     0.94919f,  0.95734f,  0.96492f,  0.97188f,  0.97818f,  0.98377f,  0.98860f,
     0.99263f,  0.99582f,  0.99813f,  0.99953f,  1.00000f},
     //---------  1.20 GeV
    {0.00053f,  0.00211f,  0.00472f,  0.00832f,  0.01286f,  0.01829f,  0.02456f,
     0.03163f,  0.03942f,  0.04788f,  0.05695f,  0.06657f,  0.07667f,  0.08720f,
     0.09809f,  0.10927f,  0.12069f,  0.13230f,  0.14403f,  0.15585f,  0.16769f,
     0.17953f,  0.19131f,  0.20301f,  0.21460f,  0.22604f,  0.23731f,  0.24838f,
     0.25924f,  0.26986f,  0.28023f,  0.29033f,  0.30015f,  0.30968f,  0.31890f,
     0.32782f,  0.33641f,  0.34469f,  0.35263f,  0.36025f,  0.36754f,  0.37450f,
     0.38114f,  0.38746f,  0.39347f,  0.39918f,  0.40459f,  0.40971f,  0.41456f,
     0.41915f,  0.42349f,  0.42759f,  0.43147f,  0.43513f,  0.43860f,  0.44187f,
     0.44497f,  0.44791f,  0.45069f,  0.45332f,  0.45583f,  0.45821f,  0.46047f,
     0.46263f,  0.46469f,  0.46666f,  0.46855f,  0.47036f,  0.47210f,  0.47377f,
     0.47538f,  0.47694f,  0.47845f,  0.47991f,  0.48133f,  0.48272f,  0.48407f,
     0.48539f,  0.48668f,  0.48795f,  0.48920f,  0.49043f,  0.49165f,  0.49284f,
     0.49403f,  0.49521f,  0.49637f,  0.49754f,  0.49869f,  0.49985f,  0.50101f,
     0.50216f,  0.50333f,  0.50449f,  0.50567f,  0.50685f,  0.50805f,  0.50927f,
     0.51049f,  0.51174f,  0.51301f,  0.51431f,  0.51563f,  0.51698f,  0.51836f,
     0.51979f,  0.52125f,  0.52276f,  0.52432f,  0.52593f,  0.52760f,  0.52934f,
     0.53115f,  0.53303f,  0.53500f,  0.53707f,  0.53923f,  0.54149f,  0.54387f,
     0.54638f,  0.54902f,  0.55180f,  0.55474f,  0.55784f,  0.56112f,  0.56459f,
     0.56825f,  0.57213f,  0.57624f,  0.58058f,  0.58518f,  0.59003f,  0.59516f,
     0.60058f,  0.60629f,  0.61231f,  0.61863f,  0.62528f,  0.63225f,  0.63955f,
     0.64717f,  0.65512f,  0.66340f,  0.67201f,  0.68093f,  0.69016f,  0.69970f,
     0.70953f,  0.71964f,  0.73001f,  0.74064f,  0.75151f,  0.76259f,  0.77386f,
     0.78531f,  0.79690f,  0.80861f,  0.82040f,  0.83224f,  0.84409f,  0.85591f,
     0.86765f,  0.87926f,  0.89069f,  0.90188f,  0.91277f,  0.92330f,  0.93341f,
     0.94303f,  0.95210f,  0.96057f,  0.96836f,  0.97543f,  0.98170f,  0.98714f,
     0.99168f,  0.99528f,  0.99789f,  0.99947f,  1.00000f},
  //---------  1.3 GeV
  {0.00015f,  0.00134f,  0.00371f,  0.00720f,  0.01178f,  0.01737f,  0.02391f,
   0.03133f,  0.03957f,  0.04856f,  0.05823f,  0.06850f,  0.07930f,  0.09057f,
   0.10223f,  0.11420f,  0.12643f,  0.13883f,  0.15137f,  0.16396f,  0.17656f,
   0.18913f,  0.20161f,  0.21395f,  0.22613f,  0.23811f,  0.24987f,  0.26137f,
   0.27259f,  0.28351f,  0.29412f,  0.30440f,  0.31434f,  0.32392f,  0.33315f,
   0.34201f,  0.35050f,  0.35861f,  0.36636f,  0.37373f,  0.38074f,  0.38739f,
   0.39369f,  0.39964f,  0.40526f,  0.41056f,  0.41555f,  0.42024f,  0.42465f,
   0.42879f,  0.43269f,  0.43634f,  0.43978f,  0.44300f,  0.44604f,  0.44890f,
   0.45160f,  0.45414f,  0.45654f,  0.45882f,  0.46097f,  0.46302f,  0.46497f,
   0.46682f,  0.46860f,  0.47029f,  0.47192f,  0.47348f,  0.47498f,  0.47642f,
   0.47782f,  0.47918f,  0.48049f,  0.48177f,  0.48301f,  0.48423f,  0.48542f,
   0.48659f,  0.48774f,  0.48886f,  0.48998f,  0.49108f,  0.49216f,  0.49324f,
   0.49431f,  0.49537f,  0.49643f,  0.49748f,  0.49853f,  0.49957f,  0.50062f,
   0.50166f,  0.50271f,  0.50376f,  0.50482f,  0.50588f,  0.50695f,  0.50803f,
   0.50911f,  0.51021f,  0.51133f,  0.51246f,  0.51360f,  0.51477f,  0.51596f,
   0.51718f,  0.51842f,  0.51970f,  0.52101f,  0.52237f,  0.52377f,  0.52521f,
   0.52671f,  0.52827f,  0.52990f,  0.53159f,  0.53337f,  0.53522f,  0.53717f,
   0.53922f,  0.54137f,  0.54365f,  0.54605f,  0.54859f,  0.55129f,  0.55415f,
   0.55719f,  0.56041f,  0.56385f,  0.56750f,  0.57139f,  0.57554f,  0.57995f,
   0.58464f,  0.58963f,  0.59492f,  0.60054f,  0.60649f,  0.61279f,  0.61944f,
   0.62645f,  0.63383f,  0.64157f,  0.64969f,  0.65818f,  0.66703f,  0.67626f,
   0.68584f,  0.69578f,  0.70605f,  0.71666f,  0.72759f,  0.73881f,  0.75030f,
   0.76205f,  0.77403f,  0.78621f,  0.79856f,  0.81104f,  0.82360f,  0.83621f,
   0.84880f,  0.86132f,  0.87373f,  0.88595f,  0.89793f,  0.90958f,  0.92085f,
   0.93165f,  0.94192f,  0.95159f,  0.96058f,  0.96882f,  0.97624f,  0.98278f,
   0.98837f,  0.99295f,  0.99644f,  0.99881f,  1.00000f},
  //---------  1.4 GeV
  {0.00017f,  0.00149f,  0.00412f,  0.00800f,  0.01307f,  0.01926f,  0.02649f,
   0.03468f,  0.04375f,  0.05362f,  0.06420f,  0.07541f,  0.08717f,  0.09938f,
   0.11197f,  0.12485f,  0.13795f,  0.15118f,  0.16447f,  0.17777f,  0.19101f,
   0.20414f,  0.21710f,  0.22986f,  0.24237f,  0.25460f,  0.26653f,  0.27812f,
   0.28937f,  0.30024f,  0.31074f,  0.32085f,  0.33055f,  0.33986f,  0.34876f,
   0.35725f,  0.36533f,  0.37302f,  0.38030f,  0.38719f,  0.39371f,  0.39984f,
   0.40562f,  0.41104f,  0.41614f,  0.42091f,  0.42538f,  0.42956f,  0.43347f,
   0.43712f,  0.44054f,  0.44374f,  0.44674f,  0.44954f,  0.45218f,  0.45465f,
   0.45698f,  0.45918f,  0.46125f,  0.46322f,  0.46508f,  0.46685f,  0.46854f,
   0.47015f,  0.47169f,  0.47316f,  0.47458f,  0.47595f,  0.47727f,  0.47854f,
   0.47978f,  0.48098f,  0.48214f,  0.48329f,  0.48440f,  0.48550f,  0.48657f,
   0.48763f,  0.48867f,  0.48970f,  0.49072f,  0.49173f,  0.49273f,  0.49373f,
   0.49472f,  0.49570f,  0.49668f,  0.49766f,  0.49864f,  0.49962f,  0.50059f,
   0.50157f,  0.50254f,  0.50352f,  0.50451f,  0.50549f,  0.50648f,  0.50748f,
   0.50848f,  0.50949f,  0.51051f,  0.51154f,  0.51258f,  0.51364f,  0.51471f,
   0.51581f,  0.51692f,  0.51806f,  0.51923f,  0.52043f,  0.52167f,  0.52294f,
   0.52426f,  0.52562f,  0.52704f,  0.52852f,  0.53006f,  0.53167f,  0.53336f,
   0.53513f,  0.53699f,  0.53895f,  0.54103f,  0.54322f,  0.54555f,  0.54803f,
   0.55066f,  0.55347f,  0.55646f,  0.55966f,  0.56308f,  0.56674f,  0.57065f,
   0.57483f,  0.57929f,  0.58407f,  0.58916f,  0.59459f,  0.60036f,  0.60650f,
   0.61301f,  0.61990f,  0.62719f,  0.63487f,  0.64295f,  0.65144f,  0.66034f,
   0.66965f,  0.67935f,  0.68946f,  0.69995f,  0.71083f,  0.72207f,  0.73367f,
   0.74559f,  0.75782f,  0.77033f,  0.78309f,  0.79604f,  0.80917f,  0.82240f,
   0.83569f,  0.84899f,  0.86222f,  0.87531f,  0.88820f,  0.90078f,  0.91300f,
   0.92476f,  0.93597f,  0.94655f,  0.95642f,  0.96549f,  0.97368f,  0.98091f,
   0.98709f,  0.99216f,  0.99604f,  0.99867f,  1.00000f},
  //---------  1.5 GeV
  {0.00018f,  0.00164f,  0.00453f,  0.00879f,  0.01436f,  0.02113f,  0.02904f,
   0.03798f,  0.04787f,  0.05860f,  0.07008f,  0.08221f,  0.09489f,  0.10802f,
   0.12151f,  0.13525f,  0.14917f,  0.16316f,  0.17717f,  0.19110f,  0.20490f,
   0.21851f,  0.23188f,  0.24496f,  0.25772f,  0.27012f,  0.28213f,  0.29374f,
   0.30493f,  0.31568f,  0.32599f,  0.33586f,  0.34527f,  0.35424f,  0.36276f,
   0.37084f,  0.37849f,  0.38570f,  0.39251f,  0.39890f,  0.40491f,  0.41053f,
   0.41580f,  0.42071f,  0.42530f,  0.42958f,  0.43356f,  0.43727f,  0.44073f,
   0.44394f,  0.44694f,  0.44974f,  0.45235f,  0.45479f,  0.45708f,  0.45923f,
   0.46126f,  0.46317f,  0.46498f,  0.46669f,  0.46832f,  0.46987f,  0.47135f,
   0.47277f,  0.47413f,  0.47544f,  0.47670f,  0.47792f,  0.47910f,  0.48024f,
   0.48135f,  0.48243f,  0.48349f,  0.48452f,  0.48554f,  0.48654f,  0.48752f,
   0.48849f,  0.48945f,  0.49040f,  0.49134f,  0.49228f,  0.49321f,  0.49414f,
   0.49506f,  0.49598f,  0.49690f,  0.49781f,  0.49873f,  0.49964f,  0.50055f,
   0.50147f,  0.50238f,  0.50330f,  0.50421f,  0.50513f,  0.50606f,  0.50698f,
   0.50791f,  0.50885f,  0.50979f,  0.51074f,  0.51170f,  0.51267f,  0.51365f,
   0.51465f,  0.51567f,  0.51670f,  0.51776f,  0.51884f,  0.51995f,  0.52110f,
   0.52228f,  0.52349f,  0.52475f,  0.52606f,  0.52742f,  0.52884f,  0.53032f,
   0.53187f,  0.53350f,  0.53522f,  0.53702f,  0.53893f,  0.54096f,  0.54311f,
   0.54540f,  0.54784f,  0.55045f,  0.55325f,  0.55625f,  0.55947f,  0.56292f,
   0.56663f,  0.57061f,  0.57489f,  0.57948f,  0.58439f,  0.58966f,  0.59528f,
   0.60129f,  0.60769f,  0.61449f,  0.62171f,  0.62935f,  0.63743f,  0.64595f,
   0.65492f,  0.66433f,  0.67420f,  0.68451f,  0.69526f,  0.70645f,  0.71805f,
   0.73007f,  0.74247f,  0.75522f,  0.76830f,  0.78167f,  0.79528f,  0.80908f,
   0.82302f,  0.83702f,  0.85102f,  0.86493f,  0.87868f,  0.89216f,  0.90529f,
   0.91798f,  0.93011f,  0.94159f,  0.95232f,  0.96220f,  0.97114f,  0.97905f,
   0.98583f,  0.99139f,  0.99565f,  0.99854f,  1.00000f},
  //---------  1.6 GeV
  {0.00020f,  0.00179f,  0.00493f,  0.00957f,  0.01561f,  0.02296f,  0.03153f,
   0.04121f,  0.05189f,  0.06345f,  0.07580f,  0.08882f,  0.10238f,  0.11639f,
   0.13073f,  0.14529f,  0.15997f,  0.17468f,  0.18933f,  0.20385f,  0.21816f,
   0.23219f,  0.24591f,  0.25925f,  0.27218f,  0.28468f,  0.29672f,  0.30828f,
   0.31935f,  0.32992f,  0.33999f,  0.34957f,  0.35865f,  0.36724f,  0.37535f,
   0.38300f,  0.39018f,  0.39693f,  0.40324f,  0.40914f,  0.41465f,  0.41978f,
   0.42455f,  0.42899f,  0.43310f,  0.43692f,  0.44046f,  0.44374f,  0.44679f,
   0.44961f,  0.45224f,  0.45469f,  0.45697f,  0.45911f,  0.46111f,  0.46299f,
   0.46476f,  0.46644f,  0.46803f,  0.46954f,  0.47098f,  0.47236f,  0.47368f,
   0.47495f,  0.47617f,  0.47735f,  0.47849f,  0.47959f,  0.48066f,  0.48171f,
   0.48272f,  0.48371f,  0.48468f,  0.48563f,  0.48657f,  0.48749f,  0.48840f,
   0.48930f,  0.49019f,  0.49107f,  0.49195f,  0.49282f,  0.49368f,  0.49455f,
   0.49541f,  0.49626f,  0.49712f,  0.49797f,  0.49883f,  0.49968f,  0.50054f,
   0.50139f,  0.50224f,  0.50310f,  0.50395f,  0.50481f,  0.50567f,  0.50654f,
   0.50740f,  0.50827f,  0.50915f,  0.51003f,  0.51092f,  0.51182f,  0.51273f,
   0.51365f,  0.51458f,  0.51554f,  0.51651f,  0.51750f,  0.51851f,  0.51955f,
   0.52063f,  0.52173f,  0.52287f,  0.52405f,  0.52527f,  0.52654f,  0.52786f,
   0.52924f,  0.53068f,  0.53219f,  0.53378f,  0.53546f,  0.53723f,  0.53911f,
   0.54111f,  0.54325f,  0.54553f,  0.54797f,  0.55060f,  0.55343f,  0.55647f,
   0.55975f,  0.56329f,  0.56711f,  0.57123f,  0.57566f,  0.58043f,  0.58556f,
   0.59107f,  0.59697f,  0.60328f,  0.61003f,  0.61721f,  0.62485f,  0.63297f,
   0.64156f,  0.65064f,  0.66021f,  0.67029f,  0.68086f,  0.69193f,  0.70349f,
   0.71553f,  0.72802f,  0.74096f,  0.75430f,  0.76801f,  0.78205f,  0.79636f,
   0.81087f,  0.82552f,  0.84023f,  0.85492f,  0.86948f,  0.88382f,  0.89782f,
   0.91139f,  0.92440f,  0.93675f,  0.94831f,  0.95899f,  0.96867f,  0.97724f,
   0.98459f,  0.99063f,  0.99527f,  0.99841f,  1.00000f},
  //---------  1.7 GeV
  {0.00022f,  0.00193f,  0.00532f,  0.01032f,  0.01683f,  0.02474f,  0.03395f,
   0.04433f,  0.05578f,  0.06815f,  0.08133f,  0.09520f,  0.10962f,  0.12446f,
   0.13961f,  0.15494f,  0.17034f,  0.18572f,  0.20096f,  0.21600f,  0.23076f,
   0.24517f,  0.25917f,  0.27272f,  0.28578f,  0.29832f,  0.31033f,  0.32180f,
   0.33271f,  0.34306f,  0.35286f,  0.36212f,  0.37084f,  0.37904f,  0.38673f,
   0.39393f,  0.40066f,  0.40693f,  0.41276f,  0.41818f,  0.42321f,  0.42787f,
   0.43218f,  0.43617f,  0.43985f,  0.44324f,  0.44638f,  0.44928f,  0.45196f,
   0.45445f,  0.45675f,  0.45889f,  0.46089f,  0.46276f,  0.46452f,  0.46617f,
   0.46773f,  0.46922f,  0.47063f,  0.47198f,  0.47327f,  0.47451f,  0.47570f,
   0.47685f,  0.47796f,  0.47904f,  0.48008f,  0.48109f,  0.48208f,  0.48304f,
   0.48398f,  0.48490f,  0.48580f,  0.48668f,  0.48755f,  0.48840f,  0.48925f,
   0.49008f,  0.49091f,  0.49173f,  0.49254f,  0.49335f,  0.49416f,  0.49496f,
   0.49576f,  0.49656f,  0.49735f,  0.49815f,  0.49894f,  0.49973f,  0.50052f,
   0.50131f,  0.50211f,  0.50290f,  0.50370f,  0.50449f,  0.50529f,  0.50609f,
   0.50690f,  0.50771f,  0.50852f,  0.50934f,  0.51017f,  0.51100f,  0.51185f,
   0.51270f,  0.51357f,  0.51446f,  0.51536f,  0.51627f,  0.51721f,  0.51817f,
   0.51916f,  0.52017f,  0.52122f,  0.52229f,  0.52340f,  0.52455f,  0.52575f,
   0.52698f,  0.52827f,  0.52962f,  0.53103f,  0.53252f,  0.53408f,  0.53573f,
   0.53749f,  0.53936f,  0.54136f,  0.54350f,  0.54581f,  0.54829f,  0.55097f,
   0.55387f,  0.55700f,  0.56040f,  0.56408f,  0.56806f,  0.57237f,  0.57703f,
   0.58206f,  0.58748f,  0.59332f,  0.59959f,  0.60631f,  0.61351f,  0.62120f,
   0.62940f,  0.63812f,  0.64737f,  0.65717f,  0.66753f,  0.67844f,  0.68990f,
   0.70191f,  0.71446f,  0.72751f,  0.74106f,  0.75506f,  0.76947f,  0.78423f,
   0.79927f,  0.81452f,  0.82989f,  0.84529f,  0.86062f,  0.87577f,  0.89060f,
   0.90502f,  0.91888f,  0.93207f,  0.94444f,  0.95588f,  0.96627f,  0.97548f,
   0.98339f,  0.98990f,  0.99489f,  0.99828f,  1.00000f},
  //---------  1.8 GeV
  {0.00023f,  0.00207f,  0.00570f,  0.01104f,  0.01800f,  0.02645f,  0.03628f,
   0.04735f,  0.05953f,  0.07268f,  0.08666f,  0.10134f,  0.11657f,  0.13221f,
   0.14812f,  0.16418f,  0.18027f,  0.19626f,  0.21207f,  0.22759f,  0.24274f,
   0.25747f,  0.27172f,  0.28543f,  0.29858f,  0.31114f,  0.32309f,  0.33443f,
   0.34515f,  0.35526f,  0.36477f,  0.37369f,  0.38204f,  0.38984f,  0.39710f,
   0.40386f,  0.41014f,  0.41595f,  0.42133f,  0.42629f,  0.43087f,  0.43509f,
   0.43897f,  0.44254f,  0.44582f,  0.44884f,  0.45161f,  0.45417f,  0.45653f,
   0.45871f,  0.46073f,  0.46261f,  0.46436f,  0.46600f,  0.46755f,  0.46901f,
   0.47039f,  0.47171f,  0.47297f,  0.47418f,  0.47534f,  0.47646f,  0.47755f,
   0.47860f,  0.47961f,  0.48060f,  0.48156f,  0.48250f,  0.48341f,  0.48431f,
   0.48518f,  0.48603f,  0.48687f,  0.48769f,  0.48850f,  0.48929f,  0.49008f,
   0.49086f,  0.49162f,  0.49238f,  0.49314f,  0.49389f,  0.49463f,  0.49537f,
   0.49611f,  0.49684f,  0.49757f,  0.49830f,  0.49903f,  0.49976f,  0.50049f,
   0.50122f,  0.50195f,  0.50268f,  0.50341f,  0.50414f,  0.50488f,  0.50562f,
   0.50637f,  0.50711f,  0.50787f,  0.50863f,  0.50940f,  0.51017f,  0.51096f,
   0.51175f,  0.51256f,  0.51338f,  0.51422f,  0.51507f,  0.51595f,  0.51684f,
   0.51775f,  0.51869f,  0.51965f,  0.52064f,  0.52166f,  0.52270f,  0.52379f,
   0.52491f,  0.52607f,  0.52728f,  0.52854f,  0.52986f,  0.53125f,  0.53270f,
   0.53425f,  0.53589f,  0.53764f,  0.53952f,  0.54154f,  0.54372f,  0.54608f,
   0.54864f,  0.55141f,  0.55443f,  0.55771f,  0.56128f,  0.56516f,  0.56937f,
   0.57395f,  0.57892f,  0.58429f,  0.59011f,  0.59638f,  0.60314f,  0.61040f,
   0.61820f,  0.62655f,  0.63547f,  0.64498f,  0.65509f,  0.66581f,  0.67715f,
   0.68910f,  0.70165f,  0.71480f,  0.72852f,  0.74276f,  0.75749f,  0.77265f,
   0.78817f,  0.80397f,  0.81997f,  0.83605f,  0.85211f,  0.86803f,  0.88367f,
   0.89889f,  0.91357f,  0.92756f,  0.94071f,  0.95289f,  0.96395f,  0.97378f,
   0.98223f,  0.98919f,  0.99453f,  0.99816f,  1.00000f},
  //---------  1.9 GeV
  {0.00025f,  0.00220f,  0.00606f,  0.01174f,  0.01913f,  0.02810f,  0.03852f,
   0.05025f,  0.06314f,  0.07703f,  0.09179f,  0.10724f,  0.12324f,  0.13964f,
   0.15628f,  0.17304f,  0.18976f,  0.20634f,  0.22266f,  0.23863f,  0.25416f,
   0.26918f,  0.28364f,  0.29749f,  0.31069f,  0.32324f,  0.33511f,  0.34630f,
   0.35682f,  0.36668f,  0.37589f,  0.38447f,  0.39245f,  0.39985f,  0.40671f,
   0.41304f,  0.41888f,  0.42426f,  0.42920f,  0.43374f,  0.43790f,  0.44171f,
   0.44519f,  0.44839f,  0.45131f,  0.45398f,  0.45643f,  0.45868f,  0.46075f,
   0.46266f,  0.46443f,  0.46608f,  0.46762f,  0.46906f,  0.47042f,  0.47171f,
   0.47294f,  0.47411f,  0.47524f,  0.47632f,  0.47737f,  0.47839f,  0.47937f,
   0.48033f,  0.48126f,  0.48217f,  0.48306f,  0.48392f,  0.48476f,  0.48559f,
   0.48640f,  0.48719f,  0.48797f,  0.48873f,  0.48948f,  0.49021f,  0.49094f,
   0.49166f,  0.49236f,  0.49306f,  0.49376f,  0.49445f,  0.49513f,  0.49581f,
   0.49648f,  0.49715f,  0.49782f,  0.49848f,  0.49915f,  0.49981f,  0.50047f,
   0.50113f,  0.50180f,  0.50246f,  0.50313f,  0.50380f,  0.50448f,  0.50515f,
   0.50584f,  0.50652f,  0.50722f,  0.50792f,  0.50862f,  0.50934f,  0.51007f,
   0.51080f,  0.51155f,  0.51232f,  0.51309f,  0.51388f,  0.51469f,  0.51552f,
   0.51636f,  0.51723f,  0.51811f,  0.51902f,  0.51995f,  0.52091f,  0.52189f,
   0.52291f,  0.52396f,  0.52504f,  0.52617f,  0.52734f,  0.52857f,  0.52986f,
   0.53122f,  0.53266f,  0.53420f,  0.53585f,  0.53762f,  0.53953f,  0.54160f,
   0.54385f,  0.54630f,  0.54897f,  0.55189f,  0.55508f,  0.55857f,  0.56238f,
   0.56654f,  0.57108f,  0.57602f,  0.58140f,  0.58724f,  0.59357f,  0.60042f,
   0.60783f,  0.61581f,  0.62439f,  0.63360f,  0.64345f,  0.65397f,  0.66516f,
   0.67703f,  0.68957f,  0.70278f,  0.71663f,  0.73109f,  0.74610f,  0.76163f,
   0.77760f,  0.79392f,  0.81049f,  0.82721f,  0.84396f,  0.86061f,  0.87700f,
   0.89301f,  0.90846f,  0.92322f,  0.93711f,  0.95000f,  0.96172f,  0.97214f,
   0.98112f,  0.98851f,  0.99419f,  0.99805f,  1.00000f},
  //---------  2.0 GeV
  {0.00026f,  0.00233f,  0.00641f,  0.01241f,  0.02022f,  0.02969f,  0.04068f,
   0.05304f,  0.06661f,  0.08122f,  0.09672f,  0.11292f,  0.12968f,  0.14681f,
   0.16415f,  0.18156f,  0.19889f,  0.21601f,  0.23282f,  0.24920f,  0.26507f,
   0.28035f,  0.29500f,  0.30896f,  0.32220f,  0.33472f,  0.34649f,  0.35753f,
   0.36784f,  0.37744f,  0.38635f,  0.39460f,  0.40222f,  0.40924f,  0.41570f,
   0.42162f,  0.42705f,  0.43201f,  0.43655f,  0.44069f,  0.44446f,  0.44789f,
   0.45102f,  0.45387f,  0.45646f,  0.45883f,  0.46099f,  0.46297f,  0.46478f,
   0.46646f,  0.46800f,  0.46944f,  0.47079f,  0.47205f,  0.47325f,  0.47439f,
   0.47547f,  0.47651f,  0.47751f,  0.47848f,  0.47942f,  0.48034f,  0.48123f,
   0.48210f,  0.48294f,  0.48377f,  0.48458f,  0.48537f,  0.48614f,  0.48690f,
   0.48764f,  0.48837f,  0.48908f,  0.48978f,  0.49047f,  0.49114f,  0.49181f,
   0.49246f,  0.49311f,  0.49375f,  0.49438f,  0.49501f,  0.49562f,  0.49624f,
   0.49685f,  0.49745f,  0.49806f,  0.49866f,  0.49925f,  0.49985f,  0.50045f,
   0.50104f,  0.50164f,  0.50224f,  0.50284f,  0.50345f,  0.50406f,  0.50467f,
   0.50529f,  0.50592f,  0.50655f,  0.50719f,  0.50783f,  0.50849f,  0.50915f,
   0.50983f,  0.51052f,  0.51122f,  0.51193f,  0.51266f,  0.51340f,  0.51415f,
   0.51493f,  0.51572f,  0.51653f,  0.51735f,  0.51820f,  0.51907f,  0.51996f,
   0.52087f,  0.52182f,  0.52278f,  0.52379f,  0.52483f,  0.52591f,  0.52705f,
   0.52824f,  0.52951f,  0.53085f,  0.53229f,  0.53384f,  0.53551f,  0.53733f,
   0.53931f,  0.54147f,  0.54383f,  0.54643f,  0.54927f,  0.55240f,  0.55584f,
   0.55961f,  0.56375f,  0.56828f,  0.57325f,  0.57867f,  0.58460f,  0.59105f,
   0.59807f,  0.60569f,  0.61394f,  0.62285f,  0.63245f,  0.64276f,  0.65379f,
   0.66556f,  0.67807f,  0.69132f,  0.70528f,  0.71992f,  0.73520f,  0.75107f,
   0.76745f,  0.78425f,  0.80138f,  0.81871f,  0.83611f,  0.85346f,  0.87059f,
   0.88734f,  0.90355f,  0.91904f,  0.93366f,  0.94723f,  0.95958f,  0.97057f,
   0.98004f,  0.98785f,  0.99385f,  0.99793f,  1.00000f},
  //---------  2.2 GeV
  {0.00029f,  0.00256f,  0.00706f,  0.01367f,  0.02225f,  0.03265f,  0.04472f,
   0.05826f,  0.07311f,  0.08907f,  0.10596f,  0.12357f,  0.14172f,  0.16020f,
   0.17885f,  0.19749f,  0.21595f,  0.23409f,  0.25179f,  0.26893f,  0.28541f,
   0.30116f,  0.31613f,  0.33026f,  0.34354f,  0.35596f,  0.36752f,  0.37823f,
   0.38811f,  0.39720f,  0.40553f,  0.41314f,  0.42007f,  0.42637f,  0.43208f,
   0.43725f,  0.44192f,  0.44614f,  0.44994f,  0.45337f,  0.45645f,  0.45923f,
   0.46173f,  0.46399f,  0.46602f,  0.46787f,  0.46954f,  0.47106f,  0.47245f,
   0.47373f,  0.47491f,  0.47600f,  0.47703f,  0.47799f,  0.47890f,  0.47977f,
   0.48061f,  0.48141f,  0.48219f,  0.48295f,  0.48368f,  0.48440f,  0.48511f,
   0.48579f,  0.48647f,  0.48713f,  0.48778f,  0.48841f,  0.48903f,  0.48964f,
   0.49024f,  0.49082f,  0.49139f,  0.49195f,  0.49251f,  0.49305f,  0.49358f,
   0.49410f,  0.49462f,  0.49513f,  0.49563f,  0.49612f,  0.49661f,  0.49710f,
   0.49758f,  0.49806f,  0.49853f,  0.49900f,  0.49947f,  0.49994f,  0.50041f,
   0.50088f,  0.50135f,  0.50182f,  0.50229f,  0.50277f,  0.50325f,  0.50373f,
   0.50422f,  0.50472f,  0.50522f,  0.50573f,  0.50624f,  0.50677f,  0.50730f,
   0.50784f,  0.50839f,  0.50895f,  0.50953f,  0.51011f,  0.51071f,  0.51131f,
   0.51194f,  0.51257f,  0.51322f,  0.51388f,  0.51455f,  0.51524f,  0.51594f,
   0.51666f,  0.51740f,  0.51816f,  0.51894f,  0.51974f,  0.52057f,  0.52144f,
   0.52236f,  0.52332f,  0.52434f,  0.52544f,  0.52662f,  0.52789f,  0.52928f,
   0.53081f,  0.53248f,  0.53432f,  0.53636f,  0.53861f,  0.54112f,  0.54389f,
   0.54698f,  0.55040f,  0.55421f,  0.55842f,  0.56309f,  0.56826f,  0.57398f,
   0.58027f,  0.58720f,  0.59481f,  0.60314f,  0.61223f,  0.62211f,  0.63282f,
   0.64438f,  0.65679f,  0.67007f,  0.68421f,  0.69917f,  0.71493f,  0.73140f,
   0.74853f,  0.76622f,  0.78436f,  0.80282f,  0.82145f,  0.84010f,  0.85858f,
   0.87673f,  0.89434f,  0.91122f,  0.92718f,  0.94203f,  0.95557f,  0.96763f,
   0.97804f,  0.98662f,  0.99323f,  0.99772f,  1.00000f},
  //---------  2.4 GeV
  {0.00031f,  0.00277f,  0.00763f,  0.01476f,  0.02403f,  0.03525f,  0.04826f,
   0.06285f,  0.07882f,  0.09597f,  0.11407f,  0.13291f,  0.15228f,  0.17196f,
   0.19174f,  0.21143f,  0.23086f,  0.24987f,  0.26831f,  0.28606f,  0.30304f,
   0.31915f,  0.33434f,  0.34858f,  0.36184f,  0.37412f,  0.38542f,  0.39579f,
   0.40524f,  0.41382f,  0.42159f,  0.42859f,  0.43487f,  0.44051f,  0.44554f,
   0.45004f,  0.45404f,  0.45761f,  0.46078f,  0.46361f,  0.46612f,  0.46836f,
   0.47036f,  0.47215f,  0.47376f,  0.47521f,  0.47651f,  0.47770f,  0.47878f,
   0.47978f,  0.48070f,  0.48156f,  0.48236f,  0.48311f,  0.48383f,  0.48451f,
   0.48517f,  0.48581f,  0.48642f,  0.48702f,  0.48760f,  0.48816f,  0.48871f,
   0.48925f,  0.48978f,  0.49029f,  0.49079f,  0.49128f,  0.49176f,  0.49223f,
   0.49268f,  0.49313f,  0.49356f,  0.49399f,  0.49440f,  0.49481f,  0.49521f,
   0.49560f,  0.49599f,  0.49637f,  0.49675f,  0.49712f,  0.49749f,  0.49785f,
   0.49821f,  0.49857f,  0.49893f,  0.49928f,  0.49964f,  0.49999f,  0.50034f,
   0.50070f,  0.50105f,  0.50141f,  0.50176f,  0.50212f,  0.50248f,  0.50285f,
   0.50321f,  0.50359f,  0.50396f,  0.50434f,  0.50473f,  0.50512f,  0.50552f,
   0.50593f,  0.50635f,  0.50677f,  0.50721f,  0.50765f,  0.50811f,  0.50857f,
   0.50905f,  0.50954f,  0.51004f,  0.51056f,  0.51108f,  0.51162f,  0.51217f,
   0.51274f,  0.51332f,  0.51391f,  0.51453f,  0.51516f,  0.51582f,  0.51650f,
   0.51722f,  0.51798f,  0.51878f,  0.51963f,  0.52055f,  0.52155f,  0.52263f,
   0.52382f,  0.52513f,  0.52657f,  0.52818f,  0.52997f,  0.53197f,  0.53421f,
   0.53673f,  0.53955f,  0.54272f,  0.54629f,  0.55029f,  0.55479f,  0.55982f,
   0.56546f,  0.57174f,  0.57874f,  0.58650f,  0.59509f,  0.60454f,  0.61490f,
   0.62621f,  0.63848f,  0.65174f,  0.66598f,  0.68116f,  0.69727f,  0.71425f,
   0.73200f,  0.75044f,  0.76945f,  0.78888f,  0.80857f,  0.82835f,  0.84803f,
   0.86740f,  0.88624f,  0.90434f,  0.92149f,  0.93746f,  0.95205f,  0.96506f,
   0.97628f,  0.98555f,  0.99268f,  0.99754f,  1.00000f},
  //---------  2.6 GeV
  {0.00033f,  0.00293f,  0.00806f,  0.01561f,  0.02540f,  0.03726f,  0.05100f,
   0.06641f,  0.08326f,  0.10133f,  0.12039f,  0.14019f,  0.16051f,  0.18110f,
   0.20175f,  0.22224f,  0.24239f,  0.26203f,  0.28100f,  0.29919f,  0.31647f,
   0.33279f,  0.34807f,  0.36229f,  0.37543f,  0.38749f,  0.39849f,  0.40848f,
   0.41749f,  0.42558f,  0.43281f,  0.43924f,  0.44494f,  0.44999f,  0.45443f,
   0.45834f,  0.46178f,  0.46481f,  0.46748f,  0.46982f,  0.47190f,  0.47374f,
   0.47538f,  0.47685f,  0.47817f,  0.47936f,  0.48045f,  0.48145f,  0.48237f,
   0.48322f,  0.48402f,  0.48477f,  0.48548f,  0.48616f,  0.48681f,  0.48743f,
   0.48802f,  0.48860f,  0.48916f,  0.48969f,  0.49021f,  0.49072f,  0.49120f,
   0.49167f,  0.49213f,  0.49257f,  0.49299f,  0.49340f,  0.49379f,  0.49417f,
   0.49454f,  0.49489f,  0.49523f,  0.49556f,  0.49588f,  0.49619f,  0.49649f,
   0.49678f,  0.49707f,  0.49736f,  0.49764f,  0.49791f,  0.49818f,  0.49845f,
   0.49872f,  0.49899f,  0.49925f,  0.49952f,  0.49978f,  0.50005f,  0.50031f,
   0.50058f,  0.50084f,  0.50111f,  0.50137f,  0.50164f,  0.50191f,  0.50218f,
   0.50245f,  0.50273f,  0.50300f,  0.50329f,  0.50358f,  0.50387f,  0.50417f,
   0.50448f,  0.50480f,  0.50513f,  0.50547f,  0.50582f,  0.50619f,  0.50657f,
   0.50696f,  0.50737f,  0.50779f,  0.50823f,  0.50869f,  0.50916f,  0.50964f,
   0.51015f,  0.51067f,  0.51120f,  0.51176f,  0.51234f,  0.51293f,  0.51355f,
   0.51420f,  0.51488f,  0.51559f,  0.51634f,  0.51714f,  0.51799f,  0.51891f,
   0.51991f,  0.52100f,  0.52219f,  0.52351f,  0.52498f,  0.52662f,  0.52846f,
   0.53053f,  0.53288f,  0.53554f,  0.53857f,  0.54201f,  0.54592f,  0.55037f,
   0.55541f,  0.56111f,  0.56754f,  0.57477f,  0.58286f,  0.59187f,  0.60185f,
   0.61286f,  0.62492f,  0.63805f,  0.65227f,  0.66755f,  0.68386f,  0.70115f,
   0.71933f,  0.73830f,  0.75794f,  0.77809f,  0.79859f,  0.81924f,  0.83983f,
   0.86014f,  0.87994f,  0.89900f,  0.91707f,  0.93392f,  0.94933f,  0.96306f,
   0.97493f,  0.98472f,  0.99226f,  0.99740f,  1.00000f},
  //---------  2.8 GeV
  {0.00034f,  0.00303f,  0.00833f,  0.01613f,  0.02625f,  0.03851f,  0.05271f,
   0.06863f,  0.08604f,  0.10471f,  0.12437f,  0.14478f,  0.16569f,  0.18686f,
   0.20804f,  0.22903f,  0.24961f,  0.26960f,  0.28886f,  0.30726f,  0.32467f,
   0.34103f,  0.35628f,  0.37040f,  0.38336f,  0.39518f,  0.40588f,  0.41552f,
   0.42413f,  0.43179f,  0.43857f,  0.44454f,  0.44977f,  0.45435f,  0.45834f,
   0.46181f,  0.46484f,  0.46748f,  0.46978f,  0.47181f,  0.47360f,  0.47519f,
   0.47662f,  0.47791f,  0.47908f,  0.48016f,  0.48117f,  0.48211f,  0.48299f,
   0.48383f,  0.48463f,  0.48540f,  0.48613f,  0.48684f,  0.48753f,  0.48819f,
   0.48883f,  0.48944f,  0.49004f,  0.49061f,  0.49117f,  0.49170f,  0.49221f,
   0.49269f,  0.49316f,  0.49361f,  0.49403f,  0.49443f,  0.49481f,  0.49518f,
   0.49552f,  0.49584f,  0.49615f,  0.49644f,  0.49672f,  0.49698f,  0.49724f,
   0.49748f,  0.49772f,  0.49795f,  0.49817f,  0.49839f,  0.49861f,  0.49882f,
   0.49903f,  0.49924f,  0.49945f,  0.49966f,  0.49987f,  0.50008f,  0.50029f,
   0.50049f,  0.50070f,  0.50091f,  0.50112f,  0.50133f,  0.50154f,  0.50176f,
   0.50197f,  0.50219f,  0.50241f,  0.50264f,  0.50288f,  0.50313f,  0.50338f,
   0.50364f,  0.50392f,  0.50421f,  0.50452f,  0.50485f,  0.50519f,  0.50555f,
   0.50593f,  0.50633f,  0.50676f,  0.50720f,  0.50767f,  0.50816f,  0.50867f,
   0.50920f,  0.50975f,  0.51032f,  0.51092f,  0.51154f,  0.51217f,  0.51283f,
   0.51352f,  0.51423f,  0.51496f,  0.51573f,  0.51653f,  0.51737f,  0.51826f,
   0.51920f,  0.52020f,  0.52128f,  0.52246f,  0.52375f,  0.52517f,  0.52676f,
   0.52855f,  0.53058f,  0.53289f,  0.53552f,  0.53855f,  0.54202f,  0.54601f,
   0.55058f,  0.55582f,  0.56178f,  0.56856f,  0.57622f,  0.58484f,  0.59447f,
   0.60517f,  0.61699f,  0.62995f,  0.64406f,  0.65931f,  0.67567f,  0.69308f,
   0.71147f,  0.73073f,  0.75073f,  0.77131f,  0.79230f,  0.81348f,  0.83465f,
   0.85556f,  0.87597f,  0.89563f,  0.91430f,  0.93171f,  0.94763f,  0.96183f,
   0.97409f,  0.98421f,  0.99201f,  0.99731f,  1.00000f},
  //---------  3.0 GeV
  {0.00034f,  0.00306f,  0.00843f,  0.01631f,  0.02656f,  0.03898f,  0.05337f,
   0.06951f,  0.08717f,  0.10608f,  0.12601f,  0.14669f,  0.16785f,  0.18926f,
   0.21066f,  0.23183f,  0.25256f,  0.27267f,  0.29199f,  0.31041f,  0.32780f,
   0.34409f,  0.35923f,  0.37318f,  0.38595f,  0.39753f,  0.40798f,  0.41733f,
   0.42564f,  0.43299f,  0.43945f,  0.44510f,  0.45003f,  0.45430f,  0.45801f,
   0.46122f,  0.46401f,  0.46643f,  0.46856f,  0.47043f,  0.47209f,  0.47358f,
   0.47494f,  0.47618f,  0.47734f,  0.47842f,  0.47945f,  0.48043f,  0.48137f,
   0.48227f,  0.48315f,  0.48400f,  0.48483f,  0.48563f,  0.48641f,  0.48717f,
   0.48791f,  0.48862f,  0.48930f,  0.48997f,  0.49061f,  0.49122f,  0.49181f,
   0.49237f,  0.49290f,  0.49341f,  0.49389f,  0.49435f,  0.49477f,  0.49518f,
   0.49556f,  0.49591f,  0.49625f,  0.49656f,  0.49686f,  0.49713f,  0.49740f,
   0.49764f,  0.49788f,  0.49811f,  0.49832f,  0.49854f,  0.49874f,  0.49894f,
   0.49914f,  0.49933f,  0.49953f,  0.49972f,  0.49991f,  0.50010f,  0.50029f,
   0.50048f,  0.50067f,  0.50086f,  0.50106f,  0.50125f,  0.50145f,  0.50165f,
   0.50186f,  0.50207f,  0.50229f,  0.50251f,  0.50275f,  0.50300f,  0.50326f,
   0.50354f,  0.50383f,  0.50414f,  0.50448f,  0.50483f,  0.50521f,  0.50562f,
   0.50605f,  0.50650f,  0.50698f,  0.50749f,  0.50802f,  0.50858f,  0.50917f,
   0.50978f,  0.51042f,  0.51109f,  0.51177f,  0.51249f,  0.51322f,  0.51398f,
   0.51476f,  0.51556f,  0.51639f,  0.51724f,  0.51812f,  0.51902f,  0.51996f,
   0.52094f,  0.52197f,  0.52305f,  0.52421f,  0.52545f,  0.52681f,  0.52830f,
   0.52996f,  0.53183f,  0.53396f,  0.53638f,  0.53917f,  0.54238f,  0.54609f,
   0.55036f,  0.55528f,  0.56093f,  0.56739f,  0.57474f,  0.58306f,  0.59240f,
   0.60285f,  0.61443f,  0.62720f,  0.64115f,  0.65628f,  0.67257f,  0.68996f,
   0.70837f,  0.72769f,  0.74780f,  0.76852f,  0.78969f,  0.81109f,  0.83250f,
   0.85366f,  0.87434f,  0.89426f,  0.91318f,  0.93083f,  0.94697f,  0.96136f,
   0.97378f,  0.98403f,  0.99191f,  0.99728f,  1.00000f},
  //---------  3.4 GeV
  {0.00032f,  0.00286f,  0.00789f,  0.01528f,  0.02491f,  0.03660f,  0.05017f,
   0.06540f,  0.08209f,  0.09999f,  0.11884f,  0.13841f,  0.15844f,  0.17869f,
   0.19893f,  0.21893f,  0.23851f,  0.25748f,  0.27569f,  0.29302f,  0.30936f,
   0.32465f,  0.33885f,  0.35192f,  0.36386f,  0.37470f,  0.38447f,  0.39322f,
   0.40101f,  0.40792f,  0.41402f,  0.41939f,  0.42412f,  0.42828f,  0.43194f,
   0.43518f,  0.43807f,  0.44066f,  0.44302f,  0.44517f,  0.44717f,  0.44904f,
   0.45082f,  0.45252f,  0.45417f,  0.45576f,  0.45732f,  0.45885f,  0.46035f,
   0.46183f,  0.46328f,  0.46472f,  0.46613f,  0.46752f,  0.46889f,  0.47024f,
   0.47156f,  0.47285f,  0.47413f,  0.47537f,  0.47660f,  0.47779f,  0.47896f,
   0.48010f,  0.48121f,  0.48228f,  0.48333f,  0.48435f,  0.48533f,  0.48628f,
   0.48720f,  0.48809f,  0.48894f,  0.48976f,  0.49055f,  0.49131f,  0.49204f,
   0.49275f,  0.49343f,  0.49409f,  0.49473f,  0.49535f,  0.49595f,  0.49654f,
   0.49712f,  0.49769f,  0.49825f,  0.49880f,  0.49935f,  0.49990f,  0.50045f,
   0.50100f,  0.50155f,  0.50210f,  0.50266f,  0.50323f,  0.50381f,  0.50440f,
   0.50500f,  0.50562f,  0.50626f,  0.50692f,  0.50760f,  0.50831f,  0.50904f,
   0.50980f,  0.51059f,  0.51141f,  0.51226f,  0.51315f,  0.51407f,  0.51502f,
   0.51600f,  0.51702f,  0.51807f,  0.51915f,  0.52026f,  0.52139f,  0.52256f,
   0.52376f,  0.52498f,  0.52622f,  0.52750f,  0.52879f,  0.53012f,  0.53146f,
   0.53283f,  0.53422f,  0.53563f,  0.53707f,  0.53852f,  0.54000f,  0.54150f,
   0.54303f,  0.54459f,  0.54619f,  0.54783f,  0.54953f,  0.55131f,  0.55318f,
   0.55518f,  0.55733f,  0.55968f,  0.56228f,  0.56516f,  0.56841f,  0.57207f,
   0.57623f,  0.58095f,  0.58632f,  0.59242f,  0.59933f,  0.60712f,  0.61587f,
   0.62564f,  0.63648f,  0.64842f,  0.66149f,  0.67569f,  0.69098f,  0.70732f,
   0.72465f,  0.74286f,  0.76183f,  0.78140f,  0.80140f,  0.82163f,  0.84188f,
   0.86191f,  0.88148f,  0.90034f,  0.91823f,  0.93492f,  0.95016f,  0.96372f,
   0.97541f,  0.98504f,  0.99243f,  0.99746f,  1.00000f},
  //---------  3.8 GeV
  {0.00028f,  0.00255f,  0.00702f,  0.01360f,  0.02217f,  0.03257f,  0.04464f,
   0.05819f,  0.07303f,  0.08892f,  0.10565f,  0.12298f,  0.14070f,  0.15857f,
   0.17639f,  0.19396f,  0.21111f,  0.22768f,  0.24354f,  0.25858f,  0.27272f,
   0.28590f,  0.29809f,  0.30927f,  0.31945f,  0.32865f,  0.33692f,  0.34432f,
   0.35090f,  0.35674f,  0.36192f,  0.36650f,  0.37057f,  0.37420f,  0.37746f,
   0.38041f,  0.38312f,  0.38564f,  0.38801f,  0.39028f,  0.39246f,  0.39460f,
   0.39671f,  0.39880f,  0.40089f,  0.40298f,  0.40507f,  0.40718f,  0.40929f,
   0.41141f,  0.41355f,  0.41569f,  0.41783f,  0.41998f,  0.42213f,  0.42429f,
   0.42644f,  0.42860f,  0.43077f,  0.43293f,  0.43509f,  0.43726f,  0.43943f,
   0.44160f,  0.44377f,  0.44594f,  0.44811f,  0.45028f,  0.45245f,  0.45462f,
   0.45679f,  0.45895f,  0.46112f,  0.46329f,  0.46547f,  0.46764f,  0.46983f,
   0.47201f,  0.47421f,  0.47642f,  0.47863f,  0.48086f,  0.48310f,  0.48534f,
   0.48760f,  0.48987f,  0.49215f,  0.49444f,  0.49673f,  0.49902f,  0.50132f,
   0.50361f,  0.50590f,  0.50819f,  0.51047f,  0.51274f,  0.51499f,  0.51724f,
   0.51948f,  0.52171f,  0.52392f,  0.52613f,  0.52832f,  0.53051f,  0.53270f,
   0.53487f,  0.53705f,  0.53922f,  0.54139f,  0.54355f,  0.54572f,  0.54789f,
   0.55006f,  0.55223f,  0.55440f,  0.55657f,  0.55874f,  0.56091f,  0.56308f,
   0.56525f,  0.56741f,  0.56957f,  0.57174f,  0.57390f,  0.57605f,  0.57821f,
   0.58036f,  0.58251f,  0.58465f,  0.58679f,  0.58893f,  0.59105f,  0.59316f,
   0.59527f,  0.59736f,  0.59945f,  0.60154f,  0.60363f,  0.60574f,  0.60787f,
   0.61006f,  0.61233f,  0.61470f,  0.61722f,  0.61993f,  0.62288f,  0.62614f,
   0.62977f,  0.63384f,  0.63842f,  0.64359f,  0.64943f,  0.65601f,  0.66341f,
   0.67168f,  0.68088f,  0.69106f,  0.70223f,  0.71442f,  0.72759f,  0.74173f,
   0.75677f,  0.77262f,  0.78919f,  0.80634f,  0.82391f,  0.84172f,  0.85959f,
   0.87730f,  0.89464f,  0.91137f,  0.92726f,  0.94209f,  0.95564f,  0.96772f,
   0.97812f,  0.98669f,  0.99327f,  0.99774f,  1.00000f},
  //---------  4.2 GeV
  {0.00029f,  0.00260f,  0.00715f,  0.01383f,  0.02251f,  0.03304f,  0.04523f,
   0.05889f,  0.07382f,  0.08978f,  0.10655f,  0.12388f,  0.14156f,  0.15935f,
   0.17704f,  0.19443f,  0.21134f,  0.22763f,  0.24315f,  0.25779f,  0.27148f,
   0.28416f,  0.29581f,  0.30640f,  0.31596f,  0.32453f,  0.33214f,  0.33885f,
   0.34475f,  0.34990f,  0.35439f,  0.35830f,  0.36171f,  0.36471f,  0.36737f,
   0.36975f,  0.37193f,  0.37395f,  0.37587f,  0.37772f,  0.37954f,  0.38135f,
   0.38318f,  0.38503f,  0.38691f,  0.38884f,  0.39081f,  0.39283f,  0.39489f,
   0.39698f,  0.39911f,  0.40127f,  0.40345f,  0.40565f,  0.40787f,  0.41011f,
   0.41235f,  0.41460f,  0.41686f,  0.41912f,  0.42138f,  0.42365f,  0.42591f,
   0.42818f,  0.43045f,  0.43272f,  0.43501f,  0.43730f,  0.43960f,  0.44192f,
   0.44427f,  0.44664f,  0.44905f,  0.45149f,  0.45398f,  0.45652f,  0.45912f,
   0.46178f,  0.46450f,  0.46729f,  0.47016f,  0.47309f,  0.47608f,  0.47915f,
   0.48227f,  0.48544f,  0.48867f,  0.49193f,  0.49521f,  0.49851f,  0.50182f,
   0.50513f,  0.50841f,  0.51167f,  0.51489f,  0.51807f,  0.52119f,  0.52425f,
   0.52725f,  0.53018f,  0.53304f,  0.53583f,  0.53856f,  0.54122f,  0.54382f,
   0.54636f,  0.54885f,  0.55129f,  0.55370f,  0.55607f,  0.55842f,  0.56074f,
   0.56304f,  0.56533f,  0.56762f,  0.56989f,  0.57216f,  0.57443f,  0.57669f,
   0.57896f,  0.58122f,  0.58348f,  0.58574f,  0.58799f,  0.59023f,  0.59247f,
   0.59469f,  0.59689f,  0.59907f,  0.60123f,  0.60336f,  0.60545f,  0.60751f,
   0.60953f,  0.61150f,  0.61343f,  0.61531f,  0.61716f,  0.61899f,  0.62080f,
   0.62262f,  0.62447f,  0.62639f,  0.62841f,  0.63059f,  0.63297f,  0.63563f,
   0.63863f,  0.64204f,  0.64595f,  0.65044f,  0.65559f,  0.66148f,  0.66820f,
   0.67580f,  0.68436f,  0.69393f,  0.70452f,  0.71616f,  0.72884f,  0.74253f,
   0.75717f,  0.77268f,  0.78896f,  0.80587f,  0.82326f,  0.84095f,  0.85874f,
   0.87641f,  0.89375f,  0.91052f,  0.92648f,  0.94140f,  0.95506f,  0.96725f,
   0.97778f,  0.98646f,  0.99315f,  0.99769f,  1.00000f},
  //---------  4.6 GeV
  {0.00029f,  0.00262f,  0.00720f,  0.01392f,  0.02265f,  0.03322f,  0.04546f,
   0.05917f,  0.07414f,  0.09015f,  0.10696f,  0.12434f,  0.14205f,  0.15987f,
   0.17759f,  0.19500f,  0.21192f,  0.22821f,  0.24372f,  0.25835f,  0.27202f,
   0.28466f,  0.29626f,  0.30680f,  0.31630f,  0.32478f,  0.33230f,  0.33892f,
   0.34470f,  0.34973f,  0.35408f,  0.35785f,  0.36112f,  0.36397f,  0.36647f,
   0.36869f,  0.37071f,  0.37258f,  0.37435f,  0.37606f,  0.37775f,  0.37945f,
   0.38117f,  0.38294f,  0.38476f,  0.38665f,  0.38860f,  0.39062f,  0.39271f,
   0.39486f,  0.39707f,  0.39933f,  0.40164f,  0.40399f,  0.40637f,  0.40878f,
   0.41121f,  0.41366f,  0.41611f,  0.41856f,  0.42100f,  0.42344f,  0.42586f,
   0.42827f,  0.43065f,  0.43302f,  0.43537f,  0.43771f,  0.44003f,  0.44235f,
   0.44467f,  0.44700f,  0.44935f,  0.45172f,  0.45413f,  0.45658f,  0.45909f,
   0.46167f,  0.46432f,  0.46705f,  0.46986f,  0.47275f,  0.47573f,  0.47879f,
   0.48193f,  0.48514f,  0.48841f,  0.49173f,  0.49508f,  0.49846f,  0.50184f,
   0.50522f,  0.50857f,  0.51189f,  0.51516f,  0.51837f,  0.52151f,  0.52457f,
   0.52755f,  0.53045f,  0.53326f,  0.53599f,  0.53864f,  0.54121f,  0.54372f,
   0.54618f,  0.54859f,  0.55096f,  0.55331f,  0.55563f,  0.55795f,  0.56027f,
   0.56260f,  0.56493f,  0.56728f,  0.56965f,  0.57204f,  0.57444f,  0.57687f,
   0.57930f,  0.58175f,  0.58420f,  0.58665f,  0.58909f,  0.59152f,  0.59393f,
   0.59631f,  0.59866f,  0.60097f,  0.60324f,  0.60544f,  0.60760f,  0.60968f,
   0.61170f,  0.61366f,  0.61555f,  0.61737f,  0.61914f,  0.62086f,  0.62255f,
   0.62424f,  0.62595f,  0.62772f,  0.62959f,  0.63161f,  0.63384f,  0.63634f,
   0.63918f,  0.64245f,  0.64622f,  0.65058f,  0.65561f,  0.66139f,  0.66800f,
   0.67552f,  0.68400f,  0.69350f,  0.70404f,  0.71564f,  0.72828f,  0.74195f,
   0.75658f,  0.77209f,  0.78837f,  0.80530f,  0.82271f,  0.84042f,  0.85824f,
   0.87596f,  0.89334f,  0.91015f,  0.92615f,  0.94112f,  0.95484f,  0.96707f,
   0.97765f,  0.98637f,  0.99310f,  0.99768f,  1.00000f},
  //---------  5.0 GeV
  {0.00029f,  0.00261f,  0.00718f,  0.01388f,  0.02258f,  0.03311f,  0.04530f,
   0.05895f,  0.07385f,  0.08979f,  0.10652f,  0.12382f,  0.14145f,  0.15918f,
   0.17680f,  0.19413f,  0.21097f,  0.22717f,  0.24260f,  0.25715f,  0.27074f,
   0.28332f,  0.29485f,  0.30532f,  0.31476f,  0.32318f,  0.33064f,  0.33720f,
   0.34292f,  0.34789f,  0.35218f,  0.35589f,  0.35909f,  0.36187f,  0.36429f,
   0.36645f,  0.36839f,  0.37018f,  0.37187f,  0.37351f,  0.37512f,  0.37675f,
   0.37842f,  0.38015f,  0.38194f,  0.38381f,  0.38577f,  0.38782f,  0.38996f,
   0.39218f,  0.39449f,  0.39687f,  0.39933f,  0.40185f,  0.40442f,  0.40704f,
   0.40970f,  0.41237f,  0.41507f,  0.41776f,  0.42045f,  0.42312f,  0.42577f,
   0.42839f,  0.43097f,  0.43351f,  0.43600f,  0.43846f,  0.44087f,  0.44325f,
   0.44561f,  0.44795f,  0.45028f,  0.45261f,  0.45497f,  0.45736f,  0.45979f,
   0.46229f,  0.46485f,  0.46749f,  0.47022f,  0.47304f,  0.47595f,  0.47896f,
   0.48205f,  0.48522f,  0.48846f,  0.49176f,  0.49510f,  0.49847f,  0.50184f,
   0.50521f,  0.50854f,  0.51184f,  0.51508f,  0.51825f,  0.52135f,  0.52435f,
   0.52726f,  0.53008f,  0.53281f,  0.53546f,  0.53802f,  0.54051f,  0.54295f,
   0.54534f,  0.54769f,  0.55003f,  0.55236f,  0.55470f,  0.55705f,  0.55943f,
   0.56185f,  0.56430f,  0.56680f,  0.56934f,  0.57192f,  0.57454f,  0.57718f,
   0.57986f,  0.58254f,  0.58524f,  0.58793f,  0.59061f,  0.59326f,  0.59588f,
   0.59845f,  0.60097f,  0.60343f,  0.60582f,  0.60812f,  0.61035f,  0.61248f,
   0.61453f,  0.61649f,  0.61836f,  0.62016f,  0.62188f,  0.62355f,  0.62518f,
   0.62680f,  0.62843f,  0.63012f,  0.63191f,  0.63386f,  0.63601f,  0.63844f,
   0.64121f,  0.64441f,  0.64812f,  0.65241f,  0.65738f,  0.66310f,  0.66966f,
   0.67712f,  0.68554f,  0.69497f,  0.70545f,  0.71698f,  0.72955f,  0.74315f,
   0.75770f,  0.77313f,  0.78933f,  0.80617f,  0.82349f,  0.84112f,  0.85885f,
   0.87648f,  0.89378f,  0.91051f,  0.92644f,  0.94135f,  0.95500f,  0.96718f,
   0.97772f,  0.98641f,  0.99311f,  0.99768f,  1.00000f}
 };


