/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.util;

import net.wimpi.modbus.util.ModbusUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitVector {
    private static final Logger logger = LoggerFactory.getLogger(BitVector.class);
    private int m_Size;
    private byte[] m_Data;
    private boolean m_MSBAccess = false;
    private static final int[] ODD_OFFSETS = new int[]{-1, -3, -5, -7};
    private static final int[] STRAIGHT_OFFSETS = new int[]{7, 5, 3, 1};

    public BitVector(int size) {
        this.m_Size = size;
        size = size % 8 > 0 ? size / 8 + 1 : (size /= 8);
        this.m_Data = new byte[size];
    }

    public void toggleAccess(boolean b) {
        this.m_MSBAccess = !this.m_MSBAccess;
    }

    public boolean isLSBAccess() {
        return !this.m_MSBAccess;
    }

    public boolean isMSBAccess() {
        return this.m_MSBAccess;
    }

    public final byte[] getBytes() {
        return this.m_Data;
    }

    public final void setBytes(byte[] data) {
        System.arraycopy(data, 0, this.m_Data, 0, data.length);
    }

    public final void setBytes(byte[] data, int size) {
        System.arraycopy(data, 0, this.m_Data, 0, data.length);
        this.m_Size = size;
    }

    public final boolean getBit(int index) throws IndexOutOfBoundsException {
        index = this.translateIndex(index);
        logger.trace("Get bit #{}", (Object)index);
        return (this.m_Data[this.byteIndex(index)] & 1 << this.bitIndex(index)) != 0;
    }

    public final void setBit(int index, boolean b) throws IndexOutOfBoundsException {
        index = this.translateIndex(index);
        logger.trace("Set bit #{}", (Object)index);
        int value = b ? 1 : 0;
        int byteNum = this.byteIndex(index);
        int bitNum = this.bitIndex(index);
        this.m_Data[byteNum] = (byte)(this.m_Data[byteNum] & ~(1 << bitNum) | (value & 1) << bitNum);
    }

    public final int size() {
        return this.m_Size;
    }

    public final void forceSize(int size) {
        if (size > this.m_Data.length * 8) {
            throw new IllegalArgumentException("Size exceeds byte[] store.");
        }
        this.m_Size = size;
    }

    public final int byteSize() {
        return this.m_Data.length;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            int idx = BitVector.doTranslateIndex(i);
            sbuf.append((this.m_Data[this.byteIndex(idx)] & 1 << this.bitIndex(idx)) != 0 ? (char)'1' : '0');
            if ((i + 1) % 8 != 0) continue;
            sbuf.append(" ");
        }
        return sbuf.toString();
    }

    private final int byteIndex(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_Data.length * 8) {
            throw new IndexOutOfBoundsException();
        }
        return index / 8;
    }

    private final int bitIndex(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_Data.length * 8) {
            throw new IndexOutOfBoundsException();
        }
        return index % 8;
    }

    private final int translateIndex(int idx) {
        if (this.m_MSBAccess) {
            int mod4 = idx % 4;
            int div4 = idx / 4;
            if (div4 % 2 != 0) {
                return idx + ODD_OFFSETS[mod4];
            }
            return idx + STRAIGHT_OFFSETS[mod4];
        }
        return idx;
    }

    private static final int doTranslateIndex(int idx) {
        int mod4 = idx % 4;
        int div4 = idx / 4;
        if (div4 % 2 != 0) {
            return idx + ODD_OFFSETS[mod4];
        }
        return idx + STRAIGHT_OFFSETS[mod4];
    }

    public static BitVector createBitVector(byte[] data, int size) {
        BitVector bv = new BitVector(data.length * 8);
        bv.setBytes(data);
        bv.m_Size = size;
        return bv;
    }

    public static BitVector createBitVector(byte[] data) {
        BitVector bv = new BitVector(data.length * 8);
        bv.setBytes(data);
        return bv;
    }

    public static void main(String[] args) {
        BitVector test = new BitVector(24);
        System.out.println(test.isLSBAccess());
        test.setBit(7, true);
        System.out.println(test.getBit(7));
        test.toggleAccess(true);
        System.out.println(test.getBit(7));
        test.toggleAccess(true);
        test.setBit(6, true);
        test.setBit(3, true);
        test.setBit(2, true);
        test.setBit(0, true);
        test.setBit(8, true);
        test.setBit(10, true);
        System.out.println(test);
        test.toggleAccess(true);
        System.out.println(test);
        test.toggleAccess(true);
        System.out.println(test);
        System.out.println(ModbusUtil.toHex(test.getBytes()));
    }
}

